local BS = LibStub("LibBabble-Spell-3.0"):GetLookupTable()

local channels = {"yell", "raidWarning", "raid", "party", "print", "channel"}

local f = CreateFrame("frame")

f:RegisterEvent("UNIT_SPELLCAST_SENT")
f:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED")

f:SetScript("OnEvent", function(self, event, unit, spell, _, player)
	if unit == "player" and spell == BS["Misdirection"] then
		if event == "UNIT_SPELLCAST_SENT" then
			self.player = player
		elseif event == "UNIT_SPELLCAST_SUCCEEDED" then
			ZMisdirect_Announce(self.player)
		end

	end
end)

function ZMisdirect_Announce(player)
	if not player then return end
	local tbl = ZHunterMod_Saved.ZMisdirect
	local message = tbl.format:gsub("$player", player)
	local channelNum = tbl.channelNum
	for i, v in ipairs(channels) do
		if tbl[v] or (tbl[v] == nil and IsInInstance()) then
			ZHunter[v](message, channelNum)
		end
	end
end

ZHunterModOptions.args.misdirect = {
	type = "group",
	name = "Перенаправление",
	desc = "Опции настроек сообщений о Перенаправлении.",
	order = 6,
	args = {
		description = {
			type = "description",
			name = "Отмеченое серым, используется только для оповещения когда вы находитесь в инстансах.",
			order = 1
		},
		format = {
			type = "input",
			name = "Формат сообщения",
			desc = "Установка формата оповещающего сообщения. Используйте '$player' чтобы сообщить имя персонажа в оповещении.",
			order = 2,
			get = function(info) return ZHunterMod_Saved.ZMisdirect.format end,
			set = function(info, v) ZHunterMod_Saved.ZMisdirect.format = v end
		}
	}
}

ZHunterModOptions_SetBroadcastOptions("ZMisdirect", ZHunterModOptions.args.misdirect.args)