local failure = "|cffff2020неудалось|r рассеять %s's |cff20ff20%s|r!"
local desiredSpells = {}
local channels = {"yell", "raidWarning", "raid", "party", "channel"}

function ZArcaneDispelParse(spells)
	if not spells then return end
	for i in pairs(desiredSpells) do
		desiredSpells[i] = nil
	end
	for i, v in pairs({strsplit("\n", spells)}) do
		desiredSpells[v] = true
	end
end

function ZArcaneDispel(destName, extraSpellName, failed)
	-- Grab a local copy of the options
	local tbl = ZHunterMod_Saved["ZArcaneDispel"]
	-- Setup and broadcast the message
	if not failed then
		local message = tbl.format or ">$spell< рассеяно с $player"
		local newmessage
		newmessage = message:gsub("$player", destName)
		newmessage = newmessage:gsub("$spell", extraSpellName)
		local channelNum = tbl.channelNum
		for i, v in ipairs(channels) do
			if tbl[v] or (tbl[v] == nil and desiredSpells[extraSpellName]) then
				ZHunter[v](newmessage, channelNum)
			end
		end
		if tbl.print or (tbl.print == nil and desiredSpells[extraSpellName]) then
			newmessage = message:gsub("$player", destName)
			newmessage = newmessage:gsub("$spell", "|cFF20FF20"..extraSpellName.."|r")
			ZHunter.print(newmessage)
		end
	elseif tbl.print or (tbl.print == nil and desiredSpells[extraSpellName]) then
		ZHunter.print(failure:format(destName, extraSpellName))
	end
end

ZHunterModOptions.args.arcanedispel = {
	type = "group",
	name = "Рассеивание",
	desc = "Опции настроек сообщений о Рассеивании от Чародейских выстрелов.",
	order = 7,
	args = {
		description = {
			type = "description",
			name = "Отмеченое серым используется только для оповещения заклинаний находящихся в списке ниже.",
			order = 1
		},
		format = {
			type = "input",
			name = "Сообщение",
			desc = "Изменение формата оповещающего сообщения. Используй '$spell' и '$player' для вывода заклинания и игрока с которого было оно рассеяно.",
			order = 2,
			get = function(info) return ZHunterMod_Saved["ZArcaneDispel"]["format"] end,
			set = function(info, v) ZHunterMod_Saved["ZArcaneDispel"]["format"] = v end
		},
		condition = {
			type = "input",
			name = "Заклинания для оповещения",
			desc = "Список заклинаний о которых будет сообщаться при их рассеивании (с учетом регистра).",
			multiline = true,
			order = 20,
			get = function(info) return ZHunterMod_Saved["ZArcaneDispel"]["condition"] end,
			set = function(info, v)
				ZHunterMod_Saved["ZArcaneDispel"]["condition"] = v
				ZArcaneDispelParse(v)
			end
		}
	}
}

ZHunterModOptions_SetBroadcastOptions("ZArcaneDispel", ZHunterModOptions.args.arcanedispel.args)