local vertical = {TOP="Вверх", BOTTOM="Вниз"}
local horizontal = {LEFT="Влево", RIGHT="Вправо"}
local mouseEvents = {OnRightClick="При Правом-Клике", OnMouseOver="При наводе мыши", Always="Всегда показывать"}

ZHunterModOptions = {
	type = "group",
	args = {
		autoshot = {
			type = "group",
			name = "Авто выстрел",
			desc = "Опции для настройки полосы авто выстрела.",
			order = 1,
			args = {
				use = {
					type = "toggle",
					name = "Вкл/Выкл",
					desc = "Вкл/Выкл отображение полосы авто выстрела.",
					get = function(info) return ZHunterMod_Saved.ZAutoShot.on end,
					set = function(info, v) ZHunterMod_Saved.ZAutoShot.on = v end
				}
			}
		},
		other = {
			type = "group",
			name = "Другие возможности",
			desc = "Включить/выключить другие доступные возможности.",
			order = 9,
			args = {
				autostrip = {
					type = "toggle",
					name = "Авто-раздевание",
					desc = "Вкл/Выкл отображение кнопки Авто-раздевания.",
					get = function(info) return ZHunterMod_Saved["ZAutoStrip"]["on"] end,
					set = function(info, v)
						ZHunterMod_Saved["ZAutoStrip"]["on"] = v
						if v then
							ZAutoStrip:Show()
						else
							ZAutoStrip:Hide()
						end
					end
				},
				antidaze = {
					type = "toggle",
					name = "Анти Головокружение",
					desc = "Вкл/Выкл снятие Духа при атаке.",
					get = function(info) return ZHunterMod_Saved["ZAntiDaze"]["on"] end,
					set = function(info, v) ZHunterMod_Saved["ZAntiDaze"]["on"] = v end
				}
			}
		}
	}
}
--/script SetBinding("J", "CLICK ZPet:LeftButton")
--/script local a,b,c=GetBindingAction("CLICK ZPet:LeftButton") Print(a) Print(b) Print(c)
--/script local a,b,c=GetBindingKey("CLICK ZPet:LeftButton") Print(a) Print(b) Print(c)

local function removeBindings(action)

end

do
--[[
	local buttons = {"ZAspect", "ZTrack", "ZTrap", "ZPet"}
	for i = 1, 4 do
		ZHunterModOptions.args[buttons[i].."Binds"] = {
			type = "group",
			name = buttons[i].." Bindings",
			desc = "Set keybindings to " .. buttons[i] .. " buttons.",
			order = 9 + i,
			args = {}
		}
		local tbl = ZHunterModOptions.args[buttons[i].."Binds"]
		for j = 1, 12 do
			local button = buttons[i] .. (j == 1 and "" or j)
			tbl.args["button"..j] = {
				type = "keybinding",
				order = j,
				name = buttons[i] .. " Button " .. j,
				desc = "Set the key binding for " .. buttons[i] .. ".",
				get = function(info)
					local key = GetBindingKey("CLICK " .. button .. ":LeftButton")
					return key
				end,
				set = function(info, v)
					SetBinding(v, "CLICK " .. button .. ":LeftButton")
					SaveBindings(GetCurrentBindingSet());
				end
			}
		end
	end
]]
end

LibStub("AceConfig-3.0"):RegisterOptionsTable("ZHunterMod", ZHunterModOptions)

function ZHunterModOptions_SetSpellOptions(name, tbl, spells)
	tbl.enable = {
		type = "toggle",
		name = "Включить", desc = "Вкл/Выкл использование кнопок.",
		order = 1,
		get = function(info) return ZHunterMod_Saved[name].enabled end,
		set = function(info, v)
			ZHunterMod_Saved[name].enabled = v
			local frame = getglobal(name)
			if v then
				frame:SetCount(ZHunterMod_Saved[name].count)
				frame:Show()
			else
				frame:SetCount(0)
				frame:Hide()
			end
		end
	}
	tbl.size = {
		type = "range", min = 20, max = 50, step = 1,
		name = "Размер кнопок", desc = "Изменение размера кнопок заклинаний.",
		order = 2,
		get = function(info) return ZHunterMod_Saved[name].size end,
		set = function(info, v)
			ZHunterMod_Saved[name].size = v
			getglobal(name):SetSize(v)
		end
	}
	tbl.roundButton = {
		type = "toggle",
		name = "Округленные кнопки", desc = "Делает края кнопок округленными.",
		order = 3,
		get = function(info) return ZHunterMod_Saved[name].roundButton end,
		set = function(info, v)
			ZHunterMod_Saved[name].roundButton = v
			getglobal(name):SetRoundButton(v)
		end
	}
	tbl.bgColor = {
		type = "color", hasAlpha = false,
		name = "Цвет края", desc = "Установка цвета края кнопок.",
		order = 4,
		get = function(info) return ZHunterMod_Saved[name].bgColor.r, ZHunterMod_Saved[name].bgColor.g, ZHunterMod_Saved[name].bgColor.b end,
		set = function(info, r, g, b)
			ZHunterMod_Saved[name].bgColor.r = r
			ZHunterMod_Saved[name].bgColor.g = g
			ZHunterMod_Saved[name].bgColor.b = b
			getglobal(name):SetBackgroundColor(ZHunterMod_Saved[name].bgColor)
		end
	}
	tbl.count = {
		type = "range", min = 0, max = #spells + 1, step = 1,
		name = "Число кнопок", desc = "Назначение числа кнопок которые будут отображаться на панеле.",
		order = 5,
		get = function(info) return ZHunterMod_Saved[name].count end,
		set = function(info, v)
			ZHunterMod_Saved[name].count = v
			getglobal(name):SetCount(v)
		end
	}
	tbl.perRow = {
		type = "range", min = 1, max = #spells + 1, step = 1,
		name = "Кнопок в ряду", desc = "Назначение числа рядов в которых будет отображаться кнопки на панеле.",
		order = 6,
		get = function(info) return ZHunterMod_Saved[name].perRow end,
		set = function(info, v)
			ZHunterMod_Saved[name].perRow = v
			getglobal(name):SetPerRow(v)
		end
	}
	tbl.horizontal = {
		type = "select", style = "dropdown", values = horizontal,
		name = "Направление колонок", desc = "Назначте в какую сторону будут раскрываться колонки в право или в лево друг от друга..",
		order = 7,
		get = function(info) return ZHunterMod_Saved[name].horizontal end,
		set = function(info, v)
			ZHunterMod_Saved[name].horizontal = v
			getglobal(name):SetHorizontal(v)
		end
	}
	tbl.vertical = {
		type = "select", style = "dropdown", values = vertical,
		name = "Направление рядов", desc = "Назначте в каком напровлении будут раскрываться ряды в вверх или вниз.",
		order = 8,
		get = function(info) return ZHunterMod_Saved[name].vertical end,
		set = function(info, v)
			ZHunterMod_Saved[name].vertical = v
			getglobal(name):SetVertical(v)
		end
	}
	tbl.expandType = {
		type = "select", style = "dropdown", values = mouseEvents,
		name = "Тип раскрывания", desc = "Установка события при котором будут всплывать кнопки заклинаний.",
		order = 9,
		get = function(info) return ZHunterMod_Saved[name].expandType end,
		set = function(info, v)
			ZHunterMod_Saved[name].expandType = v
			getglobal(name):SetExpandType(v)
		end
	}
	for i = 1, #spells do
		tbl["button"..i] = {
			type = "select", style = "dropdown", values = spells,
			name = "Кнопка "..i, desc = "Выберите какое зклинание использовать для данной кнопки.",
			order = 25 + i,
			get = function(info) return ZHunterMod_Saved[name].order[i] end,
			set = function(info, v)
				ZHunterMod_Saved[name].order[i] = v
				getglobal(name):UpdateSpells()
			end
		}
	end
end

function ZHunterModOptions_SetBroadcastOptions(name, tbl)
	tbl.print = {
		type = "toggle", tristate = true,
		name = "Для себя", desc = "Будет посылать сообщения в канал по умолчанию, только вы сможете их видеть.",
		order = 10,
		get = function(info) return ZHunterMod_Saved[name].print end,
		set = function(info, v) ZHunterMod_Saved[name].print = v end
	}
	tbl.yell = {
		type = "toggle", tristate = true,
		name = "Крик", desc = "Будет выкрикивать сообщения.",
		order = 11,
		get = function(info) return ZHunterMod_Saved[name].yell end,
		set = function(info, v) ZHunterMod_Saved[name].yell = v end
	}
	tbl.party = {
		type = "toggle", tristate = true,
		name = "Группа", desc = "Будет посылать сообщения в групповой чат.",
		order = 12,
		get = function(info) return ZHunterMod_Saved[name].party end,
		set = function(info, v) ZHunterMod_Saved[name].party = v end
	}
	tbl.raid = {
		type = "toggle", tristate = true,
		name = "Рейд", desc = "Будет посылать сообщения в рейдовый чат.",
		order = 13,
		get = function(info) return ZHunterMod_Saved[name].raid end,
		set = function(info, v) ZHunterMod_Saved[name].raid = v end
	}
	tbl.raidWarning = {
		type = "toggle", tristate = true,
		name = "Обьявление рейду", desc = "Будет посылать сообщения в обьявления рейду.",
		order = 14,
		get = function(info) return ZHunterMod_Saved[name].raidWarning end,
		set = function(info, v) ZHunterMod_Saved[name].raidWarning = v end
	}
	tbl.channel = {
		type = "toggle", tristate = true,
		name = "Канал", desc = "Будет посылать сообщения в назначенный вами канал.",
		order = 15,
		get = function(info) return ZHunterMod_Saved[name].channel end,
		set = function(info, v) ZHunterMod_Saved[name].channel = v end
	}
	tbl.channelNum = {
		type = "range", min = 1, max = 10, step = 1,
		name = "Номер канала", desc = "Назначте номер канала в который будут передоваться сообщения.",
		order = 16,
		get = function(info) return ZHunterMod_Saved[name].channelNum end,
		set = function(info, v) ZHunterMod_Saved[name].channelNum = v end
	}
end