﻿if select(2, UnitClass('player')) ~= "SHAMAN" then
	return
end

TotemBar = CreateFrame("Frame")
TotemBar.__index = TotemBar

local LBF = LibStub("LibButtonFacade", true)
	
function TotemBar.Create()
	local bar = CreateFrame("Frame", "YataBarGrip", UIParent, "SecureFrameTemplate, SecureHandlerAttributeTemplate")
	setmetatable(bar, TotemBar)
	
	bar:New()
	
	return bar
end

function TotemBar:New()
	self:Init()

	Yata:InitTotems()
	Yata:InitTotemSets()
	
	self.Set = Yata:GetTotemSet(nil) -- Retrieve the current set
	
	-- Need to get the group order then iterate through the other items
	for k, spellgroup in ipairs(self.Set["GroupOrder"]) do
		
		-- Create the header and proxy for the group
		local header = Header:Create(spellgroup, self)
		header:Show()
		header:SetParent(self)
		self.Groups[spellgroup].Header = header
	
		local proxy = Yata.Button:CreateTotemProxy(spellgroup,self)
		proxy:SetPoint("TOPLEFT",proxy.Parent,"TOPLEFT",-50,(k-1)*36)
		proxy:Hide();
		proxy:SetParent(self)
		self.Groups[spellgroup].Proxy = proxy
		
		if LBF then
			proxy.LBFButtonData = {Button = proxy, Icon = proxy.Icon, HotKey = proxy.HotKey, Cooldown = proxy.Cooldown}
			self.LBFGroup:AddButton(proxy, proxy.LBFButtonData)				
		end		
		
		for l, totemname in ipairs(self.Set[spellgroup]) do

			-- Create the buttons for each spell
			local totem = Yata:GetTotem(totemname)	
			
			local button = Yata.Button:Create(totem.Name,self.Groups[totem.SpellGroup].Header, totem)
					
			if LBF then
				button.LBFButtonData = {Button = button, Icon = button.Icon, HotKey = button.HotKey, Cooldown = button.Cooldown}
				self.LBFGroup:AddButton(button, button.LBFButtonData)				
			end			
			
			button:SetAttribute("position", l-1)
			
			table.insert(self.Groups.All, button)
			table.insert(self.Groups[totem.SpellGroup].Buttons,button)
		end
	end
		
	self:SetProxyBinding()
	self:SkinButtons()
	self:SetButtonSwapKey()
	self:SetButtonNoSwapKey()
	self:SetButtonSetCallKey()
	self:SetAutoButtonSwap()
	self:SetAutoSwapToCall()
	self:SetManualSwapToCallKey()
	self:ConfigureBarDisplay()
		
	self:PositionButtons()
	
	Yata:InitTimer()

	self:EditMacro(true,nil,nil)
end

function TotemBar:ApplyTotemSet(name)

	local set = Yata:GetTotemSet(name)

	for k, spellGroup in ipairs(set.GroupOrder) do -- Loop through the spellgroups and apply position to the headers
		self.Groups[spellGroup].Header:SetAttribute("position", k-1)
	
		for j, spellName in ipairs(set[spellGroup]) do -- Loop through each spellgroup and apply position to the buttons
			for l, button in ipairs(self.Groups[spellGroup].Buttons) do
				if button.Totem.Name == spellName then
					button:SetAttribute("newposition", j-1 )
				end
			end
		end
	end
	
	if (set["HiddenSpells"]) then
		for j, spellName in ipairs(set["HiddenSpells"]) do -- Loop through each button and set to hidden if hidden
			for l, button in ipairs(self.Groups.All) do
				if button.Totem.Name == spellName then
					button:SetAttribute("hidden", true)
				end
			end
		end
	end
end

function TotemBar:Destroy()
	self:SetParent(nil)
	self.Name = nil
	self:Hide()
		
	for k,spellgroup in ipairs(SpellGroups) do
			
		if self.Groups[spellgroup].Header then		
			self.Groups[spellgroup].Header:SetParent(nil)
			self.Groups[spellgroup].Header:Hide()
		end			
	
		if(self.Groups[spellgroup].Proxy) then
			self.Groups[spellgroup].Proxy:SetParent(nil)
			self.Groups[spellgroup].Proxy:Hide()
		end
	end
	
	for m,button in ipairs(self.Groups.All) do
		if(button) then
			button:SetParent(nil)
			button:Hide()
		end
	end
end

function TotemBar:Init()
	self.Name = "YataBarGrip"
	self.Parent = UIParent
	self:SetHeight(36)
	self:SetWidth(0)
	self.Texture = self:CreateTexture()
	self.Texture:SetTexture(0, 0, 0.5, 0.5)
	self.Texture:SetAllPoints(self)	
	self:RegisterForDrag( "LeftButton" )
	self:EnableMouse(true)
	self:SetMovable(true)
	
	self:SetAttribute("_onattributechanged", [[
		if (name == "autocall" and self:GetAttribute("autoswaptocall") == true) or (name == "manualcall") then
			local headers = newtable(self:GetChildren())
			local buttons
			local buttonToMove, buttonAtZero, buttonOldPos
			local globalID		
					
			-- we have a base actionid
			-- loop through each totem element in this call spell			
			-- get the headers of each spellgroup and loop through their children
			-- check the globalid of the action in the slot vs the globalid on the button
			-- if they match then swap the totem with the one currently in position 0
			for i = value, value + 3 do
				_, _, _, globalID = GetActionInfo(i)
				
				if globalID then
					for j,header in ipairs(headers) do
						buttons = newtable(header:GetChildren())
						buttonToMove = nil
						buttonAtZero = nil
						buttonOldPos = nil			
												
						for k, button in ipairs(buttons) do
							if button and button:GetAttribute("globalid") then
								if button:GetAttribute("position") == 0 then 
									buttonAtZero = button
								end
								if globalID == button:GetAttribute("globalid") then
									buttonToMove = button
									buttonOldPos = button:GetAttribute("position")
								end
							end
						end
						
						if buttonToMove and buttonAtZero and buttonOldPos > 0 then
							buttonToMove:SetAttribute("newposition", 0)
							buttonAtZero:SetAttribute("newposition", buttonOldPos)
						end
					end
				end
			end
		end
	]] )
	
	self:SetScript("OnDragStart", function()
		if(not Yata.CurrentDb.Locked) then
			this:StartMoving()
		end
	end)
	self:SetScript("OnDragStop", function()
		this:StopMovingOrSizing()
		self:SaveBarConfig()
	end)	
	
	self.Groups = {["All"] = {},
							["Earth"] = { ["Header"] = nil, ["Buttons"] = {}, ["Proxy"] = nil}, 
							["Fire"] = {["Header"] = nil, ["Buttons"] = {}, ["Proxy"] = nil }, 
							["Water"] = {["Header"] = nil, ["Buttons"] = {}, ["Proxy"] = nil }, 
							["Air"] = {["Header"] = nil, ["Buttons"] = {}, ["Proxy"] = nil }, 
							[SPELL_GROUP_CALL] = {["Header"] = nil, ["Buttons"] = {}, ["Proxy"] = nil }, 
							[SPELL_GROUP_IMBUE] = {["Header"] = nil, ["Buttons"] = {}, ["Proxy"] = nil }}
	
	if LBF then
		self.LBFGroup = LBF:Group("Yata")
		self.LBFGroup.SkinID = Yata.CurrentDb.ButtonSkin
		LBF:RegisterSkinCallback("Yata",self.SkinChanged,self)		
	end	
	
	self:RegisterEvent("SPELL_UPDATE_COOLDOWN", "BarUpdateHandler")
	self:RegisterEvent("UPDATE_MULTI_CAST_ACTIONBAR", "UpdateCallIndicators")
	
	self:LoadPosition()
end

function TotemBar:SkinChanged(SkinID,Gloss,Backdrop,Group,Button,Colors)
	Yata.CurrentDb.ButtonSkin = SkinID
	self:ConfigureBarDisplay()
end

function TotemBar:BarUpdateHandler()
	if Yata.CurrentDb.TimerType == 1 then
		local totem = Yata.TotemData[GetSpellInfo(8071)] -- Stoneskin Totem
		
		local start, duration, enable = GetSpellCooldown(8071)
		for k,v in ipairs(self.Groups.All) do
			CooldownFrame_SetTimer(v.Cooldown, start, duration, enable)
		end
	end
end

function TotemBar:PositionButtons()
	for j, spellgroup in ipairs(SpellGroups) do
		for k, button in ipairs(self.Groups[spellgroup].Buttons) do
			button:SetAttribute("newposition", k-1)
		end
	end
end

function TotemBar:SetPopOutScale(value)
	for i,spellgroup in ipairs(SpellGroups) do
		self.Groups[spellgroup].Header:SetAttribute("popoutscale", value)
	end
end

function TotemBar:SkinButtons(skin)
	Yata.CurrentDb.ButtonSkin = skin or Yata.CurrentDb.ButtonSkin
	if LBF and self.LBFGroup then
		self.LBFGroup:Skin(skin,0,true)
	end
end

function TotemBar:SetAutoSwapToCall(autoswaptocall)	
	if autoswaptocall == nil then 
		autoswaptocall = Yata.CurrentDb.AutoSwapToCall 
	end
	
	Yata.CurrentDb.AutoSwapToCall = autoswaptocall 

	self:SetAttribute("autoswaptocall", autoswaptocall)
end

function TotemBar:SetAutoButtonSwap(autobutton)	
	if autobutton == nil then 
		autobutton = Yata.CurrentDb.AutoButtonSwap 
	end
	
	Yata.CurrentDb.AutoButtonSwap = autobutton 
	
	for i,b in ipairs(self.Groups.All) do
		b:SetOnClickScript(Yata.CurrentDb.AutoButtonSwap)
	end
end

function TotemBar:SetButtonSetCallKey(key)	
	Yata.CurrentDb.ButtonSetCallKey = key or Yata.CurrentDb.ButtonSetCallKey
	for i,b in ipairs(self.Groups.All) do
		b:SetAttribute("setcallkey", Yata.CurrentDb.ButtonSetCallKey)
	end
end

function TotemBar:SetButtonSwapKey(key)
	Yata.CurrentDb.ButtonSwapKey = key or Yata.CurrentDb.ButtonSwapKey
	for i,b in ipairs(self.Groups.All) do
		b:SetAttribute("swapkey",Yata.CurrentDb.ButtonSwapKey)
	end
end

function TotemBar:SetButtonNoSwapKey(key)
	Yata.CurrentDb.ButtonNoSwapKey = key or Yata.CurrentDb.ButtonNoSwapKey
	for i,b in ipairs(self.Groups.All) do
		b:SetAttribute("noswapkey",Yata.CurrentDb.ButtonNoSwapKey)
	end
end

function TotemBar:SetManualSwapToCallKey(key)
	Yata.CurrentDb.ManualSwapToCallKey = key or Yata.CurrentDb.ManualSwapToCallKey
	for i,b in ipairs(self.Groups.All) do
		b:SetAttribute("manualswaptocallkey",Yata.CurrentDb.ManualSwapToCallKey)
	end
end

function TotemBar:LoadPosition()
	if Yata.CurrentDb.Locked then
		self.Texture:Hide()
	end	
	local x,y,scale
	if Yata.CurrentDb.BarPosition then
		x = Yata.CurrentDb.BarPosition.x
		y = Yata.CurrentDb.BarPosition.y
	else
		self:ClearAllPoints()
		self:SetPoint( "CENTER", WorldFrame, "CENTER", 0,0 )
		x = self:GetLeft()
		y = self:GetBottom()
	end	
	self:ClearAllPoints()
	self:SetPoint("BOTTOMLEFT", UIParent,"BOTTOMLEFT", x, y)
	self:SetScale(Yata.CurrentDb.BarScale)	
end

function TotemBar:SaveBarConfig()
	if not Yata.CurrentDb.BarPosition then 
		Yata.CurrentDb.BarPosition = {}
	end
	
	local x = self:GetLeft()
	local y = self:GetBottom()
	
	Yata.CurrentDb.BarPosition.x = x
	Yata.CurrentDb.BarPosition.y = y
end

function TotemBar:Unlock()
	Yata.CurrentDb.Locked = false
	self.Texture:Show()
	for k,v in ipairs(SpellGroups) do
		self.Groups[v].Header:Hide()
	end
	Yata:ShowTimerAnchors()
end

function TotemBar:Lock()
	Yata.CurrentDb.Locked = true
	self.Texture:Hide()
	self:SaveBarConfig()
	for k,v in ipairs(SpellGroups) do
		self.Groups[v].Header:Show()
	end
	Yata:HideTimerAnchors()	
end

function TotemBar:GetCurrentCallIndex()
	for k, button in ipairs(self.Groups[SPELL_GROUP_CALL].Buttons) do
		if button:GetAttribute("position") == 0 then
			return k - 1
		end
	end
	
	return 0
end

function TotemBar:ConfigureBarDisplay(gapValue, orientationValue, visibleValue)
	gapValue = gapValue or Yata.CurrentDb.ButtonGap
	orientationValue = orientationValue or Yata.CurrentDb.BarOrientation
	visibleValue = visibleValue or Yata.CurrentDb.VisibleButtons
	
	Yata.CurrentDb.ButtonGap = gapValue
	Yata.CurrentDb.BarOrientation = orientationValue
	Yata.CurrentDb.VisibleButtons = visibleValue
	
	if Yata.CurrentDb.ButtonSkin == "Blizzard" then
		gapValue = gapValue + 4
	end
	
	local buttonSize =  36 + gapValue
	
	for k, spellgroup in ipairs(SpellGroups) do
		local header = self.Groups[spellgroup].Header
		header:SetAttribute("buttongap",gapValue)
		header:SetWidth(36)
		header:SetHeight(36)
		header:SetAttribute("visiblebuttons", visibleValue)
		header:SetAttribute("orientation",orientationValue)
		header:SetAttribute("position",k-1)
		header:SetAttribute("show",false)
	end
	
	self:SetWidth(#SpellGroups * buttonSize)

	self:PositionButtons()

	for k,v in ipairs(self.Groups.All) do
		 if Yata.CurrentDb.ButtonSkin == "Blizzard" then
			v.Duration:SetPoint("TOP",v.Parent,"BOTTOM",0,-4)
		 else
			v.Duration:SetPoint("TOP",v.Parent,"BOTTOM",0,0)
		end
	end
		
	self:ApplyTotemSet()
end

function TotemBar:UpdateAllButtons(spellgroup)
	for k, button in ipairs(self.Groups[spellgroup].Buttons) do
		button:SetCallIndicators()
	end
end

function TotemBar:UpdateCallIndicators()
	for k, button in ipairs(self.Groups.All) do
		button:SetCallIndicators()
	end
end

function Yata:LIBKEYBOUND_ENABLED()
	for i,b in ipairs(SpellGroups) do
		Yata.Bar.Groups[b].Header:SetAttribute("visiblebuttons",10)
		Yata.Bar.Groups[b].Header:SetAttribute("show",true)
		Yata.Bar.Groups[b].Proxy:Show()
	end
	Yata.keyBoundMode = true
end

function Yata:LIBKEYBOUND_DISABLED()
	Yata.keyBoundMode = nil
	for i,b in ipairs(SpellGroups) do
		Yata.Bar.Groups[b].Header:SetAttribute("visiblebuttons",Yata.CurrentDb.VisibleButtons)
		Yata.Bar.Groups[b].Header:SetAttribute("show",false)
		Yata.Bar.Groups[b].Proxy:Hide()
	end
	self.Bar:SetProxyBinding()
end

function Yata:LIBKEYBOUND_MODE_COLOR_CHANGED()
end

function TotemBar:SetProxyBinding()
	for i,b in ipairs(SpellGroups) do
		local key = GetBindingKey(format("CLICK %s:LeftButton", self.Groups[b].Proxy.Name))
		self.Groups[b].Header:SetAttribute("proxybinding",key)
	end
end

function TotemBar:EditMacro(force, old,new)
	local num = GetNumMacros()
	local macroindex = GetMacroIndexByName("YataTotemStomp")
	if force or macroindex == 0 and num < 36 then
		local macro = "#showtooltip\n/castsequence reset=combat/"..Yata.CurrentDb.MacroResetKey.." "
		local totems = {}
		local set = Yata:GetTotemSet()
		for k,v in ipairs(set.GroupOrder) do
			if v ~= SPELL_GROUP_IMBUE and v~= SPELL_GROUP_CALL then
				for i,b in ipairs(self.Groups[v].Buttons) do
					if b:GetAttribute("position") == 0 then
						table.insert(totems,b.Totem.Name)
						break
					end
				end
			end
		end
		for k,v in ipairs(totems) do
			if totems[k] and totems[k+1] then
				macro = string.format("%s%s, ",macro,v)
			else
				macro = string.format("%s%s",macro,v)
			end
		end
		local numIcons = GetNumMacroIcons()
		local iconid = 0
		for i=1,numIcons do
			if GetMacroIconInfo(i) == "Interface\\Icons\\INV_Misc_QuestionMark" then
				iconid = i
				break
			end
		end	
		if force and macroindex > 0 then		
			EditMacro(macroindex, "YataTotemStomp", iconid, macro, 1)
		else
			CreateMacro("YataTotemStomp",iconid,macro,1,1)
		end
	elseif macroindex > 0 and old and new then
		local name, texture, macro, isLocal = GetMacroInfo(macroindex)
		macro = string.gsub(macro,old,new)
		EditMacro(macroindex, name, texture, macro, isLocal);
	end	
end