--This is the internal name of the mod.
local XBARMOD="XTotemBar";
local dbver="3";

--Default settings and other info about the mod
XBarCore.ModData[XBARMOD] = {
	["nbuttons"]=0,
	["dbver"]=dbver,
	["dhorizontal"]=true,
	["hidebar"]=false,
	["dorder"]="az",
	["dscale"]=1,
	["dtooltips"]=true,
	["enabled"]=false,
	["nchecks"]=0,
	["wrappable"]=true,
	["sortable"]=true,
	["ftexint"]=XBARMOD.."_Texture",
	["fbuttonid"]="XBar_StdButtonID",
	["foptioncb"]="XBar_StdOptionCB",
};

function XTotemBar_UpdateTotems(self,elapsed)
	local i,d1,d2,d,b,s,t,a,u1,u2,v,u3;
	local n=XBarCore.ModData.XTotemBar.nbuttons;

	XTotemBar.TimeSinceLastUpdate = XTotemBar.TimeSinceLastUpdate + elapsed;

	if (XTotemBar.TimeSinceLastUpdate < 0.5) then
		return;
	end

	XTotemBar.TimeSinceLastUpdate = 0;
	
	if (not XBarCore.ModData.XTotemBar.loaded) then
		return;
	end

	if (n==nil) then
		return;
	end

	u1=false;
	for i = 1, n do
		b=XBarCore.FrameDB["XTotemBarButton"..i];
		if (b) then
			a=b.XBarAction;
			if (a) then
				a=XBarCore.ModData.XTotemBar.ActionList[a]
				if a then
					v=a.Data[1].Data;
					-- Look for totems that we are casting
					XBarCore.ShowCount("XTotemBar",i,0,0);
					u2=false;
					u3=false;
					for s=1,4 do
						_,t,d1,d2 = GetTotemInfo(s);
						d=ceil(d2-GetTime()+d1);
						if d<0 then
							d=1;
						end
						if (t) and strsub(t,1,strlen(v))==v then
							if not b.TotemActive then
								b.TotemActive=true;
								u2=true;
							else
								u3=true;
							end
							XBarCore.ShowCount("XTotemBar",i,d,0);
							break;
						end
					end
					if u2 then
						u1=true;
					elseif b.TotemActive then
						if not u3 then
							u1=true;
							b.TotemActive=false;
						end
					end
				end
			end
		end
	end
	if u1 then
		-- Detected change in totems, update the bar
		XBarCore.Update(XBARMOD);
	end
end

function XTotemBar_OnLoad()
	--Each bar must catch its own event notifications
	local Class,_;

	-- Nonlocalized class check
	_, Class = UnitClass("player");
	if (Class == "SHAMAN") then
		this:RegisterEvent("SPELLS_CHANGED");
		this:RegisterEvent("SPELL_UPDATE_COOLDOWN");
		this:RegisterEvent("PLAYER_ENTERING_WORLD");
		this:RegisterEvent("UNIT_AURA");
		this:RegisterEvent("ACTIONBAR_UPDATE_USABLE");
		this:SetScript("OnUpdate",XTotemBar_UpdateTotems);
		XTotemBar.TimeSinceLastUpdate=0;
		XBarCore.ModData[XBARMOD].enabled=true;
	else
		this:SetScript("OnUpdate",nil);
		-- Reduces lag
	end
end

function XTotemBar_Texture(mod,texture,spellname,index)
	local t = texture;
	local b,z;

	if XBarData[XBarCore.XBarOptionSet].mods and 
	   XBarData[XBarCore.XBarOptionSet].mods[mod] and
	   XBarData[XBarCore.XBarOptionSet].mods[mod].nohighlight then
		return t;
	end
	-- Will highlight the totem the player has out (if it is an aura effect)
	for z = 1, 50 do
		b=UnitBuff("player",z);

		if (b==nil) then
			break;
		elseif (b==strsub(spellname,1,strlen(b))) then
			t = "Interface\\Icons\\Spell_Nature_WispSplode";
		end
	end

	-- Look for totems that we are casting
	for z=1,4 do
		_,b = GetTotemInfo(z);
		if (b) and strsub(b,1,strlen(spellname))==spellname then
			t="Interface\\Icons\\Spell_Nature_WispSplodeGreen";
			break;
		end
	end

	return t;
end