--This is the internal name of the mod.
local XBARMOD="XAspectBar";
local dbver="3";

--Default settings and other info about the mod
XBarCore.ModData[XBARMOD] = {
	["nbuttons"]=0,
	["dbver"]=dbver,
	["dhorizontal"]=true,
	["hidebar"]=false,
	["dorder"]="az",
	["dscale"]=1,
	["dtooltips"]=true,
	["enabled"]=false,
	["nchecks"]=0,
	["wrappable"]=false,
	["sortable"]=true,
	["ftexint"]="XBar_StdTexture",
	["fbuttonid"]="XBar_StdButtonID",
	["foptioncb"]="XBar_StdOptionCB",
	["fattributecb"]="XAspectBar_AttributeCB",
};

function XAspectBar_OnLoad()
	--Each bar must catch its own event notifications
	local Class,_;

	-- Nonlocalized class check
	_, Class = UnitClass("player");
	if (Class == "HUNTER") then
		this:RegisterEvent("SPELLS_CHANGED");
		this:RegisterEvent("SPELL_UPDATE_COOLDOWN");
		this:RegisterEvent("PLAYER_ENTERING_WORLD");
		this:RegisterEvent("UNIT_AURA");
		this:RegisterEvent("ACTIONBAR_UPDATE_USABLE");
		XBarCore.ModData[XBARMOD].enabled=true;
	else
		this:SetScript("OnUpdate",nil);
		-- Reduces lag
	end
end

function XAspectBar_OnEvent(event,arg1)
	if event=="PLAYER_ENTERING_WORLD" then
		-- Set up sliders that we missed earlier
		local i,v,c,a;

		c=0;
		for i,v in pairs(XAspectBarSpells) do
			if v==" " then
				break; -- End of the mini-list
			else
				c=c+1;
				XBarCore.ModData[XBARMOD]["slider"..c]=XASPECTBAR_ACTIONBARPAGE..v;
				XBarCore.ModData[XBARMOD]["slider"..c.."min"]=0;
				XBarCore.ModData[XBARMOD]["slider"..c.."max"]=6;
				XBarCore.ModData[XBARMOD]["slider"..c.."step"]=1;
				XBarCore.ModData[XBARMOD]["slider"..c.."format"]="%i";
				XBarCore.ModData[XBARMOD]["dslider"..c]=0;
			end
		end
		XBarCore.ModData[XBARMOD].nsliders=c;
	end
	XBar_StdEventHandler(XBARMOD,event,arg1);
end

function XAspectBar_AttributeCB(mod,index,button,action)
	local a = action.Data[1].Data;
	local o = XASPECTBAR_ACTIONBARPAGE..a;
	local v=XBarData[XBarCore.XBarOptionSet].mods[mod];

	if (v) and not XBarCore.ModData[mod].nsliders then
		XBarCore.ModData[mod].nsliders=0;
		v=nil;
	else
		v=XBarCore.GetOption(mod,o);
	end

	if v==nil or v==0 then
		return false;
	end

	button:SetAttribute("button*","type");
	button:SetAttribute("type","macro");
	button:SetAttribute("macrotext*","/changeactionbar "..tostring(v).."\010/cast "..a);
	return true;
end
