-- Credits: Thank you, Treeston (from WoWI) for the guild bank repair code,
--   making me get off my butt to finally add it. :)

local VendorMaster = CreateFrame("Frame", nil, UIParent)
	VendorMaster:Hide()
local bags = {0,1,2,3,4}
local db, buyItem, saveItem, sellItem, options, buyList, saveList, sellList

local defaults = {
	reminder = true,
	sell = false,
	buy = false,
	repair = false,
	repairGuild = false,
	details = true,
	saveList = {},
	buyList = {},
	sellList = {},
}


--local 
options = {
	name = "VendorMaster Options",
	type = "group",
	args = {
		general = {
			name = "General Options",
			type = "group",
			args = {
				sellitems = {
					name = "Auto-sell items",
					desc = "Having this checked will automatically sell all of your gray (common) quality items when you visit a vendor.\n\nAnything on your 'save list' will not be sold.",
					type = "toggle",
					get = function() return db.sell end,
					set = function() db.sell = not db.sell end,
					order = 1,
				},
				buyitems = {
					name = "Auto-buy items",
					desc = "Having this checked will automatically restock items on your shopping list when you visit a vendor.",
					type = "toggle",
					get = function() return db.buy end,
					set = function() db.buy = not db.buy end,
					order = 2,
				},
				repairitems = {
					name = "Auto-repair items",
					desc = "Having this checked will automatically repair all items in your inventory when you visit a vendor that can do repairs.",
					type = "toggle",
					get = function() return db.repair end,
					set = function() db.repair = not db.repair end,
					order = 3,
				},
				repairguild = {
					name = "Repair with guild funds",
					desc = "If you have the proper permissions and there is enough money left to withdraw, you will use guild funds to repair.",
					type = "toggle",
					get = function() return db.repairGuild end,
					set = function() db.repairGuild = not db.repairGuild end,
					disabled = function() return not db.repair end,
					order = 3.5,
				},
				desc1 = {
					name = "",
					type = "description",
					width = "full",
					order = 4,
				},
				header1 = {
					name = "",
					type = "header",
					order = 5,
				},
				details = {
					name = "Show details",
					desc = "If checked, VendorMaster will display in chat what actions it took, including money spent and earned.",
					type = "toggle",
					get = function() return db.details end,
					set = function() db.details = not db.details end,
					order = 6,
				},
				reminder = {
					name = "Show reminder",
					desc = "If checked, the reminder message will be shown at login.",
					type = "toggle",
					get = function() return db.reminder end,
					set = function() db.reminder = not db.reminder end,
					order = 7,
				},
			},
		},
		buyList = {
			name = "Buy List",
			type = "group",
			args = {
				info = {
					name = "Items on your shopping list are purchased whenever you visit a vendor that sells those items.  Use this list for items like reagents, ammo, or food.\n ",
					type = "description",
					width = "full",
					order = 1,
				},
				addItem = {
					name = "Add Item",
					type = "group",
					inline = true,
					order = 2,
					args = {
						newItem = {
							name = "Add New Item",
							desc = "Add a new item to your shopping list.\n\nEnter an item's itemID - this can be found from sites like Wowhead.  Or, use the ItemID Finder for an item in your inventory.",
							type = "input",
							get = function() return "" end,
							set = function(_,id)
										local name = GetItemInfo(id)
										if name then
											db.buyList[name] = {["itemID"] = id, ["stock"] = 0}
											options.args.buyList.args.addItem.args.message.name = name.." added to your shopping list. You can view your list, edit the amount to purchase, and remove items below."
										else
											options.args.buyList.args.addItem.args.message.name = "Item number "..id.." does not exist!"
										end
									end,
							order = 1,
						},
						findID = {
							name = "ItemID Finder",
							desc = "Open the ItemID Finder window to find the id of your items.",
							type = "execute",
							func = function()
										InterfaceOptionsFrame:Hide()
										GameMenuFrame:Hide()
										VendorMaster:Show()
									end,
							order = 2,
						},
						message = {
							name = "Enter an item id number above to get started.",
							type = "description",
							width = "full",
							order = 3,
						},
					},
				},
				editItem = {
					name = "Edit Item...",
					desc = "Select an item from the list to edit your shopping list.",
					type = "select",
					values = function()
								buyList = {}
								for k,v in pairs(db.buyList) do
									tinsert(buyList, k)
								end
								return buyList
							end,
					get = function()
								if buyItem then
									for k, v in pairs(buyList) do
										if GetItemInfo(buyItem) == v then
											return k
										end
									end
								end
							end,
					set = function(_,item)
								local item = buyList[item]
								buyItem = db.buyList[item].itemID
							end,
					order = 3,
				},
				desc2 = {
					name = " ",
					type = "description",
					width = "full",
					order = 4,
				},
				buyItem = {
					name = function() if buyItem then local texture = select(10,GetItemInfo(buyItem)) return "|T"..texture..":18|t  "..GetItemInfo(buyItem) else return " " end end,
					type = "group",
					inline = true,
					order = 5,
					args = {
						amount = {
							name = "Amount to stock",
							desc = "This is the amount of the item to keep in stock.",
							type = "range",
							min = 0,
							max = 1000,
							step = 1,
							disabled = function() if buyItem then return false else return true end end,
							get = function() if buyItem then return db.buyList[GetItemInfo(buyItem)].stock end end,
							set = function(_,amount) db.buyList[GetItemInfo(buyItem)].stock = amount end,
							order = 6,
						},
						delete = {
							name = "Delete Item",
							desc = "Click to remove this item from your shopping list.",
							type = "execute",
							disabled = function() if buyItem then return false else return true end end,
							func = function() db.buyList[GetItemInfo(buyItem)] = nil buyItem = nil end,
							order = 7,
						},
					},
				},
			},
		},
		saveList = {
			name = "Save List",
			type = "group",
			args = {
				info = {
					name = "Gray items on your save list are not sold when visiting a vendor.  Use this list for things that you wish to keep in your inventory such as flavor items or clothing.\n ",
					type = "description",
					width = "full",
					order = 1,
				},
				addItem = {
					name = "Add Item",
					type = "group",
					inline = true,
					order = 2,
					args = {
						newItem = {
							name = "Add New Item",
							desc = "Add a new item to your save list.  These gray items will -not- be sold at a vendor.\n\nEnter an item's itemID - this can be found from sites like Wowhead.  Or, use the ItemID Finder for an item in your inventory.",
							type = "input",
							get = function() return "" end,
							set = function(_,id)
										local name = GetItemInfo(id)
										if name then
											db.saveList[name] = id
											options.args.saveList.args.addItem.args.message.name = name.." added to your save list. You can view your list and remove items below."
										else
											options.args.saveList.args.addItem.args.message.name = "Item number "..id.." does not exist!"
										end
									end,
							order = 1,
						},
						findID = {
							name = "ItemID Finder",
							desc = "Open the ItemID Finder window to find the id of your items.",
							type = "execute",
							func = function()
										InterfaceOptionsFrame:Hide()
										GameMenuFrame:Hide()
										VendorMaster:Show()
									end,
							order = 2,
						},
						message = {
							name = "Enter an item id number above to get started.",
							type = "description",
							width = "full",
							order = 3,
						},
					},
				},
				editItem = {
					name = "Edit Item...",
					desc = "Select an item from the list to edit your save list.",
					type = "select",
					values = function()
								saveList = {}
								for k,v in pairs(db.saveList) do
									tinsert(saveList, k)
								end
								return saveList
							end,
					get = function()
								for k, v in pairs(saveList) do
									if saveItem == v then
										return k
									end
								end
							end,
					set = function(_,item)
								local item = saveList[item]
								saveItem = db.saveList[item]
							end,
					order = 3,
				},
				desc2 = {
					name = " ",
					type = "description",
					width = "full",
					order = 4,
				},
				saveItem = {
					name = function() if saveItem then local texture = select(10,GetItemInfo(saveItem)) return "|T"..texture..":18|t  "..GetItemInfo(saveItem) else return " " end end,
					type = "group",
					inline = true,
					order = 5,
					args = {
						delete = {
							name = "Delete Item",
							desc = "Click to remove this item from your save list.",
							type = "execute",
							disabled = function() if saveItem then return false else return true end end,
							func = function() db.saveList[GetItemInfo(saveItem)] = nil saveItem = nil end,
							order = 6,
						},
					},
				},
			},
		},
		sellList = {
			name = "Sell List",
			type = "group",
			args = {
				info = {
					name = "Items on your sell list are sold whenever you visit a vendor if you have the 'Auto-sell items' option enabled.  Use this list for non-gray items that you wish to get rid of such as fish scales, unused food, etc.\n ",
					type = "description",
					width = "full",
					order = 1,
				},
				addItem = {
					name = "Add Item",
					type = "group",
					inline = true,
					order = 2,
					args = {
						newItem = {
							name = "Add New Item",
							desc = "Add a new item to your sell list.  This is for items besides gray items that you wish to always be sold to a vendor.\n\nEnter an item's itemID - this can be found from sites like Wowhead.  Or, use the ItemID Finder for an item in your inventory.",
							type = "input",
							get = function() return "" end,
							set = function(_,id)
										local name = GetItemInfo(id)
										if name then
											db.sellList[name] = id
											options.args.sellList.args.addItem.args.message.name = name.." added to your sell list. You can view your list and remove items below."
										else
											options.args.sellList.args.addItem.args.message.name = "Item number "..id.." does not exist!"
										end
									end,
							order = 1,
						},
						findID = {
							name = "ItemID Finder",
							desc = "Open the ItemID Finder window to find the id of your items.",
							type = "execute",
							func = function()
										InterfaceOptionsFrame:Hide()
										GameMenuFrame:Hide()
										VendorMaster:Show()
									end,
							order = 2,
						},
						message = {
							name = "Enter an item id number above to get started.",
							type = "description",
							width = "full",
							order = 3,
						},
					},
				},
				editItem = {
					name = "Edit Item...",
					desc = "Select an item from the list to edit your sell list.",
					type = "select",
					values = function()
								sellList = {}
								for k,v in pairs(db.sellList) do
									tinsert(sellList, k)
								end
								return sellList
							end,
					get = function()
								for k, v in pairs(sellList) do
									if saveItem == v then
										return k
									end
								end
							end,
					set = function(_,item)
								local item = sellList[item]
								sellItem = db.sellList[item]
							end,
					order = 3,
				},
				desc2 = {
					name = " ",
					type = "description",
					width = "full",
					order = 4,
				},
				sellItem = {
					name = function() if sellItem then local texture = select(10,GetItemInfo(sellItem)) return "|T"..texture..":18|t  "..GetItemInfo(sellItem) else return " " end end,
					type = "group",
					inline = true,
					order = 5,
					args = {
						delete = {
							name = "Delete Item",
							desc = "Click to remove this item from your save list.",
							type = "execute",
							disabled = function() if sellItem then return false else return true end end,
							func = function() db.sellList[GetItemInfo(sellItem)] = nil sellItem = nil end,
							order = 6,
						},
					},
				},
			},
		},
	},
}


local function IDfinderWindow()
	if not findertext then
		VendorMaster:SetPoint("CENTER")
		VendorMaster:SetHeight(150)
		VendorMaster:SetWidth(150)
		local findertext = VendorMaster:CreateFontString(nil, "ARTWORK", "GameFontNormalLarge")
			findertext:SetParent(VendorMaster)
			findertext:SetPoint("TOP", VendorMaster, "TOP", 0,-15)
			findertext:SetText("Place item here")
		local IDfinder = VendorMaster:CreateTexture("IDfinder")
			IDfinder:SetTexture("Interface\\PaperDollInfoFrame\\UI-Character-StatBackground")
			IDfinder:SetAllPoints(VendorMaster)
			IDfinder:SetTexCoord(0,.92,0.01,.61)
		local IDbutton = CreateFrame("Button", nil, VendorMaster)
			IDbutton:SetWidth(60)
			IDbutton:SetHeight(60)
			IDbutton:SetPoint("CENTER")
			IDbutton:SetNormalTexture("Interface\\Icons\\INV_Misc_QuestionMark")
			IDbutton:SetHighlightTexture("Interface\\Buttons\\UI-Panel-Button-Highlight.blp")
			IDbutton:GetHighlightTexture():SetTexCoord(0,.64,0,.64)
			IDbutton:EnableMouse(true)
			IDbutton:SetScript("OnClick", function()
						local type,id,item = GetCursorInfo()
						if type == "item" then
							print("|cffe6cc80VendorMaster:|r "..item.." is "..id)
						else
							print("|cffe6cc80VendorMaster:|r That is not an item.")
						end
						ClearCursor()
					end)
		local closebutton = CreateFrame("Button", nil, VendorMaster, "UIPanelButtonTemplate")
			closebutton:SetPoint("BOTTOM", VendorMaster, "BOTTOM", 0, 15)
			closebutton:SetText("Done")
			closebutton:SetHeight(25)
			closebutton:SetWidth(110)
			closebutton:SetScript("OnClick", function() VendorMaster:Hide() GameMenuFrame:Show() InterfaceOptionsFrame:Show() end)
	end
end

local function BuyStuff()
	local cost = 0
	for i=1,GetMerchantNumItems() do	--scan merchant's items for ones I need
		local item,_,price,stack,maxItems = GetMerchantItemInfo(i)
		if db.buyList[item] then
			local need = db.buyList[item].stock - GetItemCount(item)	--how many do I need?
			--apparently not needed anymore - stack items aren't sold as stacks by default
			--but we do need to work this in with the cost below now
			--[[if stack > 1 then	--is this sold by the stack?
				need = floor(need/stack)	--then how many stacks do I need?
			end]]
			if not maxItems == -1 and need > maxItems then	--if not unlimited supply, and I need more than they have
				need = maxItems
			end
			if need > 0 then	--if I need something, then buy it
				BuyMerchantItem(i, need)
				--cost = cost + (price*need)	--tally my cost
				cost = cost + (price*(need/stack))	--tally my cost
			end
		end
	end
	if cost > 0 and db.details then
		print("|cffe6cc80VendorMaster:|r Items purchased for a total of: "..GetCoinTextureString(cost))
	end
end

local function Repair()
	if CanMerchantRepair() then
		local cost, needed = GetRepairAllCost()
		local funds, useGuild, msg
		if needed then	--do I need a repair?
			if db.repairGuild then
				local guildMoney = GetGuildBankWithdrawMoney()
				local guildBank = GetGuildBankMoney()
				funds = guildMoney == -1 and guildBank or math.min(guildMoney, guildBank)
				if funds < cost then
					funds = GetMoney()
				end
				useGuild = 1
				msg = " (Guild)"
			else
				funds = GetMoney()
				useGuild = nil
				msg = ""
			end
			if cost <= funds then
				RepairAllItems(useGuild)
				if db.details then
					print("|cffe6cc80VendorMaster:|r Repaired all of your items for: "..GetCoinTextureString(cost)..msg)
				end
			else
				print("|cffe6cc80VendorMaster:|r Unable to repair - insufficient"..msg.." funds.")
			end
		else
			if db.details then
				print("|cffe6cc80VendorMaster:|r No repairs needed at this time.")
			end
		end
	end
end

local function SellGrays()
	local profit = 0
	local bag, slot
	for _,bag in pairs(bags) do		--scan bags for gray items
		for slot = 1,GetContainerNumSlots(bag) do
			local _,amount,_,_,_,_,item = GetContainerItemInfo(bag,slot)	--gather item name and amount in that slot
			if item then
				local item,_,qual,_,_,_,_,_,_,_,price = GetItemInfo(item)	--gather item's quality and vendor price
				if not db.saveList[item] then
					if qual == 0 or db.sellList[item] then	--if gray or on sellList then sell
						profit = profit + (amount*price)	--tally profit
						UseContainerItem(bag,slot)	--sells item when vendor window is open
					end
				end
			end
		end
	end
	if profit > 0 and db.details then
		print("|cffe6cc80VendorMaster:|r All items sold for a profit of: "..GetCoinTextureString(profit))
	end
end

local function PlayerLogin()
	VendorMasterDB = VendorMasterDB or {}
	for k,v in pairs(defaults) do
	    if type(VendorMasterDB[k]) == "nil" then
	        VendorMasterDB[k] = v
	    end
	end
	db = VendorMasterDB
	if db.reminder then
		print("|cffe6cc80VendorMaster:|r Set up your options and shopping list by typing /vendormaster or /vm.")
	end
	
	LibStub("AceConfig-3.0"):RegisterOptionsTable("VendorMaster", options)
	VendorMaster.optionsFrame = LibStub("AceConfigDialog-3.0"):AddToBlizOptions("VendorMaster", "VendorMaster", nil, "general")
	VendorMaster.optionsFrame.buyList = LibStub("AceConfigDialog-3.0"):AddToBlizOptions("VendorMaster", "Buy List", "VendorMaster", "buyList")
	VendorMaster.optionsFrame.saveList = LibStub("AceConfigDialog-3.0"):AddToBlizOptions("VendorMaster", "Save List", "VendorMaster", "saveList")
	VendorMaster.optionsFrame.sellList = LibStub("AceConfigDialog-3.0"):AddToBlizOptions("VendorMaster", "Sell List", "VendorMaster", "sellList")
	
	SlashCmdList["VENDORMASTER"] = function() InterfaceOptionsFrame_OpenToCategory("VendorMaster") end
	SLASH_VENDORMASTER1 = "/vendormaster"
	SLASH_VENDORMASTER2 = "/vm"
	
	VendorMaster:UnregisterEvent("PLAYER_LOGIN")
	VendorMaster:RegisterEvent("MERCHANT_SHOW")
	VendorMaster:SetScript("OnShow", IDfinderWindow)
	PlayerLogin = nil
end

VendorMaster:RegisterEvent("PLAYER_LOGIN")
VendorMaster:SetScript("OnEvent", function(self,event)
			if event == "MERCHANT_SHOW" then
				if db.sell then
					SellGrays()
				end
				if db.repair then
					Repair()
				end
				if db.buy then
					BuyStuff()
				end
			else
				PlayerLogin()
			end
		end)
