-- Copyright © 2008 Xianghar  <xian@zron.de>
-- All Rights Reserved.
-- This code is not to be modified or distributed without written permission by the author.

local nrfonts = 0

local L = LibStub("AceLocale-3.0"):GetLocale("TotemTimers_GUI", true)

local LSM = LibStub:GetLibrary("LibSharedMedia-3.0", true)

local function reset()
    TotemTimers_Settings = {}
    TotemTimers_SpecSettings = {}
    ReloadUI()
end

local function resetpos()
    TotemTimers_Settings.TimerPositions = nil
    TotemTimers_Settings.FramePositions = nil
    ReloadUI()
    --[[TotemTimers_LoadDefaultSettings()
    TotemTimers_ProcessSetting("FramePositions")
    TotemTimers_OrderTimers()
    TotemTimers_PositionCastButtons()
    TotemTimers_OrderTrackers()
    for i=1,5 do
        XiTimers.timers[i]:SetTimerBarPos(XiTimers.timers[i].timerBarPos, true)
    end ]]   
end


TotemTimers.options = {
    type = "group",
    args = {
        general = {
            type = "group",
            name = "general",
            args = {
                version= {
                    order = 0,
                    type ="description",
                    name = L["Version"]..": "..tostring(GetAddOnMetadata("TotemTimers", "Version"))
                },
                lock = {
                    order = 1,
                    type = "toggle",
                    name = L["Lock"],
                    desc = L["Locks the position of TotemTimers"],
                    set = function(info, val) TotemTimers_Settings.Lock = val TotemTimers_ProcessSetting("Lock") end,
                    get = function(info) return TotemTimers_Settings.Lock end,
                },            
                flashred = {
                    order = 2,
                    type = "toggle",
                    name = L["Red Flash Color"],
                    desc = L["RedFlash Desc"],
                    set = function(info, val) TotemTimers_Settings.FlashRed = val TotemTimers_ProcessSetting("FlashRed") end,
                    get = function(info) return TotemTimers_Settings.FlashRed end,
                },            
                showtimerbars = {
                    order = 2,
                    type = "toggle",
                    name = L["Show Timer Bars"],
                    desc = L["Displays timer bars underneath times"],
                    set = function(info, val) TotemTimers_Settings.ShowTimerBars = val TotemTimers_ProcessSetting("ShowTimerBars") end,
                    get = function(info) return TotemTimers_Settings.ShowTimerBars end,
                },
                timersonbuttons = {
                    order = 2,
                    type = "toggle",
                    name = L["Timers On Buttons"],
                    desc = L["Timers On Buttons Desc"],
                    set = function(info, val) 
                        TotemTimers_Settings.TimersOnButtons = val 
                        TotemTimers_ProcessSetting("TimersOnButtons")
                        for i=1,#XiTimers.timers do
                            XiTimers.timers[i]:SetTimerBarPos(XiTimers.timers[i].timerBarPos)
                        end
                    end,
                    get = function(info) return TotemTimers_Settings.TimersOnButtons end
                },
                hideblizztimers = {
                    order = 3,
                    type = "toggle",
                    name = L["Hide Blizzard Timers"],
                    set = function(info, val) TotemTimers_Settings.HideBlizzTimers = val TotemTimers_ProcessSetting("HideBlizzTimers") end,
                    get = function(info) return TotemTimers_Settings.HideBlizzTimers end,
                },                  
                hidedefaulttotembar = {
                    order = 3,
                    type = "toggle",
                    name = L["Hide Default Totem Bar"],
                    set = function(info, val) TotemTimers_Settings.HideDefaultTotemBar = val
                            TotemTimers_ProcessSetting("HideDefaultTotemBar") end,
                    get = function(info) return TotemTimers_Settings.HideDefaultTotemBar  end,
                },                  
                tooltips = {
                    order = 3,
                    type = "toggle",
                    name = L["Show Tooltips"],
                    desc = L["Shows tooltips on timer and totem buttons"],
                    set = function(info, val) TotemTimers_Settings.Tooltips = val TotemTimers_ProcessSetting("Tooltips") end,
                    get = function(info) return TotemTimers_Settings.Tooltips end,
                },  
                tooltipsatbuttons = {
                    order = 3,
                    type = "toggle",
                    name = L["Tooltips At Buttons"],
                    desc = L["Tooltips At Buttons Desc"],
                    set = function(info, val) TotemTimers_Settings.TooltipsAtButtons = val end,
                    get = function(info) return TotemTimers_Settings.TooltipsAtButtons end,
                },
                HideInVehicle = {
                    order = 3,
                    type = "toggle",
                    name = L["Hide In Vehicles"],
                    desc = L["Hide In Vehicles Desc"],
                    set = function(info, val) TotemTimers_Settings.HideInVehicle = val TotemTimers_ProcessSetting("HideInVehicle") end,
                    get = function(info) return TotemTimers_Settings.HideInVehicle end,
                },                
                Keybinds = {
                     order = 4,
                   type = "toggle",
                    name = L["Show Key Bindings"],
                    desc = L["Shows key bindings on totem timers"],
                    set = function(info, val) TotemTimers_Settings.ShowKeybinds = val TotemTimers_ProcessSetting("ShowKeybinds") end,
                    get = function(info) return TotemTimers_Settings.ShowKeybinds end,
                },                  
                raidtotems = {
                    order = 55,
                    type = "select",
                    name = L["RaidTotems"],
                    desc = L["RaidTotems Desc"],
                    values = {  [0] = L["none"],                        
                                [66842] = GetSpellInfo(66842),
                                [66843] = GetSpellInfo(66843),
                                [66844] = GetSpellInfo(66844),
                            },
                    set = function(info, val)
                                TotemTimers_Settings.RaidTotemsToCall = val
                          end,
                    get = function(info) return TotemTimers_Settings.RaidTotemsToCall end,
                },
                h1 = {
                    order = 10,
                    type = "header",
                    name = "",
                },
                TimerBarTexture = {
                    order = 15,
                    type = "select",
                    name = L["Timer Bar Texture"],
                    values = AceGUIWidgetLSMlists.statusbar,
                    set = function(info, val) TotemTimers_Settings.TimerBarTexture = val TotemTimers_ProcessSetting("TimerBarTexture") end,
                    get = function(info) return TotemTimers_Settings.TimerBarTexture end,
                    dialogControl = "LSM30_Statusbar",
                },                
                TimeFont = {
                    order = 15,
                    type = "select",
                    name = L["Time Font"] ,
                    values = AceGUIWidgetLSMlists.font,
                    set = function(info, val) TotemTimers_Settings.TimeFont = val TotemTimers_ProcessSetting("TimeFont") end,
                    get = function(info) return TotemTimers_Settings.TimeFont end,
                    dialogControl = "LSM30_Font",
                }, 
                TimeColor = {
                    order = 16,
                    type = "color",
                    name = L["Time Color"],
                    set = function(info, r,g,b)
                        TotemTimers_Settings.TimeColor.r = r
                        TotemTimers_Settings.TimeColor.g = g
                        TotemTimers_Settings.TimeColor.b = b
                        TotemTimers_ProcessSetting("TimeColor")
                    end,
                    get = function(info) return TotemTimers_Settings.TimeColor.r,
                                                TotemTimers_Settings.TimeColor.g,
                                                TotemTimers_Settings.TimeColor.b,
                                                1
                          end,
                },
                TimerBarColor = {
                    order = 17,
                    type = "color",
                    name = L["Timer Bar Color"],
                    hasAlpha = true,
                    set = function(info, r,g,b)
                        TotemTimers_Settings.TimerBarColor.r = r
                        TotemTimers_Settings.TimerBarColor.g = g
                        TotemTimers_Settings.TimerBarColor.b = b
                        TotemTimers_Settings.TimerBarColor.a = a
                        TotemTimers_ProcessSetting("ColorTimerBars")
                    end,
                    get = function(info) return TotemTimers_Settings.TimerBarColor.r,
                                                TotemTimers_Settings.TimerBarColor.g,
                                                TotemTimers_Settings.TimerBarColor.b,
                                                TotemTimers_Settings.TimerBarColor.a
                          end,
                },
                h2 = {
                    order = 70,
                    type = "header",
                    name = "",
                },
                Debug = {
                    order = -1,
                    type = "execute",
                    name = L["Debug"] ,
                    func = function() HideUIPanel(InterfaceOptionsFrame) TotemTimers_DebugScrollFrame:Show() end
                },                
                Reset = {
                    order = -1,
                    type = "execute",
                    name = L["Reset All"] ,
                    func = reset,
                },                
                Resetpos = {
                    order = -1,
                    type = "execute",
                    name = L["Reset Positions"] ,
                    func = resetpos,
                },
            },
        },
    },
}

ACR =	LibStub("AceConfigRegistry-3.0")
ACR:RegisterOptionsTable("TotemTimers", TotemTimers.options)
local ACD = LibStub("AceConfigDialog-3.0")
local frame = ACD:AddToBlizOptions("TotemTimers", "TotemTimers", nil, "general")
frame:SetScript("OnEvent", function(self) InterfaceOptionsFrame:Hide() end)
frame:HookScript("OnShow", function(self) if InCombatLockdown() then InterfaceOptionsFrame:Hide() end TotemTimers.LastGUIPanel = self end)
frame:RegisterEvent("PLAYER_REGEN_DISABLED")



