---------------------------------------------------------------------------
-- Spellsteal Monitor
-- Creates a small frame with stealable spells from your current target.
-- Blinddate (Us-Thrall)
-- Alfabravo (US-Manoroth)
-- Iniitial release commit 01/16/10
-- 1.1 -- .toc bump. 
---------- Thanks to b_buck (@Curse) creator of MageNuggets for the inspiration and some of the code used in this addon. :)
---------------------------------------------------------------------------
local version = 1.1
SSFrame =  nil
SSFrameList = nil

function SS_OnLoad()
	this:RegisterEvent("PLAYER_TARGET_CHANGED")
	this:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
	this:RegisterEvent("UNIT_AURA")
	SSFrameCreate()
	SSFrameUpdate()
end

function SSFrameUpdate()
	local  i = 1
	local stealableBuffs = { }
	local buffName, _, _, _, _, _, _, _, isStealable = UnitAura("target", i, "HELPFUL")
	
	while buffName do
		if (isStealable == 1) then
			stealableBuffs[#stealableBuffs +1] = buffName
		end
		i = i+1
		buffName, _, _, _, _, _, _, _, isStealable = UnitAura("target", i, "HELPFUL")
	end
	if (#stealableBuffs<1) then
		SSFrame:Hide()
	else
		SSFrame:Show()
		stealableBuffs = table.concat(stealableBuffs, "\n")
		SSFrameList.DisplayText:SetText(stealableBuffs)
	end
end

function SS_HandleEvent(self, event, ...)
	--DEFAULT_CHAT_FRAME:AddMessage(event..arg1)
	
	if (event == "PLAYER_TARGET_CHANGED") then
		SSFrameUpdate()
	elseif (event == "COMBAT_LOG_EVENT_UNFILTERED")	 then
		local cEvent, sourceGUID, sourceName, _, destGUID, destName, _ = select(2, ...)
		local spellID = select(12,...)
		
		if (cEvent == "SPELL_STOLEN" and sourceGUID == UnitGUID("player")) then
			if(GetCVar("enableCombatText") == '1') then
				CombatText_AddMessage("Stole:"..GetSpellLink(spellID), CombatText_StandardScroll, 0.10, 0, 1, "sticky", nil);
			end
			DEFAULT_CHAT_FRAME:AddMessage("|cffFFFFFFYou have stolen:"..GetSpellLink(spellID).." from "..destName)
	    	end
	elseif (event == "UNIT_AURA" and arg1 == "target") then
		SSFrameUpdate()
	end
end


function SSFrameCreate()
   
	local backdrop = {bgFile = "Interface\\Tooltips\\UI-Tooltip-Background",edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", edgeSize = 3, left=2, right=2, top=2, bottom=2}
	
	if not SSFrame then
		SSFrame = CreateFrame("Frame", "SSFrame", UIParent)
		SSFrame:SetClampedToScreen(true)
		SSFrame:SetFrameStrata("HIGH")
		SSFrame:SetBackdrop(backdrop)
		SSFrame:SetBackdropColor(0,0,0,1)
		SSFrame:SetWidth(220)
		SSFrame:SetHeight(20) 
		SSFrame:SetPoint("CENTER",0,0)
		SSFrame:EnableMouse(true)
		SSFrame:SetMovable(true)
		SSFrame:RegisterForDrag("RightButton")
		SSFrame:SetUserPlaced(true)
		
		SSFrame:SetScript('OnMouseDown', function(self) 
			self:StartMoving()
			self.IsMoving = true
		end)
		SSFrame:SetScript('OnMouseUp', function(self)
			self:StopMovingOrSizing()
			self.IsMoving = false
		end)
		SSFrame:SetScript("OnShow", function(self)
			SSFrameList:Show()
			end)
		
		SSFrametitle = SSFrame:CreateFontString("SSFrametitletext", "OVERLAY")
		SSFrametitle:SetFont("Fonts\\FRIZQT__.TTF", 12)
		SSFrametitle:SetJustifyH("LEFT")
		SSFrametitle:SetText("SpellSteal Monitor")
		SSFrametitle:SetPoint("TOPLEFT", 0, -4)
		
		SSFrameList = CreateFrame("Frame", "SSFrameList", SSFrame)
		SSFrameList:SetFrameStrata("HIGH")
		SSFrameList:SetPoint("TOPLEFT",0,-21)
		SSFrameList:SetWidth(220)
		SSFrameList:SetHeight(40)
		SSFrameList:SetBackdrop(backdrop)
		SSFrameList:SetBackdropColor(1,0,0,.5)
		SSFrameList:SetBackdropBorderColor(0,0,0)
		SSFrameList.elapsed = 0
		SSFrameList.DisplayText = SSFrameList:CreateFontString("SSFrameListText", "OVERLAY", SSFrameList)
		SSFrameList.DisplayText:SetFont("Fonts\\FRIZQT__.TTF", 10)
		SSFrameList.DisplayText:SetJustifyH("LEFT")
		SSFrameList.DisplayText:SetPoint("LEFT")
	end
end

