-----------------------------------
-----------------------------------
-- SpamSentry by Anea
-----------------------------------
-- options.lua
-- Commandline and FuBar options
-----------------------------------

local L = LibStub("AceLocale-3.0"):GetLocale("SpamSentry")
local AceConfig = LibStub("AceConfig-3.0")
local AceConfigDialog = LibStub("AceConfigDialog-3.0")
local ldb = LibStub:GetLibrary("LibDataBroker-1.1")
local optFrame

-- generic options
local options = {
  type = "group",
  name = "SpamSentry",
  desc = "SpamSentry Options",
  order = 1,
  args = {
    opt = {
      type = "group",
      name = L["options"],
      desc = L["setup this mod to your needs"],
      order = 1,
      args = {
        channels = {
          type = "group",
          order = 1,
          name = L["channel"],
          desc = L["check the channels you want the addon to monitor"],
          args = {
            whisper = {
              type = "toggle",
              name = L["whisper"],
              desc = L["whisper"],
              get = function() return SS.db.profile.channelList[L["whisper"]] end,
              set = function(_,v) SS.db.profile.channelList[L["whisper"]] = v end,
              order = 1,
            },
            say = {
              type = "toggle",
              name = L["say"],
              desc = L["say"],
              get = function() return SS.db.profile.channelList[L["say"]] end,
              set = function(_,v) SS.db.profile.channelList[L["say"]] = v end,
              order = 2,
            },
            yell = {
              type = "toggle",
              name = L["yell"],
              desc = L["yell"],
              get = function() return SS.db.profile.channelList[L["yell"]] end,
              set = function(_,v) SS.db.profile.channelList[L["yell"]] = v end,
              order = 3,
            },  
            emote = {
              type = "toggle",
              name = L["emote"],
              desc = L["emote"],
              get = function() return SS.db.profile.channelList[L["emote"]] end,
              set = function(_,v) SS.db.profile.channelList[L["emote"]] = v end,
              order = 4,
            },
            general = {
              type = "toggle",
              name = L["general"],
              desc = L["general"],
              get = function() return SS.db.profile.channelList[L["general"]] end,
              set = function(_,v) SS.db.profile.channelList[L["general"]] = v end ,
              order = 5,
            },
            trade = {
              type = "toggle",
              name = L["trade"],
              desc = L["trade"],
              get = function() return SS.db.profile.channelList[L["trade"]] end,
              set = function(_,v) SS.db.profile.channelList[L["trade"]] = v end,
              order = 6,
            },
            recruit = {
              type = "toggle",
              name = L["guildrecruitment"],
              desc = L["guildrecruitment"],
              get = function() return SS.db.profile.channelList[L["guildrecruitment"]] end,
              set = function(_,v) SS.db.profile.channelList[L["guildrecruitment"]] = v end,
              order = 7,
            },
            lfg = {
              type = "toggle",
              name = L["lookingforgroup"],
              desc = L["lookingforgroup"],
              get = function() return SS.db.profile.channelList[L["lookingforgroup"]] end,
              set = function(_,v) SS.db.profile.channelList[L["lookingforgroup"]] = v end,
              order = 8,
            },
            defense = {
              type = "toggle",
              name = L["localdefense"],
              desc = L["localdefense"],
              get = function() return SS.db.profile.channelList[L["localdefense"]] end,
              set = function(_,v) SS.db.profile.channelList[L["localdefense"]] = v end,
              order = 9,
            },  
          },
        },
        notification = {
          type = "group",
          name = L["notification"],
          desc = L["set what notifications you would like to see"],
          order = 2,
          args = {
            message = {
              type = "toggle",
              name = L["message"],
              desc = L["show a warning when a message is blocked"],
              order = 2,
              set = function(_,v) SS.db.profile.notifyMessage = v end,
              get = function() return SS.db.profile.notifyMessage end,
            },
            hourly = {
              type = "toggle",
              name = L["hourly"],
              desc = L["show an hourly reminder when messages are waiting to be reported"],
              order = 3,
              set = function(_,v) SS.db.profile.notifyHourly = v end,
              get = function() return SS.db.profile.notifyHourly end,
            },
            debug = {
              type = "toggle",
              name = L["debug"],
              desc = L["show debug messages"],
              order = 5,
              set = function(_,v) SS.db.profile.notifyDebug = v end,
              get = function() return SS.db.profile.notifyDebug end,
            },
          },
        },
        ignorebylevel = {
          type = "range",
          order = 21,
          name = L["ignore by level"],
          desc = L["hide whispers from characters below the set level"],
          min = 1,
          max = 81,
          step = 1,
          set = function(_,v) SS.db.profile.minimumLevel=v end,
          get = function() return SS.db.profile.minimumLevel end,
        },
        delay = {
          type = "toggle",
          name = L["delay"],
          desc = L["toggle the delaying of suspicious messages, to stop multi-message spams from showing"],
          order = 22,
          set = function(_,v) 
            SS.db.profile.enableDelay=v 
            SS:ToggleChatQueue() 
          end,
          get = function() return SS.db.profile.enableDelay end,
        },      
        ignoreinvite = {
          type = "toggle",
          name = L["ignore party invite"],
          desc = L["ignore party invites from people you don't know"],
          order = 22,
          set = function(_,v) SS.db.profile.hidePartyInvite=v end,
          get = function() return SS.db.profile.hidePartyInvite end,
        },      
      },
    },
    modules = {
      type = "group",
      name = L["Modules"],
      desc = L["Modules"],
      args = {}
    },
  },
}
SS.options = options

function SS:SetupOptions()
  -- Load module options (code from Chatter)
  for k, v in self:IterateModules() do
    options.args.modules.args[k:gsub(" ", "_")] = {
      type = "group",
      name = (v.modName or k),
      args = nil
    }
    local t
    if v.GetOptions then
      t = v:GetOptions()
      t.settingsHeader = {
        type = "header",
        name = L["Settings"],
        order = 12
      }   
    end
    t = t or {}
    t.toggle = {
      type = "toggle", 
      name = v.toggleLabel or (L["Enable "] .. (v.modName or k)), 
      desc = v.Info and v:Info() or (L["Enable "] .. (v.modName or k)), 
      order = 11,
      get = function()
        return SS.db.profile.modules[k] ~= false or false
      end,
      set = function(info, v)
        SS.db.profile.modules[k] = v
        if v then
          SS:EnableModule(k)
        else
          SS:DisableModule(k)
        end
      end
    }
    t.header = {
      type = "header",
      name = v.modName or k,
      order = 9
    }
    if v.Info then
      t.description = {
        type = "description",
        name = v:Info() .. "\n\n",
        order = 10
      }
    end
    options.args.modules.args[k:gsub(" ", "_")].args = t
  end 
  -- End of loading module options

  options.args.profile = LibStub("AceDBOptions-3.0"):GetOptionsTable(self.db)
  optFrame = AceConfigDialog:AddToBlizOptions("SpamSentry", "SpamSentry")
  AceConfig:RegisterOptionsTable("SpamSentry", options)
  self:RegisterChatCommand("sentry", SS.OpenConfig)
  self:RegisterChatCommand("spamsentry", SS.OpenConfig)
end


function SS:OpenConfig(input)
  if input == "config" or not InterfaceOptionsFrame:IsResizable() then
    InterfaceOptionsFrame:Hide()
    AceConfigDialog:SetDefaultSize("SpamSentry", 500, 550)
    AceConfigDialog:Open("SpamSentry")
  else
    InterfaceOptionsFrame_OpenToCategory(optFrame)
  end
end