-----------------------------------
-----------------------------------
-- SpamSentry by Anea
-----------------------------------
-- Report.lua
-- Spam management and report functions
-----------------------------------

-----------------------------------
-----------------------------------
-- Initialisation
local mod = SS:NewModule("Report", "AceEvent-3.0")
--local tablet = LibStub:GetLibrary("Tablet-2.0")
local LibQTip = LibStub("LibQTip-1.0")
 
local ldb = LibStub:GetLibrary("LibDataBroker-1.1")
local L = LibStub("AceLocale-3.0"):GetLocale("SpamSentry")

mod.rItemHeight = 55
mod.rShown = 5

function mod:OnInitialize()
  mod:RegisterMessage("SPAMSENTRY_REPORTLIST_UPDATED", "UpdateReportList")

  -- Setup the spam report frame
  local frameName = "SpamSentryUI"
  local item
  local offset = -6

  local item = CreateFrame("Button", frameName .. "Item1", SpamSentryUI, "SpamSentryItem")
  item:SetPoint("TOPLEFT", 10, offset + 10 - mod.rItemHeight)
  item:SetPoint("BOTTOMRIGHT", frameName .. "ScrollFrame", "TOPLEFT", 10, offset - mod.rItemHeight)
  item:SetID(1)
  item.OnEnter = mod.ShowTooltip
  item.OnLeave = mod.HideTooltip
  
  for i=2, mod.rShown, 1 do
    item = CreateFrame("Button", frameName .. "Item" .. i, SpamSentryUI, "SpamSentryItem")
    item:SetPoint("TOPLEFT", frameName .. "Item" .. i-1, "BOTTOMLEFT", 0, offset)
    item:SetPoint("BOTTOMRIGHT", frameName .. "Item" .. i-1, "BOTTOMRIGHT", 0, offset - mod.rItemHeight)
    item:SetID(i)
    item.OnEnter = mod.ShowTooltip
    item.OnLeave = mod.HideTooltip
  end
end

-----------------------------------
-----------------------------------
-- Spam list and edit functions

function mod:RemoveSpam(name, manual)
  local l = SS.spamReportList
  local index = SS:InList(l, name)
  if not index then return end
  if SS.chatHistory[name] then -- Reset the chatcache to prevent re-blocking
    SS.chatHistory[name].message = {}
    SS.chatHistory[name].time = {}
  end
  tremove(SS.spamReportList, index)
  if manual then
    DelIgnore(name)
    tremove(SS.characterBlackList, index)
  end
  mod:UpdateReportList()
  SS:Msg(0, format(L["%s has been removed"], name))
  SS:SendMessage("SPAMSENTRY_REPORTLIST_UPDATED")
end

function mod:ClearSpam(num, manual)
  if num==0 then
    num = getn(SS.spamReportList)
  end
  for i=1, num, 1 do
    local name = SS.spamReportList[1].player
    if SS.chatHistory[name] then -- Reset the chatcache to prevent re-blocking
      SS.chatHistory[name].message = {}
      SS.chatHistory[name].time = {}
    end
    tremove(SS.spamReportList, 1)
    if manual then
      DelIgnore(name)
      tremove(SS.characterBlackList, 1)
    end
  end
  mod:UpdateReportList()
  SS:Msg(0, format(L["Reportlist cleared (%s items)"], num))
  SS:SendMessage("SPAMSENTRY_REPORTLIST_UPDATED")
end

-----------------------------------
-----------------------------------
-- Ticket / Report functions

function mod:SendSpamReport()
  local l = SS.spamReportList
  for i=1, getn(l),1 do
    if l[i].id then
     ComplainChat(l[i].id)
    else
      SS:Msg(0, "No ID for: "..l[i].message)
    end
  end
  mod:ClearSpam(0)
  SS:SendMessage("SPAMSENTRY_REPORTLIST_UPDATED")
end

-- Show the SpamSentry ticketframe GUI
function mod:ShowGUI(t)
  if (t=="feedback") then
    SpamSentry_TicketHelpText:SetText(L["SSGUIHELP_FEEDBACK"])
    SpamSentry_TicketEditBox:SetText(mod:FeedBackText())
    SpamSentryUITicketParent:Show()
  else
    SpamSentrySend:SetText(SEND_LABEL)
    SpamSentryClear:SetText(CLEAR_ALL)
    SpamSentry_HelpText:SetText(L["SSGUIHELP"])  
    SpamSentryUIParent:Show()
  end
end

-----------------------------------
-----------------------------------
-- Feedback functions

function mod:FeedBackText()
  local ret = ""
  if SS.spamFeedbackList then
    for i,v in pairs(SS.spamFeedbackList) do
      ret = ret .. mod:StringToHex(v).."\n\n"
    end
  end
  return ret
end

local str2hex = {"0","1","2","3","4","5","6","7","8","9","A","B","C","D","E","F"}
function mod:StringToHex(s)
  local ret, b, n, m = "", 0, 0 ,0
  for i=1, strlen(s), 1 do
    b = strbyte(s, i)
    n = b - 16 * floor(b/16)
    m = (b - n) / 16
    ret = ret..str2hex[m+1]..str2hex[n+1]
  end
  return ret
end

-----------------------------------
-----------------------------------
-- GUI functions

function mod:ShowTooltip(item)
  local id = item:GetID()
  mod.tooltip = LibQTip:Acquire("SpamSentry_Report", 2, "LEFT", "RIGHT")
  mod.tooltip:AddLine(NAME, SS.spamReportList[id].player)
  mod.tooltip:AddLine(L["Date / time"], SS.spamReportList[id].time)
  mod.tooltip:AddLine(L["Channel"],     SS.spamReportList[id].type)
  mod.tooltip:AddLine(L["Message-ID"],  SS.spamReportList[id].id or "|cffff0000n/a|r")
  mod.tooltip:AddLine(" ", " ")
  mod.tooltip:AddLine("|cffffff00"..L["Click to copy message\n<CTRL>-Click to remove message"].."|r")
  mod.tooltip:SmartAnchorTo(item)
  mod.tooltip:Show()
end

function mod:HideTooltip()
  LibQTip:Release(mod.tooltip)
  mod.tooltip = nil
end

function mod:OnMousewheel(scrollframe, direction)
  local scrollbar = getglobal(scrollframe:GetName() .. "ScrollBar")
  scrollbar:SetValue(scrollbar:GetValue() - direction * (scrollbar:GetHeight() / 2))
  mod:UpdateReportList()
end

function mod:UpdateReportList()
  local size = getn(SS.spamReportList)
  FauxScrollFrame_Update(SpamSentryUIScrollFrame, size, mod.rShown, mod.rShown)

  local offset = SpamSentryUIScrollFrame.offset
  for index = 1, mod.rShown, 1 do
    local i = index + offset
    local item = getglobal("SpamSentryUIItem".. index)

    if i <= size then
      item:SetText(format("|cffffff00[%02d] %s: |cffffffff%s|r",i,SS.spamReportList[i].player, SS.spamReportList[i].message))
      item:SetID(i)
      item:Show()
    else
      item:Hide()
    end
  end
  
  SpamSentry_Counter:SetText(format(L["[Items on reportlist: %s]"], size))
end

-- Show a dialog box with given text. Executes the given functions on accept/cancel.
-- Blizzard has a weird popup ui. Some of this code was taken from Prat UrlCopy
function mod:ShowCopyPopup(message)
  StaticPopupDialogs["SPAMSENTRY_NOTIFICATION"] = {
    text = L["Message:"],
    button2 = CLOSE,
    hasEditBox = 1,
    hasWideEditBox = 1,
    showAlert = 1,
    maxLetters = 255,
    OnAccept = function() end,
    timeout = 0,
    whileDead = 1,
    exclusive=1,
    hideOnEscape = 1,
    OnShow = function()
      getglobal(this:GetName().."WideEditBox"):SetText(message)
      getglobal(this:GetName().."WideEditBox"):SetFocus()
      getglobal(this:GetName().."WideEditBox"):HighlightText()

      local button = getglobal(this:GetName().."Button2")
      button:ClearAllPoints()
      button:SetWidth(200)
      button:SetPoint("CENTER", getglobal(this:GetName().."WideEditBox"), "CENTER", 0, -30)
      getglobal(this:GetName().."AlertIcon"):Hide()
    end,
    EditBoxOnEscapePressed = function()
        this:GetParent():Hide()
    end,

  };
  StaticPopup_Show ("SPAMSENTRY_NOTIFICATION")
end

function mod:Info()
  return L["Allows you to easily report blocked messages to Blizzard."]
end