-----------------------------------
-----------------------------------
-- SpamSentry by Anea
-----------------------------------
-- compatibility.lua
-- Provides hacks to force compatibility with other addons
-----------------------------------

function SS:Compat_Enable()
  -- WIM
  if IsAddOnLoaded("WIM") then  
    self:RawHook(WIM.modules["WhisperEngine"], "CHAT_MSG_WHISPER", "Compat_WIM_CHAT_MSG_WHISPER", true)  
  end

  -- Whisp
  if IsAddOnLoaded("Whisp") then
    self:RawHook(Whisp, "UpdateChatHistory", SS.Compat_Whisp_UpdateChatHistory, true)
  end
  
  -- Chatter
  if IsAddOnLoaded("Chatter") and Chatter:GetModule("Highlights"):IsEnabled() then
    self:RawHook(Chatter:GetModule("Highlights"), "ParseChat", "Compat_ChatterHighlights_ParseChat", true)
  end
end


-----------------------------------
-- WIM
-- Tested with 3.0.5
function SS:Compat_WIM_CHAT_MSG_WHISPER(...)
  SS:ChatFrame_MessageEventHandler("CHAT_MSG_WHISPER", function(...) self.hooks[WIM.modules["WhisperEngine"]]["CHAT_MSG_WHISPER"](...) end)  
end

-----------------------------------
-- Whisp 
-- Tested with 20090118
function SS:Compat_Whisp_UpdateChatHistory(msg, plr, snd, incoming)
  if incoming then
    SS:ChatFrame_MessageEventHandler("CHAT_MSG_WHISPER", function() SS.hooks[Whisp]["UpdateChatHistory"](Whisp, arg1, arg2, arg2, true, arg12) end)
  else
    SS.hooks[Whisp]["UpdateChatHistory"](Whisp, msg, plr, snd, false, arg12)
  end
end

-----------------------------------
-- Chatter Highlights
-- Tested with r220
function SS:Compat_ChatterHighlights_ParseChat(obj, event, msg, snd)
  SS:ChatFrame_MessageEventHandler(event, function(event) SS.hooks[Chatter:GetModule("Highlights")]["ParseChat"](Chatter:GetModule("Highlights"), event, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12) end)
end
