﻿--Globals
Spammy = { };
Spammy["frames"] = { nil, nil };
Spammy["debugmode"] = false;
Spammy["switches"] = { false, false, false};
Spammy["messages"] = { "", "", "" };
Spammy["interval"] = "0";
Spammy["channel"] = "";
Spammy["lastSpammed"] = 0;

--Event handling
local eventFrame = CreateFrame("Frame");
eventFrame:RegisterEvent("VARIABLES_LOADED");
eventFrame:RegisterEvent("PLAYER_LOGOUT");
eventFrame:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
function eventFrame:OnEvent(event, ...)
	if event == "VARIABLES_LOADED" then
		if SpammyConfig ~= nil then
			if SpammyConfig["message1"] ~= nil then Spammy["messages"][1] = SpammyConfig["message1"]; end
			if SpammyConfig["message2"] ~= nil then Spammy["messages"][2] = SpammyConfig["message2"]; end
			if SpammyConfig["message3"] ~= nil then Spammy["messages"][3] = SpammyConfig["message3"]; end
			if SpammyConfig["switch1"] ~= nil then Spammy["switches"][1] = SpammyConfig["switch1"]; end
			if SpammyConfig["switch2"] ~= nil then Spammy["switches"][2] = SpammyConfig["switch2"]; end
			if SpammyConfig["switch3"] ~= nil then Spammy["switches"][3] = SpammyConfig["switch3"]; end
			if SpammyConfig["interval"] ~= nil then Spammy["interval"] = SpammyConfig["interval"]; end
			ShowDebug("Loading variables");
		end
	elseif event == "PLAYER_LOGOUT" then
		SpammyConfig = { };
		SpammyConfig["message1"] = SpammyOptionsEdit1:GetText();
		SpammyConfig["message2"] = SpammyOptionsEdit2:GetText();
		SpammyConfig["message3"] = SpammyOptionsEdit3:GetText();
		SpammyConfig["switch1"] = toboolean(SpammyOptionsSwitch1:GetChecked());
		SpammyConfig["switch2"] = toboolean(SpammyOptionsSwitch2:GetChecked());
		SpammyConfig["switch3"] = toboolean(SpammyOptionsSwitch3:GetChecked());
		SpammyConfig["interval"] = SpammyOptionsIntervalValue:GetText();
		ShowDebug("Saving variables");
	elseif event == "CHAT_MSG_CHANNEL_NOTICE" then
		local arg1, arg2, arg3, arg4 = ...;
		ShowDebug(arg1 .. " " .. arg4);
		if arg1 == "YOU_LEFT" and arg4 == Spammy["channel"] and SpammyOptionsStop:IsEnabled() then
			SpammyOptionsStop_OnClick();
			SpammyOptionsChannelButton:SetText(SpammyStrings.ChannelSelect);
			UIDropDownMenu_SetSelectedID(ChannelsMenu, 1);
		end
	end
end
eventFrame:SetScript("OnEvent", eventFrame.OnEvent);

--Functions
function GetLink(lnk)
	if SpammyOptionsEdit1:HasFocus() then
		SpammyOptionsEdit1:Insert(lnk);
	elseif SpammyOptionsEdit2:HasFocus() then
		SpammyOptionsEdit2:Insert(lnk);
	elseif SpammyOptionsEdit3:HasFocus() then
		SpammyOptionsEdit3:Insert(lnk);
	else
		ChatEdit_InsertLink_old(lnk);
	end
end

function SpammingNow()
	if time() - Spammy["lastSpammed"] >= tonumber(Spammy["interval"]) then
		if Spammy["messages"][1] ~= "" then
			SendChatMessage(Spammy["messages"][1], "CHANNEL", nil, Spammy["channel"]);
		end
		if Spammy["messages"][2] ~= "" then
			SendChatMessage(Spammy["messages"][2], "CHANNEL", nil, Spammy["channel"]);
		end
		if Spammy["messages"][3] ~= "" then
			SendChatMessage(Spammy["messages"][3], "CHANNEL", nil, Spammy["channel"]);
		end
		Spammy["lastSpammed"] = time();
	end
end

SlashCmdList["SPAMMYY"] = function(str)
	ShowDebug("Slash command has been typed");
	local cmd = string.lower(str)
	if cmd == "debug" then
		Spammy["debugmode"] = not Spammy["debugmode"];
	if Spammy["debugmode"] then
		print("Spammy: |cffFF0000DEBUG ON|r");
	else
		print("Spammy: |cffFF0000DEBUG OFF|r");
	end
	else
		ShowFrame();
	end
end

function ShowFrame()
	if Spammy["frames"][1] == nil then
		Spammy["frames"][1] = CreateFrame("Frame", "SpammyOptions", UIParent, "SpammyOptions");
		SpammyOptionsEdit1:SetText(Spammy["messages"][1]);
		SpammyOptionsEdit2:SetText(Spammy["messages"][2]);
		SpammyOptionsEdit3:SetText(Spammy["messages"][3]);
		SpammyOptionsIntervalValue:SetText(Spammy["interval"]);
		if Spammy["switches"][1] then SpammyOptionsSwitch1:SetChecked(); end
		if Spammy["switches"][2] then SpammyOptionsSwitch2:SetChecked(); end
		if Spammy["switches"][3] then SpammyOptionsSwitch3:SetChecked(); end
		Spammy["messages"][1] = "";
		Spammy["messages"][2] = "";
		Spammy["messages"][3] = "";
		Spammy["interval"] = "0";
		Spammy["switches"][1] = false;
		Spammy["switches"][2] = false;
		Spammy["switches"][3] = false;
		ShowDebug("Creating the frame");
	end
	Spammy["frames"][1]:Show();
	ShowDebug("Showing the frame");
end

function HideFrame()
	if Spammy["frames"][1] ~= nil then
		Spammy["frames"][1]:Hide();
		ShowDebug("Hiding the frame");
	end
end

function ShowDebug(text)
	if Spammy["debugmode"] and text then
		print("|cffFF0000Spammy debug message:|r " .. text);
	end
end

function ShowError(text)
	if (text) then
		SpammyOptionsError:SetText(text);
	end
end

function Trim(s)
	return (s:gsub("^%s*(.-)%s*$", "%1"));
end

function toboolean(value)
  return not not value
end

function SpammyOptions_OnLoad()
	SpammyOptions:SetMovable(true);
	ChannelsDropdown = CreateFrame("Frame", "ChannelsMenu", Spammy["frames"][1], "UIDropDownMenuTemplate");
	ChannelsDropdown.point = "TOPLEFT";
	ChannelsDropdown.relativePoint = "TOPRIGHT";
	ChannelsDropdown.displayMode = "MENU";
	ChannelsDropdown.relativeTo = SpammyOptionsChannelButton;
	UIDropDownMenu_Initialize(ChannelsMenu, function(self) ChannelsMenu_Initialize(self) end, "MENU");
	UIDropDownMenu_SetSelectedID(ChannelsMenu, 1);
	UIDropDownMenu_SetWidth(ChannelsDropdown, 90);
	ChatEdit_InsertLink_old=ChatEdit_InsertLink;
	ChatEdit_InsertLink=GetLink;
	SpammyOptionsStop:Disable();
	Localize();
	ShowError("");
	local channels = { GetChannelList() };
	ShowDebug("Spammy has been loaded. Found " .. tostring(#channels/2) .. " channels.");
end

function Localize()
	SpammyOptionsTitle:SetText(SpammyStrings.Title);
	SpammyOptionsMessage1:SetText(SpammyStrings.Message1);
	SpammyOptionsMessage2:SetText(SpammyStrings.Message2);
	SpammyOptionsMessage3:SetText(SpammyStrings.Message3);
	SpammyOptionsInterval:SetText(SpammyStrings.Interval);
	SpammyOptionsChannel:SetText(SpammyStrings.Channel);
	SpammyOptionsChannelButton:SetText(SpammyStrings.ChannelSelect);
	SpammyOptionsStart:SetText(SpammyStrings.Start);
	SpammyOptionsStop:SetText(SpammyStrings.Stop);
	SpammyOptionsOk:SetText(SpammyStrings.Ok);
	if SpammyStrings.Localizer == "" then
		SpammyOptionsCredits:SetText(SpammyStrings.Author .. "");
	else
		SpammyOptionsCredits:SetText(SpammyStrings.Author .. " " .. SpammyStrings.Localizer); 
	end
end

function ChannelsMenu_Initialize()
	local channels = { GetChannelList(); }
	local channels_user = {};
	local iter = 0;
	for i,title in ipairs(channels) do
		if i % 2 ~= 0 then
			iter = iter + 1;
			channels_user[iter] = title;
		else
			channels_user[iter] = channels_user[iter] .. ". " .. title;
			ShowDebug("Found channel " .. channels_user[iter]);
		end
	end
	for i, title in ipairs(channels_user) do
		local info = UIDropDownMenu_CreateInfo();
		info.text = title;
		info.value = i;
		info.owner = ChannelsDropdown;
		info.func = function(self) OnChannelsMenuClick(self) end;
		UIDropDownMenu_AddButton(info);
	end
end

function OnChannelsMenuClick(self)
	UIDropDownMenu_SetSelectedValue(self.owner, self.value);
	local menuText = UIDropDownMenu_GetText(ChannelsDropdown);
	ShowDebug("Selected channel: [" .. self.value .. "] : " .. menuText);
	SpammyOptionsChannelButton:SetText(menuText);
end

function SpammyOptionsChannelButton_OnClick()
	ToggleDropDownMenu(1, nil, ChannelsDropdown, "SpammyOptionsChannelButton", 0, 0);
end

function SpammyOptionsStart_OnClick()
	Spammy["messages"][1] = "";
	Spammy["messages"][2] = "";
	Spammy["messages"][3] = "";
	Spammy["interval"] = "0";
	Spammy["channel"] = "";
	Spammy["lastSpammed"] = 0;
	if (SpammyOptionsSwitch1:GetChecked() or
	SpammyOptionsSwitch2:GetChecked() or
	SpammyOptionsSwitch3:GetChecked()) == nil then
		ShowError(SpammyStrings.ErrorNothing);
		return;
	end
	if SpammyOptionsSwitch1:GetChecked() then
		Spammy["messages"][1] = SpammyOptionsEdit1:GetText();
		if Spammy["messages"][1] ~= nil and Trim(Spammy["messages"][1]) ~= "" then
			ShowDebug("Message 1: " .. Spammy["messages"][1]);
		else 
			ShowError(SpammyStrings.ErrorNoMessage1);
			return;
		end
	end
	if SpammyOptionsSwitch2:GetChecked() then
		Spammy["messages"][2] = SpammyOptionsEdit2:GetText();
		if Spammy["messages"][2] ~= nil and Trim(Spammy["messages"][2]) ~= "" then
			ShowDebug("Message 2: " .. Spammy["messages"][2]);
		else
			ShowError(SpammyStrings.ErrorNoMessage2);
			return;
		end
	end
	if SpammyOptionsSwitch3:GetChecked() then
		Spammy["messages"][3] = SpammyOptionsEdit3:GetText();
		if Spammy["messages"][3] ~= nil and Trim(Spammy["messages"][3]) ~= "" then
			ShowDebug("Message 3: " .. Spammy["messages"][3]);
		else
			ShowError(SpammyStrings.ErrorNoMessage3);
			return;
		end
	end
	Spammy["interval"] = SpammyOptionsIntervalValue:GetText();
	if tonumber(Spammy["interval"]) == nil or tonumber(Spammy["interval"]) < 30 then
		ShowError(SpammyStrings.ErrorIncorrectInterval);
		return;
	end
	Spammy["channel"] = SpammyOptionsChannelButton:GetText();
	if Spammy["channel"] == SpammyStrings.ChannelSelect then
		ShowError(SpammyStrings.ErrorNoChannel);
		return;
	end
	ShowError("");
	SpammyOptionsStop:Enable();
	SpammyOptionsStart:Disable();
	SpammyOptionsSwitch1:Disable();
--	SpammyOptionsEdit1:Disable();
	SpammyOptionsSwitch2:Disable();
--	SpammyOptionsEdit2:Disable();
	SpammyOptionsSwitch3:Disable();
--	SpammyOptionsEdit3:Disable();
--	SpammyOptionsIntervalValue:Disable();
	SpammyOptionsChannelButton:Disable();
	if (Spammy["frames"][2] == nil) then
		Spammy["frames"][2] = CreateFrame("Frame");
		ShowDebug("Spamming frame has been created");
	end
	Spammy["frames"][2]:SetScript("OnUpdate", SpammingNow);
	ShowDebug("Spamming initiated in channel " .. Spammy["channel"] .. " with interval " .. Spammy["interval"]);
	--Start spamming
end

function SpammyOptionsOk_OnClick()
	HideFrame();
end

function SpammyOptionsStop_OnClick()
	--Halt spamming
	Spammy["frames"][2]:SetScript("OnUpdate", nil);
	ShowDebug("Spamming has been stopped!");
	Spammy["messages"][1] = "";
	Spammy["messages"][2] = "";
	Spammy["messages"][3] = "";
	Spammy["interval"] = "0";
	Spammy["channel"] = "";
	SpammyOptionsStart:Enable();
	SpammyOptionsStop:Disable();
	SpammyOptionsSwitch1:Enable();
--	SpammyOptionsEdit1:Enable();
	SpammyOptionsSwitch2:Enable();
--	SpammyOptionsEdit2:Enable();
	SpammyOptionsSwitch3:Enable();
--	SpammyOptionsEdit3:Enable();
--	SpammyOptionsIntervalValue:Enable();
	SpammyOptionsChannelButton:Enable();
end

function SpammyOptions_OnMouseDown()
		SpammyOptions:StartMoving();
end

function SpammyOptions_OnMouseUp()
		SpammyOptions:StopMovingOrSizing();
end

--Slash commands
SLASH_SPAMMYY1 = "/spammy"