--$Revision: 182 $
--$Date: 2010-01-10 03:45:36 +0000 (Sun, 10 Jan 2010) $
--project version: 3.1.3
local LSM = LibStub("LibSharedMedia-3.0")
local floor = math.floor
local pairs = pairs
local timercount = 0

local lastUpdate = 0
local function SMD_OnUpdate(self, elapsed)
	local doslow
	lastUpdate = lastUpdate + elapsed
	if lastUpdate > 0.04 then
		doslow = true
		lastUpdate = 0
	end
	
	local t
	for k, v in pairs(SimpleMD.timerbars) do
		if not t then t = GetTime() end
		if (not doslow) and v.slow then
			--do nothing
		elseif v.running then
			v.elapsed = t - v.start
			if v.redirecting then v.redirectElapsed = t - v.redirectStart end
			if v.stop <= t then
				SimpleMD:StopTimerBar(k)
			else
				SimpleMD:UpdateTimerBar(k)
			end
		end
	end	
end

function SimpleMD:ClearTimerBars()
	for i = table.getn(self.timerbars), 1, -1 do
		self.timerbars[i]:Hide()
		self.idents[self.timerbars[i].caster] = nil
		table.insert(self.recyclePile, table.remove(self.timerbars))
		timercount = timercount - 1
	end
end

function SimpleMD:ReadinessCheck(name)
	if self.idents[name] then
		local reverse = self.idents[name].reversed
		self.idents[name].timer:SetValue(reverse and 1 or 0)
		--self:StopTimerBar(self.idents[name])
		for k, v in pairs(self.timerbars) do
			if v == name then
				self:StopTimerBar(k)
				return
			end
		end
	end
end

function SimpleMD:UpdateTimerBar(index)
	local t = self.timerbars[index].time - self.timerbars[index].elapsed
	self.timerbars[index].slow = t > 11
	
	if self.timerbars[index].redirecting then
		self:UpdateRedirectBar(index)
	end
	
	local newtimetext
	
	local h = floor(t/3600)
	local m = t - (h*3600)
	m = floor(m/60)
	local s = t - ((h*3600) + (m*60))
	
	if s < 10 then
		newtimetext = string.format("%1.1f", s)
	else
		newtimetext = string.format("%.0f", floor(s))
	end
	
	self.timerbars[index].timetext:SetText(newtimetext)
	
	local percent = t / self.timerbars[index].time
	local reverse = self.timerbars[index].reversed
	self.timerbars[index].timer:SetValue(reverse and 1-percent or percent)
end

function SimpleMD:UpdateRedirectBar(index)
	local t = 4 - self.timerbars[index].redirectElapsed
	
	local h = floor(t/3600)
	local m = t - (h*3600)
	m = floor(m/60)
	local s = t - ((h*3600) + (m*60))
	
	local newtimetext = string.format("%1.1f", s)
	
	self.timerbars[index].redirecttext:SetText(newtimetext)
	
	local percent = t / 4
	local reverse = self.timerbars[index].reversed
	self.timerbars[index].redirect:SetValue(reverse and 1-percent or percent)
end

function SimpleMD:StopTimerBar(index)
	self.timerbars[index].running = false
	if not self.timerbars[index].stayonscreen then
		for k, v in pairs(self.timerbars) do
			if k == 1 then
				--nothing
			elseif k == 2 then
				if self.timerbars[index].growup then
					self.timerbars[k]:ClearAllPoints()
					self.timerbars[k]:SetPoint("BOTTOM", self.frame, "TOP", 10, -5)
				else
					self.timerbars[k]:ClearAllPoints()
					self.timerbars[k]:SetPoint("TOP", self.frame, "BOTTOM", 10, 5)
				end
			else
				if self.timerbars[index].growup then
					self.timerbars[k]:ClearAllPoints()
					self.timerbars[k]:SetPoint("BOTTOM", self.timerbars[k-1], "TOP", 0, 0)
				else
					self.timerbars[k]:ClearAllPoints()
					self.timerbars[k]:SetPoint("TOP", self.timerbars[k-1], "BOTTOM", 0, 0)
				end
			end
		end
		self:RecycleTimerBar(index)
	else
		self.timerbars[index].timetext:SetText("")
		local i = string.find(self.timerbars[index].text:GetText(), " ")
		local temp = string.sub(self.timerbars[index].text:GetText(), 1, i-1)
		self.timerbars[index].text:SetJustifyH("CENTER")
		self.timerbars[index].text:SetText(temp.." ready!")
	end
end

function SimpleMD:RecycleTimerBar(index)
	local alias = self.timerbars[index]
	if not alias then return end
	
	alias:Hide()
	timercount = timercount - 1
	table.insert(self.recyclePile, alias)
	self.idents[self.timerbars[index].caster] = nil
	table.remove(self.timerbars, index)
end

function SimpleMD:ReanchorTimerBars(growth)
	for k, v in pairs(self.timerbars) do
		if k == 1 then
			if growth then
				self.timerbars[k]:ClearAllPoints()
				self.timerbars[k]:SetPoint("BOTTOM", self.frame, "TOP", 10, -5)
				self.timerbars[k].growup = growth
			else
				self.timerbars[k]:ClearAllPoints()
				self.timerbars[k]:SetPoint("TOP", self.frame, "BOTTOM", 10, 5)
				self.timerbars[k].growup = growth
			end
		elseif k >= 2 then
			if growth then
				self.timerbars[k]:ClearAllPoints()
				self.timerbars[k]:SetPoint("BOTTOM", self.timerbars[k-1], "TOP", 0, 0)
				self.timerbars[k].growup = growth
			else
				self.timerbars[k]:ClearAllPoints()
				self.timerbars[k]:SetPoint("TOP", self.timerbars[k-1], "BOTTOM", 0, 0)
				self.timerbars[k].growup = growth
			end
		end
	end
end

function SimpleMD:RefreshTimerBar(alias, caster, target, runtime, reverse, stay, growth)
	alias.timer:SetStatusBarColor(self.db.profile.barR, self.db.profile.barG, self.db.profile.barB, 1)
	alias.timerbg:SetVertexColor(self.db.profile.BGr, self.db.profile.BGg, self.db.profile.BGb)
	alias.timerbg:SetAlpha(self.db.profile.bg_alpha)
	alias.timer:SetValue(1)
	alias.text:SetJustifyH("LEFT")
	if target then
		alias.text:SetText(caster.." - "..target)
		alias.text2:SetText(caster.." - "..target)
	else
		alias.text:SetText(caster)
		alias.text2:SetText(caster)
	end
	alias.timetext:SetText(runtime)
	alias.timer:SetStatusBarTexture(LSM:Fetch('statusbar', self.db.profile.texture))
	alias.timerbg:SetTexture(LSM:Fetch('statusbar', self.db.profile.texture))
	
	alias.redirect:SetStatusBarColor(self.db.profile.tbarR, self.db.profile.tbarG, self.db.profile.tbarB, 1)
	alias.redirectbg:SetVertexColor(self.db.profile.tBGr, self.db.profile.tBGg, self.db.profile.tBGb)
	alias.redirectbg:SetAlpha(self.db.profile.bg_alpha)
	alias.redirect:SetValue(1)
	alias.redirect:SetStatusBarTexture(LSM:Fetch('statusbar', self.db.profile.texture))
	alias.redirectbg:SetTexture(LSM:Fetch('statusbar', self.db.profile.texture))
	alias.redirecttext:SetText("4")
	
	local curTime = GetTime()
	alias.start = curTime
	alias.stop = curTime + runtime
	alias.elapsed = 0
	alias.redirectElapsed = 0
	alias.time = runtime
	alias.running = true
	alias.redirecting = false
	alias.reversed = reverse
	alias.stayonscreen = stay
end

local function DisableMouse(Frame)
	if Frame:IsMouseEnabled() then
		Frame:EnableMouse(false)
	end
	if Frame:GetChildren() then
		for _,child in pairs({Frame:GetChildren()}) do
			if child:IsMouseEnabled() then
				child:EnableMouse(false)
			end
			DisableMouse(child)
		end 
	end
end

function SimpleMD:CreateTimerBar(caster, target, runtime, reverse, stay, growth)
	--strip off server names, otherwise text can overrun the bar
	if target then target = strsplit("-", target) end
	
	if self.idents[caster] then
		self:RefreshTimerBar(self.idents[caster], caster, target, runtime, reverse, stay, growth)
		return
	end
	
	timercount = timercount + 1
	
	local t
	if #self.recyclePile > 0 then
		t = table.remove(self.recyclePile)
	else
		t = CreateFrame("BUTTON", nil, self.frame)
	end
	
	t:SetWidth(self.db.profile.barWidth * self.db.profile.barScale)
	t:SetHeight(self.db.profile.barHeight * self.db.profile.barScale)
	t:ClearAllPoints()
	if timercount == 1 then
		if growth then
			t:SetPoint("BOTTOM", self.frame, "TOP", 10, -5)
		else
			t:SetPoint("TOP", self.frame, "BOTTOM", 10, 5)
		end
	else
		if growth then
			t:SetPoint("BOTTOM", self.timerbars[timercount-1], "TOP", 0, 0)
		else
			t:SetPoint("TOP", self.timerbars[timercount-1], "BOTTOM", 0, 0)
		end
	end
	
	if not t.timer then
		t.timer = CreateFrame("STATUSBAR", nil, t)
	end
	t.timer:ClearAllPoints()
	t.timer:SetPoint("TOPLEFT", t, "TOPLEFT")
	t.timer:SetPoint("BOTTOMRIGHT", t, "BOTTOMRIGHT")
	t.timer:SetStatusBarTexture(LSM:Fetch('statusbar', self.db.profile.texture))
	t.timer:SetStatusBarColor(self.db.profile.barR, self.db.profile.barG, self.db.profile.barB, 1)
	t.timer:SetMinMaxValues(0, 1)
	t.timer:SetValue(1)
	
	if not t.timerbg then
		t.timerbg = t.timer:CreateTexture(nil, "BACKGROUND")
	end
	t.timerbg:ClearAllPoints()
	t.timerbg:SetAllPoints(t.timer)
	t.timerbg:SetTexture(LSM:Fetch('statusbar', self.db.profile.texture))
	t.timerbg:SetVertexColor(self.db.profile.BGr, self.db.profile.BGg, self.db.profile.BGb)
	t.timerbg:SetAlpha(self.db.profile.bg_alpha)
	
	if not t.redirect then
		t.redirect = CreateFrame("STATUSBAR", nil, t)
	end
	t.redirect:ClearAllPoints()
	t.redirect:SetPoint("TOPLEFT", t, "TOPLEFT")
	t.redirect:SetPoint("BOTTOMRIGHT", t, "BOTTOMRIGHT")
	t.redirect:SetStatusBarTexture(LSM:Fetch('statusbar', self.db.profile.texture))
	t.redirect:SetStatusBarColor(self.db.profile.tbarR, self.db.profile.tbarG, self.db.profile.tbarB, 1)
	t.redirect:SetMinMaxValues(0, 1)
	t.redirect:SetValue(1)
	t.redirect:Hide()
	
	if not t.redirectbg then
		t.redirectbg = t.redirect:CreateTexture(nil, "BACKGROUND")
	end
	t.redirectbg:ClearAllPoints()
	t.redirectbg:SetAllPoints(t.redirect)
	t.redirectbg:SetTexture(LSM:Fetch('statusbar', self.db.profile.texture))
	t.redirectbg:SetVertexColor(self.db.profile.tBGr, self.db.profile.tBGg, self.db.profile.tBGb)
	t.redirectbg:SetAlpha(self.db.profile.bg_alpha)
	
	if not t.icon then
		t.icon = t:CreateTexture()
	end
	t.icon:SetTexture(self.tex)
	t.icon:ClearAllPoints()
	t.icon:SetPoint("RIGHT", t, "LEFT", 0, 0)
	t.icon:SetTexCoord(.07, .93, .07, .93)
	t.icon:SetWidth(self.db.profile.barHeight * self.db.profile.barScale)
	t.icon:SetHeight(self.db.profile.barHeight * self.db.profile.barScale)
	
	if not t.text then
		t.text = t.timer:CreateFontString(nil, "LOW")
	end
	t.text:SetWidth(self.db.profile.barWidth * self.db.profile.barScale)
	t.text:SetHeight(self.db.profile.barHeight * self.db.profile.barScale)
	t.text:SetFont(LSM:Fetch('font', self.db.profile.font), self.db.profile.textSize)
	t.text:SetTextColor(self.db.profile.txtR, self.db.profile.txtG, self.db.profile.txtB, 1)
	t.text:SetJustifyH("LEFT")
	t.text:SetJustifyV("MIDDLE")
	t.text:ClearAllPoints()
	t.text:SetPoint("TOP", t.timer, "TOP", 5, 0)
	if target then
		t.text:SetText(caster.."  -  "..target)
	else
		t.text:SetText(caster)
	end
	
	if not t.timetext then
		t.timetext = t.timer:CreateFontString(nil, "LOW")
	end
	t.timetext:SetWidth(self.db.profile.barWidth * self.db.profile.barScale)
	t.timetext:SetHeight(self.db.profile.barHeight * self.db.profile.barScale)
	t.timetext:SetFont(LSM:Fetch('font', self.db.profile.font), self.db.profile.textSize)
	t.timetext:SetTextColor(self.db.profile.txtR, self.db.profile.txtG, self.db.profile.txtB, 1)
	t.timetext:SetJustifyH("RIGHT")
	t.timetext:SetJustifyV("MIDDLE")
	t.timetext:ClearAllPoints()
	t.timetext:SetPoint("TOP", t.timer, "TOP", -5, 0)
	t.timetext:SetText(runtime)
	t.timetext:Show()
	
	if not t.text2 then
		t.text2 = t.redirect:CreateFontString(nil, "LOW")
	end
	t.text2:SetWidth(self.db.profile.barWidth * self.db.profile.barScale)
	t.text2:SetHeight(self.db.profile.barHeight * self.db.profile.barScale)
	t.text2:SetFont(LSM:Fetch('font', self.db.profile.font), self.db.profile.textSize)
	t.text2:SetTextColor(self.db.profile.txtR, self.db.profile.txtG, self.db.profile.txtB, 1)
	t.text2:SetJustifyH("LEFT")
	t.text2:SetJustifyV("MIDDLE")
	t.text2:ClearAllPoints()
	t.text2:SetPoint("TOP", t.redirect, "TOP", 5, 0)
	if target then
		t.text2:SetText(caster.."  -  "..target)
	else
		t.text2:SetText(caster)
	end
	
	if not t.redirecttext then
		t.redirecttext = t.redirect:CreateFontString(nil, "LOW")
	end
	t.redirecttext:SetWidth(self.db.profile.barWidth * self.db.profile.barScale)
	t.redirecttext:SetHeight(self.db.profile.barHeight * self.db.profile.barScale)
	t.redirecttext:SetFont(LSM:Fetch('font', self.db.profile.font), self.db.profile.textSize)
	t.redirecttext:SetTextColor(self.db.profile.txtR, self.db.profile.txtG, self.db.profile.txtB, 1)
	t.redirecttext:SetJustifyH("RIGHT")
	t.redirecttext:SetJustifyV("MIDDLE")
	t.redirecttext:ClearAllPoints()
	t.redirecttext:SetPoint("TOP", t.redirect, "TOP", -5, 0)
	t.redirecttext:SetText("4")
	t.redirecttext:Show()
	
	local curTime = GetTime()
	t.start = curTime
	t.stop = curTime + runtime
	t.elapsed = 0
	t.redirectElapsed = 0
	t.time = runtime
	t.running = true
	t.redirecting = false
	t.reversed = reverse
	t.growup = growth
	t.stayonscreen = stay
	t.caster = caster
	
	t:SetFrameStrata("LOW")
	t:Show()
	
	DisableMouse(t)
	
	table.insert(self.timerbars, t)
	self.idents[caster] = t
end

function SimpleMD:CreateAnchor(text)
	local f = CreateFrame("BUTTON", "smdAnchor", UIParent)
	local g = CreateFrame("FRAME", nil, UIParent)
	f:SetWidth(200)
	f:SetHeight(25)
	g:SetWidth(200)
	g:SetHeight(25)
	
	if self.db.profile.position.x and self.db.profile.position.y and self.db.profile.position.anchor and self.db.profile.position.point then
		f:ClearAllPoints()
		g:ClearAllPoints()
		f:SetPoint(self.db.profile.position.point, UIParent, self.db.profile.position.anchor, self.db.profile.position.x, self.db.profile.position.y)
		g:SetPoint(self.db.profile.position.point, UIParent, self.db.profile.position.anchor, self.db.profile.position.x, self.db.profile.position.y)
	else
		f:SetPoint("CENTER", UIParent, "CENTER")
		g:SetPoint("CENTER", UIParent, "CENTER")
	end
	
	f:SetScript("OnDragStart", function() f:StartMoving() end )
	f:SetScript("OnDragStop",
		function ()
			f:StopMovingOrSizing()
			local point, _, anchor, x, y = f:GetPoint()
			SimpleMD.db.profile.position.x = math.floor(x)
			SimpleMD.db.profile.position.y = math.floor(y)
			SimpleMD.db.profile.position.anchor = anchor
			SimpleMD.db.profile.position.point = point
			g:ClearAllPoints()
			g:SetPoint(point, UIParent, anchor, x, y)
		end)
	
	f:SetBackdrop({
		bgFile = [[Interface\Tooltips\UI-Tooltip-Background]],
		edgeFile = [[Interface\Tooltips\UI-Tooltip-Border]],
		tile = false, tileSize = 16, edgeSize = 16,
		insets = { left = 5, right = 5, top = 5, bottom = 5 }
		})
		
	f:SetBackdropColor(0, 1, 0, .65)
	f:SetMovable(true)
	f:RegisterForDrag("LeftButton")
	f:SetClampedToScreen(true)
	f:EnableMouse(true)
	
	f.text = f:CreateFontString(nil, "OVERLAY")
	f.text:SetFontObject(GameFontNormalSmall)
	f.text:ClearAllPoints()
	f.text:SetTextColor(1, 1, 1, 1)
	f.text:SetWidth(200)
	f.text:SetHeight(25)
	f.text:SetPoint("TOP", f, "TOP")
	f.text:SetJustifyH("CENTER")
	f.text:SetJustifyV("MIDDLE")
	f.text:SetText(text)
	
	f:Hide()
	g:Show()
	
	g:SetScript("OnUpdate", SMD_OnUpdate)
	g:EnableMouse(false)
	
	return f, g
end
