﻿--[[
SimpleMD
Author: Michael Joseph Murray aka Starinnia of Lothar(US) aka Lyte of Lothar(US)
$Revision: 183 $
$Date: 2010-01-10 03:48:23 +0000 (Sun, 10 Jan 2010) $
Project Version: 3.1.3
contact: codemaster2010 AT gmail DOT com

Copyright (c) 2007-2009 Michael J. Murray aka Starinnia of Lothar
All rights reserved unless otherwise explicitly stated.
]]

local pname = UnitName("player")

SimpleMD = LibStub("AceAddon-3.0"):NewAddon("SimpleMD", "AceConsole-3.0", "AceComm-3.0", "AceTimer-3.0", "AceEvent-3.0", "LibSink-2.0")
local LSM = LibStub("LibSharedMedia-3.0")
local L = LibStub("AceLocale-3.0"):GetLocale("SimpleMD")

local strformat = string.format
local select = select
local pairs = pairs
local timerbars
--this allows us to disable bars/broadcasts in pvp settings where braodcasting can spam "You aren't in a party."
local allowedZones = {["none"] = true, ["pvp"] = false, ["arena"] = false, ["raid"] = true, ["party"] = true}

local function IsInGroup()
	if (UnitInRaid("player") or GetNumPartyMembers() > 0) and allowedZones[select(2, IsInInstance())] then
		return true
	else
		return false
	end
end

--timer handles for player cooldown
local readyTimer, fiveTimer, tenTimer, fifteenTimer

function SimpleMD:OnInitialize()
	local defaults = {
		profile = {
			tenCD = L["%s has 10 seconds left on MD cooldown!"],
			fiveCD = L["%s has 5 seconds left on MD cooldown!"],
			fifteenCD = L["%s has 15 seconds left on MD cooldown!"],
			noCD = L["%s has MD ready!"],
			readiness = L["%s used Readiness! MD ready!"],
			channel = "",
			showInChannel = false,
			showInChat = false,
			showFloating = false,
			showSelf = true,
			showRW = false,
			showParty = false,
			showRaid = false,
			showYell = false,
			showBars = true,
			showGain = true,
			showFade = true,
			ready = true,
			ten = true,
			five = false,
			fifteen = false,
			showReadiness = true,
			texture = "Blizzard",
			font = "Friz Quadrata TT",
			--bar_ is the normal bar color
			barR = 0,
			barG = 0.4,
			barB = 0.08,
			--tbar_ is the color when transfering threat
			tbarR = 1,
			tbarG = 1,
			tbarB = 0,
			--cbar_ is the color when finished transfering and on CD
			dbarR = 0,
			dbarG = 0,
			dbarB = 1,
			--BG_ is the color of the background of the timer bar
			BGr = 0,
			BGg = 1.0,
			BGb = 0.04,
			--tBG_ is the color of the background of the transfer bar
			tBGr = 1,
			tBGg = 1,
			tBGb = 0.59,
			--txt_ is the text color
			txtR = 1.0,
			txtG = 1.0,
			txtB = 1.0,
			bg_alpha = 1.0,
			textSize = 11,
			barScale = 1.0,
			barWidth = 195.00,
			barHeight = 17.00,
			growUp = false,
			reverse = false,
			stay = false,
			position = {},
			sinkOpts = {},
		}
	}

	self.db = LibStub("AceDB-3.0"):New("SimplemdDB", defaults, "Default")
	self.db.RegisterCallback(self, "OnProfileReset", "Reset")
	self.db.RegisterCallback(self, "OnProfileCopied", "Refresh")
	self.db.RegisterCallback(self, "OnProfileChanged", "Refresh")
	self:SetSinkStorage(self.db.profile.sinkOpts)
	
	--setup the addonID
	local ver, rev = "3.0", "183"
	rev = tonumber(rev) or -1
	local addonID
	if rev == -1 then
		addonID = "SimpleMD-" .. ver .. " SOURCE"
	else
		addonID = "SimpleMD-" .. ver .. " r" .. rev
	end
	
	--self.frame is an invisible frame to run the OnUpdate
	self.anchor, self.frame = self:CreateAnchor(addonID)
	self.timerbars = {} --storage for timer bars
	self.recyclePile = {} --hold on to the frames to reuse them
	self.idents = {} --map of caster to bar ref
	self.activeHunters = {}
	
	LibStub("AceConfig-3.0"):RegisterOptionsTable("SimpleMD", self:GetOptions())
	LibStub("AceConfigDialog-3.0"):SetDefaultSize("SimpleMD", 500, 550)
	LibStub("AceConfigDialog-3.0"):AddToBlizOptions("SimpleMD", "SimpleMD")
	self:RegisterChatCommand("smd", "OpenConfig", true, true)
	self:RegisterChatCommand("simplemd", "OpenConfig")
end

function SimpleMD:OnEnable()
	self.tex = [[Interface\Icons\Ability_Hunter_Misdirection]]
	self:RegisterComm("SimpleMD", "OnCommReceive")
	self:RegisterEvent("RAID_ROSTER_UPDATE", "RaidStatus") --to clear bars after leaving a raid/party
	self:RegisterEvent("PARTY_MEMBERS_CHANGED", "PartyStatus")
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED", "CombatLogEvent")
end

function SimpleMD:Reset()
	self.anchor:ClearAllPoints()
	self.frame:ClearAllPoints()
	self.anchor:SetPoint("CENTER", UIParent, "CENTER")
	self.frame:SetPoint("CENTER", UIParent, "CENTER")
end

function SimpleMD:Refresh()
	local db = self.db.profile
	self.anchor:ClearAllPoints()
	self.frame:ClearAllPoints()
	if db.position.x then
		self.anchor:SetPoint(db.position.point, UIParent, db.position.anchor, db.position.x, db.position.y)
		self.frame:SetPoint(db.position.point, UIParent, db.position.anchor, db.position.x, db.position.y)
	else
		self.anchor:SetPoint("CENTER", UIParent, "CENTER")
		self.frame:SetPoint("CENTER", UIParent, "CENTER")
	end
end

function SimpleMD:OpenConfig()
	LibStub("AceConfigDialog-3.0"):Open("SimpleMD")
end

function SimpleMD:OnCommReceive(prefix, message, distro, sender)
	if sender ~= pname then
		if message == "SMDREADINESS" then
			if self.db.profile.showReadiness then
				self:PrintMessage(strformat(self.db.profile.readiness, sender), false)
			end
			if self.db.profile.showBars then
				self:ReadinessCheck(sender)
			end
		elseif message == "SMDFIVE" and self.db.profile.five then
			self:PrintMessage(strformat(self.db.profile.fiveCD, sender), false)
		elseif message == "SMDTEN" and self.db.profile.ten then
			self:PrintMessage(strformat(self.db.profile.tenCD, sender), false)
		elseif message == "SMDFIFTEEN" and self.db.profile.fifteen then
			self:PrintMessage(strformat(self.db.profile.fifteenCD, sender), false)
		elseif message == "SMDREADY" and self.db.profile.ready then
			self:PrintMessage(strformat(self.db.profile.noCD, sender), false)
		end
	end
end

--dispatcher function to send to the right comm channel
function SimpleMD:Dispatch(message)
	if allowedZones[select(2, IsInInstance())] then
		if UnitInRaid("player") then
			self:SendCommMessage("SimpleMD", message, "RAID", nil, "NORMAL")
		elseif GetNumPartyMembers() > 0 then
			self:SendCommMessage("SimpleMD", message, "PARTY", nil, "NORMAL")
		end
	end
end

function SimpleMD:PrintMessage(message, isPlayer)
	--if isPlayer is true the message regards the player and the message needs to
	--be sent to any selected channels, if it is false then the message is about another hunter
	--and should only be displayed locally to the player
	
	if isPlayer then
		--print to chat frame
		if self.db.profile.showInChat and self.db.profile.showSelf then
			self:Print(message)
		end
		--print to Party chat
		if self.db.profile.showParty and GetNumPartyMembers() > 0 and GetNumRaidMembers() == 0 then
			SendChatMessage(message, "PARTY")
		end
		--print to Raid Chat
		if self.db.profile.showRaid and UnitInRaid("player") then
			SendChatMessage(message, "RAID")
		end
		--print to Raid Warning
		if (IsRaidLeader() or IsRaidOfficer()) and self.db.profile.showRW then
			SendChatMessage(message, "RAID_WARNING")
		end
		-- print to custom channel
		if self.db.profile.showInChannel and self.db.profile.channel ~= "" then
			SendChatMessage(message, "CHANNEL", nil, GetChannelName(self.db.profile.channel))
		end
		--print to Scrolling Text
		if self.db.profile.showFloating and self.db.profile.showSelf then
			self:Pour(message, self.db.profile.r, self.db.profile.g, self.db.profile.b)
		end
	else
		--print to Scrolling Text mod
		if self.db.profile.showFloating then
			self:Pour(message, self.db.profile.r, self.db.profile.g, self.db.profile.b)
		end
		--print to chat frame
		if self.db.profile.showInChat then
			self:Print(message)
		end
	end
end

-- 34477 misdirect
-- 35079 misdirect transfer buff
-- 23989 readiness
local mdOnCD, isTransferring
function SimpleMD:CombatLogEvent(event, timestamp, subevent, sID, sName, sFlags, dID, dName, dFlags, spellID, spellName)
	if spellID == 34477 then
		if subevent == "SPELL_CAST_SUCCESS" then
			if IsInGroup() then
				if self.db.profile.showBars then
					self:CreateTimerBar(sName, dName, 30, self.db.profile.reverse, self.db.profile.stay, self.db.profile.growUp)
				end
				if self.db.profile.showGain then
					self:PrintMessage(strformat(L["%s cast Misdirection on %s"], sName, dName), sName == pname)
				end
				self.activeHunters[sName] = self:ScheduleTimer("BuffRotCheck", 30, sName)
			end
		elseif subevent == "SPELL_AURA_REMOVED" then
			--it seems that the main MD buff is not removed until after the transfer buff is applied
			--however, this is unconfimed when receiving data from other hunters
			if (not isTransferring) and IsInGroup() then
				self:CancelTimer(self.activeHunters[sName])
				self.activeHunters[sName] = nil
				if self.db.profile.showBars and self.idents[sName] then
					self.idents[sName].timer:SetStatusBarColor(self.db.profile.dbarR, self.db.profile.dbarG, self.db.profile.dbarB, 1)
					local curTime = GetTime()
					self.idents[sName].start = curTime
					self.idents[sName].stop = curTime + 30
				end
				if sName == pname then
					fifteenTimer = self:ScheduleTimer("CooldownBroadcast", 15, 15) -- 15 second warning
					tenTimer = self:ScheduleTimer("CooldownBroadcast", 20, 10) -- 10 second warning
					fiveTimer = self:ScheduleTimer("CooldownBroadcast", 25, 5) -- 5 second warning
					readyTimer = self:ScheduleTimer("CooldownBroadcast", 30, 0) -- cooldown finished
					mdOnCD = true
				end
			end
		end
	--this is the 4 second buff that actually allows threat transfer
	elseif spellID == 35079 then
		if subevent == "SPELL_AURA_APPLIED" then
			if IsInGroup() then
				self:CancelTimer(self.activeHunters[sName])
				isTransferring = true
				self.activeHunters[sName] = nil
				if self.db.profile.showBars and self.idents[sName] then
					local curTime = GetTime()
					self.idents[sName].redirectStart = curTime
					self.idents[sName].start = curTime
					self.idents[sName].stop = curTime + 30
					self.idents[sName].timer:Hide()
					self.idents[sName].redirect:Show()
					self.idents[sName].redirecting = true
				end
				if sName == pname then
					fifteenTimer = self:ScheduleTimer("CooldownBroadcast", 15, 15) -- 15 second warning
					tenTimer = self:ScheduleTimer("CooldownBroadcast", 20, 10) -- 10 second warning
					fiveTimer = self:ScheduleTimer("CooldownBroadcast", 25, 5) -- 5 second warning
					readyTimer = self:ScheduleTimer("CooldownBroadcast", 30, 0) -- cooldown finished
					mdOnCD = true
				end
			end
		elseif subevent == "SPELL_AURA_REMOVED" then
			if IsInGroup() then
				isTransferring = false
				if self.db.profile.showBars and self.idents[sName] then
					self.idents[sName].timer:SetStatusBarColor(self.db.profile.dbarR, self.db.profile.dbarG, self.db.profile.dbarB, 1)
					self.idents[sName].timer:Show()
					self.idents[sName].redirect:Hide()
					self.idents[sName].redirecting = false
				end
				if self.db.profile.showFade then
					self:PrintMessage(strformat(L["Misdirection fades from %s"], dName), sName == pname)
				end
			end
		end
	elseif spellID == 23989 then
	--only deal with readiness if the caster is the player
	--we are alerted of other hunter readiness casts through the comm channel
		if IsInGroup() then
			if subevent == "SPELL_CAST_SUCCESS" and sName == pname then
				if mdOnCD then
					self:CancelCooldownTimers() --cancel all CD message events
					mdOnCD = nil
					if self.db.profile.showReadiness then
						self:PrintMessage(strformat(self.db.profile.readiness, pname), true)
					end
					self:Dispatch("SMDREADINESS")
					if self.db.profile.showSelf and self.db.profile.showBars then
						self:ReadinessCheck(pname)
					end
				end
			end
		end
	end
end

function SimpleMD:BuffRotCheck(name)
	self.activeHunters[name] = nil
	if self.db.profile.showBars and self.idents[name] then
		self.idents[name].timer:SetStatusBarColor(self.db.profile.dbarR, self.db.profile.dbarG, self.db.profile.dbarB, 1)
		local curTime = GetTime()
		self.idents[name].start = curTime
		self.idents[name].stop = curTime + 30
	end
	if name == pname then
		fifteenTimer = self:ScheduleTimer("CooldownBroadcast", 15, 15) -- 15 second warning
		tenTimer = self:ScheduleTimer("CooldownBroadcast", 20, 10) -- 10 second warning
		fiveTimer = self:ScheduleTimer("CooldownBroadcast", 25, 5) -- 5 second warning
		readyTimer = self:ScheduleTimer("CooldownBroadcast", 30, 0) -- cooldown finished
		mdOnCD = true
	end
end

function SimpleMD:CancelCooldownTimers()
	self:CancelTimer(readyTimer, true)
	self:CancelTimer(fiveTimer, true)
	self:CancelTimer(tenTimer, true)
	self:CancelTimer(fifteenTimer, true)
	
	readyTimer, fiveTimer, tenTimer, fifteenTimer = nil, nil, nil, nil
end

--Function for broadcasting the cooldown messages
--Do nothing if player is dead or ghost since they can't MD anymore (thanks Cerqua)
function SimpleMD:CooldownBroadcast(timeleft)
	if not UnitIsDeadOrGhost("player") then
		if timeleft == 10 then
			if self.db.profile.ten then
				self:PrintMessage(strformat(self.db.profile.tenCD, pname), true)
			end
			self:Dispatch("SMDTEN")
		elseif timeleft == 15 then
			if self.db.profile.fifteen then
				self:PrintMessage(strformat(self.db.profile.fifteenCD, pname), true)
			end
			self:Dispatch("SMDFIFTEEN")
		elseif timeleft == 5 then
			if self.db.profile.five then
				self:PrintMessage(strformat(self.db.profile.fiveCD, pname), true)
			end
			self:Dispatch("SMDFIVE")
		elseif timeleft == 0 then
			if self.db.profile.ready then
				self:PrintMessage(strformat(self.db.profile.noCD, pname), true)
			end
			self:Dispatch("SMDREADY")
			mdOnCD = nil
		end
	end
end

--see if the player is in a raid, if not.. clear the CD bars
function SimpleMD:RaidStatus()
	if not UnitInRaid("player") then
		self:ClearTimerBars()
	end
end

function SimpleMD:PartyStatus()
	if GetNumPartyMembers() == 0 then
		self:ClearTimerBars()
	end
end

--Disable the bars and immediately cancel all running CD timers
function SimpleMD:DisableBars()
	if self.db.profile.showBars then
		self.db.profile.showBars = false
	else
		self.db.profile.showBars = true
	end
	
	self:ClearTimerBars()
end

--Test function for all aspects of the mod
function SimpleMD:Test()
	if self.db.profile.showInChat then
		self:Print(L["Testing Chat Frame Printing"])
	end
	if self.db.profile.showInChannel and channel ~= "" then
		SendChatMessage(L["Testing Channel Printing"], "CHANNEL", GetDefaultLanguage("player"), GetChannelName(self.db.profile.channel))
	end
	if self.db.profile.showFloating then
		self:Pour(L["Testing Floating Message"], self.db.profile.r, self.db.profile.g, self.db.profile.b)
	end
	if self.db.profile.showBars then
		self:ClearTimerBars()
		self:CreateTimerBar("Test1", "test_target1", 30, self.db.profile.reverse, self.db.profile.stay, self.db.profile.growUp)
		self:CreateTimerBar("Test2", "test_target2", 30, self.db.profile.reverse, self.db.profile.stay, self.db.profile.growUp)
		self:CreateTimerBar("Test3", "test_target3", 30, self.db.profile.reverse, self.db.profile.stay, self.db.profile.growUp)
		self:ScheduleTimer("ClearTimerBars", 32)
		for k, v in pairs(self.idents) do
			if v == "Test1" then
				self.timerbars[k].timer:SetStatusBarColor(self.db.profile.dbarR, self.db.profile.dbarG, self.db.profile.dbarB, 1)
			elseif v == "Test2" then
				self.timerbars[k].timer:SetStatusBarColor(self.db.profile.tbarR, self.db.profile.tbarG, self.db.profile.tbarB, 1)
			end
		end
	end
end
