--$Revision: 183 $
--$Date: 2010-01-10 03:48:23 +0000 (Sun, 10 Jan 2010) $
--project version: 3.1.3
local L = LibStub("AceLocale-3.0"):GetLocale("SimpleMD")
local LSM = LibStub("LibSharedMedia-3.0")

local opts

function SimpleMD:GetOptions()
	if not opts then
		opts = {
			type='group',
			args = {
				anchor = {
					type = 'execute',
					name = L["Anchor"],
					desc = L["Show the dragable anchor."],
					func = function()
						if self.anchor:IsVisible() then
							self.anchor:Hide()
						else
							self.anchor:Show()
						end
					end,
					order = 1,
				},
				bars = {
					type = 'group',
					name = L["Bar"],
					desc = L["Bar Options"],
					order = 2,
					args = {
						texture = {
							type = 'select',
							name = L["Bar Texture"],
							desc = L["Bar Texture"],
							get = function() return self.db.profile.texture end,
							set = function(_, texture)
								self.db.profile.texture = texture
							end,
							dialogControl = "LSM30_Statusbar",
							values = AceGUIWidgetLSMlists.statusbar,
							order = 7,
						},
						color = {
							type = 'color',
							name = L["Bar Color"],
							desc = L["Set the default bar color."],
							get = function() return self.db.profile.barR, self.db.profile.barG, self.db.profile.barB end,
							set = function(_, r, g, b)
								self.db.profile.barR, self.db.profile.barG, self.db.profile.barB = r, g, b
							end,
							order = 1,
						},
						transferColor = {
							type = 'color',
							name = L["Threat Transfer Color"],
							desc = L["Set the bar color when transferring threat."],
							get = function() return self.db.profile.tbarR, self.db.profile.tbarG, self.db.profile.tbarB end,
							set = function(_, r, g, b)
								self.db.profile.tbarR, self.db.profile.tbarG, self.db.profile.tbarB = r, g, b
							end,
							order = 2,
						},
						cooldownColor = {
							type = 'color',
							name = L["Cooldown Color"],
							desc = L["Set the bar color when Misdirection is on cooldown."],
							get = function() return self.db.profile.dbarR, self.db.profile.dbarG, self.db.profile.dbarB end,
							set = function(_, r, g, b)
								self.db.profile.dbarR, self.db.profile.dbarG, self.db.profile.dbarB = r, g, b
							end,
							order = 3,
						},
						bgcolor = {
							type = 'color',
							name = L["Background Color"],
							desc = L["Set the bar background color."],
							get = function() return self.db.profile.BGr, self.db.profile.BGg, self.db.profile.BGb end,
							set = function(_, r, g, b)
								self.db.profile.BGr, self.db.profile.BGg, self.db.profile.BGb = r, g, b
							end,
							order = 4,
						},
						transferbgcolor = {
							type = 'color',
							name = L["Transfer Bar Background Color"],
							desc = L["Set the transfer bar background color."],
							get = function() return self.db.profile.tBGr, self.db.profile.tBGg, self.db.profile.tBGb end,
							set = function(_, r, g, b)
								self.db.profile.tBGr, self.db.profile.tBGg, self.db.profile.tBGb = r, g, b
							end,
							order = 5,
						},
						bgalpha = {
							type = 'range',
							name = L["Background Alpha"],
							desc = L["Set the bar background alpha."],
							get = function () return self.db.profile.bg_alpha end,
							set = function (_, alpha)
								self.db.profile.bg_alpha = alpha
								for k, v in pairs(self.timerbars) do
									self.timerbars[k].timer.bg:SetAlpha(alpha)
								end
							end,
							min = 0.0,
							max = 1.0,
							step = 0.01,
							order = 8,
						},
						text = {
							type = 'select',
							name = L["Font"],
							desc = L["Font"],
							get = function() return self.db.profile.font end,
							set = function(_, font)
								self.db.profile.font = font
								for k, v in pairs(self.timerbars) do
									self.timerbars[k].text:SetFont(LSM:Fetch('font', font), self.db.profile.textSize)
									self.timerbars[k].timetext:SetFont(LSM:Fetch('font', font), self.db.profile.textSize)
								end
							end,
							dialogControl = "LSM30_Font",
							values = AceGUIWidgetLSMlists.font,
							order = 9,
						},
						textcolor = {
							type = 'color',
							name = L["Text Color"],
							desc = L["Set the bar text color."],
							get = function() return self.db.profile.txtR, self.db.profile.txtG, self.db.profile.txtB end,
							set = function(_, r, g, b)
								self.db.profile.txtR, self.db.profile.txtG, self.db.profile.txtB = r, g, b
								for k, v in pairs(self.timerbars) do
									self.timerbars[k].text:SetTextColor(r, g, b, 1)
									self.timerbars[k].timetext:SetTextColor(r, g, b, 1)
								end
							end,
							order = 6,
						},
						textsize = {
							type = 'range',
							name = L["Text Size"],
							desc = L["Set the bar text size."],
							get = function () return self.db.profile.textSize end,
							set = function (_, size)
								self.db.profile.textSize = size
								for k, v in pairs(self.timerbars) do
									self.timerbars[k].text:SetFont(LSM:Fetch('font', self.db.profile.font), size)
									self.timerbars[k].timetext:SetFont(LSM:Fetch('font', self.db.profile.font), size)
								end
							end,
							min = 8,
							max = 20,
							step = 0.5,
							order = 10,
						},
						scale = {
							type = 'range',
							name = L["Bar Scale"],
							desc = L["Set the bar scale."],
							get = function () return self.db.profile.barScale end,
							set = function (_, scale)
								self.db.profile.barScale = scale
								for k, v in pairs(self.timerbars) do
									self.timerbars[k]:SetWidth(self.db.profile.barWidth * scale)
									self.timerbars[k]:SetHeight(self.db.profile.barHeight * scale)
									self.timerbars[k].icon:SetWidth(self.db.profile.barHeight * scale)
									self.timerbars[k].icon:SetHeight(self.db.profile.barHeight * scale)
									self.timerbars[k].text:SetWidth(self.db.profile.barWidth * self.db.profile.barScale)
									self.timerbars[k].text:SetHeight(self.db.profile.barHeight * self.db.profile.barScale)
									self.timerbars[k].timetext:SetWidth(self.db.profile.barWidth * self.db.profile.barScale)
									self.timerbars[k].timetext:SetHeight(self.db.profile.barHeight * self.db.profile.barScale)
								end
							end,
							min = 0.5,
							max = 1.5,
							step = 0.1,
							order = 11,
						},
						height = {
							type = 'range',
							name = L["Bar Height"],
							desc = L["Set the bar height."],
							get = function () return self.db.profile.barHeight end,
							set = function (_, height)
								self.db.profile.barHeight = height
								for k, v in pairs(self.timerbars) do
									self.timerbars[k]:SetHeight(height * self.db.profile.barScale)
									self.timerbars[k].icon:SetWidth(height * self.db.profile.barScale)
									self.timerbars[k].icon:SetHeight(height * self.db.profile.barScale)
									self.timerbars[k].text:SetHeight(height * self.db.profile.barScale)
									self.timerbars[k].timetext:SetHeight(height * self.db.profile.barScale)
								end
							end,
							min = 8,
							max = 30,
							step = 0.5,
							order = 12,
						},
						width = {
							type = 'range',
							name = L["Bar Width"],
							desc = L["Set the bar width."],
							get = function () return self.db.profile.barWidth end,
							set = function (_, width)
								self.db.profile.barWidth = width
								for k, v in pairs(self.timerbars) do
									self.timerbars[k]:SetWidth(width * self.db.profile.barScale)
									self.timerbars[k].text:SetWidth(width * self.db.profile.barScale)
									self.timerbars[k].timetext:SetWidth(width * self.db.profile.barScale)
								end
							end,
							min = 50,
							max = 300,
							step = 1.0,
							order = 13,
						},
						growth = {
							type = 'toggle',
							name = L["Grow Up"],
							desc = L["Toggle the bar growing upwards or downwards."],
							get = function () return self.db.profile.growUp end,
							set = function ()
								self.db.profile.growUp = not self.db.profile.growUp
								self:ReanchorTimerBars(self.db.profile.growUp)
							end,
							order = 20,
						},
						reverse = {
							type = 'toggle',
							name = L["Reverse"],
							desc = L["Toggle the bar fill direction."],
							get = function() return self.db.profile.reverse end,
							set = function()
								self.db.profile.reverse = not self.db.profile.reverse
								for k, v in pairs(self.timerbars) do
									self.timerbars[k].reversed = self.db.profile.reverse
								end
							end,
							order = 21,
						},
						stay = {
							type = 'toggle',
							name = L["Static Bars"],
							desc = L["Toggle the static bars feature"],
							get = function() return self.db.profile.stay end,
							set = function()
								self.db.profile.stay = not self.db.profile.stay
								for k, v in pairs(self.timerbars) do
									self.timerbars[k].stayonscreen = self.db.profile.stay
								end
								if not self.db.profile.stay then
									self:ClearTimerBars()
								end
							end,
							order = 22,
						},
					},
				},
				messages = {
					type = 'group',
					name = L["Message Text Options"],
					desc = L["Options for setting the various alert texts"],
					order = 4,
					args = {
						fivesec = {
							type = 'input',
							name = L["5 Second Warning"],
							desc = L["Set Five Seconds Remaining Message. NOTE: Use %s once to insert a name."],
							get = function() return self.db.profile.fiveCD end,
							set = function(_, v) self.db.profile.fiveCD = v end,
							order = 1,
						},
						tensec = {
							type = 'input',
							name = L["10 Second Warning"],
							desc = L["Set Ten Seconds Remaining Message. NOTE: Use %s once to insert a name."],
							get = function() return self.db.profile.tenCD end,
							set = function(_, v) self.db.profile.tenCD = v end,
							order = 2,
						},
						fifteensec = {
							type = 'input',
							name = L["15 Second Warning"],
							desc = L["Set Fifteen Seconds Remaining Message. NOTE: Use %s once to insert a name."],
							get = function() return self.db.profile.fifteenCD end,
							set = function(_, v) self.db.profile.fifteenCD = v end,
							order = 3,
						},
						cddone = {
							type = 'input',
							name = L["Cooldown Finished Warning"],
							desc = L["Set Cooldown Finished Message. NOTE: Use %s once to insert a name."],
							get = function() return self.db.profile.noCD end,
							set = function(_, v) self.db.profile.noCD = v end,
							order = 4,
						},
						readiness = {
							type = 'input',
							name = L["Readiness Warning"],
							desc = L["Set Readiness Message. NOTE: Use %s once to insert a name."],
							get = function() return self.db.profile.readiness end,
							set = function(_, v) self.db.profile.readiness = v end,
							order = 5,
						},
					},
				},
				broadcast = {
					type = 'group',
					name = L["Broadcast Options"],
					desc = L["Options for how and where the alerts are displayed"],
					order = 5,
					args = {
						console = {
							type = 'toggle',
							name = L["Show in Chat"],
							desc = L["Toggles the display of the alerts as self messages"],
							get = function() return self.db.profile.showInChat end,
							set = function() self.db.profile.showInChat = not self.db.profile.showInChat end,
						},
						channel = {
							type = 'toggle',
							name = L["Show in Channel"],
							desc = L["Toggles broadcasting of alerts to a user defined channel"],
							get = function() return self.db.profile.showInChannel end,
							set = function() self.db.profile.showInChannel = not self.db.profile.showInChannel end,
						},
						floating = {
							type = 'toggle',
							name = L["Show in Combat Text"],
							desc = L["Toggles showing alerts in popular SCT like mods"],
							get = function() return self.db.profile.showFloating end,
							set = function() self.db.profile.showFloating = not self.db.profile.showFloating end,
						},
						showSelf = {
							type = 'toggle',
							name = L["Show Own Alerts"],
							desc = L["Toggles showing your alerts on your client"],
							get = function() return self.db.profile.showSelf end,
							set = function() self.db.profile.showSelf = not self.db.profile.showSelf end,
						},
						channelName = {
							type = 'input',
							name = L["Custom Channel"],
							get = function() return self.db.profile.channel end,
							set = function(_, v) self.db.profile.channel = v end,
						},
						raidwarning = {
							type = 'toggle',
							name = L["Show in Raid Warning"],
							desc = L["Broadcast Misdirection casts to Raid Warning"],
							get = function() return self.db.profile.showRW end,
							set = function() self.db.profile.showRW = not self.db.profile.showRW end,
						},
						showgain = {
							type = 'toggle',
							name = L["Show Gain Message"],
							desc = L["Toggles the display and broadcast of the Gain message"],
							get = function() return self.db.profile.showGain end,
							set = function() self.db.profile.showGain = not self.db.profile.showGain end,
						},
						showfade = {
							type = 'toggle',
							name = L["Show Faded Message"],
							desc = L["Toggles the display and broadcast of the Faded message"],
							get = function() return self.db.profile.showFade end,
							set = function() self.db.profile.showFade = not self.db.profile.showFade end,
						},
						party = {
							type = 'toggle',
							name = L["Show in Party Chat"],
							desc = L["Toggles broadcasting alerts to Party chat"],
							get = function() return self.db.profile.showParty end,
							set = function() self.db.profile.showParty = not self.db.profile.showParty end,
						},
						raid = {
							type = 'toggle',
							name = L["Show in Raid Chat"],
							desc = L["Toggles broadcasting alerts to Raid chat"],
							get = function() return self.db.profile.showRaid end,
							set = function() self.db.profile.showRaid = not self.db.profile.showRaid end,
						},
						yell = {
							type = 'toggle',
							name = L["Show in Yells"],
							desc = L["Toggles broadcasting alerts to Yells"],
							get = function() return self.db.profile.showYell end,
							set = function() self.db.profile.showYell = not self.db.profile.showYell end,
						},
					},
				},
				cooldowns = {
					type = 'group',
					name = L["Cooldown Broadcast Options"],
					desc = L["Toggle which cooldown warnings you want to display to other users"],
					order = 6,
					args = {
						bars = {
							type = 'toggle',
							name = L["Show Cooldown Bars"],
							desc = L["Toggles the creation of cooldown bars"],
							get = function() return self.db.profile.showBars end,
							set = function()
								self.db.profile.showBars = not self.db.profile.showBars
								self:ClearTimerBars()
							end,
						},
						ready = {
							type = 'toggle',
							name = L["CD Finished Warning"],
							desc = L["Display a warning when MD cooldown finishes"],
							get = function() return self.db.profile.ready end,
							set = function() self.db.profile.ready = not self.db.profile.ready end,
						},
						readiness = {
							type = 'toggle',
							name = L["Readiness Message"],
							desc = L["Toggle showing readiness messages"],
							get = function() return self.db.profile.showReadiness end,
							set = function() self.db.profile.showReadiness = not self.db.profile.showReadiness end,
						},
						ten = {
							type = 'toggle',
							name = L["10 Second Warning"],
							desc = L["Display a warning with 10 seconds left on MD cooldown"],
							get = function() return self.db.profile.ten end,
							set = function() self.db.profile.ten = not self.db.profile.ten end,
						},
						five = {
							type = 'toggle',
							name = L["5 Second Warning"],
							desc = L["Display a warning with 5 seconds left on MD cooldown"],
							get = function() return self.db.profile.five end,
							set = function() self.db.profile.five = not self.db.profile.five end,
						},
						fifteen = {
							type = 'toggle',
							name = L["15 Second Warning"],
							desc = L["Display a warning with 15 seconds left on MD cooldown"],
							get = function() return self.db.profile.fifteen end,
							set = function() self.db.profile.fifteen = not self.db.profile.fifteen end,
						},
					},
				},
				test = {
					type = 'execute',
					name = L["Test Settings"],
					desc = L["Perform a test of all graphical elements"],
					func = "Test",
					handler = self,
					order = 8,
				},
			},
		}
		
		opts.args.output = self:GetSinkAce3OptionsDataTable()
		opts.args.profile = LibStub("AceDBOptions-3.0"):GetOptionsTable(self.db)
	end
	
	return opts
end
