-- Author      : danina /thrall
-- Create Date : 23/4/2010 15:14:13

Shadowtimer_Default_X = 0
Shadowtimer_Default_Y = 0
Shadowtimer_Default_Size = 100

MyAddon_UpdateInterval = 0.05; -- How often the OnUpdate code will run (in seconds)
WarningTime = 1000; -- WarningTime (in milliseconds)
----------------------------------------------
local nameWeakenedSoul, rankWeakenedSoul = GetSpellInfo(6788);	--"Geschwchte Seele"  	-- just for testing purpose
local nameInnerFire, rankInnerFire = GetSpellInfo(48168);	--"Inneres Feuer" 	-- just for testing purpose
local IconInnerFire = "Interface\\ICONS\\Spell_Holy_InnerFire.blp"
----------------------------------------------
local nameWordPain, rankWordPain = GetSpellInfo(48125);	--"schmerz"
local IconWordPain = "Interface\\ICONS\\Spell_Shadow_ShadowWordPain.blp"
----------------------------------------------
local nameTouch, rankTouch = GetSpellInfo(48160);	--"Vampirberhrung"
local IconTouch = "Interface\\ICONS\\Spell_Holy_Stoicism.blp"
----------------------------------------------
local namePlague, rankPlague = GetSpellInfo(48300);	--"Plague"
local IconPlague = "Interface\\ICONS\\Spell_Shadow_DevouringPlague.blp"
----------------------------------------------
local nameInsight, rankInsight = GetSpellInfo(61792);	--"Shadowy Insight"
local IconInsight = "Interface\\ICONS\\spell_arcane_blink.blp"
----------------------------------------------
local nameSpiritTap, rankSpiritTap = GetSpellInfo(59000);	--"Improved Spirit Tap"
local IconSpiritTap = "Interface\\ICONS\\spell_shadow_requiem.blp"


function ShadowTimerFrame_OnLoad()
	this:RegisterEvent("VARIABLES_LOADED");
	this:RegisterEvent("PLAYER_LOGOUT");
	DEFAULT_CHAT_FRAME:AddMessage("---Simple shadow timers loaded---");
	Texture1:SetTexture(IconTouch)
	Texture2:SetTexture(IconPlague)
	Texture3:SetTexture(IconWordPain)
	
	Texture6:SetTexture(IconInnerFire)
	Texture7:SetTexture(IconInsight)
	Texture8:SetTexture(IconSpiritTap)
	
	Texture1:Hide()
	Texture2:Hide()
	Texture3:Hide()
	Texture6:Hide()
	Texture7:Hide()
	Texture8:Hide()
	TimeSinceLastUpdate = 0

	ShadowTimerFrame:RegisterForDrag("LeftButton", "RightButton")
	ShadowTimerFrame:EnableMouse(false);
end

function ShadowTimerFrame_OnUpdate(elapsed)
		TimeSinceLastUpdate = TimeSinceLastUpdate + elapsed; 	
		while (TimeSinceLastUpdate > MyAddon_UpdateInterval) do
			CheckCurrentTargetDeBuffs();
			CheckPlayerBuffs();
		TimeSinceLastUpdate = TimeSinceLastUpdate - MyAddon_UpdateInterval;
		end
end


function ShadowTimerFrame_OnEvent()

		if (event == "ADDON_LOADED") then
			if ShadowtimerxPosiFrame then
				--DEFAULT_CHAT_FRAME:AddMessage(ShadowtimerxPosiFrame)
			end	
		end

		 if (event == "VARIABLES_LOADED") then
		  
			  if (not Shadowtimer_X) then
				Shadowtimer_X = Shadowtimer_Default_X
				Shadowtimer_Y = Shadowtimer_Default_Y
				Shadowtimer_Size = Shadowtimer_Default_Size
				
				DEFAULT_CHAT_FRAME:AddMessage("Shadowtimer Options not found. Generating...");
			  end
		 elseif (event == "PLAYER_LOGOUT") then
---
		 end
end


function CheckCurrentTargetDeBuffs()
	local finished = false
	local count = 0
	local TouchFound = 0
	local TouchLeft = 0
	local PlagueFound = 0
	local PlagueLeft = 0
	local WordPainFound = 0
	local WordPainLeft = 0
	local Toutchlefttime = 0
	local CastTime = 5000
			
	while not finished do
		count = count+1
		local bn,brank,bicon,bcount,bType,bduration,bexpirationTime,bisMine,bisStealable,bshouldConsolidate,bspellId =  UnitDebuff("target", count, 0)
		
		if not bn then
			finished = true
		else

			if bisMine == "player" then
				if bn == nameTouch then 
					TouchFound = 1 
					Toutchlefttime = floor((((bexpirationTime-GetTime())*10)+ 0.5))/10				--Time left
					TouchLeft = string.format("%1.1f",Toutchlefttime)							-- as formated string
					local name, rank, icon, cost, isFunnel, powerType, castTimeVT, minRange, maxRange = GetSpellInfo(48160)	 -- get castTime
					ToutchleftMS = Toutchlefttime*1000
					CastTime = castTimeVT	
					ToutchleftMSSafe = ToutchleftMS-WarningTime
				end
				if bn == namePlague then 
					PlagueFound = 1
					Plaguelefttime = floor((((bexpirationTime-GetTime())*10)+ 0.5))/10				--Time left
					PlagueLeft = string.format("%1.1f",Plaguelefttime)	 
					PlagueleftMS = Plaguelefttime*1000
				end
				if bn == nameWordPain then 
					WordPainFound = 1
					WordPainLeft = string.format("%1.1f",floor((((bexpirationTime-GetTime())*10)+ 0.5))/10)  
				end
			end
		end
	end
	if TouchFound == 1 then
		Texture1:Show()
		if ToutchleftMSSafe  < CastTime then
				if ToutchleftMS  < CastTime then
				 Texture1:SetVertexColor(0.1, 0.6, 0.1);
				else 
				 Texture1:SetVertexColor(0.9, 0.2, 0.2);
				 end
		else
			Texture1:SetVertexColor(1.0, 1.0, 1.0);
		end
		TEXT1:SetText(TouchLeft)
		TEXT1:Show()	
		
	else
		TEXT1:Hide()
		Texture1:Hide()
	end
	if PlagueFound == 1 then
		Texture2:Show()
		
		if PlagueleftMS < WarningTime then
		Texture2:SetVertexColor(0.9, 0.2, 0.2);
		else
		Texture2:SetVertexColor(1.0, 1.0, 1.0);
		end
		
		TEXT2:SetText(PlagueLeft)
		TEXT2:Show()	
	else
		Texture2:Hide()
		TEXT2:Hide()
	end
	if WordPainFound == 1 then
		Texture3:Show()
		TEXT3:SetText(WordPainLeft)
		TEXT3:Show()
	else
		Texture3:Hide()
		TEXT3:Hide()
	end

return 
end



function CheckPlayerBuffs()
	local finished = false
	local count = 0
	local InsightFound = 0
	local InsightLeft = 0
	local InnerFireFound = 0
	local SpiritTapFound = 0
	local SpiritTapLeft = 0
	local InnerFireStacks =0
			
	while not finished do
		count = count+1
		local bn,brank,bicon,bcount,bType,bduration,bexpirationTime,bisMine,bisStealable,bshouldConsolidate,bspellId =  UnitBuff("player", count, 0)
		
		if not bn then
			finished = true
		else
			if bn == nameInsight then 
				InsightFound = 1
				InsightLeft = string.format("%1.1f",floor((((bexpirationTime-GetTime())*10)+ 0.5))/10) 
			end
			if bn == nameSpiritTap then 
				SpiritTapFound=1
				SpiritTapLeft = string.format("%1.1f",floor((((bexpirationTime-GetTime())*10)+ 0.5))/10)  
			end
			
			if bn == nameInnerFire then
				InnerFireFound = 1
				InnerFireStacks	= bcount
			end	
		end
	end
	
	if InnerFireFound == 1 then
		Texture6:Show()
		TEXT6:SetText(InnerFireStacks)
		TEXT6:Show()	
	else
		Texture6:Hide()
		TEXT6:Hide()
	end
	
	
	if InsightFound == 1 then
		Texture7:Show()
		TEXT7:SetText(InsightLeft)
		TEXT7:Show()	
	else
		Texture7:Hide()
		TEXT7:Hide()
	end
	if SpiritTapFound == 1 then
		Texture8:Show()
		TEXT8:SetText(SpiritTapLeft)
		TEXT8:Show()
	else
		Texture8:Hide()
		TEXT8:Hide()
	end

return 
end


SLASH_SHADOWTIMERS1, SLASH_SHADOWTIMERS2 = '/st', '/ShadowTimers';
local function SLASH_SHADOWTIMERShandler(msg, editbox)
if msg == 'show' then
	ShadowTimerFrame:Show()
elseif  msg == 'hide' then
	ShadowTimerFrame:Hide()
elseif  msg == 'reset' then
	ShadowTimerFrame:Hide()
	ShadowTimerFrame:Show()	
elseif  msg == 'noconfigmode' then	
	ShadowTimerFrame:EnableMouse(false);
	ShadowTimerFrame:SetBackdrop(nil);
	STmode = 1
elseif  msg == 'configmode' then
	ShadowTimerFrame:EnableMouse(true);
	ShadowTimerFrame:SetBackdrop({bgFile = "Interface/Tooltips/UI-Tooltip-Background", edgeFile= "Interface/Tooltips/UI-Tooltip-Border", edgeSize = 4, tile = false, tileSize =16, insets = { left = 0, right = 0, top = 0, bottom = 0 }});
	STmode = 2
 else
   print("Syntax: /st (show | hide | reset | configmode | noconfigmode)");
 end
end
SlashCmdList["SHADOWTIMERS"] = SLASH_SHADOWTIMERShandler;







