﻿--[[
Name: LibBossIDs-1.0
Revision: $Revision: 14 $
Author: Elsia
Website: http://
Documentation: 
SVN: 
Description: Provide a table of mobIDs that belong to boss mobs (instance bosses, raid bosses, world bosses)
Dependencies: LibStub
License: Public Domain, Absolutely no Warranty.
]]

local MAJOR, MINOR = "LibBossIDs-1.0", "$Revision: 14 $"
local lib = LibStub:NewLibrary(MAJOR, MINOR)

if not lib then return end

-- LibBossIDs-1.0 provides a table that flags mobIDs true if the mob linked to the ID is a boss.
-- Example: if LibStub("LibBossIDs-1.0).BossIDs[mobID] then print("Found a boss!") end
-- How to get mobid from GUID
-- local mobid = tonumber(GUID:sub(9, 12), 16)

-- Explanation of comments. First quoted string is English locale string of mob.
-- The first list was derived from LibBabble-Boss-3.0.
-- Commented out lines without comments are deemed to not be actual bosses, but trash mobs
-- Otherwise comments indicate why they are not yet included.

local BossIDs = {
	[17881] = true, --"Aeonus", 
	[4422] = true, --"Agathelos the Raging",
	[25740] = true, --"Ahune",
	[23574] = true, --"Akil'zon",
	[4829] = true, --"Aku'mai",
	[19514] = true, --"Al'ar",
	[11492] = true, --"Alzzin the Wildshaper",
	[30258] = true, --"Amanitar",
	[9156] = true, --"Ambassador Flamelash",
	[18731] = true, --"Ambassador Hellmaw",
	[7358] = true, --"Amnennar the Coldbringer",
	--[7206] = true, --"Ancient Stone Keeper",
	[17808] = true, --"Anetheron",
	[17808] = true, --"Anger'rel",
	[26763] = true, --"Anomalus",
	[8127] = true, --"Antu'sul",
	[29120] = true, --"Anub'arak",
	--[15277] = true, --"Anubisath Defender",
	--[15355] = true, --"Anubisath Guardian",
	[15956] = true, --"Anub'Rekhan",
	[9031] = true, --"Anub'shiah",
	[23035] = true, --"Anzu",
	--[16485] = true, --"Arcane Watchman",
	[6487] = true, --"Arcanist Doan",
	[2748] = true, --"Archaedas",
	[31125] = true, --"Archavon the Stone Watcher",
	[17968] = true, --"Archimonde",
	[10811] = true, --"Archivist Galford",
	[4275] = true, --"Archmage Arugal",
	[4627] = true, --"Arugal's Voidwalker",
	[8580] = true, --"Atal'alarion",
	[15550] = true, --"Attumen the Huntsman",
	[14464] = true, --"Avalanchion",
	[8443] = true, --"Avatar of Hakkar",
	[15369] = true, --"Ayamiss the Hunter",
	[17842] = true, --"Azgalor",
	[6490] = true, --"Azshir the Sleepless",
	[6109] = true, --"Azuregos",
	[9016] = true, --"Bael'Gar",
	[6906] = true, --"Baelog",
	[10813] = true, --"Balnazzar",
	[9596] = true, --"Bannok Grimaxe",
	[12876] = true, --"Baron Aquanis",
	[14461] = true, --"Baron Charr",
	[10436] = true, --"Baroness Anastari",
	[12056] = true, --"Baron Geddon",
	[15205] = true, --"Baron Kazum",
	[10440] = true, --"Baron Rivendare", -- Strath
	[30549] = true, --"Baron Rivendare", -- Naxx
	[3887] = true, --"Baron Silverlaine",
	[15516] = true, --"Battleguard Sartura",
	[1716] = true, --"Bazil Thredd",
	[11519] = true, --"Bazzalan",
	[11121] = true, --"Black Guard Swordsmith",
	[18667] = true, --"Blackheart the Inciter",
	[18836] = true, --"Blindeye the Seer",
	[4425] = true, --"Blind Hunter",
	[20923] = true, --"Blood Guard Porung",
	[11382] = true, --"Bloodlord Mandokir",
	[4543] = true, --"Bloodmage Thalnos",
	--[14861] = true, --"Blood Steward of Kirtonos",
	[3672] = true, --"Boahn",
	[596] = true, --"Brainwashed Noble",
	[17380] = true, --"Broggok",
	[18398] = true, --"Brokentoe",
	[12017] = true, --"Broodlord Lashlayer",
	[1720] = true, --"Bruegal Ironknuckle",
	[24882] = true, --"Brutallus",
	[10263] = true, --"Burning Felguard",
	[15370] = true, --"Buru the Gorger",
	-- Not a mob ["Cache of the Firelord"] = true, --"Cache of the Firelord",
	[10997] = true, --"Cannon Master Willey",
	[647] = true, --"Captain Greenskin",
	[14325] = true, --"Captain Kromcrush",
	[17862] = true, --"Captain Skarloc",
	[12225] = true, --"Celebras the Cursed",
	[4421] = true, --"Charlga Razorflank",
	-- not a mob ["Chess Event"] = true, --"Chess Event",
	-- not a mob ["Chest of The Seven"] = true, --"Chest of The Seven",
	[7267] = true, --"Chief Ukorz Sandscalp",
	[14324] = true, --"Cho'Rush the Observer",
	[14020] = true, --"Chromaggus",
	[17879] = true, --"Chrono Lord Deja",
	[26532] = true, --"Chrono-Lord Epoch",
	[17827] = true, --"Claw",
	--[22055] = true, --"Coilfang Elite",
	--[22056] = true, --"Coilfang Strider",
	[26798] = true, --"Commander Kolurg",
	[17976] = true, --"Commander Sarannis",
	[4278] = true, --"Commander Springvale",
	[26796] = true, --"Commander Stoutbeard",
	-- Unknown ["Constructor & Controller"] = true, --"Constructor & Controller",
	[645] = true, --"Cookie",
	[21270] = true, --"Cosmic Infuser",
	[11120] = true, --"Crimson Hammersmith",
	[6229] = true, --"Crowd Pummeler 9-60",
	[10376] = true, --"Crystal Fang",
	[15727] = true, --"C'Thun",
	[31134] = true, --"Cyanigosa",
	[20885] = true, --"Dalliah the Doomsayer",
	[27389] = true, --"Dalronn the Controller",
	[24201] = true, --"Dalronn the Controller",
	[6228] = true, --"Dark Iron Ambassador",
	[1853] = true, --"Darkmaster Gandling",
	[18472] = true, --"Darkweaver Syth",
	[14516] = true, --"Death Knight Darkreaver",
	[16803] = true, --"Death Knight Understudy",
	[4428] = true, --"Death Speaker Jargba",
	[3872] = true, --"Deathsworn Captain",
	[21269] = true, --"Devastation",
	[5912] = true, --"Deviate Faerie Dragon",
	[1663] = true, --"Dextren Ward",
	[7057] = true, --"Digmaster Shovelphlange",
	[11261] = true, --"Doctor Theolen Krastinov",
	[18728] = true, --"Doom Lord Kazzak",
	[9039] = true, --"Doom'rel",
	[17711] = true, --"Doomwalker",
	[9040] = true, --"Dope'rel",
	[17535] = true, --"Dorothee",
	[29307] = true, --"Drakkari Colossus",
	[27654] = true, --"Drakos the Interrogator",
	[5721] = true, --"Dreamscythe",
	-- not a mob ["Dust Covered Chest"] = true, --"Dust Covered Chest",
	[10081] = true, --"Dustwraith",
	[4842] = true, --"Earthcaller Halmgar",
	[14601] = true, --"Ebonroc",
	[29932] = true, --"Eck the Ferocious",
	[639] = true, --"Edwin VanCleef",
	[29309] = true, --"Elder Nadox",
	[6235] = true, --"Electrocutioner 6000",
	[14889] = true, --"Emeriss",
	[9019] = true, --"Emperor Dagran Thaurissan",
	[15276] = true, --"Emperor Vek'lor",
	[15275] = true, --"Emperor Vek'nilash",
	[25840] = true, --"Entropius",
	[18096] = true, --"Epoch Hunter",
	[29315] = true, --"Erekem",
	[23420] = true, --"Essence of Anger",
	[23419] = true, --"Essence of Desire",
	[23418] = true, --"Essence of Suffering",
	[9029] = true, --"Eviscerator",
	[18373] = true, --"Exarch Maladaar",
	[15589] = true, --"Eye of C'Thun",
	[6488] = true, --"Fallen Champion",
	[15510] = true, --"Fankriss the Unyielding",
	[21214] = true, --"Fathom-Lord Karathress",
	[25038] = true, --"Felmyst",
	[4274] = true, --"Fenrus the Devourer",
	[15930] = true, --"Feugen",
	[9056] = true, --"Fineous Darkvire",
	[11983] = true, --"Firemaw",
	[11981] = true, --"Flamegor",
	[33113] = true, --"Flame Leviathan", -- 3.1 PTR missing
	[626] = true, --"Foreman Thistlenettle",
	-- not a mob ["Four Horsemen Chest"] = true, --"Four Horsemen Chest",
	[11058] = true, --"Fras Siabi",
	[32906] = true, --"Freya",-- 3.1 PTR missing
	[15114] = true, --"Gahz'ranka",
	[7273] = true, --"Gahz'rilla",
	[29306] = true, --"Gal'darah",
	[7291] = true, --"Galgann Firehammer",
	[12057] = true, --"Garr",
	[5713] = true, --"Gasher",
	[19218] = true, --"Gatewatcher Gyro-Kill",
	[19710] = true, --"Gatewatcher Iron-Hand",
	[22949] = true, --"Gathios the Shatterer",
	[12259] = true, --"Gehennas",
	[6243] = true, --"Gelihast",
	[13741] = true, --"Gelk",
	[9033] = true, --"General Angerforge",
	[28586] = true, --"General Bjarngrim",
	[10363] = true, --"General Drakkisath",
	[15341] = true, --"General Rajaxx",
	[33271] = true, --"General Vezax",-- 3.1 PTR missing
	[4887] = true, --"Ghamoo-ra",
	[18105] = true, --"Ghaz'an",
	[9718] = true, --"Ghok Bashguud",
	[1763] = true, --"Gilnid",
	[10268] = true, --"Gizrul the Slavener",
	[9037] = true, --"Gloom'rel",
	[15932] = true, --"Gluth",
	[8567] = true, --"Glutton",
	[11988] = true, --"Golemagg the Incinerator",
	[8983] = true, --"Golem Lord Argelmach",
	[10899] = true, --"Goraluk Anvilcrack",
	[9027] = true, --"Gorosh the Dervish",
	[26687] = true, --"Gortok Palehoof",
	[16060] = true, --"Gothik the Harvester",
	[20062] = true, --"Grand Astromancer Capernian",
	[26731] = true, --"Grand Magus Telestra",
	[26832] = true, --"Grand Magus Telestra",
	[26928] = true, --"Grand Magus Telestra",
	[26929] = true, --"Grand Magus Telestra",
	[26930] = true, --"Grand Magus Telestra",
	[18732] = true, --"Grandmaster Vorpil",
	-- non-attackable [17603] = true, --"Grandmother",
	[25166] = true, --"Grand Warlock Alythess",
	[16807] = true, --"Grand Warlock Nethekurse",
	[15953] = true, --"Grand Widow Faerlina",
	[12557] = true, --"Grethok the Controller",
	[15082] = true, --"Gri'lek",
	[4854] = true, --"Grimlok",
	[9028] = true, --"Grizzle",
	[15931] = true, --"Grobbulus",
	[7361] = true, --"Grubbis",
	[19044] = true, --"Gruul the Dragonkiller",
	[14321] = true, --"Guard Fengus",
	[14326] = true, --"Guard Mol'dar",
	[14323] = true, --"Guard Slip'kik",
	[22948] = true, --"Gurtogg Bloodboil",
	[10339] = true, --"Gyth",
	[28921] = true, --"Hadronox",
	[14834] = true, --"Hakkar",
	[23577] = true, --"Halazzi",
	[28517] = true, --"Halazzi",
	[29022] = true, --"Halazzi",
	[10220] = true, --"Halycon",
	[1717] = true, --"Hamhock",
	[20912] = true, --"Harbinger Skyriss",
	[9034] = true, --"Hate'rel",
	[15083] = true, --"Hazza'rah",
	[5722] = true, --"Hazzas",
	[23682] = true, --"Headless Horseman",
	[23800] = true, --"Headless Horseman",
	[10558] = true, --"Hearthsinger Forresten",
	[9032] = true, --"Hedrum the Creeper",
	[15936] = true, --"Heigan the Unclean",
	-- Maggy trash [17256] = true, --"Hellfire Channeler",
	-- friendly NPC [8696] = true, --"Henry Stern",
	[29311] = true, --"Herald Volazj",
	[3975] = true, --"Herod",
	[24239] = true, --"Hex Lord Malacrass",
	[18805] = true, --"High Astromancer Solarian",
	[17975] = true, --"High Botanist Freywinn",
	[4542] = true, --"High Inquisitor Fairbanks",
	[3977] = true, --"High Inquisitor Whitemane",
	[9018] = true, --"High Interrogator Gerstahn",
	[18831] = true, --"High King Maulgar",
	[16062] = true, --"Highlord Mograine",
	[9196] = true, --"Highlord Omokk",
	[15204] = true, --"High Marshal Whirlaxis",
	[22950] = true, --"High Nethermancer Zerevor",
	[14515] = true, --"High Priestess Arlokk",
	[14517] = true, --"High Priestess Jeklik",
	[14510] = true, --"High Priestess Mar'li",
	[10076] = true, --"High Priestess of Thaurissan",
	[14509] = true, --"High Priest Thekal",
	[14507] = true, --"High Priest Venoxis",
	[22887] = true, --"High Warlord Naj'entus",
	[32845] = true, --"Hodir", -- 3.1 PTR missing
	[9319] = true, --"Houndmaster Grebmar",
	[3974] = true, --"Houndmaster Loksey",
	[5715] = true, --"Hukku",
	[17770] = true, --"Hungarfen",
	[9537] = true, --"Hurley Blackbreath",
	[16179] = true, --"Hyakiss the Lurker",
	[17797] = true, --"Hydromancer Thespia",
	[7795] = true, --"Hydromancer Velratha",
	[13280] = true, --"Hydrospawn",
	[21216] = true, --"Hydross the Unstable",
	[29313] = true, --"Ichoron",
	[33118] = true, --"Ignis the Furnace Master", -- 3.1 PTR missing
	[22917] = true, --"Illidan Stormrage", -- Not adding solo quest IDs for now
	[23426] = true, --"Illidari Council",
	[11488] = true, --"Illyanna Ravenoak",
	[11496] = true, --"Immol'thar",
	[32273] = true, --"Infinite Corruptor",
	[21271] = true, --"Infinity Blades",
	[23954] = true, --"Ingvar the Plunderer",
	[23980] = true, --"Ingvar the Plunderer",
	[10505] = true, --"Instructor Malicia",
	[16061] = true, --"Instructor Razuvious",
	[3983] = true, --"Interrogator Vishas",
	[28546] = true, --"Ionar",
	[7228] = true, --"Ironaya",
	[6489] = true, --"Ironspine",
	[16097] = true, --"Isalien",
	[1063] = true, --"Jade",
	[5710] = true, --"Jammal'an the Prophet",
	[23578] = true, --"Jan'alai",
	[28515] = true, --"Jan'alai",
	[29023] = true, --"Jan'alai",
	[10503] = true, --"Jandice Barov",
	[29310] = true, --"Jedoga Shadowseeker",
	[10509] = true, --"Jed Runewatcher",
	[11518] = true, --"Jergosh the Invoker",
	[11380] = true, --"Jin'do the Hexxer",
	-- Not found ["Jormungar Behemoth"] = true, --"Jormungar Behemoth",
	[17534] = true, --"Julianne",
	[24664] = true, --"Kael'thas Sunstrider",
	[19622] = true, --"Kael'thas Sunstrider",
	[24891] = true, --"Kalecgos",
	[25319] = true, --"Kalecgos",
	[24850] = true, --"Kalecgos",
	[1666] = true, --"Kam Deepfury",
	[5401] = true, --"Kazkaz the Unholy",
	[17888] = true, --"Kaz'rogal",
	[17377] = true, --"Keli'dan the Breaker",
	[15990] = true, --"Kel'Thuzad",
	[25465] = true, --"Kel'Thuzad",
	[26723] = true, --"Keristrasza",
	[18835] = true, --"Kiggler the Crazed",
	[25315] = true, --"Kil'jaeden",
	[17229] = true, --"Kil'rek",
	[27483] = true, --"King Dred",
	[11501] = true, --"King Gordok",
	-- Considering this a pet [21684] = true, --"King Llane Piece",
	[26861] = true, --"King Ymiron",
	[10506] = true, --"Kirtonos the Herald",
	-- not a mob ["Knot Thimblejack's Cache"] = true, --"Knot Thimblejack's Cache",
	[13742] = true, --"Kolk",
	[16118] = true, --"Kormok",
	[3653] = true, --"Kresh",
	[28684] = true, --"Krik'thir the Gatewatcher",
	[18832] = true, --"Krosh Firehand",
	[27977] = true, --"Krystallus",
	[15348] = true, --"Kurinnaxx",
	[3671] = true, --"Lady Anacondra",
	[16065] = true, --"Lady Blaumeux",
	[10502] = true, --"Lady Illucia Barov",
	[22951] = true, --"Lady Malande",
	[25165] = true, --"Lady Sacrolash",
	[4831] = true, --"Lady Sarevess",
	[21212] = true, --"Lady Vashj",
	[17980] = true, --"Laj",
	[12203] = true, --"Landslide",
	[29312] = true, --"Lavanthor",
	[21215] = true, --"Leotheras the Blind",
	[14888] = true, --"Lethon",
	[14327] = true, --"Lethtendris",
	[27656] = true, --"Ley-Guardian Eregos",
	[17848] = true, --"Lieutenant Drake",
	-- friendly ally [15471] = true, --"Lieutenant General Andorov",
	[16011] = true, --"Loatheb",
	[28923] = true, --"Loken",
	[10504] = true, --"Lord Alexei Barov",
	[3669] = true, --"Lord Cobrahn",
	[14506] = true, --"Lord Hel'nurath",
	[9017] = true, --"Lord Incendius",
	[12397] = true, --"Lord Kazzak",
	[15511] = true, --"Lord Kri",
	[3670] = true, --"Lord Pythas",
	[9025] = true, --"Lord Roccor",
	[20060] = true, --"Lord Sanguinar",
	[3673] = true, --"Lord Serpentis",
	[15305] = true, --"Lord Skwol",
	[16042] = true, --"Lord Valthalak",
	[10162] = true, --"Lord Victor Nefarius",
	[12236] = true, --"Lord Vyletongue",
	[10901] = true, --"Lorekeeper Polkelt",
	[5714] = true, --"Loro",
	[12118] = true, --"Lucifron",
	[3655] = true, --"Mad Magglish",
	[15952] = true, --"Maexxna",
	[27655] = true, --"Mage-Lord Urom",
	[11487] = true, --"Magister Kalendris",
	[10435] = true, --"Magistrate Barthilas",
	[11982] = true, --"Magmadar",
	[9938] = true, --"Magmus",
	[13740] = true, --"Magra",
	[17257] = true, --"Magtheridon",
	[27975] = true, --"Maiden of Grief",
	[16457] = true, --"Maiden of Virtue",
	[12018] = true, --"Majordomo Executus",
	[24239] = true, --"Malacrass",
	[10438] = true, --"Maleki the Pallid",
	[26533] = true, --"Mal'Ganis",
	[29620] = true, --"Mal'Ganis",
	[28859] = true, --"Malygos",
	[13739] = true, --"Maraudos",
	[10433] = true, --"Marduk Blackpool",
	[599] = true, --"Marisa du'Paige",
	[20063] = true, --"Master Engineer Telonicus",
	[11834] = true, --"Maur Grimtotem",
	[26529] = true, --"Meathook",
	[19219] = true, --"Mechano-Lord Capacitus",
	-- Friendly NPC Medivh = true, --"Medivh",
	[17796] = true, --"Mekgineer Steamrigger",
	[7800] = true, --"Mekgineer Thermaplugg",
	[17941] = true, --"Mennu the Betrayer",
	[12237] = true, --"Meshlok the Harvester",
	[16151] = true, --"Midnight",
	[5717] = true, --"Mijan",
	[3586] = true, --"Miner Johnson",
	[15340] = true, --"Moam",
	[18069] = true, --"Mogor",
	[29305] = true, --"Moorabi",
	[29316] = true, --"Moragg",
	[7357] = true, --"Mordresh Fire Eye",
	[16080] = true, --"Mor Grayhoof",
	[15687] = true, --"Moroes",
	[21213] = true, --"Morogrim Tidewalker",
	[5719] = true, --"Morphaz",
	[22947] = true, --"Mother Shahraz",
	[10596] = true, --"Mother Smolderweb",
	[646] = true, --"Mr. Smite",
	[18399] = true, --"Murkblood Twin",
	-- not found ["Murkblood Twins"] = true, --"Murkblood Twins",
	[18708] = true, --"Murmur",
	[7608] = true, --"Murta Grimgut",
	[25741] = true, --"M'uru",
	[11447] = true, --"Mushgog",
	[3654] = true, --"Mutanus the Devourer",
	[29024] = true, --"Nalorakk",
	[28514] = true, --"Nalorakk",
	[23576] = true, --"Nalorakk",
	[17536] = true, --"Nazan",
	[11583] = true, --"Nefarian",
	[7796] = true, --"Nekrum Gutchewer",
	[10437] = true, --"Nerub'enkan",
	[19221] = true, --"Nethermancer Sepethrea",
	[15689] = true, --"Netherspite",
	[21268] = true, --"Netherstrand Longbow",
	[18344] = true, --"Nexus-Prince Shaffar",
	[17225] = true, --"Nightbane",
	[15954] = true, --"Noth the Plaguebringer",
	[26631] = true, --"Novos the Summoner",
	[13282] = true, --"Noxxion",
	-- [7023] = true, --"Obsidian Sentinel",
	[4279] = true, --"Odo the Blindwatcher",
	[5711] = true, --"Ogom the Wretched",
	[9030] = true, --"Ok'thor the Breaker",
	[4830] = true, --"Old Serra'kis",
	[18834] = true, --"Olm the Summoner",
	[17308] = true, --"Omor the Unscarred",
	[10184] = true, --"Onyxia",
	[26794] = true, --"Ormorok the Tree-Shaper",
	[7606] = true, --"Oro Eyegouge",
	[15339] = true, --"Ossirian the Unscarred",
	[15517] = true, --"Ouro",
	[4420] = true, --"Overlord Ramtusk",
	[9568] = true, --"Overlord Wyrmthalak",
	[9026] = true, --"Overmaster Pyron",
	-- not found ["Overseer Tidewrath"] = true, --"Overseer Tidewrath",
	[18341] = true, --"Pandemonius",
	[8923] = true, --"Panzor the Invincible",
	[16028] = true, --"Patchwerk",
	[19220] = true, --"Pathaleon the Calculator",
	[9502] = true, --"Phalanx",
	[21273] = true, --"Phaseshift Bulwark",
	[14349] = true, --"Pimgib",
	[7356] = true, --"Plaguemaw the Rotting",
	[9499] = true, --"Plugger Spazzring",
	[11143] = true, --"Postmaster Malown",
	[24560] = true, --"Priestess Delrissa",
	[23953] = true, --"Prince Keleseth",
	[15690] = true, --"Prince Malchezaar",
	[15203] = true, --"Prince Skaldrenox",
	[15509] = true, --"Princess Huhuran",
	[8929] = true, --"Princess Moira Bronzebeard",
	[14457] = true, --"Princess Tempestria",
	[12201] = true, --"Princess Theradras",
	[15543] = true, --"Princess Yauj",
	[29308] = true, --"Prince Taldaram",
	[11486] = true, --"Prince Tortheldrin",
	-- Hydross trash [22035] = true, --"Pure Spawn of Hydross",
	[14354] = true, --"Pusillin",
	[9816] = true, --"Pyroguard Emberseer",
	[9024] = true, --"Pyromancer Loregrain",
	[17942] = true, --"Quagmirran",
	[9736] = true, --"Quartermaster Zigris",
	[17767] = true, --"Rage Winterchill",
	[7354] = true, --"Ragglesnout",
	[11502] = true, --"Ragnaros",
	[10439] = true, --"Ramstein the Gorger",
	[10508] = true, --"Ras Frostwhisper",
	[11622] = true, --"Rattlegore",
	[3886] = true, --"Razorclaw the Butcher",
	[12435] = true, --"Razorgore the Untamed",
	[12258] = true, --"Razorlash",
	-- not found Razorscale = true, --"Razorscale",
	-- not found ["Reliquary of Souls"] = true, --"Reliquary of Souls",
	[15084] = true, --"Renataki",
	[17261] = true, --"Restless Skeleton",
	[6910] = true, --"Revelosh",
	[644] = true, --"Rhahk'Zor",
	[9543] = true, --"Ribbly Screwspigot",
	[17546] = true, --"Roar",
	[16181] = true, --"Rokad the Ravager",
	[18400] = true, --"Rokdar the Sundered Lord",
	[17991] = true, --"Rokmar the Crackler",
	[17533] = true, --"Romulo",
	-- not found ["Romulo & Julianne"] = true, --"Romulo & Julianne",
	[13596] = true, --"Rotgrip",
	-- not found ["Runemaster Molgeim"] = true, --"Runemaster Molgeim",
	[7797] = true, --"Ruuzlu",
	[26530] = true, --"Salramm the Fleshcrafter",
	[10080] = true, --"Sandarr Dunereaver",
	[7274] = true, --"Sandfury Executioner",
	[15989] = true, --"Sapphiron",
	[28860] = true, --"Sartharion",
	[24892] = true, --"Sathrovarr the Corruptor",
	[3976] = true, --"Scarlet Commander Mograine",
	[9038] = true, --"Seeth'rel",
	[24723] = true, --"Selin Fireheart",
	[7604] = true, --"Sergeant Bly",
	[22841] = true, --"Shade of Akama",
	[16524] = true, --"Shade of Aran",
	[5709] = true, --"Shade of Eranikus",
	[16180] = true, --"Shadikith the Glider",
	[9236] = true, --"Shadow Hunter Vosh'gajin",
	[21875] = true, --"Shadow of Leotheras",
	[7275] = true, --"Shadowpriest Sezz'ziz",
	[30451] = true, --"Shadron",
	[12264] = true, --"Shazzrah",
	[18371] = true, --"Shirrak the Dead Watcher",
	[16063] = true, --"Sir Zeliek",
	[27978] = true, --"Sjonnir The Ironshaper",
	[26693] = true, --"Skadi the Ruthless",
	[11498] = true, --"Skarr the Unbreakable",
	[27390] = true, --"Skarvald the Constructor",
	[24200] = true, --"Skarvald the Constructor",
	[18401] = true, --"Skra'gath",
	[10393] = true, --"Skul",
	[3674] = true, --"Skum",
	[29304] = true, --"Slad'ran",
	[643] = true, --"Sneed",
	[642] = true, --"Sneed's Shredder",
	[10264] = true, --"Solakar Flamewreath",
	-- Solarium trash [18925] = true, --"Solarium Agent",
	-- Solarium trash [18806] = true, --"Solarium Priest",
	[9218] = true, --"Spirestone Battle Lord",
	[9219] = true, --"Spirestone Butcher",
	[9217] = true, --"Spirestone Lord Magus",
	[21274] = true, --"Staff of Disintegration",
	[15929] = true, --"Stalagg",
	-- not found Steelbreaker = true, --"Steelbreaker",
	[14322] = true, --"Stomper Kreeg",
	[10809] = true, --"Stonespine",
	-- not found ["Stormcaller Brundir"] = true, --"Stormcaller Brundir",
	[17543] = true, --"Strawman",
	[12098] = true, --"Sulfuron Harbinger",
	[22898] = true, --"Supremus",
	[26668] = true, --"Svala Sorrowgrave",
	[17826] = true, --"Swamplord Musel'ek",
	[14890] = true, --"Taerar",
	-- hydross trash [22036] = true, --"Tainted Spawn of Hydross",
	[18473] = true, --"Talon King Ikiss",
	[11520] = true, --"Taragaman the Hungerer",
	[1696] = true, --"Targorr the Dread",
	[18343] = true, --"Tavarok",
	[6231] = true, --"Techbot",
	[17880] = true, --"Temporus",
	[11489] = true, --"Tendris Warpwood",
	[30452] = true, --"Tenebron",
	[15688] = true, --"Terestian Illhoof",
	[22871] = true, --"Teron Gorefiend",
	[15928] = true, --"Thaddius",
	[20064] = true, --"Thaladred the Darkener",
	[16064] = true, --"Thane Korth'azz",
	[10430] = true, --"The Beast",
	[17521] = true, --"The Big Bad Wolf",
	[17882] = true, --"The Black Stalker",
	-- not found ["The Blue Brothers"] = true, --"The Blue Brothers",
	-- not found ["The Bug Family"] = true, --"The Bug Family",
	[18168] = true, --"The Crone",
	[15691] = true, --"The Curator",
	-- not found ["The Eredar Twins"] = true, --"The Eredar Twins",
	-- not found ["The Four Horsemen"] = true, --"The Four Horsemen",
	[23426] = true, --"The Illidari Council",
	-- not found ["The Iron Council"] = true, --"The Iron Council",
	[7272] = true, --"Theka the Martyr",
	[21217] = true, --"The Lurker Below",
	[17381] = true, --"The Maker",
	[15263] = true, --"The Prophet Skeram",
	[26632] = true, --"The Prophet Tharon'ja",
	[27696] = true, --"The Prophet Tharon'ja",
	[10507] = true, --"The Ravenian",
	[11497] = true, --"The Razza",
	-- not found ["The Seven Dwarves"] = true, --"The Seven Dwarves",
	[28234] = true, --"The Tribunal of Ages",
	-- not found ["The Twin Emperors"] = true, --"The Twin Emperors",
	[10516] = true, --"The Unforgiven",
	[14454] = true, --"The Windreaver",
	-- friendly NPC Thorim = true, --"Thorim",
	[17978] = true, --"Thorngrin the Tender",
	-- Morogrim trash [21920] = true, --"Tidewalker Lurker",
	[10808] = true, --"Timmy the Cruel",
	[17547] = true, --"Tinhead",
	[13601] = true, --"Tinkerer Gizlock",
	[17548] = true, --"Tito",
	[3652] = true, --"Trigore the Lasher",
	[26630] = true, --"Trollgore",
	[11467] = true, --"Tsu'zee",
	[7355] = true, --"Tuten'kash",
	[4832] = true, --"Twilight Lord Kelris",
	[10584] = true, --"Urok Doomhowl",
	[13020] = true, --"Vaelastrasz the Corrupt",
	[27447] = true, --"Varos Cloudstrider",
	[17537] = true, --"Vazruden",
	[17307] = true, --"Vazruden the Herald",
	[10432] = true, --"Vectus",
	[15544] = true, --"Vem",
	[13738] = true, --"Veng",
	[22952] = true, --"Veras Darkshadow",
	[5775] = true, --"Verdan the Everliving",
	[9042] = true, --"Verek",
	[30449] = true, --"Vesperon",
	[24744] = true, --"Vexallus",
	[5399] = true, --"Veyzhak the Cannibal",
	[9036] = true, --"Vile'rel",
	[15299] = true, --"Viscidus",
	[7079] = true, --"Viscous Fallout",
	[19516] = true, --"Void Reaver",
	[28587] = true, --"Volkhan",
	[16809] = true, --"Warbringer O'mrogg",
	-- treated as pet ["Warchief Blackhand Piece"] = true, --"Warchief Blackhand Piece",
	[16808] = true, --"Warchief Kargath Bladefist",
	[10429] = true, --"Warchief Rend Blackhand",
	[20904] = true, --"Warden Mellichar",
	[9041] = true, --"Warder Stilgiss",
	[17798] = true, --"Warlord Kalithresh",
	[9237] = true, --"War Master Voone",
	[18402] = true, --"Warmaul Champion",
	[21272] = true, --"Warp Slicer",
	[17977] = true, --"Warp Splinter",
	[17306] = true, --"Watchkeeper Gargolmar",
	[5720] = true, --"Weaver",
	[7271] = true, --"Witch Doctor Zum'rah",
	[3927] = true, --"Wolf Master Nandos",
	[20886] = true, --"Wrath-Scryer Soccothrates",
	[15085] = true, --"Wushoolay",
	[29266] = true, --"Xevozz",
	-- not found ["XT-002 Deconstructor"] = true, --"XT-002 Deconstructor",
	[14887] = true, --"Ysondre",
	[5400] = true, --"Zekkis",
	[17830] = true, --"Zelemar the Wrathful",
	[20870] = true, --"Zereketh the Unbound",
	[10082] = true, --"Zerillis",
	[11490] = true, --"Zevrim Thornhoof",
	[5712] = true, --"Zolo",
	-- trash ["Zul'Farrak Dead Hero"] = true, --"Zul'Farrak Dead Hero",
	[23863] = true, --"Zul'jin",
	[5716] = true, --"Zul'Lor",
	[29314] = true, --"Zuramat the Obliterator",
	-- Patch 3.1 bosses below
    [33993] = true, --"Emalon the Storm Watcher",
    [33515] = true, --"Auriaya",
    [32930] = true, --"Kologarn",
    [33350] = true, --"Mimiron",
    [33186] = true, --"Razorscale",
    [33293] = true, --"XT-002 Deconstructor",
    [32867] = true, --"Assembly of Iron",
    [33288] = true, --"Yogg-Saron",
    [32871] = true, --"Algalon the Observer",
}
	

lib.BossIDs = BossIDs
