--[[
	Basic RuneWatch GUI Skin: Compact Skin
	Author: Voorije (ReAn)
	Last Edited: 2009-02-19T10:24:20Z
]]

assert(RuneWatch, "Unable to locate RuneWatch Addon Object.");

local Compact = RuneWatch:NewModule("Skin_Compact", RuneWatch.SkinBase, "AceConsole-3.0", "AceEvent-3.0")

local SkinArt = 
{
	Base = 
	{
		Generic = "Interface\\AddOns\\RuneWatch\\Artwork\\Shared\\Orb-Generic",
		Frost = "Interface\\AddOns\\RuneWatch\\Artwork\\Shared\\Orb-Frost",
		Unholy = "Interface\\AddOns\\RuneWatch\\Artwork\\Shared\\Orb-Unholy",
		Blood = "Interface\\AddOns\\RuneWatch\\Artwork\\Shared\\Orb-Blood",
	}
}

function Compact:OnInitialize()	
	self.ID = "compact";
	self.Name = "Compact";
	self.Description = "The Compact User-Interface for RuneWatch. This UI is designed to be a smaller version of the Compact UI";
	self.Themes = 
	{
		Generic = true,
		Frost = true,
		Unholy = true,
		Blood = true
	}
	self.Orientations =
	{
		Bottom = true,
		Left = true,
		Right = true,
		Top = true
	}
	
	-- Events
	RuneWatch.RegisterMessage(Compact, "RuneWatch_Gui_Update");
	RuneWatch.RegisterMessage(Compact, "RuneWatch_Skins_Assign");
	RuneWatch.RegisterMessage(Compact, "RuneWatch_RunicPower_Update");
	RuneWatch.RegisterMessage(Compact, "RuneWatch_Gui_DragEnable");
	
	Compact:InitSkinData();
	Compact:InitConfig();
	Compact:InitGui();
	
	RuneWatch.Skins:Register(self.ID, self);
	
	self:Super("OnInitialize");
end

function Compact:OnEnable()
	self:Super("OnEnable");
end

function Compact:OnDisable()
	self:Super("OnDisable");
end

function Compact:RegisterMount(mount, orientation, _x, _y)
	RuneWatch.Mounts:Register(mount, mount); -- Make sure RuneWatch is aware of all Mount Types

	local ori = orientation or "_Generic";
	self.Mounts[mount] = {}
	self.Mounts[mount][ori] = { x = _x, y = _y }
end

function Compact:InitSkinData()

	-- Orientations
	self.Orientations = 
	{
		["bottom"] = "Bottom",
		["top"] = "Top"
	}
	self.Themes = 
	{
		["Generic"] = "Generic",
		["Blood"] = "Blood",
		["Unholy"] = "Unholy",
		["Frost"] = "Frost"
	}

	for i = 1,6 do
		RuneWatch.Mounts:Register("RUNE"..i, "Rune #"..i);
	end
	
	self.Mounts = {}
	for i = 1,6 do
		self.Mounts["RUNE"..i] = { }
	end
	
	-- bottom
	self.Mounts["RUNE1"]["bottom"] = { x = -45, y = 0 }
	self.Mounts["RUNE2"]["bottom"] = { x = -30, y = -35 }
	self.Mounts["RUNE3"]["bottom"] = { x = -24, y = 35 }
	self.Mounts["RUNE4"]["bottom"] = { x = 24, y = 35 }
	self.Mounts["RUNE5"]["bottom"] = { x = 30, y = -35 }
	self.Mounts["RUNE6"]["bottom"] = { x = 45, y = 0 }
	
	-- top
	self.Mounts["RUNE1"]["top"] = { x = -45, y = 0 }
	self.Mounts["RUNE2"]["top"] = { x = -30, y = 35 }
	self.Mounts["RUNE3"]["top"] = { x = -24, y = -35 }
	self.Mounts["RUNE4"]["top"] = { x = 24, y = -35 }
	self.Mounts["RUNE5"]["top"] = { x = 30, y = 35 }
	self.Mounts["RUNE6"]["top"] = { x = 45, y = 0 }
	
	self.Mounts["TOP"] = {}
	self.Mounts["TOP"]["bottom"] = { x = 0, y = 70 }
	self.Mounts["TOP"]["top"] = { x = 0, y = -70 }
	
	-- Bar Texture Transforms
	self.Bar = {}
	self.Bar.Transforms = {}
	self.Bar.Transforms["bottom"] = function(tex, perc)
		tex:SetTexCoord(0,0,0,1, perc, 0, perc, 1);
	end;
	self.Bar.Transforms["top"] = function(tex, perc)
		tex:SetTexCoord(0,1,0,0, perc, 1, perc, 0);
	end;

end

function Compact:InitConfig()
	-- Compact Skin Specific Configuration Options
	local options = {
		type = "group",
		name = "Compact",
		desc = self.Description,
		args = {
			dsc = {
				type = "description",
				order = 0,
				cmdHidden = true,
				dropdownHidden = true,
				name = "Configuration options for RuneWatch Skin: Compact"
			}
		}
	}
	
	Compact.Options = {};
end

function Compact:InitGui()
	local Gui = Compact.Gui;
	
	-- Base
	Gui.Base = Compact:BuildBase();
	
	-- Register the GUI
	self.GuiBase = Gui.Base;
end

function Compact:BuildBase()
	
	local frame = CreateFrame("frame", "RuneWatch_Compact", UIParent);
	frame:SetFrameStrata("LOW");
	frame:SetFrameLevel(0);
	frame:SetWidth(150);
	frame:SetHeight(150);
	frame:Show();
	
	local base = frame:CreateTexture("$parent_T_Base", "BACKGROUND");
	base:SetAllPoints(frame);
	base:Show();
	
	frame.Art = base;
	
	local rp = frame:CreateFontString("$parent_F_RP", "ARTWORK", "SystemFont_OutlineThick_Huge4");
	rp:SetText("0");
	rp:SetTextColor(1,0.5,0,1);	

	rp:SetPoint("CENTER", frame, "CENTER", 0, 0)
	rp:SetWidth(70);
	rp:SetHeight(70);
	rp:SetJustifyH("CENTER");
	rp:SetJustifyV("MIDDLE");
	
	frame.Counter = rp;
	
	return frame;
end

-- Updates the Gui
function Compact:UpdateGui()
	if (not Compact:IsActive("compact")) then
		return
	end
	
	Compact:UpdateStructure();

	local skinOptions = RuneWatch.db.skin;
	local Gui = Compact.Gui;
	
	if (skinOptions.theme == "~INVALID~") then
	else -- Eveything
		local theme = skinOptions.theme
		-- Textures
		Gui.Base.Art:SetTexture( (SkinArt.Base[theme] or SkinArt.Base.Generic) );
	end
	
	if (skinOptions.orientation == "top") then
		
	else -- DEFAULT / Bottom
	
	end
		
end

function Compact:UpdateStructure()
	if (not Compact:IsActive("compact")) then
		return
	end

	local ori = RuneWatch.db.skin.orientation;
	local theme = RuneWatch.db.skin.theme;
	
	local frame = Compact.Gui.Base;
	
	-- Base
	if (ori == "left") then
		-- NYI
	elseif (ori == "right") then
		-- NYI
	else -- TOP / BOTTOM / ERROR
		frame:SetWidth(150);
		frame:SetHeight(150);
		frame.Art:SetWidth(150);
		frame.Art:SetHeight(150);
		frame.Art:SetPoint("CENTER", frame, "CENTER");
	end
		
	frame = Compact.Gui.Base.Counter;
	
	-- Counter
	if (ori == "top") then
		-- NYI
		frame:SetPoint("CENTER", Compact.Gui.Base, "CENTER", 0, 0);
	elseif (ori == "left") then
		-- NYI
	elseif (ori == "right") then
		-- NYI
	else -- BOTTOM / ERROR
		frame:SetPoint("CENTER", Compact.Gui.Base, "CENTER", 0, 0);
	end
end

--[[ ================ Events ============= ]]

function Compact:RuneWatch_Gui_Update()
	Compact:UpdateGui();
end

function Compact:RuneWatch_Skins_Assign(event, skinID)
	if (skinID == "compact") then
		Compact.State.IsActive = true;
	else
		Compact.State.IsActive = false;
	end
end

function Compact:RuneWatch_RunicPower_Update(event, ...)
	local rp, rpm, perc, col = ...;
	
	
	local f = _G["RuneWatch_Compact"];
	-- Update Numerical Counter
	local cnt = f.Counter;
	cnt:SetText(rp);
end

function Compact:RuneWatch_Gui_DragEnable(event, ...)
	if (not Compact:IsActive(Compact.ID)) then
		return
	end
	
	local dframe = ...;
	
	dframe:SetAllPoints(Compact.Gui.Base.Art);
end
