--[[
	Basic RuneWatch Widget: Runic Power
	Author: Voorije (ReAn)
	Last Edited: 2009-02-19T10:24:20Z
]]

local L = LibStub("AceLocale-3.0"):GetLocale("RuneWatch");

assert(RuneWatch, L["Unable to locate RuneWatch Addon Object."]);

local Widget = RuneWatch:NewModule("Widget_RunicPower", RuneWatch.WidgetBase, "AceConsole-3.0", "AceEvent-3.0")
local Widgets = RuneWatch.Widgets;

function Widget:OnInitialize()
	self:Print("Initializing...");
	Widget.ID = "runic";
	Widget.Name = "Runic Power";
	Widget.Description = "Runic Power";

	self:InitOptions();
	self:InitGui();
	
	-- Register the Widget
	Widgets:Register(self.ID, self);
	
	-- Events
	Widget:RegisterEvent("UNIT_RUNIC_POWER");
	
	self:Super("OnInitialize");
end

function Widget:OnEnable()
	self:Super("OnEnable");
end

function Widget:OnDisable()
	self:Super("OnDisable");
end

function Widget:OnUpdate(frame, elapsed)
	frame.LastUpdate = frame.LastUpdate + elapsed;
	
	if (frame.LastUpdate > 0.5) then
		Widget:UpdateRunicPower();
		frame.LastUpdate = 0;
	end
end

function Widget:UpdateRunicPower()
	local rp = UnitMana("player");
	local rpMax = UnitManaMax("player");
	if (rpMax == 0) then rpMax = 1 end
	
	local perc = rp / rpMax;
	
	-- Color Blend
	local minC = RuneWatch.db.frame.rp.minColor;
	local maxC = RuneWatch.db.frame.rp.maxColor;
	
	local rpCol = RuneWatch:BlendColors(minC, maxC, perc);
	rpCol.a = (perc * 0.6) + 0.6;
	
	-- Fire Event
	RuneWatch:SendMessage("RuneWatch_RunicPower_Update", rp, rpMax, perc, rpCol);
end

--[===[ Initialization ]===]--
function Widget:InitOptions()
	local runic = {
		type = "group",
		name = L["Runic Power"],
		order = 2,
		desc = L["Runic Power Options"],
		args = {
			dsc = {
				type = "description",
				order = 0,
				cmdHidden = true,
				dropdownHidden = true,
				name = L["Configuration options for the runic power display(s) on the frame."]
			},
			bar = {
				type = "group",
				name = L["RP Bar Options"],
				desc = L["Runic Power: Bar Options"],
				order = 1,
				inline = true,
				args = {
					dsc = {
						type = "description",
						order = 0,
						cmdHidden = true,
						dropdownHidden = true,
						name = L["The Minimum Color / Maximum Color options are the two colors the rp bar fades between as it fills. Minimum represents the color of the bar at 0 runic power. Maximum represents the color of the bar at 100 (or 130) runic power."]
					},
					minColor = {
						type = "color",
						name = L["Minimum Color"],
						desc = L["Color of the Runic Power Bar at 0 runic power."],
						order = 1,
						hasAlpha = false,
						get = function(info) local v = RuneWatch.db.frame.rp.minColor; return v.r, v.g, v.b, v.a; end,
						set = function(info, re,gr,bl,al) RuneWatch.db.frame.rp.minColor = { r = re, g = gr, b = bl, a = al }; LibStub("AceEvent-3.0").events:Fire("UNIT_RUNIC_POWER", "player") end
					},
					maxColor = {
						type = "color",
						name = L["Maximum Color"],
						desc = L["Color of the Runic Power Bar at 100 (or 130) runic power."],
						order = 2,
						hasAlpha = false,
						get = function(info) local v = RuneWatch.db.frame.rp.maxColor; return v.r, v.g, v.b, v.a; end,
						set = function(info, re,gr,bl,al) RuneWatch.db.frame.rp.maxColor = { r = re, g = gr, b = bl, a = al }; LibStub("AceEvent-3.0").events:Fire("UNIT_RUNIC_POWER", "player") end
					}
				}
			}
		}
	}
	
	Widget.Options = runic;
end

function Widget:InitGui()
	local frame = CreateFrame("frame", "RuneWatch_RunicPower", UIParent);
	frame.LastUpdate = 0;
	frame:SetScript("OnUpdate", function(self, elapsed) Widget:OnUpdate(self, elapsed) end);
end

--[===[ Events ]===]--
function Widget:UNIT_RUNIC_POWER(event, ...)
	local who = ...;
	
	if (who == "player") then
		Widget:UpdateRunicPower();
	end
end
