--CONFIG--------------------------------------------
local x1 = 103		y1 = 23				-- Coordinate for the first blood and the second unholy rune
local x2 = 72		y2 = 61				-- Coordinate for the second blood and the first unholy rune
local x3 = 25		y3 = 80				-- Coordinate for the first and second frost runes
---------------------------------------------------------

SLASH_RUNEHUD1, SLASH_RUNEHUD2 = '/runehud', '/rh';
local function handler(msg, editbox)
local command, rest = msg:match("^(%S*)%s*(.-)$")
	if command == 's' then
		if tonumber(rest) ~= nil then 
			if tonumber(rest) > 0 then
				RHs = tonumber(rest)
				RuneFrame:SetScale(RHs)
			else
				print("RuneHUD: You need to use a valid value for the scale");
			end
		else
			print("RuneHUD: You need to use a valid value for the scale");
		end
	elseif command == 'aoc' then
		if tonumber(rest) ~= nil then 
			if tonumber(rest) >= 0 then
				RHaoc = tonumber(rest)
				if InCombatLockdown() == nil then
					RuneFrame:SetAlpha(RHaoc)
				end
			else
				print("RuneHUD: You need to use a valid value for the alpha");
			end
		else
			print("RuneHUD: You need to use a valid value for the alpha");
		end
	elseif command == 'aic' then
		if tonumber(rest) ~= nil then 
			if tonumber(rest) >= 0 then
				RHaic = tonumber(rest)
				if InCombatLockdown() then
					RuneFrame:SetAlpha(RHaic)
				end
			else
				print("RuneHUD: You need to use a valid value for the alpha");
			end
		else
			print("RuneHUD: You need to use a valid value for the alpha");
		end
	elseif command == 'aiv' then
		if tonumber(rest) ~= nil then 
			if tonumber(rest) >= 0 then
				RHaiv = tonumber(rest)
				if UnitInVehicleControlSeat("player") then
					RuneFrame:SetAlpha(RHaiv)
				end
			else
				print("RuneHUD: You need to use a valid value for the alpha");
			end
		else
			print("RuneHUD: You need to use a valid value for the alpha");
		end
	elseif command == 'hoc' and (tostring(rest) == "true" or tostring(rest) == "false") then
		RHhoc = tostring(rest)
	elseif command == 'hoc' then
		print("RuneHUD: You need to use either true or false with the fading option");
	else
		print("RuneHUD: The available slash commands are:");
		print("RuneHUD: '/rh s <scale>' for scaling");
		print("RuneHUD: '/rh aoc <alpha>' for out of combat alpha");
		print("RuneHUD: '/rh aic <alpha>' for alpha in combat");
		print("RuneHUD: '/rh aiv <alpha>' for alpha when in a vehicle");
		print("RuneHUD: '/rh hoc <true/false>' for cooldown fading");
	end
end
SlashCmdList["RUNEHUD"] = handler;



--Clearing the old position
RuneButtonIndividual1:ClearAllPoints()
RuneButtonIndividual2:ClearAllPoints()
RuneButtonIndividual3:ClearAllPoints()
RuneButtonIndividual4:ClearAllPoints()
RuneButtonIndividual5:ClearAllPoints()
RuneButtonIndividual6:ClearAllPoints()

--Setting the new position, change the x,y  values in the end of each line to move the runes
RuneButtonIndividual1:SetPoint("CENTER", UIParent, "CENTER", -x1, y1)
RuneButtonIndividual2:SetPoint("CENTER", UIParent, "CENTER", -x2, y2)
RuneButtonIndividual3:SetPoint("CENTER", UIParent, "CENTER", -x3, y3)
RuneButtonIndividual4:SetPoint("CENTER", UIParent, "CENTER", x3, y3)
RuneButtonIndividual5:SetPoint("CENTER", UIParent, "CENTER", x2, y2)
RuneButtonIndividual6:SetPoint("CENTER", UIParent, "CENTER", x1, y1)

--Making the runes click through
RuneButtonIndividual1:EnableMouse(false)
RuneButtonIndividual2:EnableMouse(false)
RuneButtonIndividual3:EnableMouse(false)
RuneButtonIndividual4:EnableMouse(false)
RuneButtonIndividual5:EnableMouse(false)
RuneButtonIndividual6:EnableMouse(false)

local function Runehud_OnEvent(self, event, ...)
	if event == "PLAYER_ENTERING_WORLD" then
		if RHs == nil then
			RHs = 1.2
		end
		if RHaoc == nil then
			RHaoc = 0.1
		end
		if RHaic == nil then
			RHaic = 1
		end
		if RHaiv == nil then
			RHaiv = 0
		end
		if RHhoc == nil then
			RHhoc = "true"
		end
	end
	
	if (event == "PLAYER_ENTERING_WORLD" or event == "PLAYER_REGEN_ENABLED") and not UnitInVehicleControlSeat("player") then
		RuneFrame:SetAlpha(RHaoc) 				
	elseif event == "PLAYER_REGEN_DISABLED" and not UnitInVehicleControlSeat("player") then
		RuneFrame:SetAlpha(RHaic)
	end
	
	if (event == "UNIT_ENTERED_VEHICLE" and UnitInVehicleControlSeat("player")) then
		RuneFrame:SetAlpha(RHaiv)					--Hides the runes when entering a vehicle
	elseif (event == "PLAYER_ENTERING_WORLD" or (event == "UNIT_EXITED_VEHICLE" and not UnitInVehicleControlSeat("player"))) and InCombatLockdown() then
		RuneFrame:SetAlpha(RHaic)					--Shows the runes once again (with in combat alpha) when exiting the vehicle
		RuneFrame:SetScale(RHs)		
	elseif event == "PLAYER_ENTERING_WORLD" or(event == "UNIT_EXITED_VEHICLE" and not UnitInVehicleControlSeat("player")) then 
		RuneFrame:SetAlpha(RHaoc) 					--Shows the runes once again (with out of combat alpha) when exiting the vehicle
		RuneFrame:SetScale(RHs)
	end
	
	if RHhoc == "true" then
		if event == "PLAYER_REGEN_DISABLED" or (event == "RUNE_POWER_UPDATE" and InCombatLockdown()) and not UnitInVehicleControlSeat("player") then 
			if GetRuneCooldown(1) > 0 then
				RuneButtonIndividual1:SetAlpha(RHaoc) else 
				RuneButtonIndividual1:SetAlpha(RHaic)
			end
			if GetRuneCooldown(2) > 0 then
				RuneButtonIndividual2:SetAlpha(RHaoc)else 
				RuneButtonIndividual2:SetAlpha(RHaic)
			end
			if GetRuneCooldown(3) > 0 then
				RuneButtonIndividual5:SetAlpha(RHaoc)else 
				RuneButtonIndividual5:SetAlpha(RHaic)
			end										--Cooldown fading
			if GetRuneCooldown(4) > 0 then
				RuneButtonIndividual6:SetAlpha(RHaoc)else 
				RuneButtonIndividual6:SetAlpha(RHaic)
			end
			if GetRuneCooldown(5) > 0 then
				RuneButtonIndividual3:SetAlpha(RHaoc)else 
				RuneButtonIndividual3:SetAlpha(RHaic)
			end
			if GetRuneCooldown(6) > 0 then
				RuneButtonIndividual4:SetAlpha(RHaoc)else 
				RuneButtonIndividual4:SetAlpha(RHaic)
			return
			end
		elseif (event == "PLAYER_REGEN_ENABLED" and not UnitInVehicleControlSeat("player")) or (event == "UNIT_EXITED_VEHICLE" and not UnitInVehicleControlSeat("player")) and InCombatLockdown() then
			RuneButtonIndividual1:SetAlpha(RHaic)
			RuneButtonIndividual2:SetAlpha(RHaic)
			RuneButtonIndividual3:SetAlpha(RHaic)
			RuneButtonIndividual4:SetAlpha(RHaic)
			RuneButtonIndividual5:SetAlpha(RHaic)
			RuneButtonIndividual6:SetAlpha(RHaic)
		end
	else return
	end
end



local f = CreateFrame("Frame","RuneHUDFrame",UIParent)
f:RegisterEvent("PLAYER_REGEN_DISABLED")
f:RegisterEvent("PLAYER_REGEN_ENABLED")
f:RegisterEvent("PLAYER_ENTERING_WORLD")
f:RegisterEvent("UNIT_EXITED_VEHICLE")
f:RegisterEvent("UNIT_ENTERED_VEHICLE")
f:RegisterEvent("RUNE_POWER_UPDATE")
f:SetScript("OnEvent", Runehud_OnEvent)
RuneFrame:SetParent(RuneHUDFrame)
