﻿-- Copyright © 2008,2009 Xianghar  <xian@zron.de>
-- All Rights Reserved.
-- This code is not to be modified or distributed without written permission by the author.
-- Current permissions only include curse.com, wowui.worldofwar.net, wowinterface.com and their respective addon updaters

--[[ talents:
1: elemental, without Totem  of Wrath
2: elemental with Totem of Wrath
3: enhancement without talented WF, Strength of Earth
4: enhancement with talented WF
5: enhancement with talented SoE
6: enhancement with both
7: healing
]]

local protocolver = 103

RaidTotems = {}

local GroupTalents = LibStub:GetLibrary("LibGroupTalents-1.0")


local RAID_CLASS_COLORS = CUSTOM_CLASS_COLORS or RAID_CLASS_COLORS

local EmptyIcon = "Interface\\Icons\\INV_Misc_QuestionMark"
local Icons = {}
local inRaid = false
local PlayerName = UnitName("player")

local RaidTotemSpells = {
    [FIRE_TOTEM_SLOT]  = {0,57722,58656,58745,58704,58734}, -- Wrath, FlameTongue, FrostResistance, Searing, Magma
    [EARTH_TOTEM_SLOT] = {0,58643,58751,8143,2484,}, -- StrengthOfEarth,  StoneSkin,  Tremor,  EarthBind
    [WATER_TOTEM_SLOT] = {0,58739,58774,58757,8170,}, -- FireResistance, ManaSpring, HealingStream, Cleansing
    [AIR_TOTEM_SLOT]   = {0,8512,3738,25574,8177,}, -- Windfury, WrathOfAir, NatureResistance, Grounding
}

local RaidTotemIcons = {
    [FIRE_TOTEM_SLOT]  = {},
    [EARTH_TOTEM_SLOT] = {},
    [WATER_TOTEM_SLOT] = {},
    [AIR_TOTEM_SLOT]   = {},
}

local TalentTextures = {
    "Interface\\Icons\\Spell_Shaman_ThunderStorm",        -- shown for ele shaman
    "Interface\\Icons\\Spell_Fire_TotemOfWrath",          -- shown for tow
    "Interface\\Icons\\Spell_Shaman_FeralSpirit",         -- shown for enh shaman
    "Interface\\Icons\\Spell_Nature_EarthBindTotem",      --shown for enh. totems (totem of strength icon!)
    "Interface\\Icons\\Spell_Nature_Windfury",            --shown for improved windfury
    "Interface\\Icons\\Spell_Nature_SkinofEarth",         --shown for Earth Shield
    "Interface\\Icons\\Spell_Frost_SummonWaterElemental", --shown for mana tide totem
	"Interface\\Icons\\Spell_Nature_MagicImmunity",       --shown for resto shaman
}

local Multicast_SpellIDs = {
    CallofSpirits = 66844,
    CallofElements = 66842,
    CallofAncestors = 66843,
}

local MultiCastActions = {
    [FIRE_TOTEM_SLOT]  = {[Multicast_SpellIDs.CallofElements]=133,[Multicast_SpellIDs.CallofAncestors]=137,[Multicast_SpellIDs.CallofSpirits]=141},
    [EARTH_TOTEM_SLOT] = {[Multicast_SpellIDs.CallofElements]=134,[Multicast_SpellIDs.CallofAncestors]=138,[Multicast_SpellIDs.CallofSpirits]=142},
    [WATER_TOTEM_SLOT] = {[Multicast_SpellIDs.CallofElements]=135,[Multicast_SpellIDs.CallofAncestors]=139,[Multicast_SpellIDs.CallofSpirits]=143},
    [AIR_TOTEM_SLOT]   = {[Multicast_SpellIDs.CallofElements]=136,[Multicast_SpellIDs.CallofAncestors]=140,[Multicast_SpellIDs.CallofSpirits]=144},
}

for i=1,4 do
    for k,v in pairs(RaidTotemSpells[i]) do
        if v == 0 then
            RaidTotemIcons[i][k] = EmptyIcon
        else
            RaidTotemIcons[i][k] = select(3,GetSpellInfo(v))
        end
    end
end

local GUIDs = {} -- GUIDs (value) of shamans in raid (key)
local Names = {} -- Maps GUIDs (key) to shamans in raid (value)

local RaidShamans = {} -- The names of the shamans in the raid (key) and their class (value, either 1=ele,2=enh,3=heal)
RaidTotems_Totems = {}  -- The totems assigned to every shaman, contains spellids, 0 if no totem chosen for that slot
local RaidTotemCompatible = {} -- which shaman uses a compatible totem manager addon
local RaidMembers = {}
local ClassColors = {}
RaidTotems_EarthShields = {}

RaidTotems_Channel = "---"
RaidTotems_Whisper = true

local RaidShamanFontStrings = {} -- fontstring for the shaman names
local RaidTotemFrames = {}       -- Frames showing the selected totems for each shaman
local RaidTotemButtons = {}      -- The totem menu to select totems, there is only one menu, thats moved approprietly
local TalentIcons = {}           -- The three icons indicating the the shamans spec and totem talents
local CompatibleIcons = {}       -- The colored dots which indicate whether a shaman has a compatible totem manager addon
local EarthShieldSelectors = {}
local MainTanks = {}

local PrimarySpecSpell = GetSpellInfo(63645)
local SecondarySpecSpell = GetSpellInfo(63644)


function RaidTotems.OpenRaidTotems(msg)
	RaidTotemsFrame:Show()
end


SLASH_RAIDTOTEMS1 = "/raidtotems"
SLASH_RAIDTOTEMS2 = "/rtt"
SlashCmdList["RAIDTOTEMS"] = RaidTotems.OpenRaidTotems


local function SetEarthShieldTo(self, shaman, name)
	RaidTotems_EarthShields[shaman] = name
	RaidTotemsFrame:Hide()
	RaidTotemsFrame:Show()
end

local function InitRaidMembersList(self, level)
	level = level or 1
	if level == 1 then
		local i = UIDropDownMenu_CreateInfo()
		i.text = "---"
		i.arg1 = self.shaman
		i.func = SetEarthShieldTo
		UIDropDownMenu_AddButton(i,level)
		for k,v in pairs(RaidMembers) do
			if #v > 0 then 
				local info = UIDropDownMenu_CreateInfo()
				info.text = k
				info.value = {k, self.shaman}
				if ClassColors[k].r then
					info.colorCode = "|c"..string.format("FF%02X%02X%02X", math.floor(ClassColors[k].r*255), math.floor(ClassColors[k].g*255), math.floor(ClassColors[k].b*255))
				end
				info.notCheckable = true
				info.hasArrow = true
				UIDropDownMenu_AddButton(info, level)
			end
		end
		i.text = "MainTanks"
		i.value = {"MainTanks", self.shaman}
		i.hasArrow = true
		i.colorCode = ""
		UIDropDownMenu_AddButton(i)
	elseif level == 2 then
		if UIDROPDOWNMENU_MENU_VALUE[1] == "MainTanks" then
			local mts = MainTanks
			if oRA and oRA.maintanktable and #oRA.maintanktable > 0 then
				mts = oRA.maintanktable
			end
			for i,name in pairs(mts) do
				local info = UIDropDownMenu_CreateInfo()
				info.func = SetEarthShieldTo
				info.text = "MT"..i.." ("..name..")"
				info.value = "MT"..i
				info.arg1 = UIDROPDOWNMENU_MENU_VALUE[2]
				info.arg2 = "MT"..i
				UIDropDownMenu_AddButton(info, level)
			end
			return
		end
		local rm = RaidMembers[UIDROPDOWNMENU_MENU_VALUE[1]]		
		for k,v in pairs(rm) do
			local info = UIDropDownMenu_CreateInfo()
			info.text = v
			info.value = v
			info.arg1 = UIDROPDOWNMENU_MENU_VALUE[2]
			info.arg2 = v
			info.func = SetEarthShieldTo
			local c = UIDROPDOWNMENU_MENU_VALUE[1]
			if ClassColors[c].r then
				info.colorCode = "|c"..string.format("FF%02X%02X%02X", math.floor(ClassColors[c].r*255), math.floor(ClassColors[c].g*255), math.floor(ClassColors[c].b*255))
			end
			UIDropDownMenu_AddButton(info, level)			
		end
	end
end

function RaidTotems.Init()
	-- prepare the frames for 10 possible shamans
	for i=1,10 do
		RaidTotemFrames[i] = {}
		RaidShamanFontStrings[i] = getglobal("RaidTotems_RaidShaman"..i)
		for j=1,4 do
			RaidTotemFrames[i][j] = CreateFrame("Frame", "RaidTotems_Totem"..i..j, RaidTotemsFrame, "RaidTotems_TotemTemplate")
			RaidTotemFrames[i][j].icon = getglobal("RaidTotems_Totem"..i..j.."Icon")
			RaidTotemFrames[i][j]:SetPoint("TOPLEFT", RaidTotemsFrame, "TOPLEFT", 118+j*40, -36-i*36)
			RaidTotemFrames[i][j].nr = i
			RaidTotemFrames[i][j].element = j
		end
		TalentIcons[i] = {}
		for j=1,4 do
			TalentIcons[i][j] = CreateFrame("Frame", "RaidTotems_Talent"..i..j, RaidTotemsFrame, "RaidTotems_TalentTemplate")
			TalentIcons[i][j].icon = getglobal("RaidTotems_Talent"..i..j.."Icon")
			TalentIcons[i][j].count = getglobal("RaidTotems_Talent"..i..j.."Count")
			if j == 1 then
				TalentIcons[i][j]:SetPoint("LEFT", "RaidTotems_RaidShaman"..i, "RIGHT", -45, 6)
			else
				TalentIcons[i][j]:SetPoint("LEFT", TalentIcons[i][j-1], "RIGHT", 0, 0)
			end
			TalentIcons[i][j]:SetFrameLevel(1)
            TalentIcons[i][j]:SetAlpha(0.5)
		end
		CompatibleIcons[i] = getglobal("RaidTotems_Compatible"..i)
		CompatibleIcons[i]:SetVertexColor(0.0,1.0,0.0)
		EarthShieldSelectors[i] = CreateFrame("Button", "RaidTotems_EarthShield"..i, RaidTotemsFrame, "UIDropDownMenuTemplate")
		EarthShieldSelectors[i].button = getglobal("RaidTotems_EarthShield"..i.."Button")
		UIDropDownMenu_SetWidth(EarthShieldSelectors[i], 90)
		EarthShieldSelectors[i]:SetPoint("LEFT", RaidTotemFrames[i][4], "RIGHT", -5)
		EarthShieldSelectors[i].displayMode = "MENU"
		EarthShieldSelectors[i].initialize = InitRaidMembersList
	end
	
	-- create the totem menu
	for i=1,6 do
		RaidTotemButtons[i] = CreateFrame("Button", "RaidTotems_TotemButton"..i, RaidTotemsFrame, "RaidTotems_ButtonTemplate")
		RaidTotemButtons[i].icon = getglobal("RaidTotems_TotemButton"..i.."Icon")
		RaidTotemButtons[i].spellnr = i
		RaidTotemButtons[i]:SetFrameLevel(RaidTotemButtons[i]:GetFrameLevel()+3)
	end
	
	RaidTotemsFrame:RegisterEvent("RAID_ROSTER_UPDATE")
	RaidTotemsFrame:RegisterEvent("CHAT_MSG_ADDON")
	RaidTotemsFrame:RegisterEvent("PLAYER_ENTERING_WORLD")
	RaidTotemsFrame:RegisterEvent("PLAYER_REGEN_ENABLED")
	RaidTotemsFrame:RegisterForDrag("LeftButton")
	RaidTotems_GUIHeaderText:SetText("RaidTotems "..tostring(GetAddOnMetadata("RaidTotems", "Version")))
	RaidTotems_CheckWhisperText:SetText(RaidTotemsLocale.whisper)
	RaidTotems_NewButton:SetText(RaidTotemsLocale.new)
	RaidTotems_RenameButton:SetText(RaidTotemsLocale.rename)
	RaidTotems_UpdateButton:SetText(RaidTotemsLocale.update)
	RaidTotems_DeleteButton:SetText(RaidTotemsLocale.delete)
	RaidTotems_LoadButton:SetText(RaidTotemsLocale.load)
    RaidTotems_OptionsButton:SetText("<<")
end




function RaidTotems.RaidTotemsFrame_OnShow(self)
    local c = 1
    for shaman, class in pairs(RaidShamans) do
        if c > 10 then return end
        RaidShamanFontStrings[c]:SetText(shaman)
		EarthShieldSelectors[c].shaman = shaman
		EarthShieldSelectors[c]:Show()
		if RaidTotems_EarthShields[shaman] then
			if strsub(RaidTotems_EarthShields[shaman],1,2) == "MT" then
				local i = tonumber(strsub(RaidTotems_EarthShields[shaman],3))
				local mts = MainTanks
				if oRA and oRA.maintanktable and #oRA.maintanktable > 0 then
					mts = oRA.maintanktable
				end
				if i and mts[i] then
					UIDropDownMenu_SetText(EarthShieldSelectors[c],tostring(RaidTotems_EarthShields[shaman].." ("..mts[i]..")"))
				else
					UIDropDownMenu_SetText(EarthShieldSelectors[c],tostring(RaidTotems_EarthShields[shaman]))
				end
			else
				UIDropDownMenu_SetText(EarthShieldSelectors[c],tostring(RaidTotems_EarthShields[shaman]))
			end
		else
			UIDropDownMenu_SetText(EarthShieldSelectors[c], "")
		end
        for i=1,4 do
            RaidTotemFrames[c][i]:Show()
            RaidTotemFrames[c][i].icon:SetTexture(RaidTotemIcons[i][RaidTotems_Totems[shaman][i]])
            RaidTotemFrames[c][i].shaman = shaman
        end
        if RaidTotemCompatible[shaman] then
			CompatibleIcons[c]:Show()
		else
			CompatibleIcons[c]:Hide()
		end
        for i=1,4 do
            TalentIcons[c][i].icon:SetTexture(nil)
			TalentIcons[c][i].count:SetText("")
        end
        local role = GroupTalents:GetGUIDRole(GUIDs[shaman])
        if role then
            if role == "caster" then
                local icon = GroupTalents:GetTreeIcons("SHAMAN")
                --TalentIcons[c][1].icon:SetTexture(TalentTextures[1]) -- show ele shaman
                TalentIcons[c][1].icon:SetTexture(icon)
            end
            if role == "melee" then
                local _,icon = GroupTalents:GetTreeIcons("SHAMAN")
                --TalentIcons[c][1].icon:SetTexture(TalentTextures[3]) -- show enh shaman
                TalentIcons[c][1].icon:SetTexture(icon)
            end
            if role == "healer" then
                local _,_,icon = GroupTalents:GetTreeIcons("SHAMAN")
                --TalentIcons[c][1].icon:SetTexture(TalentTextures[8]) -- show resto shaman
                TalentIcons[c][1].icon:SetTexture(icon)
            end
            local i = 2
            local talents = GroupTalents:GetGUIDTalents(GUIDs[shaman])
            if not talents then talents = {"","",""} end
            local talent = (talents[1]:byte(22) or 48)-48 -- tow
            if talent and talent > 0 then
                TalentIcons[c][i].icon:SetTexture(TalentTextures[2]) -- show tow
				TalentIcons[c][i].count:SetText("")
                i = i + 1
            end
            talent = (talents[2]:byte(1) or 48)-48 -- enhancing totems
            if talent and talent > 0 then
                TalentIcons[c][i].icon:SetTexture(TalentTextures[4]) -- show enhancing totems
                TalentIcons[c][i].count:SetText(talent)
                i = i + 1
            end
            talent = (talents[2]:byte(13) or 48) - 48 
            if talent and talent > 0 then
                TalentIcons[c][i].icon:SetTexture(TalentTextures[5]) -- show improved windfury
                TalentIcons[c][i].count:SetText(talent)
                i = i + 1
            end
            talent = (talents[3]:byte(17) or 48) - 48 
            if talent and talent > 0 then
                TalentIcons[c][i].icon:SetTexture(TalentTextures[7]) -- show mana tide
				TalentIcons[c][i].count:SetText("")
                i = i + 1
            end
            talent = (talents[3]:byte(23) or 48) - 48
            if talent and talent > 0 then
                TalentIcons[c][i].icon:SetTexture(TalentTextures[6]) -- show earth shield
				TalentIcons[c][i].count:SetText("")
            end
            talent = (talents[3]:byte(24) or 48) - 48  -- improved earth shield
            if talent and talent > 0 then
                TalentIcons[c][i].count:SetText(talent)
				i = i + 1
            end
        end
        c = c + 1
    end
    RaidTotemsFrame:SetHeight(80+c*36)
    for i = c,10 do
        for j=1,4 do
            RaidTotemFrames[i][j]:Hide()
        end
        for j=1,4 do
            TalentIcons[i][j].icon:SetTexture(nil)
			TalentIcons[i][j].count:SetText("")
        end
        CompatibleIcons[i]:Hide()
		EarthShieldSelectors[i]:Hide()
    end
end


function RaidTotems.TotemOnEnter(self)
    for i=1,#RaidTotemIcons[self.element] do
        RaidTotemButtons[i].icon:SetTexture(RaidTotemIcons[self.element][i])
        RaidTotemButtons[i].nr = self.nr
        RaidTotemButtons[i].element = self.element
        RaidTotemButtons[i].shaman = self.shaman
        if i==1 then
            RaidTotemButtons[i]:SetPoint("TOP", self, "BOTTOM")
        else
            RaidTotemButtons[i]:SetPoint("TOP", RaidTotemButtons[i-1], "BOTTOM")
        end
        RaidTotemButtons[i]:Show()
    end
    for i=#RaidTotemIcons[self.element]+1,6 do
        RaidTotemButtons[i]:Hide()
    end
end


function RaidTotems.TotemOnLeave(self)
    for i=1,#RaidTotemIcons[self.element] do
        if MouseIsOver(RaidTotemButtons[i]) then return end
    end
    for i=1,6 do
        RaidTotemButtons[i]:Hide()
    end
end


function RaidTotems.TotemButton_OnLeave(self)
    RaidTotems.TotemOnLeave(self)
end


function RaidTotems.TotemButton_OnClick(self)
    RaidTotemFrames[self.nr][self.element].icon:SetTexture(self.icon:GetTexture())
    RaidTotems_Totems[self.shaman][self.element] = self.spellnr
end


function RaidTotems.LibGroupTalents_Add(self, event, guid, unit, name, realm)
    GUIDs[name] = guid
    Names[guid] = name
end


function RaidTotems.LibGroupTalents_Update(guid, unit, newspec, n1, n2, n3)
    if RaidTotemsFrame:IsVisible() then RaidTotems.RaidTotemsFrame_OnShow(RaidTotemsFrame) end
end


function RaidTotems.LibGroupTalents_RoleChange(guid, unit, newrole, oldrole)
    if RaidTotemsFrame:IsVisible() then RaidTotems.RaidTotemsFrame_OnShow(RaidTotemsFrame) end
end


GroupTalents.RegisterCallback(RaidTotems, "LibGroupTalents_Add")
GroupTalents.RegisterCallback(RaidTotems, "LibGroupTalents_Update")
GroupTalents.RegisterCallback(RaidTotems, "LibGroupTalents_RoleChange")

local totemsqueued = false
local queuedtotems = {}

local function ProcessTotemQueue()
    if not TotemTimers and totemsqueued and not InCombatLockdown() and RaidTotems_Multicast and type(RaidTotems_Multicast) == "number" then
        totemsqueued = false
        for i = 1,4 do
            if queuedtotems[i] then
                local spells = {GetMultiCastTotemSpells(i)}
                for _,id in pairs(spells) do
                    local name = GetSpellInfo(id)
                    print(name)
                    if name == queuedtotems[i] then
                        SetMultiCastSpell(MultiCastActions[i][RaidTotems_Multicast], id)
                        break;
                    end
                end
                queuedtotems[i] = nil
            end                
        end
    end
end

function RaidTotems.RaidTotemsFrame_OnEvent(self, event, ...)
    if event == "RAID_ROSTER_UPDATE" or (event == "PLAYER_ENTERING_WORLD" and GetNumRaidMembers()>0) then
        local _,instance = IsInInstance() 
        if instance == "pvp" or instance == "arena" then return end
        local actShamans = {}
		for k,v in pairs(RaidMembers) do
			for x,y in pairs(v) do
				v[x] = nil
			end
		end
		wipe(MainTanks)
        for i=1,25 do
			local unit = "raid"..i
            if UnitExists(unit) then			
				local class,eclass = UnitClass(unit)
				if not RaidMembers[class] then RaidMembers[class] = {} end
				local name = UnitName(unit)
				table.insert(RaidMembers[class], name)
				ClassColors[class] = RAID_CLASS_COLORS[eclass]
				if GetPartyAssignment("MAINTANK", unit) then table.insert(MainTanks,name) end
				
				if eclass == "SHAMAN" then
					actShamans[name] = true
					if not RaidTotems_Totems[name] then
						RaidTotems_Totems[name] = {1,1,1,1} -- 1 ToW, 2 enhancing totems, 3 windfury totem, 4 manatide totem
					end
				end
            end
        end
        for k,v in pairs(RaidShamans) do
            if not actShamans[k] then
                RaidShamans[k] = nil
                RaidTotemCompatible[k] = nil
            end
        end
        for k,v in pairs(actShamans) do
            if not RaidShamans[k] then
                RaidShamans[k] = 0
            end
        end
        if RaidTotemsFrame:IsVisible() then RaidTotems.RaidTotemsFrame_OnShow(RaidTotemsFrame) end		
        local enteredRaid = not inRaid and GetNumRaidMembers()>0
        if enteredRaid then SendAddonMessage("RAIDTOTEMS", "getprotocol", "RAID") end
        inRaid = GetNumRaidMembers()>0
    elseif event == "CHAT_MSG_ADDON" then
        local prefix, msg, _, sender = ...
        if prefix == "RAIDTOTEMS" then
            if msg == "gettotems" then
            else
                local args = {strsplit(" ", msg)}
				if args[1] == "es" or args[1] == "esmt" then
					RaidTotems_EarthShields[args[2]] = args[3]
                elseif args[1] == "totems" then
					local added = false
                    for i=3,6 do
                        local spell = tonumber(args[i])
                        local sname, _, texture = GetSpellInfo(spell)
						for k,v in pairs(RaidTotemIcons[i-2]) do
                            if v == texture then
                                RaidTotems_Totems[args[2]][i-2] = k
                            end
                        end
                        if RaidTotems_Multicast and type(RaidTotems_Multicast) == "number" and spell > 0 then
                            queuedtotems[i-2] = sname
                            totemsqueued = true
                        end
                    end
                    if not InCombatLockdown() then ProcessTotemQueue() end
                elseif args[1] == "protocol" and args[2] then
                    if tonumber(args[2]) == protocolver then
                        RaidTotemCompatible[sender] = true
                    end
                end
				if RaidTotemsFrame:IsVisible() then RaidTotems.RaidTotemsFrame_OnShow(RaidTotemsFrame) end
            end
        end
    elseif event == "PLAYER_REGEN_ENABLED" then
        ProcessTotemQueue()
    end
end

function RaidTotems.SendButton_OnClick(self)
    if GetNumRaidMembers() == 0 then return end
	local channelnr
	local msgType
	if RaidTotems_Channel ~= "---" then
		if RaidTotems_Channel == "RAID" then msgType = "RAID"
		else
			msgType = "CHANNEL"
			channelnr = GetChannelName(RaidTotems_Channel)
		end
	end
    for shaman,v in pairs(RaidShamans) do
        SendAddonMessage("RAIDTOTEMS", "totems "..shaman.." "..RaidTotemSpells[1][RaidTotems_Totems[shaman][1]].." "
        ..RaidTotemSpells[2][RaidTotems_Totems[shaman][2]].." "..RaidTotemSpells[3][RaidTotems_Totems[shaman][3]].." "
        ..RaidTotemSpells[4][RaidTotems_Totems[shaman][4]].." ", "RAID")
        if not RaidTotemCompatible[shaman] and shaman ~= PlayerName and (RaidTotems_Channel == "---" or RaidTotems_Whisper) then
            local msg = RaidTotemsLocale.settotems
			local hastotems = false
            for i=1,4 do
                if RaidTotemSpells[i][RaidTotems_Totems[shaman][i]] > 0 then
                    local name = GetSpellInfo(RaidTotemSpells[i][RaidTotems_Totems[shaman][i]])
                    msg = msg..name..", "
					hastotems = true
                end
            end
			msg = strtrim(msg, ", ")
			if not hastotems then msg = msg..RaidTotemsLocale.none end
			msg = msg .. "."
            SendChatMessage(msg, "WHISPER", nil, shaman)
        end
		if  RaidTotems_Channel ~= "---" then
			local msg = shaman..": "
			local hastotems = false
            for i=1,4 do
                if RaidTotemSpells[i][RaidTotems_Totems[shaman][i]] > 0 then
                    local name = GetSpellInfo(RaidTotemSpells[i][RaidTotems_Totems[shaman][i]])
                    msg = msg..name..", "
					hastotems = true
                end
            end
			msg = strtrim(msg, ", ")
			if not hastotems then msg = msg..RaidTotemsLocale.none end
			msg = msg .. "."
			SendChatMessage(msg, msgType, nil, channelnr)
		end
    end
	for shaman,_ in pairs(RaidShamans) do
		local target
		local estarget = RaidTotems_EarthShields[shaman]
		if estarget then
			if strsub(estarget,1,2) == "MT" then
				local n = tonumber(strsub(estarget,3))
				local mts = MainTanks
				if oRA and oRA.maintanktable and #oRA.maintanktable > 0 then
					mts = oRA.maintanktable
				end
				if n and mts[n] then
					target = mts[n]
				end
			else
				target = estarget
			end
		end
		if target then 
			SendAddonMessage("RAIDTOTEMS", "es "..shaman.." "..target)
			if not RaidTotemCompatible[shaman] and shaman ~= PlayerName and (RaidTotems_Channel == "---" or RaidTotems_Whisper) then
				SendChatMessage(RaidTotemsLocale.es..target, "WHISPER", nil, shaman)
			end
			if RaidTotems_Channel ~= "---" then
				local sn = GetSpellInfo(49284) 
				SendChatMessage(sn..": "..shaman.." -> "..target, msgType, nil, channelnr)
			end
		end
		if estarget and strsub(estarget,1,2) == "MT" then
			SendAddonMessage("RAIDTOTEMS", "esmt "..shaman.." "..estarget)
		end
	end
end

local function SelectChannel(self, channel)
	RaidTotems_Channel = channel
	RaidTotems.ChannelSelect_OnShow(RaidTotems_ChannelSelect)
end

function RaidTotems.ChannelSelect_OnShow(self)
	local br 
	if RaidTotems_Channel ~= "RAID" and RaidTotems_Channel ~= "---" then br = GetChannelName(RaidTotems_Channel) end
	if br and br>0 then
		UIDropDownMenu_SetText(self, RaidTotems_Channel)
	elseif RaidTotems_Channel ~= "RAID" then
		RaidTotems_Channel = "---"
	end
	if RaidTotems_Channel == "RAID" then
		UIDropDownMenu_SetText(self, "Raid Chat")
	elseif RaidTotems_Channel == "---" then
		UIDropDownMenu_SetText(self, "")
	end	
end

function RaidTotems.LoadChannels(self)
	local info = {}
	info.notCheckable = 1
	info.func = SelectChannel
	info.text = "---"
	info.value = "---"
	info.arg1 = "---"
	UIDropDownMenu_AddButton(info)
	info.text = "Raid Chat"
	info.value = "RAID"
	info.arg1 = "RAID"
	UIDropDownMenu_AddButton(info)
	local channels = {GetChannelList()}
	local serverchannels = {EnumerateServerChannels()}
	for _,c in pairs(channels) do
		if type(c) == "string" then
			local serverchannel
			for _,sc in pairs(serverchannels) do
				if strsub(c,1,strlen(sc)) == sc then serverchannel = true end
			end
			if not serverchannel then
				info.text = c
				info.arg1 = c
				UIDropDownMenu_AddButton(info)
			end
		end
	end
end


-- Code for Sets

RaidTotems_Sets = {}
local SelectedSet = nil

StaticPopupDialogs["RAIDTOTEMS_NEWSET"] = {
	text = RaidTotemsLocale.newset,
	button1 = RaidTotemsLocale.new,
	button2 = CANCEL,
	OnAccept = function(self, arg1)
		local name = getglobal(self:GetName().."EditBox"):GetText()
		if not name then return end
		if RaidTotems_Sets[name] then 
			DEFAULT_CHAT_FRAME:AddMessage(string.format(RaidTotemsLocale.alreadyexists, name))
			return
		end
		for shaman,_ in pairs(RaidShamans) do
			if not RaidTotems_Sets[name] then RaidTotems_Sets[name] = {} end
			RaidTotems_Sets[name][shaman] = {}
			for i=1,4 do
				RaidTotems_Sets[name][shaman][i] = RaidTotems_Totems[shaman][i]
			end
			RaidTotems_Sets[name][shaman]["es"] = RaidTotems_EarthShields[shaman]
		end
		UIDropDownMenu_SetText(RaidTotems_SetSelect,name)
		SelectedSet = name
		RaidTotemsFrame:Hide()
		RaidTotemsFrame:Show()
	end,
	hasEditBox = 1,
	timeout = 0,
	whileDead = 1,
	hideOnEscape = 1
}

StaticPopupDialogs["RAIDTOTEMS_RENAMESET"] = {
	text = RaidTotemsLocale.renameset,
	button1 = RaidTotemsLocale.rename,
	button2 = CANCEL,
	OnAccept = function(self)
		if not SelectedSet or not RaidTotems_Sets[SelectedSet] then
			return
		end
		local newname = getglobal(self:GetName().."EditBox"):GetText()
		if newname then
			if RaidTotems_Sets[newname] then
				DEFAULT_CHAT_FRAME:AddMessage(string.format(RaidTotemsLocale.alreadyexists, name))
			end
			RaidTotems_Sets[newname] = RaidTotems_Sets[SelectedSet]
			RaidTotems_Sets[SelectedSet] = nil
			UIDropDownMenu_SetText(RaidTotems_SetSelect, newname)
			SelectedSet = newname
		end
		RaidTotemsFrame:Hide()
		RaidTotemsFrame:Show()
	end,
	hasEditBox = 1,
	timeout = 0,
	whileDead = 1,
	hideOnEscape = 1
}

local function SelectSet(self,arg1)
	SelectedSet = arg1
	UIDropDownMenu_SetText(RaidTotems_SetSelect, arg1)
end

function RaidTotems.InitSets(self)
	local info = {}
	info.func = SelectSet
	for name,set in pairs(RaidTotems_Sets) do
		info.text = name
		info.arg1 = name
		UIDropDownMenu_AddButton(info)
	end
end

function RaidTotems.UpdateSet()
	if not SelectedSet or not RaidTotems_Sets[SelectedSet] then return end
	for shaman,_ in pairs(RaidShamans) do
		if not RaidTotems_Sets[SelectedSet] then RaidTotems_Sets[SelectedSet] = {} end
		RaidTotems_Sets[SelectedSet][shaman] = {}
		for i=1,4 do
			RaidTotems_Sets[SelectedSet][shaman][i] = RaidTotems_Totems[shaman][i]
		end
		RaidTotems_Sets[SelectedSet][shaman]["es"] = RaidTotems_EarthShields[shaman]
	end
end

function RaidTotems.DeleteSet()
	if not SelectedSet or not RaidTotems_Sets[SelectedSet] then return end
	RaidTotems_Sets[SelectedSet] = nil
	SelectedSet = nil
	UIDropDownMenu_SetText(RaidTotems_SetSelect, "")
end

function RaidTotems.LoadSet()
	if not SelectedSet or not RaidTotems_Sets[SelectedSet] then return end
	for shaman,_ in pairs(RaidShamans) do
		if RaidTotems_Sets[SelectedSet][shaman] then
			for i=1,4 do
				RaidTotems_Totems[shaman][i] = RaidTotems_Sets[SelectedSet][shaman][i]
			end
			RaidTotems_EarthShields[shaman] = RaidTotems_Sets[SelectedSet][shaman]["es"]
		end
	end
	RaidTotemsFrame:Hide()
	RaidTotemsFrame:Show()
end

-- Quicklauncher if LibDataBroker is installed
if LibStub then
	local ldb = LibStub:GetLibrary("LibDataBroker-1.1")
	if ldb then
		ldb:NewDataObject("RaidTotems", {
			type = "launcher",
			icon = "Interface\\Icons\\Spell_Nature_NullWard",
			OnClick = function(clickedframe, button)
				if button == "LeftButton" then
					RaidTotems.OpenRaidTotems()
				else
					RaidTotems_SendButton_OnClick(RaidTotems_SendButton)
				end
			end,
		})
	end		
end

function RaidTotems.OptionsButton_OnClick(self)
    self.open = not self.open
    if self.open then
        RaidTotemsOptionsFrame:Show()
        self:SetText(">>")
    else
        RaidTotemsOptionsFrame:Hide()
        self:SetText("<<")
    end
end


function RaidTotems.InitMulticastSelect(self)
	local info = {}
	info.notCheckable = 1
	info.func = RaidTotems.SelectMulticastSpell
	info.text = "---"
	info.value = "---"
	info.arg1 = "---"
	UIDropDownMenu_AddButton(info)
	for _,c in pairs(Multicast_SpellIDs) do
        local spell = GetSpellInfo(c)
        info.text = spell
        info.value = c
        info.arg1 = c
		UIDropDownMenu_AddButton(info)
	end
end

function RaidTotems.SelectMulticastSpell(self, spell)
    RaidTotems_Multicast = spell
	RaidTotems.MulticastSelect_OnShow(RaidTotems_MulticastSelect)
end

function RaidTotems.MulticastSelect_OnShow(self)
    if not RaidTotems_Multicast or RaidTotems_Multicast == "---" then
        UIDropDownMenu_SetText(self, "---")
    else 
        local spell = GetSpellInfo(RaidTotems_Multicast)
        UIDropDownMenu_SetText(self, spell)
    end
end