---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local keyboardShortcutLocales = {
    ["Right Click"] = {
        ["ptBR"] = "Clique direito",
        ["ruRU"] = "ПКМ",
        ["deDE"] = "Rechtsklick",
        ["koKR"] = "오른쪽 클릭",
        ["esMX"] = "Clic der.",
        ["enUS"] = true,
        ["zhCN"] = "右键",
        ["zhTW"] = "右鍵",
        ["esES"] = "Clic der.",
        ["frFR"] = "Clic Droit ",
    },
    ["Left Click"] = {
        ["ptBR"] = "Clique esquerdo",
        ["ruRU"] = "ЛКМ",
        ["deDE"] = "Linksklick",
        ["koKR"] = "왼쪽 클릭",
        ["esMX"] = "Clic izq.",
        ["enUS"] = true,
        ["zhCN"] = "左键",
        ["zhTW"] = "左鍵",
        ["esES"] = "Clic izq.",
        ["frFR"] = "Clic Gauche",
    },
    ["Alt"] = {
        ["ptBR"] = true,
        ["ruRU"] = true,
        ["deDE"] = true,
        ["koKR"] = true,
        ["esMX"] = true,
        ["enUS"] = true,
        ["zhCN"] = true,
        ["zhTW"] = true,
        ["esES"] = true,
        ["frFR"] = true,
    },
    ["Control"] = {
        ["ptBR"] = "Ctrl",
        ["ruRU"] = "Ctrl",
        ["deDE"] = "Strg",
        ["koKR"] = "Ctrl",
        ["esMX"] = "Ctrl",
        ["enUS"] = true,
        ["zhCN"] = "Ctrl",
        ["zhTW"] = "Ctrl",
        ["esES"] = "Ctrl",
        ["frFR"] = "Ctrl",
    },
    ["Ctrl + Left Click"] = {
        ["ptBR"] = "Ctrl + Clique esquerdo",
        ["ruRU"] = "Ctrl + ЛКМ",
        ["deDE"] = "Strg + Linksklick",
        ["koKR"] = "Ctrl + 왼쪽 클릭",
        ["esMX"] = "Ctrl + Clic izq.",
        ["enUS"] = true,
        ["zhCN"] = "Ctrl + 左键",
        ["zhTW"] = "Ctrl + 左鍵",
        ["esES"] = "Ctrl + Clic izq.",
        ["frFR"] = "Ctrl + Clic Gauche ",
    },
    ["Ctrl + Right Click"] = {
        ["ptBR"] = "Ctrl + Clique direito",
        ["ruRU"] = "Ctrl + ПКМ",
        ["deDE"] = "Strg + Rechtsklick",
        ["koKR"] = "Ctrl + 오른쪽 클릭",
        ["esMX"] = "Ctrl + Clic der.",
        ["enUS"] = true,
        ["zhCN"] = "Ctrl + 右键",
        ["zhTW"] = "Ctrl + 右鍵",
        ["esES"] = "Ctrl + Clic der.",
        ["frFR"] = "Ctrl + Clic Droit ",
    },
    ["Ctrl + Left Click + Hold"] = {
        ["ptBR"] = "Ctrl + Clique esquerdo + Manter pressionado",
        ["ruRU"] = "Зажать Ctrl + ЛКМ",
        ["deDE"] = "Strg + Linksklick + Halten",
        ["koKR"] = "Ctrl + 왼쪽 클릭 길게누르기",
        ["esMX"] = "Ctrl + Clic izq. + Mantener",
        ["enUS"] = true,
        ["zhCN"] = "Ctrl +左键+保持",
        ["zhTW"] = "Ctrl + 長按左鍵",
        ["esES"] = "Ctrl + Clic izq. + Mantener",
        ["frFR"] = "Ctrl + Clic Gauche + Maintenir",
    },
    ["Ctrl + Shift + Left Click"] = {
        ["ptBR"] = "Ctrl + Shift + Clique esquerdo",
        ["ruRU"] = "Ctrl + Shift + ЛКМ",
        ["deDE"] = "Strg + Shift + Linksklick",
        ["koKR"] = "Ctrl + Shift + 왼쪽 클릭",
        ["esMX"] = "Ctrl + Mayús + Clic izq.",
        ["enUS"] = true,
        ["zhCN"] = "Ctrl + Shift + 左键",
        ["zhTW"] = "Ctrl + Shift + 左鍵",
        ["esES"] = "Ctrl + Mayús + Clic izq.",
        ["frFR"] = "Ctrl + Maj + Clic Gauche ",
    },
    ["Shift"] = {
        ["ptBR"] = true,
        ["ruRU"] = true,
        ["deDE"] = "Umschalt",
        ["koKR"] = "Shift",
        ["esMX"] = "Mayús",
        ["enUS"] = true,
        ["zhCN"] = true,
        ["zhTW"] = true,
        ["esES"] = "Mayús",
        ["frFR"] = "Maj",
    },
    ["Hold Shift"] = {
        ["ptBR"] = "Manter Shift",
        ["ruRU"] = "Зажмите Shift",
        ["deDE"] = "Shift halten",
        ["koKR"] = "Shift 길게누르기",
        ["esMX"] = "Mantener Mayús",
        ["enUS"] = true,
        ["zhCN"] = "按住Shift查看更多",
        ["zhTW"] = "按住Shift",
        ["esES"] = "Mantener Mayús",
        ["frFR"] = "Maintenir Maj",
    },
    ["Left Click + Hold"] = {
        ["ptBR"] = "Clique esquerdo + Manter pressionado",
        ["ruRU"] = "Зажать ЛКМ",
        ["deDE"] = "Linksklick + Halten",
        ["koKR"] = "왼쪽 클릭 길게누르기",
        ["esMX"] = "Clic izq. + Mantener",
        ["enUS"] = true,
        ["zhCN"] = "左键单击并按住",
        ["zhTW"] = "按住左鍵",
        ["esES"] = "Clic izq. + Mantener",
        ["frFR"] = "Clic Gauche + Maintenir",
    },
}

for k, v in pairs(keyboardShortcutLocales) do
    l10n.translations[k] = v
end
