---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local weaponSkillLocales = {
    ["One-Handed Swords"] = {
        ["ptBR"] = "Espadas de Uma Mão",
        ["ruRU"] = "Одноручные мечи",
        ["deDE"] = "Einhandschwerter",
        ["koKR"] = "한손검류",
        ["esMX"] = "Espadas de una mano",
        ["enUS"] = true,
        ["zhCN"] = "单手剑",
        ["zhTW"] = "單手劍",
        ["esES"] = "Espadas de una mano",
        ["frFR"] = "Épées à une main",
    },
    ["One-Handed Maces"] = {
        ["ptBR"] = "Maças de Uma Mão",
        ["ruRU"] = "Одноручные дробящие",
        ["deDE"] = "Einhandstreitkolben",
        ["koKR"] = "한손둔기류",
        ["esMX"] = "Mazas de una mano",
        ["enUS"] = true,
        ["zhCN"] = "单手锤",
        ["zhTW"] = "單手錘",
        ["esES"] = "Mazas de una mano",
        ["frFR"] = "Masse à une main",
    },
    ["One-Handed Axes"] = {
        ["ptBR"] = "Machados de Uma Mão",
        ["ruRU"] = "Одноручные топоры",
        ["deDE"] = "Einhandäxte",
        ["koKR"] = "한손도끼류",
        ["esMX"] = "Hachas de una mano",
        ["enUS"] = true,
        ["zhCN"] = "单手斧",
        ["zhTW"] = "單手斧",
        ["esES"] = "Hachas de una mano",
        ["frFR"] = "Haches à une main",
    },
    ["Two-Handed Swords"] = {
        ["ptBR"] = "Espadas de Duas Mãos",
        ["ruRU"] = "Двуручные мечи",
        ["deDE"] = "Zweihandschwerter",
        ["koKR"] = "양손검류",
        ["esMX"] = "Espadas de dos manos",
        ["enUS"] = true,
        ["zhCN"] = "双手剑",
        ["zhTW"] = "雙手劍",
        ["esES"] = "Espadas de dos manos",
        ["frFR"] = "Épées à deux mains",
    },
    ["Two-Handed Maces"] = {
        ["ptBR"] = "Maças de Duas Mãos",
        ["ruRU"] = "Двуручные дробящие",
        ["deDE"] = "Zweihandstreitkolben",
        ["koKR"] = "양손둔기류",
        ["esMX"] = "Mazas de dos manos",
        ["enUS"] = true,
        ["zhCN"] = "双手锤",
        ["zhTW"] = "雙手錘",
        ["esES"] = "Mazas de dos manos",
        ["frFR"] = "Masses à deux mains",
    },
    ["Two-Handed Axes"] = {
        ["ptBR"] = "Machados de Duas Mãos",
        ["ruRU"] = "Двуручные топоры",
        ["deDE"] = "Zweihandäxte",
        ["koKR"] = "양손도끼류",
        ["esMX"] = "Hachas de dos manos",
        ["enUS"] = true,
        ["zhCN"] = "双手斧",
        ["zhTW"] = "雙手斧",
        ["esES"] = "Hachas de dos manos",
        ["frFR"] = "Haches à deux mains",
    },
    ["Fist Weapons"] = {
        ["ptBR"] = "Armas de Punho",
        ["ruRU"] = "Кистевое оружие",
        ["deDE"] = "Faustwaffen",
        ["koKR"] = "장착 무기류",
        ["esMX"] = "Armas de puño",
        ["enUS"] = true,
        ["zhCN"] = "拳套",
        ["zhTW"] = "拳套",
        ["esES"] = "Armas de puño",
        ["frFR"] = "Armes de pugilat",
    },
    ["Daggers"] = {
        ["ptBR"] = "Adagas",
        ["ruRU"] = "Кинжалы",
        ["deDE"] = "Dolche",
        ["koKR"] = "단검류",
        ["esMX"] = "Dagas",
        ["enUS"] = true,
        ["zhCN"] = "匕首",
        ["zhTW"] = "匕首",
        ["esES"] = "Dagas",
        ["frFR"] = "Dagues",
    },
    ["Thrown"] = {
        ["ptBR"] = "Arremesso",
        ["ruRU"] = "Метательное оружие",
        ["deDE"] = "Wurfwaffen",
        ["koKR"] = "투척 무기류",
        ["esMX"] = "Arrojadizas",
        ["enUS"] = true,
        ["zhCN"] = "投掷",
        ["zhTW"] = "投擲武器",
        ["esES"] = "Arrojadizas",
        ["frFR"] = "Armes de jet",
    },
    ["Bows"] = {
        ["ptBR"] = "Arcos",
        ["ruRU"] = "Луки",
        ["deDE"] = "Bögen",
        ["koKR"] = "활류",
        ["esMX"] = "Arcos",
        ["enUS"] = true,
        ["zhCN"] = "弓",
        ["zhTW"] = "弓",
        ["esES"] = "Arcos",
        ["frFR"] = "Arcs",
    },
    ["Crossbows"] = {
        ["ptBR"] = "Bestas",
        ["ruRU"] = "Арбалеты",
        ["deDE"] = "Armbrüste",
        ["koKR"] = "석궁류",
        ["esMX"] = "Ballestas",
        ["enUS"] = true,
        ["zhCN"] = "弩",
        ["zhTW"] = "弩",
        ["esES"] = "Ballestas",
        ["frFR"] = "Arbalètes",
    },
    ["Guns"] = {
        ["ptBR"] = "Armas de Fogo",
        ["ruRU"] = "Огнестрельное оружие",
        ["deDE"] = "Schusswaffen",
        ["koKR"] = "총기류",
        ["esMX"] = "Armas de fuego",
        ["enUS"] = true,
        ["zhCN"] = "枪械",
        ["zhTW"] = "槍械",
        ["esES"] = "Armas de fuego",
        ["frFR"] = "Armes à feu",
    },
    ["Staves"] = {
        ["ptBR"] = "Cajados",
        ["ruRU"] = "Посохи",
        ["deDE"] = "Stäbe",
        ["koKR"] = "지팡이류",
        ["esMX"] = "Bastones",
        ["enUS"] = true,
        ["zhCN"] = "法杖",
        ["zhTW"] = "法杖",
        ["esES"] = "Bastones",
        ["frFR"] = "Bâtons",
    },
    ["Polearms"] = {
        ["ptBR"] = "Armas de Haste",
        ["ruRU"] = "Древковое оружие",
        ["deDE"] = "Stangenwaffen",
        ["koKR"] = "장창류",
        ["esMX"] = "Armas de asta",
        ["enUS"] = true,
        ["zhCN"] = "长柄武器",
        ["zhTW"] = "長柄武器",
        ["esES"] = "Armas de asta",
        ["frFR"] = "Armes d'hast",
    },
}

for k, v in pairs(weaponSkillLocales) do
    l10n.translations[k] = v
end