---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local trackerOptionsLocales = {
    ["Tracker"] = {
        ["ptBR"] = "Rastreador",
        ["ruRU"] = "Трекер",
        ["deDE"] = "Tracker",
        ["koKR"] = "추적기",
        ["esMX"] = "Rastreador",
        ["enUS"] = true,
        ["zhCN"] = "追踪",
        ["zhTW"] = "任務清單",
        ["esES"] = "Rastreador",
        ["frFR"] = "Suivi",
    },
    ["Tracker Options"] = {
        ["ptBR"] = "Opções do rastreador para missões",
        ["ruRU"] = "Настройки трекера (окна отслеживания) заданий",
        ["deDE"] = "Questie-Tracker Einstellungen",
        ["koKR"] = "퀘스트 추적기 설정",
        ["esMX"] = "Opciones del rastreador",
        ["enUS"] = true,
        ["zhCN"] = "任务追踪选项",
        ["zhTW"] = "任務清單選項",
        ["esES"] = "Opciones del rastreador",
        ["frFR"] = "Options du suivi des quêtes",
    },
    ---------------------------------------------------------
    ["Auto Track Quests"] = {
        ["ptBR"] = "Missões de rastreamento automático",
        ["ruRU"] = "Автоотслеживание",
        ["deDE"] = "Quests automatisch verfolgen",
        ["koKR"] = "자동 추적 퀘스트",
        ["esMX"] = "Rastrear misiones automáticamente",
        ["enUS"] = true,
        ["zhCN"] = "自动追踪任务",
        ["zhTW"] = "自動追蹤所有任務",
        ["esES"] = "Rastrear misiones automáticamente",
        ["frFR"] = "Suivi auto des quêtes",
    },
    ["This is the same as 'Enable Automatic Quest Tracking' in the Blizzard Interface Options. When enabled, the Questie Tracker will automatically track all Quests in your Quest Log. Disabling this option will untrack all Quests. You will have to manually select which Quests to track.\n\nNOTE: 'Show Complete Quests' is disabled while this option is not being used."] = {
        ["ptBR"] = "É o mesmo que 'Ativar rastreamento automático de missões' nas opções da interface. Quando ativado, o Questie Rastreador rastreia automaticamente todas as missões em seu registro. Isso evita o rastreamento manual com a tecla Shift pressionada.",
        ["ruRU"] = "Когда включено, трекер будет автоматически отслеживать все задания в вашем журнале (это то же самое, что и 'Отслеживание заданий' в настройках интерфейса игры). Отключение данной настройки приведет к отмене отслеживания всех заданий в вашем журнале, вам придется вручную выбрать задания для отслеживания.\n\nПРИМЕЧАНИЕ: Настройка 'Выполненные задания' будет отключена при отключении данной настройки",
        ["deDE"] = "Dies ist dasselbe wie 'Automatische Questverfolgung aktivieren' in den Schnittstellenoptionen. Wenn aktiviert, verfolgt der Questie-Tracker automatisch alle Quests im Questlog. Dies verhindert die manuelle Verfolgung durch 'Umschalten + Linksklick'.",
        ["koKR"] = "인터페이스 옵션의 '자동 퀘스트 추적 사용 '과 동일합니다. 활성화하면 Questie Tracker가 로그의 모든 퀘스트를 자동으로 추적합니다. 이렇게하면 Shift- 클릭 수동 추적이 방지됩니다.",
        ["esMX"] = "Esto es lo mismo que 'Habilitar el seguimiento automático de misiones' en las opciones de la interfaz. Cuando está habilitado, el rastreador rastreará automáticamente todas las misiones en tu registro. Esto evita el seguimiento manual de clic de cambio.",
        ["enUS"] = true,
        ["zhCN"] = "这与界面选项中的“启用自动任务跟踪”相同。 启用后，Questie 追踪将自动追踪日志中的所有任务。 这样可以防止按住Shift键单击手动追踪。",
        ["zhTW"] = "和遊戲內建的選項 '啟用自動追蹤任務' 相同。啟用時，Questie 任務清單將會自動追蹤任務日誌中的所有任務。停用此選項將會取消追蹤所有任務，必須手動選擇要追蹤的任務。\n\n注意: 停用此選項時也會停用 '顯示已完成的任務'。",
        ["esES"] = "Esto es lo mismo que 'Habilitar el seguimiento automático de misiones' en las opciones de la interfaz. Cuando está habilitado, el rastreador rastreará automáticamente todas las misiones en tu registro. Esto evita el seguimiento manual de clic de cambio.",
        ["frFR"] = "Cela revient à utiliser 'Activer le suivi automatique des quêtes' dans les options d'interface. Le suivi des quêtes suivra alors automatiquement toutes les quêtes de votre journal et cela empêchera le suivi manuel Maj-clic.",
    },
    ---------------------------------------------------------
    ["Show Completed Quests"] = {
        ["ptBR"] = "Mostrar missões concluídas",
        ["ruRU"] = "Выполненные задания",
        ["deDE"] = "Abgeschlossene Quests anzeigen",
        ["koKR"] = "완료된 퀘스트 표시",
        ["esMX"] = "Mostrar misiones completadas",
        ["enUS"] = true,
        ["zhCN"] = "显示已完成的任务",
        ["zhTW"] = "顯示已完成的任務",
        ["esES"] = "Mostrar misiones completadas",
        ["frFR"] = "Afficher quêtes terminées",
    },
    ["When this is checked, completed Quests will show in the Questie Tracker.\n\nNOTE: This setting only works when 'Auto Track Quests' is enabled."] = {
        ["ptBR"] = "Quando esta opção está marcada, as missões completadas serão exibidas no rastreador de missões do Questie.\n\nNOTA: Esta configuração só funciona quando 'Rastrear missões automaticamente' está ativado.",
        ["ruRU"] = "Показать/скрыть выполненные задания в трекере.\n\nПРИМЕЧАНИЕ: Эта настройка работает только при включенной настройке 'Автоотслеживание'",
        ["deDE"] = "Wenn diese Option aktiviert ist, werden abgeschlossene Quests im Questie-Tracker angezeigt.\n\nHINWEIS: Diese Einstellung funktioniert nur, wenn 'Quests automatisch verfolgen' aktiviert ist.",
        ["koKR"] = false,
        ["esMX"] = "Cuando está marcado, las misiones completadas se mostrarán en el rastreador.\n\nNOTA: esta configuración solo funciona cuando el 'Rastrear misiones automáticamente' está habilitado.",
        ["enUS"] = true,
        ["zhCN"] = "启用时，任务列表中会显示已完成的任务\n\n注意: 必须先启用 '自动追踪所有任务'，此设置才有用。",
        ["zhTW"] = "啟用時，任務清單中會顯示已完成的任務。\n\n注意: 必須先啟用 '自動追蹤所有任務'，此設定才有效果。",
        ["esES"] = "Cuando está marcado, las misiones completadas se mostrarán en el rastreador.\n\nNOTA: esta configuración solo funciona cuando el 'Rastrear misiones automáticamente' está habilitado.",
        ["frFR"] = "Si cette option est cochée, les quêtes terminées s'afficheront dans le suivi de quêtes de Questie.\n\nNOTE : Ce paramètre ne fonctionne que lorsque l'option 'Suivi automatique des quêtes' est activée.",
    },
    ---------------------------------------------------------
    ["Show Quest Level"] = {
        ["ptBR"] = "Mostrar nível da missão",
        ["ruRU"] = "Уровень заданий",
        ["deDE"] = "Questlevel anzeigen",
        ["koKR"] = "퀘스트 레벨 표시",
        ["esMX"] = "Mostrar nivel de misión",
        ["enUS"] = true,
        ["zhCN"] = "显示任务等级",
        ["zhTW"] = "顯示任務等級",
        ["esES"] = "Mostrar nivel de misión",
        ["frFR"] = "Afficher le niveau des quêtes",
    },
    ["When this is checked, the Quest Level Tags for Quest Titles will show in the Questie Tracker."] = {
        ["ptBR"] = "Quando isso estiver marcado, as tags de nível de missão para títulos de missão serão exibidas no Questie Rastreador.",
        ["ruRU"] = "Показать/скрыть уровень заданий слева от их названий",
        ["deDE"] = "Wenn diese Option aktiviert ist, werden die Quest-Level-Tags für Quest-Titel im Questie-Tracker angezeigt.",
        ["koKR"] = "이 옵션을 선택하면 퀘스트 제목에 대한 퀘스트 레벨 태그가 Questie 트래커에 표시됩니다.",
        ["esMX"] = "Cuando esto está marcado, las etiquetas de nivel de búsqueda para los títulos de búsqueda se mostrarán en el rastreador.",
        ["enUS"] = true,
        ["zhCN"] = "选中后，任务标题的任务等级将显示在Questie追踪窗口",
        ["zhTW"] = "啟用時，任務清單中的任務標題將會顯示任務等級。",
        ["esES"] = "Cuando esto está marcado, las etiquetas de nivel de búsqueda para los títulos de búsqueda se mostrarán en el rastreador.",
        ["frFR"] = "Affiche le niveau des quêtes avec le titre des quêtes.",
    },
    ---------------------------------------------------------
    ["Auto Minimize Completed Quests"] = {
        ["ptBR"] = "Minimizar missões concluídas",
        ["ruRU"] = "Свернуть выполненные",
        ["deDE"] = "Abgeschlossene Quests automatisch minimieren",
        ["koKR"] = false,
        ["esMX"] = "Minimizar misiones completadas",
        ["enUS"] = true,
        ["zhCN"] = "自动收起已完成的任务",
        ["zhTW"] = "自動最小化已完成的任務",
        ["esES"] = "Minimizar misiones completadas",
        ["frFR"] = "Réduire les quêtes terminées",
    },
    ["When this is checked, completed Quests will automatically minimize."] = {
        ["ptBR"] = "Quando isso estiver marcado, as missões concluídas serão automaticamente minimizadas.",
        ["ruRU"] = "Когда включено, задания будут автоматически сворачиваться после их выполнения",
        ["deDE"] = "Wenn dies aktiviert ist, werden abgeschlossene Quests automatisch minimiert.",
        ["koKR"] = "이 옵션을 선택하면 완료된 퀘스트가 자동으로 최소화됩니다.",
        ["esMX"] = "Cuando esto está marcado, las misiones completadas se minimizarán automáticamente",
        ["enUS"] = true,
        ["zhCN"] = "选中后，已完成的任务将自动收起",
        ["zhTW"] = "啟用時，已完成的任務會自動收合起來。",
        ["esES"] = "Cuando esto está marcado, las misiones completadas se minimizarán automáticamente",
        ["frFR"] = "Réduit automatique les quêtes terminées.",
    },
    ---------------------------------------------------------
    ["Hide Completed Quest Objectives"] = {
        ["ptBR"] = "Ocultar objetivos de missões concluídos",
        ["ruRU"] = "Скрыть выполн. цели заданий",
        ["deDE"] = "Abgeschlossene Quest-Ziele ausblenden",
        ["koKR"] = false,
        ["esMX"] = "Ocultar objetivos completados",
        ["enUS"] = true,
        ["zhCN"] = "隐藏已完成的任务目标",
        ["zhTW"] = "隱藏已完成的任務目標",
        ["esES"] = "Ocultar objetivos completados",
        ["frFR"] = "Cacher les objectifs de quêtes terminés",
    },
    ["When this is checked, completed Quest Objectives will automatically be removed from the Questie Tracker."] = {
        ["ptBR"] = "Quando esta opção está marcada, os objetivos de missões concluídos serão automaticamente removidos do rastreador de missões do Questie.",
        ["ruRU"] = "Когда включено, выполненные цели заданий будут автоматически изъяты из трекера",
        ["deDE"] = "Wenn diese Option aktiviert ist, werden abgeschlossene Quest-Ziele automatisch aus dem Questie-Tracker entfernt.",
        ["koKR"] = false,
        ["esMX"] = "Cuando está marcado, los objetivos de misión completados se eliminarán automáticamente del rastreador.",
        ["enUS"] = true,
        ["zhCN"] = "启用时，已完成的任务目标将会自动从任务列表中移除。",
        ["zhTW"] = "啟用時，已完成的任務目標將會自動從任務清單中移除。",
        ["esES"] = "Cuando está marcado, los objetivos de misión completados se eliminarán automáticamente del rastreador.",
        ["frFR"] = "Si cette option est cochée, les objectifs de quêtes terminés seront automatiquement supprimés du suivi de quêtes de Questie.",
    },
    ---------------------------------------------------------
    ["Hide Blizzard Completion Text"] = {
        ["ptBR"] = "Ocultar texto de conclusão da Blizzard",
        ["ruRU"] = "Скрыть текст Blizzard",
        ["deDE"] = "Blizzards Quest-Abgeschlossen-Text ausblenden",
        ["koKR"] = false,
        ["esMX"] = "Ocultar texto de completa de Blizzard",
        ["enUS"] = true,
        ["zhCN"] = "隐藏内建的完成信息",
        ["zhTW"] = "隱藏內建的完成訊息",
        ["esES"] = "Ocultar texto de completa de Blizzard",
        ["frFR"] = "Cacher le texte de terminaison de Blizzard",
    },
    ["When this is checked, Blizzard Completion Text will be hidden for completed Quests and instead show the old Questie tags: \"Quest Complete!\" or \"Quest Failed!\""] = {
        ["ptBR"] = "Quando esta opção está marcada, o texto de conclusão da Blizzard será ocultado para as missões concluídas e, em vez disso, mostrará as antigas etiquetas do Questie: \"Missão completa!\" ou \"Missão falhou!\"",
        ["ruRU"] = "Когда включено, Blizzard-ский текст об окончании задания будет скрыт, а вместо него будет отображен текст Questie: 'Задание выполнено!' или 'Задание провалено!'",
        ["deDE"] = "Wenn diese Option aktiviert ist, wird der Blizzard Quest-Abgeschlossen-Text für abgeschlossene Quests ausgeblendet und stattdessen die alten Questie-Tags angezeigt: 'Quest abgeschlossen!' oder 'Quest fehlgeschlagen!'",
        ["koKR"] = false,
        ["esMX"] = "Cuando está marcado, el texto de completa de Blizzard se ocultará para las misiones completadas y en su lugar mostrará las etiquetas de misión antiguas: \"¡Misión completa!\" o \"¡Misión fallida!\"",
        ["enUS"] = true,
        ["zhCN"] = "启用时，完成任务时不会显示游戏内建的完成信息，而会显示传统的信息：\"任务完成！\" 和 \"任务失败！\"",
        ["zhTW"] = "啟用時，完成任務時不會顯示遊戲內建的完成訊息，而會顯示傳統的訊息: \"任務完成!\" or \"任務失敗!\"",
        ["esES"] = "Cuando está marcado, el texto de completa de Blizzard se ocultará para las misiones completadas y en su lugar mostrará las etiquetas de misión antiguas: \"¡Misión completa!\" o \"¡Misión fallida!\"",
        ["frFR"] = "Si cette option est cochée, le texte de terminaison de Blizzard sera caché pour les quêtes terminées et à la place, les anciennes balises Questie seront affichées : \"Quête terminée !\" ou \"Quête échouée !'\"",
    },
    ---------------------------------------------------------
    -- Wrath of the Lich King only
    ["Hide Completed Achieve Objectives"] = {
        ["ptBR"] = "Ocultar objetivos de conquistas concluídos",
        ["ruRU"] = "Скрыть выполн. цели достижений",
        ["deDE"] = "Abgeschlossene Erfolgsziele ausblenden",
        ["koKR"] = false,
        ["esMX"] = "Ocultar objetivos de logros completados",
        ["enUS"] = true,
        ["zhCN"] = "隐藏已完成的成就目标",
        ["zhTW"] = "隱藏已完成的成就目標",
        ["esES"] = "Ocultar objetivos de logros completados",
        ["frFR"] = "Cacher les objectifs des hauts faits terminées",
    },
    ["When this is checked, completed Achievement Objectives will automatically be removed from the Questie Tracker."] = {
        ["ptBR"] =  "Quando esta opção está marcada, os objetivos de conquistas concluídos serão automaticamente removidos do rastreador de missões do Questie.",
        ["ruRU"] = "Когда включено, выполненные цели достижений будут автоматически изъяты из трекера",
        ["deDE"] = "Wenn diese Option aktiviert ist, werden abgeschlossene Erfolgsziele automatisch aus dem Questie-Tracker entfernt.",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "启用时，已完成的成就目标将会自动从任务列表中移除。",
        ["zhTW"] = "啟用時，已完成的成就目標將會自動從任務清單中移除。",
        ["esES"] = false,
        ["frFR"] = "Si cette option est cochée, les objectifs des hauts faits terminées seront automatiquement supprimés du suivi de quêtes de Questie.",
    },
    ---------------------------------------------------------
    ["Show Blizzard Timer"] = {
        ["ptBR"] = "Mostrar temporizador da Blizzard",
        ["ruRU"] = "Таймер Blizzard",
        ["deDE"] = "Blizzard Timer anzeigen",
        ["koKR"] = "블리자드 타이머 표시",
        ["esMX"] = "Mostrar temporizador de Blizzard",
        ["enUS"] = true,
        ["zhCN"] = "显示暴雪计时器",
        ["zhTW"] = "顯示內建任務計時器",
        ["esES"] = "Mostrar temporizador de Blizzard",
        ["frFR"] = "Chrono par défaut",
    },
    ["When this is checked, the default Blizzard Timer Frame for Quests will be shown instead of being embedded inside the Questie Tracker."] = {
        ["ptBR"] = "Quando isso estiver marcado, o Quadro de temporizador padrão da Blizzard para missões será mostrado em vez de incorporado no rastreador.",
        ["ruRU"] = "Когда включено, будет отображаться стандартный таймер Blizzard вместо встраивания его в трекер",
        ["deDE"] = "Wenn diese Option aktiviert ist, wird der Standard-Blizzard-Timer-Frame für Quests angezeigt, anstatt in den Tracker eingebettet zu sein.",
        ["koKR"] = "이 옵션을 선택하면 추적기에 내장 된 대신 퀘스트에 대한 기본 블리자드 타이머 프레임이 표시됩니다.",
        ["esMX"] = "Cuando esto está marcado, se mostrará el Marco predeterminado del temporizador de Blizzard para las misiones en lugar de estar incrustado dentro del rastreador.",
        ["enUS"] = true,
        ["zhCN"] = "启用后，任务计时器将会显示",
        ["zhTW"] = "啟用時，會顯示遊戲內建的任務計時器框架，而不會內嵌在任務清單裡面。",
        ["esES"] = "Cuando esto está marcado, se mostrará el Marco predeterminado del temporizador de Blizzard para las misiones en lugar de estar incrustado dentro del rastreador.",
        ["frFR"] = "Active l'affichage du chronomètre de l'interface de base pour les quêtes au lieu d'indiquer le temps restant directement dans le suivi des quêtes.",
    },
    ---------------------------------------------------------
    ["Enable Tracker Header"] = {
        ["ptBR"] = "Ativar cabeçalho do rastreador",
        ["ruRU"] = "Вкл/выкл",
        ["deDE"] = "Tracker-Kopfzeile aktivieren",
        ["koKR"] = false,
        ["esMX"] = "Habilitar encabezado del rastreador",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "啟用任務清單標題列",
        ["esES"] = "Habilitar encabezado del rastreador",
        ["frFR"] = "Activer l'en-tête du suivi",
    },
    ["When this is enabled the Tracker Header with the number of active quests and the Questie Icon will be permanently visible.\n\nWhen this is disabled the Questie Icon will fade in while your mouse is over the Tracker."] = {
        ["ptBR"] = "Quando isso estiver ativado, o cabeçalho do rastreador com o número de missões ativas e o ícone do Questie ficará permanentemente visível.\n\nQuando isso estiver desativado, o ícone do Questie desaparecerá enquanto o cursor do mouse estiver sobre o rastreador.",
        ["ruRU"] = "Когда включено, заголовок трекера с числом активных заданий и значком Questie будет всегда виден.\n\nКогда выключено, значок Questie будет появляться при наведении мышью на трекер",
        ["deDE"] = "Wenn dies aktiviert ist sind die Tracker-Kopfzeile und das Questie Icon permanent sichtbar.\n\nWenn dies deaktiviert ist blendet sich das Questie Icon ein sobald die Maus über dem Tracker ist.",
        ["koKR"] = false,
        ["esMX"] = "Cuando esto está habilitado, el encabezado del rastreador con el número de misiones activas y el icono de Questie estarán permanentemente visibles.\n\nCuando esto esté deshabilitado, el icono de Questie desaparecerá mientras el ratón esté sobre el rastreador.",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "啟用時，會一直顯示任務數量和 Questie 圖示。\n\n停用時，滑鼠指向清單時才會顯示 Questie 圖示。",
        ["esES"] = "Cuando esto está habilitado, el encabezado del rastreador con el número de misiones activas y el icono de Questie estarán permanentemente visibles.\n\nCuando esto esté deshabilitado, el icono de Questie desaparecerá mientras el ratón esté sobre el rastreador.",
        ["frFR"] = "Quand cette option est activée, l'en-tête du suivi avec le nombre de quêtes actives et l'icône de Questie restera visible en permanence.\n\nSi cette option est désactivée, l'icône de Questie s'estompera lorsque votre souris survolera le suivi.",
    },
    ---------------------------------------------------------
    ["Show Tracker Header At The Bottom"] = {
        ["ptBR"] = "Mostrar cabeçalho do rastreador na parte inferior",
        ["ruRU"] = "Заголовок трекера внизу",
        ["deDE"] = "Tracker-Kopfzeile unten anzeigen",
        ["koKR"] = false,
        ["esMX"] = "Mostrar encabezado del rastreador en la parte inferior",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "標題列在下方",
        ["esES"] = "Mostrar encabezado del rastreador en la parte inferior",
        ["frFR"] = "Afficher l'en-tête du suivi en bas",
    },
    ["When this is enabled the Tracker Header and/or the Questie Icon will be moved to the bottom of the Questie Tracker and the sizer to the top."] = {
        ["ptBR"] = "Quando isso estiver ativado, o cabeçalho do rastreador e/ou o ícone do Questie serão movidos para a parte inferior do rastreador do Questie e o redimensionador para o topo.",
        ["ruRU"] = "Когда включено, заголовок трекера и/или значок Questie будут перемещены в низ трекера, а сайзер будет перемещен наверх",
        ["deDE"] = "Wenn dies aktiviert ist wird die Tracker-Kopfzeile und/oder das Questie-Icon an den unteren und der Sizer an den oberen Rand des Questie-Tracker verschoben",
        ["koKR"] = false,
        ["esMX"] = "Cuando esto está habilitado, el encabezado del rastreador y/o el icono de Questie se moverán a la parte inferior del rastreador y el medidor a la parte superior.",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "啟用時，任務清單標題列和 Questie 圖示會移動到清單的最下方，縮放大小的拖曳點會在最上方。",
        ["esES"] = "Cuando esto está habilitado, el encabezado del rastreador y/o el icono de Questie se moverán a la parte inferior del rastreador y el medidor a la parte superior.",
        ["frFR"] = "Si cette option est activée, l'en-tête du suivi et/ou l'icône de Questie seront déplacés en bas du suivi de quêtes et le redimensionneur en haut.",
    },
    ---------------------------------------------------------
    ["Sticky Durability Frame"] = {
        ["ptBR"] = "Quadro de durabilidade aderente",
        ["ruRU"] = "Индикатор прочности",
        ["deDE"] = "Starre Haltbarkeitsanzeige",
        ["koKR"] = "달라붙는 프레임",
        ["esMX"] = "Marco de durabilidad fijo",
        ["enUS"] = true,
        ["zhCN"] = "锁定任务道具",
        ["zhTW"] = "耐久度貼齊清單",
        ["esES"] = "Marco de durabilidad fijo",
        ["frFR"] = "Ajust auto durabilité",
    },
    ["When this is checked, the durability frame will be placed on the left or right side of the Questie Tracker depending on where the Tracker is placed on your screen."] = {
        ["ptBR"] = "Quando isso estiver marcado, o quadro de durabilidade será colocado no lado esquerdo ou direito do Rastreador, dependendo de onde o Rastreador estiver colocado na tela.",
        ["ruRU"] = "Когда включено, индикатор прочности снаряжения будет расположен с левой или правой стороны трекера (в зависимости от положения трекера на экране)",
        ["deDE"] = "Wenn diese Option aktiviert ist, wird die Haltbarkeitsanzeige auf der linken oder rechten Seite des Trackers platziert, je nachdem, wo sich der Tracker auf dem Bildschirm befindet.",
        ["koKR"] = "이 옵션을 선택하면 화면에서 트래커의 위치에 따라 내구성 프레임이 트래커의 왼쪽 또는 오른쪽에 배치됩니다.",
        ["esMX"] = "Cuando esto está marcado, el marco de durabilidad se colocará en el lado izquierdo o derecho del rastreador, dependiendo de dónde esté ubicado el rastreador en su pantalla.",
        ["enUS"] = true,
        ["zhCN"] = "选中此选项时，道具框架将根据追踪器在屏幕上的放置位置放置在追踪器的左侧或右侧。",
        ["zhTW"] = "啟用時，裝備耐久度框架會放在任務清單的左側或右側，依據任務清單在畫面上的位置而定。",
        ["esES"] = "Cuando esto está marcado, el marco de durabilidad se colocará en el lado izquierdo o derecho del rastreador, dependiendo de dónde esté ubicado el rastreador en su pantalla.",
        ["frFR"] = "Active le placement automatique du cadre de durabilité sur le côté gauche ou droit de la fenêtre de suivi selon l'endroit où celle-ci se trouve sur l'écran.",
    },
    ---------------------------------------------------------
    ["Minimize In Combat"] = {
        ["ptBR"] = "Minimizar em combate",
        ["ruRU"] = "Свернуть в бою",
        ["deDE"] = "Im Kampf minimieren",
        ["koKR"] = "전투 최소화",
        ["esMX"] = "Minimizar en combate",
        ["enUS"] = true,
        ["zhCN"] = "在战斗中最小化",
        ["zhTW"] = "戰鬥中最小化",
        ["esES"] = "Minimizar en combate",
        ["frFR"] = "Réduire en combat",
    },
    ["When this is checked, the Questie Tracker will automatically be minimized while entering combat."] = {
        ["ptBR"] = "Quando isso estiver marcado, o Rastreador será automaticamente minimizado ao entrar em combate.",
        ["ruRU"] = "Когда включено, при входе в бой трекер будет автоматически свернут",
        ["deDE"] = "Wenn dies aktiviert ist, wird der Tracker beim Eintritt in den Kampf automatisch minimiert.",
        ["koKR"] = "이 옵션을 선택하면 전투에 들어가는 동안 트래커가 자동으로 최소화됩니다.",
        ["esMX"] = "Cuando esto está marcado, el rastreador se minimizará automáticamente al entrar en combate",
        ["enUS"] = true,
        ["zhCN"] = "选中后，在进入战斗状态时，追踪器将自动最小化。",
        ["zhTW"] = "啟用時，進入戰鬥後會自動將任務清單最小化。",
        ["esES"] = "Cuando esto está marcado, el rastreador se minimizará automáticamente al entrar en combate",
        ["frFR"] = "Active la réduction automatique du suivi de quête lors des combats.",
    },
    ---------------------------------------------------------
    ["Minimize In Dungeons"] = {
        ["ptBR"] = "Minimizar em masmorras",
        ["ruRU"] = "Свернуть в подземельях",
        ["deDE"] = "In Instanzen minimieren",
        ["koKR"] = false,
        ["esMX"] = "Minimizar en calabozos",
        ["enUS"] = true,
        ["zhCN"] = "地下城时最小化",
        ["zhTW"] = "地城中最小化",
        ["esES"] = "Minimizar en mazmorras",
        ["frFR"] = "Réduire dans les donjons",
    },
    ["When this is checked, the Questie Tracker will automatically be minimized when entering a dungeon."] = {
        ["ptBR"] = "Quando isso estiver marcado, o Rastreador será minimizado automaticamente ao entrar em uma masmorra.",
        ["ruRU"] = "Когда включено, при входе в подземелье трекер будет автоматически свернут",
        ["deDE"] = "Wenn dies aktiviert ist, wird der Tracker beim Betreten eines Dungeons automatisch minimiert.",
        ["koKR"] = false,
        ["esMX"] = "Cuando esto está marcado, el rastreador se minimizará automáticamente al entrar a un calabozo.",
        ["enUS"] = true,
        ["zhCN"] = "选中此项后，进入地下城时跟踪器将自动最小化。",
        ["zhTW"] = "啟用時，進入地城後會自動將任務清單最小化。",
        ["esES"] = "Cuando esto está marcado, el rastreador se minimizará automáticamente al entrar a una mazmorra.",
        ["frFR"] = "La fenêtre du suivi sera automatiquement réduite lors de l'entrée dans un donjon.",
    },
    ---------------------------------------------------------
    ["Fade Min/Max Buttons"] = {
        ["ptBR"] = "Desvanecer botões Min/Max",
        ["ruRU"] = "Скрыть '+' и '–'",
        ["deDE"] = "Min/Max ausblenden",
        ["koKR"] = "페이드 최소 / 최대 BTN",
        ["esMX"] = "Desvanecer botones Min/Máx",
        ["enUS"] = true,
        ["zhCN"] = "淡化按钮",
        ["zhTW"] = "淡出最大化/最小化按鈕",
        ["esES"] = "Desvanecer botones Min/Máx",
        ["frFR"] = "Fondu des boutons Min/Max",
    },
    ["When this is checked, the Minimize and Maximize Buttons will fade and become transparent when not in use."] = {
        ["ptBR"] = "Quando isso estiver marcado, os botões Minimizar e Maximizar desaparecerão e se tornarão transparentes quando não estiverem em uso.",
        ["ruRU"] = "Когда включено, кнопки сворачивания и разворачивания заданий исчезают и становятся прозрачными при неиспользовании",
        ["deDE"] = "Wenn diese Option aktiviert ist, werden die Schaltflächen zum Minimieren und Maximieren von Quests ausgeblendet und transparent, wenn sie nicht verwendet werden.",
        ["koKR"] = "이 옵션을 선택하면 사용하지 않을 때 최소화 및 최대화 버튼이 사라지고 투명 해집니다.",
        ["esMX"] = "Cuando esto está marcado, los botones Minimizar y Maximizar se desvanecerán y se volverán transparentes cuando no estén en uso",
        ["enUS"] = true,
        ["zhCN"] = "选中时，自动淡化按钮",
        ["zhTW"] = "啟用時，滑鼠沒有指向最大化和最小化按鈕時會變成透明。",
        ["esES"] = "Cuando esto está marcado, los botones Minimizar y Maximizar se desvanecerán y se volverán transparentes cuando no estén en uso",
        ["frFR"] = "Active le fondu des boutons min. et max. ce qui les rend transparents en dehors du survol de la souris.",
    },
    ---------------------------------------------------------
    ["Fade Quest Item Buttons"] = {
        ["ptBR"] = "Desvanecer BTNs do item de missão",
        ["ruRU"] = "Скрыть предметы заданий",
        ["deDE"] = "Questgegenstände ausblenden",
        ["koKR"] = "페이드 퀘스트 아이템 BTN",
        ["esMX"] = "Desvanecer botones de objetos de misiones",
        ["enUS"] = true,
        ["zhCN"] = "淡化任务道具按钮",
        ["zhTW"] = "淡出任務物品按鈕",
        ["esES"] = "Desvanecer botones de objetos de misiones",
        ["frFR"] = "Fondu des objets de quête",
    },
    ["When this is checked, the Quest Item Buttons will fade and become transparent when not in use."] = {
        ["ptBR"] = "Quando isso estiver marcado, os botões de itens da missão desaparecerão e se tornarão transparentes quando não estiverem em uso.",
        ["ruRU"] = "Когда включено, кнопки предметов заданий исчезают и становятся прозрачными при неиспользовании",
        ["deDE"] = "Wenn diese Option aktiviert ist, werden die Schaltflächen für die Questgegenstände ausgeblendet und transparent, wenn sie nicht verwendet werden.",
        ["koKR"] = "이 항목을 체크하면 퀘스트 아이템 버튼이 사라지고 사용하지 않을 때 투명 해집니다.",
        ["esMX"] = "Cuando esto está marcado, los botones de objetos de búsqueda se desvanecerán y se volverán transparentes cuando no estén en uso",
        ["enUS"] = true,
        ["zhCN"] = "选中此项时，任务项按钮将在不使用时自动淡化",
        ["zhTW"] = "啟用時，滑鼠沒有指向任務物品按鈕時會變成透明。",
        ["esES"] = "Cuando esto está marcado, los btones de objetos de búsqueda se desvanecerán y se volverán transparentes cuando no estén en uso",
        ["frFR"] = "Active le fondu des boutons d'objet de quête ce qui les rend transparents en dehors du survol de la souris.",
    },
    ---------------------------------------------------------
    ["Enable Background"] = {
        ["ptBR"] = "Ativar plano de fundo",
        ["ruRU"] = "Фон трекера",
        ["deDE"] = "Hintergrund anzeigen",
        ["koKR"] = "배경 사용",
        ["esMX"] = "Habilitar fondo",
        ["enUS"] = true,
        ["zhCN"] = "启用背景",
        ["zhTW"] = "顯示背景",
        ["esES"] = "Habilitar fondo",
        ["frFR"] = "Activer l'arrière-plan",
    },
    ["When this is checked, the Questie Tracker Background becomes visible."] = {
        ["ptBR"] = "Quando isso estiver marcado, o fundo do rastreador de missões fica visível.",
        ["ruRU"] = "Показать/скрыть фон трекера",
        ["deDE"] = "Wenn diese Option aktiviert ist, wird der Questie-Tracker-Hintergrund angezeigt.",
        ["koKR"] = "이 옵션을 선택하면 Questie 추적기 배경이 나타납니다.",
        ["esMX"] = "Cuando esto está marcado, el fondo del rastreador se vuelve visible",
        ["enUS"] = true,
        ["zhCN"] = "选中后，将显示追踪器背景。",
        ["zhTW"] = "啟用時，任務清單會顯示背景顏色。",
        ["esES"] = "Cuando esto está marcado, el fondo del rastreador se vuelve visible",
        ["frFR"] = "Active l'arrière-plan du suivi des quêtes Questie.",
    },
    ---------------------------------------------------------
    ["Enable Border"] = {
        ["ptBR"] = "Ativar borda",
        ["ruRU"] = "Граница фона",
        ["deDE"] = "Rahmen anzeigen",
        ["koKR"] = "테두리 활성화",
        ["esMX"] = "Habilitar borde",
        ["enUS"] = true,
        ["zhCN"] = "启用边框",
        ["zhTW"] = "顯示邊框",
        ["esES"] = "Habilitar borde",
        ["frFR"] = "Activer la bordure",
    },
    ["When this is checked, the Questie Tracker Border becomes visible."] = {
        ["ptBR"] = "Quando isso estiver marcado, a borda do rastreador de missões fica visível.",
        ["ruRU"] = "Показать/скрыть границу фона трекера",
        ["deDE"] = "Wenn dies aktiviert ist, wird der Rand des Questie-Trackers sichtbar.",
        ["koKR"] = "이 옵션을 선택하면 Questie 트래커 테두리가 나타납니다.",
        ["esMX"] = "Cuando esto está marcado, el borde del rastreador se vuelve visible",
        ["enUS"] = true,
        ["zhCN"] = "选中后，将显示边框。",
        ["zhTW"] = "啟用時，任務清單會顯示邊框。",
        ["esES"] = "Cuando esto está marcado, el borde del rastreador se vuelve visible",
        ["frFR"] = "Active la bordure du suivi des quêtes Questie.",
    },
    ---------------------------------------------------------
    ["Fade Background"] = {
        ["ptBR"] = "Desvanecer fundo",
        ["ruRU"] = "Скрыть фон и границу",
        ["deDE"] = "Hintergrund verblassen",
        ["koKR"] = "페이드 배경",
        ["esMX"] = "Desvanecer fondo",
        ["enUS"] = true,
        ["zhCN"] = "淡化背景",
        ["zhTW"] = "淡出背景",
        ["esES"] = "Desvanecer fondo",
        ["frFR"] = "Fondu de l'arrière-plan",
    },
    ["When this is checked, the Questie Tracker Backdrop and Border (if enabled) will fade and become transparent when not in use."] = {
        ["ptBR"] = "Quando isso estiver marcado, o Pano de fundo e a borda do Questie Rastreador (se ativado) desaparecerão e se tornarão transparentes quando não estiverem em uso.",
        ["ruRU"] = "Когда включено, фон и граница трекера исчезают и становятся прозрачными при неиспользовании",
        ["deDE"] = "Wenn diese Option aktiviert ist, werden der Hintergrund des Questie-Trackers und der Rahmen (falls aktiviert) ausgeblendet und transparent, wenn sie nicht verwendet werden.",
        ["koKR"] = "이 옵션을 선택하면 Questie 트래커 배경 및 테두리 (사용 가능한 경우)가 사라지고 사용하지 않을 때 투명 해집니다.",
        ["esMX"] = "Cuando esto está marcado, el fondo y el borde del rastreador (si está habilitado) se desvanecerán y se volverán transparentes cuando no estén en uso",
        ["enUS"] = true,
        ["zhCN"] = "选中后，自动淡化背景及边框",
        ["zhTW"] = "啟用時，滑鼠沒有指向任務清單時，背景和 (如果有啟用) 邊框會變成透明。",
        ["esES"] = "Cuando esto está marcado, el fondo y el borde del rastreador (si está habilitado) se desvanecerán y se volverán transparentes cuando no estén en uso",
        ["frFR"] = "Active le fondu de l'arrière-plan du suivi des quêtes Questie lorsque celui-ci est activé.",
    },
    ---------------------------------------------------------
    ["Hide Tracker Sizer"] = {
        ["ptBR"] = "Ocultar redimensionador do rastreador",
        ["ruRU"] = "Скрыть сайзер трекера",
        ["deDE"] = "Tracker-Sizer ausblenden",
        ["koKR"] = false,
        ["esMX"] = "Ocultar medidor del rastreador",
        ["enUS"] = true,
        ["zhCN"] = "隐藏列表大小调整点",
        ["zhTW"] = "隱藏清單大小調整點",
        ["esES"] = "Ocultar medidor del rastreador",
        ["frFR"] = "Cacher le redimensionneur du suivi",
    },
    ["When this is checked, the Questie Tracker Sizer that appears in the bottom or top right hand corner will be hidden."] = {
        ["ptBR"] = "Quando esta opção estiver marcada, o redimensionador do rastreador do Questie que aparece no canto inferior ou superior direito será ocultado.",
        ["ruRU"] = "Когда включено, скрывается сайзер (изменитель размера трекера), который отображается в правом нижнем или в правом верхнем углу",
        ["deDE"] = "Wenn diese Option aktiviert ist, wird der Tracker-Sizer, der in der unteren oder oberen rechten Ecke angezeigt wird, ausgeblendet.",
        ["koKR"] = false,
        ["esMX"] = "Cuando esto está marcado, el medidor del rastreador que aparece en la esquina inferior o superior derecha estará oculto.",
        ["enUS"] = true,
        ["zhCN"] = "启用时，任务列表下方或右上角调整点不会显示。",
        ["zhTW"] = "啟用時，任務清單下方或右上角調整點不會顯示出來。",
        ["esES"] = "Cuando esto está marcado, el medidor del rastreador que aparece en la esquina inferior o superior derecha estará oculto.",
        ["frFR"] = "Lorsque ceci est coché, le redimensionneur du suivi de quêtes de Questie qui apparaît dans le coin inférieur ou supérieur droit sera caché.",
    },
    ---------------------------------------------------------
    ["Show Header For Empty Tracker"] = {
        ["ptBR"] = "Mostrar cabeçalho para o rastreador vazio",
        ["ruRU"] = "Отображать при пустом трекере",
        ["deDE"] = "Tracker-Kopfzeile für leeren Tracker anzeigen",
        ["koKR"] = false,
        ["esMX"] = "Mostrar encabezado para el rastreador vacío",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "空的清單也要顯示標題列",
        ["esES"] = "Mostrar encabezado para el rastreador vacío",
        ["frFR"] = "Afficher l'en-tête pour le suivi vide",
    },
    ["When this is enabled the Tracker Header will be visible even when no quests are being tracked versus the Tracker being hidden completely."] = {
        ["ptBR"] = "Quando isso estiver ativado, o cabeçalho do rastreador será visível mesmo quando nenhuma missão estiver sendo rastreada, ao contrário do rastreador sendo completamente oculto.",
        ["ruRU"] = "Когда включено, заголовок трекера будет виден, даже если в трекере нет отслеживаемых заданий",
        ["deDE"] = "Wenn dies aktiviert ist wird die Tracker-Kopfzeile angezeigt, selbst wenn keine Quests verfolgt werden anstatt, dass der Tracker komplett ausgeblendet wird.",
        ["koKR"] = false,
        ["esMX"] = "Cuando esto está habilitado, el encabezado del rastreador será visible incluso cuando no se estén rastreando misiones, en lugar de que el rastreador esté completamente oculto.",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "啟用時，就算沒有追蹤任何任務，也會顯示任務清單的標題列，而不是完全隱藏清單。",
        ["esES"] = "Cuando esto está habilitado, el encabezado del rastreador será visible incluso cuando no se estén rastreando misiones, en lugar de que el rastreador esté completamente oculto.",
        ["frFR"] = "Si cette option est activée, l'en-tête du suivi sera visible même lorsque aucune quête n'est suivie, contrairement à la dissimulation complète du suivi.",
    },
    ---------------------------------------------------------
    -- Wrath of the Lich King only
    ["List Achievements First"] = {
        ["ptBR"] = "Listar conquistas primeiro",
        ["ruRU"] = "Достижения вверху",
        ["deDE"] = "Erfolge zuerst anzeigen",
        ["koKR"] = false,
        ["esMX"] = "Listar logros primero",
        ["enUS"] = true,
        ["zhCN"] = "成就排前面",
        ["zhTW"] = "成就排在前面",
        ["esES"] = "Listar logros primero",
        ["frFR"] = "Afficher d'abord les hauts faits",
    },
    ["When this is checked, the Questie Tracker will list Achievements first then Quests."] = {
        ["ptBR"] = "Quando isso estiver marcado, o rastreador do Questie listará primeiro as conquistas e depois as missões.",
        ["ruRU"] = "Когда включено, достижения в трекере будут отображаться сверху заданий",
        ["deDE"] = "Wenn diese Option aktiviert ist, werden Erfolge im Tracker zuerst und dann Quests angezeigt.",
        ["koKR"] = false,
        ["esMX"] = "Si está marcado, el rastreador listará primero los logros y después las misiones.",
        ["enUS"] = true,
        ["zhCN"] = "启用时，任务追踪列表会将成就排在任务的前面",
        ["zhTW"] = "啟用時，任務追蹤清單會將成就排列在任務的前面。",
        ["esES"] = "Si está marcado, el rastreador listará primero los logros y después las misiones.",
        ["frFR"] = "Lorsque ceci est coché, le suivi de Questie affichera d'abord les hauts faits, puis les quêtes.",
    },
    ---------------------------------------------------------
    -- VoiceOver Tracker Integration
    ["Sticky VoiceOver Frame"] = {
        ["ptBR"] = "Quadro VoiceOver fixo",
        ["ruRU"] = false,
        ["deDE"] = "Sticky VoiceOver-Fenster",
        ["koKR"] = false,
        ["esMX"] = "Marco VoiceOver pegajoso",
        ["enUS"] = true,
        ["zhCN"] = "语音贴齐清单",
        ["zhTW"] = "語音貼齊清單",
        ["esES"] = "Marco VoiceOver pegajoso",
        ["frFR"] = "Cadre VoiceOver collant",
    },
    ["When this is checked, the VoiceOver talking head / sound queue frame will be placed on the left or right side of the Questie Tracker depending on where the Tracker is placed on your screen."] = {
        ["ptBR"] = "Quando isso estiver marcado, o quadro de cabeça falante / fila de som do VoiceOver será colocado no lado esquerdo ou direito do rastreador do Questie, dependendo de onde o rastreador estiver localizado na sua tela.",
        ["ruRU"] = false,
        ["deDE"] = "Wenn diese Option aktiviert ist, wird das VoiceOver-Fenster auf der linken oder rechten Seite des Questie-Trackers platziert, je nachdem, wo sich der Tracker auf dem Bildschirm befindet.",
        ["koKR"] = false,
        ["esMX"] = "Cuando esto está marcado, el marco de la cabeza parlante de VoiceOver / cola de sonido se colocará en el lado izquierdo o derecho del rastreador de Questie dependiendo de dónde esté ubicado el rastreador en tu pantalla.",
        ["enUS"] = true,
        ["zhCN"] = "启用时，语音框会放在任务列表的左侧或右侧，根据任务列表在界面上的位置而定。",
        ["zhTW"] = "啟用時，語音框架會放在任務清單的左側或右側，依據任務清單在畫面上的位置而定。",
        ["esES"] = "Cuando esto está marcado, el marco de la cabeza parlante de VoiceOver / cola de sonido se colocará en el lado izquierdo o derecho del rastreador de Questie dependiendo de dónde esté ubicado el rastreador en tu pantalla.",
        ["frFR"] = "Lorsque ceci est coché, le cadre de tête parlante / file d'attente sonore de VoiceOver sera placé sur le côté gauche ou droit du suivi de Questie en fonction de l'emplacement du suivi sur votre écran.",
    },
    ---------------------------------------------------------
    ["Lock Tracker"] = {
        ["ptBR"] = "Bloqueado o rastreador",
        ["ruRU"] = "Заблокировать трекер",
        ["deDE"] = "Tracker sperren",
        ["koKR"] = "추적기 잠금",
        ["esMX"] = "Bloquear rastreador",
        ["enUS"] = true,
        ["zhCN"] = "锁定框体",
        ["zhTW"] = "鎖定任務清單",
        ["esES"] = "Bloquear rastreador",
        ["frFR"] = "Verrouiller la fenêtre du suivi",
    },
    ["When this is checked, the Questie Tracker is locked and you need to hold CTRL when you want to move it."] = {
        ["ptBR"] = "Quando isso estiver marcado, o rastreador do Questie estará bloqueado e você precisará manter pressionada a tecla CTRL quando quiser movê-lo.",
        ["ruRU"] = "Когда это включено, то трекер заблокирован, и для его перемещения вам нужно зажать Ctrl",
        ["deDE"] = "Wenn dies aktiviert ist, dann muss STRG gedrückt gehalten werden, wenn der Tracker bewegt werden soll.",
        ["koKR"] = false,
        ["esMX"] = "Cuando esto está marcado, el rastreador está bloqueado y debes mantener presionada la tecla CTRL cuando quieras moverlo.",
        ["enUS"] = true,
        ["zhCN"] = "启用此选项，追踪器被锁定，您需要按住 CTRL 键才能移动它。",
        ["zhTW"] = "啟用時，會鎖定任務清單，必須按住 CTRL 鍵才能移動它。",
        ["esES"] = "Cuando esto está marcado, el rastreador está bloqueado y debes mantener presionada la tecla CTRL cuando quieras moverlo.",
        ["frFR"] = "Lorsque ceci est coché, le traqueur est vérouillé, maintenez CTRL lorsque vous souhaitez le déplacer.",
    },
    ---------------------------------------------------------
    ["Enable Tracker"] = {
        ["ptBR"] = "Ativar o rastreador",
        ["ruRU"] = "Включить трекер",
        ["deDE"] = "Den Tracker anzeigen",
        ["koKR"] = "트래커 활성화",
        ["esMX"] = "Habilitar el rastreador",
        ["enUS"] = true,
        ["zhCN"] = "启用跟踪器",
        ["zhTW"] = "啟用任務清單",
        ["esES"] = "Habilitar el rastreador",
        ["frFR"] = "Suivi Questie",
    },
    ["Enabling the Tracker will replace the default Blizzard Quest Tracker with the Questie Tracker.\n\nNOTE: Changing this setting will reload the UI."] = {
        ["ptBR"] = "Ativar o rastreador substituirá o rastreador de missões padrão da Blizzard pelo rastreador do Questie.\n\nNOTA: Alterar essa configuração recarregará a IU.",
        ["ruRU"] = "После нажатия данной кнопки трекер Blizzard заменится трекером Questie.\n\nПРИМЕЧАНИЕ: Эта настройка перезапускает пользовательский интерфейс",
        ["deDE"] = "Durch Aktivieren des Trackers wird der Standard-Blizzard-Quest-Tracker durch den Questie-Tracker ersetzt.\n\nHINWEIS: Das Ändern dieser Einstellung wird das Benutzerinterface neu laden.",
        ["koKR"] = false, --Old Translation: "추적기를 활성화하면 기본 블리자드 퀘스트 추적기가 Questie 추적기로 대체됩니다.",
        ["esMX"] = "Al habilitar el rastreador se reemplazará el rastreador Blizzard predeterminado por el rastreador.\n\nNOTA: al cambiar esta configuración se recargará la interfaz de usuario",
        ["enUS"] = true,
        ["zhCN"] = false, --Old Translation: "启用跟踪器会将默认的暴雪自带任务追踪器替换为Questie追踪器。",
        ["zhTW"] = "啟用任務位置提示插件的任務清單來取代遊戲內建的。\n\n此設定是每個角色分開儲存的，更改後會重新載入介面。",
        ["esES"] = "Al habilitar el rastreador se reemplazará el rastreador Blizzard predeterminado por el rastreador.\n\nNOTA: al cambiar esta configuración se recargará la interfaz de usuario",
        ["frFR"] = "Activer le suivi remplacera le suivi de quête par défaut de Blizzard par le suivi de Questie.\n\nNOTE : Modifier ce paramètre rechargera l'interface utilisateur.",
    },
    ---------------------------------------------------------
    ["Reset Tracker"] = {
        ["ptBR"] = "Redefinir rastreador",
        ["ruRU"] = "Сброс позиции",
        ["deDE"] = "Tracker-Position zurücksetzen",
        ["koKR"] = "추적기 위치 재설정",
        ["esMX"] = "Restablecer rastreador",
        ["enUS"] = true,
        ["zhCN"] = "重置追踪器位置",
        ["zhTW"] = "重置任務清單",
        ["esES"] = "Restablecer rastreador",
        ["frFR"] = "Réinitialiser suivi",
    },
    ["If the Questie Tracker is stuck offscreen or lost, you can reset it's location to the center of the screen with this button."] = {
        ["ptBR"] = "Se o rastreador do Questie estiver preso fora da tela ou perdido, você poderá redefinir sua localização para o centro da tela com este botão (pode exigir / recarregar).",
        ["ruRU"] = "Если трекер исчез полностью или оказался за пределами экрана, то нажатие этой кнопки сбросит его положение в центр экрана (может потребоваться перезагрузка пользовательского интерфейса командой '/reload')",
        ["deDE"] = "Wenn der Questie-Tracker außerhalb des Bildschirms hängen bleibt oder verloren geht, kann seine Position mit dieser Schaltfläche auf die Mitte des Bildschirms zurückgesetzt werden (erfordert möglicherweise ein /reload).",
        ["koKR"] = "Questie 트래커가 화면을 벗어나거나 잃어버린 경우이 버튼을 사용하여 화면 중앙으로 위치를 재설정 할 수 있습니다 (/ 재로드 필요).",
        ["esMX"] = "Si el rastreador Questie está atascado o perdido, puede restablecer su ubicación en el centro de la pantalla con este botón.",
        ["enUS"] = true,
        ["zhCN"] = "如果Questie追踪器卡在屏幕外或丢失，您可以使用此按钮将其位置重置到屏幕中央（可能需要重载界面 /reload）。",
        ["zhTW"] = "如果任務清單跑出畫面或不見了，使用這個按鈕可以將它重置到畫面的中間。",
        ["esES"] = "Si el rastreador Questie está atascado o perdido, puede restablecer su ubicación en el centro de la pantalla con este botón.",
        ["frFR"] = "Si le suivi des quêtes Questie est bloqué hors écran ou perdu, vous pouvez réinitialiser son emplacement au centre de l'écran avec ce bouton (peut nécessiter de /reload).",
    },
    ---------------------------------------------------------
    ["Objective Color"] = {
        ["ptBR"] = "Cor do objectivo",
        ["ruRU"] = "Цвет целей",
        ["deDE"] = "Quest-Zielfarbe",
        ["koKR"] = "퀘스트 목표 색상",
        ["esMX"] = "Color de objectivo",
        ["enUS"] = true,
        ["zhCN"] = "目标着色",
        ["zhTW"] = "任務目標顏色",
        ["esES"] = "Color de objectivo",
        ["frFR"] = "Couleur des objectifs :",
    },
    ["Change the color of Objectives in the Questie Tracker by how complete they are.\n\nNOTE: The Minimalistic option will not display the \"Blizzard Completion Text\" and just label the Quest as either \"Quest Complete!\" or \"Quest Failed!\"."] = {
        ["ptBR"] = "Mude a cor dos objetivos no rastreador do Questie conforme estiverem completos.\n\nNOTA: A opção Minimalista não exibirá o \"Texto de conclusão da Blizzard\" e apenas rotulará a missão como \"Missão Completa!\" ou \"Missão Falhou!\".",
        ["ruRU"] = "Изменение цвета целей заданий в трекере в зависимости от прогресса выполнения.\n\nПРИМЕЧАНИЕ: Настройка 'Минимализм' не будет отображать Blizzard-ский текст об окончании задания, вместо этого будут отображаться или 'Задание выполнено!', или 'Задание провалено!'",
        ["deDE"] = "Ändert die Farbe der Quest-Ziele im Questie-Tracker je nach Fortschritt.\n\nHINWEIS: Die minimalistische Option zeigt \"Blizzards Quest-Abgeschlossen-Text\" nicht an und kennzeichnet Quests nur mit \"Quest abgeschlossen!\" oder \"Quest fehlgeschlagen!\".",
        ["koKR"] = false,
        ["esMX"] = "Cambia el color de los objetivos en el rastreador de misiones según lo completos que estén.\n\nNOTA: La opción Minimalista no mostrará el \"Texto de completo de Blizzard\" y solo etiquetará la misión como \"¡Misión completa!\" o \"¡Misión fallida!\".",
        ["enUS"] = true,
        ["zhCN"] = "列表中的任务目标会根据完成度变换颜色。\n\n极简的选项不会显示游戏内建任务完成信息，只会显示 \"任务完成！\" 或 \"任务失败！\"。",
        ["zhTW"] = "清單中的任務目標會依據完成度變換顏色。\n\n極簡的選項將不會顯示遊戲內建的任務完成訊息，只會顯示 \"任務完成!\" 或 \"任務失敗!\"。",
        ["esES"] = "Cambia el color de los objetivos en el rastreador de misiones según lo completos que estén.\n\nNOTA: La opción Minimalista no mostrará el \"Texto de completo de Blizzard\" y solo etiquetará la misión como \"¡Misión completa!\" o \"¡Misión fallida!\".",
        ["frFR"] = "Modifiez la couleur des objectifs dans le suivi de Questie en fonction de leur état de complétude.\n\nNOTE : L'option Minimaliste n'affichera pas le \"Texte de terminaison de Blizzard\" et se contentera d'étiqueter la quête comme \"Quête Terminée !\" ou \"Quête Échouée !\".",
    },
    ---------------------------------------------------------
    ["Red to Green"] = {
        ["ptBR"] = "Vermelho ao verde",
        ["ruRU"] = "От красного к зеленому",
        ["deDE"] = "Rot zu Grün",
        ["koKR"] = "빨간색에서 초록색",
        ["esMX"] = "Rojo a Verde",
        ["enUS"] = true,
        ["zhCN"] = "由红至绿",
        ["zhTW"] = "紅變綠",
        ["esES"] = "Rojo a Verde",
        ["frFR"] = "Rouge à vert",
    },
    ["White"] = {
        ["ptBR"] = "Branco",
        ["ruRU"] = "Белый",
        ["deDE"] = "Weiß",
        ["koKR"] = "하얀색",
        ["esMX"] = "Blanco",
        ["enUS"] = true,
        ["zhCN"] = "白色",
        ["zhTW"] = "白色",
        ["esES"] = "Blanco",
        ["frFR"] = "Blanc",
    },
    ["White and Green"] = {
        ["ptBR"] = "Branco e verde",
        ["ruRU"] = "Белый и зеленый",
        ["deDE"] = "Weiß und Grün",
        ["koKR"] = "하얀색에서 초록색",
        ["esMX"] = "Blanco y Verde",
        ["enUS"] = true,
        ["zhCN"] = "白和绿",
        ["zhTW"] = "白和綠",
        ["esES"] = "Blanco y Verde",
        ["frFR"] = "Blanc et vert",
    },
    ["White to Green"] = {
        ["ptBR"] = "Branco ao verde",
        ["ruRU"] = "От белого к зеленому",
        ["deDE"] = "Weiß zu Grün",
        ["koKR"] = "하얀색에서 초록색",
        ["esMX"] = "Blanco a Verde",
        ["enUS"] = true,
        ["zhCN"] = "由白至绿",
        ["zhTW"] = "白變綠",
        ["esES"] = "Blanco a Verde",
        ["frFR"] = "Blanc à vert",
    },
    ["Minimalistic"] = {
        ["ptBR"] = "Minimalista",
        ["ruRU"] = "Минимализм",
        ["deDE"] = "Minimalistisch",
        ["koKR"] = false,
        ["esMX"] = "Minimalista",
        ["enUS"] = true,
        ["zhCN"] = "极简",
        ["zhTW"] = "極簡",
        ["esES"] = "Minimalista",
        ["frFR"] = "Minimaliste",
    },
    ---------------------------------------------------------
    ["Objective Sorting"] = {
        ["ptBR"] = "Classificando objetivos",
        ["ruRU"] = "Сортировка целей",
        ["deDE"] = "Quest-Zielsortierung",
        ["koKR"] = "퀘스트 목표 정렬",
        ["esMX"] = "Orden de objetivos",
        ["enUS"] = true,
        ["zhCN"] = "目标排序",
        ["zhTW"] = "任務目標排序",
        ["esES"] = "Orden de objetivos",
        ["frFR"] = "Méthode de tri des objectifs :",
    },
    -- Classic and TBC only --
    ["How Objectives are sorted in the Questie Tracker."] = {
        ["ptBR"] = "Como os objetivos são classificados no rastreador do Questie.",
        ["ruRU"] = "Выбор типа сортировки целей заданий в трекере",
        ["deDE"] = "Wie Quest-Ziele im Tracker sortiert werden.",
        ["koKR"] = false,
        ["esMX"] = "La manera que se ordena los objetivos en el rastreador.",
        ["enUS"] = true,
        ["zhCN"] = "任务目标在列表中如何排序。",
        ["zhTW"] = "任務目標在清單中如何排序。",
        ["esES"] = "La manera que se ordena los objetivos en el rastreador.",
        ["frFR"] = "Comment les objectifs sont triés dans le suivi de Questie.",
    },
    -- Wrath of the Lich King only --
    ["How Objectives are sorted in the Questie Tracker.\n\nNOTE: This will not sort Achievements."] = {
        ["ptBR"] = "Como os objectivos são classificadas no Rastreador",
        ["ruRU"] = "Выбор типа сортировки целей заданий в трекере.\n\nПРИМЕЧАНИЕ: Это не сортирует достижения",
        ["deDE"] = "Wie Quest-Ziele im Tracker sortiert werden.\n\nHINWEIS: Dies sortiert keine Erfolge.",
        ["koKR"] = "추적기에서 퀘스트 목표를 어떻게 정렬해서 보여줄지 설정합니다.",
        ["esMX"] = "La manera que se ordena los objetivos en el rastreador.",
        ["enUS"] = true,
        ["zhCN"] = "追踪列表中的任务要如何排序",
        ["zhTW"] = "任務目標在清單中如何排序。\n\n注意: 不會影響成就。",
        ["esES"] = "La manera que se ordena los objetivos en el rastreador.",
        ["frFR"] = "Comment les objectifs sont triés dans le Traqueur",
    },
    ---------------------------------------------------------
    ["By %% Complete"] = {
        ["ptBR"] = "Por %% completo",
        ["ruRU"] = "По %% выполнения",
        ["deDE"] = "Nach %% Fertigstellung",
        ["koKR"] = false,
        ["esMX"] = "Por %% completada",
        ["enUS"] = true,
        ["zhCN"] = "按完成度 %%",
        ["zhTW"] = "依完成度 %%",
        ["esES"] = "Por %% completada",
        ["frFR"] = "Par %% complet",
    },
    ["By %% Complete (Reversed)"] = {
        ["ptBR"] = "Por %% completo (invertido)",
        ["ruRU"] = "По %% выполнения (убыв.)",
        ["deDE"] = "Nach %% Fertigstellung (Absteigend)",
        ["koKR"] = false,
        ["esMX"] = "Por %% completada (inverso)",
        ["enUS"] = true,
        ["zhCN"] = "按完成度 %%（反向）",
        ["zhTW"] = "依完成度 %% (反向)",
        ["esES"] = "Por %% completada (inverso)",
        ["frFR"] = "Par %% complet (inversé)",
    },
    ["By Level"] = {
        ["ptBR"] = "Por nivel",
        ["ruRU"] = "По уровню",
        ["deDE"] = "Nach Level",
        ["koKR"] = "레벨 순서",
        ["esMX"] = "Por nivel",
        ["enUS"] = true,
        ["zhCN"] = "按等级",
        ["zhTW"] = "依等級",
        ["esES"] = "Por nivel",
        ["frFR"] = "Par niveau",
    },
    ["By Level (Reversed)"] = {
        ["ptBR"] = "Por nível (invertido)",
        ["ruRU"] = "По уровню (убыв.)",
        ["deDE"] = "Nach Level (Absteigend)",
        ["koKR"] = "레벨 순서 (역순)",
        ["esMX"] = "Por nivel (inverso)",
        ["enUS"] = true,
        ["zhCN"] = "按等级（反向）",
        ["zhTW"] = "依等級 (反向)",
        ["esES"] = "Por nivel (inverso)",
        ["frFR"] = "Par niveau (inversé)",
    },
    ["By Proximity"] = {
        ["ptBR"] = "Por proximidade",
        ["ruRU"] = "По близости",
        ["deDE"] = "Nach Nähe",
        ["koKR"] = "가까운",
        ["esMX"] = "Por proximidad",
        ["enUS"] = true,
        ["zhCN"] = "按远近",
        ["zhTW"] = "依遠近",
        ["esES"] = "Por proximidad",
        ["frFR"] = "Par proximité",
    },
    ["By Proximity (Reversed)"] = {
        ["ptBR"] = "Por proximidade (invertido)",
        ["ruRU"] = "По близости (убыв.)",
        ["deDE"] = "Nach Nähe (Absteigend)",
        ["koKR"] = false,
        ["esMX"] = "Por proximidad (inverso)",
        ["enUS"] = true,
        ["zhCN"] = "按远近（反向）",
        ["zhTW"] = "依遠近 (反向)",
        ["esES"] = "Por proximidad (inverso)",
        ["frFR"] = "Par proximité (inversé)",
    },
    ["By Zone"] = {
        ["ptBR"] = "Por zona",
        ["ruRU"] = "По игровой зоне",
        ["deDE"] = "Nach Zone",
        ["koKR"] = "지역별",
        ["esMX"] = "Por zona",
        ["enUS"] = true,
        ["zhCN"] = "按区域",
        ["zhTW"] = "依區域",
        ["esES"] = "Por zona",
        ["frFR"] = "Par zone",
    },
    ["By Zone Prox"] = {
        ["ptBR"] = "Por proximidade de zona",
        ["ruRU"] = "По дальности зоны",
        ["deDE"] = "Nach Zonen-Nähe",
        ["koKR"] = false,
        ["esMX"] = "Por proximidad de zona",
        ["enUS"] = true,
        ["zhCN"] = "按区域远近",
        ["zhTW"] = "依區域遠近",
        ["esES"] = "Por proximidad de zona",
        ["frFR"] = "Par proximité de zone",
    },
    ["By Zone Prox (Reversed)"] = {
        ["ptBR"] = "Por proximidade de zona (invertido)",
        ["ruRU"] = "По дальности зоны (убыв.)",
        ["deDE"] = "Nach Zonen-Nähe (Absteigend)",
        ["koKR"] = false,
        ["esMX"] = "Por proximidad de zona (inverso)",
        ["enUS"] = true,
        ["zhCN"] = "按区域远近（反向）",
        ["zhTW"] = "依區域遠近 (反向)",
        ["esES"] = "Por proximidad de zona (inverso)",
        ["frFR"] = "Par proximité de zone (inverté)",
    },
    ---------------------------------------------------------
    ["Set |cFF54e33bTomTom|r Target"] = {
        ["ptBR"] = "Defina o alvo de |cFF54e33bTomTom|r",
        ["ruRU"] = "Установить точку |cFF54e33bTomTom|r",
        ["deDE"] = "|cFF54e33bTomTom|r-Ziel setzen",
        ["koKR"] = "|cFF54e33bTomTom|r 대상 설정",
        ["esMX"] = "Establecer objetivo de |cFF54e33bTomTom|r",
        ["enUS"] = true,
        ["zhCN"] = "显示|cFF54e33bTomTom|r箭头",
        ["zhTW"] = "|cFF54e33bTomTom|r 開始導航",
        ["esES"] = "Establecer objetivo de |cFF54e33bTomTom|r",
        ["frFR"] = "Définir un point |cFF54e33bTomTom|r",
    },
    -- Classic and TBC only --
    ["This shortcut will set the TomTom arrow to point to either an NPC or the first incomplete Quest Objective (if location data is available)."] = {
        ["ptBR"] = "Este atalho definirá a seta do TomTom para apontar para um NPC ou o primeiro objetivo de missão incompleto (se houver dados de localização disponíveis).",
        ["ruRU"] = "Сочетание клавиш для установки точки TomTom либо на NPC, либо на первую невыполненную цель задания (если имеются координаты)",
        ["deDE"] = "Dieser Shortcut setzt den TomTom-Pfeil auf einen NPC oder das erste unvollständige Quest-Ziel (falls Positionsdaten verfügbar sind).",
        ["koKR"] = false,
        ["esMX"] = "Este atajo configurará la flecha de TomTom para que apunte a un PNJ o al primer objetivo de misión incompleto (si hay datos de ubicación disponibles).",
        ["enUS"] = true,
        ["zhCN"] = "此功能会开始 TomTom 导航箭头到 NPC或 第一个未完成的任务目标（如果有位置资料的话）。",
        ["zhTW"] = "此功能會開始 TomTom 導航箭頭到 NPC 或第一個未完成的任務目標 (如果有位置資料的話)。",
        ["esES"] = "Este atajo configurará la flecha de TomTom para que apunte a un PNJ o al primer objetivo de misión incompleto (si hay datos de ubicación disponibles).",
        ["frFR"] = "Ce raccourci définira la flèche TomTom pour pointer vers un PNJ ou le premier objectif de quête incomplet (si des données de localisation sont disponibles).",
    },
    -- Wrath of the Lich King only --
    ["This shortcut will set the TomTom arrow to point to either an NPC or the first incomplete Quest Objective (if location data is available).\n\nNOTE: This will not work with Achievements."] = {
        ["ptBR"] = "Atalho para abrir TomTom",
        ["ruRU"] = "Сочетание клавиш для установки точки TomTom либо на NPC, либо на первую невыполненную цель задания (если имеются координаты).\n\nПРИМЕЧАНИЕ: Это не работает с достижениями",
        ["deDE"] = "Der Tracker-Shortcut, um TomTom zu öffnen The tracker shortcut to open TomTom.",
        ["koKR"] = "추적기에서 TomTom 애드온을 여는 단축키를 설정합니다.",
        ["esMX"] = "El atajo del rastreador para abrir TomTom",
        ["enUS"] = true,
        ["zhCN"] = "在任务追踪上开启TomTom的快捷键",
        ["zhTW"] = "此功能會開始 TomTom 導航箭頭到 NPC 或第一個未完成的任務目標 (如果有位置資料的話)。\n\n注意: 無法用於成就。",
        ["esES"] = "El atajo del rastreador para abrir TomTom",
        ["frFR"] = "Définis le raccourci servant à ouvrir TomTom.",
    },
    ---------------------------------------------------------
    -- Classic and TBC only --
    ["Show in Quest Log"] = {
        ["ptBR"] = "Mostrar no registro de missões",
        ["ruRU"] = "Показать в журнале заданий",
        ["deDE"] = "Im Quest-Log anzeigen",
        ["koKR"] = false,
        ["esMX"] = "Mostrar en el registro de misiones",
        ["enUS"] = true,
        ["zhCN"] = "显示任务日志",
        ["zhTW"] = "顯示任務日誌",
        ["esES"] = "Mostrar en el registro de misiones",
        ["frFR"] = "Afficher dans le journal de quête",
    },
    -- Classic and TBC only --
    ["This shortcut will open the Quest Log with the clicked Quest selected."] = {
        ["ptBR"] = "Este atalho abrirá o registro de missões com a missão clicada selecionada.",
        ["ruRU"] = "Сочетание клавиш для открытия задания в журнале заданий",
        ["deDE"] = "Dieser Shortcut öffnet das Quest-Log mit der angeklickten Quest.",
        ["koKR"] = false,
        ["esMX"] = "Este atajo abrirá el registro de misiones con la misión en la que se hizo clic seleccionada.",
        ["enUS"] = true,
        ["zhCN"] = "此功能会打开任务日志并显示选点的任务。",
        ["zhTW"] = "此功能會打開任務日誌並顯示選點的任務。",
        ["esES"] = "Este atajo abrirá el registro de misiones con la misión en la que se hizo clic seleccionada.",
        ["frFR"] = "Ce raccourci ouvrira le journal des quêtes avec la quête cliquée sélectionnée.",
    },
    ---------------------------------------------------------
    -- Wrath of the Lich King only --
    ["Show Quest / Achievement"] = {
        ["ptBR"] = "Mostrar missão / conquista",
        ["ruRU"] = "Задание / Достижение",
        ["deDE"] = "Quest / Erfolg anzeigen",
        ["koKR"] = false,
        ["esMX"] = "Mostrar misión / logro",
        ["enUS"] = true,
        ["zhCN"] = "显示任务 / 成就",
        ["zhTW"] = "顯示任務 / 成就",
        ["esES"] = "Mostrar misión / logro",
        ["frFR"] = "Afficher quête / haut fait",
    },
    -- Wrath of the Lich King only --
    ["This shortcut will open the Quest Log with the clicked Quest selected or open Achievements with the clicked Achievement selected."] = {
        ["ptBR"] = "Este atalho abrirá o registro de missões com a missão clicada selecionada ou abrirá as conquistas com a conquista clicada selecionada.",
        ["ruRU"] = "Сочетание клавиш для открытия задания в журнале заданий или достижения в окне достижений",
        ["deDE"] = "Dieser Shortcut öffnet das Quest-Log mit der angeklickten Quest oder dem Erfolg.",
        ["koKR"] = false,
        ["esMX"] = "Este atajo abrirá el registro de misiones con la misión cliqueada seleccionada o abrirá los logros con el logro cliqueado seleccionado.",
        ["enUS"] = true,
        ["zhCN"] = "此功能会打开任务日志并显示选点的任务，或是打开成就窗口并显示选点的成就。",
        ["zhTW"] = "此功能會打開任務日誌並顯示選點的任務，或是打開成就視窗並顯示選點的的成就。",
        ["esES"] = "Este atajo abrirá el registro de misiones con la misión cliqueada seleccionada o abrirá los logros con el logro cliqueado seleccionado.",
        ["frFR"] = "Ce raccourci ouvrira le journal des quêtes avec la quête cliquée sélectionnée ou ouvrira les hauts faits avec le haut hait cliqué sélectionné.",
    },
    ---------------------------------------------------------
    -- Classic and TBC only --
    ["Untrack / Link Quest"] = {
        ["ptBR"] = "Desmarcar / Vincular missão",
        ["ruRU"] = "Отмена / Ссылка",
        ["deDE"] = "Quest verlinken/entfernen",
        ["koKR"] = false,
        ["esMX"] = "No rastrear/vincular misión",
        ["enUS"] = true,
        ["zhCN"] = "取消追踪 / 任务链接",
        ["zhTW"] = "取消追蹤 / 任務連結",
        ["esES"] = false,
        ["frFR"] = "Désuivre / Lier la quête",
    },
    -- Classic and TBC only --
    ["This shortcut removes a Quest from the Questie Tracker when the chat input box is NOT visible, otherwise this will link a Quest to chat."] = {
        ["ptBR"] = "Este atalho remove uma missão do rastreador do Questie quando a caixa de entrada do bate-papo NÃO está visível; caso contrário, ele vinculará uma missão ao bate-papo.",
        ["ruRU"] = "Сочетание клавиш для отмены отслеживания задания в трекере. Если активно поле ввода чата, то вместо отмены отслеживания в чат отправится ссылка на задание",
        ["deDE"] = "Dieser Shortcut entfernt eine Quest aus dem Questie-Tracker, wenn das Chat-Eingabefeld nicht sichtbar ist, andernfalls wird die Quest verlinkt.",
        ["koKR"] = false,
        ["esMX"] = "Este atajo elimina una misión del rastreador cuando el cuadro de entrada del chat NO está visible; de ​​lo contrario, vinculará una misión al chat.",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "正在聊天視窗打字時，此功能會產生可以貼到聊天視窗的任務連結。不是正在打字時會從任務清單中移除任務。",
        ["esES"] = "Este atajo elimina una misión del rastreador cuando el cuadro de entrada del chat NO está visible; de ​​lo contrario, vinculará una misión al chat.",
        ["frFR"] = "Ce raccourci retire une quête du suivi de Questie lorsque la boîte de saisie de discussion n'est PAS visible, sinon il liera une quête au discussion.",
    },
    ---------------------------------------------------------
    -- Wrath of the Lich King only --
    ["Untrack / Link"] = {
        ["ptBR"] = "Remover Rastreio/Vincular missão",
        ["ruRU"] = "Отмена / Ссылка",
        ["deDE"] = "Quest verlinken/entfernen",
        ["koKR"] = "추적종료 / 링크 퀘스트",
        ["esMX"] = "No rastrear/vincular misión",
        ["enUS"] = true,
        ["zhCN"] = "停止追踪 / 链接",
        ["zhTW"] = "取消追蹤 / 任務連結",
        ["esES"] = "No rastrear/vincular misión",
        ["frFR"] = "Ne plus traquer et partager le lien de la quête",
    },
    -- Wrath of the Lich King only --
    ["This shortcut removes a Quest or an Achievement from the Questie Tracker when the chat input box is NOT visible, otherwise this will link a Quest or an Achievement to chat."] = {
        ["ptBR"] = "Este atalho remove uma missão ou uma conquista do rastreador do Questie quando a caixa de entrada do bate-papo NÃO está visível; caso contrário, ele vinculará uma missão ou uma conquista ao bate-papo.",
        ["ruRU"] = "Сочетание клавиш для отмены отслеживания задания или достижения в трекере. Если активно поле ввода чата, то вместо отмены отслеживания в чат отправится ссылка на задание или достижение",
        ["deDE"] = "Dieser Shortcut entfernt eine Quest oder einen Erfolg aus dem Questie-Tracker, wenn das Chat-Eingabefeld nicht sichtbar ist, andernfalls wird die Quest oder der Erfolg verlinkt.",
        ["koKR"] = false,
        ["esMX"] = "Este atajo elimina una misión o un logro del rastreador de Questie cuando la caja de entrada de chat NO está visible; de lo contrario, vinculará una misión o un logro al chat.",
        ["enUS"] = true,
        ["zhCN"] = "正在聊天窗口打字时，此功能会产生可以点到聊天窗口的任务或者成就链接。不是正在打字时会从任务列表中移除任务或成就。",
        ["zhTW"] = "正在聊天視窗打字時，此功能會產生可以貼到聊天視窗的任務或成就連結。不是正在打字時會從任務清單中移除任務或成就。",
        ["esES"] = "Este atajo elimina una misión o un logro del rastreador de Questie cuando la caja de entrada de chat NO está visible; de lo contrario, vinculará una misión o un logro al chat.",
        ["frFR"] = "Ce raccourci retire une quête ou un haut fait du suivi de Questie lorsque la boîte de saisie de discussion n'est PAS visible, sinon il liera une quête ou un haut fait au discussion.",
    },
    ---------------------------------------------------------
    ["Tracker Growth Direction"] = {
        ["ptBR"] = "Direção de crescimento do rastreador",
        ["ruRU"] = "Изменение размера трекера",
        ["deDE"] = "Tracker Wachstumsrichtung",
        ["koKR"] = false,
        ["esMX"] = "Dirección de crecimiento del rastreador",
        ["enUS"] = true,
        ["zhCN"] = "列表增长方向",
        ["zhTW"] = "清單增長方向",
        ["esES"] = "Dirección de crecimiento del rastreador",
        ["frFR"] = "Direction de croissance du suivi",
    },
    ["This determines the direction in which the Questie Tracker grows when you add or remove Quests. For example, if you use the 'Up & Right' option then the ideal place for the Tracker should be in the lower left-hand corner of your screen. This allows the 'Sizer Mode: Auto' to push the Tracker Height and Width 'Up & Right' so the Tracker doesn't inadvertently cover up elements of your UI."] = {
        ["ptBR"] = "Isso determina a direção na qual o rastreador do Questie cresce quando você adiciona ou remove missões. Por exemplo, se você usar a opção 'Para Cima e Para a Direita', então o local ideal para o rastreador deve ser no canto inferior esquerdo da tela. Isso permite que o 'Modo Redimensionador: Automático' empurre a Altura e a Largura do rastreador 'Para Cima e Para a Direita' para que o rastreador não cubra inadvertidamente elementos da sua interface de usuário.",
        ["ruRU"] = "Определяет направление, в котором изменяется размер трекера при добавлении или удалении заданий. Например, при использовании значения 'Вверх и вправо' идеальным расположением для трекера будет нижний левый угол вашего экрана. Это позволяет сайзеру (изменитель размера трекера) в режиме 'Авто' выставлять высоту и ширину трекера 'Вверх и вправо' так, чтобы трекер случайно не скрыл элементы вашего интерфейса.",
        ["deDE"] = "Dies bestimmt die Richtung, in der der Questie Tracker wächst, wenn Quests hinzugefügt oder entfernt werden. Wenn du beispielsweise die Option 'Oben & Rechts' verwendest, sollte sich der Tracker idealerweise in der unteren linken Ecke deines Bildschirms befinden. Dies ermöglicht es dem 'Sizer-Modus: Auto', die Tracker-Höhe und -Breite 'Oben & Rechts' zu verschieben, damit der Tracker nicht versehentlich Elemente deiner UI verdeckt.",
        ["koKR"] = false,
        ["esMX"] = "Esto determina la dirección en la que crece el rastreador cuando agregas o eliminas misiones. Por ejemplo, si usas la opción 'Arriba y derecha', el lugar ideal para el rastreador debe ser en la esquina inferior izquierda de la pantalla. Esto permite que el 'Modo de medición: Automático' empuje la altura y el ancho del rastreador hacia arriba y hacia la derecha para que el rastreador no cubra inadvertidamente elementos de su interfaz de usuario.",
        ["enUS"] = true,
        ["zhCN"] = "新增或移除任务时，任务列表的增长方向。例如：列表在界面的左下方时，可以使用 '上 & 右'，让 '调整大小模式：自动 ' 往 '上 & 右' 调整列表的高度和宽度，列表便不会挡住其他界面清。",
        ["zhTW"] = "新增或移除任務時，任務清單的延伸方向。例如清單位置在畫面的左下方時，可以使用 '上 & 右'，讓 '調整大小模式: 自動' 往 '上 & 右' 調整清單的高度和寬度，清單便不會擋住其他介面。",
        ["esES"] = "Esto determina la dirección en la que crece el rastreador cuando agregas o eliminas misiones. Por ejemplo, si usas la opción 'Arriba y derecha', el lugar ideal para el rastreador debe ser en la esquina inferior izquierda de la pantalla. Esto permite que el 'Modo de medición: Automático' empuje la altura y el ancho del rastreador hacia arriba y hacia la derecha para que el rastreador no cubra inadvertidamente elementos de su interfaz de usuario.",
        ["frFR"] = "Cela détermine la direction dans laquelle le suivi de Questie se développe lorsque vous ajoutez ou supprimez des quêtes. Par exemple, si vous utilisez l'option 'Haut et Droite', alors l'endroit idéal pour le suivi devrait être dans le coin inférieur gauche de votre écran. Cela permet au 'Mode Redimensionneur : Auto' de pousser la hauteur et la largeur du suivi 'Haut et Droite' afin que le suivi ne recouvre pas involontairement des éléments de votre interface utilisateur.",
    },
    ---------------------------------------------------------
    ["Up & Right"] = {
        ["ptBR"] = "Para cima e para a direita",
        ["ruRU"] = "Вверх и вправо",
        ["deDE"] = "Oben & Rechts",
        ["koKR"] = false,
        ["esMX"] = "Arriba y derecho",
        ["enUS"] = true,
        ["zhCN"] = "上 & 右",
        ["zhTW"] = "上 & 右",
        ["esES"] = "Arriba y derecho",
        ["frFR"] = "En haut et à droite",
    },
    ["Up & Left"] = {
        ["ptBR"] = "Para cima e para a esquerda",
        ["ruRU"] = "Вверх и влево",
        ["deDE"] = "Oben & Links",
        ["koKR"] = false,
        ["esMX"] = "Arriba y izquierdo",
        ["enUS"] = true,
        ["zhCN"] = "上 & 左",
        ["zhTW"] = "上 & 左",
        ["esES"] = "Arriba y izquierdo",
        ["frFR"] = "En haut et à gauche",
    },
    ["Down & Right"] = {
        ["ptBR"] = "Para baixo e para a direita",
        ["ruRU"] = "Вниз и вправо",
        ["deDE"] = "Unten & Rechts",
        ["koKR"] = false,
        ["esMX"] = "Abajo y derecho",
        ["enUS"] = true,
        ["zhCN"] = "下 & 右",
        ["zhTW"] = "下 & 右",
        ["esES"] = "Abajo y derecho",
        ["frFR"] = "En bas et à droite",
    },
    ["Down & Left"] = {
        ["ptBR"] = "Para baixo e para a esquerda",
        ["ruRU"] = "Вниз и влево",
        ["deDE"] = "Unten & Links",
        ["koKR"] = false,
        ["esMX"] = "Abajo y izquierdo",
        ["enUS"] = true,
        ["zhCN"] = "下 & 左",
        ["zhTW"] = "下 & 左",
        ["esES"] = "Abajo y izquierdo",
        ["frFR"] = "En bas et à gauche",
    },
    ---------------------------------------------------------
    ["Font Size for Active Quests Header"] = {
        ["ptBR"] = "Tamanho da fonte para missões ativas",
        ["ruRU"] = "Размер шрифта заголовка",
        ["deDE"] = "Schriftgröße für aktive Quests",
        ["koKR"] = "활성 퀘스트의 글꼴 크기",
        ["esMX"] = "Tamaño de fuente para misiones activas",
        ["enUS"] = true,
        ["zhCN"] = "当前任务字体大小",
        ["zhTW"] = "標題列文字大小",
        ["esES"] = "Tamaño de fuente para misiones activas",
        ["frFR"] = "Taille de police pour les quêtes actives",
    },
    ["The font size used for the Active Quests Header."] = {
        ["ptBR"] = "O tamanho da fonte que o Missões ativas usa.",
        ["ruRU"] = "Размер шрифта, используемого в заголовке 'Активные задания'",
        ["deDE"] = "Die Schriftgröße die für aktive Quests verwendet wird.",
        ["koKR"] = "Active Quests에서 사용하는 글꼴 크기입니다.",
        ["esMX"] = "El tamaño de fuente que utiliza misiones activas.",
        ["enUS"] = true,
        ["zhCN"] = "当前任务使用的字体大小。",
        ["zhTW"] = "標題列文字的字體大小。",
        ["esES"] = "El tamaño de fuente que utiliza misiones activas.",
        ["frFR"] = "Taille de police utilisée par Active Quests.",
    },
    ---------------------------------------------------------
    ["Font for Active Quests Header"] = {
        ["ptBR"] = "Fonte para missões ativas",
        ["ruRU"] = "Шрифт заголовка",
        ["deDE"] = "Schriftart für aktive Quests",
        ["koKR"] = "활성 퀘스트를위한 글꼴",
        ["esMX"] = "Fuente para misiones activas",
        ["enUS"] = true,
        ["zhCN"] = "当前任务的字体",
        ["zhTW"] = "標題列字體",
        ["esES"] = "Fuente para misiones activas",
        ["frFR"] = "Police pour les quêtes actives",
    },
    ["The font used for the Active Quests Header."] = {
        ["ptBR"] = "A fonte Missões ativas usa.",
        ["ruRU"] = "Шрифт, используемый в заголовке 'Активные задания'",
        ["deDE"] = "Die Schriftart die für aktive Quests verwendet wird.",
        ["koKR"] = "액티브 퀘스트 글꼴이 사용합니다.",
        ["esMX"] = "La fuente que utiliza misiones activas.",
        ["enUS"] = true,
        ["zhCN"] = "当前任务使用的字体。",
        ["zhTW"] = "標題列文字的字體。",
        ["esES"] = "La fuente que utiliza misiones activas.",
        ["frFR"] = "La police utilisée par Active Quests.",
    },
    ---------------------------------------------------------
    ["Font Size for Zone Names"] = {
        ["ptBR"] = "Tamanho da fonte para nomes de zonas",
        ["ruRU"] = "Размер шрифта названий игровых зон",
        ["deDE"] = "Schriftgröße für Zonennamen",
        ["koKR"] = "영역 이름의 글꼴 크기",
        ["esMX"] = "Tamaño de fuente para nombres de zona",
        ["enUS"] = true,
        ["zhCN"] = "区域名称字体大小",
        ["zhTW"] = "區域名稱文字大小",
        ["esES"] = "Tamaño de fuente para nombres de zona",
        ["frFR"] = "Taille de police pour les noms de zone",
    },
    ["The font size used for zone names."] = {
        ["ptBR"] = "O tamanho da fonte usada para nomes de zonas.",
        ["ruRU"] = "Размер шрифта, используемого в названиях игровых зон",
        ["deDE"] = "Die Schriftgröße die für Zonennamen verwendet wird.",
        ["koKR"] = "영역 이름에 사용되는 글꼴 크기입니다.",
        ["esMX"] = "El tamaño de fuente utilizado para los nombres de zona.",
        ["enUS"] = true,
        ["zhCN"] = "区域名称使用的字体大小。",
        ["zhTW"] = "區域名稱文字的字體大小。",
        ["esES"] = "El tamaño de fuente utilizado para los nombres de zona.",
        ["frFR"] = "La taille de police utilisée pour les noms de zone.",
    },
    ---------------------------------------------------------
    ["Font for Zone Names"] = {
        ["ptBR"] = "Fonte para nomes de zonas",
        ["ruRU"] = "Шрифт названий игровых зон",
        ["deDE"] = "Schriftart für Zonennamen",
        ["koKR"] = "영역 이름의 글꼴",
        ["esMX"] = "Fuente para nombres de zona",
        ["enUS"] = true,
        ["zhCN"] = "区域名称字体",
        ["zhTW"] = "區域名稱字體",
        ["esES"] = "Fuente para nombres de zona",
        ["frFR"] = "Police pour les noms de zone",
    },
    ["The font used for zone names."] = {
        ["ptBR"] = "A fonte usada para nomes de zona.",
        ["ruRU"] = "Шрифт, используемый в названиях игровых зон",
        ["deDE"] = "Die Schriftart die für Zonennamen verwendet wird.",
        ["koKR"] = "영역 이름에 사용되는 글꼴입니다.",
        ["esMX"] = "La fuente utilizada para los nombres de zona.",
        ["enUS"] = true,
        ["zhCN"] = "区域名称使用的字体",
        ["zhTW"] = "區域名稱文字的字體。",
        ["esES"] = "La fuente utilizada para los nombres de zona.",
        ["frFR"] = "La police utilisée pour les noms de zone.",
    },
    ---------------------------------------------------------
    ["Font Size for Quest Titles"] = {
        ["ptBR"] = "Tamanho da fonte dos títulos das missões",
        ["ruRU"] = "Размер шрифта названий заданий",
        ["deDE"] = "Schriftgröße für Quest-Titel",
        ["koKR"] = "퀘스트 제목의 글꼴 크기",
        ["esMX"] = "Tamaño de fuente para títulos de búsqueda",
        ["enUS"] = true,
        ["zhCN"] = "任务标题字体大小",
        ["zhTW"] = "任務標題文字大小",
        ["esES"] = "Tamaño de fuente para títulos de búsqueda",
        ["frFR"] = "Taille de police pour les titres de quête",
    },
    ["The font size used for Quest Titles.\n\nNOTE: Objective font size will auto adjust to less than or equal to Quest font size. This is necessary to avoid any text collisions and formatting abnormalities."] = {
        ["ptBR"] = "O tamanho da fonte usado para os títulos de missão.\n\nNOTA: O tamanho da fonte do objetivo será ajustado automaticamente para menos ou igual ao tamanho da fonte da missão. Isso é necessário para evitar colisões de texto e anormalidades de formatação.",
        ["ruRU"] = "Размер шрифта, используемого в названиях заданий.\n\nПРИМЕЧАНИЕ: Размер шрифта целей будет автоматически скорректирован до значения меньше или равно 'Размер шрифта названий заданий'. Это необходимо для того, чтобы избежать любых проблем с текстом и форматированием",
        ["deDE"] = "Die Schriftgröße der Quest-Titel.\n\nHINWEIS: Die Schriftgröße für Quest-Ziele wird automatisch auf weniger als oder gleich der Quest-Titel Schriftgröße angepasst. Dies ist notwendig, um Textkollisionen und Formatierungsfehler zu vermeiden.",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "任务标题文字的字体大小。\n\n注意: 任务目标文字大小会自动调整为小于或等于任务文字大小大小，这是为了避免任务文字冲突和格式异常而必需的设定。",
        ["zhTW"] = "任務標題文字的字體大小。\n\n注意: 任務目標文字大小會自動調整為小於或等於任務文字大小，這是為了避免任何文字衝突和格式異常而必須的。",
        ["esES"] = false,
        ["frFR"] = "La taille de police utilisée pour les titres de quête.\n\nNOTE : La taille de police des objectifs s'ajustera automatiquement à moins ou égale à la taille de police des quêtes. Cela est nécessaire pour éviter toute collision de texte et toute anomalie de formatage.",
    },
    ---------------------------------------------------------
    ["Font for Quest Titles"] = {
        ["ptBR"] = "Fonte para títulos de missão",
        ["ruRU"] = "Шрифт названий заданий",
        ["deDE"] = "Schriftart für Quest-Titel",
        ["koKR"] = "퀘스트 타이틀용 글꼴",
        ["esMX"] = "Fuente para los títulos de misión",
        ["enUS"] = true,
        ["zhCN"] = "任务标题字体",
        ["zhTW"] = "任務標題字體",
        ["esES"] = "Fuente para los títulos de Misión",
        ["frFR"] = "Police pour les titres de quête",
    },
    ["The font used for Quest Titles."] = {
        ["ptBR"] = "A fonte usada para os títulos das missões.",
        ["ruRU"] = "Шрифт, используемый в названиях заданий",
        ["deDE"] = "Die Schriftart die für Quest-Titel verwendet wird.",
        ["koKR"] = "퀘스트 제목에 사용되는 글꼴입니다.",
        ["esMX"] = "La fuente utilizada para los títulos de misiones.",
        ["enUS"] = true,
        ["zhCN"] = "任务标题使用的字体。",
        ["zhTW"] = "任務標題文字的字體。",
        ["esES"] = "La fuente utilizada para los títulos de misiones.",
        ["frFR"] = "La police utilisée pour les titres de quête.",
    },
    ---------------------------------------------------------
    ["Font Size for Objectives"] = {
        ["ptBR"] = "Tamanho da fonte para objetivos",
        ["ruRU"] = "Размер шрифта целей",
        ["deDE"] = "Schriftgröße für Quest-Ziele",
        ["koKR"] = "목표를위한 글꼴 크기",
        ["esMX"] = "Tamaño de fuente para objetivos",
        ["enUS"] = true,
        ["zhCN"] = "目标字体大小",
        ["zhTW"] = "任務目標文字大小",
        ["esES"] = "Tamaño de fuente para objetivos",
        ["frFR"] = "Taille de police pour les objectifs",
    },
    ["The font size used for Objectives.\n\nNOTE: Objective font size will auto adjust to less than or equal to Quest font size. This is necessary to avoid any text collisions and formatting abnormalities."] = {
        ["ptBR"] = "O tamanho da fonte usada para os objetivos.",
        ["ruRU"] = "Размер шрифта, используемого в наименованиях целей заданий.\n\nПРИМЕЧАНИЕ: Размер шрифта целей будет автоматически скорректирован до значения меньше или равно 'Размер шрифта названий заданий'. Это необходимо для того, чтобы избежать любых проблем с текстом и форматированием",
        ["deDE"] = "Die Schriftgröße die für Quest-Ziele verwendet wird.",
        ["koKR"] = "목표에 사용되는 글꼴 크기입니다.",
        ["esMX"] = "El tamaño de fuente utilizado para los objetivos.",
        ["enUS"] = true,
        ["zhCN"] = "用于目标使用的字体大小",
        ["zhTW"] = "任務目標文字的字體大小。",
        ["esES"] = "El tamaño de fuente utilizado para los objetivos.",
        ["frFR"] = "La taille de police utilisée pour les objectifs.",
    },
    ---------------------------------------------------------
    ["Font for Objectives"] = {
        ["ptBR"] = "Fonte para objetivos",
        ["ruRU"] = "Шрифт целей",
        ["deDE"] = "Schriftart für Quest-Ziele",
        ["koKR"] = "목표를위한 글꼴",
        ["esMX"] = "Fuente para objetivos",
        ["enUS"] = true,
        ["zhCN"] = "目标字体",
        ["zhTW"] = "任務目標字體",
        ["esES"] = "Fuente para objetivos",
        ["frFR"] = "Police pour objectifs",
    },
    ["The font used for Objectives."] = {
        ["ptBR"] = "A fonte usada para objetivos.",
        ["ruRU"] = "Шрифт, используемый в наименовании целей",
        ["deDE"] = "Die Schriftart die für Quest-Ziele verwendet wird.",
        ["koKR"] = "목표에 사용되는 글꼴입니다.",
        ["esMX"] = "La fuente utilizada para los objetivos.",
        ["enUS"] = true,
        ["zhCN"] = "用于目标的字体。",
        ["zhTW"] = "任務目標文字的字體。",
        ["esES"] = "La fuente utilizada para los objetivos.",
        ["frFR"] = "La police utilisée pour les objectifs.",
    },
    ---------------------------------------------------------
    ["Padding Between Quests"] = {
        ["ptBR"] = "Preenchimento entre missões",
        ["ruRU"] = "Отступ между заданиями",
        ["deDE"] = "Abstand zwischen Quests",
        ["koKR"] = "퀘스트간 간격 설정",
        ["esMX"] = "Espaciado ente misiones",
        ["enUS"] = true,
        ["zhCN"] = "任务间距",
        ["zhTW"] = "任務間距",
        ["esES"] = "Espaciado ente misiones",
        ["frFR"] = "Espacement entre les quêtes",
    },
    ["The amount of padding between Quests in the Questie Tracker.\n\nNOTE: Changing this setting while in Sizer Manual Mode will reset the Sizer back to Auto Mode"] = {
        ["ptBR"] = "A quantidade de preenchimento entre missões no Questie Tracker.\n\nOBSERVAÇÃO: Alterar esta configuração no modo Manual do Medidor irá redefinir o Medidor de volta para o Modo Automático",
        ["ruRU"] = "Установка отступа между заданиями в трекере.\n\nПРИМЕЧАНИЕ: Если сайзер (изменитель размера трекера) в ручном режиме, то изменение этой настройки сбросит режим сайзера на автоматический",
        ["deDE"] = "Der Abstand zwischen Quests im Questie-Tracker.\n\nHINWEIS: Wenn Sie diese Einstellung im manuellen Sizer-Modus ändern, wird der Sizer wieder in den automatischen Modus zurückgesetzt",
        ["koKR"] = "Questie Tracker에서 퀘스트 사이의 패딩 양입니다.\n\n참고: Sizer 수동 모드에서 이 설정을 변경하면 Sizer가 다시 자동 모드로 재설정됩니다.",
        ["esMX"] = "La cantidad de relleno entre Quests en Questie Tracker.\n\nNOTA: Cambiar esta configuración mientras está en el modo manual de Sizer restablecerá el Sizer nuevamente al modo automático",
        ["enUS"] = true,
        ["zhCN"] = "Questie Tracker 中任务之间的填充量。\n\n注意：在 Sizer 手动模式下更改此设置会将 Sizer 重置为自动模式",
        ["zhTW"] = "清單中每個任務之間的距離。\n\n注意: 在手動調整大小的模式下更改此設定會重置為自動模式。",
        ["esES"] = "La cantidad de relleno entre Quests en Questie Tracker.\n\nNOTA: Cambiar esta configuración mientras está en el modo manual de Sizer restablecerá el Sizer nuevamente al modo automático",
        ["frFR"] = "La quantité de rembourrage entre les quêtes dans le suivi des quêtes.\n\nREMARQUE : La modification de ce paramètre en mode manuel du calibreur réinitialisera le calibreur en mode automatique.",
    },
    ---------------------------------------------------------
    ["Outline for Zones, Titles, and Objectives"] = {
        ["ptBR"] = "Contorno para as zonas de missão, títulos e objetivos",
        ["ruRU"] = "Обводка шрифтов",
        ["deDE"] = "Konturen für Zonen, Titel und Ziele",
        ["koKR"] = false,
        ["esMX"] = "Contorno de zonas, títulos y objetivos",
        ["enUS"] = true,
        ["zhCN"] = "区域、标题和任务目标的文字外框",
        ["zhTW"] = "區域、標題和任務目標的文字外框",
        ["esES"] = "Contorno de zonas, títulos y objetivos",
        ["frFR"] = "Contours des Zones, des Titres et des Objectifs",
    },
    ["The outline used for Quest Zones, Titles, and Objectives in the Questie Tracker."] = {
        ["ptBR"] = "O contorno usado para as zonas de missão, títulos e objetivos no rastreador do Questie.",
        ["ruRU"] = "Обводка для шрифтов названий игровых зон, названий заданий и целей",
        ["deDE"] = "Die Konturen die für Zonen, Titel und Ziele im Questie-Tracker verwendet werden.",
        ["koKR"] = false,
        ["esMX"] = "El contorno utilizado para las zonas de misiones, títulos y objetivos en el rastreador.",
        ["enUS"] = true,
        ["zhCN"] = "区域、标题和任务目标文字的外框样式。",
        ["zhTW"] = "區域、標題和任務目標文字的外框樣式。",
        ["esES"] = "El contorno utilizado para las zonas de misiones, títulos y objetivos en el rastreador.",
        ["frFR"] = "Contour utilisé pour les zones de quêtes, les titres et les objectifs dans le traqueur",
    },
    ---------------------------------------------------------
    ["Tracker Backdrop Alpha"] = {
        ["ptBR"] = "Alfa do cenário do rastreador",
        ["ruRU"] = "Непрозрачность фона",
        ["deDE"] = "Tracker Hintergrund Alpha",
        ["koKR"] = "트래커 배경 알파",
        ["esMX"] = "Transparencia del fondo del rastreador",
        ["enUS"] = true,
        ["zhCN"] = "背景透明度",
        ["zhTW"] = "背景透明度",
        ["esES"] = "Transparencia del fondo del rastreador",
        ["frFR"] = "Opacité de l'arrière-plan",
    },
    ["The alpha level of the Questie Trackers backdrop. A setting of 100 percent is fully visible."] = {
        ["ptBR"] = "O nível alfa do cenário do rastreador",
        ["ruRU"] = "Уровень непрозрачности фона трекера",
        ["deDE"] = "Das Alpha-Level des Tracker-Hintergrunds",
        ["koKR"] = "트래커 배경의 알파 수준",
        ["esMX"] = "La transparencia del fondo del rastreador",
        ["enUS"] = true,
        ["zhCN"] = "设置背景的透明度",
        ["zhTW"] = "任務清單背景的透明度，100% 是完全不透明。",
        ["esES"] = "La transparencia del fondo del rastreador",
        ["frFR"] = "Définis l'opacité de l'arrière-plan du suivi des quêtes Questie.",
    },
    ---------------------------------------------------------
    ["Tracker Height Ratio"] = {
        ["ptBR"] = "Proporção de altura do rastreador",
        ["ruRU"] = "Соотношение высоты трекера",
        ["deDE"] = "Tracker Höhenverhältnis",
        ["koKR"] = false,
        ["esMX"] = "Relación de altura del rastreador",
        ["enUS"] = true,
        ["zhCN"] = "列表高度比例",
        ["zhTW"] = "清單高度比例",
        ["esES"] = "Relación de altura del rastreador",
        ["frFR"] = "Ratio de hauteur du suivi",
    },
    ["The height of the Questie Tracker based on percentage of usable screen height. A setting of 100 percent would make the Tracker fill the players entire screen height.\n\nNOTE: This setting only applies while in Sizer Mode: Auto"] = {
        ["ptBR"] = "A altura do rastreador do Questie baseada em percentagem da altura de tela utilizável. Uma configuração de 100 por cento faria com que o rastreador preenchesse toda a altura da tela do jogador.\n\nNOTA: Esta configuração só se aplica enquanto estiver no Modo de Redimensionamento: Automático.",
        ["ruRU"] = "Высота трекера, основанная на процентах от высоты экрана. Значение 100 заставит трекер заполнять всю высоту экрана.\n\nПРИМЕЧАНИЕ: Эта настройка работает только тогда, когда сайзер (изменитель размера трекера) в автоматическом режиме",
        ["deDE"] = "Die Höhe des Questie-Trackers basierend auf dem Prozentsatz der nutzbaren Bildschirmhöhe. Eine Einstellung von 100 Prozent würde den Tracker die gesamte Bildschirmhöhe des Spielers ausfüllen lassen.\n\nHINWEIS: Diese Einstellung gilt nur im Sizer-Modus: Auto",
        ["koKR"] = false,
        ["esMX"] = "La altura del rastreador se basa en el porcentaje de la altura utilizable de la pantalla. Una configuración del 100 por ciento haría que el rastreador llenara toda la altura de la pantalla del jugador.\n\nNOTA: Esta configuración solo se aplica en el modo Tamaño: Auto",
        ["enUS"] = true,
        ["zhCN"] = "列表高度依据可用的界面高度百分比，100%会让列表和界面一样高。\n\n注意：此设定只在调整大小模式为自动时有效。",
        ["zhTW"] = "清單高度依據可用的畫面高度百分比，100% 會讓清單和畫面一樣高。\n\n注意: 此設定只在調整大小模式為自動時有效。",
        ["esES"] = "La altura del rastreador se basa en el porcentaje de la altura utilizable de la pantalla. Una configuración del 100 por ciento haría que el rastreador llenara toda la altura de la pantalla del jugador.\n\nNOTA: Esta configuración solo se aplica en el modo Tamaño: Auto",
        ["frFR"] = "La hauteur du suivi de Questie en pourcentage de la hauteur d'écran utilisable. Un réglage de 100 pour cent ferait remplir la hauteur de l'écran du joueur.\n\nNOTE : Ce réglage ne s'applique que lors du mode Redimensionneur : Automatique.",
    },
    ["Font Options"] = {
        ["ptBR"] = "Opções de fonte",
        ["ruRU"] = "Настройки шрифтов",
        ["deDE"] = "Schriftarten",
        ["koKR"] = false,
        ["esMX"] = "Opciones de fuente",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "字體選項",
        ["esES"] = "Opciones de fuente",
        ["frFR"] = "Options de police",
    },
    ["Quest Options"] = {
        ["ptBR"] = "Opções de missão",
        ["ruRU"] = "Настройки заданий",
        ["deDE"] = "Quest-Einstellungen",
        ["koKR"] = false,
        ["esMX"] = "Opciones de misión",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "任務選項",
        ["esES"] = "Opciones de misión",
        ["frFR"] = "Options de quête",
    },
    ["Quest and Achievement Options"] = {
        ["ptBR"] = "Opções de missões e conquistas",
        ["ruRU"] = "Настройки заданий и достижений",
        ["deDE"] = "Quest- und Erfolg-Einstellungen",
        ["koKR"] = false,
        ["esMX"] = "Opciones de misión y logro",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "任務和成就選項",
        ["esES"] = "Opciones de misión y logro",
        ["frFR"] = "Options des quêtes et des hauts faits",
    },
    ["Tracker Window Options"] = {
        ["ptBR"] = "Opções da janela do rastreador",
        ["ruRU"] = "Настройки окна трекера",
        ["deDE"] = "Tracker-Fenster-Einstellungen",
        ["koKR"] = false,
        ["esMX"] = "Opciones de la ventana del rastreador",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "任務清單視窗選項",
        ["esES"] = "Opciones de la ventana del rastreador",
        ["frFR"] = "Options de la fenêtre de suivi",
    },
    ["Tracker Background"] = {
        ["ptBR"] = "Fundo do rastreador",
        ["ruRU"] = "Фон трекера",
        ["deDE"] = "Tracker-Hintergrund",
        ["koKR"] = false,
        ["esMX"] = "Fondo del rastreador",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "任務清單背景",
        ["esES"] = "Fondo del rastreador",
        ["frFR"] = "Arrière-plan du suivi",
    },
    ["Tracker Header"] = {
        ["ptBR"] = "Cabeçalho do rastreador",
        ["ruRU"] = "Заголовок трекера",
        ["deDE"] = "Tracker-Kopfzeile",
        ["koKR"] = false,
        ["esMX"] = "Encabezado del rastreador",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "任務清單標題列",
        ["esES"] = "Encabezado del rastreador",
        ["frFR"] = "En-tête du suivi",
    },
}

for k, v in pairs(trackerOptionsLocales) do
    l10n.translations[k] = v
end
