---@type SeasonOfDiscovery
local SeasonOfDiscovery = QuestieLoader:ImportModule("SeasonOfDiscovery")
---@type QuestieDB
local QuestieDB = QuestieLoader:ImportModule("QuestieDB")
---@type ZoneDB
local ZoneDB = QuestieLoader:ImportModule("ZoneDB")

--- Load the base quests for Season of Discovery
--- These are generated, do NOT EDIT the data entries here.
--- If you want to edit a quest, do so in sodQuestFixes.lua
function SeasonOfDiscovery:LoadBaseQuests()
    local questKeys = QuestieDB.questKeys
    local zoneIDs = ZoneDB.zoneIDs
    local raceIDs = QuestieDB.raceKeys
    local classIDs = QuestieDB.classKeys
    local sortKeys = QuestieDB.sortKeys

    return {
        [76156] = {
            [questKeys.name] = "Stalk With The Earthmother",
            [questKeys.startedBy] = {{205729}},
            [questKeys.finishedBy] = {{205729,}},
            [questKeys.requiredLevel] = 4,
            [questKeys.questLevel] = 6,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Sneak into the Venture Company mine southeast of Thunder Bluff and collect 5 Seaforium Mining Charges from carts of blasting supplies, then return them to Boarton Shadetotem in Thunder Bluff."},
            [questKeys.objectives] = {nil,nil,{{206157}}},
        },
        [76160] = {
            [questKeys.name] = "Stalk With The Earthmother",
            [questKeys.startedBy] = {{205729}},
            [questKeys.finishedBy] = {{205729,}},
            [questKeys.requiredLevel] = 4,
            [questKeys.questLevel] = 6,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Gather 8 Windfury Cones north of Thunder Bluff, use them with the Mortar and Pestle, then return to Boarton Shadetotem in Thunder Bluff with the result."},
            [questKeys.objectives] = {nil,nil,{{206175},{206176}}},
        },
        [76240] = {
            [questKeys.name] = "Stalk With The Earthmother",
            [questKeys.startedBy] = {{205729}},
            [questKeys.finishedBy] = {{205729,}},
            [questKeys.requiredLevel] = 4,
            [questKeys.questLevel] = 6,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Buy or catch a Raw Brilliant Smallfish, then use the Knife Set to fillet it in front of Boarton Shadetotem in Thunder Bluff."},
            [questKeys.objectives] = {nil,nil,{{206345},{206344}}},
        },
        [77568] = {
            [questKeys.name] = "A Hunter's Strength",
            [questKeys.startedBy] = {{3596}},
            [questKeys.finishedBy] = {{3596,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Defeat Githyiss the Vile in Shadowthread Cave and recover the lost rune. Learn the rune, then report back to Ayanna Everstride in Shadowglen."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{410121}}},
        },
        [77571] = {
            [questKeys.name] = "Relics of the Kaldorei",
            [questKeys.startedBy] = {{3597}},
            [questKeys.finishedBy] = {{3597,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Recover the relic from the grellkin in Shadowglen. Follow the relic's guidance to learn a new ability, then report back to Mardant Strongoak."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{410061}}},
        },
        [77573] = {
            [questKeys.name] = "Second-Story Work",
            [questKeys.startedBy] = {{3594}},
            [questKeys.finishedBy] = {{3594,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Retrieve the rune from the hidden idol, then use it to learn a new ability. Afterwards, return to Frahun Shadewhisper."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{400105}}},
        },
        [77574] = {
            [questKeys.name] = "Meditation on Elune",
            [questKeys.startedBy] = {{3595}},
            [questKeys.finishedBy] = {{3595,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kneel at the moonwell to meditate on Elune, then use the memory to learn a new ability. Afterwards, return to Shanda in Shadowglen."},
            [questKeys.objectives] = {nil,nil,{{205951}}},
        },
        [77575] = {
            [questKeys.name] = "Amidst the Shadowed Webs",
            [questKeys.startedBy] = {{3593}},
            [questKeys.finishedBy] = {{3593,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Slay webwood spiders in Shadowthread Cave and recover the lost rune. Learn the rune, then report back to Alyissia in Shadowglen."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{403470}}},
        },
        [77582] = {
            [questKeys.name] = "A Trial of Fitness",
            [questKeys.startedBy] = {{3153}},
            [questKeys.finishedBy] = {{3153,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Find the Hidden Cache in the cliffs behind Frang. Learn the rune inside, then report back to Frang in the Valley of Trials."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{403470}}},
        },
        [77583] = {
            [questKeys.name] = "Atop the Cliffs",
            [questKeys.startedBy] = {{3155}},
            [questKeys.finishedBy] = {{3155,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Find the Hidden Cache in the cliffs surrounding the Valley of Trials. Learn the rune inside, then report back to Rwag in The Den."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{400105}}},
        },
        [77584] = {
            [questKeys.name] = "Hunt for the Rune",
            [questKeys.startedBy] = {{3154}},
            [questKeys.finishedBy] = {{3154,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Find the lost rune by slaying scorpids in the Valley of Trials. Learn the rune's power, then report back to Jen'sahn."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{410121}}},
        },
        [77585] = {
            [questKeys.name] = "Icons of Power",
            [questKeys.startedBy] = {{3157}},
            [questKeys.finishedBy] = {{3157,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Find the stolen icon by slaying scorpids in the Valley of Trials. Learn its power, then report back to Shikrik."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{410094}}},
        },
        [77586] = {
            [questKeys.name] = "Stolen Power",
            [questKeys.startedBy] = {{3156}},
            [questKeys.finishedBy] = {{3156,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Find the stolen rune inside of the Burning Blade Coven. Learn its power, then report back to Nartok in The Den."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{403919}}},
        },
        [77587] = {
            [questKeys.name] = "Icons of Power",
            [questKeys.startedBy] = {{3157}},
            [questKeys.finishedBy] = {{3157,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Find the stolen icon by slaying scorpids in the Valley of Trials. Learn its power, then report back to Shikrik."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{410094}}},
        },
        [77588] = {
            [questKeys.name] = "A Trial of Fitness",
            [questKeys.startedBy] = {{3153}},
            [questKeys.finishedBy] = {{3153,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Find the Hidden Cache in the cliffs behind Frang. Learn the rune inside, then report back to Frang in the Valley of Trials."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{403470}}},
        },
        [77590] = {
            [questKeys.name] = "Rugged Terrain",
            [questKeys.startedBy] = {{3154}},
            [questKeys.finishedBy] = {{3154,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Find the lost rune by slaying scorpids in the Valley of Trials. Learn the rune's power, then report back to Jen'sahn."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{410121}}},
        },
        [77592] = {
            [questKeys.name] = "Atop the Cliffs",
            [questKeys.startedBy] = {{3155}},
            [questKeys.finishedBy] = {{3155,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Find the Hidden Cache in the cliffs surrounding the Valley of Trials. Learn the rune inside, then report back to Rwag in The Den."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{400105}}},
        },
        [77616] = {
            [questKeys.name] = "The Lost Rune",
            [questKeys.startedBy] = {{911}},
            [questKeys.finishedBy] = {{911,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Find the lost rune within Echo Ridge Mine and use it to learn a new ability, then report back to Llane Beshere in Northshire."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{403470}}},
        },
        [77617] = {
            [questKeys.name] = "Relics of the Light",
            [questKeys.startedBy] = {{925}},
            [questKeys.finishedBy] = {{925,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Recover the libram and follow its guidance to learn a new ability, then return to Brother Sammuel in Northshire."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{410002}}},
        },
        [77618] = {
            [questKeys.name] = "Thrice Stolen",
            [questKeys.startedBy] = {{915}},
            [questKeys.finishedBy] = {{915,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Recover the lost rune from the Defias camps and use it to learn a new ability, then return to Jorik Kerridan in Northshire."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{400105}}},
        },
        [77619] = {
            [questKeys.name] = "Meditation on the Light",
            [questKeys.startedBy] = {{375}},
            [questKeys.finishedBy] = {{375,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Slay kobolds in Echo Ridge Mine to receive a memory. Kneel within Northshire Abbey to meditate on the light, then use the memory to learn a new ability. Afterwards, return to Priestess Anetta."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{402862}}},
        },
        [77620] = {
            [questKeys.name] = "Spell Research",
            [questKeys.startedBy] = {{198}},
            [questKeys.finishedBy] = {{198,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Recover research notes from the Defias bandits and use them to learn a new spell, then return to Khelden Bremen in Northshire."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{401760}}},
        },
        [77621] = {
            [questKeys.name] = "Stolen Power",
            [questKeys.startedBy] = {{459}},
            [questKeys.finishedBy] = {{459,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Recover the rune from the Defias camps to the east and use it to learn a new ability, then return to Drusilla La Salle in Northshire."},
            [questKeys.objectives] = nil,
        },
        [77642] = {
            [questKeys.name] = "Wisdom of the Loa",
            [questKeys.startedBy] = {{3707}},
            [questKeys.finishedBy] = {{3707,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kneel at the Loa Altar in Sen'jin Village. Commune with the Loa spirit, then use the memory to learn a new ability. Afterwards, return to Ken'jai  in the Valley of Trails."},
            [questKeys.objectives] = {nil,nil,{{205951}}},
        },
        [77643] = {
            [questKeys.name] = "Spell Research",
            [questKeys.startedBy] = {{5884}},
            [questKeys.finishedBy] = {{5884,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Find the stolen spell notes inside the Burning Blade Coven, then use them to learn a new ability. Afterwards, return to Mai'ah in the Valley of Trails."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{401760}}},
        },
        [77648] = {
            [questKeys.name] = "Relics of the Tauren",
            [questKeys.startedBy] = {{3060}},
            [questKeys.finishedBy] = {{3060,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Recover the stolen relic from Brambleblade Ravine. Follow the relic's guidance to learn a new ability, then report back to Gart Mistrunner in Camp Narache."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{410061}}},
        },
        [77649] = {
            [questKeys.name] = "A Hunter's Strength",
            [questKeys.startedBy] = {{3061}},
            [questKeys.finishedBy] = {{3061,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Find the missing rune by slaying Bristleback Battleboars in Brambleblade Ravine. Use the rune to learn a new ability, then report back to Lanka Farshot in Camp Narache."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{410121}}},
        },
        [77651] = {
            [questKeys.name] = "Into the Brambles",
            [questKeys.startedBy] = {{3059}},
            [questKeys.finishedBy] = {{3059,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Recover the lost rune from Brambleblade Ravine. Use the rune to learn a new ability, then report back to Harutt Thunderhorn in Camp Narache."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{403470}}},
        },
        [77652] = {
            [questKeys.name] = "Icons of Power",
            [questKeys.startedBy] = {{3062}},
            [questKeys.finishedBy] = {{3062,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Recover the lost icon from the Bristleback Shamans in Brambleblade Ravine. Learn its power, then report back to Harutt Thunderhorn in Camp Narache."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{410094}}},
        },
        [77655] = {
            [questKeys.name] = "The Lost Rune",
            [questKeys.startedBy] = {{912}},
            [questKeys.finishedBy] = {{912,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Find the lost rune carried by a  Frostmane troll in Coldridge Valley. Use it to learn a new ability, then report back to Thran Khorman in Anvilmar."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{403470}}},
        },
        [77656] = {
            [questKeys.name] = "The Lost Rune",
            [questKeys.startedBy] = {{912}},
            [questKeys.finishedBy] = {{912,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Find the lost rune carried by a Frostmane troll in Coldridge Valley. Use it to learn a new ability, then report back to Thran Khorman in Anvilmar."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{403470}}},
        },
        [77657] = {
            [questKeys.name] = "Relics of the Light",
            [questKeys.startedBy] = {{926}},
            [questKeys.finishedBy] = {{926,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Recover the stolen libram carried by a Frostmane troll in Coldridge Valley. Follow its guidance to learn a new ability, then return to Bromos Grummner in Anvilmar."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{410002}}},
        },
        [77658] = {
            [questKeys.name] = "Thrice Stolen",
            [questKeys.startedBy] = {{916}},
            [questKeys.finishedBy] = {{916,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Recover the stolen rune from the cave of Frostmane trolls in Coldridge Valley. Use it to learn a new ability, then return to Solm Hargrin in Anvilmar."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{400105}}},
        },
        [77659] = {
            [questKeys.name] = "Thrice Stolen",
            [questKeys.startedBy] = {{916}},
            [questKeys.finishedBy] = {{916,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Recover the stolen rune from the cave of Frostmane trolls in Coldridge Valley. Use it to learn a new ability, then return to Solm Hargrin in Anvilmar."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{400105}}},
        },
        [77660] = {
            [questKeys.name] = "Trek Through the Caves",
            [questKeys.startedBy] = {{895}},
            [questKeys.finishedBy] = {{895,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Recover the stolen rune from the cave of Frostmane trolls in Coldridge Valley. Use the rune to learn a new ability, then report back to Thorgas Grimson in Anvilmar."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{410121}}},
        },
        [77661] = {
            [questKeys.name] = "Meditation on the Light",
            [questKeys.startedBy] = {{837}},
            [questKeys.finishedBy] = {{837,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Find a memory of the past inside of a chest at the trogg camp near Anvilmar. Then, kneel at the Altar of the Light within Anvilmar to meditate on the light, and use the memory to learn a new ability. Afterwards, speak to Branstock Khalder."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{402862}}},
        },
        [77666] = {
            [questKeys.name] = "Stolen Power",
            [questKeys.startedBy] = {{460}},
            [questKeys.finishedBy] = {{460,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Recover the rune from the group of Troggs, southwest of Anvilmar, and use it to learn a new ability. Then, return to Alamar Grimm in Anvilmar."},
            [questKeys.objectives] = nil,
        },
        [77667] = {
            [questKeys.name] = "Spell Research",
            [questKeys.startedBy] = {{944}},
            [questKeys.finishedBy] = {{944,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Find the stolen spell notes at the trogg camp to the southwest of Anvilmar, then use them to learn a new ability. Afterwards, return to Marryk Nurribit in Anvilmar."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{401760}}},
        },
        [77668] = {
            [questKeys.name] = "The Lost Rune",
            [questKeys.startedBy] = {{2119}},
            [questKeys.finishedBy] = {{2119,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Find the rune hidden in Night Web's Hollow and use it to learn a new technique, then report back to Dannal Stern in Deathknell."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{403470}}},
        },
        [77669] = {
            [questKeys.name] = "The Scarlet Rune",
            [questKeys.startedBy] = {{2122}},
            [questKeys.finishedBy] = {{2122,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Pickpocket or kill Scarlet Converts to find a rune, then use it to learn a new ability. Afterwards, return to David Trias in Deathknell."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{400105}}},
        },
        [77670] = {
            [questKeys.name] = "Meditation on Undeath",
            [questKeys.startedBy] = {{2123}},
            [questKeys.finishedBy] = {{2123,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kneel in the graveyard to meditate on undeath, then use the rune to learn a new ability. Afterwards, return to Dark Cleric Duesten in the Deathknell chapel."},
            [questKeys.objectives] = {nil,nil,{{205951}}},
        },
        [77671] = {
            [questKeys.name] = "Spell Research",
            [questKeys.startedBy] = {{2124}},
            [questKeys.finishedBy] = {{2124,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Kill Scarlet Initiates to find spell notes and use them to learn a new ability, then return to Isabella in Deathknell."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{401760}}},
        },
        [77672] = {
            [questKeys.name] = "The Lost Rune",
            [questKeys.startedBy] = {{2126}},
            [questKeys.finishedBy] = {{2126,}},
            [questKeys.requiredLevel] = 2,
            [questKeys.questLevel] = 2,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Recover the rune from Night Web's Hollow and use it to learn a new ability, then return to Maximillion in Deathknell."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{403919}}},
        },
        [78088] = {
            [questKeys.name] = "A Strange Artifact",
            [questKeys.startedBy] = {{3663}},
            [questKeys.finishedBy] = {{3663,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Did you find something in the tower?"},
            [questKeys.objectives] = {nil,nil,{{209836}}},
        },
        [78089] = {
            [questKeys.name] = "Advice From Stormwind",
            [questKeys.startedBy] = {{3663}},
            [questKeys.finishedBy] = {{5492,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Consult the paladins of Stormwind for advice on the orb."},
            [questKeys.objectives] = nil,
        },
        [78090] = {
            [questKeys.name] = "A Second Opinion",
            [questKeys.startedBy] = {{5492}},
            [questKeys.finishedBy] = {{5495,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Find the warlock sanctum within Stormwind and seek advice on the orb."},
            [questKeys.objectives] = nil,
        },
        [78091] = {
            [questKeys.name] = "Earning Your Salt",
            [questKeys.startedBy] = {{5495}},
            [questKeys.finishedBy] = {{5495,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Collect 14 Summoner's Salt from Blackrock Summoners in Redridge Mountains, then return to Ursula Deline in Stormwind."},
            [questKeys.objectives] = {nil,nil,{{209778}}},
        },
        [78092] = {
            [questKeys.name] = "It Must Be Destroyed",
            [questKeys.startedBy] = {{5495}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Find a way to destroy the orb."},
            [questKeys.objectives] = {nil,nil,{{209779}}},
        },
        [78093] = {
            [questKeys.name] = "Return to Delgren",
            [questKeys.startedBy] = {{3663}},
            [questKeys.finishedBy] = {{3663,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Return the Orb Shards to Delgren."},
            [questKeys.objectives] = nil,
        },
        [78114] = {
            [questKeys.name] = "Wild Wyvern Wrangling",
            [questKeys.startedBy] = {{210845}},
            [questKeys.finishedBy] = {{210845,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Bring a Hypnotic Crystal and a Gnarled Wand of Wild Magic to Jixo Madrocket in the Stonetalon Mountains."},
            [questKeys.objectives] = {nil,nil,{{209838},{209840}}},
        },
        [78121] = {
            [questKeys.name] = "Wrangling a Wild Wyvern",
            [questKeys.startedBy] = {{210845}},
            [questKeys.finishedBy] = {{210845,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Follow Jixo Madrocket, and watch him tame a Wyvern."},
            [questKeys.objectives] = nil,
        },
        [78124] = {
            [questKeys.name] = "Nar'thalas Almanac",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{209843}}},
        },
        [78127] = {
            [questKeys.name] = "The Dalaran Digest",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{209844}}},
        },
        [78132] = {
            [questKeys.name] = "Dragonslayer's Helm",
            [questKeys.startedBy] = {{210995}},
            [questKeys.finishedBy] = {{210995,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"The helm of the Dragonslayer once belonged to a great commander who fell in battle. It is said his tormented soul still haunts the site of his passing."},
            [questKeys.objectives] = {nil,nil,{{209872}}},
        },
        [78133] = {
            [questKeys.name] = "Dragonslayer's Shield",
            [questKeys.startedBy] = {{210995}},
            [questKeys.finishedBy] = {{210995,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"The shield of the Dragonslayer is rumored to be held by an Orcish warlord. He stole it while raiding a human settlement."},
            [questKeys.objectives] = {nil,nil,{{209873}}},
        },
        [78134] = {
            [questKeys.name] = "Dragonslayer's Lance",
            [questKeys.startedBy] = {{210995}},
            [questKeys.finishedBy] = {{210995,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"The lance of the Dragonslayer has changed hands many times. Every now and then, rumor spreads of it appearing in black market arms deals. Perhaps the lance's current unsavory proprietor would be willing to part with it; for a price."},
            [questKeys.objectives] = {nil,nil,{{209874}}},
        },
        [78142] = {
            [questKeys.name] = "Bewitchments and Glamours",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{209845}}},
        },
        [78143] = {
            [questKeys.name] = "Secrets of the Dreamers",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{209846}}},
        },
        [78144] = {
            [questKeys.name] = "Alonso the Dragonslayer",
            [questKeys.startedBy] = {{210995}},
            [questKeys.finishedBy] = {{210995,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Accompany Alonso to slay the dragon."},
            [questKeys.objectives] = nil,
        },
        [78145] = {
            [questKeys.name] = "Arcanic Systems Manual",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{209847}}},
        },
        [78146] = {
            [questKeys.name] = "Goaz Scrolls",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{209848}}},
        },
        [78147] = {
            [questKeys.name] = "Crimes Against Anatomy",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{209849}}},
        },
        [78148] = {
            [questKeys.name] = "Runes of the Sorceror-Kings",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{209850}}},
        },
        [78149] = {
            [questKeys.name] = "Fury of the Land",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{209851}}},
        },
        [78150] = {
            [questKeys.name] = "Friend of the Library",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Thanks to your donations, the library is thriving.Please, take this."},
            [questKeys.objectives] = nil,
        },
        [78192] = {
            [questKeys.name] = "Secrets of the Light",
            [questKeys.startedBy] = {{211188}},
            [questKeys.finishedBy] = {{211188,}},
            [questKeys.requiredLevel] = 17,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill 7 Forsaken Herbalists and 9 Forsaken Seekers in northwest Ashenvale, then return to Maethra Slagheart in Darnassus."},
            [questKeys.objectives] = nil,
        },
        [78193] = {
            [questKeys.name] = "Secrets of the Light",
            [questKeys.startedBy] = {{211188}},
            [questKeys.finishedBy] = {{376,}},
            [questKeys.requiredLevel] = 17,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Travel to Stormwind City and speak to High Priestess Laurena in the Cathedral of Light."},
            [questKeys.objectives] = nil,
        },
        [78194] = {
            [questKeys.name] = "Secrets of Elune",
            [questKeys.startedBy] = {{11397}},
            [questKeys.finishedBy] = {{11397,}},
            [questKeys.requiredLevel] = 17,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Collect 10 Dire Wolf Paws from wolves in Duskwood."},
            [questKeys.objectives] = {nil,nil,{{210053}}},
        },
        [78195] = {
            [questKeys.name] = "Secrets of Elune",
            [questKeys.startedBy] = {{11397}},
            [questKeys.finishedBy] = {{211298,}},
            [questKeys.requiredLevel] = 17,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Bring the phial to Syrnoya at the Auberdine moonwell."},
            [questKeys.objectives] = nil,
        },
        [78196] = {
            [questKeys.name] = "Secrets of Undeath",
            [questKeys.startedBy] = {{211229}},
            [questKeys.finishedBy] = {{211229,}},
            [questKeys.requiredLevel] = 18,
            [questKeys.questLevel] = 22,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Collect 12 Shadeleaf from Shadethicket elementals in Ashenvale."},
            [questKeys.objectives] = {nil,nil,{{210045}}},
        },
        [78197] = {
            [questKeys.name] = "Secrets of Undeath",
            [questKeys.startedBy] = {{211229}},
            [questKeys.finishedBy] = {{6491,}},
            [questKeys.requiredLevel] = 18,
            [questKeys.questLevel] = 22,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Travel to Brill's graveyard in Tirisfal Glades and use the Tincture of Waking Death."},
            [questKeys.objectives] = nil,
        },
        [78198] = {
            [questKeys.name] = "Secrets of the Loa",
            [questKeys.startedBy] = {{211225}},
            [questKeys.finishedBy] = {{211225,}},
            [questKeys.requiredLevel] = 18,
            [questKeys.questLevel] = 23,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Collect 14 Hillsbrad Human Bones from humans in Hillsbrad Foothills, then return to Baj'ura in Undercity."},
            [questKeys.objectives] = {nil,nil,{{210055}}},
        },
        [78199] = {
            [questKeys.name] = "Secrets of the Loa",
            [questKeys.startedBy] = {{211225}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 18,
            [questKeys.questLevel] = 23,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Travel to the Echo Isles and use the offering at Bwonsamdi's shrine."},
            [questKeys.objectives] = nil,
        },
        [78229] = {
            [questKeys.name] = "Trial of The Owls",
            [questKeys.startedBy] = {{12042}},
            [questKeys.finishedBy] = {{12042,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Bring symbols of the three owls to Loganaar in Moonglade."},
            [questKeys.objectives] = {nil,nil,{{210044},{210043},{210026}}},
        },
        [78261] = {
            [questKeys.name] = "The Horn of Xelthos",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 23,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Find The Horn of Xelthos inside of Shadowfang Keep. Then, return it to C's dead drop near Pyrewood Village. You must complete the job alone."},
            [questKeys.objectives] = {nil,nil,{{210183}}},
        },
        [78265] = {
            [questKeys.name] = "Fish Oil",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = {{211653,}},
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"I'm going to need fish oil - and a lot of it!"},
            [questKeys.objectives] = {nil,nil,{{17058}}},
        },
        [78266] = {
            [questKeys.name] = "Dark Iron Ordinance",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = {{211653,}},
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"I'll need some Dark Iron Ordinance. Where are you going to find Dark Iron dwarves? That's your problem!"},
            [questKeys.objectives] = {nil,nil,{{210138}}},
        },
        [78267] = {
            [questKeys.name] = "Shredder Turbochargers",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = {{211653,}},
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"I'll need some of the Venture Company's Shredder Turbochargers. They're tightly coupled to the shredder systems, so you'll need special equipment to salvage them.No, I don't have that equipment."},
            [questKeys.objectives] = {nil,nil,{{210146}}},
        },
        [78270] = {
            [questKeys.name] = "Goblin Lockpicks",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{4086,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 23,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Find The Horn of Xelthos inside of Shadowfang Keep. Then, return it to C's dead drop near Pyrewood Village."},
            [questKeys.objectives] = {nil,nil,{{210187}}},
        },
        [78277] = {
            [questKeys.name] = "A Token of Gratitude",
            [questKeys.startedBy] = {{1498}},
            [questKeys.finishedBy] = {{1498,}},
            [questKeys.requiredLevel] = 12,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"It might have been a silly thing to do, but Thule, Gunthar and I were like family... brothers. We never expected our world to be torn apart, nor for Thule to side with the Lich King leaving Gunthar and myself to fight for our humanity... I can sense the taint of the scourge seeping into Thule's portion of the wand. It will forever be marred, corrupted by his betrayal, but alas I am not ready to let go... maybe with time.Please accept this token of knowledge as my final thanks."},
            [questKeys.objectives] = nil,
        },
        [78287] = {
            [questKeys.name] = "Let Me Make You An Offer",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = {{8383,}},
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Take the Arms Shipment to Master Wood in Stormwind City."},
            [questKeys.objectives] = nil,
        },
        [78288] = {
            [questKeys.name] = "Let Me Make You An Offer",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = {{3408,}},
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Take the Arms Shipment to Zel'mak in Orgrimmar."},
            [questKeys.objectives] = nil,
        },
        [78297] = {
            [questKeys.name] = "You've Got Yourself A Deal",
            [questKeys.startedBy] = {{8383}},
            [questKeys.finishedBy] = {{211653,}},
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return the Signed Procurement Contract to Grizzby in Ratchet."},
            [questKeys.objectives] = nil,
        },
        [78304] = {
            [questKeys.name] = "You've Got Yourself A Deal",
            [questKeys.startedBy] = {{3408}},
            [questKeys.finishedBy] = {{211653,}},
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return the Signed Procurement Contract to Grizzby in Ratchet."},
            [questKeys.objectives] = nil,
        },
        [78307] = {
            [questKeys.name] = "The Horn of Xelthos",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 23,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Log."},
            [questKeys.objectives] = nil,
        },
        [78506] = {
            [questKeys.name] = "Elemental Distress",
            [questKeys.startedBy] = {{12736}},
            [questKeys.finishedBy] = {{12736,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Collect motes of elemental rage, and bring them to Je'neu Sancrea at Zoram'gar Outpost, Ashenvale."},
            [questKeys.objectives] = {nil,nil,{{210668},{210667},{210665}}},
        },
        [78537] = {
            [questKeys.name] = "Elixir of Insight",
            [questKeys.startedBy] = {{12736}},
            [questKeys.finishedBy] = {{12736,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Bring an Elixir of Water Breathing and an Elixir of Wisdom to Je'neu Sancrea at Zoram'gar Outpost, Ashenvale."},
            [questKeys.objectives] = {nil,nil,{{5996},{3383}}},
        },
        [78561] = {
            [questKeys.name] = "Elixir of Insight",
            [questKeys.startedBy] = {{12736}},
            [questKeys.finishedBy] = {{12736,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Drink the Elixir of Insight near the bonfire at Zoram'gar Outpost, and witness the vision it grants you."},
            [questKeys.objectives] = {nil,nil,{{210712}}},
        },
        [78575] = {
            [questKeys.name] = "Hirzek",
            [questKeys.startedBy] = {{12736}},
            [questKeys.finishedBy] = {{12736,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Slay Hirzek at Blackthorn Ridge, Barrens, and bring his staff to Jen'neu Sancrea at Zoram'gar Outpost, Ashenvale."},
            [questKeys.objectives] = {nil,nil,{{210724}}},
        },
        [78611] = {
            [questKeys.name] = "A Waylaid Shipment",
            [questKeys.startedBy] = {{214101}},
            [questKeys.finishedBy] = {{213077,214070,214096,214098,214099,214101,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"The shipment's missing some items, but it will still be of some use. &nbsp;Thank you, &lt;name&gt;."},
            [questKeys.objectives] = nil,
        },
        [78612] = {
            [questKeys.name] = "A Full Shipment",
            [questKeys.startedBy] = {{214101}},
            [questKeys.finishedBy] = {{213077,214070,214096,214098,214099,214101,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Do you have something for me?"},
            [questKeys.objectives] = {nil,nil,{{211365}}},
        },
        [78676] = {
            [questKeys.name] = "The Eye of Bhossca",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Find The Eye of Bhossca inside of the Scarlet Monastery. Then, return it to C's dead drop near Pyrewood Village. You must complete the job alone."},
            [questKeys.objectives] = {nil,nil,{{210953}}},
        },
        [78680] = {
            [questKeys.name] = "Rumors Abound",
            [questKeys.startedBy] = {{6247}},
            [questKeys.finishedBy] = {{6247,}},
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Not much is known about the location of these shattered weapon fragments, save that they are both in the possession of once great mages held up in towers of importance. One is said to be located here to the north on Kalimdor, while the other is nestled near the heart of the Eastern Kingdoms.See if the rumors are true... Search for the two missing halves of this weapon and bring them to me."},
            [questKeys.objectives] = {nil,nil,{{210765},{210763}}},
        },
        [78681] = {
            [questKeys.name] = "The Conjuring",
            [questKeys.startedBy] = {{6247}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 28,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Collect 10 Blood of the Legion and perform the ritual to summon Des'Altek to trap its soul once again."},
            [questKeys.objectives] = {nil,nil,{{210966}}},
        },
        [78684] = {
            [questKeys.name] = "Mysterious Traveler",
            [questKeys.startedBy] = {{213444}},
            [questKeys.finishedBy] = {{6247,}},
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 28,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Meet with Doan Karhan and the Mysterious Traveler in the Barrens."},
            [questKeys.objectives] = nil,
        },
        [78699] = {
            [questKeys.name] = "The Eye of Bhossca",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 23,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Log."},
            [questKeys.objectives] = nil,
        },
        [78702] = {
            [questKeys.name] = "Raszel Ander",
            [questKeys.startedBy] = {{6247}},
            [questKeys.finishedBy] = {{6247,}},
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 28,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Raszel was a friend... One I thought I had lost long ago, from a different time... We were young apprentices back then... Much has changed.The result of the ritual might have been a setback, but I believe we can still reform the weapon.Raszel and I have much to discuss, together we will come up with a plan. I'll send word once we know how to move forward.In the meantime, take this. It seems like something you might be interested in."},
            [questKeys.objectives] = nil,
        },
        [78823] = {
            [questKeys.name] = "Terror of the Desert Skies",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{715,}},
            [questKeys.requiredLevel] = 26,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Bring the Primitive Drawing to Hemet Nesingwary in Stranglethorn Vale."},
            [questKeys.objectives] = nil,
        },
        [78830] = {
            [questKeys.name] = "Terror of the Desert Skies",
            [questKeys.startedBy] = {{715}},
            [questKeys.finishedBy] = {{715,}},
            [questKeys.requiredLevel] = 26,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Get a Crimson Trophy Quill from Gharrik in the Badlands. Then, return to Hemet Nesingwary in Stranglethorn Vale."},
            [questKeys.objectives] = {nil,nil,{{211293},{211272}}},
        },
        [78872] = {
            [questKeys.name] = "A Full Shipment",
            [questKeys.startedBy] = {{214101}},
            [questKeys.finishedBy] = {{213077,214070,214096,214098,214099,214101,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 12,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Do you have something for me?"},
            [questKeys.objectives] = {nil,nil,{{211367}}},
        },
        [78909] = {
            [questKeys.name] = "Shifting Scale Talisman",
            [questKeys.startedBy] = {{214208}},
            [questKeys.finishedBy] = {{214208,}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring N'ora Anyheart the following materials alongside the Handful of Shifting Scales to complete the talisman: A satchel of Strange Dust, five Greater Magic Essence, 2 Small Glimmering Shards and five gold pieces."},
            [questKeys.objectives] = {nil,nil,{{10940},{10939},{211419},{10978}}},
        },
        [78914] = {
            [questKeys.name] = "Soul Vessel",
            [questKeys.startedBy] = {{213445}},
            [questKeys.finishedBy] = {{215850,}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Now that we have a way to weaken the demon we need a vessel to bind them within. The Burning Blade have overrun ancient elven ruins in southern Desolace, using it as a staging ground to summon demons to Azeroth. Once you have found a Soul Vessel meet us in Desolace, there we will complete the ritual."},
            [questKeys.objectives] = {nil,nil,{{211427}}},
        },
        [78916] = {
            [questKeys.name] = "The Heart of the Void",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{4783,}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the Blackfathom Pearl to Dawnwatcher Selgorm in Darnassus."},
            [questKeys.objectives] = nil,
        },
        [78917] = {
            [questKeys.name] = "The Heart of the Void",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{9087,}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the Blackfathom Pearl to Bashana Runetotem in Thunder Bluff."},
            [questKeys.objectives] = nil,
        },
        [78920] = {
            [questKeys.name] = "Baron Aquanis",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{12736,}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the Strange Water Globe to Je'neu Sancrea at Zoram'gar Outpost, Ashenvale."},
            [questKeys.objectives] = nil,
        },
        [78921] = {
            [questKeys.name] = "Blackfathom Villainy",
            [questKeys.startedBy] = {{4787}},
            [questKeys.finishedBy] = {{4783,}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the head of Twilight Lord Kelris to Dawnwatcher Selgorm in Darnassus."},
            [questKeys.objectives] = {nil,nil,{{5881}}},
        },
        [78922] = {
            [questKeys.name] = "Blackfathom Villainy",
            [questKeys.startedBy] = {{4787}},
            [questKeys.finishedBy] = {{9087,}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the head of Twilight Lord Kelris to Bashana Runetotem in Thunder Bluff."},
            [questKeys.objectives] = {nil,nil,{{5881}}},
        },
        [78923] = {
            [questKeys.name] = "Knowledge in the Deeps",
            [questKeys.startedBy] = {{2786}},
            [questKeys.finishedBy] = {{2786,}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the Lorgalis Manuscript to Gerrig Bonegrip in the Forlorn Cavern in Ironforge."},
            [questKeys.objectives] = {nil,nil,{{5359}}},
        },
        [78925] = {
            [questKeys.name] = "Twilight Falls",
            [questKeys.startedBy] = {{4784}},
            [questKeys.finishedBy] = {{4784,}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring 10 Twilight Pendants to Argent Guard Manados in Darnassus."},
            [questKeys.objectives] = {nil,nil,{{5879}}},
        },
        [78926] = {
            [questKeys.name] = "Researching the Corruption",
            [questKeys.startedBy] = {{8997}},
            [questKeys.finishedBy] = {{8997,}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gershala Nightwhisper in Auberdine wants 8 Corrupt Brain stems."},
            [questKeys.objectives] = {nil,nil,{{5952}}},
        },
        [78927] = {
            [questKeys.name] = "Allegiance to the Old Gods",
            [questKeys.startedBy] = {{12736}},
            [questKeys.finishedBy] = {{12736,}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Kill Lorgus Jett in Blackfathom Deeps and then return to Je'neu Sancrea in Ashenvale."},
            [questKeys.objectives] = nil,
        },
        [78994] = {
            [questKeys.name] = "A Solid Foundation",
            [questKeys.startedBy] = {{213445}},
            [questKeys.finishedBy] = {{213445,}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"The Emerald Dragons protect several portals to the Emerald Dream throughout Azeroth. One of these locations surely has what we need.Once you've found a Bough of Shadows return with haste."},
            [questKeys.objectives] = {nil,nil,{{211426}}},
        },
        [79007] = {
            [questKeys.name] = "...and that note you found",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 14,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Charred remains of the note serve as your only guide."},
            [questKeys.objectives] = nil,
        },
        [79008] = {
            [questKeys.name] = "...and that note you found",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 14,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Charred remains of the note serve as your only guide."},
            [questKeys.objectives] = nil,
        },
        [79077] = {
            [questKeys.name] = "Sharing the Faith",
            [questKeys.startedBy] = {{1212}},
            [questKeys.finishedBy] = {{1212,}},
            [questKeys.requiredLevel] = 5,
            [questKeys.questLevel] = 5,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Meditate on the Light, then pray with the kneeling elf to share your meditations."},
            [questKeys.objectives] = nil,
        },
        [79078] = {
            [questKeys.name] = "Sharing the Faith",
            [questKeys.startedBy] = {{4092}},
            [questKeys.finishedBy] = {{4092,}},
            [questKeys.requiredLevel] = 5,
            [questKeys.questLevel] = 5,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Meditate on Elune, then pray with the kneeling human to share your meditations."},
            [questKeys.objectives] = nil,
        },
        [79079] = {
            [questKeys.name] = "Sharing the Faith",
            [questKeys.startedBy] = {{6018}},
            [questKeys.finishedBy] = {{6018,}},
            [questKeys.requiredLevel] = 5,
            [questKeys.questLevel] = 5,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Meditate on the Loa, then pray with the kneeling Forsaken to share your meditations."},
            [questKeys.objectives] = nil,
        },
        [79080] = {
            [questKeys.name] = "Sharing the Faith",
            [questKeys.startedBy] = {{4607}},
            [questKeys.finishedBy] = {{4607,}},
            [questKeys.requiredLevel] = 5,
            [questKeys.questLevel] = 5,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Meditate on undeath, then pray with the kneeling troll to share your meditations."},
            [questKeys.objectives] = nil,
        },
        [79090] = {
            [questKeys.name] = "Repelling Invaders",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{212970,217707,}},
            [questKeys.requiredLevel] = 18,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the Warsong Outrider Mark to Felore Moonray, Priestess of the Moon, at the Moonwell base in Ashenvale."},
            [questKeys.objectives] = nil,
        },
        [79091] = {
            [questKeys.name] = "Archmage Antonidas: The Unabridged Autobiography",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211033,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{203754}}},
        },
        [79092] = {
            [questKeys.name] = "Archmage Theocritus's Research Journal",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{203755}}},
        },
        [79093] = {
            [questKeys.name] = "Rumi of Gnomeregan: The Collected Works",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{208860}}},
        },
        [79094] = {
            [questKeys.name] = "The Lessons of Ta'zo",
            [questKeys.startedBy] = {{211022}},
            [questKeys.finishedBy] = {{211022,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{207972}}},
        },
        [79095] = {
            [questKeys.name] = "The Apothecary's Metaphysical Primer",
            [questKeys.startedBy] = {{211022}},
            [questKeys.finishedBy] = {{211022,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{208185}}},
        },
        [79096] = {
            [questKeys.name] = "Ataeric: On Arcane Curiosities",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{210177}}},
        },
        [79097] = {
            [questKeys.name] = "Baxtan: On Destructive Magics",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{208800}}},
        },
        [79098] = {
            [questKeys.name] = "Clear the Forest!",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{212969,217706,}},
            [questKeys.requiredLevel] = 18,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the Silverwing Sentinel Charm to Kazragore, Far Seer, at the Bonfire base in Ashenvale."},
            [questKeys.objectives] = nil,
        },
        [79099] = {
            [questKeys.name] = "Baron Aquanis",
            [questKeys.startedBy] = {{214876}},
            [questKeys.finishedBy] = {{214876,}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the Strange Water Globe to Davidus Voidstar in Auberdine, Darkshore."},
            [questKeys.objectives] = {nil,nil,{{211818}}},
        },
        [79100] = {
            [questKeys.name] = "A Waylaid Shipment",
            [questKeys.startedBy] = {{214101}},
            [questKeys.finishedBy] = {{213077,214070,214096,214098,214099,214101,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 15,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"The shipment's missing some items, but it will still be of some use. &nbsp;Thank you, &lt;name&gt;."},
            [questKeys.objectives] = nil,
        },
        [79101] = {
            [questKeys.name] = "A Full Shipment",
            [questKeys.startedBy] = {{214101}},
            [questKeys.finishedBy] = {{213077,214070,214096,214098,214099,214101,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 18,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Do you have something for me?"},
            [questKeys.objectives] = {nil,nil,{{211839}}},
        },
        [79102] = {
            [questKeys.name] = "A Full Shipment",
            [questKeys.startedBy] = {{214101}},
            [questKeys.finishedBy] = {{213077,214070,214096,214098,214099,214101,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 22,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Do you have something for me?"},
            [questKeys.objectives] = {nil,nil,{{211840}}},
        },
        [79103] = {
            [questKeys.name] = "A Full Shipment",
            [questKeys.startedBy] = {{214101}},
            [questKeys.finishedBy] = {{213077,214070,214096,214098,214099,214101,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Do you have something for me?"},
            [questKeys.objectives] = {nil,nil,{{211841}}},
        },
        [79192] = {
            [questKeys.name] = "Stepping Stones",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 14,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"You tear the note from the plank and read the scrawled writing."},
            [questKeys.objectives] = nil,
        },
        [79229] = {
            [questKeys.name] = "Highway Robbery",
            [questKeys.startedBy] = {{11438}},
            [questKeys.finishedBy] = {{11438,}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Find someone in Desolace who knows about the pillaged campsite."},
            [questKeys.objectives] = nil,
        },
        [79235] = {
            [questKeys.name] = "On the Lam",
            [questKeys.startedBy] = {{11438}},
            [questKeys.finishedBy] = {{215643,}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Find one of the Desolace marauders."},
            [questKeys.objectives] = nil,
        },
        [79236] = {
            [questKeys.name] = "Cherry for Your Thoughts?",
            [questKeys.startedBy] = {{215643}},
            [questKeys.finishedBy] = {{215643,}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring a Cherry Grog to Tokal, in Booty Bay, to hear the rest of her story."},
            [questKeys.objectives] = {nil,nil,{{4600}}},
        },
        [79242] = {
            [questKeys.name] = "No Honor Among Thieves",
            [questKeys.startedBy] = {{215643}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Find Illari Duskfeather, near Arathi Highlands, and get access to her cache of stolen loot."},
            [questKeys.objectives] = {nil,nil,{{212347}}},
        },
        [79298] = {
            [questKeys.name] = "Tempting Fate",
            [questKeys.startedBy] = {{215850}},
            [questKeys.finishedBy] = {{215849,}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Assist Raszel Ander and Doan Karhan with the summoning ritual and trap Des'Altek inside the staff."},
            [questKeys.objectives] = nil,
        },
        [79348] = {
            [questKeys.name] = "The Lost Ancient",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{216289,}},
            [questKeys.requiredLevel] = 26,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Find someone who can tell you more about the rotten ancient seed."},
            [questKeys.objectives] = nil,
        },
        [79358] = {
            [questKeys.name] = "Tattered Note",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{4722,}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Warn the denizens of Thousand Needles of what you have discovered."},
            [questKeys.objectives] = nil,
        },
        [79360] = {
            [questKeys.name] = "Elemental Aid",
            [questKeys.startedBy] = {{4722}},
            [questKeys.finishedBy] = {{6176,}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"While many inhabitants of Thousand Needles are our enemies, we can't stand by and watch them get washed away. The note was clear, they plan to raise an undead army in the aftermath, which potentially threatens us all.We are ill equipped to deal with this, but I've heard of a shaman on the Eastern Kingdoms who's proficient in the elemental imbuement of weapons, they might be capable of helping.Find this shaman and plead for their aid."},
            [questKeys.objectives] = nil,
        },
        [79361] = {
            [questKeys.name] = "Power of da Wind",
            [questKeys.startedBy] = {{6176}},
            [questKeys.finishedBy] = {{6176,}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Collect 5 Whirling Essence from the whirlwind elementals in Desolace and bring them to Bath'rah the Windwatcher in Alterac Mountains. Rewards ."},
            [questKeys.objectives] = {nil,nil,{{212724}}},
        },
        [79362] = {
            [questKeys.name] = "Power of da Earth",
            [questKeys.startedBy] = {{6176}},
            [questKeys.finishedBy] = {{6176,}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 38,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Collect 5 Rumbling Essence from the rock elementals in Badlands and bring them to Bath'rah the Windwatcher in Alterac Mountains."},
            [questKeys.objectives] = {nil,nil,{{212723}}},
        },
        [79363] = {
            [questKeys.name] = "Power of da Water",
            [questKeys.startedBy] = {{6176}},
            [questKeys.finishedBy] = {{6176,}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 36,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Collect 5 Rushing Essence from the withering elementals in Dustwallow Marsh and bring them to Bath'rah the Windwatcher in Alterac Mountains."},
            [questKeys.objectives] = {nil,nil,{{212726}}},
        },
        [79364] = {
            [questKeys.name] = "A Simple Container",
            [questKeys.startedBy] = {{6176}},
            [questKeys.finishedBy] = {{6176,}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"You didn't think I'd be making some crazy weapon for ya did you's? Nah, nah, nah me friend dis be a potion of protection.Fightin' fire with fire not always be the right approach mon.Bring a Crystal Vial to Bath'rah the Windwatcher in Alterac Mountains."},
            [questKeys.objectives] = {nil,nil,{{8925}}},
        },
        [79365] = {
            [questKeys.name] = "With Wind Beneath Your Wings",
            [questKeys.startedBy] = {{6176}},
            [questKeys.finishedBy] = {{4722,}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Return to Rau Cliffrunner in Thousand Needles at Freewind Post."},
            [questKeys.objectives] = {nil,nil,{{212982}}},
        },
        [79366] = {
            [questKeys.name] = "Calm Before the Storm",
            [questKeys.startedBy] = {{4722}},
            [questKeys.finishedBy] = {{4722,}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Venture into the eye of the storm and confront the quilboars."},
            [questKeys.objectives] = {nil,nil,{{212792}}},
        },
        [79377] = {
            [questKeys.name] = "The Lost Saplings",
            [questKeys.startedBy] = {{216289}},
            [questKeys.finishedBy] = {{216289,}},
            [questKeys.requiredLevel] = 26,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Find the four lost saplings in Eastern Kingdoms, and share the Water of Elune'ara with them. Afterwards, return to Orokai, in Moonglade."},
            [questKeys.objectives] = {nil,nil,{{213036}}},
        },
        [79442] = {
            [questKeys.name] = "Catching Up",
            [questKeys.startedBy] = {{4722}},
            [questKeys.finishedBy] = {{6176,}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Return to Bath'rah the Windwatcher in Alterac Mountains and see if he can put the Eye of the Tempest to use."},
            [questKeys.objectives] = nil,
        },
        [79482] = {
            [questKeys.name] = "Stolen Winter Veil Treats",
            [questKeys.startedBy] = {{216902}},
            [questKeys.finishedBy] = {{216915,}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Locate the Smokywood Pastures investigator that has gone missing in the snowy regions of the Alterac Mountains."},
            [questKeys.objectives] = nil,
        },
        [79483] = {
            [questKeys.name] = "Stolen Winter Veil Treats",
            [questKeys.startedBy] = {{216924}},
            [questKeys.finishedBy] = {{216915,}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Locate the Smokywood Pastures investigator that has gone missing in the snowy regions of the Alterac Mountains."},
            [questKeys.objectives] = nil,
        },
        [79484] = {
            [questKeys.name] = "You're a Mean One...",
            [questKeys.startedBy] = {{216915}},
            [questKeys.finishedBy] = {{216902,}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Locate and return the Stolen Treats to Wulmort Jinglepocket in Ironforge.  It was last thought to be in the possession of the Abominable Greench, found somewhere in the snowy regions of the Alterac Mountains."},
            [questKeys.objectives] = {nil,nil,{{17662}}},
        },
        [79485] = {
            [questKeys.name] = "You're a Mean One...",
            [questKeys.startedBy] = {{216915}},
            [questKeys.finishedBy] = {{216924,}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Locate and return the Stolen Treats to Kaymard Copperpinch in Orgrimmar.  It was last thought to be in the possession of the Abominable Greench, found somewhere in the snowy regions of the Alterac Mountains."},
            [questKeys.objectives] = {nil,nil,{{17662}}},
        },
        [79486] = {
            [questKeys.name] = "A Smokywood Pastures' Thank You!",
            [questKeys.startedBy] = {{216902}},
            [questKeys.finishedBy] = {{13444,}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Speak with Greatfather Winter in Ironforge."},
            [questKeys.objectives] = nil,
        },
        [79487] = {
            [questKeys.name] = "A Smokywood Pastures' Thank You!",
            [questKeys.startedBy] = {{216924}},
            [questKeys.finishedBy] = {{13445,}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Speak with Great-father Winter in Orgrimmar."},
            [questKeys.objectives] = nil,
        },
        [79492] = {
            [questKeys.name] = "Metzen the Reindeer",
            [questKeys.startedBy] = {{216902}},
            [questKeys.finishedBy] = {{216902,}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Find Metzen the Reindeer.  Use the notes provided to you for clues as to where he is being held.When you find Metzen, have the Pouch of Reindeer Dust in your possession so you can sprinkle some of the dust on him; this should free Metzen from his bonds of captivity.Return the Pouch of Reindeer Dust to Wulmort Jinglepocket in Ironforge once Metzen is freed."},
            [questKeys.objectives] = {nil,nil,{{21211},{21315}}},
        },
        [79495] = {
            [questKeys.name] = "Metzen the Reindeer",
            [questKeys.startedBy] = {{216924}},
            [questKeys.finishedBy] = {{216924,}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Find Metzen the Reindeer.  Use the notes provided to you for clues as to where he is being held.When you find Metzen, have the Pouch of Reindeer Dust in your possession so you can sprinkle some of the dust on him; this should free Metzen from his bonds of captivity.Return the Pouch of Reindeer Dust to Kaymard Copperpinch in Orgrimmar once Metzen is freed."},
            [questKeys.objectives] = {nil,nil,{{21211},{21315}}},
        },
        [79535] = {
            [questKeys.name] = "Basilisks: Should Petrification be Feared?",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{213165}}},
        },
        [79536] = {
            [questKeys.name] = "Greater Friend of the Library",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Thanks to your donations, the library is thriving.Please, take this."},
            [questKeys.objectives] = nil,
        },
        [79588] = {
            [questKeys.name] = "Small Furry Paws",
            [questKeys.startedBy] = {{14829}},
            [questKeys.finishedBy] = {{14829,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"The first lesson in drawing a crowd is: lure them with gadgets and trinkets! &nbsp;Can you help me?I need small furry paws to use for prizes. &nbsp;You can find those on the cats of the Barrens or Darkshore....Bring me some paws and I'll trade you a Darkmoon Faire ticket for them."},
            [questKeys.objectives] = {nil,nil,{{5134}}},
        },
        [79589] = {
            [questKeys.name] = "Torn Bear Pelts",
            [questKeys.startedBy] = {{14829}},
            [questKeys.finishedBy] = {{14829,}},
            [questKeys.requiredLevel] = 10,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Children love toys! &nbsp;And no matter what race, I've found that all children love furry, plushy toys made from torn bear pelts!You can get those pelts from the bears of Ashenvale or Hillsbrad. &nbsp;Bring me a heap of them and earn yourself a heap of Darkmoon Faire tickets!"},
            [questKeys.objectives] = {nil,nil,{{11407}}},
        },
        [79590] = {
            [questKeys.name] = "Heavy Grinding Stone",
            [questKeys.startedBy] = {{14832}},
            [questKeys.finishedBy] = {{14832,}},
            [questKeys.requiredLevel] = 10,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"To help with my workout, I like to fit a staff between heavy grinding stones, then lift the staff over my head. &nbsp;It isn't easy, but being the strongest woman in the world, like I am, can't be earned sitting down!Can you help me? &nbsp;I need more grinding stones - bring me some and I'll trade Darkmoon Faire tickets for them."},
            [questKeys.objectives] = {nil,nil,{{3486}}},
        },
        [79591] = {
            [questKeys.name] = "Whirring Bronze Gizmo",
            [questKeys.startedBy] = {{14841}},
            [questKeys.finishedBy] = {{14841,}},
            [questKeys.requiredLevel] = 10,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"My new booth will be a sight to see, yes sir! &nbsp;A sight to see, and... for a lucky few, to touch!I can already hear the whirring bronze gizmos singing their song of mechanical rapture as patrons step to my booth and test their skill!Ah... now I need the gizmos themselves to bring my dream closer to fruition. &nbsp;Please, &lt;name&gt;, bring me whirring bronze gizmos... and Darkmoon Faire tickets will be yours!"},
            [questKeys.objectives] = {nil,nil,{{4375}}},
        },
        [79592] = {
            [questKeys.name] = "Carnival Jerkins",
            [questKeys.startedBy] = {{14833}},
            [questKeys.finishedBy] = {{14833,}},
            [questKeys.requiredLevel] = 10,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Our Faire workers do more than sweep trash and hammer spikes! &nbsp;They also help guard the carnival as it travels, and to that end they are always needing good sturdy armor jerkins.If you make some tough leather armor and bring it to me, then I'll make sure it gets to the right people. &nbsp;I'll also get you some Darkmoon Faire tickets as trade."},
            [questKeys.objectives] = {nil,nil,{{2314}}},
        },
        [79593] = {
            [questKeys.name] = "Coarse Weightstone",
            [questKeys.startedBy] = {{14832}},
            [questKeys.finishedBy] = {{14832,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"It takes a lot of work to be the strongest woman alive! &nbsp;My weight set is getting too light and if I'm too stay fit then I'll need more weights!Do you think you could bring me some weight stones? &nbsp;If you do, then I'll give you a Darkmoon Faire ticket."},
            [questKeys.objectives] = {nil,nil,{{3240}}},
        },
        [79594] = {
            [questKeys.name] = "Copper Modulator",
            [questKeys.startedBy] = {{14841}},
            [questKeys.finishedBy] = {{14841,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Yebb is developing a new attraction for the Zoo Bizarre, one that will drive people crazy with wonder, and delight! &nbsp;But it will take a lot of work, and a lot of materials...That includes copper modulators. &nbsp;We need lots of modulators for the mechanical parts of the attraction. &nbsp;Bring me copper modulators and I'll trade for them with a Darkmoon Faire ticket."},
            [questKeys.objectives] = {nil,nil,{{4363}}},
        },
        [79595] = {
            [questKeys.name] = "Carnival Boots",
            [questKeys.startedBy] = {{14833}},
            [questKeys.finishedBy] = {{14833,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"We at the Darkmoon Faire do much walking. &nbsp;We walk from one faire site to another... in fact, you'll never see us sitting down on the job! &nbsp;So it is no surprise that we wear out quite a lot of boots! &nbsp;We need boots that are both durable and stylish, and embossed leather boots fit that bill rather well.You! &nbsp;You're a leatherworker; make me embossed leather boots and I'll give you a Darkmoon Faire ticket for the work."},
            [questKeys.objectives] = {nil,nil,{{2309}}},
        },
        [79624] = {
            [questKeys.name] = "Anyone Can Cook",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{217300,}},
            [questKeys.requiredLevel] = 26,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Find an ogre who can read the Illegible Recipe."},
            [questKeys.objectives] = nil,
        },
        [79626] = {
            [questKeys.name] = "The Salvagematic 9000!",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Insert a Grime-Encrusted Salvage into the Salvagematic 9000, and be sure to have thirty silver coins to start the machine."},
            [questKeys.objectives] = {nil,nil,{{213427}}},
        },
        [79677] = {
            [questKeys.name] = "A Quick Grocery Run",
            [questKeys.startedBy] = {{217300}},
            [questKeys.finishedBy] = {{217300,}},
            [questKeys.requiredLevel] = 26,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Gather the ingredients for Skonk's dish, then bring them to him in Arathi Highlands."},
            [questKeys.objectives] = {nil,nil,{{213526},{213527},{213528},{213529}}},
        },
        [79678] = {
            [questKeys.name] = "Taste Testing",
            [questKeys.startedBy] = {{217300}},
            [questKeys.finishedBy] = {{217300,}},
            [questKeys.requiredLevel] = 26,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Taste test the recipe with Skonk."},
            [questKeys.objectives] = nil,
        },
        [79704] = {
            [questKeys.name] = "The Salvagematic 9000!",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Insert a Grime-Encrusted Salvage into the Salvagematic 9000, and be sure to have three silver coins to start the machine."},
            [questKeys.objectives] = {nil,nil,{{213427}}},
        },
        [79705] = {
            [questKeys.name] = "Salvaging the Salvagematic",
            [questKeys.startedBy] = {{217689}},
            [questKeys.finishedBy] = {{217689,}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Ziri \"The Wrench\" 10 Mithril Bars, 5 Greater Mystic Essence, 3 GG12-082 Cartridge Fuses, and a Pristine G-7 C.O.R.E. Processor and she can get the Salvagematic 9000! working for you. Probably. Maybe."},
            [questKeys.objectives] = {nil,nil,{{3860},{216634},{11135},{213735}}},
        },
        [79731] = {
            [questKeys.name] = "The Troll Scroll",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{715,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Solve the riddle of the scroll. Once you've done that, Hemet Nesingwary might like to hear the tale."},
            [questKeys.objectives] = {nil,nil,nil,nil,nil,{{425314}}},
        },
        [79905] = {
            [questKeys.name] = "A Taste of Knowledge",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211033,}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"With the knowledge you've gained in your travels, I believe you're ready to learn to conjure Comprehension Charms on your own. This will help you uncover new texts for the library's collection.Safe travels, &lt;name&gt;."},
            [questKeys.objectives] = nil,
        },
        [79939] = {
            [questKeys.name] = "The Broken Hammer",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{5492,}},
            [questKeys.requiredLevel] = 25,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Search for clues about what happened at the Mannoroc Coven in Desolace, and find someone who may know more about the broken hammer."},
            [questKeys.objectives] = {nil,nil,{{216956}}},
        },
        [79940] = {
            [questKeys.name] = "A Lost Brother",
            [questKeys.startedBy] = {{5492}},
            [questKeys.finishedBy] = {{5492,}},
            [questKeys.requiredLevel] = 26,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Speak with Katherine the Pure and learn more about the broken hammer."},
            [questKeys.objectives] = nil,
        },
        [79945] = {
            [questKeys.name] = "Orders from the Grand Crusader",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{5492,}},
            [questKeys.requiredLevel] = 26,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the Orders from the Grand Crusader back to Katherine the Pure."},
            [questKeys.objectives] = nil,
        },
        [79946] = {
            [questKeys.name] = "A Brother In Need",
            [questKeys.startedBy] = {{5492}},
            [questKeys.finishedBy] = {{217996,}},
            [questKeys.requiredLevel] = 26,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Speak with Katherine to learn more about Aeonas, and then find him in the Scarlet Monastery."},
            [questKeys.objectives] = nil,
        },
        [79947] = {
            [questKeys.name] = "Geomancy: The Stone-Cold Truth",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{215683}}},
        },
        [79948] = {
            [questKeys.name] = "Defensive Magics 101",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{215815}}},
        },
        [79949] = {
            [questKeys.name] = "A Web of Lies: Debunking Myths and Legends",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{215816}}},
        },
        [79950] = {
            [questKeys.name] = "Demons and You",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{215817}}},
        },
        [79951] = {
            [questKeys.name] = "Mummies: A Guide to the Unsavory Undead",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{215820}}},
        },
        [79952] = {
            [questKeys.name] = "RwlRwlRwlRwl!",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{215822}}},
        },
        [79953] = {
            [questKeys.name] = "A Ludite's Guide to Caring for Your Demonic Pet",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{215824}}},
        },
        [79963] = {
            [questKeys.name] = "By The Light's Grace",
            [questKeys.startedBy] = {{217996}},
            [questKeys.finishedBy] = {{217996,}},
            [questKeys.requiredLevel] = 26,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Heal Aeonas."},
            [questKeys.objectives] = nil,
        },
        [79970] = {
            [questKeys.name] = "Aeonas the Vindicated",
            [questKeys.startedBy] = {{217996}},
            [questKeys.finishedBy] = {{218160,}},
            [questKeys.requiredLevel] = 26,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Meet Aeonas at the Cathedral of Light in Stormwind."},
            [questKeys.objectives] = nil,
        },
        [79974] = {
            [questKeys.name] = "Wet Job",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 14,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Dusting off a messenger bag emerging from the soil, you find a parchment nestled among the supplies."},
            [questKeys.objectives] = nil,
        },
        [79975] = {
            [questKeys.name] = "Eagle's Fist",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 14,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Water spray dampens the air, the view is incredible."},
            [questKeys.objectives] = nil,
        },
        [79976] = {
            [questKeys.name] = "This Must Be The Place",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 14,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Whoever was here, you just missed them."},
            [questKeys.objectives] = nil,
        },
        [79980] = {
            [questKeys.name] = "Scramble",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 14,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Find what awaits you."},
            [questKeys.objectives] = nil,
        },
        [79981] = {
            [questKeys.name] = "The Corroded Core",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{218237,}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Find someone who can repair the Corroded G-7 C.O.R.E Processor."},
            [questKeys.objectives] = nil,
        },
        [79982] = {
            [questKeys.name] = "Warranty Claim",
            [questKeys.startedBy] = {{218237}},
            [questKeys.finishedBy] = {{218237,}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Wirdal Wondergear a Charged Voidcore."},
            [questKeys.objectives] = {nil,nil,{{216636}}},
        },
        [79984] = {
            [questKeys.name] = "Quadrangulation",
            [questKeys.startedBy] = {{7853}},
            [questKeys.finishedBy] = {{7853,}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Find Wirdal Wondergear's Quadrangulation Beacons and attune with them. There are four of them and they are located somewhere in Kalimdor. Rewards ."},
            [questKeys.objectives] = nil,
        },
        [79985] = {
            [questKeys.name] = "A Fine Mess",
            [questKeys.startedBy] = {{7850}},
            [questKeys.finishedBy] = {{7853,}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Escort Kernobee to the Clockwerk Run exit and then report to Scooty in Booty Bay."},
            [questKeys.objectives] = nil,
        },
        [79986] = {
            [questKeys.name] = "Grime-Encrusted Ring",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Figure out a way to remove the grime from the Grime-Encrusted Ring."},
            [questKeys.objectives] = nil,
        },
        [79987] = {
            [questKeys.name] = "Return of the Ring",
            [questKeys.startedBy] = {{6826}},
            [questKeys.finishedBy] = {{6826,}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"You may either keep the ring, or you may find the person responsible for the imprint and engravings on the inside of the band."},
            [questKeys.objectives] = nil,
        },
        [79990] = {
            [questKeys.name] = "Stranglethorn Lumber",
            [questKeys.startedBy] = {{14984}},
            [questKeys.finishedBy] = {{14984,}},
            [questKeys.requiredLevel] = 26,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Sergeant Maclear a Shipment of Stranglethorn Lumber."},
            [questKeys.objectives] = {nil,nil,{{216491}}},
        },
        [79991] = {
            [questKeys.name] = "Stranglethorn Lumber",
            [questKeys.startedBy] = {{15022}},
            [questKeys.finishedBy] = {{15022,}},
            [questKeys.requiredLevel] = 26,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Deathstalker Mortis a Shipment of Stranglethorn Lumber."},
            [questKeys.objectives] = {nil,nil,{{216491}}},
        },
        [80001] = {
            [questKeys.name] = "Rekindle",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"An extinguished fire pit. The wood is even dry enough to catch a flame."},
            [questKeys.objectives] = {nil,nil,{{4470},{4471}}},
        },
        [80098] = {
            [questKeys.name] = "Curious Dalaran Relic",
            [questKeys.startedBy] = {{218920}},
            [questKeys.finishedBy] = {{218920,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Have you recovered one of the stolen relics?"},
            [questKeys.objectives] = {nil,nil,{{216945}}},
        },
        [80120] = {
            [questKeys.name] = "A Service to Dalaran",
            [questKeys.startedBy] = {{218920}},
            [questKeys.finishedBy] = {{218920,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"You have done a great service for Dalaran, and for Azeroth.Our laws prohibit me from sharing Dalaran's secrets with outsiders, but I think I can stretch the rules a bit to reward you for your efforts. Please, take this."},
            [questKeys.objectives] = nil,
        },
        [80131] = {
            [questKeys.name] = "Gnome Improvement",
            [questKeys.startedBy] = {{6826}},
            [questKeys.finishedBy] = {{6826,}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the Brilliant Gold Ring, a Silver Bar, a Moss Agate, and 30 silver coins to Talvash del Kissel in Ironforge."},
            [questKeys.objectives] = {nil,nil,{{2842},{1206}}},
        },
        [80132] = {
            [questKeys.name] = "Rig Wars",
            [questKeys.startedBy] = {{3412}},
            [questKeys.finishedBy] = {{3412,}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Retrieve the Rig Blueprints and Thermaplugg's Safe Combination from Gnomeregan and bring them to Nogg in Orgrimmar."},
            [questKeys.objectives] = {nil,nil,{{9153},{9299}}},
        },
        [80133] = {
            [questKeys.name] = "Chief Engineer Scooty",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{7853,}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Speak with Scooty in Booty Bay."},
            [questKeys.objectives] = nil,
        },
        [80134] = {
            [questKeys.name] = "Gnomer-gooooone!",
            [questKeys.startedBy] = {{7853}},
            [questKeys.finishedBy] = {{7853,}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Wait for Scooty to calibrate the Goblin Transponder."},
            [questKeys.objectives] = nil,
        },
        [80135] = {
            [questKeys.name] = "Klockmort's Essentials",
            [questKeys.startedBy] = {{6142}},
            [questKeys.finishedBy] = {{6169,}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Speak with Klockmort Spannerspan in Ironforge."},
            [questKeys.objectives] = nil,
        },
        [80136] = {
            [questKeys.name] = "Essential Artificials",
            [questKeys.startedBy] = {{6169}},
            [questKeys.finishedBy] = {{6169,}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring 12 Essential Artificials to Klockmort Spannerspan in Ironforge."},
            [questKeys.objectives] = {nil,nil,{{9278}}},
        },
        [80137] = {
            [questKeys.name] = "Save Techbot's Brain!",
            [questKeys.startedBy] = {{7944}},
            [questKeys.finishedBy] = {{7944,}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Techbot's Memory Core to Tinkmaster Overspark in Ironforge."},
            [questKeys.objectives] = {nil,nil,{{9277}}},
        },
        [80138] = {
            [questKeys.name] = "Tinkmaster Overspark",
            [questKeys.startedBy] = {{7917}},
            [questKeys.finishedBy] = {{7944,}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Speak with Tinkmaster Overspark in Ironforge."},
            [questKeys.objectives] = nil,
        },
        [80139] = {
            [questKeys.name] = "Gnogaine",
            [questKeys.startedBy] = {{1268}},
            [questKeys.finishedBy] = {{1268,}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Use the Empty Leaden Collection Phial on Irradiated Invaders or Irradiated Pillagers to collect radioactive fallout. Once it is full, take it back to Ozzie Togglevolt in Kharanos."},
            [questKeys.objectives] = {nil,nil,{{9284},{9283}}},
        },
        [80140] = {
            [questKeys.name] = "Return of the Ring",
            [questKeys.startedBy] = {{3412}},
            [questKeys.finishedBy] = {{3412,}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"You may either keep the ring, or you may find the person responsible for the imprint and engravings on the inside of the band."},
            [questKeys.objectives] = nil,
        },
        [80141] = {
            [questKeys.name] = "Nogg's Ring Redo",
            [questKeys.startedBy] = {{3412}},
            [questKeys.finishedBy] = {{3412,}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the Brilliant Gold Ring, a Silver Bar, a Moss Agate, and 30 silver coins to Nogg in Orgrimmar."},
            [questKeys.objectives] = {nil,nil,{{2842},{1206}}},
        },
        [80143] = {
            [questKeys.name] = "Data Rescue",
            [questKeys.startedBy] = {{7950}},
            [questKeys.finishedBy] = {{7950,}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring a Prismatic Punch Card to Master Mechanic Castpipe in Ironforge."},
            [questKeys.objectives] = {nil,nil,{{9316}}},
        },
        [80147] = {
            [questKeys.name] = "Curious Dalaran Relic",
            [questKeys.startedBy] = {{218920}},
            [questKeys.finishedBy] = {{218920,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Have you recovered one of the stolen relics?"},
            [questKeys.objectives] = {nil,nil,{{216946}}},
        },
        [80148] = {
            [questKeys.name] = "Curious Dalaran Relic",
            [questKeys.startedBy] = {{218920}},
            [questKeys.finishedBy] = {{218920,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Have you recovered one of the stolen relics?"},
            [questKeys.objectives] = {nil,nil,{{216947}}},
        },
        [80149] = {
            [questKeys.name] = "Curious Dalaran Relic",
            [questKeys.startedBy] = {{218920}},
            [questKeys.finishedBy] = {{218920,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Have you recovered one of the stolen relics?"},
            [questKeys.objectives] = {nil,nil,{{216948}}},
        },
        [80150] = {
            [questKeys.name] = "Curious Dalaran Relic",
            [questKeys.startedBy] = {{218920}},
            [questKeys.finishedBy] = {{218920,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Have you recovered one of the stolen relics?"},
            [questKeys.objectives] = {nil,nil,{{216949}}},
        },
        [80151] = {
            [questKeys.name] = "Curious Dalaran Relic",
            [questKeys.startedBy] = {{218920}},
            [questKeys.finishedBy] = {{218920,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Have you recovered one of the stolen relics?"},
            [questKeys.objectives] = {nil,nil,{{216950}}},
        },
        [80152] = {
            [questKeys.name] = "Curious Dalaran Relic",
            [questKeys.startedBy] = {{218920}},
            [questKeys.finishedBy] = {{218920,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Have you recovered one of the stolen relics?"},
            [questKeys.objectives] = {nil,nil,{{216951}}},
        },
        [80153] = {
            [questKeys.name] = "The Sparklematic 5200!",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Insert a Grime-Encrusted Item into the Sparklematic 5200, and be sure to have three silver coins to start the machine."},
            [questKeys.objectives] = {nil,nil,{{9308}}},
        },
        [80155] = {
            [questKeys.name] = "More Sparklematic Action",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"The Sparklematic 5200 is empty, awaiting a grime-encrusted object to clean and three silver coins to start!"},
            [questKeys.objectives] = {nil,nil,{{9308}}},
        },
        [80157] = {
            [questKeys.name] = "The Sparklematic 5200!",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"As quickly as it started, the Sparklematic 5200 comes to an abrupt halt. &nbsp;A simple \"ding\" is heard from the machine, and the mouth of the machine spirals upward. &nbsp;Inside the Sparklematic 5200 is a small box wrapped in a little bow. &nbsp;The machine would appear to wrap an object up after eliminating its grime-encrusted status. &nbsp;Even if the machine didn't work, at least the item is now wrapped in a pretty box.Well, there is one way to find out if it cleaned the item or not..."},
            [questKeys.objectives] = nil,
        },
        [80158] = {
            [questKeys.name] = "The Sparklematic 5200!",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Insert a Grime-Encrusted Item into the Sparklematic 5200, and be sure to have three silver coins to start the machine."},
            [questKeys.objectives] = {nil,nil,{{9308}}},
        },
        [80160] = {
            [questKeys.name] = "More Sparklematic Action",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"The Sparklematic 5200 is empty, awaiting a grime-encrusted object to clean and three silver coins to start!"},
            [questKeys.objectives] = {nil,nil,{{9308}}},
        },
        [80161] = {
            [questKeys.name] = "The Sparklematic 5200!",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"As quickly as it started, the Sparklematic 5200 comes to an abrupt halt. &nbsp;A simple \"ding\" is heard from the machine, and the mouth of the machine spirals upward. &nbsp;Inside the Sparklematic 5200 is a small box wrapped in a little bow. &nbsp;The machine would appear to wrap an object up after eliminating its grime-encrusted status. &nbsp;Even if the machine didn't work, at least the item is now wrapped in a pretty box.Well, there is one way to find out if it cleaned the item or not..."},
            [questKeys.objectives] = nil,
        },
        [80169] = {
            [questKeys.name] = "Cluster Launcher",
            [questKeys.startedBy] = {{15909}},
            [questKeys.finishedBy] = {{15909,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"The most splendid fireworks shows must include cluster rockets, and those cluster rockets must be fired from cluster launchers! &nbsp;Is it not then logical for you to learn the secrets of making cluster launchers? &nbsp;Bring me coins of ancestry and I will give this knowledge to you."},
            [questKeys.objectives] = {nil,nil,{{21100}}},
        },
        [80180] = {
            [questKeys.name] = "The Grand Betrayal",
            [questKeys.startedBy] = {{7937}},
            [questKeys.finishedBy] = {{7937,}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Venture to Gnomeregan and kill Mekgineer Thermaplugg. Return to High Tinker Mekkatorque when the task is complete."},
            [questKeys.objectives] = nil,
        },
        [80181] = {
            [questKeys.name] = "Gyrodrillmatic Excavationators",
            [questKeys.startedBy] = {{6579}},
            [questKeys.finishedBy] = {{6579,}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring twenty-four Robo-mechanical Guts to Shoni in Stormwind."},
            [questKeys.objectives] = {nil,nil,{{9309}}},
        },
        [80182] = {
            [questKeys.name] = "The Only Cure is More Green Glow",
            [questKeys.startedBy] = {{1268}},
            [questKeys.finishedBy] = {{1268,}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Travel to Gnomeregan and bring back High Potency Radioactive Fallout. Be warned, the fallout is unstable and will collapse rather quickly.Ozzie will also require your Heavy Leaden Collection Phial when the task is complete."},
            [questKeys.objectives] = {nil,nil,{{9365}}},
        },
        [80241] = {
            [questKeys.name] = "The Origins of Smithing",
            [questKeys.startedBy] = {{7798}},
            [questKeys.finishedBy] = {{7798,}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring six Golden Scale Bracers to Hank the Hammer in Stormwind."},
            [questKeys.objectives] = {nil,nil,{{6040}}},
        },
        [80307] = {
            [questKeys.name] = "A Full Shipment",
            [questKeys.startedBy] = {{214101}},
            [questKeys.finishedBy] = {{213077,214070,214096,214098,214099,214101,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 28,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Do you have something for me?"},
            [questKeys.objectives] = {nil,nil,{{217337}}},
        },
        [80308] = {
            [questKeys.name] = "A Full Shipment",
            [questKeys.startedBy] = {{214101}},
            [questKeys.finishedBy] = {{213077,214070,214096,214098,214099,214101,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Do you have something for me?"},
            [questKeys.objectives] = {nil,nil,{{217338}}},
        },
        [80309] = {
            [questKeys.name] = "A Full Shipment",
            [questKeys.startedBy] = {{214101}},
            [questKeys.finishedBy] = {{213077,214070,214096,214098,214099,214101,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Do you have something for me?"},
            [questKeys.objectives] = {nil,nil,{{217339}}},
        },
        [80324] = {
            [questKeys.name] = "The Mad King",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{7937,}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Thermaplugg's Engineering Notes to High Tinker Mekkatorque at Tinker Town in Ironforge."},
            [questKeys.objectives] = nil,
        },
        [80325] = {
            [questKeys.name] = "The Mad King",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{3412,}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Thermaplugg's Engineering Notes to Nogg at the Valley of Honor in Orgrimmar."},
            [questKeys.objectives] = nil,
        },
        [80411] = {
            [questKeys.name] = "The Talisman of Kazdor",
            [questKeys.startedBy] = {{6707}},
            [questKeys.finishedBy] = {{6707,}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Find The Talisman of Kazdor inside of Zul'Farrak. Then, bring it to Fahrad at Ravenholdt Manor. You must complete the job alone."},
            [questKeys.objectives] = {nil,nil,{{217609}}},
        },
        [80421] = {
            [questKeys.name] = "Green Iron Bracers",
            [questKeys.startedBy] = {{14832}},
            [questKeys.finishedBy] = {{14832,}},
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"I'm working on a new costume, for when I have my own booth as the strongest woman alive! &nbsp;Right now I'm looking for some bracers I can wear. &nbsp;They can't cover much because people want to see my muscles, but I still want to flash a little color, you know?How about green iron bracers, &lt;name&gt;? &nbsp;Can you make me green iron bracers? &nbsp;If you can, then I have a whole bunch of Darkmoon Faire tickets for you."},
            [questKeys.objectives] = {nil,nil,{{3835}}},
        },
        [80422] = {
            [questKeys.name] = "Green Fireworks",
            [questKeys.startedBy] = {{14841}},
            [questKeys.finishedBy] = {{14841,}},
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"When I finally get this booth up and running, I'll want to advertise! &nbsp;And what better way is there to advertise then with fireworks?Well, some might think that the smell of a cauldron, churning with the boiling heads of your foes is better for drawing crowds, but... we're in mixed company. &nbsp;So fireworks it will have to be!Bring me green fireworks, &lt;name&gt;, and I have a big fistful of Darkmoon Faire tickets for you."},
            [questKeys.objectives] = {nil,nil,{{9313}}},
        },
        [80423] = {
            [questKeys.name] = "The World's Largest Gnome!",
            [questKeys.startedBy] = {{14833}},
            [questKeys.finishedBy] = {{14833,}},
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Yebb Nebblegear is looking to add more talent to his show, and he's searching far and wide for the world's largest gnome. &nbsp;Do you know any gnomes of considerable size?Well before he finds the gnome, he wants to have its costume ready. &nbsp;I think a barbaric harness would be a good foundation for the costume; can you make some harnesses and bring them to me? &nbsp;Do that, and I'll have a stack of Darkmoon Faire tickets for you..."},
            [questKeys.objectives] = {nil,nil,{{5739}}},
        },
        [80453] = {
            [questKeys.name] = "Best Laid Plans",
            [questKeys.startedBy] = {{6707}},
            [questKeys.finishedBy] = {{6777,}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Bring the Talisman of Kazdor to Zan Shivsprocket in the basement of Ravenholdt Manor."},
            [questKeys.objectives] = nil,
        },
        [80454] = {
            [questKeys.name] = "One Last Drop",
            [questKeys.startedBy] = {{6777}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Take the Modified Talisman to Caius' dead drop near Pyrewood Village."},
            [questKeys.objectives] = nil,
        },
        [80455] = {
            [questKeys.name] = "Biding Our Time",
            [questKeys.startedBy] = {{6707}},
            [questKeys.finishedBy] = {{6707,}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Report back to Fahrad at Ravenholdt Manor."},
            [questKeys.objectives] = nil,
        },
        [80526] = {
            [questKeys.name] = "Fool Me Twice",
            [questKeys.startedBy] = {{6707}},
            [questKeys.finishedBy] = {{6707,}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Speak to Fahrad when you're ready to hear his plan."},
            [questKeys.objectives] = nil,
        },
        [81570] = {
            [questKeys.name] = "Jarl Needs a Blade",
            [questKeys.startedBy] = {{4792}},
            [questKeys.finishedBy] = {{4792,}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring a Moonsteel Broadsword to Jarl in Dustwallow Marsh."},
            [questKeys.objectives] = {nil,nil,{{217281}}},
        },
        [81682] = {
            [questKeys.name] = "The Old Champ",
            [questKeys.startedBy] = {{220984}},
            [questKeys.finishedBy] = {{221400,}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Find Kajind somewhere in Azshara."},
            [questKeys.objectives] = nil,
        },
        [81697] = {
            [questKeys.name] = "Defanged",
            [questKeys.startedBy] = {{221400}},
            [questKeys.finishedBy] = {{221400,}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Retrieve Kajind's blade from the blue drake roaming south-east of Forlorn Ridge in Azshara."},
            [questKeys.objectives] = {nil,nil,{{219935}}},
        },
        [81716] = {
            [questKeys.name] = "Recover Incursion Field Report: Duskwood",
            [questKeys.startedBy] = {{221471}},
            [questKeys.finishedBy] = {{221471,}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Kill demons and return the field report to Field Captain Palandar."},
            [questKeys.objectives] = {nil,nil,{{219759}}},
        },
        [81727] = {
            [questKeys.name] = "Recover Incursion Field Report: Ashenvale",
            [questKeys.startedBy] = {{221477}},
            [questKeys.finishedBy] = {{221477,}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Kill demons and return the field report to Field Captain Hannalah."},
            [questKeys.objectives] = {nil,nil,{{219770}}},
        },
        [81728] = {
            [questKeys.name] = "Recover Incursion Field Report: Hinterlands",
            [questKeys.startedBy] = {{221479}},
            [questKeys.finishedBy] = {{221479,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Kill demons and return the field report to Field Captain Korlian."},
            [questKeys.objectives] = {nil,nil,{{219772}}},
        },
        [81729] = {
            [questKeys.name] = "Recover Incursion Field Report: Feralas",
            [questKeys.startedBy] = {{221480}},
            [questKeys.finishedBy] = {{221480,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Kill demons and return the field report to Field Captain Arunnel."},
            [questKeys.objectives] = {nil,nil,{{219771}}},
        },
        [81730] = {
            [questKeys.name] = "Duskwood Mission I: Defeat Worgen",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221471,}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat 15 Nightmare Runners and 15 Nightmare Weavers in the Duskwood Nightmare Incursion in the Rotting Orchard and return to Field Captain Palandar."},
            [questKeys.objectives] = nil,
        },
        [81731] = {
            [questKeys.name] = "Duskwood Mission II: Defeat Ogres",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221471,}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat 5 Deranged Ogres and 5 Demented Fire Weavers in the Duskwood Nightmare Incursion at the Vul'gol Ogre Mound and return to Field Captain Palandar."},
            [questKeys.objectives] = nil,
        },
        [81732] = {
            [questKeys.name] = "Duskwood Mission III: Defeat Dragonkin",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221471,}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat 5 Wyrmkin Terrorwalkers and 15 Nightterror Whelps in the Duskwood Nightmare Incursion at the Yorgen Farmstead and return to Field Captain Palandar."},
            [questKeys.objectives] = nil,
        },
        [81733] = {
            [questKeys.name] = "Duskwood Mission IV: Ogre Intelligence",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221471,}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather intelligence from Dreamwarden Thalinar in the Duskwood Nightmare Incursion deep inside the Vul'gol Ogre Mound and return to Field Captain Palandar."},
            [questKeys.objectives] = {nil,nil,{{219776}}},
        },
        [81734] = {
            [questKeys.name] = "Duskwood Mission V: Worgen Intelligence",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221471,}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather intelligence from Dreamwarden Dorilar in the Duskwood Nightmare Incursion in the barn at the Rotting Orchard and return to Field Captain Palandar."},
            [questKeys.objectives] = {nil,nil,{{219778}}},
        },
        [81735] = {
            [questKeys.name] = "Duskwood Mission VI: Dragon Intelligence",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221471,}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather intelligence from Dreamwarden Amalia in the Duskwood Nightmare Incursion in the farmhouse at the Yorgen Farmstead and return to Field Captain Palandar."},
            [questKeys.objectives] = {nil,nil,{{219803}}},
        },
        [81736] = {
            [questKeys.name] = "Duskwood Mission VII: Recover Shadowscythe",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221471,}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Recover the Shadowscythe in the Duskwood Nightmare Incursion upstairs in the farmhouse at the Rotting Orchard and return to Field Captain Palandar."},
            [questKeys.objectives] = {nil,nil,{{219404}}},
        },
        [81737] = {
            [questKeys.name] = "Duskwood Mission VIII: Recover Ogre Magi text",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221471,}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Recover an Ogre Magi Text in the Duskwood Nightmare Incursion within the Vul'gol Ogre Mound and return to Field Captain Palandar."},
            [questKeys.objectives] = {nil,nil,{{219405}}},
        },
        [81738] = {
            [questKeys.name] = "Duskwood Mission IX: Recover Dragon Egg",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221471,}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Recover an Unhatched Green Dragon Egg in the Duskwood Nightmare Incursion from the Yorgen Farmstead near the large stump in the fields and return to Field Captain Palandar."},
            [questKeys.objectives] = {nil,nil,{{219406}}},
        },
        [81739] = {
            [questKeys.name] = "Duskwood Mission X: Nightmare Moss",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221471,}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather 10 Nightmare Moss in the Duskwood Nightmare Incursions and return to Field Captain Palandar."},
            [questKeys.objectives] = {nil,nil,{{219399}}},
        },
        [81740] = {
            [questKeys.name] = "Duskwood Mission XI: Cold Iron Ore",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221471,}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather 10 Cold Iron Ore in the Duskwood Nightmare Incursions and return to Field Captain Palandar."},
            [questKeys.objectives] = {nil,nil,{{219401}}},
        },
        [81741] = {
            [questKeys.name] = "Duskwood Mission XII: Dream-Touched Dragonscale",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221471,}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather 10 Dream-Touched Dragonscales in the Duskwood Nightmare Incursions and return to Field Captain Palandar."},
            [questKeys.objectives] = {nil,nil,{{219402}}},
        },
        [81742] = {
            [questKeys.name] = "Duskwood Mission XIII: Defeat Ylanthrius",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221471,}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat Ylanthrius in the Duskwood Nightmare Incursion at the Yorgen Farmstead field and return to Field Captain Palandar."},
            [questKeys.objectives] = nil,
        },
        [81743] = {
            [questKeys.name] = "Duskwood Mission XIV: Defeat Vvarc'zul",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221471,}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat Vvarc'zul in the Duskwood Nightmare Incursion deep in the Vul'gol Ogre Mound and return to Field Captain Palandar."},
            [questKeys.objectives] = nil,
        },
        [81744] = {
            [questKeys.name] = "Duskwood Mission XV: Defeat Amokarok",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221471,}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat Amokarok in the Duskwood Nightmare Incursion at a campsite near the barn in the Rotting Orchard and return to Field Captain Palandar."},
            [questKeys.objectives] = nil,
        },
        [81745] = {
            [questKeys.name] = "Duskwood Mission XVI: Rescue Kroll Mountainshade",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221471,}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Rescue Kroll Mountainshade from the Duskwood Nightmare Incursion in the guest house at the Rotting Orchard and return to Field Captain Palandar."},
            [questKeys.objectives] = nil,
        },
        [81746] = {
            [questKeys.name] = "Duskwood Mission XVII: Rescue Alara Grovemender",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221471,}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Rescue Alara Grovemender in the Duskwood Nightmare Incursion in the stable at the Yorgen Farmstead and return to Field Captain Palandar. A quest."},
            [questKeys.objectives] = nil,
        },
        [81747] = {
            [questKeys.name] = "Duskwood Mission XVIII: Rescue Elenora Marshwalker",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221471,}},
            [questKeys.requiredLevel] = 23,
            [questKeys.questLevel] = 27,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Rescue Elenora Marshwalker in the Duskwood Nightmare Incursion in the ruins of a farmhouse near the Vul'gol Ogre Mound and return to Field Captain Palandar."},
            [questKeys.objectives] = nil,
        },
        [81762] = {
            [questKeys.name] = "Some Good News",
            [questKeys.startedBy] = {{218160}},
            [questKeys.finishedBy] = {{5492,}},
            [questKeys.requiredLevel] = 44,
            [questKeys.questLevel] = 46,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Speak with Katherine the Pure at the Cathedral of Light in Stormwind."},
            [questKeys.objectives] = nil,
        },
        [81764] = {
            [questKeys.name] = "The Mysterious Merchant",
            [questKeys.startedBy] = {{5492}},
            [questKeys.finishedBy] = {{221575,}},
            [questKeys.requiredLevel] = 44,
            [questKeys.questLevel] = 46,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Travel to Theramore and find the mysterious merchant."},
            [questKeys.objectives] = nil,
        },
        [81765] = {
            [questKeys.name] = "Elrick, Paladin of the Silver Hand",
            [questKeys.startedBy] = {{221575}},
            [questKeys.finishedBy] = {{6272,}},
            [questKeys.requiredLevel] = 44,
            [questKeys.questLevel] = 46,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Speak with Elrick to learn more."},
            [questKeys.objectives] = nil,
        },
        [81766] = {
            [questKeys.name] = "The Bloody Missive",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{5492,}},
            [questKeys.requiredLevel] = 44,
            [questKeys.questLevel] = 46,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Bring the missive to Katherine the Pure at the Cathedral of Light in Stormwind."},
            [questKeys.objectives] = nil,
        },
        [81768] = {
            [questKeys.name] = "Ashenvale Mission I: Defeat Satyrs",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221477,}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat 15 Dreamfire Betrayers and 15 Dreamfire Hellcallers in the Ashenvale Nightmare Incursion in Satyrnaar and return to Field Captain Hannalah."},
            [questKeys.objectives] = nil,
        },
        [81769] = {
            [questKeys.name] = "Ashenvale Mission II: Defeat Treants",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221477,}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat 10 Vengeful Ancients in the Ashenvale Nightmare Incursion at the Warsong Lumber Camp and return to Field Captain Hannalah."},
            [questKeys.objectives] = nil,
        },
        [81770] = {
            [questKeys.name] = "Ashenvale Mission III: Defeat Dragonkin",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221477,}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat 5 Wyrmkin Nightstalkers and 15 Terror Whelps in the Ashenvale Nightmare Incursion in Forest Song and return to Field Captain Hannalah."},
            [questKeys.objectives] = nil,
        },
        [81771] = {
            [questKeys.name] = "Ashenvale Mission IV: Dragon Intelligence",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221477,}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather intelligence from Dreamwarden Ellodar in the Ashenvale Nightmare Incursion in Forest Song on the bridge to the ancient tower and return to Field Captain Hannalah."},
            [questKeys.objectives] = {nil,nil,{{219924}}},
        },
        [81772] = {
            [questKeys.name] = "Ashenvale Mission V: Satyr Intelligence",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221477,}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather intelligence from Dreamwarden Mandoran in the Ashenvale Nightmare Incursion at the ritual circle in Satyrnaar and return to Field Captain Hannalah."},
            [questKeys.objectives] = {nil,nil,{{219925}}},
        },
        [81773] = {
            [questKeys.name] = "Ashenvale Mission VI: Treant Intelligence",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221477,}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather intelligence from Dreamwarden Lanaria in the Ashenvale Nightmare Incursion inside Kargathia Keep at the Warsong Lumber Camp and return to Field Captain Hannalah."},
            [questKeys.objectives] = {nil,nil,{{219926}}},
        },
        [81774] = {
            [questKeys.name] = "Ashenvale Mission VII: Recover Dreamengine",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221477,}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Recover the Dreamengine in the Ashenvale Nightmare Incursion from the forge at Warsong Lumber Camp and return to Field Captain Hannalah. A quest."},
            [questKeys.objectives] = {nil,nil,{{219448}}},
        },
        [81775] = {
            [questKeys.name] = "Ashenvale Mission VIII: Recover Azsharan Prophecy",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221477,}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Recover the Azsharan Prophecy in the Ashenvale Nightmare Incursion from the small tent in Satyrnaar and return to Field Captain Hannalah. A quest."},
            [questKeys.objectives] = {nil,nil,{{219449}}},
        },
        [81776] = {
            [questKeys.name] = "Ashenvale Mission IX: Recover Dream-Touched Dragonegg",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221477,}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Recover a Dream-Touched Dragonegg in the Ashenvale Nightmare Incursion from the central ruin in Forest Song and return to Field Captain Hannalah."},
            [questKeys.objectives] = {nil,nil,{{219447}}},
        },
        [81777] = {
            [questKeys.name] = "Ashenvale Mission X: Dreamroot",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221477,}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather 10 Dreamroot in the Ashenvale Nightmare Incursions and return to Field Captain Hannalah."},
            [questKeys.objectives] = {nil,nil,{{219444}}},
        },
        [81778] = {
            [questKeys.name] = "Ashenvale Mission XI: Fool's Gold Dust",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221477,}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather 10 Fool's Gold Dust in the Ashenvale Nightmare Incursions and return to Field Captain Hannalah."},
            [questKeys.objectives] = {nil,nil,{{219445}}},
        },
        [81779] = {
            [questKeys.name] = "Ashenvale Mission XII: Dream-Infused Dragonscale",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221477,}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather 10 Dream-Infused Dragonscale in the Ashenvale Nightmare Incursions and return to Field Captain Hannalah."},
            [questKeys.objectives] = {nil,nil,{{219446}}},
        },
        [81780] = {
            [questKeys.name] = "Ashenvale Mission XIII: Defeat Larsera",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221477,}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat Larsera in the Ashenvale Nightmare Incursion outside the central ruin in Forest Song and return to Field Captain Hannalah."},
            [questKeys.objectives] = nil,
        },
        [81781] = {
            [questKeys.name] = "Ashenvale Mission XIV: Defeat Zalius",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221477,}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat Zalius in the Ashenvale Nightmare Incursion at the base of the ziggurat in Satyrnaar and return to Field Captain Hannalah."},
            [questKeys.objectives] = nil,
        },
        [81782] = {
            [questKeys.name] = "Ashenvale Mission XV: Defeat Shredder 9000",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221477,}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat Shredder 9000 in the Ashenvale Nightmare Incursion near the lumber cranes in Warsong Lumber Camp and return to Field Captain Hannalah."},
            [questKeys.objectives] = nil,
        },
        [81783] = {
            [questKeys.name] = "Ashenvale Mission XVI: Rescue Alyssian Windcaller",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221477,}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Rescue Alyssian Windcaller from the Ashenvale Nightmare Incursion at the base of the watch tower in the Warsong Lumber Camp and return to Field Captain Hannalah."},
            [questKeys.objectives] = nil,
        },
        [81784] = {
            [questKeys.name] = "Ashenvale Mission XVII: Rescue Doran Dreambough",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221477,}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Rescue Doran Dreambough from the Ashenvale Nightmare Incursion at the moonlit gazebo in Forest Song and return to Field Captain Hannalah. A quest."},
            [questKeys.objectives] = nil,
        },
        [81785] = {
            [questKeys.name] = "Ashenvale Mission XVIII: Rescue Maseara Autumnmoon",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221477,}},
            [questKeys.requiredLevel] = 37,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Rescue Maseara Autumnmoon from the Ashenvale Nightmare Incursion at the southeast tent cluster in Satyrnaar and return to Field Captain Hannalah."},
            [questKeys.objectives] = nil,
        },
        [81786] = {
            [questKeys.name] = "Hinterlands Mission I: Defeat Moonkin",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221479,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat 30 Fallen Moonkin in the Hinterlands Nightmare Incursion at Skulk Rock and return to Field Captain Korlian."},
            [questKeys.objectives] = nil,
        },
        [81787] = {
            [questKeys.name] = "Hinterlands Mission II: Defeat Giant Turtles",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221479,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat 30 Dreamwater Visejaw in the Hinterlands Nightmare Incursion at Shaol'watha and return to Field Captain Korlian."},
            [questKeys.objectives] = nil,
        },
        [81788] = {
            [questKeys.name] = "Hinterlands Mission III: Defeat Dragonkin",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221479,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat 15 Wrath Whelps and 5 Wyrmkin Starhunters in the Hinterlands Nightmare Incursion at Agol'watha and return to Field Captain Korlian. A quest."},
            [questKeys.objectives] = nil,
        },
        [81789] = {
            [questKeys.name] = "Hinterlands Mission IV: Dragon Intelligence",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221479,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather intelligence from Dreamwarden Laninar in the Hinterlands Nightmare Incursion at the archway in Agol'watha and return to Field Captain Korlian."},
            [questKeys.objectives] = {nil,nil,{{219928}}},
        },
        [81790] = {
            [questKeys.name] = "Materials of Significance",
            [questKeys.startedBy] = {{221636}},
            [questKeys.finishedBy] = {{221636,}},
            [questKeys.requiredLevel] = 44,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Locate the materials listed in Gregory's Note and return them to Gregory at the source of Bloodvenom Falls in Felwood."},
            [questKeys.objectives] = {nil,nil,{{220166},{220167},{220168},{220169},{220170}}},
        },
        [81801] = {
            [questKeys.name] = "Return to the Arena",
            [questKeys.startedBy] = {{221400}},
            [questKeys.finishedBy] = {{220984,}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Return to Fizbuz Mithril in Gadgetzan, Tanaris."},
            [questKeys.objectives] = nil,
        },
        [81817] = {
            [questKeys.name] = "Hinterlands Mission V: Turtle Intelligence",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221479,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather intelligence from Dreamwarden Sanathel in the Hinterlands Nightmare Incursion behind the drum in Shaol'watha and return to Field Captain Korlian."},
            [questKeys.objectives] = {nil,nil,{{219937}}},
        },
        [81820] = {
            [questKeys.name] = "Hinterlands Mission VI: Moonkin Intelligence",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221479,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather intelligence from Dreamwarden Valori in the Hinterlands Nightmare Incursion at the underground lake in Skulk Rock and return to Field Captain Korlian."},
            [questKeys.objectives] = {nil,nil,{{219938}}},
        },
        [81826] = {
            [questKeys.name] = "Hinterlands Mission VII: Recover Star-Touched Dragonegg",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221479,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Recover a Star-Touched Dragonegg in the Hinterlands Nightmare Incursion from the central hut at Agol'wath and return to Field Captain Korlian."},
            [questKeys.objectives] = {nil,nil,{{219488}}},
        },
        [81830] = {
            [questKeys.name] = "Hinterlands Mission VIII: Recover Elunar Relic",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221479,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Recover an Elunar Relic in the Hinterlands Nightmare Incursion from the high ledge inside Skulk Rock and return to Field Captain Korlian. A quest."},
            [questKeys.objectives] = {nil,nil,{{219490}}},
        },
        [81832] = {
            [questKeys.name] = "Hinterlands Mission IX: Recover Dreampearl",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221479,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Recover a Dreampearl in the Hinterlands Nightmare Incursion from a snake fountain at Shaol'watha and return to Field Captain Korlian. A quest."},
            [questKeys.objectives] = {nil,nil,{{219491}}},
        },
        [81833] = {
            [questKeys.name] = "Hinterlands Mission X: Star Lotus",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221479,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather 10 Star Lotus in the Hinterlands Nightmare Incursions and return to Field Captain Korlian."},
            [questKeys.objectives] = {nil,nil,{{219454}}},
        },
        [81834] = {
            [questKeys.name] = "Hinterlands Mission XI: Starsilver Ore",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221479,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather 10 Starsilver Ore in the Hinterlands Nightmare Incursions and return to Field Captain Korlian."},
            [questKeys.objectives] = {nil,nil,{{219486}}},
        },
        [81835] = {
            [questKeys.name] = "Hinterlands Mission XII: Starshells",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221479,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather 10 Sharshells in the Hinterlands Nightmare Incursions and return to Field Captain Korlian."},
            [questKeys.objectives] = {nil,nil,{{219487}}},
        },
        [81837] = {
            [questKeys.name] = "Hinterlands Mission XIII: Defeat Florius",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221479,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat Florius in the Hinterlands Nightmare Incursion at the main courtyard in Agol'watha and return to Field Captain Korlian."},
            [questKeys.objectives] = nil,
        },
        [81838] = {
            [questKeys.name] = "Hinterlands Mission XIV: Defeat Doomkin",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221479,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat the Doomkin in the Hinterlands Nightmare Incursion on the deep ledge inside Skulk Rock and return to Field Captain Korlian. A quest. Always up to date."},
            [questKeys.objectives] = nil,
        },
        [81839] = {
            [questKeys.name] = "Hinterlands Mission XV: Defeat Ghamoo-Raja",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221479,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat Ghamoo-Raja in the Hinterlands Nightmare Incursion in the courtyard at Shaol'watha and return to Field Captain Korlian."},
            [questKeys.objectives] = nil,
        },
        [81850] = {
            [questKeys.name] = "Hinterlands Mission XVI: Rescue Elianar Shadowdrinker",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221479,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Rescue Elianar Shadowdrinker from the Hinterlands Nightmare Incursion at the troll fortification near Agol'watha and return to Field Captain Korlian."},
            [questKeys.objectives] = nil,
        },
        [81851] = {
            [questKeys.name] = "Hinterlands Mission XVII: Rescue Serlina Starbright",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221479,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Rescue Serlina Starbright from the Hinterlands Nightmare Incursion at the troll fortification nearest Shol'watha and return to Field Captain Korlian."},
            [questKeys.objectives] = nil,
        },
        [81852] = {
            [questKeys.name] = "Hinterlands Mission XVIII: Rescue Veanna Cloudsleeper",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221479,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Rescue Veanna Cloudsleeper from the Hinterlands Nightmare Incursion in the hammock above Skulk Rock and return to Field Captain Korlian. A quest."},
            [questKeys.objectives] = nil,
        },
        [81855] = {
            [questKeys.name] = "Feralas Mission I: Defeat Children of Cenarius",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221480,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat 15 Lost Daughters and 15 Vengeful Sons in the Feralas Nightmare Incursion at the Twin Colossals and return to Field Captain Arunnel. A quest."},
            [questKeys.objectives] = nil,
        },
        [81856] = {
            [questKeys.name] = "Feralas Mission II: Defeat Harpies",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221480,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat 15 Dreamspring Roguefeathers and 15 Dreamspring Stormcallers in the Feralas Nightmare Incursion at the Ruins of Ravenwind and return to Field Captain Arunnel."},
            [questKeys.objectives] = nil,
        },
        [81857] = {
            [questKeys.name] = "Feralas Mission III: Defeat Dragonkin",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221480,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat 15 Frenzied Whelps and 5 Wyrmkin Berserkers in the Feralas Nightmare Incursion at Oneiros and return to Field Captain Arunnel. A quest."},
            [questKeys.objectives] = nil,
        },
        [81858] = {
            [questKeys.name] = "Feralas Mission IV: Dragon Intelligence",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221480,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather intelligence from Dreamwarden Sheldryn in the Feralas Nightmare Incursion at the southernmost ruins in Oneiros and return to Field Captain Arunnel."},
            [questKeys.objectives] = {nil,nil,{{219957}}},
        },
        [81859] = {
            [questKeys.name] = "Feralas Mission V: Cenarion Intelligence",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221480,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather intelligence from Dreamwarden Gorlas in the Feralas Nightmare Incursion near the waterfall at the Twin Colossals and return to Field Captain Arunnel."},
            [questKeys.objectives] = {nil,nil,{{219958}}},
        },
        [81860] = {
            [questKeys.name] = "Feralas Mission VI: Harpy Intelligence",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221480,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather intelligence from Dreamwarden Anadelle in the Feralas Nightmare Incursion at the broken gazebo in the Ruins of Ravenwind and return to Field Captain Arunnel."},
            [questKeys.objectives] = {nil,nil,{{219959}}},
        },
        [81861] = {
            [questKeys.name] = "Feralas Mission VII: Recover Moonglow Dragonegg",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221480,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Recover a Moonglow Dragonegg in the Feralas Nightmare Incursion from the gazebo at Oneiros and return to Field Captain Arunnel."},
            [questKeys.objectives] = {nil,nil,{{219520}}},
        },
        [81863] = {
            [questKeys.name] = "Feralas Mission VIII: Recover Keeper's Notes",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221480,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Recover the Mad Keeper's Notes in the Feralas Nightmare Incursion from the east slope of the west colossal at the Twin Colossals and return to Field Captain Arunnel."},
            [questKeys.objectives] = {nil,nil,{{219519}}},
        },
        [81864] = {
            [questKeys.name] = "Feralas Mission IX: Recover Harpy Screed",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221480,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Recover a Harpy Screed in the Feralas Nightmare Incursion from the southwestern gazebo at the Ruins of Ravenwind and return to Field Captain Arunnel."},
            [questKeys.objectives] = {nil,nil,{{219518}}},
        },
        [81865] = {
            [questKeys.name] = "Feralas Mission X: Moonroot",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221480,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather 10 Moonroot in the Feralas Nightmare Incursions and return to Field Captain Arunnel."},
            [questKeys.objectives] = {nil,nil,{{219514}}},
        },
        [81866] = {
            [questKeys.name] = "Feralas Mission XI: Greater Moonstone",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221480,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather 10 Greater Moonstone in the Feralas Nightmare Incursions and return to Field Captain Arunnel."},
            [questKeys.objectives] = {nil,nil,{{219515}}},
        },
        [81867] = {
            [questKeys.name] = "Feralas Mission XII: Greater Moondragon Scales",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221480,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather 10 Moondragon Scales in the Feralas Nightmare Incursions and return to Field Captain Arunnel."},
            [questKeys.objectives] = {nil,nil,{{219517}}},
        },
        [81868] = {
            [questKeys.name] = "Feralas Mission XIII: Defeat Tyrannikus",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221480,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat Tyrannikus in the Feralas Nightmare Incursion at the ruined temple in Oneiros and return to Field Captain Arunnel."},
            [questKeys.objectives] = nil,
        },
        [81870] = {
            [questKeys.name] = "Feralas Mission XIV: Defeat Alondrius",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221480,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat Alondrius in the Feralas Nightmare Incursion patrolling the road at the Twin Colossals and return to Field Captain Arunnel. A quest. Always up to date."},
            [questKeys.objectives] = nil,
        },
        [81871] = {
            [questKeys.name] = "Feralas Mission XV: Defeat Slirena",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221480,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Defeat Slirena in the Feralas Nightmare Incursion near the ziggurat in the Ruins of Ravenwind and return to Field Captain Arunnel. A quest. Always up to date."},
            [questKeys.objectives] = nil,
        },
        [81872] = {
            [questKeys.name] = "Feralas Mission XVI: Rescue Mellias Earthtender",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221480,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Rescue Mellias Earthtender from the Feralas Nightmare Incursion at the stairs by Jademir Lake in Oneiros and return to Field Captain Arunnel."},
            [questKeys.objectives] = nil,
        },
        [81873] = {
            [questKeys.name] = "Feralas Mission XVII: Rescue Nerene Brooksinger",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221480,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Rescue Nerene Brooksinger from the Feralas Nightmare Incursion at the campfire at the Twin Colossals and return to Field Captain Arunnel. A quest."},
            [questKeys.objectives] = nil,
        },
        [81874] = {
            [questKeys.name] = "Feralas Mission XVIII: Rescue Jamniss Treemender",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{221480,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Rescue Jamnice Treemender from the Feralas Nightmare Incursion at the northern edge of the Ruins of Ravenwind and return to Field Captain Arunnel."},
            [questKeys.objectives] = nil,
        },
        [81877] = {
            [questKeys.name] = "Fight Night",
            [questKeys.startedBy] = {{220984}},
            [questKeys.finishedBy] = {{220984,}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Claim victory in the Gadgetzan Arena."},
            [questKeys.objectives] = nil,
        },
        [81885] = {
            [questKeys.name] = "The Ritual",
            [questKeys.startedBy] = {{221587}},
            [questKeys.finishedBy] = {{221587,}},
            [questKeys.requiredLevel] = 44,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Speak with Gregory to begin the ritual."},
            [questKeys.objectives] = nil,
        },
        [81900] = {
            [questKeys.name] = "The Burning Beast",
            [questKeys.startedBy] = {{7506}},
            [questKeys.finishedBy] = {{7506,}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Find an expert on the beasts of the Blasted Lands."},
            [questKeys.objectives] = nil,
        },
        [81917] = {
            [questKeys.name] = "Chains That Bind",
            [questKeys.startedBy] = {{7506}},
            [questKeys.finishedBy] = {{7506,}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Bring 5 infernal chain links to Bloodmage Lynnore in the Blasted Lands."},
            [questKeys.objectives] = {nil,nil,{{220214}}},
        },
        [81919] = {
            [questKeys.name] = "Brought to Heel",
            [questKeys.startedBy] = {{7506}},
            [questKeys.finishedBy] = {{7506,}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Bring the fel lifeblood of Calefactus the Unleashed to Bloodmage Lynnore in the Blasted Lands."},
            [questKeys.objectives] = {nil,nil,{{220213}}},
        },
        [81924] = {
            [questKeys.name] = "Wisdom of the Guardians",
            [questKeys.startedBy] = {{221985}},
            [questKeys.finishedBy] = {{221985,}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Prove yourself to the guardian spirits of Feralas, Azshara, and the Hinterlands, then return to Tyrisius in Feralas."},
            [questKeys.objectives] = nil,
        },
        [81944] = {
            [questKeys.name] = "A Newly Discovered Purpose...",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{214529,}},
            [questKeys.requiredLevel] = 44,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"I... cannot explain this, &lt;race&gt;, &nbsp;but I think I have something you need. I came to this land to seek knowledge, and that search led me up the mountain over yonder to a giant stone of light, fallen from the sky. In my contemplation at the stone, An'she gifted me with a great many things. One was a sense of new purpose. Another of which was a vision of you and me, here, having this conversation. I think I gave you this.Please, take this totem. Use it well in service of An'she... in service of the light."},
            [questKeys.objectives] = nil,
        },
        [81947] = {
            [questKeys.name] = "Sanguine Sorcery",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{220345}}},
        },
        [81949] = {
            [questKeys.name] = "Legends of the Tidesages",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{220346}}},
        },
        [81951] = {
            [questKeys.name] = "The Liminal and the Arcane",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{220347}}},
        },
        [81952] = {
            [questKeys.name] = "Everyday Etiquette",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{220348}}},
        },
        [81953] = {
            [questKeys.name] = "Stonewrought Design",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{220349}}},
        },
        [81954] = {
            [questKeys.name] = "Venomous Journeys",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{220350}}},
        },
        [81955] = {
            [questKeys.name] = "A Mind of Metal",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{220352}}},
        },
        [81956] = {
            [questKeys.name] = "Conjurer's Codex",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Have you brought something to add to our collection?"},
            [questKeys.objectives] = {nil,nil,{{220353}}},
        },
        [81960] = {
            [questKeys.name] = "Clarifying Air",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{222289,}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Find the tainted Spirit Rock and drink the Murky Air Sapta."},
            [questKeys.objectives] = {nil,nil,{{220379},{220351}}},
        },
        [81967] = {
            [questKeys.name] = "Otherworldly Treasure",
            [questKeys.startedBy] = {{222052}},
            [questKeys.finishedBy] = {{222052,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Here ya go, boss!"},
            [questKeys.objectives] = nil,
        },
        [81968] = {
            [questKeys.name] = "Answering Air's Call",
            [questKeys.startedBy] = {{222289}},
            [questKeys.finishedBy] = {{222289,}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Collect 3 Elemental Essence from the water elementals on The Forgotten Coast across from Sardor Isle in Feralas and combine them with the Fragment of Air to summon help at the corrupted shrine there."},
            [questKeys.objectives] = {nil,nil,{{220510},{220525},{220375}}},
        },
        [81974] = {
            [questKeys.name] = "More Junk for Ziri",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{217689,}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Talk with Ziri \"The Wrench\" Littlesprocket in Gnomeregan."},
            [questKeys.objectives] = nil,
        },
        [81975] = {
            [questKeys.name] = "A Troubling Exchange",
            [questKeys.startedBy] = {{217689}},
            [questKeys.finishedBy] = {{217689,}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Talk to Ziri."},
            [questKeys.objectives] = nil,
        },
        [81986] = {
            [questKeys.name] = "Waking the Nightmare",
            [questKeys.startedBy] = {{222188}},
            [questKeys.finishedBy] = {{222188,}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Destroy the Nightmare Amalgamation and bring the Shadowy Figure any loot you find."},
            [questKeys.objectives] = {nil,nil,{{220570}}},
        },
        [81987] = {
            [questKeys.name] = "Goblin Solutions",
            [questKeys.startedBy] = {{222261}},
            [questKeys.finishedBy] = {{222261,}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring 5 Goblin Land Mines to Maximillian \"The Greaser\" in the Shimmering Flat."},
            [questKeys.objectives] = {nil,nil,{{4395}}},
        },
        [82001] = {
            [questKeys.name] = "Require Gnomish Problems",
            [questKeys.startedBy] = {{222261}},
            [questKeys.finishedBy] = {{222261,}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the Horn of a Thunderstomp Stegodon to Maximillian \"The Greaser\"."},
            [questKeys.objectives] = {nil,nil,{{220916}}},
        },
        [82002] = {
            [questKeys.name] = "Whats Red and Smells like Paint?",
            [questKeys.startedBy] = {{222261}},
            [questKeys.finishedBy] = {{222261,}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Head to Hearthglen and find a Box of Scarlet Dye."},
            [questKeys.objectives] = {nil,nil,{{220917}}},
        },
        [82003] = {
            [questKeys.name] = "Victory Lap For the Goblins!",
            [questKeys.startedBy] = {{222261}},
            [questKeys.finishedBy] = {{222316,}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Talk to Fizzbizz Coppercoil about getting a pay out."},
            [questKeys.objectives] = nil,
        },
        [82004] = {
            [questKeys.name] = "Hush Money",
            [questKeys.startedBy] = {{222316}},
            [questKeys.finishedBy] = {{222316,}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Accept the Bribe from Fizzbizz Coppercoil."},
            [questKeys.objectives] = nil,
        },
        [82008] = {
            [questKeys.name] = "Gnomish Solutions",
            [questKeys.startedBy] = {{222316}},
            [questKeys.finishedBy] = {{222316,}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Fizzbizz Coppercoil 2 Gnomish Harm Prevention Belts."},
            [questKeys.objectives] = {nil,nil,{{10721}}},
        },
        [82009] = {
            [questKeys.name] = "Require Goblin Problems",
            [questKeys.startedBy] = {{222316}},
            [questKeys.finishedBy] = {{222316,}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Fizzbizz Coppercoil a Thunderstomp Stegodon Horn."},
            [questKeys.objectives] = {nil,nil,{{220916}}},
        },
        [82010] = {
            [questKeys.name] = "Watering Down the Competition",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{222316,}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Go to Hearthglen and find a Box of Scarlet Dye."},
            [questKeys.objectives] = {nil,nil,{{220917}}},
        },
        [82011] = {
            [questKeys.name] = "Victory Lap for the Gnomes!",
            [questKeys.startedBy] = {{222316}},
            [questKeys.finishedBy] = {{222261,}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Talk to Maximillian \"The Greaser\"."},
            [questKeys.objectives] = nil,
        },
        [82013] = {
            [questKeys.name] = "Hush Money",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{222261,}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Accept the bribe from Maximillian \"The Greaser\"."},
            [questKeys.objectives] = nil,
        },
        [82016] = {
            [questKeys.name] = "Atal'ai Potent Potables",
            [questKeys.startedBy] = {{222413}},
            [questKeys.finishedBy] = {{222413,}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"I offer quite a deal for you mon! Bring me mojo found only from de Atal'ai people, and I make you a proposition: power beyond your wildest imagination. Be warned, mon, this power can only be used de swamps it is found from. Dey say de Atal'ai practice forbidden hexcraft, and I might know a bit about 'em. Sound good? Do you want to make a trade?"},
            [questKeys.objectives] = {nil,nil,{{221312}}},
        },
        [82017] = {
            [questKeys.name] = "An Amalagamation of Nightmares",
            [questKeys.startedBy] = {{221477}},
            [questKeys.finishedBy] = {{12042,}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Seek out Loganaar in Moonglade."},
            [questKeys.objectives] = nil,
        },
        [82018] = {
            [questKeys.name] = "Itharius",
            [questKeys.startedBy] = {{12042}},
            [questKeys.finishedBy] = {{5353,}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Seek out Itharius somewhere in the Swamp of Sorrows."},
            [questKeys.objectives] = nil,
        },
        [82019] = {
            [questKeys.name] = "Going Under",
            [questKeys.startedBy] = {{5353}},
            [questKeys.finishedBy] = {{5353,}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Find out more about what is happening in the Temple of Atal'Hakkar."},
            [questKeys.objectives] = nil,
        },
        [82020] = {
            [questKeys.name] = "Return to Moonglade",
            [questKeys.startedBy] = {{5353}},
            [questKeys.finishedBy] = {{12042,}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return to Loganaar in Moonglade."},
            [questKeys.objectives] = nil,
        },
        [82021] = {
            [questKeys.name] = "A Fortuitous Turn of Events",
            [questKeys.startedBy] = {{222188}},
            [questKeys.finishedBy] = {{222188,}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Listen to what the Shadowy Figure has to say."},
            [questKeys.objectives] = nil,
        },
        [82022] = {
            [questKeys.name] = "The Bad News...",
            [questKeys.startedBy] = {{222188}},
            [questKeys.finishedBy] = {{222188,}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Find the adventurer that the Shadowy Figure described, and recover the Void-Powered Vambraces."},
            [questKeys.objectives] = {nil,nil,{{220964}}},
        },
        [82023] = {
            [questKeys.name] = "The Lost Vambraces",
            [questKeys.startedBy] = {{222444}},
            [questKeys.finishedBy] = {{222451,}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Find the lair of the \"Beast\" that the injured gnome was referring to and recover the Void-Powered Vambraces."},
            [questKeys.objectives] = nil,
        },
        [82043] = {
            [questKeys.name] = "The Wild Gods",
            [questKeys.startedBy] = {{222408}},
            [questKeys.finishedBy] = {{222522,}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Collect a Wildwhisper Draught from Jintha'alor in the Hinterlands, then use it at the top of Razorfen Downs to speak to the Spirit of Agamaggan."},
            [questKeys.objectives] = nil,
        },
        [82044] = {
            [questKeys.name] = "The Wild Gods",
            [questKeys.startedBy] = {{222522}},
            [questKeys.finishedBy] = {{222408,}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Deliver Wild Offerings to the Shadowtooth Emissary in Felwood. Use Agamaggan's Roar on a Delirious Ancient and defeat it to earn Wild Offerings."},
            [questKeys.objectives] = {nil,nil,{{221262}}},
        },
        [82055] = {
            [questKeys.name] = "Darkmoon Dunes Deck",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{14847,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return the Dunes Deck to the Darkmoon Faire when it comes to town. A Darkmoon Faire quest. +150 reputation with Darkmoon Faire. Added in Classic World of Warcraft."},
            [questKeys.objectives] = nil,
        },
        [82056] = {
            [questKeys.name] = "Darkmoon Nightmares Deck",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return the Nightmares Deck to the Darkmoon Faire when it comes to town. A Darkmoon Faire quest. +150 reputation with Darkmoon Faire. Always up to date."},
            [questKeys.objectives] = nil,
        },
        [82057] = {
            [questKeys.name] = "Darkmoon Plagues Deck",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{14847,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return the Plagues Deck to the Darkmoon Faire when it comes to town. A Darkmoon Faire quest. +150 reputation with Darkmoon Faire. Added in Classic World of Warcraft."},
            [questKeys.objectives] = nil,
        },
        [82058] = {
            [questKeys.name] = "Darkmoon Wilds Deck",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{14847,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Return the Wilds Deck to the Darkmoon Faire when it comes to town. A Darkmoon Faire quest. +150 reputation with Darkmoon Faire. Added in Classic World of Warcraft."},
            [questKeys.objectives] = nil,
        },
        [82062] = {
            [questKeys.name] = "Ever After",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{222530,}},
            [questKeys.requiredLevel] = 48,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"&lt;You're handed a small parcel with a shirt neatly folded over it.&gt;."},
            [questKeys.objectives] = nil,
        },
        [82068] = {
            [questKeys.name] = "Fight the Nightmare Incursions",
            [questKeys.startedBy] = {{221479}},
            [questKeys.finishedBy] = {{221479,221480,}},
            [questKeys.requiredLevel] = 47,
            [questKeys.questLevel] = 52,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Complete a Nightmare Incursion mission in Feralas or Hinterlands and then report to Field Captain Korlian or Field Captain Arunnel. Rewards ."},
            [questKeys.objectives] = nil,
        },
        [82071] = {
            [questKeys.name] = "Purifying Fire",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{222617,}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Find the tainted Spirit Rock and drink the Murky Fire Sapta."},
            [questKeys.objectives] = {nil,nil,{{221350},{221347}}},
        },
        [82072] = {
            [questKeys.name] = "Purging Earth",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{222623,}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Find the tainted Spirit Rock and drink the Murky Earth Sapta."},
            [questKeys.objectives] = {nil,nil,{{221352},{221349}}},
        },
        [82073] = {
            [questKeys.name] = "Cleansing Water",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{222005,}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Find the tainted Spirit Rock and drink the Murky Water Sapta."},
            [questKeys.objectives] = {nil,nil,{{221351},{221348}}},
        },
        [82074] = {
            [questKeys.name] = "Answering Fire's Call",
            [questKeys.startedBy] = {{222617}},
            [questKeys.finishedBy] = {{222617,}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Collect 3 Elemental Essence from the water elementals on The Forgotten Coast across from Sardor Isle in Feralas and combine them with the Fragment of Fire to summon help at the corrupted shrine there."},
            [questKeys.objectives] = {nil,nil,{{220510},{221356},{221353}}},
        },
        [82075] = {
            [questKeys.name] = "Answering Earth's Call",
            [questKeys.startedBy] = {{222623}},
            [questKeys.finishedBy] = {{222623,}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Collect 3 Elemental Essence from the water elementals on The Forgotten Coast across from Sardor Isle in Feralas and combine them with the Fragment of Earth to summon help at the corrupted shrine there."},
            [questKeys.objectives] = {nil,nil,{{220510},{221358},{221355}}},
        },
        [82076] = {
            [questKeys.name] = "Answering Water's Call",
            [questKeys.startedBy] = {{222005}},
            [questKeys.finishedBy] = {{222005,}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Collect 3 Elemental Essence from the water elementals on The Forgotten Coast across from Sardor Isle in Feralas and combine them with the Fragment of Water to summon help at the corrupted shrine there."},
            [questKeys.objectives] = {nil,nil,{{220510},{221357},{221354}}},
        },
        [82081] = {
            [questKeys.name] = "A Broken Ritual",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = {{14875,}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the Scapula of the Fallen Avatar to Molthor in Yojamba Isle."},
            [questKeys.objectives] = nil,
        },
        [82083] = {
            [questKeys.name] = "A Broken Ritual",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the Scapula of the Fallen Avatar to Molthor in Yojamba Isle."},
            [questKeys.objectives] = nil,
        },
        [82084] = {
            [questKeys.name] = "A Lesson in Literacy",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033,}},
            [questKeys.requiredLevel] = 42,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Your progress in the arcane arts has been exemplary, &lt;name&gt;. I think you are ready to author a spellbook of your own.Let's see... a quill from the Owlbeasts of the Hinterlands, and ink derived from silithid resin... yes, that will do. And for the pages, the finest Farraki Papyrus!"},
            [questKeys.objectives] = {nil,nil,{{221359},{221361},{221360}}},
        },
        [82086] = {
            [questKeys.name] = "A Lesson in Literacy",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 42,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = nil,
            [questKeys.objectives] = {nil,nil,{{221359},{221361},{221360}}},
        },
        [82089] = {
            [questKeys.name] = "Master of Transmutation",
            [questKeys.startedBy] = {{222772}},
            [questKeys.finishedBy] = {{222772,}},
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Crimeon Lablade three Arcanite Bars."},
            [questKeys.objectives] = {nil,nil,{{12360}}},
        },
        [82090] = {
            [questKeys.name] = "Mixology For Fun and Profit",
            [questKeys.startedBy] = {{222763}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring Mixmaster Blix 10 Invisibility Potions, 10 Major Trollsblood Potions, and 5 Elixir of Sages."},
            [questKeys.objectives] = {nil,nil,{{20004},{9172},{13447}}},
        },
        [82093] = {
            [questKeys.name] = "Jungle Durian",
            [questKeys.startedBy] = {{222413}},
            [questKeys.finishedBy] = {{222413,}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = nil,
            [questKeys.objectives] = {nil,nil,{{221312}}},
        },
        [82094] = {
            [questKeys.name] = "Signets of the Lost Temple",
            [questKeys.startedBy] = {{222413}},
            [questKeys.finishedBy] = {{222413,}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = nil,
            [questKeys.objectives] = {nil,nil,{{221313}}},
        },
        [82095] = {
            [questKeys.name] = "The God Hakkar",
            [questKeys.startedBy] = {{8579}},
            [questKeys.finishedBy] = {{8579,}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring the Filled Egg of Hakkar to Yeh'kinya in Tanaris."},
            [questKeys.objectives] = {nil,nil,{{10662},{10663},{10465}}},
        },
        [82096] = {
            [questKeys.name] = "Into the Depths",
            [questKeys.startedBy] = {{7771}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Find the Altar of Hakkar in the Sunken Temple in Swamp of Sorrows."},
            [questKeys.objectives] = nil,
        },
        [82097] = {
            [questKeys.name] = "Secret of the Circle",
            [questKeys.startedBy] = {{7771}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Travel into the Sunken Temple and discover the secret hidden in the circle of statues."},
            [questKeys.objectives] = nil,
        },
        [82098] = {
            [questKeys.name] = "Into The Temple of Atal'Hakkar",
            [questKeys.startedBy] = {{5384}},
            [questKeys.finishedBy] = {{5384,}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Gather 10 Atal'ai Tablets for Brohann Caskbelly in Stormwind."},
            [questKeys.objectives] = {nil,nil,{{6288}}},
        },
        [82099] = {
            [questKeys.name] = "Haze of Evil",
            [questKeys.startedBy] = {{7775}},
            [questKeys.finishedBy] = {{9119,}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Collect 5 samples of Atal'ai Haze, then return to Muigin in Un'Goro Crater."},
            [questKeys.objectives] = {nil,nil,{{11318}}},
        },
        [82100] = {
            [questKeys.name] = "The Temple of Atal'Hakkar",
            [questKeys.startedBy] = {{1443}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Collect 20 Fetishes of Hakkar and bring them to Fel'Zerul in Stonard."},
            [questKeys.objectives] = {nil,nil,{{6181}}},
        },
        [82101] = {
            [questKeys.name] = "Zapper Fuel",
            [questKeys.startedBy] = {{8496}},
            [questKeys.finishedBy] = {{9118,}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Deliver the Unloaded Zapper and 5 samples of Atal'ai Haze to Larion in Marshal's Refuge."},
            [questKeys.objectives] = {nil,nil,{{11318}}},
        },
        [82102] = {
            [questKeys.name] = "The Essence of Eranikus",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Place the Essence of Eranikus in the Essence Font located in this lair in the Sunken Temple."},
            [questKeys.objectives] = nil,
        },
        [82104] = {
            [questKeys.name] = "Jammal'an the Prophet",
            [questKeys.startedBy] = {{5598}},
            [questKeys.finishedBy] = {{5598,}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"The Atal'ai Exile in The Hinterlands wants the Head of Jammal'an."},
            [questKeys.objectives] = {nil,nil,{{6212}}},
        },
        [82106] = {
            [questKeys.name] = "Forging the Mightstone",
            [questKeys.startedBy] = {{10838}},
            [questKeys.finishedBy] = {{10838,}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Bring the voodoo feathers to Ashlam Valorfist."},
            [questKeys.objectives] = {nil,nil,{{20606},{20607},{20608}}},
        },
        [82107] = {
            [questKeys.name] = "Voodoo Feathers",
            [questKeys.startedBy] = {{7572}},
            [questKeys.finishedBy] = {{7572,}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Bring the Voodoo Feathers from the trolls in the Sunken Temple to the Fallen Hero of the Horde."},
            [questKeys.objectives] = {nil,nil,{{20606},{20607},{20608}}},
        },
        [82108] = {
            [questKeys.name] = "The Green Drake",
            [questKeys.startedBy] = {{8405}},
            [questKeys.finishedBy] = {{8405,}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Bring the Tooth of Morphaz to Ogtinc in Azshara.  Ogtinc resides atop the cliffs northeast the Ruins of Eldarath."},
            [questKeys.objectives] = {nil,nil,{{20019}}},
        },
        [82110] = {
            [questKeys.name] = "The Azure Key",
            [questKeys.startedBy] = {{8379}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Return the Azure Key to Lord Jorach Ravenholdt."},
            [questKeys.objectives] = {nil,nil,{{20022}}},
        },
        [82111] = {
            [questKeys.name] = "Blood of Morphaz",
            [questKeys.startedBy] = {{8405}},
            [questKeys.finishedBy] = {{10922,}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Morphaz in the sunken temple of Atal'Hakkar, and return his blood to Greta Mosshoof in Felwood.  The entrance to the sunken temple can be found in the Swamp of Sorrows."},
            [questKeys.objectives] = {nil,nil,{{20025}}},
        },
        [82112] = {
            [questKeys.name] = "A Better Ingredient",
            [questKeys.startedBy] = {{9619}},
            [questKeys.finishedBy] = {{9619,}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Retrieve a Putrid Vine from the guardian at the bottom of the Sunken Temple and return to Torwa Pathfinder."},
            [questKeys.objectives] = {nil,nil,{{22444}}},
        },
        [82113] = {
            [questKeys.name] = "Da Voodoo",
            [questKeys.startedBy] = {{6176}},
            [questKeys.finishedBy] = {{6176,}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Bring the voodoo feathers to Bath'rah the Windwatcher."},
            [questKeys.objectives] = {nil,nil,{{20606},{20607},{20608}}},
        },
        [82114] = {
            [questKeys.name] = "Destroy Morphaz",
            [questKeys.startedBy] = {{8379}},
            [questKeys.finishedBy] = {{8379,}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Retrieve the Arcane Shard from Morphaz and return to Archmage Xylem."},
            [questKeys.objectives] = {nil,nil,{{20085}}},
        },
        [82115] = {
            [questKeys.name] = "Trolls of a Feather",
            [questKeys.startedBy] = {{14470}},
            [questKeys.finishedBy] = {{14470,}},
            [questKeys.requiredLevel] = 50,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Bring a total of 6 Voodoo Feathers from the trolls in sunken temple."},
            [questKeys.objectives] = {nil,nil,{{20606},{20607},{20608}}},
        },
        [82135] = {
            [questKeys.name] = "The Price of Hope",
            [questKeys.startedBy] = {{221587}},
            [questKeys.finishedBy] = {{5492,}},
            [questKeys.requiredLevel] = 44,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Bring the Mannoroc Echoing Orb to Katherine the Pure in Stormwind."},
            [questKeys.objectives] = nil,
        },
        [82208] = {
            [questKeys.name] = "Greater Friend of the Library",
            [questKeys.startedBy] = {{211033}},
            [questKeys.finishedBy] = {{211022,211033,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Thanks to your donations, the library is thriving.Please, take this."},
            [questKeys.objectives] = nil,
        },
        [82209] = {
            [questKeys.name] = "Water Pouch Bounty",
            [questKeys.startedBy] = {{7408}},
            [questKeys.finishedBy] = {{7408,}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 44,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Back again, &lt;name&gt;? &nbsp;If you have five more Wastewander water pouches, then I have a care package with your name on it!"},
            [questKeys.objectives] = {nil,nil,{{8483}}},
        },
        [82210] = {
            [questKeys.name] = "Troll Necklace Bounty",
            [questKeys.startedBy] = {{7884}},
            [questKeys.finishedBy] = {{7884,}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"You've done it already, but we will continue to accept any troll tribal necklaces you find and are willing to turn in. &nbsp;By turning them in to me, you'll continue to improve your standing amongst the Wildhammers; if you're willing to fight for us, then we'll be willing to fight for you!I need five troll tribal necklaces for them to count, &lt;name&gt;."},
            [questKeys.objectives] = {nil,nil,{{9259}}},
        },
        [82271] = {
            [questKeys.name] = "More Glowing Scorpid Blood",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"A Darkmoon Faire quest. Rewards Darkmoon Faire Prize Ticket. Added in Classic World of Warcraft. Always up to date with the latest patch (1.15.2)."},
            [questKeys.objectives] = {nil,nil,{{19933}}},
        },
        [82272] = {
            [questKeys.name] = "Glowing Scorpid Blood",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"A Darkmoon Faire quest. +100 reputation with Darkmoon Faire. Rewards Darkmoon Faire Prize Ticket. Added in Classic World of Warcraft. Always up to date."},
            [questKeys.objectives] = {nil,nil,{{19933}}},
        },
        [82273] = {
            [questKeys.name] = "More Bat Eyes",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"A Darkmoon Faire quest. Rewards Darkmoon Faire Prize Ticket. Added in Classic World of Warcraft. Always up to date with the latest patch (1.15.2)."},
            [questKeys.objectives] = {nil,nil,{{11404}}},
        },
        [82274] = {
            [questKeys.name] = "Evil Bat Eyes",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"A Darkmoon Faire quest. +100 reputation with Darkmoon Faire. Rewards Darkmoon Faire Prize Ticket. Added in Classic World of Warcraft. Always up to date."},
            [questKeys.objectives] = {nil,nil,{{11404}}},
        },
        [82275] = {
            [questKeys.name] = "Big Black Mace",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"A Darkmoon Faire quest. +100 reputation with Darkmoon Faire. Rewards Darkmoon Faire Prize Ticket. Added in Classic World of Warcraft. Always up to date."},
            [questKeys.objectives] = {nil,nil,{{7945}}},
        },
        [82276] = {
            [questKeys.name] = "Rituals of Strength",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"A Darkmoon Faire quest. +100 reputation with Darkmoon Faire. Rewards Darkmoon Faire Prize Ticket. Added in Classic World of Warcraft. Always up to date."},
            [questKeys.objectives] = {nil,nil,{{12644}}},
        },
        [82277] = {
            [questKeys.name] = "More Dense Grinding Stones",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"A Darkmoon Faire quest. Rewards Darkmoon Faire Prize Ticket. Added in Classic World of Warcraft. Always up to date with the latest patch (1.15.2)."},
            [questKeys.objectives] = {nil,nil,{{12644}}},
        },
        [82278] = {
            [questKeys.name] = "More Thorium Widgets",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"A Darkmoon Faire quest. Rewards Darkmoon Faire Prize Ticket. Added in Classic World of Warcraft. Always up to date with the latest patch (1.15.2)."},
            [questKeys.objectives] = {nil,nil,{{15994}}},
        },
        [82279] = {
            [questKeys.name] = "Thorium Widget",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"A Darkmoon Faire quest. +100 reputation with Darkmoon Faire. Rewards Darkmoon Faire Prize Ticket. Added in Classic World of Warcraft. Always up to date."},
            [questKeys.objectives] = {nil,nil,{{15994}}},
        },
        [82280] = {
            [questKeys.name] = "Mechanical Repair Kits",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"A Darkmoon Faire quest. +100 reputation with Darkmoon Faire. Rewards Darkmoon Faire Prize Ticket. Added in Classic World of Warcraft. Always up to date."},
            [questKeys.objectives] = {nil,nil,{{11590}}},
        },
        [82281] = {
            [questKeys.name] = "More Armor Kits",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"A Darkmoon Faire quest. Rewards Darkmoon Faire Prize Ticket. Added in Classic World of Warcraft. Always up to date with the latest patch (1.15.2)."},
            [questKeys.objectives] = {nil,nil,{{15564}}},
        },
        [82282] = {
            [questKeys.name] = "Armor Kits",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"A Darkmoon Faire quest. +100 reputation with Darkmoon Faire. Rewards Darkmoon Faire Prize Ticket. Added in Classic World of Warcraft. Always up to date."},
            [questKeys.objectives] = {nil,nil,{{15564}}},
        },
        [82283] = {
            [questKeys.name] = "Crocolisk Boy and the Bearded Murloc",
            [questKeys.startedBy] = nil,
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"A Darkmoon Faire quest. +100 reputation with Darkmoon Faire. Rewards Darkmoon Faire Prize Ticket. Added in Classic World of Warcraft. Always up to date."},
            [questKeys.objectives] = {nil,nil,{{8185}}},
        },
        [82301] = {
            [questKeys.name] = "Otherworldly Treasure",
            [questKeys.startedBy] = {{222052}},
            [questKeys.finishedBy] = {{222052,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Here ya go, boss!"},
            [questKeys.objectives] = nil,
        },
        [82302] = {
            [questKeys.name] = "Otherworldly Treasure",
            [questKeys.startedBy] = {{222052}},
            [questKeys.finishedBy] = {{222052,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Here ya go, boss!"},
            [questKeys.objectives] = nil,
        },
        [82303] = {
            [questKeys.name] = "Otherworldly Treasure",
            [questKeys.startedBy] = {{222052}},
            [questKeys.finishedBy] = {{222052,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Here ya go, boss!"},
            [questKeys.objectives] = nil,
        },
        [82307] = {
            [questKeys.name] = "A Full Shipment",
            [questKeys.startedBy] = {{214101}},
            [questKeys.finishedBy] = {{213077,214070,214096,214099,214101,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Do you have something for me?"},
            [questKeys.objectives] = {nil,nil,{{221008}}},
        },
        [82308] = {
            [questKeys.name] = "A Full Shipment",
            [questKeys.startedBy] = {{214101}},
            [questKeys.finishedBy] = {{213077,214070,214098,214099,214101,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Do you have something for me?"},
            [questKeys.objectives] = {nil,nil,{{221009}}},
        },
        [82309] = {
            [questKeys.name] = "A Full Shipment",
            [questKeys.startedBy] = {{214101}},
            [questKeys.finishedBy] = {{214070,214099,214101,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Do you have something for me?"},
            [questKeys.objectives] = {nil,nil,{{221010}}},
        },
        [82316] = {
            [questKeys.name] = "Seven Eyes I Seek...",
            [questKeys.startedBy] = {{223590}},
            [questKeys.finishedBy] = {{223590,}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Seven hidden eyes I seek... bring them to me and you too shall see."},
            [questKeys.objectives] = {nil,nil,{{223330},{223332},{223333},{223334},{223335},{223337},{223336}}},
        },
        [82323] = {
            [questKeys.name] = "Vibrant Plumes",
            [questKeys.startedBy] = {{14829}},
            [questKeys.finishedBy] = {{14829,}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"A Darkmoon Faire quest. +100 reputation with Darkmoon Faire. Rewards Darkmoon Faire Prize Ticket. Added in Classic World of Warcraft. Always up to date."},
            [questKeys.objectives] = {nil,nil,{{5117}}},
        },
        [82656] = {
            [questKeys.name] = "Wild Leather Vest",
            [questKeys.startedBy] = {{7854}},
            [questKeys.finishedBy] = {{7854,}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring 2 Turtle Scale Breastplates, 2 Turtle Scale Gloves, and a Wildvine to Jangdor Swiftstrider in Camp Mojache."},
            [questKeys.objectives] = {nil,nil,{{8153},{217268},{217270}}},
        },
        [82657] = {
            [questKeys.name] = "Wild Leather Vest",
            [questKeys.startedBy] = {{7852}},
            [questKeys.finishedBy] = {{7852,}},
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"Bring 2 Turtle Scale Breastplates, 2 Turtle Scale Gloves, and a Wildvine to Pratt McGrubben in Feathermoon Stronghold."},
            [questKeys.objectives] = {nil,nil,{{8153},{217268},{217270}}},
        },
        [82662] = {
            [questKeys.name] = "The Way of the Weaponsmith",
            [questKeys.startedBy] = {{11146}},
            [questKeys.finishedBy] = {{11146,}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"To become a Weaponsmith, you must make the following items and return them to Ironus: 4 Moonsteel Broadswords, 4 Massive Iron Axes, 2 Heavy Mithril Axes, and 2 Big Black Maces."},
            [questKeys.objectives] = {nil,nil,{{217281},{3855},{7941},{7945}}},
        },
        [82665] = {
            [questKeys.name] = "The Way of the Weaponsmith",
            [questKeys.startedBy] = {{11178}},
            [questKeys.finishedBy] = {{11178,}},
            [questKeys.requiredLevel] = 40,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.objectivesText] = {"To become a Weaponsmith, you must make the following items and return them to Borgosh: 4 Moonsteel Broadswords, 4 Massive Iron Axes, 2 Heavy Mithril Axes, and 2 Big Black Maces."},
            [questKeys.objectives] = {nil,nil,{{217281},{3855},{7941},{7945}}},
        },
    }
end
