QUESTGURU_NUMTABS = 0;
QuestGuru_Tab = {};

-- tabInfo
-- .click = function to call on TabClick
-- .expand = function to call on ExpandCollapse
-- .text = Text to display on the tab
-- .frame = Frame to show when on this tab
-- .name = Name of tab for updating
-- pos = position of where the tab should appear, starting with 1
function QuestGuru_AddTab(tabInfo, pos)
	local i, temp;
	
	if ((not pos) or (pos < 1)) then
 		tinsert(QuestGuru_Tab, tabInfo);
	else
 		tinsert(QuestGuru_Tab, pos, tabInfo);
	end
	QUESTGURU_NUMTABS = QUESTGURU_NUMTABS + 1;
	temp = CreateFrame("Button", "QuestGuru_QuestLogFrameTab"..QUESTGURU_NUMTABS, QuestGuru_QuestLogFrame, "QuestGuru_QuestLogFrameTabTemplate");
	PanelTemplates_SetNumTabs(QuestGuru_QuestLogFrame, QUESTGURU_NUMTABS);
	QuestGuru_UpdateTabs();
end

function QuestGuru_UpdateTab(tabInfo)
	local i, v;
	
	for i, v in ipairs(QuestGuru_Tab) do
		if (v.name == tabInfo.name) then
			if (tabInfo.click) then v.click = tabInfo.click; end
			if (tabInfo.expand) then v.expand = tabInfo.expand; end
			if (tabInfo.text) then v.text = tabInfo.text; end
			if (tabInfo.frame) then v.frame = tabInfo.frame; end
		end
	end
	QuestGuru_UpdateTabs();
end

function QuestGuru_UpdateTabText(tabName, tabText)
	local tmpInfo = {};
	
	tmpInfo.name = tabName;
	tmpInfo.text = tabText;
	QuestGuru_UpdateTab(tmpInfo);
end

function QuestGuru_GetCurrTabName()
	local currTab = PanelTemplates_GetSelectedTab(QuestGuru_QuestLogFrame);
	if (QuestGuru_Tab[currTab]) then
		return QuestGuru_Tab[currTab].name;
	else
		return nil;
	end
end

function QuestGuru_TabClick(id)
	local i;

	HideDropDownMenu(1);
	
	if (id > QUESTGURU_NUMTABS) then return; end

	PanelTemplates_SetTab(QuestGuru_QuestLogFrame, id);

	for i=1, QUESTGURU_NUMTABS do
		QuestGuru_Tab[i].frame:Hide();
	end
	QuestGuru_Tab[id].frame:Show();
	
	QuestGuru_Tab[id].click();
end

function QuestGuru_UpdateTabs()
	local i;
	local lastTab = 1;
	
	if (QUESTGURU_NUMTABS == 0) then return; end

	QuestGuru_QuestLogFrameTab1:SetPoint("TOPLEFT", "QuestGuru_QuestLogFrame", "TOPLEFT", 32, -18);
	QuestGuru_QuestLogFrameTab1:SetText(QuestGuru_Tab[1].text);
	QuestGuru_QuestLogFrameTab1:SetID(1);
	PanelTemplates_TabResize(getglobal("QuestGuru_QuestLogFrameTab1"), 8);
	for i=2, QUESTGURU_NUMTABS do
		local tab = getglobal("QuestGuru_QuestLogFrameTab"..i);
		tab:SetID(i);
		local t = QuestGuru_Tab[i].text;
		tab:SetText(t);
		if (t) then
			if (string.find(t, "%(0%)")) then
				tab:Hide();
			else
				tab:SetPoint("LEFT", "QuestGuru_QuestLogFrameTab"..lastTab, "RIGHT", 0, 0);
				PanelTemplates_TabResize(tab, 8);
				tab:Show();
				lastTab = i;
			end
		end
	end
end

function QuestGuru_ExpandCollapse()
	local currTab = PanelTemplates_GetSelectedTab(QuestGuru_QuestLogFrame);

	QuestGuru_Tab[currTab].expand();
end