local lastColorPick;

QuestGuru_Sounds = {"PVPENTERQUEUE","PVPTHROUGHQUEUE","GLUECREATECHARACTERBUTTON","GLUEENTERWORLDBUTTON","QUESTCOMPLETED","INTERFACESOUND_MONEYFRAMEOPEN",
"igPlayerInvite","LEVELUP","QUESTADDED","gsCharacterCreationCreateChar","TalentScreenOpen","ReadyCheck","RaidWarning","AuctionWindowOpen","AuctionWindowClose",
"Sound\\Creature\\Peon\\PeonBuildingComplete1.wav", "Sound\\Creature\\Peon\\PeonReady1.wav", "Sound\\Creature\\Peasant\\PeasantReady1.wav", "Sound\\Interface\\igPlayerBind.wav",
"Sound\\Creature\\MillhouseManastorm\\TEMPEST_Millhouse_Ready01.wav", "Sound\\Creature\\MillhouseManastorm\\TEMPEST_Millhouse_Slay01.wav", "Sound\\Creature\\Cow\\CowDeath.wav",
"Sound\\interface\\HumanExploration.wav"};

function QuestGuru_OptionsFrameSoundProgressDropDown_Initialize()
	if (QuestGuru_Settings.Sounds == nil) then return; end
	local info = UIDropDownMenu_CreateInfo();
	info.func = QuestGuru_OptionsFrameSoundProgress_OnClick;
	info.owner = QuestGuru_OptionsFrameSoundProgressButton;
	info.checked = nil;
	info.icon = nil;

	for i,v in ipairs(QuestGuru_Sounds) do
		info.text = v;
		info.value = i;
		if (v == QuestGuru_Settings.Sounds.Progress.Sound) then
			info.checked = 1;
		else
			info.checked = nil;
		end
		UIDropDownMenu_AddButton(info, 1);
	end
	UIDropDownMenu_SetText(QuestGuru_OptionsFrameSoundProgressButton, QuestGuru_Settings.Sounds.Progress.Sound);
end

function QuestGuru_OptionsFrameSoundProgress_OnClick(self, button, down)
	if (QuestGuru_Settings.Sounds == nil) then return; end
	local sound = QuestGuru_Sounds[self.value];
	if ((string.sub(sound, -4) == ".wav") or (string.sub(sound, -4) == ".mp3")) then
		PlaySoundFile(sound);
	else
		PlaySound(sound);
	end
	UIDropDownMenu_SetText(QuestGuru_OptionsFrameSoundProgressButton, sound);
	QuestGuru_Settings.Sounds.Progress.Sound = sound;
end

function QuestGuru_OptionsFrameSoundObjCompleteDropDown_Initialize()
	if (QuestGuru_Settings.Sounds == nil) then return; end
	local info = UIDropDownMenu_CreateInfo();
	info.func = QuestGuru_OptionsFrameSoundObjComplete_OnClick;
	info.owner = QuestGuru_OptionsFrameSoundObjCompleteButton;
	info.checked = nil;
	info.icon = nil;

	for i,v in ipairs(QuestGuru_Sounds) do
		info.text = v;
		info.value = i;
		if (v == QuestGuru_Settings.Sounds.ObjComplete.Sound) then
			info.checked = 1;
		else
			info.checked = nil;
		end
		UIDropDownMenu_AddButton(info, 1);
	end
	UIDropDownMenu_SetText(QuestGuru_OptionsFrameSoundObjCompleteButton, QuestGuru_Settings.Sounds.ObjComplete.Sound);
end

function QuestGuru_OptionsFrameSoundObjComplete_OnClick(self, button, down)
	if (QuestGuru_Settings.Sounds == nil) then return; end
	local sound = QuestGuru_Sounds[self.value];
	if ((string.sub(sound, -4) == ".wav") or (string.sub(sound, -4) == ".mp3")) then
		PlaySoundFile(sound);
	else
		PlaySound(sound);
	end
	UIDropDownMenu_SetText(QuestGuru_OptionsFrameSoundObjCompleteButton, sound);
	QuestGuru_Settings.Sounds.ObjComplete.Sound = sound;
end

function QuestGuru_OptionsFrameSoundQuestCompleteDropDown_Initialize()
	if (QuestGuru_Settings.Sounds == nil) then return; end
	local info = UIDropDownMenu_CreateInfo();
	info.func = QuestGuru_OptionsFrameSoundQuestComplete_OnClick;
	info.owner = QuestGuru_OptionsFrameSoundQuestCompleteButton;
	info.checked = nil;
	info.icon = nil;

	for i,v in ipairs(QuestGuru_Sounds) do
		info.text = v;
		info.value = i;
		if (v == QuestGuru_Settings.Sounds.QuestComplete.Sound) then
			info.checked = 1;
		else
			info.checked = nil;
		end
	    UIDropDownMenu_AddButton(info, 1);
	end
	UIDropDownMenu_SetText(QuestGuru_OptionsFrameSoundQuestCompleteButton, QuestGuru_Settings.Sounds.QuestComplete.Sound);
end

function QuestGuru_OptionsFrameSoundQuestComplete_OnClick(self, button, down)
	if (QuestGuru_Settings.Sounds == nil) then return; end
	local sound = QuestGuru_Sounds[self.value];
	if ((string.sub(sound, -4) == ".wav") or (string.sub(sound, -4) == ".mp3")) then
		PlaySoundFile(sound);
	else
		PlaySound(sound);
	end
	UIDropDownMenu_SetText(QuestGuru_OptionsFrameSoundQuestCompleteButton, sound);
	QuestGuru_Settings.Sounds.QuestComplete.Sound = sound;
end

do
	local temp, i;

---------------------
-- General Options --
---------------------
	QuestGuru_OptionsFrameGeneral = CreateFrame("FRAME", "QuestGuru_OptionsFrameGeneral", QuestGuru_OptionsFrame);
	QuestGuru_OptionsFrameGeneral.name = "QuestGuru";
	QuestGuru_OptionsFrameGeneral.default = function () QuestGuru_SetGeneralDefaults(); end;
	InterfaceOptions_AddCategory(QuestGuru_OptionsFrameGeneral);

	QuestGuru_OptionsFrameGeneralTitle = QuestGuru_OptionsFrameGeneral:CreateFontString("QuestGuru_OptionsFrameGeneralTitle", "ARTWORK", "GameFontNormalLarge");
	QuestGuru_OptionsFrameGeneralTitle:SetPoint("TOPLEFT", 16, -16);
	QuestGuru_OptionsFrameGeneralTitle:SetJustifyH("LEFT");
	QuestGuru_OptionsFrameGeneralTitle:SetJustifyV("TOP");
	QuestGuru_OptionsFrameGeneralTitle:SetText("QuestGuru "..QG_OPTIONS);

	QuestGuru_OptionsFrameGeneralSubText = QuestGuru_OptionsFrameGeneral:CreateFontString("QuestGuru_OptionsFrameGeneralSubText", "ARTWORK", "GameFontHighlightSmall");
	QuestGuru_OptionsFrameGeneralSubText:SetPoint("TOPLEFT", "QuestGuru_OptionsFrameGeneralTitle", "BOTTOMLEFT", 0, -8);
	QuestGuru_OptionsFrameGeneralSubText:SetPoint("RIGHT", -32, 0);
	QuestGuru_OptionsFrameGeneralSubText:SetJustifyH("LEFT");
	QuestGuru_OptionsFrameGeneralSubText:SetJustifyV("TOP");
	QuestGuru_OptionsFrameGeneralSubText:SetHeight(24);
	QuestGuru_OptionsFrameGeneralSubText:SetText(QG_OPT_OPTIONS_DESC);

	QuestGuru_OptionsFrameGeneralColorize = QuestGuru_OptionsFrameGeneral:CreateFontString("QuestGuru_OptionsFrameGeneralColorize", "OVERLAY", "GameFontHighlight");
	QuestGuru_OptionsFrameGeneralColorize:SetPoint("TOPLEFT", "QuestGuru_OptionsFrameGeneralSubText", "BOTTOMLEFT", -2, -8);
	QuestGuru_OptionsFrameGeneralColorize:SetText(QG_OPT_COLORIZE_HEAD);

	QuestGuru_OptionsFrameColorizePlayerNameToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameColorizePlayerNameToggle", QuestGuru_OptionsFrameGeneral, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameColorizePlayerNameToggle:SetPoint("TOPLEFT", "QuestGuru_OptionsFrameGeneralColorize", "BOTTOMLEFT", 0, -2);
	QuestGuru_OptionsFrameColorizePlayerNameToggleText:SetText(QG_OPT_COLORIZE_PLAYER);
	QuestGuru_OptionsFrameColorizePlayerNameToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameColorizePlayerNameToggle:GetChecked()) then
				QuestGuru_Settings.Colorize.PlayerName.Enabled = true;
			else
				QuestGuru_Settings.Colorize.PlayerName.Enabled = false;
			end
		end);
		
	QuestGuru_OptionsFrameColorizePlayerNameColor = CreateFrame("Button", "QuestGuru_OptionsFrameColorizePlayerNameColor", QuestGuru_OptionsFrameGeneral, "QuestGuru_ColorPickerButtonTemplate");
	QuestGuru_OptionsFrameColorizePlayerNameColor:SetPoint("LEFT", QuestGuru_OptionsFrameColorizePlayerNameToggle, "RIGHT", 80, 0);
	QuestGuru_OptionsFrameColorizePlayerNameColorSwatch:SetTexture(1.0, 1.0, 1.0, 1.0);
	QuestGuru_OptionsFrameColorizePlayerNameColor:SetScript("OnClick",
		function ()
			ColorPickerFrame.hasOpacity = false;
			ColorPickerFrame.func = QuestGuru_OptionsSaveColor;
			lastColorPick = "PlayerName";
			ColorPickerFrame:SetColorRGB(QuestGuru_Settings.Colorize.PlayerName.Color.r, QuestGuru_Settings.Colorize.PlayerName.Color.g, QuestGuru_Settings.Colorize.PlayerName.Color.b);
			ColorPickerFrame:Show();
			ColorPickerFrame:SetPoint("TOPLEFT", InterfaceOptionsFrame, "TOPRIGHT", -50, 0);
		end);

	QuestGuru_OptionsFrameColorizeAreaNamesToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameColorizeAreaNamesToggle", QuestGuru_OptionsFrameGeneral, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameColorizeAreaNamesToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameColorizePlayerNameToggle, "BOTTOMLEFT", 0, 0);
	QuestGuru_OptionsFrameColorizeAreaNamesToggleText:SetText(QG_OPT_COLORIZE_AREA);
	QuestGuru_OptionsFrameColorizeAreaNamesToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameColorizeAreaNamesToggle:GetChecked()) then
				QuestGuru_Settings.Colorize.AreaNames.Enabled = true;
			else
				QuestGuru_Settings.Colorize.AreaNames.Enabled = false;
			end
		end);
		
	QuestGuru_OptionsFrameColorizeAreaNamesColor = CreateFrame("Button", "QuestGuru_OptionsFrameColorizeAreaNamesColor", QuestGuru_OptionsFrameGeneral, "QuestGuru_ColorPickerButtonTemplate");
	QuestGuru_OptionsFrameColorizeAreaNamesColor:SetPoint("LEFT", QuestGuru_OptionsFrameColorizeAreaNamesToggle, "RIGHT", 80, 0);
	QuestGuru_OptionsFrameColorizeAreaNamesColorSwatch:SetTexture(1.0, 1.0, 1.0, 1.0);
	QuestGuru_OptionsFrameColorizeAreaNamesColor:SetScript("OnClick",
		function ()
			ColorPickerFrame.hasOpacity = false;
			ColorPickerFrame.func = QuestGuru_OptionsSaveColor;
			lastColorPick = "AreaNames";
			ColorPickerFrame:SetColorRGB(QuestGuru_Settings.Colorize.AreaNames.Color.r, QuestGuru_Settings.Colorize.AreaNames.Color.g, QuestGuru_Settings.Colorize.AreaNames.Color.b);
			ColorPickerFrame:Show();
			ColorPickerFrame:SetPoint("TOPLEFT", InterfaceOptionsFrame, "TOPRIGHT", -50, 0);
		end);

	QuestGuru_OptionsFrameColorizeNPCNamesToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameColorizeNPCNamesToggle", QuestGuru_OptionsFrameGeneral, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameColorizeNPCNamesToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameColorizeAreaNamesToggle, "BOTTOMLEFT", 0, 0);
	QuestGuru_OptionsFrameColorizeNPCNamesToggleText:SetText(QG_OPT_COLORIZE_NPC);
	QuestGuru_OptionsFrameColorizeNPCNamesToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameColorizeNPCNamesToggle:GetChecked()) then
				QuestGuru_Settings.Colorize.NPCNames.Enabled = true;
			else
				QuestGuru_Settings.Colorize.NPCNames.Enabled = false;
			end
		end);
		
	QuestGuru_OptionsFrameColorizeNPCNamesColor = CreateFrame("Button", "QuestGuru_OptionsFrameColorizeNPCNamesColor", QuestGuru_OptionsFrameGeneral, "QuestGuru_ColorPickerButtonTemplate");
	QuestGuru_OptionsFrameColorizeNPCNamesColor:SetPoint("LEFT", QuestGuru_OptionsFrameColorizeNPCNamesToggle, "RIGHT", 80, 0);
	QuestGuru_OptionsFrameColorizeNPCNamesColorSwatch:SetTexture(1.0, 1.0, 1.0, 1.0);
	QuestGuru_OptionsFrameColorizeNPCNamesColor:SetScript("OnClick",
		function ()
			ColorPickerFrame.hasOpacity = false;
			ColorPickerFrame.func = QuestGuru_OptionsSaveColor;
			lastColorPick = "NPCNames";
			ColorPickerFrame:SetColorRGB(QuestGuru_Settings.Colorize.NPCNames.Color.r, QuestGuru_Settings.Colorize.NPCNames.Color.g, QuestGuru_Settings.Colorize.NPCNames.Color.b);
			ColorPickerFrame:Show();
			ColorPickerFrame:SetPoint("TOPLEFT", InterfaceOptionsFrame, "TOPRIGHT", -50, 0);
		end);


	QuestGuru_OptionsFrameGeneralShowLevels = QuestGuru_OptionsFrameGeneral:CreateFontString("QuestGuru_OptionsFrameGeneralShowLevels", "OVERLAY", "GameFontHighlight");
	QuestGuru_OptionsFrameGeneralShowLevels:SetPoint("TOP", "QuestGuru_OptionsFrameGeneralSubText", "BOTTOM", 0, -8);
	QuestGuru_OptionsFrameGeneralShowLevels:SetPoint("LEFT", 200, 0);
	QuestGuru_OptionsFrameGeneralShowLevels:SetText(QG_OPT_LEVELS_HEAD);

	QuestGuru_OptionsFrameShowLevelsQuestLogToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameShowLevelsQuestLogToggle", QuestGuru_OptionsFrameGeneral, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameShowLevelsQuestLogToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameGeneralShowLevels, "BOTTOMLEFT", 0, -2);
	QuestGuru_OptionsFrameShowLevelsQuestLogToggleText:SetText(QG_OPT_LEVELS_QUESTLOG);
	QuestGuru_OptionsFrameShowLevelsQuestLogToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameShowLevelsQuestLogToggle:GetChecked()) then
				QuestGuru_Settings.ShowLevels.QuestLog = true;
			else
				QuestGuru_Settings.ShowLevels.QuestLog = false;
			end
			QuestLog_Update();
		end);

	QuestGuru_OptionsFrameShowLevelsAbandonToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameShowLevelsAbandonToggle", QuestGuru_OptionsFrameGeneral, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameShowLevelsAbandonToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameShowLevelsQuestLogToggle, "BOTTOMLEFT", 0, 0);
	QuestGuru_OptionsFrameShowLevelsAbandonToggleText:SetText(QG_OPT_LEVELS_ABANDON);
	QuestGuru_OptionsFrameShowLevelsAbandonToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameShowLevelsAbandonToggle:GetChecked()) then
				QuestGuru_Settings.ShowLevels.Abandon = true;
			else
				QuestGuru_Settings.ShowLevels.Abandon = false;
			end
			QuestGuru_UpdateAbandon();
		end);

	QuestGuru_OptionsFrameShowLevelsHistoryToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameShowLevelsHistoryToggle", QuestGuru_OptionsFrameGeneral, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameShowLevelsHistoryToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameShowLevelsAbandonToggle, "BOTTOMLEFT", 0, 0);
	QuestGuru_OptionsFrameShowLevelsHistoryToggleText:SetText(QG_OPT_LEVELS_HISTORY);
	QuestGuru_OptionsFrameShowLevelsHistoryToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameShowLevelsHistoryToggle:GetChecked()) then
				QuestGuru_Settings.ShowLevels.History = true;
			else
				QuestGuru_Settings.ShowLevels.History = false;
			end
			QuestGuru_UpdateHistory();
		end);

	QuestGuru_OptionsFrameShowTooltipTextToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameShowTooltipTextToggle", QuestGuru_OptionsFrameGeneral, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameShowTooltipTextToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameColorizeNPCNamesToggle, "BOTTOMLEFT", 0, -6);
	QuestGuru_OptionsFrameShowTooltipTextToggleText:SetText(QG_OPT_TOOLTIP_TEXT);
	QuestGuru_OptionsFrameShowTooltipTextToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameShowTooltipTextToggle:GetChecked()) then
				QuestGuru_Settings.TooltipText = true;
			else
				QuestGuru_Settings.TooltipText = false;
			end
		end);

	QuestGuru_OptionsFrameAutoCompleteToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameAutoCompleteToggle", QuestGuru_OptionsFrameGeneral, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameAutoCompleteToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameShowTooltipTextToggle, "BOTTOMLEFT", 0, -4);
	QuestGuru_OptionsFrameAutoCompleteToggleText:SetText(QG_OPT_AUTOCOMPLETE);
	QuestGuru_OptionsFrameAutoCompleteToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameAutoCompleteToggle:GetChecked()) then
				QuestGuru_Settings.AutoComplete = true;
			else
				QuestGuru_Settings.AutoComplete = false;
			end
		end);

	QuestGuru_OptionsFrameAltStatusToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameAltStatusToggle", QuestGuru_OptionsFrameGeneral, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameAltStatusToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameAutoCompleteToggle, "BOTTOMLEFT", 0, -4);
	QuestGuru_OptionsFrameAltStatusToggleText:SetText(QG_OPT_ALT_STATUS);
	QuestGuru_OptionsFrameAltStatusToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameAltStatusToggle:GetChecked()) then
				QuestGuru_Settings.ShowAltStatus = true;
			else
				QuestGuru_Settings.ShowAltStatus = false;
			end
		end);

	QuestGuru_OptionsFrameGuildStatusToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameGuildStatusToggle", QuestGuru_OptionsFrameGeneral, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameGuildStatusToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameAltStatusToggle, "BOTTOMLEFT", 0, 0);
	QuestGuru_OptionsFrameGuildStatusToggleText:SetText(QG_OPT_GUILD_STATUS);
	QuestGuru_OptionsFrameGuildStatusToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameGuildStatusToggle:GetChecked()) then
				QuestGuru_Settings.ShowGuildStatus = true;
			    QuestGuru_OptionsFrameSimpleGuildStatusToggle:Enable();
			else
				QuestGuru_Settings.ShowGuildStatus = false;
			    QuestGuru_OptionsFrameSimpleGuildStatusToggle:Disable();
			end
		end);

	QuestGuru_OptionsFrameSimpleGuildStatusToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameSimpleGuildStatusToggle", QuestGuru_OptionsFrameGeneral, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameSimpleGuildStatusToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameGuildStatusToggle, "BOTTOMLEFT", 24, 2);
	QuestGuru_OptionsFrameSimpleGuildStatusToggleText:SetText(QG_OPT_GUILD_SIMPLE);
	QuestGuru_OptionsFrameSimpleGuildStatusToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameSimpleGuildStatusToggle:GetChecked()) then
				QuestGuru_Settings.ShowSimpleGuildStatus = true;
			else
				QuestGuru_Settings.ShowSimpleGuildStatus = false;
			end
		end);
	QuestGuru_OptionsFrameSimpleGuildStatusToggle:SetScript("OnUpdate",
		function ()
			if (QuestGuru_OptionsFrameSimpleGuildStatusToggle:IsEnabled() == 1) then
				QuestGuru_OptionsFrameSimpleGuildStatusToggleText:SetTextColor(HIGHLIGHT_FONT_COLOR.r, HIGHLIGHT_FONT_COLOR.g, HIGHLIGHT_FONT_COLOR.b);
			else
				QuestGuru_OptionsFrameSimpleGuildStatusToggleText:SetTextColor(GRAY_FONT_COLOR.r, GRAY_FONT_COLOR.g, GRAY_FONT_COLOR.b);
			end
		end);

	QuestGuru_OptionsFrameShowObjItemIconsToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameShowObjItemIconsToggle", QuestGuru_OptionsFrameGeneral, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameShowObjItemIconsToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameSimpleGuildStatusToggle, "BOTTOMLEFT", -24, -4);
	QuestGuru_OptionsFrameShowObjItemIconsToggleText:SetText(QG_OPT_OBJ_ICON);
	QuestGuru_OptionsFrameShowObjItemIconsToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameShowObjItemIconsToggle:GetChecked()) then
				QuestGuru_Settings.ShowObjItemIcons = true;
			else
				QuestGuru_Settings.ShowObjItemIcons = false;
			end
			QuestLog_UpdateQuestDetails();
		end);

	QuestGuru_OptionsFrameShowWorldMapIconsToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameShowWorldMapIconsToggle", QuestGuru_OptionsFrameGeneral, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameShowWorldMapIconsToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameShowObjItemIconsToggle, "BOTTOMLEFT", -0, -4);
	QuestGuru_OptionsFrameShowWorldMapIconsToggleText:SetText(QG_OPT_WORLDMAP_ICON);
	QuestGuru_OptionsFrameShowWorldMapIconsToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameShowWorldMapIconsToggle:GetChecked()) then
				QuestGuru_Settings.ShowWorldMapIcons = true;
			else
				QuestGuru_Settings.ShowWorldMapIcons = false;
			end
		end);

	QuestGuru_OptionsFrameShowHeaderQuestsToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameShowHeaderQuestsToggle", QuestGuru_OptionsFrameGeneral, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameShowHeaderQuestsToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameShowWorldMapIconsToggle, "BOTTOMLEFT", -0, -4);
	QuestGuru_OptionsFrameShowHeaderQuestsToggleText:SetText(QG_OPT_HEADER_QUEST_NUM);
	QuestGuru_OptionsFrameShowHeaderQuestsToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameShowHeaderQuestsToggle:GetChecked()) then
				QuestGuru_Settings.HeaderQuests = true;
			else
				QuestGuru_Settings.HeaderQuests = false;
			end
			QuestLog_Update();
			if (IsAddOnLoaded("QuestGuru_History")) then QuestGuru_UpdateHistory(); end
		end);

	QuestGuru_OptionsFrameDisableCommToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameDisableCommToggle", QuestGuru_OptionsFrameGeneral, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameDisableCommToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameShowHeaderQuestsToggle, "BOTTOMLEFT", 0, -4);
	QuestGuru_OptionsFrameDisableCommToggleText:SetText(QG_OPT_DISABLE_COMM);
	QuestGuru_OptionsFrameDisableCommToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameDisableCommToggle:GetChecked()) then
				QuestGuru_Settings.DisableComm = true;
			else
				QuestGuru_Settings.DisableComm = false;
				QuestGuru_CommSendPGMessage("0001", QUESTGURU_VERSION);
				QuestGuru_SendCurrentQuestStatus(true);
			end
		end);
		

---------------------
-- Sound Options --
---------------------
	QuestGuru_OptionsFrameSound = CreateFrame("FRAME", "QuestGuru_OptionsFrameSound", QuestGuru_OptionsFrame);
	QuestGuru_OptionsFrameSound.name = "QG Sounds";
	QuestGuru_OptionsFrameSound.parent = "QuestGuru";
	QuestGuru_OptionsFrameSound.default = function () QuestGuru_SetSoundDefaults(); end;
	InterfaceOptions_AddCategory(QuestGuru_OptionsFrameSound)

	QuestGuru_OptionsFrameSoundTitle = QuestGuru_OptionsFrameSound:CreateFontString("QuestGuru_OptionsFrameSoundTitle", "ARTWORK", "GameFontNormalLarge");
	QuestGuru_OptionsFrameSoundTitle:SetPoint("TOPLEFT", 16, -16);
	QuestGuru_OptionsFrameSoundTitle:SetJustifyH("LEFT");
	QuestGuru_OptionsFrameSoundTitle:SetJustifyV("TOP");
	QuestGuru_OptionsFrameSoundTitle:SetText("QuestGuru "..QG_OPT_SOUND_HEAD);

	QuestGuru_OptionsFrameSoundSubText = QuestGuru_OptionsFrameSound:CreateFontString("QuestGuru_OptionsFrameSoundSubText", "ARTWORK", "GameFontHighlightSmall");
	QuestGuru_OptionsFrameSoundSubText:SetPoint("TOPLEFT", "QuestGuru_OptionsFrameSoundTitle", "BOTTOMLEFT", 0, -8);
	QuestGuru_OptionsFrameSoundSubText:SetPoint("RIGHT", -32, 0);
	QuestGuru_OptionsFrameSoundSubText:SetJustifyH("LEFT");
	QuestGuru_OptionsFrameSoundSubText:SetJustifyV("TOP");
	QuestGuru_OptionsFrameSoundSubText:SetHeight(24);
	QuestGuru_OptionsFrameSoundSubText:SetText(QG_OPT_SOUND_DESC);

	QuestGuru_OptionsFrameSoundToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameSoundToggle", QuestGuru_OptionsFrameSound, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameSoundToggle:SetPoint("TOPLEFT", "QuestGuru_OptionsFrameSoundSubText", "BOTTOMLEFT", -2, -8);
	QuestGuru_OptionsFrameSoundToggleText:SetText(QG_OPT_SOUND_ENABLE);
	QuestGuru_OptionsFrameSoundToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameSoundToggle:GetChecked()) then
				QuestGuru_Settings.Sounds.Enabled = true;
			else
				QuestGuru_Settings.Sounds.Enabled = false;
			end
		end);

	QuestGuru_OptionsFrameSoundProgressToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameSoundProgressToggle", QuestGuru_OptionsFrameSound, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameSoundProgressToggle:SetPoint("TOPLEFT", "QuestGuru_OptionsFrameSoundToggle", "BOTTOMLEFT", 0, -12);
	QuestGuru_OptionsFrameSoundProgressToggleText:SetText(QG_OPT_SOUND_OBJ);
	QuestGuru_OptionsFrameSoundProgressToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameSoundProgressToggle:GetChecked()) then
				QuestGuru_Settings.Sounds.Progress.Enabled = true;
			else
				QuestGuru_Settings.Sounds.Progress.Enabled = false;
			end
		end);

	QuestGuru_OptionsFrameSoundProgressButton = CreateFrame("Frame", "QuestGuru_OptionsFrameSoundProgressButton", QuestGuru_OptionsFrameSound, "UIDropDownMenuTemplate");
	QuestGuru_OptionsFrameSoundProgressButton:SetPoint("TOPLEFT", "QuestGuru_OptionsFrameSoundProgressToggle", "BOTTOMLEFT");
	QuestGuru_OptionsFrameSoundProgressButton:SetWidth(200);
	QuestGuru_OptionsFrameSoundProgressButtonText:SetJustifyH("LEFT");
	UIDropDownMenu_SetWidth(QuestGuru_OptionsFrameSoundProgressButton, 200);
	UIDropDownMenu_Initialize(QuestGuru_OptionsFrameSoundProgressButton, QuestGuru_OptionsFrameSoundProgressDropDown_Initialize);

	QuestGuru_OptionsFrameSoundObjCompleteToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameSoundObjCompleteToggle", QuestGuru_OptionsFrameSound, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameSoundObjCompleteToggle:SetPoint("TOPLEFT", "QuestGuru_OptionsFrameSoundProgressToggle", "BOTTOMLEFT", 0, -48);
	QuestGuru_OptionsFrameSoundObjCompleteToggleText:SetText(QG_OPT_SOUND_OBJ_DONE);
	QuestGuru_OptionsFrameSoundObjCompleteToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameSoundObjCompleteToggle:GetChecked()) then
				QuestGuru_Settings.Sounds.ObjComplete.Enabled = true;
			else
				QuestGuru_Settings.Sounds.ObjComplete.Enabled = false;
			end
		end);

	QuestGuru_OptionsFrameSoundObjCompleteButton = CreateFrame("Frame", "QuestGuru_OptionsFrameSoundObjCompleteButton", QuestGuru_OptionsFrameSound, "UIDropDownMenuTemplate");
	QuestGuru_OptionsFrameSoundObjCompleteButton:SetPoint("TOPLEFT", "QuestGuru_OptionsFrameSoundObjCompleteToggle", "BOTTOMLEFT");
	QuestGuru_OptionsFrameSoundObjCompleteButton:SetWidth(200);
	QuestGuru_OptionsFrameSoundObjCompleteButtonText:SetJustifyH("LEFT");
	UIDropDownMenu_SetWidth(QuestGuru_OptionsFrameSoundObjCompleteButton, 200);
	UIDropDownMenu_Initialize(QuestGuru_OptionsFrameSoundObjCompleteButton, QuestGuru_OptionsFrameSoundObjCompleteDropDown_Initialize);

	QuestGuru_OptionsFrameSoundQuestCompleteToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameSoundQuestCompleteToggle", QuestGuru_OptionsFrameSound, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameSoundQuestCompleteToggle:SetPoint("TOPLEFT", "QuestGuru_OptionsFrameSoundObjCompleteToggle", "BOTTOMLEFT", 0, -48);
	QuestGuru_OptionsFrameSoundQuestCompleteToggleText:SetText(QG_SOUND_QUEST_DONE);
	QuestGuru_OptionsFrameSoundQuestCompleteToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameSoundQuestCompleteToggle:GetChecked()) then
				QuestGuru_Settings.Sounds.QuestComplete.Enabled = true;
			else
				QuestGuru_Settings.Sounds.QuestComplete.Enabled = false;
			end
		end);

	QuestGuru_OptionsFrameSoundQuestCompleteButton = CreateFrame("Frame", "QuestGuru_OptionsFrameSoundQuestCompleteButton", QuestGuru_OptionsFrameSound, "UIDropDownMenuTemplate");
	QuestGuru_OptionsFrameSoundQuestCompleteButton:SetPoint("TOPLEFT", "QuestGuru_OptionsFrameSoundQuestCompleteToggle", "BOTTOMLEFT");
	QuestGuru_OptionsFrameSoundQuestCompleteButton:SetWidth(200);
	QuestGuru_OptionsFrameSoundQuestCompleteButtonText:SetJustifyH("LEFT");
	UIDropDownMenu_SetWidth(QuestGuru_OptionsFrameSoundQuestCompleteButton, 200);
	UIDropDownMenu_Initialize(QuestGuru_OptionsFrameSoundQuestCompleteButton, QuestGuru_OptionsFrameSoundQuestCompleteDropDown_Initialize);
end

function QuestGuru_OptionsSaveColor()
	local r,g,b = ColorPickerFrame:GetColorRGB();

	QuestGuru_Settings.Colorize[lastColorPick].Color.r = r;
	QuestGuru_Settings.Colorize[lastColorPick].Color.g = g;
	QuestGuru_Settings.Colorize[lastColorPick].Color.b = b;
	QuestGuru_OptionsFrameColorizePlayerNameColorSwatch:SetTexture(QuestGuru_Settings.Colorize.PlayerName.Color.r, QuestGuru_Settings.Colorize.PlayerName.Color.g, QuestGuru_Settings.Colorize.PlayerName.Color.b, 1.0);
	QuestGuru_OptionsFrameColorizeAreaNamesColorSwatch:SetTexture(QuestGuru_Settings.Colorize.AreaNames.Color.r, QuestGuru_Settings.Colorize.AreaNames.Color.g, QuestGuru_Settings.Colorize.AreaNames.Color.b, 1.0);
	QuestGuru_OptionsFrameColorizeNPCNamesColorSwatch:SetTexture(QuestGuru_Settings.Colorize.NPCNames.Color.r, QuestGuru_Settings.Colorize.NPCNames.Color.g, QuestGuru_Settings.Colorize.NPCNames.Color.b, 1.0);
end

function QuestGuru_OptionsSoundsLoadSettings()
	if (QuestGuru_Settings.Sounds == nil) then
		QuestGuru_Settings.Sounds = {};
	end
	if (QuestGuru_Settings.Sounds.Enabled ~= false) then
		QuestGuru_Settings.Sounds.Enabled = true;
	end
	QuestGuru_OptionsFrameSoundToggle:SetChecked(QuestGuru_Settings.Sounds.Enabled);
	
	if (QuestGuru_Settings.Sounds.Progress == nil) then
		QuestGuru_Settings.Sounds.Progress = {};
	end
	if (QuestGuru_Settings.Sounds.Progress.Enabled ~= false) then
		QuestGuru_Settings.Sounds.Progress.Enabled = true;
	end
	QuestGuru_OptionsFrameSoundProgressToggle:SetChecked(QuestGuru_Settings.Sounds.Progress.Enabled);
	if (QuestGuru_Settings.Sounds.Progress.Sound == nil) then
		QuestGuru_Settings.Sounds.Progress.Sound = "AuctionWindowOpen";
	end
	UIDropDownMenu_SetText(QuestGuru_OptionsFrameSoundProgressButton, QuestGuru_Settings.Sounds.Progress.Sound);

	if (QuestGuru_Settings.Sounds.ObjComplete == nil) then
		QuestGuru_Settings.Sounds.ObjComplete = {};
	end
	if (QuestGuru_Settings.Sounds.ObjComplete.Enabled ~= false) then
		QuestGuru_Settings.Sounds.ObjComplete.Enabled = true;
	end
	QuestGuru_OptionsFrameSoundObjCompleteToggle:SetChecked(QuestGuru_Settings.Sounds.ObjComplete.Enabled);
	if (QuestGuru_Settings.Sounds.ObjComplete.Sound == nil) then
		QuestGuru_Settings.Sounds.ObjComplete.Sound = "AuctionWindowClose";
	end
	UIDropDownMenu_SetText(QuestGuru_OptionsFrameSoundObjCompleteButton, QuestGuru_Settings.Sounds.ObjComplete.Sound);

	if (QuestGuru_Settings.Sounds.QuestComplete == nil) then
		QuestGuru_Settings.Sounds.QuestComplete = {};
	end
	if (QuestGuru_Settings.Sounds.QuestComplete.Enabled ~= false) then
		QuestGuru_Settings.Sounds.QuestComplete.Enabled = true;
	end
	QuestGuru_OptionsFrameSoundQuestCompleteToggle:SetChecked(QuestGuru_Settings.Sounds.QuestComplete.Enabled);
	if (QuestGuru_Settings.Sounds.QuestComplete.Sound == nil) then
		QuestGuru_Settings.Sounds.QuestComplete.Sound = "ReadyCheck";
	end
	UIDropDownMenu_SetText(QuestGuru_OptionsFrameSoundQuestCompleteButton, QuestGuru_Settings.Sounds.QuestComplete.Sound);
end

function QuestGuru_SetGeneralDefaults()
	QuestGuru_Echo("Resetting General settings to defaults.");
	QuestGuru_Settings.AutoComplete = false;
	QuestGuru_OptionsFrameAutoCompleteToggle:SetChecked(QuestGuru_Settings.AutoComplete);
	QuestGuru_Settings.ShowObjItemIcons = false;
	QuestGuru_OptionsFrameShowObjItemIconsToggle:SetChecked(QuestGuru_Settings.ShowObjItemIcons);
	QuestGuru_Settings.ShowWorldMapIcons = true;
	QuestGuru_OptionsFrameShowWorldMapIconsToggle:SetChecked(QuestGuru_Settings.ShowWorldMapIcons);
	QuestGuru_Settings.TooltipText = true;
	QuestGuru_OptionsFrameShowTooltipTextToggle:SetChecked(QuestGuru_Settings.TooltipText);
	QuestGuru_Settings.DisableComm = false;
	QuestGuru_OptionsFrameDisableCommToggle:SetChecked(QuestGuru_Settings.DisableComm);
	QuestGuru_Settings.HeaderQuests = true;
	QuestGuru_OptionsFrameShowHeaderQuestsToggle:SetChecked(QuestGuru_Settings.HeaderQuests);
	QuestGuru_Settings.ShowAltStatus = true;
	QuestGuru_OptionsFrameAltStatusToggle:SetChecked(QuestGuru_Settings.ShowAltStatus);
	QuestGuru_Settings.ShowGuildStatus = true;
	QuestGuru_OptionsFrameGuildStatusToggle:SetChecked(QuestGuru_Settings.ShowGuildStatus);
	QuestGuru_OptionsFrameSimpleGuildStatusToggle:Enable();
	QuestGuru_Settings.ShowSimpleGuildStatus = false;
	QuestGuru_OptionsFrameSimpleGuildStatusToggle:SetChecked(QuestGuru_Settings.ShowSimpleGuildStatus);
	QuestGuru_Settings.ShowLevels = {};
	QuestGuru_Settings.ShowLevels.QuestLog = true;
	QuestGuru_OptionsFrameShowLevelsQuestLogToggle:SetChecked(QuestGuru_Settings.ShowLevels.QuestLog);
	QuestGuru_Settings.ShowLevels.History = true;
	QuestGuru_OptionsFrameShowLevelsHistoryToggle:SetChecked(QuestGuru_Settings.ShowLevels.History);
	QuestGuru_Settings.ShowLevels.Abandon = true;
	QuestGuru_OptionsFrameShowLevelsAbandonToggle:SetChecked(QuestGuru_Settings.ShowLevels.Abandon);
	QuestGuru_Settings.Colorize = {};
	QuestGuru_Settings.Colorize.PlayerName = {};
	QuestGuru_Settings.Colorize.PlayerName.Enabled = true;
	QuestGuru_OptionsFrameColorizePlayerNameToggle:SetChecked(QuestGuru_Settings.Colorize.PlayerName.Enabled);
	QuestGuru_Settings.Colorize.PlayerName.Color = { r=0, g=0.4, b=0.8 };
	QuestGuru_OptionsFrameColorizePlayerNameColorSwatch:SetTexture(QuestGuru_Settings.Colorize.PlayerName.Color.r, QuestGuru_Settings.Colorize.PlayerName.Color.g, QuestGuru_Settings.Colorize.PlayerName.Color.b, 1.0);
	QuestGuru_Settings.Colorize.AreaNames = {};
	QuestGuru_Settings.Colorize.AreaNames.Enabled = true;
	QuestGuru_OptionsFrameColorizeAreaNamesToggle:SetChecked(QuestGuru_Settings.Colorize.AreaNames.Enabled);
	QuestGuru_Settings.Colorize.AreaNames.Color = { r=0, g=0.4, b=0.8 };
	QuestGuru_OptionsFrameColorizeAreaNamesColorSwatch:SetTexture(QuestGuru_Settings.Colorize.AreaNames.Color.r, QuestGuru_Settings.Colorize.AreaNames.Color.g, QuestGuru_Settings.Colorize.AreaNames.Color.b, 1.0);
	QuestGuru_Settings.Colorize.NPCNames = {};
	QuestGuru_Settings.Colorize.NPCNames.Enabled = true;
	QuestGuru_OptionsFrameColorizeNPCNamesToggle:SetChecked(QuestGuru_Settings.Colorize.NPCNames.Enabled);
	QuestGuru_Settings.Colorize.NPCNames.Color = { r=0, g=0.4, b=0.8 };
	QuestGuru_OptionsFrameColorizeNPCNamesColorSwatch:SetTexture(QuestGuru_Settings.Colorize.NPCNames.Color.r, QuestGuru_Settings.Colorize.NPCNames.Color.g, QuestGuru_Settings.Colorize.NPCNames.Color.b, 1.0);
	QuestLog_Update();
end

function QuestGuru_SetSoundDefaults()
	QuestGuru_Echo("Resetting Sound settings to defaults.");
	QuestGuru_Settings.Sounds.Progress.Enabled = true;
	QuestGuru_Settings.Sounds.QuestComplete.Sound = "ReadyCheck";
	QuestGuru_Settings.Sounds.ObjComplete.Sound = "AuctionWindowClose";
	QuestGuru_Settings.Sounds.Progress.Sound = "AuctionWindowOpen";
end