QuestGuru_Abandon = {};
QuestGuru_AbandonHeaders = {};
QuestGuru_numAbandoned = 0;
QuestGuru_currAbandon = 2;
QuestGuru_LastAbandonQuest = {};

StaticPopupDialogs["QUESTGURU_CLEARABANDON"] = {
  text = QG_ABANDON_CLEAR,
  button1 = YES,
  button2 = NO,
  OnAccept = function()
      QuestGuru_Abandon = {};
      QuestGuru_UpdateAbandon();
  end,
  timeout = 0,
  whileDead = 1,
  hideOnEscape = 1
};

StaticPopupDialogs["QUESTGURU_DELETEABANDONTITLE"] = {
  text = QG_ABANDON_DELETE,
  button1 = YES,
  button2 = NO,
  OnAccept = function()
	local qhTitle = getglobal("QuestGuru_QuestAbandonTitle"..QuestGuru_currAbandon - FauxScrollFrame_GetOffset(QuestGuru_QuestAbandonListScrollFrame));
	local i, qH;
   	for i, qH in ipairs(QuestGuru_Abandon) do
   		if (qH.qID == qhTitle.qID) then
   			tremove(QuestGuru_Abandon, i)
			QuestGuru_Quests[QuestGuru_RealmName][qH.qID][QuestGuru_Player] = nil;
			break;
		end
	end
	QuestGuru_UpdateAbandon();
  end,
  timeout = 0,
  whileDead = 1,
  hideOnEscape = 1
};

function QuestGuru_AbandonTabClick()
	local scrollOffset = FauxScrollFrame_GetOffset(QuestGuru_QuestAbandonListScrollFrame)
	local n = QuestGuru_currAbandon - scrollOffset;
	if ((n > 0) and (n <= QUESTGURU_QUESTS_DISPLAYED)) then
		getglobal("QuestGuru_QuestAbandonTitle"..n):Click();
	end
end

function QuestGuru_AbandonTabExpand()
	local i, qH;
	local collapsed=true;

	for i, qH in ipairs(QuestGuru_Abandon) do
		if (QuestGuru_AbandonHeaders[qH.Header]) then collapsed=false; end
	end
	if (collapsed) then
		for i, qH in ipairs(QuestGuru_Abandon) do
			QuestGuru_AbandonHeaders[qH.Header] = true;
		end
		QuestLog_SetAbandonSelection(2);
	else
		for i, qH in ipairs(QuestGuru_Abandon) do
			QuestGuru_AbandonHeaders[qH.Header] = false;
		end
		QuestLog_SetAbandonSelection(0);
	end
	FauxScrollFrame_SetOffset(QuestGuru_QuestAbandonListScrollFrame, 0);
	QuestGuru_UpdateAbandon();
end

function QuestGuru_QuestAbandonTitleMenu_OnLoad()
	local info = UIDropDownMenu_CreateInfo();
	info.func = QuestGuru_QuestAbandonTitleMenu_OnClick;
	info.checked = nil;
	info.icon = nil;

	info.text = QG_DELETE_QUEST;
	info.value = "delete";
	UIDropDownMenu_AddButton(info, 1);

	info.text = "-----------------";
	info.value = "-";
	info.isTitle = 1;
	UIDropDownMenu_AddButton(info, 1);

	info = UIDropDownMenu_CreateInfo();
	info.func = QuestGuru_QuestAbandonTitleMenu_OnClick;
	info.checked = nil;
	info.icon = nil;
	info.text = CANCEL;
	info.value = "cancel";
	UIDropDownMenu_AddButton(info, 1);

end

function QuestGuru_QuestAbandonTitleMenu_OnClick()
	local qhTitle = getglobal("QuestGuru_QuestAbandonTitle"..QuestGuru_currAbandon - FauxScrollFrame_GetOffset(QuestGuru_QuestAbandonListScrollFrame));
	if (this.value == "delete") then
		StaticPopup_Show("QUESTGURU_DELETEABANDONTITLE", qhTitle:GetText());
	end
end

function QuestGuru_QuestAbandonTitleButton_OnLoad(self)
	self:RegisterForClicks("LeftButtonUp", "RightButtonUp");
	self:RegisterEvent("UNIT_QUEST_LOG_CHANGED");
	self:RegisterEvent("PARTY_MEMBER_ENABLE");
	self:RegisterEvent("PARTY_MEMBER_DISABLE");
end

function QuestGuru_QuestAbandonTitleButton_OnEvent(self, event, ...)
	if ( GameTooltip:IsOwned(self) ) then
		GameTooltip:Hide();
	end
end

function QuestGuru_QuestAbandonTitleButton_OnClick(self, button, down)
	local questName = self:GetText();
	local questIndex = self:GetID() + FauxScrollFrame_GetOffset(QuestGuru_QuestAbandonListScrollFrame);
	
	QuestLog_SetAbandonSelection(questIndex)
	if (button == "LeftButton") then
		if ( IsShiftKeyDown() ) then
			-- If header then return
			if ( self.isHeader ) then
				return;
			end
			-- Otherwise try to put it into chat
			local activeWindow = ChatEdit_GetActiveWindow();
			if ( activeWindow ) then
				local n, qH, currHead;
				local c = 0;
				for n, qH in ipairs(QuestGuru_Abandon) do
					if (qH.Header ~= currHead) then
						currHead = qH.Header;
						c = c + 1;
					end
					if (QuestGuru_AbandonHeaders[currHead] ~= false) then
						c = c + 1;
					end
					if (c == questIndex) then
					    if (QuestGuru_Abandon[n].Link) then
					        activeWindow:Insert(QuestGuru_Abandon[n].Link);
						else
							activeWindow:Insert(strtrim("["..QuestGuru_Abandon[n].Level.."] "..QuestGuru_Abandon[n].Title));
						end
					end
				end
			end
		end
	elseif (button == "RightButton") then
		ToggleDropDownMenu(1, nil, QuestGuru_QuestAbandonTitleMenu, self:GetName(), 0, 0)
	end	
	QuestGuru_UpdateAbandon();
end

function QuestGuru_QuestAbandonTitleButton_OnEnter(self, motion)
	-- Set highlight
	getglobal(self:GetName().."Tag"):SetTextColor(HIGHLIGHT_FONT_COLOR.r, HIGHLIGHT_FONT_COLOR.g, HIGHLIGHT_FONT_COLOR.b);
	getglobal(self:GetName().."Level"):SetTextColor(HIGHLIGHT_FONT_COLOR.r, HIGHLIGHT_FONT_COLOR.g, HIGHLIGHT_FONT_COLOR.b);

	-- Set group info tooltip
	QuestGuru_UpdateAbandonPartyInfoTooltip();
end

function QuestGuru_UpdateAbandonPartyInfoTooltip()
	if (not QuestGuru_Settings.ShowAltStatus) then return; end
	if (this.isHeader) then return; end

	local index = this:GetID() + FauxScrollFrame_GetOffset(QuestGuru_QuestAbandonListScrollFrame);
	GameTooltip_SetDefaultAnchor(GameTooltip, this);
	
	local lastHeader = "";
	local altOnQuest;
	for i, questAbandon in ipairs(QuestGuru_Abandon) do
		if (questAbandon.Header ~= lastHeader) then
			lastHeader = questAbandon.Header;
			index = index - 1;
		end
		if (not QuestGuru_AbandonHeaders[questAbandon.Header]) then
			index = index + 1;
		end
		if (i == index) then
			local questTitleText = questAbandon.Title;
			GameTooltip:SetText(questTitleText);

			local i, v;
			local questDescription = questAbandon.Description;
			local questObjectives = questAbandon.ObjectiveText;
			local qID = this.qID;
	
			if (QuestGuru_Quests[QuestGuru_RealmName][qID] ~= nil) then
				for i, v in pairs(QuestGuru_Quests[QuestGuru_RealmName][qID]) do
					if (string.find(i, "~") and (i ~= "~"..QuestGuru_Player)) then
						if (not altOnQuest) then
							GameTooltip:AddLine(QG_ALT_STATUS_HEAD);
							altOnQuest = true;
						end
						if (v == "Complete") then
							GameTooltip:AddDoubleLine(string.sub(i,2), COMPLETE, 1, 1, 1, 0, 1, 0);
						elseif (v == "Abandoned") then
							GameTooltip:AddDoubleLine(string.sub(i,2), QG_ABANDONED, 1, 1, 1, 1, 0, 0);
						else
							GameTooltip:AddDoubleLine(string.sub(i,2), QG_ACTIVE, 1, 1, 1, 0, 1, 1);
							local currStatus = { strsplit(";", v) };

							local numObjectives = questAbandon.Objectives;
			
							if (numObjectives ~= nil) then
								for j=1, numObjectives, 1 do
									local text = questAbandon.Objective[j].Description;
									local type = questAbandon.Objective[j].Type;
				
									if (type == "item") then
										local numNeeded = questAbandon.Objective[j].numNeeded;
										GameTooltip:AddDoubleLine("  - "..text, currStatus[j+1].."/"..numNeeded, 1, 1, 1, 1, 1, 1);
									elseif (type == "monster") then
										local x, y, name, numItems, numNeeded = string.find(text, QG_ITEM_REQ_STR);
										GameTooltip:AddDoubleLine("  - "..name, currStatus[j+1].."/"..numNeeded, 1, 1, 1, 1, 1, 1);
									else
										if (currStatus[j+1] == 1) then
											GameTooltip:AddDoubleLine("  - "..text, COMPLETE, 1, 1, 1, 0, 1, 0);
										else
											GameTooltip:AddDoubleLine("  - "..text, QG_INCOMPLETE, 1, 1, 1, 1, 0, 0);
										end
									end
								end
							end
						end
					end
				end
			end
		end
	end
	if (altOnQuest) then
		GameTooltip:Show();
	else
		GameTooltip:Hide();
	end
end

function QuestGuru_QuestAbandonStart_OnClick(self, button, down)
	local scrollOffset = FauxScrollFrame_GetOffset(QuestGuru_QuestAbandonListScrollFrame);
	local questTitle = getglobal("QuestGuru_QuestAbandonTitle"..QuestGuru_currAbandon - scrollOffset);
	local qID;
	if (not questTitle) then
		local n, qH, currHead;
		local c = 0;
		for n, qH in ipairs(QuestGuru_Abandon) do
			if (qH.Header ~= currHead) then
				currHead = qH.Header;
				c = c + 1;
			end
			if (QuestGuru_AbandonHeaders[currHead] ~= false) then
				c = c + 1;
			end
			if (c == QuestGuru_currAbandon) then
				qID = qH.qID;
			end
		end
	else
		qID = questTitle.qID;
	end
	if (not qID) then return; end
	for i, questAbandon in ipairs(QuestGuru_Abandon) do
		if (questAbandon.qID == qID) then
			if (questAbandon.Daily == 1) then
				QuestGuru_WorldmapIconTexture:SetTexCoord(0.375, 0.5, 0.5, 1);
			else
				QuestGuru_WorldmapIconTexture:SetTexCoord(0.125, 0.25, 0.5, 1);
			end
			QuestGuru_ShowMap(questAbandon.StartNPCZone, questAbandon.StartPosX, questAbandon.StartPosY, questAbandon.StartNPCName, questAbandon.Title);
		end
	end
end

function QuestGuru_QuestAbandonStart_OnEnter(self, motion)
	local tempWidth, maxWidth;
	local scrollOffset = FauxScrollFrame_GetOffset(QuestGuru_QuestAbandonListScrollFrame);
	local questTitle = getglobal("QuestGuru_QuestAbandonTitle"..QuestGuru_currAbandon - scrollOffset);
	local qID;
	if (not questTitle) then
		local n, qH, currHead;
		local c = 0;
		for n, qH in ipairs(QuestGuru_Abandon) do
			if (qH.Header ~= currHead) then
				currHead = qH.Header;
				c = c + 1;
			end
			if (QuestGuru_AbandonHeaders[currHead] ~= false) then
				c = c + 1;
			end
			if (c == QuestGuru_currAbandon) then
				qID = qH.qID;
			end
		end
	else
		qID = questTitle.qID;
	end
	if (not qID) then return; end

	local NPCColor, AreaColor;
	if (QuestGuru_Settings.Colorize.NPCNames.Enabled) then
		NPCColor = QuestGuru_Settings.Colorize.NPCNames.Color;
	else
		NPCColor = { r=0, g=0, b=0 };
	end
	if (QuestGuru_Settings.Colorize.AreaNames.Enabled) then
		AreaColor = QuestGuru_Settings.Colorize.AreaNames.Color;
	else
		AreaColor = { r=0, g=0, b=0 };
	end
	local i, questHistory;

	for i, questAbandon in ipairs(QuestGuru_Abandon) do
		if (questAbandon.qID == qID) then
			QuestGuru_QuestStartInfoFrame:ClearAllPoints();
			QuestGuru_QuestStartInfoFrame:SetPoint("BOTTOM", QuestGuru_QuestAbandonStart, "TOP");
			QuestGuru_QuestStartInfoTitle:SetText(QG_QSTART_HEAD);
			maxWidth = QuestGuru_QuestStartInfoTitle:GetWidth();

			QuestGuru_QuestStartInfoNPC:SetText(questAbandon.StartNPCName);
			QuestGuru_QuestStartInfoNPC:SetTextColor(NPCColor.r, NPCColor.g, NPCColor.b);

			QuestGuru_QuestStartInfoPOS:SetText("("..questAbandon.StartPosX..","..questAbandon.StartPosY..")");
			QuestGuru_QuestStartInfoPOS:SetTextColor(AreaColor.r, AreaColor.g, AreaColor.b);
			tempWidth = QuestGuru_QuestStartInfoNPC:GetWidth() + QuestGuru_QuestStartInfoPOS:GetWidth() + 8;
			if (tempWidth > maxWidth) then maxWidth = tempWidth; end

			QuestGuru_QuestStartInfoArea:SetText(questAbandon.StartNPCZone);
			QuestGuru_QuestStartInfoArea:SetTextColor(AreaColor.r, AreaColor.g, AreaColor.b);
			tempWidth = QuestGuru_QuestStartInfoArea:GetWidth();
			if (tempWidth > maxWidth) then maxWidth = tempWidth; end

			QuestGuru_QuestStartInfoTimeLabel:SetText(QG_QSTART_TIME);
			QuestGuru_QuestStartInfoTime:SetText(questAbandon.StartTime);
			tempWidth = QuestGuru_QuestStartInfoTimeLabel:GetWidth() + QuestGuru_QuestStartInfoTime:GetWidth() + 8;
			if (tempWidth > maxWidth) then maxWidth = tempWidth; end

			QuestGuru_QuestStartInfoLevelLabel:SetText(QG_QSTART_LEVEL);
			QuestGuru_QuestStartInfoLevel:SetText(questAbandon.StartLevel);
			tempWidth = QuestGuru_QuestStartInfoLevelLabel:GetWidth() + QuestGuru_QuestStartInfoLevel:GetWidth() + 8;
			if (tempWidth > maxWidth) then maxWidth = tempWidth; end

			QuestGuru_QuestStartInfoFrame:SetWidth(maxWidth + 18);
			QuestGuru_QuestStartInfoFrame:Show();
		end
	end
end

function QuestGuru_QuestAbandonFinish_OnEnter(self, motion)
--	local questName = QuestGuru_QuestAbandonQuestTitle:GetText();
--	local NPCColor = QuestGuru_Settings.Colorize.NPCNames.Color;
--	local AreaColor = QuestGuru_Settings.Colorize.AreaNames.Color;
--	local i, questHistory;

--	for i, questAbandon in ipairs(QuestGuru_Abandon) do
--		if (questAbandon.Title == questName) then
--			GameTooltip:Hide();
--			GameTooltip:ClearLines();
--			GameTooltip:SetOwner(self,"ANCHOR_CURSOR");
--			GameTooltip:AddLine("Quest Abandon Details",1,1,1);
--			GameTooltip:AddDoubleLine("Abandoned on:",questAbandon.FinishTime,1,1,1);
--			GameTooltip:AddDoubleLine("Abandoned at level:",questAbandon.FinishLevel,1,1,1);
--			GameTooltip:Show();
--		end
--	end
end

function QuestGuru_SaveAbandon()
	local inserted = false;
	local i, qH;
	local qLinki, qLinkj, qLinkNum;
	
	if (QuestGuru_LastAbandonQuest.Level == nil) then
		return;
	end
	if (QuestGuru_LastAbandonQuest.Title ~= nil) then
		for i, qH in ipairs(QuestGuru_Abandon) do
			if (qH.Header == QuestGuru_LastAbandonQuest.Header) then
				if (qH.Level == QuestGuru_LastAbandonQuest.Level) then
					if (qH.qID == qID) then
						if (qH.Count == nil) then qH.Count = 1; end
						qH.Count = qH.Count + 1;
						inserted = true;
						break;
					end
					if (qH.Title > QuestGuru_LastAbandonQuest.Title) then
						tinsert(QuestGuru_Abandon, i, QuestGuru_LastAbandonQuest);
						inserted = true;
						break;
					end
				elseif (qH.Level > QuestGuru_LastAbandonQuest.Level) then
					tinsert(QuestGuru_Abandon, i, QuestGuru_LastAbandonQuest);
					inserted = true;
					break;
				end
			elseif (qH.Header > QuestGuru_LastAbandonQuest.Header) then
				tinsert(QuestGuru_Abandon, i, QuestGuru_LastAbandonQuest);
				inserted = true;
				break;
			end
			if (inserted == true) then
				qLinki, qLinkj, qLinkNum = string.find(qH.Link, (":(%d+):"));
			end
		end
		if (not inserted) then
			tinsert(QuestGuru_Abandon, QuestGuru_LastAbandonQuest);
			inserted = true;
		end
		QuestGuru_QuestStart[QuestGuru_LastAbandonQuest.Title] = nil;
	end
	QuestGuru_LastAbandonQuest = {};
	QuestGuru_UpdateAbandon();
	if (qLinkNum) then
		QuestGuru_CommSendPGMessage("010C", qLinkNum);
	end
end
hooksecurefunc("AbandonQuest", QuestGuru_SaveAbandon);

function QuestGuru_SaveAbandonQuest()
	if (QuestGuru_LastAbandonQuest.Link == nil) then return; end
	local lastHeader;
	local numEntries, numQuests = GetNumQuestLogEntries();
	local i, j;
	local lqi, lqj, lqNum = string.find(QuestGuru_LastAbandonQuest.Link, (":(%d+):"));
	if (not lqNum) then return; end

	local prevQuestLogEntry = GetQuestLogSelection();
	for i=1, numEntries do
		local qLink = GetQuestLink(i);
		local qi, qj, qNum;
		if (qLink) then
			qi, qj, qNum = string.find(qLink, (":(%d+):"));
		end
		local questTitle, level, questTag, suggestedGroup, isHeader, isCollapsed, isComplete, isDaily = GetQuestLogTitle(i);
		if (isHeader) then
			QuestGuru_LastAbandonQuest.Header = questTitle;
		elseif (qNum == lqNum) then
			SelectQuestLogEntry(i);
			QuestGuru_LastAbandonQuest.Title = questTitle;
			QuestGuru_LastAbandonQuest.Level = level;
			QuestGuru_LastAbandonQuest.qID = qNum;
			QuestGuru_LastAbandonQuest.Tag = questTag;
			QuestGuru_LastAbandonQuest.SuggestedGroup = suggestedGroup;
			QuestGuru_LastAbandonQuest.Daily = isDaily;
			if (QuestGuru_LastAbandonQuest.Daily == 1) then
				QuestGuru_LastAbandonQuest.Count = 1;
			end

			QuestGuru_LastAbandonQuest.FinishTime = date(QG_DATETIME);
			QuestGuru_LastAbandonQuest.FinishLevel = UnitLevel("player");
			SetMapToCurrentZone();
			local player_x, player_y = GetPlayerMapPosition("player");
			QuestGuru_LastAbandonQuest.FinishPosX = floor(player_x * 10000) / 100;
			QuestGuru_LastAbandonQuest.FinishPosY = floor(player_y * 10000) / 100;

			if (not UnitName("npc") or UnitIsPlayer("npc")) then
				QuestGuru_LastAbandonQuest.FinishNPCName = QG_UNKNOWN;
				QuestGuru_LastAbandonQuest.FinishNPCZone = QG_UNKNOWN;
			else
				QuestGuru_LastAbandonQuest.FinishNPCName = UnitName("npc");
				local mmzText = GetMinimapZoneText();
				local zText = GetRealZoneText();
				if (mmzText == zText) then
					QuestGuru_LastAbandonQuest.FinishNPCZone = zText;
				else
					QuestGuru_LastAbandonQuest.FinishNPCZone = mmzText .. ", " .. zText;
				end
			end

			if (QuestGuru_QuestStart[questTitle] == nil) then
				QuestGuru_QuestStart[questTitle] = {};
				QuestGuru_QuestStart[questTitle].StartTime = date(QG_DATETIME);
				QuestGuru_QuestStart[questTitle].NPCName = QG_UNKNOWN;
				QuestGuru_QuestStart[questTitle].NPCZone = QG_UNKNOWN;
				QuestGuru_QuestStart[questTitle].PosX = 0;
				QuestGuru_QuestStart[questTitle].PosY = 0;
				QuestGuru_QuestStart[questTitle].Level = 0;
			end
			QuestGuru_LastAbandonQuest.StartTime = QuestGuru_QuestStart[questTitle].StartTime;
			QuestGuru_LastAbandonQuest.StartNPCName = QuestGuru_QuestStart[questTitle].NPCName;
			QuestGuru_LastAbandonQuest.StartNPCZone = QuestGuru_QuestStart[questTitle].NPCZone;
			QuestGuru_LastAbandonQuest.StartPosX = QuestGuru_QuestStart[questTitle].PosX;
			QuestGuru_LastAbandonQuest.StartPosY = QuestGuru_QuestStart[questTitle].PosY;
			QuestGuru_LastAbandonQuest.StartLevel = QuestGuru_QuestStart[questTitle].Level;

			local questDescription, questObjectives = GetQuestLogQuestText();
			QuestGuru_LastAbandonQuest.Description = gsub(questDescription,QuestGuru_Player,"<name>");
			QuestGuru_LastAbandonQuest.ObjectiveText = gsub(questObjectives,QuestGuru_Player,"<name>");

			local numObjectives = GetNumQuestLeaderBoards();
			QuestGuru_LastAbandonQuest.Objectives = numObjectives;
			QuestGuru_LastAbandonQuest.Objective = {};
			for j=1, numObjectives do
				local desc, type, done = GetQuestLogLeaderBoard(j, i);
				QuestGuru_LastAbandonQuest.Objective[j] = {};
				QuestGuru_LastAbandonQuest.Objective[j].Type = type;
				if (type == "item") then
					local itemLink = QuestGuru_GetQuestItemLink(j, i);
					local x, y, name, numItems, numNeeded = string.find(desc, QG_ITEM_REQ_STR);
					if (itemLink == nil) then
						itemLink = name;
					end
					QuestGuru_LastAbandonQuest.Objective[j].Description = itemLink;
					QuestGuru_LastAbandonQuest.Objective[j].numNeeded = numNeeded;
				else
					QuestGuru_LastAbandonQuest.Objective[j].Description = desc;
				end

			end

			QuestGuru_LastAbandonQuest.RequiredMoney = GetQuestLogRequiredMoney();

			local numRewards = GetNumQuestLogRewards();
			QuestGuru_LastAbandonQuest.Rewards = numRewards;
			QuestGuru_LastAbandonQuest.Reward = {};
			for j=1, numRewards do
				name, texture, numItems, quality, isUsable = GetQuestLogRewardInfo(j);
				QuestGuru_LastAbandonQuest.Reward[j] = {};
				QuestGuru_LastAbandonQuest.Reward[j].Link = GetQuestLogItemLink("reward", j);
				QuestGuru_LastAbandonQuest.Reward[j].Count = numItems;
			end

			local numChoices = GetNumQuestLogChoices();
			QuestGuru_LastAbandonQuest.Choices = numChoices;
			QuestGuru_LastAbandonQuest.Choice = {};
			for j=1, numChoices do
				name, texture, numItems, quality, isUsable = GetQuestLogChoiceInfo(j);
				QuestGuru_LastAbandonQuest.Choice[j] = {};
				QuestGuru_LastAbandonQuest.Choice[j].Link = GetQuestLogItemLink("choice", j);
				QuestGuru_LastAbandonQuest.Choice[j].Count = numItems;
			end

			if (GetRewardSpell()) then
			    QuestGuru_LastAbandonQuest.SpellRewards = 1;
			    QuestGuru_LastAbandonQuest.SpellReward = {};
				texture, name, isTradeskillSpell, isSpellLearned = GetQuestLogRewardSpell();
				QuestGuru_LastAbandonQuest.SpellReward.Texture = texture;
				QuestGuru_LastAbandonQuest.SpellReward.Name = name;
			else
			    QuestGuru_LastAbandonQuest.SpellRewards = 0;
			end

			QuestGuru_LastAbandonQuest.RewardMoney = GetRewardMoney();
			QuestGuru_LastAbandonQuest.Honor = GetRewardHonor();
			QuestGuru_LastAbandonQuest.XP = GetRewardXP();
			QuestGuru_LastAbandonQuest.Talents = GetRewardTalents();
			QuestGuru_LastAbandonQuest.RewardTitle = GetQuestLogRewardTitle();
			return;
		end
	end
	SelectQuestLogEntry(prevQuestLogEntry);
	QuestGuru_LastAbandonQuest = {};
end

function QuestGuru_UpdateAbandon()
	local count=0;
	local headCount = 0;
	local titleCount = 0;
	local currAbandon = 1;
	local currHeader = "";
	local questAbandon;
	local scrollOffset = FauxScrollFrame_GetOffset(QuestGuru_QuestAbandonListScrollFrame);

	local questIndex, questAbandonTitle, questTitleTag, questLevel, questNormalText, questHighlight;
	local questLogTitleText, level, questTag, suggestedGroup, isHeader, isCollapsed, isComplete, isDaily, color;
	local numPartyMembers, partyMembersOnQuest, tempWidth, textWidth;
	local questTagText, strLvl, textLeft;

	QuestGuru_QuestAbandonHighlightFrame:Hide();

	for i, questAbandon in ipairs(QuestGuru_Abandon) do
		if ((titleCount+headCount >= scrollOffset) or (questAbandon.Header ~= currHeader and titleCount+headCount+1==scrollOffset)) then
			if (currAbandon <= QUESTGURU_QUESTS_DISPLAYED) then

				if ((titleCount+headCount+1) == scrollOffset and questAbandon.Header ~= currHeader) then
					currHeader = questAbandon.Header;
					headCount = headCount + 1;
				else
					if (questAbandon.Header ~= currHeader) then
						questAbandonTitle = getglobal("QuestGuru_QuestAbandonTitle"..currAbandon);
						questTitleTag = getglobal("QuestGuru_QuestAbandonTitle"..currAbandon.."Tag");
						questLevel = getglobal("QuestGuru_QuestAbandonTitle"..currAbandon.."Level");
						questNormalText = getglobal("QuestGuru_QuestAbandonTitle"..currAbandon.."NormalText");
						questHighlight = getglobal("QuestGuru_QuestAbandonTitle"..currAbandon.."Highlight");
						questAbandonTitle:SetText(questAbandon.Header);
						if (QuestGuru_AbandonHeaders[questAbandon.Header] ~= false) then
							questAbandonTitle:SetNormalTexture("Interface\\Buttons\\UI-MinusButton-Up");
							QuestGuru_AbandonHeaders[questAbandon.Header] = true;
						else
							questAbandonTitle:SetNormalTexture("Interface\\Buttons\\UI-PlusButton-Up");
						end
						questHighlight:SetTexture("Interface\\Buttons\\UI-PlusButton-Hilight");
						questAbandonTitle.isHeader = true;
						questAbandonTitle.qID = "";
						currHeader = questAbandon.Header;
						color = QuestDifficultyColors["header"];
						questTitleTag:SetText("");
						questTitleTag:SetTextColor(color.r, color.g, color.b);
						questLevel:SetText("");
						questAbandonTitle:SetNormalFontObject(color.font);
						questAbandonTitle.r = color.r;
						questAbandonTitle.g = color.g;
						questAbandonTitle.b = color.b;
						questAbandonTitle:Show();
						textLeft = 20;
						questNormalText:SetPoint("LEFT", textLeft, 0);
						headCount = headCount + 1;
						currAbandon = currAbandon + 1;
					end
				end

				if ((currAbandon <= QUESTGURU_QUESTS_DISPLAYED) and (QuestGuru_AbandonHeaders[questAbandon.Header] ~= false) and (strfind(strlower(questAbandon.Title),strlower(QuestGuru_QuestAbandonSearch:GetText())))) then
					questAbandonTitle = getglobal("QuestGuru_QuestAbandonTitle"..currAbandon);
					questTitleTag = getglobal("QuestGuru_QuestAbandonTitle"..currAbandon.."Tag");
					questLevel = getglobal("QuestGuru_QuestAbandonTitle"..currAbandon.."Level");
					questNormalText = getglobal("QuestGuru_QuestAbandonTitle"..currAbandon.."NormalText");
					questHighlight = getglobal("QuestGuru_QuestAbandonTitle"..currAbandon.."Highlight");

					strLvl = questAbandon.Level
					if (questAbandon.Daily) then
					    strLvl = strLvl.."Y";
					end
					if (questAbandon.Tag ~= nil) then
						if ((questAbandon.Tag == "Group") and (questAbandon.SuggestedGroup > 0)) then
							strLvl = strLvl.."G"..questAbandon.SuggestedGroup;
						elseif (questAbandon.Tag == "Dungeon") then
							strLvl = strLvl.."D";
						else
							strLvl = strLvl.."+"
						end
					end
					questLevel:SetText(strLvl);
					local s = questAbandon.Title;
					if (questAbandon.Count ~= nil and questAbandon.Daily) then
						s = s.." ("..questAbandon.Count..")";
					end
					questAbandonTitle:SetText(s);
					
					if (QuestGuru_Settings.ShowLevels == nil) then
					    QuestGuru_Settings.ShowLevels = {};
					end
					if (QuestGuru_Settings.ShowLevels.Abandon) then
					    textLeft = 40;
					    questLevel:Show();
					else
					    textLeft = 16;
					    questLevel:Hide();
					end
					questNormalText:SetPoint("LEFT", textLeft, 0);

					QuestGuru_QuestLogDummyText:SetText(s);

					questAbandonTitle:SetNormalTexture("");
					questHighlight:SetTexture("");

					-- Save if its a header or not
					questAbandonTitle.isHeader = false;
					
					questAbandonTitle.qID = questAbandon.qID;

					questTag = questAbandon.Tag;
					if ( questTag ) then
						if ((questTag == "Group") and (questAbandon.SuggestedGroup == 0)) then
							questTag = "Elite";
						end
						questTagText = "("..questTag
						if ((questAbandon.SuggestedGroup ~= nil) and (questAbandon.SuggestedGroup > 0)) then
							questTagText = questTagText..":"..questAbandon.SuggestedGroup;
						end
						questTagText = questTagText..")";
						questTitleTag:SetText(questTagText);
						-- Shrink text to accomdate quest tags without wrapping
						tempWidth = 300 - textLeft - 8 - questTitleTag:GetWidth();

						if ( QuestGuru_QuestLogDummyText:GetWidth() > tempWidth ) then
							textWidth = tempWidth;
						else
							textWidth = QuestGuru_QuestLogDummyText:GetWidth();
						end

						questNormalText:SetWidth(tempWidth);
					else
						questTitleTag:SetText("");
						questNormalText:SetWidth(300 - textLeft);
					end

					-- Color the quest title and highlight according to the difficulty level
					local playerLevel = UnitLevel("player");
					color = GetQuestDifficultyColor(questAbandon.Level);
					questTitleTag:SetTextColor(color.r, color.g, color.b);
					questAbandonTitle:SetNormalFontObject(color.font);
					questLevel:SetTextColor(color.r, color.g, color.b);
					questAbandonTitle.r = color.r;
					questAbandonTitle.g = color.g;
					questAbandonTitle.b = color.b;
					questAbandonTitle:Show();

					-- Place the highlight and lock the highlight state
					if ( QuestGuru_currAbandon == currAbandon + scrollOffset ) then
						QuestGuru_QuestAbandonHighlightFrame:SetPoint("TOPLEFT", "QuestGuru_QuestAbandonTitle"..currAbandon, "TOPLEFT", 0, 0);
						QuestGuru_QuestAbandonSkillHighlight:SetVertexColor(questAbandonTitle.r, questAbandonTitle.g, questAbandonTitle.b);
						QuestGuru_QuestAbandonHighlightFrame:Show();
						questTitleTag:SetTextColor(HIGHLIGHT_FONT_COLOR.r, HIGHLIGHT_FONT_COLOR.g, HIGHLIGHT_FONT_COLOR.b);
						questLevel:SetTextColor(HIGHLIGHT_FONT_COLOR.r, HIGHLIGHT_FONT_COLOR.g, HIGHLIGHT_FONT_COLOR.b);
						questAbandonTitle:LockHighlight();
					else
						questAbandonTitle:UnlockHighlight();
					end

					currAbandon = currAbandon + 1;
				end
			else
				if (questAbandon.Header ~= currHeader) then
					currHeader = questAbandon.Header;
					headCount = headCount + 1;
				end
			end
		else
			if (questAbandon.Header ~= currHeader) then
				currHeader = questAbandon.Header;
				headCount = headCount + 1;
			end
		end
		if (QuestGuru_AbandonHeaders[questAbandon.Header] ~= false) then
			titleCount = titleCount + 1;
		end
		count = count + 1;
	end

	-- ScrollFrame update
	FauxScrollFrame_Update(QuestGuru_QuestAbandonListScrollFrame, titleCount + headCount, QUESTGURU_QUESTS_DISPLAYED, QUESTLOG_QUEST_HEIGHT, nil, nil, nil, QuestGuru_QuestAbandonHighlightFrame, 293, 316 )
	local currTab = QuestGuru_GetCurrTabName();
	if ( count == 0 ) then
	    if (currTab == "Abandon") then
	        QuestGuru_QuestLogNoQuestsText:SetText("No Abandoned Quests");
			QuestGuru_EmptyQuestLogFrame:Show();
		end
		QuestGuru_QuestAbandonDetailScrollFrame:Hide();
	else
	    if (currTab == "Abandon") then
			QuestGuru_EmptyQuestLogFrame:Hide();
		end
		QuestGuru_QuestAbandonDetailScrollFrame:Show();
	end
	QuestGuru_UpdateTabText("Abandon", QG_TAB_ABANDON.." ("..count..")");

	for i=currAbandon, QUESTGURU_QUESTS_DISPLAYED do
		getglobal("QuestGuru_QuestAbandonTitle"..i):Hide();
	end
end

function QuestLog_SetAbandonSelection(questID)
	local selectedQuest;

	QuestGuru_currAbandon = questID;

	if ( questID == 0 ) then
		QuestGuru_QuestAbandonDetailScrollFrame:Hide();
		QuestGuru_UpdateAbandon();
		return;
	end

	-- Get xml id
	local id = questID - FauxScrollFrame_GetOffset(QuestGuru_QuestAbandonListScrollFrame);

	local titleButton = getglobal("QuestGuru_QuestAbandonTitle"..id);
	local titleButtonTag = getglobal("QuestGuru_QuestAbandonTitle"..id.."Tag");

	if ( titleButton.isHeader ) then
		if ( QuestGuru_AbandonHeaders[titleButton:GetText()] == true ) then
			QuestGuru_AbandonHeaders[titleButton:GetText()] = false;
			QuestGuru_UpdateAbandon();
			return;
		else
			QuestGuru_AbandonHeaders[titleButton:GetText()] = true;
			QuestGuru_UpdateAbandon();
			return;
		end
	else
		-- Set newly selected quest and highlight it
		local scrollFrameOffset = FauxScrollFrame_GetOffset(QuestGuru_QuestAbandonListScrollFrame);
		if ( questID > scrollFrameOffset and questID <= (scrollFrameOffset + QUESTGURU_QUESTS_DISPLAYED) ) then
			titleButton:LockHighlight();
			titleButtonTag:SetTextColor(HIGHLIGHT_FONT_COLOR.r, HIGHLIGHT_FONT_COLOR.g, HIGHLIGHT_FONT_COLOR.b);
			QuestGuru_QuestAbandonSkillHighlight:SetVertexColor(titleButton.r, titleButton.g, titleButton.b);
			QuestGuru_QuestAbandonHighlightFrame:SetPoint("TOPLEFT", "QuestGuru_QuestAbandonTitle"..id, "TOPLEFT", 5, 0);
			QuestGuru_QuestAbandonHighlightFrame:Show();
		end
	end
	QuestLog_UpdateQuestAbandonDetails();
end

function QuestLog_UpdateQuestAbandonDetails(doNotScroll)
	local questAbandon;
	local questFound = false;
	local i, qH, NPCColor, PosColor;

	local scrollOffset = FauxScrollFrame_GetOffset(QuestGuru_QuestAbandonListScrollFrame);
	local qID = getglobal("QuestGuru_QuestAbandonTitle"..QuestGuru_currAbandon - scrollOffset).qID;

	for i, qH in ipairs(QuestGuru_Abandon) do
		if (qH.qID == qID) then
			questAbandon = qH;
			questFound = true;
			break;
		end
	end

	if (not questFound) then
	    return;
	end

	local questTitle = questAbandon.Title;
	local lastObjective;

-- Added LightHeaded support
if (IsAddOnLoaded("LightHeaded")) then
	if (QuestGuru_GetCurrTabName() == "Abandon") then
		if (questAbandon.Link) then
			local i, j, qNum = string.find(questAbandon.Link, (":(%d+):"));
			if LightHeaded.db.profile.singlepage then
				LightHeaded:UpdateFrame(tonumber(qNum), nil)
			else
				LightHeaded:UpdateFrame(tonumber(qNum), 1)
			end
		else
			LightHeaded:UpdateFrame(0, nil);
		end
	end
end

-- End LightHeaded support

	if ( not questTitle ) then
		questTitle = "";
	end
	QuestGuru_QuestAbandonQuestTitle:SetText(questTitle);

	local questDescription = gsub(questAbandon.Description,"<name>",QuestGuru_Player);
    
	QuestGuru_QuestAbandonObjectivesText:SetPoint("TOPLEFT", "QuestGuru_QuestAbandonQuestTitle", "BOTTOMLEFT", 0, -5);
	QuestGuru_QuestAbandonStart:Hide();
	QuestGuru_QuestAbandonFinish:Hide();
	if (questAbandon ~= nil) then
		if ((questAbandon.StartNPCName ~= nil) and (questAbandon.StartNPCName ~= QG_UNKNOWN) and (questAbandon.StartNPCName ~= "Unknown") and (questAbandon.StartPosX ~= nil) and (questAbandon.StartPosY ~= nil)) then
			QuestGuru_QuestAbandonStartNPCName:SetText(questAbandon.StartNPCName);
			if (QuestGuru_Settings.Colorize.NPCNames.Enabled) then
				NPCColor = QuestGuru_Settings.Colorize.NPCNames.Color;
			else
				NPCColor = { r=0, g=0, b=0 };
			end
			QuestGuru_QuestAbandonStartNPCName:SetTextColor(NPCColor.r, NPCColor.g, NPCColor.b);
			QuestGuru_QuestAbandonStartPos:SetText("(" .. floor(questAbandon.StartPosX) .. "," .. floor(questAbandon.StartPosY) .. ")");
			if (QuestGuru_Settings.Colorize.AreaNames.Enabled) then
				PosColor = QuestGuru_Settings.Colorize.AreaNames.Color;
			else
				PosColor = { r=0, g=0, b=0 };
			end
			QuestGuru_QuestAbandonStartPos:SetTextColor(PosColor.r, PosColor.g, PosColor.b);
			local tempWidth = QuestGuru_QuestAbandonStartLabel:GetWidth() + QuestGuru_QuestAbandonStartPos:GetWidth();
			QuestGuru_QuestAbandonStartNPCName:SetWidth(285 - tempWidth);
			QuestGuru_QuestAbandonStart:Show();
			QuestGuru_QuestAbandonObjectivesText:SetPoint("TOPLEFT", "QuestGuru_QuestAbandonStart", "BOTTOMLEFT", 0, -8);
		end
		if (questAbandon.FinishTime ~= nil) then
			QuestGuru_QuestAbandonFinishNPCName:SetText(questAbandon.FinishTime);
			QuestGuru_QuestAbandonFinishPos:SetText("");
			QuestGuru_QuestAbandonFinish:Show();
			QuestGuru_QuestAbandonObjectivesText:SetPoint("TOPLEFT", "QuestGuru_QuestAbandonFinish", "BOTTOMLEFT", 0, -8);
		end
	end
	
	local questObjectives = gsub(questAbandon.ObjectiveText,"<name>",QuestGuru_Player);

	questObjectives = QuestGuru_ColorizeText(questObjectives);
	QuestGuru_QuestAbandonObjectivesText:SetText(questObjectives);

	QuestGuru_QuestAbandonTimerText:Hide();
	QuestGuru_QuestAbandonObjective1:SetPoint("TOPLEFT", "QuestGuru_QuestAbandonObjectivesText", "BOTTOMLEFT", 0, -10);

	local numObjectives = questAbandon.Objectives;
	local currObj = 0;

	for i=1, 10 do
		getglobal("QuestGuru_QuestAbandonObjective"..i):Hide();
	end

	for i=1, numObjectives, 1 do
		local text = questAbandon.Objective[i].Description;
		local type = questAbandon.Objective[i].Type;
--		if (type ~= "item") then
			currObj = currObj + 1;
			local string = getglobal("QuestGuru_QuestAbandonObjective"..currObj);
			if ( not text or strlen(text) == 0 ) then
				text = type;
			end
			if (questAbandon.Objective[i].numNeeded ~= nil) then
				text = text.." ("..questAbandon.Objective[i].numNeeded..")";
			end
			string:SetTextColor(0, 0, 0);
			string:SetText(text);
			string:Show();
			lastObjective = string;
--		end
	end

	-- If there's money required then anchor and display it
	if ( questAbandon.RequiredMoney > 0 ) then
		if ( numObjectives > 0 ) then
			QuestGuru_QuestAbandonRequiredMoneyText:SetPoint("TOPLEFT", lastObjective, "BOTTOMLEFT", 0, -4);
		else
			QuestGuru_QuestAbandonRequiredMoneyText:SetPoint("TOPLEFT", "QuestGuru_QuestAbandonObjectivesText", "BOTTOMLEFT", 0, -10);
		end

		MoneyFrame_Update("QuestGuru_QuestAbandonRequiredMoneyFrame", questAbandon.RequiredMoney);

		QuestGuru_QuestAbandonRequiredMoneyText:SetTextColor(0.2, 0.2, 0.2);
		SetMoneyFrameColor("QuestGuru_QuestAbandonRequiredMoneyFrame", 1.0, 1.0, 1.0);

		QuestGuru_QuestAbandonRequiredMoneyText:Show();
		QuestGuru_QuestAbandonRequiredMoneyFrame:Show();
	else
		QuestGuru_QuestAbandonRequiredMoneyText:Hide();
		QuestGuru_QuestAbandonRequiredMoneyFrame:Hide();
	end

	if ( questAbandon.SuggestedGroup > 0 ) then
		local suggestedGroupString = format(QUEST_SUGGESTED_GROUP_NUM, questAbandon.SuggestedGroup);
		QuestGuru_QuestAbandonSuggestedGroupNum:SetText(suggestedGroupString);
		QuestGuru_QuestAbandonSuggestedGroupNum:Show();
		QuestGuru_QuestAbandonSuggestedGroupNum:ClearAllPoints();
		if ( questAbandon.RequiredMoney > 0 ) then
			QuestGuru_QuestAbandonSuggestedGroupNum:SetPoint("TOPLEFT", "QuestGuru_QuestAbandonRequiredMoneyText", "BOTTOMLEFT", 0, -4);
		elseif ( numObjectives > 0 ) then
			QuestGuru_QuestAbandonSuggestedGroupNum:SetPoint("TOPLEFT", lastObjective, "BOTTOMLEFT", 0, -4);
		else
			QuestGuru_QuestAbandonSuggestedGroupNum:SetPoint("TOPLEFT", "QuestGuru_QuestAbandonObjectivesText", "BOTTOMLEFT", 0, -10);
		end
	else
		QuestGuru_QuestAbandonSuggestedGroupNum:Hide();
	end

	if ( questAbandon.SuggestedGroup > 0 ) then
		QuestGuru_QuestAbandonDescriptionTitle:SetPoint("TOPLEFT", "QuestGuru_QuestAbandonSuggestedGroupNum", "BOTTOMLEFT", 0, -10);
	elseif ( questAbandon.RequiredMoney > 0 ) then
		QuestGuru_QuestAbandonDescriptionTitle:SetPoint("TOPLEFT", "QuestGuru_QuestAbandonRequiredMoneyText", "BOTTOMLEFT", 0, -10);
	elseif ( numObjectives > 0 ) then
		QuestGuru_QuestAbandonDescriptionTitle:SetPoint("TOPLEFT", lastObjective, "BOTTOMLEFT", 0, -10);
	else
		QuestGuru_QuestAbandonDescriptionTitle:SetPoint("TOPLEFT", "QuestGuru_QuestAbandonObjectivesText", "BOTTOMLEFT", 0, -10);
	end
	if ( questDescription ) then
		questDescription = QuestGuru_ColorizeText(questDescription);
		QuestGuru_QuestAbandonQuestDescription:SetText(questDescription);
	end
	local numRewards = questAbandon.Rewards;
	local numChoices = questAbandon.Choices;
	local money = questAbandon.RewardMoney;
	local honor = questAbandon.Honor;
	local talents = questAbandon.Talents;
	local playerTitle = questAbandon.RewardTitle;

	if ( playerTitle or (numRewards + numChoices + money + honor + talents) > 0 ) then
		QuestGuru_QuestAbandonRewardTitleText:Show();
	else
		QuestGuru_QuestAbandonRewardTitleText:Hide();
	end

	QuestGuru_QuestAbandonFrameItems_Update("QuestAbandon");
	if ( not doNotScroll ) then
		QuestGuru_QuestAbandonDetailScrollFrameScrollBar:SetValue(0);
	end
	QuestGuru_QuestAbandonDetailScrollFrame:UpdateScrollChildRect();
end

function QuestGuru_QuestAbandonFrameItems_Update(questState)
	local isQuestLog = 0;
	local questAbandon;

	if ( questState == "QuestAbandon" ) then
		isQuestLog = 1;
		questState = "QuestGuru_QuestAbandon";
	end

	local scrollOffset = FauxScrollFrame_GetOffset(QuestGuru_QuestAbandonListScrollFrame);
	local qID = getglobal("QuestGuru_QuestAbandonTitle"..QuestGuru_currAbandon - scrollOffset).qID;

	for i, qH in ipairs(QuestGuru_Abandon) do
		if (qH.qID == qID) then
			questAbandon = qH;
			questFound = true;
			break;
		end
	end

	if (not questFound) then
	    return
	end

	local numQuestRewards = questAbandon.Rewards;
	local numQuestChoices = questAbandon.Choices;
	local numQuestSpellRewards = questAbandon.SpellRewards;
	local money = questAbandon.RewardMoney;
	local honor = questAbandon.Honor;
	local talents = questAbandon.Talents;
	local playerTitle = questAbandon.RewardTitle;

	local totalRewards = numQuestRewards + numQuestChoices + numQuestSpellRewards;
	local questItemName = questState.."Item";
	local material = QuestFrame_GetMaterial();
	local honorFrame = getglobal(questState.."HonorFrame");
	local talentFrame = getglobal(questState.."TalentFrame");
	local moneyFrame = getglobal(questState.."MoneyFrame");
	local playerTitleFrame = getglobal(questState.."PlayerTitleFrame");
	local questItemReceiveText = getglobal(questState.."ItemReceiveText");

	if ( totalRewards == 0 and money == 0 and honor == 0 and talents == 0 and not playerTitle ) then
		getglobal(questState.."RewardTitleText"):Hide();
	else
		getglobal(questState.."RewardTitleText"):Show();
		QuestFrame_SetTitleTextColor(getglobal(questState.."RewardTitleText"), material);
	end

	if ( money == 0 ) then
		moneyFrame:Hide();
	else
		moneyFrame:Show();
		MoneyFrame_Update(questState.."MoneyFrame", money);
	end

	if (honor == 0) then
		honorFrame:Hide();
	else
		honorFrame:Show();
		--QuestHonorFrame_Update(questState.."HonorFrame", honor);
		getglobal(questState.."HonorFramePoints"):SetText(honor);
		honorFrame:ClearAllPoints();
		if (money == 0) then
			honorFrame:SetPoint("LEFT", questItemReceiveText, "RIGHT", 15, 0);
		else
			honorFrame:SetPoint("LEFT", moneyFrame, "RIGHT", -5, 0);
		end
	end

	if (questAbandon.XP) then
		QuestGuru_QuestAbandonXPFramePoints:SetText(questAbandon.XP);
		QuestGuru_QuestAbandonXPFrame:Show();
	else
		QuestGuru_QuestAbandonXPFramePoints:SetText("");
		QuestGuru_QuestAbandonXPFrame:Hide();
	end

	if (talents == 0) then
		talentFrame:Hide();
	else
		if ( honor ~= 0 ) then
			talentFrame:SetPoint("TOPLEFT", honorFrame, "BOTTOMLEFT", 0, -5);
		end
		talentFrame:Show();
--		QuestTalentFrame_Update(questState.."TalentFrame", talents);
		getglobal(questState.."TalentFramePoints"):SetText(talents);
	end

	if ( not playerTitle ) then
		playerTitleFrame:Hide();
	else
		local anchorFrame;
		if ( talents ~= 0) then
			anchorFrame = talentFrame;
		elseif ( honor ~= 0 ) then
			anchorFrame = honorFrame;
		elseif ( money ~= 0 ) then
			anchorFrame = moneyFrame;
		else
			anchorFrame = getglobal(questState.."RewardTitleText");
		end
		playerTitleFrame:SetPoint("TOP", anchorFrame, "BOTTOM", 0, -5);
		playerTitleFrame:SetPoint("LEFT", questState.."ItemReceiveText", "LEFT", -3, -5);
		getglobal(questState.."PlayerTitleFrameTitle"):SetText(playerTitle);
		playerTitleFrame:Show();
	end
	
	-- Hide unused rewards
	for i=totalRewards + 1, MAX_NUM_ITEMS, 1 do
		getglobal(questItemName..i):Hide();
	end

	local questItem, name, texture, isTradeskillSpell, isSpellLearned, quality, isUsable, numItems = 1;
	local rewardsCount = 0;

	-- Setup choosable rewards
	if ( numQuestChoices > 0 ) then
		local itemChooseText = getglobal(questState.."ItemChooseText");
		itemChooseText:Show();
		QuestFrame_SetTextColor(itemChooseText, material);

		local index;
		local baseIndex = rewardsCount;
		for i=1, numQuestChoices, 1 do
			index = i + baseIndex;
			questItem = getglobal(questItemName..index);
			questItem.type = "choice";
			name, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, texture = GetItemInfo(questAbandon.Choice[i].Link)
			if (texture == nil) then
				GameTooltip:SetHyperlink(questAbandon.Choice[i].Link);
				GameTooltip:Show();
				GameTooltip:Hide();
				questItem.timerEnabled = true;
			end
			numItems = questAbandon.Choice[i].Count;

			questItem:SetID(i)
			questItem:Show();
			-- For the tooltip
			questItem.rewardType = "item"
			getglobal(questItemName..index.."Name"):SetText(name);
			SetItemButtonCount(questItem, numItems);
			SetItemButtonTexture(questItem, texture);
			questItem.link = questAbandon.Choice[i].Link;
--			if ( IsEquippableItem(itemLink) or IsConsumableItem(itemLink) ) then
				SetItemButtonTextureVertexColor(questItem, 1.0, 1.0, 1.0);
				SetItemButtonNameFrameVertexColor(questItem, 1.0, 1.0, 1.0);
--			else
--				SetItemButtonTextureVertexColor(questItem, 0.9, 0, 0);
--				SetItemButtonNameFrameVertexColor(questItem, 0.9, 0, 0);
--			end
			if ( i > 1 ) then
				if ( mod(i,2) == 1 ) then
					questItem:SetPoint("TOPLEFT", questItemName..(index - 2), "BOTTOMLEFT", 0, -2);
				else
					questItem:SetPoint("TOPLEFT", questItemName..(index - 1), "TOPRIGHT", 1, 0);
				end
			else
				questItem:SetPoint("TOPLEFT", itemChooseText, "BOTTOMLEFT", -3, -5);
			end
			rewardsCount = rewardsCount + 1;
		end
	else
		getglobal(questState.."ItemChooseText"):Hide();
	end

	-- Setup spell rewards
	if ( numQuestSpellRewards > 0 ) then
		local learnSpellText = getglobal(questState.."SpellLearnText");
		learnSpellText:Show();
		QuestFrame_SetTextColor(learnSpellText, material);

		--Anchor learnSpellText if there were choosable rewards
		if ( rewardsCount > 0 ) then
			learnSpellText:SetPoint("TOPLEFT", questItemName..rewardsCount, "BOTTOMLEFT", 3, -5);
		else
			learnSpellText:SetPoint("TOPLEFT", questState.."RewardTitleText", "BOTTOMLEFT", 0, -5);
		end

		texture = questAbandon.SpellReward.Texture;
		name = questAbandon.SpellReward.Name;

		learnSpellText:SetText(name);

		rewardsCount = rewardsCount + 1;
		questItem = getglobal(questItemName..rewardsCount);
		questItem:Show();
		-- For the tooltip
		questItem.link = nil;
		questItem.rewardType = "spell";
		SetItemButtonCount(questItem, 0);
		SetItemButtonTexture(questItem, texture);
		getglobal(questItemName..rewardsCount.."Name"):SetText(name);
		questItem:SetPoint("TOPLEFT", learnSpellText, "BOTTOMLEFT", -3, -5);
	else
		getglobal(questState.."SpellLearnText"):Hide();
	end

	-- Setup mandatory rewards
	if ( numQuestRewards > 0 or money > 0 or honor > 0 or talents > 0) then
		QuestFrame_SetTextColor(questItemReceiveText, material);
		-- Anchor the reward text differently if there are choosable rewards
		if ( numQuestSpellRewards > 0  ) then
			questItemReceiveText:SetText(REWARD_ITEMS);
			questItemReceiveText:SetPoint("TOPLEFT", questItemName..rewardsCount, "BOTTOMLEFT", 3, -5);
		elseif ( numQuestChoices > 0  ) then
			questItemReceiveText:SetText(REWARD_ITEMS);
			local index = numQuestChoices;
			if ( mod(index, 2) == 0 ) then
				index = index - 1;
			end
			questItemReceiveText:SetPoint("TOPLEFT", questItemName..index, "BOTTOMLEFT", 3, -5);
		else
			questItemReceiveText:SetText(REWARD_ITEMS_ONLY);
			questItemReceiveText:SetPoint("TOPLEFT", questState.."RewardTitleText", "BOTTOMLEFT", 3, -5);
		end
		questItemReceiveText:Show();
		-- Setup mandatory rewards
		local index;
		local baseIndex = rewardsCount;
		for i=1, numQuestRewards, 1 do
			index = i + baseIndex;
			questItem = getglobal(questItemName..index);

			questItem.type = "reward";
			name, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, texture = GetItemInfo(questAbandon.Reward[i].Link);
			numItems = questAbandon.Reward[i].Count;

			questItem:SetID(i)
			questItem:Show();
			-- For the tooltip
			questItem.link = questAbandon.Reward[i].Link;
			questItem.rewardType = "item";
			getglobal(questItemName..index.."Name"):SetText(name);
			SetItemButtonCount(questItem, numItems);
			SetItemButtonTexture(questItem, texture);
			SetItemButtonTextureVertexColor(questItem, 1.0, 1.0, 1.0);
			SetItemButtonNameFrameVertexColor(questItem, 1.0, 1.0, 1.0);

			if ( i > 1 ) then
				if ( mod(i,2) == 1 ) then
					questItem:SetPoint("TOPLEFT", questItemName..(index - 2), "BOTTOMLEFT", 0, -2);
				else
					questItem:SetPoint("TOPLEFT", questItemName..(index - 1), "TOPRIGHT", 1, 0);
				end
			elseif (talents > 0) then
				questItem:SetPoint("TOPLEFT", talentFrame, "BOTTOMLEFT", -3, -5);
			elseif (honor > 0) then
				questItem:SetPoint("TOPLEFT", questState.."HonorFrame", "BOTTOMLEFT", -3, -5);
			else
				questItem:SetPoint("TOPLEFT", questState.."ItemReceiveText", "BOTTOMLEFT", -3, -5);
			end
			rewardsCount = rewardsCount + 1;
		end
	else
		questItemReceiveText:Hide();
	end
end

function QuestGuru_DeleteAbandon(questTitle)
	local i, qH;

	for i, qH in ipairs(QuestGuru_Abandon) do
		if (qH.Title == questTitle) then
			tremove(QuestGuru_Abandon, i);
			i = i - 1;
		end
	end
	QuestGuru_UpdateAbandon();
end

function QuestGuru_CheckAbandon()
	local i, qH, prevH;

	for i, qH in ipairs(QuestGuru_Abandon) do
		if (qH.Level == nil) then
			tremove(QuestGuru_Abandon, i);
		end
		if (qH.StartNPCName == nil) then
			qH.StartNPCName = QG_UNKNOWN;
		end
		if (qH.StartNPCZone == nil) then
			qH.StartNPCZone = QG_UNKNOWN;
		end
		if (qH.StartPosX == nil) then
			qH.StartPosX = 0;
		end
		if (qH.StartPosY == nil) then
			qH.StartPosY = 0;
		end
		if (qH.StartLevel == nil) then
			qH.StartLevel = 0;
		end
		if (qH.Honor == nil) then
			qH.Honor = 0;
		end
		if (qH.Talents == nil) then
			qH.Talents = 0;
		end
		if (tonumber(qH.qID) == nil and qH.Link) then
			local qi, qj, qNum = string.find(qH.Link, (":(%d+):"));
			qH.qID = qNum;
		end

		if (qH.StartNPCZone) then
			z = string.find(qH.StartNPCZone, " in ");
			if (z) then
				ls = strsub(qH.StartNPCZone, 1, z - 1);
				rs = strsub(qH.StartNPCZone, z + 4);
				qH.StartNPCZone = ls..", "..rs;
			end
		end
	end
end

function QuestGuru_UpdateAbandonDB()
	if (QuestGuru_Quests[QuestGuru_RealmName] == nil) then return; end
	local i, qH, qID;

   	for i, qH in ipairs(QuestGuru_Abandon) do
   		if (qH.qID == nil) then return; end
		if (QuestGuru_Quests[QuestGuru_RealmName][qH.qID] == nil) then
			QuestGuru_Quests[QuestGuru_RealmName][qH.qID] = {};
			QuestGuru_Quests[QuestGuru_RealmName][qH.qID].level = qH.Level;
			QuestGuru_Quests[QuestGuru_RealmName][qH.qID]["_link"] = qH.Link;
		end
		QuestGuru_Quests[QuestGuru_RealmName][qH.qID]["~"..QuestGuru_Player] = "Abandoned";
	end
end