﻿-- PointTo: Written by Olorin

-- Version  0.6b
-- Added PLAYER_ENTERING_WORLD to trigger for autohide since some instances change zone before they zone in so it 
-- wasnt being triggered this should avoid the frame being shown/hidden incorrectly
-- Version  0.6a
-- Small change to avoid the editbox sometimes getting the focus when you login to a character
-- Version: 0.6
-- Rewritten to be better dynamicly updated, code tidied somewhat and include the following requested changes:
-- Added autohide feature
-- Persistant addon on/off feature
-- Added ability to enter any valid unitID

-- Version History:
-- 0.5 Initial release

-- ** Variable Declaration - Non Saved**
local s2 = sqrt(2);
local cos, sin, rad = math.cos, math.sin, math.rad;
local Angle=0
local PointToUnit = UnitName("party1")
local MainFrameElap, MainFrameElapsed = 0,0
local TimerFrameElap,TimerFrameElapsed = 0,0
local LocX, LocY, LocXVal, LocYVal, NoLocs,TarLoc
local PlayerXpos,PlayerYpos, UnitXPos,UnitYPos = 0,0,0,0
local PointToPointLoc,Str1, Str2
local R, G, B, A  -- Variables for color and alpha 
local cmd
local Distance, DistanceX, DistanceY, Facing
local MainFrame,MainText1,ArrowFrame, ArrowTexture, DebugFrame, GotoLoc
local OnLoadFrame=CreateFrame("Frame","PointToLoaded")
local TimerFrame=CreateFrame("Frame","PointToTimerFrame")

-- Standard  Addon Functions / Variables
local DebugMode	--  Debug Output , Debug ==1 for Debug Text, ==2 for Debug Text plus Debug Call Stack Information
local DMsg
local Msg

-- Start of Function definitions
local function DOut(...)  --  Debug Output , Debug ==1 for Debug Text, ==2 for Debug Text plus Debug Call Stack Information
	if Debug ~= nil then
		DMsg = "|cFEFED000GBF,"
		for ArgCounter = 1, select("#", ...) do -- counter for number of args passed to function using ... so that variable number of args may be used.
			if select(ArgCounter, ...) ~= nil then
				DMsg = DMsg .. "|cFEFED000 DebugMsg arg" .. ArgCounter .. ": |cFF00FFFF" .. select(ArgCounter, ...)
			else 
				DMsg = DMsg .. "|cFEFED000 DebugMsg arg" .. ArgCounter .. ": |cFF00FFFFnil"
			end
		end
		if Debug > 1 then 
			DMsg = DMsg .. "\n|cFFCC00FF" .. debugstack()
		end
		DEFAULT_CHAT_FRAME:AddMessage(DMsg)
	end
end

local function Out(...)  --  Standard Output Function
	Msg = nil
	for ArgCounter = 1, select("#", ...) do
		if select(ArgCounter, ...) ~= nil then
			if Msg == nil then
				Msg = select(ArgCounter, ...) 
			else
				Msg = Msg .. select(ArgCounter, ...) 
			end
		end
	end
	if Msg ~= nil then
		DEFAULT_CHAT_FRAME:AddMessage(Msg) 
	else
		if Debug > 1 then
			DEFAULT_CHAT_FRAME:AddMessage("Получена пустая строка " .. debugstack()) 
		elseif Debug ~= nil then 
			DEFAULT_CHAT_FRAME:AddMessage("Получена пустая строка ") 
		end
	end
end

--  ** Slash Command Handler Function **
function PointTo_Command(cmd)
  	if  (cmd ~= nil and cmd ~= "") then
		cmd=strlower(cmd)
  		Out("|cFEFED000" .."PointTo Команда: " .. cmd);
  		if cmd == "on" then
            PointToDisabled = nil
  			Out("|cFEFED000" .."PointTo Включен.");
  			MainFrame:Show()	
 		elseif cmd=="off" then
            PointToDisabled = 1
 			MainFrame:Hide()
			DebugFrame:Hide()
  			Out("|cFEFED000" .."PointTo Выключен.");
		elseif cmd=="lock" then
            if MainFrame:IsVisible() then
                if MainFrame:IsMovable() == nil then
                    Out("PointTo Разблокирован!")
                    MainFrame:SetMovable(true)
                    MainFrame:EnableMouse(true)
                else
                    Out("PointTo Заблокирован!")
                    MainFrame:SetMovable(false)
                    MainFrame:EnableMouse(false)
                end
            else
                Out("|cFEFED000" .."PointTo Не включен, что бы включить пропишите /PT on")
            end
        elseif cmd=="autohide" then
            if PointToAutoHide == nil then
                Out("|cFEFED000" .."PointTo АвтоСкрытие включено и теперь будет прятать аддон когда для данной локации нет координат, это заработает со следующим переходом зоны.")
                PointToAutoHide = 1
            else
             Out("|cFEFED000" .."PointTo AutoHide выключен, PointTo больше не будет автоматически скрывать аддон когда нет доступных локаций для текущей зоны, это заработает со следующим переходом зоны.")
                PointToAutoHide = nil
            end
            if MainFrame:IsVisible() == false then
                Out("|cFEFED000" .."Настройки АвтоСкрытия изменены но сам аддон не включен, для включения пропишите /PT on")
            end
		elseif cmd=="debugon" then
			DebugFrame:Show()
		elseif cmd=="debugoff" then
			DebugFrame:Hide()
        else
  			Out("|cFEFED000" .."Команда /PointTo " .. cmd .. " не верная.")
  		end	
  	else
		Out("|cFF00FFFF".."Команды аддона:" .."|cFEFED000" .." /PointTo, /pointto, /pt or /PT")
		Out("|cFF00FFFF".."PointTo On -" .."|cFEFED000" .." Включить аддон")
		Out("|cFF00FFFF".."PointTo Off -" .."|cFEFED000" .." Выключить аддон")
--		Out("PointTo debugon - Enable PointTo Debug Frame")	
--		Out("PointTo debugoff - Disable PointTo Debug Frame")
		Out("|cFF00FFFF".."PointTo Lock -" .."|cFEFED000" .." Блокирует/разблокирует окошко аддона")
        Out("|cFF00FFFF".."PointTo AutoHide -" .."|cFEFED000" .." Включает/выключает автоскрытие в подземельях")
        Out("|cFF00FFFF".."Текущий статус PointTo:")
        if PointToAutoHide == nil then
            Out("|cFF00FFFF".."PointTo Автоскрытие Выключено -" .."|cFEFED000" .." PointTo не будет автоматически спрятан")
        else
            Out("|cFF00FFFF".."PointTo Автоскрытие Включено -" .."|cFEFED000" .." PointTo будет автоматически спрятан")
        end
        if PointToDisabled == nil then
            Out("|cFF00FFFF".."PointTo ВКЛЮЧЕН")
        else
            Out("|cFF00FFFF".."PointTo ВЫКЛЮЧЕН")
        end
	end
end
--[[
local function DebugInfo() -- Generally a Hidden Frame but can be shown to display debug Information
	DebugFrame:SetWidth(350); DebugFrame:SetHeight(120);
	DebugFrame:SetPoint("CENTER",UIParent);
	DebugFrame:SetBackdrop({
	  bgFile="Interface\\Tooltips\\UI-Tooltip-Background", 
	  edgeFile="Interface\\Tooltips\\UI-Tooltip-Border", 
	  tile=1, tileSize=10, edgeSize=10, 
	  insets={left=3, right=3, top=3, bottom=3}
	});
	
	DebugText1=DebugFrame:CreateFontString("$parentText","ARTWORK","GameFontNormal")
	DebugText1:SetPoint("TOP",DebugFrame,("TOP"),0,-5)
	
	DebugText2=DebugFrame:CreateFontString("$parentText","ARTWORK","GameFontNormal")
	DebugText2:SetPoint("TOP",DebugText1,("BOTTOM"),0,-5) 
	
	DebugText3=DebugFrame:CreateFontString("$parentText","ARTWORK","GameFontNormal")
	DebugText3:SetPoint("TOP",DebugText2,("BOTTOM"),0,-5) 
	
	DebugText4=DebugFrame:CreateFontString("$parentText","ARTWORK","GameFontNormal")
	DebugText4:SetPoint("TOP",DebugText3,("BOTTOM"),0,-5)

	DebugText5=DebugFrame:CreateFontString("$parentText","ARTWORK","GameFontNormal")
	DebugText5:SetPoint("TOP",DebugText4,("BOTTOM"),0,-5)
	
	--Making Debug Frame Movable
	DebugFrame:SetMovable(true)
	DebugFrame:EnableMouse(true)
	DebugFrame:SetScript("OnMouseDown",function() DebugFrame:StartMoving() end)
	DebugFrame:SetScript("OnMouseUp",function() DebugFrame:StopMovingOrSizing() end)	
end	
]]--

local function MainFrameCreate()
	MainFrame=CreateFrame("FRAME","PointToMainFrame",UIParent);
	MainFrame:SetBackdrop({
		bgFile="Interface\\Tooltips\\UI-Tooltip-Background", 
		edgeFile="Interface\\Tooltips\\UI-Tooltip-Border", 
		tile=1, tileSize=10, edgeSize=10, 
		insets={left=3, right=3, top=3, bottom=3}
		})
	MainFrame:SetBackdropColor(0,0,0,0.8)
	MainFrame:SetWidth(100); MainFrame:SetHeight(125);
	MainFrame:SetPoint(MainFramePoint,UIParent, MainFrameXpos, MainFrameYpos);
	MainFrame:SetResizable(true)

	MainText1=MainFrame:CreateFontString("$parentText","ARTWORK","GameFontNormal")
	MainText1:SetHeight(14)
	MainText1:SetPoint("TOP",MainFrame,"TOP",0,-4)
	MainText1:SetText("Init String")
		
	MainText2=MainFrame:CreateFontString("$parentText","ARTWORK","GameFontNormal")
	MainText2:SetPoint("TOP",MainText1,"BOTTOM",0,-1)
	MainText2:SetHeight(14)
	
	ArrowFrame=CreateFrame("Frame","ARTWORK",MainFrame)
	ArrowFrame:SetWidth(50);ArrowFrame:SetHeight(50)
	ArrowFrame:SetPoint("TOP",MainText2,"BOTTOM",0,-2)
	
	ArrowTexture=ArrowFrame:CreateTexture(nil,"BACKGROUND")
	ArrowTexture:SetTexture("Interface\\AddOns\\bcsPointTo\\Art\\bcsArrow.tga")
	ArrowTexture:SetAllPoints(ArrowFrame) 
	ArrowFrame.texture = ArrowTexture  -- assign the texture to the frame

	GotoLoc=CreateFrame("EditBox","GotoLoc",MainFrame,"InputBoxTemplate")
    GotoLoc:SetAutoFocus(false)
	GotoLoc:SetPoint("BOTTOM",MainFrame,"BOTTOM",3,4)
	GotoLoc:EnableMouse(true)
	GotoLoc:SetMultiLine(false)
	GotoLoc:SetFontObject(GameFontNormalSmall)
    GotoLoc:SetWidth(85);GotoLoc:SetHeight(20)
	GotoLoc:SetJustifyH("CENTER") 
	GotoLoc:RegisterEvent("OnEnterPressed")
	GotoLoc:SetScript("OnEnterPressed", function() GotoLoc:ClearFocus() end)
	GotoLoc:RegisterEvent("OnEscapePressed")
	GotoLoc:SetScript("OnEscapePressed", function() GotoLoc:ClearFocus() GotoLoc:SetText("") end)
     
	TextLocX=MainFrame:CreateFontString("$parentText","ARTWORK","GameFontNormal")
	TextLocX:SetHeight(14)
	TextLocX:SetPoint("BOTTOMLEFT",GotoLoc,"TOPLEFT",-5,2)
	TextLocX:SetText("|cFEFED000".. "X:")	
	TextLocXVal=MainFrame:CreateFontString("$parentText","ARTWORK","GameFontNormal")
	TextLocXVal:SetHeight(14)
	TextLocXVal:SetPoint("BOTTOMLEFT",GotoLoc,"TOPLEFT",9,2)
	TextLocY=MainFrame:CreateFontString("$parentText","ARTWORK","GameFontNormal")
	TextLocY:SetHeight(14)
	TextLocY:SetPoint("BOTTOMLEFT",GotoLoc,"TOPLEFT",42,2)		
	TextLocY:SetText("|cFEFED000".. "Y:")
	TextLocYVal=MainFrame:CreateFontString("$parentText","ARTWORK","GameFontNormal")
	TextLocYVal:SetHeight(14)
	TextLocYVal:SetPoint("BOTTOMLEFT",GotoLoc,"TOPLEFT",55,2)
	
	MainFrame:SetScript("OnUpdate", MainFrame_OnUpdate)
	MainFrame:SetMovable(false)
	MainFrame:EnableMouse(false)
	MainFrame:SetScript("OnMouseDown",function() MainFrame:StartMoving() end)
	-- MainFrame:SetScript("OnMouseUp",function() MainFrame:StopMovingOrSizing() end)
	MainFrame:SetScript("OnMouseUp", PointToSaveLoc)
end

function PointToSaveLoc()
	MainFrame:StopMovingOrSizing()
	MainFramePoint, relativeTo, relativePoint, MainFrameXpos, MainFrameYpos = MainFrame:GetPoint()
end

-- Main Frame Event Handler including Starts addon functions when variables are loaded
local function OnLoadFrame_OnEvent(this, event, arg1, arg2, arg3, arg4,...) 
	if Debug ~= 0 then
		local EventMsg = "PointTo - Событие:" .. event 
		if arg1~=nil then EventMsg = EventMsg .. " arg1: " .. arg1 end
		if arg2~=nil then EventMsg = EventMsg .. " arg2: " .. arg2 end
		if arg3~=nil then EventMsg = EventMsg .. " arg3: " .. arg3 end
		if arg4~=nil then EventMsg = EventMsg .. " arg4: " .. arg4 end
		if arg5~=nil then EventMsg = EventMsg .. " arg5: " .. arg5 end
		if arg6~=nil then EventMsg = EventMsg .. " arg6: " .. arg6 end
		if arg7~=nil then EventMsg = EventMsg .. " arg7: " .. arg7 end
		if arg8~=nil then EventMsg = EventMsg .. " arg8: " .. arg8 end
		if arg9~=nil then EventMsg = EventMsg .. " arg9: " .. arg9 end
		DOut(EventMsg)
	end
	if event=="VARIABLES_LOADED" then
		DOut("Populating frame posiitioning variables and creating Main Frame")
		if(not MainFrame) then MainFrame = 0 end
		if(not MainFrameYpos) then MainFrameYpos = 0 end
		if(not MainFramePoint) then MainFramePoint ="CENTER" end
        MainFrameCreate()
        if PointToDisabled ~= nil then
            MainFrame:Hide()
        end
    elseif ((event == "ZONE_CHANGED_NEW_AREA") or (event == "PLAYER_ENTERING_WORLD")) then
        if PointToDisabled == nil then
            if PointToAutoHide ~= nil then
                if TimerFrameElapsed~= 0 then
                    TimerFrameElapsed = 0
                else
                    TimerFrame:Hide()
                    TimerFrame:SetScript("OnUpdate", function(self, TimerFrameElap) 
                    TimerFrameElapsed = TimerFrameElapsed + TimerFrameElap
                    if TimerFrameElapsed < 5 then return end
                    PlayerXpos,PlayerYpos = GetPlayerMapPosition("player")
                    if PlayerXpos == 0 and PlayerYpos == 0 then
                        MainFrame:Hide()
                    else 
                        MainFrame:Show()
                    end
                    self:Hide()
                    TimerFrameElapsed=0
                    TimerFrame:SetScript("OnUpdate",nil)
                end)
                TimerFrame:Show()
                end
            end
        end
	end
end

local function PointToCalcDistance()
	if ( UnitXPos	- PlayerXpos) < 0 then
		DistanceX = -( UnitXPos - PlayerXpos) 
	else
		DistanceX = ( UnitXPos - PlayerXpos) 
	end
	
	if ( UnitYPos	- PlayerYpos) < 0 then
		DistanceY = -( UnitYPos - PlayerYpos) 
	else
		DistanceY = ( UnitYPos - PlayerYpos) 
	end
	Distance = DistanceX + DistanceY
end

-- ** Section on rotating textures around the center - NOT the texture required own center
local function CalcCorner(Angle)
	local r = rad(Angle);
	return 0.5 + cos(r) / s2, 0.5 + sin(r) / s2;
end

local function RotateTexture(texture, Angle)
	local LRx, LRy = CalcCorner(Angle + 45);
	local LLx, LLy = CalcCorner(Angle + 135);
	local ULx, ULy = CalcCorner(Angle + 225);
	local URx, URy = CalcCorner(Angle - 45);
	texture:SetTexCoord(ULx, ULy, LLx, LLy, URx, URy, LRx, LRy);
end

local function PointToGetPlayerLocs()
    -- Get Locs for Player
    PlayerXpos,PlayerYpos = GetPlayerMapPosition("player")
    PlayerXpos=PlayerXpos*100
    PlayerYpos=PlayerYpos*100
    -- Put locs for player on PointTo Frame
    LocXVal = string.format("%.4f", PlayerXpos)
    LocYVal = string.format("%.4f", PlayerYpos)
    TextLocXVal:SetText("|cFF00FFFF".. (string.format("%.1f", PlayerXpos)))
    TextLocYVal:SetText("|cFF00FFFF".. (string.format("%.1f", PlayerYpos)))
end

function PointToGetTargetLocs()
--		Loc = ("Player X:  ".. (string.format("%.4f", PlayerXpos)) .. "         Y: ".. (string.format("%.4f", PlayerYpos)))
		if ValidTargetType == 2 then
			UnitXPos=tonumber(Str1)
			UnitYPos=tonumber(Str2)
		else
			UnitXPos,UnitYPos = GetPlayerMapPosition(PointToUnit)
			UnitXPos=UnitXPos*100
			UnitYPos=UnitYPos*100	
		end
        if ValidTargetType ~= nil then
		    TarLoc =  ("party1 X: ".. (string.format("%.4f", UnitXPos)) .. "           Y: ".. (string.format("%.4f", UnitYPos)))
        end
		TempVal=(((math.atan2((UnitYPos)-PlayerYpos, (UnitXPos -PlayerXpos )))/math.pi/2)*360)+180    	--  calculates angle to party1 from player,   math.atan2 
																														--  gives the angle in pi +3.xxx to -3.xxx  and pi./ 180 gives angle in -180 to + 180,
																														--  final +180 is just to give positive only figure west is 0 and east is 180
--		if GetCVar("rotateMinimap") == "0" then             -- check if minimap has been set to rotate with the player
--			Facing = ((select(49,Minimap:GetChildren()):GetFacing()/math.pi/2)*360)
--		else
--			Facing = ((MiniMapCompassRing:GetFacing()/math.pi/2)*360)
--		end

--	 Attempt to fix changes for patch 3.1
		Facing = ((GetPlayerFacing()/math.pi/2)*360)

end

function MainFrame_OnUpdate(self, MainFrameElap)
	MainFrameElapsed = MainFrameElapsed + MainFrameElap
	if MainFrameElapsed < .1 then return end  -- .1 seems decent lag free setting
	MainFrameElapsed = 0 
    ValidTargetType = nil    -- nil = Entered Loc Invalid, 1 = Entered Loc is a Player,  2 = Entered Loc is a X,Y location
    InputLoc = GotoLoc:GetText()
    PointToGetPlayerLocs()
    if (PlayerXpos ~= 0 and PlayerYpos ~= 0) then 
        if InputLoc ~= nil and InputLoc ~= "" then
            if UnitExists(InputLoc) then      -- unit valid
                PointToUnit = InputLoc    
                ValidTargetType = 1
                PointToGetTargetLocs()
                MainText1:SetText(UnitName(PointToUnit))
            else
                Str1, Str2 =strsplit(",",InputLoc)
                if (tonumber(Str1) ~= nil and tonumber(Str2) ~= nil) then
                    ValidTargetType = 2
                    PointToGetTargetLocs()
                    MainText1:SetText("Поз введена")
                else 
                    MainText1:SetText("Поз неверна")
                end
            end
        else
            if UnitExists("Party1") then
                PointToUnit = "Party1"
                ValidTargetType = 1
                PointToGetTargetLocs()
                MainText1:SetText(UnitName(PointToUnit))
                
            else 
                MainText1:SetText("Не в группе")          
            end
        end
        if ((UnitXPos == 0) and  (UnitYPos ==0) and (ValidTargetType == 1)) then
            ArrowFrame:Hide()
            MainText2:SetText("Не та же зона")
        elseif ValidTargetType~=nil then
            ArrowFrame:Show()
            PointToCalcDistance()
            RotateTexture(ArrowTexture, -((Facing + TempVal)-90 )) -- Call to function that rotates texture less 90 Degrees since 0 is West,
-- 	    Extra rotation removed since 3.1 patch changes to improve arrow accuracy
--	    -10' more since the loc isnt center to character, Note whole equasion is Minused since it rotates the wrong way otherwise		
            if Distance < .4 then
                MainText2:SetText("Прибыли!")
            else
                MainText2:SetText(string.format("%.0f", Distance*10).." Ярдов")
            end
        else 
            ArrowFrame:Hide()
            MainText2:SetText("")
        end
    else
            ArrowFrame:Hide()
            MainText2:SetText("")
            MainText1:SetText("Нет Поз-й")
    end

--[[    --  ** Push Debug information to strings if Debug frame is Visible **
    if (DebugFrame:IsVisible()) then
        local DebugText1 =  ("Debug Info: GetPlayerBearing: ".. Facing)
        DebugText1:SetText(DebugText1)
        DebugText2:SetText("Angle of TargetUnit: " .. TempVal)
        DebugText3:SetText(Loc)
        DebugText4:SetText(TarLoc)	
        DebugText5:SetText("DistanceX: "..DistanceX .. "     DistanceY: " .. DistanceY)
    end
    ]]--
end

-- ** Define Slash Commands **
SLASH_PointTo1 = "/pointto"
SLASH_PointTo2 = "/PointTo"
SLASH_PointTo3 = "/pt"
SLASH_PointTo4 = "/PT"

SlashCmdList["PointTo"] = PointTo_Command

-- Main Code for Addon Begins here trigger for main code is the saved variables being loaded

OnLoadFrame:RegisterEvent("VARIABLES_LOADED")
OnLoadFrame:RegisterEvent("ZONE_CHANGED_NEW_AREA")
OnLoadFrame:RegisterEvent("PLAYER_ENTERING_WORLD")
OnLoadFrame:SetScript("OnEvent", OnLoadFrame_OnEvent)
