--[[
	This file keeps track of aura duration and debuff type.
	I'm opting to use PvP durations when possible.
	
]]

local lib = LibStub("LibAuraInfo-1.0");
if(not lib) then error("spellIdData.lua for LibAuraInfo needs library loaded."); return; end

local myDataVersion = 1277784451;
if(lib.auraInfo and myDataVersion <= lib.spellIdDataVersion) then return; end
lib.spellIdDataVersion = myDataVersion;

--~ local mem1 = collectgarbage("count")
lib.auraInfo = {
[67] = "10;1", --Vindication (Rank 1)
[118] = "50;1", --Polymorph (Rank 1)
[130] = "30;1", --Slow Fall
[131] = "600;0", --Water Breathing
[132] = "600;1", --Detect Invisibility
[168] = "1800;0", --Frost Armor (Rank 1)
[324] = "600;1", --Lightning Shield (Rank 1)
[339] = "27;1", --Entangling Roots (Rank 1)
[355] = "3;0", --Taunt
[498] = "12;1", --Divine Protection
[546] = "600;0", --Water Walking
[552] = "12;1", --Abolish Disease
[588] = "1800;0", --Inner Fire (Rank 1)
[602] = "1800;0", --Inner Fire (Rank 3)
[604] = "600;1", --Dampen Magic (Rank 1)
[605] = "60;1", --Mind Control
[642] = "12;1", --Divine Shield
[643] = "0;0", --Devotion Aura (Rank 3)
[673] = "3600;0", --Lesser Armor
[694] = "6;0", --Mocking Blow
[706] = "1800;0", --Demon Armor (Rank 1)
[768] = "0;0", --Cat Form (Shapeshift)
[770] = "300;1", --Faerie Fire
[782] = "600;1", --Thorns (Rank 2)
[783] = "0;0", --Travel Form (Shapeshift)
[871] = "12;0", --Shield Wall
[905] = "600;1", --Lightning Shield (Rank 3)
[976] = "600;1", --Shadow Protection (Rank 1)
[982] = "3;0", --Revive Pet
[1006] = "1800;0", --Inner Fire (Rank 4)
[1032] = "0;0", --Devotion Aura (Rank 5)
[1038] = "10;1", --Hand of Salvation
[1044] = "6;1", --Hand of Freedom
[1066] = "0;0", --Aquatic Form (Shapeshift)
[1075] = "600;1", --Thorns (Rank 3)
[1126] = "1800;1", --Mark of the Wild (Rank 1)
[1161] = "6;0", --Challenging Shout
[1243] = "1800;1", --Power Word: Fortitude (Rank 1)
[1244] = "1800;1", --Power Word: Fortitude (Rank 2)
[1245] = "1800;1", --Power Word: Fortitude (Rank 3)
[1330] = "3;0", --Garrote - Silence
[1459] = "1800;1", --Arcane Intellect (Rank 1)
[1460] = "1800;1", --Arcane Intellect (Rank 2)
[1461] = "1800;1", --Arcane Intellect (Rank 3)
[1513] = "20;1", --Scare Beast (Rank 1)
[1539] = "10;0", --Feed Pet
[1543] = "0;0", --Flare
[1604] = "4;0", --Dazed
[1706] = "120;1", --Levitate
[1715] = "15;0", --Hamstring
[1719] = "12;0", --Recklessness
[1776] = "4;0", --Gouge
[1784] = "0;0", --Stealth
[1833] = "4;0", --Cheap Shot
[1953] = "1;0", --Blink
[2094] = "10;0", --Blind
[2367] = "3600;0", --Lesser Strength
[2374] = "3600;0", --Lesser Agility
[2378] = "3600;0", --Health
[2479] = "30;0", --Honorless Target
[2565] = "10;0", --Shield Block
[2584] = "0;0", --Waiting to Resurrect
[2645] = "0;1", --Ghost Wolf
[2791] = "1800;1", --Power Word: Fortitude (Rank 4)
[2825] = "40;1", --Bloodlust
[2893] = "12;1", --Abolish Poison
[2895] = "0;0", --Wrath of Air Totem
[3034] = "8;3", --Viper Sting
[3043] = "20;3", --Scorpid Sting
[3045] = "15;0", --Rapid Fire
[3166] = "3600;0", --Lesser Intellect
[3355] = "20;1", --Freezing Trap Effect (Rank 1)
[3409] = "12;3", --Crippling Poison
[3436] = "300;2", --Wandering Plague
[3600] = "5;1", --Earthbind
[3714] = "600;0", --Path of Frost
[4167] = "4;1", --Web (Rank 1)
[4511] = "0;0", --Phase Shift
[5116] = "4;0", --Concussive Shot
[5118] = "0;0", --Aspect of the Cheetah
[5209] = "6;0", --Challenging Roar
[5215] = "0;0", --Prowl
[5229] = "10;0", --Enrage
[5232] = "1800;1", --Mark of the Wild (Rank 2)
[5234] = "1800;1", --Mark of the Wild (Rank 4)
[5384] = "360;0", --Feign Death
[5484] = "6;1", --Howl of Terror (Rank 1)
[5487] = "0;0", --Bear Form (Shapeshift)
[5697] = "600;0", --Unending Breath
[5760] = "10;3", --Mind-numbing Poison
[6150] = "12;0", --Quick Shots
[6196] = "0;0", --Far Sight
[6215] = "20;1", --Fear (Rank 3)
[6307] = "0;0", --Blood Pact (Rank 1)
[6346] = "180;1", --Fear Ward
[6358] = "15;1", --Seduction
[6562] = "0;0", --Heroic Presence (Racial Passive)
[6653] = "0;0", --Dire Wolf
[6756] = "1800;1", --Mark of the Wild (Rank 3)
[6770] = "60;0", --Sap (Rank 1)
[6774] = "6;0",  --Slice and Dice (Rank 2)
[6788] = "15;0", --Weakened Soul
[6795] = "3;0", --Growl
[7178] = "1800;0", --Water Breathing (Rank 1)
[7300] = "1800;0", --Frost Armor (Rank 2)
[7301] = "1800;0", --Frost Armor (Rank 3)
[7302] = "1800;0", --Ice Armor (Rank 1)
[7321] = "5;1", --Chilled (Rank 1)
[7353] = "60;0", --Cozy Fire
[7744] = "0;0", --Will of the Forsaken (Racial)
[7804] = "0;0", --Blood Pact (Rank 2)
[7870] = "300;0", --Lesser Invisibility
[7922] = "2;0", --Charge Stun (1.5 seconds)
[8178] = "0;0", --Grounding Totem Effect (Rank 1)
[8212] = "1200;0", --Enlarge
[8219] = "3600;0", --Flip Out
[8220] = "3600;0", --Flip Out
[8221] = "3600;0", --Yaaarrrr
[8222] = "3600;0", --Yaaarrrr
[8326] = "0;0", --Ghost
[8385] = "3600;1", --Swift Wind
[8395] = "0;0", --Emerald Raptor
[8515] = "0;0", --Windfury Totem (Rank 1)
[8643] = "6;0", --Kidney Shot (Rank 2)
[8647] = "6;0", --Expose Armor
[8907] = "1800;1", --Mark of the Wild (Rank 5)
[8914] = "600;1", --Thorns (Rank 4)
[8983] = "4;0", --Bash (Rank 3)
[9484] = "30;1", --Shackle Undead (Rank 1)
[9485] = "40;1", --Shackle Undead (Rank 2)
[9634] = "0;0", --Dire Bear Form (Shapeshift)
[9756] = "600;1", --Thorns (Rank 5)
[9884] = "1800;1", --Mark of the Wild (Rank 6)
[9885] = "1800;1", --Mark of the Wild (Rank 7)
[10060] = "15;1", --Power Infusion
[10156] = "1800;1", --Arcane Intellect (Rank 4)
[10157] = "1800;1", --Arcane Intellect (Rank 5)
[10219] = "1800;0", --Ice Armor (Rank 3)
[10220] = "1800;0", --Ice Armor (Rank 4)
[10278] = "10;1", --Hand of Protection (Rank 3)
[10290] = "0;0", --Devotion Aura (Rank 2)
[10291] = "0;0", --Devotion Aura (Rank 4)
[10293] = "0;0", --Devotion Aura (Rank 7)
[10298] = "0;0", --Retribution Aura (Rank 2)
[10299] = "0;0", --Retribution Aura (Rank 3)
[10300] = "0;0", --Retribution Aura (Rank 4)
[10301] = "0;0", --Retribution Aura (Rank 5)
[10308] = "6;1", --Hammer of Justice (Rank 4)
[10326] = "20;1", --Turn Evil
[10431] = "600;1", --Lightning Shield (Rank 6)
[10796] = "0;0", --Turquoise Raptor
[10799] = "0;0", --Violet Raptor
[10890] = "8;1", --Psychic Scream (Rank 4)
[10894] = "18;1", --Shadow Word: Pain (Rank 8)
[10901] = "30;1", --Power Word: Shield (Rank 10)
[10937] = "1800;1", --Power Word: Fortitude (Rank 5)
[10938] = "1800;1", --Power Word: Fortitude (Rank 6)
[10951] = "1800;0", --Inner Fire (Rank 5)
[10952] = "1800;0", --Inner Fire (Rank 6)
[10955] = "50;1", --Shackle Undead (Rank 3)
[10957] = "1200;1", --Shadow Protection (Rank 2)
[10958] = "600;1", --Shadow Protection (Rank 3)
[11196] = "60;0", --Recently Bandaged
[11305] = "15;0", --Sprint (Rank 3)
[11549] = "120;0", --Battle Shout (Rank 4)
[11719] = "12;4", --Curse of Tongues (Rank 2)
[11733] = "1800;0", --Demon Armor (Rank 3)
[12042] = "15;1", --Arcane Power
[12043] = "0;1", --Presence of Mind
[12051] = "8;0", --Evocation
[12169] = "5;0", --Shield Block
[12323] = "6;0", --Piercing Howl
[12328] = "30;0", --Sweeping Strikes
[12472] = "20;1", --Icy Veins
[12494] = "5;1", --Frostbite
[12536] = "15;1", --Clearcasting
[12544] = "1800;1", --Frost Armor
[12579] = "15;1", --Winter's Chill
[12654] = "4;1", --Ignite
[12721] = "6;0", --Deep Wounds
[12809] = "5;0", --Concussion Blow
[12970] = "15;0", --Flurry (Rank 5)
[12976] = "20;0", --Last Stand
[13159] = "0;0", --Aspect of the Pack
[13163] = "0;0", --Aspect of the Monkey
[13165] = "0;0", --Aspect of the Hawk (Rank 1)
[13443] = "15;0", --Rend
[13750] = "15;0", --Adrenaline Rush
[13810] = "0;0", --Frost Trap Aura
[13877] = "15;0", --Blade Flurry
[14149] = "20;0", --Remorseless (Rank 2)
[14177] = "0;0", --Cold Blood
[14203] = "12;0", --Enrage (Rank 4)
[14267] = "0;0", --Horde Flag
[14268] = "0;0", --Alliance Flag
[14278] = "7;0", --Ghostly Strike
[14308] = "20;1", --Freezing Trap Effect (Rank 2)
[14309] = "20;1", --Freezing Trap Effect (Rank 3)
[14318] = "0;0", --Aspect of the Hawk (Rank 2)
[14319] = "0;0", --Aspect of the Hawk (Rank 3)
[14320] = "0;0", --Aspect of the Hawk (Rank 4)
[14321] = "0;0", --Aspect of the Hawk (Rank 5)
[14322] = "0;0", --Aspect of the Hawk (Rank 6)
[14325] = "120;1", --Hunter's Mark (Rank 4)
[14751] = "0;1", --Inner Focus
[14752] = "1800;1", --Divine Spirit (Rank 1)
[14818] = "1800;1", --Divine Spirit (Rank 2)
[14819] = "1800;1", --Divine Spirit (Rank 3)
[14893] = "15;1", --Inspiration (Rank 1)
[15007] = "600;0", --Resurrection Sickness (assuming level 20+)
[15258] = "15;1", --Shadow Weaving (Rank 1)
[15271] = "15;1", --Spirit Tap (Rank 1)
[15286] = "1800;0", --Vampiric Embrace
[15359] = "15;1", --Inspiration (Rank 3)
[15473] = "0;0", --Shadowform
[15487] = "5;1", --Silence
[15571] = "4;0",  --Dazed
[15588] = "0;1", --Thunderclap
[15708] = "0;0", --Mortal Strike
[16166] = "30;1", --Elemental Mastery
[16188] = "0;1", --Nature's Swiftness
[16236] = "15;1", --Ancestral Fortitude (Rank 2)
[16237] = "15;1", --Ancestral Fortitude (Rank 3)
[16246] = "15;1", --Clearcasting
[16280] = "15;0", --Flurry (Rank 5)
[16468] = "0;3", --Mother's Milk
[16491] = "6;0", --Blood Craze
[16509] = "15;0", --Rend
[16567] = "600;4", --Tainted Mind
[16591] = "600;1", --Noggenfogger Elixir
[16593] = "15;1", --Noggenfogger Elixir
[16595] = "600;1", --Noggenfogger Elixir
[16609] = "3600;0", --Warchief's Blessing
[16857] = "300;1", --Faerie Fire (Feral)
[16870] = "15;1", --Clearcasting
[16886] = "3;1", --Nature's Grace
[17116] = "0;1", --Nature's Swiftness
[17229] = "0;0", --Winterspring Frostsaber
[17364] = "12;0", --Stormstrike
[17465] = "0;0", --Green Skeletal Warhorse
[17481] = "0;0", --Rivendare's Deathcharger
[17539] = "7200;0", --Greater Arcane Elixir
[17619] = "0;0", --Alchemist's Stone
[17670] = "0;0", --Argent Dawn Commission
[17800] = "30;1", --Shadow Mastery
[17928] = "8;1", --Howl of Terror (Rank 2)
[17941] = "10;1", --Shadow Trance
[17962] = "6;0", --Conflagrate
[18118] = "5;1", --Aftermath
[18223] = "12;4", --Curse of Exhaustion
[18425] = "2;1", --Silenced - Improved Kick
[18469] = "2;1", --Silenced - Improved Counterspell	 (Rank 1)
[18498] = "3;1", --Silenced - Gag Order
[18499] = "10;0", --Berserker Rage
[18647] = "30;1", --Banish (Rank 2)
[18657] = "40;1", --Hibernate (Rank 2)
[18708] = "15;0", --Fel Domination
[18990] = "0;0", --Brown Kodo
[19136] = "0;0", --Stormbolt
[19263] = "5;0", --Deterrence
[19503] = "4;0", --Scatter Shot
[19506] = "0;0", --Trueshot Aura
[19574] = "10;0", --Bestial Wrath
[19579] = "0;0", --Spirit Bond (Rank 1)
[19615] = "8;0",  --Frenzy Effect (Rank 1)
[19683] = "900;0", --Tame Armored Scorpid
[19742] = "600;1", --Blessing of Wisdom (Rank 1)
[19746] = "0;0", --Concentration Aura
[19821] = "5;1", --Arcane Bomb
[19835] = "600;1", --Blessing of Might (Rank 3)
[19836] = "600;1", --Blessing of Might (Rank 4)
[19837] = "600;1", --Blessing of Might (Rank 5)
[19838] = "1800;1", --Blessing of Might (Rank 6)
[19853] = "600;1", --Blessing of Wisdom (Rank 4)
[19899] = "0;0", --Fire Resistance Aura (Rank 2)
[20005] = "5;0", --Chilled
[20007] = "15;0", --Holy Strength
[20053] = "30;1", --Vengeance
[20066] = "60;1", --Repentance
[20132] = "10;0", --Redoubt
[20164] = "1800;0", --Seal of Justice
[20165] = "1800;0", --Seal of Light
[20166] = "1800;0", --Seal of Wisdom
[20170] = "2;0", --Stun
[20178] = "8;0", --Reckoning
[20184] = "20;1", --Judgement of Justice
[20185] = "20;1", --Judgement of Light (Rank 1)
[20186] = "20;1", --Judgement of Wisdom (Rank 1)
[20216] = "0;1", --Divine Favor
[20217] = "600;1", --Blessing of Kings
[20230] = "12;0", --Retaliation
[20236] = "15;1", --Lay on Hands (Rank 2)
[20253] = "3;0", --Intercept (Rank 1)
[20375] = "1800;0", --Seal of Command
[20511] = "8;0", --Intimidating Shout
[20549] = "2;0", --War Stomp (Racial)
[20572] = "15;0", --Blood Fury (Racial)
[20578] = "10;0", --Cannibalize
[20736] = "6;0", --Distracting Shot
[20911] = "600;1", --Blessing of Sanctuary
[21084] = "1800;0", --Seal of Righteousness
[21183] = "20;0", --Heart of the Crusader (Rank 1)
[21553] = "10;0", --Mortal Strike (Rank 4)
[21564] = "3600;1", --Prayer of Fortitude (Rank 2)
[21850] = "3600;1", --Gift of the Wild (Rank 2)
[22717] = "0;0", --Black War Steed
[22718] = "0;0", --Black War Kodo
[22719] = "0;0", --Black Battlestrider
[22720] = "0;0", --Black War Ram
[22721] = "0;0", --Black War Raptor
[22722] = "0;0", --Red Skeletal Warhorse
[22723] = "0;0", --Black War Tiger
[22724] = "0;0", --Black War Wolf
[22782] = "1800;0", --Mage Armor (Rank 2)
[22812] = "12;1", --Barkskin
[22842] = "10;0", --Frenzied Regeneration
[22888] = "7200;0", --Rallying Cry of the Dragonslayer
[22911] = "0;0", --Charge
[22959] = "30;1", --Improved Scorch
[23028] = "3600;1", --Arcane Brilliance (Rank 1)
[23033] = "0;0", --Battle Standard
[23036] = "0;0", --Battle Standard
[23161] = "0;0", --Dreadsteed (Summon)
[23214] = "0;0", --Charger (Summon)
[23219] = "0;0", --Swift Mistsaber
[23221] = "0;0", --Swift Frostsaber
[23227] = "0;0", --Swift Palomino
[23228] = "0;0", --Swift White Steed
[23229] = "0;0", --Swift Brown Steed
[23238] = "0;0", --Swift Brown Ram
[23239] = "0;0", --Swift Gray Ram
[23240] = "0;0", --Swift White Ram
[23241] = "0;0", --Swift Blue Raptor
[23242] = "0;0", --Swift Olive Raptor
[23243] = "0;0", --Swift Orange Raptor
[23246] = "0;0", --Purple Skeletal Warhorse
[23247] = "0;0", --Great White Kodo
[23248] = "0;0", --Great Gray Kodo
[23249] = "0;0", --Great Brown Kodo
[23250] = "0;0", --Swift Brown Wolf
[23251] = "0;0", --Swift Timber Wolf
[23252] = "0;0", --Swift Gray Wolf
[23333] = "0;0", --Warsong Flag
[23335] = "0;0", --Silverwing Flag
[23338] = "0;0", --Swift Stormsaber
[23451] = "10;0", --Speed
[23493] = "10;0", --Restoration
[23509] = "0;0", --Frostwolf Howler
[23510] = "0;0", --Stormpike Battle Charger
[23511] = "0;0", --Demoralizing Shout
[23693] = "120;0", --Stormpike's Salvation
[23694] = "5;0", --Improved Hamstring
[23885] = "8;0", --Bloodthirst
[23920] = "5;0", --Spell Reflection
[23978] = "10;0", --Speed
[24242] = "0;0", --Swift Razzashi Raptor
[24252] = "0;0", --Swift Zulian Tiger
[24259] = "3;1", --Spell Lock
[24378] = "60;0", --Berserking
[24398] = "600;1", --Water Shield (Rank 7)
[24450] = "0;0", --Prowl (Rank 1)
[24452] = "0;0", --Prowl (Rank 2)
[24529] = "0;0", --Spirit Bond (Rank 2)
[24711] = "3600;0", --Ninja Costume
[24735] = "3600;0", --Ghost Costume
[24858] = "0;0", --Moonkin Form (Shapeshift)
[24907] = "0;0", --Moonkin Aura
[24932] = "0;0", --Leader of the Pack
[25046] = "2;1", --Arcane Torrent (Racial)
[25163] = "0;0", --Oozeling's Disgusting Aura
[25228] = "0;0", --Soul Link
[25291] = "600;1", --Blessing of Might (Rank 7)
[25296] = "0;0", --Aspect of the Hawk (Rank 7)
[25312] = "1800;1", --Divine Spirit (Rank 5)
[25389] = "1800;1", --Power Word: Fortitude (Rank 7)
[25392] = "3600;1", --Prayer of Fortitude (Rank 3)
[25433] = "600;1", --Shadow Protection (Rank 4)
[25472] = "600;1", --Lightning Shield (Rank 9)
[25771] = "120;0", --Forbearance
[25780] = "120;1", --Righteous Fury
[25804] = "900;0", --Rumsey Rum Black Label
[25809] = "12;3", --Crippling Poison (Rank 1)
[25810] = "12;3", --Mind-numbing Poison
[25898] = "1800;1", --Greater Blessing of Kings
[25899] = "1800;1", --Greater Blessing of Sanctuary
[26004] = "1800;0", --Mistletoe
[26013] = "900;0", --Deserter
[26017] = "10;1", --Vindication (Rank 2)
[26297] = "10;0", --Berserking (Racial)
[26669] = "15;0", --Evasion (Rank 2)
[26864] = "15;0", --Hemorrhage (Rank 4)
[26888] = "10;0", --Vanish (Rank 3)
[26990] = "1800;1", --Mark of the Wild (Rank 8)
[26991] = "3600;1", --Gift of the Wild (Rank 3)
[26992] = "600;1", --Thorns (Rank 7)
[27044] = "0;0", --Aspect of the Hawk (Rank 8)
[27089] = "30;0", --Drink
[27124] = "1800;0", --Ice Armor (Rank 5)
[27126] = "1800;1", --Arcane Intellect (Rank 6)
[27127] = "3600;1", --Arcane Brilliance (Rank 2)
[27142] = "600;1", --Blessing of Wisdom (Rank 7)
[27143] = "1800;1", --Greater Blessing of Wisdom (Rank 3)
[27149] = "0;0", --Devotion Aura (Rank 8)
[27150] = "0;0", --Retribution Aura (Rank 6)
[27151] = "0;0", --Shadow Resistance Aura (Rank 4)
[27152] = "0;0", --Frost Resistance Aura (Rank 4)
[27268] = "0;0", --Blood Pact (Rank 6)
[27813] = "6;1", --Blessed Recovery (Rank 1)
[27818] = "6;1", --Blessed Recovery (Rank 3)
[27827] = "15;0", --Spirit of Redemption
[27828] = "6;1", --Focused Casting (Rank 2)
[27841] = "1800;1", --Divine Spirit (Rank 4)
[28093] = "15;0", --Lightning Speed
[28176] = "1800;0", --Fel Armor (Rank 1)
[28497] = "3600;0", --Mighty Agility
[28520] = "7200;0", --Flask of Relentless Assault
[28730] = "2;1", --Arcane Torrent (Racial)
[28878] = "0;0", --Heroic Presence (Racial Passive)
[29131] = "10;0", --Bloodrage
[29166] = "10;1", --Innervate
[29177] = "10;0", --Elemental Devastation (Rank 2)
[29178] = "10;0", --Elemental Devastation (Rank 3)
[29348] = "3600;0", --Goldenmist Special Brew
[29703] = "6;0", --Dazed
[29801] = "0;0", --Rampage (Passive)
[29842] = "10;0", --Second Wind (Rank 2)
[30070] = "0;0", --Blood Frenzy (Rank 2)
[30708] = "0;0", --Totem of Wrath
[30802] = "0;0", --Unleashed Rage (Rank 1)
[30809] = "0;0", --Unleashed Rage (Rank 3)
[30823] = "15;0", --Shamanistic Rage
[31224] = "5;0", --Cloak of Shadows
[31579] = "0;0", --Arcane Empowerment (Rank 1)
[31583] = "0;0", --Arcane Empowerment (Rank 3)
[31589] = "15;1", --Slow
[31616] = "10;0", --Nature's Guardian
[31661] = "5;1", --Dragon's Breath (Rank 1)
[31665] = "6;0", --Master of Subtlety
[31790] = "3;0", --Righteous Defense
[31801] = "1800;0", --Seal of Vengeance
[31803] = "15;1", --Holy Vengeance (Rank 1)
[31821] = "6;0", --Aura Mastery
[31834] = "15;1", --Light's Grace
[31842] = "15;1", --Divine Illumination
[31884] = "20;1", --Avenging Wrath
[32182] = "40;1", --Heroism
[32223] = "0;0", --Crusader Aura
[32243] = "0;0", --Tawny Wind Rider
[32244] = "0;0", --Blue Wind Rider
[32245] = "0;0", --Green Wind Rider
[32246] = "0;0", --Swift Red Wind Rider
[32295] = "0;0", --Swift Green Wind Rider
[32297] = "0;0", --Swift Purple Wind Rider
[32388] = "12;1", --Shadow Embrace
[32390] = "12;1", --Shadow Embrace
[32391] = "12;1", --Shadow Embrace
[32600] = "10;0", --Avoidance
[32612] = "0;0", --Invisibility
[32851] = "10;0", --Demonic Frenzy
[32999] = "3600;1", --Prayer of Spirit (Rank 2)
[33041] = "5;1", --Dragon's Breath (Rank 2)
[33042] = "5;1", --Dragon's Breath (Rank 3)
[33043] = "5;1", --Dragon's Breath (Rank 4)
[33197] = "24;0", --Misery (Rank 2)
[33198] = "24;0", --Misery (Rank 3)
[33206] = "8;1", --Pain Suppression
[33256] = "1800;0", --Well Fed
[33263] = "1800;0", --Well Fed
[33268] = "1800;0", --Well Fed
[33280] = "0;0", --Corporal
[33357] = "15;0", --Dash (Rank 3)
[33395] = "2;1", --Freeze
[33660] = "0;0", --Swift Pink Hawkstrider
[33697] = "15;0", --Blood Fury (Racial)
[33721] = "3600;0", --Spellpower Elixir
[33736] = "600;1", --Water Shield (Rank 8)
[33763] = "7;1", --Lifebloom (Rank 1)
[33786] = "6;0", --Cyclone
[33891] = "0;0", --Tree of Life (Shapeshift)
[33943] = "0;0", --Flight Form (Shapeshift)
[34027] = "30;0", --Kill Command (Rank 1)
[34074] = "0;0", --Aspect of the Viper
[34123] = "0;0", --Tree of Life (Passive)
[34321] = "10;0", --Call of the Nexus
[34471] = "10;0", --The Beast Within
[34477] = "30;0", --Misdirection
[34490] = "3;1", --Silencing Shot
[34501] = "7;1", --Expose Weakness
[34655] = "8;3", --Deadly Poison
[34767] = "0;0", --Summon Charger (Summon)
[34769] = "0;0", --Summon Warhorse (Summon)
[34790] = "0;0", --Dark War Talbuk
[34795] = "0;0", --Red Hawkstrider
[34837] = "8;0", --Master Tactician (Rank 5)
[34896] = "0;0", --Cobalt War Talbuk
[34897] = "0;0", --White War Talbuk
[34898] = "0;0", --Silver War Talbuk
[34899] = "0;0", --Tan War Talbuk
[34936] = "8;1", --Backlash
[35020] = "0;0", --Blue Hawkstrider
[35025] = "0;0", --Swift Green Hawkstrider
[35027] = "0;0", --Swift Purple Hawkstrider
[35028] = "0;0", --Swift Warstrider
[35098] = "20;0", --Rapid Killing (Rank 1)
[35099] = "20;0", --Rapid Killing (Rank 2)
[35101] = "4;0", --Concussive Barrage
[35696] = "0;0", --Demonic Knowledge
[35706] = "0;0", --Master Demonologist
[35713] = "0;0", --Great Blue Elekk
[35714] = "0;0", --Great Purple Elekk
[36032] = "6;0", --Arcane Blast
[36444] = "0;0", --Wintergrasp Water
[36554] = "3;0", --Shadowstep
[36563] = "10;0", --Shadowstep
[37795] = "0;0", --Recruit
[38384] = "8;1", --Cone of Cold
[39315] = "0;0", --Cobalt Riding Talbuk
[39316] = "0;0", --Dark Riding Talbuk
[39317] = "0;0", --Silver Riding Talbuk
[39319] = "0;0", --White Riding Talbuk
[39374] = "1200;1", --Prayer of Shadow Protection (Rank 2)
[39439] = "10;0", --Aura of the Crusader
[39627] = "3600;0", --Elixir of Draenic Wisdom
[39796] = "3;1", --Stoneclaw Stun
[39800] = "0;0", --Red Riding Nether Ray
[39802] = "0;0", --Silver Riding Nether Ray
[40120] = "0;0", --Swift Flight Form (Shapeshift)
[40623] = "3600;0", --Apexis Vibrations
[40625] = "5400;0", --Apexis Emanations
[41252] = "0;0", --Raven Lord
[41425] = "30;0", --Hypothermia
[41514] = "0;0", --Azure Netherwing Drake
[41516] = "0;0", --Purple Netherwing Drake
[42138] = "7200;0", --Brewfest Enthusiast
[42292] = "0;0", --PvP Trinket
[42650] = "4;0", --Army of the Dead
[42842] = "9;1", --Frostbolt (Rank 16)
[42891] = "0;0", --Pyroblast (Rank 12)
[42917] = "8;1", --Frost Nova (Rank 6)
[42931] = "11;1", --Cone of Cold (Rank 8)
[42949] = "5;1", --Dragon's Breath (Rank 5)
[42950] = "5;1", --Dragon's Breath (Rank 6)
[42995] = "1800;1", --Arcane Intellect (Rank 7)
[43002] = "3600;1", --Arcane Brilliance (Rank 3)
[43008] = "1800;0", --Ice Armor (Rank 6)
[43010] = "30;1", --Fire Ward (Rank 7)
[43012] = "30;1", --Frost Ward (Rank 7)
[43015] = "600;1", --Dampen Magic (Rank 7)
[43020] = "60;1", --Mana Shield (Rank 9)
[43024] = "1800;0", --Mage Armor (Rank 6)
[43038] = "60;1", --Ice Barrier (Rank 7)
[43039] = "60;1", --Ice Barrier (Rank 8)
[43045] = "1800;0", --Molten Armor (Rank 2)
[43046] = "1800;0", --Molten Armor (Rank 3)
[43180] = "30;0", --Food
[43183] = "30;0", --Drink
[43196] = "1800;1", --Armor (Rank 6)
[43265] = "0;0", --Death and Decay (Rank 1)
[43680] = "60;0", --Idle
[43681] = "60;0", --Inactive
[43688] = "0;0", --Amani War Bear
[43751] = "10;0", --Energized
[43771] = "3600;0", --Well Fed
[43900] = "0;0", --Swift Brewfest Ram
[43927] = "0;0", --Cenarion War Hippogryph
[44151] = "0;0", --Turbo-Charged Flying Machine
[44153] = "0;0", --Flying Machine
[44401] = "15;1", --Missile Barrage
[44413] = "10;1", --Incanter's Absorption
[44521] = "0;0", --Preparation
[44535] = "6;0", --Spirit Heal
[44572] = "5;1", --Deep Freeze
[44795] = "0;0", --Parachute
[45182] = "3;0", --Cheating Death
[45241] = "8;1", --Focused Will (Rank 2)
[45242] = "8;1", --Focused Will (Rank 3)
[45282] = "8;1", --Natural Perfection (Rank 2)
[45283] = "8;1", --Natural Perfection (Rank 3)
[45334] = "4;0", --Feral Charge Effect
[45373] = "7200;0", --Bloodberry
[45438] = "10;1", --Ice Block
[45472] = "60;0", --Parachute
[45524] = "10;1", --Chains of Ice
[45529] = "20;0", --Blood Tap
[45544] = "8;0", --First Aid (Rank 15)
[45548] = "30;0", --Food
[46168] = "0;0", --Pet Biscuit
[46199] = "0;0", --X-51 Nether-Rocket X-TREME
[46356] = "300;0", --Blood Elf Illusion
[46604] = "4;1", --Ice Block
[46628] = "0;0", --Swift White Hawkstrider
[46833] = "15;0", --Wrath of Elune
[46857] = "60;0", --Trauma (Rank 2)
[46916] = "5;0", --Slam!
[46924] = "6;0", --Bladestorm
[46968] = "4;0", --Shockwave
[46987] = "4;1", --Frostbolt
[46989] = "4;1", --Improved Blink
[47241] = "30;0", --Metamorphosis
[47436] = "120;0", --Battle Shout (Rank 9)
[47437] = "30;0", --Demoralizing Shout (Rank 8)
[47440] = "120;0", --Commanding Shout (Rank 3)
[47465] = "15;0", --Rend (Rank 10)
[47476] = "5;1", --Strangulate
[47481] = "3;0", --Gnaw
[47486] = "10;0", --Mortal Strike (Rank 8)
[47502] = "30;0", --Thunder Clap (Rank 9)
[47585] = "6;0", --Dispersion
[47610] = "12;1", --Frostfire Bolt (Rank 2)
[47753] = "12;1", --Divine Aegis (Rank 1)
[47811] = "15;1", --Immolate (Rank 11)
[47813] = "18;1", --Corruption (Rank 10)
[47823] = "15;0", --Hellfire (Rank 5)
[47836] = "18;1", --Seed of Corruption (Rank 3)
[47843] = "15;1", --Unstable Affliction (Rank 5)
[47847] = "3;1", --Shadowfury (Rank 5)
[47855] = "15;0", --Drain Soul (Rank 6)
[47856] = "9;0", --Health Funnel (Rank 9)
[47857] = "5;1", --Drain Life (Rank 9)
[47860] = "3;1", --Death Coil (Rank 6)
[47864] = "24;4", --Curse of Agony (Rank 9)
[47865] = "300;4", --Curse of the Elements (Rank 5)
[47883] = "900;0", --Soulstone Resurrection
[47889] = "1800;0", --Demon Armor (Rank 8)
[47891] = "30;1", --Shadow Ward (Rank 6)
[47893] = "1800;0", --Fel Armor (Rank 4)
[47930] = "15;1", --Grace
[47982] = "0;0", --Blood Pact (Rank 7)
[47983] = "180;1", --Fire Shield (Rank 7)
[47986] = "30;1", --Sacrifice (Rank 9)
[47988] = "6;0", --Consume Shadows (Rank 9)
[47990] = "15;1", --Suffering (Rank 8)
[47995] = "3;0", --Intercept (Rank 4)
[48018] = "360;0", --Demonic Circle: Summon
[48024] = "0;0", --Headless Horseman's Mount
[48027] = "0;0", --Black War Elekk
[48040] = "1800;0", --Inner Fire (Rank 8)
[48065] = "30;1", --Power Word: Shield (Rank 13)
[48066] = "30;1", --Power Word: Shield (Rank 14)
[48068] = "15;1", --Renew (Rank 14)
[48073] = "1800;1", --Divine Spirit (Rank 6)
[48074] = "3600;1", --Prayer of Spirit (Rank 3)
[48090] = "45;0", --Demonic Pact
[48101] = "1800;1", --Stamina (Level 6)
[48111] = "30;1", --Prayer of Mending (Rank 3)
[48125] = "18;1", --Shadow Word: Pain (Rank 12)
[48135] = "7;1", --Holy Fire (Rank 11)
[48156] = "3;0", --Mind Flay (Rank 9)
[48160] = "15;1", --Vampiric Touch (Rank 5)
[48161] = "1800;1", --Power Word: Fortitude (Rank 8)
[48162] = "3600;1", --Prayer of Fortitude (Rank 4)
[48168] = "1800;0", --Inner Fire (Rank 9)
[48169] = "600;1", --Shadow Protection (Rank 5)
[48170] = "1200;1", --Prayer of Shadow Protection (Rank 3)
[48263] = "0;0", --Frost Presence
[48265] = "0;0", --Unholy Presence
[48266] = "0;0", --Blood Presence
[48300] = "24;2", --Devouring Plague (Rank 9)
[48301] = "10;1", --Mind Trauma
[48391] = "10;0", --Owlkin Frenzy
[48418] = "0;0", --Master Shapeshifter
[48420] = "0;0", --Master Shapeshifter
[48421] = "0;0", --Master Shapeshifter
[48422] = "0;0", --Master Shapeshifter
[48441] = "15;1", --Rejuvenation (Rank 15)
[48443] = "21;1", --Regrowth (Rank 12)
[48446] = "0;0", --Tranquility (Rank 6)
[48447] = "7;0", --Tranquility (Rank 7)
[48450] = "7;1", --Lifebloom (Rank 2)
[48451] = "7;1", --Lifebloom (Rank 3)
[48463] = "12;1", --Moonfire (Rank 14)
[48467] = "0;0", --Hurricane (Rank 5)
[48468] = "14;1", --Insect Swarm (Rank 7)
[48469] = "1800;1", --Mark of the Wild (Rank 9)
[48470] = "3600;1", --Gift of the Wild (Rank 4)
[48504] = "15;0", --Living Seed
[48517] = "15;0", --Eclipse (Solar)
[48518] = "15;0", --Eclipse (Lunar)
[48560] = "30;0", --Demoralizing Roar (Rank 8)
[48564] = "60;0", --Mangle (Bear) (Rank 5)
[48566] = "60;0", --Mangle (Cat) (Rank 5)
[48568] = "15;0", --Lacerate (Rank 3)
[48574] = "9;0", --Rake (Rank 7)
[48660] = "15;0", --Hemorrhage (Rank 5)
[48671] = "14;0", --Rupture (Rank 8)
[48672] = "16;0", --Rupture (Rank 9)
[48674] = "6;0", --Deadly Throw (Rank 3)
[48675] = "18;0", --Garrote (Rank 9)
[48676] = "18;0", --Garrote (Rank 10)
[48707] = "5;0", --Anti-Magic Shell
[48778] = "0;0", --Acherus Deathcharger (Summon)
[48792] = "12;0", --Icebound Fortitude
[48817] = "3;1", --Holy Wrath (Rank 5)
[48827] = "10;1", --Avenger's Shield (Rank 5)
[48836] = "5;0", --Vengeful Justice
[48931] = "1800;1", --Blessing of Might (Rank 9)
[48932] = "600;1", --Blessing of Might (Rank 10)
[48933] = "1800;1", --Greater Blessing of Might (Rank 4)
[48934] = "1800;1", --Greater Blessing of Might (Rank 5)
[48935] = "600;1", --Blessing of Wisdom (Rank 8)
[48936] = "600;1", --Blessing of Wisdom (Rank 9)
[48938] = "1800;1", --Greater Blessing of Wisdom (Rank 5)
[48942] = "0;0", --Devotion Aura (Rank 10)
[48943] = "0;0", --Shadow Resistance Aura (Rank 5)
[48945] = "0;0", --Frost Resistance Aura (Rank 5)
[48947] = "0;0", --Fire Resistance Aura (Rank 5)
[48952] = "10;1", --Holy Shield (Rank 6)
[48989] = "15;1", --Mend Pet (Rank 9)
[48990] = "15;1", --Mend Pet (Rank 10)
[49000] = "21;3", --Serpent Sting (Rank 11)
[49001] = "15;3", --Serpent Sting (Rank 12)
[49010] = "30;3", --Wyvern Sting (Rank 6)
[49012] = "30;3", --Wyvern Sting (Rank 6)
[49016] = "30;0", --Hysteria
[49028] = "12;0", --Dancing Rune Weapon
[49039] = "10;0", --Lichborne
[49050] = "10;0", --Aimed Shot (Rank 9)
[49054] = "15;1", --Immolation Trap (Rank 8)
[49065] = "0;0", --Explosive Trap Effect (Rank 6)
[49203] = "10;1", --Hungering Cold (Rank 1)
[49206] = "0;0", --Summon Gargoyle
[49222] = "300;0", --Bone Shield
[49231] = "8;0", --Earth Shock (Rank 10)
[49233] = "18;1", --Flame Shock (Rank 9)
[49236] = "8;1", --Frost Shock (Rank 7)
[49280] = "600;1", --Lightning Shield (Rank 10)
[49281] = "600;1", --Lightning Shield (Rank 11)
[49284] = "600;1", --Earth Shield (Rank 5)
[49322] = "0;0", --Swift Zhevra
[49379] = "0;0", --Great Brewfest Kodo
[49560] = "3;0", --Death Grip
[49759] = "0;0", --Teleport
[49800] = "12;0", --Rip (Rank 9)
[49802] = "6;0", --Maim (Rank 2)
[49803] = "4;0", --Pounce (Rank 5)
[49804] = "18;0", --Pounce Bleed (Rank 5)
[49938] = "0;0", --Death and Decay (Rank 4)
[50213] = "6;0", --Tiger's Fury (Rank 6)
[50227] = "5;0", --Sword and Board
[50259] = "3;0", --Dazed
[50334] = "15;0", --Berserk
[50411] = "3;0", --Dazed
[50421] = "20;0", --Scent of Blood
[50436] = "10;0", --Icy Clutch
[50449] = "30;1", --Bloody Vengeance
[50461] = "0;0", --Anti-Magic Zone
[50510] = "0;2", --Crypt Fever
[50511] = "120;4", --Curse of Weakness (Rank 9)
[50518] = "2;0", --Ravage (Rank 1)
[50519] = "2;0", --Sonic Blast (Rank 1)
[50536] = "10;0", --Unholy Blight
[50589] = "13;0", --Immolation Aura (Demon)
[50613] = "2;1", --Arcane Torrent (Racial)
[50989] = "3;0", --Flame Breath
[51124] = "30;0", --Killing Machine
[51271] = "20;0", --Unbreakable Armor
[51470] = "0;0", --Elemental Oath (Rank 2)
[51514] = "30;4", --Hex
[51585] = "8;0", --Blade Twisting
[51690] = "2;0", --Killing Spree
[51693] = "8;0", --Waylay
[51713] = "6;0", --Shadow Dance
[51722] = "10;0", --Dismantle
[51724] = "60;0", --Sap (Rank 4)
[51726] = "0;2", --Ebon Plague
[51735] = "15;2", --Ebon Plague
[52000] = "12;1", --Earthliving (Rank 6)
[52127] = "600;1", --Water Shield (Rank 1)
[52129] = "600;1", --Water Shield (Rank 2)
[52131] = "600;1", --Water Shield (Rank 3)
[52134] = "600;1", --Water Shield (Rank 4)
[52136] = "600;1", --Water Shield (Rank 5)
[52179] = "0;0", --Astral Shift
[52418] = "0;0", --Carrying Seaforium
[52437] = "10;0", --Sudden Death
[52459] = "10;0", --End of Round
[52610] = "34;0", --Savage Roar (Rank 1) (note this duration changes by combo points, 14, 19, 24, 29, 34)
[52910] = "8;0", --Turn the Tables
[53023] = "5;0", --Mind Sear (Rank 2)
[53137] = "0;0", --Abomination's Might (Rank 1)
[53138] = "0;0", --Abomination's Might (Rank 2)
[53148] = "1;0", --Charge
[53200] = "0;0", --Starfall (Rank 3)
[53201] = "10;0", --Starfall (Rank 4)
[53220] = "12;0", --Improved Steady Shot
[53227] = "6;0", --Typhoon (Rank 5)
[53251] = "7;1", --Wild Growth (Rank 4)
[53257] = "10;0", --Cobra Strikes
[53283] = "30;0", --Food
[53284] = "1800;0", --Well Fed
[53307] = "600;1", --Thorns (Rank 8)
[53308] = "27;1", --Entangling Roots (Rank 8)
[53312] = "45;1", --Nature's Grasp (Rank 8)
[53313] = "27;1", --Entangling Roots (Rank 8)
[53338] = "300;1", --Hunter's Mark (Rank 5)
[53365] = "15;0", --Unholy Strength
[53390] = "15;1", --Tidal Waves
[53401] = "20;0", --Rabid
[53403] = "0;0", --Rabid Power
[53426] = "5;0", --Lick Your Wounds
[53434] = "20;0", --Call of the Wild
[53477] = "3;0", --Taunt
[53480] = "12;0", --Roar of Sacrifice
[53515] = "8;1", --Owl's Focus
[53517] = "9;1", --Roar of Recovery
[53547] = "4;1", --Pin (Rank 5)
[53548] = "4;1", --Pin (Rank 6)
[53563] = "60;1",  --Beacon of Light
[53601] = "30;1", --Sacred Shield (Rank 1)
[53657] = "60;0", --Judgements of the Pure (Rank 3)
[53659] = "10;0", --Sacred Cleansing
[53736] = "1800;0", --Seal of Corruption
[53742] = "15;1", --Blood Corruption (Rank 1)
[53746] = "3600;0", --Wrath Elixir
[53748] = "3600;0", --Mighty Strength
[53749] = "3600;0", --Guru's Elixir
[53751] = "3600;0", --Elixir of Mighty Fortitude
[53752] = "3600;0", --Lesser Flask of Toughness
[53755] = "3600;0", --Flask of the Frost Wyrm
[53758] = "3600;0", --Flask of Stoneblood
[53760] = "3600;0", --Flask of Endless Rage
[53768] = "0;0", --Haunted
[53806] = "600;0", --Pygmy Oil
[53817] = "30;1", --Maelstrom Weapon
[53908] = "15;0", --Speed
[54043] = "0;0", --Retribution Aura (Rank 7)
[54131] = "5;0", --Bloodthirsty
[54149] = "15;0", --Infusion of Light (Rank 2)
[54152] = "60;0", --Judgements of the Pure (Rank 4)
[54153] = "60;0", --Judgements of the Pure (Rank 5)
[54203] = "12;1", --Sheath of Light
[54212] = "3600;0", --Flask of Pure Mojo
[54277] = "15;1", --Backdraft
[54370] = "8;1", --Nether Protection
[54371] = "8;1", --Nether Protection
[54372] = "8;1", --Nether Protection
[54373] = "8;1", --Nether Protection
[54374] = "8;1", --Nether Protection
[54375] = "8;1", --Nether Protection
[54428] = "15;1", --Divine Plea
[54499] = "20;0", --Heart of the Crusader (Rank 3)
[54501] = "6;0", --Consume Shadows
[54508] = "15;0", --Demonic Empowerment
[54643] = "20;0", --Teleport
[54646] = "1800;1", --Focus Magic
[54648] = "10;1", --Focus Magic
[54726] = "0;0", --Winged Steed of the Ebon Blade
[54727] = "0;0", --Winged Steed of the Ebon Blade
[54753] = "0;0", --White Polar Bear
[54758] = "12;0", --Hyperspeed Acceleration
[54833] = "10;1", --Glyph of Innervate
[54839] = "10;0", --Purified Spirit
[54861] = "5;0", --Nitro Boosts
[55001] = "30;0", --Parachute
[55018] = "10;0", --Sonic Awareness
[55021] = "4;1", --Silenced - Improved Counterspell (Rank 2)
[55078] = "15;2", --Blood Plague
[55080] = "8;1", --Shattered Barrier
[55095] = "15;2", --Frost Fever
[55166] = "20;1", --Tidal Force
[55233] = "10;0", --Vampiric Blood
[55277] = "15;0", --Stoneclaw Totem
[55360] = "12;1", --Living Bomb (Rank 3)
[55428] = "5;0", --Lifeblood (Rank 1)
[55480] = "5;0", --Lifeblood (Rank 2)
[55502] = "5;0", --Lifeblood (Rank 5)
[55503] = "5;0", --Lifeblood (Rank 6)
[55531] = "0;0", --Mechano-hog
[55610] = "0;0", --Improved Icy Talons
[55629] = "0;0", --First Lieutenant
[55637] = "15;0", --Lightweave
[55694] = "10;0", --Enraged Regeneration
[55711] = "600;0", --Weakened Heart
[55741] = "0;0", --Desecration
[55817] = "3600;0", --Eck Residue
[56222] = "3;0", --Dark Command
[56453] = "12;0", --Lock and Load
[56520] = "600;1", --Blessing of Might (Rank 10)
[56654] = "0;0", --Rapid Recuperation
[57073] = "30;0", --Drink
[57100] = "3600;0", --Well Fed
[57102] = "3600;0", --Well Fed
[57111] = "3600;0", --Well Fed
[57286] = "3600;0", --Well Fed
[57288] = "3600;0", --Well Fed
[57291] = "3600;0", --Well Fed
[57294] = "3600;0", --Well Fed
[57325] = "3600;0", --Well Fed
[57327] = "3600;0", --Well Fed
[57329] = "3600;0", --Well Fed
[57330] = "120;0", --Horn of Winter (Rank 1)
[57332] = "3600;0", --Well Fed
[57334] = "3600;0", --Well Fed
[57348] = "0;0", --Carrying an RP-GG
[57350] = "6;1", --Illusionary Barrier
[57356] = "3600;0", --Well Fed
[57358] = "3600;0", --Well Fed
[57365] = "3600;0", --Well Fed
[57367] = "3600;0", --Well Fed
[57371] = "3600;0", --Well Fed
[57399] = "3600;0", --Well Fed
[57457] = "0;0", --Kindred Spirits
[57458] = "0;0", --Kindred Spirits
[57475] = "0;0", --Kindred Spirits
[57482] = "0;0", --Kindred Spirits
[57485] = "0;0", --Kindred Spirits
[57516] = "12;0", --Enrage (Rank 2)
[57522] = "12;0", --Enrage (Rank 5)
[57524] = "120;1", --Metanoia
[57531] = "0;1", --Arcane Potency
[57564] = "0;0", --Fel Intelligence (Rank 2)
[57566] = "0;0", --Fel Intelligence (Rank 4)
[57567] = "0;0", --Fel Intelligence (Rank 5)
[57623] = "120;0", --Horn of Winter (Rank 2)
[57663] = "0;0", --Totem of Wrath
[57669] = "15;0", --Replenishment
[57723] = "600;0", --Exhaustion
[57724] = "600;0", --Sated
[57761] = "15;1", --Fireball!
[57819] = "0;0", --Argent Champion
[57820] = "0;0", --Ebon Champion
[57821] = "0;0", --Champion of the Kirin Tor
[57822] = "0;0", --Wyrmrest Champion
[57933] = "6;0", --Tricks of the Trade
[57934] = "30;0", --Tricks of the Trade
[57940] = "0;0", --Essence of Wintergrasp
[57960] = "600;1", --Water Shield (Rank 9)
[57970] = "12;3", --Deadly Poison IX (Rank 9)
[57974] = "10;3", --Wound Poison VI (Rank 6)
[57975] = "15;3", --Wound Poison VII (Rank 7)
[57993] = "6;3", --Envenom (Rank 4)
[58045] = "0;0", --Essence of Wintergrasp
[58179] = "12;2", --Infected Wounds
[58181] = "12;2", --Infected Wounds
[58363] = "10;0", --Glyph of Revenge
[58371] = "180;0", --Recently Slain
[58374] = "10;0", --Glyph of Blocking
[58427] = "20;0", --Overkill
[58449] = "1800;1", --Strength (Rank 8)
[58450] = "1800;1", --Agility (Rank 7)
[58499] = "7200;0", --Happy
[58500] = "7200;0", --Angry
[58511] = "45;0", --Rotten Apple Aroma
[58514] = "45;0", --Rotten Banana Aroma
[58519] = "45;0", --Spit
[58549] = "0;0", --Tenacity
[58555] = "0;0", --Great Honor
[58556] = "0;0", --Greater Honor
[58557] = "0;0", --Greatest Honor
[58567] = "30;0", --Sunder Armor (Rank 1)
[58578] = "20;0", --Icy Talons
[58591] = "15;0", --Stoneclaw Totem
[58597] = "6;1", --Sacred Shield (Rank 1)
[58600] = "10;0", --Restricted Flight Area
[58610] = "10;1", --Lava Breath (Rank 5)
[58611] = "10;1", --Lava Breath (Rank 6)
[58617] = "10;0", --Glyph of Heart Strike
[58646] = "0;0", --Strength of Earth (Rank 8)
[58655] = "0;0", --Flametongue Totem (Rank 8)
[58683] = "0;0", --Savage Combat (Rank 2)
[58729] = "0;0", --Spiritual Immunity
[58730] = "9;0", --Restricted Flight Area
[58744] = "0;0", --Frost Resistance (Rank 6)
[58754] = "0;0", --Stoneskin (Rank 10)
[58777] = "0;0", --Mana Spring (Rank 8)
[58799] = "8;0", --Frostbrand Attack (Rank 9)
[58861] = "2;0", --Bash (Rank 1)
[58875] = "15;0", --Spirit Walk
[58882] = "6;0", --Rapid Recuperation
[58914] = "30;0", --Kill Command (Rank 1)
[59000] = "8;1", --Improved Spirit Tap (Rank 2)
[59052] = "0;1", --Freezing Fog
[59164] = "12;1", --Haunt (Rank 4)
[59542] = "15;0", --Gift of the Naaru (Racial)
[59547] = "15;0", --Gift of the Naaru (Racial)
[59548] = "15;0", --Gift of the Naaru (Racial)
[59568] = "0;0", --Blue Drake
[59569] = "0;0", --Bronze Drake
[59570] = "0;0", --Red Drake
[59578] = "15;1", --The Art of War (Rank 2)
[59620] = "15;0", --Berserk
[59626] = "10;0", --Black Magic
[59628] = "6;0", --Tricks of the Trade
[59638] = "4;1", --Frostbolt
[59671] = "6;0", --Challenging Howl (Demon)
[59725] = "5;0", --Spell Reflection
[59752] = "0;0", --Every Man for Himself (Racial)
[59785] = "0;0", --Black War Mammoth
[59788] = "0;0", --Black War Mammoth
[59793] = "0;0", --Wooly Mammoth
[59797] = "0;0", --Ice Mammoth
[59885] = "9;0", --Rake (Rank 5)
[59886] = "9;0", --Rake (Rank 6)
[59889] = "6;1", --Borrowed Time
[59891] = "6;1", --Borrowed Time
[59911] = "0;0", --Tenacity
[59961] = "0;0", --Red Proto-Drake
[59996] = "0;0", --Blue Proto-Drake
[60002] = "0;0", --Time-Lost Proto-Drake
[60024] = "0;0", --Violet Proto-Drake
[60025] = "0;0", --Albino Drake
[60053] = "2;0", --Explosive Shot (Rank 4)
[60062] = "10;0", --Essence of Life
[60064] = "10;0", --Now is the time!
[60065] = "10;0", --Reflection of Torment
[60097] = "10;0", --Feeding Frenzy (Rank 2)
[60114] = "0;0", --Armored Brown Bear
[60116] = "0;0", --Armored Brown Bear
[60118] = "0;0", --Black War Bear
[60119] = "0;0", --Black War Bear
[60196] = "12;0", --Berserker!
[60210] = "10;1", --Freezing Arrow Effect (Rank 1) (PvP duration)
[60214] = "0;0", --Seal of the Pantheon
[60215] = "0;0", --Lavanthor's Talisman
[60218] = "0;0", --Essence of Gossamer
[60229] = "15;0", --Greatness
[60233] = "15;0", --Greatness
[60234] = "15;0", --Greatness
[60302] = "10;0", --Meteorite Whetstone
[60305] = "20;0", --Heart of a Dragon
[60314] = "10;0", --Fury of the Five Flights
[60318] = "13;0", --Edward's Insight
[60340] = "3600;0", --Accuracy
[60341] = "3600;0", --Deadly Strikes
[60345] = "3600;0", --Armor Piercing
[60346] = "3600;0", --Lightning Speed
[60347] = "3600;0", --Mighty Thoughts
[60424] = "0;0", --Mekgineer's Chopper
[60433] = "12;1", --Earth and Moon
[60437] = "10;0", --Grim Toll
[60479] = "10;0", --Forge Ember
[60503] = "9;0", --Taste for Blood
[60512] = "15;0", --Healing Trance
[60520] = "15;0", --Spark of Life
[60525] = "10;0", --Majestic Dragon Figurine
[60549] = "10;0", --Deadly Aggression
[60551] = "10;0", --Furious Gladiator's Libram of Fortitude
[60553] = "10;0", --Relentless Aggression
[60568] = "10;0", --Furious Gladiator's Idol of Steadfastness
[60946] = "4;1", --Nightmare
[60947] = "5;1", --Nightmare
[60956] = "0;0", --Improved Health Funnel
[61024] = "1800;1", --Dalaran Intellect (Rank 7)
[61198] = "6;0", --Spirit Strike (Rank 6)
[61258] = "5;0", --Runic Return (Rank 2)
[61294] = "0;0", --Green Proto-Drake
[61301] = "15;1", --Riptide (Rank 4)
[61309] = "0;0", --Magnificent Flying Carpet
[61316] = "3600;1", --Dalaran Brilliance (Rank 3)
[61336] = "20;0", --Survival Instincts
[61394] = "4;1", --Glyph of Freezing Trap
[61427] = "20;0", --Infinite Speed
[61447] = "0;0", --Traveler's Tundra Mammoth
[61465] = "0;0", --Grand Black War Mammoth
[61467] = "0;0", --Grand Black War Mammoth
[61469] = "0;0", --Grand Ice Mammoth
[61485] = "60;0", --Dreadful Roar
[61573] = "0;0", --Banner of the Alliance
[61619] = "10;0", --Tentacles
[61671] = "10;0", --Crusader's Glory
[61684] = "16;0", --Dash
[61685] = "4;0", --Charge
[61721] = "50;1", --Polymorph (Rabbit)
[61792] = "10;0", --Shadowy Insight
[61840] = "8;1", --Righteous Vengeance
[61846] = "0;0", --Aspect of the Dragonhawk (Rank 1)
[61847] = "0;0", --Aspect of the Dragonhawk (Rank 2)
[61858] = "0;0", --Plague Slime
[62064] = "0;0", --Tower Control
[62124] = "3;0", --Hand of Reckoning
[62408] = "300;0", --Ethereal Oil
[62552] = "0;0", --Defend
[62574] = "0;0", --Warts-B-Gone Lip Balm
[62606] = "10;0", --Savage Defense
[63167] = "10;1", --Decimation
[63232] = "0;0", --Stormwind Steed
[63243] = "10;1", --Pyroclasm
[63244] = "10;1", --Pyroclasm
[63283] = "300;0", --Totem of Wrath
[63321] = "40;1", --Life Tap
[63433] = "0;0", --Orgrimmar Champion's Pennant
[63468] = "8;0", --Piercing Shots
[63500] = "0;0", --Argent Crusade Valiant's Pennant
[63529] = "3;1", --Silenced - Shield of the Templar
[63619] = "5;0", --Shadowcrawl
[63635] = "0;0", --Darkspear Raptor
[63640] = "0;0", --Orgrimmar Wolf
[63641] = "0;0", --Thunder Bluff Kodo
[63665] = "0;0", --Charge
[63672] = "15;1", --Black Arrow (Rank 6)
[63685] = "5;1", --Freeze
[63725] = "8;1", --Holy Concentration
[63729] = "3600;0", --Elixir of Minor Accuracy
[63734] = "20;1", --Serendipity
[63844] = "0;0", --Argent Hippogryph
[63848] = "60;0", --Hunger For Blood
[63944] = "60;0", --Renewed Hope
[63963] = "0;0", --Rusted Proto-Drake
[64044] = "3;1", --Psychic Horror
[64058] = "10;0", --Psychic Horror
[64205] = "10;1", --Divine Sacrifice
[64368] = "10;1", --Eradication
[64370] = "10;1", --Eradication
[64371] = "10;1", --Eradication
[64373] = "0;0", --Armistice
[64419] = "15;0", --Sniper Training (Rank 3)
[64420] = "15;0", --Sniper Training (Rank 3)
[64440] = "10;0", --Blade Warding
[64494] = "0;0", --Furious Howl (Rank 5)
[64495] = "20;0", --Furious Howl (Rank 6)
[64524] = "20;0", --Platinum Disks of Battle
[64568] = "20;0", --Blood Reserve
[64658] = "0;0", --Black Wolf
[64659] = "0;0", --Venomhide Ravasaur
[64695] = "5;1", --Earthgrab
[64701] = "15;1", --Elemental Mastery
[64804] = "4;1", --Entrapment
[64810] = "0;0", --Bested Ironforge
[64844] = "8;1", --Divine Hymn
[64850] = "6;0", --Unrelenting Assault
[64855] = "10;0", --Blade Barrier (Rank 2)
[64856] = "10;0", --Blade Barrier (Rank 3)
[64859] = "10;0", --Blade Barrier (Rank 5)
[64951] = "12;0", --Primal Wrath (Rank 5)
[64977] = "0;0", --Black Skeletal Horse
[65019] = "10;0", --Mjolnir Runestone
[65156] = "10;0", --Juggernaut
[65247] = "3514;0", --Well Fed
[65264] = "6;1", --Lava Flows
[65639] = "0;0", --Swift Red Hawkstrider
[65641] = "0;0", --Great Golden Kodo
[65642] = "0;0", --Turbostrider
[65644] = "0;0", --Swift Purple Raptor
[65645] = "0;0", --White Skeletal Warhorse
[65646] = "0;0", --Swift Burgundy Wolf
[65745] = "300;0", --Path of Cenarius
[66090] = "0;0", --Quel'dorei Steed
[66091] = "0;0", --Sunreaver Hawkstrider
[66122] = "0;0", --Magic Rooster
[66157] = "0;0", --Honorable Defender
[66233] = "120;0", --Ardent Defender
[66803] = "20;0", --Desolation
[66846] = "0;0", --Ochre Skeletal Warhorse
[66906] = "0;0", --Argent Charger (Summon)
[66922] = "12;1", --Flash of Light
[67016] = "3600;0", --Flask of the North
[67017] = "3600;0", --Flask of the North
[67018] = "3600;0", --Flask of the North
[67117] = "15;0", --Unholy Might
[67354] = "9;0", --Evasion (Rank 5)
[67355] = "16;0", --Agile
[67358] = "9;0", --Rejuvenating
[67360] = "12;0", --Blessing of the Moon Goddess
[67364] = "15;0", --Holy Judgement
[67371] = "16;0", --Holy Strength
[67378] = "18;0", --Evasion (Rank 1)
[67383] = "20;0", --Unholy Force (Rank 1)
[67385] = "12;0", --Energized
[67388] = "15;0", --Spiritual Trance
[67391] = "18;0", --Volcanic Fury
[67466] = "0;0", --Argent Warhorse
[67596] = "15;0", --Tremendous Fortitude
[67631] = "10;1", --Aegis
[67669] = "10;0", --Elusive Power
[67671] = "10;0", --Fury
[67683] = "20;0", --Celerity
[67684] = "20;0", --Hospitality
[67694] = "20;0", --Defensive Tactics
[67695] = "20;0", --Rage
[67696] = "10;0", --Energized
[67703] = "15;0", --Paragon
[67708] = "15;0", --Paragon
[67713] = "0;0", --Mote of Flame
[67737] = "0;0", --Risen Fury
[67738] = "20;0", --Rising Fury
[67890] = "3;0", --Cobalt Frag Bomb
[68054] = "600;0", --Pressing Engagement
[68055] = "20;1", --Judgements of the Just (Rank 1)
[68056] = "0;0", --Swift Horde Wolf
[68057] = "0;0", --Swift Alliance Steed
[68269] = "0;0", --The Brewmaiden's Blessing (Rank 6)
[68766] = "0;0", --Desecration
[69369] = "8;1", --Predator's Swiftness
[70013] = "0;0", --Quel'Delar's Compulsion
[70029] = "0;0", --The Beast Within
[70657] = "15;0", --Advantage (Rank 5)
[70691] = "15;1", --Rejuvenation
[70721] = "6;0", --Omen of Doom
[70725] = "10;0", --Enraged Defense
[70728] = "10;0", --Exploit Weakness
[70753] = "5;0", --Pushing the Limit
[70757] = "10;0", --Holiness (Rank 5)
[70806] = "10;0", --Rapid Currents
[70840] = "10;0", --Devious Minds
[70855] = "10;0", --Blood Drinker
[70893] = "10;0", --Culling the Herd
[70940] = "6;0", --Divine Guardian
[71007] = "10;0", --Stinger
[71041] = "1800;0", --Dungeon Deserter
[71165] = "15;0", --Molten Core
[71177] = "15;0", --Vicious
[71184] = "15;0", --Soothing
[71187] = "15;0", --Formidable
[71192] = "15;0", --Blessed
[71197] = "15;0", --Evasive
[71199] = "30;0", --Furious
[71216] = "15;0", --Enraged
[71220] = "15;0", --Energized
[71227] = "15;0", --Indomitable
[71396] = "10;0", --Rage of the Fallen
[71401] = "15;0", --Icy Rage
[71403] = "10;0", --Fatal Flaws
[71432] = "0;0", --Mote of Anger
[71484] = "30;0", --Strength of the Taunka
[71486] = "30;0", --Power of the Taunka
[71491] = "30;0", --Aim of the Iron Dwarves
[71492] = "30;0", --Speed of the Vrykul
[71564] = "20;0", --Deadly Precision
[71570] = "10;0", --Cultivated Power
[71572] = "10;0", --Cultivated Power
[71584] = "15;0", --Revitalized
[71586] = "10;0", --Hardened Skin
[71600] = "0;0", --Surging Power
[71601] = "20;0", --Surge of Power
[71633] = "10;0", --Thick Skin
[71824] = "6;1", --Lava Burst
[71864] = "0;0", --Fountain of Light
[71882] = "10;1", --Invigoration
[72412] = "10;0", --Frostforged Champion
[72414] = "10;0", --Frostforged Defender
[72416] = "10;0", --Frostforged Sage
[72418] = "10;0", --Chilling Knowledge
[72586] = "1800;1", --Blessing of Forgotten Kings
[72588] = "3600;1", --Gift of the Wild
[72590] = "3600;1", --Fortitude
[72808] = "0;0", --Bloodbathed Frostbrood Vanquisher
[72968] = "0;0", --Precious's Ribbon
[73313] = "0;0", --Crimson Deathcharger (Summon)
[74347] = "3;1", --Silenced - Gag Order
[74396] = "15;0", --Fingers of Frost
[75446] = "0;0", --Ferocious Inspiration
[75447] = "0;0", --Ferocious Inspiration
[75596] = "0;0", --Frosty Flying Carpet
[75617] = "0;0", --Celestial Steed
[75618] = "0;0", --Celestial Steed
[75619] = "0;0", --Celestial Steed
[75620] = "0;0", --Celestial Steed
[75957] = "0;0", --X-53 Touring Rocket
[75972] = "0;0", --X-53 Touring Rocket
[23223] = "0;0", --Swift White Mechanostrider
[53805] = "600;0", --Pygmy Oil
[41513] = "0;0", --Onyx Netherwing Drake
[58269] = "0;0", --Iceskin Stoneform
[46202] = "10;0", --Pierce Armor
[65006] = "10;0", --Eye of the Broodmother
[51987] = "20;0", --Arcane Infusion
[66088] = "0;0", --Sunreaver Dragonhawk
[13161] = "0;0", --Aspect of the Beast
[57107] = "3600;0", --Well Fed
[64731] = "0;0", --Sea Turtle
[54452] = "3600;0", --Adept's Elixir
[27681] = "3600;1", --Prayer of Spirit (Rank 1)
[27683] = "1200;1", --Prayer of Shadow Protection (Rank 1)
[32386] = "12;1", --Shadow Embrace
[21849] = "3600;1", --Gift of the Wild (Rank 1)
[47892] = "1800;0", --Fel Armor (Rank 3)
[25040] = "900;0", --Mark of Nature
[5784] = "0;0", --Felsteed (Summon)
[48440] = "15;1", --Rejuvenation (Rank 14)
[325] = "600;1", --Lightning Shield (Rank 2)
[25431] = "1800;0", --Inner Fire (Rank 7)
[11766] = "0;0", --Blood Pact (Rank 4)
[58501] = "600;1", --Iron Boot Flask
[62061] = "3600;0", --Festive Holiday Mount
[35018] = "0;0", --Purple Hawkstrider
[35022] = "0;0", --Black Hawkstrider
[54842] = "0;0", --Thunder Charge
[19740] = "600;1", --Blessing of Might (Rank 1)
[60569] = "10;0", --Relentless Survival
[7128] = "1800;0", --Inner Fire (Rank 2)
[8733] = "3600;0", --Blessing of Blackfathom
[25469] = "600;1", --Lightning Shield (Rank 8)
[64657] = "0;0", --White Kodo
[696] = "1800;0", --Demon Skin (Rank 2)
[53747] = "3600;0", --Elixir of Spirit
[57565] = "0;0", --Fel Intelligence (Rank 3)
[45123] = "0;0", --Romantic Picnic
[60494] = "10;0", --Dying Curse
[48941] = "0;0", --Devotion Aura (Rank 9)
[27140] = "1800;1", --Blessing of Might (Rank 8)
[23844] = "0;0", --Master Demonologist
[21562] = "3600;1", --Prayer of Fortitude (Rank 1)
[60530] = "12;0", --Forethought Talisman
[50882] = "20;0", --Icy Talons
[28682] = "0;1", --Combustion
[32752] = "5;0", --Summoning Disorientation
[33257] = "1800;0", --Well Fed
[6192] = "120;0", --Battle Shout (Rank 3)
[50434] = "10;0", --Icy Clutch
[10292] = "0;0", --Devotion Aura (Rank 6)
[25289] = "120;0", --Battle Shout (Rank 7)
[33944] = "600;1", --Dampen Magic (Rank 6)
[57447] = "0;0", --Kindred Spirits
[50720] = "1800;0", --Vigilance
[60122] = "30;0", --Baby Spice
[48442] = "21;1", --Regrowth (Rank 11)
[58479] = "3600;0", --Nearly Well Fed
[11396] = "3600;0", --Greater Intellect
[8272] = "600;1", --Mind Tremor
[58999] = "0;0", --Big Blizzard Bear
[19850] = "600;1", --Blessing of Wisdom (Rank 2)
[19852] = "600;1", --Blessing of Wisdom (Rank 3)
[57360] = "3600;0", --Well Fed
[60106] = "300;0", --Old Spices
[3593] = "3600;0", --Elixir of Fortitude
[59658] = "15;0", --Argent Heroism
[22783] = "1800;0", --Mage Armor (Rank 3)
[10403] = "0;0", --Stoneskin (Rank 4)
[25916] = "1800;1", --Greater Blessing of Might (Rank 2)
[52138] = "600;1", --Water Shield (Rank 6)
[27009] = "45;1", --Nature's Grasp (Rank 7)
[11841] = "600;1", --Static Barrier
[68188] = "0;0", --Crusader's Black Warhorse
[17463] = "0;0", --Blue Skeletal Horse
[70772] = "9;0", --Blessed Healing
[43023] = "1800;0", --Mage Armor (Rank 5)
[48937] = "1800;1", --Greater Blessing of Wisdom (Rank 4)
[44212] = "3600;0", --Jack-o'-Lanterned!
[30808] = "0;0", --Unleashed Rage (Rank 2)
[43019] = "60;1", --Mana Shield (Rank 8)
[11334] = "3600;0", --Greater Agility
[7320] = "1800;0", --Ice Armor (Rank 2)
[9910] = "600;1", --Thorns (Rank 6)
[2974] = "10;0", --Wing Clip
[1002] = "60;0", --Eyes of the Beast
[58180] = "12;2", --Infected Wounds
[16711] = "300;1", --Grow
[65640] = "0;0", --Swift Gray Steed
[10173] = "600;1", --Dampen Magic (Rank 4)
[28491] = "3600;0", --Healing Power
[54424] = "0;0", --Fel Intelligence (Rank 1)
[11734] = "1800;0", --Demon Armor (Rank 4)
[24453] = "0;0", --Prowl (Rank 3)
[16511] = "15;0", --Hemorrhage (Rank 1)
[19895] = "0;0", --Shadow Resistance Aura (Rank 2)
[10668] = "3600;0", --Spirit of Boar
[15357] = "15;1", --Inspiration (Rank 2)
[72081] = "0;0", --Frozen Orb
[48846] = "20;0", --Runic Infusion
[6117] = "1800;0", --Mage Armor (Rank 1)
[16488] = "6;0", --Blood Craze
[72122] = "0;0", --Frozen Mallet
[70760] = "10;0", --Deliverance
[72004] = "20;0", --Frostbite
[52419] = "10;0", --Deflection
[48102] = "1800;1", --Stamina (Level 6)
[59650] = "0;0", --Black Drake
[1463] = "60;1", --Mana Shield (Rank 1)
[66808] = "15;0", --Meteor Fists
[18989] = "0;0", --Gray Kodo
[49232] = "18;1", --Flame Shock (Rank 8)
[66721] = "0;0", --Burning Fury
[55775] = "15;0", --Swordguard Embroidery
[66725] = "15;0", --Meteor Fists
[57079] = "3600;0", --Well Fed
[8119] = "1800;1", --Strength (Rank 2)
[46355] = "300;0", --Blood Elf Illusion
[72034] = "0;0", --Whiteout
[53301] = "2;0", --Explosive Shot (Rank 1)
[64493] = "20;0", --Furious Howl (Rank 4)
[63250] = "10;0", --Jouster's Fury
[71993] = "0;0", --Frozen Mallet
[33946] = "600;1", --Amplify Magic (Rank 6)
[57097] = "3600;0", --Well Fed
[23829] = "0;0", --Master Demonologist
[13555] = "15;3", --Serpent Sting (Rank 8)
[8117] = "1800;1", --Agility (Rank 3)
[71875] = "10;1", --Necrotic Touch
[14030] = "6;0", --Hooked Net
[48108] = "10;0", --Hot Streak
[25918] = "1800;1", --Greater Blessing of Wisdom (Rank 2)
[17038] = "1200;0", --Winterfall Firewater
[28694] = "900;0", --Dreaming Glory
[33254] = "1800;0", --Well Fed
[48565] = "60;0", --Mangle (Cat) (Rank 4)
[11767] = "0;0", --Blood Pact (Rank 5)
[62305] = "4;0", --Master's Call
[12178] = "1800;1", --Stamina (Level 4)
[11328] = "3600;0", --Agility
[58468] = "3600;0", --Hugely Well Fed
[44614] = "9;1", --Frostfire Bolt (Rank 1)
[14323] = "300;1", --Hunter's Mark (Rank 2)
[28518] = "3600;0", --Flask of Fortification
[58984] = "0;0", --Shadowmeld (Racial)
[11712] = "24;4", --Curse of Agony (Rank 5)
[19705] = "900;0", --Well Fed
[20903] = "10;0", --Aimed Shot (Rank 5)
[17628] = "7200;0", --Supreme Power
[19834] = "600;1", --Blessing of Might (Rank 2)
[54216] = "4;0", --Master's Call
[36895] = "3600;0", --Transporter Malfunction
[36897] = "3600;0", --Transporter Malfunction
[20154] = "1800;0", --Seal of Righteousness
[8314] = "3600;1", --Rock Skin
[8096] = "1800;1", --Intellect (Rank 1)
[16811] = "45;1", --Nature's Grasp (Rank 3)
[49005] = "20;1", --Mark of Blood
[467] = "600;1", --Thorns (Rank 1)
[7294] = "0;0", --Retribution Aura (Rank 1)
[8050] = "18;1", --Flame Shock (Rank 1)
[47501] = "30;0", --Thunder Clap (Rank 8)
[3219] = "3600;0", --Weak Troll's Blood Elixir
[10432] = "600;1", --Lightning Shield (Rank 7)
[7844] = "3600;0", --Fire Power
[6114] = "300;0", --Raptor Punch
[57969] = "12;3", --Deadly Poison VIII (Rank 8)
[23760] = "0;0", --Master Demonologist
[67736] = "20;0", --Volatile Power
[7805] = "0;0", --Blood Pact (Rank 3)
[59230] = "3600;0", --Well Fed
[67735] = "0;0", --Volatility
[57833] = "4;0", --Frost Spit
[32296] = "0;0", --Swift Yellow Wind Rider
[56161] = "6;1", --Glyph of Prayer of Healing
[57621] = "0;0", --Strength of Earth (Rank 7)
[2048] = "240;0", --Battle Shout (Rank 8)
[18400] = "0;0", --Piccolo of the Flaming Fire
[72098] = "20;0", --Frostbite
[72096] = "0;0", --Whiteout
[49071] = "0;0", --Aspect of the Wild (Rank 4)
[44825] = "0;0", --Flying Reindeer
[32240] = "0;0", --Snowy Gryphon
[47867] = "60;4", --Curse of Doom (Rank 3)
[57662] = "0;0", --Totem of Wrath
[63956] = "0;0", --Ironbound Proto-Drake
[72121] = "10;0", --Frostbite
[32289] = "0;0", --Swift Red Gryphon
[58776] = "0;0", --Mana Spring (Rank 7)
[26276] = "7200;0", --Greater Firepower
[75593] = "0;0", --Ferocious Inspiration
[17535] = "7200;0", --Elixir of the Sages
[61669] = "0;0", --Aspect of the Beast
[21163] = "1800;0", --Polished Armor (Rank 1)
[33151] = "10;1", --Surge of Light (Rank 1)
[57363] = "3600;0", --Well Fed
[73320] = "600;1", --Frostborn Illusion
[72104] = "5;1", --Freezing Ground
[23225] = "0;0", --Swift Green Mechanostrider
[57054] = "10;0", --Tranquility
[29228] = "18;1",  --Flame Shock (Rank 6)
[1120] = "15;0",  --Drain Soul (Rank 1)
[48299] = "24;2", --Devouring Plague (Rank 8)
[29175] = "3600;0",  --Ribbon Dance [This duration changed based on how long you've used the ribbon poll]
[34917] = "15;1",  --Vampiric Touch (Rank 3)
[25221] = "15;1",  --Renew (Rank 11)
[48058] = "30;1", --Crystal Bloom
[774] = "15;1", --Rejuvenation (Rank 1)
[64904] = "8;1", --Hymn of Hope
[63637] = "0;0", --Darnassian Nightsaber
[13552] = "15;3", --Serpent Sting (Rank 5)
[12024] = "5;0", --Net
[54497] = "3600;0", --Lesser Armor
[68720] = "0;0", --Quarry
[57063] = "10;1", --Arcane Attraction
[53764] = "3600;0", --Mighty Mana Regeneration
[6673] = "120;0", --Battle Shout (Rank 1)
[30910] = "60;4", --Curse of Doom (Rank 2)
[744] = "30;3", --Poison
[54314] = "30;0", --Drain Power
[52537] = "10;0", --Fixate
[19706] = "900;0", --Well Fed
[3220] = "3600;0", --Armor
[53334] = "9;0", --Animate Bones
[47748] = "45;0", --Rift Shield
[45716] = "40;0", --Torch Tossing Training
[586] = "10;0", --Fade
[20762] = "900;0", --Soulstone Resurrection
[469] = "120;0", --Commanding Shout (Rank 1)
[54681] = "12;0", --Monstrous Strength
[25368] = "18;1", --Shadow Word: Pain (Rank 10)
[11572] = "15;0", --Rend (Rank 5)
[42728] = "60;0", --Dreadful Roar
[50131] = "10;0", --Draw Magic
[20798] = "1800;1", --Demon Skin
[57056] = "0;0", --Aura of Regeneration
[48155] = "3;0", --Mind Flay (Rank 8)
[28747] = "600;0", --Frenzy
[54315] = "30;0", --Drain Power
[11349] = "3600;0", --Armor
[589] = "18;1", --Shadow Word: Pain (Rank 1)
[19854] = "600;1", --Blessing of Wisdom (Rank 5)
[25217] = "30;1", --Power Word: Shield (Rank 11)
[47781] = "6;0", --Spellbreaker
[42705] = "60;0", --Enrage
[116] = "8;1", --Frostbolt (Rank 1)
[68722] = "0;0", --Oil Refinery
[35079] = "4;0", --Misdirection
[56778] = "60;1", --Mana Shield
[29341] = "5;0", --Shadowburn
[172] = "12;1", --Corruption (Rank 1)
[66776] = "0;0", --Rage
[6222] = "15;1", --Corruption (Rank 2)
[67811] = "12;0", --Dagger Throw
[43182] = "30;0", --Drink
[16244] = "30;0", --Demoralizing Shout
[3248] = "6;0", --Improved Blocking
[61470] = "0;0", --Grand Ice Mammoth
[15572] = "30;0", --Sunder Armor
[34410] = "3600;0", --Hellscream's Warsong
[42833] = "8;0", --Fireball (Rank 16)
[58651] = "0;0", --Flametongue Totem (Rank 6)
[25058] = "15;1", --Renew
[68719] = "0;0", --Oil Refinery
[29882] = "0;0", --Loose Mana
[25527] = "0;0", --Strength of Earth (Rank 6)
[47981] = "15;0", --Spell Reflection
[26867] = "14;0", --Rupture (Rank 7)
[43931] = "15;0", --Rend
[64843] = "5;0", --Divine Hymn (Rank 1)
[11735] = "1800;0", --Demon Armor (Rank 5)
[47774] = "120;0", --Frenzy
[13730] = "30;0", --Demoralizing Shout
[133] = "4;0", --Fireball (Rank 1)
[47543] = "0;0", --Frozen Prison
[17464] = "0;0", --Brown Skeletal Horse
[60819] = "10;0", --Libram of Reciprocation
[71877] = "10;1", --Necrotic Touch
[25467] = "23;2", --Devouring Plague (Rank 7)
[2947] = "180;1", --Fire Shield (Rank 1)
[47854] = "0;0", --Frozen Prison
[43017] = "600;1", --Amplify Magic (Rank 7)
[755] = "10;0", --Health Funnel (Rank 1)
[8205] = "22;0", --Thunder Clap (Rank 4)
[53520] = "4;0", --Carrion Beetles
[8042] = "8;0", --Earth Shock (Rank 1)
[71579] = "20;0", --Elusive Power
[51990] = "12;1", --Earthliving (Rank 2)
[8045] = "8;0", --Earth Shock (Rank 3)
[54309] = "10;1", --Mark of Darkness
[5242] = "120;0", --Battle Shout (Rank 2)
[48400] = "20;0", --Frost Tomb
[18267] = "30;4", --Curse of Weakness
[47791] = "5;0", --Arcane Haste
[707] = "15;1", --Immolate (Rank 2)
[6268] = "3;0", --Rushing Charge (Rank 1)
[980] = "24;4", --Curse of Agony (Rank 1)
[18070] = "30;0", --Earthborer Acid
[46221] = "180;0", --Animal Blood
[25218] = "30;1", --Power Word: Shield (Rank 12)
[25222] = "15;1", --Renew (Rank 12)
[58740] = "0;0", --Fire Resistance (Rank 6)
[58493] = "3600;0", --Mohawked!
[1130] = "300;1", --Hunter's Mark (Rank 1)
[29334] = "3600;0", --Toasted Smorc
[6278] = "60;2", --Creeping Mold
[54955] = "0;0", --Ticking Bomb
[13549] = "15;3", --Serpent Sting (Rank 2)
[68377] = "0;0", --Carrying Huge Seaforium
[5262] = "10;1", --Fanatic Blade
[40192] = "0;0", --Ashes of Al'ar
[348] = "15;1", --Immolate (Rank 1)
[8450] = "600;1", --Dampen Magic (Rank 2)
[12541] = "600;2", --Ghoul Rot
[68298] = "5;0", --Parachute
[5782] = "10;1", --Fear (Rank 1)
[12292] = "30;0", --Death Wish
[52493] = "10;3", --Poison Spray
[6546] = "15;0", --Rend (Rank 2)
[46899] = "900;0", --Well Fed
[66550] = "20;0", --Teleport
[42702] = "10;2", --Decrepify
[8076] = "0;0", --Strength of Earth (Rank 1)
[25569] = "0;0", --Mana Spring (Rank 5)
[57139] = "3600;0", --Well Fed
[53322] = "6;0", --Crushing Webs
[53330] = "20;2", --Infected Wound
[5280] = "45;0", --Razor Mane (Rank 1)
[60486] = "10;0", --Illustration of the Dragon Soul
[43664] = "15;0", --Unholy Rage
[99] = "30;0", --Demoralizing Roar (Rank 1)
[8242] = "2;0", --Shield Slam
[26884] = "18;0", --Garrote (Rank 8)
[9904] = "9;0", --Rake (Rank 4)
[58502] = "7200;0", --Scared
[64861] = "15;0", --Precision Shots
[8202] = "1200;1", --Sapta Sight
[6950] = "60;1", --Faerie Fire
[42740] = "8;1", --Njord's Rune of Protection
[65638] = "0;0", --Swift Moonsaber
[48095] = "0;0", --Intense Cold
[20800] = "21;1", --Immolate
[52446] = "10;0", --Acid Splash
[54494] = "3600;0", --Major Agility
[27187] = "12;3", --Deadly Poison VII (Rank 7)
[18266] = "15;4", --Curse of Agony
[29235] = "3600;0", --Fire Festival Fortitude
[126] = "45;0", --Eye of Kilrogg (Summon)
[52470] = "8;0", --Enrage
[55753] = "30;0", --Acid Spit (Rank 5)
[71870] = "10;1", --Blessing of Light
[26968] = "12;3", --Deadly Poison VI (Rank 6)
[53801] = "600;0", --Frenzy
[11348] = "3600;0", --Greater Armor
[20043] = "0;0", --Aspect of the Wild (Rank 1)
[64057] = "3600;0", --Well Fed
[72221] = "0;0", --Luck of the Draw
[25454] = "8;0", --Earth Shock (Rank 8)
[25207] = "1800;1", --Amulet of the Moon
[53602] = "12;0", --Dart
[35944] = "30;1", --Power Word: Shield
[27817] = "6;1", --Blessed Recovery (Rank 2)
[1086] = "1800;0", --Demon Armor (Rank 2)
[71568] = "20;0", --Urgency
[39171] = "5;0", --Mortal Strike
[58750] = "0;0", --Nature Resistance (Rank 6)
[702] = "120;4", --Curse of Weakness (Rank 1)
[8316] = "180;1", --Fire Shield (Rank 2)
[53467] = "15;0", --Leeching Swarm
[6343] = "10;0", --Thunder Clap (Rank 1)
[54965] = "8;1", --Bolthorn's Rune of Flame
[63643] = "0;0", --Forsaken Warhorse
[68652] = "0;0", --Honorable Defender
[60344] = "3600;0", --Expertise
[11390] = "3600;0", --Arcane Elixir
[8451] = "600;1", --Dampen Magic (Rank 3)
[57580] = "5;1", --Lightning Infusion
[52113] = "0;0", --Flametongue Totem (Rank 5)
[31403] = "120;0", --Battle Shout
[432] = "24;0", --Drink
[47283] = "8;1", --Empowered Imp
[8599] = "120;0", --Enrage
[57483] = "0;0", --Kindred Spirits
[65014] = "10;0", --Pyrite Infusion
[55077] = "5;0", --Pounce
[32594] = "600;1", --Earth Shield (Rank 3)
[1430] = "15;1", --Rejuvenation (Rank 3)
[19709] = "900;0", --Well Fed
[687] = "1800;0", --Demon Skin (Rank 1)
[38232] = "20;0", --Battle Shout
[33702] = "15;0", --Blood Fury (Racial)
[58448] = "1800;1", --Strength (Rank 7)
[9896] = "16;0", --Rip (Rank 6)
[31462] = "3600;0", --Moonwell Restoration
[57452] = "0;0", --Kindred Spirits
[24586] = "10;3", --Scorpid Poison (Rank 3)
[37578] = "5;0", --Debilitating Strike
[8156] = "0;0", --Stoneskin (Rank 2)
[57484] = "0;0", --Kindred Spirits
[17462] = "0;0", --Red Skeletal Horse
[58775] = "0;0", --Mana Spring (Rank 6)
[51999] = "12;1", --Earthliving (Rank 5)
[25290] = "600;1", --Blessing of Wisdom (Rank 6)
[28521] = "3600;0", --Flask of Blinding Light
[25387] = "3;0", --Mind Flay (Rank 7)
[68160] = "15;0", --Meteor Fists
[53468] = "0;0", --Leeching Swarm
[42723] = "2;0", --Dark Smash
[46352] = "3600;0", --Fire Festival Fury
[580] = "0;0", --Timber Wolf
[50448] = "30;1", --Bloody Vengeance
[57086] = "0;0", --Frenzy
[56827] = "60;1", --Aura of Arcane Haste
[36702] = "0;0", --Fiery Warhorse
[53030] = "10;3", --Leech Poison
[21049] = "30;1", --Bloodlust
[67332] = "0;0", --Flaming Cinder
[47699] = "300;1", --Crystal Bark
[53317] = "15;0", --Rend
[57660] = "0;0", --Totem of Wrath
[68161] = "15;0", --Meteor Fists
[8936] = "21;1", --Regrowth (Rank 1)
[45444] = "0;0", --Bonfire's Blessing
[47747] = "45;0", --Charge Rifts
[41635] = "30;1", --Prayer of Mending (Rank 1)
[57453] = "0;0", --Kindred Spirits
[56969] = "8;0", --Arcane Blast
[47779] = "4;1", --Arcane Torrent
[58752] = "0;0", --Stoneskin (Rank 9)
[25746] = "15;1", --Damage Absorb
[48100] = "1800;1", --Intellect (Rank 7)
[1127] = "27;0", --Food
[51714] = "20;0", --Frost Vulnerability
[8898] = "1200;1", --Sapta Sight
[71175] = "15;0", --Agile
[5171] = "15;0",  --Slice and Dice (Rank 1)
[853] = "3;1",  --Hammer of Justice (Rank 1)
[8052] = "18;1",  --Flame Shock (Rank 2)
[29073] = "30;0", --Food
[13550] = "15;3", --Serpent Sting (Rank 3)
[63438] = "0;0", --Silvermoon Champion's Pennant
[7947] = "60;3", --Localized Toxin
[7948] = "20;1", --Wild Regeneration
[22766] = "0;0", --Sneak (Rank 1)
[3603] = "15;0", --Distracting Pain
[6432] = "10;0", --Smite Stomp
[113] = "15;1", --Chains of Ice (Rank 1)
[60299] = "20;0", --Incisor Fragment
[28189] = "1800;0", --Fel Armor (Rank 2)
[970] = "18;1", --Shadow Word: Pain (Rank 3)
[5171] = "12;0", --Slice and Dice (Rank 1)
[64491] = "20;0", --Furious Howl (Rank 2)
[9821] = "15;0", --Dash (Rank 2)
[6713] = "5;0", --Disarm
[3747] = "30;1", --Power Word: Shield (Rank 4)
[2090] = "15;1", --Rejuvenation (Rank 4)
[65081] = "4;1", --Body and Soul
[28273] = "600;0", --Bloodthistle
[7483] = "300;0", --Howling Rage
[7484] = "300;0", --Howling Rage
[6466] = "3;0", --Axe Toss
[29333] = "3600;0", --Midsummer Sausage
[62380] = "7200;0", --Lesser Flask of Resistance
[17627] = "3600;0", --Distilled Wisdom
[592] = "30;1", --Power Word: Shield (Rank 2)
[20707] = "900;0", --Soulstone Resurrection
[27863] = "600;0", --The Baron's Ultimatum
[5213] = "15;0", --Molten Metal
[10909] = "60;0", --Mind Vision (Rank 2)
[19974] = "15;1", --Entangling Roots (Rank 2)
[9128] = "120;0", --Battle Shout
[58452] = "1800;1", --Armor (Rank 7)
[594] = "18;1", --Shadow Word: Pain (Rank 2)
[52109] = "0;0", --Flametongue Totem (Rank 1)
[20006] = "12;1", --Unholy Curse
[122] = "8;1", --Frost Nova (Rank 1)
[30991] = "0;0", --Stealth
[10174] = "600;1", --Dampen Magic (Rank 5)
[6253] = "2;0", --Backhand
[9672] = "4;1", --Frostbolt
[8040] = "15;1", --Druid's Slumber
[16739] = "300;0", --Orb of Deception
[51209] = "10;1", --Hungering Cold (Rank 1)
[11977] = "15;0", --Rend
[58891] = "45;0", --Wild Magic
[70639] = "8;0", --Call of Sylvanas
[3140] = "8;0", --Fireball (Rank 4)
[8939] = "21;1", --Regrowth (Rank 3)
[6016] = "20;0", --Pierce Armor
[7038] = "60;4", --Forsaken Skill: Swords
[7039] = "60;4", --Forsaken Skill: Axes
[7040] = "60;4", --Forsaken Skill: Daggers
[7041] = "60;4", --Forsaken Skill: Maces
[7042] = "60;4", --Forsaken Skill: Staves
[7044] = "60;4", --Forsaken Skill: Guns
[7045] = "60;4", --Forsaken Skill: 2H Axes
[8066] = "120;4", --Shrink
[7812] = "30;1", --Sacrifice (Rank 1)
[7049] = "60;4", --Forsaken Skill: Fire
[1014] = "24;4", --Curse of Agony (Rank 2)
[3661] = "15;1", --Mend Pet (Rank 3)
[7053] = "60;4", --Forsaken Skill: Shadow
[600] = "30;1", --Power Word: Shield (Rank 3)
[7057] = "300;4", --Haunting Spirits
[5277] = "15;0", --Evasion (Rank 1)
[7322] = "7;1", --Frostbolt (Rank 4)
[7068] = "15;4", --Veil of Shadow
[6306] = "30;3", --Acid Splash
[7072] = "60;0", --Wild Rage
[7074] = "5;1", --Screams of the Past
[30482] = "1800;0", --Molten Armor (Rank 1)
[7046] = "60;4", --Forsaken Skill: 2H Maces
[10927] = "15;1", --Renew (Rank 7)
[7047] = "60;4", --Forsaken Skill: 2H Swords
[42777] = "0;0", --Swift Spectral Tiger
[435] = "24;0", --Food
[8365] = "10;1", --Enlarge
[430] = "18;0", --Drink
[14143] = "20;0", --Remorseless (Rank 1)
[8379] = "10;0", --Disarm
[700] = "20;1", --Sleep (Rank 1)
[14914] = "7;1", --Holy Fire (Rank 1)
[8041] = "10;0", --Serpent Form (Shapeshift)
[8112] = "1800;1", --Spirit (Rank 1)
[56112] = "10;0", --Furious Attacks
[6074] = "15;1", --Renew (Rank 2)
[53578] = "15;0", --Savage Rend (Rank 2)
[1008] = "600;1", --Amplify Magic (Rank 1)
[6205] = "120;4", --Curse of Weakness (Rank 3)
[1079] = "12;0", --Rip (Rank 1)
[33720] = "7200;0", --Onslaught Elixir
[10405] = "0;0", --Stoneskin (Rank 6)
[7295] = "10;1", --Soul Drain
[431] = "21;0", --Drink
[53386] = "30;0", --Cinderglacier
[71345] = "0;0", --Big Love Rocket
[8926] = "12;1", --Moonfire (Rank 4)
[7481] = "300;0", --Howling Rage
[26522] = "1800;0", --Lunar Fortune
[543] = "30;1", --Fire Ward (Rank 1)
[19386] = "6;3", --Wyvern Sting (Rank 1)
[29335] = "3600;0", --Elderberry Pie
[7621] = "10;4", --Arugal's Curse
[7051] = "60;4", --Forsaken Skill: Holy
[703] = "18;0", --Garrote (Rank 1)
[8134] = "600;1", --Lightning Shield (Rank 5)
[28274] = "1200;0", --Bloodthistle Withdrawal
[1850] = "15;0", --Dash (Rank 1)
[19434] = "10;0", --Aimed Shot (Rank 1)
[59882] = "9;0", --Rake (Rank 2)
[16490] = "6;0", --Blood Craze
[8140] = "15;1", --Befuddlement (Rank 1)
[7121] = "10;0", --Anti-Magic Shield
[10898] = "30;1", --Power Word: Shield (Rank 7)
[29332] = "3600;0", --Fire-toasted Bun
[7124] = "300;4", --Arugal's Gift
[7125] = "120;3", --Toxic Saliva
[3698] = "10;0", --Health Funnel (Rank 2)
[7127] = "60;1", --Wavering Will
[8148] = "0;0", --Thorns Aura
[18381] = "30;0", --Cripple (Rank 1)
[7054] = "300;4", --Forsaken Skills
[6075] = "15;1", --Renew (Rank 3)
[58496] = "7200;0", --Sad
[8153] = "0;0", --Owl Form (Shapeshift)
[7389] = "15;0", --Attack
[20765] = "900;0", --Soulstone Resurrection
[16689] = "45;1", --Nature's Grasp (Rank 1)
[7399] = "4;1", --Terrify
[35712] = "0;0", --Great Green Elekk
[8382] = "45;3", --Leech Poison
[7140] = "5;1", --Expose Weakness
[6547] = "15;0", --Rend (Rank 3)
[8162] = "0;0", --Strength of Earth (Rank 2)
[5159] = "20;0", --Melt Ore
[69180] = "30;4", --Gutgore Ripper
[63668] = "15;1", --Black Arrow (Rank 2)
[8198] = "14;0", --Thunder Clap (Rank 2)
[8398] = "8;1", --Frostbolt Volley
[2944] = "24;2", --Devouring Plague (Rank 1)
[25295] = "15;3", --Serpent Sting (Rank 9)
[434] = "21;0", --Food
[2983] = "15;0", --Sprint (Rank 1)
[1094] = "15;1", --Immolate (Rank 3)
[853] = "3;1", --Hammer of Justice (Rank 1)
[51466] = "0;0", --Elemental Oath (Rank 1)
[5115] = "6;1", --Battle Command
[6136] = "5;1", --Chilled (Rank 1)
[1159] = "6;0", --First Aid (Rank 2)
[27065] = "10;0", --Aimed Shot (Rank 7)
[45693] = "0;0", --Torches Caught
[689] = "5;1", --Drain Life (Rank 1)
[1160] = "30;0", --Demoralizing Shout (Rank 1)
[8938] = "21;1", --Regrowth (Rank 2)
[3427] = "30;2", --Infected Wound
[8056] = "8;1", --Frost Shock (Rank 1)
[837] = "6;1", --Frostbolt (Rank 3)
[1735] = "30;0", --Demoralizing Roar (Rank 2)
[12548] = "8;1", --Frost Shock
[43197] = "1800;1", --Spirit (Rank 6)
[13797] = "15;1", --Immolation Trap (Rank 1)
[47439] = "360;0", --Commanding Shout (Rank 2)
[6548] = "15;0", --Rend (Rank 4)
[23600] = "6;0", --Piercing Howl
[21069] = "6;3", --Larva Goo
[11580] = "26;0", --Thunder Clap (Rank 5)
[8101] = "1800;1", --Stamina (Level 3)
[64128] = "4;1", --Body and Soul
[6065] = "30;1", --Power Word: Shield (Rank 5)
[33053] = "7200;0", --Mr Pinchy's Blessing
[18610] = "8;0", --First Aid (Rank 10)
[11113] = "6;0", --Blast Wave (Rank 1)
[6077] = "12;1", --Renew (Rank 5)
[11640] = "15;1", --Renew
[23768] = "7200;0", --Sayge's Dark Fortune of Damage
[13704] = "6;1", --Psychic Scream
[5588] = "4;1", --Hammer of Justice (Rank 2)
[45062] = "0;0", --Holy Energy
[24870] = "900;0", --Well Fed
[15265] = "7;1", --Holy Fire (Rank 5)
[56352] = "12;1", --Storm Punch
[14251] = "30;0", --Riposte
[8157] = "0;0", --Stoneskin (Rank 3)
[7648] = "18;1", --Corruption (Rank 4)
[10179] = "9;1", --Frostbolt (Rank 8)
[53909] = "15;0", --Wild Magic
[6131] = "8;1", --Frost Nova (Rank 3)
[51945] = "12;1", --Earthliving (Rank 1)
[12255] = "900;4", --Curse of Tuten'kash
[3583] = "60;3", --Deadly Poison
[10730] = "10;1", --Pacify
[10734] = "3;0", --Hail Storm
[6143] = "30;1", --Frost Ward (Rank 1)
[13812] = "0;0", --Explosive Trap Effect (Rank 1)
[32727] = "0;0", --Arena Preparation
[11273] = "10;0", --Rupture (Rank 4)
[5137] = "60;4", --Call of the Grave
[12826] = "10;1", --Polymorph (Rank 4)
[28703] = "900;0", --Netherbloom Pollen
[13864] = "1800;1", --Power Word: Fortitude
[21062] = "30;2", --Putrid Breath
[2070] = "35;0", --Sap (Rank 2)
[3604] = "8;0", --Tendon Rip
[8263] = "0;0", --Elemental Protection Totem Aura (Rank 1)
[8267] = "600;4", --Cursed Blood
[43195] = "1800;1", --Intellect (Rank 6)
[20615] = "3;0", --Intercept (Rank 3)
[10838] = "8;0", --First Aid (Rank 7)
[55012] = "0;0", --Lok'lira's Bargain
[11876] = "3;0", --War Stomp
[9840] = "15;1", --Rejuvenation (Rank 9)
[15976] = "10;0", --Puncture
[453] = "15;0", --Mind Soothe
[9856] = "21;1", --Regrowth (Rank 7)
[6726] = "5;1", --Silence
[11397] = "300;2", --Diseased Shot
[2602] = "15;1", --Fire Shield IV
[6223] = "18;1", --Corruption (Rank 3)
[12946] = "10;2", --Putrid Stench
[6742] = "30;1", --Bloodlust
[5211] = "2;0", --Bash (Rank 1)
[5217] = "6;0", --Tiger's Fury (Rank 1)
[11445] = "60;1", --Bone Armor
[14515] = "15;1", --Dominate Mind
[25941] = "900;0", --Well Fed
[8391] = "3;0", --Ravage
[3639] = "6;0", --Improved Blocking
[8399] = "10;1", --Sleep
[1822] = "9;0", --Rake (Rank 1)
[8407] = "8;1", --Frostbolt (Rank 6)
[1823] = "9;0", --Rake (Rank 2)
[21909] = "8;0", --Dust Field
[19897] = "0;0", --Frost Resistance Aura (Rank 2)
[12523] = "12;0", --Pyroblast (Rank 4)
[12531] = "8;1", --Chilling Touch
[10491] = "0;0", --Mana Spring (Rank 2)
[1062] = "15;1", --Entangling Roots (Rank 2)
[74960] = "10;0", --Infrigidate
[32736] = "5;0", --Mortal Strike
[9493] = "12;0", --Rip (Rank 3)
[25606] = "1800;1", --Pendant of the Agate Shield
[8990] = "0;0", --Retribution Aura (Rank 1)
[3662] = "15;1", --Mend Pet (Rank 4)
[8495] = "60;1", --Mana Shield (Rank 3)
[11573] = "15;0", --Rend (Rank 6)
[25694] = "900;0", --Well Fed
[25702] = "21;0", --Food
[12627] = "0;0", --Disease Cloud
[18093] = "10;1", --Pyroclasm
[11641] = "10;1", --Hex
[66684] = "0;0", --Flaming Cinder
[60343] = "3600;0", --Mighty Defense
[11665] = "15;1", --Immolate (Rank 5)
[30931] = "20;0", --Battle Shout
[3700] = "10;0", --Health Funnel (Rank 4)
[12890] = "15;1", --Deep Slumber
[25894] = "1800;1", --Greater Blessing of Wisdom (Rank 1)
[13218] = "15;3", --Wound Poison (Rank 1)
[13222] = "15;3", --Wound Poison II (Rank 2)
[10160] = "8;1", --Cone of Cold (Rank 4)
[28489] = "3600;0", --Camouflage
[3699] = "7;0", --Health Funnel (Rank 3)
[8639] = "16;0", --Rupture (Rank 2)
[71866] = "6;0", --Fountain of Light
[32593] = "600;1", --Earth Shield (Rank 2)
[24425] = "7200;0", --Spirit of Zandalar
[8455] = "600;1", --Amplify Magic (Rank 2)
[53572] = "6;0", --Tendon Rip (Rank 3)
[9833] = "12;1", --Moonfire (Rank 8)
[20925] = "10;1", --Holy Shield (Rank 1)
[17311] = "3;0", --Mind Flay (Rank 2)
[15266] = "7;1", --Holy Fire (Rank 6)
[72282] = "0;0", --Invincible
[31643] = "8;1", --Blazing Speed
[13532] = "10;0", --Thunder Clap (Rank 1)
[24974] = "14;1", --Insect Swarm (Rank 2)
[10458] = "8;0", --Frostbrand Attack (Rank 3)
[465] = "0;0", --Devotion Aura (Rank 1)
[14324] = "300;1", --Hunter's Mark (Rank 3)
[12795] = "120;0", --Frenzy
[39318] = "0;0", --Tan Riding Talbuk
[8204] = "18;0", --Thunder Clap (Rank 3)
[18658] = "10;1", --Hibernate (Rank 3)
[676] = "10;0", --Disarm
[13326] = "1800;1", --Arcane Intellect
[14032] = "18;1", --Shadow Word: Pain
[18972] = "20;1", --Slow
[75731] = "0;0", --Instant Statue
[6213] = "15;1", --Fear (Rank 2)
[5403] = "6;1", --Crash of Waves
[61451] = "0;0", --Flying Carpet
[6940] = "12;1", --Hand of Sacrifice
[7964] = "4;1", --Smoke Bomb
[7966] = "60;0", --Thorns Aura
[5413] = "120;2", --Noxious Catalyst
[3222] = "7200;0", --Strong Troll's Blood Elixir
[70845] = "10;0", --Stoicism
[11971] = "30;0", --Sunder Armor
[60518] = "10;1", --Touched by a Troll
[10831] = "5;1", --Reflection Field
[27260] = "1800;0", --Demon Armor (Rank 6)
[10899] = "30;1", --Power Word: Shield (Rank 8)
[8288] = "15;0", --Drain Soul (Rank 2)
[12891] = "45;0", --Acid Breath
[3742] = "15;0", --Static Electricity
[63735] = "20;1", --Serendipity
[10348] = "20;0", --Tune Up
[59676] = "1800;0", --Residue of Darkness
[1108] = "120;4", --Curse of Weakness (Rank 2)
[53579] = "15;0", --Savage Rend (Rank 3)
[59675] = "1800;0", --Nexus Residue
[63896] = "12;0", --Bullheaded
[11366] = "12;0", --Pyroblast (Rank 1)
[52110] = "0;0", --Flametongue Totem (Rank 2)
[20902] = "10;0", --Aimed Shot (Rank 4)
[945] = "600;1", --Lightning Shield (Rank 4)
[71485] = "30;0", --Agility of the Vrykul
[24712] = "3600;0", --Leper Gnome Costume
[139] = "15;1", --Renew (Rank 1)
[27125] = "1800;0", --Mage Armor (Rank 4)
[11426] = "60;1", --Ice Barrier (Rank 1)
[9034] = "21;1", --Immolate
[10412] = "8;0", --Earth Shock (Rank 5)
[25859] = "0;0", --Reindeer
[11442] = "180;2", --Withered Touch
[24394] = "2;0", --Intimidation
[17312] = "3;0", --Mind Flay (Rank 3)
[699] = "5;1", --Drain Life (Rank 2)
[34976] = "0;0", --Netherstorm Flag
[12484] = "2;0", --Chilled (Rank 1)
[29544] = "6;0", --Frightening Shout
[52909] = "1800;0", --Water Breathing
[408] = "1;0", --Kidney Shot (Rank 1)
[8046] = "8;0", --Earth Shock (Rank 4)
[9438] = "8;0", --Arcane Bubble
[8910] = "15;1", --Rejuvenation (Rank 7)
[31125] = "4;0", --Blade Twisting
[19891] = "0;0", --Fire Resistance Aura (Rank 1)
[13542] = "15;1", --Mend Pet (Rank 5)
[8058] = "8;1", --Frost Shock (Rank 2)
[3267] = "7;0", --First Aid (Rank 3)
[15087] = "15;0", --Evasion
[59884] = "9;0", --Rake (Rank 4)
[64343] = "10;0", --Impact (Rank 1)
[8068] = "1800;1", --Healthy Spirit
[9482] = "30;1", --Amplify Flames
[58451] = "1800;1", --Agility (Rank 8)
[9490] = "30;0", --Demoralizing Roar (Rank 3)
[12528] = "10;1", --Silence
[8078] = "10;1", --Thunderclap
[48103] = "1800;1", --Spirit (Rank 7)
[2767] = "18;1", --Shadow Word: Pain (Rank 5)
[11554] = "30;0", --Demoralizing Shout (Rank 3)
[8492] = "8;1", --Cone of Cold (Rank 2)
[9007] = "18;0", --Pounce Bleed (Rank 1)
[14201] = "12;0", --Enrage (Rank 2)
[24379] = "10;0", --Restoration
[70747] = "30;0", --Quad Core
[16177] = "15;1", --Ancestral Fortitude (Rank 1)
[15971] = "30;0", --Demoralizing Roar
[12097] = "20;0", --Pierce Armor
[45724] = "0;0", --Braziers Hit!
[1135] = "30;0", --Drink
[45245] = "1800;0", --Well Fed
[48838] = "10;0", --Elemental Tenacity
[6066] = "30;1", --Power Word: Shield (Rank 6)
[1137] = "30;0", --Drink
[1490] = "300;4", --Curse of the Elements (Rank 1)
[10596] = "0;0", --Nature Resistance (Rank 1)
[54443] = "20;0", --Demonic Empowerment
[6076] = "15;1", --Renew (Rank 4)
[6078] = "15;1", --Renew (Rank 6)
[10404] = "0;0", --Stoneskin (Rank 5)
[21337] = "600;1", --Thorns
[11131] = "10;0", --Icicle
[44415] = "3;1", --Blackout (Rank 1)
[62146] = "30;0", --Unflinching Valor
[3815] = "45;3", --Poison Cloud
[8282] = "120;4", --Curse of Blood
[67380] = "20;0", --Evasion (Rank 1)
[8600] = "180;2", --Fevered Plague
[11980] = "120;4", --Curse of Weakness
[5589] = "5;1", --Hammer of Justice (Rank 3)
[16277] = "15;0", --Flurry (Rank 2)
[16914] = "0;0", --Hurricane (Rank 1)
[15263] = "7;1", --Holy Fire (Rank 3)
[9275] = "21;1", --Immolate
[5599] = "8;1", --Hand of Protection (Rank 2)
[8632] = "18;0", --Garrote (Rank 3)
[70244] = "3600;0", --\"Wizardry\" Cologne
[8640] = "6;0", --Rupture (Rank 3)
[7651] = "5;1", --Drain Life (Rank 4)
[26008] = "1800;0", --Toast
[13553] = "15;3", --Serpent Sting (Rank 6)
[8285] = "3;0", --Rampage
[7992] = "24;3", --Slowing Poison
[21007] = "120;4", --Curse of Weakness
[12245] = "300;2", --Infected Spine
[33726] = "3600;0", --Elixir of Mastery
[16810] = "45;1", --Nature's Grasp (Rank 2)
[51399] = "2;0", --Death Grip
[27046] = "15;1", --Mend Pet (Rank 8)
[10732] = "10;0", --Supercharge
[2819] = "12;3", --Deadly Poison II (Rank 2)
[8696] = "15;0", --Sprint (Rank 2)
[6146] = "15;1", --Slow (Rank 2)
[11770] = "180;1", --Fire Shield (Rank 4)
[36899] = "3600;0", --Transporter Malfunction
[5196] = "21;1", --Entangling Roots (Rank 4)
[59843] = "600;0", --Underbelly Elixir
[17154] = "30;1", --The Green Tower (Rank 1)
[19972] = "21;1", --Entangling Roots (Rank 4)
[9750] = "21;1", --Regrowth (Rank 6)
[120] = "8;1", --Cone of Cold (Rank 1)
[12824] = "30;1", --Polymorph (Rank 2)
[709] = "5;1", --Drain Life (Rank 3)
[8377] = "4;0", --Earthgrab
[9747] = "30;0", --Demoralizing Roar (Rank 4)
[32292] = "0;0", --Swift Purple Gryphon
[710] = "20;1", --Banish (Rank 1)
[19278] = "24;2", --Devouring Plague (Rank 4)
[15407] = "3;0", --Mind Flay (Rank 1)
[8163] = "0;0", --Strength of Earth (Rank 3)
[11327] = "10;0", --Vanish (Rank 1)
[9798] = "0;0", --Radiation
[8269] = "120;0", --Frenzy
[5677] = "0;0", --Mana Spring (Rank 1)
[8788] = "600;1", --Lightning Shield (Rank 4)
[8281] = "6;1", --Sonic Burst
[12884] = "45;0", --Acid Breath
[8289] = "15;0", --Drain Soul (Rank 3)
[21655] = "1;0", --Blink
[3356] = "45;1", --Flame Lash
[12540] = "4;0", --Gouge
[12248] = "10;1", --Amplify Damage
[7739] = "10;1", --Inferno Shell
[12251] = "30;3", --Virulent Poison
[8317] = "180;1", --Fire Shield (Rank 3)
[19876] = "0;0", --Shadow Resistance Aura (Rank 1)
[65637] = "0;0", --Great Red Elekk
[13439] = "5;1", --Frostbolt
[12421] = "2;0", --Mithril Frag Bomb
[10892] = "18;1", --Shadow Word: Pain (Rank 6)
[10452] = "20;1", --Flame Buffet
[11922] = "15;1", --Entangling Roots
[49623] = "15;0", --Effervescence
[20763] = "900;0", --Soulstone Resurrection
[11962] = "15;1", --Immolate
[14298] = "15;1", --Immolation Trap (Rank 2)
[2601] = "30;1", --Fire Shield III
[10413] = "8;0", --Earth Shock (Rank 6)
[12461] = "2;0", --Backhand
[15531] = "8;1", --Frost Nova
[992] = "18;1", --Shadow Word: Pain (Rank 4)
[14517] = "30;1", --Crusader Strike
[15039] = "12;1", --Flame Shock
[50486] = "18;1", --Acclimation
[11974] = "30;1", --Power Word: Shield
[9256] = "10;0", --Deep Sleep
[12493] = "120;4", --Curse of Weakness
[20875] = "900;0", --Rumsey Rum
[11020] = "8;1", --Petrify
[8928] = "12;1", --Moonfire (Rank 6)
[75458] = "15;0", --Piercing Twilight
[59125] = "120;0", --Lucky
[8940] = "21;1", --Regrowth (Rank 4)
[5246] = "8;0", --Intimidating Shout
[9459] = "60;1", --Corrosive Ooze
[13551] = "21;3", --Serpent Sting (Rank 4)
[38254] = "1800;2", --Festering Wound
[10493] = "0;0", --Mana Spring (Rank 3)
[6789] = "3;1", --Death Coil (Rank 1)
[11555] = "30;0", --Demoralizing Shout (Rank 4)
[6793] = "6;0", --Tiger's Fury (Rank 2)
[29674] = "0;1", --Lesser Shielding
[19973] = "18;1", --Entangling Roots (Rank 3)
[10598] = "0;0", --Nature Resistance (Rank 2)
[8988] = "10;1", --Silence (Rank 1)
[21331] = "15;1", --Entangling Roots
[11551] = "240;0", --Battle Shout (Rank 6)
[61425] = "0;0", --Traveler's Tundra Mammoth
[8633] = "18;0", --Garrote (Rank 4)
[9906] = "5;1", --Reflection
[57529] = "0;1", --Arcane Potency
[21067] = "10;3", --Poison Bolt
[50263] = "20;1", --Quickness of the Sailor
[8927] = "12;1", --Moonfire (Rank 5)
[64492] = "20;0", --Furious Howl (Rank 3)
[12098] = "20;1", --Sleep
[12096] = "8;1", --Fear
[19276] = "24;2", --Devouring Plague (Rank 2)
[39628] = "3600;0", --Elixir of Ironskin
[3419] = "6;0", --Improved Blocking
[5195] = "18;1", --Entangling Roots (Rank 3)
[71560] = "30;0", --Speed of the Vrykul
[24709] = "3600;0", --Pirate Costume
[27153] = "0;0", --Fire Resistance Aura (Rank 4)
[19277] = "24;2", --Devouring Plague (Rank 3)
[11820] = "6;0", --Electrified Net
[11443] = "15;1", --Cripple
[9080] = "10;0", --Hamstring
[11639] = "18;1", --Shadow Word: Pain
[46630] = "90;0", --Torch Tossing Practice
[11647] = "30;0", --Power Word: Shield
[15262] = "7;1", --Holy Fire (Rank 2)
[65780] = "300;0", --Pink Gumball
[19710] = "900;0", --Well Fed
[6728] = "10;1", --Enveloping Winds (Rank 1)
[36893] = "3600;0", --Transporter Malfunction
[11671] = "18;1", --Corruption (Rank 5)
[13298] = "30;3", --Poison
[8275] = "75;3", --Poisoned Shot
[3439] = "300;2", --Wandering Plague
[4318] = "1800;1", --Guile of the Raptor
[3627] = "15;1", --Rejuvenation (Rank 6)
[1943] = "16;0", --Rupture (Rank 1)
[11699] = "5;1", --Drain Life (Rank 5)
[10170] = "600;1", --Amplify Magic (Rank 4)
[11707] = "120;4", --Curse of Weakness (Rank 5)
[11711] = "24;4", --Curse of Agony (Rank 4)
[28509] = "3600;0", --Greater Mana Regeneration
[12741] = "120;4", --Curse of Weakness
[34709] = "15;0", --Shadow Sight
[57514] = "12;0", --Enrage (Rank 1)
[6217] = "24;4", --Curse of Agony (Rank 3)
[2941] = "15;1", --Immolate (Rank 4)
[64937] = "5;0", --Heightened Reflexes
[16812] = "45;1", --Nature's Grasp (Rank 4)
[865] = "8;1", --Frost Nova (Rank 2)
[33082] = "1800;1", --Strength (Rank 5)
[17347] = "15;0", --Hemorrhage (Rank 2)
[14314] = "0;0", --Explosive Trap Effect (Rank 2)
[59883] = "9;0", --Rake (Rank 3)
[8408] = "8;1", --Frostbolt (Rank 7)
[63311] = "8;0", --Glyph of Shadowflame
[11264] = "10;1", --Ice Blast
[61299] = "15;1", --Riptide (Rank 2)
[12294] = "10;0", --Mortal Strike (Rank 1)
[10159] = "11;1", --Cone of Cold (Rank 3)
[740] = "8;0", --Tranquility (Rank 1)
[56521] = "1800;1", --Blessing of Wisdom
[6190] = "30;0", --Demoralizing Shout (Rank 2)
[17537] = "3600;0", --Elixir of Brute Force
[45694] = "180;0", --Captain Rumsey's Lager
[21547] = "5;0", --Spore Cloud
[5138] = "5;1", --Drain Mana
[9775] = "60;2", --Irradiated
[2818] = "12;3", --Deadly Poison (Rank 1)
[21068] = "24;1", --Corruption
[49962] = "17;0", --Jungle Madness!
[8258] = "240;0", --Devotion Aura
[60517] = "20;0", --Talisman of Troll Divinity
[1133] = "27;0", --Drink
[21749] = "2;0", --Thorn Volley
[20927] = "10;1", --Holy Shield (Rank 2)
[50872] = "30;0", --Savagery
[48333] = "300;0", --Going Ape
[56525] = "1800;1", --Blessing of Kings
[25747] = "15;1", --Damage Absorb
[745] = "5;0", --Web
[2091] = "15;1", --Rejuvenation (Rank 5)
[42792] = "3;0", --Recently Dropped Flag
[9839] = "15;1", --Rejuvenation (Rank 8)
[21687] = "15;3", --Toxic Volley
[10093] = "1;0", --Harsh Winds
[23759] = "0;0", --Master Demonologist
[23767] = "7200;0", --Sayge's Dark Fortune of Armor
[11550] = "120;0", --Battle Shout (Rank 5)
[10180] = "9;1", --Frostbolt (Rank 9)
[3256] = "240;2", --Plague Cloud
[6533] = "2;0", --Net
[59674] = "1800;0", --Moonshroud Residue
[33259] = "1800;0", --Well Fed
[1129] = "30;0", --Food
[21787] = "120;3", --Deadly Poison
[52111] = "0;0", --Flametongue Totem (Rank 3)
[8362] = "20;1", --Renew
[13526] = "30;3", --Corrosive Poison
[11436] = "10;1", --Slow
[11329] = "10;0", --Vanish (Rank 2)
[15532] = "8;1", --Frost Nova
[74855] = "0;0", --Blazing Hippogryph
[14518] = "30;1", --Crusader Strike
[45699] = "5;0", --Flames of Failure
[15548] = "10;1", --Thunderclap
[12486] = "2;0", --Chilled (Rank 3)
[8402] = "8;0", --Fireball (Rank 7)
[8406] = "7;1", --Frostbolt (Rank 5)
[51911] = "2;0", --Spell Deflection
[8925] = "12;1", --Moonfire (Rank 3)
[8929] = "12;1", --Moonfire (Rank 7)
[20901] = "10;0", --Aimed Shot (Rank 3)
[8053] = "18;1", --Flame Shock (Rank 3)
[8941] = "21;1", --Regrowth (Rank 5)
[6524] = "2;0", --Ground Tremor
[12611] = "8;1", --Cone of Cold
[12530] = "60;1", --Frailty
[61291] = "8;1", --Shadowflame
[10494] = "0;0", --Mana Spring (Rank 4)
[12040] = "30;1", --Shadow Shield
[19440] = "30;1", --Sacrifice (Rank 3)
[5005] = "21;0", --Food
[13445] = "15;0", --Rend
[9492] = "12;0", --Rip (Rank 2)
[47057] = "180;0", --Fiery Seduction
[12479] = "10;0", --Hex of Jammal'an

		
}


--Durations that don't match PvE durations.
--http://www.wowwiki.com/Diminishing_returns
lib.auraInfoPvP = {
[339] = 10, --Entangling Roots (Rank 1)
[53313] = 10, --Entangling Roots (Rank 8)
[53308] = 10, --Entangling Roots (Rank 8)
[18657] = 10, --Hibernate (Rank 2)
[14308] = 10, --Freezing Trap Effect (Rank 2)
[14309] = 10, --Freezing Trap Effect (Rank 3)
[3355] = 10, --Freezing Trap Effect (Rank 1)
--~ [1513] = 10, --Scare Beast (Rank 1)
[49012] = 6, --Wyvern Sting (Rank 6)
[61721] = 10, --Polymorph (Rabbit)
[118] = 10, --Polymorph (Rank 1)
[20066] = 6, --Repentance
[10326] = 10, --Turn Evil
[605] = 10, --Mind Control
--~ [10955] = 10,--Shackle Undead 
[8643] = 6, --Kidney Shot (Rank 2) (time based on comob points, i'll assume they're using 5 points)
[51724] = 10, --Sap (Rank 4)
[6770] = 10, --Sap (Rank 1)
[51514] = 10, --Hex 
[18647] = 6, --Banish (Rank 2)
[6215] = 10, --Fear (Rank 3)
[6358] = 10, --Seduction
[1715] = 10, --Hamstring
[770] = 40, --Faerie Fire
[16857] = 40, --Faerie Fire (Feral)
[53338] = 120,  --Hunter's Mark (Rank 5)* Confirm Duration",
[47865] = 120, --Curse of the Elements (Rank 5)
}

--~ local mem2 = collectgarbage("count")
--~ local memoryUsed = (mem2 - mem1) * 1024
--~ print("our spelldata table's using. "..memoryUsed.." bytes")

--~ local newTbl = {}

--~ for spellID in pairs(lib.auraInfo) do 
--~ 	newTbl[spellID] = {x=1,y=1}
--~ end

--~ local mem3 = collectgarbage("count")
--~ local memoryUsed = (mem3 - mem2) * 1024
--~ print("our spelldata if we were using tables. "..memoryUsed.." bytes")