if not (type(OneRingLib) == "table" and type(OneRingLib.CreateRing) == "function") then
	return;
end

local function generateColor(c, n)
	local hue, v, s = (15+(c-1)*360/n)%360, 1, 0.85;

	local h = floor(hue/60) % 6;
	local f = (hue/60) % 1;
	local p, q, t = v - v * s, v - v * f * s, v - v*s + v * f * s;
	if h == 0 then return v, t, p;
	elseif h == 1 then return q, v, p;
	elseif h == 2 then return p, v, t;
	elseif h == 3 then return p, q, v;
	elseif h == 4 then return t, p, v;
	elseif h == 5 then return v, p, q;
	end
end

do -- OPieTrinkets
	OneRingLib:CreateRing("OPieTrinkets", {
		{"item", (GetInventorySlotInfo("Trinket0Slot")), r=0.05, g=0.75, b=0.95}, -- top
		{"item", (GetInventorySlotInfo("Trinket1Slot")), r=0.95, g=0.75, b=0.05}, -- bottom
		name="Trinkets"
	});
end
do -- OPieRaidSymbols
	local rname, rdesc = "OPieRaidSymbols", {
		{"func", r=1, g=1, b=0}, -- yellow star
		{"func", r=1, g=0.5, b=0.05}, -- orange circle
		{"func", r=1, g=0.30, b=1}, -- purple diamond
		{"func", r=0.20, g=1, b=0.20}, -- green triangle
		{"func", r=0.65, g=0.84, b=1}, -- silver moon
		{"func", r=0.20, g=0.20, b=1}, -- blue square
		{"func", r=1, g=0.10, b=0.10}, -- red cross
		{"func", r=0.74, g=0.70, b=0.60}, -- white skull
		name="Raid Markers", hotkey="ALT-R"
	};
	local function ringClick(ring, id)
		if GetRaidTargetIndex("target") == id then id = 0; end
		SetRaidTarget("target", id);
	end
	local function ringActive(stype, sfunc, sid)
		return GetRaidTargetIndex("target") == sid;
	end
	for i=1,8 do
		rdesc[i][2], rdesc[i][3], rdesc[i].icon, rdesc[i].active, rdesc[i].caption = ringClick, i, "Interface\\TargetingFrame\\UI-RaidTargetingIcon_" .. i, ringActive, _G["RAID_TARGET_" .. i];
	end
	OneRingLib:CreateRing(rname, rdesc);
end
do -- OPieTracker
	local rname, rdesc, ringID = "OPieTracker", {
		name="Tracking", hotkey="ALT-F"
	};
	local function setTracking(ring, id)
		local name, tex = GetTrackingInfo(id);
		SetTracking(tex ~= GetTrackingTexture() and id or nil);
	end
	local function actionHint(etype, earg, eid)
		local name, tex = GetTrackingInfo(eid);
		return name and true or false, 0, 0, tex, name, 0, tex == GetTrackingTexture();
	end
	function rdesc.preClick()
		local n = GetNumTrackingTypes();
		if n ~= #rdesc then
			for i=1,n do
				rdesc[i] = rdesc[i] or {}; local t = rdesc[i];
				t[1], t[2], t[3], t.actionHint = "func", setTracking, i, actionHint;
				t.r, t.g, t.b = generateColor(i,n);
			end
			for i=n+1,#rdesc do
				rdesc[i] = nil;
			end
			OneRingLib:SetRingData(ringID, rdesc);
		end
	end
	ringID = OneRingLib:CreateRing(rname, rdesc);
	EC_Register("PLAYER_ENTERING_WORLD", "OPie.AutoTracker", function() return "remove", rdesc.preClick(ringID); end);
end
do -- OPieAutoQuest
	local pwhitelist = {[37888]=true, [37860]=true, [37859]=true, [37815]=true, [46847]=true, [47030]=true, [39213]=true, [42986]=true, [49278]=true};
	local blacklist, whitelist, inring, fastClickItem = {[32757]=true}, nil, {};
	local rname, rdesc, rid = "OPieAutoQuest", {
		name="Quest Items", hotkey="ALT-Q"
	};
	rid = OneRingLib:CreateRing(rname, rdesc);

	local itypeQuest, lastQEvent = nil, 0;
	local function isActiveQuestItem(link, iid, popwhitelist)
		local _, _, _, _, _, iType = GetItemInfo(iid);
		itypeQuest = itypeQuest or select(6,GetItemInfo(28455)) or "Quest";

		if (GetTime()-lastQEvent) < 1 and iType ~= itypeQuest and popwhitelist then
			-- Item received in shortly after starting a quest; add it just in case.
			whitelist[iid] = true;
		end
		return iid and (iType == itypeQuest or whitelist[iid]) and GetItemSpell(iid) and not blacklist[iid];
	end
	local function scanInventory()
		-- Clear the existing ring, we're rescanning from inventory.
		for i=1,#rdesc do rdesc[i] = nil; end
		for k in pairs(inring) do inring[k] = nil; end

		for bag=0,4 do
			for slot=1,GetContainerNumSlots(bag) do
				local link = GetContainerItemLink(bag, slot);
				local iid = link and tonumber(link:match("item:(%d+)"));
				if link and iid and isActiveQuestItem(link, iid) and not inring[iid] then
					rdesc[#rdesc+1], inring[iid] = {"item", link:match("item:%d+")}, true;
				end
			end
		end
	end
	local function syncRing()
		local n = #rdesc;
		for i, d in ipairs(rdesc) do
			d.fastClick, d.r, d.g, d.b = true, generateColor(i, n);
			if fastClickItem and d[2] == fastClickItem then rdesc.fastClickSlice = i; end
		end
		OneRingLib:SetRingData(rid, rdesc);
	end
	local function pvarNotify(event, name, var)
		if event == "LOADED" then
			fastClickItem, var.fastClick = var.fastClick, fastClickItem;
			syncRing();
		elseif event == "LOGOUT" and rid then
			local fcslice = select(7, OneRingLib:GetRingInfo(rid)) or nil;
			var.fastClick = fcslice and rdesc[fcslice] and rdesc[fcslice][2] or nil;
		end
	end
	function rdesc.preClick(ring, id, force)
		if scanInventory then
			scanInventory();
			scanInventory = nil;
		else
			local i, changed = 1, force or false;
			while rdesc[i] do
				local iid = tonumber(rdesc[i][2]:match("item:(%d+)"));
				if GetItemCount(iid) == 0 then
					whitelist[iid], inring[iid], changed = nil, nil, true;
					table.remove(rdesc,i);
				else
					i = i + 1;
				end
			end
			if not changed then return; end
		end
		syncRing();
	end
	EC_Register("QUEST_FINISHED", "OPie.AutoQuest", function(e)
		-- Finished talking to a quest NPC, NOT finished a quest.
		lastQEvent = GetTime();
	end);
	EC_Register("CHAT_MSG_LOOT", "OPie.AutoQuest", function(e, text)
		local iid = tonumber(text:match("|Hitem:(%d+)"));
		if isActiveQuestItem(text:match("|H(.-)|h"), iid, true) and not inring[iid] then
			rdesc[#rdesc+1], inring[iid] = {"item", "item:" .. iid}, true;
			syncRing();
		end
	end);
	EC_Register("PLAYER_ENTERING_WORLD", "OPie.AutoQuest", function()
		itypeQuest = select(6, GetItemInfo(9570)) or select(6, GetItemInfo(29331)) or select(6, GetItemInfo(28455));
		if not itypeQuest then
			GameTooltip:SetOwner(UIParent, "ANCHOR_NONE")
			GameTooltip:SetHyperlink("item:28455");
			GameTooltip:Hide();
		end
		return "remove";
	end);
	EC_Register("PLAYER_REGEN_DISABLED", "OPie.AutoQuest", function()
		if scanInventory then
			scanInventory();
			syncRing();
		end
		return "remove";
	end);

	whitelist = setmetatable(OneRingLib:RegisterPVar("AutoQuestWhitelist", {}, pvarNotify), {__index=pwhitelist});
end