--[[	MTLove 2 is a 'small' World Of Warcraft Addon which adds
	a "target of mouseover" function to the client.
	Copyright (C) 2006-2009 Herrmann, Tom
	from Randoom.org

	This file is part of MTLove 2.

	MTLove 2 is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	version 2 as published by the Free Software Foundation.

	MTLove 2 is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.]]

MTLove_SavedVariables				= {};
local MTLove_SavedVariables_Cache		= {};
local MTLove_SavedVariables_General_Defaults	= {
							["Frame"]				= true,
							["Frame_Counter"]			= nil,
							["Frame_Mo_Bar"]			= true,
							["Frame_Mot_Bar"]			= true,
							["Frame_Offset_X"]			= nil,
							["Frame_Offset_Y"]			= nil,
							["TT"]					= nil,
							["TT_Counter"]				= nil,
							["TargetCounter"]			= true,
							["FocusCounter"]			= nil,
							["Self_NotInParty"]			= nil,
							["Mo_OutOfCombat"]			= nil,
							["Mot_Healer_Highlight"]		= true,
							["Mo_Friendly_PartyMember_Player"]	= nil,
							["Mo_Friendly_PartyMember_Pet"]		= nil,
							["Mo_Friendly_Player"]			= nil,
							["Mo_Friendly_Pet"]			= nil,
							["Mo_Friendly_Npc"]			= nil,
							["Mo_Enemy_Player"]			= true,
							["Mo_Enemy_Pet"]			= true,
							["Mo_Enemy_Npc"]			= true,
							["Mo_Neutral_Npc"]			= true,
							["Mot_Self"]				= true,
							["Mot_OwnPet"]				= nil,
							["Mot_Friendly_PartyMember_Player"]	= true,
							["Mot_Friendly_PartyMember_Pet"]	= nil,
							["Mot_Friendly_Player"]			= nil,
							["Mot_Friendly_Pet"]			= nil,
							["Mot_Friendly_Npc"]			= nil,
							["Mot_Enemy_Player"]			= nil,
							["Mot_Enemy_Pet"]			= nil,
							["Mot_Enemy_Npc"]			= nil,
							["Mot_Neutral_Npc"]			= nil,
							["Mot_Stun"]				= true,
							["Mot_Mo_Self"]				= true,
							["Mot_Nothing"]				= nil,
							["Count_Tanks"]				= true,
							["Count_Plate"]				= true,
							["Count_Mail"]				= true,
							["Count_Leather"]			= true,
							["Count_Pets"]				= nil,
							["Experimental_Features"]		= nil
						};
local MTLove_SavedVariables_PetHandler_Defaults	= {
							["Mot_OwnPet"]				= true,
							["Count_Pets"]				= true
						};
local MTLove_globalValues			= {};
MTLove_globalValues["UI_Name"]				= GetAddOnMetadata("MTLove", "Title");
MTLove_globalValues["UI_ClientLanguage"]		= GetLocale();
MTLove_globalValues["UI_Version"]			= GetAddOnMetadata("MTLove", "Version");
MTLove_globalValues["UI_Mail"]				= GetAddOnMetadata("MTLove", "X-Email");
MTLove_globalValues["UI_Website"]			= GetAddOnMetadata("MTLove", "X-Website");
MTLove_globalValues["Version_Major"]			= string.sub(MTLove_globalValues["UI_Version"], 1, 1);
MTLove_globalValues["Version_Minor"]			= string.sub(MTLove_globalValues["UI_Version"], 3, 3);
MTLove_globalValues["Version_SubMinor"]			= string.sub(MTLove_globalValues["UI_Version"], 5);
MTLove_globalValues["Version_PreRelease"]		= (string.len(MTLove_globalValues["Version_SubMinor"]) > 3);
MTLove_globalValues["Frame_Offset_Slider_Low"]		= -200;
MTLove_globalValues["Frame_Offset_Slider_High"]		= 200;
MTLove_globalValues["UI_Frame_Offset_Slider_Low"]	= tostring(MTLove_globalValues["Frame_Offset_Slider_Low"]);
MTLove_globalValues["UI_Frame_Offset_Slider_High"]	= tostring(MTLove_globalValues["Frame_Offset_Slider_High"]);
local MTLove_Stats				= nil;
local MTLove_Stats_CPU_Usage			= "";
local MTLove_Stats_Memory_Usage			= "";
local MTLove_GUI_Settings_changed		= nil;

function MTLove_get_SavedVariables(setting)
	if (setting ~= nil) then
		if (MTLove_SavedVariables_Cache[setting]) then
			return MTLove_SavedVariables_Cache[setting];
		else
			if (string.sub(setting, 1, 13) == "Frame_Offset_") then
				return 0;
			end
			return nil;
		end
	end
	return MTLove_SavedVariables_Cache;
end
function MTLove_set_SavedVariables(setting, value)
	if (string.sub(setting, 1, 13) == "Frame_Offset_") then
		if (tonumber(value) ~= 0) then
			value	= tonumber(value);
		else
			value	= nil;
		end
	end
	MTLove_SavedVariables_Cache[setting]		= value;
	MTLove_SavedVariables["MTLove_" .. setting]	= MTLove_SavedVariables_Cache[setting];
end

function MTLove_get_globalValues(setting)
	if (setting ~= nil) then
		return MTLove_globalValues[setting];
	end
	return MTLove_globalValues;
end
function MTLove_set_globalValue_UI_ClientLanguage(UI_ClientLanguage)
	MTLove_globalValues["UI_ClientLanguage"]	= UI_ClientLanguage;
end

function MTLove_set_Stats(stats)
	MTLove_Stats = stats;
end
function MTLove_get_Stats()
	return MTLove_Stats;
end

function MTLove_set_Stats_CPU_Usage(CPU_Usage)
	MTLove_Stats_CPU_Usage = CPU_Usage;
end
function MTLove_get_Stats_CPU_Usage()
	return MTLove_Stats_CPU_Usage;
end

function MTLove_set_Stats_Memory_Usage(Memory_Usage)
	MTLove_Stats_Memory_Usage = Memory_Usage;
end
function MTLove_get_Stats_Memory_Usage()
	return MTLove_Stats_Memory_Usage;
end

function MTLove_set_GUI_Settings_changed(Settings_changed)
	MTLove_GUI_Settings_changed = Settings_changed;
end
function MTLove_get_GUI_Settings_changed()
	return MTLove_GUI_Settings_changed;
end

function MTLove_loadVariables()
	if (MTLove_tcount(MTLove_SavedVariables) == 0) then
		MTLove_SavedVariables = {};
		MTLove_GUI_reset_to_defaults();
	end

-- remove in 2.3.1
	if (not MTLove_SavedVariables["MTLove_Version_Major"]) then
		if (MTLove_SavedVariables["MTLove_noFrame"]) then
			MTLove_set_SavedVariables("Frame", nil);
			MTLove_SavedVariables["MTLove_noFrame"] = nil;
		elseif (not MTLove_SavedVariables["MTLove_Version"])then
			MTLove_set_SavedVariables("Frame", true);
		end
		if (MTLove_SavedVariables["MTLove_HealerHighlight"]) then
			MTLove_set_SavedVariables("Mot_Healer_Highlight", true);
			MTLove_SavedVariables["MTLove_HealerHighlight"] = nil;
		end
		if (MTLove_SavedVariables["MTLove_MotBar"]) then
			MTLove_set_SavedVariables("Frame_Mot_Bar", true);
			MTLove_SavedVariables["MTLove_MotBar"] = nil;
		end
		if (MTLove_SavedVariables["MTLove_MoBar"]) then
			MTLove_set_SavedVariables("Frame_Mo_Bar", true);
			MTLove_SavedVariables["MTLove_MoBar"] = nil;
		end
		if (MTLove_SavedVariables["MTLove_X"]) then
			MTLove_set_SavedVariables("Frame_Offset_X", MTLove_SavedVariables["MTLove_X"]);
			MTLove_SavedVariables["MTLove_X"] = nil;
		end
		if (MTLove_SavedVariables["MTLove_Y"]) then
			MTLove_set_SavedVariables("Frame_Offset_Y", MTLove_SavedVariables["MTLove_Y"]);
			MTLove_SavedVariables["MTLove_Y"] = nil;
		end
		if (MTLove_SavedVariables["MTLove_TT"] or (not MTLove_SavedVariables["MTLove_noFrame"])) then
			MTLove_set_SavedVariables("Mo_Enemy_Npc", true);
			MTLove_set_SavedVariables("Mot_Friendly_PartyMember_Player", true);
			MTLove_set_SavedVariables("Mot_Stun", true);
			MTLove_set_SavedVariables("Count_Tanks", true);
			MTLove_set_SavedVariables("Count_Plate", true);
			MTLove_set_SavedVariables("Count_Mail", true);
			MTLove_set_SavedVariables("Count_Leather", true);
		end
		if (MTLove_SavedVariables["MTLove_Version"]) then
			MTLove_set_SavedVariables("Mot_Stun", true);
			MTLove_set_SavedVariables("Count_Tanks", true);
			MTLove_set_SavedVariables("Count_Plate", true);
			MTLove_set_SavedVariables("Count_Mail", true);
			MTLove_set_SavedVariables("Count_Leather", true);
			MTLove_SavedVariables["MTLove_Version"] = nil;
		end
		if (MTLove_SavedVariables["MTLove_ShowSelf"]) then
			MTLove_set_SavedVariables("Mot_Self", true);
			MTLove_SavedVariables["MTLove_ShowSelf"] = nil;
		end
		if (MTLove_SavedVariables["MTLove_ShowPet"]) then
			MTLove_set_SavedVariables("Mot_OwnPet", true);
			MTLove_set_SavedVariables("Mot_Friendly_PartyMember_Pet", true);
			MTLove_set_SavedVariables("Mot_Friendly_Pet", true);
			MTLove_SavedVariables["MTLove_ShowPet"] = nil;
		end
		if (MTLove_SavedVariables["MTLove_ShowNPC"]) then
			MTLove_set_SavedVariables("Mot_Friendly_Npc", true);
			MTLove_SavedVariables["MTLove_ShowNPC"] = nil;
		end
		if (MTLove_SavedVariables["MTLove_ShowPartyAliens"]) then
			MTLove_set_SavedVariables("Mot_Friendly_Player", true);
			MTLove_SavedVariables["MTLove_ShowPartyAliens"] = nil;
		end
		if (MTLove_SavedVariables["MTLove_AlwaysOn"]) then
			MTLove_set_SavedVariables("Mo_Friendly_PartyMember_Player", true);
			MTLove_set_SavedVariables("Mo_Friendly_PartyMember_Pet", true);
			MTLove_set_SavedVariables("Mo_Friendly_Player", true);
			MTLove_set_SavedVariables("Mo_Friendly_Pet", true);
			MTLove_set_SavedVariables("Mo_Friendly_Npc", true);
			MTLove_set_SavedVariables("Mot_Enemy_Player", true);
			MTLove_set_SavedVariables("Mot_Enemy_Pet", true);
			MTLove_set_SavedVariables("Mot_Enemy_Npc", true);
			MTLove_set_SavedVariables("Mot_Neutral_Npc", true);
			MTLove_SavedVariables["MTLove_AlwaysOn"] = nil;
		end
		if (MTLove_SavedVariables["MTLove_OutOfCombat"]) then
			MTLove_set_SavedVariables("Mo_OutOfCombat", true);
			MTLove_SavedVariables["MTLove_OutOfCombat"] = nil;
		end
		if (MTLove_SavedVariables["MTLove_ShowInPVP"]) then
			MTLove_set_SavedVariables("Mo_Enemy_Player", true);
			MTLove_set_SavedVariables("Mo_Enemy_Pet", true);
			MTLove_SavedVariables["MTLove_ShowInPVP"] = nil;
		end
		if (MTLove_SavedVariables["MTLove_SINIP"]) then
			MTLove_set_SavedVariables("Self_NotInParty", true);
			MTLove_SavedVariables["MTLove_SINIP"] = nil;
		end
	end
	if ((MTLove_SavedVariables["MTLove_Version_SubMinor"] == "0.BETA_2") and (MTLove_SavedVariables["MTLove_Version_Minor"] == "2") and (MTLove_SavedVariables["MTLove_Version_Major"] == "2")) then
		MTLove_set_SavedVariables("Count_Tanks", true);
	end
-- remove in 2.3.1

	if (MTLove_SavedVariables["MTLove_Frame"]) then
		MTLove_SavedVariables_Cache["Frame"]				= MTLove_SavedVariables["MTLove_Frame"];
	end
	if (MTLove_SavedVariables["MTLove_Frame_Counter"]) then
		MTLove_SavedVariables_Cache["Frame_Counter"]			= MTLove_SavedVariables["MTLove_Frame_Counter"];
	end
	if (MTLove_SavedVariables["MTLove_Frame_Mo_Bar"]) then
		MTLove_SavedVariables_Cache["Frame_Mo_Bar"]			= MTLove_SavedVariables["MTLove_Frame_Mo_Bar"];
	end
	if (MTLove_SavedVariables["MTLove_Frame_Mot_Bar"]) then
		MTLove_SavedVariables_Cache["Frame_Mot_Bar"]			= MTLove_SavedVariables["MTLove_Frame_Mot_Bar"];
	end
	if (MTLove_SavedVariables["MTLove_Frame_Offset_X"]) then
		MTLove_SavedVariables_Cache["Frame_Offset_X"]			= MTLove_SavedVariables["MTLove_Frame_Offset_X"];
	end
	if (MTLove_SavedVariables["MTLove_Frame_Offset_Y"]) then
		MTLove_SavedVariables_Cache["Frame_Offset_Y"]			= MTLove_SavedVariables["MTLove_Frame_Offset_Y"];
	end
	if (MTLove_SavedVariables["MTLove_TT"]) then
		MTLove_SavedVariables_Cache["TT"]				= MTLove_SavedVariables["MTLove_TT"];
	end
	if (MTLove_SavedVariables["MTLove_TT_Counter"]) then
		MTLove_SavedVariables_Cache["TT_Counter"]			= MTLove_SavedVariables["MTLove_TT_Counter"];
	end
	if (MTLove_SavedVariables["MTLove_TargetCounter"]) then
		MTLove_SavedVariables_Cache["TargetCounter"]			= MTLove_SavedVariables["MTLove_TargetCounter"];
	end
	if (MTLove_SavedVariables["MTLove_FocusCounter"]) then
		MTLove_SavedVariables_Cache["FocusCounter"]			= MTLove_SavedVariables["MTLove_FocusCounter"];
	end
	if (MTLove_SavedVariables["MTLove_Self_NotInParty"]) then
		MTLove_SavedVariables_Cache["Self_NotInParty"]			= MTLove_SavedVariables["MTLove_Self_NotInParty"];
	end
	if (MTLove_SavedVariables["MTLove_Mo_OutOfCombat"]) then
		MTLove_SavedVariables_Cache["Mo_OutOfCombat"]			= MTLove_SavedVariables["MTLove_Mo_OutOfCombat"];
	end
	if (MTLove_SavedVariables["MTLove_Mo_Friendly_PartyMember_Player"]) then
		MTLove_SavedVariables_Cache["Mo_Friendly_PartyMember_Player"]	= MTLove_SavedVariables["MTLove_Mo_Friendly_PartyMember_Player"];
	end
	if (MTLove_SavedVariables["MTLove_Mo_Friendly_PartyMember_Pet"]) then
		MTLove_SavedVariables_Cache["Mo_Friendly_PartyMember_Pet"]	= MTLove_SavedVariables["MTLove_Mo_Friendly_PartyMember_Pet"];
	end
	if (MTLove_SavedVariables["MTLove_Mo_Friendly_Player"]) then
		MTLove_SavedVariables_Cache["Mo_Friendly_Player"]		= MTLove_SavedVariables["MTLove_Mo_Friendly_Player"];
	end
	if (MTLove_SavedVariables["MTLove_Mo_Friendly_Pet"]) then
		MTLove_SavedVariables_Cache["Mo_Friendly_Pet"]			= MTLove_SavedVariables["MTLove_Mo_Friendly_Pet"];
	end
	if (MTLove_SavedVariables["MTLove_Mo_Friendly_Npc"]) then
		MTLove_SavedVariables_Cache["Mo_Friendly_Npc"]			= MTLove_SavedVariables["MTLove_Mo_Friendly_Npc"];
	end
	if (MTLove_SavedVariables["MTLove_Mo_Enemy_Player"]) then
		MTLove_SavedVariables_Cache["Mo_Enemy_Player"]			= MTLove_SavedVariables["MTLove_Mo_Enemy_Player"];
	end
	if (MTLove_SavedVariables["MTLove_Mo_Enemy_Pet"]) then
		MTLove_SavedVariables_Cache["Mo_Enemy_Pet"]			= MTLove_SavedVariables["MTLove_Mo_Enemy_Pet"];
	end
	if (MTLove_SavedVariables["MTLove_Mo_Enemy_Npc"]) then
		MTLove_SavedVariables_Cache["Mo_Enemy_Npc"]			= MTLove_SavedVariables["MTLove_Mo_Enemy_Npc"];
	end
	if (MTLove_SavedVariables["MTLove_Mo_Neutral_Npc"]) then
		MTLove_SavedVariables_Cache["Mo_Neutral_Npc"]			= MTLove_SavedVariables["MTLove_Mo_Neutral_Npc"];
	end
	if (MTLove_SavedVariables["MTLove_Mot_Healer_Highlight"]) then
		MTLove_SavedVariables_Cache["Mot_Healer_Highlight"]		= MTLove_SavedVariables["MTLove_Mot_Healer_Highlight"];
	end
	if (MTLove_SavedVariables["MTLove_Mot_Self"]) then
		MTLove_SavedVariables_Cache["Mot_Self"]				= MTLove_SavedVariables["MTLove_Mot_Self"];
	end
	if (MTLove_SavedVariables["MTLove_Mot_OwnPet"]) then
		MTLove_SavedVariables_Cache["Mot_OwnPet"]			= MTLove_SavedVariables["MTLove_Mot_OwnPet"];
	end
	if (MTLove_SavedVariables["MTLove_Mot_Friendly_PartyMember_Player"]) then
		MTLove_SavedVariables_Cache["Mot_Friendly_PartyMember_Player"]	= MTLove_SavedVariables["MTLove_Mot_Friendly_PartyMember_Player"];
	end
	if (MTLove_SavedVariables["MTLove_Mot_Friendly_PartyMember_Pet"]) then
		MTLove_SavedVariables_Cache["Mot_Friendly_PartyMember_Pet"]	= MTLove_SavedVariables["MTLove_Mot_Friendly_PartyMember_Pet"];
	end
	if (MTLove_SavedVariables["MTLove_Mot_Friendly_Player"]) then
		MTLove_SavedVariables_Cache["Mot_Friendly_Player"]		= MTLove_SavedVariables["MTLove_Mot_Friendly_Player"];
	end
	if (MTLove_SavedVariables["MTLove_Mot_Friendly_Pet"]) then
		MTLove_SavedVariables_Cache["Mot_Friendly_Pet"]			= MTLove_SavedVariables["MTLove_Mot_Friendly_Pet"];
	end
	if (MTLove_SavedVariables["MTLove_Mot_Friendly_Npc"]) then
		MTLove_SavedVariables_Cache["Mot_Friendly_Npc"]			= MTLove_SavedVariables["MTLove_Mot_Friendly_Npc"];
	end
	if (MTLove_SavedVariables["MTLove_Mot_Enemy_Player"]) then
		MTLove_SavedVariables_Cache["Mot_Enemy_Player"]			= MTLove_SavedVariables["MTLove_Mot_Enemy_Player"];
	end
	if (MTLove_SavedVariables["MTLove_Mot_Enemy_Pet"]) then
		MTLove_SavedVariables_Cache["Mot_Enemy_Pet"]			= MTLove_SavedVariables["MTLove_Mot_Enemy_Pet"];
	end
	if (MTLove_SavedVariables["MTLove_Mot_Enemy_Npc"]) then
		MTLove_SavedVariables_Cache["Mot_Enemy_Npc"]			= MTLove_SavedVariables["MTLove_Mot_Enemy_Npc"];
	end
	if (MTLove_SavedVariables["MTLove_Mot_Neutral_Npc"]) then
		MTLove_SavedVariables_Cache["Mot_Neutral_Npc"]			= MTLove_SavedVariables["MTLove_Mot_Neutral_Npc"];
	end
	if (MTLove_SavedVariables["MTLove_Mot_Stun"]) then
		MTLove_SavedVariables_Cache["Mot_Stun"]				= MTLove_SavedVariables["MTLove_Mot_Stun"];
	end
	if (MTLove_SavedVariables["MTLove_Mot_Mo_Self"]) then
		MTLove_SavedVariables_Cache["Mot_Mo_Self"]			= MTLove_SavedVariables["MTLove_Mot_Mo_Self"];
	end
	if (MTLove_SavedVariables["MTLove_Mot_Nothing"]) then
		MTLove_SavedVariables_Cache["Mot_Nothing"]			= MTLove_SavedVariables["MTLove_Mot_Nothing"];
	end
	if (MTLove_SavedVariables["MTLove_Count_Tanks"]) then
		MTLove_SavedVariables_Cache["Count_Tanks"]			= MTLove_SavedVariables["MTLove_Count_Tanks"];
	end
	if (MTLove_SavedVariables["MTLove_Count_Plate"]) then
		MTLove_SavedVariables_Cache["Count_Plate"]			= MTLove_SavedVariables["MTLove_Count_Plate"];
	end
	if (MTLove_SavedVariables["MTLove_Count_Mail"]) then
		MTLove_SavedVariables_Cache["Count_Mail"]			= MTLove_SavedVariables["MTLove_Count_Mail"];
	end
	if (MTLove_SavedVariables["MTLove_Count_Leather"]) then
		MTLove_SavedVariables_Cache["Count_Leather"]			= MTLove_SavedVariables["MTLove_Count_Leather"];
	end
	if (MTLove_SavedVariables["MTLove_Count_Pets"]) then
		MTLove_SavedVariables_Cache["Count_Pets"]			= MTLove_SavedVariables["MTLove_Count_Pets"];
	end
	if (MTLove_SavedVariables["MTLove_Experimental_Features"]) then
		MTLove_SavedVariables_Cache["Experimental_Features"]			= MTLove_SavedVariables["MTLove_Experimental_Features"];
	end

	if ((MTLove_SavedVariables["MTLove_Version_Major"] ~= MTLove_globalValues["Version_Major"]) or (MTLove_SavedVariables["MTLove_Version_Minor"] ~= MTLove_globalValues["Version_Minor"]) or (MTLove_SavedVariables["MTLove_Version_SubMinor"] ~= MTLove_globalValues["Version_SubMinor"])) then
		MTLove_UI_PostStatus("garbageclean");
		MTLove_GarbageClean_SavedVariables();
	end
end

function MTLove_reset_to_defaults(special_settings)
	MTLove_SavedVariables_Cache		= MTLove_SavedVariables_General_Defaults;
	if (special_settings == "petHandler") then
		for index, value in pairs(MTLove_SavedVariables_PetHandler_Defaults) do 
			MTLove_SavedVariables_Cache[index]	= value;
		end
	end
	MTLove_GarbageClean_SavedVariables();
end

function MTLove_GarbageClean_SavedVariables()
	MTLove_SavedVariables					= nil;
	MTLove_SavedVariables					= {};
	MTLove_SavedVariables["MTLove_Version_Major"]		= MTLove_globalValues["Version_Major"];
	MTLove_SavedVariables["MTLove_Version_Minor"]		= MTLove_globalValues["Version_Minor"];
	MTLove_SavedVariables["MTLove_Version_SubMinor"]	= MTLove_globalValues["Version_SubMinor"];
	MTLove_SavedVariables["MTLove_Version_PreRelease"]	= MTLove_globalValues["Version_PreRelease"];
	MTLove_Clean_SavedVariable("Frame");
	MTLove_Clean_SavedVariable("Frame_Counter");
	MTLove_Clean_SavedVariable("Frame_Mo_Bar");
	MTLove_Clean_SavedVariable("Frame_Mot_Bar");
	MTLove_Clean_SavedVariable("Frame_Offset_X");
	MTLove_Clean_SavedVariable("Frame_Offset_Y");
	MTLove_Clean_SavedVariable("TT");
	MTLove_Clean_SavedVariable("TT_Counter");
	MTLove_Clean_SavedVariable("TargetCounter");
	MTLove_Clean_SavedVariable("FocusCounter");
	MTLove_Clean_SavedVariable("Self_NotInParty");
	MTLove_Clean_SavedVariable("Mo_OutOfCombat");
	MTLove_Clean_SavedVariable("Mo_Friendly_PartyMember_Player");
	MTLove_Clean_SavedVariable("Mo_Friendly_PartyMember_Pet");
	MTLove_Clean_SavedVariable("Mo_Friendly_Player");
	MTLove_Clean_SavedVariable("Mo_Friendly_Pet");
	MTLove_Clean_SavedVariable("Mo_Friendly_Npc");
	MTLove_Clean_SavedVariable("Mo_Enemy_Player");
	MTLove_Clean_SavedVariable("Mo_Enemy_Pet");
	MTLove_Clean_SavedVariable("Mo_Enemy_Npc");
	MTLove_Clean_SavedVariable("Mo_Neutral_Npc");
	MTLove_Clean_SavedVariable("Mot_Healer_Highlight");
	MTLove_Clean_SavedVariable("Mot_Self");
	MTLove_Clean_SavedVariable("Mot_OwnPet");
	MTLove_Clean_SavedVariable("Mot_Friendly_PartyMember_Player");
	MTLove_Clean_SavedVariable("Mot_Friendly_PartyMember_Pet");
	MTLove_Clean_SavedVariable("Mot_Friendly_Player");
	MTLove_Clean_SavedVariable("Mot_Friendly_Pet");
	MTLove_Clean_SavedVariable("Mot_Friendly_Npc");
	MTLove_Clean_SavedVariable("Mot_Enemy_Player");
	MTLove_Clean_SavedVariable("Mot_Enemy_Pet");
	MTLove_Clean_SavedVariable("Mot_Enemy_Npc");
	MTLove_Clean_SavedVariable("Mot_Neutral_Npc");
	MTLove_Clean_SavedVariable("Mot_Stun");
	MTLove_Clean_SavedVariable("Mot_Mo_Self");
	MTLove_Clean_SavedVariable("Mot_Nothing");
	MTLove_Clean_SavedVariable("Count_Tanks");
	MTLove_Clean_SavedVariable("Count_Plate");
	MTLove_Clean_SavedVariable("Count_Mail");
	MTLove_Clean_SavedVariable("Count_Leather");
	MTLove_Clean_SavedVariable("Count_Pets");
	MTLove_Clean_SavedVariable("Experimental_Features");
end

function MTLove_Clean_SavedVariable(setting)
	MTLove_set_SavedVariables(setting, MTLove_get_SavedVariables(setting));
end

function MTLove_tcount(tab)
	local n = 0;
		for _ in pairs(tab) do
			n = n + 1;
		end
	return n;
end
