--[[	MTLove 2 is a 'small' World Of Warcraft Addon which adds
	a "target of mouseover" function to the client.
	Copyright (C) 2006-2009 Herrmann, Tom
	from Randoom.org

	This file is part of MTLove 2.

	MTLove 2 is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	version 2 as published by the Free Software Foundation.

	MTLove 2 is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.]]

if (MTLove_UI_Localization) then
	if (MTLove_UI_Localization ~= "default") then
		MTLove_set_globalValue_UI_ClientLanguage(MTLove_UI_Localization);
	end
	MTLove_Local();
end

function MTLove_GUI_reset_to_defaults()
	if (MTLove_UnitCanControlPet("player")) then
		--MTLove_UI_Debug("player is petHandler", true);
		MTLove_reset_to_defaults("petHandler");
	else
		--MTLove_UI_Debug("player is petHandler", false);
		MTLove_reset_to_defaults();
	end
	MTLove_UI_playSound(true);
	MTLove_set_GUI_Settings_changed(nil);
	MTLove_GUI_refresh();
	MTLove_activate();
	MTLove_UI_PostStatus("defaults");
end

function MTLove_UI_playSound(set)
	local sound = "igMainMenuOptionCheckBoxOff";
	if (set) then
		sound = "igMainMenuOptionCheckBoxOn";
	end
	PlaySound(sound);
end

function MTLove_UI_PostStatus(id)
	local msg = "";
	if (id == "onload") then
		msg = MTLove_UI_OnLoad;
		if (MTLove_get_globalValues("Version_PreRelease")) then
			msg = msg .. MTLove_UI_Testversion;
			MTLove_GUI_About_Panel_SubText_Text = MTLove_GUI_About_Panel_SubText_Text .. MTLove_UI_Testversion;
		else
			msg = msg .. MTLove_UI_Releaseversion;
			MTLove_GUI_About_Panel_SubText_Text = MTLove_GUI_About_Panel_SubText_Text .. MTLove_UI_Releaseversion;
		end
	elseif (id == "variables_loaded") then
		msg = MTLove_UI_Variables_Loaded;
	elseif (id == "defaults") then
		msg = MTLove_UI_Defaults;
	elseif (id == "garbageclean") then
		msg = MTLove_UI_GarbageClean;
	end
	if (not (msg == nil)) then
		DEFAULT_CHAT_FRAME:AddMessage(msg);
	end

	--MTLove_UI_Debug("msg", msg);
end

function MTLove_UI_Debug(msg0, msg1)
	DEFAULT_CHAT_FRAME:AddMessage(string.sub(tostring(ceil(GetTime() * 1000)), 4, 6) .. " MTLove_UI_Debug: " .. tostring(msg0) .. " == " .. tostring(msg1));
end

function MTLove_GUI_onLoad(frame)
	if (frame == getglobal("MTLove_GUI_General_Options_Panel")) then
		frame.name	= MTLove_GUI_General_Options_Category_Text;
		frame.okay	= function (frame) MTLove_GUI_getChanges(); end;
		frame.cancel	= function (frame) MTLove_set_GUI_Settings_changed(nil); end;
	else
		if(frame == getglobal("MTLove_GUI_Unit_Selection_Panel")) then
			frame.name	= MTLove_GUI_Unit_Selection_Category_Text;
		elseif(frame == getglobal("MTLove_GUI_Counters_Panel")) then
			frame.name	= MTLove_GUI_Counters_Category_Text;
		else
			frame.name	= MTLove_GUI_About_Category_Text;
		end
		frame.parent	= MTLove_GUI_General_Options_Category_Text;
	end
	frame.default	= function (frame) MTLove_GUI_reset_to_defaults(); end;
	InterfaceOptions_AddCategory(frame);
end

function MTLove_GUI_show()
	InterfaceOptionsFrame_OpenToCategory(MTLove_GUI_General_Options_Category_Text);
end

function MTLove_GUI_getChanges()
	if (MTLove_get_GUI_Settings_changed()) then
		MTLove_set_SavedVariables("Frame", MTLove_GUI_BT_Frame:GetChecked());
		MTLove_set_SavedVariables("Frame_Counter", MTLove_GUI_BT_Frame_Counter:GetChecked());
		MTLove_set_SavedVariables("Frame_Mo_Bar", MTLove_GUI_BT_Frame_Mo_Bar:GetChecked());
		MTLove_set_SavedVariables("Frame_Mot_Bar", MTLove_GUI_BT_Frame_Mot_Bar:GetChecked());
		MTLove_set_SavedVariables("Frame_Offset_X", MTLove_GUI_Slider_Frame_Offset_X:GetValue());
		MTLove_set_SavedVariables("Frame_Offset_Y", MTLove_GUI_Slider_Frame_Offset_Y:GetValue());
		MTLove_set_SavedVariables("TT", MTLove_GUI_BT_TT:GetChecked());
		MTLove_set_SavedVariables("TT_Counter", MTLove_GUI_BT_TT_Counter:GetChecked());
		MTLove_set_SavedVariables("TargetCounter", MTLove_GUI_BT_TargetCounter:GetChecked());
		MTLove_set_SavedVariables("FocusCounter", MTLove_GUI_BT_FocusCounter:GetChecked());
		MTLove_set_SavedVariables("Self_NotInParty", MTLove_GUI_BT_Self_NotInParty:GetChecked());
		MTLove_set_SavedVariables("Mo_OutOfCombat", MTLove_GUI_BT_Mo_OutOfCombat:GetChecked());
		MTLove_set_SavedVariables("Mot_Healer_Highlight", MTLove_GUI_BT_Mot_Healer_Highlight:GetChecked());
		MTLove_set_SavedVariables("Count_Tanks", MTLove_GUI_BT_Count_Tanks:GetChecked());
		MTLove_set_SavedVariables("Count_Plate", MTLove_GUI_BT_Count_Plate:GetChecked());
		MTLove_set_SavedVariables("Count_Mail", MTLove_GUI_BT_Count_Mail:GetChecked());
		MTLove_set_SavedVariables("Count_Leather", MTLove_GUI_BT_Count_Leather:GetChecked());
		MTLove_set_SavedVariables("Count_Pets", MTLove_GUI_BT_Count_Pets:GetChecked());
		MTLove_set_SavedVariables("Mo_Friendly_PartyMember_Player", MTLove_GUI_BT_Mo_Friendly_PartyMember_Player:GetChecked());
		MTLove_set_SavedVariables("Mo_Friendly_PartyMember_Pet", MTLove_GUI_BT_Mo_Friendly_PartyMember_Pet:GetChecked());
		MTLove_set_SavedVariables("Mo_Friendly_Player", MTLove_GUI_BT_Mo_Friendly_Player:GetChecked());
		MTLove_set_SavedVariables("Mo_Friendly_Pet", MTLove_GUI_BT_Mo_Friendly_Pet:GetChecked());
		MTLove_set_SavedVariables("Mo_Friendly_Npc", MTLove_GUI_BT_Mo_Friendly_Npc:GetChecked());
		MTLove_set_SavedVariables("Mo_Enemy_Player", MTLove_GUI_BT_Mo_Enemy_Player:GetChecked());
		MTLove_set_SavedVariables("Mo_Enemy_Pet", MTLove_GUI_BT_Mo_Enemy_Pet:GetChecked());
		MTLove_set_SavedVariables("Mo_Enemy_Npc", MTLove_GUI_BT_Mo_Enemy_Npc:GetChecked());
		MTLove_set_SavedVariables("Mo_Neutral_Npc", MTLove_GUI_BT_Mo_Neutral_Npc:GetChecked());
		MTLove_set_SavedVariables("Mot_Self", MTLove_GUI_BT_Mot_Self:GetChecked());
		MTLove_set_SavedVariables("Mot_OwnPet", MTLove_GUI_BT_Mot_OwnPet:GetChecked());
		MTLove_set_SavedVariables("Mot_Friendly_PartyMember_Player", MTLove_GUI_BT_Mot_Friendly_PartyMember_Player:GetChecked());
		MTLove_set_SavedVariables("Mot_Friendly_PartyMember_Pet", MTLove_GUI_BT_Mot_Friendly_PartyMember_Pet:GetChecked());
		MTLove_set_SavedVariables("Mot_Friendly_Player", MTLove_GUI_BT_Mot_Friendly_Player:GetChecked());
		MTLove_set_SavedVariables("Mot_Friendly_Pet", MTLove_GUI_BT_Mot_Friendly_Pet:GetChecked());
		MTLove_set_SavedVariables("Mot_Friendly_Npc", MTLove_GUI_BT_Mot_Friendly_Npc:GetChecked());
		MTLove_set_SavedVariables("Mot_Enemy_Player", MTLove_GUI_BT_Mot_Enemy_Player:GetChecked());
		MTLove_set_SavedVariables("Mot_Enemy_Pet", MTLove_GUI_BT_Mot_Enemy_Pet:GetChecked());
		MTLove_set_SavedVariables("Mot_Enemy_Npc", MTLove_GUI_BT_Mot_Enemy_Npc:GetChecked());
		MTLove_set_SavedVariables("Mot_Neutral_Npc", MTLove_GUI_BT_Mot_Neutral_Npc:GetChecked());
		MTLove_set_SavedVariables("Mot_Stun", MTLove_GUI_BT_MotSpezial_Stun:GetChecked());
		MTLove_set_SavedVariables("Mot_Mo_Self", MTLove_GUI_BT_MotSpezial_Mo_Self:GetChecked());
		MTLove_set_SavedVariables("Mot_Nothing", MTLove_GUI_BT_MotSpezial_Nothing:GetChecked());
		MTLove_set_Stats(MTLove_GUI_BT_About_Stats:GetChecked());
		MTLove_set_SavedVariables("Experimental_Features", MTLove_GUI_BT_About_Experimental:GetChecked());
	end
	MTLove_set_GUI_Settings_changed(nil);
end

function MTLove_GUI_refresh()
	if (not MTLove_get_GUI_Settings_changed()) then
		MTLove_GUI_BT_Frame:SetChecked(MTLove_get_SavedVariables("Frame"));
		MTLove_GUI_BT_Frame_Counter:SetChecked(MTLove_get_SavedVariables("Frame_Counter"));
		MTLove_GUI_BT_Frame_Mo_Bar:SetChecked(MTLove_get_SavedVariables("Frame_Mo_Bar"));
		MTLove_GUI_BT_Frame_Mot_Bar:SetChecked(MTLove_get_SavedVariables("Frame_Mot_Bar"));
		MTLove_GUI_Slider_Frame_Offset_X:SetValue(MTLove_get_SavedVariables("Frame_Offset_X"));
		MTLove_GUI_Slider_Frame_Offset_Y:SetValue(MTLove_get_SavedVariables("Frame_Offset_Y"));
		MTLove_GUI_BT_TT:SetChecked(MTLove_get_SavedVariables("TT"));
		MTLove_GUI_BT_TT_Counter:SetChecked(MTLove_get_SavedVariables("TT_Counter"));
		MTLove_GUI_BT_TargetCounter:SetChecked(MTLove_get_SavedVariables("TargetCounter"));
		MTLove_GUI_BT_FocusCounter:SetChecked(MTLove_get_SavedVariables("FocusCounter"));
		MTLove_GUI_BT_Self_NotInParty:SetChecked(MTLove_get_SavedVariables("Self_NotInParty"));
		MTLove_GUI_BT_Mo_OutOfCombat:SetChecked(MTLove_get_SavedVariables("Mo_OutOfCombat"));
		MTLove_GUI_BT_Mot_Healer_Highlight:SetChecked(MTLove_get_SavedVariables("Mot_Healer_Highlight"));
		MTLove_GUI_BT_Count_Tanks:SetChecked(MTLove_get_SavedVariables("Count_Tanks"));
		MTLove_GUI_BT_Count_Plate:SetChecked(MTLove_get_SavedVariables("Count_Plate"));
		MTLove_GUI_BT_Count_Mail:SetChecked(MTLove_get_SavedVariables("Count_Mail"));
		MTLove_GUI_BT_Count_Leather:SetChecked(MTLove_get_SavedVariables("Count_Leather"));
		MTLove_GUI_BT_Count_Pets:SetChecked(MTLove_get_SavedVariables("Count_Pets"));
		MTLove_GUI_BT_Mo_Friendly_PartyMember_Player:SetChecked(MTLove_get_SavedVariables("Mo_Friendly_PartyMember_Player"));
		MTLove_GUI_BT_Mo_Friendly_PartyMember_Pet:SetChecked(MTLove_get_SavedVariables("Mo_Friendly_PartyMember_Pet"));
		MTLove_GUI_BT_Mo_Friendly_Player:SetChecked(MTLove_get_SavedVariables("Mo_Friendly_Player"));
		MTLove_GUI_BT_Mo_Friendly_Pet:SetChecked(MTLove_get_SavedVariables("Mo_Friendly_Pet"));
		MTLove_GUI_BT_Mo_Friendly_Npc:SetChecked(MTLove_get_SavedVariables("Mo_Friendly_Npc"));
		MTLove_GUI_BT_Mo_Enemy_Player:SetChecked(MTLove_get_SavedVariables("Mo_Enemy_Player"));
		MTLove_GUI_BT_Mo_Enemy_Pet:SetChecked(MTLove_get_SavedVariables("Mo_Enemy_Pet"));
		MTLove_GUI_BT_Mo_Enemy_Npc:SetChecked(MTLove_get_SavedVariables("Mo_Enemy_Npc"));
		MTLove_GUI_BT_Mo_Neutral_Npc:SetChecked(MTLove_get_SavedVariables("Mo_Neutral_Npc"));
		MTLove_GUI_BT_Mot_Self:SetChecked(MTLove_get_SavedVariables("Mot_Self"));
		MTLove_GUI_BT_Mot_OwnPet:SetChecked(MTLove_get_SavedVariables("Mot_OwnPet"));
		MTLove_GUI_BT_Mot_Friendly_PartyMember_Player:SetChecked(MTLove_get_SavedVariables("Mot_Friendly_PartyMember_Player"));
		MTLove_GUI_BT_Mot_Friendly_PartyMember_Pet:SetChecked(MTLove_get_SavedVariables("Mot_Friendly_PartyMember_Pet"));
		MTLove_GUI_BT_Mot_Friendly_Player:SetChecked(MTLove_get_SavedVariables("Mot_Friendly_Player"));
		MTLove_GUI_BT_Mot_Friendly_Pet:SetChecked(MTLove_get_SavedVariables("Mot_Friendly_Pet"));
		MTLove_GUI_BT_Mot_Friendly_Npc:SetChecked(MTLove_get_SavedVariables("Mot_Friendly_Npc"));
		MTLove_GUI_BT_Mot_Enemy_Player:SetChecked(MTLove_get_SavedVariables("Mot_Enemy_Player"));
		MTLove_GUI_BT_Mot_Enemy_Pet:SetChecked(MTLove_get_SavedVariables("Mot_Enemy_Pet"));
		MTLove_GUI_BT_Mot_Enemy_Npc:SetChecked(MTLove_get_SavedVariables("Mot_Enemy_Npc"));
		MTLove_GUI_BT_Mot_Neutral_Npc:SetChecked(MTLove_get_SavedVariables("Mot_Neutral_Npc"));
		MTLove_GUI_BT_MotSpezial_Stun:SetChecked(MTLove_get_SavedVariables("Mot_Stun"));
		MTLove_GUI_BT_MotSpezial_Mo_Self:SetChecked(MTLove_get_SavedVariables("Mot_Mo_Self"));
		MTLove_GUI_BT_MotSpezial_Nothing:SetChecked(MTLove_get_SavedVariables("Mot_Nothing"));
		MTLove_GUI_BT_About_Stats:SetChecked(MTLove_get_Stats());
		MTLove_GUI_BT_About_Experimental:SetChecked(MTLove_get_SavedVariables("Experimental_Features"));
	end
	if (MTLove_GUI_BT_Frame:GetChecked()) then
		MTLove_GUI_BT_Frame_Counter:Enable();
		MTLove_GUI_BT_Frame_Mo_Bar:Enable();
		MTLove_GUI_BT_Frame_Mot_Bar:Enable();
		MTLove_GUI_BT_Offset_Reset:Enable();
	else
		MTLove_GUI_BT_Frame_Counter:Disable();
		MTLove_GUI_BT_Frame_Mo_Bar:Disable();
		MTLove_GUI_BT_Frame_Mot_Bar:Disable();
		MTLove_GUI_BT_Offset_Reset:Disable();
	end
	if (MTLove_GUI_BT_TT:GetChecked()) then
		MTLove_GUI_BT_TT_Counter:Enable();
	else
		MTLove_GUI_BT_TT_Counter:Disable();
	end
	if ((MTLove_GUI_BT_Frame:GetChecked() and MTLove_GUI_BT_Frame_Counter:GetChecked()) or (MTLove_GUI_BT_TT:GetChecked() and MTLove_GUI_BT_TT_Counter:GetChecked()) or MTLove_GUI_BT_TargetCounter:GetChecked() or MTLove_GUI_BT_FocusCounter:GetChecked()) then
		MTLove_GUI_BT_Count_Tanks:Enable();
		MTLove_GUI_BT_Count_Plate:Enable();
		MTLove_GUI_BT_Count_Mail:Enable();
		MTLove_GUI_BT_Count_Leather:Enable();
		MTLove_GUI_BT_Count_Pets:Enable();
	else
		MTLove_GUI_BT_Count_Tanks:Disable();
		MTLove_GUI_BT_Count_Plate:Disable();
		MTLove_GUI_BT_Count_Mail:Disable();
		MTLove_GUI_BT_Count_Leather:Disable();
		MTLove_GUI_BT_Count_Pets:Disable();
	end
	if (MTLove_get_globalValues("Version_PreRelease")) then
		MTLove_GUI_BT_About_Stats:Show();
		MTLove_GUI_FS_About_StatsPerformance:Show();
		MTLove_GUI_FS_About_Stats_Cpu:Show();
		MTLove_GUI_FS_About_Stats_Mem:Show();
	else
		MTLove_GUI_BT_About_Stats:Hide();
		MTLove_GUI_FS_About_StatsPerformance:Hide();
		MTLove_GUI_FS_About_Stats_Cpu:Hide();
		MTLove_GUI_FS_About_Stats_Mem:Hide();
	end
	if (MTLove_GUI_BT_About_Stats:GetChecked()) then
		MTLove_GUI_FS_About_Stats_Cpu:SetText(MTLove_GUI_FS_About_Stats_Cpu_Text .. " " .. MTLove_get_Stats_CPU_Usage());
		MTLove_GUI_FS_About_Stats_Mem:SetText(MTLove_GUI_FS_About_Stats_Mem_Text .. " " .. MTLove_get_Stats_Memory_Usage());
	else
		MTLove_GUI_FS_About_Stats_Cpu:SetText(MTLove_GUI_FS_About_Stats_Cpu_Text .. " " .. MTLove_GUI_Disabled);
		MTLove_GUI_FS_About_Stats_Mem:SetText(MTLove_GUI_FS_About_Stats_Mem_Text .. " " .. MTLove_GUI_Disabled);
	end
end
