--[[	MTLove 2 is a 'small' World Of Warcraft Addon which adds
	a "target of mouseover" function to the client.
	Copyright (C) 2006-2009 Herrmann, Tom
	from Randoom.org

	This file is part of MTLove 2.

	MTLove 2 is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	version 2 as published by the Free Software Foundation.

	MTLove 2 is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.]]

local UpdateInterval		= 0.1;
local do_stats_at_count		= 25;
local Frames_On			= nil;
local TargetCounter_On		= nil;
local FocusCounter_On		= nil;
local DefaultTT			= "GameTooltip";
local AddToWidth		= 20 / UIParent:GetScale();
local MinWidth			= 80 / UIParent:GetScale();
local color_tanks		= "|cFFFFFFFF";
local color_plate		= "|cFF00FF00";
local color_mail		= "|cFFFFFF00";
local color_leather		= "|cFFFF6600";
local color_cloth		= "|cFFFF0000";
local color_pet			= "|cFF9900FF";
local color_npc			= color_pet;
local color_stun		= "|cFF999999";
local color_mo_self		= color_stun;
local color_nothing		= color_stun;
local end_color			= "|r";
local stats_data		= {};

-- local alias' for MTLove's global functions
local get_SavedVariables	= MTLove_get_SavedVariables;
local get_Stats			= MTLove_get_Stats;

-- local alias' for MTLove's global 'variables'
local EventHandler;
local TargetCounter_Counter;
local TargetCounter_Counter_Line0;
local FocusCounter_Counter;
local FocusCounter_Counter_Line0;
local Frame;
local Frame_Line0;
local Frame_Counter;
local Frame_Counter_Line0;
local Frame_StatusBar0;
local Frame_StatusBar1;
local TT_Frame;
local TT_Frame_Line0;
local TT_Frame_Line1;
local TT_Frame_Counter;
local TT_Frame_Counter_Line0;
local TT_Frame_StatusBar;

-- local alias' for global functions
local alias_UnitExists			= UnitExists;
local alias_UnitIsDeadOrGhost		= UnitIsDeadOrGhost;
local alias_UnitIsUnit			= UnitIsUnit;
local alias_UnitClass			= UnitClass;
local alias_UnitLevel			= UnitLevel;
local alias_UnitHealth			= UnitHealth;
local alias_UnitHealthMax		= UnitHealthMax;
local alias_UnitCreatureType		= UnitCreatureType;
local alias_UnitClassification		= UnitClassification;
local alias_UnitName			= UnitName;
local alias_UnitBuff			= UnitBuff;
local alias_UnitIsFriend		= UnitIsFriend;
local alias_UnitIsEnemy			= UnitIsEnemy;
local alias_UnitIsPlayer		= UnitIsPlayer;
local alias_UnitPlayerOrPetInParty	= UnitPlayerOrPetInParty;
local alias_UnitPlayerOrPetInRaid	= UnitPlayerOrPetInRaid;
local alias_UnitPlayerControlled	= UnitPlayerControlled;
local alias_UnitAffectingCombat		= UnitAffectingCombat;
local alias_UnitIsTapped		= UnitIsTapped;
local alias_GetNumPartyMembers		= GetNumPartyMembers;
local alias_GetNumRaidMembers		= GetNumRaidMembers;
local alias_GetPartyAssignment		= GetPartyAssignment;

-- local functions to acquire other addons MT-Lists
local getORA2Tanks			= function() return false end;
local getCTRATanks			= function() return false end;

-- local alias' for global 'variables'
local mo				= "mouseover";
local mot				= "mouseovertarget";

function MTLove_OnLoad()
	MTLove_EventHandler:RegisterEvent("VARIABLES_LOADED");
	MTLove_EventHandler:RegisterEvent("PLAYER_TARGET_CHANGED");
	MTLove_EventHandler:RegisterEvent("PLAYER_FOCUS_CHANGED");
	MTLove_EventHandler:RegisterEvent("UPDATE_MOUSEOVER_UNIT");
	SLASH_MTLove1 = "/mtlove";
	SlashCmdList["MTLove"] = MTLove_GUI_show;
	MTLove_UI_PostStatus("onload");
end

function MTLove_OnEvent(event, self)
	if ((event == "UPDATE_MOUSEOVER_UNIT") or (event == "PLAYER_TARGET_CHANGED") or (event == "PLAYER_FOCUS_CHANGED")) then
		MTLove_activate();
		self.TimeSinceLastUpdate	= UpdateInterval;
	elseif (event == "VARIABLES_LOADED") then
		EventHandler			= MTLove_EventHandler;
		TargetCounter_Counter		= MTLove_TargetCounter_Counter;
		TargetCounter_Counter_Line0	= MTLove_TargetCounter_Counter_Line0;
		FocusCounter_Counter		= MTLove_FocusCounter_Counter;
		FocusCounter_Counter_Line0	= MTLove_FocusCounter_Counter_Line0;
		Frame				= MTLove_Frame;
		Frame_Line0			= MTLove_Frame_Line0;
		Frame_Counter			= MTLove_Frame_Counter;
		Frame_Counter_Line0		= MTLove_Frame_Counter_Line0;
		Frame_StatusBar0		= MTLove_Frame_StatusBar0;
		Frame_StatusBar1		= MTLove_Frame_StatusBar1;
		TT_Frame			= MTLove_TT_Frame;
		TT_Frame_Line0			= MTLove_TT_Frame_Line0;
		TT_Frame_Line1			= MTLove_TT_Frame_Line1;
		TT_Frame_Counter		= MTLove_TT_Frame_Counter;
		TT_Frame_Counter_Line0		= MTLove_TT_Frame_Counter_Line0;
		TT_Frame_StatusBar		= MTLove_TT_Frame_StatusBar;
		-- check for optional addon
		if (IsAddOnLoaded("TipBuddy")) then
			DefaultTT = "TipBuddyTooltip";
		end
		if (IsAddOnLoaded("oRA2")) then
			getORA2Tanks	= function() return oRA.maintanktable end;
		end
		if (IsAddOnLoaded("CT_RaidAssist")) then
			getCTRATanks	= function() return CT_RATarget.MainTanks end;
		end
		MTLove_Stats_Reset();
		MTLove_loadVariables();
		MTLove_activate();
		EventHandler:UnregisterEvent("VARIABLES_LOADED");
		MTLove_UI_PostStatus("variables_loaded");
	end
end

function MTLove_activate()
	TargetCounter_On		= nil;
	FocusCounter_On			= nil;
	Frames_On			= nil;
	if (alias_UnitExists(mo) and (not alias_UnitIsDeadOrGhost(mo)) and get_SavedVariables("Frame")) then
		Frame:Show();
		Frame:SetBackdropBorderColor(1, 1, 1);
		Frame:SetBackdropColor(0.09, 0.09, 0.19);
		Frame_Counter:SetBackdropBorderColor(1, 1, 1);
		Frame_Counter:SetBackdropColor(0.09, 0.09, 0.19);
		if (get_SavedVariables("Frame_Counter")) then
			Frame_Counter:Show();
		else
			Frame_Counter:Hide();
		end
		if (get_SavedVariables("Frame_Mo_Bar")) then
			Frame_StatusBar0:Show();
		else
			Frame_StatusBar0:Hide();
		end
		if (get_SavedVariables("Frame_Mot_Bar")) then
			Frame_StatusBar1:Show();
		else
			Frame_StatusBar1:Hide();
		end
		Frame:SetAlpha(0);
		Frame_Counter:SetAlpha(0);
		Frames_On = true;
	else
		Frame:Hide();
	end
	if (alias_UnitExists(mo) and (not alias_UnitIsDeadOrGhost(mo)) and get_SavedVariables("TT")) then
		TT_Frame:Show();
		TT_Frame:SetBackdropBorderColor(1, 1, 1);
		TT_Frame:SetBackdropColor(0.09, 0.09, 0.19);
		TT_Frame:SetPoint("BOTTOMRIGHT", DefaultTT, "BOTTOMLEFT");
		TT_Frame:SetAlpha(0);
		TT_Frame_Counter:SetBackdropBorderColor(1, 1, 1);
		TT_Frame_Counter:SetBackdropColor(0.09, 0.09, 0.19);
		TT_Frame_Counter:SetPoint("BOTTOMLEFT", DefaultTT, "TOPLEFT");
		TT_Frame_Counter:SetAlpha(0);
		if (get_SavedVariables("TT_Counter")) then
			TT_Frame_Counter:Show();
		else
			TT_Frame_Counter:Hide();
		end
		Frames_On = true;
	else
		TT_Frame:Hide();
		TT_Frame_Counter:Hide();
	end
	if (TargetFrame:IsShown() and alias_UnitExists("target") and (not alias_UnitIsDeadOrGhost("target")) and get_SavedVariables("TargetCounter")) then
		TargetCounter_Counter:Show();
		TargetCounter_Counter:SetBackdropBorderColor(1, 1, 1);
		TargetCounter_Counter:SetBackdropColor(0.09, 0.09, 0.19);
		
		TargetCounter_On = true;
	else
		TargetCounter_Counter:Hide();
	end
	if (FocusFrame:IsShown() and alias_UnitExists("focus") and (not alias_UnitIsDeadOrGhost("focus")) and get_SavedVariables("FocusCounter")) then		
		FocusCounter_Counter:Show();
		FocusCounter_Counter:SetBackdropBorderColor(1, 1, 1);
		FocusCounter_Counter:SetBackdropColor(0.09, 0.09, 0.19);
		
		FocusCounter_On = true;
	else
		FocusCounter_Counter:Hide();
	end
	if (Frames_On or TargetCounter_On or FocusCounter_On) then
		EventHandler:Show();
		--MTLove_UI_Debug("EvHandler", "show");
	else
		EventHandler:Hide();
		--MTLove_UI_Debug("EvHandler", "hide");
	end
	MTLove_Update_Memory_Usage();
end

function MTLove_OnUpdate(self, elapsed)
	self.TimeSinceLastUpdate	= self.TimeSinceLastUpdate + elapsed;
	if (self.TimeSinceLastUpdate > UpdateInterval) then
		MTLove_Reset_CPU_Usage();
		
		--MTLove_UI_Debug("TargetCounter_On", TargetCounter_On);
		--MTLove_UI_Debug("Frames_On", Frames_On);

		local Self_GroupMode					= nil;
		local Self_GroupMembers					= 0;
		if (alias_GetNumPartyMembers() > 0) then
			if (alias_GetNumRaidMembers() > 0) then
				Self_GroupMode				= "raid";
				Self_GroupMembers			= alias_GetNumRaidMembers();
			else
				Self_GroupMode				= "party";
				Self_GroupMembers			= alias_GetNumPartyMembers();
			end
		end

		--MTLove_UI_Debug("Self_GroupMode", Self_GroupMode);
		--MTLove_UI_Debug("Self_GroupMembers", Self_GroupMembers);
		
		MTLove_OnUpdate_Frames(Self_GroupMode, Self_GroupMembers);
		
		if (TargetCounter_On) then
			MTLove_OnUpdate_TargetCounter(Self_GroupMode, Self_GroupMembers);
		end
		if (FocusCounter_On) then
			MTLove_OnUpdate_FocusCounter(Self_GroupMode, Self_GroupMembers);
		end
		
		MTLove_Update_Memory_Usage();
		MTLove_Update_CPU_Usage();
		self.TimeSinceLastUpdate	= 0;
	else
		MTLove_arrangeFrame();
	end
	-- no event is fired when the mouseover is dead or does not exsist... fix for that
	if ((not alias_UnitExists(mo) or alias_UnitIsDeadOrGhost(mo)) and (not alias_UnitExists("target") or alias_UnitIsDeadOrGhost("target")) and (not alias_UnitExists("focus") or alias_UnitIsDeadOrGhost("focus"))) then
		MTLove_activate();
	end
end

function MTLove_OnUpdate_Frames(Self_GroupMode, Self_GroupMembers)
	if (Frames_On) then
		local mo_Unit_NotDead				= (not alias_UnitIsDeadOrGhost(mo)) and alias_UnitExists(mo);
		local Self_PartyOk				= Self_GroupMode or get_SavedVariables("Self_NotInParty");
		local mo_Unit_AffectedOk			= alias_UnitAffectingCombat(mo) or get_SavedVariables("Mo_OutOfCombat");

		--MTLove_UI_Debug("mo_Unit_NotDead", mo_Unit_NotDead);
		--MTLove_UI_Debug("Self_PartyOk", Self_PartyOk);
		--MTLove_UI_Debug("mo_Unit_AffectedOk", mo_Unit_AffectedOk);

		if (mo_Unit_NotDead and Self_PartyOk and mo_Unit_AffectedOk) then
			local mot_Unit_NotDead		= (not alias_UnitIsDeadOrGhost(mot)) and alias_UnitExists(mot);
			local mot_Unit_Stun		= (not alias_UnitExists(mot)) and alias_UnitAffectingCombat(mo) and alias_UnitIsTapped(mo);
			local mot_Unit_Mo_Self		= alias_UnitIsUnit(mo, mot);
			local mot_Unit_Nothing		= (not mot_Unit_Stun) and (not alias_UnitExists(mot));

			local mo_Unit_Self		= alias_UnitIsUnit(mo, "player");
			local mo_Unit_OwnPet		= alias_UnitIsUnit(mo, "pet");
			local mo_Unit_Friend		= alias_UnitIsFriend(mo, "player");
			local mo_Unit_Enemy		= alias_UnitIsEnemy(mo, "player");
			local mo_Unit_PartyMember	= alias_UnitPlayerOrPetInParty(mo) or alias_UnitPlayerOrPetInRaid(mo);
			local mo_Unit_Player		= alias_UnitIsPlayer(mo);
			local mo_Unit_Pet		= alias_UnitPlayerControlled(mo);

			local mo_Type			= nil;
			local mo_Type_cleaned		= nil;

			if (mo_Unit_Self) then
				mo_Type = "self";
			elseif (mo_Unit_OwnPet) then
				mo_Type = "ownpet";
			else
				if (mo_Unit_Friend) then
					mo_Type = "friendly_";
					if (mo_Unit_PartyMember) then
						mo_Type = mo_Type .. "partymember_";
					end
				elseif (mo_Unit_Enemy) then
					mo_Type = "enemy_";
				else
					mo_Type = "neutral_";
				end
				if (mo_Unit_Player) then
					mo_Type = mo_Type .. "player";
				elseif (mo_Unit_Pet) then
					mo_Type = mo_Type .. "pet";
				else
					mo_Type = mo_Type .. "npc";
				end
			end

			if ((mo_Type == "self")					and false) then
				-- you never really want that, therefore no setting -> false
				mo_Type_cleaned = mo_Type;
			elseif ((mo_Type == "ownpet")				and false) then
				-- you never really want that, therefore no setting -> false
				mo_Type_cleaned = mo_Type;
			elseif ((mo_Type == "friendly_partymember_player")	and get_SavedVariables("Mo_Friendly_PartyMember_Player")) then
				mo_Type_cleaned = mo_Type;
			elseif ((mo_Type == "friendly_partymember_pet")		and get_SavedVariables("Mo_Friendly_PartyMember_Pet")) then
				mo_Type_cleaned = mo_Type;
			elseif ((mo_Type == "friendly_player")			and get_SavedVariables("Mo_Friendly_Player")) then
				mo_Type_cleaned = mo_Type;
			elseif ((mo_Type == "friendly_pet")			and get_SavedVariables("Mo_Friendly_Pet")) then
				mo_Type_cleaned = mo_Type;
			elseif ((mo_Type == "friendly_npc")			and get_SavedVariables("Mo_Friendly_Npc")) then
				mo_Type_cleaned = mo_Type;
			elseif ((mo_Type == "enemy_player")			and get_SavedVariables("Mo_Enemy_Player")) then
				mo_Type_cleaned = mo_Type;
			elseif ((mo_Type == "enemy_pet")			and get_SavedVariables("Mo_Enemy_Pet")) then
				mo_Type_cleaned = mo_Type;
			elseif ((mo_Type == "enemy_npc")			and get_SavedVariables("Mo_Enemy_Npc")) then
				mo_Type_cleaned = mo_Type;
			elseif ((mo_Type == "neutral_player")			and false) then
				-- impossible, therefore no setting -> false
				mo_Type_cleaned = mo_Type;
			elseif ((mo_Type == "neutral_pet")			and false) then
				-- impossible, therefore no setting -> false
				mo_Type_cleaned = mo_Type;
			elseif ((mo_Type == "neutral_npc")			and get_SavedVariables("Mo_Neutral_Npc")) then
				mo_Type_cleaned = mo_Type;
			end

			--MTLove_UI_Debug("mot_Unit_NotDead", mot_Unit_NotDead);
			--MTLove_UI_Debug("mot_Unit_Stun", mot_Unit_Stun);
			--MTLove_UI_Debug("mo_Type", mo_Type);
			--MTLove_UI_Debug("mo_Type_cleaned", mo_Type_cleaned);

			if ((mot_Unit_NotDead or mot_Unit_Stun or mot_Unit_Mo_Self or mot_Unit_Nothing) and mo_Type_cleaned) then
				local mot_Name			= alias_UnitName(mot);
				local mot_Unit_Self		= alias_UnitIsUnit(mot, "player");
				local mot_Unit_OwnPet		= alias_UnitIsUnit(mot, "pet");
				local mot_Unit_Friend		= alias_UnitIsFriend(mot, "player");
				local mot_Unit_Enemy		= alias_UnitIsEnemy(mot, "player");
				local mot_Unit_PartyMember	= alias_UnitPlayerOrPetInParty(mot) or alias_UnitPlayerOrPetInRaid(mot);
				local mot_Unit_Player		= alias_UnitIsPlayer(mot);
				local mot_Unit_Pet		= alias_UnitPlayerControlled(mot);

				local mot_Type			= nil;
				local mot_Type_cleaned		= nil;

				if (mot_Unit_Stun) then
					mot_Type = "stun";
				elseif (mot_Unit_Mo_Self) then
					mot_Type = "mo";
				elseif (mot_Unit_Nothing) then
					mot_Type = "nothing";
				else
					if (mot_Unit_Self) then
						mot_Type = "self";
					elseif (mot_Unit_OwnPet) then
						mot_Type = "ownpet";
					else
						if (mot_Unit_Friend) then
							mot_Type = "friendly_";
							if (mot_Unit_PartyMember) then
								mot_Type = mot_Type .. "partymember_";
							end
						elseif (mot_Unit_Enemy) then
							mot_Type = "enemy_";
						else
							mot_Type = "neutral_";
						end
						if (mot_Unit_Player) then
							mot_Type = mot_Type .. "player";
						elseif (mot_Unit_Pet) then
							mot_Type = mot_Type .. "pet";
						else
							mot_Type = mot_Type .. "npc";
						end
					end
				end

				if ((mot_Type == "stun")				and get_SavedVariables("Mot_Stun")) then
					mot_Type_cleaned = mot_Type;
				elseif ((mot_Type == "mo")				and get_SavedVariables("Mot_Mo_Self")) then
					mot_Type_cleaned = mot_Type;
				elseif ((mot_Type == "nothing")				and get_SavedVariables("Mot_Nothing")) then
					mot_Type_cleaned = mot_Type;
				elseif ((mot_Type == "self")				and get_SavedVariables("Mot_Self")) then
					mot_Type_cleaned = mot_Type;
				elseif ((mot_Type == "ownpet")				and get_SavedVariables("Mot_OwnPet")) then
					mot_Type_cleaned = mot_Type;
				elseif ((mot_Type == "friendly_partymember_player")	and get_SavedVariables("Mot_Friendly_PartyMember_Player")) then
					mot_Type_cleaned = mot_Type;
				elseif ((mot_Type == "friendly_partymember_pet")	and get_SavedVariables("Mot_Friendly_PartyMember_Pet")) then
					mot_Type_cleaned = mot_Type;
				elseif ((mot_Type == "friendly_player")			and get_SavedVariables("Mot_Friendly_Player")) then
					mot_Type_cleaned = mot_Type;
				elseif ((mot_Type == "friendly_pet")			and get_SavedVariables("Mot_Friendly_Pet")) then
					mot_Type_cleaned = mot_Type;
				elseif ((mot_Type == "friendly_npc")			and get_SavedVariables("Mot_Friendly_Npc")) then
					mot_Type_cleaned = mot_Type;
				elseif ((mot_Type == "enemy_player")			and get_SavedVariables("Mot_Enemy_Player")) then
					mot_Type_cleaned = mot_Type;
				elseif ((mot_Type == "enemy_pet")			and get_SavedVariables("Mot_Enemy_Pet")) then
					mot_Type_cleaned = mot_Type;
				elseif ((mot_Type == "enemy_npc")			and get_SavedVariables("Mot_Enemy_Npc")) then
					mot_Type_cleaned = mot_Type;
				elseif ((mot_Type == "neutral_player")			and false) then
					-- impossible, therefore no setting -> false
					mot_Type_cleaned = mot_Type;
				elseif ((mot_Type == "neutral_pet")			and false) then
					-- impossible, therefore no setting -> false
					mot_Type_cleaned = mot_Type;
				elseif ((mot_Type == "neutral_npc")			and get_SavedVariables("Mot_Neutral_Npc")) then
					mot_Type_cleaned = mot_Type;
				end

				--MTLove_UI_Debug("mot_Type", mot_Type);
				--MTLove_UI_Debug("mot_Type_cleaned", mot_Type_cleaned);

				if (mot_Type_cleaned) then
					local use_count				= get_SavedVariables("Frame_Counter") or get_SavedVariables("TT_Counter");
					
					local mot_Merge_Player			= (mot_Type == "self") or (mot_Type == "friendly_partymember_player") or (mot_Type == "friendly_player") or (mot_Type == "enemy_player") or (mot_Type == "neutral_player");
					local mot_Merge_Pet			= (mot_Type == "ownpet") or (mot_Type == "friendly_partymember_pet") or (mot_Type == "friendly_pet") or (mot_Type == "enemy_pet") or (mot_Type == "neutral_pet");
					local mot_Merge_Npc			= (mot_Type == "friendly_npc") or (mot_Type == "enemy_npc") or (mot_Type == "neutral_npc");
					local mot_IsTank			= (mot_Merge_Player and MTLove_UnitIsTank(mot, mot_Unit_PartyMember));
					local mot_IsHealer			= (mot_Merge_Player and MTLove_UnitIsHealer(mot, mot_Unit_PartyMember));
					local mot_WearesPlate			= (mot_Merge_Player and MTLove_UnitWearesPlate(mot));
					local mot_WearesMail			= (mot_Merge_Player and MTLove_UnitWearesMail(mot));
					local mot_WearesLeather			= (mot_Merge_Player and MTLove_UnitWearesLeather(mot));
					local count_result			= "";
					local width				= 0;
					local msg				= nil;

					if (mot_Type == "stun") then
						msg = color_stun;
					elseif (mot_Type == "mo") then
						msg = color_mo_self;
					elseif (mot_Type == "nothing") then
						msg = color_nothing;
					elseif (mot_Merge_Player) then
						if (mot_IsTank) then
							msg = color_tanks;
						elseif (mot_WearesPlate) then
							msg = color_plate;
						elseif (mot_WearesMail) then
							msg = color_mail;
						elseif (mot_WearesLeather) then
							msg = color_leather;
						else
							msg = color_cloth;
						end
					elseif (mot_Merge_Pet) then
						msg = color_pet;
					elseif (mot_Merge_Npc) then
						msg = color_npc;
					end
					if (mot_IsHealer and get_SavedVariables("Mot_Healer_Highlight")) then
						msg = msg .. "> " .. mot_Name .. " <" ..end_color;
					elseif (mot_Type == "stun") then
						msg = msg .. MTLove_UI_FearStun .. end_color;
					elseif (mot_Type == "mo") then
						msg = msg .. MTLove_UI_Mot_Mo_Self .. end_color;
					elseif (mot_Type == "nothing") then
						msg = msg .. MTLove_UI_Mot_Nothing .. end_color;
					else
						msg = msg .. mot_Name .. end_color;
					end

					--MTLove_UI_Debug("msg_L0", msg);

					if (use_count) then
						count_result = MTLove_Count_Units_Targeting_Unit(Self_GroupMode, Self_GroupMembers, mo);
					end

					--MTLove_UI_Debug("count_result", count_result);

					if (get_SavedVariables("Frame")) then
						Frame_Line0:SetText(msg);
						width = Frame_Line0:GetStringWidth();
						if (width < MinWidth) then
							width = MinWidth;
						end
						Frame:SetWidth(width + AddToWidth);
						if (get_SavedVariables("Frame_Mo_Bar")) then
							Frame_StatusBar0:SetMinMaxValues(0, alias_UnitHealthMax(mo));
							Frame_StatusBar0:SetValue(alias_UnitHealth(mo));
						end
						if (get_SavedVariables("Frame_Mot_Bar")) then
							Frame_StatusBar1:SetMinMaxValues(0, alias_UnitHealthMax(mot));
							Frame_StatusBar1:SetValue(alias_UnitHealth(mot));
						end
						Frame:SetAlpha(255);
						MTLove_arrangeFrame();
						if (use_count and Self_GroupMode) then
							Frame_Counter_Line0:SetText(count_result);
							width = Frame_Counter_Line0:GetStringWidth();
							Frame_Counter:SetWidth(width + AddToWidth);
							Frame_Counter:SetAlpha(255);
						else
							Frame_Counter:SetAlpha(0);
						end
					end
					if (get_SavedVariables("TT")) then
						local mot_ClassLoc	= alias_UnitClass(mot);
						local mot_Level		= alias_UnitLevel(mot);
						local mot_CreatureType	= alias_UnitCreatureType(mot);
						local mot_Plus		= alias_UnitClassification(mot);
						local width2		= 0;

						TT_Frame_Line0:SetText(msg);
						if ((mot_Type == "stun") or (mot_Type == "mo") or (mot_Type == "nothing")) then
							msg = "";
						elseif (mot_Level > 0) then
							msg = MTLove_UI_Level .. " " .. mot_Level;
							if (mot_Plus and (mot_Plus ~= "normal")) then
								msg = msg .. "+ ";
							else
								msg = msg .. " ";
							end
							if (mot_Merge_Player) then
								if (mot_Type == "self") then
									msg = msg .. mot_ClassLoc .. " (" .. MTLove_UI_Self .. ")";
								else
									msg = msg .. mot_ClassLoc .. " (" .. MTLove_UI_Player .. ")";
								end
							else
								if (mot_Merge_Pet) then
									if (mot_Type == "ownpet") then
										mot_CreatureType = MTLove_UI_OwnPet;
									else
										mot_CreatureType = MTLove_UI_Pet;
									end
								elseif (mot_Merge_Npc) then
									mot_CreatureType = MTLove_UI_NPC;
								end
								msg = msg .. mot_CreatureType;
							end
						else
							if (not mot_CreatureType) then
								mot_CreatureType = "?!?";
							end
							if (mot_Plus == "worldboss") then
								msg = MTLove_UI_Boss .. mot_CreatureType;
							else
								msg = "?!? " .. mot_CreatureType;
							end
						end

						--MTLove_UI_Debug("msg_TT_L1", msg);

						TT_Frame_Line1:SetText(msg);
						width = TT_Frame_Line0:GetWidth();
						width2 = TT_Frame_Line1:GetWidth();
						if (width2 > width) then
							width = width2;
						end
						if (width < MinWidth) then
							width = MinWidth;
						end
						TT_Frame:SetWidth(width + AddToWidth);
						TT_Frame_StatusBar:SetMinMaxValues(0, alias_UnitHealthMax(mot));
						TT_Frame_StatusBar:SetValue(alias_UnitHealth(mot));
						if (msg == "") then
							TT_Frame:SetHeight(35);
						else
							TT_Frame:SetHeight(48);
						end
						TT_Frame:SetAlpha(255);
						if (use_count and Self_GroupMode) then
							TT_Frame_Counter_Line0:SetText(count_result);
							width = TT_Frame_Counter_Line0:GetStringWidth();
							TT_Frame_Counter:SetWidth(width + AddToWidth);
							TT_Frame_Counter:SetAlpha(255);
						else
							TT_Frame_Counter:SetAlpha(0);
						end
					end
					return;
				end
			end
		end
	end
	Frame:SetAlpha(0);
	TT_Frame:SetAlpha(0);
	TT_Frame_Counter:SetAlpha(0);
end

function MTLove_OnUpdate_TargetCounter(Self_GroupMode, Self_GroupMembers)
	local width					= nil;
	if (Self_GroupMode) then
		local count_tot_result			= MTLove_Count_Units_Targeting_Unit(Self_GroupMode, Self_GroupMembers, "target");

		--MTLove_UI_Debug("count_tot_result", count_tot_result);

		TargetCounter_Counter_Line0:SetText(count_tot_result);
		width = TargetCounter_Counter_Line0:GetStringWidth();
		TargetCounter_Counter:SetWidth(width + AddToWidth);
		TargetCounter_Counter:SetAlpha(255);
		if (TargetFrameNumericalThreat:IsShown()) then
			TargetCounter_Counter:ClearAllPoints();
			TargetCounter_Counter:SetPoint("RIGHT", "TargetFrameNumericalThreat", "LEFT", 5, 2);
		else
			TargetCounter_Counter:ClearAllPoints();
			TargetCounter_Counter:SetPoint("BOTTOM", "TargetFrame", "TOP", -50, -22);
		end
	else
		TargetCounter_Counter:SetAlpha(0);
	end
end

function MTLove_OnUpdate_FocusCounter(Self_GroupMode, Self_GroupMembers)
	if (FocusCounter_On) then
		local width					= nil;
		if (Self_GroupMode) then
			local count_tof_result			= MTLove_Count_Units_Targeting_Unit(Self_GroupMode, Self_GroupMembers, "focus");

			--MTLove_UI_Debug("count_tof_result", count_tof_result);
			
			FocusCounter_Counter_Line0:SetText(count_tof_result);
			width = FocusCounter_Counter_Line0:GetStringWidth();
			FocusCounter_Counter:SetWidth(width + AddToWidth);
			FocusCounter_Counter:SetAlpha(255);
			if (FocusFrameNumericalThreat:IsShown()) then
				FocusCounter_Counter:ClearAllPoints();
				FocusCounter_Counter:SetPoint("LEFT", "FocusFrameNumericalThreat", "RIGHT", -5, 6);
			else
				FocusCounter_Counter:ClearAllPoints();
				FocusCounter_Counter:SetPoint("BOTTOM", "FocusFrame", "TOP", -18, -6);
			end
		else
			FocusCounter_Counter:SetAlpha(0);
		end

	end
end

function MTLove_arrangeFrame()
	local x, y = GetCursorPosition();
	x = (x + 3) / UIParent:GetScale() + get_SavedVariables("Frame_Offset_X");
	y = y / UIParent:GetScale() + get_SavedVariables("Frame_Offset_Y");
	Frame:ClearAllPoints();
	Frame:SetPoint("BOTTOMLEFT", x, y);
end

function MTLove_UnitIsTank(unit, unit_partyMember)
	if (get_SavedVariables("Experimental_Features") and getORA2Tanks()) then
		local list	= getORA2Tanks();
		for i = 1, 10, 1 do
			if (list[i] == alias_UnitName(unit)) then
				return true;
			end
		end
	end
	if (get_SavedVariables("Experimental_Features") and getCTRATanks()) then
		for k, v in pairs(getCTRATanks()) do
			if (v[2] == UnitName(unit)) then
				return true;
			end
		end
	end
	local classLoc, class	= alias_UnitClass(unit);
	local MaintankUnit	= alias_GetPartyAssignment("MAINTANK");
	
	--MTLove_UI_Debug("MaintankUnit", MaintankUnit);
	
	if ((unit_partyMember) and (alias_GetPartyAssignment("MAINTANK", unit))) then
		return true;
	end

	if ((not MaintankUnit) and ((not get_SavedVariables("Experimental_Features")) or ((not getORA2Tanks()) and (not getCTRATanks()))))  then
		if (class == "WARRIOR") then
			return true;
		elseif ((class == "DEATHKNIGHT") or (class == "DRUID") or (class == "PALADIN")) then
			local i = 1;
			while (alias_UnitBuff(unit, i) ~= nil) do
				local buffName, buffRank, buffTexture = alias_UnitBuff(unit, i);
				
				--MTLove_UI_Debug("buffTexture", buffTexture);
				
				if ((string.find(buffTexture, "Spell_Deathknight_FrostPresence")) or (string.find(buffTexture, "Ability_Racial_BearForm")) or (string.find(buffTexture, "Spell_Holy_SealOfFury"))) then
					return true;
				end
				i = i + 1;
			end
		end
	end
	return false;
end

function MTLove_UnitIsHealer(unit, unit_partyMember)
	local classLoc, class	= alias_UnitClass(unit);
	
	if ((class == "SHAMAN") or (class == "PRIEST")) then
		return true;
	elseif ((class == "PALADIN") or (class == "DRUID")) then
		return (not MTLove_UnitIsTank(unit, unit_partyMember));
	end
	return false;
end

function MTLove_UnitWearesPlate(unit)
	local level		= alias_UnitLevel(unit);
	local classLoc, class	= alias_UnitClass(unit);

	if (level >= 40) then
		return ((class == "WARRIOR") or (class == "DEATHKNIGHT") or (class == "PALADIN"));
	else
		return false;
	end
end

function MTLove_UnitWearesMail(unit)
	local level		= alias_UnitLevel(unit);
	local classLoc, class	= alias_UnitClass(unit);
	if (level >= 40) then
		return ((class == "SHAMAN") or (class == "HUNTER"));
	else
		return ((class == "WARRIOR") or (class == "PALADIN"));
	end
end

function MTLove_UnitWearesLeather(unit)
	local level		= alias_UnitLevel(unit);
	local classLoc, class	= alias_UnitClass(unit);
	if (level >= 40) then
		return ((class == "DRUID") or (class == "ROGUE"));
	else
		return ((class == "SHAMAN") or (class == "HUNTER") or (class == "DRUID") or (class == "ROGUE"));
	end
end

function MTLove_UnitWearesCloth(unit)
	return ((not MTLove_UnitWearesPlate(unit)) and (not MTLove_UnitWearesMail(unit)) and (not MTLove_UnitWearesLeather(unit)));
end

function MTLove_UnitCanControlPet(unit)
	local classLoc, class	= alias_UnitClass(unit);
	return ((class == "HUNTER") or (class == "WARLOCK") or (class == "DEATHKNIGHT"));
end

function MTLove_Count_Units_Targeting_Unit(Self_GroupMode, Self_GroupMembers, unit)
	local count_plate			= 0;
	local count_plate_tanks			= 0;
	local count_mail			= 0;
	local count_mail_tanks			= 0;
	local count_leather			= 0;
	local count_leather_tanks		= 0;
	local count_cloth			= 0;
	local count_cloth_tanks			= 0;
	local count_pets			= 0;
	local count_result			= "";

	if (Self_GroupMode == "party") then
		if (alias_UnitIsUnit(unit, "target")) then
			local UnitToTest	= "player";
			local unit_is_tank	= MTLove_UnitIsTank(UnitToTest, true);
			if (MTLove_UnitWearesPlate(UnitToTest)) then
				if (not unit_is_tank) then
					count_plate		= count_plate + 1;
				else
					count_plate_tanks	= count_plate_tanks + 1;
				end
			elseif (MTLove_UnitWearesMail(UnitToTest)) then
				if (not unit_is_tank) then
					count_mail		= count_mail + 1;
				else
					count_mail_tanks	= count_mail_tanks + 1;
				end
			elseif (MTLove_UnitWearesLeather(UnitToTest)) then
				if (not unit_is_tank) then
					count_leather		= count_leather + 1;
				else
					count_leather_tanks	= count_leather_tanks + 1;
				end
			else
				if (not unit_is_tank) then
					count_cloth		= count_cloth + 1;
				else
					count_cloth_tanks	= count_cloth_tanks + 1;
				end
			end
		end
		if (alias_UnitIsUnit(unit, "pettarget")) then
			count_pets = count_pets + 1;
		end
	end
	for i = 1, Self_GroupMembers, 1 do
		if (alias_UnitIsUnit(unit, Self_GroupMode .. tostring(i) .. "target")) then
			local UnitToTest 	= Self_GroupMode .. tostring(i);
			local unit_is_tank	= MTLove_UnitIsTank(UnitToTest, true);
			if (MTLove_UnitWearesPlate(UnitToTest)) then
				if (not unit_is_tank) then
					count_plate		= count_plate + 1;
				else
					count_plate_tanks	= count_plate_tanks + 1;
				end
			elseif (MTLove_UnitWearesMail(UnitToTest)) then
				if (not unit_is_tank) then
					count_mail		= count_mail + 1;
				else
					count_mail_tanks	= count_mail_tanks + 1;
				end
			elseif (MTLove_UnitWearesLeather(UnitToTest)) then
				if (not unit_is_tank) then
					count_leather		= count_leather + 1;
				else
					count_leather_tanks	= count_leather_tanks + 1;
				end
			else
				if (not unit_is_tank) then
					count_cloth		= count_cloth + 1;
				else
					count_cloth_tanks	= count_cloth_tanks + 1;
				end
			end
		end
		if (alias_UnitIsUnit(unit, Self_GroupMode .."pet" .. tostring(i) .. "target")) then
			count_pets = count_pets + 1;
		end
	end
	if (get_SavedVariables("Count_Tanks")) then
		local count_tanks	= count_plate_tanks + count_mail_tanks + count_leather_tanks + count_cloth_tanks;
		count_result		= color_tanks .. count_tanks .. end_color .. " - ";
	else
		count_plate		= count_plate + count_plate_tanks;
		count_mail		= count_mail + count_mail_tanks;
		count_leather		= count_leather + count_leather_tanks;
		count_cloth		= count_cloth + count_cloth_tanks;
	end
	if (not get_SavedVariables("Count_Plate")) then
		count_cloth		= count_cloth + count_plate;
	else
		count_result		= count_result .. color_plate .. count_plate .. end_color .. " ";
	end
	if (not get_SavedVariables("Count_Mail")) then
		count_cloth		= count_cloth + count_mail;
	else
		count_result		= count_result .. color_mail .. count_mail .. end_color .. " ";
	end
	if (not get_SavedVariables("Count_Leather")) then
		count_cloth		= count_cloth + count_leather;
	else
		count_result		= count_result .. color_leather .. count_leather .. end_color .. " ";
	end
	count_result			= count_result .. color_cloth .. count_cloth .. end_color;
	if (get_SavedVariables("Count_Pets")) then
		count_result		= count_result .. " - " .. color_pet .. count_pets .. end_color;
	end
	MTLove_Update_Memory_Usage();
	return count_result;
end

function MTLove_Stats_Reset()
	stats_data["count_cpu"]		= 0;
	stats_data["cpu_average"]	= 0;
	stats_data["cpu_values"]	= 0;
	stats_data["cpu_max"]		= 0;
	stats_data["cpu_min"]		= 0;
	stats_data["count_mem"]		= 0;
	stats_data["mem_average"]	= 0;
	stats_data["mem_values"]	= 0;
	stats_data["mem_max"]		= 0;
	stats_data["mem_min"]		= 0;
end

function MTLove_Update_CPU_Usage()
	if (get_Stats()) then
		if (stats_data["count_cpu"] >= do_stats_at_count) then
			stats_data["count_cpu"]		= 0;
			UpdateAddOnCPUUsage();
			local usedTime			= ceil(GetAddOnCPUUsage("MTLove") * 1000);
			stats_data["cpu_average"]	= ((stats_data["cpu_average"] * stats_data["cpu_values"]) + usedTime) / (stats_data["cpu_values"] + 1);
			stats_data["cpu_values"]	= stats_data["cpu_values"] + 1;
			if (usedTime > stats_data["cpu_max"]) then
				stats_data["cpu_max"]	= usedTime;
			end
			if ((usedTime < stats_data["cpu_min"]) or (stats_data["cpu_min"] == 0)) then
				stats_data["cpu_min"]	= usedTime;
			end
			MTLove_set_Stats_CPU_Usage("max: " .. stats_data["cpu_max"] .. " ns | average: " .. ceil(stats_data["cpu_average"]) .. " ns | min: " .. stats_data["cpu_min"] .. " ns");
		else
			stats_data["count_cpu"]	= stats_data["count_cpu"] +1;
		end
	end
end

function MTLove_Reset_CPU_Usage()
	if (get_Stats()) then
		ResetCPUUsage();
	end
end

function MTLove_Update_Memory_Usage()
	if (get_Stats()) then
		if (stats_data["count_mem"] >= (do_stats_at_count + 1)) then
			stats_data["count_mem"]	= 0;
			UpdateAddOnMemoryUsage();
			local usedMem = ceil(GetAddOnMemoryUsage("MTLove"));
			stats_data["mem_average"]	= ((stats_data["mem_average"] * stats_data["mem_values"]) + usedMem) / (stats_data["mem_values"] + 1);
			stats_data["mem_values"]	= stats_data["mem_values"] + 1;				
			if (usedMem > stats_data["mem_max"])then
				stats_data["mem_max"]	= usedMem;
			end
			if ((usedMem < stats_data["mem_min"]) or (stats_data["mem_min"] == 0))  then
				stats_data["mem_min"]	= usedMem;
			end
			MTLove_set_Stats_Memory_Usage("max: " .. stats_data["mem_max"] .. " KB | average: " .. ceil(stats_data["mem_average"]) .. " KB | min: " .. stats_data["mem_min"] .. " KB");
		else
		stats_data["count_mem"]	= stats_data["count_mem"] + 1;
		end
	end
end
