local kNamePlates = CreateFrame("Frame", nil, UIParent)
kNamePlates:SetScript("OnEvent", function(self, event, ...) self[event](self, ...) end)

-- Start configuration area

local frameheight, framewidth = kNPCustom_frameheight or 11, kNPCustom_framewidth or 120
local castbarheight = kNPCustom_castbarheight or frameheight * 0.8

local agrocolors = kNPCustom_agrocolors or {
		-- alpha is not currently used here, these are really just placeholders
		[0]		= { 1.00, 0.00, 0.00 },	-- "gray" equivalent (translate gray glow to red, the default hostile nameplate color; low aggro)
		[1]		= { 0.00, 1.00, 1.00 },	-- "yellow" equivalent (tranlate glow to a bright cyan; you are at risk of pulling/losing aggro)
		[2]		= { 1.00, 0.00, 1.00 },	-- "orange" equivalent (tranlate glow to a bright magenta; you are really close to pulling/losing aggro)
		[3]		= { 1.00, 0.67, 0.00 },	-- "red" equivalent (tranlate glow to a bright orange; this target is securely yours)
	}
local barTexture = kNPCustom_barTexture or [[Interface\Addons\kNamePlates\media\Smoothv2]]
local glowTexture = kNPCustom_glowTexture or [[Interface\Addons\kNamePlates\media\Outline]]
local font, fontSize, fontOutline = kNPCustom_font or [[Interface\Addons\kNamePlates\media\Calibri1.ttf]], kNPCustom_fontSize or 9, kNPCustom_fontOutline or "OUTLINE"
local stackedPointsfontSize = kNPCustom_stackedPointsfontSize or fontSize + 3
local castbarfontsize = kNPCustom_castbarfontsize or 8

-- Localization!
local thousandstext = kNPCustom_thousandstext or "%.1fk"
local millionstext = kNPCustom_millionstext or "%.1fm"
local L = GetLocale()
-- Add localization here
--[[if L == "frFR" then
	thousandstext = "%.1fk"
	millionstext = "%.1fm"
end]]

-- End configuration area

local lacerateID = 48568
local sunderID = 47467
local retributionSealID = UnitFactionGroup("player") == "Alliance" and 31801 or 53736
local retributionID = UnitFactionGroup("player") == "Alliance" and 31803 or 53742
local select = select
local _, playerClass = UnitClass("player")
local overlayTexture = [[Interface\Tooltips\Nameplate-Border]]

local function round(num, idp)
  return tonumber(string.format("%." .. (idp or 0) .. "f", num))
end



local IsValidFrame = function(frame)
	if frame:GetName() then
		return
	end

	overlayRegion = select(2, frame:GetRegions())

	return overlayRegion and overlayRegion:GetObjectType() == "Texture" and overlayRegion:GetTexture() == overlayTexture
end

local HumanNumber = function(value, minhp, maxhp)
	if value < 10000 then
		return value
	elseif value >= 10000 and value < 1000000 then
		return string.format(thousandstext, value / 1000)
	elseif value >= 1000000 and value < 1000000000 then
		return string.format(millionstext, value / 1000000)
	else
		return value
	end
end
local HPValuefunction = kNPCustom_HPValuefunction or HumanNumber

local UpdateTime = function(self, curValue)
	local minValue, maxValue = self:GetMinMaxValues()
	if self.channeling then
		self.time:SetFormattedText("%.1f ", curValue)
	else
		self.time:SetFormattedText("%.1f ", maxValue - curValue)
	end
end

local ThreatUpdate = function(self, elapsed)
	self.elapsed = self.elapsed + elapsed
	if self.elapsed >= 0.2 then
		local r,g,b = self.oldglow:GetVertexColor()
		
		if not self.oldglow:IsShown() then
			self.healthBar.hpGlow:SetVertexColor(0, 0, 0)
			self.healthBar.hpGlow:Hide()
		else
			local tr, tg, tb = self.oldglow:GetVertexColor()
			local key = tostring(round(tr, 3)..","..round(tg, 3)..","..round(tb, 3))
			self.healthBar.hpGlow:Show()
			self.healthBar.hpGlow:SetVertexColor(unpack(agrocolors[key] or {0,0,0}))
		end

		--self.healthBar:SetStatusBarColor(self.r, self.g, self.b)

		self.elapsed = 0
	end
end

local function GetBuff(spellID, isMine)
	local spellName, spellRank , spellIconPath = GetSpellInfo(spellID)
	local j = 1
	local filter = "HARMFUL"
	if isMine then
		filter = filter .. "|PLAYER"
	end
	while true do
		local buffRank
		buffName, buffRank, buffIconPath, count, _, duration, expirationTime, caster = UnitAura("target", j, filter);
		if (not buffName) then
			break;
		end

		if (spellName == buffName and 
			spellIconPath == buffIconPath and
			spellRank == buffRank ) 
		then 
			break
		else 
			buffName, count, duration, expirationTime, caster, numBuffs, buffIconPath = nil;                        
		end
		j=j+1;
	end
	return count, duration, expirationTime
end

local function GetStackedCount()
	if UnitExists("target") then
		local count, percent, duration, expirationTime
		percent = 0
		if playerClass == "DRUID" then
			if GetShapeshiftForm(true) == 1 then -- bear/dire bear form
				count, duration, expirationTime = GetBuff(lacerateID, true)
				if expirationTime and duration then
					percent = 1 - ((expirationTime - GetTime()) / duration)
				end
			elseif GetShapeshiftForm(true) == 3 then
				count = GetComboPoints("player", "target")
				percent = count / 5
			end
		elseif playerClass == "WARRIOR" then
			count, duration, expirationTime = GetBuff(sunderID, false)
			if expirationTime and duration then
				percent = 1 - ((expirationTime or GetTime() - GetTime()) / duration or 0)
			end
		elseif playerClass == "ROGUE" then
			count = GetComboPoints("player", "target")
			percent = count / 5
		elseif playerClass == "PALADIN" then
			count, duration, expirationTime = GetBuff(retributionID, true)
			if expirationTime and duration then
				percent = 1 - ((expirationTime or GetTime() - GetTime()) / duration or 0)
			end
		end
		if count and count > 0 then
			return count, percent
		else
			return ""
		end
	end
end

local UpdateFrame = function(self)
	
	if InCombatLockdown() then
		self.updateframe = true
	else
		self:SetHeight(frameheight + 5)
		self:SetWidth(framewidth + 5)
	end
	
	
	self.healthBar:ClearAllPoints()
	self.healthBar:SetPoint("CENTER", self.healthBar:GetParent(), "CENTER", 0, 0)
	self.healthBar:SetHeight(frameheight)
	self.healthBar:SetWidth(framewidth)

	self.castBar:ClearAllPoints()
	self.castBar:SetPoint("TOPRIGHT", self.healthBar, "BOTTOMRIGHT", 0, -1)
	self.castBar:SetHeight(castbarheight)
	self.castBar:SetWidth(framewidth - castbarheight)

	self.highlight:ClearAllPoints()
	self.highlight:SetAllPoints(self.healthBar)

	self.name:SetText(self.oldname:GetText())
	
	if self:GetAlpha() == 1 and self.name:GetText() == UnitName("target") then
		self.stacked:SetText(GetStackedCount())
		self.stacked:Show()
	else
		self.stacked:SetText("")
		self.stacked:Hide()
	end
	local level, elite = tonumber(self.level:GetText()), self.elite:IsShown()
	self.level:Hide()
	self.righttext:ClearAllPoints()
	local hp, minhp, maxhp = self.healthBar:GetValue(), self.healthBar:GetMinMaxValues()
	self.righttext:SetPoint("RIGHT", self.healthBar, "RIGHT", -2, 1)
	self.righttext:SetTextColor(self.level:GetTextColor())
	if hp ~= maxhp then
		self.righttext:SetTextColor(1, 1, 1)
		self.righttext:SetText(HPValuefunction(self.healthBar:GetValue(), self.healthBar:GetMinMaxValues()))
	else
		
		if self.boss:IsShown() then
			self.righttext:SetText("??")
		else
			self.righttext:SetText(level..(elite and "+" or ""))
		end
	end
end

local FixCastbar = function(self)
	self.castbarOverlay:Hide()

	self:SetHeight(castbarheight)
	self:ClearAllPoints()
	self:SetPoint("TOPRIGHT", self.healthBar, "BOTTOMRIGHT", 0, -1)
end

local ColorCastBar = function(self, shielded)
	if shielded then
		self:SetStatusBarColor(0.8, 0.05, 0)
	end
end

local CastBarOnSizeChanged = function(self)
	self.needFix = true
end

local CastBarOnValueChanged = function(self, curValue)
	UpdateTime(self, curValue)
	if self.needFix then
		FixCastbar(self)
		self.needFix = nil
	end
end

local HealthOnValueChanged = function(frame, value)
	frame:GetParent().righttext:SetText(HPValuefunction(value, frame:GetMinMaxValues()))
end

local CastBarOnShow = function(self)
	self.channeling  = UnitChannelInfo("target") 
	FixCastbar(self)
	ColorCastBar(self, self.shieldedRegion:IsShown())
end

local OnHide = function(self)
	self.highlight:Hide()
end

local CastBarOnEvent = function(self, event, unit)
	if unit == "target" then
		if self:IsShown() then
			ColorCastBar(self, event == "UNIT_SPELLCAST_NOT_INTERRUPTIBLE")
		end
	end
end

local function NameplateOnEvent(frame, event, ...)
	--[[if event == "PLAYER_TARGET_CHANGED" then
		CombatTextSetActiveUnit("target")
		UpdateFrame(frame)
	end
	if event == "COMBAT_TEXT_UPDATE" then
		local msgtype = ...
		if msgtype == "MANA" or msgtype == "ENERGY" or msgtype == "RAGE" or msgtype == "FOCUS" then
			UpdateFrame(frame)
		end
	end]]
	if event == "PLAYER_TARGET_CHANGED" or event == "UNIT_COMBO_POINTS" or event == "UNIT_AURA" then
		UpdateFrame(frame)
	end
	
end

local CreateFrame = function(frame)
	if frame.done then
		return
	end
	
	frame.nameplate = true
	
	if InCombatLockdown() then
		frame.updateframe = true
	else
		frame:SetHeight(frameheight + 5)
		frame:SetWidth(framewidth + 5)
	end

	frame.healthBar, frame.castBar = frame:GetChildren()
	local healthBar, castBar = frame.healthBar, frame.castBar
	local glowRegion, overlayRegion, castbarOverlay, shieldedRegion, spellIconRegion, highlightRegion, nameTextRegion, levelTextRegion, bossIconRegion, raidIconRegion, stateIconRegion = frame:GetRegions()

	frame.oldname = nameTextRegion
	nameTextRegion:Hide()

	local newNameRegion = frame:CreateFontString()
	newNameRegion:SetPoint("LEFT", healthBar, "LEFT", 0, 1)
	newNameRegion:SetJustifyH("LEFT") 
	newNameRegion:SetJustifyV("MIDDLE") 
	newNameRegion:SetWidth(framewidth * .9)
	newNameRegion:SetHeight(frameheight)
	newNameRegion:SetFont(font, fontSize, fontOutline)
	newNameRegion:SetTextColor(1, 1, 1)
	newNameRegion:SetShadowOffset(0, 0)
	frame.name = newNameRegion
	
	local newRightRegion = frame:CreateFontString()
	newRightRegion:SetPoint("LEFT", healthBar, "LEFT", 0, 1)
	newRightRegion:SetFont(font, fontSize, fontOutline)
	newRightRegion:SetShadowOffset(0, 0)
	newRightRegion:SetJustifyV("MIDDLE") 
	newRightRegion:SetHeight(frameheight)
	frame.righttext = newRightRegion
	
	local newStackedPointsRegion = frame:CreateFontString()
	newStackedPointsRegion:SetPoint("RIGHT", healthBar, "LEFT", -1, 1)
	newStackedPointsRegion:SetFont(font, stackedPointsfontSize, fontOutline)
	newStackedPointsRegion:SetShadowOffset(0, 0)
	newStackedPointsRegion:SetJustifyV("MIDDLE") 
	newStackedPointsRegion:SetHeight(frameheight)
	newStackedPointsRegion:SetText("")
	newStackedPointsRegion:Hide()
	frame.stacked = newStackedPointsRegion
	
	
	-- Events
	--frame:RegisterEvent("COMBAT_TEXT_UPDATE")
	frame:RegisterEvent("PLAYER_TARGET_CHANGED")
	if playerClass == "DRUID" or playerClass == "WARRIOR" or playerClass == "ROGUE" or playerClass == "PALADIN" then
		frame:RegisterEvent("UNIT_COMBO_POINTS")
		frame:RegisterEvent("UNIT_AURA")
	end
	frame:SetScript("OnEvent", NameplateOnEvent)
	
	frame.level = levelTextRegion
	levelTextRegion:Hide()
	levelTextRegion:SetFont(font, fontSize, fontOutline)
	levelTextRegion:SetShadowOffset(0, 0)

	healthBar:SetStatusBarTexture(barTexture)
	healthBar:SetScript("OnValueChanged", HealthOnValueChanged)

	healthBar.hpBackground = healthBar:CreateTexture(nil, "BORDER")
	healthBar.hpBackground:SetAllPoints(healthBar)
	healthBar.hpBackground:SetTexture(barTexture)
	healthBar.hpBackground:SetAlpha(0.5)
	healthBar.hpBackground:SetVertexColor(0.15, 0.15, 0.15)

	--[[healthBar.hpGlowFrame = CreateFrame("frame", nil, healthbar)
	healthBar.hpGlowFrame:SetFrameStrata("BACKGROUND")
	healthBar.hpGlowFrame:ClearAllPoints()
	healthBar.hpGlowFrame:SetPoint("CENTER", healthBar, "CENTER")
	healthBar.hpGlowFrame:SetHeight(11)
	healthBar.hpGlowFrame:SetWidth(110)]]

	healthBar.hpGlow = healthBar:CreateTexture(nil, "BORDER")
	--healthBar.hpGlow:SetAllPoints(healthBar)
	healthBar.hpGlow:SetPoint("TOPLEFT", healthBar, "TOPLEFT", -2, 2)
	healthBar.hpGlow:SetPoint("BOTTOMRIGHT", healthBar, "BOTTOMRIGHT", 2, -2)
	healthBar.hpGlow:SetTexture(glowTexture)
	--healthBar.hpGlow:SetBlendMode("ADD")
	healthBar.hpGlow:SetVertexColor(0, 0, 0)
	healthBar.hpGlow:SetAlpha(1)
	--healthBar.hpGlow:SetBackdropBorderColor(0, 0, 0)
	healthBar.hpGlow:Hide()

	castBar.castbarOverlay = castbarOverlay
	castBar.healthBar = healthBar
	castBar.shieldedRegion = shieldedRegion
	castBar:SetStatusBarTexture(barTexture)

	castBar:SetScript("OnShow", CastBarOnShow)
	castBar:SetScript("OnSizeChanged", CastBarOnSizeChanged)
	castBar:SetScript("OnValueChanged", CastBarOnValueChanged)
	castBar:SetScript("OnEvent", CastBarOnEvent)
	castBar:RegisterEvent("UNIT_SPELLCAST_INTERRUPTIBLE")
	castBar:RegisterEvent("UNIT_SPELLCAST_NOT_INTERRUPTIBLE")

	castBar.time = castBar:CreateFontString(nil, "ARTWORK")
	castBar.time:SetPoint("RIGHT", castBar, "RIGHT", -2, 0)
	castBar.time:SetFont(font, castbarfontsize)
	castBar.time:SetTextColor(1, 1, 1)
	castBar.time:SetShadowOffset(0, 0)

	castBar.cbBackground = castBar:CreateTexture(nil, "BORDER")
	castBar.cbBackground:SetAllPoints(castBar)
	castBar.cbBackground:SetTexture(barTexture)
	castBar.cbBackground:SetVertexColor(0.15, 0.15, 0.15)
	castBar.cbBackground:SetAlpha(0.5)

	castBar.cbGlow = CreateFrame("Frame", nil, castBar)
	castBar.cbGlow:SetPoint("TOPLEFT", castBar, "TOPLEFT", -4.5, 4)
	castBar.cbGlow:SetPoint("BOTTOMRIGHT", castBar, "BOTTOMRIGHT", 4.5, -4.5)
	--castBar.cbGlow:SetBackdrop(backdrop)
	--castBar.cbGlow:SetBackdropColor(1, 1, 1)
	--castBar.cbGlow:SetBackdropBorderColor(1, 1, 1)
	
	castBar.spellIcon = spellIconRegion
	castBar.spellIcon:SetPoint("TOPRIGHT", castBar, "TOPLEFT")
	castBar.spellIcon:SetHeight(castbarheight)
	castBar.spellIcon:SetWidth(castbarheight)
	
	
	highlightRegion:SetTexture(barTexture)
	highlightRegion:SetVertexColor(0.25, 0.25, 0.25)
	frame.highlight = highlightRegion

	raidIconRegion:ClearAllPoints()
	raidIconRegion:SetPoint("CENTER", healthBar, "TOP", 0, 2)
	raidIconRegion:SetHeight(15)
	raidIconRegion:SetWidth(15)

	frame.oldglow = glowRegion
	frame.elite = stateIconRegion
	frame.boss = bossIconRegion

	frame.done = true

	glowRegion:SetTexture(nil)
	overlayRegion:SetTexture(nil)
	shieldedRegion:SetTexture(nil)
	castbarOverlay:SetTexture(nil)
	stateIconRegion:SetTexture(nil)
	bossIconRegion:SetTexture(nil)

	UpdateFrame(frame)
	frame:SetScript("OnShow", UpdateFrame)
	frame:SetScript("OnHide", OnHide)

	frame.elapsed = 0
	frame:SetScript("OnUpdate", ThreatUpdate)
	--Spew("frame", frame)
end

local numKids = 0
local lastUpdate = 0
local OnUpdate = function(self, elapsed)
	lastUpdate = lastUpdate + elapsed

	if lastUpdate > 0.1 then
		lastUpdate = 0

		if WorldFrame:GetNumChildren() ~= numKids then
			numKids = WorldFrame:GetNumChildren()
			for i = 1, select("#", WorldFrame:GetChildren()) do
				frame = select(i, WorldFrame:GetChildren())

				if IsValidFrame(frame) then
					CreateFrame(frame)
				end
			end
		end
	end
end
do
	for status = 0, 3 do
		local tr, tg, tb = GetThreatStatusColor(status)
		agrocolors[tostring(round(tr, 3)..","..round(tg, 3)..","..round(tb, 3))] = agrocolors[status]
	end
end

kNamePlates:SetScript("OnUpdate", OnUpdate)

