
-- all things slash-command related

-- cross-module access
local	KarmaObj = KarmaAvEnK;

local	CommandQueueLockSource = nil;
local	CommandQueueLockMsgDelta = 20;
local	CommandQueueLockAt = 0;
local	CommandQueueLockIndirect = 0;

function	KarmaObj.Slash.CommandQLock(sFrom)
	if (CommandQueueLockSource == nil) then
		CommandQueueLockAt = GetTime();
		CommandQueueLockSource = sFrom;
		return true, CommandQueueLockSource;
	else
		local	iDelta = GetTime() - CommandQueueLockAt;
		local	sDelta = format("%02im %02is", math.floor(iDelta / 60), iDelta % 60);
		KarmaChatSecondary(format(KARMA_MSG_COMMANDQUEUE_LOCKED_ALREADY, tostring(sFrom), tostring(CommandQueueLockSource), sDelta));
		return false, CommandQueueLockSource;
	end
end

function	KarmaObj.Slash.CommandQLocked(fTimeNow)
	if (CommandQueueLockSource and fTimeNow) then
		if (FriendsFrame:IsVisible()) then
			CommandQueueLockIndirect = fTimeNow;
		else
			local	iDelta = fTimeNow - CommandQueueLockAt;
			if (CommandQueueLockIndirect > CommandQueueLockAt) then
				iDelta = fTimeNow - CommandQueueLockIndirect;
			end

			if (iDelta > CommandQueueLockMsgDelta) then
				if (CommandQueueLockMsgDelta < 80) then
					local	sDelta = format("%.1fs", iDelta);
					KarmaChatDebug(format(KARMA_MSG_COMMANDQUEUE_LOCKED_SHORT, tostring(CommandQueueLockSource), sDelta));
				else
					local	sDelta = format("%02im %02is", math.floor(iDelta / 60), iDelta % 60);
					KarmaChatSecondaryFallbackDefault("|cFFFF6080" .. format(KARMA_MSG_COMMANDQUEUE_LOCKED_LONG, tostring(CommandQueueLockSource), sDelta) .. "|r");
				end

				CommandQueueLockMsgDelta = CommandQueueLockMsgDelta * 2;
			end
		end
	end

	return CommandQueueLockSource, CommandQueueLockAt;
end

function	KarmaObj.Slash.CommandQUnlock(sFrom)
	if (CommandQueueLockSource == sFrom) then
		CommandQueueLockSource = nil;
		CommandQueueLockMsgDelta = 15;
		return true;
	elseif (CommandQueueLockSource) then
		local	iDelta = GetTime() - CommandQueueLockAt;
		local	sDelta = format("%02im %02is", math.floor(iDelta / 60), iDelta % 60);
		KarmaChatSecondary("CommandQ: Unlock request from <" .. sFrom .. "> declined, still locked to <" .. CommandQueueLockSource .. "> since " .. sDelta);
		return false, CommandQueueLockSource;
	else
		KarmaChatSecondary("CommandQ: Unlock request from <" .. sFrom .. "> ignored, no lock set.");
	end
end

