--[[
	Karma
	by Aveasau

	Karma Resurrection
	by Endareth

	Karma Keeping-Alive
	by Krbr

	See readme.txt for notes
]]--

----------------------------------
-- UIVERSION CROSSCOMPATIBILITY --
----------------------------------

local GfTt =
	{
		GetNumPartyMembersTf = GetNumPartyMembers or GetNumSubgroupMembers,
		GetNumRaidMembersTf = GetNumRaidMembers or GetNumGroupMembers,
	};

----------------------------------------------
-- GLOBALS
----------------------------------------------

KARMA_ININIT = 0;
KARMA_LOADED = 0;

KarmaConfig = {};
local	KarmaConfigLocal = nil;

-- cross-module access
local	LANG = KARMAAVENK_LANG;
local	KarmaObj = KarmaAvEnK;
local	KCfg = KarmaObj.Cfg;
local	KOH = KarmaObj.Helpers;
local	KSlash = KarmaObj.Slash;

-- various Elements shall get their own arrays here:
KarmaObj.UI.NotesPublic = {};
KarmaObj.UI.Config = {};

KARMA_MAINWND_KEEPOPEN = false;
KARMA_MAINWND_REINSERT = false;

-- for all functions local to this module
local	KarmaModuleLocal =
		{
			-- Version check related
			Version =
				{
					Seen =
						{
							PARTY = {
								Newer = 0,
								Same  = 0,
								Older = 0
								},
							GUILD = {
								Newer = 0,
								Same  = 0,
								Older = 0
								},
							RAID = {
								Newer = 0,
								Same  = 0,
								Older = 0
								}
						}
				},

			-- stuff regarding the command queue
			Command = {},
			Timers = {
					CmdQ = 0,
					CronQ = 0,
					Update = 0,
				},

			-- information containers
			Raid =
				{
					-- current raid
					MemberCnt = 0,
					Name2Index = {},

					-- previous raids
					iIndexHistory = 1,
					HistoryTables =
						{
						}
				},

			-- information containers
			NotesPublic =
				{
					Results = {}
				},

			-- channel information: Blizzard channel, other
			Channels = {},
			ChannelName = nil;		-- channel name or number
			ChannelTime = 0;		-- list request for channel sent at this time

			-- new chat system
			ChatFilters = {},
			ChatFilterMissingWarning = {},

			-- Dummy inits
			TalentSpecCount = nil,
			PatternZoneExplored = nil,

			-- UI parts & pieces
			UIConfig = {},
			ColorSpaces = {
				Default1 = {
					Min = { r = 1.0, g = 0.0, b = 0.0 },
					Avg = { r = 0.5, g = 0.5, b = 1.0 },
					Max = { r = 0.0, g = 1.0, b = 0.0 },
				},

				Default2 = {
					Min = { r = 0.7, g = 0.7, b = 0.7 },
					Avg = { r = 0.5, g = 0.5, b = 1.0 },
					Max = { r = 0.3, g = 1.0, b = 0.3 },
				},
			},
			FieldHighLow = {
			},

			-- tooltip: only add Karma info once per target+mouseover
			GameTooltipUnit = nil,

			-- required for partial Achievement tracking
			PlayerRegenEnabledOrMobDied = nil,

			-- only once - flags
			WhoInfoOnlyOnce_Char = nil,
			WarnTrackingOnce = nil,

			-- char select menu: must delay selected until after init
			CharSelection_Index = nil,

			-- mouseover Unit storage
			MouseOverKeepCount = 25,
			MouseOverKeepIndex = 0,
			MouseOverKeepList = {},

			-- chatter history storage
			ChatRememberCount = 10,
			ChatRememberIndex = 0,
			ChatRememberList = {},

			-- Who queue
			ExecutingWhoSince = nil,
			ExecutingWhoBroken = false,

			-- check for terrorist player pending
			AchievementCheckTerrorTimer = 0,
			AchievementCheckTerrorCount = 0,
			AchievementCheckTerrorList = {},

			-- meta-entry for guildless people
			Guildless = "> no guild <",

			FriendList = {},

			-- debugging: region colorization changes
			RegionChangePrevious = "Undefined",

			-- debugging: checking load order
			AddonLoaded = {},

			-- regions:
				-- grab bg/arena region names from the system
			RegionsBGsAndArenas = {},
				-- grab and map localized names to AreaID
				-- if done, goes into KarmaData.COMMON.<LOCALE>.REGIONS
			RegionsByAreaID = { Name2ID = {}, ID2Name = {}, Continent2Zones = {} },
		};

-- BINDING Names
BINDING_HEADER_KARMA = KARMA_BINDING_HEADER_TITLE;
BINDING_NAME_KARMAWINDOW = KARMA_BINDING_WINDOW_TITLE;
BINDING_NAME_KARMAWINDOW2 = KARMA_BINDING_WINDOW2_TITLE;

----------------------------------------------
-- CONSTS
----------------------------------------------

-- COMMON/REGIONNAMES LEVEL FIELDS: DB_L3_CR
local	KARMA_DB_L3_CR = {
			ZONEIDS = "ZONEIDS",
			ISPVPZONE = "PVPZONE",
			ZONETYPE = "ZONETYPE"
		};

-- REALM/FACTION/<FACTION> LEVEL FIELDS: DB_L4_RRFF
local	KARMA_DB_L4_RRFF = {
			CHARACTERLIST = "CHARACTERLIST",
			MEMBERLIST = "MEMBERLIST",				-- no longer used since version 4 of the database
			MEMBERBUCKETS = "MEMBERBUCKETS",
			ALTGROUPS = "ALTGROUPS",
			QUESTNAMES = "QUESTNAMES",
			ZONENAMES = "ZONENAMES",
			-- XFACTIONHOLD = "XFACTIONHOLD",		-- moved to L1 and creation/access hidden into KarmaObj.DB.* functions
			IGNORE24 = "IGNTMP",

			HISTORY_MOVED = "HIST_MOVED",
			HISTORY_SEEN = "HIST_SEEN",
		};

-- REALM/FACTION/<FACTION>/CHARACTERLIST OBJECT FIELDS: DB_L5_RRFFC
local	KARMA_DB_L5_RRFFC = {
			NAME = "NAME";
			XPTOTAL = "XPTOTAL";
			XPLAST = "XPLAST";
			XPMAX = "XPMAX";
			PLAYED = "PLAYED";
			PLAYEDPVP = "PLAYEDPVP";
			PLAYEDLAST = "PLAYEDLAST";
			CONFIGPERCHAR = "CHARCONFIG";
			XPLVLSUM = "XPLVLSUM";
		};

-- Waawaa, "local" limit: 200
-- TODO: more KARMA_DB_??_*_* -> KARMA_DB_??_*.*

-- REALM/FACTION/<FACTION>/MEMBERLIST OBJECT FIELDS: DB_L5_RRFFM
local	KARMA_DB_L5_RRFFM = {
			LASTCHANGED_TIME = "TOUCH_TIME",
			LASTCHANGED_FIELD = "TOUCH_FIELD",
			LASTSEEN = "LASTSEEN",

			GUID = "GUID",
			NAME = "NAME",
			ALTGROUP = "ALTID",
			GUILD = "GUILD",
			LEVEL = "LEVEL",
			GENDER = "GENDER",
			RACE = "RACE",
			CLASS = "CLASS",
			CLASS_ID = "CLSID",

			RACE_EN = "RACEEN",
			CLASS_EN = "CLASSEN",

			GEARLEVEL_PVP = "GEAR_PVP_LVL",
			GEARLEVEL_PVE = "GEAR_PVE_LVL",
		};

-- #### --

local		KARMA_DB_L5_RRFFM_CONFLICT = "CONFLICT";

local		KARMA_DB_L5_RRFFM_TALENT = "TALENT";
local		KARMA_DB_L5_RRFFM_TALENTTREE = "TALENTTREE";

local		KARMA_DB_L5_RRFFM_KARMA = "KARMA";

local		KARMA_DB_L5_RRFFM_PUBLIC_NOTES = "PUBLIC_NOTES";
local		KARMA_DB_L5_RRFFM_NOTES = "NOTES";
local		KARMA_DB_L5_RRFFM_PUBLIC_NOTES_TIME = "PUBNOTES_TIME";
local		KARMA_DB_L5_RRFFM_NOTES_TIME = "NOTES_TIME";
local		KARMA_DB_L5_RRFFM_PUBLIC_NOTES_HISTORY = "PUBNOTES_HIST";
-- stores imported total sum
local		KARMA_DB_L5_RRFFM_KARMA_IMPORTED = "K_IMP";
-- modifier for "time"-Karma: -1 = use default, 0 = off, 1 = on
local		KARMA_DB_L5_RRFFM_KARMA_TIME = "K_TIME";
-- old concept... dropped.
-- it's impossible to add "-3 underperforming" to "+3 nice" and get a sensible result...
-- must remain a while to clean out intermediate versions
local		KARMA_DB_L5_RRFFM_KARMA_MODSOC = "K_SOC";
local		KARMA_DB_L5_RRFFM_KARMA_MODSKILL = "K_SKILL";
-- TODO: three new values to filter on...
local		KARMA_DB_L5_RRFFM_SKILL = "SKILL";
local		KARMA_DB_L5_RRFFM_GEAR_PVP = "GEAR_PVP";
local		KARMA_DB_L5_RRFFM_GEAR_PVE = "GEAR_PVE";

local		KARMA_DB_L5_RRFFM_TIMESTAMP = "TIMESTAMP";
local		KARMA_DB_L5_RRFFM_TIMESTAMP_TRY = "TRY";
local		KARMA_DB_L5_RRFFM_TIMESTAMP_SUCCESS = "SUCCESS";
local		KARMA_DB_L5_RRFFM_JOINEDLAST_TIME = "JOINEDLAST";
local		KARMA_DB_L5_RRFFM_JOINEDLAST_CHAR = "JOINEDWITH";

-- local		KARMA_DB_L5_RRFFM_KARMA_TRUST = "K_TRUST";
local		KARMA_DB_L5_RRFFM_SHARE_TRUST = "SHARE_TRUST";

local		KARMA_DB_L5_RRFFM_TERROR = "TERROR";

-- REALM/FACTION/<FACTION>/MEMBERLIST/<Bucket>/<Member>/CHARACTERS/<Character> OBJECT FIELDS: DB_L6_RRFFMCC
-- character specific data
-- container
local		KARMA_DB_L5_RRFFM_CHARACTERS = "CHARACTERSPECIFIC";
local		KARMA_DB_L6_RRFFMCC_KARMA_ID = "K_IDREF";
-- data
local		KARMA_DB_L6_RRFFMCC_QUESTIDLIST = "QUESTIDLIST";
local		KARMA_DB_L6_RRFFMCC_QUESTEXLIST = "QUESTEXLIST";
local		KARMA_DB_L6_RRFFMCC_ZONEIDLIST = "ZONEIDLIST";
local		KARMA_DB_L6_RRFFMCC_XP = "XP";
local		KARMA_DB_L6_RRFFMCC_XPLAST = "XPLAST";
local		KARMA_DB_L6_RRFFMCC_XPMAX = "XPMAX";
local		KARMA_DB_L6_RRFFMCC_XPLVL = "XPLVL";
local		KARMA_DB_L6_RRFFMCC_PLAYED = "PLAYED";
local		KARMA_DB_L6_RRFFMCC_PLAYEDPVP = "PLAYEDPVP";
local		KARMA_DB_L6_RRFFMCC_PLAYEDLAST = "PLAYEDLAST";
local		KARMA_DB_L6_RRFFMCC_JOINEDLAST = "JOINEDLAST";
local		KARMA_DB_L6_RRFFMCC_ACHIEVED = "ACHIEVED";
-- ../CHARACTERS/<Character>/REGIONLIST OBJECT FIELDS: DB_L7_RRFFMCCR
-- region tracking: which when how long...
-- container
local		KARMA_DB_L6_RRFFMCC_REGIONLIST = "REG_L";			-- list of
-- data
-- KARMA_DB_L7_RRFFMCCRR_ -> KARMA_DB_L7_RRFFMCCRR_
local		KARMA_DB_L7_RRFFMCCRR_KEY = "RL_REGKEY";				-- an ID (RegionID + Difficulty!)
local		KARMA_DB_L7_RRFFMCCRR_ID = "RL_REGID";					-- a RegionID
local		KARMA_DB_L7_RRFFMCCRR_DIFF = "RL_REGDIFF";				-- a difficulty
local		KARMA_DB_L7_RRFFMCCRR_PLAYEDTOTAL = "REG_TOTAL";		-- summed time
-- another container
local		KARMA_DB_L7_RRFFMCCRR_PLAYEDDAYS = "REG_DAYS";			-- list of
-- and another dataset
local		KARMA_DB_L8_RRFFMCCRRD_KEY = "REG_DAYKEY";					-- an ID
local		KARMA_DB_L8_RRFFMCCRRD_START = "RD_FROM";					-- start (datetime)
local		KARMA_DB_L8_RRFFMCCRRD_END = "RD_TILL";						-- end (datetime)
local		KARMA_DB_L8_RRFFMCCRRD_ROLE = "RD_ROLE";					-- role in the group (if PUG)

-- REALM/FACTION/<FACTION>/XFACTIONHOLD OBJECT FIELDS: additional field besides DB_L5_RRFFM
local		KARMA_DB_L5_RRFFX_KARMA = "KARMA";
local		KARMA_DB_L5_RRFFX_SOURCE = "SOURCE";
local		KARMA_DB_L5_RRFFX_FACTION = "FACTION";

local		KARMA_ALPHACHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";


-- CONFIG FIELDS (all local)
local	KARMA_CONFIG = {
			-- Options: "Sort/Color"
			SORTFUNCTION = "SORTFUNCTION",
			SORTFUNCTION_TYPE_KARMA = "KARMASORT",
			SORTFUNCTION_TYPE_NAME = "NAMESORT",
			SORTFUNCTION_TYPE_XP	= "XPSORT",
			SORTFUNCTION_TYPE_PLAYED = "PLAYEDSORT",
			SORTFUNCTION_TYPE_CLASS = "CLASSSORT",
			SORTFUNCTION_TYPE_JOINED = "JOINEDSORT",
			SORTFUNCTION_TYPE_JOINEDTHIS = "SRT_JOINEDTHIS",
			SORTFUNCTION_TYPE_SEEN = "SRT_SEEN",
			SORTFUNCTION_TYPE_TALENT = "TALENTSORT",
			SORTFUNCTION_TYPE_XPALL	= "XPALLSORT",
			SORTFUNCTION_TYPE_PLAYEDALL = "PLAYEDALLSORT",
			SORTFUNCTION_TYPE_GUILD_TOP = "BYGUILD_TOP",
			SORTFUNCTION_TYPE_GUILD_BOTTOM = "BYGUILD_BTM",

			COLORFUNCTION = "COLORFUNCTION",
			COLORFUNCTION_TYPE_XP	= "XPCOLOR",
			COLORFUNCTION_TYPE_PLAYED = "PLAYEDCOLOR",
			COLORFUNCTION_TYPE_KARMA = "KARMACOLOR",
			COLORFUNCTION_TYPE_CLASS = "CLASSCOLOR",
			COLORFUNCTION_TYPE_XPALL = "XPALLCOLOR",
			COLORFUNCTION_TYPE_PLAYEDALL = "PLAYEDALLCOLOR",
			COLORFUNCTION_TYPE_XPLVL = "XPLVLCOLOR";
			COLORFUNCTION_TYPE_XPLVLALL = "XPLVLALLCOLOR";

			COLORSPACE_ENABLE = "COLORSPACE_ENABLE",
			COLORSPACE_KARMA = "COLORSPACE_KARMA",
			COLORSPACE_TIME = "COLORSPACE_TIME",
			COLORSPACE_XP = "COLORSPACE_XP",

			-- Options: "Tooltip"
			TOOLTIP_SHIFTREQ = "TT_SHREQ",
			TOOLTIP_KARMA = "TT_KARMA",
			TOOLTIP_PLAYEDTOTAL = "TT_PLAYEDTOTAL",
			TOOLTIP_PLAYEDTHIS = "TT_PLAYEDTHIS",
			TOOLTIP_NOTES = "TT_NOTES",
			TOOLTIP_SKILL = "TT_SKILL",
			TOOLTIP_GEAR = "TT_GEAR",
			TOOLTIP_TALENTS = "TT_TALENTS",
			TOOLTIP_TERROR = "TT_TERROR",
			TOOLTIP_ALTS = "TT_ALTS",
			TOOLTIP_HELP = "TT_HELP",
			TOOLTIP_LFMADDKARMA = "TT_LFMADDKARMA",

			-- Options: "auto.Ign/Warn"
			AUTOIGNORE_THRESHOLD = "AUTOIGNORE_THRESHOLD",
			AUTOIGNORE = "AUTOIGNORE",
			AUTOIGNORE_INVITES = "AUTOIGNORE_INVITES",
			JOINWARN_THRESHOLD = "JOINWARN_THRESHOLD",
			JOINWARN_ENABLED = "JOINWARN_ENABLED",

			-- Options: "Chat windows"
			CHAT_DEFAULT = "CHAT_DEFAULT",
			CHAT_SECONDARY = "CHAT_SECONDARY",
			CHAT_DEBUG = "CHAT_DEBUG",

			MARKUP_ENABLED = "MARKUP",
			MARKUP_VERSION = "MARKUP_VERSION",
			MARKUP_COLOUR_NAME = "COLOUR_NAME",				-- missing in UI
			MARKUP_COLOUR_KARMA = "COLOUR_KARMA",				-- missing in UI
			MARKUP_SHOW_KARMA = "SHOW_KARMA",				-- missing in UI
			MARKUP_WHISPERS = "MARKUP_WHISPERS",
			MARKUP_CHANNELS = "MARKUP_CHANNELS",
			MARKUP_GUILD = "MARKUP_GUILD",
			MARKUP_RAID = "MARKUP_RAID",
			MARKUP_BG = "MARKUP_BG",
			MARKUP_YELLSAYEMOTE = "MARKUP_YSE",

			-- Options: "virtual Karma"
			TIME_KARMA_DEFAULT = "K_TIME_DEFAULT",
			TIME_KARMA_MINVAL = "K_TIME_MINVAL",
			TIME_KARMA_FACTOR = "K_TIME_FACTOR",
			TIME_KARMA_SKIPBGTIME = "K_TIME_NOTBG",

			-- Options: "Other"
			TARGET_COLORED = "TARGET_COLORED",
			QUESTWARNCOLLAPSED = "QUESTWARN",
			MAINWND_INITIALTAB = "MAINWND_INITTAB",
			TALENTS_AUTOFETCH = "TALENTS_AUTOFETCH",
			MINIMAP_HIDE = "MINIMAP_HIDE",
			QUESTSIGNOREDAILIES = "Q_IGN_DAILY",
			UPDATEWHILEAFK = "UPD_ON_AFK",
			DB_SPARSE = "SPARSEDB",

			-- Options: "DB cleaning"
			CLEAN_AUTO = "AUTOCLEAN",
			CLEAN_AUTOPVP = "AUTOCLEANPVP",
			CLEAN_KEEPIFNOTE = "CLEAN_KEEPIFNOTE",
			CLEAN_REMOVEPVPJOINS = "CLEAN_REM_PVP",
			CLEAN_REMOVEXSERVER = "CLEAN_REMOVEXSERVER",
			CLEAN_KEEPIFKARMA = "CLEAN_KEEPIFKARMA",
			CLEAN_KEEPIFREGIONCOUNT = "CLEAN_KEEPIFREGIONCOUNT",
			CLEAN_KEEPIFZONECOUNT = "CLEAN_KEEPIFZONECOUNT",
			CLEAN_KEEPIFQUESTCOUNT = "CLEAN_KEEPIFQUESTCOUNT",
			CLEAN_IGNOREPVPZONES = "CLEAN_IGNOREPVPZONES",

			-- Options: "Sharing"
			SHARE_ONREQ_KARMA = "SHARE_ONREQ_KARMA",
			SHARE_ONREQ_PUBLICNOTE = "SHARE_ONREQ_PUBNOTE",
			SHARE_CHANNEL_NAME = "SHARE_CHAN_NAME",
			SHARE_CHANNEL_AUTO = "SHARE_CHAN_AUTO",

			-- Options: "Tracking" (UI partially TODO)
			RAID_TRACKALL = "RAID_TRACKALL",
			RAID_NOGROUP  = "RAID_NOGROUP",
			TRACK_DISABLEACHIEVEMENT = "TRACK_NOACHIEVEMENT",
			TRACK_DISABLEACHIEV_TERROR = "TRACK_NOACH_TERROR",
			TRACK_DISABLEQUEST = "TRACK_NOQUEST",
			TRACK_DISABLEREGION = "TRACK_NOREGION",
			TRACK_DISABLEZONE = "TRACK_NOZONE",
			TRACK_DISABLEPVPAREAS = "TRACK_NOPVPAREA",
			TRACK_DISABLEWARNING_VERSION = "TRACK_WARNVERSION",

			MENU_DEACTIVATE = "MENU_OFF",
			MENU_WARN = "MENU_WARN",

			-- internal
			DEBUG_ENABLED = "DEBUG",

			-- == last entry no ",", add to previous == --
			BETA = "BETA"
		};

local		KARMA_ALPHACHARS_ACCENT =
	{
		["A"] = {[1] = 192, [2] = 193, [4] = 194, [5] = 195, [6] = 196, [7] = 197, [8] = 198},
		["C"] = {[1] = 199},
		["D"] = {[1] = 208},
		["E"] = {[1] = 200, [2] = 201, [3] = 202, [4] = 203},
		["I"] = {[1] = 204, [2] = 205, [3] = 206, [4] = 207},
		["N"] = {[1] = 209},
		["O"] = {[1] = 210, [2] = 211, [3] = 212, [4] = 213, [5] = 214, [6] = 215, [7] = 216},
		["U"] = {[1] = 217, [2] = 218, [3] = 219, [4] = 220},
		["Y"] = {[1] = 221}
	};

-- these tables just cover "Basic-Latin" (U-0000) and "Latin-1" (U-0080)
-- from the UNICODE charts
local		KARMA_ALPHACHARS_UTF8_REVERSE =
	{
	-- all but  start with 195,  with 197
		[195] = {
				["A"] = { 128, 129, 130, 131, 132, 133, 134 },
				["B"] = { 159 },	-- !!  -> b
				["C"] = { 135 },
				["D"] = { 144 },
				["E"] = { 136, 137, 138, 139 },
				["I"] = { 140, 141, 142, 143 },
				["N"] = { 145 },	--  -> n
				["O"] = { 146, 147, 148, 149, 150, 152 },
				["U"] = { 153, 154, 155, 156 },
				-- ["Y"] = { ??? }
			},

		[197] = {
					["O"] = { 115 },
			},
	};

local		KARMA_ALPHACHARS_UTF8_FORWARD =
	{
	-- all but  start with 195,  with 197
		[195] = {
					[128] = "A", [129] = "A", [130] = "A", [131] = "A", [132] = "A", [133] = "A", [134] = "A",
					[159] = "B",	-- !!  -> b
					[135] = "C",
					[144] = "D",
					[136] = "E", [137] = "E", [138] = "E", [139] = "E",
					[140] = "I", [141] = "I", [142] = "I", [143] = "I",
					[145] = "N",	--  -> n
					[146] = "O", [147] = "O", [148] = "O", [149] = "O", [150] = "O", [152] = "O",
					[153] = "U", [154] = "U", [155] = "U", [156] = "U",
			},

		[197] = {
					[115] = "O",
			},
	};

-- Bitfield
-- 1-2-4     : HPS (1), TANK (2), DPS (4), Feral(6)
-- 8-16      : MELEE(8), RANGED(16)
local	KARMA_TALENTS_MAXBITPLUS1 = 5;

local	KARMA_TALENTS =
	{
		[0] = { key = "KARMA_MISSING_INFO", color = "|cFF9F9F9F" },
		[1] = { key = "KARMA_TALENT_HPS", color = "|cFF00FF00" },		-- spec: Dru/Pal/Shm/Pri
		[2] = { key = "KARMA_TALENT_TANK", color = "|cFFFFFFFF" },		-- spec: Dru/Pal/War tanks
		[4] = { key = "KARMA_TALENT_DPS", color = "|cFFFF0000" },		-- spec: all classes
		[6] = { key = "KARMA_TALENT_FERAL", color = "|cFFFF8080" },		-- spec: Feral
		[8] = { key = "KARMA_TALENT_MELEE", color = "|cFFFFA0A0" },		-- spec: Moonkin/Feral, ShamanMelee/Ranged
		[16] = { key = "KARMA_TALENT_RANGED", color = "|cFF8080FF" }		-- spec: Moonkin/Feral, ShamanMelee/Ranged
	};

--------------------------------------------------
-- FOLLOWING IS PART OF THE CLASS, NOT TALENTED --
--------------------------------------------------

-- (no need to store at each member, derive from class)
-- Bitfield
-- 1-2-4 : CC: CC.(1), CC1(2), CC2(4)
local	KARMA_ABILITIES_CC_COLOR = "|cFFA0A0F0";
local	KARMA_ABILITIES_CC =
	{
		[0] = "KARMA_MISSING_INFO",
		[1] = "KARMA_TALENT_CC_CC0",
		[2] = "KARMA_TALENT_CC_CC1",
		[4] = "KARMA_TALENT_CC_CC2"
	};

-- Bitfield
-- 1-    : CC: H(uman 1), U(ndead 2), E(lement 4), B(east 8), D(raconian 16)
local	KARMA_TARGETS_CC =
	{
		[0] = "KARMA_MISSING_INFO",
		[1] = "KARMA_MONSTER_HUMAN",
		[2] = "KARMA_MONSTER_UNDEAD",
		[4] = "KARMA_MONSTER_ELEMENT",
		[8] = "KARMA_MONSTER_BEAST",
		[16] = "KARMA_MONSTER_DRAKE"
	};

-- Bitfield
-- 1-2   : AE: M1(128), AE(256)
local	KARMA_ABILITIES_AE =
	{
		[0] = "KARMA_MISSING_INFO",
		[1] = "KARMA_TALENT_AE_M1",
		[2] = "KARMA_TALENT_AE_AE"
	};

local	KARMA_SKILL_LEVELS = nil;

----------------------------------------------
--	Local variables
----------------------------------------------

local	KSLASH = {};
local	KARMA_CURRENTLIST = 1;
local	KARMA_CURRENTMEMBER = nil;
local	KARMA_CURRENTCHAR = nil;
local	KARMA_MEMBERLIST_SIZE = 25;
local	KARMA_MAINLISTS_SIZE = 15;
local	KARMA_ALTLIST_SIZE = 5;

local	KARMA_SELECTEDTAB = nil;

local	KARMA_VERSION_TEXT = nil;
local	KARMA_VERSION_DATE = nil;

local	KARMA_VERSION_TEXT_NEWEST = nil;
local	KARMA_VERSION_DATE_NEWEST = nil;

-- DEBUG
local	KARMA_ALWAYS_WATCH_EVENTS = false;
local	KARMA_SHOW_FORBIDDEN_IN_MAIN = false;

-- testing (quicker) online check... not working as intended :-(
local	KARMA_OnlineCheckAddedFriend = nil;

-- extended Questlog usage
local	KARMA_QEx_NumPartyMembers = 0;
local	KARMA_QExInitDone = 0;
local	KARMA_QExCreate = 50;
local	KARMA_QExCreateLog = 0;
local	KARMA_QExUpdate = 50;
local	KARMA_QExDisplay = 1;
local	KARMA_QExsWarnComp = "";
local	KARMA_QZone = 1;

local	KARMA_NamesSortedAlpha = nil;
local	KARMA_NamesSortedCustom = nil;

local	KARMA_Filter =
	{
		Total = nil,
		Pattern = nil,
		Name = nil,
		Class = nil,
		LevelFrom = nil,
		LevelTo = nil,
		KarmaFrom = nil,
		KarmaTo = nil,
		JoinedAfter = nil,
		JoinedBefore = nil,
		Notes = nil,
		Public = nil,
		Guild = nil,
		Instance = nil,
	};

local	KARMA_PartyNames = {};
local	KARMA_OtherInfos = {};

local	KARMA_TalentInspect =
	{
		OtherFramesWarn = 1,
		AutofetchConfigCache = nil,
		RequiredCount = 0,
		RequiredList = {},
		RequestQueueTimer = 0,

		RequestedUnit = nil,
		RequestedMember = nil,
		RequestedGUID = nil,

		StateNextTime = nil,
		StateCurrent = 0,
		State1Time = nil,
		State2Time = nil,
		State3Time = nil,
		State4Time = nil,

		NotifyInspectCallCount = 0,
		NotifyInspectCallList = {},
		TalentsReadyCallCount = 0,
		TalentsReadyCallList = {},

		DebugMsgState = nil
	};

-- for hiding the tooltip when the minimap menu was openend
local	KARMA_Minimap_Tooltip_Hide = false;

local	KARMA_QuestCache = {};
local	KARMA_QuestCache_LastUpdated = -1;
local	KARMA_QuestCache_LastQLEC = -1;

-- Queues
local	KARMA_LastUpdateTime = 0;
local	KARMA_LastCronTime = 0;
local	KARMA_LastMessageTime = 0;
local	KARMA_WhoElapsedTime = 0;
local	Karma_CommandQueue = {}
local	Karma_MessageQueue = {}
local	Karma_Executing_Who = nil;
local	Karma_WhoQueue = {};
local	Karma_CronQueue = {}

-- Patch routine holders
local	KARMA_OriginalChatFrame_OnEvent = nil;
local	KARMA_Original_Who_Update = nil;

local	KARMA_WarnedOnce = 0;

-- no update on zone type unless time() - Karma_ZoneChanged > 5
local	Karma_ZoneChanged = 0;
local	KARMA_CHECKCHANNEL_TIMEMAX = 120;

-- maybe, maybe not... pondering
--local	oFaction = nil;

----------------------------------------------------------------------------------
-- FUNCTION META OBJECTS: too many copies of code, need some tables to simplify...
----------------------------------------------------------------------------------

KarmaModuleLocal.UIConfig.Elements =
	{
--[[
		-- examples:
			-- sublist: CFGName, TYPE, DEPENDSName, DEFAULT, MINVAL, MAXVAL
		"Object" =									-- boolean Checkbutton
			{ CFGName = "...", TYPE = "bool", DEPENDSName = "...", DEFAULT = value, MINVAL = value, MAXVAL = value },
		"Object2" = { "Config2", "01" },			-- 0/1 Checkbutton
		"Object2" = { "Config2", "0n" },			-- 0..n editbox
		"Object3" = { "Config3", "karma" },			-- 1..100 editbox
		"Object3" = { "Config3", "number" },		-- distinct values selection (menu)
		"Object3" = { "Config3", "float" },			-- non-integer number (editbox)
		"Object3" = { "Config3", "string" }			-- string values (non-numeric editbox)
]]--

		-- colorspace configurable:
		["KarmaOptionsWindow_ColorSpace_Enable_Checkbox"] =
			{ CFGName = "COLORSPACE_ENABLE", TYPE = "bool" },

		-- markup
		["KarmaOptionWindow_MarkupEnabled_Checkbox"] =
			{ CFGName = "MARKUP_ENABLED", TYPE = "bool" },
		["KarmaOptionWindow_MarkupWhispers_Checkbox"] =
			{ CFGName = "MARKUP_WHISPERS", TYPE = "bool", DEPENDSName = "MARKUP_ENABLED" },
		["KarmaOptionWindow_MarkupChannels_Checkbox"] =
			{ CFGName = "MARKUP_CHANNELS", TYPE = "bool", DEPENDSName = "MARKUP_ENABLED" },
		["KarmaOptionWindow_MarkupYSE_Checkbox"] =
			{ CFGName = "MARKUP_YELLSAYEMOTE", TYPE = "bool", DEPENDSName = "MARKUP_ENABLED" },
		["KarmaOptionWindow_MarkupGuild_Checkbox"] =
			{ CFGName = "MARKUP_GUILD", TYPE = "bool", DEPENDSName = "MARKUP_ENABLED" },
		["KarmaOptionWindow_MarkupRaid_Checkbox"] =
			{ CFGName = "MARKUP_RAID", TYPE = "bool", DEPENDSName = "MARKUP_ENABLED" },
		["KarmaOptionWindow_MarkupBG_Checkbox"] =
			{ CFGName = "MARKUP_BG", TYPE = "bool", DEPENDSName = "MARKUP_ENABLED" },

		-- autoignore
		["KarmaOptionWindow_AutoignoreEnabled_Checkbox"] =
			{ CFGName = "AUTOIGNORE", TYPE = "01" },
		["KarmaOptionWindow_IgnoreInvites_Checkbox"] =
			{ CFGName = "AUTOIGNORE_INVITES", TYPE = "01", DEPENDSName = "AUTOIGNORE" },
		["KarmaOptionWindow_AutoIgnoreThreshold"] =
			{ CFGName = "AUTOIGNORE_THRESHOLD", TYPE = "karma", DEPENDSName = "AUTOIGNORE" },

		-- autowarn
		["KarmaOptionWindow_WarnLowKarma_Checkbox"] =
			{ CFGName = "JOINWARN_ENABLED", TYPE = "01" },
		["KarmaOptionWindow_WarnLowKarma_Threshold"] =
			{ CFGName = "JOINWARN_THRESHOLD", TYPE = "karma" },

		-- Sharing
		["KarmaOptionWindow_Sharing_ChannelAutoJoinHide_Checkbox"] =
			{ CFGName = "SHARE_CHANNEL_AUTO", TYPE = "bool" },

		-- DBClean (1)
		["KarmaOptionWindow_DBClean_AutoClean_Checkbox"] =
			{ CFGName = "CLEAN_AUTO", TYPE = "bool" },
		["KarmaOptionWindow_DBClean_AutoCleanPvP_Checkbox"] =
			{ CFGName = "CLEAN_AUTOPVP", TYPE = "01" },

		-- DBClean (2)
		["KarmaOptionWindow_DBClean_KeepIfNote_Checkbox"] =
			{ CFGName = "CLEAN_KEEPIFNOTE", TYPE = "01", DEFAULT = 1 },
		["KarmaOptionWindow_DBClean_RemovePvPJoins_Checkbox"] =
			{ CFGName = "CLEAN_REMOVEPVPJOINS", TYPE = "01" },
		["KarmaOptionWindow_DBClean_RemoveXServer_Checkbox"] =
			{ CFGName = "CLEAN_REMOVEXSERVER", TYPE = "01" },
		["KarmaOptionWindow_DBClean_KeepIfKarma_Checkbox"] =
			{ CFGName = "CLEAN_KEEPIFKARMA", TYPE = "01" },
		["KarmaOptionWindow_DBClean_KeepIfQListThres_Editbox"] =
			{ CFGName = "CLEAN_KEEPIFQUESTCOUNT", TYPE = "0n" },
		["KarmaOptionWindow_DBClean_KeepIfZListThres_Editbox"] =
			{ CFGName = "CLEAN_KEEPIFZONECOUNT", TYPE = "0n" },
		["KarmaOptionWindow_DBClean_KeepIfRListThres_Editbox"] =
			{ CFGName = "CLEAN_KEEPIFREGIONCOUNT", TYPE = "0n" },
		["KarmaOptionWindow_DBClean_IgnorePVPZones_Checkbox"] =
			{ CFGName = "CLEAN_IGNOREPVPZONES", TYPE = "01" },

		-- other
		["KarmaOptionWindow_OtherTargetColored_Checkbox"] =
			{ CFGName = "TARGET_COLORED", TYPE = "01", DEFAULT = 1 },
		["KarmaOptionWindow_Other_QCacheWarn_Checkbox"] =
			{ CFGName = "QUESTWARNCOLLAPSED", TYPE = "01", DEFAULT = 1 },
		-- missing: mapping of menu for initial tab
		["KarmaOptionWindow_Other_AutocheckTalents_Checkbox"] =
			{ CFGName = "TALENTS_AUTOFETCH", TYPE = "01" },
		["KarmaOptionWindow_Other_MinimapIconHide_Checkbox"] =
			{ CFGName = "MINIMAP_HIDE", TYPE = "01" },
		["KarmaOptionWindow_Other_QuestsIgnoreDailies_Checkbox"] =
			{ CFGName = "QUESTSIGNOREDAILIES", TYPE = "01" },
		["KarmaOptionWindow_Other_UpdateWhileAFK_Checkbox"] =
			{ CFGName = "UPDATEWHILEAFK", TYPE = "01" },
		["KarmaOptionWindow_Other_ContextMenuDeactivate_Checkbox"] =
			{ CFGName = "MENU_DEACTIVATE", TYPE = "01" },
		["KarmaOptionWindow_Other_DBSparseTables_Checkbox"] =
			{ CFGName = "DB_SPARSE", TYPE = "01" },

		-- virtual Karma
		["KarmaOptionWindow_VirtualKarma_TimeKarma_Checkbox"] =
			{ CFGName = "TIME_KARMA_DEFAULT", TYPE = "01" },
		["KarmaOptionWindow_VirtualKarma_TimeKarmaThreshold_Editbox"] =
			{ CFGName = "TIME_KARMA_MINVAL", TYPE = "karma", DEFAULT = 50 },
		["KarmaOptionWindow_VirtualKarma_TimeKarmaFactor_Editbox"] = 
			{ CFGName = "TIME_KARMA_FACTOR", TYPE = "float", DEFAULT = 0.4, MINVAL = 0.01, MAXVAL = 10.0 },
		["KarmaOptionWindow_VirtualKarma_SkipBGTime_Checkbox"] =
			{ CFGName = "TIME_KARMA_SKIPBGTIME", TYPE = "01", DEFAULT = 1 },

		-- tooltip options
		["KarmaOptionWindow_OtherKarmaTips_Checkbox"] =
			{ CFGName = "TOOLTIP_KARMA", TYPE = "bool" },
		["KarmaOptionWindow_OtherNoteTips_Checkbox"] =
			{ CFGName = "TOOLTIP_NOTES", TYPE = "bool" },
		["KarmaOptionWindow_Tooltip_Skill_Checkbox"] =
			{ CFGName = "TOOLTIP_SKILL", TYPE = "01" },
		["KarmaOptionWindow_Tooltip_Gear_Checkbox"] =
			{ CFGName = "TOOLTIP_GEAR", TYPE = "01" },
		["KarmaOptionWindow_Tooltip_Talents_Checkbox"] =
			{ CFGName = "TOOLTIP_TALENTS", TYPE = "01" },
		["KarmaOptionWindow_Tooltip_Terror_Checkbox"] =
			{ CFGName = "TOOLTIP_TERROR", TYPE = "01" },
		["KarmaOptionWindow_Tooltip_Alts_Checkbox"] =
			{ CFGName = "TOOLTIP_ALTS", TYPE = "01" },
		["KarmaOptionWindow_Tooltip_Help_Checkbox"] =
			{ CFGName = "TOOLTIP_HELP", TYPE = "01" },

		-- core features: tracking
		["KarmaOptionWindow_CoreFeatures_TrackingDisableQuests_Checkbox"] = 
			{ CFGName = "TRACK_DISABLEQUEST", TYPE = "01", DEFAULT = 0 },
		["KarmaOptionWindow_CoreFeatures_TrackingDisableAchievements_Checkbox"] = 
			{ CFGName = "TRACK_DISABLEACHIEVEMENT", TYPE = "01", DEFAULT = 0 },
		["KarmaOptionWindow_CoreFeatures_TrackingDisableAchievementTerror_Checkbox"] = 
			{ CFGName = "TRACK_DISABLEACHIEV_TERROR", TYPE = "01", DEFAULT = 0 },
		["KarmaOptionWindow_CoreFeatures_TrackingDisableRegions_Checkbox"] = 
			{ CFGName = "TRACK_DISABLEREGION", TYPE = "01", DEFAULT = 0 },
		["KarmaOptionWindow_CoreFeatures_TrackingDisableZones_Checkbox"] = 
			{ CFGName = "TRACK_DISABLEZONE", TYPE = "01", DEFAULT = 0 },
	};

-- install fallbacks
if (type(KARMA_CONFIG) == "table") then
	local	k, v;
	for k, v in pairs(KarmaModuleLocal.UIConfig.Elements) do
		v.CFG = KARMA_CONFIG[v.CFGName];
		if (v.DEPENDSName) then
			v.DEPENDS = KARMA_CONFIG[v.DEPENDSName];
		end
	end
end

-----------------------------------------------------------------
-- FUNCTIONS: LOCAL (everything that need not be visible outside, could add a whole lot more...)
-----------------------------------------------------------------

-- local	CommonRegionZoneAddCurrent;
local	CommonRegionZoneAdd;
local	CommonRegionListGet;
local	CommonZoneListGet;

local	CommonQuestAdd;
--local	CommonQuestListGet; -- -> KarmaObj.DB.CF.QuestNameListGet;
local	CommonQuestInfoListGet;

-- local	Karma_IDToClass;
-- local	Karma_X_ClassToID;
-- local	Karma_RaceLocalizedToRaceEN;

local	WhoAmI;

-- local just to be on the safe side...
local	Karma_MemberObject_SetName;
local	Karma_MemberObject_SetGUID;

local	KARMA_FriendsFrameVisible = nil;
local	KARMA_FriendsFrameUnregistered = nil;
local	KARMA_WhoRequest = nil;
local	KARMA_WhoRequestIsMine = 0;

local	KARMA_InspectByUser = {};

----------------------------------------------
-- FUNCTIONS: QUICK&SHORT LOCALS
----------------------------------------------
function	KarmaObj.StringInitial(input)
	local	c = strsub(input, 1, 1);
	if (c >= 'A') and (c <= 'Z') then
		return c;
	end

	local	b1 = strbyte(input, 1);

	if (b1 >= 192) and (b1 <= 223) then
		-- two-byte-sequence
		c = strsub(input, 1, 2);
		return c;
	end

	if (b1 >= 224) and (b1 <= 239) then
		-- three-byte-sequence
		c = strsub(input, 1, 3);
		return c;
	end

	if (b1 >= 240) then
		-- four-byte-sequence
		c = strsub(input, 1, 4);
		return c;
	end

	-- giving up...
	return c;
end

function	KarmaObj.StringInitialCapitalized(input)
	local	c = KarmaObj.StringInitial(input);
	return strupper(c) .. strsub(input, 1 + strlen(c));
end

KarmaObj.UTF8 = {};

function	KarmaObj.UTF8.FirstChar(sValue)
	local	b1 = strbyte(sValue, 1);
	if (b1 < 191) then
		-- one-byte-sequence
		c = strsub(sValue, 1, 1);
		return c, 1;
	end

	if (b1 >= 192) and (b1 <= 223) then
		-- two-byte-sequence
		c = strsub(sValue, 1, 2);
		return c, 2;
	end

	if (b1 >= 224) and (b1 <= 239) then
		-- three-byte-sequence
		c = strsub(sValue, 1, 3);
		return c, 3;
	end

	if (b1 >= 240) then
		-- four-byte-sequence
		c = strsub(sValue, 1, 4);
		return c, 4;
	end

	-- actually, shouldn't get here...
	return c, 1;
end

function	KarmaObj.UTF8.LenInChars(_sValue)
	local	iLen = 0;
	local	sValue = _sValue;
	if (sValue == nil) then
		return iLen;
	end

	while (sValue ~= "") do
		local	c1, l1 = KarmaObj.UTF8.FirstChar(sValue);
		iLen = iLen + 1;
		sValue = strsub(sValue, 1 + l1);
	end

	return iLen;
end

function	KarmaObj.UTF8.SubInChars(_sValue, iFrom, iTo)
	local	iLen = 0;
	local	sValue = _sValue;
	if (sValue == nil) then
		return sValue;
	end

	local	sResult = "";
	while (sValue ~= "") do
		local	c1, l1 = KarmaObj.UTF8.FirstChar(sValue);
		iLen = iLen + 1;
		if (iLen >= iFrom) and ((iTo == nil) or (iLen <= iTo)) then
			sResult = sResult .. c1;
		end
		sValue = strsub(sValue, 1 + l1);
	end

	return sResult;
end

--
--	Turn accented characters into plain non accented characters
--	this is very useful for the purpose of sorting, so that all
--	A's regardless of accent get sorted into the same bucket.
--
function	KarmaObj.NameToBucket(input)
	-- direct ASCII
	local	c = KarmaObj.StringInitial(input);
	if (c >= 'A') and (c <= 'Z') then
		return c;
	end

	-- mappable UTF8
	local	b1 = strbyte(c, 1);
	if (KARMA_ALPHACHARS_UTF8_FORWARD[b1]) then
		local	b2 = strbyte(c, 2);
		if (KARMA_ALPHACHARS_UTF8_FORWARD[b1][b2]) then
			return KARMA_ALPHACHARS_UTF8_FORWARD[b1][b2];
		end
	end

	-- other: changed from "Y" to "X", because "Y" is actually not that uncommon...
	return "X";
end

--
-- for pattern searching, convert whole string to ascii
--
function	KarmaObj.StringToASCII(input)
	if (not input) or (input == "") then
		return input;
	end

	local	result = "";

	local	c, cub, b1, b2, d;
	repeat
		-- direct ASCII
		c = KarmaObj.StringInitial(input);
		cup = strupper(c);
		if (cup >= 'A') and (cup <= 'Z') then
			result = result .. c;
		else
			d = c;

			-- mappable UTF8?
			local	b1 = strbyte(cup, 1);
			if (KARMA_ALPHACHARS_UTF8_FORWARD[b1]) then
				local	b2 = strbyte(cup, 2);
				if (KARMA_ALPHACHARS_UTF8_FORWARD[b1][b2]) then
					d = KARMA_ALPHACHARS_UTF8_FORWARD[b1][b2];
				end
			end

			if (c == cup) then
				result = result .. d;
			else
				result = result .. strlower(d);
			end
		end
		input = strsub(input, 1 + strlen(c));
	until (not input or (input == ""));

	return result;
end

----------------------------------------------
-- FUNCTIONS: GLOBAL
----------------------------------------------

function	Karma_WhoAmIInit()
	if (WhoAmI == nil) then
		WhoAmI = UnitName("player");
		if ((WhoAmI == KARMA_UNKNOWN) or (WhoAmI == KARMA_UNKNOWN_ENT)) then
			-- not yet available
			WhoAmI = nil;
		else
			KARMA_CURRENTCHAR = WhoAmI;
			if (KARMA_CURRENTMEMBER ~= nil) then
				-- refresh char dropdown
				Karma_SetCurrentMember(KARMA_CURRENTMEMBER);
			end
		end
	end
end

function	Karma_OnLoad(self)
	KARMA_ININIT = 1;

	Karma_SetupDebug();
	KarmaObj.ProfileStart("Karma_OnLoad");
	Karma_InitSlash();

	KARMA_VERSION_TEXT = GetAddOnMetadata("Karma", "Version");
	if (KARMA_VERSION_TEXT == nil) then
		KARMA_VERSION_TEXT = "???";
	end
	KARMA_VERSION_DATE = GetAddOnMetadata("Karma", "X-Date");
	if (KARMA_VERSION_DATE == nil) then
		KARMA_VERSION_DATE = "???";
	end

	-- expansion differences
	local	_, _, _, iTOC = GetBuildInfo();
	KarmaObj.Const.iTOC = iTOC;
	KarmaObj.Const.bMoPActive = false;

	KarmaObj.Talents.SpecCount = 1;
	if (iTOC >= 30100) then
		KarmaObj.Talents.SpecCount = 2;
	end

	KarmaObj.Const.LevelMax = 80;
	if (iTOC >= 40000) then
		KarmaObj.Const.LevelMax = 85;
		if (iTOC >= 50000) then
			-- Pandaria release day unknown as of now
		--	local	iNow = time();
		--	if (iNow >= time({ year = 2010, month = 12, day = 7, hour = 0, min = 0, sec = 0, isdst = false })) then
				KarmaObj.Const.bMoPActive = true;
				KarmaObj.Const.LevelMax = 90;
		--	end
		end
	end

	self:RegisterEvent("ADDON_LOADED");
	self:RegisterEvent("VARIABLES_LOADED");

	self:RegisterEvent("PLAYER_LOGIN");
	self:RegisterEvent("PLAYER_ENTERING_WORLD");

	-- for debugging of FORBIDDEN popup
	self:RegisterEvent("ADDON_ACTION_FORBIDDEN");

	-- legacy: older tooltip data (potentially translated)
	if (KARMA_FILTER_TOOLTIP) then
		KARMA_TOOLTIPS["FILTER"] = KARMA_FILTER_TOOLTIP;
	end

	KarmaObj.ProfileStop("Karma_OnLoad");
end

function	Karma_SpecAvailable(iSpec)
	return (iSpec >= 1) and (iSpec <= KarmaObj.Talents.SpecCount);
end

function	Karma_FullInitialise()
	local	sPlayername = UnitName("player");
	if (sPlayername and (sPlayername ~= "") and (sPlayername ~= KARMA_UNKNOWN)) then
		KCfg.Init();
		KarmaModuleLocal.ColorSpaces.Karma = KCfg.Get("COLORSPACE_KARMA");
		KarmaModuleLocal.ColorSpaces.Time = KCfg.Get("COLORSPACE_TIME");
		KarmaModuleLocal.ColorSpaces.XP = KCfg.Get("COLORSPACE_XP");

		KarmaObj.DB.Create();
		if (KarmaObj.DB.Upgrade() == -1) then
			return -1;
		end

		if (not KarmaObj.DB.FactionCacheInit(true)) then
			return -1;
		end

		Karma_IntializePlayerObject();

		-- Sometimes we get crap entries. Clear them
		Karma_CleanDatabase();

		-- => config per char
		KARMA_LOADED = 1;

		-- 2nd call: now charspecific choices are available
		Karma_SetupChatWindows();

		-- We want this to show up in the main chat window.
		if (DEFAULT_CHAT_FRAME) then
			DEFAULT_CHAT_FRAME:AddMessage(KARMA_TITLE .. KARMA_WINEL_FRAG_SPACE .. "v" .. KARMA_VERSION_TEXT .. LANG.INITIAL_MESSAGE);
		end

		local	iVer = KCfg.Get("MARKUP_VERSION") or 3;
		if (iVer == 1) then
			-- those should be always safe to taint, they're all non-combat frames
			KarmaChatSecondaryFallbackDefault("Old version of feature 'chat markup' is active. Please change to the new version in options->chat windows->markup, newer version.");
			Karma_InsertChatFramePatch();		-- colourisation, ignore
		end

		-- newer mechanic, if possible other mechanics should be moved here...
		Karma_HookSecureFunctions();

		KarmaObj.Achievements.CacheCreate();
		Karma_CreateQuestCache();
		Karma_MemberList_CreatePartyNamesCache();
		Karma_MemberList_CreateMemberNamesCache();
		Karma_AddTimeToPartyMembers();

		Karma_MinimapIconFrame_InitComplete();

		if (KCfg.Get("SKILL_MODEL") == "complex") then
			KARMA_SKILL_LEVELS = KARMA_SKILL_LEVELS_COMPLEX;
		else
			KARMA_SKILL_LEVELS = KARMA_SKILL_LEVELS_SIMPLE;
		end
		KarmaObj.Const.SkillLevels = KARMA_SKILL_LEVELS;

		if (KCfg.Get("SHARE_CHANNEL_AUTO") == true) then
			KarmaModuleLocal.Command.ChannelAutoQueue();
		end

		if (IsInGuild()) then
			KarmaModuleLocal.Command.VersionQueryQueue("?v1", "GUILD");
		end

		local	olXMembers = KarmaObj.DB.FactionXHoldGet();
		if (type(olXMembers) == "table") then
			local	iCount, key, value = 0;
			for key, value in pairs(olXMembers) do
				iCount = iCount + 1;
			end
			if (iCount > 0) then
				KarmaModuleLocal.Command.xFactionRemindUpdateQueue(iCount);
			end
		end

		if (KCfg.Get("MENU_WARN") == 1) then
			-- this happens when the user didn't choose before but quit WoW
			StaticPopup_Show("KARMA_BLIZZARDBROKEMENUS_AGAIN");
		end

		KarmaObj.Slash.CommandQRemove("func", Karma_QueueFullInitialise);
	else
		Karma_MemberList_CreatePartyNamesCache();
	end
end

function	Karma_QueueFullInitialise(self)
	local	iBad = Karma_FullInitialise();
	if (KARMA_LOADED == 1) then
		self:RegisterEvent("ZONE_CHANGED");
		self:RegisterEvent("ZONE_CHANGED_INDOORS");
		self:RegisterEvent("ZONE_CHANGED_NEW_AREA");

		-- to get pvp - zones identified
		self:RegisterEvent("PLAYER_SKINNED");

		-- removed hook to UIParent, do it "regular" style
		self:RegisterEvent("PARTY_INVITE_REQUEST");
		self:RegisterEvent("DUEL_REQUESTED");
		self:RegisterEvent("GUILD_INVITE_REQUEST");
		self:RegisterEvent("TRADE_REQUEST");

		-- achievement tracking
		if (KCfg.Get("TRACK_DISABLEACHIEVEMENT") ~= 1) then
			self:RegisterEvent("ACHIEVEMENT_EARNED");
			self:RegisterEvent("PLAYER_REGEN_ENABLED");
			self:RegisterEvent("PLAYER_REGEN_DISABLED");
		end

		self:RegisterEvent("LFG_COMPLETION_REWARD");
		self:RegisterEvent("PARTY_MEMBERS_CHANGED");	-- pre-MoP
		self:RegisterEvent("RAID_ROSTER_UPDATE");		-- pre-MoP
		self:RegisterEvent("GROUP_ROSTER_UPDATE");		-- post-MoP

		self:RegisterEvent("UNIT_INVENTORY_CHANGED");

		self:RegisterEvent("PLAYER_XP_UPDATE");

		self:RegisterEvent("QUEST_COMPLETE");
		self:RegisterEvent("QUEST_FINISHED");
		self:RegisterEvent("QUEST_ITEM_UPDATE");
		self:RegisterEvent("QUEST_PROGRESS");
		self:RegisterEvent("QUEST_DETAIL");
		self:RegisterEvent("QUEST_LOG_UPDATE");

		self:RegisterEvent("PLAYER_TARGET_CHANGED");

		self:RegisterEvent("CHAT_MSG_COMBAT_HOSTILE_DEATH");
		self:RegisterEvent("CHAT_MSG_COMBAT_XP_GAIN");

		self:RegisterEvent("CHAT_MSG_ADDON");
		self:RegisterEvent("CHAT_MSG_SYSTEM");
		self:RegisterEvent("CHAT_MSG_CHANNEL");
		self:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");

		self:RegisterEvent("WHO_LIST_UPDATE");

		self:RegisterEvent("PLAYER_TARGET_CHANGED");

		self:RegisterEvent("UPDATE_MOUSEOVER_UNIT");

		-- MoP:
		if (KarmaObj.Const.iTOC >= 50000) then
			-- if a player switches his active spec, use the chance to scan the other spec
			self:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED");
		end

	elseif (iBad == -1) then
		DEFAULT_CHAT_FRAME:AddMessage("|cFFFF8080Karma: FAILED TO INITIALIZE DATABASE PROPERLY!|r");
		DEFAULT_CHAT_FRAME:AddMessage("|cFFFF8080Karma: Load-On-Demand is enabled for the database, but at least one database (KarmaAlliance or KarmaHorde) cannot be loaded.|r");
		DEFAULT_CHAT_FRAME:AddMessage("|cFFFF8080Karma: Please enable KarmaAlliance and KarmaHorde, or disable Load-On-Demand.|r");
	else
		-- queue command: any other queued command has to be dropped for self
		KarmaModuleLocal.Timers.CmdQ = GetTime() + 10;

		local	oCmd = { sName = "init", func = Karma_QueueFullInitialise, args = self };
		KarmaObj.Slash.CommandQClear();
		KarmaObj.Slash.CommandQAdd(oData);
	end
end

local function KarmaRegisterWithmyAddOns()
	if ((myAddOnsFrame_Register ~= nil) and (KarmaObj.myAddOnsRegistered ~= 1)) then
		local	KarmaHelp = {};
		local	key, value;

		local	KarmaHelp1 = "";
		for key, value in pairs(KARMA_CMDLINE_HELP_SHORT) do
			KarmaHelp1 = KarmaHelp1 .. value .. "\n";
		end
		KarmaChatDebug(KarmaHelp1);
		tinsert(KarmaHelp, KarmaHelp1);

		local	oHelp = KARMA_CMDLINE_HELPMETA_FULL;
		if (KARMA_CMDLINE_HELP_LONG ~= nil) then
			oHelp = KARMA_CMDLINE_HELPMETA_LEGACY;
		end
		local	KarmaHelp2 = "";
		for key, value in pairs(oHelp) do
			local	oGroup = getglobal("KARMA_CMDLINE_HELP_" .. value);
			if (type(oGroup) == "table") then
				local	ksub, vsub;
				for ksub, vsub in pairs(oGroup) do
					KarmaHelp2 = KarmaHelp2 .. vsub .. "\n";
				end
			end
		end
		KarmaChatDebug(KarmaHelp2);
		tinsert(KarmaHelp, KarmaHelp2);

		local	KarmaDetails = { name = "Karma", author = "K\195\164rb\195\164r" };
		myAddOnsFrame_Register(KarmaDetails, KarmaHelp);
		KarmaObj.myAddOnsRegistered = 1;
	end
end

function	KarmaObj.RegisterWIMModule()
-- WIM bridge
-- WhisperEngine.lua:
--    local WhisperEngine = CreateModule("WhisperEngine");
-- WindowHandler.lua:
--    CallModuleFunction("OnWindowCreated", obj);

	if (WIM and (type(WIM) == "table") and (type(WIM.CreateModule) == "function")) then
		if (KarmaObj.Karma2WIMBridge == nil) then
			KarmaObj.Karma2WIMBridge = WIM.CreateModule("Karma2WIMBridge", true);
			KarmaObj.Karma2WIMBridge.OnWindowCreated = function(self, oWnd)
					if (oWnd and (type(oWnd) == "table") and (oWnd.theUser)) then
						KarmaChatSecondary("(WIM integration) Checking for information about " .. KOH.Name2Clickable(oWnd.theUser) .. "...");
						local	oMember = Karma_MemberList_GetObject(oWnd.theUser);
						if (oMember ~= nil) then
							oWnd.widgets.from:SetText(oWnd.theUser .. " <" .. Karma_MemberObject_GetKarmaModifiedForListWithColors(oMember) .. ">");
						else
							oWnd.widgets.from:SetText(oWnd.theUser .. " <-->");
						end;
					end;
				end;
			KarmaObj.Karma2WIMBridge.enabled = true;
			KarmaChatDebug("Registered WIM module.");
		else
			KarmaChatDebug("WIM module *IS* already registered.");
		end
	else
		KarmaChatDebug("Failed to register WIM module.");
	end
end

KarmaObj.BrokerCallback = {};

function	KarmaObj.BrokerCallback.CQLInfo()
	local	oQueue = KarmaObj.Slash.CommandQGet();
	local	iCmdCnt = #oQueue;
	if (iCmdCnt > 0) then
		local	oNames, i = {};
		for i = 1, iCmdCnt do
			local	sName = oQueue[i].sName;
			if (sName and (sName ~= "classcheck done") and (sName ~= "classcheck done all")) then
				tinsert(oNames, sName);
			end
		end
		iCmdCnt = #oNames;

		local	sMsg = "There are " .. iCmdCnt .. " commands pending.";
		if (not IsControlKeyDown()) then
			return sMsg .. " (CTRL for tech. details)";
		end

		local	sMsgL, sMsgR;
		if (iCmdCnt > 0) then
			sMsg = sMsg .. "\nNext command ";
			local	TimeNow = GetTime();
			if (KarmaModuleLocal.Timers.CmdQ > TimeNow) then
				sMsg = sMsg .. " in " .. format("%.2f", KarmaModuleLocal.Timers.CmdQ - TimeNow) .. " seconds";
			end
			sMsg = sMsg .. " is <" .. oNames[1] .. ">";

			if (iCmdCnt > 1) then
				local	ListMax = 10;
				if (IsShiftKeyDown()) then
					ListMax = 40;
				end

				sMsgL = "";
				local	iL;
				if (iCmdCnt <= 5) then
					iL = iCmdCnt;
				else
					iL = math.min(math.ceil(1 + iCmdCnt / 2), ListMax / 2);
				end

				for i = 2, iL do
					sMsgL = sMsgL .. "\n[" .. i .. "] " .. oNames[i];
				end

				if (iL == iCmdCnt) then
				--	sMsgL = "\n[2 - " .. iL .. "]" .. sMsgL;
					sMsg = sMsg .. sMsgL;
					sMsgL = nil;
				else
					sMsgR = "";
					local	iR = math.min(iCmdCnt, (ListMax - 1));
					for i = iL + 1, iR do
						sMsgR = sMsgR .. "\n[" .. i .. "] " .. oNames[i];
					end

				--	sMsgL = "\n[2 - " .. iL .. "]" .. sMsgL;
				--	sMsgR = "\n[" .. (iL + 1) .. " - " .. iR .. ":" .. iCmdCnt .. "/" .. ListMax .. "]" .. sMsgR;

					-- cut extra newlines
					sMsgL = strsub(sMsgL, 2);
					sMsgR = strsub(sMsgR, 2);
				end
			end
		end

		return sMsg, sMsgL, sMsgR
	end
end

local	function	Karma_InitHelper(self, event, ...)
	if (KARMA_ININIT == 127) then
		return
	end

	KarmaChatDebug("INIT: " .. event .. " >> " .. KARMA_ININIT);

	local	bResult;
	if (event == "PLAYER_LOGIN") then
		-- login event, only once per UI init
		KARMA_ININIT = bit.bor(KARMA_ININIT, 4);

		bResult = true;
	elseif (event == "ADDON_LOADED") then
		local	arg1 = ...;
		KarmaModuleLocal.AddonLoaded[arg1 .. "::ADDON_LOADED"] = GetTime();
		KarmaChatDebug("INIT: " .. event .. " - " .. arg1);
		if (arg1 == "Karma") then
			KARMA_ININIT = bit.bor(KARMA_ININIT, 2);

			KarmaConfigLocal = KarmaConfig;

			-- message in error dialog:
			-- <AddOn> has been blocked because of an action only useable by Blizzard's UI.
			-- You can disactivate this addon and reload the UI.
			StaticPopupDialogs["KARMA_BLIZZARDBROKEMENUS_AGAIN"] = {
					text = KARMA_TAINT_MENU,
					button1 = "DISABLE",
					button2 = "CANCEL",
					OnAccept = function()
							KCfg.Set("MENU_DEACTIVATE", 1);
							KCfg.Set("MENU_WARN", 0);
							ReloadUI();
						end,
					OnCancel = function()
							KCfg.Set("MENU_DEACTIVATE", 0);
							KCfg.Set("MENU_WARN", 0);
						end,
					timeout = 0,
					whileDead = 1,
					hideOnEscape = 0,
					showAlert = 1,
					notClosableByLogout = 1
				};

			local	sFaction = UnitFactionGroup("player");
			if (sFaction) then
				if (not IsAddOnLoaded("KarmaDB" .. sFaction)) then
					LoadAddOn("KarmaDB" .. sFaction);
				end
			end
		elseif (strsub(arg1, 1, 7) == "KarmaDB") then
			-- faction DB
			local	sFaction = UnitFactionGroup("player");
			if (sFaction and (arg1 == "KarmaDB" .. sFaction)) then
				KARMA_ININIT = bit.bor(KARMA_ININIT, 16);
			else
				return true;
			end
		end

		bResult = true;
	elseif (event == "PLAYER_ENTERING_WORLD") then
		-- this is the event to say 'zoning'... happens on every loading screen
		KARMA_ININIT = bit.bor(KARMA_ININIT, 32);
		self:UnregisterEvent(event);

		bResult = true;
	end

	if (0 == bit.band(KARMA_ININIT, 8)) then
		if (7 == bit.band(KARMA_ININIT, 7)) then
			-- uses global config only! => silent
			Karma_SetupChatWindows(1);

			KARMA_ININIT = bit.bor(KARMA_ININIT, 8);
		end
	end

	if (0 == bit.band(KARMA_ININIT, 64)) then
		if (63 == bit.band(KARMA_ININIT, 63)) then
			Karma_QueueFullInitialise(self);

			-- register with myAddOns
			KarmaRegisterWithmyAddOns();

			-- new...
			if (KarmaConfig.WIM == 1) then
				KarmaObj.RegisterWIMModule();
			end;

			KARMA_ININIT = bit.bor(KARMA_ININIT, 64);

			-- should this be delayed until we want to send our first request?
			if (KarmaObj.Const.iTOC >= 40100) then
				RegisterAddonMessagePrefix("KARMA");
			end
		end
	end

	KarmaChatDebug("INIT: " .. event .. " << " .. KARMA_ININIT);

	return bResult;
end

function	KarmaObj.Events.RAID_ROSTER_UPDATE(self, ...)
	if (KARMA_LOADED == 1) then
		if (Karma_EverythingLoaded()) then
			if (KarmaModuleLocal.Raid.MemberCnt == 0) then
				Karma_ZoneChanged = time() + 15;
				Karma_AddZoneToPartyMember();
			end

			local	bChanged = KarmaModuleLocal.Raid.MemberCnt ~= GfTt.GetNumRaidMembersTf();
			KarmaModuleLocal.Raid.MemberCnt = GfTt.GetNumRaidMembersTf();

			if (KCfg.Get("RAID_TRACKALL") == 1) then
				Karma_AddTimeToPartyMembers(1);

				if (bChanged) then
					Karma_MemberList_ResetMemberNamesCache();
					Karma_MemberList_CreatePartyNamesCache();
					-- Karma_Queue_ReCreatePartyNamesCache();
				end
			end

			-- no args, no infos, says wowwiki
			-- KarmaChatDebug("RRU: " .. Karma_NilToString(arg1) .. "/" .. Karma_NilToString(arg2)
			--				.. "/" .. Karma_NilToString(arg3) .. "/" .. Karma_NilToString(arg4));

			local	oHistory = KarmaModuleLocal.Raid.HistoryTables[KarmaModuleLocal.Raid.iIndexHistory];
			if (oHistory == nil) then
				oHistory = {};
				KarmaModuleLocal.Raid.HistoryTables[KarmaModuleLocal.Raid.iIndexHistory] = oHistory;
			end

			if (oHistory.__Start == nil) then
				if (KarmaModuleLocal.Raid.MemberCnt > 0) then
					oHistory.__Start = time();
				end
			end

			-- need to update in any case, if people changed positions
			local	aSpeedup = KarmaModuleLocal.Raid.Name2Index;
			local	sName, value;
			for sName, value in pairs(aSpeedup) do
				value.valid = 0;
			end

			local	i, sName, iPosHyphen;
			for i = 1, MAX_RAID_MEMBERS do
				sName = GetRaidRosterInfo(i);
				if (sName) then
					iPosHyphen = strfind(sName, "-", 1, true);
					if (iPosHyphen) then
						-- BG "raids"
						sName = strsub(sName, 1, iPosHyphen - 1) .. "@" .. strsub(sName, iPosHyphen + 1);
					end
					if (oHistory[sName] == nil) then
						oHistory[sName] = {};
						oHistory[sName].Sideline = 0;
						oHistory[sName].JoinedFirst = time();
					end

					if (aSpeedup[sName] == nil) then
						aSpeedup[sName] = {};
					end

					if (aSpeedup[sName].index == nil) then
						KarmaChatDebug("RRU: " .. sName .. " joined the raid.");
						if ((oHistory[sName].Joined ~= nil) and (oHistory[sName].Left ~= nil)) then
							oHistory[sName].Sideline = oHistory[sName].Sideline + time() - oHistory[sName].Left;
						end

						oHistory[sName].Joined = time();
						oHistory[sName].Left = nil;
					end

					aSpeedup[sName].index = i;
					aSpeedup[sName].valid = 1;
				end
			end

			for sName, value in pairs(aSpeedup) do
				if (value.valid == 0) then
					KarmaChatDebug("RRU: " .. sName .. " left the raid.");
					aSpeedup[sName] = nil;

					if (oHistory[sName] == nil) then
						oHistory[sName] = {};
						oHistory[sName].Sideline = 0;
						oHistory[sName].Joined = time();
					end

					oHistory[sName].Left = time();
				end
			end

			if (bChanged and (KarmaModuleLocal.Raid.MemberCnt == 0) and
				(GfTt.GetNumPartyMembersTf() == 0) and
				(KCfg.Get("CLEAN_AUTOPVP") == 1)) then
				local	args = {};
				KSlash.CleanPvp(args);
			end

			-- left a raid, next container
			if (bChanged and (KarmaModuleLocal.Raid.MemberCnt == 0)) then
				oHistory.__End = time();
				KarmaModuleLocal.Raid.iIndexHistory = KarmaModuleLocal.Raid.iIndexHistory + 1;
			end
		end
	end
end

function	KarmaObj.Events.PARTY_MEMBERS_CHANGED(self, ...)
	if (KARMA_LOADED == 1) then
		if (Karma_EverythingLoaded()) then
			if (KARMA_QEx_NumPartyMembers < GfTt.GetNumPartyMembersTf()) then
				if (KARMA_QEx_NumPartyMembers == 0) then
					-- newly joined a party
					Karma_ZoneChanged = time() + 15;
					Karma_AddZoneToPartyMember();
				end

				KARMA_QEx_NumPartyMembers = GfTt.GetNumPartyMembersTf();
			end

			Karma_CreateQuestCache(1);
			Karma_AddTimeToPartyMembers(1);

			Karma_MemberList_ResetMemberNamesCache();
			Karma_Queue_ReCreatePartyNamesCache();

			if (KARMA_QEx_NumPartyMembers > GfTt.GetNumPartyMembersTf()) then
				-- someone left
				KARMA_QEx_NumPartyMembers = GfTt.GetNumPartyMembersTf();
				Karma_CreateQuestCache(1);
			end

			KarmaWindow_Update();
		end
	end
end

function	KarmaObj.Events.GROUP_ROSTER_UPDATE(self, ...)
	if (KARMA_LOADED == 1) then
		if (Karma_EverythingLoaded()) then
			if (IsInRaid() or (KarmaModuleLocal.Raid.MemberCnt ~= 0)) then
				KarmaChatDebug("GROUP_ROSTER_UPDATE: in raid => RAID_ROSTER_UPDATE");
				KarmaObj.Events["RAID_ROSTER_UPDATE"](self, ...);
			end
			if (IsInGroup() or (KARMA_QEx_NumPartyMembers ~= 0)) then
				KarmaChatDebug("GROUP_ROSTER_UPDATE: in group => PARTY_MEMBERS_CHANGED");
				KarmaObj.Events["PARTY_MEMBERS_CHANGED"](self, ...);
			end
		end
	end
end

function	Karma_OnEvent(self, event, ...)
	KarmaObj.ProfileStart("Karma_OnEvent");
	if (DEFAULT_CHAT_FRAME) then
		local	tEventText, iCount = event
		--[[
		for iCount = 1, 10 do
			local	av = getglobal("arg"..iCount);
			if (av and av ~= "") then
				if (av == true) then
					tEventText = tEventText.." arg"..iCount.." = true";
				elseif (av == false) then
					tEventText = tEventText.." arg"..iCount.." = false";
				else
					tEventText = tEventText.." arg"..iCount.." = "..av;
				end
			end
		end
		]]--

		-- **whole** lot of spam
		if (KARMA_ALWAYS_WATCH_EVENTS == false) then
			KarmaChatKarma(tEventText);
		else
			KarmaChatDebug(tEventText, 1.0, 0, 0.90);
		end
	end

	if (Karma_InitHelper(self, event, ...)) then
		return
	end

	if (KarmaObj.Events[event]) then
		return KarmaObj.Events[event](self, ...);
	end

	if (event == "COMBAT_LOG_EVENT_UNFILTERED") then
		local	arg1, arg2 = ...;
		if ((strsub(arg2, 1, 5) == "UNIT_") or (strsub(arg2, 1, 6) == "PARTY_")) then
			local	arg3, arg4, arg5, arg6, arg7;
			if (KarmaObj.Const.iTOC >= 40200) then
				local	hideCaster, srcRaidFlags;	-- added arg in 4.2: hideCaster
				arg1, arg2, hideCaster, arg3, arg4, arg5, srcRaidFlags, arg6, arg7 = ...;
				-- timestamp, event, hideCaster, sourceGUID, sourceName, sourceFlags, sourceRaidFlags, destGUID, destName, destFlags, destRaidFlags
			elseif (KarmaObj.Const.iTOC >= 40100) then
				local	hideCaster;	-- added arg in 4.1: hideCaster
				arg1, arg2, hideCaster, arg3, arg4, arg5, arg6, arg7 = ...;
				-- timestamp, event, hideCaster, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags
			else
				arg1, arg2, arg3, arg4, arg5, arg6, arg7 = ...;
				-- timestamp, event, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags
			end

			if (arg7 == nil) then
				arg7 = "<unknown??>";
			end

			local	bMob, sMob = false, " <p.c./pet>";
			if (arg6) then
				local	sType = strsub(arg6, 3, 5);
				local	iType = tonumber(sType, 16);
				-- mask MUST be 0x007, not 0x00F, because merged cross-language BG players can have 0x??8* GUIDs
				if (3 == bit.band(iType, 7)) then
					bMob = true;
					sMob = " <mob>";
				end
			end

			KarmaChatDebug("CLEU: " .. arg2 .. " -> " .. arg7 .. sMob);
			if (bMob) then
				KarmaModuleLocal.PlayerRegenEnabledOrMobDied = GetTime();
			end
		end
	elseif (event == "CHAT_MSG_CHANNEL") then
		Karma_ChatMsg_Channel(self, event, ...);
	elseif (event == "PLAYER_TARGET_CHANGED") then
		Karma_Event_PlayerTargetChanged();
	elseif (event == "UPDATE_MOUSEOVER_UNIT") then
		Karma_Event_UpdateMouseOverUnit();
	elseif (event == "PLAYER_XP_UPDATE") then
		if (KARMA_LOADED == 1) then
			if (Karma_EverythingLoaded()) then
				Karma_AddTimeToPartyMembers();
				Karma_AddXPToPartyMembers();
				KarmaWindow_Update();
			end
		end
	elseif (event == "CHAT_MSG_CHANNEL_NOTICE") then
		local	arg1, _2, _3, arg4, _5, _6, arg7, arg8, arg9 = ...;
		-- KarmaChatDebug("CHAT_MSG_CHANNEL_NOTICE: " .. arg1 .. " => [" .. arg7 .. "] " .. arg8 .. ". " .. arg9);

		-- arg1:
		-- - YOU_JOINED (real join or re-join after SUSPENDED)
		-- - YOU_LEFT
		-- - YOU_CHANGED (General - Darnassus => General - Teldrassil)
		-- - SUSPENDED (#Trade, #LFGuild city -> outside)
		-- arg7: type (0 = custom, 1..n = Blizzard official channel
		-- arg8: channel #
		-- arg9: channel name
		if (arg1 ~= "YOU_CHANGED") then
			local	sChanKarma = KCfg.Get("SHARE_CHANNEL_NAME");
			if (sChanKarma) then
				local	sChanKarmaLower = strlower(sChanKarma);
				if (sChanKarmaLower == strlower(arg9)) then
					KarmaChatDebug("Changes regarding Karma share channel detected: " .. arg1 .. " => [" .. arg7 .. "] #" .. arg8);
					local	oChanKarma = KarmaModuleLocal.Channels[0];
					if (oChanKarma == nil) then
						KarmaModuleLocal.Channels[0] = {};
						oChanKarma = KarmaModuleLocal.Channels[0];
						oChanKarma.NameUser  = "<internal>";
						oChanKarma.NameShort = "<internal>";
						oChanKarma.BlizzChan = 0;
						oChanKarma.Number    = nil;
					end

					if (arg1 == "YOU_LEFT") then
						oChanKarma.BlizzChan      = 0;
						oChanKarma.Number    = nil;
					elseif (arg1 == "YOU_JOINED") then
						oChanKarma.BlizzChan = arg7;
						if (oChanKarma.BlizzChan ~= 0) then
							KarmaChatDefault("INVALID communication channel <#" .. arg4 .. "> (Blizzard channel)");
							oChanKarma.Number = -1;
						else
							KarmaChatDefault("Found communication channel <#" .. arg4 .. ">");
							oChanKarma.Number = arg8;
						end
					end
				end
			end

			KarmaModuleLocal.Channels[arg8] = {};
			local	oChan = KarmaModuleLocal.Channels[arg8];
			oChan.NameUser  = arg4;
			oChan.NameShort = strlower(arg9);
			oChan.BlizzChan = arg7 or 0;
			oChan.Number    = arg8;
		end
	elseif (event == "CHAT_MSG_ADDON") then
		Karma_ChatMsg_AddOn(self, event, ...);
	elseif (event == "CHAT_MSG_SYSTEM") then
		Karma_ChatMsg_System(self, event, ...);
	elseif (strsub(event, 1, 6) == "QUEST_") then
		-- as those are all we registered starting with QUEST_, skip this longish list?
		-- does process 6 string - comparisons for every event...
		if (event == "QUEST_COMPLETE" or event == "QUEST_FINISHED" or event == "QUEST_LOG_UPDATE" or
			event == "QUEST_ITEM_UPDATE" or event == "QUEST_DETAIL" or event == "QUEST_PROGRESS" ) then
			if (KARMA_LOADED == 1) then
				if (Karma_EverythingLoaded()) then
					Karma_UpdateQuest();
					Karma_CreateQuestCache(1);
				end
			end
		end
	elseif	(event == "ZONE_CHANGED") or
		(event == "ZONE_CHANGED_INDOORS") or
		(event == "ZONE_CHANGED_NEW_AREA") then
		Karma_ZoneChanged = time();
	elseif	(event == "PLAYER_SKINNED") then
		if (Karma_ZoneChanged == 0) then
	 		KarmaChatDebug("Event: >> PLAYER_SKINNED");
			CommonRegionZoneAddCurrent(1);	-- only area you can 'skin' a player in: Alterac valley
	 		KarmaChatDebug("Event: << PLAYER_SKINNED");
		end
 	elseif (event == "INSPECT_READY") then
 		Karma_InspectTalentReady();
 	elseif (event == "INSPECT_ACHIEVEMENT_READY") then
 		local	sUnit = KarmaObj.Achievements.CheckTerrorReady();
		if (sUnit and KarmaModuleLocal.AchievementCheckTerrorList[sUnit]) then
			KarmaModuleLocal.AchievementCheckTerrorList[sUnit] = nil;
			KarmaModuleLocal.AchievementCheckTerrorCount = KarmaModuleLocal.AchievementCheckTerrorCount - 1;
			if (KarmaModuleLocal.AchievementCheckTerrorCount <= 0) then
				local	i, k, v = 0;
				for k, v in pairs(KarmaModuleLocal.AchievementCheckTerrorList) do
					i = i + 1;
				end
				KarmaModuleLocal.AchievementCheckTerrorCount = i;
				if (i == 0) then
					KarmaObj.Achievements.CheckTerrorDone(KARMA_PartyNames);
				end
			end
		end
	elseif (event == "LFG_COMPLETION_REWARD") then
		if (Karma_PlayerIsInRaid()) then
			-- not for raids, as they get already tracked above
			return
		end

		local	iCnt = GfTt.GetNumPartyMembersTf();
		if (iCnt == 0) then
			return
		end

		local	iNow = time();

		-- ensure that previous track is closed
		local	oHistory = KarmaModuleLocal.Raid.HistoryTables[KarmaModuleLocal.Raid.iIndexHistory];
		if (oHistory) then
			oHistory.__End = iNow;
		end

		-- open new track
		oHistory = { __Instance = GetRealZoneText(), __End = iNow };

		-- link to store
		KarmaModuleLocal.Raid.iIndexHistory = KarmaModuleLocal.Raid.iIndexHistory + 1;
		KarmaModuleLocal.Raid.HistoryTables[KarmaModuleLocal.Raid.iIndexHistory] = oHistory;

		local	sName, sServer, i;
		for i = 1, iCnt do
			sName, sServer = UnitName("party" .. i);
			if (sServer and (sServer ~= "")) then
				sName = sName .. "@" .. sServer;
			end

			oHistory[sName] = {};
			oHistory[sName].Sideline = 0;
			oHistory[sName].JoinedFirst = iNow;
			oHistory[sName].Joined = iNow;
			oHistory[sName].Left = iNow;

			local	oMember = KARMA_PartyNames[sName];
			if (oMember == nil) then
				oMember = Karma_MemberList_GetObject(sName);
			end
			local	oRegions;
			if (oMember) then
				-- find most recent region entry covering one minute before this point in time
				local	oPerChar = KarmaObj.DB.MC.Get(oMember, WhoAmI);
				if (oPerChar) then
					oRegions = oPerChar[KARMA_DB_L6_RRFFMCC_REGIONLIST];
				end
			end
			local	oCandidate;
			if (oRegions) then
				local	k1, oRegionDifficulty;
				for k1, oRegionDifficulty in pairs(oRegions) do
					local	k2, oDay;
					for k2, oDay in pairs(oRegionDifficulty[KARMA_DB_L7_RRFFMCCRR_PLAYEDDAYS]) do
						local	iFrom = oDay[KARMA_DB_L8_RRFFMCCRRD_START];
						local	iUntil = oDay[KARMA_DB_L8_RRFFMCCRRD_END];
						if (iUntil - iFrom > 180) then
							if (oCandidate == nil) then
								oCandidate = oDay;
							elseif (oCandidate[KARMA_DB_L8_RRFFMCCRRD_END] < iUntil) then
								oCandidate = oDay;
							end
						end
					end
				end
			end
			if (oCandidate) then
				local	iJoined = oCandidate[KARMA_DB_L8_RRFFMCCRRD_START];
				oHistory[sName].JoinedFirst = iJoined;
				oHistory[sName].Joined = iJoined;
				if (not oHistory.__Start) then
					oHistory.__Start = iJoined;
				else
					oHistory.__Start = math.min(iJoined, oHistory.__Start);
				end
			end
		end

		if (not oHistory.__Start) then
			-- TODO: store in PARTY_MEMBERS_CHANGED when we join?
			oHistory.__Start = oHistory.__End - 60;
		end
	elseif (event == "VARIABLES_LOADED") then
		KarmaModuleLocal.AddonLoaded["Karma::VARIABLES_LOADED"] = GetTime();
	elseif	(event == "PARTY_INVITE_REQUEST") or
			(event == "DUEL_REQUESTED") or
			(event == "GUILD_INVITE_REQUEST") or
			(event == "TRADE_REQUEST") then
		Karma_AutoIgnore_Invites(event);
	elseif (event == "ACHIEVEMENT_EARNED") then
		Karma_WhoAmIInit();
		KarmaObj.Achievements.Progress(KARMA_PartyNames, WhoAmI, event, ...);
	elseif (event == "PLAYER_REGEN_ENABLED") then
		KarmaModuleLocal.PlayerRegenEnabledOrMobDied = GetTime();
		self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
		KarmaChatDebug("PRE: -> +CLEU");
	elseif (event == "PLAYER_REGEN_DISABLED") then
		KarmaModuleLocal.PlayerRegenEnabledOrMobDied = nil;
		self:UnregisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
		KarmaChatDebug("PRD: -> -CLEU");
 	elseif (event == "FRIENDLIST_UPDATE") then
 		Karma_Friendlist_Update();
	elseif (event == "WHO_LIST_UPDATE") then
		KarmaModuleLocal.ExecutingWhoSince = nil;
		KarmaModuleLocal.ExecutingWhoBroken = nil;
		Karma_Who_Update(event, ...);
	elseif (event == "ADDON_ACTION_FORBIDDEN") then
		local backtrace = debugstack();
		local	arg1, arg2, arg3 = ...;
		backtrace = event .. KARMA_WINEL_FRAG_COLONSPACE .. Karma_NilToString(arg1) .. "/" .. Karma_NilToString(arg2) .. "/"
					.. Karma_NilToString(arg3) .. " => " .. backtrace;
		if (KARMA_SHOW_FORBIDDEN_IN_MAIN) then
 			KarmaChatDefault(backtrace);
 		else
 			KarmaChatDebug(backtrace);
 		end

		-- if someone tried target/focus, set a flag to warn on next start
		-- arg1: AddOn
		-- arg2: protected function
		if (arg1 == "Karma") then
			if ((arg2 == "TargetUnit()") or (arg2 == "FocusUnit()")) then
				KarmaChatDebug("Setting flag for disable-warning.");
				KCfg.Set("MENU_WARN", 1);

				-- might be too soon...
				StaticPopup_Hide("ADDON_ACTION_FORBIDDEN");
				StaticPopup_Show("KARMA_BLIZZARDBROKEMENUS_AGAIN");
			end
		end
	elseif (event == "UNIT_SPELLCAST_SUCCEEDED") then
		if (KarmaObj.Const.iTOC < 50000) then
			-- shouldn't register then
			return
		end

		-- on talent swap, rescan
		local	sUnit, sSpellName, iRank, iLineID, iSpellID = ...;
		if ((iSpellID == 63644) or (iSpellID == 63645)) then
			-- 63644: 1 => 2
			-- 63645: 2 => 1
			KarmaChatDebug("Karma_OnEvent: Spec swap by " .. sUnit .. ": " .. ((iSpellID == 63644) and "1 => 2" or "2 => 1") .. ".");
			-- might be superfluous to check both ways: TODO
			if (not UnitIsUnit(sUnit, "player") and (UnitInRaid(sUnit) or UnitInParty(sUnit))) then
				-- we might get it for player/target/focus also, re-map and only use if in group/raid
				local	sGUID, iMax, i = UnitGUID(sUnit), GetNumGroupMembers();
				local	sKey = "party";
				if (IsInRaid()) then
					sKey = "raid";
				end
				for i = 1, iMax do
					if (sGUID == UnitGUID(sKey .. i)) then
						-- TODO: store which spec was active on last scan in group
						-- TODO: if that information is available, only scan if not too old
						local	sCombined, sServer = UnitName(sKey .. i);
						if (sServer and (sServer ~= "")) then
							sCombined = sCombined .. "@" .. sServer;
						end
						local	iTime = 0;
						local	oTree = KARMA_PartyNames[sCombined] and KARMA_PartyNames[sCombined][KARMA_DB_L5_RRFFM_TALENTTREE];
						if (type(oTree) == "table") then
							local	sSpec = "S_" .. (63646 - iSpellID);
							if (oTree[sSpec]) then
								iTime = oTree[sSpec].Time;
							end
						end

						local	iNow = time();
						if (iNow - iTime) > 43200 then
							if (KARMA_TalentInspect.RequiredList[sKey .. i] == nil) then
								KarmaChatDebug("Karma_OnEvent: Queueing spec scan as " .. sUnit .. " switched their spec.");
								KARMA_TalentInspect.RequiredList[sKey .. i] = sCombined;
								KARMA_TalentInspect.RequiredCount = KARMA_TalentInspect.RequiredCount + 1;
							else
								KarmaChatDebug("Karma_OnEvent: " .. sUnit .. " already in queue to scan.");
							end
						else
							KarmaChatDebug("Karma_OnEvent: " .. sUnit .. " was scanned for this spec. recently (" .. (iNow - iTime) .. " seconds ago).");
						end
					end
				end
			end
		end
	else
		local	sArgs, sSkip, i = "", "";
		for i = 1, 10 do
			local	xVal = select(i, ...);
			if (xVal == nil) then
				sSkip = sSkip .. ", <nil>";
			else
				sArgs = sArgs .. sSkip .. ", " .. tostring(xVal);
				sSkip = "";
			end
		end
		KarmaChatDebug("Karma_OnEvent: Unhandled event " .. event .. " received, args: " .. strsub(sArgs, 3));
	end

	KarmaObj.ProfileStop("Karma_OnEvent");
end

function	Karma_EverythingLoaded()
	if (UnitName("player") ~= nil) and (UnitName("player") ~= "") then
		local	x = KarmaObj.DB.FactionCacheGet(true);
		if (x ~= nil) then
			return true;
		end
	end
	return false;
end


function	Karma_SendWho(sRequest, bResend)
	if (not FriendsFrame:IsVisible()) then
		KARMA_FriendsFrameUnregistered = 1;
		FriendsFrame:UnregisterEvent("WHO_LIST_UPDATE");

		Karma_Executing_Who = time();
		if (bResend == nil) then
			KarmaModuleLocal.ExecutingWhoSince = Karma_Executing_Who;
		end
		SetWhoToUI(1);

		KARMA_WhoRequestIsMine = 1;
		KARMA_WhoRequest = sRequest;
		SendWho(sRequest);

		KarmaChatDebug("(Re-)Sending /who <" .. sRequest .. ">... (command queue length: " .. KarmaObj.Slash.CommandQLen() .. ")");
	end;
end

--
-- HookSecureFunc etc.
--
function	Karma_HookSecureFunctions()
	hooksecurefunc("NotifyInspect", Karma_SecureHook_NotifyInspect);

	local	bChannel = false;
	local	sChan = KCfg.Get("SHARE_CHANNEL_NAME"); 
	if ((sChan ~= nil) and (sChan ~= "")) then
		bChannel = true;
	end

	if (KCfg.Get("MENU_DEACTIVATE") ~= 1) then
		KarmaChatDefault("Shortcuts to " .. KARMA_ITSELF .. " functions in context menus are ACTIVE. (If you're bothered with the taint on target/focus, you can disable this in Options/Other.)");

		UnitPopupButtons["KARMA_SPLITTER"]      = { text = "---------------", dist = 0 };
		UnitPopupButtons["KARMA_CHARADD"]       = { text = KARMA_UNITPOPUP_CHARADD, dist = 0 };
		UnitPopupButtons["KARMA_CHARDEL"]       = { text = KARMA_UNITPOPUP_CHARDEL, dist = 0 };
		UnitPopupButtons["KARMA_GIVE4"]         = { text = KARMA_ITSELF_COLONSPACE .. KARMA_UNITPOPUP_INCREASE .. "4", dist = 0 };
		UnitPopupButtons["KARMA_GIVE1"]         = { text = KARMA_ITSELF_COLONSPACE .. KARMA_UNITPOPUP_INCREASE .. "1", dist = 0 };
		UnitPopupButtons["KARMA_TAKE1"]         = { text = KARMA_ITSELF_COLONSPACE .. KARMA_UNITPOPUP_DECREASE .. "1", dist = 0 };
		UnitPopupButtons["KARMA_TAKE4"]         = { text = KARMA_ITSELF_COLONSPACE .. KARMA_UNITPOPUP_DECREASE .. "4", dist = 0 };
		UnitPopupButtons["KARMA_SELECT"]        = { text = KARMA_ITSELF_COLONSPACE .. KARMA_UNITPOPUP_SELECT, dist = 0 };
		if (IsInGuild()) then
			UnitPopupButtons["KARMA_PUBNOTE_GUILD"] = { text = KARMA_ITSELF_COLONSPACE .. KARMA_UNITPOPUP_PUBNOTE_CHECKGUILD, dist = 0 };
		end
		if (bChannel) then
			UnitPopupButtons["KARMA_PUBNOTE_CHANNEL"] = { text = KARMA_ITSELF_COLONSPACE .. KARMA_UNITPOPUP_PUBNOTE_CHECKCHANNEL, dist = 0 };
		end

		table.insert(UnitPopupMenus["PARTY"], "KARMA_SPLITTER");
		table.insert(UnitPopupMenus["PARTY"], "KARMA_GIVE4");
		table.insert(UnitPopupMenus["PARTY"], "KARMA_GIVE1");
		table.insert(UnitPopupMenus["PARTY"], "KARMA_SELECT");
		if (IsInGuild()) then
			table.insert(UnitPopupMenus["PARTY"], "KARMA_PUBNOTE_GUILD");
		end
		if (bChannel) then
			table.insert(UnitPopupMenus["PARTY"], "KARMA_PUBNOTE_CHANNEL");
		end
		table.insert(UnitPopupMenus["PARTY"], "KARMA_TAKE1");
		table.insert(UnitPopupMenus["PARTY"], "KARMA_TAKE4");

		-- target frame popup
		table.insert(UnitPopupMenus["PLAYER"], "KARMA_SPLITTER");
		table.insert(UnitPopupMenus["PLAYER"], "KARMA_CHARADD");
		table.insert(UnitPopupMenus["PLAYER"], "KARMA_GIVE4");
		table.insert(UnitPopupMenus["PLAYER"], "KARMA_GIVE1");
		table.insert(UnitPopupMenus["PLAYER"], "KARMA_SELECT");
		if (IsInGuild()) then
			table.insert(UnitPopupMenus["PLAYER"], "KARMA_PUBNOTE_GUILD");
		end
		if (bChannel) then
			table.insert(UnitPopupMenus["PLAYER"], "KARMA_PUBNOTE_CHANNEL");
		end
		table.insert(UnitPopupMenus["PLAYER"], "KARMA_TAKE1");
		table.insert(UnitPopupMenus["PLAYER"], "KARMA_TAKE4");
		table.insert(UnitPopupMenus["PLAYER"], "KARMA_CHARDEL");

		-- chat popup
		table.insert(UnitPopupMenus["FRIEND"], "KARMA_SPLITTER");
		table.insert(UnitPopupMenus["FRIEND"], "KARMA_CHARADD");
		table.insert(UnitPopupMenus["FRIEND"], "KARMA_SELECT");
		if (IsInGuild()) then
			table.insert(UnitPopupMenus["FRIEND"], "KARMA_PUBNOTE_GUILD");
		end
		if (bChannel) then
			table.insert(UnitPopupMenus["FRIEND"], "KARMA_PUBNOTE_CHANNEL");
		end

		hooksecurefunc("UnitPopup_OnClick", Karma_SecureHook_UnitPopup_OnClick);
	end

	-- new /who handling
	hooksecurefunc(FriendsFrame, "Show", Karma_SecureHook_FriendsFrame_OnShow);
	hooksecurefunc(FriendsFrame, "Hide", Karma_SecureHook_FriendsFrame_OnHide);
	hooksecurefunc("SendWho", Karma_SecureHook_SendWho);

	-- inspect protection...
	hooksecurefunc("InspectUnit", Karma_SecureHook_InspectUnit);

	-- "discovered: <foo>" handling
	hooksecurefunc(UIErrorsFrame, "AddMessage", Karma_SecureHook_UIErrorsFrame_AddMessage);

	if (KCfg.Get("MARKUP_VERSION") >= 2) then
		if (KCfg.Get("MARKUP_VERSION") >= 3) then
			KarmaChatSecondaryFallbackDefault("Newest version of feature 'chat markup' is active.");
			-- overwriting ChatFrame.lua::GetColoredName()
			GetColoredName = KOH.GetColoredName;
			KarmaObj.UI.Chatfilters = KarmaModuleLocal.ChatFilters;
		else
			KarmaChatSecondaryFallbackDefault("New version of feature 'chat markup' is active.");
		end

		-- going for filter function instead of hooking:
		KarmaModuleLocal.ChatFilters.Install();
		hooksecurefunc("ChatFrame_AddMessageEventFilter", Karma_SecureHook_ChatFrame_AddMessageEventFilter);
	end

	-- friend list
	local	i = 0;
	repeat
		i = i + 1;
		oFrame = _G["FriendsFrameFriendsScrollFrameButton" .. i];
		if (oFrame) then
			oFrame:HookScript("OnEnter", Karma_SecureHook_FriendsFrameTooltip_Show);
		end
	until (not oFrame);

	-- ignore list: not currently setup with a handler at all, no tip
	local	i, oFrame, oScript;
	for i = 2, 19 do
		oFrame = _G["FriendsFrameIgnoreButton" .. i];
		oFrame:HookScript("OnEnter", KarmaWindow_Showtip);
		oFrame:HookScript("OnLeave", GameTooltip_Hide);
--[[
		oScript = oFrame:GetScript("OnEnter");
		if (type(oScript) == "function") then
			oFrame:HookScript("OnEnter", KarmaWindow_Showtip);
		else
			oFrame:SetScript("OnEnter", KarmaWindow_Showtip);
		end

		oScript = oFrame:GetScript("OnLeave");
		if (type(oScript) == "function") then
			oFrame:HookScript("OnLeave", GameTooltip_Hide);
		else
			oFrame:SetScript("OnLeave", GameTooltip_Hide);
		end
]]--
	end

	local	fAreaIDInvalidate = function(selfOrNil) KarmaModuleLocal.RegionsByAreaID.Valid = false; KarmaChatDebug("Invalidated map area: " .. ((selfOrNil == nil) and "PlayerToZone" or "MapShow")); end;
	hooksecurefunc("SetMapToCurrentZone",  fAreaIDInvalidate);
	hooksecurefunc("WorldMapFrame_OnShow", fAreaIDInvalidate);

	-- tooltip for Unit frame & LFG/LFM
	Karma_HookTip();
end

---
----
---

function	Karma_SecureHook_NotifyInspect(UnitID)
	KarmaChatDebug("NotifyInspect-Hook: " .. Karma_NilToString(UnitID) .. " (state = " .. (KARMA_TalentInspect.StateCurrent or "nil")
			.. ", nicc = " .. KARMA_TalentInspect.NotifyInspectCallCount .. ")");
	KARMA_TalentInspect.NotifyInspectCallCount = KARMA_TalentInspect.NotifyInspectCallCount + 1;
	KARMA_TalentInspect.RequestedUnitInventoryIncomplete = nil;
	if (KARMA_TalentInspect.StateCurrent >= 1) and
	   (KARMA_TalentInspect.StateCurrent <= 4) then
		local	Entry = {};
		Entry.Time = time();
		Entry.Unit = UnitID;
		tinsert(KARMA_TalentInspect.NotifyInspectCallList, Entry);
	end
end


function	Karma_SecureHook_UnitPopup_OnClick(self)
	local	dropdownFrame = UIDROPDOWNMENU_INIT_MENU;
	local	ddF_Unit, ddF_Name, ddF_Server;
	if (dropdownFrame) then
		ddF_Unit   = dropdownFrame.unit;
		ddF_Name   = dropdownFrame.name;
		ddF_Server = dropdownFrame.server;
	end

-- KarmaChatDebug("Karma_SecureHook_UnitPopup_OnClick: self.value = " .. Karma_NilToString(self.value) .. ", ddF_Unit = " .. Karma_NilToString(ddF_Unit));

	if (self and (type(self.value) == "string")) then
		if (strsub(self.value, 1, 6) == "KARMA_") then
			local	sName, sServer;
			if (ddF_Unit ~= nil) then
				sName, sServer = UnitName(ddF_Unit);
				if (sServer and (sServer ~= "")) then
					sName = sName .. "@" .. sServer;
				end
			else
				KarmaChatDebug("No unit given... trying name/server = " .. (ddF_Name or "<nil>") .. " @ " .. (ddF_Server or "<nil>"));
				sName   = ddF_Name;
				sServer = ddF_Server;
				--[[
				if (sNAme == nil) and (dropdownFrame ~= nil) then
					local	k, v;
					for k, v in pairs(dropdownFrame) do
						if (type(v) == "string") then
							KarmaChatDebug("-> [" .. k .. "] = " .. v);
						else
							KarmaChatDebug("-> [" .. k .. "] = <" .. type(v) .. ">");
						end
					end
				end
				]]--
			end

			if (sName) then
				if (strsub(self.value, 7, 10) == "GIVE") then
					local	Num = tonumber(strsub(self.value, 11));
					if (Num) then
						local newval = Karma_IncreaseKarma(sName, true, Num);
						if (newval == nil) then
							KarmaChatDefault(KARMA_MSG_NOTONKARMASLIST1 .. sName .. KARMA_WINEL_FRAG_COLONSPACE .. KARMA_MSG_NOTONKARMASLIST2);
						end
					end
				elseif (strsub(self.value, 7, 10) == "TAKE") then
					local	Num = tonumber(strsub(self.value, 11));
					if (Num) then
						local newval = Karma_DecreaseKarma(sName, true, Num);
						if (newval == nil) then
							KarmaChatDefault(KARMA_MSG_NOTONKARMASLIST1 .. sName .. KARMA_WINEL_FRAG_COLONSPACE .. KARMA_MSG_NOTONKARMASLIST2);
						end
					end
				elseif (strsub(self.value, 7, 13) == "CHARADD") then
					local	args = {};
					args[2] = sName;
					KSlash.Add(args);
				elseif (strsub(self.value, 7, 13) == "CHARDEL") then
					local	args = {};
					args[2] = sName;
					KSlash.Rem(args);
				elseif (strsub(self.value, 7, 13) == "SELECT") then
					if (KARMA_CURRENTMEMBER ~= sName) then
						Karma_SetCurrentMember(sName);
						if (KARMA_CURRENTMEMBER == sName) then
							KarmaWindow_ScrollToCurrentMember();
							KarmaChatDefault("Currently selected member in Karma window set to >" .. sName .. "<");
						else
							KarmaChatDefault(KARMA_MSG_NOTONKARMASLIST1 .. sName .. KARMA_WINEL_FRAG_COLONSPACE .. KARMA_MSG_NOTONKARMASLIST2);
						end
					else
						KarmaWindow_ScrollToCurrentMember();
					end
				elseif (strsub(self.value, 7, 20) == "PUBNOTE_GUILD") then
					if (IsInGuild()) then
						if (GetNumGuildMembers() > 1) then
							local	args = {};
							args[2] = "$GUILD";
							args[3] = sName;
							-- "?p" - request
							KSlash.ShareQuery(args, 3);
						else
							KarmaChatDefault("You're the only guild member online to query about " .. sName .. "... (At least that's what the UI claims. Did you open your social frame yet?)");
						end
					else
						KarmaChatDefault("You have to join a guild first to ask them about " .. sName .. "...");
					end
				elseif (strsub(self.value, 7, 22) == "PUBNOTE_CHANNEL") then
					local	args = {};
					args[2] = "#";
					args[3] = sName;
					-- "?p" - request
					KSlash.ShareQuery(args, 3);
				end
			end

			KarmaWindow_Update();
		end
	end
end


function	Karma_SecureHook_FriendsFrame_OnShow(self)
	KARMA_FriendsFrameVisible = 1;
	if (Karma_WhoQueue[1] ~= nil) then
		local Msg = "Social frame openend. Stopping /who requests.";
		if (KARMA_FriendsFrameUnregistered == 1) then
			KARMA_FriendsFrameUnregistered = 0;
			FriendsFrame:RegisterEvent("WHO_LIST_UPDATE");
			Msg = Msg .. " Reregistering /who result check.";
		end;
		KarmaChatDefault(Msg);
	end;
end;

function	Karma_SecureHook_FriendsFrame_OnHide()
	KARMA_FriendsFrameVisible = 0;
	if (Karma_WhoQueue[1] ~= nil) then
		KarmaChatSecondary("Social frame closed. Resuming pending /who requests...");
	end;
end;


function	Karma_SecureHook_SendWho(sRequest)
	if (sRequest ~= KARMA_WhoRequest) then
		KARMA_WhoRequestIsMine = 0;
		Karma_Executing_Who = time() + 30;
		if (KARMA_FriendsFrameUnregistered == 1) then
			KARMA_FriendsFrameUnregistered = 0;
			FriendsFrame:RegisterEvent("WHO_LIST_UPDATE");
			KarmaChatDefault("Alternate /who request. Restoring update to /who frame. (You probably have to repeat your /who. Sorry!)");
			KarmaChatDebug("Alternate /who request: calltrace >>" .. debugstack());
		end
	end
end


function	Karma_SecureHook_InspectUnit(sUnit)
	KARMA_InspectByUser.At = time();
	KARMA_InspectByUser.Who = sUnit;
end

function	Karma_SecureHook_UIErrorsFrame_AddMessage(self, message, red, green, blue, alpha)
	-- UIErrorsFrame gets this one:
	-- FrameXML/GlobalStrings.lua:ERR_ZONE_EXPLORED = "Discovered: %s";
	-- ChatWindow gets this one: (or upper if no xp)
	-- FrameXML/GlobalStrings.lua:ERR_ZONE_EXPLORED_XP = "Discovered %s: %d experience gained";

	if (KarmaModuleLocal.PatternZoneExplored == nil) then
		KarmaModuleLocal.PatternZoneExplored = string.gsub(ERR_ZONE_EXPLORED, "(%%s)", "(.+)");
	end

	if (not alpha) then
		alpha = 1.0;
	end
	if (not red) then
		red = 1.0;
	end
	if (not green) then
		green = 1.0;
	end
	if (not blue) then
		blue = 1.0;
	end

	-- we want 1, 1, 0 - but that's floating point
	if (red < 0.99) or (green < 0.99) or (blue > 0.01) then
		return
	end

	KarmaChatDebug("SH(UIEF:AM) -> message: " .. message .. " (pattern <" .. KarmaModuleLocal.PatternZoneExplored .. ">) - alpha, rgb " .. alpha .. " - " .. red .. "/" .. green .. "/" .. blue);

	local	first, last, zone = strfind(message, KarmaModuleLocal.PatternZoneExplored);
	if (first and last and (zone == GetSubZoneText())) then
		-- check callstack?

		local	ZID = CommonRegionZoneAddCurrent();
		if (ZID) then
			local	globalZones = CommonZoneListGet();
			if (globalZones[ZID].Name ~= zone) then
				KarmaChatSecondary("Internal error, area <" .. zone .. "> not found. :(");
				KarmaChatDebug("SH(UIEF:AM) -> returned zone was <" .. (globalZones[ZID].Name or "nil") .. "> ?!");
				return
			end

			SetMapToCurrentZone();
			local posX, posY = GetPlayerMapPosition("player");
			if (posX and (posX ~= 0) and posY and (posY ~= 0)) then
				if (globalZones[ZID].PosX == nil) or (globalZones[ZID].PosY == nil) then
					globalZones[ZID].PosSumX = 0;
					globalZones[ZID].PosSumY = 0;
					globalZones[ZID].PosSumCnt = 0;
				end

				globalZones[ZID].PosSumX = globalZones[ZID].PosSumX + posX;
				globalZones[ZID].PosSumY = globalZones[ZID].PosSumX + posY;
				globalZones[ZID].PosSumCnt = globalZones[ZID].PosSumCnt + 1;

				globalZones[ZID].PosX = globalZones[ZID].PosSumX / globalZones[ZID].PosSumCnt;
				globalZones[ZID].PosY = globalZones[ZID].PosSumY / globalZones[ZID].PosSumCnt;
			end

			if (GfTt.GetNumPartyMembersTf() > 0) or
                           (KCfg.Get("RAID_TRACKALL") == 1) and Karma_PlayerIsInRaid() then
				local	iMax, sBase;
				if (Karma_PlayerIsInRaid()) then
					if (KCfg.Get("RAID_TRACKALL") == 1) then
						iMax = GfTt.GetNumRaidMembersTf();
						sBase = "raid";
					else
						KarmaChatDebug("New area discovered: <" .. zone .. "> -- tracking in raid is OFF.");
						return
					end
				else
					iMax = GfTt.GetNumPartyMembersTf();
					sBase = "party";
				end

				KarmaChatSecondary("New area discovered: <" .. zone .. "> -- adding to group/raid.");

				-- we ignore distance here - all in the party shall count, even across the world
				local	i;
				for i = 1, iMax do
					local	sName, sServer = UnitName(sBase .. i);
					local	oMember = Karma_MemberList_GetObject(sName, sServer);
					if (oMember) then
						local	oMemPerChar = KarmaObj.DB.MC.GetPlayer(oMember);
						if (oMemPerChar) then
							KOH.TableInit(oMemPerChar, "EXPLORED_FIRST_TIME");
							oMemPerChar["EXPLORED_FIRST_TIME"]["Z" .. ZID] = time();
						end
					end
				end
			else
				KarmaChatDebug("New area discovered: <" .. zone .. "> -- would add to group if you were in one...");
			end
		end
	end
end

function	KarmaModuleLocal.ChatFilters.Install()
	local	sEvent, oFilter;
	for sEvent, oFilter in pairs(KarmaModuleLocal.ChatFilters) do
		if (type(oFilter) == "table") then
			ChatFrame_AddMessageEventFilter(sEvent, oFilter.fFilter);
		end
	end
end

function	Karma_SecureHook_ChatFrame_AddMessageEventFilter(event, func)
	-- if it is an event we track, and func is not ours, remove and reinsert us to get into last position again
	if (KarmaModuleLocal.ChatFilters[event]) then
		local	oFilter = KarmaModuleLocal.ChatFilters[event]; 
		if (oFilter.bRedo) then
			if (func ~= oFilter.fFilter) then
				ChatFrame_RemoveMessageEventFilter(event, oFilter.fFilter);
				ChatFrame_AddMessageEventFilter(event, oFilter.fFilter);
			end
		end
	end
end

function	Karma_SecureHook_FriendsFrameTooltip_Show(oButton)
	if (oButton.buttonType == FRIENDS_BUTTON_TYPE_WOW) then
		local name, level, class, area, connected, status, noteText = GetFriendInfo(oButton.id);
		if (not connected) then
			local	oMember = Karma_MemberList_GetObject(name);
			if (oMember) then
				level = Karma_MemberObject_GetLevel(oMember);
				class = Karma_MemberObject_GetClass(oMember);
				if (level and class) then
					FriendsTooltipToon1Name:Show();
					FriendsFrameTooltip_SetLine(FriendsTooltipToon1Name, nil, string.format(FRIENDS_LEVEL_TEMPLATE, level, class));
					-- anchor = FriendsFrameTooltip_SetLine(FriendsTooltipToon1Info, nil, area);

					local	iJoined = Karma_MemberObject_GetTimeJoinedTimeTotal(oMember);
					local	iUpdated = Karma_MemberObject_GetTimestampSuccess(oMember);
					local	iOnline = math.max(iJoined or 0, iUpdated or 0);
					if (iOnline > 0) then
						FriendsTooltipToon1Info:Show();
						FriendsFrameTooltip_SetLine(FriendsTooltipToon1Info, nil, date("Looked up/Joined: " .. KARMA_DATEFORMAT .. " %H:%M", iOnline));
					end

					FriendsTooltip:SetHeight(FriendsTooltip.height + FRIENDS_TOOLTIP_MARGIN_WIDTH);
					FriendsTooltip:SetWidth(min(FRIENDS_TOOLTIP_MAX_WIDTH, FriendsTooltip.maxWidth + FRIENDS_TOOLTIP_MARGIN_WIDTH));
					FriendsTooltip:Show();
				end
			end
		end
	end
end

--
---
--
function	Karma_HookTip()
	-- dead-ugly, thanks to Blizzard:
	-- - SetUnit is NOT called on character images themselves
	-- - UnitColor is NOT called on calls to SetUnit via XPerl (bars, animated head)
	-- - both fire on unitframe::title
	-- so, neither function hook suffices and sometimes *both* are called - well done, Blizzard!
	hooksecurefunc(GameTooltip, "SetUnit", Karma_SecureHook_GameTooltip_SetUnit);
	hooksecurefunc("GameTooltip_UnitColor", Karma_SecureHook_GameTooltip_UnitColor);

	-- hooks to support LFG/LFM notes
	hooksecurefunc(GameTooltip, "SetOwner", Karma_SecureHook_GameTooltip_SetOwner);
	hooksecurefunc(GameTooltip, "AddLine", Karma_SecureHook_GameTooltip_AddLine);

	if (type(LFMButton_OnClick) == "function") then
		-- not anymore in 3.3
		hooksecurefunc("LFMButton_OnClick", Karma_SecureHook_LFMFrameButton_OnClick);
	end
end

function	Karma_SecureHook_GameTooltip_SetUnit(self, sUnit)
	if (sUnit == nil) then
		sUnit = "<none>";
	else
		if (UnitExists(sUnit) and UnitIsPlayer(sUnit) and UnitIsFriend(sUnit, "player")) then
			if (KarmaModuleLocal.GameTooltipUnit ~= nil) then
				return
			end
			KarmaModuleLocal.GameTooltipUnit = sUnit .. "::" .. UnitName(sUnit);

			KarmaChatDebug("KSH_GTT:SU(" .. sUnit .. ")");
			local	TT_Added = Karma_AddTip(sUnit);
			if (TT_Added) then
				GameTooltip:Show();

				-- the color gets lost for reasons completely unknown (UnitColor-Hook doesn't need self!)
				-- => refresh it
				getglobal(self:GetName().."TextLeft1"):SetTextColor(GameTooltip_UnitColor(sUnit, true));
			end
		end
	end

	KarmaChatDebug("SH(GT:SU) -> unit " .. sUnit);
end

function	Karma_SecureHook_GameTooltip_UnitColor(sUnit, bSelfCall)
	if (bSelfCall) then
		-- call from GameTooltip_SetUnit - hook above
		KarmaChatDebug("SH(GT:UC) selfcall -> unit " .. sUnit);
		return
	end

	if (UnitExists(sUnit) and UnitIsPlayer(sUnit) and UnitIsFriend(sUnit, "player")) then
		if (KarmaModuleLocal.GameTooltipUnit ~= nil) then
			return
		end
		KarmaModuleLocal.GameTooltipUnit = sUnit .. "::" .. UnitName(sUnit);

		KarmaChatDebug("KSH_GTT:UC(" .. sUnit .. ")");
		local	TT_Added = Karma_AddTip(sUnit);
		if (TT_Added) then
			GameTooltip:Show();
		end
	end
end

local	KARMA_GameTooltipLFM = {
			LFMFrameButtonXIsOwner = 0,
			NameCount = 0,
			Name = "",
			Notes = ""
	};

function	Karma_SecureHook_GameTooltip_SetOwner(self, oFrame, sAnchor, dx, dy)
	KarmaModuleLocal.GameTooltipUnit = nil;

	local	sFrame;
	if ((oFrame) and (type(oFrame) == "table") and
		(oFrame.GetName) and (type(oFrame.GetName) == "function")) then
		sFrame = oFrame:GetName();
	end
	-- strange AddOns call this with a oFrame object that returns *nil* to GetName()! (WIM)
	if (sFrame == nil) or (sFrame == "") then
		sFrame = "<none>";
	end

	if (sAnchor == nil) then
		sAnchor = "<none>";
	end

--	KarmaChatDebug("SH(GT:SO) -> frame " .. sFrame .. ", anchor " .. sAnchor);
	if (strsub(sFrame, 1, 14) == "LFMFrameButton") then
		KARMA_GameTooltipLFM.LFMFrameButtonXIsOwner = 1;
		KARMA_GameTooltipLFM.NameCount = 0;
		KARMA_GameTooltipLFM.Name = "";
		KARMA_GameTooltipLFM.Notes = "";
		KARMA_GameTooltipLFM.Texture = oFrame.partyMembers and (oFrame.partyMembers > 0);
	else
		KARMA_GameTooltipLFM.LFMFrameButtonXIsOwner = 0;
	end
end

function	Karma_SecureHook_GameTooltip_AddLine(self, sText, red, green, blue, bWrap)
	if (sText == nil) or (sText == "") then
--		KarmaChatDebug("SH(GT:AL) -> line <empty>");
		return;
	end

--	KarmaChatDebug("SH(GT:AL) -> line " .. sText .. ", first byte " .. string.byte(sText, 1));

	-- the zones and note of the player are starting with a newline
	local	iByte = string.byte(sText, 1);
	if (KARMA_GameTooltipLFM.LFMFrameButtonXIsOwner == 1) and (iByte ~= 10) and (iByte ~= 32) then
		local	iMinusPos = strfind(sText, '-', 1, true);
		if (iMinusPos) then
			local	iSpacePos = strfind(sText, ' ', 1, true);
			if (iSpacePos) then
				local	sName = strsub(sText, 1, iSpacePos - 1);
--				KarmaChatDebug("SH(GT:AL) -> -> name " .. sName);
				local	oMember = Karma_MemberList_GetObject(sName);
				if (oMember) then
					local	iKarma = Karma_MemberObject_GetKarmaModified(oMember);
					if (iKarma) then
						local	sInfo = "";
						local	sKarma = Karma_MemberObject_GetKarmaWithModifiers(oMember);
						if (iKarma ~= 50) then
							sInfo = sInfo .. " " .. sKarma;
						end
						local	sNotes = Karma_MemberObject_GetNotes(oMember);
						if (sNotes and (sNotes ~= "")) then
							sInfo = sInfo .. " (+ Note)";
						end

						if (sInfo ~= "") then
							KARMA_GameTooltipLFM.NameCount = KARMA_GameTooltipLFM.NameCount + 1;
							KARMA_GameTooltipLFM.Name = sName;
							local	sExtract = KOH.ExtractHeader(sNotes);
							KARMA_GameTooltipLFM.Notes = KARMA_GameTooltipLFM.Notes .. "\n" .. KOH.Name2Clickable(sName)
								.. "{" .. Karma_MemberObject_GetKarmaModifiedForListWithColors(oMember) .. "}:\n" .. sExtract;

							if (KCfg.Get("TOOLTIP_LFMADDKARMA") == 1) then
								--[[
								local	KRed, KGreen, KBlue = Karma_Karma2Color(math.min(100, iKarma));
								if (KARMA_GameTooltipLFM.Texture) then
									-- add bogus texture (as in FrameXML/LFGFrame.lua)
									-- this has to be in kinda reverse order compared to there:
									-- the 'outside' AddTexture matches our line, so we match the already added line we got tripped from
									GameTooltip:AddTexture("");
								end
								GameTooltip:AddDoubleLine("", "Karma: " .. sInfo, nil, nil, nil, KRed, KGreen, KBlue);
								-- GameTooltip:AddLine("-- Karma: " .. sInfo, KRed, KGreen, KBlue);
								]]--

								local	iLine = GameTooltip:NumLines();
								local	oText = _G["GameTooltipTextLeft" .. iLine];
								if (oText) then
									local	sText = oText:GetText();
									local	iPos = strfind(sText, " ");
									local	sInfo = KarmaModuleLocal.ChatFilters.MarkupSender("", oMember);
									-- there is no color given, so we overwrite with bright yellow in the hopes that the common yellow is used
									sText = "|cFFFFFF40" .. strsub(sText, 1, iPos - 1) .. "|r" .. sInfo .. strsub(sText, iPos);
									oText:SetText(sText);
								end
							end

--							KarmaChatDebug("SH(GT:AL) -> -> -> Info " .. sInfo);
						end
					end
				end
			end
		end
	end
end

function	Karma_SecureHook_LFMFrameButton_OnClick()
	if (KARMA_GameTooltipLFM.Notes ~= "") then
		KarmaChatSecondary(KARMA_GameTooltipLFM.Notes);
		if (KARMA_GameTooltipLFM.NameCount == 1) then
			local	bShiftPressed = IsShiftKeyDown();
			if (bShiftPressed) then
				Karma_SetCurrentMember(KARMA_GameTooltipLFM.Name);
			end
		end
	end
end

---
----
---

local	function	Karma_TalentsRead()
	local	Entry = {};
	Entry["Time"] = time();

	if (KarmaObj.Const.iTOC < 50000) then
		local	iNumSpecs = 1;
		if (KarmaObj.Const.iTOC >= 30100) then
			iNumSpecs = GetNumTalentGroups(true);
		end

		local	iNumTabs = GetNumTalentTabs(true);
		local	iSpec, iTab, iID, sName, sIconTexture, iPointsSpent, sBackground, sTab;
		for iSpec = 1, iNumSpecs do
			for iTab = 1, iNumTabs do
				if (KarmaObj.Const.iTOC >= 40000) then
					-- Cataclysm: additional arguments added NOT at the end :-(
					iID, sName, sDesc, sIconTexture, iPointsSpent, sBackground = GetTalentTabInfo(iTab, true, false, iSpec);
				else
					sName, sIconTexture, iPointsSpent, sBackground = GetTalentTabInfo(iTab, true, false, iSpec);
				end

				if (sName) then
					sTab = "T_" .. tostring(iSpec) .. "_" .. tostring(iTab);
					KarmaChatDebug("Spec[" .. tostring(iSpec) .. "].Talents[" .. tostring(sTab) .. "] = " .. tostring(sName) .. " has " .. tostring(iPointsSpent) .. " points.");

					Entry[sTab] = {};
					Entry[sTab].Name = sName;
					Entry[sTab].Points = iPointsSpent;
					KarmaChatDebug("Spec[" .. iSpec .. "].Talents[" .. sTab .. "] = " .. sName .. " has " .. iPointsSpent .. " points.");
				end
			end
		end

		tinsert(KARMA_TalentInspect.TalentsReadyCallList, Entry);
		return true;
	else
		local	iSpecID = GetInspectSpecialization(KARMA_TalentInspect.RequestedUnit);
		if (iSpecID ~= nil and iSpecID > 0) then
			local	iSpec;
			-- GetActiveSpecGroup(true) is broken, or at least highly unreliable (always #1)
			-- so, replace the older spec. that' different
			local	oMember = Karma_MemberList_GetObject(KARMA_TalentInspect.RequestedMember);
			if (oMember) then
				local	oTree = oMember[KARMA_DB_L5_RRFFM_TALENTTREE] or {};
				local	iTime1, iTime2 = 0, 0;
				if (oTree.S_1) then
					iTime1 = oTree.S_1.Time or 0;
					if (oTree.S_1.Spec == iSpecID) then
						-- already stored as spec 1
						iSpec = 1;
					end
				end
				if (oTree.S_2) then
					iTime2 = oTree.S_2.Time or 0;
					if (oTree.S_2.Spec == iSpecID) then
						-- already stored as spec 2
						iSpec = 2;
					end
				end
				if (iSpec == nil) then
					-- not stored yet, replace older stored spec
					if (iTime1 <= iTime2) then
						iSpec = 1;
					else
						iSpec = 2;
					end
				end

				local	sSpec = "S_" .. tostring(iSpec);
				Entry[sSpec] = {};
				Entry[sSpec].Spec = iSpecID;
				Entry[sSpec].Time = Entry["Time"];

				local	sClassLocale, sClassEN = UnitClass(KARMA_TalentInspect.RequestedUnit);
				local	oInfo = KarmaObj.DB.CG.LocaleTalentGet(iSpecID, sClassEN);

				local	sName = UnitName(KARMA_TalentInspect.RequestedUnit);
				KarmaChatDebug("Karma_TalentsRead: " .. sName .. "[" .. iSpec .. "] = " .. iSpecID .. " (" .. oInfo.Name .. ")"); 

				tinsert(KARMA_TalentInspect.TalentsReadyCallList, Entry);
				return true;
			end
		end
	end

	return false;
end

function	Karma_InspectTalentReady()
	KarmaChatDebug("[Talentscan] ITR time = " .. date("%H:%M:%S", time()) .. " (state = " .. (KARMA_TalentInspect.StateCurrent or "nil") .. ")");
	KARMA_TalentInspect.TalentsReadyCallCount = KARMA_TalentInspect.TalentsReadyCallCount + 1;
	if (KARMA_TalentInspect.StateCurrent >= 1) and
	   (KARMA_TalentInspect.StateCurrent <= 3) then
		Karma_TalentsRead();
	end
end

function	Karma_AutofetchTalents()
	-- 4 states:
	-- state 0: if queue empty, do nothing, else reset states and switch to state 1
	-- state 1: register event, wait 10 seconds
	-- state 2: send NotifyInspect, switch to state 3
	-- state 3: wait for first reply + 10 seconds, then switch to state 4
	-- state 4: unregister event, if *one* NotifyInspect and *one* InspectTalentReady* then accept scan, go to state 0

	if (DebugMsgState == nil) then
		DebugMsgState = KARMA_TalentInspect.StateCurrent;
	end
	if (DebugMsgState ~= KARMA_TalentInspect.StateCurrent) then
		KarmaChatDebug("[Talentscan] [" .. tostring(time() % 60) .. "] state " .. Karma_NilToString(DebugMsgState)
			.. " => " ..  Karma_NilToString(KARMA_TalentInspect.StateCurrent));
		DebugMsgState = KARMA_TalentInspect.StateCurrent;
	end

	-- state 0: if queue empty, do nothing, else switch to state 0
	if (KARMA_TalentInspect.StateCurrent == 0) then
		-- default case: nothing to do
		if (KARMA_TalentInspect.RequiredCount == 0) then
			return
		end

		if (KARMA_InspectByUser.At ~= nil) then
			if (time() - KARMA_InspectByUser.At < 120) then
				return
			end

			KARMA_InspectByUser.At = nil;
		end

		if (KARMA_TalentInspect.AutofetchConfigCache == nil) then
			KARMA_TalentInspect.AutofetchConfigCache = KCfg.Get("TALENTS_AUTOFETCH");
			if (KARMA_TalentInspect.AutofetchConfigCache == nil) then
				KARMA_TalentInspect.AutofetchConfigCache = 1;
				KCfg.Set("TALENTS_AUTOFETCH", KARMA_TalentInspect.AutofetchConfigCache)
				KarmaChatSecondary("Talent scanning in background: setting default state of 'enabled'. Disable with '" .. KARMA_CMDSELF .. " autochecktalents' (or via ConfigUI).");
			end
		end

		if (KARMA_TalentInspect.AutofetchConfigCache ~= 1) then
			return
		end

		-- ok, select a unit, switch to state 1
		local	sUnit, sName, sChoiceUnit, sChoiceName;
		for sUnit, sName in pairs(KARMA_TalentInspect.RequiredList) do
			if (CheckInteractDistance(sUnit, 1) == 1) then
				sChoiceUnit = sUnit;
				sChoiceName = sName;
			end
		end

		if (sChoiceUnit) then
			local	sUnit2Name, sUnit2Server;
			if (UnitIsPlayer(sChoiceUnit)) then
				sUnit2Name, sUnit2Server = UnitName(sChoiceUnit);
				if (sUnit2Server) and (sUnit2Server ~= "") then
					sUnit2Name = sUnit2Name .. "@" .. sUnit2Server;
				end
			end
			if (sUnit2Name == nil) or (sUnit2Name ~= sChoiceName) then
				KarmaChatDebug("[Talentscan] Unit(" .. sChoiceUnit .. ") changed, removing from talent autofetch queue...");
				KARMA_TalentInspect.RequiredList[sChoiceUnit] = nil;
				sChoiceUnit = nil;

				local	i, key, value;
				i = 0;
				for key, value in pairs(KARMA_TalentInspect.RequiredList) do
					i = i + 1;
				end
				KARMA_TalentInspect.RequiredCount = i;
			end
		end

		if (sChoiceUnit) then
			KARMA_TalentInspect.RequestedUnit   = sChoiceUnit;
			KARMA_TalentInspect.RequestedMember = sChoiceName;
			KARMA_TalentInspect.RequestedGUID   = UnitGUID(sChoiceUnit);
			KarmaChatDebug("[Talentscan] Selected Unit(" .. KARMA_TalentInspect.RequestedUnit .. ") = " .. KARMA_TalentInspect.RequestedMember);

			KARMA_TalentInspect.State1Time = nil;
			KARMA_TalentInspect.State2Time = nil;
			KARMA_TalentInspect.State3Time = nil;
			KARMA_TalentInspect.State4Time = nil;
	
			KARMA_TalentInspect.NotifyInspectCallCount = 0;
			KARMA_TalentInspect.NotifyInspectCallList = {};
			KARMA_TalentInspect.TalentsReadyCallCount = 0;
			KARMA_TalentInspect.TalentsReadyCallList = {};
	
			KARMA_TalentInspect.StateCurrent = 1;

			-- since the event fails to deliver all too often... try to get around without depending on it
			ClearInspectPlayer();
		end
	elseif (KARMA_TalentInspect.StateCurrent == 1) then
		if (KARMA_TalentInspect.State1Time == nil) then
			if (not Karma:IsEventRegistered("INSPECT_READY")) then
				Karma:RegisterEvent("INSPECT_READY");
				KarmaChatDebug("[Talentscan] [1] Event registered.");
			else
				KarmaChatDebug("[Talentscan] [1] Event still registered?");
			end

			KARMA_TalentInspect.State1Time = time();
		elseif ((time() - KARMA_TalentInspect.State1Time) > 8) then
			KARMA_TalentInspect.StateCurrent = 2;
		end
	elseif (KARMA_TalentInspect.StateCurrent == 2) then
		KarmaChatDebug("[Talentscan] [2] Checking unit for validity...");
		KARMA_TalentInspect.State2Time = time();
		if  (KARMA_InspectByUser.At == nil) and
			(UnitIsPlayer(KARMA_TalentInspect.RequestedUnit) and
			(KARMA_TalentInspect.RequestedGUID == UnitGUID(KARMA_TalentInspect.RequestedUnit))) then
			-- CanInspect(<unit>, <true: show error message>)
			if (CanInspect(KARMA_TalentInspect.RequestedUnit)) then
				if (not Karma:IsEventRegistered("INSPECT_READY")) then
					KarmaChatDebug("[Talentscan] [2] Event is not registered!!");
				end
				NotifyInspect(KARMA_TalentInspect.RequestedUnit);
				KarmaChatDebug("[Talentscan] [2] Sent request for <" .. KARMA_TalentInspect.RequestedUnit .. ">");
			else
				KarmaChatDebug("[Talentscan] [2] Failed to send request for <" .. KARMA_TalentInspect.RequestedUnit
					.. ">: CanInspect returned no.");
			end
		else
			KARMA_TalentInspect.RequestedGUID = nil;
			KarmaChatDebug("[Talentscan] [2] Unit is meanwhile changed or invalid: " .. KARMA_TalentInspect.RequestedUnit);
		end

		KARMA_TalentInspect.StateCurrent = 3;
	elseif (KARMA_TalentInspect.StateCurrent == 3) then
		if (KARMA_TalentInspect.State3Time == nil) then
			if (KARMA_TalentInspect.TalentsReadyCallCount == 0) then
				if ((time() - KARMA_TalentInspect.State2Time) < 18) then
					return
				end
			end

			KARMA_TalentInspect.State3Time = time();
		elseif ((time() - KARMA_TalentInspect.State3Time) > 4) then
			KARMA_TalentInspect.StateCurrent = 4;
		end
	elseif (KARMA_TalentInspect.StateCurrent == 4) then
		if (KARMA_TalentInspect.State4Time == nil) then
			if (Karma:IsEventRegistered("INSPECT_READY")) then
				Karma:UnregisterEvent("INSPECT_READY");
				KarmaChatDebug("[Talentscan] [4] Event unregistered.");
			else
				KarmaChatDebug("[Talentscan] [4] Event was not registered?");
			end

			local	bSuccess, bRecount;
			if ((KARMA_TalentInspect.NotifyInspectCallCount == 1) and
			   (KARMA_TalentInspect.TalentsReadyCallCount == 0)) then
				if (Karma_TalentsRead()) then
					KARMA_TalentInspect.TalentsReadyCallCount = 1;
					KarmaChatDebug("[Talentscan] [4] No event was returned to the single request, assuming available talents are the right ones...");
				end
			end

			if (KARMA_TalentInspect.NotifyInspectCallCount == 1) and
			   (KARMA_TalentInspect.TalentsReadyCallCount == 1) and
			   UnitIsPlayer(KARMA_TalentInspect.RequestedUnit) and
			   (KARMA_TalentInspect.RequestedGUID == UnitGUID(KARMA_TalentInspect.RequestedUnit)) then
				KarmaChatDebug("[Talentscan] [4] Got definite scan: Unit(" .. KARMA_TalentInspect.RequestedUnit
					.. ") = " .. KARMA_TalentInspect.RequestedMember);
				-- got result, if valid member, move the result into the tree
				local	oMember = Karma_MemberList_GetObject(KARMA_TalentInspect.RequestedMember);
				if (oMember) then
					local	oOut = oMember[KARMA_DB_L5_RRFFM_TALENTTREE] or {};
					local	oIn, k, v = KARMA_TalentInspect.TalentsReadyCallList[1];
					-- this shouldn't be nil, but when the unit left the raid during the attempt to read back talents, it can be
					if (oIn) then
						for k, v in pairs(oIn) do
							oOut[k] = oIn[k];
						end

						oMember[KARMA_DB_L5_RRFFM_TALENTTREE] = oOut;
						KARMA_TalentInspect.TalentsReadyCallList = {};
						bSuccess = true;
					end

					KARMA_TalentInspect.RequestedUnitInventoryIncomplete = KarmaObj.Events.UNIT_INVENTORY_CHANGED(nil, KARMA_TalentInspect.RequestedUnit, oMember);
					KarmaChatSecondaryFallbackDefault("Successfully updated talents on " .. KARMA_TalentInspect.RequestedMember .. ".");
				end

				if (KARMA_TalentInspect.RequiredList[KARMA_TalentInspect.RequestedUnit] == KARMA_TalentInspect.RequestedMember) then
					KARMA_TalentInspect.RequiredList[KARMA_TalentInspect.RequestedUnit] = nil;
					bRecount = true;
				end
			else
				local sReason = "";
				if (KARMA_TalentInspect.NotifyInspectCallCount ~= 1) then
					sReason = sReason .. " (ICC (" .. KARMA_TalentInspect.NotifyInspectCallCount .. ") != 1)";
				end
				if (KARMA_TalentInspect.TalentsReadyCallCount ~= 1) then
					sReason = sReason .. " (RCC (" .. KARMA_TalentInspect.TalentsReadyCallCount .. ") != 1)";
				end
				KarmaChatDebug("[Talentscan] [4] Failed to get a definite scan: " .. KARMA_TalentInspect.RequestedUnit .. " <-" .. sReason);

				-- remove from queue if it changed or went invalid
				local	sName, sServer;
				if (UnitIsPlayer(KARMA_TalentInspect.RequestedUnit)) then
					sName, sServer = UnitName(KARMA_TalentInspect.RequestedUnit);
					if (sServer) and (sServer ~= "") then
						sName = sName .. "@" .. sServer;
					end
					if (KARMA_TalentInspect.RequiredList[KARMA_TalentInspect.RequestedUnit] ~= sName) then
						KarmaChatDebug("[Talentscan] [4] Unit changed: Unit(" .. KARMA_TalentInspect.RequestedUnit .. ") {"
							.. KARMA_TalentInspect.RequiredList[KARMA_TalentInspect.RequestedUnit] .. "} -> {" .. sName .. "}");
						KARMA_TalentInspect.RequiredList[KARMA_TalentInspect.RequestedUnit] = nil;
						bRecount = true;
					end
				else
					KarmaChatDebug("[Talentscan] [4] Unit went invalid: Unit(" .. KARMA_TalentInspect.RequestedUnit .. ") != "
						.. KARMA_TalentInspect.RequiredList[KARMA_TalentInspect.RequestedUnit]);
					KARMA_TalentInspect.RequiredList[KARMA_TalentInspect.RequestedUnit] = nil;
					bRecount = true;
				end
			end

			if (bRecount) then
				local	i, key, value;
				i = 0;
				for key, value in pairs(KARMA_TalentInspect.RequiredList) do
					i = i + 1;
				end
				KARMA_TalentInspect.RequiredCount = i;
			end

			if (bSuccess) then
				KARMA_TalentInspect.State4Time = time() - 15;
			else
				-- failed: increase counter, message on every 10th failure
				if (KARMA_TalentInspect.RequestedMember) then
					if (KARMA_OtherInfos[KARMA_TalentInspect.RequestedMember] == nil) then
						KARMA_OtherInfos[KARMA_TalentInspect.RequestedMember] = {};
					end

					local	iTIFCount = KARMA_OtherInfos[KARMA_TalentInspect.RequestedMember].TalentInspectFailed;
					if (iTIFCount == nil) then
						iTIFCount = 1;
					else
						iTIFCount = iTIFCount + 1;
						if ((iTIFCount % 10) == 0) then
							KarmaChatSecondaryFallbackDefault("Failed the " .. iTIFCount
								.. "th time to fetch talents for player " .. KARMA_TalentInspect.RequestedMember .. "...");
						end
					end
					KARMA_OtherInfos[KARMA_TalentInspect.RequestedMember].TalentInspectFailed = iTIFCount;
				end
				KARMA_TalentInspect.State4Time = time();
			end

			KARMA_TalentInspect.RequestedUnit   = nil;
			KARMA_TalentInspect.RequestedMember = nil;
			KARMA_TalentInspect.RequestedGUID   = nil;
		else
			if (KARMA_TalentInspect.RequestedUnitInventoryIncomplete) then
				KARMA_TalentInspect.RequestedUnitInventoryIncomplete = KarmaObj.Events.UNIT_INVENTORY_CHANGED(nil, KARMA_TalentInspect.RequestedUnitInventoryIncomplete, nil);
			end

			if ((time() - KARMA_TalentInspect.State4Time) > 20) then
				KARMA_TalentInspect.RequestedUnitInventoryIncomplete = nil;
				KARMA_TalentInspect.StateCurrent = 0;
			end
		end
	end
end

function	Karma_AutofetchTalents_Status()
	KarmaChatDebug("Karma_AutofetchTalents: [" .. tostring(time() % 60) .. "] state " .. Karma_NilToString(DebugMsgState)
		.. " => " ..  Karma_NilToString(KARMA_TalentInspect.StateCurrent));

	local	key, value;
	for key, value in pairs(KARMA_TalentInspect) do
		if (type(value) == "table") then
			KarmaChatDebug("-- " .. key .. " => <table>");
		else
			KarmaChatDebug("-- " .. key .. " => " .. value);
		end
	end

	KarmaChatDebug("***");
end

function	Karma_AddToTalentQueue(sUnit)
	if (CanInspect(sUnit, true)) then
		if (KARMA_TalentInspect.RequiredList == nil) then
			KARMA_TalentInspect.RequiredList = {};
		end

		local	sName, sServer = UnitName(sUnit);
		if (sServer and (sServer ~= "")) then
			sName = sName .. "@" .. sServer;
		end
		KARMA_TalentInspect.RequiredList[sUnit] = sName;
		KARMA_TalentInspect.RequiredCount = KARMA_TalentInspect.RequiredCount + 1;
	end
end

--
--
--

--[[
EJ table (from http://elitistjerks.com/f15/t44718-item_level_mechanics/)
Slot	Modifier
Head	1.00
Neck	9/16
Shoulder	3/4
Chest	1.00
Waist	3/4
Legs	1.00
Feet	3/4
Wrist	9/16
Hands	3/4
Finger	9/16
Trinket	17/25*
Back	9/16
One Handed Weapon	27/64
Two Handed Weapon	1.00
Off Hand	9/16
Shield	9/16
Wand	5/16
Ranged	81/256

Uncommon:
    itemLevel = 101.18*ln(itemSlotValue) - 292.23

Rare:
    itemLevel = 97.632*ln(itemSlotValue) - 287.14

Epic:
    itemLevel = 106.29*ln(itemSlotValue) - 344.36
]]--

local	ItemLevelToItemSlotValue = {
		[2] = { delta = 292.23, factor = 101.18  },
		[3] = { delta = 287.14, factor =  97.632 },
		[4] = { delta = 344.36, factor = 106.29  },
	}

local	SlotModifier = {
		[ 1] =   1,			-- head
		[ 2] =  9/16,			-- neck
		[ 3] =  0.75,			-- shoulder
		[ 4] =  0,			-- shirt
		[ 5] =   1,			-- chest
		[ 6] =  0.75,			-- belt
		[ 7] =   1,			-- legs
		[ 8] =  0.75,			-- feet
		[ 9] =  9/16,			-- wrist
		[10] =  0.75,			-- gloves
		[11] =  9/16,			-- finger 1
		[12] =  9/16,			-- finger 2
		[13] = 17/25,			-- trinket 1
		[14] = 17/25,			-- trinket 2
		[15] =  9/16,			-- back
		[16] = 27/64,			-- main hand
		[17] =  9/16,			-- off hand
		[18] =  5/16,			-- ranged/relic
	}

function	KarmaObj.Events.UNIT_INVENTORY_CHANGED(oFrame, sUnit, oMember, bOverwrite)
	local	sName, sServer = UnitName(sUnit);
	if (sName == nil) then
		return
	end
	if (sServer == "") then
		sServer = nil;
	end

	if ((sUnit == "player" or sUnit == "target" or sUnit == "mouseover") and not bOverwrite) then
		return
	end

	if (oFrame) then
		-- requeue inspection
		if (strsub(sUnit, 1, 4) == "raid" or strsub(sUnit, 1, 5) == "party") then
			-- ok, select a unit, switch to state 1
			local	sUnitListed, sNameListed;
			for sUnitListed, sNameListed in pairs(KARMA_TalentInspect.RequiredList) do
				-- already queued?
				if (sUnitListed == sUnit) then
					return
				end
			end

			if (KARMA_TalentInspect.RequiredList[sUnit] == nil) then
				KARMA_TalentInspect.RequiredCount = KARMA_TalentInspect.RequiredCount + 1;
				if (sServer) then
					KARMA_TalentInspect.RequiredList[sUnit] = sName .. "@" .. sServer;
				else
					KARMA_TalentInspect.RequiredList[sUnit] = sName;
				end
			end
		end
	end

	local	sOut = "";

	local	iUnitLvl = UnitLevel(sUnit);
	local	iMissing, iLvlRawSum, iSlotSum, iLvlSum, iPvpSum, oStats = 0, 0, 0, 0, 0, {};
	local	oHandMain, oHandOff, bItemInfoFail, iSlot;
	for iSlot = 1, 18 do
		if (iSlot ~= 4) then
			local	sItemlink = GetInventoryItemLink(sUnit, iSlot);
			if (sItemlink) then
				local	sName, _, iQuality, iItemlevel, _, _, _, _, sEquipSlot = GetItemInfo(sItemlink);
				if (sName == nil) then
					bItemInfoFail = iSlot;
					break;
				end

				if (iQuality == 7) then
					-- heirlooms are of rare quality and always lvl 1...
					iQuality = 3;
					iItemlevel = iUnitLvl;		-- this is definitely too low for the item
				end

				-- white hath no value
				local	iItemValue = 0;
				local	iItemSlotValue = 0;
				if (iItemlevel >= 272) then
					sOut = sOut .. ", [" .. iSlot .. "] " .. iItemlevel .. " => " .. iItemlevel * SlotModifier[iSlot];
					iLvlRawSum = iLvlRawSum + iItemlevel * SlotModifier[iSlot];
					iSlotSum = iSlotSum + SlotModifier[iSlot];

					iItemSlotValue = iItemlevel;
					iItemValue = iItemSlotValue * SlotModifier[iSlot];
				elseif (iQuality >= 2) then
					sOut = sOut .. ", [" .. iSlot .. "] " .. iItemlevel .. " => " .. iItemlevel * SlotModifier[iSlot];
					iLvlRawSum = iLvlRawSum + iItemlevel * SlotModifier[iSlot];
					iSlotSum = iSlotSum + SlotModifier[iSlot];

					iItemSlotValue = math.exp((iItemlevel + ItemLevelToItemSlotValue[iQuality].delta) / ItemLevelToItemSlotValue[iQuality].factor);
					iItemValue = iItemSlotValue * SlotModifier[iSlot];
				end

				if (iSlot == 16) then
					oHandMain = { ilvl = iItemSlotValue, sEquip = sEquipSlot };
				end
				if (iSlot == 17) then
					oHandOff = { ilvl = iItemSlotValue, sEquip = sEquipSlot };
				end

				iLvlSum = iLvlSum + iItemValue;

				local	oStats = GetItemStats(sItemlink);
				if (oStats["ITEM_MOD_RESILIENCE_SHORT"]) then
					iPvpSum = iPvpSum + iItemValue;
				end
				table.wipe(oStats);
			else
				local	iID = GetInventoryItemID(sUnit, iSlot);
				if (iID) then
					iMissing = iMissing + 1;
				end
			end
		end
	end

	if (oHandMain and not oHandOff and oHandMain.sEquip == "INVTYPE_2HWEAPON") then
		-- no off hand, 2H in main hand: count main hand as 1.0 instead of 27/64
		-- One Handed Weapon	27/64
		-- Two Handed Weapon	1.00
		sOut = sOut .. ", [16] " .. (oHandMain.ilvl * SlotModifier[16]) .. " => " .. oHandMain.ilvl;
		iLvlRawSum = iLvlRawSum + oHandMain.ilvl * (1 - SlotModifier[16]);
		iLvlSum = iLvlSum + oHandMain.ilvl * (1 - SlotModifier[16]);
		iSlotSum = iSlotSum + (1 - SlotModifier[16]);
	end

	KarmaChatDebug("Unit [" .. sUnit .. ": " .. sName .. "] Raw data - " .. strsub(sOut, 3));

	if (iSlotSum == 0) then
		KarmaChatDebug("Unit [" .. sUnit .. ": " .. sName .. "] Item check failed: incomplete information available (no data, actually)");
		return sUnit;
	end

	iLvlSum = math.floor(iLvlRawSum / iSlotSum) + iSlotSum / 100;
	if (iMissing > 0) then
		KarmaChatDebug("Unit [" .. sUnit .. ": " .. sName .. "] Item check failed: incomplete information available (" .. iMissing .. " pieces missing)");
		return sUnit;
	end

	local	sKey;
	if (bItemInfoFail) then
		KarmaChatDebug("Unit [" .. sUnit .. ": " .. sName .. "] Item check failed: item in slot " .. bItemInfoFail .. " couldn't be decoded.");
		return
	elseif (iLvlRawSum == 0) then
		KarmaChatDebug("Unit [" .. sUnit .. ": " .. sName .. "] Item check failed: unit is naked (or only in grey/white)?");
		return
	else
		-- at least half the pieces have resi => pvp set (or pve fail-cheat try)
		if (iPvpSum >= 0.5 * iLvlSum) then
			sKey = "P";
		else
			sKey = "E";
		end

		KarmaChatDebug("Unit [" .. sUnit .. ": " .. sName .. "] updated to Pv" .. sKey .. " milvl " .. iLvlSum .. ", rilvl " .. iLvlRawSum);
	end

	if (sUnit == "player") then
		return nil, format("%.2f", iLvlRawSum / iSlotSum), sKey;
	end

	if (bOverwrite) then
		-- /run KarmaAvEnK.Events.UNIT_INVENTORY_CHANGED(nil, "player", nil, true)
		KarmaChatSecondary("Unit [" .. sUnit .. ": " .. sName .. "] would be counted for Pv" .. sKey .. " as gear value " .. math.floor(iLvlSum)
				.. " (raw summed ilvl " .. iLvlRawSum .. ", ~" .. format("%.2f", iLvlRawSum / iSlotSum) .. ")");
		return
	end

	if (sKey) then
		if (oMember == nil) then
			oMember = Karma_MemberList_GetObject(sName, sServer);
		end

		if (oMember) then
			if (UnitGUID(sUnit) ~= oMember[KARMA_DB_L5_RRFFM.GUID]) then
				KarmaChatDebug("Unit [" .. sUnit .. "] Item check failed: GUID mismatch between unit and member.");
				return
			end

			local	sDBKey = KARMA_DB_L5_RRFFM["GEARLEVEL_PV" .. sKey];
			if (sDBKey) then
				local	iLvlSumOld = oMember[sDBKey] or 0;
				if (oFrame and math.abs(iLvlSumOld - iLvlSum) >= 1.0) then
					-- event
					KarmaChatSecondary(sName .. ": Updated modified total Pv" .. sKey .. " gear value to " .. math.floor(iLvlSum) .. ".");
				end
				oMember[sDBKey] = iLvlSum;
			end
		end
	end
end
--

function	Karma_TimeKarma_Status(sName, iSet)
	if (sName == nil) then
		if (iSet) and (type(iSet) == "number") then
			KCfg.Set("TIME_KARMA_DEFAULT", iSet);
		end
		KarmaChatDebug("Time->Karma global setting: " .. KCfg.Get("TIME_KARMA_DEFAULT"));
	else
		local	oMember = Karma_MemberList_GetObject(sName);
		if (oMember == nil) then
			KarmaChatDebug("Not a member: " .. Karma_NilToString(sName));
		else
			if (iSet) and (type(iSet) == "number") then
				oMember[KARMA_DB_L5_RRFFM_KARMA_TIME] = iSet;
			end
			KarmaChatDebug("Time->Karma: " .. oMember[KARMA_DB_L5_RRFFM_KARMA_TIME]);
		end
	end
end

--------------------
-- Command queue  --
--------------------

function	KarmaObj.Slash.CommandQGet()
	return Karma_CommandQueue;
end

function	KarmaObj.Slash.CommandQLen()
	return #Karma_CommandQueue;
end

function	KarmaObj.Slash.CommandQClear()
	Karma_CommandQueue = {};
end

function	KarmaObj.Slash.CommandQAdd(oData)
	if (type(oData) ~= "table") then
		return
	end

	local	iQLen = 1 + #Karma_CommandQueue;
	Karma_CommandQueue[iQLen] = oData;
	return iQLen;
end

function	KarmaObj.Slash.CommandQAddPrio(oData)
	if (type(oData) ~= "table") then
		return
	end

	local	oQueueNew = oData;
	local	iQNewLen = #oQueueNew;

	local	iQLen, i = 1 + #Karma_CommandQueue;
	for i = 1, iQLen do
		oQueueNew[iQNewLen + i] = Karma_CommandQueue[i]; 
	end

	Karma_CommandQueue = oQueueNew;
end

function	KarmaObj.Slash.CommandQIterate(fFunc)
	local	iCnt, i = #Karma_CommandQueue;
	for i = 1, iCnt do
		local	oCmd = Karma_CommandQueue[i];
		if (not fFunc(oCmd, i)) then
			break;
		end
	end
end

function	KarmaObj.Slash.CommandQRemove(sKey, oValue)
	local	iCnt, i, bRemoved = #Karma_CommandQueue;
	for i = 1, iCnt do
		local	oCmd = Karma_CommandQueue[i];
		if (oCmd[sKey] == oValue) then
			bRemoved = true;
			Karma_CommandQueue[i] = nil;
		end
	end

	if (bRemoved) then
		local	oQueue = {};
		for i = 1, iCnt do
			local	oCmd = Karma_CommandQueue[i];
			if (oCmd) then
				oQueue[1 + #oQueue] = oCmd;
			end
		end

		Karma_CommandQueue = oQueue;
	end
end

function	KarmaObj.Slash.CommandQExecute()
	local	elem = Karma_CommandQueue[1];

	local	iCnt, i = #Karma_CommandQueue;
	for i = 2, iCnt do
		Karma_CommandQueue[i-1] = Karma_CommandQueue[i];
	end
	Karma_CommandQueue[iCnt] = nil;

	if (elem ~= nil) then
		if (elem.func) then
			KarmaChatDebug(date("[%H:%M:%S]", time()) .. " Executing <" .. elem.sName .. "> (f)");
			elem.func(elem.args);
		elseif (elem.method) then
			KarmaChatDebug(date("[%H:%M:%S]", time()) .. " Executing <" .. elem.sName .. "> (m)");
			elem.method(elem);
		else
			KarmaChatDebug("Uuh. Function to command <" .. elem.sName .. "> non-existant?");
		end
	end
end

--------------------
-- Message queue  --
--------------------

function	KarmaObj.MessageQueueAdd(oData)
	Karma_MessageQueue[1 + #Karma_MessageQueue] = oData;
end

function	KarmaObj.MessageQueueLen()
	return #Karma_MessageQueue;
end

--------------------
-- Slash Commands --
--------------------
function	Karma_InitSlash()
	SLASH_KARMA1 = KARMA_CMDSELF;
	SLASH_KARMA2 = "/kar";
	SlashCmdList["KARMA"] = function(argfield, argcnt)
		KSlash.CommandHandler(argfield, argcnt);
	end

	KSLASH = {
		window = Karma_ToggleWindow,
		win = Karma_ToggleWindow,
		addmember = KSlash.Add,
		add = KSlash.Add,
		addguild = KSlash.AddGuild,
		ignore = KSlash.Ign,
		ign = KSlash.Ign,
		remove = KSlash.Rem,
		rem = KSlash.Rem,
		give = KSlash.Give,
		take = KSlash.Take,
		sortby = KSlash.Sort,
		colorby = KSlash.Col,
		colourby = KSlash.Col,
		options  = KSlash.Opt,
		opt = KSlash.Opt,
		autoignore = KSlash.Auto,
		questcache = KSlash.Cache,
		clean = KSlash.Clean,
		cleanpvp = KSlash.CleanPvp,
		karmatips = KSlash.KarmaTips,
		notetips = KSlash.NoteTips,
		update = KSlash.Update,
		export = KSlash.Export,
		import = KSlash.Import,
		transport = KSlash.Transport,
		help = KSlash.Help,
		filter = KSlash.Filter,
		qcachewarn = KSlash.QCacheWarn,

		--[[
		checkclass = KSlash.CheckClassOnline,
		checkchannel = KSlash.CheckOnlineInChannel,
		checkallclasses = KSlash.CheckAllClassesOnline,
		checkguild = KSlash.CheckGuild,
		]]--
		checkclass = KSlash.LFM,
		checkchannel = KSlash.LFM,
		checkallclasses = KSlash.LFM,
		checkguild = KSlash.LFM,

		showonline = KSlash.ShowOnline,

		altadd = KSlash.AltAdd,
		altrem = KSlash.AltRemove,
		altlist = KSlash.AltList,
		altcheck = KSlash.AltCheck,
		resetgui = KSlash.ResetGUI,
		pausequeuedwhos = KSlash.PauseWho,				-- TODO: needs help entry and *code*
		autochecktalents = KSlash.AutocheckTalents,
		skillmodel = KSlash.SkillModel,
		mouseover = Karma_MouseOverUnitLog_Status,
		xinfo = Karma_CrossFactionInfo,
		xnote = Karma_CrossFactionNote,
		xupdate = Karma_CrossFactionUpdate,
		forcenew = Karma_MemberForceNew,
		forceupdate = Karma_MemberForceUpdate,
		forcecheck = Karma_MemberForceCheck,
		cql = KSlash.CQList,
		pql = KSlash.PQList,
		wql = KSlash.WQList,
		pubnoteset = KSlash.PubNoteSet,
		pubnoteget = KSlash.PubNoteGet,
		pubnoteclear = KSlash.PubNoteClear,
		wim_module = KSlash.WIMModule,
		shareconfig = KSlash.ShareConfig,
		sharequery = KSlash.ShareQuery,
		raid = KSlash.Raid,
		dbsparse = KSlash.DBSparse,
		tracking = KSlash.Tracking,
		addoffline = KSlash.CmdAddOffline,
		history = KSlash.History,
	};

	KarmaObj.Share.CommandsInsert();
end

function	KarmaObj.Slash.CommandAdd(sCmd, oFunc)
	KSLASH[sCmd] = oFunc;
end

function	KSlash.CommandHandler(msg, bSilent)
	local	args = {};
	local	iCounter = 0;
	local	i = 0;

	-- Split commands
	-- %w+: alphanumeric chars, does not include e.g. accented letters
	-- => only sufficient for command, but not for character names
	-- %S+: all but space chars
	local	w;
	for w in string.gmatch(msg, "%S+") do
		iCounter = iCounter+1;
		args[iCounter] = w;
	end

	if (KSLASH[args[1]]) then
		KSLASH[args[1]](args, iCounter);
	elseif (bSilent ~= true) then
		if args[1] then
			KarmaChatDefault(LANG.CMDUNKNOWN_PRE .. args[1].. LANG.CMDUNKNOWN_POST);
		end

		local	sSecondary = KarmaObj.UIChat.SecondaryNameGet();
		if (sSecondary ~= nil) then
			KarmaChatDefault(KARMA_MSG_HELPINSECONDWINDOW .. " [" .. sSecondary .. "]");
		end

		local	helpindex, helpline, versionpos;
		for helpindex, helpline in pairs(KARMA_CMDLINE_HELP_SHORT) do
			if (helpindex == 1) then
				versionpos = strfind(helpline, "***", 1, true);
				if (versionpos) then
					helpline = strsub(helpline, 1, versionpos - 1) .. KARMA_VERSION_TEXT .. strsub(helpline, versionpos + 3);
				end
			end
			KarmaChatSecondaryFallbackDefault("|" .. KARMA_CMDLINE_HELP_COLOR1 .. "-- " .. helpline, 1);
		end
	end
end

function KSlash.Help(args)
	if (args[2] == "quick") then
		local	key, value, unsorted;
		local	lines = {};
		unsorted = "Commands (unsorted): ==[";
		for key, value in pairs(KSLASH) do
			if (strlen(unsorted) + strlen(key) > 300) then
				KarmaChatDebug(unsorted);
				unsorted = "(cont'd)";
			end
			unsorted = unsorted .. " " .. key;
			tinsert(lines, key);
		end
		KarmaChatDebug(unsorted .. " ]==");
		KOH.GenericSort(lines);
		local	line = "";
		for key, value in pairs(lines) do
			line = line .. " " .. value;
		end
		KarmaChatDefault(KARMA_MSG_HELPCOMMANDLIST .. line);
		return;
	end;

	local	sSecondary = KarmaObj.UIChat.SecondaryNameGet();
	if (sSecondary ~= nil) then
		KarmaChatDefault(KARMA_MSG_HELPINSECONDWINDOW .. " [" .. sSecondary .. "]");
	end

	local	sGroup;
	if ((args[2] ~= nil) and (args[2] ~= "")) then
		sGroup = strupper(args[2]);
		if ((sGroup ~= "LONG") and (sGroup ~= "FULL")) then
			local	oGroup = getglobal("KARMA_CMDLINE_HELP_" .. sGroup);
			if (type(oGroup) == "table") then
				local	helpkeysub, helplinesub;
				for helpkeysub, helplinesub in pairs(oGroup) do
					KarmaChatSecondaryFallbackDefault("|" .. KARMA_CMDLINE_HELP_COLOR1 .. "-- " .. helplinesub, 1);
				end

				return
			end
		end

		if (sGroup ~= "ALL") then
			KarmaChatSecondaryFallbackDefault("Unrecognized command group: " .. args[2] .. "; only displaying regular help.");
		end
	end

	local	oHelpGroups = KARMA_CMDLINE_HELPMETA_LONG;
	if (KARMA_CMDLINE_HELP_LONG ~= nil) then
		-- legacy
		oHelpGroups = KARMA_CMDLINE_HELPMETA_LEGACY;
	elseif (sGroup == "ALL") then
		oHelpGroups = KARMA_CMDLINE_HELPMETA_FULL;
	end

	local	helpindex, helpline, versionpos;
	for helpindex, helpline in pairs(KARMA_CMDLINE_HELP_SHORT) do
		if (helpindex == 1) then
			versionpos = strfind(helpline, "***", 1, true);
			if (versionpos) then
				helpline = strsub(helpline, 1, versionpos - 1) .. KARMA_VERSION_TEXT .. strsub(helpline, versionpos + 3);
			end
		end
		KarmaChatSecondaryFallbackDefault("|" .. KARMA_CMDLINE_HELP_COLOR1 .. "-- " .. helpline, 1);
	end

	for helpindex, helpline in pairs(oHelpGroups) do
		local	oGroup = getglobal("KARMA_CMDLINE_HELP_" .. helpline);
		if (type(oGroup) == "table") then
			local	helpkeysub, helplinesub;
			for helpkeysub, helplinesub in pairs(oGroup) do
				KarmaChatSecondaryFallbackDefault("|" .. KARMA_CMDLINE_HELP_COLOR1 .. "-- " .. helplinesub, 1);
			end
		end
	end
end

function	KSlash.CQList()
	local	iCnt = KarmaObj.Slash.CommandQLen();
	local	sMsg = "Length of command queue at this time: " .. iCnt .. " commands pending.";
	local	TimeNow = GetTime();
	if (KarmaModuleLocal.Timers.CmdQ > TimeNow) then
		sMsg = sMsg .. " Next command in " .. format("%.2f", KarmaModuleLocal.Timers.CmdQ - TimeNow) .. " seconds.";
	end
	KarmaChatSecondary(sMsg);

	local	fTrace = function(oCmd, i)
			KarmaChatSecondary("[" .. i .. "] " .. oCmd.sName);
			return true;
		end

	KarmaObj.Slash.CommandQIterate(fTrace);
end

function	KSlash.PQList()
	local	sMsg = "Length of cron queue at this time: " .. getn(Karma_CronQueue) .. " sets pending.";
	KarmaChatSecondary(sMsg);
	for i = 1, getn(Karma_CronQueue) do
		local	sName = "<unknown!!>";
		if ((Karma_CronQueue[i].CmdList ~= nil) and (Karma_CronQueue[i].CmdList[1] ~= nil)) then
			sName = Karma_CronQueue[i].CmdList[1].sName;
		end
		if (sName == nil) then
			sName = "<unknown??>";
		end
		KarmaChatSecondary("[" .. i .. "] @ [" .. date("%H:%M:%S", time() + (Karma_CronQueue[i].At - GetTime())) .. "] " .. sName);
	end
end

function	KSlash.WQList()
	KarmaChatSecondary("Length of /who queue at this time: " .. getn(Karma_WhoQueue) .. " commands pending.");
	for i = 1, getn(Karma_WhoQueue) do
		KarmaChatSecondary("[" .. i .. "] " .. Karma_WhoQueue[i].text);
	end
end

function KSlash.Add(args)
	if (args[2] == nil) then
		local	sName, sServer = UnitName("target");
		if (sServer and (sServer ~= "")) then
			sName = sName .. "@" .. sServer;
		end
		args[2] = sName;
		if (args[2]) then
			KarmaChatSecondary("No name on command line... using current target <" .. args[2] .. ">.");
		end
	end

	if (args[2] ~= nil and args[2] ~= "") then
		Karma_Command_AddMember_Insert(args);
	end
end

function KSlash.AddGuild(args, iCnt)
	if (args[2] == nil) then
		KarmaChatSecondary("No name to add on command line!");
		return
	end

	local	sGuild, i = args[2];
	for	i = 3, iCnt do
		sGuild = sGuild .. " " .. args[i];
	end

	local	sGuildPure = sGuild;
	sGuild = "<" .. sGuild .. ">";
	local	guildobj = Karma_MemberList_GetObject(sGuild);
	if (guildobj == nil) then
		Karma_MemberList_Add(sGuild);
		Karma_MemberList_Update(sGuild, nil, nil, nil, sGuildPure);

		guildobj = Karma_MemberList_GetObject(sGuild);
		guildobj.Meta = "GUILD";

		KarmaChatDebug("Added meta 'guild' " .. sGuild .. ".");
	else
		KarmaChatDebug("Found meta 'guild' " .. sGuild .. ", not added again.");
	end
end

function KSlash.Ign(args)
	if (args[2] == nil) then
		local	sName, sServer = UnitName("target");
		if (sServer and (sServer ~= "")) then
			sName = sName .. "@" .. sServer;
		end
		args[2] = sName;
		if (args[2]) then
			KarmaChatSecondary("No name on command line... using current target <" .. args[2] .. ">.");
		end
	end

	if (args[2] ~= nil and args[2] ~= "") then
		Karma_Command_AddIgnore_Insert(args);
	end
end

function KSlash.Rem(args)
	if (args[2] == nil) then
		KarmaChatDefault(KARMA_MSG_COMMAND_MISSINGARG .. KARMA_WINEL_FRAG_COLONSPACE .. KARMA_MSG_PLAYER_REQARG);
		return
	end

	if (args[2] == KARMA_CURRENTMEMBER) then
		Karma_SetCurrentMember(nil);
	end;

	Karma_MemberList_ResetMemberNamesCache();
	Karma_MemberList_Remove(args[2]);
	KarmaWindow_UpdateMemberList();

	KarmaChatDefault(args[2] .. KARMA_MSG_REMOVE_COMPLETED);
end

function KSlash.Give(args)
	if (args[2] == nil) then
		local	sName, sServer = UnitName("target");
		if (sServer and (sServer ~= "")) then
			sName = sName .. "@" .. sServer;
		end
		args[2] = sName;
		if (args[2]) then
			KarmaChatSecondary("No name on command line... using current target <" .. args[2] .. ">.");
		end
	end

	if (args[2] ~= nil) then
		Karma_IncreaseKarma(args[2], false, 3);
		Karma_SetCurrentMember(args[2]);
	else
		KarmaChatDefault(KARMA_MSG_COMMAND .. args[1] .. KARMA_MSG_COMMAND_NEEDTARGETORARGUMENT);
	end
end

function KSlash.Take(args)
	if (args[2] == nil) then
		local	sName, sServer = UnitName("target");
		if (sServer and (sServer ~= "")) then
			sName = sName .. "@" .. sServer;
		end
		args[2] = sName;
		if (args[2]) then
			KarmaChatSecondary("No name on command line... using current target <" .. args[2] .. ">.");
		end
	end

	if (args[2] ~= nil) then
		Karma_DecreaseKarma(args[2], false, 3);
		Karma_SetCurrentMember(args[2]);
	else
		KarmaChatDefault(KARMA_MSG_COMMAND .. args[1] .. KARMA_MSG_COMMAND_NEEDTARGETORARGUMENT);
	end
end

function KSlash.Sort(args, iCounter)
	if (iCounter >= 2) then
		if (args[2] == "sName") then
			KCfg.SetIndirect("SORTFUNCTION", "SORTFUNCTION_TYPE_NAME");
		elseif (args[2] == "xp" or args[2] == "exp") then
			KCfg.SetIndirect("SORTFUNCTION", "SORTFUNCTION_TYPE_XP");
		elseif (args[2] == "karma") then
			KCfg.SetIndirect("SORTFUNCTION", "SORTFUNCTION_TYPE_KARMA");
		elseif (args[2] == "played") then
			KCfg.SetIndirect("SORTFUNCTION", "SORTFUNCTION_TYPE_PLAYED");
		elseif (args[2] == "class") then
			KCfg.SetIndirect("SORTFUNCTION", "SORTFUNCTION_TYPE_CLASS");
		elseif (args[2] == "joined") then
			KCfg.SetIndirect("SORTFUNCTION", "SORTFUNCTION_TYPE_JOINED");
		elseif (args[2] == "joinedthis") then
			KCfg.SetIndirect("SORTFUNCTION", "SORTFUNCTION_TYPE_JOINEDTHIS");
		elseif (args[2] == "lastseen") then
			KCfg.SetIndirect("SORTFUNCTION", "SORTFUNCTION_TYPE_SEEN");
		elseif (args[2] == "talent") then
			KCfg.SetIndirect("SORTFUNCTION", "SORTFUNCTION_TYPE_TALENT");
		elseif (args[2] == "guildtop") then
			KCfg.SetIndirect("SORTFUNCTION", "SORTFUNCTION_TYPE_GUILD_TOP");
		elseif (args[2] == "guildbottom") then
			KCfg.SetIndirect("SORTFUNCTION", "SORTFUNCTION_TYPE_GUILD_BOTTOM");
		end
		KarmaWindow_Update();
	end
end

function KSlash.Col(args, iCounter)
	if (iCounter >= 2) then
		if (args[2] == "xp" or args[2] == "exp") then
			KCfg.SetIndirect("COLORFUNCTION", "COLORFUNCTION_TYPE_XP");
		elseif (args[2] == "karma") then
			KCfg.SetIndirect("COLORFUNCTION", "COLORFUNCTION_TYPE_KARMA");
		elseif (args[2] == "played") then
			KCfg.SetIndirect("COLORFUNCTION", "COLORFUNCTION_TYPE_PLAYED");
		elseif (args[2] == "class") then
			KCfg.SetIndirect("COLORFUNCTION", "COLORFUNCTION_TYPE_CLASS");
		end
		KarmaWindow_Update();
	end
end

function KSlash.Opt(args)
	KarmaOptionsWindow_Show();
end

function KSlash.Auto(args, iCounter)
	local	bNewConfig = KCfg.Get("AUTOIGNORE");

	if (iCounter == 1) then
		if (bNewConfig == 1) then
			bNewConfig = 0;
		else
			bNewConfig = 1;
		end

		KCfg.Set("AUTOIGNORE", bNewConfig);
	elseif (iCounter == 2) then
		for key, value in pairs(tOnOff) do
			if (strupper(value) == strupper(args[2])) then
				bNewConfig = key;
			end
		end
	end

	if (bNewConfig == 1) then
		KarmaChatDefault(KARMA_MSG_CONFIG_AUTOIGNORE .. KARMA_MSG_CONFIG_ISNOWON);
	else
		KarmaChatDefault(KARMA_MSG_CONFIG_AUTOIGNORE .. KARMA_MSG_CONFIG_ISNOWOFF);
	end
end

function KSlash.Cache(args)
	if (KarmaObj.UIChat.SecondaryNotNil()) then
		KarmaChatDefault(KARMA_MSG_QCACHE_SECONDWINDOW);
	end

	local listsubid = 0;
	if (args[2] ~= nil) then
		listsubid = tonumber(args[2]);
		KarmaChatSecondaryFallbackDefault(KARMA_MSG_QCACHE_SUBLISTING .. args[2]);
	end

	for sName, values in pairs(KARMA_QuestCache) do
		local id = Karma_NilToString(values.id);
		local extid = Karma_NilToString(values.extid);
		KarmaChatSecondaryFallbackDefault("[" .. id .. "] " .. "{" .. extid .. "} " .. sName .. KARMA_WINEL_FRAG_COLONSPACE .. KARMA_MSG_QCACHE_COMPLETE .. values.complete);
		if (listsubid == id) or (listsubid == -1) then
			local QObjs;
			if (values.objectives ~= nil) then
				QObjs = values.objectives;
			else
				QObjs = {};
				Karma_GetQuestObjectives(values.id, QObjs, 1);
			end

			if (QObjs ~= nil) then
				if (type(QObjs.objectives) ~= "table") then
					KarmaChatSecondaryFallbackDefault(KARMA_MSG_QCACHE_OBJECTIVESPECIAL);
				else
					for qobjid, qobj in pairs(QObjs.objectives) do
						KarmaChatSecondaryFallbackDefault(qobj.type .. "~" .. qobj.desc .. KARMA_MSG_QCACHE_COMPLETE .. qobj.progress);
					end
				end
				KarmaChatSecondaryFallbackDefault("-----------------------------------------------");
			end
		end
	end
end

function KSlash.Clean(args)
	Karma_ClearUnused(args[2]);
end

function KSlash.CleanPvp(args)
	Karma_ClearUnused(args[2], 1);
end

function	KSlash.KarmaTips(args)
	local	bNewConfig = KCfg.Get("TOOLTIP_KARMA");

	bNewConfig = not bNewConfig;
	KCfg.Set("TOOLTIP_KARMA", bNewConfig);

	if bNewConfig then
		KarmaChatDefault(KARMA_MSG_CONFIG_TIP_KARMA .. KARMA_MSG_CONFIG_ISNOWON);
	else
		KarmaChatDefault(KARMA_MSG_CONFIG_TIP_KARMA .. KARMA_MSG_CONFIG_ISNOWOFF);
	end
end

function	KSlash.NoteTips(args)
	local	bNewConfig = KCfg.Get("TOOLTIP_NOTES");

	bNewConfig = not bNewConfig;
	KCfg.Set("TOOLTIP_NOTES", bNewConfig);

	if bNewConfig then
		KarmaChatDefault(KARMA_MSG_CONFIG_TIP_NOTES .. KARMA_MSG_CONFIG_ISNOWON);
	else
		KarmaChatDefault(KARMA_MSG_CONFIG_TIP_NOTES .. KARMA_MSG_CONFIG_ISNOWOFF);
	end
end

function	KSlash.Filter(args)
	-- convert array back to string...
	local	CurrentFilter = "";
	local	Delimiter = "";
	local	Space = " ";
	for k, v in pairs(args) do
		if (k > 1) then
			CurrentFilter = CurrentFilter .. Delimiter .. v;
			Delimiter = Space;
		end
	end

	if (CurrentFilter ~= "") then
		Karma_ExecuteFilter(CurrentFilter);
		KarmaWindow_Filter_EditBox:SetText(KARMA_Filter.Total);
		KarmaChatSecondaryFallbackDefault(KARMA_MSG_FILTER_SET);
	else
		Karma_ExecuteFilter(nil);
		KarmaWindow_Filter_EditBox:SetText("");
		KarmaChatSecondaryFallbackDefault(KARMA_MSG_FILTER_CLEARED);
	end
end

local BucketValues = nil;

function KSlash.Update(args, iCounter, force)
	if (args[2] == nil) then
		local	sName, sServer;
		if (UnitExists("target") and UnitIsPlayer("target")) then
			sName, sServer = UnitName("target");
			if (sServer and (sServer ~= "")) then
				sName = sName .. "@" .. sServer;
			end
			args[2] = sName;
		end

		if (args[2] == nil) then
			args[2] = "";
		end
	end

	if (args[2] == "") then
		local i, BucketValue;
		if (BucketValues == nil) then
			BucketValues = {};
			for i = 1, strlen(KARMA_ALPHACHARS) do
				BucketValue = {};
				BucketValue.Bucket = strsub(KARMA_ALPHACHARS, i, i);
				BucketValue.Value = 100000;
				tinsert(BucketValues, BucketValue);
			end
		end

		local FirstValue = 0;
		for i, BucketValue in pairs(BucketValues) do
			BucketValue.First = FirstValue;
			FirstValue = FirstValue + BucketValue.Value;
		end
		if (FirstValue == 0) then
			-- no data.
			return
		end

		-- select a random incomplete/non-KarmaObj.Const.LevelMax list member, try older entries with higher probability
		local	Choice = math.random(0, FirstValue - 1);
		local	sBucketName = nil;
		for i, BucketValue in pairs(BucketValues) do
			if (sBucketName == nil) then
				if (BucketValue.First <= Choice) and (Choice < BucketValue.First + BucketValue.Value) then
					sBucketName = BucketValue.Bucket;
				end
			end
		end

		if (sBucketName == nil) then
			KarmaChatDebug("Fallback! " .. Choice .. " ?? <-> " .. FirstValue);
			i = math.random(1, strlen(KARMA_ALPHACHARS));
			sBucketName = strsub(KARMA_ALPHACHARS, i, i);
		else
			KarmaChatDebug("Bucket selected: " .. sBucketName .. " (" .. Choice .. "/" .. FirstValue .. ")");
		end

		local	lMembers = KarmaObj.DB.SF.MemberListGet();
		local	lBucketMembers = lMembers[sBucketName];
		local	lCandidates = {};
		i = 0;
		local	j = 0;
		local	Now = time();
		for member, obj in pairs(lBucketMembers) do
			local	impdat = 0;
			local	bonus = 1;
			if ((obj.Meta ~= nil) or (strfind(member, "@", 1, true) ~= nil)) then
				bonus = 0;
			else
				if (obj[KARMA_DB_L5_RRFFM.LEVEL] > 0) then
					bonus = bonus + KarmaObj.Const.LevelMax - obj[KARMA_DB_L5_RRFFM.LEVEL];
				else
					bonus = bonus + 50;
					impdat = 1;
				end
				if (obj[KARMA_DB_L5_RRFFM.CLASS] == "") then
					bonus = bonus + 25;
					impdat = 1;
				end
				if (obj[KARMA_DB_L5_RRFFM.RACE] == "") then
					bonus = bonus + 5;
					impdat = 1;
				end

				if (obj[KARMA_DB_L5_RRFFM.GUILD] == "") then
					bonus = bonus + 2;
				end
			end

			if (bonus > 0) then
				lCandidates[i] = {};
				lCandidates[i][0] = member;
				lCandidates[i][1] = j;
				local	Try;
				local	Success;
				if (obj[KARMA_DB_L5_RRFFM_TIMESTAMP] == nil) then
					-- like never tried...
					bonus = bonus + 100000;
				else
					local	Try = obj[KARMA_DB_L5_RRFFM_TIMESTAMP][KARMA_DB_L5_RRFFM_TIMESTAMP_TRY];
					local	Success = obj[KARMA_DB_L5_RRFFM_TIMESTAMP][KARMA_DB_L5_RRFFM_TIMESTAMP_SUCCESS];
					if (Try ~= nil) and (Success ~= nil) then
						if (Try == 0) then
							-- never tried...
							bonus = bonus + 100000;
						elseif (Success == 0) then
							-- never succeeded
							bonus = bonus + 1000;
						elseif (time() - Success > 7 * 24 * 60 * 60) then
							-- the more recent the last try, the lower the bonus
							-- => add difference in hours between last try and now...
							bonus = bonus + floor((time() - Try) / 3600);
						elseif (impdat ~= 1) then
							-- less than 7 days from most recent update,
							-- *only* non-crucial info missing
							bonus = 1;
						end
					end
				end

				if (type(obj[KARMA_DB_L5_RRFFM_CONFLICT]) == "table") then
					local	sConflict = obj[KARMA_DB_L5_RRFFM_CONFLICT].Conflict;
					if (obj[KARMA_DB_L5_RRFFM_CONFLICT].Resolved == 0) then
						bonus = bonus + 20000;
					end
				end

				bonus = floor(bonus * KarmaObj.DB.M.KarmaGet(obj) / 10);
				j = j + bonus;
				lCandidates[i][2] = j;
				i = i + 1;

				-- KarmaChatDefault("i: "..i..", Name = "..member..", Score: ".. j - bonus .. " -> "..j);
			end
		end -- for

		for i, BucketValue in pairs(BucketValues) do
			if (BucketValue.Bucket == sBucketName) then
				if (i == 0) or (j == 0) then
					KarmaChatDebug("Bucket is 'empty': " .. sBucketName .. ", dropping" .. KARMA_WINEL_FRAG_TRIDOTS);
					BucketValues[i] = nil;
				else
					BucketValue.Value = j;
				end
			end
		end

		KarmaChatDebug("Random selection: Bucket = " .. sBucketName .. ", i = " .. i .. ", jmax = " .. j);
		if (i > 0) and (j > 0) then
			local imax = i - 1;
			local jmax = j;
			j = math.random(0, jmax - 1);
			for i = 0, imax do
				if (j >= lCandidates[i][1]) and (j < lCandidates[i][2]) then
					args[2] = lCandidates[i][0];
					break;
				end
			end
		else
			KarmaChatDefault(KARMA_MSG_UPDATE_RANDOM_EMPTYBUCKET1 .. " <" .. sBucketName .. "> " .. KARMA_MSG_UPDATE_RANDOM_EMPTYBUCKET2);
		end
	end

	if (args[2] ~= "") then
		local	tMember = Karma_MemberList_GetObject(args[2]);
		if (tMember == nil) then
			if (force == nil) then
				KarmaChatDefault(KARMA_MSG_CANNOT_PRE .. args[1] .. KARMA_MSG_CANNOT_POST
								.. KARMA_WINEL_FRAG_SPACE .. args[2] .. KARMA_WINEL_FRAG_COLONSPACE
								.. KARMA_MSG_COMMAND_NOTMEMBER);
				return;
			end
		else
			if (tMember[KARMA_DB_L5_RRFFM_TIMESTAMP] == nil) then
				tMember[KARMA_DB_L5_RRFFM_TIMESTAMP] = {};
				tMember[KARMA_DB_L5_RRFFM_TIMESTAMP][KARMA_DB_L5_RRFFM_TIMESTAMP_SUCCESS] = 0;
			end

			tMember[KARMA_DB_L5_RRFFM_TIMESTAMP][KARMA_DB_L5_RRFFM_TIMESTAMP_TRY] = time();
		end

		-- KarmaChatDefault("Karma: Trying to update info on " .. args[2] .. KARMA_WINEL_FRAG_TRIDOTS);
		Karma_Command_UpdateMember_Insert(args);
	end
end

function KSlash.QCacheWarn(args)
	local	bNewConfig = KCfg.Get("QUESTWARNCOLLAPSED");

	if (type(bNewConfig) ~= "number") then
		bNewConfig = 0;
	end

	bNewConfig = 1 - bNewConfig;
	KCfg.Set("QUESTWARNCOLLAPSED", bNewConfig);

	if (bNewConfig == 1) then
		KarmaChatDefault(KARMA_MSG_CONFIG_QCACHEWARN .. KARMA_MSG_CONFIG_ISNOWON);
	else
		KarmaChatDefault(KARMA_MSG_CONFIG_QCACHEWARN .. KARMA_MSG_CONFIG_ISNOWOFF);
	end
end

function KSlash.ShowOnline(args)
	Karma_ToggleWindow2();
	if (KarmaObj.LFM) then
		KarmaObj.LFM.WindowUpdate();
	end
end

function KSlash.CheckOnlineInChannel(args)
	if (args[2] ~= nil) and (args[2] ~= "") then
		Karma_QueueCommandChannelCheck(args[2]);
	end
end

function Karma_CheckOnlineInChannelResults(blobofnames)
	if (not KarmaModuleLocal.ChannelName) then
		return
	end

	local	bIsLFGChannel;
	local	iLFG, sLFG = GetChannelName(KARMA_CHANNELNAME_LFG);
	if (type(KarmaModuleLocal.ChannelName) == "number") then
		bIsLFGChannel = KarmaModuleLocal.ChannelName == iLFG;
	else
		bIsLFGChannel = KarmaModuleLocal.ChannelName == sLFG;
	end

	local	iNow = time();
	local	lMembers = KarmaObj.DB.SF.MemberListGet();

	local	sName, sBucketName, sMemberName, oMember;
	local	iResultCount = 0;
	local	iMemberCount = 0;
	for sName in string.gmatch(blobofnames, "%S+") do
		sMemberName = strsub(sName, 1, strlen(sName) - 1);

		-- channel mod has * in front
		if (strsub(sMemberName, 1, 1) == "*") then
			sMemberName = strsub(sMemberName, 2);
		end

		if (KarmaObj.LFM) then
			KarmaObj.LFM.PlayerUpdateFromChannel(sMemberName, iNow, bIsLFGChannel);
		end

		oMember = Karma_MemberList_GetObject(sMemberName, nil, lMembers);
		if (oMember ~= nil) then
			local	sGuild = Karma_MemberObject_GetGuild(oMember);
			if (sGuild == nil) then
				sGuild = "";
			end
			if (sGuild ~= "") then
				sGuild = "<" .. sGuild .. "> ";
			end
			local	iLevel = Karma_MemberObject_GetLevel(oMember);
			local	sClass = Karma_MemberObject_GetClass(oMember);
			local	sKarma = Karma_MemberObject_GetKarmaModifiedForListWithColors(oMember);
			local	sMemberName_clickable = KOH.Name2Clickable(sMemberName);
			KarmaChatDebug(sMemberName .. "{" .. sKarma .. "} " .. sGuild .. iLevel .. " " .. sClass .. " online.");
			iMemberCount = iMemberCount + 1;
		end

		iResultCount = iResultCount + 1;
	end

	KarmaModuleLocal.ChannelResultCount = KarmaModuleLocal.ChannelResultCount + iResultCount;
	KarmaModuleLocal.ChannelMemberCount = KarmaModuleLocal.ChannelMemberCount + iMemberCount;

	if (KarmaObj.LFM) then
		KarmaObj.LFM.WindowUpdate();
	end
end

function Karma_CheckOnlineInChannelDone()
	if (not KarmaModuleLocal.ChannelName) then
		KarmaModuleLocal.ChannelTime = 0;
		KarmaModuleLocal.ChannelResultCount = 0;
		KarmaModuleLocal.ChannelMemberCount = 0;
		return
	end

	local	sTotal = KARMA_WINEL_FRAG_COLON .. KARMA_MSG_CHECKCHANNEL_TOTAL1 .. KARMA_WINEL_FRAG_COLONSPACE .. KarmaModuleLocal.ChannelResultCount
				.. KARMA_MSG_CHECKCHANNEL_TOTAL2 .. KarmaModuleLocal.ChannelMemberCount .. KARMA_MSG_CHECKCHANNEL_TOTAL3;
	if (type(KarmaModuleLocal.ChannelName) == "number") then
		KarmaChatSecondaryFallbackDefault(KARMA_MSG_CHECKCHANNEL_RESULTS .. " #" .. KarmaModuleLocal.ChannelName .. sTotal);
	else
		KarmaChatSecondaryFallbackDefault(KARMA_MSG_CHECKCHANNEL_RESULTS .. " <" .. KarmaModuleLocal.ChannelName .. ">" .. sTotal);
	end

	KarmaModuleLocal.ChannelTime = 0;
	KarmaModuleLocal.ChannelName = nil;
end

function KSlash.ResetGUI(args)
	Karma_MinimapIconFrame_ResetIcon();
	Karma_MinimapIconFrame_InitComplete();

	KarmaWindow:Hide();
	KarmaWindow:ClearAllPoints();
	KarmaWindow:SetPoint("CENTER");
	KarmaWindow:Show();

	if (KarmaObj.LFM) then
		KarmaObj.LFM.WindowReset();
	end

	KarmaChatDefault(KARMA_MSG_RESETGUI);
end

function Karma_AltID2Names(altid, maxperline, prefix)
	local	AltsObj = KarmaObj.DB.FactionCacheGet()[KARMA_DB_L4_RRFF.ALTGROUPS];
	if (AltsObj == nil) then
		KarmaChatDefault(KARMA_MSG_OOPS);
		return "";
	end

	if (maxperline == nil) then
		maxperline = 99;
	end
	if (prefix == nil) then
		prefix = "";
	end

	local	key, value;
	for key, value in pairs(AltsObj) do
		if (value.ID == altid) then
			local	key2, value2, iCnt, sLine;
			sLine = prefix;
			iCnt = 0;
			for key2, value2 in pairs(value.AL) do
				if (iCnt > maxperline) then
					sLine = sLine .. "\n" .. prefix;
					iCnt = 0;
				end

				sLine = sLine .. " " .. value2;
				iCnt = iCnt + 1;
			end

			return sLine;
		end
	end

	return "<Oops?>";
end

function KSlash.AltList(args)
	if (args[2] == nil) or (args[2] == "") then
		KarmaChatDefault(KARMA_MSG_COMMAND_MISSINGARG .. KARMA_WINEL_FRAG_COLONSPACE .. KARMA_MSG_ALT_REQARG);
		return
	end

	local	oMember = Karma_MemberList_GetObject(args[2]);
	if (oMember == nil) then
		KarmaChatDefault(KARMA_MSG_ALT_LIST_NOTMEMBER1 .. args[2] .. KARMA_MSG_ALT_LIST_NOTMEMBER2
							.. KARMA_WINEL_FRAG_COLONSPACE .. KARMA_MSG_COMMAND_NOTMEMBER);
		return
	end

	local	altid = Karma_MemberObject_GetAltID(oMember);
	if (altid == -1) then
		KarmaChatDefault(KARMA_MSG_ALT_LIST_NOALTS1 .. args[2] .. KARMA_MSG_ALT_LIST_NOALTS2);
		return
	end

	local	text = Karma_AltID2Names(altid);
	if (text ~= "") then
		KarmaChatDefault(KARMA_MSG_ALT_LIST_PREFIX .. tostring(altid) .. KARMA_WINEL_FRAG_COLONSPACE .. text);
	else
		KarmaChatDefault(KARMA_MSG_ALT_LIST_OOPS_NOALTS1 .. args[2] .. KARMA_MSG_ALT_LIST_OOPS_NOALTS2);
	end
end

function KSlash.AltRemove(args)
	if (args[2] == nil) or (args[2] == "") then
		KarmaChatDefault(KARMA_MSG_COMMAND_MISSINGARG .. KARMA_WINEL_FRAG_COLONSPACE .. KARMA_MSG_ALT_REQARG);
		return
	end

	local	AltsObj = KarmaObj.DB.FactionCacheGet()[KARMA_DB_L4_RRFF.ALTGROUPS];
	if (AltsObj == nil) then
		KarmaChatDefault(KARMA_MSG_OOPS);
		return
	end

	local	oMember = Karma_MemberList_GetObject(args[2]);
	if (oMember == nil) then
		KarmaChatDefault(KARMA_MSG_ALT_REM_NOTMEMBER1 .. args[2] .. KARMA_MSG_ALT_REM_NOTMEMBER2
							.. KARMA_WINEL_FRAG_COLONSPACE .. KARMA_MSG_COMMAND_NOTMEMBER);
		return
	end

	local	altid = Karma_MemberObject_GetAltID(oMember);
	if (altid == -1) then
		KarmaChatDefault(KARMA_MSG_ALT_REM_NOALTID1 .. args[2] .. KARMA_MSG_ALT_REM_NOALTID2);
		return
	end

	local	key, value;
	for key, value in pairs(AltsObj) do
		if (value.ID == altid) then
			local	subkey, subvalue;
			for subkey, subvalue in pairs(value.AL) do
				if (subvalue == args[2]) then
					tremove(value.AL, subkey);
					break;
				end
			end
			Karma_MemberObject_SetAltID(oMember, -1);
			KarmaChatDefault(KARMA_MSG_ALT_REM_DONE1 .. args[2] .. KARMA_MSG_ALT_REM_DONE2);

			return
		end
	end

	Karma_MemberObject_SetAltID(oMember, -1);
	KarmaChatDefault(KARMA_MSG_ALT_REM_OOPS_NOALTS1 .. args[2] .. KARMA_MSG_ALT_REM_OOPS_NOALTS2
						.. KARMA_WINEL_FRAG_TRIDOTS);
end

function KSlash.AltAdd(args)
	-- arg2 = A, arg3 = B, both can be on alt-groups already!
	if (args[2] == nil) or (args[2] == "") or (args[3] == nil) or (args[3] == "") then
		KarmaChatDefault(KARMA_MSG_COMMAND_MISSINGARGS .. KARMA_WINEL_FRAG_COLONSPACE .. KARMA_MSG_ALT_REQARGS);
		return
	end

	if (args[2] == args[3]) then
		KarmaChatDefault(KARMA_MSG_ALT_ADD_SAMEPLAYER);
		return
	end

	local	AltsObj = KarmaObj.DB.FactionCacheGet()[KARMA_DB_L4_RRFF.ALTGROUPS];
	if (AltsObj == nil) then
		KarmaChatDefault(KARMA_MSG_OOPS);
		return
	end

	local	oMember1 = Karma_MemberList_GetObject(args[2]);
	local	oMember2 = Karma_MemberList_GetObject(args[3]);
	if (oMember1 == nil) or (oMember2 == nil) then
		KarmaChatDefault(KARMA_MSG_ALT_ADD_NOTMEMBER);
		return
	end

	local	altid1 = Karma_MemberObject_GetAltID(oMember1);
	local	altid2 = Karma_MemberObject_GetAltID(oMember2);

	if (altid1 == -1) and (altid2 == -1) then
		-- new group
		local	max_i = 0;
		local	key, value;
		for key, value in pairs(AltsObj) do
			local	i = value.ID;
			if (i > max_i) then
				max_i = i;
			end
		end

		max_i = max_i + 1;
		local	Obj = {};
		Obj.ID = max_i;
		Obj.AL = {};
		tinsert(Obj.AL, args[2]);
		tinsert(Obj.AL, args[3]);

		tinsert(AltsObj, Obj);

		Karma_MemberObject_SetAltID(oMember1, max_i);
		Karma_MemberObject_SetAltID(oMember2, max_i);

		KarmaChatDefault(args[2] .. KARMA_MSG_ALT_ADD_DONE1 .. args[3] .. KARMA_MSG_ALT_ADD_DONE2 .. tostring(max_i));
		return
	end

	if (altid1 ~= -1) and (altid2 ~= -1) then
		if (altid1 == altid2) then
			KarmaChatDefault(KARMA_MSG_ALT_ADD_ALREADYSAME);
		else
			-- merge groups: too much work :-D TODO?
			KarmaChatDefault(KARMA_MSG_ALT_ADD_NOMERGE);
		end

		return
	end

	-- add member to group
	local	altid;
	if (altid1 == -1) then
		altid = altid2;
	else
		altid = altid1;
	end

	local	Obj;
	for key, value in pairs(AltsObj) do
		if (value.ID == altid) then
			Obj = AltsObj[key];
		end
	end

	if (altid1 == -1) then
		tinsert(Obj.AL, args[2]);
		Karma_MemberObject_SetAltID(oMember1, altid);
	else
		tinsert(Obj.AL, args[3]);
		Karma_MemberObject_SetAltID(oMember2, altid);
	end
	
	KarmaChatDefault(args[2] .. KARMA_MSG_ALT_ADD_DONE1 .. args[3] .. KARMA_MSG_ALT_ADD_DONE2 .. tostring(altid));
end

function	KSlash.AltCheck(args)
	local	bExecute = (args[2] == "execute");
	if (bExecute and KARMA_CURRENTMEMBER) then
		KarmaChatSecondary("Unsetting currently selected member to not screw up UI.");
		Karma_SetCurrentMember(nil);
	end

	-- lazy variant. could probably merge the two parses into one faster...

	local	AltsObj = KarmaObj.DB.FactionCacheGet()[KARMA_DB_L4_RRFF.ALTGROUPS];
	if (AltsObj == nil) then
		AltsObj = {};
	end

	local	lMembers = KarmaObj.DB.SF.MemberListGet();
	if (lMembers == nil) then
		lMembers = {};
	end

	for iBucketNum = 1, strlen(KARMA_ALPHACHARS) do
		local	sBucketName = strsub(KARMA_ALPHACHARS, iBucketNum, iBucketNum);
		local	lBucketMembers = lMembers[sBucketName];
		if (type(lBucketMembers) ~= "table") then
			KarmaChatDebug("Oopsie: Bucket " .. sBucketName .. " doesn't exist??!");
		else
			local	sMember, oMember;
			for sMember, oMember in pairs(lBucketMembers) do
				local	altid = Karma_MemberObject_GetAltID(oMember);
				if (altid ~= -1) then
					local	bFound;
					local	altgroupkey, altgroupvalue, altgrouplist;
					for altgroupkey, altgroupvalue in pairs(AltsObj) do
						if (altgroupvalue.ID == altid) then
							altgrouplist = AltsObj[altgroupkey];
							for altkey, altvalue in pairs(altgrouplist.AL) do
								if (sMember == altvalue) then
									bFound = true;
									break;
								end
							end

							break;
						end
					end
					if (not bFound) then
						if (bExecute) then
							KarmaChatSecondary("Alt " .. sMember .. " supposed to be in group #" .. altid .. ", but not found. Resetting " .. sMember .. ".");
							Karma_MemberObject_SetAltID(oMember, -1);
						else
							KarmaChatSecondary("Alt " .. sMember .. " supposed to be in group #" .. altid .. ", but not found. Would reset " .. sMember .. ".");
						end
					end
				end
			end
		end
	end

	local	altgroupkey, altgroupvalue, altgrouplist;
	for altgroupkey, altgroupvalue in pairs(AltsObj) do
		altgrouplist = AltsObj[altgroupkey];
		KarmaChatDebug("Checking alt group #" .. altgroupvalue.ID .. " containing: " .. Karma_AltID2Names(altgroupvalue.ID));
		for altkey, altvalue in pairs(altgrouplist.AL) do
			local	bValid;
			local	altid = -1;
			local	oMember = Karma_MemberList_GetObject(altvalue);
			if (oMember) then
				altid = Karma_MemberObject_GetAltID(oMember);
				bValid = (altgroupvalue.ID == altid);
			end

			if (not bValid) then
				if (bExecute) then
					KarmaChatSecondary("Alt " .. altvalue .. " supposed to be in group #" .. altgroupvalue.ID .. ", but disagrees. Removing from group.");
					tremove(altgrouplist.AL, altkey);
				else
					KarmaChatSecondary("Alt " .. altvalue .. " supposed to be in group #" .. altgroupvalue.ID .. ", but disagrees. Would remove from group.");
				end
			end
		end
	end
end

--- TODO ---
function KSlash.PauseWho(args)
	KarmaChatDefault(KARMA_MSG_OOPS_NOTIMPLEMENTED .. KARMA_WINEL_FRAG_TRIDOTS);
end

function KSlash.AutocheckTalents(args)
	KARMA_TalentInspect.AutofetchConfigCache = KCfg.Get("TALENTS_AUTOFETCH");
	if (KARMA_TalentInspect.AutofetchConfigCache == nil) then
		KARMA_TalentInspect.AutofetchConfigCache = 1;
	else
		KARMA_TalentInspect.AutofetchConfigCache = 1 - KARMA_TalentInspect.AutofetchConfigCache;
	end
		
	KCfg.Set("TALENTS_AUTOFETCH", KARMA_TalentInspect.AutofetchConfigCache);
	if (KARMA_TalentInspect.AutofetchConfigCache == 1) then
		KarmaChatDefault(KARMA_MSG_CONFIG_AUTOTALENTS .. KARMA_MSG_CONFIG_ISNOWON);
	else
		KarmaChatDefault(KARMA_MSG_CONFIG_AUTOTALENTS .. KARMA_MSG_CONFIG_ISNOWOFF);
	end
end

function KSlash.SkillModel(args)
	if (args[2] == "simple") then
		KCfg.Set("SKILL_MODEL", "simple");
		KARMA_SKILL_LEVELS = KARMA_SKILL_LEVELS_SIMPLE;
		KarmaChatDefault(KARMA_MSG_CONFIG_SKILLMODEL_ISNOW .. " *simple*.");
	elseif (args[2] == "complex") then
		KCfg.Set("SKILL_MODEL", "complex");
		KARMA_SKILL_LEVELS = KARMA_SKILL_LEVELS_COMPLEX;
		KarmaChatDefault(KARMA_MSG_CONFIG_SKILLMODEL_ISNOW .. " *complex*.");
	else
		KarmaChatDefault(KARMA_MSG_COMMAND_MISSINGARG .. KARMA_WINEL_FRAG_COLONSPACE .. "<[complex||simple]>");
	end
end

function	Karma_CrossFactionInfo(args)
	if (args[2] == nil) or (args[2] == "") then
		local	sName, sServer = UnitName("target");
		if (sServer and (sServer ~= "")) then
			sName = sName .. "@" .. sServer;
		end
		args[2] = sName;
	end

	if (args[2] == nil) or (args[2] == "") then
		KarmaChatDefault(KARMA_MSG_COMMAND_MISSINGARG .. KARMA_WINEL_FRAG_COLONSPACE .. KARMA_MSG_PLAYER_REQARG);
		return;
	end

	if (UnitFactionGroup("player") == "Neutral") then
		KarmaChatDefault("YOU have no faction affiliation yet.");
		return
	end

	local	mouseoverindex = tonumber(args[2]);
	if (mouseoverindex) and (mouseoverindex > 0) then
		args[2] = KarmaModuleLocal.MouseOverKeepList[mouseoverindex].Name;
	end

	local	bFound = false;

	local	oXFaction = KarmaObj.DB.FactionOtherGet();
	if (oXFaction) and (type(oXFaction) == "table") then
		oXlMembers = oXFaction[KARMA_DB_L4_RRFF.MEMBERBUCKETS];
		if (oXlMembers) and (type(oXlMembers) == "table") then
			local	XBucketkey = KarmaObj.NameToBucket(args[2]);
			local	oXlBucket = oXlMembers[XBucketkey];
			if (oXlBucket) and (type(oXlBucket) == "table") then
				local	oXMember = oXlBucket[args[2]];
				if (oXMember) then
					local	sGuild = Karma_MemberObject_GetGuild(oXMember);
					if (sGuild) and (sGuild ~= "") then
						sGuild = " <" .. sGuild .. ">";
					else
						sGuild = "";
					end
					local	sKarma = Karma_MemberObject_GetKarmaWithModifiers(oXMember);
					local	sNote = Karma_MemberObject_GetNotes(oXMember);
					if (sNote) and (sNote ~= "") then
						sNote = "- Notes: " .. sNote;
					else
						sNote = "- no notes.";
					end

					KarmaChatDefault("|cFFFF8080" .. args[2] .. "|r " .. sGuild .. " {" .. sKarma .. "} " .. sNote);
					bFound = true;
				end
			end
		end
	end

	if (not bFound) then
		-- to do: localize
		local	xFaction;
		if (UnitFactionGroup("player") == "Horde") then
			xFaction = "Alliance";
		else
			xFaction = "Horde";
		end

		KarmaChatDefault("Player >" .. args[2] .. "< is not listed on Karma's table for the " .. xFaction .. ".");
	end
end

function	Karma_CrossFactionNote(args)
	if	(args[2] == nil) or (args[2] == "") or
		(args[3] == nil) or (args[3] == "") or
		(args[4] == nil) or (args[4] == "") then
		-- to do: localize
		KarmaChatDefault(KARMA_MSG_COMMAND_MISSINGARG .. KARMA_WINEL_FRAG_COLONSPACE .. "<playername or mouseover-index> +/-/!<Karma> +/!<Note> (where +: add, -: take away, !: set to value)");
		return;
	end

	if (UnitFactionGroup("player") == "Neutral") then
		KarmaChatDefault("YOU have no faction affiliation yet.");
		return
	end

	local	mouseoverindex = tonumber(args[2]);
	if (mouseoverindex) and (mouseoverindex > 0) then
		args[2] = KarmaModuleLocal.MouseOverKeepList[mouseoverindex].Name;
	end

	local	argModKarma = strsub(args[3], 1, 1);
	local	argValKarma = tonumber(strsub(args[3], 2));
	if ((argModKarma ~= "+") and (argModKarma ~= "-") and (argModKarma ~= "!")) or (argValKarma == nil) then
		-- to do: localize
		KarmaChatDefault("Second argument must be: +/-/!<Karma>");
		return;
	end

	local	argModNote = strsub(args[4], 1, 1);
	local	argValNote = strsub(args[4], 2);
	if (argModNote ~= "+") and (argModNote ~= "!") then
		-- to do: localize
		KarmaChatDefault("Third argument must be: +/!<Note>");
		return;
	end
	local	i = 5;
	while (args[i] ~= nil) do
		argValNote = argValNote .. " " .. args[i];
		i = i + 1;
	end

	local	xFaction;
	if (UnitFactionGroup("player") == "Horde") then
		xFaction = "Alliance";
	else
		xFaction = "Horde";
	end

	if (mouseoverindex) then
		if (xFaction ~= KarmaModuleLocal.MouseOverKeepList[mouseoverindex].Faction) then
			-- to do: localize
			KarmaChatDefault("Player is on *YOUR* faction. This command is for cross-faction players.");
			return;
		end
	end

	local	bFound = false;
	if (xFaction) then
		local	oXFaction = KarmaObj.DB.FactionOtherGet();
		if (oXFaction) and (type(oXFaction) == "table") then
			local	oXlMembers = oXFaction[KARMA_DB_L4_RRFF.MEMBERBUCKETS];
			if (oXlMembers) and (type(oXlMembers) == "table") then
				local	XBucketkey = KarmaObj.NameToBucket(args[2]);
				local	oXlBucket = oXlMembers[XBucketkey];
				if (oXlBucket) and (type(oXlBucket) == "table") then
					local	oXMember = oXlBucket[args[2]];
					if (oXMember) then
						local	iKarma = KarmaObj.DB.M.KarmaGet(oXMember);
						local	sKarma = Karma_MemberObject_GetKarmaWithModifiers(oXMember);
						local	sNote = Karma_MemberObject_GetNotes(oXMember);
						if (sNote) and (sNote ~= "") then
							sNote = "- Notes: " .. sNote;
						else
							sNote = "- no notes.";
						end

						-- to do: localize
						KarmaChatDefault("Modifying entry for |cFFFF8080" .. args[2] .. "|r {" .. sKarma .. "} " .. sNote);

						argValKarma = floor(argValKarma);
						if (argModKarma == "+") then
							iKarma = iKarma + argValKarma;
						elseif (argModKarma == "-") then
							iKarma = iKarma - argValKarma;
						elseif (argModKarma == "!") then
							iKarma = argValKarma;
						end
						if (iKarma < 1) or (iKarma > 100) then
							iKarma = math.max(1, math.min(100, iKarma));
							KarmaChatDefault("Karma change: " .. argModKarma .. argValKarma .. " results in invalid Karma value. Changed to " .. iKarma ..".");
						end
						KarmaObj.DB.M.KarmaSet(oXMember, iKarma);

						sNote = Karma_MemberObject_GetNotes(oXMember);
						if (argValNote and (argValNote ~= "")) then
							argValNote = argValNote .. "\n";
						end
						if (argModNote == "+") then
							sNote = sNote .. argValNote;
						elseif (argModNote == "!") then
							sNote = argValNote;
						end
						Karma_MemberObject_SetNotes(oXMember, sNote);

						sKarma = Karma_MemberObject_GetKarmaWithModifiers(oXMember);
						if (sNote) and (sNote ~= "") then
							sNote = "- Notes: " .. sNote;
						else
							sNote = "- no notes.";
						end

						-- to do: localize
						KarmaChatDefault("Changed entry reads as |cFFFF8080" .. args[2] .. "|r {" .. sKarma .. "} " .. sNote);

						bFound = true;
					end
				end
			end
		end

		if (not bFound) then
			KarmaObj.DB.FactionXHoldCreate();
			local	oXlMembers = KarmaObj.DB.FactionXHoldGet(xFaction);
			KOH.TableInit(oXlMembers, args[2]);
			local	oXMember = oXlMembers[args[2]];
			oXMember[KARMA_DB_L5_RRFFM.NAME] = args[2];
			oXMember[KARMA_DB_L5_RRFFX_KARMA] = args[3];
			oXMember[KARMA_DB_L5_RRFFM_NOTES] = argModNote .. argValNote;
			oXMember[KARMA_DB_L5_RRFFM_TIMESTAMP] = time();
			oXMember[KARMA_DB_L5_RRFFX_SOURCE] = UnitName("player");
			if (mouseoverindex) then
				local	value = KarmaModuleLocal.MouseOverKeepList[mouseoverindex];
				oXMember[KARMA_DB_L5_RRFFM.LEVEL] = value.Level;
				oXMember[KARMA_DB_L5_RRFFM.GUID] = value.GUID;
				oXMember[KARMA_DB_L5_RRFFM.RACE] = value.Race;
				oXMember[KARMA_DB_L5_RRFFM.RACE_EN] = value.RaceEN;
				oXMember[KARMA_DB_L5_RRFFM.CLASS] = value.Class;
				oXMember[KARMA_DB_L5_RRFFM.CLASS_EN] = value.ClassEN;
				oXMember[KARMA_DB_L5_RRFFX_FACTION] = xFaction;
			end

			-- to do: localize
			KarmaChatDefault("Stored entry for " .. args[2] .. " in holding space. You'll have to login at the \"other\" side to let Karma add the player to its list and update them accordingly.");
		end
	end
end

function	Karma_CrossFactionUpdate(args)
	local	CmdQLen = KarmaObj.Slash.CommandQLen();
	if (CmdQLen > 0) then
		-- to do: localize
		KarmaChatDefault("Command queue must be empty for this... (" .. CmdQLen .. " commands pending)");
		return;
	end

	if (UnitFactionGroup("player") == "Neutral") then
		KarmaChatDefault("YOU have no faction affiliation yet.");
		return
	end

	KarmaChatDefault("Starting cross-faction update...");

	local	sQueued = "";
	local	sSkipped = nil;

	local	olMembers = KarmaObj.DB.FactionXHoldGet();
	if (olMembers) and (type(olMembers) == "table") then
		local	oMember, bExecute;
		local	args = {};
		for key, value in pairs(olMembers) do
			KarmaChatSecondary("Looking at entry for >" .. key .. "< created by " .. value[KARMA_DB_L5_RRFFX_SOURCE] .. " on " .. date("%Y-%m-%d %H:%M", value[KARMA_DB_L5_RRFFM_TIMESTAMP]));
			oMember = Karma_MemberList_GetObject(key);
			if (oMember == nil) then
				sQueued = sQueued .. " " .. key;
				args[2] = key;
				Karma_Command_AddMember_Insert(args);
				KarmaChatSecondary("Trying to add >" .. key .. "< to Karma's list first... (must be online for that!) Reissue the command to actually store the information.")
			elseif (key == KARMA_CURRENTMEMBER) then
				sSkipped = key;
				KarmaChatSecondary("Couldn't update " .. key ..": currently selected in Karma's main window. Result of a potential note change is not definite. Holding off.");
			else
				bExecute = true;
				local	sError = "";

				-- verify: GUID, Race, Level, Class, Faction
				if	(value.GUID) then
					local	sGUID = Karma_MemberObject_GetGUID(oMember);
					if (sGUID) and (sGUID ~= "") then
						if (value.GUID ~= sGUID) then
							bExecute = false;
							sError = sError .. " GUID";
						end
					end
				end

				if	(value.Race) then
					local	sRace = Karma_MemberObject_GetRace(oMember);
					if (sRace) and (sRace ~= "") then
						if (value.Race ~= sRace) then
							bExecute = false;
							sError = sError .. " race";
						end
					end
				end

				if	(value.Level) then
					local	iLevel = Karma_MemberObject_GetLevel(oMember);
					if (iLevel) and (iLevel ~= 0) then
						if (value.Level > iLevel) then
							bExecute = false;
							sError = sError .. " level";
						end
					end
				end

				if	(value.Class) then
					local	sClass = Karma_MemberObject_GetClass(oMember);
					if (sClass) and (sClass ~= "") then
						if (value.Class ~= sClass) then
							bExecute = false;
							sError = sError .. " class";
						end
					end
				end

				if	(value.Faction) then
					if (value.Faction ~= UnitFactionGroup("player")) then
						bExecute = false;
						sError = sError .. " faction";
					end
				end

				if (not bExecute) then
					-- to do: localize
					KarmaChatSecondary("Couldn't update " .. key .." due to mismatch:" .. sError);
				else
					local	iKarma = KarmaObj.DB.M.KarmaGet(oMember);
					local	sKarma = Karma_MemberObject_GetKarmaWithModifiers(oMember);
					local	sNote = Karma_MemberObject_GetNotes(oMember);
					if (sNote) and (sNote ~= "") then
						sNote = "- Notes: " .. sNote;
					else
						sNote = "- no notes.";
					end

					-- to do: localize
					KarmaChatDefault("Modifying entry for |cFF80FF80" .. key .. "|r {" .. sKarma .. "} " .. sNote);

					if (value.GUID) then
						local	sGUID = Karma_MemberObject_GetGUID(oMember);
						if (sGUID == nil) then
							KarmaChatSecondary("There was no GUID for " .. key .. ", entering the cross-faction one!");
							Karma_MemberObject_SetGUID(oMember, value.GUID);
						end
					end

					local	argModKarma = strsub(value[KARMA_DB_L5_RRFFX_KARMA], 1, 1);
					local	argValKarma = tonumber(strsub(value[KARMA_DB_L5_RRFFX_KARMA], 2));

					argValKarma = floor(argValKarma);
					if (argModKarma == "+") then
						iKarma = iKarma + argValKarma;
					elseif (argModKarma == "-") then
						iKarma = iKarma - argValKarma;
					elseif (argModKarma == "!") then
						iKarma = argValKarma;
					end
					if (iKarma < 1) or (iKarma > 100) then
						iKarma = math.max(1, math.min(100, iKarma));
						KarmaChatDefault("Karma change: " .. value[KARMA_DB_L5_RRFFX_KARMA] .. " results in invalid Karma value. Changed to " .. iKarma);
					end
					KarmaObj.DB.M.KarmaSet(oMember, iKarma);

					local	argModNote = strsub(value[KARMA_DB_L5_RRFFM_NOTES], 1, 1);
					local	argValNote = strsub(value[KARMA_DB_L5_RRFFM_NOTES], 2);

					sNote = Karma_MemberObject_GetNotes(oMember);
					if (argValNote and (argValNote ~= "")) then
						argValNote = argValNote .. "\n";
					end
					if (argModNote == "+") then
						sNote = sNote .. argValNote;
					elseif (argModNote == "!") then
						sNote = argValNote;
					end
					Karma_MemberObject_SetNotes(oMember, sNote);

					sKarma = Karma_MemberObject_GetKarmaWithModifiers(oMember);
					if (sNote) and (sNote ~= "") then
						sNote = "- Notes: " .. sNote;
					else
						sNote = "- no notes.";
					end

					-- to do: localize
					KarmaChatSecondary("Changed entry reads as |cFF80FF80" .. key .. "|r {" .. sKarma .. "} " .. sNote);
	
					-- entry done, drop
					olMembers[key] = nil;
				end
			end
		end
	end

	if (sQueued ~= "") then
		KarmaChatDefault("-- Queued to add first:" .. sQueued);
	end
	if (sSkipped) then
		KarmaChatDefault("-- Skipped (selected): " .. sSkipped);
	end
	KarmaChatDefault("***")
end

function	Karma_MemberForceNew(args)
	if (args[2] == nil) or (args[2] == "") then
		KarmaChatDefault("Missing argument: <player>");
		return;
	end

	do
		local	lMembers = KarmaObj.DB.SF.MemberListGet();
		local	sBucketName = KarmaObj.NameToBucket(args[2]);
		if (lMembers[sBucketName][args[2]] == nil) then
			KarmaChatDefault("Invalid argument: >" .. args[2] .. "< not on Karma's list.");
			return;
		end

		if (args[2] == KARMA_CURRENTMEMBER) then
			Karma_SetCurrentMember(nil);
		end
	
		local	sDate = date("%Y%m%d", time());
		local	i = 1;
		local	key = args[2] .. "." .. sDate .. ":" .. i;
		while (lMembers[sBucketName][key] ~= nil) do
			i = i + 1;
		end
	
		-- store as version to a new key
		lMembers[sBucketName][key] = lMembers[sBucketName][args[2]];
		Karma_MemberObject_SetName(lMembers[sBucketName][key], key);

		if (type(lMembers[sBucketName][key][KARMA_DB_L5_RRFFM_CONFLICT]) == "table") then
			if (lMembers[sBucketName][key][KARMA_DB_L5_RRFFM_CONFLICT].Resolved == 0) then
				lMembers[sBucketName][key][KARMA_DB_L5_RRFFM_CONFLICT].Resolved = time();
			end
		end

		-- unlink the two entries
		lMembers[sBucketName][args[2]] = nil;
	end

	Karma_MemberList_Add(args[2]);
	Karma_MemberList_Update(args[2]);
	Karma_MemberList_CreatePartyNamesCache();
	Karma_MemberList_ResetMemberNamesCache();
end

function	Karma_MemberForceUpdate(args)
	if (args[2] == nil) or (args[2] == "") then
		KarmaChatDefault("Missing argument: <player>");
		return;
	end

	do
		local	oMember = Karma_MemberList_GetObject(args[2]);
		if (oMember == nil) then
			KarmaChatDefault("Invalid argument: >" .. args[2] .. "< not on Karma's list.");
		end
	
		oMember[KARMA_DB_L5_RRFFM.GUID] = nil;
		oMember[KARMA_DB_L5_RRFFM.LEVEL] = 0;
		oMember[KARMA_DB_L5_RRFFM.CLASS_ID] = 0;
		oMember[KARMA_DB_L5_RRFFM.RACE] = "";
		oMember[KARMA_DB_L5_RRFFM.RACE_EN] = nil;
		oMember[KARMA_DB_L5_RRFFM.LASTCHANGED_TIME] = time();
		oMember[KARMA_DB_L5_RRFFM.LASTCHANGED_FIELD] = "forced update";

		if (type(oMember[KARMA_DB_L5_RRFFM_CONFLICT]) == "table") then
			if (oMember[KARMA_DB_L5_RRFFM_CONFLICT].Resolved == 0) then
				oMember[KARMA_DB_L5_RRFFM_CONFLICT].Resolved = time();
			end
		end
	end

	KarmaChatDefault("Player " .. KOH.Name2Clickable(args[2]) .. " has been reset.");
	Karma_MemberList_Update(args[2]);
	Karma_MemberList_CreatePartyNamesCache();
	Karma_MemberList_ResetMemberNamesCache();

	KSlash.Update(args, 2);
end

function	Karma_MemberForceCheck(args)
	local	bExecute = (args[2] == "execute");
	if (bExecute and KARMA_CURRENTMEMBER) then
		KarmaChatSecondary("Unsetting currently selected member to not screw up UI.");
		Karma_SetCurrentMember(nil);
	end

	local	lMembers = KarmaObj.DB.SF.MemberListGet();
	if (lMembers == nil) then
		lMembers = {};
	end

	local	iBucketNum;
	for iBucketNum = 1, strlen(KARMA_ALPHACHARS) do
		local	sBucketName = strsub(KARMA_ALPHACHARS, iBucketNum, iBucketNum);
		local	lBucketMembers = lMembers[sBucketName];
		if (type(lBucketMembers) ~= "table") then
			KarmaChatDebug("Oopsie: Bucket " .. sBucketName .. " doesn't exist??!");
		else
			local	sMember, oMember;
			for sMember, oMember in pairs(lBucketMembers) do
				if (sMember ~= Karma_MemberObject_GetName(oMember)) then
					KarmaChatSecondary("Mismatch due to forcenew: " .. sMember .. " =!= " .. Karma_MemberObject_GetName(oMember));
					if (bExecute) then
						KarmaChatSecondary("Overwriting former name with metakeyed name.");
						Karma_MemberObject_SetName(oMember, sMember);
					end
				end
			end
		end
	end
end

function	KSlash.PubNoteSet(args)
	if	(args[2] == nil) or (args[2] == "") or
		(args[3] == nil) or (args[3] == "") then
		KarmaChatDefault("Missing arguments: <player> <note>");
		return;
	end

	local	oMember =  Karma_MemberList_GetObject(args[2]);
	if (oMember == nil) then
		KarmaChatDefault("Player <" .. args[2] .. "> unknown.");
		return;
	end

	local	sNote = args[3];
	local	i = 4;
	while (args[i]) do
		sNote = sNote .. " " .. args[i];
		i = i + 1;
	end

	Karma_MemberObject_SetPublicNotes(oMember, sNote);
	KarmaChatDefault("Public note for player <" .. args[2] .. "> reads now: " .. sNote);
end

function	KSlash.PubNoteGet(args)
	if (args[2] == nil) or (args[2] == "") then
		KarmaChatDefault("Missing argument: <player>");
		return;
	end

	local	oMember =  Karma_MemberList_GetObject(args[2]);
	if (oMember == nil) then
		KarmaChatDefault("Player <" .. args[2] .. "> unknown.");
		return;
	end

	local	sNote = Karma_MemberObject_GetPublicNotes(oMember) or "";
	KarmaChatDefault("Public note for player <" .. args[2] .. "> is currently: " .. sNote);
end

function	KSlash.PubNoteClear(args)
	if (args[2] == nil) or (args[2] == "") then
		KarmaChatDefault("Missing argument: <player>");
		return;
	end

	local	oMember =  Karma_MemberList_GetObject(args[2]);
	if (oMember == nil) then
		KarmaChatDefault("Player <" .. args[2] .. "> unknown.");
		return;
	end

	local	sNote = Karma_MemberObject_GetPublicNotes(oMember) or "";
	Karma_MemberObject_SetPublicNotes(oMember, "");
	KarmaChatDefault("Public note for player <" .. args[2] .. "> deleted. Previously, it was set to: " .. sNote);
end

function	KSlash.WIMModule(args)
	local	Set_b, Set_s;
	if (KarmaConfig.WIM == 1) then
		Set_s = "disabled";
		Set_b = 0;
	else
		Set_s = "enabled";
		Set_b = 1;
	end
	KarmaChatDefault("Karma's WIM module will be " .. Set_s .. " at next re-initialization.");
	KarmaConfig.WIM = Set_b;
end

function	KSlash.ShareConfig(args)
	if ((args[2] == nil) or (args[2] == "")) then
		KarmaChatDefault("Insufficient arguments: <category> <value>.");
		KarmaChatDefault("For categories 'karma' or 'pubnote' (for public note), the following values are valid: 0 = never, 1 = always, 2 = via GUILD, 3 = with trusted people only (n.y.i.).");
		KarmaChatDefault("For category 'channel', 'value' is the name of the channel to use, or nothing to reset.");

		local	iKarma = 0;
		local	iPubNote = 0;
		local	sChan = "<none>";
		if (KCfg.Get("SHARE_ONREQ_KARMA") ~= nil) then
			iKarma = KCfg.Get("SHARE_ONREQ_KARMA");
		end
		if (KCfg.Get("SHARE_ONREQ_PUBLICNOTE") ~= nil) then
			iPubNote = KCfg.Get("SHARE_ONREQ_PUBLICNOTE");
		end
		if (KCfg.Get("SHARE_CHANNEL_NAME") ~= nil) then
			sChan = KCfg.Get("SHARE_CHANNEL_NAME");
		end
		KarmaChatDefault("Current settings: 'karma' -> " .. iKarma .. ", 'pubnote' -> " .. iPubNote .. ", 'channel' -> " .. sChan);
		return;
	end

	if ((args[2] ~= "karma") and (args[2] ~= "pubnote") and (args[2] ~= "channel")) then
		KarmaChatDefault("Category invalid: <" .. args[2] .. ">. ");
		return;
	end

	-- channel
	if (args[2] == "channel") then
		if ((args[3] == nil) or (args[3] == "")) then
			KCfg.Set("SHARE_CHANNEL_NAME", nil);
			args[3] = "<none>";
		else
			KCfg.Set("SHARE_CHANNEL_NAME", args[3]);
		end

		KarmaModuleLocal.Channels[0] = nil;
		KarmaChatDefault("Channel for sharing is now: " .. args[3]);
		return
	end


	-- karma, pubnote

	if (args[3] == nil) then
		args[3] = "";
	end
	local	iValue = tonumber(args[3]);
	if (iValue == 0) and (args[3] ~= "0") then
		KarmaChatDefault("Mode invalid: <" .. args[2] .. ">. Valid modes are 0, 1, 2, 3.");
		return;
	end

	local	sMode = "never";
	if (iValue == 1) then
		sMode = "always";
	elseif (iValue == 2) then
		sMode = "via GUILD";
	elseif (iValue == 3) then
		sMode = "with trusted people";
	end

	-- 0: never, 1: always, 2: via GUILD, 3: with trusted people only
	if (args[2] == "karma") then
		KCfg.Set("SHARE_ONREQ_KARMA", iValue);
		KarmaChatDefault("Sharemode for Karma is now: " .. sMode);
	end
	if (args[2] == "pubnote") then
		KCfg.Set("SHARE_ONREQ_PUBLICNOTE", iValue);
		KarmaChatDefault("Sharemode for public note is now: " .. sMode);
	end
end

function	KSlash.ShareQuery(args, iCounter, internal)
	if (args[2] == nil) or (args[2] == "") or (args[3] == nil) or (args[3] == "") then
		if (internal == nil) then
			KarmaChatDefault("Missing arguments: <audience> <player>");
			KarmaChatDefault("<Audience> is $guild, #channel or another player. <Player> is the player you want information about.");
		end

		return false;
	end

	local	sChanKarma = KCfg.Get("SHARE_CHANNEL_NAME");
	local	bChan = strsub(args[2], 1, 1) == "#"
	if (bChan) then
		if (sChanKarma and (sChanKarma ~= "")) then
			args[2] = "#" .. sChanKarma;
		else
			return true;
		end
	end

	local	bMeta = strsub(args[2], 1, 1) == "$";
	if (internal == nil) then
		local	sAudience;
		if (bChan) then
			sAudience = "in " .. args[2];
		elseif (bMeta) then
			sAudience = "in " .. strlower(strsub(args[2], 2));
		else
			sAudience = args[2];
		end
		local	oMember = Karma_MemberList_GetObject(args[3]);
		if (oMember) then
			KarmaChatDefault("Asking " .. sAudience .. " about <" .. args[3] .. ">, results will be silently collected.");
		else
			KarmaChatDefault("Asking " .. sAudience .. " about <" .. args[3] .. ">.");
		end
	else
		KarmaChatDebug("Internal SSQ (internal = true)");
	end

	-- "?p" - request
	local	bResult = false;
	if (bChan) then
		local	KarmaChatFunc;
		if (internal == nil) then
			KarmaChatFunc = KarmaChatSecondaryFallbackDefault;
		else
			KarmaChatFunc = KarmaChatDebug;
		end
		local	sName = KCfg.Get("SHARE_CHANNEL_NAME");
		if (sName == nil) then
			KarmaChatFunc("Sharequery failed: No channel yet defined for " .. KARMA_ITSELF .. " to use for requests. You have to define one with '/" .. KARMA_CMDSELF .. " shareconfig channel <name>'.");
		else
			local	iID = GetChannelName(sName);
			if (iID == 0) then
				KarmaChatFunc("Sharequery failed: You have not joined channel #" .. sName .. " yet!");
			else
				if (KarmaModuleLocal.Channels[0]) then
					local	iChan = KarmaModuleLocal.Channels[0].Number; 
					if (iChan and (iChan > 0)) then		--  = 194,167
						local	sDecReq = args[3];
						local	sEncReq = "";
						while (sDecReq ~= "") do
							local	iMulti;
							local	iRand = random(1, 5);
							if (iRand == 1) then
								sEncReq = sEncReq .. "+";
								iMulti = 121;	-- 17
							elseif (iRand == 2) then
								sEncReq = sEncReq .. "-";
								iMulti = 230;	-- 19
							elseif (iRand == 3) then
								sEncReq = sEncReq .. "!";
								iMulti = 190;	-- 23
							elseif (iRand == 4) then
								sEncReq = sEncReq .. "?";
								iMulti = 195;	-- 29
							else
								sEncReq = sEncReq .. "=";
								iMulti = 199;	-- 31
							end

							if (iMulti) then
								local	iVal = strbyte(sDecReq, 1, 1);
								if (iVal and iVal ~= 0) then
									sEncReq = sEncReq .. format("%03d", (iVal * iMulti) % 257);
								else
									sEncReq = "";
									sDecRec = "";
								end
							else
								sEncReq = "";
								sDecRec = "";
							end
							if (sDecReq ~="") then
								sDecReq = strsub(sDecReq, 2);
							end
						end
						if (sEncReq ~= "") then
							SendChatMessage("\194\167KARMA:?p1:" .. sEncReq, "CHANNEL", nil, iChan);
							bResult = true;
						else
							KarmaChatDefault("Oops! Error in encoding name <" .. args[3] .. ">. Please report this error back!");
						end
					else
						KarmaChatFunc("Sharequery failed: Channel #" .. sName .. " not recognized as private yet. Say something there!");
					end
				else
						KarmaChatFunc("Sharequery failed: Channel status of #" .. sName .. " unknown, waiting for more chatter.");
				end
			end
		end
	elseif (bMeta) then
		SendAddonMessage("KARMA", "?p1:" .. args[3], strupper(strsub(args[2], 2)));
		bResult = true;
	else
		SendAddonMessage("KARMA", "?p1:" .. args[3], "WHISPER", args[2]);
		bResult = true;
	end

	return bResult;
end

function	KSlash.Raid(args, iCounter)
	if (iCounter < 2) then
		KarmaChatDefault("Missing arguments: <option> <switch>");
		KarmaChatDefault("<Options> are: trackall, hidegroup. <Switches> are on/off/toggle.");
		return
	end

	local	sOutputsub = "currently ";

	local	tValue;
	if (iCounter == 3) then
		local	sSwitch = strlower(args[3]);
		if (sSwitch == "on") then
			tValue = 1;
		elseif (sSwitch == "off") then
			tValue = 0;
		elseif (sSwitch == "toggle") then
			tValue = -1;
		else
			KarmaChatDefault("Valid <switches> are on/off/toggle.");
			return
		end
	end

	local	sOutputsub = "currently ";
	if (tValue) then
		sOutputsub = "now ";
	end

	local	sKey, sOutput;
	local	sOption = strlower(args[2]);
	if (sOption == "trackall") then
		sKey = "RAID_TRACKALL";
		sOutput = "Tracking the whole raid is ";
	elseif (sOption == "hidegroup") then
		sKey = "RAID_NOGROUP";
		sOutput = "Hiding the group in raids is ";
	else
		KarmaChatDefault("Valid <options> are: trackall, hidegroup.");
		return
	end

	local	bEnabled = 1 == KCfg.Get(sKey);
	if (tValue) then
		if (tValue == -1) then
			bEnabled = not bEnabled;
		else
			bEnabled = tValue == 1;
		end

		if (bEnabled) then
			KCfg.Set(sKey, 1);
		else
			KCfg.Set(sKey, 0);
		end
	end

	local	sEnabled = "off";
	if (bEnabled) then
		sEnabled = "on";
	end

	KarmaChatDefault(sOutput .. sOutputsub .. sEnabled .. ".");
end

function	KSlash.DBSparse(args, iCounter)
	if (KCfg.Get("DB_SPARSE") ~= 1) then	-- dbsparse
		KarmaChatDefault("DBSparse: Sparse tables mode is not enabled.");
		return
	end

	if ((args[2] == nil) or (args[2] == "")) then
		KarmaChatDefault("DBSparse: Missing parameter <character/pattern>. Valid parameters are e.g. Arwen, Ar* or *. If no star is at the end, the name must match exactly. If there is a star, the name must start exactly like the pattern.");
		return
	end

	local	bDrop = args[3] == "execute";
	if (bDrop) then
		KarmaChatDefault("DBSparse: Execute given, will *actually* delete tables without information!");
	else
		KarmaChatDefault("DBSparse: 2nd parameter 'execute' not given, only giving information about contents of tables.");
	end

	local	iDropped = KarmaObj.DB.SF.Sparsify(args[2], bDrop);
	if (iDropped > 0) then
		if (bDrop) then
			KarmaChatDefault("DBSparse: Dropped " .. iDropped .. " tables without information.");
		else
			KarmaChatDefault("DBSparse: Found " .. iDropped .. " tables without information.");
		end
	else
		KarmaChatDefault("DBSparse: Database is already sparse (for this server/faction).");
	end
end

function	KSlash.Tracking(args, iCounter)
	if ((args[2] == nil) or (args[2] == "") or (args[3] == nil) or (args[3] == "")) then
		KarmaChatDefault("Missing arguments to command: <enable||disable||status> <quests||zones||regions||achievements||achieve:cutthroat>");
		return
	end

	local	sField;
	if (args[3] == "quests") then
		sField = "TRACK_DISABLEQUEST";
	elseif (args[3] == "zones") then
		sField = "TRACK_DISABLEZONE";
	elseif (args[3] == "regions") then
		sField = "TRACK_DISABLEREGION";
	elseif (args[3] == "achievements") then
		sField = "TRACK_DISABLEACHIEVEMENT";
	elseif (args[3] == "achieve:cutthroat") then
		sField = "TRACK_DISABLEACHIEV_TERROR";
	end
	if (sField == nil) then
		KarmaChatDefault("Second argument to command must be one of: <quests||zones||regions||achievements||achieve:cutthroat>");
		return
	end

	local	sFrag = "now";
	if (args[2] == "enable") then
		KCfg.Set(sField, 0);
	elseif (args[2] == "disable") then
		KCfg.Set(sField, 1);
	elseif (args[2] == "status") then
		sFrag = "currently";
	else
		KarmaChatDefault("First argument to command must be one of: <enable||disable||status>");
		return
	end

	local	value = KCfg.Get(sField);
	if (value == 1) then
		KarmaChatDefault("Tracking of <" .. args[3] .. "> is " .. sFrag .. " DISabled.");
	else
		KarmaChatDefault("Tracking of <" .. args[3] .. "> is " .. sFrag .. " enabled.");
	end
end

function	KSlash.CmdAddOffline(args, iCounter)
	local	i;
	for i = 1, 5 do
		if ((args[i] == nil) or (args[i] == "")) then
			iCounter = i - 1;
			break;
		end
	end

	if (iCounter < 5) then
		KarmaChatDefault("Missing arguments to <addoffline>: <name> <sex> <race> <class>. Additional arguments will be stored as comment.");
		return
	end

	local	oMember = Karma_Memberlist_GetObject(args[2]);
	if (oMember) then
		KarmaChatDefault("Skipping action, player is already on Karma's list: " .. args[2]);
		return
	end

	local	ClassID = KOH.ClassToID(args[5]);
	if (ClassID == 0) then
		KarmaChatDefault("Class not recognized: " .. args[5]);
		return
	end

	local	sComment;
	if (args[6]) then
		sComment = args[6];
		local	i = 7;
		while (args[i]) do
			sComment = sComment .. " " .. args[i];
			i = i + 1;
		end
	end

	local	sName = args[2];
	Karma_MemberList_Add(sName);
	Karma_MemberList_Update(sName, nil, args[5], args[4]);

	local	oMember = Karma_MemberList_GetObject(sName);
	oMember[KARMA_DB_L5_RRFFM.GENDER] = tonumber(args[3]);

	if (sComment) then
		oMember[KARMA_DB_L5_RRFFM_NOTES] = sComment;
	end

	KarmaChatDefault("Player has been added to Karma's list: " .. args[2]);
end

local	function	Karma_LoadHistory()
	local	bLoaded = IsAddOnLoaded("KarmaHistory");
	if (not bLoaded) then
		local	name, title, notes, enabled, loadable, reason = GetAddOnInfo("KarmaHistory");
		if (not enabled) then
			KarmaChatDefault("Can't load historic database: |cFFFF8080module disabled.|r");
		elseif (not loadable) then
			if (reason == "MISSING") then
				KarmaChatSecondaryFallbackDefault("Can't load historic database: |cFF8080FFmodule not installed.|r");
			else
				KarmaChatSecondaryFallbackDefault("Can't load historic database: |cFFFF4040module can't be loaded.|r (" .. tostring(reason) .. ")");
			end
		else
			KarmaChatSecondaryFallbackDefault("Trying to load historic database module...");
			local	sWhyNot;
			bLoaded, sWhyNot = LoadAddOn("KarmaHistory");
			if (bLoaded) then
				if (not KarmaObj.History) then
					KarmaChatSecondaryFallbackDefault("Failed to initialize historic database module!");
				end
			else
				KarmaChatSecondaryFallbackDefault("Failed to load historic database module: " .. sWhyNot);
			end
		end
	end

	return bLoaded;
end

function	KSlash.History(args, iCounter, bInternal)
	local	bLoaded = Karma_LoadHistory();
	if (bLoaded) then
		if (KarmaObj.History) then
			KarmaObj.History.Update(args[2], bInternal);
		end
	end
end

function	KSlash.LFM(args, iCounter)
	KarmaChatDefault("Command not valid: LFM module is not loaded.");
end

-----------------------------------------
-- Import/Export Database Commands
-----------------------------------------

function KSlash.Export(args)
	if (KARMATRANS_AVAILABLE ~= nil) then
		if (KARMATRANS_AVAILABLE == 0) then
			KarmaChatDefault("No export, KarmaTrans available but not fully initialized.");
			return;
		else
			KarmaExp = nil;
		end
	else
		KarmaData["_EXP_"] = nil;
	end

	if (args[2] ~= nil) and (args[2] ~= "") then
		local	lNames = {};
		if (args[2] == "*") then
			local	lMembers = KarmaObj.DB.SF.MemberListGet();
			local	BucketName, Bucket;
			for BucketName, Bucket in pairs(lMembers) do
				local	MemberName, MemberBucket;
				for MemberName, MemberBucket in pairs(Bucket) do
					table.insert(lNames, MemberName);
				end
			end
		elseif (strsub(args[2], 2, 1) == "*") then
			-- allow one bucket as export: A* = bucket["A"]
			local	lMembers = KarmaObj.DB.SF.MemberListGet();
			if (lMembers[strsub(args[2], 1, 1)] ~= nil) then
				local	MemberName, MemberBucket;
				for MemberName, MemberBucket in pairs(lMembers[strsub(args[2], 1, 1)]) do
					table.insert(lNames, MemberName);
				end
			end
		end
		KarmaChatDefault("Trying to export " .. #lNames .. " entries" .. KARMA_WINEL_FRAG_TRIDOTS);
		for Index, Member in pairs(lNames) do
			KarmaObj.DB.ExportOne(Member);
		end
		KarmaChatDefault("Export of " .. #lNames .. " entries completed.");
	else
		KarmaChatDefault("Removing export data.");
		KarmaData["_EXP_"] = nil;
	end
end

function KSlash.Import(args)
	KarmaObj.DB.Import(args);
end

function	KSlash.Transport()
	KarmaObj.DB.ImpExpCleanup();
end

------------------
------------------
------------------

local	Karma_PlayerIsInRaid_50000 = function () return IsInRaid() end;
local	Karma_PlayerIsInRaid_49999 = function () return (GfTt.GetNumRaidMembersTf() > 0) end;
function	Karma_PlayerIsInRaid()
	local	fFunc;
	if (KarmaObj.Const.iTOC >= 50000) then
		fFunc = Karma_PlayerIsInRaid_50000;
	else
		fFunc = Karma_PlayerIsInRaid_49999;
	end

	local	bResult = fFunc();
	Karma_PlayerIsInRaid = fFunc;
	return bResult;
end

local	Karma_PlayerIsInParty_50000 = function () return IsInGroup() end;
local	Karma_PlayerIsInParty_49999 = function () return (GfTt.GetNumPartyMembersTf() > 0) end;
function	Karma_PlayerIsInParty()
	local	fFunc;
	if (KarmaObj.Const.iTOC >= 50000) then
		fFunc = Karma_PlayerIsInParty_50000;
	else
		fFunc = Karma_PlayerIsInParty_49999;
	end

	local	bResult = fFunc();
	Karma_PlayerIsInParty = fFunc;
	return bResult;
end

CommonRegionZoneAddCurrent = function(CurrentIsPvPRegion)
	local	CurrentRegionText = GetZoneText();
	local	CurrentRegionRealText = GetRealZoneText();

	local	CurrentZoneText = GetMinimapZoneText();
	local	CurrentZoneRealText = GetSubZoneText();

	local	CurrentIsInstance;
	if (CurrentIsPvPRegion == nil) and (Karma_ZoneChanged == 0) then
		local	bInInstance, sType = IsInInstance();
		if (bInInstance) then
			if (sType == "pvp") or (sType == "arena") then
				CurrentIsPvPRegion = 1;
			elseif (sType == "party") then
				CurrentIsInstance = 5;
			elseif (sType == "raid") then
				CurrentIsInstance = 10;
			end
		else
			CurrentIsInstance = 0;
		end
	end

	return CommonRegionZoneAdd(CurrentRegionText, CurrentZoneText, CurrentRegionRealText, CurrentZoneRealText, CurrentIsPvPRegion, CurrentIsInstance);
end

CommonRegionZoneAdd = function(RegionText, ZoneText, RegionRealText, ZoneRealText, IsPvPRegion, IsInstance)
	if (UnitIsDeadOrGhost("player")) then
		IsPvPRegion = nil;
		IsInstance  = nil;
	end

	local posX, posY = GetPlayerMapPosition("player");
	if (((posX == nil) or (posX == 0)) and ((posY == nil) or (posY == 0))) then
		--- not yet fully zoned, but not sure: old world dungeons *have* no map :-(
		if (not UnitOnTaxi("player") and not IsMounted("player") and not WorldMapFrame:IsShown()) then
			SetMapZoom(-1);			-- force reset
			SetMapToCurrentZone();
		end
	end

	-- if this is delayed as result, we're f'ed. TODO
	local	iAreaID = GetCurrentMapAreaID();
	if (KarmaObj.DB.CG.LocaleRegions(iAreaID) == nil) then
		local	sName, iContinent, iZone;
		if (IsInInstance()) then
			sName = GetInstanceInfo();
			KarmaChatDebug("Adding areaID " .. iAreaID .. ": " .. (sName or "<nil>") .. "(instance)");
		else
			iContinent = GetCurrentMapContinent();
			if (iContinent <= 0) then
				KarmaChatDebug("Can't add areaID " .. iAreaID .. ": no continent");
			else
				if (KarmaModuleLocal.RegionsByAreaID.Continent2Zones[iContinent] == nil) then
					KarmaChatDebug("Loading zone names for continent " .. iContinent .. "...");
					KarmaModuleLocal.RegionsByAreaID.Continent2Zones[iContinent] = { GetMapZones(iContinent) };
				end
				iZone = GetCurrentMapZone();
				sName = KarmaModuleLocal.RegionsByAreaID.Continent2Zones[iContinent][iZone];
			end
		end

		if (not sName) then
			KarmaChatDebug("Can't add areaID " .. iAreaID .. ": no name found");
		elseif (not KarmaModuleLocal.RegionsByAreaID.Name2ID[sName]) then
			local	iAreaID = GetCurrentMapAreaID();
			KarmaChatDebug("Area2Name: " .. (iContinent or "<nil>") .. "." .. (iZone or "<nil>") .. " - " .. (sName or "???") .. " => " .. iAreaID);
			KarmaObj.DB.CG.LocaleRegions(iAreaID, iContinent, iZone, sName);
		end
	end

	local	CommonRegionList = KarmaObj.DB.CG.RegionListGet();

	local	CurrentRegionID = nil;
	local	CurrentRegionItem = nil;
	if (CommonRegionList ~= nil) and (RegionText ~= nil) and (RegionText ~= "") then
		local	iAreaID = KarmaObj.DB.CG.LocaleRegion2AreaID(RegionText);
		if (type(iAreaID) ~= "number") then
			iAreaID = nil;
		end

		-- Region to Zone - List
		local iMax, CRIDByAID, k, v = 0;
		for k, v in pairs(CommonRegionList) do
			if ((iAreaID ~= nil) and (v.AreaID == iAreaID)) then
				if (CRIDByAID) then
					CRIDByAID = math.min(CRIDByAID, k);
				else
					CRIDByAID = k;
				end
			elseif (v.Name == RegionText) then
				CurrentRegionID = k;
				break;
			end

			iMax = math.max(iMax, k);
		end

		if (CurrentRegionID == nil) then
			if (CRIDByAID ~= nil) then
				CurrentRegionID = CRIDByAID;
			else
				CurrentRegionID = iMax + 1;
				KOH.TableInit(CommonRegionList, CurrentRegionID);
			end
		end
		CurrentRegionItem = CommonRegionList[CurrentRegionID];

		if ((iAreaID ~= nil) and (CurrentRegionItem.AreaID == nil)) then
			CurrentRegionItem.AreaID = iAreaID;
		end

		if CurrentRegionItem.Name == nil then
			CurrentRegionItem.Name = RegionText;
		end

		if (CurrentRegionItem.NameReal == nil) and (RegionRealText ~= nil) then
			CurrentRegionItem.NameReal = RegionRealText;
		end

		if (Karma_ZoneChanged == 0) then
			if (IsPvPRegion ~= CurrentRegionItem[KARMA_DB_L3_CR.ISPVPZONE]) then
				KarmaChatDebug("CommonRegionZoneAdd: IsPvPRegion(" .. RegionText .. ") => " .. Karma_NilToString(IsPvPRegion));
				CurrentRegionItem[KARMA_DB_L3_CR.ISPVPZONE] = IsPvPRegion;
			end

			if (IsInstance ~= nil) then
				local	OldValue = CurrentRegionItem[KARMA_DB_L3_CR.ZONETYPE] or "nil";
				if	(CurrentRegionItem[KARMA_DB_L3_CR.ZONETYPE] == nil) or
					(CurrentRegionItem[KARMA_DB_L3_CR.ZONETYPE] == 0) then
					CurrentRegionItem[KARMA_DB_L3_CR.ZONETYPE] = IsInstance;
				elseif (CurrentRegionItem[KARMA_DB_L3_CR.ZONETYPE] >= 5) then		-- only cast upwards...
					CurrentRegionItem[KARMA_DB_L3_CR.ZONETYPE] = max(CurrentRegionItem[KARMA_DB_L3_CR.ZONETYPE], IsInstance);
				end
				local	NewValue = CurrentRegionItem[KARMA_DB_L3_CR.ZONETYPE] or "nil";
				if (OldValue ~= NewValue) then
					KarmaChatDebug("Region.Type: " .. OldValue .. "->" .. NewValue);
				end
			end
		end

		KOH.TableInit(CurrentRegionItem, KARMA_DB_L3_CR.ZONEIDS);
	end

	local	CurrentZoneID = nil;
	local	CurrentZoneItem = nil;
	local	CommonZoneList = KarmaObj.DB.CG.ZoneListGet();
	if (CommonZoneList ~= nil) and (ZoneText ~= nil) and (ZoneText ~= "") then
		local Found = false;
		if (CurrentRegionItem ~= nil) then
			-- if we can search and find in the sublist, it's a lot faster
			local	k, v;
			for k, v in pairs(CurrentRegionItem[KARMA_DB_L3_CR.ZONEIDS]) do
				if (CommonZoneList[v].Name == ZoneText) then
					CurrentZoneID = v;
					Found = true;
					break;
				end
			end
		end

		if (CurrentZoneID == nil) then
			-- traverse full Zonelist
			local	iMax, k, v = 0;
			for k, v in pairs(CommonZoneList) do
				if (v.Name == ZoneText) then
					-- *one* subzone exists twice: Stables in Karazan and in BG Arathi Bassin
					if ((v.RegionID == nil) or (CurrentRegionID == nil) or (v.RegionID == CurrentRegionID)) then
						CurrentZoneID = k;
						break;
					end
				end

				iMax = math.max(iMax, k);
			end

			if (CurrentZoneID == nil) then
				CurrentZoneID = iMax + 1;
				KOH.TableInit(CommonZoneList, CurrentZoneID);
			end
		end
		CurrentZoneItem = CommonZoneList[CurrentZoneID];

		if CurrentZoneItem.Name == nil then
			CurrentZoneItem.Name = ZoneText;
		end

		if (CurrentZoneItem.NameReal == nil) and (ZoneRealText ~= nil) then
			CurrentZoneItem.NameReal = ZoneRealText;
		end

		-- Zone to Region - Link
		if CurrentRegionItem ~= nil then
			if (CurrentZoneItem.RegionID == nil) and (CurrentRegionID ~= nil) then
				CurrentZoneItem.RegionID = CurrentRegionID;
			end

			-- add Zone to Region
			if (not Found) then
				for k, v in pairs(CurrentRegionItem[KARMA_DB_L3_CR.ZONEIDS]) do
					if v == CurrentZoneID then
						Found = true;
						break;
					end
				end
				if not Found then
					table.insert(CurrentRegionItem[KARMA_DB_L3_CR.ZONEIDS], CurrentZoneID);
				end
			end
		elseif (CurrentZoneItem.RegionID ~= nil) then
			CurrentRegionID = CurrentZoneItem.RegionID;
		end
	end

	if (KarmaTrans_LogRegionZone ~= nil) and (KCfg.Get("DEBUG_ENABLED") == 1) then
		if (CurrentRegionItem == nil) and (CurrentRegionID ~= nil) then
			CurrentRegionItem = CommonRegionList[CurrentRegionID];
		end
		if (CurrentRegionItem ~= nil) and (CurrentZoneItem ~= nil) then
			KarmaTrans_LogRegionZone(CurrentRegionID, CurrentRegionItem.Name, CurrentZoneID,
				CurrentZoneItem.Name, CurrentRegionItem[KARMA_DB_L3_CR.ZONETYPE]);
		elseif (CurrentRegionItem == nil) and (CurrentZoneItem ~= nil) then
			KarmaTrans_LogRegionZone(CurrentRegionID, nil,                    CurrentZoneID,
				CurrentZoneItem.Name, nil);
		else
			KarmaTrans_LogRegionZone(CurrentRegionID, nil,                    CurrentZoneID,
				nil,                  nil);
		end
	end

	if ((Karma_ZoneChanged == 0) and (KarmaModuleLocal.RegionChangePrevious ~= RegionText)) then
		KarmaChatDebug("Region changed: " .. KarmaModuleLocal.RegionChangePrevious .. " -> " .. RegionText);
		local	bInInstance, sType = IsInInstance();
		KarmaChatDebug("Expected Type: pvp=" .. Karma_NilToString(IsPvPRegion) .. ", inst=" .. Karma_NilToString(IsInstance) .. "; UI: " .. Karma_NilToString(bInInstance) .. "/" .. Karma_NilToString(sType));
		if ((CurrentRegionItem ~= nil) and (CurrentRegionItem[KARMA_DB_L3_CR.ZONETYPE] ~= nil)) then
			local	sPvP = "";
			if (CurrentRegionItem[KARMA_DB_L3_CR.ISPVPZONE] == 1) then
				sPvP = "/pvp";
			end
			KarmaChatDebug("Current Type: " .. CurrentRegionItem[KARMA_DB_L3_CR.ZONETYPE] .. sPvP);
		end
		KarmaModuleLocal.RegionChangePrevious = RegionText;
	end

	return CurrentZoneID, CurrentRegionID;
end

CommonRegionListGet = function()
	return KarmaObj.DB.CG.RegionListGet();
end

CommonZoneListGet = function()
	return KarmaObj.DB.CG.ZoneListGet();
end

CommonQuestAdd = function(Quest, ExtID)
	return KarmaObj.DB.CF.QuestListAdd(Quest, nil, ExtID);
end

CommonQuestInfoListGet = function()
	return KarmaObj.DB.CF.QuestInfosListGet(Quest, Faction, ExtID);
end

-- new: class id instead of class (for multilingual users)
function KOH.IDToClass(ClassID)
	if (ClassID == nil) or (ClassID == 0) then
		KarmaChatDebug("Failed to translate ClassID " .. Karma_NilToString(ClassID) .. " to name. (1)");
		return "";
	end;

	if (type(ClassID) ~= "number") then
		KarmaChatDebug("ID2Class: Callstack >> " .. debugstack());
		return "";
	end

	if (ClassID > 0) then
		if     (ClassID == 1) then
			return KARMA_CLASS_DRUID_M;
		elseif (ClassID == 2) then
			return KARMA_CLASS_HUNTER_M;
		elseif (ClassID == 3) then
			return KARMA_CLASS_MAGE_M;
		elseif (ClassID == 4) then
			return KARMA_CLASS_PALADIN_M;
		elseif (ClassID == 5) then
			return KARMA_CLASS_PRIEST_M;
		elseif (ClassID == 6) then
			return KARMA_CLASS_ROGUE_M;
		elseif (ClassID == 7) then
			return KARMA_CLASS_SHAMAN_M;
		elseif (ClassID == 8) then
			return KARMA_CLASS_WARRIOR_M;
		elseif (ClassID == 9) then
			return KARMA_CLASS_WARLOCK_M;
		elseif (ClassID == 10) then
			return KARMA_CLASS_DEATHKNIGHT_M;
		elseif (ClassID == 11) then
			return KARMA_CLASS_MONK_M;
		end;
	else
		if     (ClassID == - 1) then
			return KARMA_CLASS_DRUID_F;
		elseif (ClassID == - 2) then
			return KARMA_CLASS_HUNTER_F;
		elseif (ClassID == - 3) then
			return KARMA_CLASS_MAGE_F;
		elseif (ClassID == - 4) then
			return KARMA_CLASS_PALADIN_F;
		elseif (ClassID == - 5) then
			return KARMA_CLASS_PRIEST_F;
		elseif (ClassID == - 6) then
			return KARMA_CLASS_ROGUE_F;
		elseif (ClassID == - 7) then
			return KARMA_CLASS_SHAMAN_F;
		elseif (ClassID == - 8) then
			return KARMA_CLASS_WARRIOR_F;
		elseif (ClassID == - 9) then
			return KARMA_CLASS_WARLOCK_F;
		elseif (ClassID == - 10) then
			return KARMA_CLASS_DEATHKNIGHT_F;
		elseif (ClassID == - 11) then
			return KARMA_CLASS_MONK_F;
		end;
	end;

	KarmaChatDebug("Failed to translate ClassID " .. ClassID .. " to name. (2)");
	return "";
end;

function KOH.ClassToID(ClassAsName)
	if     (ClassAsName == KARMA_CLASS_DRUID_M) then
		return 1;
	elseif (ClassAsName == KARMA_CLASS_HUNTER_M) then
		return 2;
	elseif (ClassAsName == KARMA_CLASS_MAGE_M) then
		return 3;
	elseif (ClassAsName == KARMA_CLASS_PALADIN_M) then
		return 4;
	elseif (ClassAsName == KARMA_CLASS_PRIEST_M) then
		return 5;
	elseif (ClassAsName == KARMA_CLASS_ROGUE_M) then
		return 6;
	elseif (ClassAsName == KARMA_CLASS_SHAMAN_M) then
		return 7;
	elseif (ClassAsName == KARMA_CLASS_WARRIOR_M) then
		return 8;
	elseif (ClassAsName == KARMA_CLASS_WARLOCK_M) then
		return 9;
	elseif (ClassAsName == KARMA_CLASS_DEATHKNIGHT_M) then
		return 10;
	elseif (ClassAsName == KARMA_CLASS_MONK_M) then
		return 11;
	end;

	if     (ClassAsName == KARMA_CLASS_DRUID_F) then
		return - 1;
	elseif (ClassAsName == KARMA_CLASS_HUNTER_F) then
		return - 2;
	elseif (ClassAsName == KARMA_CLASS_MAGE_F) then
		return - 3;
	elseif (ClassAsName == KARMA_CLASS_PALADIN_F) then
		return - 4;
	elseif (ClassAsName == KARMA_CLASS_PRIEST_F) then
		return - 5;
	elseif (ClassAsName == KARMA_CLASS_ROGUE_F) then
		return - 6;
	elseif (ClassAsName == KARMA_CLASS_SHAMAN_F) then
		return - 7;
	elseif (ClassAsName == KARMA_CLASS_WARRIOR_F) then
		return - 8;
	elseif (ClassAsName == KARMA_CLASS_WARLOCK_F) then
		return - 9;
	elseif (ClassAsName == KARMA_CLASS_DEATHKNIGHT_F) then
		return - 10;
	elseif (ClassAsName == KARMA_CLASS_MONK_F) then
		return - 11;
	end;

	if (ClassAsName ~= nil) and (ClassAsName ~= "") then
		KarmaChatDebug("Failed to translate ClassName " .. ClassAsName .. " to ID.");
	end;

	return 0;
end;

Karma_RaceLocalizedToRaceEN = function(sRaceLoc, iGender)
	local	sTableBase = "KARMA_RACES_" .. strupper(UnitFactionGroup("player")) .. "_";
	local	sGender = { [ 1 ] = "MALE", [ 2 ] = "FEMALE" };
	local	iMin, iMax, i = 1, 2;
	if (iGender) then
		if (iGender == 2) then
			iMax = 1;
		elseif (iGender == 3) then
			iMin = 2;
		end
	end

	for i = iMin, iMax do
		local	oTable, k, v = _G[ sTableBase .. sGender[i]];
		for k, v in pairs(oTable) do
			if (v == sRaceLoc) then
				return k, (i + 1);
			end
		end
	end

	return nil;
end

--
--- two tab logic
--
local	KarmaWindow_Partitions =
		{
			[1] = {
				"KarmaWindow_CharSelection_DropDown",
				"KarmaWindow_TrackingData_Frame",
				"KarmaWindow_ListChoice_Area",
				"KarmaWindow_RegionList_EnclosingArea",
				"KarmaWindow_ZoneList_EnclosingArea",
				"KarmaWindow_QuestList_EnclosingArea",
				"KarmaWindow_AchievementList_EnclosingArea"
				},
			[2] = {
				"KarmaWindow_OtherData_Frame",
				"KarmaWindow_AltList_EnclosingArea",
				"KarmaWindow_NotesPublicBorder_Frame",
				"KarmaWindow_NotesPublicQuery_Button",
				"KarmaWindow_NotesPublicResults_Button",
				"KarmaWindow_NotesBorder_Frame"
				};
		};

function	KarmaWindow_SelectTab(arg)
	PanelTemplates_SetTab(KarmaWindow, arg);
	if (arg == 1) then
		local	key, value, frameobj;
		for key, value in pairs(KarmaWindow_Partitions[2]) do
			frameobj = getglobal(value);
			frameobj:Hide();
		end

		for key, value in pairs(KarmaWindow_Partitions[1]) do
			frameobj = getglobal(value);
			frameobj:Show();
		end

		KARMA_SELECTEDTAB = 1;

		KarmaWindow_Lists_SetAnchors();
	elseif (arg == 2) then
		local	key, value, frameobj;
		for key, value in pairs(KarmaWindow_Partitions[1]) do
			frameobj = getglobal(value);
			frameobj:Hide();
		end
		for key, value in pairs(KarmaWindow_Partitions[2]) do
			frameobj = getglobal(value);
			frameobj:Show();
		end

		KARMA_SELECTEDTAB = 2;
	end
end

function	KarmaWindow_OnLoad(self)
	-- make it closeable with ESC
	tinsert(UISpecialFrames,self:GetName());

	-- create list buttons:
	local	FrameL = { "RegionList", "ZoneList", "QuestList", "AchievementList" };

	local	key, listname, i, sButton, oParent, sTemplate, oButton, sButtonPrev; 
	for key, listname in pairs(FrameL) do
		for i = 2, KARMA_MAINLISTS_SIZE do
			sButton = listname .. "_GlobalButton" .. tostring(i);
			oParent = getglobal("KarmaWindow_" .. listname .. "_Frame");
			sTemplate = listname .. "_GlobalButtonTemplate";
			oButton = CreateFrame("Button", sButton, oParent, sTemplate);
			oButton:SetID(i);
			sButtonPrev = listname .. "_GlobalButton" .. tostring(i - 1);
			oButton:SetPoint("TOPLEFT", sButtonPrev, "BOTTOMLEFT");
		end
	end

	local	AltButtonsL = { "KarmaValue", "Level", "Name" };
	listname = "AltList";
	local	btnname;
	for key, btnname in pairs(AltButtonsL) do
		for i = 2, KARMA_ALTLIST_SIZE do
			sButton = listname .. "_" .. btnname .. "Button" .. tostring(i);
			oParent = getglobal("KarmaWindow_" .. listname .. "_Frame");
			sTemplate = listname .. "_" .. btnname .. "ButtonTemplate";
			oButton = CreateFrame("Button", sButton, oParent, sTemplate);
			oButton:SetID(i);
			sButtonPrev = listname .. "_" .. btnname .. "Button" .. tostring(i - 1);
			oButton:SetPoint("TOPLEFT", sButtonPrev, "BOTTOMLEFT");
		end
	end

	PanelTemplates_SetNumTabs(self, 2);
	KarmaWindow_SelectTab(1);
end

--
--- list order and alignment on tab 1
--
function	KarmaWindow_Lists_SetAnchors()
	if (KARMA_SELECTEDTAB ~= 1) then
		return;
	end

	local	key, value, frameobj;
	local	ListsL = {};
	local	iCount = 0;
	for key, value in pairs(KarmaWindow_Partitions[1]) do
		if (strsub(value, strlen(value) - 17) == "List_EnclosingArea") then
			local	ListChar = strsub(value, 13, 13);
			if (ListChar ~= nil) and (ListChar ~= "")  then
				if (KCfg.Get("MAINWND_LIST_" .. ListChar) ~= 1) then
					frameobj = getglobal(value);
					frameobj:Hide();
				else
					tinsert(ListsL, value);
					iCount = iCount + 1;
				end
			end
		end
	end

	if (iCount == 0) then
		return;
	end

	-- todo: find out this value with UI-funcs:
	local	iWndSpace = 400;

	local	iListWidth = floor(iWndSpace / iCount);
	local	sPreviousFrame, sListname, listobj, btnobj, btntxtobj;
	for key, value in pairs(ListsL) do
		local	ListChar = strsub(value, 13, 13);
-- KarmaChatDebug("ListChar: " .. Karma_NilToString(ListChar));
		frameobj = getglobal(value);
		local	PointL = {};
		local	i, j;

--[[
		for i = 1, frameobj:GetNumPoints() do
			sPoint, sRelativeTo, sRelativePoint, iXOffset, iYOffset = frameobj:GetPoint(i)
			PointL[i] = {};
			PointL[i].P  = sPoint;
			PointL[i].RT = sRelativeTo;
			PointL[i].RP = sRelativePoint;
			PointL[i].XO = iXOffset;
			PointL[i].YO = iYOffset;

KarmaChatDebug(ListChar .. "L: " .. sPoint .. " -> " .. sRelativeTo:GetName() .. "." .. sRelativePoint .. " +{" .. iXOffset .. ", " .. iYOffset .. "}");
		end
]]--

		-- initially, all lists should be:
		-- TOPLEFT -> KarmaWindow_ListChoice_Area.TOPRIGHT +{0, -20}
		if (sPreviousFrame == nil) then
			frameobj:SetPoint("TOPLEFT", KarmaWindow_ListChoice_Area, "TOPRIGHT", 0, -20);
		else
			frameobj:SetPoint("TOPLEFT", sPreviousFrame, "TOPRIGHT");
		end
		frameobj:SetWidth(iListWidth);

		sListname = gsub(value, "EnclosingArea", "", 1)
		listobj = getglobal(sListname .. "Frame");
		if (listobj) then
			listobj:SetWidth(iListWidth);

			j = 1;
			sListname = strsub(sListname, 13);
			btnobj = getglobal(sListname .. "GlobalButton" .. j);
			if (btnobj == nil) then
KarmaChatDebug(ListChar .. "L: !" .. sListname .. "GlobalButton" .. j .. "?");
			end
			while (btnobj ~= nil) do
				btnobj:SetWidth(iListWidth - 30);
				btntxtobj = getglobal(sListname .. "GlobalButton" .. j .. "_Text");
				btntxtobj:SetWidth(iListWidth - 30);

				j = j + 1;
				btnobj = getglobal(sListname .. "GlobalButton" .. j);
			end
		end

		frameobj:Show();

		sPreviousFrame = value;
	end
end

function	KarmaWindow_OnUpdateEvent(self, iElapsed)
	local	iCurrent = KarmaModuleLocal.Timers.Update + iElapsed;
	if (iCurrent < 0.5) then
		KarmaModuleLocal.Timers.Update = iCurrent;
		return
	end

	KarmaModuleLocal.Timers.Update = 0;
	KarmaWindow_OnUpdateEventDo();
end

function	KarmaWindow_OnUpdateEventDo()
	local	TimeNow = GetTime();

	if (KARMA_LOADED == 1) then
		-- we have to delay the event, because regen is enabled just *before* the achievements are updated
		if (KarmaModuleLocal.PlayerRegenEnabledOrMobDied ~= nil) then
			if (TimeNow - KarmaModuleLocal.PlayerRegenEnabledOrMobDied > 2.5) then
				Karma_WhoAmIInit();
				if (WhoAmI) then
					KarmaModuleLocal.PlayerRegenEnabledOrMobDied = nil;
					KarmaObj.Achievements.UpdateTest(KARMA_PartyNames, WhoAmI);
				end
			end

			-- don't let anything else waste even a single CPU cycle,
			-- we want to be as close to PlayerRegen as possible!
			return
		end
	end

	if (not KarmaModuleLocal.RegionsByAreaID.Done) then
		local	_, iAreaIDStored = KarmaObj.DB.CG.LocaleRegions();
		iAreaIDStored = iAreaIDStored or 0;
		if (iAreaIDStored >= 1000) then
			KarmaChatDebug("Acquired all outdoor areaID <=> zoneName mappings.");
			KarmaModuleLocal.RegionsByAreaID.Done = true;
		elseif (not KarmaModuleLocal.RegionsByAreaID.TimeAt) then
			if (not WorldMapFrame:IsShown()) then
				if (not KarmaModuleLocal.RegionsByAreaID.AreaID) then
					KarmaChatDebug("Starting to acquire areaID <=> zoneName mappings...");
					SetMapZoom(-1);
				end
				iAreaIDStored = math.max(0, iAreaIDStored - 5);
				KarmaModuleLocal.RegionsByAreaID.AreaID = (KarmaModuleLocal.RegionsByAreaID.AreaID or iAreaIDStored or 0) + 1;
				KarmaModuleLocal.RegionsByAreaID.Valid = true;
				KarmaModuleLocal.RegionsByAreaID.TimeAt = TimeNow;
				SetMapByID(KarmaModuleLocal.RegionsByAreaID.AreaID);
			end
		elseif (TimeNow - KarmaModuleLocal.RegionsByAreaID.TimeAt > 0.5) then
			if (not KarmaModuleLocal.RegionsByAreaID.Valid) then
				KarmaChatDebug("Was interfered in acquiring mapping for areaID " .. KarmaModuleLocal.RegionsByAreaID.AreaID .. "...");
				KarmaModuleLocal.RegionsByAreaID.AreaID = KarmaModuleLocal.RegionsByAreaID.AreaID - 1;
				KarmaModuleLocal.RegionsByAreaID.TimeAt = nil;
			else
				local	iContinent = GetCurrentMapContinent();
				if (iContinent > 0) then
					if (KarmaModuleLocal.RegionsByAreaID.Continent2Zones[iContinent] == nil) then
						KarmaChatDebug("Loading zone names for continent " .. iContinent .. "...");
						KarmaModuleLocal.RegionsByAreaID.Continent2Zones[iContinent] = { GetMapZones(iContinent) };
					end
					local	iZone = GetCurrentMapZone();
					local	sName = KarmaModuleLocal.RegionsByAreaID.Continent2Zones[iContinent][iZone];
					if (sName) then
						if (not KarmaModuleLocal.RegionsByAreaID.Name2ID[sName]) then
							local	iAreaID = GetCurrentMapAreaID();
							if (iAreaID == KarmaModuleLocal.RegionsByAreaID.AreaID) then
								KarmaChatDebug("Area2Name: " .. iContinent .. "." .. iZone .. " - " .. (sName or "???") .. " => " .. KarmaModuleLocal.RegionsByAreaID.AreaID);
								KarmaObj.DB.CG.LocaleRegions(iAreaID, iContinent, iZone, sName);
								KarmaModuleLocal.RegionsByAreaID.Name2ID[sName] = iAreaID;
								KarmaModuleLocal.RegionsByAreaID.ID2Name[iAreaID] = sName;
							end
						end
					end
				end

				KarmaObj.DB.CG.LocaleRegions(- KarmaModuleLocal.RegionsByAreaID.AreaID);
				if (KarmaModuleLocal.RegionsByAreaID.AreaID < 1000) then
					KarmaModuleLocal.RegionsByAreaID.TimeAt = nil;
				else
					KarmaModuleLocal.RegionsByAreaID.Done = true;
				end
			end
		end
	end

	if (TimeNow - KarmaModuleLocal.Timers.CmdQ >= 0.35) then
		KarmaModuleLocal.Timers.CmdQ = TimeNow;
		local	CQSize = KarmaObj.Slash.CommandQLen();
		if (CQSize == 0) then
			if UnitIsAFK("player") and (UnitName("target") == nil) then
				if (KCfg.Get("UPDATEWHILEAFK") == 1) then
					local	args = {};
					KSlash.Update(args);
					return
				end
			end
		end

		if (CQSize > 0) then
			if (KarmaObj.Slash.CommandQLocked(TimeNow) == nil) then
				KarmaObj.Slash.CommandQExecute();
				return
			end
		end
	end

	if (KARMA_LOADED ~= 1) then
		return
	end

	if (TimeNow - KARMA_LastMessageTime >= 1.5) then
		KARMA_LastMessageTime = TimeNow;
		local	CQSize = #Karma_MessageQueue;
		if (CQSize > 0) then
			local	elem = Karma_MessageQueue[1];
			local	i;
			if (CQSize > 1) then
				for i = 2, CQSize do
					if (Karma_MessageQueue[i] ~= nil) then
						Karma_MessageQueue[i-1] = Karma_MessageQueue[i];
					end
				end
				Karma_MessageQueue[CQSize] = nil;
			else
				Karma_MessageQueue = {};
			end

			if (elem ~= nil) then
				if (elem.func ~= nil) then
					elem.func(elem);
				end
				SendChatMessage(elem.text, elem.chattype, nil, elem.target);

				return
			end
		end
	end

	-- /who wasn't getting thru, retry.
	if (KARMA_FriendsFrameVisible ~= 1) and ((Karma_Executing_Who == nil) or (time() - Karma_Executing_Who > 5)) then
		if (Karma_WhoQueue[1] ~= nil) then
			local	iDelta = 180;
			if (KarmaModuleLocal.ExecutingWhoBroken) then
				iDelta = 60;
			end
			if (KarmaModuleLocal.ExecutingWhoSince and (time() - KarmaModuleLocal.ExecutingWhoSince > iDelta)) then
				if (KarmaModuleLocal.ExecutingWhoBroken) then
					KarmaChatSecondaryFallbackDefault("|cFFFF8080Reminder: /who still not working... ('/console reloadui'!)");
					KarmaModuleLocal.ExecutingWhoSince = time() - iDelta + 30;	-- => every 30s
				else
					KarmaChatDefault("|cFFFF2020WARNING: Failed to complete /who since three minutes. /who is seemingly BROKEN at this time. Please execute a '/reloadui' command as soon as possible. This error cannot be fixed by " .. KARMA_ITSELF .. " (and is usually triggered by WhoLib from ACE).");
				end
				Karma_Who_Process();	-- not ideal, but better than nothing...
				KarmaModuleLocal.ExecutingWhoBroken = true;
				return
			end
			if (Karma_WhoQueue[1].text ~= nil) then
				Karma_SendWho(Karma_WhoQueue[1].text, true);
				return
			end
		else
			KarmaModuleLocal.ExecutingWhoSince = nil;
			Karma_Executing_Who = nil;
		end
	end

	if (TimeNow - KARMA_LastUpdateTime >= 10) then
		KARMA_LastUpdateTime = TimeNow;
		if (KARMA_LOADED == 1) then
			if (KCfg.Get("RAID_TRACKALL") == 1) and Karma_PlayerIsInRaid() then
				Karma_AddTimeToPartyMembers();
				KARMA_LastUpdateTime = KARMA_LastUpdateTime + 50;
			else
				Karma_AddTimeToPartyMembers();
			end
			KarmaWindow_Update();

			if (KarmaObj.LFM) then
				KarmaObj.LFM.WindowUpdate(true);
			end
		end
	end

	if (TimeNow - KARMA_TalentInspect.RequestQueueTimer >= 2) then
		KARMA_TalentInspect.RequestQueueTimer = TimeNow;
		Karma_AutofetchTalents();
	end

	if (TimeNow - KarmaModuleLocal.Timers.CronQ > 1) then
		KarmaModuleLocal.Timers.CronQ = TimeNow;
		if (#Karma_CronQueue ~= 0) then
			local	iCron, iCronMax = 0, #Karma_CronQueue;
			for iCron = 1, iCronMax do
				if (TimeNow > Karma_CronQueue[iCron].At) then
					local	oCron = Karma_CronQueue[iCron];
					if (iCron ~= iCronMax) then
						Karma_CronQueue[iCron] = Karma_CronQueue[iCronMax];
					end
					Karma_CronQueue[iCronMax] = nil;

					local	oCmdList = oCron.CmdList;
					local	iCmdMax, iCmd = #oCmdList;
					for iCmd = 1, iCmdMax do
						if (oCmdList[iCmd].sName) then
							KarmaChatDebug(date("[%H:%M:%S]", time()) .. " Activating <" .. oCmdList[iCmd].sName .. ">");
						else
							KarmaChatDebug(date("[%H:%M:%S]", time()) .. " Activating <unknown cmd>");
						end
					end
					KarmaObj.Slash.CommandQAddPrio(oCmdList);

					return
				end
			end
		end
	end

	if (KarmaObj.Share.UpdateEventCheck()) then
		if ((KarmaObj.Slash.CommandQLen() == 0) and (#Karma_MessageQueue == 0) and
			(KARMA_TalentInspect.RequiredCount == 0))  then
			KarmaObj.Share.UpdateEventDo();
		end
	end

	if (TimeNow - KarmaModuleLocal.AchievementCheckTerrorTimer >= 60) then
		KarmaModuleLocal.AchievementCheckTerrorTimer = TimeNow;
		if (KarmaModuleLocal.AchievementCheckTerrorCount > 0) then
			KarmaObj.Achievements.CheckTerrorQuery(KarmaModuleLocal.AchievementCheckTerrorList);
			if (next(KarmaModuleLocal.AchievementCheckTerrorList) == nil) then
				KarmaModuleLocal.AchievementCheckTerrorCount = 0;	-- left group etc.
			end
		end
	end

	if (Karma_ZoneChanged ~= 0) then
		if (time() - Karma_ZoneChanged > 15) then
			Karma_ZoneChanged = 0;
			CommonRegionZoneAddCurrent();
			Karma_AddZoneToPartyMember();
		end
	end

	if (KarmaModuleLocal.ChannelTime ~= 0) then
		if (TimeNow > KarmaModuleLocal.ChannelTime + KARMA_CHECKCHANNEL_TIMEMAX) then
			Karma_CheckOnlineInChannelDone();
		end
	end
end

function	Karma_AddTip(sUnit)
	--	Attempts to add Karma info to tooltip
	if (sUnit == "player" or (sUnit == "mouseover" and UnitIsUnit("player", "mouseover"))) then
		if (KCfg.Get("TOOLTIP_GEAR") == 1) then
			-- /run KarmaAvEnK.Events.UNIT_INVENTORY_CHANGED(nil, "player", nil, true)
			local	_, iLvl, iSet = KarmaAvEnK.Events.UNIT_INVENTORY_CHANGED(nil, "player", nil, true)
			if (iLvl and iSet) then
				local	oText = GameTooltipTextLeft1;
				local	sText = oText:GetText();
				sText = sText .. " [Pv" .. iSet .. ": " .. iLvl .. "]";
				oText:SetText(sText);
				return true;
			end
		end

		return
	end

	local	TT_Added = false;
	local	sSummary = "";
	local	sMember, sServer = UnitName(sUnit);
	local	oMember = Karma_MemberList_GetObject(sMember, sServer);
	local	bShiftReq = 1 == KCfg.Get("TOOLTIP_SHIFTREQ");
	local	bShiftPressed = IsShiftKeyDown();
	if (oMember ~= nil) then
		local	sPlayed, bPlayed = "";
		do
			local	iSeconds;
			if (1 == KCfg.Get("TOOLTIP_PLAYEDTOTAL")) then
				iSeconds = Karma_MemberObject_GetTotalTimePlayedSummedUp(oMember);
				sPlayed = " (total)";
			elseif (1 == KCfg.Get("TOOLTIP_PLAYEDTHIS")) then
				iSeconds = Karma_MemberObject_GetTimePlayed(oMember);
				sPlayed = " (with current char)";
			end
			if (iSeconds) then
				if (iSeconds > 0) then
					bPlayed = true;
					sPlayed = " -- over " .. KOH.Duration2String(iSeconds) .. sPlayed;
				else
					sPlayed = " -- never joined" .. sPlayed;
				end
			end
		end

		if KCfg.Get("TOOLTIP_KARMA") then
			local	iKarma = Karma_MemberObject_GetKarmaModified(oMember);
			iKarma = math.min(100, iKarma);
			local	iRed, iGreen, iBlue = Karma_Karma2Color(iKarma);
			local	sKarma = Karma_MemberObject_GetKarmaWithModifiers(oMember);
			sKarma = format("|c%s%s|r", ColourToString(1, iRed, iGreen, iBlue), sKarma);
			if (bShiftReq and not bShiftPressed) then
				if (iKarma ~= 50) then
					sSummary = sSummary .. sKarma;
					if (bPlayed) then
						sSummary = sSummary .. " Time";
					end
				end
			else
				sKarma = KARMA_ITSELF .. KARMA_WINEL_FRAG_COLONSPACE .. sKarma;
				GameTooltip:AddLine(sKarma .. sPlayed, 1, 1, 1);
				TT_Added = true;
			end
		end

		if (KCfg.Get("TOOLTIP_SKILL") == 1) then
			local	iSkill = Karma_MemberObject_GetSkill(oMember);
			if (iSkill >= 0) and (KARMA_SKILL_LEVELS[iSkill]) then
				local	sSkill = KARMA_MSG_TIP_SKILL .. KARMA_WINEL_FRAG_COLONSPACE .. KARMA_SKILL_LEVELS[iSkill];
				if (bShiftReq and not bShiftPressed) then
					sSummary = sSummary .. " Skill";
				else
					GameTooltip:AddLine(sSkill, 0.9, 0.6, 0.9);
					TT_Added = true;
				end
			end
		end

		if (KCfg.Get("TOOLTIP_TALENTS") == 1) then
			local	oLines, sSummarySub, iTimeOfTalents = KarmaObj.Talents.MemberObjToStringsObj(oMember, bShiftPressed);

			if (bShiftReq and not bShiftPressed) then
				sSummary = sSummary .. sSummarySub;
			else
				local	i;
				for i = 1, #oLines do
					if (iTimeOfTalents) then
						GameTooltip:AddLine("Talents as of " .. date(KARMA_DATEFORMAT, iTimeOfTalents) .. ":", 1, 1, 1);
						iTimeOfTalents = nil;
					end
					GameTooltip:AddLine(oLines[i], 1, 1, 1);
					TT_Added = true;
				end
			end
		end

		if (KCfg.Get("TOOLTIP_GEAR") == 1) then
			if (oMember[KARMA_DB_L5_RRFFM.GEARLEVEL_PVP] or oMember[KARMA_DB_L5_RRFFM.GEARLEVEL_PVE]) then
				local	iPvplvl = oMember[KARMA_DB_L5_RRFFM.GEARLEVEL_PVP];
				local	iPvelvl = oMember[KARMA_DB_L5_RRFFM.GEARLEVEL_PVE];

				local	sGear = "";
				if (iPvelvl) then
					sGear = sGear .. " [PvE:" .. math.floor(iPvelvl) .. "]";
				end
				if (iPvplvl) then
					sGear = sGear .. " [PvP:" .. math.floor(iPvplvl) .. "]";
				end

				-- no shift-test, show always
				GameTooltipTextLeft1:SetText(GameTooltipTextLeft1:GetText() .. sGear);
				TT_Added = true;
			end
		end

		if (KCfg.Get("TOOLTIP_ALTS") == 1) then
			local	iAltID = Karma_MemberObject_GetAltID(oMember);
			if (iAltID ~= -1) then
				local	sAlts = Karma_AltID2Names(iAltID, 5, KARMA_MSG_TIP_ALTS .. KARMA_WINEL_FRAG_COLONSPACE);
				if (sAlts) and (sAlts ~= "") then
					if (bShiftReq and not bShiftPressed) then
						sSummary = sSummary .. " Alts";
					else
						GameTooltip:AddLine(sAlts, 0.9, 0.6, 0.9);
						TT_Added = true;
					end
				end
			end
		end

		if (KCfg.Get("TOOLTIP_TERROR") == 1) then
			if (oMember[KARMA_DB_L5_RRFFM_TERROR]) then
				local	iTotal, k, v = 0;
				for k, v in pairs(oMember[KARMA_DB_L5_RRFFM_TERROR]) do
					if (type(k) == "number") then
						iTotal = iTotal + 1;
					end
				end

				if (bShiftReq and not bShiftPressed) then
					if (iTotal == 0) then
						sSummary = sSummary .. " |cFF40FF40(no cutthroat)|r";
					elseif (iTotal < 5) then
						sSummary = sSummary .. " |cFFFFFF00Cutthroat|r";
					else
						sSummary = sSummary .. " |cFFFF4040Cutthroat|r";
					end
				else
					if (iTotal == 5) then
						GameTooltip:AddLine("For The Alliance/For The Horde: Completed. :-(", 1, 0.375, 0.375);
					elseif (iTotal > 0) then
						GameTooltip:AddLine("For The Alliance/For The Horde: Partly completed (" .. (iTotal * 25) .. "%). :-|", 1, 1, 0.375);
					else
						GameTooltip:AddLine("For The Alliance/For The Horde: Not started. :-)", 0.375, 1, 0.375);
					end
				end
			end
		end

		-- Notes should always be the last part!
		if KCfg.Get("TOOLTIP_NOTES") then
			local	sNote = Karma_MemberObject_GetNotes(oMember);
			if (sNote) and (sNote ~= "") then
				if (bShiftReq and not bShiftPressed) then
					sSummary = sSummary .. " Notes";
				else
					local	sExtract = KOH.ExtractHeader(sNote);
					GameTooltip:AddLine(sExtract, 0.7, 0.9, 0.7, 1);
					TT_Added = true;
				end
			end
		end

		if (bShiftReq and not bShiftPressed) and (sSummary ~= "") then
			sSummary = KARMA_ITSELF .. KARMA_WINEL_FRAG_COLONSPACE .. sSummary;
			GameTooltip:AddLine(sSummary, 0.8, 1, 0.8, 1);
			TT_Added = true;
		end
	end

	return TT_Added;
end

function	Karma_IntializePlayerObject()
	local	oPlayer = Karma_GetPlayerObject();

	Karma_FieldInitialize(oPlayer, KARMA_DB_L5_RRFFC.PLAYED, 0);
	Karma_FieldInitialize(oPlayer, KARMA_DB_L5_RRFFC.PLAYEDPVP, 0);
	Karma_FieldInitialize(oPlayer, KARMA_DB_L5_RRFFC.PLAYEDLAST, 0);
	oPlayer[KARMA_DB_L5_RRFFC.PLAYEDLAST] = GetTime();
end

function	Karma_GetPlayerObject(char)
	KarmaObj.ProfileStart("Karma_GetPlayerObject");

	if (char == nil) then
		char = UnitName("player");
	end
	local	lCharacter = KarmaObj.DB.SF.CharacterListGet();
	local	oPlayer = lCharacter[char];

	KarmaObj.ProfileStop("Karma_GetPlayerObject");
	return oPlayer;
end

-----------------------------------------
--	Cacheing routines
-----------------------------------------
function	Karma_MemberList_ResetMemberNamesCache()
	KARMA_NamesSortedAlpha = nil;
	KARMA_NamesSortedCustom = nil;
end

function	Karma_MemberList_CreateMemberNamesCache()
	KARMA_NamesSortedAlpha = {};
	KARMA_NamesSortedCustom = {};

	local	MemberNames = {};
	local	lMembers;
	if (type(KARMA_CURRENTLIST) == "string") then
		KarmaChatDebug("MemberCache: creating for " .. KARMA_CURRENTLIST);
		lMembers = KarmaObj.DB.SF.MemberListGet(KARMA_CURRENTLIST);
	else
		KarmaChatDebug("MemberCache: creating for current realm");
		lMembers = KarmaObj.DB.SF.MemberListGet();
	end

	local	iNumEntries = getn(lMembers);
	local	BucketValue, sBucketName;

	local	i = 0;
	local	FilterLenTotal;

	local	flPattern, flName, flClass, flLevelFrom, flLevelTo, flKarmaFrom, flKarmaTo;
	local	flJoinedAfter, flJoinedBefore, flNotes, flPublic, flGuild, flInstance;

	if KARMA_Filter.Total == nil then
		FilterLenTotal = 0;
	else
		FilterLenTotal = strlen(KARMA_Filter.Total);

		flPattern = 0;
		if KARMA_Filter.Pattern ~= nil then
			flPattern = strlen(KARMA_Filter.Pattern);
		end
		flName = 0;
		if KARMA_Filter.Name ~= nil then
			flName = strlen(KARMA_Filter.Name);
		end
		flClass = 0;
		if KARMA_Filter.Class ~= nil then
			flClass = strlen(KARMA_Filter.Class);
		end
		flLevelTo = 0;
		if KARMA_Filter.LevelTo ~= nil then
			flLevelTo = KARMA_Filter.LevelTo;
		end
		flLevelFrom = 0;
		if KARMA_Filter.LevelFrom ~= nil then
			flLevelFrom = KARMA_Filter.LevelFrom;
		end
		flKarmaFrom = 0;
		if KARMA_Filter.KarmaFrom ~= nil then
			flKarmaFrom = KARMA_Filter.KarmaFrom;
		end
		flKarmaTo = 0;
		if KARMA_Filter.KarmaTo ~= nil then
			flKarmaTo = KARMA_Filter.KarmaTo;
		end
		flJoinedAfter = 0;
		if KARMA_Filter.JoinedAfter ~= nil then
			flJoinedAfter = KARMA_Filter.JoinedAfter;
		end
		flJoinedBefore = 0;
		if KARMA_Filter.JoinedBefore ~= nil then
			flJoinedBefore = KARMA_Filter.JoinedBefore;
		end
		flNotes = 0;
		if KARMA_Filter.Notes ~= nil then
			flNotes = strlen(KARMA_Filter.Notes);
		end
		flPublic = 0;
		if KARMA_Filter.Public ~= nil then
			flPublic = strlen(KARMA_Filter.Public);
		end
		flGuild = 0;
		if KARMA_Filter.Guild ~= nil then
			flGuild = strlen(KARMA_Filter.Guild);
		end
		flInstance = 0;
		if KARMA_Filter.Instance ~= nil then
			flInstance = strlen(KARMA_Filter.Instance);
		end
	end

	local	EntryAdd;
	local	Once = 5;
	for sBucketName, BucketValue in pairs(lMembers) do
		for key, value in pairs(BucketValue) do
			EntryAdd = 1;
			if FilterLenTotal > 0 then
				if flPattern > 0 then
					local	keyasascii = KarmaObj.StringToASCII(key);
					if (not string.find(keyasascii, KARMA_Filter.Pattern, 1, true)) then
						EntryAdd = 0;
					end
-- DEBUG>>
--					local	ck = strsub(key, 1, 1);
--					if (ck < 'A') or (ck > 'Z') then
--						KarmaChatDebug("FilterName: Filter = < " .. KARMA_Filter.Pattern .. " > , Key = < " .. key .. " > , AscKey = < " .. keyasascii .. " > , EntryAdd = " .. EntryAdd);
--					end
-- <<DEBUG
				end
				if flName > 0 then
					if (1 ~= string.find(key, KARMA_Filter.Name, 1, true)) then
						EntryAdd = 0;
					end
				end
				if flClass > 0 then
					local vClass = nil;
					-- if ID is set...
					if (type(value[KARMA_DB_L5_RRFFM.CLASS_ID]) == "number") then
						-- ... to a real value ...
						if (value[KARMA_DB_L5_RRFFM.CLASS_ID] ~= 0) then
							local vClsFrmID = KOH.IDToClass(value[KARMA_DB_L5_RRFFM.CLASS_ID]);
							-- ... and we can convert it: assign
							if (vClsFromID ~= "") then
								vClass = vClsFromID;
							end;
						end;
					end;
					-- ID not set, invalid or inconvertible
					if (vClass == nil) then
						vClass = value[KARMA_DB_L5_RRFFM.CLASS];
					end;
--					if (Once == 1) then
--						KarmaChatDefault("flClass > 0: vClass = " .. vClass .. ", K_FC = " .. KARMA_Filter.Class);
--					end
					if (vClass ~= nil) then
						if (vClass ~= "") then
							if 1 ~= string.find(vClass, KARMA_Filter.Class, 1, true) then
								EntryAdd = 0;
							end
						elseif 1 ~= string.find(KARMA_UNKNOWN, KARMA_Filter.Class, 1, true) then
							EntryAdd = 0;
						end
					end
				end
				if (flLevelFrom > 0) or (flLevelTo > 0) then
					local vLevel = value[KARMA_DB_L5_RRFFM.LEVEL];
--					if (Once == 1) then
--						KarmaChatDefault("flLevelFrom + flLevelTo > 0: vLevel = " .. vLevel
--														.. ", K_FLF = " .. Karma_NilToString(KARMA_Filter.LevelFrom)
--														.. ", K_FLT = " .. Karma_NilToString(KARMA_Filter.LevelTo));
--					end
					if (vLevel ~= nil) then
						if (vLevel > 0) then
							if (flLevelFrom > 0) and (KARMA_Filter.LevelFrom > vLevel) then
								EntryAdd = 0;
							end
							if (flLevelTo > 0) and (KARMA_Filter.LevelTo < vLevel) then
								EntryAdd = 0;
							end
						end
					end
				end
				if (flKarmaFrom > 0) or (flKarmaTo > 0) then
					local vKarma = Karma_MemberObject_GetKarmaModified(value);
--					if (Once == 1) then
--						KarmaChatDefault("flKarmaFrom + flKarmaTo > 0: vKarma = " .. vKarma
--														.. ", K_FKF = " .. Karma_NilToString(KARMA_Filter.KarmaFrom)
--														.. ", K_FKT = " .. Karma_NilToString(KARMA_Filter.KarmaTo));
--					end
					if (vKarma ~= nil) then
						if (vKarma > 0) then
							if (flKarmaFrom > 0) and (KARMA_Filter.KarmaFrom > vKarma) then
								EntryAdd = 0;
							end
							if (flKarmaTo > 0) and (KARMA_Filter.KarmaTo < vKarma) then
								EntryAdd = 0;
							end
						end
					end
				end
				if ((flJoinedAfter ~= 0) or (flJoinedBefore ~= 0)) then
					local	vJoined = value[KARMA_DB_L5_RRFFM_JOINEDLAST_TIME];
					if (vJoined ~= nil) then
--						if (Once > 0) then
--							KarmaChatDebug("flJoined* set: vJoined = " .. vJoined .. ", K_FJ = " ..
--								Karma_NilToString(KARMA_Filter.JoinedAfter) .. " -> " .. Karma_NilToString(KARMA_Filter.JoinedBefore));
--						end
						local	tNow = time();
						if ((flJoinedAfter < 0) and (tNow + (flJoinedAfter * 86400) > vJoined)) then
							EntryAdd = 0;
						elseif ((flJoinedAfter > 0) and (flJoinedAfter > vJoined)) then
							EntryAdd = 0;
						end
						if ((flJoinedBefore < 0) and (tNow + (flJoinedBefore * 86400) < vJoined)) then
							EntryAdd = 0;
						elseif ((flJoinedBefore > 0) and (flJoinedBefore < vJoined)) then
							EntryAdd = 0;
						end
					else
						EntryAdd = 0;
					end
				end
				if flNotes > 0 then
					local vNotes = value[KARMA_DB_L5_RRFFM_NOTES];
--					if (Once > 0) then
--						KarmaChatDefault("flNotes > 0: vNotes = " .. vNotes .. ", K_FC = " .. KARMA_Filter.Notes);
--					end
					if (vNotes ~= nil) then
						if nil == strfind(vNotes, KARMA_Filter.Notes) then
							EntryAdd = 0;
						end
					else
						EntryAdd = 0;
					end
				end
				if flPublic > 0 then
					local vPublic = value[KARMA_DB_L5_RRFFM_PUBLIC_NOTES];
--					if (Once == 1) then
--						KarmaChatDefault("flPublic > 0: vPublic = " .. vPublic .. ", K_FC = " .. KARMA_Filter.Public);
--					end
					if (vPublic ~= nil) then
						if nil == strfind(vPublic, KARMA_Filter.Public) then
							EntryAdd = 0;
						end
					else
						EntryAdd = 0;
					end
				end
				if flGuild > 0 then
					local vGuild = value[KARMA_DB_L5_RRFFM.GUILD];
--					if (Once == 1) then
--						KarmaChatDefault("flPublic > 0: vPublic = " .. vPublic .. ", K_FC = " .. KARMA_Filter.Public);
--					end
					if ((vGuild ~= nil) and (vGuild ~= "")) then
						if nil == strfind(vGuild, KARMA_Filter.Guild) then
							EntryAdd = 0;
						end
					elseif (KARMA_Filter.Guild ~= KarmaModuleLocal.Guildless) then
						EntryAdd = 0;
					end
				end
				if flInstance > 0 then
					-- worst of all filters... must walk over instance list
					if not KarmaObj.DB.JoinedInInstance(value, KARMA_CURRENTCHAR, KARMA_Filter.Instance) then
						EntryAdd = 0;
					end
				end

				if (Once > 0) then
					Once = Once - 1;
				end
			end
			if EntryAdd == 0 then
				if KARMA_CURRENTMEMBER ~= nil then
					if key == KARMA_CURRENTMEMBER then
						EntryAdd = 1;
					end
				end
			end
			if EntryAdd == 1 then
				MemberNames[i] = key;
				i = i + 1;
			end
		end
	end
	iNumEntries = i;

	KARMA_NamesSortedAlpha = KOH.AlphaBucketSort(MemberNames);
	KARMA_NamesSortedCustom = Karma_MemberFieldNumericSort(KARMA_NamesSortedAlpha);

	KarmaChatDebug("MemberCache: total of " .. i .. " entries (" .. #KARMA_NamesSortedAlpha .. "/" .. #KARMA_NamesSortedCustom .. ")");
end

local	function	Karma_CleanupRegions(oMember)
	local	CommonRegionList = KarmaObj.DB.CG.RegionListGet();

	if (type(oMember[KARMA_DB_L5_RRFFM_CHARACTERS]) == "table") then
		local	sPlayer, oPlayer;
		for sPlayer, oPlayer in pairs(oMember[KARMA_DB_L5_RRFFM_CHARACTERS]) do
			if (type(oPlayer[KARMA_DB_L6_RRFFMCC_REGIONLIST]) == "table") then
				KarmaChatDebug("Checking regionlist for " .. sPlayer .. "...");

				local	iRegion, oRegion;
				for iRegion, oRegion in pairs(oPlayer[KARMA_DB_L6_RRFFMCC_REGIONLIST]) do
					local	sName = CommonRegionList[oRegion[KARMA_DB_L7_RRFFMCCRR_ID]].Name;
					KarmaChatDebug("Checking list of region " .. sName .. "...");

					local	iDay, oDay, iCount;
					iCount = 0;
					for iDay, oDay in pairs(oRegion[KARMA_DB_L7_RRFFMCCRR_PLAYEDDAYS]) do
						iCount = iCount + 1;
						local	iStart = oDay[KARMA_DB_L8_RRFFMCCRRD_START];
						local	iEnd = oDay[KARMA_DB_L8_RRFFMCCRRD_END];
						if (iStart and iEnd and (time() - iEnd > 87600)) then
							if (abs(iEnd - iStart) < 30) then
								iCount = iCount - 1;
								KarmaChatDebug("Killing flakey entry [" .. sName .. "]: " .. date("%Y-%m-%d %H:%M", iStart) .. " " .. KOH.Duration2String(math.abs(iEnd - iStart)));
								oRegion[KARMA_DB_L7_RRFFMCCRR_PLAYEDDAYS][iDay] = nil;
							end
						end
					end

					if (iCount == 0) then
						KarmaChatDebug("Nothing left in regionlist for " .. sName .. "... dropping entirely.");
						oPlayer[KARMA_DB_L6_RRFFMCC_REGIONLIST][iRegion] = nil;
					end
				end
			else
				KarmaChatDebug("No regionlist for " .. sPlayer .. " yet...");
			end
		end
	end
end

function	Karma_MemberList_CreatePartyNamesCache()
	local	i = 0;
	local	VerAlreadyReq = 0;

	local	KARMA_PartyNamesOld = {};
	local	key, value;
	for key, value in pairs(KARMA_PartyNames) do
		KARMA_PartyNamesOld[key] = 1;
	end
	value = nil;

	KARMA_PartyNames = {};
	local	sUnit, sName, sServer, sCombined, bHaveUnknown;

	Karma_WhoAmIInit();

	local	iMax = GfTt.GetNumPartyMembersTf();
	local	sBase = "party";
	if (Karma_PlayerIsInRaid()) then
		if (KCfg.Get("RAID_TRACKALL") == 1) then
			iMax = GfTt.GetNumRaidMembersTf();
			sBase = "raid";
		elseif (KCfg.Get("RAID_NOGROUP") == 1) then
			return
		end
	end

	if ((iMax > 0) and (KarmaModuleLocal.WarnTrackingOnce == nil)) then
		KarmaModuleLocal.WarnTrackingOnce = 1;
		local	sVersion = KCfg.Get("TRACK_DISABLEWARNING_VERSION");
		if (sVersion ~= KARMA_VERSION_TEXT) then
			if (KCfg.Get("TRACK_DISABLEQUEST") == 1) then
				KarmaChatDefault("|cFFFF2020Quest tracking is currently DISabled.|r");
			end
			if (KCfg.Get("TRACK_DISABLEZONE") == 1) then
				KarmaChatDefault("|cFFFF2020Zone tracking is currently DISabled.|r");
			end
			if (KCfg.Get("TRACK_DISABLEREGION") == 1) then
				KarmaChatDefault("|cFFFF2020Region (= dungeon) tracking is currently DISabled.|r");
			end
			if (KCfg.Get("TRACK_DISABLEACHIEVEMENT") == 1) then
				KarmaChatDefault("|cFFFF2020Achievement tracking is currently DISabled.|r");
			elseif (KCfg.Get("TRACK_DISABLEACHIEV_TERROR") == 1) then
				KarmaChatDefault("|cFFFF2020Cutthroat achievement tracking is currently DISabled.|r");
			end

			KCfg.Set("TRACK_DISABLEWARNING_VERSION", KARMA_VERSION_TEXT);
		end
	end

	KarmaChatDebug("CreatePartyNamesCache: base = " .. sBase .. ", max. = " .. iMax);

	local	iNow = time();
	for i = 1, iMax do
		sUnit = sBase .. i;
		sName, sServer = UnitName(sUnit);
		if (sServer == "") then
			sServer = nil;
		end
		if (sName ~= nil) and (sServer or (sName ~= WhoAmI)) then
			-- Unknown or information not yet available (e.g. when joining a 40 player raid)
			if  ((sName == KARMA_UNKNOWN) or (UnitHealthMax(sUnit) == 1)) then
				bHaveUnknown = true;
			end

			sCombined = sName;
			if (sServer) then
				sCombined = sName .. "@" .. sServer;
			end

			local	iCC, sReason = Karma_MemberList_CollisionCheck(nil, sCombined, sUnit);
			if (iCC == 1) then
				if (sName ~= KARMA_UNKNOWN) then
					KarmaChatDefault("|cFFFF4040WARNING!|r Cannot add or change any information for >" .. KOH.Name2Clickable(sCombined) .. "< : " .. sReason .. "! Either do a '" .. KARMA_CMDSELF .. " forceupdate " .. sCombined .. "' or a '" .. KARMA_CMDSELF .. " forcenew " .. sCombined .. "'!", true);
				end
				KARMA_PartyNames[sCombined] = nil;
			else
				-- check if already there, if not, check if history has data
				local	oMember = Karma_MemberList_GetObject(sCombined);
				if (oMember == nil) then
					local	oServer = KarmaObj.DB.FactionServerGet(sServer);
					KOH.TableInit(oServer, KARMA_DB_L4_RRFF.HISTORY_MOVED);
					KOH.TableInit(oServer, KARMA_DB_L4_RRFF.HISTORY_SEEN);
					if (oServer[KARMA_DB_L4_RRFF.HISTORY_MOVED][sName]) then
						oServer[KARMA_DB_L4_RRFF.HISTORY_SEEN][sName] = iNow;
						KarmaChatDefault("Player " .. sCombined .. " has a historic record. Trying to load up history and restore the information... (You might want to /reload on success to unload the historic database module again.)");
						local	args = { [2] = sServer };
						Karma_LoadHistory();
						KSlash.History(args, 2, true);
					end
				end

				Karma_MemberList_Add(sCombined, true);
				Karma_MemberList_Update(sCombined);
				KARMA_PartyNames[sCombined] = Karma_MemberList_GetObject(sCombined);
				if (KARMA_OtherInfos[sCombined] == nil) then
					Karma_CleanupRegions(KARMA_PartyNames[sCombined]);
					KARMA_OtherInfos[sCombined] = {};
				end

				if (KARMA_OtherInfos[sCombined].ver) then
					VerAlreadyReq = VerAlreadyReq + 1;
				end

				-- TODO: switch to disable self
				if (KARMA_OtherInfos[sCombined].Queried == nil) then
					KARMA_OtherInfos[sCombined].Queried = 0;
					Karma_QueueCommandShareQuery(sCombined);
				end

				if (sName ~= KARMA_UNKNOWN) then
					local	iTime = 0;
					if (KARMA_PartyNames[sCombined][KARMA_DB_L5_RRFFM_TALENTTREE] ~= nil) then
						iTime = KARMA_PartyNames[sCombined][KARMA_DB_L5_RRFFM_TALENTTREE]["Time"];
						-- MoP: can't scan inactive spec any longer
						if (KarmaObj.Const.iTOC >= 50000) then
							local	iTimeSub, i;
							for i = 1, 2 do
								iTimeSub = 0;
								if (KARMA_PartyNames[sCombined][KARMA_DB_L5_RRFFM_TALENTTREE]["S_" .. i]) then
									iTimeSub = KARMA_PartyNames[sCombined][KARMA_DB_L5_RRFFM_TALENTTREE]["S_" .. i].Time;
								end
								iTime = math.min(iTime, iTimeSub);
							end
						end
					end
	
					-- if most recent update is more than 12 hours old...
					if (iNow - iTime) > 43200 then
						KARMA_TalentInspect.RequiredList[sUnit] = sCombined;
					end

					if ((UnitLevel(sUnit) >= 80) and
					    (KCfg.Get("TRACK_DISABLEACHIEVEMENT") ~= 1) and
					    (KCfg.Get("TRACK_DISABLEACHIEV_TERROR") ~= 1)) then
						local	iUpdate = 0;
						if (KARMA_PartyNames[sCombined][KARMA_DB_L5_RRFFM_TERROR] ~= nil) then
							iUpdate = KARMA_PartyNames[sCombined][KARMA_DB_L5_RRFFM_TERROR].Updated;
						end
						if (iUpdate and (iNow - iUpdate > 43200)) then
							KarmaModuleLocal.AchievementCheckTerrorList[sUnit] = sCombined;
						end
					end
				end
			end
		end
	end

	KARMA_TalentInspect.RequiredCount = 0;
	for sUnit, sName in pairs(KARMA_TalentInspect.RequiredList) do
		KARMA_TalentInspect.RequiredCount = KARMA_TalentInspect.RequiredCount + 1;
	end
	KarmaModuleLocal.AchievementCheckTerrorCount = 0;
	for sUnit, sName in pairs(KarmaModuleLocal.AchievementCheckTerrorList) do
		KarmaModuleLocal.AchievementCheckTerrorCount = KarmaModuleLocal.AchievementCheckTerrorCount + 1;
	end

	local	bPartyChanged;
	for key, value in pairs(KARMA_PartyNames) do
		if (KARMA_PartyNamesOld[key] ~= 1) then
			-- player joined
			bPartyChanged = true;
			Karma_MemberList_CharContainerCleanup(key, false);
		end
	end
	for key, value in pairs(KARMA_PartyNamesOld) do
		if (KARMA_PartyNames[key] == nil) then
			-- player left
			bPartyChanged = true;
			Karma_MemberList_CharContainerCleanup(key, true);
		end
	end

	if (bPartyChanged) then
		local	sOld = "";
		for key, value in pairs(KARMA_PartyNamesOld) do
			sOld = sOld .. ", " .. key;
		end
		local	sNew = "";
		for key, value in pairs(KARMA_PartyNames) do
			sNew = sNew .. ", " .. key;
		end

		KarmaChatDebug("MRU list: updating due to party changes (" .. strsub(sOld, 3) .. " => " .. strsub(sNew, 3) .. ")");
		KarmaObj.DB.SF.RecentlyJoinedUpdate(KARMA_PartyNames);
	end

	if (bPartyChanged) and (iMax > 0) then
		if (VerAlreadyReq < iMax) then
			if (Karma_PlayerIsInRaid()) then
				KarmaModuleLocal.Command.VersionQueryQueue("?v1", "RAID");
			elseif (Karma_PlayerIsInParty()) then
				KarmaModuleLocal.Command.VersionQueryQueue("?v1", "PARTY");
			end
		end

		KARMA_TalentInspect.OtherFramesWarn = 1;

		local	bWarn, iWarnLevel;
		if (KCfg.Get("JOINWARN_ENABLED") == 1) then
			iWarnLevel = KCfg.Get("JOINWARN_THRESHOLD");
		end
		if (iWarnLevel) then
			iWarnLevel = tonumber(iWarnLevel);
			for key, value in pairs(KARMA_PartyNames) do
				local	iKarma = Karma_MemberObject_GetKarmaModified(KARMA_PartyNames[key]);
				if (iKarma) and (iKarma < iWarnLevel) and (KARMA_OtherInfos[key].warn == nil) then
					KarmaChatDefault("|cFFFF4040" .. KARMA_MSG_PARTYJOINED_LOWKARMA1 .. KARMA_WINEL_FRAG_COLONSPACE
						.. key .. KARMA_MSG_PARTYJOINED_LOWKARMA2 .. iKarma
						.. KARMA_MSG_PARTYJOINED_LOWKARMA3 .. iWarnLevel .. KARMA_MSG_PARTYJOINED_LOWKARMA4, true);
					KARMA_OtherInfos[key].warn = 1;
					bWarn = true;
				end
			end
		end
		if (bWarn) then
			PlaySoundFile("Sound\\Creature\\HoundmasterLoksey\\HoundmasterLokseyAggro01.wav");
		end
	end

	if ((KARMA_CURRENTLIST == 2) and (sBase == "raid")) then
		Karma_MemberList_ResetMemberNamesCache();
	end

	if (bHaveUnknown) then
		KarmaChatDebug("Got an *Unknown* as party member. Queueing a second call to CreatePartyNamesCache in 10 seconds...");
		Karma_Queue_ReCreatePartyNamesCache();
	end
end

function	Karma_Queue_ReCreatePartyNamesCache()
	-- sometimes we get an "Unknwon" and this is then wrongly assigned until the party changes!
	-- so: delayed update to cache

	-- now also called regularly instead of Create, because of the update mechanism of Blizzard to send events as 0, 1, 2, ... n as party size
	-- therefore, check if already in progress:
	local	bFound = false;
	local	fCheck = function(oCmd)
			if (oCmd.sName == "CreatePartyNamesCache") then
				bFound = true;
				return false;
			end

			return true;
		end
	KarmaObj.Slash.CommandQIterate(fCheck);

	if (bFound) then
		KarmaChatDebug("Already queued a CPNC, skipping additional.");
		return
	end

	local	oEntry = {};
	oEntry.At = GetTime() + 10;
	oEntry.CmdList = {};
	oEntry.CmdList[1] = { sName = "CreatePartyNamesCache", func = Karma_MemberList_CreatePartyNamesCache, args = {} };

	Karma_CronQueue[#Karma_CronQueue + 1] = oEntry;
end

function	Karma_GetQuestObjectives(qIndex, qContainer, qForce)
	if 	(qIndex == nil) or (qContainer == nil) or
		((KARMA_QExCreate == 0) and (qForce == nil)) then
		return;
	end

	if (KARMA_QExInitDone == 0) then
		-- WoW is *not* properly intializing objectives without opening the QLog :(
		-- ToggleQuestLog();
		QuestLog_OnShow(self);
		QuestLog_OnHide();
		KARMA_QExInitDone = 1;
	end

	if (KARMA_QExCreateLog > qIndex) then
		KarmaChatDebug("K_GQO: >> qIndex = " .. qIndex);
	end

	qContainer.objectives = nil;

	local qTotalProgress = 0;
	local qObjectiveCount = GetNumQuestLeaderBoards(qIndex);
	if qObjectiveCount then
		if (qObjectiveCount > 0) then
			qContainer.objectives = {};

			local qObjective;
			for qObjective = 1, qObjectiveCount do
				local	qdesc, qtype, qdone = GetQuestLogLeaderBoard(qObjective, qIndex);
				qContainer.objectives[qObjective] = {};
				qContainer.objectives[qObjective].desc = qdesc;
				qContainer.objectives[qObjective].type = qtype;
				if (qdone == nil) then
					qdone = 0;
				end
				qContainer.objectives[qObjective].done = qdone;
				local qProgress = 0;
				if (qdone == 1) then
					qProgress = 100;
				end

				-- try to find a ": <num>/<num>"...
				-- item, monster: obvious
				-- object: e.g. Burning Steppes quests (e.g. Broodling Essence)
				if (qtype == "item") or (qtype == "object") or (qtype == "monster") then
					local colonpos = strfind(qdesc, ":", 1, true);
					if (colonpos ~= nil) then
						local slashpos = strfind(qdesc, "/", colonpos, true);
						if (slashpos ~= nil) then
							local sCountCurr = strsub(qdesc, colonpos + 1, slashpos - 1);
							local sCountTotal = strsub(qdesc, slashpos + 1);
							local iCountCurr = tonumber(sCountCurr);
							local iCountTotal = tonumber(sCountTotal);
							if (iCountCurr ~= nil) and (iCountTotal ~= nil) and (iCountTotal > 0) then
								qProgress = ceil(100 * iCountCurr / iCountTotal);
							end
						end
					end
				end

				qContainer.objectives[qObjective].progress = qProgress;
				qTotalProgress = qTotalProgress + qProgress;
			end
		end
	end

	qContainer.totalProgress = qTotalProgress;


	if (KARMA_QExCreateLog > qIndex) then
		KarmaChatDebug("K_GQO: << qIndex = " .. qIndex);
	end
end

function	Karma_CreateQuestCache(force, Switch1, Switch2, Switch3)
	KarmaObj.ProfileStart("Karma_CreateQuestCache");

	if (Switch1 ~= nil) then
		KARMA_QExCreate = Switch1;
		if (KARMA_QEx_NumPartyMembers == 0) then
			KARMA_QEx_NumPartyMembers = 1;
		end
		KarmaChatDebug("K_CQC: QExC <- 50, QEx_NPM > 0");
	end
	if (Switch2 ~= nil) then
		KARMA_QExCreateLog = Switch2;
		KarmaChatDebug("K_CQC: QExCL <- 50");
	end
	if (Switch3 ~= nil) then
		KARMA_QExUpdate = Switch3;
		KarmaChatDebug("K_CQC: QExU <- 50");
	end

	local	iOldTotal, iOldDaily, iOldCompleted, k, v = 0, 0, 0;
	for k, v in pairs(KARMA_QuestCache) do
		iOldTotal = iOldTotal + 1;
		if (v.daily == 1) then
			iOldDaily = iOldDaily + 1;
		end
		if (v.complete == 1) then
			iOldCompleted = iOldCompleted + 1;
		end
	end

	-- incredible often the QL refreshes like mad for no particular reason... stop that.
	-- force it down to .2s delays
	local	gtSeconds = ceil(GetTime() * 5);
	if (KARMA_QuestCache_LastUpdated + 5 > gtSeconds) then
		if (force ~= 1) then
			KarmaObj.ProfileStop("Karma_CreateQuestCache");
			return;
		end
	end

	-- first, check for collapsed entries and WARN
	local	iNumEntries = GetNumQuestLogEntries();
	local	previousIsHeader = nil;
	local	Warn = false;
	local	iNumQuests = 0;
	local	i;
	local	sWarnComp = "";
	for i = 1, iNumEntries do
		local	questLogTitleText, level, questTag, suggestedGroup, isHeader, isCollapsed, isComplete, isDaily = GetQuestLogTitle(i);
		if (isHeader == 1) then
			sWarnComp = sWarnComp .. "H";
			if (previousIsHeader == 1) then
				Warn = true;
			end
		else
			sWarnComp = sWarnComp .. "Q";
		end
		if (isHeader ~= 1) then
			iNumQuests = iNumQuests + 1;
		end
		previousIsHeader = isHeader;
	end
	-- only last section collapsed?
	if (previousIsHeader == 1) then
		Warn = true;
	end

	if (force ~= 1) then
		-- count same?
		if (KARMA_QuestCache_LastQLEC == iNumQuests) then
			-- same count, do nothing
			KarmaObj.ProfileStop("Karma_CreateQuestCache");
			return
		end
		-- only partial info currently?
		if Warn and (KARMA_QuestCache_LastQLEC > iNumQuests) then
			-- something is collapsed and we got more in cache
			-- => assume cache is more correct
			KarmaObj.ProfileStop("Karma_CreateQuestCache");
			return
		end
	end

	-- should go into UI...
	local	bQuestlogCollapsedWarning = KCfg.Get("QUESTWARNCOLLAPSED");
	if (bQuestlogCollapsedWarning == 0) then
		if Warn then
			Warn = KARMA_WarnedOnce == 0;
			KARMA_WarnedOnce = 1;
		end
	elseif (bQuestlogCollapsedWarning == nil) then
		KCfg.Set("QUESTWARNCOLLAPSED", 1);
	end
	if (Warn) and (sWarnComp ~= KARMA_QExsWarnComp) then
		KarmaChatSecondaryFallbackDefault(KARMA_MSG_QCACHE_WARNING);
	end

	KARMA_QExsWarnComp = sWarnComp;

	KARMA_QuestCache_LastUpdated = gtSeconds;
	KARMA_QuestCache_LastQLEC = iNumQuests;
	KARMA_QuestCache = {};

	local	i = 0;
	local	iNumCached, iNumDaily, iNumCompleted = 0, 0, 0;
	local	extid, s0, s1, s2, s3;
	for i = 1, iNumEntries do
		-- suggestedGroup: new with 2.0.3 (stupid Blizzard, why not insert new params at the end?)
		local	questLogTitleText, level, questTag, suggestedGroup, isHeader, isCollapsed, isComplete, isDaily = GetQuestLogTitle(i);
		if (questLogTitleText ~= nil and questLogTitleText ~= "" and isHeader ~= 1) then
			-- isComplete: tristate (-1 (failed), nil (todo), +1 (succeeded))
			if (isComplete == nil) then
				isComplete = 0;
			end

			extid = GetQuestLink(i);
			if (extid) then
				-- split out the QID itself
				s0, s1, s2, s3 = strsplit("|", extid);
				s1, extid, s3 = strsplit(":", s2);
			end
 
			local	oQC = {};
			oQC.id = i;
			Karma_GetQuestObjectives(oQC.id, oQC, force);
			if ((oQC.objectives == nil) or ((#oQC.objectives == 1) and (oQC.objectives[1].type == "log"))) then
				-- tracking of this is buggy on Blizzard's end (toggles completed around)
				KarmaChatDebug("Karma_CreateQuestCache: Ignoring <" .. i .. ": " .. questLogTitleText .. ">.");
				KARMA_QuestCache[questLogTitleText] = nil;
				oQC = nil;
			end

			if (oQC) then
				KARMA_QuestCache[questLogTitleText] = oQC;
				iNumCached = iNumCached + 1;

				oQC.extid = extid;
				oQC.complete = isComplete;
				if (isComplete == 1) then
					iNumCompleted = iNumCompleted + 1;
				end
				if (isDaily) then
					oQC.daily = 1;
					iNumDaily = iNumDaily + 1;
				else
					oQC.daily = 0;
				end
			end
		end
	end

	KarmaChatDebug("Karma_CreateQuestCache-Old: Total Count = " .. iOldTotal .. ", " .. iOldDaily .. " 'daily's; " .. iOldCompleted .. " completed.");
	KarmaChatDebug("Karma_CreateQuestCache-New: Total Count = " .. iNumCached .. ", " .. iNumDaily .. " 'daily's; " .. iNumCompleted .. " completed.");

	KarmaObj.ProfileStop("Karma_CreateQuestCache");
end

function	Karma_UpdateQuest(event)
	KarmaObj.ProfileStart("Karma_UpdateQuest");

	if (KCfg.Get("TRACK_DISABLEQUEST") == 1) then
		KarmaChatDebug("Quest tracking is currently disabled.");
		return
	end

	local sName, value, i;
	local UpdateWindow = false;
	for sName, value in pairs(KARMA_QuestCache) do
		for i = 1, GetNumQuestLogEntries() do
			local	questLogTitleText, level, questTag, suggestedGroup, isHeader, isCollapsed, isComplete = GetQuestLogTitle(i);
			if (sName == questLogTitleText) then
				if (isComplete == nil) then
					isComplete = 0;
				end

				-- DEBUG:
				if (value.complete ~= isComplete) then
					KarmaChatDebug("Karma: " .. sName .. KARMA_WINEL_FRAG_COLONSPACE .. Karma_NilToString(value.complete) .. " -> " .. Karma_NilToString(isComplete));
				end
				-- :DEBUG

				-- new: count *partial* progress on quest goals also
				if (KARMA_QExUpdate > i) and (value.objectives ~= nil) then
					local QuestObjectives = {};
					Karma_GetQuestObjectives(i, QuestObjectives);
					if (QuestObjectives.totalProgress ~= nil) and (value.totalProgress ~= nil) then
						if (QuestObjectives.totalProgress > 1 + value.totalProgress) then
							KarmaChatDebug("Karma: " .. sName .. KARMA_WINEL_FRAG_COLONSPACE .. value.totalProgress .. " -> " .. QuestObjectives.totalProgress .. " (1)");
							Karma_AddQuestToPartyMembers(sName, value, QuestObjectives, value.extid, value.daily);
							UpdateWindow = true;
						end
					end
				else
					-- old: only count as completed, when going from incomplete to completed
					if (value.complete == 0) and (isComplete == 1) then
						KarmaChatDebug("Karma: " .. sName .. KARMA_WINEL_FRAG_COLONSPACE .. "0 -> 1 (2)");
						Karma_AddQuestToPartyMembers(sName, nil, nil, value.extid, value.daily);
						UpdateWindow = true;
					end
				end
			end
		end
	end

	if (UpdateWindow) then
		KarmaWindow_Update();
	end

	KarmaObj.ProfileStop("Karma_UpdateQuest");
end


-----------------------------------------
-- QuestList routines
-----------------------------------------

-- OnClick: self-send link
function	KarmaWindow_QuestList_OnClick(oQuestBtn, sMousebutton)
	if	(sMousebutton == "LeftButton") and (IsShiftKeyDown()) and
		(DEFAULT_CHAT_FRAME) and not DEFAULT_CHAT_FRAME.editBox:IsShown() then
		local	btntxt = getglobal(oQuestBtn:GetName() .. "_Text");
		if (btntxt) then
			local	questid = btntxt.ExtID;
			if (questid) then
				local	text = "http://wow.allakhazam.com/db/quest.html?wquest=" .. questid .. ";locale=" .. GetLocale();
				ChatFrame_OpenChat(text);
			end
		end
	end
end

function	Karma_QuestList_AddQuest(questname, extid)
	-- negative = new global list
	local QID = - CommonQuestAdd(questname, extid);
	return QID;
end

function QuestListNamesSortFunc(i1, i2)
	if (i1.RegionName < i2.RegionName) then
		return true;
	elseif (i1.RegionName > i2.RegionName) then
		return false;
	else
		if (i1.name < i2.name) then
			return true;
		else
			return false;
		end
	end
end

-- Generates a list of names, based on the input of a list of quest ids.
function	Karma_QuestList_GetListOfNames(questids)
	local	questnames = {};

	local	globalRegions = CommonRegionListGet();
	local	localQuests = KarmaObj.DB.SF.QuestListGet();
	local	globalQuests = KarmaObj.DB.CF.QuestNameListGet();
	local	globalQuestInfos = CommonQuestInfoListGet();
	local	questitem, regionitem;
	local	RegionsAddedL = {};
	local	x = 1;
	for key, value in pairs(questids) do
		if (value < 0) then
			local posval = - value;
			if (globalQuests and (globalQuests[posval] ~= "")) then
				questitem = {};
				questitem.id = value;
				questitem.name = globalQuests[posval];
				questitem.RegionName = "";
				if (globalQuestInfos[posval] ~= nil) then
					questitem.ExtID = globalQuestInfos[posval].ExtID;
					questitem.RegionID = globalQuestInfos[posval].RegionID;
					questitem.RegionName = nil;
					if (globalRegions[questitem.RegionID]) then
						questitem.RegionName = globalRegions[questitem.RegionID].Name;
					elseif (questitem.RegionID == 0) then
						questitem.RegionName = KARMA_CHATMSG_VARIOUS_REGIONS;
					end

					if (questitem.RegionName ~= nil) then
						if (RegionsAddedL[questitem.RegionID] == nil) then
							RegionsAddedL[questitem.RegionID] = 1;

							regionitem = {};
							regionitem.name = "";
							regionitem.RegionID = questitem.RegionID;
							regionitem.RegionName = questitem.RegionName;
							tinsert(questnames, regionitem);
							x = x + 1;
						end
					end
				end
				tinsert(questnames, questitem);
				x = x + 1;
			end
		end

		if (value > 0) then
			if (localQuests[value] ~= "") then
				questitem = {};
				questitem.id = value;
				questitem.name = localQuests[value];
				tinsert(questnames, questitem);
				x = x+1;
				end
			end
		end

	KOH.GenericSort(questnames, QuestListNamesSortFunc);
	return questnames;
end

-----------------------------------------
-- ZoneList routines
-----------------------------------------
-- Adds the zone to the zone list, then returns the uniqueid for that zone.
-- If the zone is already in the list then this will return the uniqueid already in existance.

--[[function	Karma_ZoneList_AddZone(zonename)
	KarmaObj.ProfileStart("Karma_ZoneList_AddZone");
	local	lZones;
	lZones = KarmaObj.DB.SF.ZoneListGet();
	if (lZones == nil) then
		KarmaChatDebug("lZones == nil");
	else
		KarmaChatDebug("lZones ~= nil");
	end
	for key, value in pairs(lZones) do
		if (value == zonename) then
			KarmaObj.ProfileStop("Karma_ZoneList_AddZone");
			return key;
		end
	end
	local	newid = getn(lZones)+1;
	lZones[newid] = zonename;
	KarmaObj.ProfileStop("Karma_ZoneList_AddZone");
	return newid;
end]]--

function	Karma_ZoneList_AddZone(zonename)
	local ZID, RID = CommonRegionZoneAdd(nil, zonename, nil, nil);
	if ZID == nil then
		return nil;
	else
		return - ZID, RID;
	end
end

function	Karma_CompareZoneList(Entry1, Entry2)
	if (Entry1.Region ~= nil) or (Entry2.Region ~= nil) then
		local	Region1, Region2;
		if Entry1.Region == nil then
			Region1 = "";
		else
			Region1 = Entry1.Region;
		end
		if Entry2.Region == nil then
			Region2 = "";
		else
			Region2 = Entry2.Region;
		end

		if Region1 < Region2 then
			return true;
		end
		if Region1 > Region2 then
			return false;
		end
	end

	local rv = Entry1.Zone < Entry2.Zone;
	return rv;
end

-- Generates a list of names, based on the input of a list of zone ids.
function	Karma_ZoneList_GetListOfNames(zoneids, iRegioncount)
	local	zonenames = {};
	iRegioncount = 0;
	if (type(zoneids) ~= "table") then
		return	zonenames, iRegioncount;
	end

	local	localZones = KarmaObj.DB.SF.ZoneListGet();
	local	globalZones = CommonZoneListGet();
 	local	x = 1;
	local	OldCount = 0;

	for key, value in pairs(zoneids) do
		if value > 0 then
			OldCount = OldCount + 1;
		end
	end

	if OldCount > 0 then
		for key, value in pairs(zoneids) do
			if (value < 0) then
				local posval = - value;
				if (globalZones[posval].Name ~= "") then
					zonenames[x] = globalZones[posval].Name;
					x = x+1;
				end
			end
			if (value > 0) then
				if (localZones[value] ~= "") then
					zonenames[x] = localZones[value];
					x = x+1;
				end
			end
		end
		KOH.GenericSort(zonenames, nil);
	else
		local	globalRegions = CommonRegionListGet();
		local	RegionsL = {};
		for key, value in pairs(zoneids) do
			local posval = - value;
			if (globalZones[posval].Name ~= "") then
				zonenames[x] = {};
				zonenames[x].Zone = globalZones[posval].Name;
				if globalZones[posval].RegionID ~= nil then
					local	RegionID = globalZones[posval].RegionID;
					if globalRegions[RegionID] ~= nil then
						local	sRegionName = globalRegions[RegionID].Name;
						if (globalRegions[RegionID].AreaID) then
							local	sName = KarmaObj.DB.CG.LocaleRegions(globalRegions[RegionID].AreaID);
							if (sName) then
								sRegionName = sName;
							end
						end

						zonenames[x].Region = sRegionName;
						if (RegionsL[RegionID] == nil) then
							RegionsL[RegionID] = 1;

							x = x + 1;
							zonenames[x] = {};
							zonenames[x].RegionID = RegionID;
							zonenames[x].Region = sRegionName;
							zonenames[x].Zone = "";
						end
					end
				end
				x = x + 1;
			end
		end

		KOH.GenericSort(zonenames, Karma_CompareZoneList);
	end

	return zonenames, iRegionCount;
end


-----------------------------------------
-- MEMBERLIST FUNCTIONS
-----------------------------------------

function	Karma_MemberList_GetMemberNamesSortedAlpha()
	if (KARMA_NamesSortedAlpha == nil) then
		Karma_MemberList_CreateMemberNamesCache();
	end

	return Karma_CopyTable(KARMA_NamesSortedAlpha);
end

function	Karma_MemberList_GetMemberNamesSortedCustom()
	if (KARMA_NamesSortedCustom == nil) then
		Karma_MemberList_CreateMemberNamesCache();
	end

	return Karma_CopyTable(KARMA_NamesSortedCustom);
end

local	function	Karma_SameUnit(sName1, sServer1, sName2, sServer2)
	local	Result = true;
	if (sName1 ~= sName2) then
		Result = false;
	end

	if (sServer1 == "") then
		sServer1 = nil;
	end
	if (sServer2 == "") then
		sServer2 = nil;
	end
	if (Result) then
		Result = sServer1 == sServer2;
	end

--[[
local	ResStr = "false";
if (Result) then
	ResStr = "true";
end
KarmaChatDebug("SameUnit: " .. Karma_NilToString(sName1) .. "@" .. Karma_NilToString(sServer1) .. " == "
							.. Karma_NilToString(sName2) .. "@" .. Karma_NilToString(sServer2) .. "? " .. ResStr);
]]--

	return Result;
end

function	Karma_MemberList_MemberNameToUnitName(sMemberName)
	local	iPos = strfind(sMemberName, "@", 1, true);
	local	sServerName = "";
	if (iPos) then
		sServerName = strsub(sMemberName, iPos + 1);
		sMemberName = strsub(sMemberName, 1, iPos - 1);
	end

	local	membercount = GfTt.GetNumPartyMembersTf();
	local	iCounter, sUnitID;
	for iCounter = 1, membercount do
		sUnitID = "party" .. iCounter;
		sUnitName, sUnitServer = UnitName(sUnitID);
		if Karma_SameUnit(sMemberName, sServerName, sUnitName, sUnitServer) then
			return sUnitID;
		end
	end

	local	membercount = GfTt.GetNumRaidMembersTf();
	local	iCounter, sUnitID;
	for iCounter = 1, membercount do
		sUnitID = "raid" .. iCounter;
		sUnitName, sUnitServer = UnitName(sUnitID);
		if Karma_SameUnit(sMemberName, sServerName, sUnitName, sUnitServer) then
			return sUnitID;
		end
	end

	local	sUnitName, sUnitServer;
	sUnitName, sUnitServer = UnitName("target");
	if Karma_SameUnit(sMemberName, sServerName, sUnitName, sUnitServer) then
		return "target";
	end

	sUnitName, sUnitServer = UnitName("mouseover");
	if Karma_SameUnit(sMemberName, sServerName, sUnitName, sUnitServer) then
		return "mouseover";
	end

	return nil;
end

function	Karma_MemberList_Add(sMemberName, bInGroup)
	local	oMember = Karma_MemberList_GetObject(sMemberName, nil, nil, nil, true);
	if (oMember == nil) then
		return;
	end

	Karma_FieldInitialize(oMember, KARMA_DB_L5_RRFFM.LASTCHANGED_TIME, time(), true);
	Karma_FieldInitialize(oMember, KARMA_DB_L5_RRFFM.LASTCHANGED_FIELD, "Created", true);
	if (bInGroup) then
		local	iNow = time();
		oMember[KARMA_DB_L5_RRFFM.LASTCHANGED_TIME] = iNow;
		oMember[KARMA_DB_L5_RRFFM.LASTCHANGED_FIELD] = "Joined";

		oMember[KARMA_DB_L5_RRFFM.LASTSEEN] = iNow;
	end

	Karma_FieldInitialize(oMember, KARMA_DB_L5_RRFFM.NAME, sMemberName, true);
	Karma_FieldInitialize(oMember, KARMA_DB_L5_RRFFM.GUILD, "", true);
	Karma_FieldInitialize(oMember, KARMA_DB_L5_RRFFM.LEVEL, 0, true);
	Karma_FieldInitialize(oMember, KARMA_DB_L5_RRFFM.GENDER, 1, true);
	Karma_FieldInitialize(oMember, KARMA_DB_L5_RRFFM.RACE, "", true);
	Karma_FieldInitialize(oMember, KARMA_DB_L5_RRFFM.CLASS, "", true);
	Karma_FieldInitialize(oMember, KARMA_DB_L5_RRFFM.CLASS_ID, 0, true);

	-- these should all go nil if default:
	Karma_FieldDeinitialize(oMember, KARMA_DB_L5_RRFFM_KARMA, 50, true);
	Karma_FieldDeinitialize(oMember, KARMA_DB_L5_RRFFM.ALTGROUP, -1, true);

-- ================ -- -- ================ -- -- ================ -- -- ================ --

	Karma_FieldDeinitialize(oMember, KARMA_DB_L5_RRFFM_TALENT, 0, true);

	Karma_FieldDeinitialize(oMember, KARMA_DB_L5_RRFFM_NOTES, "", true);
	Karma_FieldDeinitialize(oMember, KARMA_DB_L5_RRFFM_PUBLIC_NOTES, "", true);
	Karma_FieldDeinitialize(oMember, KARMA_DB_L5_RRFFM_PUBLIC_NOTES_HISTORY, "", true);

	Karma_FieldDeinitialize(oMember, KARMA_DB_L5_RRFFM_SKILL, -1, true);
	Karma_FieldDeinitialize(oMember, KARMA_DB_L5_RRFFM_GEAR_PVE, -1, true);
	Karma_FieldDeinitialize(oMember, KARMA_DB_L5_RRFFM_GEAR_PVP, -1, true);
	Karma_FieldDeinitialize(oMember, KARMA_DB_L5_RRFFM_KARMA_IMPORTED, 0, true);
	Karma_FieldDeinitialize(oMember, KARMA_DB_L5_RRFFM_KARMA_TIME, -1, true);

-- ================ -- -- ================ -- -- ================ -- -- ================ --

	KOH.TableInit(oMember, KARMA_DB_L5_RRFFM_TIMESTAMP);
	Karma_FieldInitialize(oMember[KARMA_DB_L5_RRFFM_TIMESTAMP], KARMA_DB_L5_RRFFM_TIMESTAMP_TRY, 0, true);
	Karma_FieldInitialize(oMember[KARMA_DB_L5_RRFFM_TIMESTAMP], KARMA_DB_L5_RRFFM_TIMESTAMP_SUCCESS, 0, true);

	KOH.TableInit(oMember, KARMA_DB_L5_RRFFM_CHARACTERS);

	Karma_WhoAmIInit();
	if (KCfg.Get("DB_SPARSE") == 1) then	-- dbsparse
		if (bInGroup) then
			if (KarmaObj.DB.MC.InitFull(oMember, WhoAmI)) then
				KarmaChatDebug("Adding container to " .. sMemberName .. " for " .. WhoAmI .. "; via: " .. debugstack());
			end
		end
	else
		local	bOk = false;
		local	bForeign = strfind(sMemberName, '@', 1, true);
		if (not bForeign) then
			local	oFaction = KarmaObj.DB.FactionCacheGet();
			for ckey, cvalue in pairs(oFaction[KARMA_DB_L4_RRFF.CHARACTERLIST]) do
				KarmaObj.DB.MC.InitFull(oMember, ckey);
				if (ckey == WhoAmI) then
					bOk = true;
				end
			end
		end

		if (not bOk) then
			KarmaObj.DB.MC.InitFull(oMember, WhoAmI);
		end
	end
end

function	Karma_MemberList_CharContainerCleanup(sMemberName, bTables)
	local	oMember = Karma_MemberList_GetObject(sMemberName);
	if (oMember) then
		local	oTableChar = KarmaObj.DB.MC.GetPlayer(oMember);
		if (oTableChar) then
			oTableChar[KARMA_DB_L6_RRFFMCC_XPLAST] = nil;
			oTableChar[KARMA_DB_L6_RRFFMCC_XPMAX] = nil;
			oTableChar[KARMA_DB_L6_RRFFMCC_PLAYEDLAST] = 0;

			if (bTables) then
				local	k, v;
				for k, v in pairs(oTableChar) do
					if (type(v) == "table") then
						if (KOH.TableIsEmpty(v)) then
							oTableChar[k] = nil;
						end
					end
				end
			end
		end
	end
end

function	Karma_MemberList_GetFieldHighLow(fieldname, oMember)
	local	lowfield;
	local	highfield;
	local	iCounter = 0;

	if (oMember and KarmaModuleLocal.FieldHighLow[fieldname]) then
		local	oField = KarmaModuleLocal.FieldHighLow[fieldname];
		local	xVal = oMember[fieldname];
		if (xVal) then
			if  (xVal < oField.Low) then
				oField.Low = xVal;
			end
			if  (xVal > oField.High) then
				oField.High = xVal;
			end
		end

		lowfield = oField.Low;
		highfield = oField.High;
		iCounter = oField.Counter;
	else
		local	lMembers = KarmaObj.DB.SF.MemberListGet();
		local	perbuckets = {};
		local	bFirst, mbname, mbvalue = true;
		for mbname, mbvalue in pairs(lMembers) do
			if (mbvalue ~= nil) then
				local	sName, record;
				for sName, record in pairs(mbvalue) do
					if (record ~= nil) then
						local	pobj = Karma_MemberObject_GetCharacterObject(record);
						if (pobj and pobj[fieldname]) then
							iCounter = iCounter + 1;
							if (bFirst) then
								bFirst = false;
								lowfield = pobj[fieldname];
								highfield = pobj[fieldname];
							else
								if (pobj[fieldname] < lowfield) then
									lowfield = pobj[fieldname];
								end
								if (pobj[fieldname] > highfield) then
									highfield = pobj[fieldname];
								end
							end
						end
					end
				end
			end
		end

		local	oField = KarmaModuleLocal.FieldHighLow[fieldname];
		if (oField == nil) then
			oField = {};
			KarmaModuleLocal.FieldHighLow[fieldname] = oField;
		end
		oField.Low = lowfield;
		oField.High = highfield;
		oField.Counter = iCounter;
	end

	if (iCounter == 0) then
		return 0, 0, 0;
	end

	local	average = (highfield - lowfield) / iCounter;
	return lowfield, highfield, average;
end

function	Karma_MemberList_GetHighLow_TotalFieldSummedUp(fieldname, oMember)
	local	lowfield;
	local	highfield;
	local	iCounter = 0;

	if (oMember and KarmaModuleLocal.FieldHighLow[fieldname]) then
		local	oField = KarmaModuleLocal.FieldHighLow[fieldname];
		local	iSum;
		if (oMember[KARMA_DB_L5_RRFFM_CHARACTERS]) then
			iSum = 0;
			local	sChar, oChar;
			for sChar, oChar in pairs(oMember[KARMA_DB_L5_RRFFM_CHARACTERS]) do
				if (oChar[fieldname]) then
					iSum = iSum + oChar[fieldname];
				end
			end
		end

		if (iSum) then
			if  (iSum < oField.Low) then
				oField.Low = iSum;
			end
			if  (iSum > oField.High) then
				oField.High = iSum;
			end
		end

		lowfield = oField.Low;
		highfield = oField.High;
		iCounter = oField.Counter;
	else
		local	lMembers = KarmaObj.DB.SF.MemberListGet();
		local	perbuckets = {};
		local	bFirst, mbname, mbvalue = true;
		for mbname, mbvalue in pairs(lMembers) do
			if (mbvalue ~= nil) then
				local	sName, record;
				for sName, record in pairs(mbvalue) do
					if (record ~= nil) then
						iCounter = iCounter + 1;
						local	iSum = 0;
						if (record[KARMA_DB_L5_RRFFM_CHARACTERS]) then
							local	sChar, oChar;
							for sChar, oChar in pairs(record[KARMA_DB_L5_RRFFM_CHARACTERS]) do
								if (oChar[fieldname]) then
									iSum = iSum + oChar[fieldname];
								end
							end
						end

						if (bFirst) then
							bFirst = false;
							lowfield = iSum;
							highfield = iSum;
						else
							if (iSum < lowfield) then
								lowfield = iSum;
							end
							if (iSum > highfield) then
								highfield = iSum;
							end
						end
					end
				end
			end
		end

		local	oField = KarmaModuleLocal.FieldHighLow[fieldname];
		if (oField == nil) then
			oField = {};
			KarmaModuleLocal.FieldHighLow[fieldname] = oField;
		end
		oField.Low = lowfield;
		oField.High = highfield;
		oField.Counter = iCounter;
	end

	if (iCounter == 0) then
		return 0, 0, 0;
	end

	local	average = (highfield - lowfield) / iCounter;
	return lowfield, highfield, average;
end

--
-- Collision check routine
-- if this returns 1, Karma_MemberList_Update should not be called
--
function	Karma_MemberList_CollisionCheckActually(oMember, sCombined, sUnit, iLevel, iClassID, sRace)
	-- Collision check:
	-- - GUID must be equal (easy one...)
	if  (sUnit) and (oMember[KARMA_DB_L5_RRFFM.GUID]) and
		(oMember[KARMA_DB_L5_RRFFM.GUID] == UnitGUID(sUnit)) then
		return 0, "=GUID";
	end

	-- - non-trivial cases: if values are both available, then...
	-- a) level must be greater or equal
	-- b) classid must be equal
	-- b) race must be equal

	local	retval = 0;
	local	retstr = "";

	if (iLevel == nil) and (sUnit ~= nil) then
		iLevel = UnitLevel(sUnit);
	end
	if	(iLevel) and (oMember[KARMA_DB_L5_RRFFM.LEVEL]) and
		(iLevel > 0) and (oMember[KARMA_DB_L5_RRFFM.LEVEL] > 0) and
		(oMember[KARMA_DB_L5_RRFFM.LEVEL] > iLevel) then
		retval = 1;
		retstr = " !Level: " .. iLevel .. " (new) < " .. oMember[KARMA_DB_L5_RRFFM.LEVEL] .. " (old)";
	end

	local	sClass;
	if (iClassID == nil) and (sUnit ~= nil) then
		sClass = UnitClass(sUnit);
		if (sClass) then
			iClassID = KOH.ClassToID(sClass);
		end
	end
	if	(iClassID) and (iClassID ~= 0) and
		(oMember[KARMA_DB_L5_RRFFM.CLASS_ID]) and (oMember[KARMA_DB_L5_RRFFM.CLASS_ID] ~= 0) and
		(math.abs(iClassID) ~= math.abs(oMember[KARMA_DB_L5_RRFFM.CLASS_ID])) then
		if (sClass == nil) then
			sClass = KOH.IDToClass(iClassID);
		end
		retval = 1;
		retstr = retstr .. " !ClassID: " .. iClassID .. " (new: " .. sClass .. ") != " .. oMember[KARMA_DB_L5_RRFFM.CLASS_ID] .. " (old: " .. oMember[KARMA_DB_L5_RRFFM.CLASS] .. ")";
	end

	local	sRaceNewEN;
	if (sRace == nil) and (sUnit ~= nil) then
		sRace, sRaceNewEN = UnitRace(sUnit);
	end
	if  (sRace and (sRace ~= "")) then
		if (sRaceNewEN == nil) then
			sRaceNewEN = Karma_RaceLocalizedToRaceEN(sRace);
		end
		if (sRaceNewEN) then
			sRaceNewEN = strupper(sRaceNewEN);
		end

		local	sRaceOld = oMember[KARMA_DB_L5_RRFFM.RACE] or "";
		local	sRaceOldEN = oMember[KARMA_DB_L5_RRFFM.RACE_EN] or "";
		if (sRaceOldEN ~= "") then
			sRaceOldEN = strupper(sRaceOldEN);
		elseif (sRaceOld ~= "") then
			local	iGender;
			sRaceOldEN, iGender = Karma_RaceLocalizedToRaceEN(oMember[KARMA_DB_L5_RRFFM.RACE], oMember[KARMA_DB_L5_RRFFM.GENDER]);
			if (not iGender or (iGender ~= oMember[KARMA_DB_L5_RRFFM.GENDER])) then
				local	sRaceOldENOther, iGenderOther = Karma_RaceLocalizedToRaceEN(oMember[KARMA_DB_L5_RRFFM.RACE], 5 - oMember[KARMA_DB_L5_RRFFM.GENDER]);
				if (not iGenderOther) then
					sRaceOldEN = "[" .. strupper(sRaceOldEN or "<nil>") .. " - " .. oMember[KARMA_DB_L5_RRFFM.RACE] .. "?: " .. (oMember[KARMA_DB_L5_RRFFM.GENDER] or "?") .. " vs. " .. (iGender or "?") .. "]";
				else
					sRaceOldEN = "[" .. strupper(sRaceOldEN or "<nil>") .. " - " .. oMember[KARMA_DB_L5_RRFFM.RACE] .. "?: " .. (oMember[KARMA_DB_L5_RRFFM.GENDER] or "?") .. " vs. " .. (iGender or "?") .. " - gender changed: " .. (oMember[KARMA_DB_L5_RRFFM.GENDER] or "?") .. " - " .. iGenderOther .. "]";
				end
			elseif (sRaceOldEN ~= "") then
				sRaceOldEN = strupper(sRaceOldEN);
			end
		end

		if (sRaceNewEN and (sRaceNewEN ~= "") and
		    sRaceOldEN and (sRaceOldEN ~= "") and
			(sRaceNewEN ~= sRaceOldEN)) then
			retval = 1;
			retstr = retstr .. " !Race: " .. sRace .. " (new: " .. sRaceNewEN .. ") != " .. oMember[KARMA_DB_L5_RRFFM.RACE] .. " (old: " .. sRaceOldEN .. ")";
		end
	end

	return retval, retstr;
end

function	Karma_MemberList_CollisionCheck(oMember, sCombined, sUnit, iLevel, iClassID, sRace)
	if (oMember == nil) then
		oMember = Karma_MemberList_GetObject(sCombined);
		if (oMember == nil) then
			return 0, "not on list";
		end
	end

	local	retval, retstr;

	if (type(oMember[KARMA_DB_L5_RRFFM_CONFLICT]) == "table") then
		retstr = oMember[KARMA_DB_L5_RRFFM_CONFLICT].Conflict;
		if (oMember[KARMA_DB_L5_RRFFM_CONFLICT].Resolved == 0) then
			return 1, retstr;
		end
	end

	retval, retstr = Karma_MemberList_CollisionCheckActually(oMember, sCombined, sUnit, iLevel, iClassID, sRace);
	if (retval == 1) then
		if (type(oMember[KARMA_DB_L5_RRFFM_CONFLICT]) ~= "table") then
			oMember[KARMA_DB_L5_RRFFM_CONFLICT] = {};
		end

		if (oMember[KARMA_DB_L5_RRFFM_CONFLICT].At == nil) then
			oMember[KARMA_DB_L5_RRFFM_CONFLICT].At = time();
		end
		oMember[KARMA_DB_L5_RRFFM_CONFLICT].Conflict = retstr;
		oMember[KARMA_DB_L5_RRFFM_CONFLICT].Resolved = 0;
	end

	return retval, retstr;
end

--
-- Update parts of the member record which might have changed.
-- Also set the parts which might not yet have been set.
--
function	Karma_MemberList_Update(sMemberName, level, class, race, guild)
	if (sMemberName == "" or sMemberName == nil) then
		return;
	end

	local	oMember = Karma_MemberList_GetObject(sMemberName);
	if (oMember == nil) then
		return;
	end

	-- delete: unused.
	oMember[KARMA_DB_L5_RRFFM_KARMA_MODSOC] = nil;
	oMember[KARMA_DB_L5_RRFFM_KARMA_MODSKILL] = nil;
	-- this shall be per char
	oMember[KARMA_DB_L6_RRFFMCC_REGIONLIST] = nil;

	local	iClassID = KOH.ClassToID(class);
	local	iCC, sReason = Karma_MemberList_CollisionCheck(oMember, sMemberName, nil, level, iClassID, race);
	if (iCC == 1) then
		if (sMemberName ~= KARMA_UNKNOWN) then
			local	sMemberName_Clickable = KOH.Name2Clickable(sMemberName);
			KarmaChatSecondary("Karma |cFFFF8080*can't*|r update >" .. sMemberName_Clickable .. "< : " .. sReason .. ". Use '" .. KARMA_CMDSELF .. " forcenew <player>' to backup the current entry and add a new one, or '" .. KARMA_CMDSELF .. " forceupdate <player>' to remove any conflicting data on the existing entry.", true);
		end

		return
	end

	-- don't lose /who data unnecessarily...
	if (level ~= nil) then
		oMember[KARMA_DB_L5_RRFFM.LEVEL] = level;

		local	timestamp = time();
		if (oMember[KARMA_DB_L5_RRFFM_TIMESTAMP] == nil) then
			oMember[KARMA_DB_L5_RRFFM_TIMESTAMP] = {};
			oMember[KARMA_DB_L5_RRFFM_TIMESTAMP][KARMA_DB_L5_RRFFM_TIMESTAMP_TRY] = timestamp;
		end
		oMember[KARMA_DB_L5_RRFFM_TIMESTAMP][KARMA_DB_L5_RRFFM_TIMESTAMP_SUCCESS] = timestamp;
	end
	if (class ~= nil) then
		oMember[KARMA_DB_L5_RRFFM.CLASS] = class;
		local ClassID = KOH.ClassToID(class);
		if (ClassID ~= 0) then
			oMember[KARMA_DB_L5_RRFFM.CLASS_ID] = ClassID;
		end
	end
	if (race ~= nil) then
		oMember[KARMA_DB_L5_RRFFM.RACE] = race;
	end
	if (guild ~= nil) then
		oMember[KARMA_DB_L5_RRFFM.GUILD] = guild;
	end

	if (oMember[KARMA_DB_L5_RRFFM_TIMESTAMP] == nil) then
		oMember[KARMA_DB_L5_RRFFM_TIMESTAMP] = {};
	end

	local timestamp = time();
	if ((level ~= nil) and (class ~= nil) and (race ~= nil)) then
		oMember[KARMA_DB_L5_RRFFM_TIMESTAMP][KARMA_DB_L5_RRFFM_TIMESTAMP_TRY] = timestamp;
		oMember[KARMA_DB_L5_RRFFM_TIMESTAMP][KARMA_DB_L5_RRFFM_TIMESTAMP_SUCCESS] = timestamp;
	end

	Karma_WhoAmIInit();
	if (WhoAmI ~= nil) then
		if (KCfg.Get("DB_SPARSE") ~= 1) then	-- dbsparse
			KarmaObj.DB.MC.InitMinimumPlayer(oMember);
		end

		local	oMemberChar = KarmaObj.DB.MC.Get(oMember, WhoAmI); 
		if (type(oMemberChar) == "table") then
			oMemberChar[KARMA_DB_L6_RRFFMCC_PLAYEDLAST] = 0;
			oMemberChar[KARMA_DB_L6_RRFFMCC_XPLAST] = UnitXP("player");
			oMemberChar[KARMA_DB_L6_RRFFMCC_XPMAX] = UnitXPMax("player");
		end
	end

	local	unitname = Karma_MemberList_MemberNameToUnitName(sMemberName);
	if (unitname == nil) then
		-- If the unit isn't in the party, no Unit* - functions...
		return
	end

	oMember[KARMA_DB_L5_RRFFM.GUID] = UnitGUID(unitname);

	oMember[KARMA_DB_L5_RRFFM.LEVEL] = UnitLevel(unitname);
	local	sClassLocalized, sClassEN = UnitClass(unitname);
	oMember[KARMA_DB_L5_RRFFM.CLASS] = sClassLocalized;
	oMember[KARMA_DB_L5_RRFFM.CLASS_EN] = sClassEN;
	local ClassID = KOH.ClassToID(oMember[KARMA_DB_L5_RRFFM.CLASS]);
	if (ClassID ~= 0) then
		oMember[KARMA_DB_L5_RRFFM.CLASS_ID] = ClassID;
	end
	oMember[KARMA_DB_L5_RRFFM.GENDER] = UnitSex(unitname);
	local	sRaceLocalized, sRaceEN = UnitRace(unitname);
	oMember[KARMA_DB_L5_RRFFM.RACE] = sRaceLocalized;
	oMember[KARMA_DB_L5_RRFFM.RACE_EN] = sRaceEN;

	-- guild is not properly given for distant units, only allow if close
	if (CheckInteractDistance(unitname, 1) == 1) then
		oMember[KARMA_DB_L5_RRFFM.GUILD] = GetGuildInfo(unitname);
	end
	if (oMember[KARMA_DB_L5_RRFFM.GUILD] == nil) then
		oMember[KARMA_DB_L5_RRFFM.GUILD] = "";
	end

	oMember[KARMA_DB_L5_RRFFM_TIMESTAMP][KARMA_DB_L5_RRFFM_TIMESTAMP_TRY] = timestamp;
	oMember[KARMA_DB_L5_RRFFM_TIMESTAMP][KARMA_DB_L5_RRFFM_TIMESTAMP_SUCCESS] = timestamp;
end

-----------------------------------------
-- MEMBEROBJECT FUNCTIONS
-----------------------------------------
function	Karma_MemberObject_GetName(oMember)
	if (type(oMember) == "table") then
		return oMember[KARMA_DB_L5_RRFFM.NAME];
	else
		return nil;
	end
end

function	Karma_MemberObject_GetXP(oMember)
	if (type(oMember) == "table") then
		local	charobj = Karma_MemberObject_GetCharacterObject(oMember);
		if (charobj == nil) then
			return 0;
		end
		return charobj[KARMA_DB_L6_RRFFMCC_XP];
	else
		return nil;
	end
end

function	Karma_MemberObject_GetTotalXPSummedUp(oMember)
	if	(type(oMember) ~= "table") or
		(type(oMember[KARMA_DB_L5_RRFFM_CHARACTERS]) ~= "table") then
		return 0;
	end

	local	iSum, key, value = 0;
	for key, value in pairs(oMember[KARMA_DB_L5_RRFFM_CHARACTERS]) do
		iSum = iSum + (value[KARMA_DB_L6_RRFFMCC_XP] or 0);
	end

	return iSum;
end

function	Karma_MemberObject_GetXPLVL(oMember)
	if (type(oMember) == "table") then
		local	charobj = Karma_MemberObject_GetCharacterObject(oMember);
		if (charobj == nil) then
			return 0;
		end

		return charobj[KARMA_DB_L6_RRFFMCC_XPLVL];
	else
		return nil;
	end
end

function	Karma_MemberObject_GetTotalXPLVLSummedUp(oMember)
	if	(type(oMember) ~= "table") or
		(type(oMember[KARMA_DB_L5_RRFFM_CHARACTERS]) ~= "table") then
		return 0;
	end

	local	iSum, key, value = 0;
	for key, value in pairs(oMember[KARMA_DB_L5_RRFFM_CHARACTERS]) do
		iSum = iSum + (value[KARMA_DB_L6_RRFFMCC_XPLVL] or 0);
	end

	return iSum;
end

function	Karma_MemberObject_GetTimePlayed(oMember)
	if (type(oMember) == "table") then
		local	charobj = Karma_MemberObject_GetCharacterObject(oMember);
		if (charobj == nil) then
			return nil;
		end

		return charobj[KARMA_DB_L6_RRFFMCC_PLAYED];
	else
		return nil;
	end
end

function	Karma_MemberObject_GetTotalTimePlayedSummedUp(oMember)
	if	(type(oMember) ~= "table") or
		(type(oMember[KARMA_DB_L5_RRFFM_CHARACTERS]) ~= "table") then
		return 0;
	end

	local	iSum, key, value = 0;
	for key, value in pairs(oMember[KARMA_DB_L5_RRFFM_CHARACTERS]) do
		if (value[KARMA_DB_L6_RRFFMCC_PLAYED]) then
			iSum = iSum + value[KARMA_DB_L6_RRFFMCC_PLAYED];
		end
	end

	return iSum;
end

function	Karma_MemberObject_GetTimeJoinedTimeTotal(oMember)
	if (type(oMember) == "table") then
		return oMember[KARMA_DB_L5_RRFFM_JOINEDLAST_TIME];
	else
		return 0;
	end
end

function	Karma_MemberObject_GetTimeJoinedCharTotal(oMember)
	if (type(oMember) == "table") then
		return oMember[KARMA_DB_L5_RRFFM_JOINEDLAST_CHAR];
	else
		return nil;
	end
end

function	Karma_MemberObject_GetTimeJoinedChar(oMember, sChar)
	if (type(oMember) == "table") then
		local	charobj = KarmaObj.DB.MC.Get(oMember, sChar);
		if (charobj == nil) then
			return 0;
		end

		return charobj[KARMA_DB_L6_RRFFMCC_JOINEDLAST];
	else
		return 0;
	end
end

function	Karma_MemberObject_GetKarmaModifier(oMember)
	if (type(oMember) == "table") then
		local	value = KarmaObj.DB.M.KarmaGet(oMember);
		local	bModified = false;

		local	val_imp = oMember[KARMA_DB_L5_RRFFM_KARMA_IMPORTED];
		if (val_imp) and (val_imp ~= 0) then
			bModified = true;
			value = value + val_imp;
		end

		local	minval = KCfg.Get("TIME_KARMA_MINVAL");
		if (minval == nil) then
			minval = 50;
		end
		local	timemember = oMember[KARMA_DB_L5_RRFFM_KARMA_TIME];
		if (timemember == 0) or (value < minval) then
			return value, 0, nil;
		end

		if (timemember ~= 1) then
			local	timeglobal = KCfg.Get("TIME_KARMA_DEFAULT");
			if (timeglobal == 1) then
				timemember = timeglobal;
			end
		end

		local	timesum = 0;
		if (timemember == 1) then
			local	factor = KCfg.Get("TIME_KARMA_FACTOR");
			if (factor == nil) then
				factor = 0.4;
			end

			local	iSkipBGPlayed = KCfg.Get("TIME_KARMA_SKIPBGTIME");
			if (iSkipBGPlayed == nil) then
				iSkipBGPlayed = 1;
			end

			local	char, charobj;
			for char, charobj in pairs(oMember[KARMA_DB_L5_RRFFM_CHARACTERS]) do
				if (charobj[KARMA_DB_L6_RRFFMCC_PLAYED]) then
					timesum = timesum + charobj[KARMA_DB_L6_RRFFMCC_PLAYED];
					if ((iSkipBGPlayed == 1) and (charobj[KARMA_DB_L6_RRFFMCC_PLAYEDPVP] ~= nil)) then
						timesum = timesum - charobj[KARMA_DB_L6_RRFFMCC_PLAYEDPVP];
					end
				end
			end
			timesum = (timesum / 3600) * factor;
			bModified = bModified or (timesum >= 0.5);
		end

		return value, math.floor(timesum + 0.5), bModified;
	else
		return nil, nil;
	end
end

function	Karma_MemberObject_GetKarmaModified(oMember)
	if (type(oMember) == "table") then
		local	value, iMod, bMod = Karma_MemberObject_GetKarmaModifier(oMember);
		if (iMod ~= nil) then
			return value + iMod, bMod;
		end
	end

	return nil, nil;
end

function	Karma_MemberObject_GetKarmaModifiedForListWithColors(oMember)
	local	iKarma, bModified = Karma_MemberObject_GetKarmaModified(oMember);
	if (iKarma) then
		local	sKarma = iKarma;
		if (iKarma > 100) then
			sKarma = "++";
		end
		if (bModified) then
			sKarma = "*" .. sKarma;
		end

		iKarma = math.min(iKarma, 100);
		local	iRed, iGreen, iBlue = Karma_Karma2Color(iKarma);
		sKarma = "|c" .. ColourToString(1, iRed, iGreen, iBlue) .. sKarma .. "|r";

		return sKarma, iKarma;
	end

	return "", 50;
end

function	Karma_MemberObject_GetKarmaWithModifiers(oMember)
	if (type(oMember) == "table") then
		local	valueplusimp, iMod, bMod = Karma_MemberObject_GetKarmaModifier(oMember);
		if (iMod == nil) then
			return valueplusimp;
		end

		local	value = KarmaObj.DB.M.KarmaGet(oMember);
		local	val_imp = oMember[KARMA_DB_L5_RRFFM_KARMA_IMPORTED];
		if (val_imp == nil) then
			val_imp = 0;
		end

		local	bModified = false;

		local	valstr = value .. " rK";
		if (val_imp ~= 0) then
			bModified = true;
			valstr = valstr .. ", " .. val_imp .. " iK";
		end

		if (iMod > 0) then
			bModified = true;
			valstr = valstr .. ", " .. iMod .. " tK";
		end

		if (bModified) then
			return valstr;
		else
			return value;
		end
	else
		return nil;
	end
end

function	Karma_MemberObject_GetLevel(oMember)
	if (type(oMember) == "table") then
		return oMember[KARMA_DB_L5_RRFFM.LEVEL];
	else
		return nil;
	end
end

function	Karma_MemberObject_GetRace(oMember)
	if (type(oMember) == "table") then
		return oMember[KARMA_DB_L5_RRFFM.RACE];
	else
		return nil;
	end
end

function	Karma_MemberObject_GetClass(oMember)
	if (type(oMember) == "table") then
		local	iID = oMember[KARMA_DB_L5_RRFFM.CLASS_ID];
		if ((type(iID) ~= "number") or (iID == 0)) then
			iID = KOH.ClassToID(oMember[KARMA_DB_L5_RRFFM.CLASS]);
			if (iID and (iID ~= 0)) then
				oMember[KARMA_DB_L5_RRFFM.CLASS_ID] = iID;
			end
		end

		if (iID and (iID ~= 0)) then
			local Tmp = KOH.IDToClass(iID);
			if (Tmp ~= "") then
				return Tmp, iID;
			end
		end

		return oMember[KARMA_DB_L5_RRFFM.CLASS];
	else
		return nil;
	end
end

function	Karma_MemberObject_GetClassWOGender(oMember)
	local ClassName = Karma_MemberObject_GetClass(oMember);
	local ClassID = KOH.ClassToID(ClassName);
	if  (ClassID < 0) then
		ClassID = - ClassID;
	end;

	return KOH.IDToClass(ClassID);
end

function	Karma_MemberObject_GetTalentIDRaw(oMember, iSpec)
	if (type(oMember) == "table") then
		if (iSpec == nil) then
			iSpec = 1;
		end

		local	sSpecKey = KARMA_DB_L5_RRFFM_TALENT .. "_" .. iSpec;
		if (oMember[sSpecKey] == 0) then
			oMember[sSpecKey] = nil;
		end

		local	Result = oMember[sSpecKey];
		if (Result == nil) then
			if (iSpec == 1) then
				if (oMember[KARMA_DB_L5_RRFFM_TALENT] == 0) then
					oMember[KARMA_DB_L5_RRFFM_TALENT] = nil;
				end
				Result = oMember[KARMA_DB_L5_RRFFM_TALENT];
				if (Result) then
					oMember[sSpecKey] = oMember[KARMA_DB_L5_RRFFM_TALENT];
				end
			end
			if (Result == nil) then
				Result = 0;
			end
		end

		return Result;
	else
		return nil;
	end
end

function	Karma_MemberObject_GetTalentID(oMember, iSpec)
	if (type(oMember) == "table") then
		local	talentid = Karma_MemberObject_GetTalentIDRaw(oMember, iSpec);
		if (talentid == 0) then
--			KarmaChatDebug("KMO_GetTalentID: no talent set, retrieving from class" .. KARMA_WINEL_FRAG_TRIDOTS);
			local	classid = oMember[KARMA_DB_L5_RRFFM.CLASS_ID];
			if (classid == 0) then
				classid = KOH.ClassToID(Karma_MemberObject_GetClass(oMember));
			end

			local	talentid, pattern = KarmaObj.Talents.ClassIDToTalentsDefault(classid); 
			return talentid, pattern;
		end

		return talentid, false;
	else
		return nil, false;
	end
end

function	Karma_MemberObject_GetTalentColorizedText(oMember, iSpec)
	local	iTalentID, bPattern, iDerived = Karma_MemberObject_GetTalentID(oMember, iSpec);
	if (bPattern) then
		iDerived = KarmaObj.Talents.MemberObjSpecNumToTalent(oMember, iSpec);
		if (iDerived) then
--			KarmaChatDebug("KMO_GetTalentColorizedText: no talent set, derived from class: " .. tostring(iDerived));
			iTalentID = iDerived;
		else
--			KarmaChatDebug("KMO_GetTalentColorizedText: no talent set, can't derive from class.");
		end
	end
	local	sResult = KarmaObj.Talents.TalentIDToColorizedText(iTalentID);
	if (iDerived) then
		sResult = "[" .. sResult .. "]";
	end
	return sResult, iTalentID;
end

function	Karma_MemberObject_GetGuild(oMember)
	if (type(oMember) == "table") then
		return oMember[KARMA_DB_L5_RRFFM.GUILD];
	else
		return nil;
	end
end

function	Karma_MemberObject_GetNotes(oMember)
	if (type(oMember) == "table") then
		return oMember[KARMA_DB_L5_RRFFM_NOTES];
	else
		return nil;
	end
end

function	Karma_MemberObject_GetPrivateNotesCut(oMember, iLinesMax, iCharsMax)
	if (type(oMember) == "table") then
		local	sNotes = oMember[KARMA_DB_L5_RRFFM_NOTES];
		if (sNotes) then
			return KOH.ExtractHeader(sNotes, iLinesMax, iCharsMax);
		end
	end
end

function	Karma_MemberObject_GetPublicNotes(oMember)
	if (type(oMember) == "table") then
		return oMember[KARMA_DB_L5_RRFFM_PUBLIC_NOTES];
	else
		return nil;
	end
end

function	Karma_MemberObject_GetAltID(oMember)
	if (type(oMember) == "table") then
		if (oMember[KARMA_DB_L5_RRFFM.ALTGROUP] == -1) then
			oMember[KARMA_DB_L5_RRFFM.ALTGROUP] = nil;
		end

		return oMember[KARMA_DB_L5_RRFFM.ALTGROUP] or -1;
	else
		return -1;
	end
end

function	Karma_MemberObject_GetSkill(oMember)
	if (type(oMember) == "table") then
		if (oMember[KARMA_DB_L5_RRFFM_SKILL] == -1) then
			oMember[KARMA_DB_L5_RRFFM_SKILL] = nil;
		end
		return oMember[KARMA_DB_L5_RRFFM_SKILL] or -1;
	else
		return nil;
	end
end

function	Karma_MemberObject_GetSkillText(oMember)
	local	iSkill = Karma_MemberObject_GetSkill(oMember);
	if (iSkill and (iSkill >= 0) and (KARMA_SKILL_LEVELS[iSkill] ~= nil)) then
		local	sModel = KCfg.Get("SKILL_MODEL");
		if (sModel == "complex") then
			return (tostring(iSkill) .. KARMA_WINEL_FRAG_COLONSPACE .. KARMA_SKILL_LEVELS[iSkill]);
		else
			return KARMA_SKILL_LEVELS[iSkill];
		end
	end

	return nil;
end

function	Karma_MemberObject_GetGearPVP(oMember)
	if (type(oMember) == "table") then
		if (oMember[KARMA_DB_L5_RRFFM_GEAR_PVP] == -1) then
			oMember[KARMA_DB_L5_RRFFM_GEAR_PVP] = nil;
		end
		return oMember[KARMA_DB_L5_RRFFM_GEAR_PVP] or -1;
	else
		return nil;
	end
end

function	Karma_MemberObject_GetGearPVE(oMember)
	if (type(oMember) == "table") then
		if (oMember[KARMA_DB_L5_RRFFM_GEAR_PVE] == -1) then
			oMember[KARMA_DB_L5_RRFFM_GEAR_PVE] = nil;
		end
		return oMember[KARMA_DB_L5_RRFFM_GEAR_PVE] or -1;
	else
		return nil;
	end
end

function	Karma_MemberObject_GetGender(oMember)
	if (type(oMember) == "table") then
		local genderTable = { [ 1 ] = nil, [ 2 ] = "(m)", [ 3 ] = "(f)", [ "" ] = nil };
		return genderTable[oMember[KARMA_DB_L5_RRFFM.GENDER]]
	else
		return nil;
	end
end

function	Karma_MemberObject_GetGUID(oMember)
	if (type(oMember) == "table") then
		return oMember[KARMA_DB_L5_RRFFM.GUID];
	else
		return nil;
	end
end

function	Karma_MemberObject_GetTimestampTry(oMember)
	if (type(oMember) == "table") then
		if (oMember[KARMA_DB_L5_RRFFM_TIMESTAMP] ~= nil) then
			return oMember[KARMA_DB_L5_RRFFM_TIMESTAMP][KARMA_DB_L5_RRFFM_TIMESTAMP_TRY];
		end
	end

	return 0;
end

function	Karma_MemberObject_GetTimestampSuccess(oMember)
	if (type(oMember) == "table") then
		if (oMember[KARMA_DB_L5_RRFFM_TIMESTAMP] ~= nil) then
			return oMember[KARMA_DB_L5_RRFFM_TIMESTAMP][KARMA_DB_L5_RRFFM_TIMESTAMP_SUCCESS];
		end
	end

	return 0;
end

function	Karma_MemberObject_GetQuestList(oMember)
	if (type(oMember) == "table") then
		charobj = Karma_MemberObject_GetCharacterObject(oMember);
		if (charobj) then
			return charobj[KARMA_DB_L6_RRFFMCC_QUESTIDLIST];
		else
			return nil;
		end
	else
		return nil;
	end
end

function	Karma_MemberObject_GetQuestExList(oMember)
	if (type(oMember) == "table") then
		charobj = Karma_MemberObject_GetCharacterObject(oMember);
		if (charobj) then
			return charobj[KARMA_DB_L6_RRFFMCC_QUESTEXLIST];
		else
			return nil;
		end
	else
		return nil;
	end
end

function	Karma_MemberObject_GetZoneList(oMember)
	if (type(oMember) == "table") then
		charobj = Karma_MemberObject_GetCharacterObject(oMember);
		if (charobj) then
			return charobj[KARMA_DB_L6_RRFFMCC_ZONEIDLIST];
		else
			return nil;
		end
	else
		return nil;
	end
end

function	Karma_MemberObject_GetTotalQuestListCount(oMember)
	if (type(oMember) == "table") then
		local TotalQuestListCount = 0;
		for char, charobj in pairs(oMember[KARMA_DB_L5_RRFFM_CHARACTERS]) do
			if (charobj[KARMA_DB_L6_RRFFMCC_QUESTIDLIST]) then
				for index, QID in pairs(charobj[KARMA_DB_L6_RRFFMCC_QUESTIDLIST]) do
					TotalQuestListCount = TotalQuestListCount + 1;
				end
			end
		end

		return TotalQuestListCount;
	else
		return 0;
	end
end

local function IsPvpZone(ZID)
	local ZKey = - ZID;
	local ZL = CommonZoneListGet();
	if (type(ZL) == "table") then
		if (ZL[ZKey] ~= nil) then
			local RKey = ZL[ZKey].RegionID;
			if (RKey ~= nil) then
				local RL = CommonRegionListGet();
				if (type(RL) == "table") then
					if (RL[RKey] ~= nil) then
						return RL[RKey][KARMA_DB_L3_CR.ISPVPZONE] == 1;
					else
						KarmaChatDebug(KARMA_TITLE.."-DBG: RL[" .. RKey .. "] == nil!");
					end
				end
			end
		else
			KarmaChatDebug(KARMA_TITLE.."-DBG: ZL[" .. ZID .. "] == nil!");
		end
	end

	return false;
end

-- >> toying around part 1
function	TextEncode(text)
	local	char, toggle, rnd;

	local	out = "";

	local	i;
	local	textlen = strlen(text);
	if (textlen ~= nil) then
		KarmaChatDebug("encode: " .. textlen .. " characters");
	else
		KarmaChatDebug("encode not possible: type = " .. type(text));
		return "";
	end

	local	firstspacepos = strfind(text, " ", 1, true);
	if (firstspacepos == nil) or (firstspacepos < 3) then
		KarmaChatDebug("encode not possible: not enough text");
		return "";
	end

	-- early fixed modification for quick identification:
	-- strupper last char in first word and double first space
	for i = 1, firstspacepos - 1 do
		char = strsub(text, i, i);
		out = out .. char;
	end
	i = firstspacepos + 1;
	char = strsub(text, i, i);
	out = out .. " ^ " .. char .. char;
	
	-- must not change seed...
	math.randomseed(20070519);

	-- modify message 'slightly'
	for i = firstspacepos + 2, textlen do
		char = strsub(text, i, i);
		if (strupper(char) == "") or (strlower(char) == "") then
			-- inconvertible: don't touch
			out = out .. char;
		else
			rnd = math.random(41);
			if (char == " ") then
				out = out .. char;
				if (rnd < 7) then
					out = out .. char;
				end
			else
				toggle = strlower(char);
				if (toggle == char) then
					toggle = strupper(char);
				end
				if (rnd > 36) then
					out = out .. toggle;
				elseif (rnd < 4) then
					out = out .. char .. strlower(char);
				else
					out = out .. char;
				end
			end
		end
	end

	out = out .. ".,.``";

	KarmaChatDebug("encode: done");

	return	out;
end
-- << toying around part 1

-- >> toying around part 2
function	TextDecode(text)
end
-- << toying around part 2

-- Karma_TEST: development helper ;) (start)
function	Karma_TEST(cmd, arg, arg2)
	KarmaObj.UI.MsgAddOnForceHandling = 2;

	if (cmd == -10) then
		KarmaData.MapTestNameToID = {};
		KarmaData.MapTestIDToName = {};

		local	iMax, i = 1000;
		for i = 1, iMax do
			SetMapZoom(-1);
			SetMapByID(i);
			local	sName = GetZoneText();
			if (KarmaData.MapTestNameToID[sName] == nil) then
				KarmaData.MapTestIDToName[i] = sName;
				KarmaData.MapTestNameToID[sName] = i;
			end
		end
	end

	if (cmd == -9) then
		local ZKey = - arg;
		local ZL = CommonZoneListGet();
		if (type(ZL) == "table") then
			if (ZL[ZKey] ~= nil) then
				KarmaChatDebug("Zone: " .. KarmaObj.Helpers.TableToString(ZL[ZKey]));

				local RKey = ZL[ZKey].RegionID;
				if (RKey ~= nil) then
					local RL = CommonRegionListGet();
					if (type(RL) == "table") then
						if (RL[RKey] ~= nil) then
							KarmaChatDebug("Region: " .. KarmaObj.Helpers.TableToString(RL[RKey]));
						end
					end
				end
			end
		end

		return
	end

	if (cmd == -8) then
		local	sIn = string.format(ERR_INVITED_TO_GROUP_SS, "Test", "Test");
		KarmaChatDebug("In: " .. string.gsub(sIn, "\124", "\124\124"));
		local	sPattern = string.gsub(ERR_INVITED_TO_GROUP_SS, "|Hplayer:%%s|h%[%%s%]|h", "|Hplayer:[^|]+|h%%[(.+)%%]|h");
		KarmaChatDebug("Pattern: " .. string.gsub(sPattern, "\124", "\124\124"));
		local	sName = string.match(sIn, sPattern);
		KarmaChatDebug("Match: " .. (sName or "<nil>"));
		if (sName) then
			DEFAULT_CHAT_FRAME:AddMessage("Karma: |cFF8080FFInvite to group by " .. sName .. ".|r");
		end

		return
	end

	if (cmd == -7) then
		if (KarmaModuleLocal.AchievementCheckTerrorCount == 0) then
			KarmaModuleLocal.AchievementCheckTerrorTimer = GetTime() + 50;
			KarmaModuleLocal.AchievementCheckTerrorCount = 1;
			KarmaModuleLocal.AchievementCheckTerrorList["target"] = UnitName("target");
		end

		return
	end

	if (cmd == -6) then
		KarmaModuleLocal.PlayerRegenEnabledOrMobDied = GetTime();
		return
	end

	if (cmd == -5) then
		local	oMember = Karma_MemberList_GetObject(arg);
		if (oMember) then
			Karma_CleanupRegions(oMember)
		else
			KarmaChatDebug("Unknown player.");
		end
		return
	end

	if (cmd == -4) then
		local	sName, aData, sFrom, aInfo, sInfos;
		for sName, aData in pairs(KarmaModuleLocal.NotesPublic.Results) do
			sInfos = sName .. ": ";
			for sFrom, aInfo in pairs(aData) do
				sInfos = sInfos .. sFrom .. "(";
				if (aInfo.sKarma) then
					sInfos = sInfos .. "K";
				end
				if (aInfo.sNotePub) then
					sInfos = sInfos .. "N" .. strlen(aInfo.sNotePub);
				end
				sInfos = sInfos .. ") ";
			end
			KarmaChatDebug(sName .. ": " .. sInfos);
		end
		return
	end

	if (cmd == -3) then
		KarmaObj.UI.MsgAddOnForceHandling = nil;
		local	_, iMax = GetNumWhoResults();
		local	i;
		for i = 1, iMax do
			SendAddonMessage("KARMA", "?v1", "WHISPER", GetWhoInfo(i));
		end
		KarmaChatDebug("Sent " .. iMax .. " version requests. Chaman, Chassuer, Chevalier, Demo, Druide, Guerrier, Mage, Pala, Pretre, Voleur!");
		return
	end

	if (cmd == -2) then
		if (arg == "GUILD") or (arg == "PARTY") or (arg == "RAID") then
			SendAddonMessage("KARMA", "?v1", arg);
		else
			SendAddonMessage("KARMA", "?v1", "WHISPER", arg);
		end

		return;
	end

	if (cmd == -1) then
		if (KARMA_TalentInspect.RequiredCount == 0) then
			local	sUnit = "target";
			if (CheckInteractDistance(sUnit, 1) == 1) then
				local	sName, sServer = UnitName("target");
				if (sServer) and (sServer ~= "") then
					sName = sName .. "@" .. sServer
				end
				KARMA_TalentInspect.RequiredList[sUnit] = sName;
				KARMA_TalentInspect.RequiredCount = 1;
			end
		end

		return
	end

	if (cmd == 0) then
		-- scriptErrors -> 1
		SetCVar("scriptErrors", true);
		-- scriptKarmaObj.Profile -> 1? true?
		SetCVar("scriptKarmaObj.Profile", true);

		UpdateAddOnCPUUsage();

		local	i = 1;
		if (arg) then
			i = arg;
		end
		local	name, time;
		local	done = false;
		while not done do
			name = GetAddOnInfo(i);
			if name ~= nil then
				time = GetAddOnCPUUsage(i);
				KarmaChatSecondary(name .. KARMA_WINEL_FRAG_COLONSPACE .. time);
			else
				done = true;
			end
			i = i + 1;
		end
	end

	if (cmd == 1) then
		if (arg == nil) then
			arg = "player";
		end

		if not UnitExists(arg) then
			arg = "player";
		end
		
		KarmaChatSecondary("Karma_TEST: arg = " .. Karma_NilToString(arg));

		local x, y = GetPlayerMapPosition(arg);
		KarmaChatSecondary("x/y = " .. x .. "/" .. y);

		Karma_ScanningTooltip:ClearLines()
		Karma_ScanningTooltip:SetUnit(arg);

		local	i;
		for i = 1, Karma_ScanningTooltip:NumLines() do
			local mytext = getglobal("Karma_ScanningTooltipTextLeft" .. i)
			local text = mytext:GetText()
			KarmaChatSecondary("[" .. i .. "]: " .. text);
		end
		return
	end

	if (cmd == 2) then
		local	trigraphs = {};
		local	tri = "";
		local	trimaxnum = 0;
		local	Memberlist = Karma_MemberList_GetMemberNamesSortedAlpha();
		local	i, Name;
		for i, Name in pairs(Memberlist) do
			local j, len;
			len = strlen(Name);
			for j = 1, len - 2 do
				tri = strsub(Name, j, j + 2);
				if (trigraphs[tri] == nil) then
					trigraphs[tri] = 0;
				end

				trigraphs[tri] = trigraphs[tri] + 1;
				trimaxnum = math.max(trimaxnum, trigraphs[tri]);
			end
		end

		local	trishort = {};
		local	trimax = "";
		local	trimaxnumtotal = 0;
		for tri, i in pairs(trigraphs) do
			if (i == trimaxnum) then
				trimaxnumtotal = trimaxnumtotal + trimaxnum;
				trimax = trimax .. ", [" .. tri .. "]";
			end

			if (trishort[i] == nil) then
				trishort[i] = 0;
			end
			trishort[i] = trishort[i] + 1;
		end

		for tri, i in pairs(trishort) do
			KarmaChatDebug("#" .. tri .. "-tris : " .. i);
		end

		KarmaChatDebug("best: " .. strsub(trimax, 3) .. " : " ..  trimaxnum);

		if (arg ~= nil) then
			local args = {};
			args[1] = "checkonline";
			if (arg == nil) then
				args[2] = trimax;
			else
				args[2] = arg;
			end
			args[3] = KARMA_Filter.Class;

			Karma_Command_CheckOnline_Insert(args);
		end
		return
	end

	if (cmd == 3) then
		local	digraphs = {};
		local	di = "";
		local	dimaxnum = 0;
		local	Memberlist = Karma_MemberList_GetMemberNamesSortedAlpha();
		local	i, Name;
		for i, Name in pairs(Memberlist) do
			local	NameLower = strlower(Name);
			local len, j = KarmaObj.UTF8.LenInChars(NameLower);
			for j = 1, len - 1 do
				di = KarmaObj.UTF8.SubInChars(NameLower, j, j + 1);

				if (digraphs[di] == nil) then
					digraphs[di] = 0;
				end

				digraphs[di] = digraphs[di] + 1;
				dimaxnum = math.max(dimaxnum, digraphs[di]);
			end
		end

		local	dishort = {};
		local	dimax = "";
		local	dimaxnumtotal = 0;
		for di, i in pairs(digraphs) do
			if (i == dimaxnum) then
				dimaxnumtotal = dimaxnumtotal + dimaxnum;
				dimax = dimax .. ", [" .. di .. "]";
			end

			if (dishort[i] == nil) then
				dishort[i] = {};
			end
			tinsert(dishort[i], di);
		end

		local	iRank = 1;
		for i = dimaxnum, 1, -1 do
			local	odi = dishort[i];
			if (odi) then
				if (#odi < 150) then
					KarmaChatDebug("#" .. iRank .. ": [" .. i .. " hits for each of " .. #odi .. " digraphs] [" .. table.concat(odi, ", ") .. "]");
				else
					KarmaChatDebug("#" .. iRank .. ": [" .. i .. " hits for each of " .. #odi .. " digraphs] [<< skipped listing >>]");
				end
				iRank = iRank + 1;
			end
		end
		return
	end

	if (cmd == 4) and (arg ~= nil) then
		local	about = arg2;
		if (about == nil) then
			about = UnitName("player");
		end
		if (about) then
			local	arg_u = strupper(arg);
			local	args = {};
			args[2] = arg;
			args[3] = about;
			if (arg_u == "GUILD") or (arg_u == "PARTY") or (arg_u == "RAID") then
				KarmaChatDebug("Karma_TEST(4): to <" .. arg .. "> about [" .. about .. "]");
				args[2] = "$" .. arg_u;
			else
				KarmaChatDebug("Karma_TEST(4): to <WHISPER:" .. arg .. "> about [" .. about .. "]");
			end
			-- "?p" - request
			KSlash.ShareQuery(args, 3);
		end
		return
	end

	if (cmd == 5) and (arg ~= nil) then
		local	out = TextEncode(arg);
		KarmaChatDebug("encode: " .. arg .. " -> " .. out);
		return
	end

	if (cmd == 6) and (arg ~= nil) then
		local	out = TextDecode(arg);
		KarmaChatDebug("decode: " .. arg .. " -> " .. out);
		return
	end

--[[
	if (cmd == 42) then
		local i, FCount, name, level, class, area, connected, status;
		local found = 0;
		FCount = GetNumFriends();
		for i = 1, FCount do
			name, level, class, area, connected, status = GetFriendInfo(i);
			if (name == arg) then
				KarmaChatDefault("Karma_TEST: " .. name .. " found, online = " .. Karma_NilToString(connected));
				found = 1;
				break;
			end;
		end;
	
		if (found == 0) then
			local DefaultMessages = { GetChatWindowMessages(DEFAULT_CHAT_FRAME:GetID()) };
			local MLML = "";
			for i, name in pairs(DefaultMessages) do
				MLML = MLML .. name .. " / ";
			end
			KarmaChatDefault("Karma_TEST: pre channels = " .. MLML);
	
			RemoveChatWindowMessages(DEFAULT_CHAT_FRAME:GetID(), "SYSTEM");
	
			local DefaultMessages = { GetChatWindowMessages(DEFAULT_CHAT_FRAME:GetID()) };
			local MLML = "";
			for i, name in pairs(DefaultMessages) do
				MLML = MLML .. name .. " / ";
			end
			KarmaChatDefault("Karma_TEST: post channels = " .. MLML);
	
			-- KarmaChatDefault("Karma_TEST: adding");
			Karma:RegisterEvent("FRIENDLIST_UPDATE");
			KARMA_OnlineCheckAddedFriend = arg;
			AddFriend(arg);
		end;
	end;
]]--
end;
-- Karma_TEST: development helper ;) (end)

function	Karma_Friendlist_Update()
	Karma:UnregisterEvent("FRIENDLIST_UPDATE");

	local	oFriendListNew, i = {};

	local	iMax = BNGetNumFriends();
	for i = 1, iMax do
		local	_, _, _, sName, _, _, bOnline = BNGetFriendInfo(i);
		oFriendListNew[sName] = bOnline;
	end
	local	iMax = GetNumFriends();
	for i = 1, iMax do
		local	sName, _, _, _, bOnline = GetFriendInfo(i);
		oFriendListNew[sName] = bOnline;
	end

	local	oFriendListOld, k, v = KarmaModuleLocal.FriendList;
	local	oFriendListChanged = {};
	for k, v in pairs(oFriendListOld) do
		if (oFriendListNew[k] ~= v) then
			oFriendListChanged[k] = true;
		end
	end
	for k, v in pairs(oFriendListNew) do
		if (oFriendListOld[k] ~= v) then
			oFriendListChanged[k] = true;
		end
	end

	local	iNow = time();
	for k, v in pairs(oFriendListChanged) do
		local	oMember = Karma_MemberList_GetObject(k);
		if ((type(oMember) == "table") and (type(oMember[KARMA_DB_L5_RRFFM_TIMESTAMP]) == "table")) then
			oMember[KARMA_DB_L5_RRFFM_TIMESTAMP][KARMA_DB_L5_RRFFM_TIMESTAMP_SUCCESS] = iNow;
		end
	end

	KarmaModuleLocal.FriendList = oFriendListNew;

	if (KARMA_OnlineCheckAddedFriend ~= nil) then
		local i, FCount, name, level, class, area, connected, status;
		FCount = GetNumFriends();
		for i = 1, FCount do
			name, level, class, area, connected, status = GetFriendInfo(i);
			if name == KARMA_OnlineCheckAddedFriend then
				KarmaChatDefault("Karma_TEST: " .. name .. " found, online = " .. Karma_NilToString(connected));
				break;
			end
		end
	
		RemoveFriend(KARMA_OnlineCheckAddedFriend);
		KARMA_OnlineCheckAddedFriend = nil;
		AddChatWindowMessages(DEFAULT_CHAT_FRAME:GetID(), "SYSTEM");
	end
end

function	Karma_MemberObject_GetTotalZoneListCount(oMember, bVerbose)
	if (type(oMember) == "table") then
		local TotalZoneListCount = 0;
		local PvpZoneListCount = 0;
		local IgnorePvpZones = KCfg.Get("CLEAN_IGNOREPVPZONES");
		for char, charobj in pairs(oMember[KARMA_DB_L5_RRFFM_CHARACTERS]) do
			if (charobj[KARMA_DB_L6_RRFFMCC_ZONEIDLIST]) then
				for index, ZID in pairs(charobj[KARMA_DB_L6_RRFFMCC_ZONEIDLIST]) do
					if (IgnorePvpZones == 1) and IsPvpZone(ZID) then
						PvpZoneListCount = PvpZoneListCount + 1;
					else
						TotalZoneListCount = TotalZoneListCount + 1;
					end
				end
			end
		end

		if (bVerbose)  then
			KarmaChatDebug(KARMA_TITLE.."::MO::GETZLC(" .. oMember[KARMA_DB_L5_RRFFM.NAME] .. "): ".. PvpZoneListCount .. "/" .. TotalZoneListCount);
		end

		return TotalZoneListCount;
	else
		return 0;
	end
end

function	Karma_MemberObject_GetTotalRegionCount(oMember, bVerbose)
	if (type(oMember) == "table") then
		local	ZoneIDlist = {};
		local	RegionIDlist = {};

		local	CommonRegionList = KarmaObj.DB.CG.RegionListGet();
		local	IgnorePvpZones = KCfg.Get("CLEAN_IGNOREPVPZONES");
		local	PvpZoneListCount = 0;

		local	char, charobj;
		for char, charobj in pairs(oMember[KARMA_DB_L5_RRFFM_CHARACTERS]) do
			if (charobj[KARMA_DB_L6_RRFFMCC_ZONEIDLIST]) then
				local	index, ZID;
				for index, ZID in pairs(charobj[KARMA_DB_L6_RRFFMCC_ZONEIDLIST]) do
					if (IgnorePvpZones == 1) and IsPvpZone(ZID) then
						if (bVerbose) then
							KarmaChatDebug(KARMA_TITLE.."::MO::GETRLC::ZL: iZoneID is pvp => " .. ZID);
						end
						PvpZoneListCount = PvpZoneListCount + 1;
					else
						tinsert(ZoneIDlist, - ZID);
					end
				end
			end

			if (charobj[KARMA_DB_L6_RRFFMCC_REGIONLIST]) then
				local	i1, oRegion;
				for i1, oRegion in pairs(charobj[KARMA_DB_L6_RRFFMCC_REGIONLIST]) do
					local	iRegionID = oRegion[KARMA_DB_L7_RRFFMCCRR_ID];
					if (bVerbose) then
						KarmaChatDebug(KARMA_TITLE.."::MO::GETRLC::RL: iRegionID == " .. iRegionID);
					end

					if (IgnorePvpZones == 1) then
						local	oRegion = CommonRegionList[iRegionID];
						if (oRegion[KARMA_DB_L3_CR.ISPVPZONE] == 1) then
							PvpZoneListCount = PvpZoneListCount + 1000;
						else
							tinsert(RegionIDlist, iRegionID);
						end
					else
						tinsert(RegionIDlist, iRegionID);
					end
				end
			end
		end
		table.sort(ZoneIDlist);

		local CZL = CommonZoneListGet();
		local ZIDPrev = 0;
		local i, ZID, ZRegionID;
		for i, ZID in pairs(ZoneIDlist) do
			if ZID ~= ZIDPrev then
				ZRegionID = CZL[ZID].RegionID
				if (ZRegionID ~= nil) then
					tinsert(RegionIDlist, ZRegionID);
				end
			end
			ZIDPrev = ZID;
		end
		table.sort(RegionIDlist);

		local TotalRegionCount = 0;
		local RIDPrev = 0;
		local iCnt, i, RID = #RegionIDlist;
		for i = 1, iCnt do
			local	RID = RegionIDlist[i];
			if (RID ~= RIDPrev) then
				TotalRegionCount = TotalRegionCount + 1;
			end
			RIDPrev = RID;
		end

		if (bVerbose)  then
			KarmaChatDebug(KARMA_TITLE.."::MO::GETRLC(" .. oMember[KARMA_DB_L5_RRFFM.NAME] .. "): ".. PvpZoneListCount .. "/" .. TotalRegionCount);
		end

		return TotalRegionCount;
	else
		return 0;
	end
end

function	Karma_MemberObject_GetCharacterObject(oMember)
	if (KARMA_CURRENTCHAR == nil) then
		return
	end

	local	oData = KarmaObj.DB.MC.Get(oMember, KARMA_CURRENTCHAR);
	if (oData) then
		return oData;
	elseif (KCfg.Get("DB_SPARSE") ~= 1) then	-- dbsparse
		KarmaObj.DB.MC.InitFull(oMember, KARMA_CURRENTCHAR);
		return KarmaObj.DB.MC.Get(oMember, KARMA_CURRENTCHAR);
	end
end


-- Set Functions

-- dangerous setters => local'ed.
-- required for forcenew/forcecheck
Karma_MemberObject_SetName = function (oMember, name)
	if (type(oMember) == "table") then
		KarmaObj.DB.M.Modified(oMember, "NameByForceChange");
		oMember[KARMA_DB_L5_RRFFM.NAME] = name;
		oMember[KARMA_DB_L5_RRFFM.NAME .. ":SIC"] = name;
	end
end

-- required for xupdate
Karma_MemberObject_SetGUID = function(oMember, sGUID)
	if (type(oMember) == "table") then
		oMember[KARMA_DB_L5_RRFFM.GUID] = sGUID;
	end
end

--[[
-- unused
function	Karma_MemberObject_SetTimePlayed(oMember, played)
	if (type(oMember) == "table") then
		local	charobj = Karma_MemberObject_GetCharacterObject(oMember);
		charobj[KARMA_DB_L6_RRFFMCC_PLAYED] = played;
	end
end
]]--


function	Karma_MemberObject_SetTalentID(oMember, iSpec, iTalent)
	if (type(oMember) == "table") then
		if (iTalent) then
			if (iTalent == 0) then
				iTalent = nil;
			end
			local	sKey = KARMA_DB_L5_RRFFM_TALENT .. "_" .. iSpec;
			if (oMember[sKey] ~= iTalent) then
				KarmaObj.DB.M.Modified(oMember, "Talent " .. (iSpec or ""));
				oMember[sKey] = iTalent;
			end
			if (iSpec == 1) then	-- TODO: dual-cleanup
				oMember[KARMA_DB_L5_RRFFM_TALENT] = iTalent;
			end
		end
	end
end

function	Karma_MemberObject_SetAltID(oMember, altid)
	if (type(oMember) == "table") then
		if (altid == -1) then
			altid = nil;
		end
		if (oMember[KARMA_DB_L5_RRFFM.ALTGROUP] ~= altid) then
			KarmaObj.DB.M.Modified(oMember, "Alt group");
			oMember[KARMA_DB_L5_RRFFM.ALTGROUP] = altid;
		end
	end
end

function	Karma_MemberObject_SetNotes(oMember, text)
	if (type(oMember) == "table") then
		if (text == "") then
			text = nil;
		end
		if (oMember[KARMA_DB_L5_RRFFM_NOTES] ~= text) then
			if	(KarmaTrans_Changelog ~= nil) and
			    (KCfg.Get("DEBUG_ENABLED") == 1) then
				KarmaTrans_Changelog("KMOSetNotes(" .. oMember[KARMA_DB_L5_RRFFM.NAME] .. ")", oMember[KARMA_DB_L5_RRFFM_NOTES], text);
			end

			oMember[KARMA_DB_L5_RRFFM_NOTES_TIME] = time();
			oMember[KARMA_DB_L5_RRFFM_NOTES] = text;

			KarmaObj.DB.M.Modified(oMember, "Private notes");
		end
	end
end

function	Karma_MemberObject_SetPublicNotes(oMember, text)
	if (type(oMember) == "table") then
		-- we don't want this to be *long*
		text = KarmaObj.UTF8.SubInChars(text, 1, 40);
		if (text == "") then
			text = nil;
		end
		if (oMember[KARMA_DB_L5_RRFFM_PUBLIC_NOTES] ~= text) then
			if	(KarmaTrans_Changelog ~= nil) and
			    (KCfg.Get("DEBUG_ENABLED") == 1) then
				KarmaTrans_Changelog("KMOSetPublicNotes(" .. oMember[KARMA_DB_L5_RRFFM.NAME] .. ")", oMember[KARMA_DB_L5_RRFFM_PUBLIC_NOTES], text);
			end

			if ((oMember[KARMA_DB_L5_RRFFM_PUBLIC_NOTES] ~= nil) and
			    (oMember[KARMA_DB_L5_RRFFM_PUBLIC_NOTES] ~= "")) then
				local	iOld = 0;
				if (oMember[KARMA_DB_L5_RRFFM_PUBLIC_NOTES_TIME]) then
					iOld = oMember[KARMA_DB_L5_RRFFM_PUBLIC_NOTES_TIME];
				end
				if (time() - iOld > 76800) then
					local	sValue = oMember[KARMA_DB_L5_RRFFM_PUBLIC_NOTES_HISTORY];
					sValue = sValue .. date(KARMA_DATEFORMAT .. " %H:%M:%S", iOld) .. ": >>\n" .. oMember[KARMA_DB_L5_RRFFM_PUBLIC_NOTES] .. "\n<<\n\n";
					oMember[KARMA_DB_L5_RRFFM_PUBLIC_NOTES_HISTORY] = sValue;
				end
			end

			oMember[KARMA_DB_L5_RRFFM_PUBLIC_NOTES_TIME] = time();
			oMember[KARMA_DB_L5_RRFFM_PUBLIC_NOTES] = text;

			KarmaObj.DB.M.Modified(oMember, "'Public' notes");
		end
	end
end

function	Karma_MemberObject_SetSkill(oMember, iSkill)
	if (type(oMember) == "table") then
		if (iSkill == -1) then
			iSkill = nil;
		end
		if (oMember[KARMA_DB_L5_RRFFM_SKILL] ~= iSkill) then
			KarmaObj.DB.M.Modified(oMember, "Skill");
			oMember[KARMA_DB_L5_RRFFM_SKILL] = iSkill;
		end
	end
end

function	Karma_MemberObject_SetGearPVP(oMember, iLevel)
	if (type(oMember) == "table") then
		if (iLevel == -1) then
			iLevel = nil;
		end
		if (oMember[KARMA_DB_L5_RRFFM_GEAR_PVP] ~= iLevel) then
			KarmaObj.DB.M.Modified(oMember, "PvP gear");
			oMember[KARMA_DB_L5_RRFFM_GEAR_PVP] = iLevel;
		end
	end
end

function	Karma_MemberObject_SetGearPVE(oMember, iLevel)
	if (type(oMember) == "table") then
		if (iLevel == -1) then
			iLevel = nil;
		end
		if (oMember[KARMA_DB_L5_RRFFM_GEAR_PVE] ~= iLevel) then
			KarmaObj.DB.M.Modified(oMember, "PvE gear");
			oMember[KARMA_DB_L5_RRFFM_GEAR_PVE] = iLevel;
		end
	end
end

-----------------------------------------
-- ACCESSOR FUNCTIONS
-----------------------------------------

function	Karma_RegionTypeResetAll()
	local	RegionList, iIndex, oRegion = KarmaObj.DB.CG.RegionListGet();
	for iIndex, oRegion in pairs(RegionList) do
		if ((oRegion[KARMA_DB_L3_CR.ISPVPZONE] ~= nil) or (oRegion[KARMA_DB_L3_CR.ZONETYPE] ~= nil)) then
			KarmaChatDebug("Region[" .. (oRegion.Name or "<nil>") .. "].Type: pvp=" .. (oRegion[KARMA_DB_L3_CR.ISPVPZONE] or "<nil>") .. ", inst=" .. (oRegion[KARMA_DB_L3_CR.ZONETYPE] or "<nil>") .. " -> nil/nil");
			oRegion[KARMA_DB_L3_CR.ISPVPZONE] = nil;
			oRegion[KARMA_DB_L3_CR.ZONETYPE] = nil;
		end
	end
end


function	Karma_CleanDatabase()
	-- Not a lot of point in having people listed who have no notes, neutral(50) karma, and no quest/area info.
	KarmaObj.ProfileStart("Karma_CleanDatabase");
	if (KCfg.Get("CLEAN_AUTO")) then
		Karma_ClearUnused();
	end
	KarmaObj.ProfileStop("Karma_CleanDatabase");
end

function	Karma_ClearUnused(extra, pvponly_b, allservers)
	-- this will attempt to delete any members that have no karma, notes, and zone/quest info
	local	IsDryRun = false;
	local	CheckOnlyBucket, CheckOnlyChar;
	if (extra ~= nil) then
		IsDryRun = extra == "dryrun";
		CheckOnlyChar = (type(extra) == "string") and (strsub(extra, 1, 5) == "test:");
		if (not IsDryRun and not CheckOnlyChar) then
			KarmaChatDefault(KARMA_MSG_DBCLEAN_EXTRAARG);
			return
		end

		if (CheckOnlyChar) then
			IsDryRun = true;
			CheckOnlyChar = strsub(extra, 6);
			CheckOnlyBucket = KarmaObj.NameToBucket(CheckOnlyChar);
			KarmaChatDefault("Only checking char " .. CheckOnlyChar .. "...");
		end
	end

	-- must not remove people from list who are in party, so demand that we are not in a party...
	if (GfTt.GetNumPartyMembersTf() > 0) or (GfTt.GetNumRaidMembersTf() > 0) and not IsDryRun then
		KarmaChatDefault(KARMA_MSG_DBCLEAN_INGROUP);
		return
	end

	-- Known bug: Removing doesn't work properly if the Karma window is open.
	-- Maybe does now, since all Karma_GetMemberObject were changed into Karma_MemberList_GetObject? Gotta test some day... TODO.
	if not IsDryRun and KarmaWindow:IsVisible() then
		KarmaWindow:Hide();
	end

	Karma_SetCurrentMember(nil);

	KarmaObj.DB.CG.RegionListMarkPVP(KarmaModuleLocal.RegionsBGsAndArenas);

	local	sMsgStart;
	if IsDryRun then
		sMsgStart = KARMA_MSG_DBCLEAN_PRETEXT_DRYRUN .. KARMA_WINEL_FRAG_TRIDOTS;
	else
		sMsgStart = KARMA_MSG_DBCLEAN_PRETEXT_NORMAL .. KARMA_WINEL_FRAG_TRIDOTS;
	end
	if (pvponly_b == 1) then
		sMsgStart = sMsgStart .. " (pvp entries)";
	end
	KarmaChatDefault(sMsgStart);

	-- configurable 'clean' parameters
	local	KARMA_CleanCheckNoteNotEmpty;
	if (KCfg.Get("CLEAN_KEEPIFNOTE") ~= 0) then
		KARMA_CleanCheckNoteNotEmpty = 1;
	else
		KARMA_CleanCheckNoteNotEmpty = 0;
	end

	local	KARMA_CleanCheckNotPvPJoin;
	if (KCfg.Get("CLEAN_REMOVEPVPJOINS") ~= 0) then
		KARMA_CleanCheckNotPvPJoin = 1;
	else
		KARMA_CleanCheckNotPvPJoin = 0;
	end

	local	KARMA_CleanCheckNotXServer;
	if (KCfg.Get("CLEAN_REMOVEXSERVER") ~= 0) then
		KARMA_CleanCheckNotXServer = 1;
	else
		KARMA_CleanCheckNotXServer = 0;
	end

	local	KARMA_CleanCheckKarmaNot50;
	if (KCfg.Get("CLEAN_KEEPIFKARMA") ~= 0) then
		KARMA_CleanCheckKarmaNot50 = 1;
	else
		KARMA_CleanCheckKarmaNot50 = 0;
	end

	local	KARMA_CleanCheckQuestlistThreshold;
	local Value = KCfg.Get("CLEAN_KEEPIFQUESTCOUNT");
	if (Value ~= nil) then
		Value = tonumber(Value);
	end
	if (type(Value) == "number") then
		KARMA_CleanCheckQuestlistThreshold = Value;
	else
		KARMA_CleanCheckQuestlistThreshold = 1;
	end

	local	KARMA_CleanCheckRegionlistThreshold;
	Value = KCfg.Get("CLEAN_KEEPIFREGIONCOUNT");
	if (Value ~= nil) then
		Value = tonumber(Value);
	end
	if (type(Value) == "number") then
		KARMA_CleanCheckRegionlistThreshold = Value;
	else
		KARMA_CleanCheckRegionlistThreshold = 2;
	end

	local	KARMA_CleanCheckZonelistThreshold;
	Value = KCfg.Get("CLEAN_KEEPIFZONECOUNT");
	if (Value ~= nil) then
		Value = tonumber(Value);
	end
	if (type(Value) == "number") then
		KARMA_CleanCheckZonelistThreshold = Value;
	else
		KARMA_CleanCheckZonelistThreshold = 4;
	end

	local	oServers;
	if (allservers) then
		oServers = KarmaObj.DB.ServerListGet(true);
	else
		oServers = { "CURRENT" };
	end

	local	iIxServer, sServer;
	for iIxServer, sServer in pairs(oServers) do
		-- dryrun message
		local	MsgStart = "Cleanup dryrun ";

		local	MsgCountKeep = 0;
		local	MsgLinesCountKeep = 1;
		local	MsgCurrentKeep = "";
		local	MsgCurrentKeepList = {};

		local	MsgCountRemove = 0;
		local	MsgLinesCountRemove = 1;
		local	MsgCurrentRemove = "";
		local	MsgCurrentRemoveList = {};

		local	RemoveCount = 0;
		local	TotalCount = 0;

		local	lMembers, sPrefix;
		if (sServer == "CURRENT") then
			sServer = nil;
			lMembers = KarmaObj.DB.SF.MemberListGet();
			sPrefix = "";
		else
			lMembers = KarmaObj.DB.SF.MemberListGet(sServer);
			KarmaChatSecondary("==== Server <" .. sServer .. "> ====");
			sPrefix = "Server <" .. sServer .. "> ";
		end

		local	KeepReasons, sBucketName, BucketValue;
		for sBucketName, BucketValue in pairs(lMembers) do -- Loop through each bucket
			if (not CheckOnlyBucket or (sBucketName == CheckOnlyBucket)) then
				local	sMemberName, value, RemoveEntry, ForceRemoveEntry;
				for sMemberName, value in pairs(BucketValue) do -- Loop through contents of bucket
					if (not CheckOnlyChar or (sMemberName == CheckOnlyChar)) then
						-- Dealing with an entry in this bucket
						local	oMember = value;
						TotalCount = TotalCount + 1;
						local	KarmaValue = Karma_MemberObject_GetKarmaModified(oMember);

						ForceRemoveEntry = 0;
						RemoveEntry = 1;

						if (IsDryRun) then
							KeepReasons = "";
						end

						-- pre-test: definitely remove these entries
						if	(
								(KarmaValue == nil) or
								(strupper(sMemberName) == strupper(KARMA_UNKNOWN_ENT)) or
								(strupper(sMemberName) == strupper(KARMA_UNKNOWN))
							) then
							ForceRemoveEntry = 1;
							RemoveEntry = 0; -- skip further tests
							if IsDryRun then
								KeepReasons = KeepReasons .. "-K|UNK!";
							end
						end

						-- now for the (soon to be configurable) parts...

						-- keep entry if note is not empty
						if ((RemoveEntry == 1) or IsDryRun) and (KARMA_CleanCheckNoteNotEmpty == 1) then
							local NoteValue = Karma_MemberObject_GetNotes(oMember);
							if (NoteValue ~= nil) and (NoteValue ~= "") then
								RemoveEntry = 0;
								if IsDryRun then
									KeepReasons = KeepReasons  .. "+N";
								end
							end
						end

						-- force-remove entry if joined in pvp and no note
						if ((RemoveEntry == 1) or IsDryRun) and (KARMA_CleanCheckNotPvPJoin == 1) then
							local	ZID = KarmaObj.DB.M.AddedZoneGet(oMember);
							if (ZID and IsPvpZone(ZID)) then
								ForceRemoveEntry = 1;
								RemoveEntry = 0; -- skip further tests
								if IsDryRun then
									KeepReasons = KeepReasons  .. "-PVP!";
								end
							end
						end

						-- force-remove entry if XServer and no note
						if ((RemoveEntry == 1) or IsDryRun) and (KARMA_CleanCheckNotXServer == 1) then
							if (string.find(sMemberName, "(*)", 1, true) ~= nil) or
							   (string.find(sMemberName, "@", 1, true) ~= nil) then
								ForceRemoveEntry = 1;
								RemoveEntry = 0; -- skip further tests
								if IsDryRun then
									KeepReasons = KeepReasons  .. "-*!";
								end
							end
						end

						-- keep entry if Karma is not 50
						if ((RemoveEntry == 1) or IsDryRun) and (KARMA_CleanCheckKarmaNot50 == 1) then
							if (KarmaValue ~= 50) and (KarmaValue ~= nil) then
								RemoveEntry = 0;
								if IsDryRun then
									KeepReasons = KeepReasons  .. "+K";
								end
							end
						end

						-- keep entry if Questlist has threshold entries
						if ((RemoveEntry == 1) or IsDryRun) and (KARMA_CleanCheckQuestlistThreshold > 0) then
							local TotalQuestListCount = Karma_MemberObject_GetTotalQuestListCount(oMember);
							if (TotalQuestListCount >= KARMA_CleanCheckQuestlistThreshold) then
								RemoveEntry = 0;
								if IsDryRun then
									KeepReasons = KeepReasons  .. "+Q(" .. TotalQuestListCount .. ")";
								end
							end
						end

						-- keep entry if Zonelist has threshold entries
						if ((RemoveEntry == 1) or IsDryRun) and (KARMA_CleanCheckZonelistThreshold > 0) then
							local TotalZoneListCount = Karma_MemberObject_GetTotalZoneListCount(oMember, CheckOnlyChar);
							if (TotalZoneListCount >= KARMA_CleanCheckZonelistThreshold) then
								RemoveEntry = 0;
								if IsDryRun then
									KeepReasons = KeepReasons  .. "+Z(" .. TotalZoneListCount .. ")";
								end
							end
						end

						-- keep entry if Zonelist-Region-total has threshold entries
						if ((RemoveEntry == 1) or IsDryRun) and (KARMA_CleanCheckRegionlistThreshold > 0) then
							local TotalRegionCount = Karma_MemberObject_GetTotalRegionCount(oMember, CheckOnlyChar);
							if (TotalRegionCount >= KARMA_CleanCheckRegionlistThreshold) then
								RemoveEntry = 0;
								if IsDryRun then
									KeepReasons = KeepReasons  .. "+R(" .. TotalRegionCount .. ")";
								end
							end
						end

						-- cleanpvp: drop all pvp but those with Karma/Note
						if (pvponly_b == 1) and (ForceRemoveEntry ~= 1) then
							RemoveEntry = 0;
						end

						if (RemoveEntry == 1) or (ForceRemoveEntry == 1) then
							if IsDryRun then
								MsgCurrentRemove = MsgCurrentRemove .. " |cFFFF3F3F-" .. sMemberName .. "(" .. KeepReasons .. ")";
								MsgCountRemove = MsgCountRemove + 1;
							else
								Karma_MemberList_Remove(sMemberName, sServer);
							end
							RemoveCount = RemoveCount + 1;
						else
							if IsDryRun then
								MsgCurrentKeep = MsgCurrentKeep .. " |cFF3FFF3F+" .. sMemberName .. "(" .. KeepReasons .. ")";
								MsgCountKeep = MsgCountKeep + 1;
							end
						end

						if IsDryRun then
							if MsgCountKeep >= 12 then
								MsgCurrentKeep = MsgStart .. " (" .. MsgLinesCountKeep .. ") =>" .. MsgCurrentKeep;
								MsgCurrentKeepList[MsgLinesCountKeep] = MsgCurrentKeep;
								MsgLinesCountKeep = MsgLinesCountKeep + 1;

								MsgCurrentKeep = "";
								MsgCountKeep = 0;
							end
							if MsgCountRemove >= 12 then
								MsgCurrentRemove = MsgStart .. " (" .. MsgLinesCountRemove .. ") =>" .. MsgCurrentRemove;
								MsgCurrentRemoveList[MsgLinesCountRemove] = MsgCurrentRemove;
								MsgLinesCountRemove = MsgLinesCountRemove + 1;

								MsgCurrentRemove = "";
								MsgCountRemove = 0;
							end
						end
					end
				end
			end
		end

		if IsDryRun then
			-- don't forget the last segment!
			if MsgCountKeep > 0 then
				MsgCurrentKeep = MsgStart .. " (" .. MsgLinesCountKeep .. ") =>" .. MsgCurrentKeep;
				MsgCurrentKeepList[MsgLinesCountKeep] = MsgCurrentKeep;
				MsgLinesCountKeep = MsgLinesCountKeep + 1;

				MsgCurrentKeep = "";
				MsgCountKeep = 0;
			end
			if MsgCountRemove > 0 then
				MsgCurrentRemove = MsgStart .. " (" .. MsgLinesCountRemove .. ") =>" .. MsgCurrentRemove;
				MsgCurrentRemoveList[MsgLinesCountRemove] = MsgCurrentRemove;
				MsgLinesCountRemove = MsgLinesCountRemove + 1;

				MsgCurrentRemove = "";
				MsgCountRemove = 0;
			end

			local	iLine;
			for iLine = 1, MsgLinesCountKeep - 1 do
				KarmaChatDebug(MsgCurrentKeepList[iLine]);
			end
			for iLine = 1, MsgLinesCountRemove - 1 do
				KarmaChatSecondary(MsgCurrentRemoveList[iLine]);
			end

			KarmaChatDefault(sPrefix .. KARMA_MSG_DBCLEAN_RESULT_DRYRUN1 .. RemoveCount .. KARMA_MSG_DBCLEAN_RESULT_DRYRUN2
								.. KARMA_WINEL_FRAG_COLONSPACE .. (TotalCount - RemoveCount)
								.. KARMA_MSG_DBCLEAN_RESULT_3);
		else
			KarmaChatDefault(sPrefix .. KARMA_MSG_DBCLEAN_RESULT_NORMAL1 .. RemoveCount .. KARMA_MSG_DBCLEAN_RESULT_NORMAL2
								.. KARMA_WINEL_FRAG_COLONSPACE .. (TotalCount - RemoveCount)
								.. KARMA_MSG_DBCLEAN_RESULT_3);
		end
	end

	Karma_MemberList_CreateMemberNamesCache();
	KarmaObj.DB.SF.RecentlyJoinedUpdate({});
end

--
-- ----------------------------------------------------------------------------
--

--
-- Add zone to 1
--
local	ZoneAddTime = 0;
local	ZoneAddFlag = 1;
local	ZoneAddDone = 0;
local	ZoneIdPrev = 0;
local	ZoneId = 0;
local	RegionGap = 900;				-- 15m Relog-Gap allowed
local	RegionLogID = nil;
local	RegionLogKey = nil;
local	RegionLogDayID = nil;
local	RegionLogDayKey = nil;

function	Karma_AddZoneToPartyMember(oMember, memberfield_character)
	local	iTime = GetTime();

	-- delay after zoning
	if (Karma_ZoneChanged ~= 0) then
		ZoneAddFlag = 0;
		ZoneAddTime = iTime + 20;

		KarmaChatDebug("AddZoneToPartyMember: Reset AddFlag due to zone change.");
		return
	end

	-- don't add anything while we're dead
	if (UnitIsGhost("player") == 1) then
		-- next 'real' update should be triggered by zoning
		ZoneAddFlag = 0;
		ZoneAddTime = iTime + 120;

		KarmaChatDebug("AddZoneToPartyMember: Reset AddFlag due to you being a ghost.");
		return
	end

	-- prelude postactive: set time and zone
	-- (only once per update for the party, therefore extra call in Add*ToPartyMembers())
	if (memberfield_character == nil) then
		local	iParty = GfTt.GetNumPartyMembersTf();
		local	iRaid = GfTt.GetNumRaidMembersTf();
		if (iRaid > 0) then
			iParty = 0;
		end
		if (ZoneAddTime < iTime) then
			ZoneAddFlag = 1;
			ZoneAddTime = iTime + 20 + iParty * 5 + iRaid * 5;

			if (ZoneIdPrev ~= ZoneId) then
				-- one faster update, maybe someone died or was just out of line of sight or zoned slow
				ZoneAddTime = iTime + 20;
			end
		elseif (ZoneAddDone == 1) then
			ZoneAddFlag = 0;
			ZoneAddDone = 0;
			ZoneIdPrev = ZoneId;
		end

		if (iParty + iRaid > 0) then
--			local	sStack = debugstack(3, 1, 0);
--			KarmaChatDebug("AddZoneToPartyMember: Flag = " .. ZoneAddFlag .. ", next in " .. (ZoneAddTime - GetTime()) .. " (from " .. sStack .. ")");
		end

		return
	end

-- KarmaChatDebug("AddZoneToPartyMember: >>");

	-- get UnitID (name does not work for UnitXXX - functions)
	local uname = Karma_MemberList_MemberNameToUnitName(Karma_MemberObject_GetName(oMember));
	if (uname == nil) or not UnitExists(uname) then
		KarmaChatDebug("AddZoneToPartyMember: Failed to find matching unit for <" .. Karma_MemberObject_GetName(oMember) .. ">");
		return
	end

	-- new: only add if visible... no list for leechers
	if (UnitIsVisible(uname) == nil) then
-- KarmaChatDebug("AddZoneToPartyMember: << (2)");
		return
	end

	local	RegionID, negZoneID;
	-- ZoneId, RegionID = Karma_ZoneList_AddZone(GetMinimapZoneText());
	negZoneID, RegionID = CommonRegionZoneAddCurrent();
	if (negZoneID == nil) then
-- KarmaChatDebug("AddZoneToPartyMember: << (3.1) " .. GetMinimapZoneText());
		return;
	end

	ZoneId = - negZoneID;

	-- new: every 60 seconds be enough for the same zone..
	if (ZoneAddFlag == 0) then
-- KarmaChatDebug("AddZoneToPartyMember: << (3)");
		return
	end

	ZoneAddDone = 1;
	KarmaChatDebug("Region/Zone update...");

	local	bTrackZonePvP = true;
	if (KCfg.Get("TRACK_DISABLEPVPAREAS") == 1) then
		if (IsPvpZone(ZoneId)) then
			KarmaChatDebug("Pvp area tracking disabled.");
			bTrackZonePvP = false;
		end
	end

	local	bTrackZoneNormal = true;
	if (bTrackZonePvP and (KCfg.Get("TRACK_DISABLEZONE") == 1)) then
		KarmaChatDebug("Zone tracking disabled.");
		bTrackZoneNormal = false;
	end

	KarmaObj.DB.M.AddedZoneSet(oMember, memberfield_character, ZoneId, bTrackZonePvP and bTrackZoneNormal);

	if (not bTrackZonePvP) then
		return
	end

-- KarmaChatDebug("AddZoneToPartyMember: RegionID = " .. (RegionID or "nil"));
	if (RegionID) then
		local	bInInstance, iType = IsInInstance();
-- KarmaChatDebug("AddZoneToPartyMember: bInInstance = " .. (bInInstance or "nil") .. ", iType = " .. (iType or "nil"));
		if (bInInstance) and (iType == "party") or (iType == "raid") then
			if (KCfg.Get("TRACK_DISABLEREGION") == 1) then
				KarmaChatDebug("Region tracking disabled.");
				return
			end

			--[[
			-- pre -5.0: iDiff = GetInstanceDifficulty:
				-- 1 = party/raid 10/raid 40(!), 2 = party heroic/raid 25, 3 = raid 10 heroic, 4 = raid 25 heroic
			-- post-5.0: _, iDiff = GetInstanceInfo:
				-- 0 = none(!), 1 = party, 2 = party heroic, 3 = raid 10, 4 = raid 25, 5 = raid 10 heroic,
				-- 6 = raid 25 heroic, 7 = LFR, 8 = challenge, 9 = raid 40
			-- =>: old <=> new:
				-- party/1,2 = party/1,2
				-- raid/1,2,3,4 (+10) = raid/3|9,4,5,6
				-- raid/?,? = raid/7,8
			]]--
			local	iDifficulty;
			if (KarmaObj.Const.iTOC < 50000) then
				iDifficulty = GetInstanceDifficulty();
			if (iType == "raid") then
				iDifficulty = iDifficulty + 10;
			end
			else
				local	sInstanceName, sInstanceType, sDifficultyName, iMaxPlayers;
				sInstanceName, sInstanceType, iDifficulty, sDifficultyName, iMaxPlayers = GetInstanceInfo();
				if (iDifficulty == 1) or (iDifficulty == 2) then
					-- same in old and new scheme: nothing to do
				elseif (iDifficulty >= 3) and (iDifficulty <= 6) then
					-- 3,4,5,6 => 10,11,12,13
					iDifficulty = iDifficulty + 7;
				elseif (iDifficulty == 7) then
					-- LFR:
					if (iMaxPlayers == 10) then
						iDifficulty = 10;
					else
						iDifficulty = 11;
					end
				elseif (iDifficulty == 8) then
					-- this might be heroic, value unknown
					iDifficulty = 1;
				elseif (iDifficulty == 9) then
					-- 40 mans: only of historic value...
					iDifficulty = 10;
				else
					return;
				end
			end
			local	bRegionKeysValid;

			-- if we add to same region since last time, maybe don't have to check thru all regions...
			if (RegionLogID) and (RegionKey) then
				local	RegionLog = memberfield_character[KARMA_DB_L6_RRFFMCC_REGIONLIST][RegionLogID];
				if (type(RegionLog) == "table") then
					if  (RegionLog[KARMA_DB_L7_RRFFMCCRR_KEY] == RegionLogKey) and
						(RegionLog[KARMA_DB_L7_RRFFMCCRR_ID] == RegionID) and
						(RegionLog[KARMA_DB_L7_RRFFMCCRR_DIFF] == iDifficulty) then
						bRegionKeysValid = true;
					end
				end
			end

			-- didn't have key yet or different key than region? check thru all regions...
			if (bRegionKeysValid == nil) then
				local	key, value;
				for key, value in pairs(memberfield_character[KARMA_DB_L6_RRFFMCC_REGIONLIST]) do
					if  (value[KARMA_DB_L7_RRFFMCCRR_ID] == RegionID) and
						(value[KARMA_DB_L7_RRFFMCCRR_DIFF] == iDifficulty) then
						RegionLogID = key;
						RegionLogKey = value[KARMA_DB_L7_RRFFMCCRR_KEY];
						bRegionKeysValid = true;
					end
				end
			end

			-- still invalid? add new entry
			if (bRegionKeysValid == nil) then
				RegionLogID = 1 + #memberfield_character[KARMA_DB_L6_RRFFMCC_REGIONLIST];
				RegionLogKey = time();

				-- if we move fast across zone boundaries after being ported e.g.,
				-- time() might become be a duplicate key by accident
				-- check and if true, increase until unique
				local	key, value, maxkey;
				maxkey = 0;
				for key, value in pairs(memberfield_character[KARMA_DB_L6_RRFFMCC_REGIONLIST]) do
					if (value[KARMA_DB_L7_RRFFMCCRR_KEY] >= RegionLogKey) then
						maxkey = value[KARMA_DB_L7_RRFFMCCRR_KEY];
					end
				end
				if (maxkey > 0) then
					RegionLogKey = maxkey + 1;
				end

				memberfield_character[KARMA_DB_L6_RRFFMCC_REGIONLIST][RegionLogID] = {};

				local	RegionLog = memberfield_character[KARMA_DB_L6_RRFFMCC_REGIONLIST][RegionLogID];
				RegionLog[KARMA_DB_L7_RRFFMCCRR_KEY] = RegionLogKey;
				RegionLog[KARMA_DB_L7_RRFFMCCRR_ID] = RegionID;
				RegionLog[KARMA_DB_L7_RRFFMCCRR_DIFF] = iDifficulty;
				RegionLog[KARMA_DB_L7_RRFFMCCRR_PLAYEDTOTAL] = 0;
				RegionLog[KARMA_DB_L7_RRFFMCCRR_PLAYEDDAYS] = {};
				bRegionKeysValid = true;
KarmaChatDebug("AddZoneToPartyMember: added new RegionLog entry, {" .. RegionID .. ": " .. RegionLogKey .. ", " .. iDifficulty .. "}");
			end

			if (type(memberfield_character[KARMA_DB_L6_RRFFMCC_REGIONLIST]) ~= "table") then
KarmaChatDebug("Oops: RegionList broken (1)");
				return;
			end
			if (type(memberfield_character[KARMA_DB_L6_RRFFMCC_REGIONLIST][RegionLogID]) ~= "table") then
KarmaChatDebug("Oops: RegionList broken (2)");
				return;
			end
			if (type(memberfield_character[KARMA_DB_L6_RRFFMCC_REGIONLIST][RegionLogID][KARMA_DB_L7_RRFFMCCRR_PLAYEDDAYS]) ~= "table") then
KarmaChatDebug("Oops: RegionList broken (3)");
				return;
			end

			-- set total to negative, so we know that we need to add up the times to show:
			local	RegionLog = memberfield_character[KARMA_DB_L6_RRFFMCC_REGIONLIST][RegionLogID];
			RegionLog[KARMA_DB_L7_RRFFMCCRR_PLAYEDTOTAL] = - abs(RegionLog[KARMA_DB_L7_RRFFMCCRR_PLAYEDTOTAL]);

			-- ok, now we have a container with the zone/difficulty
			-- now we've gotta check for a subcontainer with times
			local	Days = RegionLog[KARMA_DB_L7_RRFFMCCRR_PLAYEDDAYS];
			local	bRegionDayValid;
			if (RegionLogDayID) then
				local	Day = Days[RegionLogDayID];
				if (type(Day) == "table") and
					(Day[KARMA_DB_L8_RRFFMCCRRD_KEY] == RegionLogDayKey) then
					local	endtime = Day[KARMA_DB_L8_RRFFMCCRRD_END];
					if (time() - endtime) < RegionGap then
						bRegionDayValid = true;
					end
				end
			end

			if (bRegionDayValid == nil) then
				local	key, value, endtime, enddelta;
				enddelta = RegionGap;								-- 10 minutes gap allowed for relogging
				for key, value in pairs(Days) do
					if (type(value) == "table") then
						endtime = value[KARMA_DB_L8_RRFFMCCRRD_END];
						if (time() - endtime) < enddelta then
							bRegionDayValid = true;
							RegionLogDayID = key;
							RegionLogDayKey = value[KARMA_DB_L8_RRFFMCCRRD_KEY];
							enddelta = time() - endtime;
						end
					end
				end
			end

			-- if the starttime is more than 12 hours away, don't accept the key
			if (bRegionDayValid) then
				local	starttime = Days[RegionLogDayID][KARMA_DB_L8_RRFFMCCRRD_START];
				if (starttime == nil) or ((time() - starttime) > 43200) then
					bRegionDayValid = nil;
					RegionLogDayID = nil;
					RegionLogDayKey = nil;
				end
			end

			-- nothing found or something found but thrown away: add new.
			if (bRegionDayValid == nil) then
				RegionLogDayID = 1 + #Days;
				RegionLogDayKey = time();
				-- if we move fast across zone boundaries after being ported e.g.,
				-- time() might become be a duplicate key by accident
				-- check and if true, increase until unique
				local	key, value, maxkey;
				maxkey = 0;
				for key, value in pairs(Days) do
					if (value[KARMA_DB_L8_RRFFMCCRRD_KEY] >= RegionLogDayKey) then
						maxkey = value[KARMA_DB_L8_RRFFMCCRRD_KEY];
					end
				end
				if (maxkey > 0) then
					RegionLogDayKey = maxkey + 1;
				end

				Days[RegionLogDayID] = {};
				local	Day = Days[RegionLogDayID];
				Day[KARMA_DB_L8_RRFFMCCRRD_KEY] = RegionLogDayKey;
				Day[KARMA_DB_L8_RRFFMCCRRD_START] = RegionLogDayKey;
				Day[KARMA_DB_L8_RRFFMCCRRD_END] = RegionLogDayKey;

				local	sRoleInGroup = UnitGroupRolesAssigned(uname);
				if (sRoleInGroup and sRoleInGroup ~= "NONE") then
					local	iRoleInGroup = KOH.RoleToNumber(sRoleInGroup);
					if (iRoleInGroup ~= 0) then
						Day[KARMA_DB_L8_RRFFMCCRRD_ROLE] = Day[KARMA_DB_L8_RRFFMCCRRD_ROLE] or iRoleInGroup;
					end
				end

KarmaChatDebug("AddZoneToPartyMember: adding new Day, {" .. RegionLogDayID .. ": " .. RegionLogDayKey .. "}");
			end

			if (type(Days[RegionLogDayID]) ~= "table") then
KarmaChatDebug("Oops: RegionDayList broken (1)");
				return;
			end

-- KarmaChatDebug("AddZoneToPartyMember: Instance start at " .. date("%m-%d %H:%M:%S", Days[RegionLogDayID][KARMA_DB_L8_RRFFMCCRRD_START])
-- 	.. ", end expanded from " .. date("%H:%M:%S", Days[RegionLogDayID][KARMA_DB_L8_RRFFMCCRRD_END]) .. " to " .. date("%H:%M:%S", time()));

			-- now hopefully there's a full-blown correct entry... just move the endtime.
			local	Day = Days[RegionLogDayID];
			Day[KARMA_DB_L8_RRFFMCCRRD_END] = time();
		end
	end

-- KarmaChatDebug("AddZoneToPartyMember: << (4)");
end

--
-- Add xp to 1
--
function	Karma_AddXPToPartyMember(oMember)
	KarmaObj.ProfileStart("Karma_AddXPToPartyMember");

	KarmaObj.DB.MC.InitMinimumPlayer(oMember);
	local	memberfield_character = KarmaObj.DB.MC.GetPlayer(oMember);

	Karma_FieldInitialize(memberfield_character, KARMA_DB_L6_RRFFMCC_XPLAST, UnitXP("player"));
	Karma_FieldInitialize(memberfield_character, KARMA_DB_L6_RRFFMCC_XPMAX, UnitXPMax("player"));

	local	accrued = 0;
	local	accrued_rel = 0;

	local	memlast = memberfield_character[KARMA_DB_L6_RRFFMCC_XPLAST];
	local	memmax = memberfield_character[KARMA_DB_L6_RRFFMCC_XPMAX];

	local	newxp = UnitXP("player");
	local	newxpmax = UnitXPMax("player");
	if (newxp < memlast) then
		-- Ding!
		accrued = (memmax - memlast) + newxp;
		accrued_rel = (memmax - memlast) / memmax + newxp / newxpmax;
	else
		accrued = newxp - memlast;
		accrued_rel = (newxp - memlast) / memmax;
	end

	memberfield_character[KARMA_DB_L6_RRFFMCC_XPLAST] = newxp;
	memberfield_character[KARMA_DB_L6_RRFFMCC_XPMAX] = newxpmax;

	-- only add to visibles
	local name = Karma_MemberObject_GetName(oMember);
	local uname = Karma_MemberList_MemberNameToUnitName(name);
	local addit = true;
	if (uname ~= nil) and UnitExists(uname) then
		addit = false;
		if (UnitIsDeadOrGhost(uname) or UnitIsVisible(uname)) then
			addit = true;
		end
	end

	if (addit) then
		memberfield_character[KARMA_DB_L6_RRFFMCC_XP] = memberfield_character[KARMA_DB_L6_RRFFMCC_XP] + accrued;
		memberfield_character[KARMA_DB_L6_RRFFMCC_XPLVL] = memberfield_character[KARMA_DB_L6_RRFFMCC_XPLVL] + accrued_rel;
	end

	Karma_AddZoneToPartyMember(oMember, memberfield_character);

	KarmaObj.ProfileStop("Karma_AddXPToPartyMember");
end

--
-- Add xp to self
--
function	Karma_AddXPToPlayer()
	KarmaObj.ProfileStart("Karma_AddXPToPlayer");

	local	oPlayer = Karma_GetPlayerObject();

	Karma_FieldInitialize(oPlayer, KARMA_DB_L5_RRFFC.XPTOTAL, 0);
	Karma_FieldInitialize(oPlayer, KARMA_DB_L5_RRFFC.XPLAST, UnitXP("player"));
	Karma_FieldInitialize(oPlayer, KARMA_DB_L5_RRFFC.XPMAX, UnitXPMax("player"));

	Karma_FieldInitialize(oPlayer, KARMA_DB_L5_RRFFC.XPLVLSUM, 0);

	local	accrued = 0;
	local	accruedlvl = 0;

	local	playlast = oPlayer[KARMA_DB_L5_RRFFC.XPLAST];
	local	playmax = oPlayer[KARMA_DB_L5_RRFFC.XPMAX]

	local	newxp = UnitXP("player");
	local	newxpmax = UnitXPMax("player");
	if (newxp < playlast) then
		-- Ding!
		accrued = (playmax - playlast) + newxp;
		accruedlvl = (playmax - playlast) / playmax + newxp / newxpmax;
	else
		accrued = newxp - playlast;
		accruedlvl = (newxp - playlast) / playmax;
	end

	oPlayer[KARMA_DB_L5_RRFFC.XPTOTAL] = oPlayer[KARMA_DB_L5_RRFFC.XPTOTAL] + accrued;
	oPlayer[KARMA_DB_L5_RRFFC.XPLAST] = newxp;
	oPlayer[KARMA_DB_L5_RRFFC.XPMAX] = newxpmax;

	oPlayer[KARMA_DB_L5_RRFFC.XPLVLSUM] = oPlayer[KARMA_DB_L5_RRFFC.XPLVLSUM] + accruedlvl;

	KarmaObj.ProfileStop("Karma_AddXPToPlayer");
end

--
-- Add time to 1
--
function	Karma_AddTimeToPartyMember(oMember, isPvp)
	KarmaObj.ProfileStart("Karma_AddTimeToPartyMember");

	local	newtime = GetTime();
	local	timebetween = 0;
	local	joinedlast = time();

	oMember[KARMA_DB_L5_RRFFM.LASTSEEN] = joinedlast;
	oMember[KARMA_DB_L5_RRFFM_JOINEDLAST_TIME] = joinedlast;
	oMember[KARMA_DB_L5_RRFFM_JOINEDLAST_CHAR] = UnitName("player");

	KarmaObj.DB.MC.InitMinimumPlayer(oMember);
	local	memberfield_character = KarmaObj.DB.MC.GetPlayer(oMember);

	if (memberfield_character[KARMA_DB_L6_RRFFMCC_PLAYEDLAST] == 0) then
		memberfield_character[KARMA_DB_L6_RRFFMCC_PLAYEDLAST] = newtime;
	end

	memberfield_character[KARMA_DB_L6_RRFFMCC_JOINEDLAST] = joinedlast;

	timebetween = newtime - memberfield_character[KARMA_DB_L6_RRFFMCC_PLAYEDLAST];
	if (timebetween  >= 0) then
		-- only add to visibles
		local name = Karma_MemberObject_GetName(oMember);
		local uname = Karma_MemberList_MemberNameToUnitName(name);
		local addit = true;
		if (uname ~= nil) and UnitExists(uname) then
			addit = false;
			if (UnitIsDeadOrGhost(uname) or UnitIsVisible(uname)) then
				addit = true;
			end
		end

		if (addit) then
			memberfield_character[KARMA_DB_L6_RRFFMCC_PLAYED] = memberfield_character[KARMA_DB_L6_RRFFMCC_PLAYED] + timebetween;
			if (isPvp) then
				if (memberfield_character[KARMA_DB_L6_RRFFMCC_PLAYEDPVP] == nil) then
					memberfield_character[KARMA_DB_L6_RRFFMCC_PLAYEDPVP] = 0;
				end
				memberfield_character[KARMA_DB_L6_RRFFMCC_PLAYEDPVP] = memberfield_character[KARMA_DB_L6_RRFFMCC_PLAYEDPVP] + timebetween;
			end
		end
	end

	memberfield_character[KARMA_DB_L6_RRFFMCC_PLAYEDLAST] = newtime;

	Karma_AddZoneToPartyMember(oMember, memberfield_character);

	KarmaObj.ProfileStop("Karma_AddTimeToPartyMember");
end

--
-- Add time to self
--
function	Karma_AddTimeToPlayer(addtoself, isPvp)
	KarmaObj.ProfileStart("Karma_AddTimeToPlayer");

	local	newtime = GetTime();
	local	timebetween = 0;

	local	oPlayer = Karma_GetPlayerObject();

	Karma_FieldInitialize(oPlayer, KARMA_DB_L5_RRFFC.PLAYED, 0);
	Karma_FieldInitialize(oPlayer, KARMA_DB_L5_RRFFC.PLAYEDLAST, newtime);

	timebetween = newtime - oPlayer[KARMA_DB_L5_RRFFC.PLAYEDLAST];
	if (addtoself == 1) then
		oPlayer[KARMA_DB_L5_RRFFC.PLAYED] = oPlayer[KARMA_DB_L5_RRFFC.PLAYED] + timebetween;
		if (isPvp) then
			oPlayer[KARMA_DB_L5_RRFFC.PLAYEDPVP] = oPlayer[KARMA_DB_L5_RRFFC.PLAYEDPVP] + timebetween;
		end
	end
	oPlayer[KARMA_DB_L5_RRFFC.PLAYEDLAST] = newtime;

	KarmaObj.ProfileStop("Karma_AddTimeToPlayer");
end

--
-- Add xp to party
--
function	Karma_AddXPToPartyMembers()
	KarmaObj.ProfileStart("Karma_AddXPToPartyMembers");

	-- check timer for zone list update
	Karma_AddZoneToPartyMember();

	Karma_AddXPToPlayer();
	-- Calculate and add the appropriate amount of xp to each character in the party.
	Karma_VisitAllGroupMembers(Karma_AddXPToPartyMember, nil);

	-- (re-)set timer for zone list update
	Karma_AddZoneToPartyMember();

	KarmaObj.ProfileStop("Karma_AddXPToPartyMembers");
end

--
-- Add time to party
--
function	Karma_AddTimeToPartyMembers(addtoself)
	KarmaObj.ProfileStart("Karma_AddTimeToPartyMembers");

	-- check timer for zone list update
	Karma_AddZoneToPartyMember();

	-- force-add if called from event "party changed"
	local	bInParty = Karma_PlayerIsInRaid();
	local	bInRaid = Karma_PlayerIsInParty();
	if (bInParty or bInRaid) then
		addtoself = 1;
	end

	if (next(KarmaModuleLocal.RegionsBGsAndArenas) == nil) then
		-- TODO: no wargames before which level?
		if (UnitLevel("player") < 15) then
			local	iMax, i = GetNumBattlegroundTypes();
			for i = 1, iMax do
				local sName, _, _, isRandom, iID = GetBattlegroundInfo(i);
				if (not isRandom) then
					KarmaModuleLocal.RegionsBGsAndArenas[sName] = 20000 + iID;
				end
			end

			KarmaChatDebug("Karma_AddTimeToPartyMembers: Found " .. (iMax - 1) .. " BGs.");
		else
			-- PVPFrame.lua::WarGamesFrame_Update() etc.
			-- GetNumWarGameTypes() + GetWarGameTypeInfo(...)
			local	iMax = GetNumWarGameTypes();
			if (iMax == 0) then
				UpdateWarGamesList();
				iMax = GetNumWarGameTypes();
			end

			-- this only works fine if the entries are not collapsed
			local	iCnt, i = 0;
			for i = 1, iMax do
				-- PVPFrame.lua::WarGamesFrame_Update()
				local sName, iPVPType, collapsed, iID, minPlayers, maxPlayers, isRandom = GetWarGameTypeInfo(i);
				if (sName ~= "header") then
					iCnt = iCnt + 1;
					if (iPVPType == INSTANCE_TYPE_ARENA) then
						KarmaModuleLocal.RegionsBGsAndArenas[sName] = 10000 + iID;
					else
						KarmaModuleLocal.RegionsBGsAndArenas[sName] = 20000 + iID;
					end
				end
			end

			KarmaChatDebug("Karma_AddTimeToPartyMembers: Found " .. iCnt .. " BGs/arenas.");
		end
	end

	local	isPvp, RegionName = false, GetZoneText();
	if (next(KarmaModuleLocal.RegionsBGsAndArenas) ~= nil) then
		if (KarmaModuleLocal.RegionsBGsAndArenas[RegionName]) then
			isPvp = true;
		end
	elseif ((RegionName == KARMA_PVPZONE_WSG) or (RegionName == KARMA_PVPZONE_AB) or (RegionName == KARMA_PVPZONE_AV) or
	    (RegionName == KARMA_PVPZONE_ES) or (RegionName == KARMA_PVPZONE_SA) or (RegionName == KARMA_PVPZONE_WG)) then
		isPvp = true;
	end
	Karma_AddTimeToPlayer(addtoself, isPvp);

	Karma_VisitAllGroupMembers(Karma_AddTimeToPartyMember, isPvp);

	-- (re-)set timer for zone list update
	Karma_AddZoneToPartyMember();

	KarmaObj.ProfileStop("Karma_AddTimeToPartyMembers");
end

function	Karma_RegionLog_Status(arg)
	if (arg) then
		local	oMember = Karma_MemberList_GetObject(arg);
		if (oMember) then
			local	oMemChar = KarmaObj.DB.MC.Get(oMember, KARMA_CURRENTCHAR);
			if (oMemChar) then
				local	oRegL = oMemChar[KARMA_DB_L6_RRFFMCC_REGIONLIST];
				if (oRegL) then
					KarmaChatSecondary("RegionLog_Status: ");

					local	RegionList = CommonRegionListGet();

					local	key, value, subkey, subvalue;
					for key, value in pairs(oRegL) do
						local	iTotal = abs(value[KARMA_DB_L7_RRFFMCCRR_PLAYEDTOTAL]);

						local	sTotal = "";
						if (iTotal >= 86400) then
							sTotal = math.floor(iTotal / 86400) .. "d ";
							iTotal = iTotal % 86400;
						end
						sTotal = sTotal .. math.floor(iTotal / 3600) .. "h";

						iTotal = math.max(0, iTotal);
						KarmaChatSecondary("RegionLog[" .. key .. "] = { "
							.. value[KARMA_DB_L7_RRFFMCCRR_KEY] .. ", " ..  value[KARMA_DB_L7_RRFFMCCRR_ID] .. " = "
							.. RegionList[value[KARMA_DB_L7_RRFFMCCRR_ID]].Name .. ", "
							.. value[KARMA_DB_L7_RRFFMCCRR_DIFF] .. ", " .. sTotal);

						local	starttime, endtime;
						for subkey, subvalue in pairs(value[KARMA_DB_L7_RRFFMCCRR_PLAYEDDAYS]) do
							starttime = subvalue[KARMA_DB_L8_RRFFMCCRRD_START];
							endtime = subvalue[KARMA_DB_L8_RRFFMCCRRD_END];
							iTotal = iTotal + (endtime - starttime);
							KarmaChatSecondary(" -- Day[" .. subkey .. "] = " .. date("%Y-%m-%d", subvalue[KARMA_DB_L8_RRFFMCCRRD_START]) .. " from " .. date("%H:%M:%S", subvalue[KARMA_DB_L8_RRFFMCCRRD_START]) .. " to " .. date("%H:%M:%S", subvalue[KARMA_DB_L8_RRFFMCCRRD_END]));
						end

						if (value[KARMA_DB_L7_RRFFMCCRR_PLAYEDTOTAL] <= 0) then
							value[KARMA_DB_L7_RRFFMCCRR_PLAYEDTOTAL] = iTotal;
						end
					end

					KarmaChatSecondary("***");
				end
			end
		end
	end
end
--
-- ----------------------------------------------------------------------------
--

function	Karma_UpdateCurrentTargetNameColor()
	local	bTargetColored = KCfg.Get("TARGET_COLORED");
	if (bTargetColored ~= 0) and TargetFrame:IsVisible() then
		local	targetname, targetserver = UnitName("target");
		if (targetserver and (targetserver ~= "")) then
			targetname = targetname .. "@" .. targetserver;
		end
		if (targetname and TargetFrame:IsVisible()) then
			if (UnitFactionGroup("player") == UnitFactionGroup("target") and UnitIsPlayer("target")) then
				local	lMembers = KarmaObj.DB.SF.MemberListGet();
				if (lMembers[KarmaObj.NameToBucket(targetname)][targetname] ~= nil) then
					local	red, green, blue = Karma_MemberList_GetColors(targetname);

					if (TargetFrameTextureFrameName) then
						-- post-3.3 name (probably renamed to fit its hierarchical place)
						TargetFrameTextureFrameName:SetTextColor(1, 1, 1);
					elseif (TargetName) then
						-- pre-3.2 name
						TargetName:SetTextColor(1, 1, 1);
					end
					TargetFrameNameBackground:SetVertexColor(red * 0.6667, green * 0.6667, blue * 0.6667);
				end
			end
		end
	end
end

function	Karma_AdjustPartyMemberNameColors()
	local	iPartyMembers = GfTt.GetNumPartyMembersTf();
	if (iPartyMembers == 0) then
		return;
	end

	local	i;
	for i = 1, iPartyMembers do
		local	membernameobject = getglobal("PartyMemberFrame"..i.."Name");
		if (membernameobject and membernameobject:IsVisible()) then
			local	sMemberName = membernameobject:GetText();
			if (sMemberName ~= nil) then
				local	oMember = Karma_MemberList_GetObject(sMemberName);
				if (oMember) then
					local	red, green, blue = Karma_MemberList_GetColors(sMemberName);
					membernameobject:SetTextColor(red, green, blue);
				end
			end
		end
	end
end

function	Karma_AddQuestToIndividualPartyMember(oMember, questid, state1, state2)
	KarmaObj.ProfileStart("Karma_AddQuestToIndividualPartyMember");

	local	lQuests = Karma_MemberObject_GetQuestList(oMember);
	if (type(lQuests) ~= "table") then
		KarmaObj.ProfileStop("Karma_AddQuestToIndividualPartyMember");
		KarmaChatSecondary("Oops! Failed to find quest data container for player??!");
		return
	end

	local	duplicate, key, value = false;
	for key, value in pairs(lQuests) do
		if (questid == value) then
			duplicate = true;
			break;
		end
	end
	if (duplicate == false) then
		lQuests[getn(lQuests)+1] = questid;
	end

	if (KARMA_QExUpdate > 0) and (state1 ~= nil) and (state2 ~= nil) then
		KarmaChatDebug("Karma_AddQuestToIndividualPartyMember: >> QuestObjectives");
		local lQEx = Karma_MemberObject_GetQuestExList(oMember);
		if (lQEx ~= nil) then
			if (type(lQEx) ~= "table") then
				lQEx = {};
			end

			if (lQEx[questid] == nil) or (type(lQEx[questid]) ~= "table") then
				lQEx[questid] = {};
				lQEx[questid].SummedProgress = nil;
				lQEx[questid].ObjectiveTotal = nil;
			end

			local ObjCount = 0;
			local SummedProgress = 0;
			if (state1.objectives ~= nil) then
				for key, value in pairs(state1.objectives) do
					local okey = "O."..key;
					local pro1 = state1.objectives[key].progress;
					local pro2 = state2.objectives[key].progress;
					if (state1.objectives[key].progress + 1 < state2.objectives[key].progress) then
						if (lQEx[questid][okey] == nil) then
							lQEx[questid][okey] = 0;
						end

						lQEx[questid][okey] = lQEx[questid][okey] + pro2 - pro1;
						SummedProgress = SummedProgress + pro2 - pro1;
					end

					ObjCount = ObjCount + 1;
				end
			end

			if (lQEx[questid].ObjectiveTotal == nil) then
				lQEx[questid].ObjectiveTotal = ObjCount * 100;
			end
			if (lQEx[questid].SummedProgress == nil) then
				lQEx[questid].SummedProgress = 0;
			end

			lQEx[questid].SummedProgress = lQEx[questid].SummedProgress + SummedProgress;
		end
		KarmaChatDebug("Karma_AddQuestToIndividualPartyMember: << QuestObjectives");
	end

	KarmaObj.ProfileStop("Karma_AddQuestToIndividualPartyMember");
end

function	Karma_AddQuestToPartyMembers(questname, state1, state2, extid, daily)
	KarmaObj.ProfileStart("Karma_AddQuestToPartyMembers");
	if (KOH.TableIsEmpty(KARMA_PartyNames)) then
		KarmaChatDebug("Quest information, not in group, not adding.");
		KarmaObj.ProfileStop("Karma_AddQuestToPartyMembers");
		return;
	end

	-- if config option is set, don't add dailies
	if ((daily == 1) and (KCfg.Get("QUESTSIGNOREDAILIES") == 1)) then
		KarmaChatDebug("Daily quest, config option says no adding, not adding.");
		KarmaObj.ProfileStop("Karma_AddQuestToPartyMembers");
		return;
	end

	local	questid = Karma_QuestList_AddQuest(questname, extid);
	-- DEBUG:
	KarmaChatDebug("Karma: " .. questname .. " -> QID = " .. questid .. ", ExtID = " .. Karma_NilToString(extid));
	-- :DEBUG
	if (questid < 0) then
		local	questposid = - questid;
		local	CurrentZoneID = CommonRegionZoneAddCurrent();
		local	globalZoneList = CommonZoneListGet();

		local	globalQuestInfoList = CommonQuestInfoListGet();
		if (globalQuestInfoList[questposid] == nil) then
			globalQuestInfoList[questposid] = {}
		end
		if globalZoneList[CurrentZoneID] then
			if globalZoneList[CurrentZoneID].RegionID then
				if (globalQuestInfoList[questposid].RegionID == nil) then
					globalQuestInfoList[questposid].RegionID = globalZoneList[CurrentZoneID].RegionID;
				elseif (globalQuestInfoList[questposid].RegionID ~= 0) and
					(globalQuestInfoList[questposid].RegionID ~= globalZoneList[CurrentZoneID].RegionID) then
					globalQuestInfoList[questposid].RegionID = 0;
				end

				-- DEBUG:
				KarmaChatDebug("Karma: " .. questname .. " -> RID = " .. globalZoneList[CurrentZoneID].RegionID);
				-- :DEBUG
			end
		end
	end

	Karma_VisitAllGroupMembers(Karma_AddQuestToIndividualPartyMember, questid, state1, state2);
	KarmaObj.ProfileStop("Karma_AddQuestToPartyMembers");
end

-- For each group member, either retrieve, or create a member object, and then pass it
-- to the specified function.
function	Karma_VisitAllGroupMembers(func, user, extra1, extra2)
	KarmaObj.ProfileStart("Karma_VisitAllGroupMembers");
	-- Now update the list of players that this character is grouped with.
	local	oMember;
	for sMemberName, oMember in pairs(KARMA_PartyNames) do
		if (oMember) then
			func(oMember, user, extra1, extra2);
		end
	end

	KarmaObj.ProfileStop("Karma_VisitAllGroupMembers");
end

---
----
---
function	Karma_CurrentMember_PostToChat(toplayer)
	KarmaObj.ProfileStart("Karma_CurrentMember_PostToChat");
	if (toplayer == "") then
		toplayer = nil;
	end

	local	oMember = Karma_MemberList_GetObject(KARMA_CURRENTMEMBER);
	if (oMember) and (DEFAULT_CHAT_FRAME) then
		local	ChatType, DefaultChatEditBox;
		local	DoIt = 0;
		if (toplayer ~= nil) then
			DoIt = 1;
		else
			DefaultChatEditBox = DEFAULT_CHAT_FRAME.editBox;
			ChatType = DefaultChatEditBox:GetAttribute("chatType");
			if (ChatType ~= "WHISPER") and (ChatType ~= "CHANNEL") then
				-- todo: localize
				KarmaChatDefault("Not supported for \"" .. ChatType .. "\", must be talking to a specific target. (Only channels and whispers are allowed... either open the chatline by pressing 'r' (reply, i.e. whisper) or type return and \"/w <player> \" or \"/# \", then click.)");
			elseif (#Karma_MessageQueue > 0) then
				-- todo: localize
				KarmaChatDefault("Chat queue must be empty for self. Currently there are " .. #Karma_MessageQueue .. " lines queued.");
			else
				DoIt = 1;
			end
		end

		if (DoIt == 1) then
			-- implicit lock to queue
			KARMA_LastMessageTime = GetTime() + 30;

			local	Infos = {};
			local	i = 1;
			Infos[i] = "";
			local	iLevel = Karma_MemberObject_GetLevel(oMember);
			local	sRace = Karma_MemberObject_GetRace(oMember);
			local	sClass = Karma_MemberObject_GetClass(oMember);
			if (iLevel) and (iLevel > 0) then
				Infos[i] = Infos[i] .. " " .. iLevel;
			end
			if (sRace) and (sRace ~= "") then
				Infos[i] = Infos[i] .. " " .. sRace;
			end
			if (sClass) and (sClass ~= "") then
				Infos[i] = Infos[i] .. " " .. sClass;
			end
			if (Infos[i] ~= "") then
				Infos[i] = "Karma infos on >" .. KARMA_CURRENTMEMBER .. "< " .. Infos[i];
				i = i + 1;
			end

			local	sNotesPublic = Karma_MemberObject_GetPublicNotes(oMember);
			if (sNotesPublic) and (sNotesPublic ~= "") then
				Infos[i] = KARMA_WINEL_NOTESPUBLIC .. KARMA_WINEL_FRAG_COLONSPACE .. sNotesPublic;
				i = i + 1;
			end

			local	sKarma = Karma_MemberObject_GetKarmaWithModifiers(oMember);
			if (sKarma) and (sKarma ~= "") then
				Infos[i] = KARMA_ITSELF .. KARMA_WINEL_FRAG_COLONSPACE .. sKarma;
				local	sNotes = Karma_MemberObject_GetNotes(oMember);
				if (sNotes) and (sNotes ~= "") then
					Infos[i] = Infos[i] .. " - " .. KARMA_WINEL_NOTESSCROLLFRAMETITLE .. KARMA_WINEL_FRAG_SPACE .. strlen(sNotes) .. " chars";
				else
					Infos[i] = Infos[i] .. " - " .. KARMA_MSG_WHOCATCHED_NONOTES .. KARMA_CURRENTMEMBER;
				end
				i = i + 1;
			end

			local	sSkill = Karma_MemberObject_GetSkillText(oMember);
			if (sSkill) and (sSkill ~= "") then
				Infos[i] = KARMA_MSG_TIP_SKILL .. KARMA_WINEL_FRAG_COLONSPACE .. sSkill;
				i = i + 1;
			end

			local	bHasEntries, EntriesL, iTotal = Karma_RegionList_GetLines(oMember);
			if (bHasEntries == 1) then
				local	dur, key, value = 0;
				for key, value in pairs(EntriesL) do
				end

				Infos[i] = "Tracked dungeons: " .. #EntriesL .. " visits total over " .. KOH.Duration2String(iTotal);
				i = i + 1;
			end

			Infos[i] = "--## the end ##--";
			i = i + 1;

			local	chattarget;
			if (toplayer ~= nil) then
				chattarget = toplayer;
				ChatType = "WHISPER";
				KarmaChatDefault("Whispering Karma's infos about >" .. KARMA_CURRENTMEMBER .. "< to " .. chattarget .. "...");
			else
				if (ChatType == "WHISPER") then
					chattarget = DefaultChatEditBox:GetAttribute("tellTarget");
					KarmaChatDefault("Whispering Karma's infos about >" .. KARMA_CURRENTMEMBER .. "< to " .. chattarget .. "...");
				end
				if (ChatType == "CHANNEL") then
					chattarget = DefaultChatEditBox:GetAttribute("channelTarget");
					KarmaChatDefault("Sending Karma's infos about >" .. KARMA_CURRENTMEMBER .. "< into channel " .. chattarget .. "...");
				end
			end

KarmaChatDebug("ChatType: " .. Karma_NilToString(ChatType) .. ", chattarget: " .. Karma_NilToString(chattarget) .. " (toplayer: " .. Karma_NilToString(toplayer) .. ")");

			if (ChatType and chattarget) then
				local	k, elem;
				for k = 1, i - 1 do
					elem = {};
					elem.text = Infos[k];
					elem.chattype = ChatType;
					elem.target = chattarget;
					Karma_MessageQueue[1 + #Karma_MessageQueue] = elem;
				end
			end

			KARMA_LastMessageTime = GetTime() + 0.5;
		end
	end

	KarmaObj.ProfileStop("Karma_CurrentMember_PostToChat");
end

-----------------------------------------
-- COLOR FUNCTIONS
-----------------------------------------

function	ColourToString(iAlpha, iRed, iGreen, iBlue)
--[[
	if (iAlpha == nil) or (iRed == nil) or (iGreen == nil) or (iBlue == nil) then
		KarmaChatDebug("ColourToString: invalid input from -- " .. debugstack());
		return "FFFF4040";
	end
]]--
	return string.format("%.2X%.2X%.2X%.2X", iAlpha*255, iRed*255, iGreen*255, iBlue*255)
end

function	Karma_MemberList_GetColors(sMemberName)
	local	colorfunction	= KCfg.Get("COLORFUNCTION");
	if (colorfunction == nil) then
		KCfg.SetIndirect("COLORFUNCTION", "COLORFUNCTION_TYPE_KARMA");
		colorfunction = KCfg.Get("COLORFUNCTION");
	end

	if (KCfg.EqualsIndirect(colorfunction, "COLORFUNCTION_TYPE_XP")) then
		return Karma_GetColors_XP(sMemberName);
	elseif (KCfg.EqualsIndirect(colorfunction, "COLORFUNCTION_TYPE_PLAYED")) then
		return Karma_GetColors_Played(sMemberName);
	elseif (KCfg.EqualsIndirect(colorfunction, "COLORFUNCTION_TYPE_KARMA")) then
		return Karma_GetColors_Karma(sMemberName);
	elseif (KCfg.EqualsIndirect(colorfunction, "COLORFUNCTION_TYPE_CLASS")) then
		return Karma_GetColors_Class(sMemberName);
	elseif (KCfg.EqualsIndirect(colorfunction, "COLORFUNCTION_TYPE_XPALL")) then
		return Karma_GetColors_XP(sMemberName, true);
	elseif (KCfg.EqualsIndirect(colorfunction, "COLORFUNCTION_TYPE_PLAYEDALL")) then
		return Karma_GetColors_Played(sMemberName, true);
	elseif (KCfg.EqualsIndirect(colorfunction, "COLORFUNCTION_TYPE_XPLVL")) then
		return Karma_GetColors_XPLVL(sMemberName);
	elseif (KCfg.EqualsIndirect(colorfunction, "COLORFUNCTION_TYPE_XPLVLALL")) then
		return Karma_GetColors_XPLVL(sMemberName, true);
	end
	return 1, 1, 1;
end

function	Karma_Value2Color(sContext, iValue)
	KarmaObj.ProfileStart("Karma_Value2Color");

	-- new: more color change between 40 and 60, where most players end up
		-- r, g: 1 Karma = 0.01 change, b: 1 Karma = 0.02 change
		-- 40-60: r, g: 1 Karma = 0.02
		-- => r(40->60) = 0.7 -> 0.3, g(40->60) = 0.3 -> 0.7
		-- => r(0 ->40) = 1.0 -> 0.7, g(0 ->40) = 0.0 -> 0.3
		-- => r(60->++) = 0.3 -> 0.0, g(60->++) = 0.7 -> 1.0
	local	red;
	local	green;
	local	blue  = 1.0 -  0.02 * math.abs(iValue - 50);

	if (iValue >= 60) then
		red   = 0.3 - (iValue - 60) * 0.0075;
		green = 0.7 + (iValue - 60) * 0.0075;
	elseif (iValue >= 40) then
		red   = 0.7 - (iValue - 40) * 0.02;
		green = 0.3 + (iValue - 40) * 0.02;
	else
		red   = 1.0 - (iValue     ) * 0.0075;
		green =       (iValue     ) * 0.0075;
	end

	-- even newer: let user define the three border colors and interpolate
	if (KCfg.Get("COLORSPACE_ENABLE")) then
		-- normalize
		iValue = math.min(100, math.max(0, iValue));

		-- again, we want 40-60 to be "stronger" than other values
		local	oFrom, oTo, dFactor;
		if (iValue < 50) then
			oFrom = KarmaObj.Colorspace.ValueGet(sContext, "Min");
			oTo   = KarmaObj.Colorspace.ValueGet(sContext, "Avg");
			--  0 .. 50 => 0 .. 1?
			--  0 .. 40 =>   0 .. 2/3
			-- 40 .. 50 => 2/3 ..   1
			if (iValue < 40) then
				dFactor = iValue / 60;
			else
				dFactor = 2/3 + (iValue - 40) / 30;
			end
		else
			oFrom = KarmaObj.Colorspace.ValueGet(sContext, "Avg");
			oTo   = KarmaObj.Colorspace.ValueGet(sContext, "Max");
			-- 50 .. 100 =>   0 .. 1?
			-- 50 ..  60 =>   0 .. 1/3
			-- 60 .. 100 => 1/3 ..   1
			if (iValue < 60) then
				dFactor = (iValue - 50) / 30;
			else
				dFactor = 1/3 + (iValue - 60) / 60;
			end
		end

		red   = oFrom.r + (oTo.r - oFrom.r) * dFactor;
		green = oFrom.g + (oTo.g - oFrom.g) * dFactor;
		blue  = oFrom.b + (oTo.b - oFrom.b) * dFactor;
	end

	KarmaObj.ProfileStop("Karma_Value2Color");

	return red, green, blue;
end

function	Karma_GetColors_Played(sMemberName, bTotal)
	KarmaObj.ProfileStart("Karma_GetColors_Time");
	local	oMember = Karma_MemberList_GetObject(sMemberName);
	if (oMember == nil) then
		return 0.8, 0.8, 0.8;
	end

	local	membertime, low, high, average;
	if (bTotal) then
		membertime = Karma_MemberObject_GetTotalTimePlayedSummedUp(oMember);
		low, high, average = Karma_MemberList_GetHighLow_TotalFieldSummedUp(KARMA_DB_L6_RRFFMCC_PLAYED, oMember);
	else
		membertime = Karma_MemberObject_GetTimePlayed(oMember);
		low, high, average = Karma_MemberList_GetFieldHighLow(KARMA_DB_L6_RRFFMCC_PLAYED, oMember);
	end

	if (membertime == nil) then
		membertime = low;
	end
	local	percentage = ((membertime - low)/(0.01 + (high - low))) * 100;

	percentstep = percentage/5;
	local	green = percentstep*0.08;
	local	blue = (1.0-(percentstep*0.09));
	if (blue < 0) then
		blue = 0;
	end
	if (green > 1.0) then
		green = 1.0
	end

	local	red = 0.0;

	if (KCfg.Get("COLORSPACE_ENABLE")) then
		red, green, blue = Karma_Value2Color("Time", percentage);
	end

	--	KarmaChatDebug("red == "..red.." green == "..green.." blue == "..blue);
	KarmaObj.ProfileStop("Karma_GetColors_Time");

	return red, green, blue;
end

function	Karma_GetColors_XP(sMemberName, bTotal)
	KarmaObj.ProfileStart("Karma_GetColors_XP");
	local	oMember = Karma_MemberList_GetObject(sMemberName);
	if (oMember == nil) then
		return 1, 1, 1;
	end

	local	memberxp, low, high, average;
	if (bTotal) then
		memberxp = Karma_MemberObject_GetTotalXPSummedUp(oMember);
		low, high, average = Karma_MemberList_GetHighLow_TotalFieldSummedUp(KARMA_DB_L6_RRFFMCC_XP, oMember);
	else
		memberxp = Karma_MemberObject_GetXP(oMember);
		low, high, average = Karma_MemberList_GetFieldHighLow(KARMA_DB_L6_RRFFMCC_XP, oMember);
	end
	if (memberxp == nil) then
		memberxp = low;
	end

	local	percentage = ((memberxp - low)/(0.01 + (high - low))) * 100;

	percentstep = percentage/5;
	local	green = percentstep*0.08;
	local	blue = (1.0-(percentstep*0.09));
	if (blue < 0) then
		blue = 0;
	end
	if (green > 1.0) then
		green = 1.0
	end
	local	red = 0.0;

	if (KCfg.Get("COLORSPACE_ENABLE")) then
		red, green, blue = Karma_Value2Color("XP", percentage);
	end

	KarmaObj.ProfileStop("Karma_GetColors_XP");

	return red, green, blue;
end

function	Karma_GetColors_XPLVL(sMemberName, bTotal)
	KarmaObj.ProfileStart("Karma_GetColors_XP");
	local	oMember = Karma_MemberList_GetObject(sMemberName);
	if (oMember == nil) then
		return 1, 1, 1;
	end

	local	memberxp, low, high, average;
	if (bTotal) then
		memberxp = Karma_MemberObject_GetTotalXPLVLSummedUp(oMember);
		low, high, average = Karma_MemberList_GetHighLow_TotalFieldSummedUp(KARMA_DB_L6_RRFFMCC_XPLVL, oMember);
	else
		memberxp = Karma_MemberObject_GetXPLVL(oMember);
		low, high, average = Karma_MemberList_GetFieldHighLow(KARMA_DB_L6_RRFFMCC_XPLVL, oMember);
	end
	if (memberxp == nil) then
		memberxp = low;
	end

	local	percentage = ((memberxp - low)/(0.01 + (high - low))) * 100;

	percentstep = percentage/5;
	local	green = percentstep*0.08;
	local	blue = (1.0-(percentstep*0.09));
	if (blue < 0) then
		blue = 0;
	end
	if (green > 1.0) then
		green = 1.0
	end
	local	red = 0.0;

	if (KCfg.Get("COLORSPACE_ENABLE")) then
		red, green, blue = Karma_Value2Color("XP", percentage);
	end

	KarmaObj.ProfileStop("Karma_GetColors_XP");

	return red, green, blue;
end

function	Karma_Karma2Color(iKarma)
	return Karma_Value2Color("Karma", iKarma);
end

function	Karma_GetColors_Karma(sMemberName)
	KarmaObj.ProfileStart("Karma_GetColors_Karma");
		-- Calculate the color of the karma bar.
	-- The better the person the greener the karma.
	-- The worse the person the redder the karma.
	local	oMember = Karma_MemberList_GetObject(sMemberName);
	if (oMember == nil) then
		return 1, 1, 1;
	end

	local	iKarma = Karma_MemberObject_GetKarmaModified(oMember);
	iKarma = math.min(iKarma, 100);

	local	red, green, blue = Karma_Karma2Color(iKarma);

	KarmaObj.ProfileStop("Karma_GetColors_Karma");
	return red, green, blue;
end

function	Karma_ClassMToColor(sClassWOGender)
	local	red = 0.8;
	local	green = 0.8;
	local	blue = 0.8;

	-- RAID_CLASS_COLORS: defined in Fonts.xml...
	local	Class = sClassWOGender;
	if (Class) and (Class ~= "") then
		local	Colors = nil;
		if (Class == KARMA_CLASS_DRUID_M) then
			Colors = RAID_CLASS_COLORS["DRUID"];
		end
		if (Class == KARMA_CLASS_HUNTER_M) then
			Colors = RAID_CLASS_COLORS["HUNTER"];
		end
		if (Class == KARMA_CLASS_MAGE_M) then
			Colors = RAID_CLASS_COLORS["MAGE"];
		end
		if (Class == KARMA_CLASS_PALADIN_M) then
			Colors = RAID_CLASS_COLORS["PALADIN"];
		end
		if (Class == KARMA_CLASS_PRIEST_M) then
			Colors = RAID_CLASS_COLORS["PRIEST"];
		end
		if (Class == KARMA_CLASS_ROGUE_M) then
			Colors = RAID_CLASS_COLORS["ROGUE"];
		end
		if (Class == KARMA_CLASS_SHAMAN_M) then
			Colors = RAID_CLASS_COLORS["SHAMAN"];
		end
		if (Class == KARMA_CLASS_WARRIOR_M) then
			Colors = RAID_CLASS_COLORS["WARRIOR"];
		end
		if (Class == KARMA_CLASS_WARLOCK_M) then
			Colors = RAID_CLASS_COLORS["WARLOCK"];
		end
		if (Class == KARMA_CLASS_DEATHKNIGHT_M) then
			Colors = RAID_CLASS_COLORS["DEATHKNIGHT"];
		end
		if (Class == KARMA_CLASS_MONK_M) then
			Colors = RAID_CLASS_COLORS["MONK"];
		end
	
		if (Colors ~= nil) then
			red = Colors.r;
			green = Colors.g;
			blue = Colors.b;
		end
	end

	return red, green, blue;
end

function	Karma_GetColors_Class(sMemberName)
	KarmaObj.ProfileStart("Karma_GetColors_Class");
		-- Calculate the color of the karma bar.
	-- The better the person the greener the karma.
	-- The worse the person the redder the karma.
	local	oMember = Karma_MemberList_GetObject(sMemberName);
	if (oMember == nil) then
		KarmaObj.ProfileStop("Karma_GetColors_Class");
		return 0.8, 0.8, 0.8;
	end

	if (oMember.Meta) then
		KarmaObj.ProfileStop("Karma_GetColors_Class");
		return 0.0, 1.0, 0.0;
	end

	local	sClassWOGender = Karma_MemberObject_GetClassWOGender(oMember);

	KarmaObj.ProfileStop("Karma_GetColors_Class");
	return Karma_ClassMToColor(sClassWOGender);
end

------------------------------------------------------
--		SORTING FUNCTIONS
------------------------------------------------------

-- whoohoo, this one is *actually* used!
function	Karma_MemberSort_CompareName(memname1, memname2)
	if (memname1 == nil) or (memname2 == nil) then
		return false;
	end
	if (memname1 < memname2) then
		return true;
	end
	return false;
end

--
--	this function does a sort based on some numeric field in the
--	oMember. Because we are now using version 4 of the database
--	GetMemberObject is now on par with AlphaBucketSort routine.
--	this sorts into numbered buckets, which always come in order.
--

--	The bucket borders should actually be different for various
--	sort kinds: by time, by xp (absolute), by xp (relative)

--[[
local	LARGE_NUMERIC_SORTING_BUCKETS = {
	 [1] = { max =       0, records = {}},
	 [2] = { max =      50, records = {}},
	 [3] = { max =     150, records = {}},
	 [4] = { max =     450, records = {}},
	 [5] = { max =    1350, records = {}},
	 [6] = { max =    4050, records = {}},
	 [7] = { max =   10000, records = {}},
	 [8] = { max =   20000, records = {}},
	 [9] = { max =   40000, records = {}},
	[10] = { max =   80000, records = {}},
	[11] = { max =  160000, records = {}},
	[12] = { max =  320000, records = {}},
	[13] = { max =  640000, records = {}},
	[14] = { max = 1280000, records = {}},
	[15] = { max = 3000000, records = {}},
	[16] = { max = 9000000, records = {}},
	[17] = { max =      -1, records = {}}
};
]]--

--	Changed to logarithmic.
local	SMALL_NUMERIC_SORTING_BUCKETS;

function	Karma_SortNameValuePairsByValue(table1, cmpfunc)
	-- The following method is Lua's built in sort library sort(table1)
	-- is it? looks just like good old bubble sort...
	local	lo, hi, min, j, iCount
	lo = 1
	hi = getn(table1)
	for iCount = lo, hi do
		-- find smallest 'bubble'...
		min = iCount
		for j = iCount, hi do
			if table1[j].sortvalue < table1[min].sortvalue then
				min = j;
			end
		end

		-- ...and let it 'sink' to lowest spot (or: all larger bubbles 'rise' to higher spots)
		local	temp = table1[min]
		table1[min] = table1[iCount]
		table1[iCount] = temp
	end

	return table1
end

function	Karma_SortNameValuePairsByName(table1, cmpfunc)
	-- The following method is Lua's built in sort library sort(table1)
	-- is it? looks just like good old bubble sort...
	local	lo, hi, min, j, iCount;
	lo = 1
	hi = getn(table1)
	for iCount = lo, hi do
		-- find smallest 'bubble'...
		min = iCount
		for j = iCount, hi do
			-- REVERSE (to compensate for reversal in main loop)
			if table1[j].name > table1[min].name then
				min = j;
			end
		end

		-- ...and let it 'sink' to lowest spot (or: all larger bubbles 'rise' to higher spots)
		local	temp = table1[min]
		table1[min] = table1[iCount]
		table1[iCount] = temp
	end

	return table1;
end

local	SortHelpers = {};

function	SortHelpers.fBucketByMemberCharfieldCurrent(oMember)
	local	oData, bucketname = KarmaObj.DB.MC.Get(oMember, KARMA_CURRENTCHAR);
	if (oData) then
		bucketname = oData[SortHelpers.sBucketByMemberCharfield];
		if (bucketname == nil) then
			bucketname = 0;
		elseif (bucketname > 1) then
			bucketname = math.log(bucketname) * 2;
		else
			bucketname = 0;
		end
	end

	return bucketname;
end

function	SortHelpers.fBucketByMemberCharfieldTotal(oMember)
	local	bucketname = 0;
	local	oChars = oMember[KARMA_DB_L5_RRFFM_CHARACTERS];
	if (type(oChars) == "table") then
		local	oChar, oData;
		for oChar, oData in pairs(oChars) do
			local	iValue = oData[SortHelpers.sBucketByMemberCharfield];
			if (iValue) then
				bucketname = bucketname + iValue;
			end
		end
	end

	if (bucketname > 1) then
		bucketname = math.log(bucketname) * 2;
	else
		bucketname = 0;
	end

	return bucketname;
end

function	SortHelpers.fBucketByJoinedGlobal(oMember, sName, iNow)
	local	bucketname = oMember[KARMA_DB_L5_RRFFM_JOINEDLAST_TIME];
	if (bucketname == nil) then
		bucketname = 0;
	elseif (bucketname > 0) then
		-- more than two years? 94672800 seconds (94672800 = 3 years)
		if (iNow - bucketname > 63072000) then
			bucketname = math.log10(bucketname) - 7;
			if (bucketname < 0.75) then
				bucketname = 0.75;
			end
		else
			bucketname = 24 - (iNow - bucketname) / 86400 / 40;
		end
	end

	return bucketname;
end

function	SortHelpers.fBucketByJoinedThis(oMember, sName, iNow)
	local	bucketname = 0;
	local	charobj = KarmaObj.DB.MC.GetPlayer(oMember);
	if (charobj) then
		bucketname = charobj[KARMA_DB_L6_RRFFMCC_JOINEDLAST];
	end
	if (bucketname == nil) then
		bucketname = 0;
	elseif (bucketname > 0) then
		-- more than two years? 94672800 seconds (94672800 = 3 years)
		if (iNow - bucketname > 63072000) then
			bucketname = math.log10(bucketname) - 7;
			if (bucketname < 0.75) then
				bucketname = 0.75;
			end
		else
			bucketname = 24 - (iNow - bucketname) / 86400 / 40;
		end
	end

	return bucketname;
end

function	SortHelpers.fBucketBySeen(oMember, sName, iNow)
	local	iSeen = oMember[KARMA_DB_L5_RRFFM.LASTSEEN] or 1;
	local	iUpdated = Karma_MemberObject_GetTimestampSuccess(oMember) or 1;
	local	iJoined = oMember[KARMA_DB_L5_RRFFM_JOINEDLAST_TIME] or 1;

	bucketname = math.max(iSeen, math.max(iUpdated, iJoined));

	return math.log(bucketname);
end

function	SortHelpers.fBucketByClass(oMember)
	local	bucketname = nil;
	local	iClassID = oMember[KARMA_DB_L5_RRFFM.CLASS_ID];
	if (iClassID) then
		if (iClassID < 0) then
			iClassID = - iClassID;
		end
		bucketname = KOH.IDToClass(iClassID);
	end

	if (bucketname == nil) or (bucketname == "") then
		bucketname = oMember[KARMA_DB_L5_RRFFM.CLASS];
		if (bucketname == nil) or (bucketname == "") then
			bucketname = "???";
		end
	end

	return bucketname;
end

function	SortHelpers.fBucketByGuild(oMember)
	local	bucketname = oMember[KARMA_DB_L5_RRFFM.GUILD];
	if (bucketname == nil) or (bucketname == "") then
		bucketname = KarmaModuleLocal.Guildless;
	end

	return bucketname;
end

function	SortHelpers.fBucketByTalent(oMember)
	local	bucketname = 0;

	local	iTalents = oMember[KARMA_DB_L5_RRFFM_TALENT];
	if (iTalents == nil) then
		local iClass = oMember[KARMA_DB_L5_RRFFM.CLASS_ID];
		iTalents = KarmaObj.Talents.ClassIDToTalentsDefault(iClass);
	end
	if (iTalents % 2 ~= 0) then
		bucketname = 4;
	elseif (iTalents % 4 ~= 0) then
		bucketname = 3;
	elseif (iTalents % 7 ~= 0) then
		bucketname = 2;
	else
		bucketname = 1;
	end

	return bucketname;
end

function	SortHelpers.fBucketByKarma(oMember, sName)
	local	bucketname = Karma_MemberObject_GetKarmaModified(oMember);
	if (bucketname == nil) then
		KarmaChatDebug("Karma_MemberFieldNumericSort() - <" .. sName .. "> has no Karma?!");
		bucketname = 50;
	elseif (bucketname > 100) then
		bucketname = 100;
	end

	return bucketname;
end

function	Karma_MemberFieldNumericSort(table1, sortfunc)
	local i=0;
	local key, value;
	local result={};
	local buckets={};
	local tempbuckets={};
	local temp = {};
	local index, name;

	local sortfunction;
	if (sortfunc) then
		sortfunction = sortfunc;
	else
		sortfunction = KCfg.Get("SORTFUNCTION");
	end;

	if (KCfg.EqualsIndirect(sortfunction, "SORTFUNCTION_TYPE_NAME")) then
		return table1;
	end;

	-- sort routines
	local	fSort;
	if     (KCfg.EqualsIndirect(sortfunction, "SORTFUNCTION_TYPE_XP")) then
		SortHelpers.sBucketByMemberCharfield = KARMA_DB_L6_RRFFMCC_XP;
		fSort = SortHelpers.fBucketByMemberCharfieldCurrent;
	elseif (KCfg.EqualsIndirect(sortfunction, "SORTFUNCTION_TYPE_XPALL")) then
		SortHelpers.sBucketByMemberCharfield = KARMA_DB_L6_RRFFMCC_XP;
		fSort = SortHelpers.fBucketByMemberCharfieldTotal;
	elseif (KCfg.EqualsIndirect(sortfunction, "SORTFUNCTION_TYPE_PLAYED")) then
		SortHelpers.sBucketByMemberCharfield = KARMA_DB_L6_RRFFMCC_PLAYED;
		fSort = SortHelpers.fBucketByMemberCharfieldCurrent;
	elseif (KCfg.EqualsIndirect(sortfunction, "SORTFUNCTION_TYPE_PLAYEDALL")) then
		SortHelpers.sBucketByMemberCharfield = KARMA_DB_L6_RRFFMCC_PLAYED;
		fSort = SortHelpers.fBucketByMemberCharfieldTotal;

	elseif (KCfg.EqualsIndirect(sortfunction, "SORTFUNCTION_TYPE_JOINED")) then
		fSort = SortHelpers.fBucketByJoinedGlobal;
	elseif (KCfg.EqualsIndirect(sortfunction, "SORTFUNCTION_TYPE_JOINEDTHIS")) then
		fSort = SortHelpers.fBucketByJoinedThis;

	elseif (KCfg.EqualsIndirect(sortfunction, "SORTFUNCTION_TYPE_SEEN")) then
		fSort = SortHelpers.fBucketBySeen;

	elseif (KCfg.EqualsIndirect(sortfunction, "SORTFUNCTION_TYPE_CLASS")) then
		fSort = SortHelpers.fBucketByClass;
	elseif (KCfg.EqualsIndirect(sortfunction, "SORTFUNCTION_TYPE_GUILD_TOP") or
		KCfg.EqualsIndirect(sortfunction, "SORTFUNCTION_TYPE_GUILD_BOTTOM")) then
		fSort = SortHelpers.fBucketByGuild;
	elseif (KCfg.EqualsIndirect(sortfunction, "SORTFUNCTION_TYPE_TALENT")) then
		fSort = SortHelpers.fBucketByTalent;
	elseif (KCfg.EqualsIndirect(sortfunction, "SORTFUNCTION_TYPE_KARMA")) then
		fSort = SortHelpers.fBucketByKarma;
	end

	-- bucket pre-creation
	local	bBucketIsDiscrete = true;					-- buckets are *exakt*
	local	bPostProcessingSimple = true;					-- non-specific flattening-out
	if (KCfg.EqualsIndirect(sortfunction, "SORTFUNCTION_TYPE_KARMA")) then
		for i = 1, 100 do
			buckets[i] = {};
		end
	elseif ((KCfg.EqualsIndirect(sortfunction, "SORTFUNCTION_TYPE_CLASS")) or
		(KCfg.EqualsIndirect(sortfunction, "SORTFUNCTION_TYPE_GUILD_TOP")) or
		(KCfg.EqualsIndirect(sortfunction, "SORTFUNCTION_TYPE_GUILD_BOTTOM"))) then
		-- make buckets on-the-fly ~
		bPostProcessingSimple = false;
	elseif (KCfg.EqualsIndirect(sortfunction, "SORTFUNCTION_TYPE_TALENT")) then
		-- tank, hps, dps, unset
		for i = 1, 4 do
			buckets[i] = {};
		end
	else
		bBucketIsDiscrete = false;
		local	BucketsStatic = SMALL_NUMERIC_SORTING_BUCKETS;
		if (BucketsStatic == nil) then
			SMALL_NUMERIC_SORTING_BUCKETS = {};
			BucketsStatic = SMALL_NUMERIC_SORTING_BUCKETS;
			for i = 1, 49 do
				BucketsStatic[i] = { max = (i - 1) / 2 };
			end
			BucketsStatic[50] = { max = - 1 };
		end

		-- Okay we need to create buckets for the other sort values.
		for i = 1, #BucketsStatic do
			buckets[i] = BucketsStatic[i];
			buckets[i].records = {};
			tempbuckets[i] = {};
		end
	end

	Karma_WhoAmIInit();

	local	iWarnMax, bWarnFunc = 10;
	local	sServer;
	if (type(KARMA_CURRENTLIST) == "string") then
		sServer = KARMA_CURRENTLIST;
	end
	local	iNow, iClassID = time();
	for key, value in pairs(table1) do
		if (value ~= nil  and value~= "") then
			local memberobj = Karma_MemberList_GetObject(value, sServer);
			local bucketname = 0;
			if (memberobj and (memberobj.Meta == nil)) then
				if (fSort) then
					bucketname = fSort(memberobj, value, iNow);
				elseif (not bWarnFunc) then
					bWarnFunc = true;
					KarmaChatSecondaryFallbackDefault("Missing sort function?? Sort routine: " .. sortfunction);
				end

				if (bBucketIsDiscrete) then
					if (bucketname) then
		 				if (buckets[bucketname] == nil) then
		 					buckets[bucketname] = {};
		 				end

						buckets[bucketname][getn(buckets[bucketname]) + 1] = value;
					else
						iWarnMax = iWarnMax - 1;
						if (iWarnMax > 0) then
							KarmaChatDebug("Failed to map " .. KOH.AllToString(value) .. " to a discrete bucket?? Sortfunction is <" .. sortfunction .. ">");
						end
					end
				else
					if (bucketname) then
						for i= 1, getn(buckets) do
							if (bucketname <= buckets[i].max) then
								buckets[i].records[getn(buckets[i].records) + 1] = { name = value, sortvalue = bucketname };
								break;
							elseif (buckets[i].max == -1) then
								buckets[i].records[getn(buckets[i].records) + 1] = { name = value, sortvalue = bucketname };
							end
						end
					else
						iWarnMax = iWarnMax - 1;
						if (iWarnMax > 0) then
							KarmaChatDebug("Failed to map " .. KOH.AllToString(value) .. " to a ranged bucket?? Sortfunction is <" .. sortfunction .. ">");
						end
					end
				end
			end
		end
	end

	if (iWarnMax < 10) then
		KarmaChatSecondaryFallbackDefault("Whoops! Something is quite wrong with the sort routine. :-( Please report this error! Sort routine: " .. sortfunction .. " / " .. (10 - iWarnMax));
	end

	if (bBucketIsDiscrete) then
		tempbuckets = buckets;
	else
		for i = 1, getn(buckets) do
			if (i > 1) then
				Karma_SortNameValuePairsByValue(buckets[i].records);
			else
				-- special case the first bucket is for those you've never gotten any time/exp with.
				Karma_SortNameValuePairsByName(buckets[i].records);
			end

			local x = 0;
			for x = getn(buckets[i].records), 1, -1 do
				tempbuckets[i][getn(tempbuckets[i]) + 1] = buckets[i].records[x].name;
			end
		end

		local	iTotals = 0;
		for i = 1, #buckets do
			iTotals = iTotals + #buckets[i].records;
		end
		if (iTotals > 0) then
		local	sUsage = "numeric distribution sort: total = " .. iTotals .. ", bucket usage = ";
		iTotals = iTotals / #buckets;
		for i = 1, #buckets do
			sUsage = sUsage .. format("%d: %.2f, ", i, #buckets[i].records / iTotals);
		end
		KarmaChatDebug(sUsage);
	end
	end

	-- flatten into one single bucket
	if (bPostProcessingSimple) then
		local	counter = 1;
		for i = 1, getn(tempbuckets) do
			local	index, name;
			for index, name in pairs(tempbuckets[(getn(tempbuckets) + 1) - i]) do
				result[counter] = name;
				counter = counter + 1;
			end
		end
	elseif (KCfg.EqualsIndirect(sortfunction, "SORTFUNCTION_TYPE_CLASS")) then
		local	counter = 1;
		local	class, bucket;
		for class, bucket in pairs(tempbuckets) do
			local index, name;
			for index, name in pairs(bucket) do
				result[counter] = name;
				counter = counter + 1;
			end
		end
	elseif (KCfg.EqualsIndirect(sortfunction, "SORTFUNCTION_TYPE_GUILD_TOP") or
		KCfg.EqualsIndirect(sortfunction, "SORTFUNCTION_TYPE_GUILD_BOTTOM")) then
		local	counter = 1;
		local	oGuilds = {};
		local	guild, bucket;
		for guild, bucket in pairs(tempbuckets) do
			if (guild ~= KarmaModuleLocal.Guildless) then
				tinsert(oGuilds, guild);
			end
		end

		table.sort(oGuilds);

		do
			local	guildobj = Karma_MemberList_GetObject("<" .. KarmaModuleLocal.Guildless .. ">");
			if (guildobj == nil) then
				local	sCmd = "addguild " .. KarmaModuleLocal.Guildless;
				KSlash.CommandHandler(sCmd, true);
				guildobj = Karma_MemberList_GetObject("<" .. KarmaModuleLocal.Guildless .. ">");
			end
			if (not bFiltered and (guildobj ~= nil)) then
				local	bucket = tempbuckets[KarmaModuleLocal.Guildless];
				if (bucket and not KOH.TableIsEmpty(bucket)) then
					guildobj[KARMA_DB_L5_RRFFM.LEVEL] = #bucket;
				end
			end
		end

		if (KCfg.EqualsIndirect(sortfunction, "SORTFUNCTION_TYPE_GUILD_TOP")) then
			local	bucket = tempbuckets[KarmaModuleLocal.Guildless];
			if (bucket and not KOH.TableIsEmpty(bucket)) then
				result[counter] = "<" .. KarmaModuleLocal.Guildless .. ">";
				counter = counter + 1;
				for index, name in pairs(bucket) do
					result[counter] = name;
					counter = counter + 1;
				end
			end
		end

		local	bFiltered = (KARMA_Filter.Total ~= nil) and (strlen(KARMA_Filter.Total) > 0);
		for index, guild in pairs(oGuilds) do
			local	bucket = tempbuckets[guild];
			if (bucket and not KOH.TableIsEmpty(bucket)) then
				result[counter] = "<" .. guild .. ">";
				counter = counter + 1;
				local	conterfrom = counter;
				for index, name in pairs(bucket) do
					result[counter] = name;
					counter = counter + 1;
				end
				local	guildobj = Karma_MemberList_GetObject("<" .. guild .. ">");
				if (guildobj == nil) then
					local	sCmd = "addguild " .. guild;
					KSlash.CommandHandler(sCmd, true);
					guildobj = Karma_MemberList_GetObject("<" .. guild .. ">");
				end
				if (not bFiltered and (guildobj ~= nil)) then
					guildobj[KARMA_DB_L5_RRFFM.LEVEL] = counter - conterfrom;
				end
			end
		end

		if (KCfg.EqualsIndirect(sortfunction, "SORTFUNCTION_TYPE_GUILD_BOTTOM")) then
			local	bucket = tempbuckets[KarmaModuleLocal.Guildless];
			if (bucket and not KOH.TableIsEmpty(bucket)) then
				result[counter] = "<" .. KarmaModuleLocal.Guildless .. ">";
				counter = counter + 1;
				for index, name in pairs(bucket) do
					result[counter] = name;
					counter = counter + 1;
				end
			end
		end
	end

	return result;
end

-----------------------------------------
--	GUI FUNCTIONS
-----------------------------------------

function Karma_UpdateMember(Membername, force)
	-- update info, if online
	if (Membername ~= nil) then
		local fakeargs = {}
		fakeargs[2] = Membername;
		KSlash.Update(fakeargs, 2, force);
	end
end

function Karma_UpdateCurrentMember()
	-- allows to Update random member, if none selected in Karma window
	local fakeargs = {}
	fakeargs[1] = "update";
	fakeargs[2] = KARMA_CURRENTMEMBER;
	KSlash.Update(fakeargs);
end

function	Karma_RemoveMember_Really(Membername)
	if (Membername ~= nil) then
		local fakeargs = {}
		fakeargs[2] = Membername;
		KSlash.Rem(fakeargs);
	end
end

function	Karma_RemoveMember(Membername)
	-- update info, if online
	if (Membername ~= nil) and (Membername ~= "") then
		local DoIt = true;
		local	i, iMax, sBase;

		if (Karma_PlayerIsInRaid()) then
			iMax = GfTt.GetNumRaidMembersTf();
			sBase = "raid";
		else
			iMax = GfTt.GetNumPartyMembersTf();
			sBase = "party";
		end
		for i = 1, iMax do
			local	sGroupName, sGroupServer = UnitName(sBase .. i);
			if (sGroupServer and (sGroupServer ~= "")) then
				sGroupName = sGroupName .. "@" .. sGroupServer;
			end
			if (strupper(Membername) == strupper(sGroupName)) then
				KarmaChatDefault(KARMA_MSG_CANNOT_PRE .. KARMA_MSG_REMOVE_ISINGROUP1 .. KARMA_MSG_CANNOT_POST .. " >" .. Membername .. "<" .. KARMA_MSG_REMOVE_ISINGROUP2);
				DoIt = false;
			end
		end

		if DoIt then
			Karma_DialogBox_Text:SetText(KARMA_WINEL_REMOVE_QUESTION_TEXT_PRE .. Membername .. KARMA_WINEL_REMOVE_QUESTION_TEXT_POST);
			Karma_DialogBox_ButtonLeft:SetText(KARMA_WINEL_REMOVE_QUESTION_BTN_EXECUTE);
			Karma_DialogBox_ButtonRight:SetText(KARMA_WINEL_REMOVE_QUESTION_BTN_CANCEL);

			Karma_DialogBox.CallbackLeft_func = Karma_RemoveMember_Really;
			Karma_DialogBox.CallbackLeft_arg1 = Membername;
			Karma_DialogBox:SetAlpha(1.0);
			Karma_DialogBox:Show();

			-- to be closeable by ESC...
			tinsert(UISpecialFrames, Karma_DialogBox:GetName());
		end
	end
end

function	Karma_ToggleWindow()
	if (KARMA_LOADED ~= 1) then
		DEFAULT_CHAT_FRAME:AddMessage("Karma: Oops! Not fully initialized (yet), request to open a window ignored.", 1, 0, 0);
	else
		KARMA_MAINWND_KEEPOPEN = false;
		if ( KarmaWindow:IsVisible() ) then
			KarmaWindow:Hide();
		else
			Karma_CreateQuestCache(1);

			KarmaWindow:Show();
			KarmaWindow_DressUp();
			KarmaWindow_Update();
		end
	end
end

function	KarmaWindowKeyUp(index)
	Karma_ToggleWindow();
end

function	Karma_ToggleWindow2()
	if (KARMA_LOADED ~= 1) then
		DEFAULT_CHAT_FRAME:AddMessage("Karma: Oops! Not fully initialized (yet), request to open a window ignored.", 1, 0, 0);
	else
		local	sCmdName = "toggle LFM window";
		if (KarmaObj.LFM) then
			KarmaObj.LFM.WindowToggle();
		else
			local	name, title, notes, enabled, loadable, reason = GetAddOnInfo("KarmaLFM");
			if (not enabled) then
				KarmaChatDefault("Can't show LFM window: |cFFFF8080module disabled.|r");
			elseif (not loadable) then
				if (reason == "MISSING") then
					KarmaChatSecondaryFallbackDefault("Can't show LFM window: |cFF8080FFmodule not installed.|r");
				else
					KarmaChatSecondaryFallbackDefault("Can't show LFM window: |cFFFF4040module can't be loaded.|r (" .. tostring(reason) .. ")");
				end
			else
				KarmaChatSecondaryFallbackDefault("Trying to load LFM module...");
				local	iLoaded, sWhyNot = LoadAddOn("KarmaLFM");
				if (iLoaded) then
					if (KarmaObj.LFM) then
						KarmaObj.LFM.WindowToggle();
					else
						KarmaChatSecondaryFallbackDefault("Failed to initialize LFM module!");
					end
				else
					KarmaChatSecondaryFallbackDefault("Failed to load LFM module: " .. sWhyNot);
				end
			end
		end
	end
end

function	KarmaWindow2KeyUp(index)
	Karma_ToggleWindow2();
end

local	KarmaWindow_FirstOpen = true;

function	KarmaWindow_DressUp()
	KarmaObj.ProfileStart("KarmaWindowDressUp");
	KarmaWindow_Title:SetText(KARMA_TITLE .. KARMA_WINEL_FRAG_SPACE .. "v" .. KARMA_VERSION_TEXT);

	if KarmaWindow_FirstOpen then
		KarmaWindow_FirstOpen = false;
		local	i = KCfg.Get("MAINWND_INITIALTAB");
		if (i) then
			KarmaWindow_SelectTab(i);
		end
	end

	KarmaObj.ProfileStop("KarmaWindowDressUp");
end

--
--	this function should always be safe to call.
--
function	KarmaWindow_Update(force)
	if Karma_EverythingLoaded() then
		if (KarmaWindow:IsVisible() or force) then
			KarmaWindow_UpdateCurrentMember();
			KarmaWindow_UpdateKarmaBar();
			KarmaWindow_UpdateRegionList();
			KarmaWindow_UpdateZoneList();
			KarmaWindow_UpdateQuestList();
			KarmaWindow_UpdateAchievementList();
			KarmaWindow_UpdateMemberList();
			KarmaWindow_UpdatePartyList();
			KarmaWindow_UpdateAltList();
		end

		Karma_AdjustPartyMemberNameColors();
		Karma_UpdateCurrentTargetNameColor();
	end
end

--
--	Handler for clicks in the partylist
--
function	KarmaWindow_PartyList_OnClick(oButton, sMousebutton)
	KarmaObj.ProfileStart("KarmaWindow_PartyList_OnClick")

	local	id = oButton:GetID();
	local	oButtonText = getglobal("PartyList_GlobalButton"..id.."_Text");
	local	sText = oButtonText:GetText();
	if (sText ~= nil) and (sText ~= "") then
		if (sMousebutton == "LeftButton") then
			if (IsShiftKeyDown()) then
				if (DEFAULT_CHAT_FRAME) and not DEFAULT_CHAT_FRAME.editBox:IsShown() then
					ChatFrame_SendTell(sText);
				end
			else
				Karma_SetCurrentMember(sText);
				KarmaWindow_ScrollToCurrentMember();
			end
		elseif (sMousebutton == "RightButton") then
			local	oMember = Karma_MemberList_GetObject(sText);
			if (oMember) then
				if	(oMember[KARMA_DB_L5_RRFFM_CONFLICT] ~= nil) and
					(oMember[KARMA_DB_L5_RRFFM_CONFLICT].Resolved == 0) then

					Karma_MemberConflict_Menu.Caller = oButton:GetName();
					Karma_MemberConflict_Menu.Member = sText;
					ToggleDropDownMenu(1, nil, Karma_MemberConflict_Menu, oButton, 0, 0);
				end
			end
		end
	end

	KarmaObj.ProfileStop("KarmaWindow_PartyList_OnClick")
end

--
--	Handler for right-clicks in the member list
--
local	MemberlistClickedBtn = nil;
local	MemberlistClickedBtnText = nil;
local	MemberlistClickedName = nil;

local KARMA_MEMBERLIST_MENU_DROPDOWN = {
	[ 1] = {sName = KARMA_WINEL_INVITEBUTTON,      iCommand = 100, bSameServer = 1},
	[ 2] = {sName = KARMA_WINEL_NEWFORCEBUTTON,    iCommand = 700, bOnConflict = 1},
	[ 3] = {sName = KARMA_WINEL_UPDATEFORCEBUTTON, iCommand = 800, bOnConflict = 1},
	[ 4] = {sName = KARMA_WINEL_UPDATEBUTTON,      iCommand = 200, bSameServer = 1},
	[ 5] = {sName = KARMA_WINEL_REMOVEBUTTON,      iCommand = 300},
	[ 6] = {sName = KARMA_WINEL_ALTADDBUTTON,      iCommand = 400, bNotOnCurrMemberClicked = 1, bAddCurrentMember = 1},
	[ 7] = {sName = KARMA_WINEL_ALTREMBUTTON,      iCommand = 500},
	[ 8] = {sName = KARMA_WINEL_ML_FRIENDADD,      iCommand = 1000, bSameServer = 1},
	[ 9] = {sName = KARMA_WINEL_ML_IGNOREADD,      iCommand = 1010},
	[10] = {sName = KARMA_WINEL_POSTTOMEMBER,      iCommand = 600, bNotOnCurrMemberClicked = 1, bAddCurrentMember = 1},
	[11] = {sName = KARMA_WINEL_UNSELECT,          iCommand = 350},
	[12] = {sName = KARMA_WINEL_CANCEL,            iCommand = 375},
};

function	Karma_MemberlistMenu_Initialize()
	KarmaObj.ProfileStart("Karma_MemberlistMenu_Initialize")

	if (MemberlistClickedName ~= nil) and (MemberlistClickedName ~= KARMA_UNKNOWN) then
		local	iAt = strfind(MemberlistClickedName, "@", 1, true);
		local	bSameServer = (iAt == nil) and (type(KARMA_CURRENTLIST) ~= "string");

		local	info;
		info = {};
		info.text = KARMA_WINEL_TITLE .. KARMA_WINEL_FRAG_COLONSPACE .. MemberlistClickedName;
		info.isTitle = 1;
		info.notCheckable = 1;
		UIDropDownMenu_AddButton(info);

		local	oMember = Karma_MemberList_GetObject(MemberlistClickedName);
		local	bConflict = false;
		if (oMember ~= nil) and (oMember[KARMA_DB_L5_RRFFM_CONFLICT] ~= nil) then
			bConflict = true;
		end
		local	bIsCurrentMember = false;
		if (KARMA_CURRENTMEMBER) and (MemberlistClickedName ~= KARMA_CURRENTMEMBER) then
			bIsCurrentMember = true;
		end

		info = {};
		for i = 1, getn(KARMA_MEMBERLIST_MENU_DROPDOWN) do
			if  (
					(bSameServer or (KARMA_MEMBERLIST_MENU_DROPDOWN[i].bSameServer ~= 1))
				and
					(bIsCurrentMember or (KARMA_MEMBERLIST_MENU_DROPDOWN[i].bNotOnCurrMemberClicked ~= 1))
				and
					(bConflict or (KARMA_MEMBERLIST_MENU_DROPDOWN[i].bOnConflict ~= 1))
				) then

				if (KARMA_MEMBERLIST_MENU_DROPDOWN[i].bAddCurrentMember == 1) then
					info.text = KARMA_MEMBERLIST_MENU_DROPDOWN[i].sName .. Karma_NilToString(KARMA_CURRENTMEMBER);
				else
					info.text = KARMA_MEMBERLIST_MENU_DROPDOWN[i].sName;
				end
				info.notCheckable = 1;

				info.func = Karma_MemberlistMenu_OnSelect;
				info.arg1 = KARMA_MEMBERLIST_MENU_DROPDOWN[i].iCommand;
				info.arg2 = MemberlistClickedName;
	
				UIDropDownMenu_AddButton(info);
			end
		end
	end

	KarmaObj.ProfileStop("Karma_MemberlistMenu_Initialize")
end

function	Karma_MemberlistMenu_OnSelect(self, arg1, arg2)
	KarmaObj.ProfileStart("Karma_MemberlistMenu_OnSelect")

	local	oMember = Karma_MemberList_GetObject(arg2);
	if (oMember ~= nil) then
		if (arg1 == 100) then
			 InviteUnit(arg2);
		elseif (arg1 == 200) then
			Karma_UpdateMember(arg2);
		elseif (arg1 == 300) then
			Karma_RemoveMember(arg2);
		elseif (arg1 == 350) then
			Karma_SetCurrentMember();
		elseif (arg1 == 375) then
			CloseDropDownMenus();
		elseif (arg1 == 400) and (KARMA_CURRENTMEMBER) and (arg2 ~= KARMA_CURRENTMEMBER) then
			local	args = {};
			args[2] = arg2;
			args[3] = KARMA_CURRENTMEMBER;
			KSlash.AltAdd(args);
		elseif (arg1 == 500) then
			local	args = {};
			args[2] = arg2;
			KSlash.AltRemove(args);
		elseif (arg1 == 600) then
			if (DEFAULT_CHAT_FRAME) and not DEFAULT_CHAT_FRAME.editBox:IsShown() then
				Karma_CurrentMember_PostToChat(arg2);
			end
		elseif (arg1 == 700) then
			local	args = {};
			args[2] = arg2;
			Karma_MemberForceNew(args);
		elseif (arg1 == 800) then
			local	args = {};
			args[2] = arg2;
			Karma_MemberForceUpdate(args);
		elseif (arg1 == 1000) then
			local	sName = arg2;
			KarmaChatDefault("Trying to toggle status on friend list for: <" .. sName .. ">");
			AddOrRemoveFriend(sName);
		elseif (arg1 == 1010) then
			local	sName = arg2;
			local	iAt = strfind(sName, "@", 1, true);
			if (iAt) then
				sName = strsub(sName, 1, iAt - 1) .. "-" .. strsub(sName, iAt + 1);
			elseif (type(KARMA_CURRENTLIST) == "string") then
				sName = sName .. "-" .. KARMA_CURRENTLIST;
			end
			local	iAt = strfind(sName, "-", 1, true);
			if (iAt) then
				-- buggy Blizzard implementation auto-removes spaces in server names on add, but not on del
				sName = strsub(sName, 1, iAt) .. string.gsub(strsub(sName, iAt + 1), " ", "");
			end
			KarmaChatDefault("Trying to toggle status on ignore list for: <" .. sName .. ">");
			AddOrDelIgnore(sName);
		end
	end

	KarmaObj.ProfileStop("Karma_MemberlistMenu_OnSelect")
end

--
--	Handler for right-clicks in the memberlist for non-members (= Mouseover-List)
--
local	XFactionClickedBtn = nil;
local	XFactionClickedName = nil;

local KARMA_XFACTION_MENU_DROPDOWN = {
	[1] = {sName = KARMA_UNITPOPUP_CHARADD,			iCommand = 1000, bSameFaction = true	},
	[2] = {sName = KARMA_UNITPOPUP_PUBNOTE_CHECKGUILD,	iCommand = 1100, bSameFaction = true	},
	[3] = {sName = KARMA_UNITPOPUP_PUBNOTE_CHECKCHANNEL,	iCommand = 1150, bSameFaction = true	},
	[4] = {sName = KARMA_XFACTION_MENU_CHARADD,		iCommand = 1200, bSameFaction = false	},
	[5] = {sName = KARMA_XFACTION_MENU_CHARNOTE,		iCommand = 1300, bSameFaction = false	},
	[6] = {sName = KARMA_XFACTION_MENU_CHARCHECK,		iCommand = 1400, bSameFaction = false	},
};

function	Karma_XFactionMenu_Initialize()
	KarmaObj.ProfileStart("XFactionMenu_Initialize")

	if ((MemberlistClickedBtn ~= nil) and
	    (MemberlistClickedName ~= nil) and (MemberlistClickedName ~= KARMA_UNKNOWN)) then
		local	bSameFaction = false;
		if ((MemberlistClickedBtn.KarmaMouseoverIndex ~= nil) and (MemberlistClickedBtn.KarmaMouseoverGUID ~= nil)) then
			local	oMouseover = KarmaModuleLocal.MouseOverKeepList[MemberlistClickedBtn.KarmaMouseoverIndex];
			if ((oMouseover ~= nil) and (oMouseover.GUID == MemberlistClickedBtn.KarmaMouseoverGUID)) then
				bSameFaction = oMouseover.Faction == UnitFactionGroup("player");
			else
				KarmaChatDebug("KW_ML_OC: oMouseover nil or GUID mismatch");
				return
			end
		else
			KarmaChatDebug("KW_ML_OC: MemberlistClickedBtn Index or GUID unset");
			return
		end

		local	info;
		info = {};
		info.text = KARMA_WINEL_TITLE .. KARMA_WINEL_FRAG_COLONSPACE .. MemberlistClickedName;
		info.isTitle = 1;
		info.notCheckable = 1;
		UIDropDownMenu_AddButton(info);

		info.text = "Operates in " .. KARMA_ITSELF .. "'s data or holding space";
		info.isTitle = 0;
		info.notCheckable = 1;
		UIDropDownMenu_AddButton(info);

		info = {};
		for i = 1, getn(KARMA_XFACTION_MENU_DROPDOWN) do
			if  (bSameFaction == KARMA_XFACTION_MENU_DROPDOWN[i].bSameFaction) then
				info.text = KARMA_XFACTION_MENU_DROPDOWN[i].sName;
				info.notCheckable = 1;

				info.func = Karma_XFactionMenu_OnSelect;
				info.arg1 = KARMA_XFACTION_MENU_DROPDOWN[i].iCommand;
				info.arg2 = MemberlistClickedName;

				UIDropDownMenu_AddButton(info);
			end
		end
	end

	KarmaObj.ProfileStop("Karma_XFactionMenu_Initialize")
end

function	Karma_XFactionMenu_OnSelect(self, arg1, arg2)
	KarmaObj.ProfileStart("Karma_XFactionMenu_OnSelect")

	if (arg1 == 1000) then
		local	args = {};
		args[2] = arg2;
		KSlash.Add(args);
	elseif (arg1 == 1100) then
		local	args = {};
		args[2] = "$GUILD";
		args[3] = arg2;
		KSlash.ShareQuery(args, 3);
	elseif (arg1 == 1150) then
		local	args = {};
		args[2] = "#";
		args[3] = arg2;
		KSlash.ShareQuery(args, 3);
	elseif (arg1 == 1200) then
		local	args = {};
		args[2] = arg2;
		args[3] = "+0";
		args[4] = "+" .. date(KARMA_DATEFORMAT .. " %H:%M:%S", time()) .. " <added from cross-faction mouseover>";
		Karma_CrossFactionNote(args);
	elseif (arg1 == 1300) then
		local	sText = KarmaWindow_Filter_EditBox:GetText();
		if ((sText ~= nil) and (sText ~= "")) then
			local	args = {};
			args[2] = arg2;
			args[3] = "+0";
			args[4] = "+" .. date(KARMA_DATEFORMAT .. " %H:%M:%S", time()) .. " <added from cross-faction mouseover>: " .. sText;
			Karma_CrossFactionNote(args);
		else
			KarmaChatDefault("Enter the corresponding note into the filter editbox at the bottom first!");
		end
	elseif (arg1 == 1400) then
		local	args = {};
		args[2] = arg2;
		Karma_CrossFactionInfo(args);
	end


	KarmaObj.ProfileStop("Karma_XFactionMenu_OnSelect")
end

--
--- clicks on memberlist/...
--
function	KarmaWindow_MemberList_OnClick(buttonobject, mousebutton)
	KarmaObj.ProfileStart("KarmaWindow_MemberList_OnClick")

	local	id = buttonobject:GetID();
	MemberlistClickedBtn = getglobal("MemberList_GlobalButton" .. id);
	MemberlistClickedBtnText = getglobal("MemberList_GlobalButton" .. id .. "_Text");
	MemberlistClickedName = MemberlistClickedBtnText:GetText();

	KarmaChatDebug(mousebutton .. " on " .. Karma_NilToString(MemberlistClickedName));

	Karma_WhoAmIInit();
	if ((MemberlistClickedName == WhoAmI) or (MemberlistClickedName == nil) or
	    (MemberlistClickedName == KARMA_UNKNOWN) or (MemberlistClickedName == KARMA_UNKNOWN_ENT)) then
		return
	end

	if (strsub(MemberlistClickedName, 1, 3) == "-- ") then
		-- date separators
		return
	end

	local	iAt = strfind(MemberlistClickedName, "@", 1, true);
	local	bSameServer = iAt == nil;

	local	bSameFaction = true;
	if (KARMA_CURRENTLIST == 3) then
		bSameFaction = false;
		if ((buttonobject ~= nil) and (buttonobject.KarmaMouseoverIndex ~= nil) and (buttonobject.KarmaMouseoverGUID ~= nil)) then
			local	oMouseover = KarmaModuleLocal.MouseOverKeepList[buttonobject.KarmaMouseoverIndex];
			if ((oMouseover ~= nil) and (oMouseover.GUID == buttonobject.KarmaMouseoverGUID)) then
				bSameFaction = oMouseover.Faction == UnitFactionGroup("player");
			else
				KarmaChatDebug("KW_ML_OC: oMouseover nil or GUID mismatch");
			end
		else
			KarmaChatDebug("KW_ML_OC: buttonobject or Index or GUID is nil");
		end
	end

	local	bFailFaction = false;
	local	bFailServer = false;
	if (mousebutton == "LeftButton") then
		if (IsShiftKeyDown()) then
			if (DEFAULT_CHAT_FRAME) and not DEFAULT_CHAT_FRAME.editBox:IsShown() then
				if (bSameServer) then
					ChatFrame_SendTell(MemberlistClickedName, nil);
				else
					local	sTarget = strsub(MemberlistClickedName, 1, iAt - 1) .. "-" .. strsub(MemberlistClickedName, iAt + 1);
					ChatFrame_SendTell(sTarget, nil);
				end
			end
		else
			if (buttonobject.NameServer) then
				Karma_SetCurrentMember(MemberlistClickedName);
				if (KARMA_CURRENTMEMBER) then
					KarmaChatDebug("KARMA_CURRENTMEMBER -> "..KARMA_CURRENTMEMBER);
				end
			else
				bFailFaction = true;
			end
		end
	end

	if (mousebutton == "MiddleButton") then
		if (buttonobject.NameServer) then
			if (bSameServer) then
				Karma_UpdateMember(MemberlistClickedName);
			else
				bFailServer = true;
			end
		else
			bFailFaction = true;
		end
	end

	if (mousebutton == "RightButton") then
		if ((KARMA_CURRENTLIST == 3) and (not buttonobject.NameServer)) then
			GameTooltip:Hide();
			ToggleDropDownMenu(1, nil, Karma_XFactionMenu, MemberlistClickedBtn, 0, 0);
		else
			GameTooltip:Hide();
			ToggleDropDownMenu(1, nil, Karma_MemberlistMenu, MemberlistClickedBtn, 0, 0);
		end
	end

	if (bFailFaction) then
		KarmaChatDefault("This player is either not on " .. KARMA_ITSELF .. "'s list or on the other faction. You can not select or update it. (Shift-clicking or right-clicking are possible...)");
	end
	if (bFailServer) then
		KarmaChatDefault("This player is on another server. You can not update it. (Shift-clicking or right-clicking are possible...)");
	end

	KarmaObj.ProfileStop("KarmaWindow_MemberList_OnClick")
end

function	Karma_CurrentMemberValid()
	if (KARMA_CURRENTMEMBER) and (KARMA_CURRENTMEMBER ~= "") then
		return true;
	else
		return false;
	end
end

function	Karma_SetCurrentMember(sName)
	KarmaWindow_CharSelection_DropDown:Hide();

	if (KARMA_CURRENTMEMBER) then
		KarmaChatDebug("KARMA_CURRENTMEMBER: " .. KARMA_CURRENTMEMBER .. " -> <nil>");

		KARMA_CURRENTMEMBER = nil;
		KarmaWindow_Update(true);
		KarmaWindow_NotesInitializeText();
	end

	if (sName) and (sName ~= "") then
		if (type(KARMA_CURRENTLIST) == "string") then
			sName = sName .. "@" .. KARMA_CURRENTLIST;
		end

		local	oMember = Karma_MemberList_GetObject(sName);
		if (oMember) then
			KarmaChatDebug("KARMA_CURRENTMEMBER: <nil> -> " .. sName);

			KARMA_CURRENTMEMBER = sName;

			KarmaWindow_Update(true);
			KarmaWindow_NotesInitializeText();
		end
	end

	if (KARMA_SELECTEDTAB == 1) then
		KarmaWindow_CharSelection_DropDown:Show();
	end
end

function	KarmaWindow_Memberlist_GetCurrent()
	local	MemberNames, sMemberName;
	if ((type(KARMA_CURRENTLIST) == "string") or (KARMA_CURRENTLIST == 1)) then
		MemberNames = Karma_MemberList_GetMemberNamesSortedCustom();
	elseif ((KARMA_CURRENTLIST == 2) and (KCfg.Get("RAID_TRACKALL") == 1)) then
		MemberNames = {};
		local	Dummy;
		for sMemberName, Dummy in pairs(KARMA_PartyNames) do
			tinsert(MemberNames, sMemberName);
		end
	elseif (KARMA_CURRENTLIST == 3) then
		MemberNames = {};
		GUID2Index = {};
		local	iKey, oMouseOver;
		for iKey, oMouseOver in pairs(KarmaModuleLocal.MouseOverKeepList) do
			GUID2Index[oMouseOver.GUID] = iKey;
			tinsert(MemberNames, oMouseOver.GUID);
		end
	elseif (KARMA_CURRENTLIST == 4) then
		MemberNames = {};
		local	sRealm = KarmaObj.DB.ServerName();
		local	iNow = time();
		local	iNowDay, iAtOld = (iNow - iNow % 86400) / 86400;
		local	lMRU, iIx, oData = KarmaObj.DB.SF.RecentlyJoinedGet();
		for iIx = #lMRU, 1, -1 do
			local	oData = lMRU[iIx];
			if (oData.iAt == nil) then
				oData.iAt = 0;
			end

			local	iDelta;
			if (not iAtOld) then
				local	iAtDay = (oData.iAt - oData.iAt % 86400) / 86400;

				iDelta = iNowDay - iAtDay;
				iAtOld = oData.iAt - oData.iAt % 86400;
			elseif (oData.iAt < iAtOld) then
				local	iAtDay = (oData.iAt - oData.iAt % 86400) / 86400;

				iDelta = iNowDay - iAtDay;
				iAtOld = oData.iAt - oData.iAt % 86400;
			end

			if (iDelta) then
				if (iDelta == 0) then
					tinsert(MemberNames, "-- today -- ");
				elseif (iDelta == 1) then
					tinsert(MemberNames, "-- yesterday -- ");
				elseif (iDelta < 2 * 30) then
					tinsert(MemberNames, "-- " .. iDelta .. " days ago -- ");
				else
					local	iMonths = math.floor(iDelta / 30);
					tinsert(MemberNames, "-- over " .. iMonths .. " months ago -- ");
				end
			end

			if (oData.sServerFrom == sRealm) then
				tinsert(MemberNames, oData.sPlayer);
			else
				tinsert(MemberNames, oData.sPlayer .. '@' .. oData.sServerFrom);
			end
		end
	elseif (KARMA_CURRENTLIST < 0) then
		local	iKey, iCount = - KARMA_CURRENTLIST, 0;
		if (type(KarmaModuleLocal.Raid.HistoryTables[iKey]) == "table") then
			local	oHistory = KarmaModuleLocal.Raid.HistoryTables[iKey];
			MemberNames = {};
			for sMembername, Dummy in pairs(oHistory) do
				if ((sMembername ~= "__Start") and (sMembername ~= "__End") and (sMembername ~= "__Instance") and (sMembername ~= WhoAmI)) then
					iCount = iCount + 1;
					tinsert(MemberNames, sMembername);
				end
			end
		end
		KarmaChatDebug("History #" .. iKey .. ": " .. iCount .. " players.");
	end

	return MemberNames;
end

-- Scrolls to the current member in the members list.
-- this is not done every update. this is just so that the
-- current member is always visible when certain operations
-- have been done. Namely increases and decreases in the
-- karma value.
function	KarmaWindow_ScrollToCurrentMember()
	if (not Karma_CurrentMemberValid()) then
		KarmaChatDebug("Scroll: Noone selected.");
		return false;
	end

	local	MemberNames = KarmaWindow_Memberlist_GetCurrent();
	if (MemberNames == nil) then
		KarmaChatDebug("Scroll: Invalid base set.");
		return false;
	end

	local	i, iKey, iNumEntries, iIndex = 0;
	for iKey, sMemberName in pairs(MemberNames) do
		i = i + 1;
		if (sMemberName == KARMA_CURRENTMEMBER) then
			iIndex = i;
		end
	end
	iNumEntries = i;
	KarmaChatDebug("Scroll: " .. KARMA_CURRENTMEMBER .. " = " .. Karma_NilToString(iIndex) .. "/" .. iNumEntries);

	if ((iNumEntries  <= 25) or (iIndex == nil)) then
		FauxScrollFrame_SetOffset(KarmaWindow_MemberList_ScrollFrame, 0);
		KarmaWindow_MemberList_ScrollFrameScrollBar:SetValue(0);
		return (iIndex ~= nil);
	end

	if (iIndex <= 25) then
		FauxScrollFrame_SetOffset(KarmaWindow_MemberList_ScrollFrame, 0);
		KarmaWindow_MemberList_ScrollFrameScrollBar:SetValue(0);
	else
		KarmaChatDebug("KW_S2CM: iIndex = " .. iIndex);
		KarmaWindow_MemberList_ScrollFrameScrollBar:SetValue((iIndex - 1) * 13);
		FauxScrollFrame_SetOffset(KarmaWindow_MemberList_ScrollFrame, iIndex - 1);
	end

	return true;
end

function	KarmaWindow_UpdatePartyList()
	KarmaObj.ProfileStart("KarmaWindow_UpdatePartyList");
	local	lMembers, button, i, iNumEntries
	local	sMembername, sServername;
	local	oMember;
	local	red, green, blue, iKarma, bModified, sKarma;

	iNumEntries = GfTt.GetNumPartyMembersTf();

	-- clear all buttons from current values:
	for i = 1, 4 do
		local	karmavaluetext = getglobal("PartyList_KarmaValue"..i.."_Text");
		karmavaluetext:SetText("");

		local	buttontext = getglobal("PartyList_GlobalButton"..i.."_Text");
		buttontext:SetText("");

		local	button = getglobal("PartyList_GlobalButton"..i);
		button:UnlockHighlight();
	end

	if (Karma_PlayerIsInRaid()) and
	   (KCfg.Get("RAID_NOGROUP") == 1) then
		local	buttontext = getglobal("PartyList_GlobalButton2_Text");
		buttontext:SetText("-= RAID MODE =-");
		return
	end

	for i = 1, iNumEntries do
		sMembername, sServername = UnitName("party"..i);
		if (sServername) and (sServername ~= "") then
			sMembername = sMembername .. "@" .. sServername;
		end;

		local	button = getglobal("PartyList_GlobalButton"..i);
		local	buttontext = getglobal("PartyList_GlobalButton"..i.."_Text");
		buttontext:SetText(sMembername);
		if (sMembername == KARMA_CURRENTMEMBER) then
			button:LockHighlight();
		end;

		red, green, blue = Karma_MemberList_GetColors(sMembername);
		buttontext:SetTextColor(red, green, blue);

		local	karmavaluetext = getglobal("PartyList_KarmaValue"..i.."_Text");
		local	oMember = Karma_MemberList_GetObject(sMembername);
		if (oMember) then
			iKarma, bModified = Karma_MemberObject_GetKarmaModified(oMember);
			if (iKarma >= 100) then
				sKarma = "++";
			else
				sKarma = iKarma;
			end
			if (bModified) then
				sKarma = "*" .. sKarma;
			end
			karmavaluetext:SetText(sKarma);
		end

		red, green, blue = Karma_GetColors_Karma(sMembername);
		karmavaluetext:SetTextColor(red, green, blue);

		if (oMember) then
			if	(type(oMember[KARMA_DB_L5_RRFFM_CONFLICT]) == "table") and
				(oMember[KARMA_DB_L5_RRFFM_CONFLICT].Resolved == 0) then
				karmavaluetext:SetText("CF!");
				karmavaluetext:SetTextColor(1, 0, 0);
			end
		end
	end

	KarmaObj.ProfileStop("KarmaWindow_UpdatePartyList");
end

function	KarmaWindow_UpdateMemberList()
	KarmaObj.ProfileStart("KarmaWindowUpdateMemberList");

	-- clear all buttons from current values:
	local	i;
	for i = 1, KARMA_MEMBERLIST_SIZE do
		local	karmavaluetext = getglobal("MemberList_KarmaValue"..i.."_Text");
		karmavaluetext:SetText("");

		local	buttontext = getglobal("MemberList_GlobalButton"..i.."_Text");
		buttontext:SetText("");

		local	button = getglobal("MemberList_GlobalButton"..i);
		button:UnlockHighlight();

		button.KarmaMouseoverIndex = nil;
		button.KarmaMouseoverGUID  = nil;
		button.NameServer = nil;
	end

	local	Dummy, sMembername, sMyFaction;
	sMyFaction = UnitFactionGroup("player");
	Karma_WhoAmIInit();

	local	MemberNames, sServer = KarmaWindow_Memberlist_GetCurrent();
	if (MemberNames == nil) then
		return
	end

	if (type(KARMA_CURRENTLIST) == "string") then
		sServer = KARMA_CURRENTLIST; 
	end

	i = 0;
	for Dummy, sMembername in pairs(MemberNames) do
		i = i + 1;
	end
	local	iNumEntries = i;

	local	iCounter = 1;
	local	nindex = 1;
	for Dummy, sMembername in pairs(MemberNames) do
		--search the index of the array for the current users name
		if (nindex - FauxScrollFrame_GetOffset(KarmaWindow_MemberList_ScrollFrame)  >= 0) then
			if (iCounter <= KARMA_MEMBERLIST_SIZE) then
				local	iKey, oMouseover;
				if (KARMA_CURRENTLIST == 3) then
					iKey = GUID2Index[sMembername];
					if (iKey and (KarmaModuleLocal.MouseOverKeepList[iKey]) and (KarmaModuleLocal.MouseOverKeepList[iKey].GUID == sMembername)) then
						oMouseover = KarmaModuleLocal.MouseOverKeepList[iKey];
						sMembername = oMouseover.Name;
					else
						iKey = nil;
						sMembername = nil;
					end
				end

				local	buttontext = getglobal("MemberList_GlobalButton"..iCounter.."_Text");
				buttontext:SetTextColor(0.75, 0.75, 0.75);
				local	button = getglobal("MemberList_GlobalButton"..iCounter);
				local	karmavaluetext = getglobal("MemberList_KarmaValue"..iCounter.."_Text");

				button.KarmaMouseoverIndex = iKey;
				button.KarmaMouseoverGUID  = nil;

				if (sMembername) then
					buttontext:SetText(sMembername);
					if (sMembername .. (not sServer and "" or ("@" .. sServer)) == KARMA_CURRENTMEMBER) then
						button:LockHighlight();
					end

					local	oMember = Karma_MemberList_GetObject(sMembername, sServer);
					if (oMember) then
						button.NameServer = sMembername;
						if (sServer) then
							button.NameServer = sMembername .. "@" .. sServer;
						end

						local	iKarma, bModified, sKarma, red, green, blue;
						iKarma, bModified = Karma_MemberObject_GetKarmaModified(oMember);
						red, green, blue = Karma_MemberList_GetColors(button.NameServer);
						buttontext:SetTextColor(red, green, blue);

						red, green, blue = Karma_GetColors_Karma(button.NameServer);

						if (iKarma >= 100) then
							sKarma = "++";
						else
							sKarma = iKarma;
						end
						if (bModified) then
							sKarma = "*" .. sKarma;
						end
						karmavaluetext:SetText(sKarma);
						karmavaluetext:SetTextColor(red, green, blue);
					end
				end

				if (oMouseover ~= nil) then
					if (not button.NameServer) then
--[[
		Value.GUID = UnitGUID("mouseover");
		Value.Faction = UnitFactionGroup("mouseover");
		Value.Name = UnitName("mouseover");
		Value.Race = UnitRace("mouseover");
		Value.Level = UnitLevel("mouseover");
		Value.Class = UnitClass("mouseover");

		Value.Time = time();
		Value.Zone = GetZoneText() .. ": " ..  GetSubZoneText();
]]--
						local	ClassID = KOH.ClassToID(oMouseover.Class);
						if  (ClassID < 0) then
							ClassID = - ClassID;
						end;
						local	sClass = KOH.IDToClass(ClassID);
						if (sClass and (sClass ~= "")) then
							local	iRed, iGreen, iBlue = Karma_ClassMToColor(sClass);
							buttontext:SetTextColor(iRed, iGreen, iBlue);
						end

						if (oMouseover.Level) then
							karmavaluetext:SetText("L" .. oMouseover.Level);
						else
							karmavaluetext:SetText("L??");
						end
						if (oMouseover.Faction == sMyFaction) then
							karmavaluetext:SetTextColor(0.4, 1.0, 0.4);
						else
							karmavaluetext:SetTextColor(1.0, 0.4, 0.4);
						end
					end

					button.KarmaMouseoverGUID = oMouseover.GUID;
				end

				iCounter = iCounter+1;
			else
				break
			end
		end
		nindex = nindex+1;
	end

	--	function FauxScrollFrame_Update(frame, numItems, numToDisplay, valueStep, button, smallWidth, bigWidth, highlightFrame, smallHighlightWidth, bigHighlightWidth )
	-- valueStep = line height in Pixel!
	local	ExtraLines = KARMA_MEMBERLIST_SIZE - (KARMA_MEMBERLIST_SIZE % 2);
	ExtraLines = ExtraLines / 2;
	-- KarmaChatDebug("ML: FSF_U(" .. KarmaWindow_MemberList_ScrollFrame:GetName() .. ", " .. iNumEntries + ExtraLines .. ", " .. KARMA_MEMBERLIST_SIZE .. ", ...)");
	FauxScrollFrame_Update(KarmaWindow_MemberList_ScrollFrame, iNumEntries + ExtraLines, KARMA_MEMBERLIST_SIZE, 13, nil, 0, 0);
	KarmaObj.ProfileStop("KarmaWindowUpdateMemberList");
end

function	KarmaWindow_UpdateCurrentMember()
	KarmaObj.ProfileStart("KarmaWindow_UpdateCurrentMember");

	local	oMember = Karma_MemberList_GetObject(KARMA_CURRENTMEMBER);
	if (oMember == nil) then
		if (KARMA_CURRENTMEMBER ~= nil) then
			Karma_SetCurrentMember(nil);
		end

		KarmaWindow_ChosenPlayer:SetText("");
		KarmaWindow_ChosenPlayerInfo:SetText("");
		KarmaWindow_ChosenPlayerXPPercentage:SetText("");
		KarmaWindow_ChosenPlayerXPAccrued:SetText("");
		KarmaWindow_ChosenPlayerTimePercentage:SetText("");
		KarmaWindow_ChosenPlayerTimeAccrued:SetText("");
		KarmaWindow_ChosenPlayerSkillValue:SetText("");
		KarmaWindow_ChosenPlayerGearPVEValue:SetText("");
		KarmaWindow_ChosenPlayerGearPVPValue:SetText("");
		KarmaWindow_Notes_EditBox:SetText("");

		return -- Perfectly reasonable.
	end

	KarmaWindow_ChosenPlayer:SetText(KARMA_CURRENTMEMBER);

	local	playerinfo = "";
	if (oMember.Meta ~= nil) then
		-- currently only GUILD meta:
		-- lvl: storing number of people we know in this guild
		local	playerlvl = Karma_MemberObject_GetLevel(oMember);
		if (playerlvl and (playerlvl > 0)) then
			local	sGuild = Karma_MemberObject_GetGuild(oMember);
			if (sGuild ~= KarmaModuleLocal.Guildless) then
				playerinfo = playerlvl .. " (known) members";
			else
				playerinfo = playerlvl .. " players";
			end
		end
	else
		local	playerlvl, playerclass, playertalent;
		playerlvl = Karma_MemberObject_GetLevel(oMember) or "";
		playerclass = Karma_MemberObject_GetClass(oMember) or "";
		if (playerclass ~= "") then
			local	red, green, blue = Karma_GetColors_Class(KARMA_CURRENTMEMBER);
			playerclass = "|c" .. string.format("FF%2x%2x%2x", floor(red * 255), floor(green * 255), floor(blue * 255)) .. playerclass
		end

		playertalent = Karma_MemberObject_GetTalentColorizedText(oMember, 1);
		playerinfo = playerlvl .. " " .. playerclass .. "|cFFFFFFFF (" .. playertalent .. "|cFFFFFFFF";
		if (KarmaObj.Talents.SpecCount == 2) then
			local	playertalent2 = Karma_MemberObject_GetTalentColorizedText(oMember, 2);
			if ((playertalent2 ~= nil) and (playertalent2 ~= 0) and (playertalent2 ~= playertalent)) then
				playerinfo = playerinfo .. " + " .. playertalent2 .. "|cFFFFFFFF)";
			end
		end
		playerinfo = playerinfo .. ")";
	end
	KarmaWindow_ChosenPlayerInfo:SetText(playerinfo);

	local iSkill = Karma_MemberObject_GetSkill(oMember);
	if (iSkill >= 0) and (KARMA_SKILL_LEVELS[iSkill] ~= nil) then
		local	sModel = KCfg.Get("SKILL_MODEL");
		if (sModel == "complex") then
			KarmaWindow_ChosenPlayerSkillValue:SetText(tostring(iSkill) .. KARMA_WINEL_FRAG_COLONSPACE .. KARMA_SKILL_LEVELS[iSkill]);
		else
			KarmaWindow_ChosenPlayerSkillValue:SetText(KARMA_SKILL_LEVELS[iSkill]);
		end
	else
		KarmaWindow_ChosenPlayerSkillValue:SetText("");
	end

	local iGearlvl = Karma_MemberObject_GetGearPVE(oMember);
	if (iGearlvl >= 0) and (KARMA_GEAR_PVE_LEVELS[iGearlvl] ~= nil) then
		KarmaWindow_ChosenPlayerGearPVEValue:SetText(KARMA_GEAR_PVE_LEVELS[iGearlvl]);
	else
		KarmaWindow_ChosenPlayerGearPVEValue:SetText("");
	end

	iGearlvl = Karma_MemberObject_GetGearPVP(oMember);
	if (iGearlvl >= 0) and (KARMA_GEAR_PVP_LEVELS[iGearlvl] ~= nil) then
		KarmaWindow_ChosenPlayerGearPVPValue:SetText(KARMA_GEAR_PVP_LEVELS[iGearlvl]);
	else
		KarmaWindow_ChosenPlayerGearPVPValue:SetText("");
	end

	local	memberaccrue_abs;
	if (KARMA_CURRENTCHAR == nil) then
		memberaccrue_abs = Karma_MemberObject_GetTotalXPSummedUp(oMember);
	else
		memberaccrue_abs = Karma_MemberObject_GetXP(oMember);
	end
	if (memberaccrue_abs == nil) then
		memberaccrue_abs = 0;
	end
	local	memberaccrue_rel = Karma_MemberObject_GetXPLVL(oMember);

	do
		local	txt = memberaccrue_abs;
		if (memberaccrue_rel) then
			txt = txt .. " (" .. string.format("%.2f", memberaccrue_rel) .. ")";
		end
		KarmaWindow_ChosenPlayerXPAccrued:SetText(txt);
	end

	local	playeraccrue_abs;
	local	playeraccrue_rel;
	local	oPlayer;
	if (KARMA_CURRENTCHAR) then
		oPlayer = Karma_GetPlayerObject(KARMA_CURRENTCHAR);
	end
	if (oPlayer) then
		playeraccrue_abs = oPlayer[KARMA_DB_L5_RRFFC.XPTOTAL];
		playeraccrue_rel = oPlayer[KARMA_DB_L5_RRFFC.XPLVLSUM];
	end

	if (playeraccrue_abs == nil) or (playeraccrue_abs == 0) then
		KarmaWindow_ChosenPlayerXPPercentage:SetText("0.0");
	else
		local	per = 100 * tonumber(memberaccrue_abs) / tonumber(playeraccrue_abs);
		local	txt = string.format("%.2f", per);
		if (memberaccrue_rel) and (playeraccrue_rel) and (playeraccrue_rel > 0) then
			txt = txt .. " (" .. string.format("%.2f",
					100 * tonumber(memberaccrue_rel) / tonumber(playeraccrue_rel)) .. ")";
		end
		KarmaWindow_ChosenPlayerXPPercentage:SetText(txt);
	end

	local	membertotal;
	if (KARMA_CURRENTCHAR == nil) then
		membertotal = Karma_MemberObject_GetTotalTimePlayedSummedUp(oMember);
	else
		membertotal = Karma_MemberObject_GetTimePlayed(oMember);
	end
	if (membertotal == nil) then
		membertotal = 0;
	end
	KarmaWindow_ChosenPlayerTimeAccrued:SetText(KOH.Duration2String(membertotal));

	local	playertotal;
	if (oPlayer) then
		playertotal = oPlayer[KARMA_DB_L5_RRFFC.PLAYED];
	end
	if (playertotal == nil) or (playertotal == 0) then
		KarmaWindow_ChosenPlayerTimePercentage:SetText("0.0");
	else
		per = 100 * (membertotal / playertotal);
		KarmaWindow_ChosenPlayerTimePercentage:SetText(string.format("%.2f", per));
	end

	KarmaObj.ProfileStop("KarmaWindow_UpdateCurrentMember")
end

function	KarmaWindow_UpdateQuestList()
	KarmaObj.ProfileStart("KarmaWindow_UpdateQuestList")
	local	i, button;
	for i = 1, KARMA_MAINLISTS_SIZE do
		button = getglobal("QuestList_GlobalButton"..i.."_Text");
		button:SetText("");
	end

	local	oMember = Karma_MemberList_GetObject(KARMA_CURRENTMEMBER);
	if (oMember == nil) then
		KarmaObj.ProfileStop("KarmaWindow_UpdateQuestList")
		return;
	end

	local	questidlist = Karma_MemberObject_GetQuestList(oMember);
	if (questidlist == nil) then
		return
	end

	local	lQEx = nil;
	if (KARMA_QExDisplay > 0) then
		--KarmaChatDebug("KarmaWindow_UpdateQuestList: >> Karma_MemberObject_GetQuestExList");
		lQEx = Karma_MemberObject_GetQuestExList(oMember);
		--if lQEx == nil then
		--	KarmaChatDebug("KarmaWindow_UpdateQuestList: lQEx == nil.");
		--end
		--KarmaChatDebug("KarmaWindow_UpdateQuestList: << Karma_MemberObject_GetQuestExList");
	end

	local	iCounter = 1;
	local	nindex = 0;

	local	lQuestNames = Karma_QuestList_GetListOfNames(questidlist);
	local	lQuestInfos = CommonQuestInfoListGet();

	-- now counting lQuestNames instead of questidlist, because of added region entries
	local iNumEntries = 0;
	local key, value;
	for key, value in pairs(lQuestNames) do
		iNumEntries = iNumEntries + 1;
	end

	for key, value in pairs(lQuestNames) do
		--search the index of the array for the current users sName
		if (nindex - FauxScrollFrame_GetOffset(KarmaWindow_QuestList_ScrollFrame)  >= 0) then
			if (iCounter  <= KARMA_MAINLISTS_SIZE) then
				button = getglobal("QuestList_GlobalButton"..iCounter.."_Text");
				button.ExtID = nil;
				local globalQKey = value.id;
				local btntxt = value.name;
				if (KARMA_QZone > 0) then
					--KarmaChatDebug("KW_UQL: globalQKey = " .. globalQKey);
					if (globalQKey == nil) then
						-- region header entry:
						btntxt = value.RegionName .. ":";
					elseif (lQuestInfos ~= nil) and (globalQKey < 0) then
						--KarmaChatDebug("KW_UQL: lQuestInfos ~= nil");
						local globalQKeyPos = - globalQKey;
						local RegionID = nil;
						if (lQuestInfos[globalQKeyPos] ~= nil) then
							--KarmaChatDebug("KW_UQL: lQuestInfos[" .. globalQKeyPos .. "] ~= nil");
							RegionID = lQuestInfos[globalQKeyPos].RegionID;
							local ExtID = lQuestInfos[globalQKeyPos].ExtID;
							if (ExtID) then
								button.ExtID = ExtID;
								btntxt = btntxt .. " {" .. ExtID .. "}";
							end
						end
						if (RegionID ~= nil) then
							btntxt = "- " .. btntxt;
						else
							btntxt = "? " .. btntxt;
						end
					end
				end

				if (KARMA_QExDisplay > 0) then
					if (lQEx ~= nil) and (globalQKey ~= nil) then
						if (lQEx[globalQKey] ~= nil) then
							--KarmaChatDebug("KW_UQL: lQEx[" .. globalQKey .. "] ~= nil");
							local SummedProgress = lQEx[globalQKey].SummedProgress;
							if (SummedProgress == nil) then
								SummedProgress = 0;
							end
							local ObjectiveTotal = lQEx[globalQKey].ObjectiveTotal;
							if (ObjectiveTotal == nil) then
								ObjectiveTotal = 0;
							end
							btntxt = btntxt .. " [" .. SummedProgress .. "/" .. ObjectiveTotal .. "]";
							--KarmaChatDebug("KW_UQL: btntxt = " .. btntxt);
						end
					end
				end

				button:SetText(btntxt);
				iCounter = iCounter + 1;
			end
		end

		nindex = nindex + 1;
	end

	FauxScrollFrame_Update(KarmaWindow_QuestList_ScrollFrame, iNumEntries + 5, KARMA_MAINLISTS_SIZE, 13, nil, 0, 0);
	KarmaObj.ProfileStop("KarmaWindow_UpdateQuestList")
end


function	KarmaWindow_UpdateZoneList()
	KarmaObj.ProfileStart("KarmaWindow_UpdateZoneList")

	local	i, button;
	for i = 1, KARMA_MAINLISTS_SIZE do
		local	button = getglobal("ZoneList_GlobalButton"..i.."_Text");
		button:SetText("");
	end

	local	oMember = Karma_MemberList_GetObject(KARMA_CURRENTMEMBER);
	if (oMember == nil) then
		KarmaObj.ProfileStop("KarmaWindow_UpdateZoneList")
		return;
	end

	local	zoneidlist = Karma_MemberObject_GetZoneList(oMember);
	local	key, value;

	local	iCounter = 1;
	local	nindex = 0;
	local	lZones = Karma_ZoneList_GetListOfNames(zoneidlist);

	-- now counting lZones instead of zoneidlist, because of added region entries
	i = 0;
	for key, value in pairs(lZones) do
		i = i + 1;
	end
	local	iNumEntries = i;

	for key, value in pairs(lZones) do
		--search the index of the array for the current users sName
		if (nindex - FauxScrollFrame_GetOffset(KarmaWindow_ZoneList_ScrollFrame)  >= 0) then
			if (iCounter  <= KARMA_MAINLISTS_SIZE) then
				button = getglobal("ZoneList_GlobalButton" .. iCounter .. "_Text");
				button.RegionID = nil;
				if type(value) == "table" then
					if (value.Region ~= nil) and (value.Region ~= "") then
						if (value.Zone ~= "") then
							button:SetText("- " .. value.Zone);
						else
							button.RegionID = value.RegionID;
							button:SetText(value.Region .. ":");
						end
					else
						button:SetText("? " .. value.Zone);
					end
				else
	 				button:SetText(value);
				end
				iCounter = iCounter + 1;
			end
		end
		nindex = nindex + 1;
	end

	FauxScrollFrame_Update(KarmaWindow_ZoneList_ScrollFrame, iNumEntries + 5, KARMA_MAINLISTS_SIZE, 13, nil, 0, 0);
	KarmaObj.ProfileStop("KarmaWindow_UpdateZoneList")
end

function	KarmaWindow_UpdateRegionList()
	KarmaObj.ProfileStart("KarmaWindow_UpdateRegionList")

	local	i, button;
	for i = 1, KARMA_MAINLISTS_SIZE do
		local	button = getglobal("RegionList_GlobalButton"..i.."_Text");
		button:SetText("");
	end

	local	oMember = Karma_MemberList_GetObject(KARMA_CURRENTMEMBER);
	if (oMember == nil) then
		KarmaObj.ProfileStop("KarmaWindow_UpdateRegionList")
		return;
	end

	local	iNumEntries = 0;
	local	bGotRegions, lRegions = Karma_RegionList_GetLines(oMember);

	-- now counting lZones instead of zoneidlist, because of added region entries
	i = 0;
	for key, value in pairs(lRegions) do
		i = i + 1;
	end

	local	iNumEntries = i;
	local	key, value;
	local	iCounter = 1;
	local	nindex = 0;

	for key, value in pairs(lRegions) do
		--search the index of the array for the current users sName
		if (nindex - FauxScrollFrame_GetOffset(KarmaWindow_RegionList_ScrollFrame)  >= 0) then
			if (iCounter  <= KARMA_MAINLISTS_SIZE) then
				button = getglobal("RegionList_GlobalButton" .. iCounter .. "_Text");
 				button:SetText(value);
				iCounter = iCounter + 1;
			end
		end
		nindex = nindex + 1;
	end

	FauxScrollFrame_Update(KarmaWindow_RegionList_ScrollFrame, iNumEntries + 5, KARMA_MAINLISTS_SIZE, 13, nil, 0, 0);
	KarmaObj.ProfileStop("KarmaWindow_UpdateRegionList")
end

function	KarmaWindow_UpdateAchievementList()
	KarmaObj.ProfileStart("KarmaWindow_UpdateAchievementList")

	local	i, btnObj, btnText;
	for i = 1, KARMA_MAINLISTS_SIZE do
		local	btnText = getglobal("AchievementList_GlobalButton"..i.."_Text");
		btnText:SetText("");
	end

	local	oMember = Karma_MemberList_GetObject(KARMA_CURRENTMEMBER);
	if ((oMember == nil) or (KARMA_CURRENTCHAR == nil)) then
		KarmaObj.ProfileStop("KarmaWindow_UpdateAchievementList")
		return;
	end

	local	iNumEntries = 0;
	local	lKeys, lAchievements = KarmaObj.Achievements.LinesGet(oMember, KARMA_CURRENTCHAR);
	if (lAchievements == nil) then
		return;
	end

	local	iNumEntries = lKeys.__Count;

	local	iCounter = 1;
	local	iBase = FauxScrollFrame_GetOffset(KarmaWindow_AchievementList_ScrollFrame);
	for iOffset = iBase, iBase + KARMA_MAINLISTS_SIZE - 1 do
		local	btnObj = getglobal("AchievementList_GlobalButton" .. iCounter);
		btnObj.AchievementData = nil;
		local	sKey = lKeys[(iOffset - iBase) + 1];
		if (sKey) then
			btnText = getglobal("AchievementList_GlobalButton" .. iCounter .. "_Text");
			local	sType = strsub(sKey, 1, 1);
			if (sType == "C") then
				local	CatID = tonumber(strsub(sKey, 2));
				btnText:SetText(GetCategoryInfo(CatID) .. ":");
			elseif (sType == "A") then
				btnObj.AchievementData = lAchievements[sKey];
				btnObj.AchievementTitle = lAchievements[sKey].AchievementTitle;
				btnObj.AchievementID = lAchievements[sKey].AchievementID;
				btnText:SetText(" -- " .. lAchievements[sKey].AchievementTitle);
			end
		end
		iCounter = iCounter + 1;
	end

	FauxScrollFrame_Update(KarmaWindow_AchievementList_ScrollFrame, iNumEntries + 5, KARMA_MAINLISTS_SIZE, 13, nil, 0, 0);
	KarmaObj.ProfileStop("KarmaWindow_UpdateAchievementList")
end

function	KarmaWindow_NotesInitializeText()
	KarmaObj.ProfileStart("KarmaWindow_NotesInitializeText")

	local	oMember = Karma_MemberList_GetObject(KARMA_CURRENTMEMBER);
	if (oMember == nil) then
		KarmaWindow_NotesPublic_EditBox:SetText("");
		KarmaWindow_Notes_EditBox:SetText("");
		KarmaObj.ProfileStop("KarmaWindow_NotesInitializeText")
		return;
	end

	local	scrollBar = getglobal(KarmaWindow_Notes_EditBox:GetParent():GetParent():GetName().."ScrollBar")
	scrollBar:SetValue(0);
	KarmaWindow_Notes_EditBox:GetParent():GetParent():UpdateScrollChildRect();

	local	sNotes;

	sNotes = Karma_MemberObject_GetPublicNotes(oMember) or "";
	KarmaWindow_NotesPublic_EditBox:SetText(sNotes);

	sNotes = Karma_MemberObject_GetNotes(oMember) or "";
	KarmaWindow_Notes_EditBox:SetText(sNotes);

	KarmaObj.ProfileStop("KarmaWindow_NotesInitializeText")
end

function	KarmaWindow_NotePublic_UpdateText()
	KarmaObj.ProfileStart("KarmaWindow_NotesUpdateText");

	local	oMember = Karma_MemberList_GetObject(KARMA_CURRENTMEMBER);
	if (oMember ~= nil) then
		Karma_MemberObject_SetPublicNotes(oMember, KarmaWindow_NotesPublic_EditBox:GetText());
	end

	KarmaObj.ProfileStop("KarmaWindow_NotesUpdateText");
end

function	KarmaWindow_NotesUpdateText()
	KarmaObj.ProfileStart("KarmaWindow_NotesUpdateText")

	local	oMember = Karma_MemberList_GetObject(KARMA_CURRENTMEMBER);
	if (oMember ~= nil) then
		Karma_MemberObject_SetNotes(oMember, KarmaWindow_Notes_EditBox:GetText());
	end

	KarmaObj.ProfileStop("KarmaWindow_NotesUpdateText")
end

function	KarmaObj.UI.NotePublic_Editbox_Tooltip(self, title, key, anchor)
	-- ANCHOR_BOTTOMLEFT: links unten
	if Karma_ShowTooltipHelp() and (type(KARMA_TOOLTIPS[key]) == "table") then
		if (anchor) then
			GameTooltip:SetOwner(self, anchor);
		else
			GameTooltip:SetOwner(self, "ANCHOR_TOPLEFT");
		end
	
		GameTooltip:AddLine(KARMA_WINEL_TITLE .. KARMA_WINEL_FRAG_COLONSPACE .. title);
		local	bNextIsBrighter = false;
		for key, value in pairs(KARMA_TOOLTIPS[key]) do
			if (value == "") then
				bNextIsBrighter = true;
			else
				if (bNextIsBrighter) then
					GameTooltip:AddLine(value, 0.9, 0.9, 0.9);
					bNextIsBrighter = false;
				else
					GameTooltip:AddLine(value, 0.8, 0.8, 0.8);
				end
			end
		end
	
		GameTooltip:Show();
	end
end

function	KarmaWindow_UpdateKarmaBar()
	KarmaObj.ProfileStart("KarmaWindow_UpdateKarmaBar")

	local	oMember = Karma_MemberList_GetObject(KARMA_CURRENTMEMBER);
	if (oMember == nil) then
		KarmaWindow_KarmaSlider:SetValue(50);
		KarmaWindow_KarmaIndicator:SetValue(50);
		KarmaWindow_KarmaTextIndicator:SetText("50");
		KarmaObj.ProfileStop("KarmaWindow_UpdateKarmaBar")
		return;
	end

	-- KarmaChatDebug(KARMA_CURRENTMEMBER.." karmarating = "..KarmaObj.DB.M.KarmaGet(oMember));
	local	iKarma = KarmaObj.DB.M.KarmaGet(oMember);
	KarmaWindow_KarmaSlider:SetValue(iKarma);
	KarmaWindow_KarmaIndicator:SetValue(iKarma);
	KarmaWindow_KarmaTextIndicator:SetText(Karma_MemberObject_GetKarmaWithModifiers(oMember));

	if (iKarma == 1) then
		KarmaWindow_KarmaUpButton:Enable();
		KarmaWindow_KarmaDownButton:Disable();
	elseif (iKarma == 100) then
		KarmaWindow_KarmaUpButton:Disable();
		KarmaWindow_KarmaDownButton:Enable();
	else
		KarmaWindow_KarmaUpButton:Enable();
		KarmaWindow_KarmaDownButton:Enable();
	end

	local	red, green, blue;
	red, green, blue = Karma_GetColors_Karma(Karma_MemberObject_GetName(oMember));
	KarmaWindow_KarmaIndicator:SetStatusBarColor(red, green, blue);

	KarmaObj.ProfileStop("KarmaWindow_UpdateKarmaBar")
end

function	Karma_ChangeKarma(sMemberName, scroll, value, note)
	KarmaObj.ProfileStart("Karma_ChangeKarma")

	local	oMember = Karma_MemberList_GetObject(sMemberName);
	if (oMember == nil) then
		KarmaObj.ProfileStop("Karma_ChangeKarma")
		return;
	end

	local	curkarma = KarmaObj.DB.M.KarmaGet(oMember);
	curkarma = curkarma + value;
	if (curkarma <= 0) then
		curkarma = 1;
	end
	if (curkarma > 100) then
		curkarma = 100;
	end
	KarmaObj.DB.M.KarmaSet(oMember, curkarma);

	if (note ~= nil) then
		local	currnote = Karma_MemberObject_GetNotes(oMember);
		if currnote == nil then
			currnote = "";
		end

		currnote = currnote .. note .. KARMA_WINEL_FRAG_NEWLINE;
		Karma_MemberObject_SetNotes(oMember, currnote)
	end

	if (scroll) then
		KarmaWindow_ScrollToCurrentMember();
		KarmaWindow_Update();
	end
	KarmaObj.ProfileStop("Karma_ChangeKarma")
end

function	Karma_DecreaseKarma(sMemberName, scroll, value)
	KarmaObj.ProfileStart("Karma_DecreaseKarma")

	local	oMember = Karma_MemberList_GetObject(sMemberName);
	if (oMember == nil) then
		KarmaObj.ProfileStop("Karma_DecreaseKarma")
		return nil;
	end

	if (value == nil) then
		value = 1;
	end

	local	curkarma = KarmaObj.DB.M.KarmaGet(oMember);
	curkarma = curkarma - value;
	if (curkarma <= 0) then
		curkarma = 1;
	end
	KarmaObj.DB.M.KarmaSet(oMember, curkarma);
	if (scroll) then
		KarmaWindow_ScrollToCurrentMember();
		KarmaWindow_Update();
	end

	KarmaObj.ProfileStop("Karma_DecreaseKarma")
	return curkarma;
end

function	Karma_IncreaseKarma(sMemberName, scroll, value)
	KarmaObj.ProfileStart("Karma_IncreaseKarma")

	local	oMember = Karma_MemberList_GetObject(sMemberName);
	if (oMember == nil) then
		KarmaObj.ProfileStop("Karma_IncreaseKarma")
		return nil;
	end

	if (value == nil) then
		value = 1;
	end

	local	curkarma = KarmaObj.DB.M.KarmaGet(oMember);
	curkarma = curkarma + value;
	if (curkarma > 100) then
		curkarma = 100;
	end
	KarmaObj.DB.M.KarmaSet(oMember, curkarma);
	if (scroll) then
		KarmaWindow_ScrollToCurrentMember();
		KarmaWindow_Update();
	end

	KarmaObj.ProfileStop("Karma_IncreaseKarma")
	return curkarma;
end

function	KarmaWindow_KarmaSlider_OnValueChanged()
	local	oMember = Karma_MemberList_GetObject(KARMA_CURRENTMEMBER);
	if (oMember) then
		local	oldvalue = KarmaObj.DB.M.KarmaGet(oMember);
		local	newvalue = KarmaWindow_KarmaSlider:GetValue();

		KarmaObj.DB.M.KarmaSet(oMember, newvalue);
		KarmaWindow_KarmaIndicator:SetValue(newvalue);
		KarmaWindow_KarmaTextIndicator:SetText(Karma_MemberObject_GetKarmaWithModifiers(oMember));

		if (abs(oldvalue - newvalue) > 5) then
			KarmaChatSecondary("Changing Karma on " .. KARMA_CURRENTMEMBER .. " from " .. oldvalue .. " to " .. newvalue .."...");
		end
	end
end

function	KarmaWindow_KarmaSlider_OnMouseUp()
	KarmaWindow_KarmaChanged_RefreshSort();
end

function	KarmaWindow_KarmaIndicator_UpDownButtons(up)
	if (up) then
		Karma_IncreaseKarma(KARMA_CURRENTMEMBER, true, 1);
	else
		Karma_DecreaseKarma(KARMA_CURRENTMEMBER, true, 1);
	end
end

function	KarmaWindow_KarmaIndicator_OnMouseUp()
	KarmaWindow_KarmaChanged_RefreshSort();
end

function	KarmaWindow_KarmaChanged_RefreshSort()
	-- if sorting by Karma, this might change the order...
	local	sortby = KCfg.Get("SORTFUNCTION");
	if (KCfg.EqualsIndirect(sortby, "SORTFUNCTION_TYPE_KARMA")) then
		-- ... so force refresh of order, but CPU usage is too high to do it "live"
		Karma_MemberList_ResetMemberNamesCache();
		KarmaWindow_Update();
		KarmaWindow_ScrollToCurrentMember();
	else
		KarmaWindow_Update();
	end
end

--
---
--
function	KarmaWindow_Showtip(WndObj, sName, bJoined, iMouseover)
	local	sFrame = (type(WndObj) == "table") and (type(WndObj.GetName) == "function") and WndObj:GetName();
	local	bViaIgnore = strsub(sFrame, 1, 24) == "FriendsFrameIgnoreButton";
	if (bViaIgnore) then
		sName = WndObj.name:GetText();
		KarmaChatDebug("KarmaWindow_Showtip() from frame <" .. sFrame .. ">: sName = " .. (sName or "<missing>"));
		if (type(sName) ~= "string") then
			return
		end

		local	iPos = strfind(sName, "-", 1, true);
		if (iPos) then
			sName = strsub(sName, 1, iPos - 1) .. "@" .. strsub(sName, iPos + 1);
		end

		bJoined = nil;
		iMouseover = nil;
	end

	local	mo = Karma_MemberList_GetObject(sName);
	if (bViaIgnore and (type(mo) ~= "table")) then
		return
	end

	GameTooltip:SetOwner(WndObj, "ANCHOR_LEFT");

	local	red, green, blue;
	red, green, blue = Karma_GetColors_Karma(sName);
	GameTooltip:SetText(sName, red, green, blue);

	-- tooltip text has the form:
	--	Guild
	--	Gender, Race, Class, Level
	if (mo and (mo.Meta == nil)) then
		local	guild = Karma_MemberObject_GetGuild(mo);
		if (guild ~= "" and guild) then
			GameTooltip:AddLine("<"..guild..">", 1, 1, 1);
		end
	end

	local	temptext = ""
	local	level;
	if (mo) then
		if (mo.Meta == nil) then
			level = Karma_MemberObject_GetLevel(mo);
		end
	elseif (iMouseover) then
		level = KarmaModuleLocal.MouseOverKeepList[iMouseover].Level;
	end
	if (level) then
		local	gender;
		local	race;
		local	class;

		if (mo) then
			gender = Karma_MemberObject_GetGender(mo);
			race = Karma_MemberObject_GetRace(mo);
			class = Karma_MemberObject_GetClass(mo);
		elseif (iMouseover) then
			race = KarmaModuleLocal.MouseOverKeepList[iMouseover].Race;
			class = KarmaModuleLocal.MouseOverKeepList[iMouseover].Class;
		end

		if (gender) then
			temptext = string.format(KARMA_MSG_TIP_LEVEL .. " %s %s %s %s", level, gender, Karma_NilToString(race), Karma_NilToString(class));
		else
			temptext = string.format(KARMA_MSG_TIP_LEVEL .. " %s %s %s", level, Karma_NilToString(race), Karma_NilToString(class));
		end

		if (mo and KCfg.Get("TOOLTIP_GEAR") == 1) then
			local	iPvplvl = mo[KARMA_DB_L5_RRFFM.GEARLEVEL_PVP];
			if (iPvplvl) then
				temptext = temptext .. " [PvP:" .. math.floor(iPvplvl) .. "]";
			end
			local	iPvelvl = mo[KARMA_DB_L5_RRFFM.GEARLEVEL_PVE];
			if (iPvelvl) then
				temptext = temptext .. " [PvE:" .. math.floor(iPvelvl) .. "]";
			end
		end

		GameTooltip:AddLine(temptext, 1, 1, 1);
	end

	if (mo and (mo.Meta == nil) and (KCfg.Get("TOOLTIP_TALENTS") == 1)) then
		local	oLines, sSummarySub, iTimeOfTalents = KarmaObj.Talents.MemberObjToStringsObj(mo, true);
		local	i;
		for i = 1, #oLines do
			if (iTimeOfTalents) then
				GameTooltip:AddLine("Talents as of " .. date(KARMA_DATEFORMAT, iTimeOfTalents) .. ":", 1, 1, 1);
				iTimeOfTalents = nil;
			end
			GameTooltip:AddLine(oLines[i], 1, 1, 1);
			TT_Added = true;
		end
	end

	local	sPlayed = "";
	if (mo and (mo.Meta == nil)) then
		local	iSeconds;
		if (1 == KCfg.Get("TOOLTIP_PLAYEDTOTAL")) then
			iSeconds = Karma_MemberObject_GetTotalTimePlayedSummedUp(mo);
			sPlayed = " (total)";
		elseif (1 == KCfg.Get("TOOLTIP_PLAYEDTHIS")) then
			iSeconds = Karma_MemberObject_GetTimePlayed(mo);
			sPlayed = " (with current char)";
		end
		if (iSeconds) then
			if (iSeconds > 0) then
				sPlayed = " -- over " .. KOH.Duration2String(iSeconds) .. sPlayed;
			else
				sPlayed = " -- never joined" .. sPlayed;
			end
		end
	end

	local	iKarma, bModified = Karma_MemberObject_GetKarmaModified(mo);
	if (mo and bModified) then
		iKarma = math.min(100, iKarma);
		local	iRed, iGreen, iBlue = Karma_Karma2Color(iKarma);
		local	sKarma = Karma_MemberObject_GetKarmaWithModifiers(mo);
		sKarma = format(KARMA_ITSELF .. KARMA_WINEL_FRAG_COLONSPACE .. "|c%s%s|r", ColourToString(1, iRed, iGreen, iBlue), sKarma);
		GameTooltip:AddLine(sKarma .. sPlayed, 1, 1, 1);
	end

	if (bJoined and mo and (mo.Meta == nil)) then
		local	joinedTime, joinedChar = Karma_MemberObject_GetTimeJoinedTimeTotal(mo);
		if (joinedTime and (joinedTime > 0)) then
			joinedChar = Karma_MemberObject_GetTimeJoinedCharTotal(mo);
			if (joinedChar == nil) then
				joinedChar = KARMA_UNKNOWN;
			end
			temptext = KARMA_WINEL_LISTMEMBERTIP_JOINED_ATALL_PRE .. joinedChar .. KARMA_WINEL_LISTMEMBERTIP_JOINED_ATALL_POST
					.. date(KARMA_DATEFORMAT .. " %H:%M:%S", joinedTime);
			GameTooltip:AddLine(temptext, 1, 1, 1);
		end

		Karma_WhoAmIInit();
		if (not joinedChar or (joinedChar ~= WhoAmI)) then
			local	joinedTime = Karma_MemberObject_GetTimeJoinedChar(mo, WhoAmI);
			if (joinedTime and (joinedTime > 0)) then
				temptext = KARMA_WINEL_LISTMEMBERTIP_JOINED_CHAR .. date(KARMA_DATEFORMAT .. " %H:%M:%S", joinedTime);
				GameTooltip:AddLine(temptext, 1, 1, 1);
			end
		end

		-- "!*t" would be the path to ideal formatting, but returns a table..
		-- lazy for now, %m,%d,&y is not Mac-compatible though!
		local Try = Karma_MemberObject_GetTimestampTry(mo);
		local Success = Karma_MemberObject_GetTimestampSuccess(mo);
		if (Success) and (Success ~= 0) then
			temptext = KARMA_WINEL_LISTMEMBERTIP_UPDATE_OK .. date(KARMA_DATEFORMAT .. " %H:%M:%S", Success);
		elseif (Try) and (Try ~= 0) then
			temptext = KARMA_WINEL_LISTMEMBERTIP_UPDATE_FAIL .. date(KARMA_DATEFORMAT .. " %H:%M:%S", Try);
		else
			temptext = KARMA_WINEL_LISTMEMBERTIP_UPDATE_NEVER;
		end
		GameTooltip:AddLine(temptext, 1, 1, 1);
	end

	if (mo and KCfg.Get("TOOLTIP_SKILL") == 1) then
		local	iSkill = Karma_MemberObject_GetSkill(mo);
		if (iSkill >= 0) and (KARMA_SKILL_LEVELS[iSkill]) then
			local	sSkill = KARMA_MSG_TIP_SKILL .. KARMA_WINEL_FRAG_COLONSPACE .. KARMA_SKILL_LEVELS[iSkill];
			GameTooltip:AddLine(sSkill, 0.9, 0.6, 0.9);
		end
	end

	if (mo) then
		if ((KCfg.Get("TOOLTIP_TERROR") == 1) and mo[KARMA_DB_L5_RRFFM_TERROR]) then
			local	iTotal, k, v = 0;
			for k, v in pairs(mo[KARMA_DB_L5_RRFFM_TERROR]) do
				if (type(k) == "number") then
					iTotal = iTotal + 1;
				end
			end

			if (iTotal == 5) then
				GameTooltip:AddLine("For The Alliance/For The Horde: Completed. :-(", 1, 0.375, 0.375);
			elseif (iTotal > 0) then
				GameTooltip:AddLine("For The Alliance/For The Horde: Partly completed (" .. (iTotal * 25) .. "%). :-|", 1, 1, 0.375);
			else
				GameTooltip:AddLine("For The Alliance/For The Horde: Not started. :-)", 0.375, 1, 0.375);
			end
		end
	end

--[[
Value.GUID = UnitGUID("mouseover");
Value.Faction = UnitFactionGroup("mouseover");
Value.Name = UnitName("mouseover");
Value.Race = UnitRace("mouseover");
Value.Level = UnitLevel("mouseover");
Value.Class = UnitClass("mouseover");

Value.Time = time();
Value.Zone = GetZoneText() .. ": " ..  GetSubZoneText();
]]--

	if (iMouseover) then
		local	sSeen = "Seen in " .. KarmaModuleLocal.MouseOverKeepList[iMouseover].Zone;
		GameTooltip:AddLine(sSeen, 1, 1, 1);
		sSeen = "At " .. date(KARMA_DATEFORMAT .. " %H:%M:%S", KarmaModuleLocal.MouseOverKeepList[iMouseover].Time);
		GameTooltip:AddLine(sSeen, 1, 1, 1);
	end

	if ((type(KARMA_CURRENTLIST) == "number") and (KARMA_CURRENTLIST < 0)) then
		local	iIndex = - KARMA_CURRENTLIST;
		local	oHistory = KarmaModuleLocal.Raid.HistoryTables[iIndex];
		if (oHistory and (type(oHistory[sName]) == "table")) then
			local	oEntry = oHistory[sName];
			local	sJoined = "Joined initially at " .. date(KARMA_DATEFORMAT .. " %H:%M:%S", oEntry.JoinedFirst);
			GameTooltip:AddLine(sJoined, 1, 1, 1);

			local	iLeft = oEntry.Left;
			if (iLeft == nil) then
				iLeft = time();
			else
				local	sLeft = "Left finally at " .. date(KARMA_DATEFORMAT .. " %H:%M:%S", oEntry.Left);
				GameTooltip:AddLine(sLeft, 1, 1, 1);
			end
			-- KarmaChatDebug("History: " .. sName .. " = " .. oEntry.JoinedFirst .. " -> " .. iLeft .. " (- " .. oEntry.Sideline .. ")");
			local	iTimeInRaid = iLeft - oEntry.JoinedFirst - oEntry.Sideline;
			local	iRaidTotal;
			if (oHistory.__End) then
				iRaidTotal = oHistory.__End - oHistory.__Start;
			else
				iRaidTotal = time() - oHistory.__Start;
			end
			local	sLeft = "Total time in raid: " .. KOH.Duration2String(iTimeInRaid) .. format(" (%.1f%%)", 100.0 * iTimeInRaid / iRaidTotal);
			GameTooltip:AddLine(sLeft, 1, 1, 1);
		end
	end

	if (mo and (mo.Meta == nil)) then
		local	iSeen = mo[KARMA_DB_L5_RRFFM.LASTSEEN];
		if (iSeen) then
			local	sAdd = "Seen: " .. date(KARMA_DATEFORMAT .. " %H:%M:%S", iSeen);
			GameTooltip:AddLine(sAdd, 1, 1, 1);
		end

		local	iModified, sModified = mo[KARMA_DB_L5_RRFFM.LASTCHANGED_TIME], mo[KARMA_DB_L5_RRFFM.LASTCHANGED_FIELD];
		if ((iModified ~= nil) and (sModified ~= nil)) then
			local	sAdd = "MRC: " .. sModified .. "@" .. date(KARMA_DATEFORMAT .. " %H:%M:%S", iModified);
			GameTooltip:AddLine(sAdd, 1, 1, 1);
		end

		if (type(mo[KARMA_DB_L5_RRFFM_CONFLICT]) == "table") then
			local	sConflict = mo[KARMA_DB_L5_RRFFM_CONFLICT].Conflict;
			if (mo[KARMA_DB_L5_RRFFM_CONFLICT].Resolved == 0) then
				GameTooltip:AddLine(" ");
				GameTooltip:AddLine("CONFLICT: " .. sConflict, 1, 0.6, 0.2);
			end
		end
	end

	if (bViaIgnore) then
		local	sNote = mo[KARMA_DB_L5_RRFFM_NOTES] or "";
		if (sNote ~= "") then 
			GameTooltip:AddLine("Note:\n" .. sNote);
		end
	end

	GameTooltip:Show();
end


function	KarmaWindow_PartyList_OnEnter(self, motion)
	local	id = self:GetID();
	local	button = getglobal("PartyList_GlobalButton"..id.."_Text");
	local	sName = button:GetText();
	if (sName ~= nil and sName ~= "" and sName ~= KARMA_UNKNOWN and sName ~= KARMA_UNKNOWN_ENT) then
		if (type(KARMA_CURRENTLIST) == "string") then
			sName = sName .. "@" .. KARMA_CURRENTLIST;
		end
		KarmaWindow_Showtip(self, sName, false);
	end
end

function	KarmaWindow_MemberList_OnEnter(self, motion)
	local	id = self:GetID();
	local	buttontext = getglobal("MemberList_GlobalButton"..id.."_Text");
	local	sName = buttontext:GetText();
	if (sName ~= nil and sName ~= "" and sName ~= KARMA_UNKNOWN and sName ~= KARMA_UNKNOWN_ENT) then
		if (KARMA_CURRENTLIST == 3) then
			local	button = getglobal("MemberList_GlobalButton" .. id);
			local	iKey = button.KarmaMouseoverIndex;
			if (iKey and (KarmaModuleLocal.MouseOverKeepList[iKey]) and (KarmaModuleLocal.MouseOverKeepList[iKey].GUID == button.KarmaMouseoverGUID)) then
				KarmaWindow_Showtip(self, sName, false, iKey);
			else
				KarmaWindow_Showtip(self, sName, true);
			end
		else
			if (type(KARMA_CURRENTLIST) == "string") then
				sName = sName .. "@" .. KARMA_CURRENTLIST;
			end
			KarmaWindow_Showtip(self, sName, true);
		end
	end
end

function	KarmaWindow_QuestList_OnEnter(self, motion)
	local	id = self:GetID();
	local	button = getglobal("QuestList_GlobalButton"..id.."_Text");
	local	sName = button:GetText();
	if (sName ~= nil) and (sName ~= "") then
		if (strsub(sName, strlen(sName)) == ":") then
			sName = strsub(sName, 1, strlen(sName) - 1);
		end
		GameTooltip:SetOwner(self, "ANCHOR_RIGHT");
		GameTooltip:SetText(sName, red, green, blue);
		GameTooltip:Show();
	end
end

function	Karma_RegionList_GetLines(oMember, aRegionID, aName)
	local	bFound, iSumTotals = 0, 0;
	local	Result = {};

	local	GetList = function(oRegL, bFound, iSumTotals, Result)
			local	sDateWas;
			local	RegionList = CommonRegionListGet();
			local	key, value, subkey, subvalue;
			for key, value in pairs(oRegL) do
				local	iRegionID = value[KARMA_DB_L7_RRFFMCCRR_ID];
				if (aRegionID == nil) or (iRegionID == aRegionID) then
					local	sDiff = KARMA_DUNGEON_DIFFICULTY[value[KARMA_DB_L7_RRFFMCCRR_DIFF]];
					if (sDiff == nil) then
						sDiff = value[KARMA_DB_L7_RRFFMCCRR_DIFF] .. "?";
					end
					if (RegionList[iRegionID][KARMA_DB_L3_CR.ISPVPZONE] == 1) then
						sDiff = sDiff .. " <pvp>";
					end
					if (RegionList[iRegionID][KARMA_DB_L3_CR.ZONETYPE]) then
						sDiff = sDiff .. "/" .. RegionList[iRegionID][KARMA_DB_L3_CR.ZONETYPE];
					end
					if (RegionList[iRegionID][KARMA_DB_L3_CR.ISPVPZONE] == 1) then
						sDiff = sDiff .. " <pvp>";
					end

					local	iTotal = abs(value[KARMA_DB_L7_RRFFMCCRR_PLAYEDTOTAL]);

					local	sTotal = "";
					if (iTotal >= 86400) then
						sTotal = math.floor(iTotal / 86400) .. "d ";
						iTotal = iTotal % 86400;
					end
					sTotal = sTotal .. math.floor(iTotal / 3600) .. "h ";
					iTotal = iTotal % 3600;
					sTotal = sTotal .. math.floor(iTotal / 60) .. "m";

					iTotal = math.max(0, iTotal);

					if (aName) then
						tinsert(Result, aName .. " (" .. sDiff .. ") :   " .. sTotal);
					else
						aName = RegionList[iRegionID].Name;
						tinsert(Result, aName .. " (" .. sDiff .. ") :   " .. sTotal);
						aName = nil;
					end

					local	starttime, endtime, sDate, sRoles;
					iTotal = 0;
					for subkey, subvalue in pairs(value[KARMA_DB_L7_RRFFMCCRR_PLAYEDDAYS]) do
						starttime = subvalue[KARMA_DB_L8_RRFFMCCRRD_START];
						endtime = subvalue[KARMA_DB_L8_RRFFMCCRRD_END];
						iTotal = iTotal + (endtime - starttime);
						sRoles = KOH.RolesToString(subvalue[KARMA_DB_L8_RRFFMCCRRD_ROLE], " as ");
						sDate = date("%Y-%m-%d: ", subvalue[KARMA_DB_L8_RRFFMCCRRD_START]);
						if (sDate == sDateWas) then
							sDate = "";
						else
							sDateWas = sDate;
						end
						tinsert(Result, "=> " .. sDate .. date("%H:%M:%S", subvalue[KARMA_DB_L8_RRFFMCCRRD_START])
							.. sRoles);
						sDate = date("%Y-%m-%d: ", subvalue[KARMA_DB_L8_RRFFMCCRRD_END]);
						if (sDate == sDateWas) then
							sDate = "";
						else
							sDateWas = sDate;
						end
						tinsert(Result, "<= " .. sDate .. date("%H:%M:%S", subvalue[KARMA_DB_L8_RRFFMCCRRD_END])
							.. sRoles);
					end

					iSumTotals = iSumTotals + iTotal;
					if (value[KARMA_DB_L7_RRFFMCCRR_PLAYEDTOTAL] <= 0) then
						value[KARMA_DB_L7_RRFFMCCRR_PLAYEDTOTAL] = iTotal;
					end

					bFound = 1;
				end
			end

			return bFound, iSumTotals, Result;
		end



	if ((oMember ~= nil) and (oMember[KARMA_DB_L5_RRFFM_CHARACTERS] ~= nil)) then
		if (KARMA_CURRENTCHAR ~= nil) then
			local	oMemChar = KarmaObj.DB.MC.Get(oMember, KARMA_CURRENTCHAR);
			if (oMemChar) then
				local	oRegL = oMemChar[KARMA_DB_L6_RRFFMCC_REGIONLIST];
				if ((type(oRegL) == "table") and not KOH.TableIsEmpty(oRegL)) then
					bFound, iSumTotals = GetList(oRegL, bFound, iSumTotals, Result);
				end
			end
		else
			local	iIx, oMemChar;
			for iIx, oMemChar in pairs(oMember[KARMA_DB_L5_RRFFM_CHARACTERS]) do
				local	oRegL = oMemChar[KARMA_DB_L6_RRFFMCC_REGIONLIST];
				if ((type(oRegL) == "table") and not KOH.TableIsEmpty(oRegL)) then
					local	iID = oMemChar[KARMA_DB_L6_RRFFMCC_KARMA_ID];
					local	sName = KarmaObj.DB.MC.IDToName(iID) or ("<? " .. iID .. ">");
					tinsert(Result, "|cFFFFFFFF=< " .. sName .. " >=|r");
					bFound, iSumTotals = GetList(oRegL, bFound, iSumTotals, Result);
					tinsert(Result, "|cFFFFFFFF--------------------------|r");
				end
			end
		end
	end

	return bFound, Result, iSumTotals;
end

function	KarmaWindow_RegionList_OnEnter(self, motion)
	local	id = self:GetID();
	local	button = getglobal("RegionList_GlobalButton"..id.."_Text");
	local	sName = button:GetText();
	if (sName ~= nil) and (sName ~= "") then
		if (strsub(sName, strlen(sName)) == ":") then
			sName = strsub(sName, 1, strlen(sName) - 1);
		end

		GameTooltip:SetOwner(self, "ANCHOR_RIGHT");
		GameTooltip:SetText(sName, red, green, blue);
		GameTooltip:Show();
	end
end

function	KarmaWindow_ZoneList_OnEnter(self, motion)
	local	id = self:GetID();
	local	button = getglobal("ZoneList_GlobalButton"..id.."_Text");
	local	sName = button:GetText();
	if (sName ~= nil) and (sName ~= "") then
		GameTooltip:SetOwner(self, "ANCHOR_RIGHT");
		if (button.RegionID == nil) then
			GameTooltip:SetText(sName, red, green, blue);
		else
			sName = strsub(sName, 1, strlen(sName) - 1)

			local	bFound = 0;
			local	oMember = Karma_MemberList_GetObject(KARMA_CURRENTMEMBER);
			if (oMember) then
				local	EntriesL;
				bFound, EntriesL = Karma_RegionList_GetLines(oMember, button.RegionID, sName);
				if (bFound) then
					local	key, value;
					for key, value in pairs(EntriesL) do
						GameTooltip:AddLine(value);
					end
				end
			end
			if (bFound == 0) then
				GameTooltip:SetText(sName, red, green, blue);
			end
		end

		GameTooltip:Show();
	end
end

function	KarmaWindow_AchievementList_OnEnter(self, motion)
	KarmaObj.Achievements.ListTip(self);
end

function	KarmaWindow_AchievementList_OnClick(oAchBtn, sMouse)
	KarmaObj.Achievements.OnClick(oAchBtn, sMouse);
end

--
function	Karma_HelpQuestionMark_OnEnter(self, motion)
	local	oFrame = self:GetParent();
	local	sFrameName = oFrame:GetName();
	if (sFrameName ~= "") and (sFrameName ~= nil) then
		KarmaChatDebug("Looking for help for " .. sFrameName .. ".");

		local	replace = "KarmaWindow";
		local	len = strlen(replace);
		if (strsub(sFrameName, 1, len) == replace) then
			sFrameName = "Help_KW" .. strsub(sFrameName, len + 1);
		end
		replace = "Karma";
		len = strlen(replace);
		if (strsub(sFrameName, 1, len) == replace) then
			sFrameName = "Help_K" .. strsub(sFrameName, len + 1);
		end

		local	oHelp;
		if (type(KARMA_FRAMES_HELP) == "table") then
			if (type(KARMA_FRAMES_HELP[sFrameName]) == "table") then
				oHelp = KARMA_FRAMES_HELP[sFrameName];
			end
		end

		if (type(KARMAAVENK_LOC_MODULES) == "table") then
			local	sMod, oModHelp;
			for sMod, oModHelp in pairs(KARMAAVENK_LOC_MODULES) do
				if (oModHelp[sFrameName]) then
					oHelp = oModHelp[sFrameName];
					break
				end
			end
		end

		if (type(oHelp) == "table") then
			GameTooltip:SetOwner(self, "ANCHOR_RIGHT");

			local	key, value, later;
			for key, value in pairs(oHelp) do
				if (later) then
					if (value == "~") then
						GameTooltip:AddDoubleLine("~~~~", "~~~~", 1, 1, 1, 1, 1, 1);
					else
						GameTooltip:AddLine(value, 1, 1, 1);
					end
				else
					GameTooltip:AddLine(value, red, green, blue);
					later = true;
				end
			end

			GameTooltip:Show();
		else
			KarmaChatDebug("Missing help for " .. sFrameName .. ".");
		end
	end
end

---
----
---
function	KarmaWindow_AltList_OnEnter(self, motion)
	local	id = self:GetID();
	local	button = getglobal("AltList_NameButton"..id.."_Text");
	local	sName = button:GetText();
	if (sName ~= nil) and (sName ~= "") then
		GameTooltip:SetOwner(self, "ANCHOR_RIGHT");
		GameTooltip:SetText(sName, red, green, blue);
		GameTooltip:Show();
	end
end

function	KarmaWindow_AltList_OnClick(btnobj, mousebtn)
	local	id = btnobj:GetID();
	local	button = getglobal("AltList_NameButton"..id.."_Text");
	local	sName = button:GetText();
	if (sName ~= nil) and (sName ~= "") then
		KarmaChatDebug("Switching to alt <" .. sName .. ">");
		Karma_SetCurrentMember(sName);
		KarmaWindow_ScrollToCurrentMember();
	else
		KarmaChatDebug("Trying to select >nil< alt.");
	end
end

function	KarmaWindow_UpdateAltList()
	KarmaObj.ProfileStart("KarmaWindow_UpdateAltList")

	local	i, button;
	for i = 1, KARMA_ALTLIST_SIZE do
		button = getglobal("AltList_KarmaValueButton"..i.."_Text");
		button:SetText("");
		button = getglobal("AltList_LevelButton"..i.."_Text");
		button:SetText("");
		button = getglobal("AltList_NameButton"..i.."_Text");
		button:SetText("");
	end

	local	AltsObj = KarmaObj.DB.FactionCacheGet()[KARMA_DB_L4_RRFF.ALTGROUPS];
	if (AltsObj == nil) then
		if (KARMA_CURRENTMEMBER) then
			KarmaChatDebug("No alt groups defined.");
		end
		FauxScrollFrame_Update(KarmaWindow_AltList_ScrollFrame, floor(KARMA_ALTLIST_SIZE / 2), KARMA_ALTLIST_SIZE, 13, nil, 0, 0);
		KarmaObj.ProfileStop("KarmaWindow_UpdateAltList")
		return
	end

	local	oMember = Karma_MemberList_GetObject(KARMA_CURRENTMEMBER);
	if (oMember == nil) then
		if (KARMA_CURRENTMEMBER) then
			KarmaChatDebug(KARMA_CURRENTMEMBER .. ": Ups? Not on Karma's list??");
		end
		FauxScrollFrame_Update(KarmaWindow_AltList_ScrollFrame, floor(KARMA_ALTLIST_SIZE / 2), KARMA_ALTLIST_SIZE, 13, nil, 0, 0);
		KarmaObj.ProfileStop("KarmaWindow_UpdateAltList")
		return;
	end

	local	altid = Karma_MemberObject_GetAltID(oMember);
	if (altid == -1) then
--		KarmaChatDebug(KARMA_CURRENTMEMBER .. ": no alts.");
		FauxScrollFrame_Update(KarmaWindow_AltList_ScrollFrame, floor(KARMA_ALTLIST_SIZE / 2), KARMA_ALTLIST_SIZE, 13, nil, 0, 0);
		KarmaObj.ProfileStop("KarmaWindow_UpdateAltList")
		return
	end

	local	lAlts;
	local	key, value;
	for key, value in pairs(AltsObj) do
		if (value.ID == altid) then
			lAlts = Karma_CopyTable(value.AL);
			break;
		end
	end
	if (lAlts == nil) then
		lAlts = {};
	else
		lAlts = KOH.AlphaBucketSort(lAlts);
	end

	local	iNumEntries = 0;
	i = 0;
	for key, value in pairs(lAlts) do
		i = i + 1;
	end

	KarmaChatDebug(KARMA_CURRENTMEMBER .. ": " .. i .. " alts in same alt-group.");

	local	iNumEntries = i;
	local	iCounter = 1;
	local	nindex = 0;
	local	iKarma, bModified, sKarma, r, g, b;
	for key, value in pairs(lAlts) do
		--search the index of the array for the current users sName
		if (nindex - FauxScrollFrame_GetOffset(KarmaWindow_AltList_ScrollFrame)  >= 0) then
			if (iCounter <= KARMA_ALTLIST_SIZE) then
				local	oMemberAlt = Karma_MemberList_GetObject(value);
				if (oMemberAlt) then
					button = getglobal("AltList_KarmaValueButton" .. iCounter .. "_Text");
					iKarma, bModified = Karma_MemberObject_GetKarmaModified(oMemberAlt);
					if (iKarma) then
						if (iKarma > 99) then
							sKarma = "++";
						else
							sKarma = iKarma;
						end
						if (bModified) then
							sKarma = "*" .. sKarma;
						end
						button:SetText(sKarma);

						iKarma = math.min(iKarma, 100);
						r, g, b = Karma_Karma2Color(iKarma);
						button:SetTextColor(r, g, b);
					end

					button = getglobal("AltList_LevelButton" .. iCounter .. "_Text");
					local	iLevel = Karma_MemberObject_GetLevel(oMemberAlt);
					if (iLevel) and (iLevel > 0) then
						button:SetText(iLevel);
					else
						button:SetText("??");
					end
				end

				button = getglobal("AltList_NameButton" .. iCounter .. "_Text");
				button:SetText(value);
				r, g, b = Karma_GetColors_Class(value);
				button:SetTextColor(r, g, b);

				iCounter = iCounter + 1;
			end
		end
		nindex = nindex + 1;
	end
	FauxScrollFrame_Update(KarmaWindow_AltList_ScrollFrame, iNumEntries + floor(KARMA_ALTLIST_SIZE / 2), KARMA_ALTLIST_SIZE, 13, nil, 0, 0);

	KarmaObj.ProfileStop("KarmaWindow_UpdateAltList")
end

----------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------

---
---- CharSelection Menu
---
function	KarmaWindow_ListSelection_DropDown_Initialize(self, level)
	local	info = {};

	level = level or 1;
	if (level == 1) then
		table.wipe(info);
		info.value = 1;
		info.text = KARMA_WINEL_MEMBERLISTTITLE .. " (current server)";
		info.arg1 = 1;
		info.func = KarmaWindow_ListSelection_DropDown_OnClick;

		UIDropDownMenu_AddButton(info);

		if (KCfg.Get("RAID_TRACKALL") == 1) then
			table.wipe(info);
			info.value = 2;
			info.text = "Current raid";
			info.arg1 = 2;
			info.func = KarmaWindow_ListSelection_DropDown_OnClick;

			UIDropDownMenu_AddButton(info);
		end

		table.wipe(info);
		info.value = 3;
		info.text = "Mouse-'Seen'";
		info.arg1 = 3;
		info.func = KarmaWindow_ListSelection_DropDown_OnClick;

		UIDropDownMenu_AddButton(info);

		table.wipe(info);
		info.value = 4;
		info.text = "Seen most recently (incl. cross-server)";
		info.arg1 = 4;
		info.func = KarmaWindow_ListSelection_DropDown_OnClick;

		UIDropDownMenu_AddButton(info);

		local	oServers, iCnt, i = KarmaObj.DB.ServerListGet();
		iCnt = math.ceil((#oServers - 1) / 10);
		for i = 1, iCnt do
			table.wipe(info);
			info.value = i + 4;
			info.text = "Servers #" .. (1 + 10 * (i - 1)) .. " - #" .. (10 * i);
			info.hasArrow = 1;
			info.notClickable = 1;

			UIDropDownMenu_AddButton(info);
		end

		if (KCfg.Get("RAID_TRACKALL") == 1) then
			local	iKey, oHistory;
			for iKey, oHistory in pairs(KarmaModuleLocal.Raid.HistoryTables) do
				table.wipe(info);
				info.value = 1000 + iKey;
				if (oHistory.__Instance) then
					info.text = oHistory.__Instance .. date(" @%H:%M", oHistory.__End or time());
				else
					info.text = "raid history #" .. iKey;
				end
				info.arg1 = 1000 + iKey;
				info.func = KarmaWindow_ListSelection_DropDown_OnClick;

				UIDropDownMenu_AddButton(info);
			end
		end
	elseif (level == 2) then
		local	iGroup = UIDROPDOWNMENU_MENU_VALUE - 4;
		local	oServers, i = KarmaObj.DB.ServerListGet();
		for i = 1 + (iGroup - 1) * 10, iGroup * 10 do
			local	sServer = oServers[i];
			if (sServer) then
				local	sChar = KarmaObj.NameToBucket(sServer);
				table.wipe(info);
				info.value = oServers[i];
				info.text = "Server: " .. oServers[i];
				info.arg1 = oServers[i];
				info.func = KarmaWindow_ListSelection_DropDown_OnClick;

				UIDropDownMenu_AddButton(info, level);
			end
		end
	end
end

function	KarmaWindow_ListSelection_DropDown_OnShow(self)
	UIDropDownMenu_Initialize(self, KarmaWindow_ListSelection_DropDown_Initialize);
	UIDropDownMenu_SetWidth(self, 125);
	UIDropDownMenu_SetButtonWidth(self, 18);

	if ((type(KARMA_CURRENTLIST) == "string") or (KARMA_CURRENTLIST > 0)) then
		UIDropDownMenu_SetSelectedValue(KarmaWindow_ListSelection_DropDown, KARMA_CURRENTLIST);
	else
		UIDropDownMenu_SetSelectedValue(KarmaWindow_ListSelection_DropDown, 1000 - KARMA_CURRENTLIST);
	end
end

function	KarmaWindow_ListSelection_DropDown_OnClick(self, arg1, arg2)
	CloseDropDownMenus();
	-- UIDropDownMenu_SetSelectedID(KarmaWindow_ListSelection_DropDown, self:GetID());
	UIDropDownMenu_SetSelectedValue(KarmaWindow_ListSelection_DropDown, arg1);
	if (arg1 ~= nil) and (arg1 ~= "") then
		local	KCLold = KARMA_CURRENTLIST;
		if (type(arg1) == "string") then
			KARMA_CURRENTLIST = arg1;
		elseif (arg1 > 1000) then
			KARMA_CURRENTLIST = 1000 - arg1;
		else
			KARMA_CURRENTLIST = arg1;
		end

		KarmaChatDebug("Selected current list: " .. arg1);

		Karma_MemberList_ResetMemberNamesCache();
		KarmaWindow_Update();
	end
end

----------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------

---
---- CharSelection Menu
---
function	KarmaWindow_CharSelection_DropDown_Initialize()
	local	info;

	info = {};
	info.value = 1;
	info.isTitle = 1;
	info.notCheckable = 1;
	info.text = "List data sources by character:";

	UIDropDownMenu_AddButton(info);

	local	oMember;
	if (KARMA_CURRENTMEMBER ~= nil) then
		oMember = Karma_MemberList_GetObject(KARMA_CURRENTMEMBER);
	end
	local	oCharacterL = KarmaObj.DB.SF.CharacterListGet();
	if ((KARMA_CURRENTMEMBER == nil) or (oMember == nil) or (oCharacterL == nil)) then
		info = {};
		info.value = 2;
		info.text = "-- nothing available --";
		info.arg1 = "";

		UIDropDownMenu_AddButton(info);

		KarmaModuleLocal.CharSelection_Index = 2;

		return
	end

	local	oCharIDs = {};
	local	sCharIDs, iIx, oChar = "";
	for iIx, oChar in pairs(oMember[KARMA_DB_L5_RRFFM_CHARACTERS]) do
		local	iCharID = oChar[KARMA_DB_L6_RRFFMCC_KARMA_ID];
		oCharIDs[iCharID] = 1;
		sCharIDs = sCharIDs .. ", " .. iCharID;
	end
	KarmaChatDebug("CharIDs: " .. strsub(sCharIDs, 2));

	local	bHasCurrentChar, iHasCurrentChar = (KARMA_CURRENTCHAR == nil);
	local	sCharAvail, iCharAvail;

	Karma_WhoAmIInit();
	local	key = WhoAmI;
	if (KarmaObj.DB.MC.Exists(oMember, key)) then
		local	iCharID = KarmaObj.DB.MC.NameToID(key);
		oCharIDs[iCharID] = nil;

		if (KARMA_CURRENTCHAR == key) then
			bHasCurrentChar = true;
			iHasCurrentChar = 2;
		end
		if (sCharAvail == nil) then
			sCharAvail = key;
			iCharAvail = 2;
		end

		info = {};
		info.value = 2;
		info.text = "Show data related to >" .. key .. "<";
		info.arg1 = key;
		info.func = KarmaWindow_CharSelection_DropDown_OnClick;

		UIDropDownMenu_AddButton(info);
	else
		KarmaChatDebug("No data to current char >" .. key .. "<");
	end

	local	i, value = 3;
	for key, value in pairs(oCharacterL) do
		if ((key ~= WhoAmI) and KarmaObj.DB.MC.Exists(oMember, key)) then
			local	iCharID = KarmaObj.DB.MC.NameToID(key);
			oCharIDs[iCharID] = nil;

			if (KARMA_CURRENTCHAR == key) then
				bHasCurrentChar = true;
				iHasCurrentChar = 2;
			end
			if (sCharAvail == nil) then
				sCharAvail = key;
				iCharAvail = 2;
			end

			info = {};
			info.value = 2;
			info.text = "Show data related to >" .. key .. "<";
			info.arg1 = key;
			info.func = KarmaWindow_CharSelection_DropDown_OnClick;

			UIDropDownMenu_AddButton(info);
		end
	end

	for key, value in pairs(oCharIDs) do
		local	sCharName, sCharServer = KarmaObj.DB.MC.IDToName(key);
		sCharName = sCharName .. "@" .. sCharServer;
		if (KarmaObj.DB.MC.Exists(oMember, sCharName)) then
			if (KARMA_CURRENTCHAR == sCharName) then
				bHasCurrentChar = true;
				iHasCurrentChar = i;
			end
			if (sCharAvail == nil) then
				sCharAvail = sCharName;
				iCharAvail = i;
			end

			info = {};
			info.value = i;
			info.text = "Show data related to >" .. sCharName .. "<";
			info.arg1 = sCharName;
			info.func = KarmaWindow_CharSelection_DropDown_OnClick;

			UIDropDownMenu_AddButton(info);

			i = i + 1;
		end
	end

	info = {};
	info.value = i;
	info.text  = "Show total data";
	info.arg1  = nil;
	info.func = KarmaWindow_CharSelection_DropDown_OnClick;

	UIDropDownMenu_AddButton(info);

	KarmaModuleLocal.CharSelection_Index = nil;
	if (not bHasCurrentChar) then
		if (KARMA_CURRENTCHAR ~= nil) then
			KARMA_CURRENTCHAR = sCharAvail;
			Karma_MemberList_ResetMemberNamesCache();
			KarmaWindow_Update();

			if (iCharAvail) then
				KarmaChatDebug("Force-selected current char: " .. Karma_NilToString(sCharAvail));
				KarmaModuleLocal.CharSelection_Index = - iCharAvail;
			end
		end
	else
		KarmaChatDebug("Selected current char in entry " .. Karma_NilToString(iHasCurrentChar));
		KarmaModuleLocal.CharSelection_Index = iHasCurrentChar;
	end

	if (KarmaModuleLocal.CharSelection_Index == nil) then
		KarmaChatDebug("No entries to current char and/or no current char selected. Fall-through to all data.");
		KarmaModuleLocal.CharSelection_Index = i;
	end
end

function	KarmaWindow_CharSelection_DropDown_OnShow(self)
	UIDropDownMenu_Initialize(self, KarmaWindow_CharSelection_DropDown_Initialize);
	UIDropDownMenu_SetWidth(self, 350);			-- upped from 210, because we got Server also there...
	UIDropDownMenu_SetButtonWidth(self, 25);

	local	bRefresh = false;
	if (KarmaModuleLocal.CharSelection_Index < 0) then
		bRefresh = true;
		KarmaModuleLocal.CharSelection_Index = - KarmaModuleLocal.CharSelection_Index;
	end
	UIDropDownMenu_SetSelectedValue(KarmaWindow_CharSelection_DropDown, KarmaModuleLocal.CharSelection_Index);
	if (bRefresh) then
		KarmaWindow_Update();
	end
end

function	KarmaWindow_CharSelection_DropDown_OnClick(self, arg1)
	UIDropDownMenu_SetSelectedID(KarmaWindow_CharSelection_DropDown, self:GetID());
	if (arg1 ~= "") then
		KARMA_CURRENTCHAR = arg1;
		Karma_MemberList_ResetMemberNamesCache();
		KarmaWindow_Update();

		KarmaChatDebug("Selected current char: " .. Karma_NilToString(arg1));
	end
end

---
---- list choice
---
function	KarmaWindow_ListChoice_Checkbox_OnLoad(self, ListChar)
	if (ListChar) and (ListChar ~= "") then
		self:SetChecked(KCfg.Get("MAINWND_LIST_" .. ListChar));
		KarmaWindow_Lists_SetAnchors();
	end
end

function	KarmaWindow_ListChoice_Checkbox_OnClick(self, ListChar)
	if (ListChar) and (ListChar ~= "") then
		KCfg.Set("MAINWND_LIST_" .. ListChar, KOH.Nil1To01(self:GetChecked()));
		KarmaWindow_Lists_SetAnchors();
	end
end

---
---- Skill Button
---
function	Karma_SkillButton_Menu_Initialize()
	KarmaObj.ProfileStart("Karma_SkillButton_Menu_Initialize")

	if (Karma_CurrentMemberValid()) then
		local	info;
		info = {};
		info.text = KARMA_CURRENTMEMBER .. KARMA_WINEL_FRAG_COLONSPACE .. KARMA_WINEL_CHOSENPLAYERSKILLTITLE;
		info.isTitle = 1;
		info.notCheckable = 1;
		UIDropDownMenu_AddButton(info);

		info = {};
		info.func = Karma_SkillButton_Menu_OnSelect;
		info.arg2 = KARMA_CURRENTMEMBER;
		for i = 0, 100 do
			if (KARMA_SKILL_LEVELS[i]) then
				info.text = KARMA_SKILL_LEVELS[i];
				info.arg1 = i;
		
				UIDropDownMenu_AddButton(info);
			end
		end

		info.text = "----------------------------------------";
		info.notClickable = 1;
		info.arg1 = nil;
		UIDropDownMenu_AddButton(info);

		info = {};
		info.func = Karma_SkillButton_Menu_OnSelect;
		info.text = KARMA_LEVEL_RESET;
		info.arg1 = -1;
		info.arg2 = KARMA_CURRENTMEMBER;
		UIDropDownMenu_AddButton(info);
	end

	KarmaObj.ProfileStop("Karma_SkillButton_Menu_Initialize")
end

function	Karma_SkillButton_Menu_OnSelect(self, arg1, arg2)
	KarmaObj.ProfileStart("Karma_SkillButton_Menu_OnSelect")

	local	oMember = Karma_MemberList_GetObject(arg2);
	if (oMember ~= nil) and (arg1 ~= nil) then
		Karma_MemberObject_SetSkill(oMember, arg1);
		KarmaWindow_Update();
	end

	KarmaObj.ProfileStop("Karma_SkillButton_Menu_OnSelect")
end

function	KarmaWindow_SkillButton_OnClick(buttonobject, mousebutton)
	KarmaObj.ProfileStart("KarmaWindow_SkillButton_OnClick")

	GameTooltip:Hide()
	if (Karma_CurrentMemberValid()) then
		ToggleDropDownMenu(1, nil, Karma_SkillButton_Menu, buttonobject, 0, 0);
	end

	KarmaObj.ProfileStop("KarmaWindow_SkillButton_OnClick")
end

---
---- Gear/PVE Button
---
function	Karma_GearPVEButton_Menu_Initialize()
	KarmaObj.ProfileStart("Karma_GearPVEButton_Menu_Initialize")

	if (Karma_CurrentMemberValid()) then
		local	info;
		info = {};
		info.text = KARMA_CURRENTMEMBER .. KARMA_WINEL_FRAG_COLONSPACE .. KARMA_WINEL_CHOSENPLAYERGEARPVETITLE;
		info.isTitle = 1;
		info.notCheckable = 1;
		UIDropDownMenu_AddButton(info);

		info = {};
		info.func = Karma_GearPVEButton_Menu_OnSelect;
		info.arg2 = KARMA_CURRENTMEMBER;
		for i = 0, 100 do
			if (KARMA_GEAR_PVE_LEVELS[i]) then
				info.text = KARMA_GEAR_PVE_LEVELS[i];
				info.arg1 = i;
		
				UIDropDownMenu_AddButton(info);
			end
		end

		info.text = "----------------------------------------";
		info.notClickable = 1;
		info.arg1 = nil;
		UIDropDownMenu_AddButton(info);

		info = {};
		info.func = Karma_GearPVEButton_Menu_OnSelect;
		info.text = KARMA_LEVEL_RESET;
		info.arg1 = -1;
		info.arg2 = KARMA_CURRENTMEMBER;
		UIDropDownMenu_AddButton(info);
	end

	KarmaObj.ProfileStop("Karma_GearPVEButton_Menu_Initialize")
end

function	Karma_GearPVEButton_Menu_OnSelect(self, arg1, arg2)
	KarmaObj.ProfileStart("Karma_GearPVEButton_Menu_OnSelect")

	local	oMember = Karma_MemberList_GetObject(arg2);
	if (oMember ~= nil) and (arg1 ~= nil) then
		Karma_MemberObject_SetGearPVE(oMember, arg1);
		KarmaWindow_Update();
	end

	KarmaObj.ProfileStop("Karma_GearPVEButton_Menu_OnSelect")
end

function	KarmaWindow_GearPVEButton_OnClick(buttonobject, mousebutton)
	KarmaObj.ProfileStart("KarmaWindow_GearPVEButton_OnClick")

	GameTooltip:Hide()
	if (Karma_CurrentMemberValid()) then
		ToggleDropDownMenu(1, nil, Karma_GearPVEButton_Menu, buttonobject, 0, 0);
	end

	KarmaObj.ProfileStop("KarmaWindow_GearPVEButton_OnClick")
end

---
---- Gear/PVP Button
---
function	Karma_GearPVPButton_Menu_Initialize()
	KarmaObj.ProfileStart("Karma_GearPVPButton_Menu_Initialize")

	if (Karma_CurrentMemberValid()) then
		local	info;
		info = {};
		info.text = KARMA_CURRENTMEMBER .. KARMA_WINEL_FRAG_COLONSPACE .. KARMA_WINEL_CHOSENPLAYERGEARPVPTITLE;
		info.isTitle = 1;
		info.notCheckable = 1;
		UIDropDownMenu_AddButton(info);

		info = {};
		info.func = Karma_GearPVPButton_Menu_OnSelect;
		info.arg2 = KARMA_CURRENTMEMBER;
		for i = 0, 100 do
			if (KARMA_GEAR_PVP_LEVELS[i]) then
				info.text = KARMA_GEAR_PVP_LEVELS[i];
				info.arg1 = i;
		
				UIDropDownMenu_AddButton(info);
			end
		end

		info.text = "----------------------------------------";
		info.notClickable = 1;
		info.arg1 = nil;
		UIDropDownMenu_AddButton(info);

		info = {};
		info.func = Karma_GearPVPButton_Menu_OnSelect;
		info.text = KARMA_LEVEL_RESET;
		info.arg1 = -1;
		info.arg2 = KARMA_CURRENTMEMBER;
		UIDropDownMenu_AddButton(info);
	end

	KarmaObj.ProfileStop("Karma_GearPVPButton_Menu_Initialize")
end

function	Karma_GearPVPButton_Menu_OnSelect(self, arg1, arg2)
	KarmaObj.ProfileStart("Karma_GearPVPButton_Menu_OnSelect")

	local	oMember = Karma_MemberList_GetObject(arg2);
	if (oMember ~= nil) and (arg1 ~= nil) then
		Karma_MemberObject_SetGearPVP(oMember, arg1);
		KarmaWindow_Update();
	end

	KarmaObj.ProfileStop("Karma_GearPVPButton_Menu_OnSelect")
end

function	KarmaWindow_GearPVPButton_OnClick(buttonobject, mousebutton)
	KarmaObj.ProfileStart("KarmaWindow_GearPVPButton_OnClick")

	GameTooltip:Hide()
	if (Karma_CurrentMemberValid()) then
		ToggleDropDownMenu(1, nil, Karma_GearPVPButton_Menu, buttonobject, 0, 0);
	end

	KarmaObj.ProfileStop("KarmaWindow_GearPVPButton_OnClick")
end

--
-- Page 2
--
function	KarmaObj.UI.NotesPublic.QueryBtnClicked(oQueryBtn, sMousebutton)
	if (KARMA_CURRENTMEMBER == nil) then
		KarmaChatDefault("No player selected!");
		return
	end

	if (GetNumGuildMembers() > 1) then
		local	args = {};
		args[2] = "$GUILD";
		args[3] = KARMA_CURRENTMEMBER;
		-- "?p" - request
		KSlash.ShareQuery(args, 3, true);
	else
		KarmaChatDefault("You're the only guild member online to query about " .. KARMA_CURRENTMEMBER .. "... (At least that's what the UI claims. Did you open your social frame yet?)");
	end


	local	args = {};
	args[2] = "#";
	args[3] = KARMA_CURRENTMEMBER;
	-- "?p" - request
	KSlash.ShareQuery(args, 3, true);
end

function	KarmaObj.UI.NotesPublic.ResultsTip(self, motion)
	GameTooltip:SetOwner(self, "ANCHOR_RIGHT");
	if (KARMA_CURRENTMEMBER ~= nil) then
		GameTooltip:AddLine("Karma/public notes about: " .. KARMA_CURRENTMEMBER, 1, 1, 0);
		GameTooltip:AddLine(" ");

		if (KarmaModuleLocal.NotesPublic.Results[KARMA_CURRENTMEMBER] ~= nil) then
			local	sFrom, aStance;
			for sFrom, aStance in pairs(KarmaModuleLocal.NotesPublic.Results[KARMA_CURRENTMEMBER]) do
				local	sFromOut = sFrom;
				local	red, green, blue = Karma_GetColors_Karma(sFrom);
				if (red + green + blue < 2.95) then
					sFromOut = format("|cFF%02X%02X%02X%s|r", red, green, blue, sFrom);
				end

				local	sLine = sFromOut .. " says:";
				if (aStance.sKarma) then
					sLine = sLine .. " [" .. aStance.sKarma .. "]";
				end
				if (aStance.sNotePub) then
					sLine = sLine .. " => <<" .. aStance.sNotePub .. ">>";
				end
				GameTooltip:AddLine(sLine, 1, 1, 1);
			end
		else
			GameTooltip:AddLine("No information available.");
		end
	else
		GameTooltip:AddLine("No player selected.");
	end

	GameTooltip:Show();
end

function	KarmaObj.UI.NotesPublic.Get(sName)
	if (sName) then
		return KarmaModuleLocal.NotesPublic.Results[sName];
	end
end

-----------------------------------------
--	UNITPopUp Patch
-----------------------------------------

function	Karma_InsertChatFramePatch()
	if (KARMA_OriginalChatFrame_OnEvent == nil) then
		KARMA_OriginalChatFrame_OnEvent = ChatFrame_OnEvent;
		ChatFrame_OnEvent = Karma_ChatFrame_OnEvent;
	end
end

-- TODO: change to hooksecurefunc? or will that open the FriendsFrame on /who?
--[[
function	Karma_InsertWhoUpdatePatch()
	if (KARMA_Original_Who_Update == nil) then
		KARMA_Original_Who_Update = FriendsFrame_OnEvent
		FriendsFrame_OnEvent = Karma_Who_Update;
	end
end
]]--

function	Karma_Event_PlayerTargetChanged()
	Karma_UpdateCurrentTargetNameColor();

	if (KarmaWindow:IsVisible() and Karma_CurrentMemberValid()) then
		return;
	end

	-- window is not open or no member is chosen
	if  (UnitName("target") ~= nil) and (UnitName("target") ~= KARMA_UNKNOWN) and
		UnitIsPlayer("target") and not (UnitIsUnit("target", "player")) and 
		(UnitFactionGroup("target") == UnitFactionGroup("player")) then

		local	targetname, targetserver = UnitName("target");
		local	oMember = Karma_MemberList_GetObject(targetname, targetserver);
		if (oMember) then
			if (targetserver and (targetserver ~= "")) then
				targetname = targetname .. "@" .. targetserver;
			end
			Karma_SetCurrentMember(targetname);
		end
	end
end

function	Karma_Event_UpdateMouseOverUnit()
	if (UnitIsPlayer("mouseover") and not UnitIsUnit("player", "mouseover") and not IsInInstance()) then
		local	key, value;
		for key, value in pairs(KarmaModuleLocal.MouseOverKeepList) do
			if (value.GUID == UnitGUID("mouseover")) then
				value.Time = time();
				return;
			end
		end

		-- not yet in storage. add
		KarmaModuleLocal.MouseOverKeepIndex = KarmaModuleLocal.MouseOverKeepIndex + 1;
		if (KarmaModuleLocal.MouseOverKeepIndex == KarmaModuleLocal.MouseOverKeepCount + 1) then
			KarmaModuleLocal.MouseOverKeepIndex = 1;
		end
		KarmaModuleLocal.MouseOverKeepList[KarmaModuleLocal.MouseOverKeepIndex] = {};
		local	Value = KarmaModuleLocal.MouseOverKeepList[KarmaModuleLocal.MouseOverKeepIndex];
		Value.GUID = UnitGUID("mouseover");
		Value.Faction = UnitFactionGroup("mouseover");
		local	sName, sServer = UnitName("mouseover");
		if (sServer and (sServer ~= "")) then
			sName = sName .. "@" .. sServer;
		end
		Value.Name = sName;
		Value.Level = UnitLevel("mouseover");
		local	sRaceLocalized, sRaceEN = UnitRace("mouseover");
		Value.Race = sRaceLocalized;
		Value.RaceEN = sRaceEN;
		local	sClassLocalized, sClassEN = UnitClass("mouseover");
		Value.Class = sClassLocalized;
		Value.ClassEN = sClassEN;
		Value.Sex = UnitSex("mouseover");

		Value.Time = time();
		Value.Zone = GetZoneText() .. ": " ..  GetSubZoneText();
		local	_x, _y = GetPlayerMapPosition("player");
		if (_x == 0) and (_y == 0) then
			SetMapToCurrentZone();
			_x, _y = GetPlayerMapPosition("player");
		end
		Value.Koords = { x = _x, y = _y };

		if (KARMA_CURRENTLIST == 3) then
			KarmaWindow_UpdateMemberList();
		end
	end
end

function	Karma_MouseOverUnitLog_Compare(val1, val2)
	return (val1.Time < val2.Time);
end

function	Karma_MouseOverUnitLog_Status(args)
	local	i, order, key, trans, value, name2click;
	local	playerfaction = UnitFactionGroup("player");
	if (args[2]) and (args[2] ~= "") then
		local	key = tonumber(args[2]);
		if (key) then
			value = KarmaModuleLocal.MouseOverKeepList[key];
			if (value.Faction == playerfaction) then
				name2click = "|cFF80FF80" .. KOH.Name2Clickable(value.Name) .. "|r";
			else
				name2click = "|cFFFF8080" .. value.Name .. "|r";
			end
			KarmaChatSecondary("[" .. key .. ": " .. value.Faction .. "] " .. name2click .. " " .. value.Race .. " " .. value.Level .. " " .. value.Class .. " (" .. date("%H:%M:%S", value.Time) .. ")");
			KarmaChatSecondary("-- seen at " .. value.Zone .. " { X = " .. value.Koords.x .. ", Y = " .. value.Koords.y .. " }");
		else
			for i = 1, KarmaModuleLocal.MouseOverKeepCount do
				if (KarmaModuleLocal.MouseOverKeepList[i]) then
					value = KarmaModuleLocal.MouseOverKeepList[i];
					if (strfind(value.Name, args[2], 1, true) ~= nil) then
						if (value.Faction == playerfaction) then
							name2click = "|cFF80FF80" .. KOH.Name2Clickable(value.Name) .. "|r";
						else	-- foreign also clickable to be able to shift-click to copy to chatline
							name2click = "|cFFFF8080" .. KOH.Name2Clickable(value.Name) .. "|r";
						end
						KarmaChatSecondary("[" .. i .. ": " .. value.Faction .. "] " .. name2click .. " " .. value.Race .. " " .. value.Level .. " " .. value.Class .. " (" .. date("%H:%M:%S", value.Time) .. ")");
						KarmaChatSecondary("-- seen at " .. value.Zone .. " { X = " .. value.Koords.x .. ", Y = " .. value.Koords.y .. " }");
					end
				end
			end
		end

		return
	end

	KarmaChatSecondary("Most recent up to " .. KarmaModuleLocal.MouseOverKeepCount .. " mouse-overs:");

	local	order = {};
	for i = 1, KarmaModuleLocal.MouseOverKeepCount do
		if (KarmaModuleLocal.MouseOverKeepList[i]) then
			order[i] = { Index = i, Time = KarmaModuleLocal.MouseOverKeepList[i].Time };
		end
	end

	KOH.GenericSort(order, Karma_MouseOverUnitLog_Compare);

	local	trans;
	for key, trans in pairs(order) do
		value = KarmaModuleLocal.MouseOverKeepList[trans.Index];
		if (value) then
			if (value.Faction == playerfaction) then
				name2click = "|cFF80FF80" .. KOH.Name2Clickable(value.Name) .. "|r";
			else
				name2click = "|cFFFF8080" .. value.Name .. "|r";
			end
			KarmaChatSecondary("{" .. trans.Index .. ": " .. value.Faction .. "} " .. name2click .. " " .. value.Race .. " " .. value.Level .. " " .. value.Class .. " (" .. date("%H:%M:%S", value.Time) .. ")");
		end
	end

	KarmaChatSecondary("***");
end

-----------------------------------------
--	Other commands
-----------------------------------------

function	Karma_CommandChannelCheck(args)
	if (KarmaModuleLocal.ChannelName) then
		KarmaChatDefault("Channel check is still running for channel " .. KarmaModuleLocal.ChannelName .. ", try again in a bit...");
		return
	end

	local	Channel = args.sChannel;
	if (strlen(Channel) == 1) then
		if (tonumber(Channel)) then
			Channel = tonumber(Channel);
		end
	end
	if (type(Channel) == "number") then
		KarmaChatDefault(KARMA_MSG_CHECKCHANNEL_ONE .. " #" .. args.sChannel);
	else
		KarmaChatDefault(KARMA_MSG_CHECKCHANNEL_ONE .. " <" .. args.sChannel .. ">");
	end

	KarmaModuleLocal.ChannelTime = GetTime();
	KarmaModuleLocal.ChannelName = Channel;
	KarmaModuleLocal.ChannelResultCount = 0;
	KarmaModuleLocal.ChannelMemberCount = 0;

	ListChannelByName(Channel);

	-- delay next command by 5 seconds (automatic reset in ChatEvent is after 10.x seconds)
	KarmaModuleLocal.Timers.CmdQ = GetTime() + 5;
end

function	Karma_QueueCommandChannelCheck(channel)
	local	oCmd = { sName = "channelcheck - " .. channel, func = Karma_CommandChannelCheck, args = { sChannel = channel }};
	KarmaObj.Slash.CommandQAdd(oCmd);
end

-----------------------------------------
--	Karma_Who_Update - Callees
-----------------------------------------

function	Karma_Command_AddIgnore_Insert(args)
	local	oCmdA = { sName = "addignorecheck - "..args[2], func = Karma_Command_AddIgnore_Start, args = {sName = args[2]}};
	local	oCmdB = { sName = "updatewindow", func = Karma_Command_UpdateMembers, args = {}};
	KarmaObj.Slash.CommandQAddPrio( { [1] = oCmdA, [2] = oCmdB } );
end

function	Karma_Command_AddIgnore_Start(args)
	local	bLock, sLock = KarmaObj.Slash.CommandQLock("AddIgnore");
	if (not bLock) then
		return
	end

	-- Create a who command and send it to the server for processing
	local	whotext = WHO_TAG_NAME.."\""..args.sName.."\""
	Karma_WhoQueue[getn(Karma_WhoQueue)+1] = { func = Karma_AddIgnore_Complete, sName = args.sName, text = whotext};
end

function	Karma_AddIgnore_Complete(addname)
	local	numWhos, totalCount = GetNumWhoResults();
	local	sName, sNameLower, guild, level, race, class, zone, group;
	local	i = 0;
	local	found = false;
	-- Huh? Makes it impossible to have an accented letter as first in name, which is a common tactic of pvp losers...
	-- addname = string.upper(KarmaObj.NameToBucket(strsub(addname, 1, 1)))..strsub(addname, 2)
	local addnameLower = strlower(addname);
	for i = 1, totalCount do
		sName, guild, level, race, class, zone, group = GetWhoInfo(i);
		sNameLower = strlower(sName);
		if (sNameLower == addnameLower) then
			Karma_MemberList_Add(sName);
			Karma_MemberList_Update(sName, level, class, race, guild);

			local	mo = Karma_MemberList_GetObject(addname);
			KarmaObj.DB.M.KarmaSet(mo, 1);
			KarmaChatDefault(addname .. KARMA_MSG_IGNOREMEMBER_ADDED);
			found = true;
		end
	end
	if (found == false) then
		KarmaChatDefault(addname .. KARMA_MSG_ADDORIGNMEMBER_OFFLINE);
	end
	if (FriendsFrame:IsVisible()) then
		SetWhoToUI(1);
	else
		SetWhoToUI(0);
	end

	Karma_Executing_Who = nil;
	KarmaObj.Slash.CommandQUnlock("AddIgnore");
end

function	Karma_Command_AddMember_Insert(args)
	local	cmdargs = { sName = args[2], bForce = (args[3] == "force") };
	local	oCmdA = { sName = "addmembercheck - " .. args[2], func = Karma_Command_AddMember_Start, args = cmdargs };
	local	oCmdB = { sName = "updatewindow", func = Karma_Command_UpdateMembers, args = {}};
	KarmaObj.Slash.CommandQAddPrio( { [1] = oCmdA, [2] = oCmdB } );
end

function	Karma_Command_AddMember_Start(args)
	local	bLock, sLock = KarmaObj.Slash.CommandQLock("AddMember");
	if (not bLock) then
		return
	end

	-- Create a who command and send it to the server for processing
	local	whotext = WHO_TAG_NAME.."\""..args.sName.."\""
	Karma_WhoQueue[getn(Karma_WhoQueue)+1] = { method = Karma_AddMember_Complete, sName = args.sName, bForce = args.bForce, text = whotext};
end

function	Karma_AddMember_Complete(data)
	local	addname = data.sName;
	local	numWhos, totalCount = GetNumWhoResults();
	local	sName, sNameLower, guild, level, race, class, zone, group;
	local	i = 0;
	local	found = false;
	-- Huh? Makes it impossible to have an accented letter as first in name, which is a common tactic of pvp losers...
	-- addname = string.upper(KarmaObj.NameToBucket(strsub(addname, 1, 1)))..strsub(addname, 2)
	local addnameLower = strlower(addname);
	for i = 1, totalCount do
		sName, guild, level, race, class, zone, group = GetWhoInfo(i);
		sNameLower = strlower(sName);
		if (sNameLower == addnameLower) then
			Karma_MemberList_Add(sName);
			Karma_MemberList_Update(sName, level, class, race, guild);
			local	addname_clickable = KOH.Name2Clickable(addname);
			KarmaChatDefault(addname_clickable .. KARMA_MSG_ADDMEMBER_ADDED);

			local	oMember = Karma_MemberList_GetObject(sName);
			if (oMember) then
				local	sPlayerFaction, key, value = UnitFactionGroup("player");
				for key, value in pairs(KarmaModuleLocal.ChatRememberList) do
					if ((value.Name == sName) and (value.Faction == sPlayerFaction) and (value.Class == class) and (value.Race == race)) then
						-- value: GUID, Name, Time, Class, ClassEN, Race, RaceEN, Faction, Sex
						oMember[KARMA_DB_L5_RRFFM.GUID] = value.GUID;
						oMember[KARMA_DB_L5_RRFFM.GENDER] = value.Sex;
					end
				end
			end

			found = true;
		end
	end
	if (found == false) then
		if (data.bForce) then
			KarmaChatDefault("No information available. Still adding " .. addname .. " as requested.");
			Karma_MemberList_Add(addname);
			Karma_MemberList_Update(addname);
		else
			KarmaChatDefault(addname .. KARMA_MSG_ADDORIGNMEMBER_OFFLINE);
		end
	end
	if (FriendsFrame:IsVisible()) then
		SetWhoToUI(1);
	else
		SetWhoToUI(0);
	end

	Karma_Executing_Who = nil;
	KarmaObj.Slash.CommandQUnlock("AddMember");
end

function	Karma_Command_UpdateMember_Insert(args)
	local	oCmdA = { sName = "updatemembercheck - " .. args[2], func = Karma_Command_UpdateMember_Start, args = {sName = args[2]}};
	local	oCmdB = { sName = "updatemember completed - " .. args[2], func = Karma_Command_UpdateMembers, args = {}};
	KarmaObj.Slash.CommandQAddPrio( { [1] = oCmdA, [2] = oCmdB } );
end

function	Karma_Command_UpdateMember_Start(args)
	local	bLock, sLock = KarmaObj.Slash.CommandQLock("UpdateMember");
	if (not bLock) then
		return
	end

	-- Create a who command and send it to the server for processing
	local	whotext = WHO_TAG_NAME.."\""..args.sName.."\""
	Karma_WhoQueue[getn(Karma_WhoQueue)+1] = {func = Karma_UpdateMember_Complete, sName = args.sName, text = whotext};
end

function	Karma_UpdateMember_Complete(addname)
	local	numWhos, totalCount = GetNumWhoResults();

	local	sName, guild, level, race, class, zone, group;
	local	found = false;
	local	iNow, i = time();
	for i = 1, totalCount do
		sName, guild, level, race, class, zone, group = GetWhoInfo(i);

		if (KarmaObj.LFM) then
			KarmaObj.LFM.PlayerUpdateFromWhoResult(sName, iNow, guild, level, race, class, zone);
		end

		if (sName == addname) then
			-- no adding here, must already be on the list
			Karma_MemberList_Update(sName, level, class, race, guild);
			local	Msg = KOH.Name2Clickable(sName);
			if (guild) and (guild ~= "") then
				Msg = Msg .. " <" .. guild .. ">";
			end
			KarmaChatSecondary(Msg .. KARMA_MSG_UPDATEMEMBER_UPDATED .. Karma_NilToEmptyString(zone));
			found = true;
		end
	end
	if (found == false) and not UnitIsAFK("player") then
		KarmaChatDefault(addname .. KARMA_MSG_UPDATEMEMBER_OFFLINE);
	end
	if (FriendsFrame:IsVisible()) then
		SetWhoToUI(1);
	else
		SetWhoToUI(0);
	end

	Karma_Executing_Who = nil;
	KarmaObj.Slash.CommandQUnlock("UpdateMember");
end

function	Karma_Command_UpdateMembers(args)
	Karma_MemberList_ResetMemberNamesCache();
	KarmaWindow_Update();
end

function	Karma_Command_CheckOnline_Insert(args)
	local	CmdName = "onlinecheck - " .. args[2];
	if (args[3] ~= nil) then
		CmdName = CmdName .. "+" .. args[3];
	end
	local	oCmd = { sName = CmdName, func = Karma_Command_CheckOnline_Start, args = {sName = args[2], sClass = args[3]}};
	KarmaObj.Slash.CommandQAddPrio( { [1] = oCmd } );
end

function	Karma_Command_CheckOnline_Start(args)
	local	bLock, sLock = KarmaObj.Slash.CommandQLock("CheckOnline");
	if (not bLock) then
		return
	end

	-- Create a who command and send it to the server for processing
	local	whotext = WHO_TAG_NAME.."\""..args.sName.."\"";
	if (args.sClass ~= nil) then
		whotext = whotext .. " " .. WHO_TAG_CLASS .. args.sClass;
	end

	KarmaChatDebug("Sending " .. whotext);

	Karma_WhoQueue[getn(Karma_WhoQueue)+1] = {func = Karma_CheckOnline_Complete, sName = args.sName, sClass = args.sClass, text = whotext};
end

function	Karma_CheckOnline_Complete(namefrag, classfrag)
	local	totalCount, numWhos = GetNumWhoResults();
	KarmaChatDebug("Results for /who (n-" .. namefrag .. ", c-" .. Karma_NilToEmptyString(classfrag) .. "): " .. totalCount .. "+, accessible " .. numWhos);

	local	lMembers = KarmaObj.DB.SF.MemberListGet();

	local	sName, guild, level, race, class, zone, group;
	local	iNow, i = time();
	for i = 1, numWhos do
		sName, guild, level, race, class, zone, group = GetWhoInfo(i);

		if (KarmaObj.LFM) then
			KarmaObj.LFM.PlayerUpdateFromWhoResult(sName, iNow, guild, level, race, class, zone);
		end

		local	oMember = Karma_MemberList_GetObject(sName, nil, lMembers);
		if (oMember ~= nil) then
			Karma_MemberList_Update(sName, level, class, race, guild);
			local	Msg = KOH.Name2Clickable(sName);
			if (guild) and (guild ~= "") then
				Msg = Msg .. " <" .. guild .. ">";
			end
			KarmaChatSecondary(Msg .. KARMA_MSG_UPDATEMEMBER_ONLINE .. Karma_NilToEmptyString(zone));
		end
	end

	if (FriendsFrame:IsVisible()) then
		SetWhoToUI(1);
	else
		SetWhoToUI(0);
	end

	Karma_Executing_Who = nil;
	KarmaObj.Slash.CommandQUnlock("CheckOnline");
end

function	Karma_Command_CompareClassOnline_Insert(args, races)
	local	CmdName = "classcall - " .. args[2];
	if (args[3] and args[3] ~= "") then
		CmdName = CmdName .. "+" .. args[3];
	end
	if (args[4] and args[4] ~= "") then
		CmdName = CmdName .. "(" .. args[4] .. ")";
	end

	local	params = { sClass = args[2], sRace = args[3], sLevel = args[4] };
	local	oCmd = { sName = CmdName, method = Karma_Command_CompareClassOnline_Start, args = params, races = races };
	KarmaObj.Slash.CommandQAdd(oCmd);
end

function	Karma_Command_CompareClassOnline_Start(oData)
	local	args = oData.args;
	if args.sClass == nil then
		return
	end

	local	sOutput = args.sClass;

	-- Create a who command and send it to the server for processing
	local	whotext = WHO_TAG_CLASS .. args.sClass;
	if (args.sClass == "ANY") then
		whotext = "";
	end

	if (args.sRace ~= nil) then
		sOutput = args.sRace .. "+" .. sOutput;
		whotext = whotext .. " ".. WHO_TAG_RACE .. args.sRace;
	end
	if (args.sLevel ~= nil) then
		sOutput = sOutput .. "(" .. args.sLevel .. ")";
		-- there is no "WHO_TAG_LEVEL"...
		whotext = whotext .. " ".. args.sLevel;
	end
	if (args.sClass == "ANY") then
		whotext = strsub(whotext, 2);
		if (whotext == "") then
			KarmaChatDebug("Empty /who... no class.");
			return
		end
	end

	local	bLock, sLock = KarmaObj.Slash.CommandQLock("CompareClassOnline");
	if (not bLock) then
		return
	end

	-- KarmaChatSecondaryFallbackDefault(KARMA_MSG_CHECKING_FOR .. sOutput .. KARMA_WINEL_FRAG_TRIDOTS);
	KarmaChatDebug("Sending /who " .. whotext .. KARMA_WINEL_FRAG_TRIDOTS);

	Karma_WhoQueue[getn(Karma_WhoQueue)+1] = { method = Karma_Command_CompareClassOnline_Complete, text = whotext, args = args, races = oData.races};
end

function	Karma_Command_CompareClassOnline_Complete(oData)
	local	args = oData.args;
	local	whoclass, whorace, wholevel, whotext = args.sClass, args.sRace, args.sLevel, oData.text;
	local	numWhos, totalCount = GetNumWhoResults();

	KarmaChatDebug("Results for /who " .. Karma_NilToString(whotext) .. KARMA_WINEL_FRAG_COLONSPACE .. totalCount .. ", accessible " .. numWhos);
	if (numWhos > 0) then
		local whoargs = whoclass;
		if (whorace) then
			whoargs = whorace .. "+" .. whoargs;
		end
		if (wholevel and wholevel ~= "") then
			whoargs = whoargs .. "(" .. wholevel .. ")";
		end
		local	Msg = KARMA_MSG_WHORESULT_1 .. whoargs .. KARMA_MSG_WHORESULT_2 .. tostring(totalCount) .. KARMA_MSG_WHORESULT_3;
		if (numWhos == 50) then
			Msg = Msg .. KARMA_MSG_WHORESULT_4;
		end
		KarmaChatSecondaryFallbackDefault(Msg);
	end

	local	lMembers = KarmaObj.DB.SF.MemberListGet();

	local	sName, guild, level, race, class, zone, group;
	local	iNow, i = time();
	for i = 1, numWhos do
		sName, guild, level, race, class, zone, group = GetWhoInfo(i);

		if (KarmaObj.LFM) then
			KarmaObj.LFM.PlayerUpdateFromWhoResult(sName, iNow, guild, level, race, class, zone);
		end

		local	oMember = Karma_MemberList_GetObject(sName, nil, lMembers);
		if (oMember ~= nil) then
			local	iKarma, bModified = Karma_MemberObject_GetKarmaModified(oMember);
			if (bModified) then
				iKarma = "*" .. iKarma;
			end
			Karma_MemberList_Update(sName, level, class, race, guild);
			local	sNameClickable = KOH.Name2Clickable(sName);
			KarmaChatSecondary(sNameClickable .. "{" .. iKarma .. "} " .. KARMA_MSG_UPDATEMEMBER_ONLINE .. Karma_NilToEmptyString(zone));
		end
	end

	if ((numWhos == 50) and (whoclass ~= "ANY")) then
		args.sLevel = args.sLevel or ("1-" .. KarmaObj.Const.LevelMax);
		local	sFrom, sTo;
		if (strfind(args.sLevel, "-", 1, true)) then
			sFrom, sTo = string.match(args.sLevel, "(%d+)%-(%d+)");
		else
			sFrom = string.match(args.sLevel, "(%d+)");
			if (sFrom == args.sLevel) then
				sTo = sFrom;
			end
		end

		local	iFrom, iTo;
		if (sFrom and sTo) then
			iFrom, iTo = tonumber(sFrom), tonumber(sTo);
			if (iFrom and iTo) then
				if (iFrom ~= iTo) then
					KarmaChatDebug("Abundant results for " .. whoclass .. " (" .. wholevel .. "), splitting by level.");

					local	argswithoutrace = {};
					argswithoutrace[2] = args.sClass;

					local	iMiddle;
					if (iFrom > 40) then
						-- high level: tends to be fuller at the higher end
						iMiddle = math.ceil((    iFrom + 3 * iTo) / 4);
					elseif (iTo < 40) then
						-- low level: tends to be fuller at the lower end (bank alts etc.)
						iMiddle = math.ceil((3 * iFrom +     iTo) / 4);
					else
						-- default: "middle" is in the middle
						iMiddle = math.ceil((    iFrom +     iTo) / 2);
					end
					if (iTo == KarmaObj.Const.LevelMax) then
						-- split off max level first, this will almost always overflow
						iMiddle = KarmaObj.Const.LevelMax;
					end

					if ((iMiddle - 1) > iFrom) then
						argswithoutrace[4] = iFrom .. "-" .. (iMiddle - 1);
					else
						argswithoutrace[4] = tostring(iFrom);
					end
					Karma_Command_CompareClassOnline_Insert(argswithoutrace, oData.races);
					if (iMiddle ~= iTo) then
						argswithoutrace[4] = iMiddle .. "-" .. iTo;
					else
						argswithoutrace[4] = tostring(iTo);
					end
					Karma_Command_CompareClassOnline_Insert(argswithoutrace, oData.races);
				elseif ((iFrom == iTo) and (whorace == nil) and (type(oData.races) == "table")) then
					if (#oData.races > 1) then
						KarmaChatDebug("Abundant results for " .. whoclass .. " (" .. wholevel .. "), splitting by race.");

						local	argswithrace = {};
						argswithrace[2] = args.sClass;
						argswithrace[4] = args.sLevel;
						local	k, v;
						for k, v in pairs(oData.races) do
							argswithrace[3] = v;
							Karma_Command_CompareClassOnline_Insert(argswithrace);
						end
					else
						KarmaChatDebug("Abundant results for " .. whoclass .. " (" .. wholevel .. "), only one race? (" .. #oData.races .. ")");
					end
				end
			end

			if (not iFrom or not iTo) then
				KarmaChatDebug("Abundant results for " .. whoclass .. " (" .. wholevel .. ") - failed to parse level??");
			end
		end
	end

	if (FriendsFrame:IsVisible()) then
		SetWhoToUI(1);
	else
		SetWhoToUI(0);
	end

	Karma_Executing_Who = nil;
	KarmaObj.Slash.CommandQUnlock("CompareClassOnline");
end

function	Karma_Command_CompareGuildOnline_Insert(args)
	local	oCmd = { sName = "guildcall", func = Karma_Command_CompareGuildOnline_Start, args = args };
	KarmaObj.Slash.CommandQAdd(oCmd);
end

function	Karma_Command_CompareGuildOnline_Start(args)
	local	bLock, sLock = KarmaObj.Slash.CommandQLock("CompareGuildOnline");
	if (not bLock) then
		return
	end

	-- Create a who command and send it to the server for processing
	args[1] = "";
	local	whotext = WHO_TAG_GUILD .. "\"" .. strsub(table.concat(args, " "), 2) .. "\"";
	KarmaChatDebug("Sending /who " .. whotext .. KARMA_WINEL_FRAG_TRIDOTS);
	KarmaChatSecondaryFallbackDefault(KARMA_MSG_CHECKING_FOR .. "<" .. strsub(whotext, 4, strlen(whotext) - 1) .. ">" .. KARMA_WINEL_FRAG_TRIDOTS);

	Karma_WhoQueue[getn(Karma_WhoQueue)+1] = {func = Karma_Command_CompareGuildOnline_Complete, text = whotext};
end

function	Karma_Command_CompareGuildOnline_Complete(whoname, whoclass, whorace, whotext)
	local	numWhos, totalCount = GetNumWhoResults();

	KarmaChatDebug("Results for /who " .. whotext .. KARMA_WINEL_FRAG_COLONSPACE .. totalCount .. ", accessible " .. numWhos);
	if (numWhos > 0) then
		local	Msg = KARMA_MSG_WHORESULT_1 .. "<" .. strsub(whotext, 4, strlen(whotext) - 1) .. ">" .. KARMA_MSG_WHORESULT_2 .. tostring(totalCount) .. KARMA_MSG_WHORESULT_3;
		if (numWhos == 50) then
			Msg = Msg .. KARMA_MSG_WHORESULT_4;
		end
		KarmaChatSecondaryFallbackDefault(Msg);
	end

	local	lMembers = KarmaObj.DB.SF.MemberListGet();

	local	sName, guild, level, race, class, zone, group;
	local	iNow, i = time();
	for i = 1, numWhos do
		sName, guild, level, race, class, zone, group = GetWhoInfo(i);

		if (KarmaObj.LFM) then
			KarmaObj.LFM.PlayerUpdateFromWhoResult(sName, iNow, guild, level, race, class, zone);
		end

		local	oMember = Karma_MemberList_GetObject(sName, nil, lMembers);
		if (oMember ~= nil) then
			local	iKarma, bModified = Karma_MemberObject_GetKarmaModified(oMember);
			if (bModified) then
				iKarma = "*" .. iKarma;
			end
			Karma_MemberList_Update(sName, level, class, race, guild);
			local	sNameClickable = KOH.Name2Clickable(sName);
			KarmaChatSecondary(sNameClickable .. "{" .. iKarma .. "} " .. KARMA_MSG_UPDATEMEMBER_ONLINE .. Karma_NilToEmptyString(zone));
		end
	end

	if (FriendsFrame:IsVisible()) then
		SetWhoToUI(1);
	else
		SetWhoToUI(0);
	end

	Karma_Executing_Who = nil;
	KarmaObj.Slash.CommandQUnlock("CompareGuildOnline");
end


local function WhoUpdateShowKarmaAndNote()
	if (GetNumWhoResults() == 1) then
		local	sName, guild, level, race, class, zone, group = GetWhoInfo(1);
		if (KarmaModuleLocal.WhoInfoOnlyOnce_Char ~= sName) then
			KarmaModuleLocal.WhoInfoOnlyOnce_Char = sName;

			local	lMembers = KarmaObj.DB.SF.MemberListGet();
			local	sBucketName = KarmaObj.NameToBucket(sName);
			if (lMembers[sBucketName][sName] ~= nil) then
				Karma_MemberList_Update(sName, level, class, race, guild);
				local	oMember = Karma_MemberList_GetObject(sName);
				local	iKarma, bModified = Karma_MemberObject_GetKarmaModified(oMember);
				if (bModified) then
					iKarma = "*" .. iKarma;
				end
				local	sNameClickable = KOH.Name2Clickable(sName);
				local	sSkill = Karma_MemberObject_GetSkillText(oMember);
				if (sSkill) then
					sSkill = "\n-> Skill: " .. sSkill;
				else
					sSkill = "";
				end
				local	sNote = Karma_MemberObject_GetNotes(oMember);
				if sNote and (sNote ~= "") then
					local	sExtract = KOH.ExtractHeader(sNote);
					KarmaChatSecondary(KARMA_MSG_WHOCATCHED_GOTNOTES .. sNameClickable .. "{" .. iKarma .. "}:" .. sSkill .. "\n" .. sExtract);
				else
					KarmaChatSecondary(KARMA_MSG_WHOCATCHED_NONOTES .. sNameClickable .. "{" .. iKarma .. "}" .. sSkill .. ".");
				end
			else
				KarmaChatDebug(sName .. KARMA_MSG_UNKNOWN);
			end
		else
			KarmaChatDebug("Note already showed for this char.");
		end
	elseif (GetNumWhoResults() > 0) then
		KarmaChatDebug("Multiple /who results.");
	end
end

function	Karma_Who_Update(event, ...)
	local	_, iResultCnt = GetNumWhoResults();
	if ((iResultCnt > 0) and not InCombatLockdown()) then
		-- in combat we want minimal overhead

		local	lMembers = KarmaObj.DB.SF.MemberListGet();

		local	iNow, i = time();
		for i = 1, iResultCnt do
			local	sName, sGuild, iLevel, sRace, sClass, sZone, sClassEN = GetWhoInfo(i);
			if (KarmaObj.LFM) then
				KarmaObj.LFM.PlayerUpdateFromWhoResult(sName, iNow, sGuild, iLevel, sRace, sClass, sZone);
			end

			local	sBucket = KarmaObj.NameToBucket(sName);
			local	oMember = lMembers[sBucket][sName];
			if (oMember) then
				local	iClassID = KOH.ClassToID(sClass);
				if (0 == Karma_MemberList_CollisionCheck(oMember, sName, nil, iLevel, iClassID, sRace)) then
					oMember[KARMA_DB_L5_RRFFM.LASTSEEN] = iNow;
				end
			end

			KarmaObj.DB.HistorySeen(sName, iNow);
		end
	end

	if (KARMA_WhoRequestIsMine ~= 1) then
		return
	end

	KARMA_WhoRequestIsMine = 0;

	if (event ~= nil) then
		KarmaChatDebug("Karma_Who_Update: " .. event);
	end

	if (#Karma_WhoQueue == 0) then
		if (KARMA_Original_Who_Update ~= nil) then
			KARMA_Original_Who_Update(event, ...);
		end

		WhoUpdateShowKarmaAndNote();

		return
	end

	Karma_Who_Process();
end

function	Karma_Who_Process()
	local	elem = Karma_WhoQueue[1];
	local	i;
	if (#Karma_WhoQueue > 1) then
		for i = 2, #Karma_WhoQueue do
			Karma_WhoQueue[i - 1] = Karma_WhoQueue[i];
		end
		Karma_WhoQueue[#Karma_WhoQueue] = nil;
	else
		Karma_WhoQueue = table.wipe(Karma_WhoQueue);
	end

	if (type(elem.method) == "function") then
		elem:method();
	elseif (type(elem.func) == "function") then
		elem.func(elem.sName, elem.sClass, elem.sRace, elem.text);
	end

	WhoUpdateShowKarmaAndNote();
end

-----------------------------------------
-- Invite patch
-----------------------------------------

function	Karma_AutoIgnore_Invites(event)
	if (KCfg.Get("AUTOIGNORE") ~= 1) or
	   (KCfg.Get("AUTOIGNORE_INVITES") ~= 1) then
		return;
	end

	local	oMember = Karma_MemberList_GetObject(arg1);
	if (oMember == nil) then
		return;
	end

	local	karma = KarmaObj.DB.M.KarmaGet(oMember);
	local	threshold = tonumber(KCfg.Get("AUTOIGNORE_THRESHOLD"));
	if (karma > threshold) then
		return;
	end

	local	Msg = arg1 .. " (" .. karma .. KARMA_MSG_AUTOIGNORE_2 .. threshold .. KARMA_MSG_AUTOIGNORE_3;
	if (event == "GUILD_INVITE_REQUEST") then
		KarmaChatDefault(KARMA_MSG_AUTOIGNORE_GUILD .. Msg);
		DeclineGuild();
		StaticPopup_Hide("GUILD_INVITE");

		return;
	end

	if (event == "PARTY_INVITE_REQUEST") then
		KarmaChatDefault(KARMA_MSG_AUTOIGNORE_PARTY .. Msg);
		DeclineGroup();
		StaticPopup_Hide("PARTY_INVITE");

		return;
	end

	if (event == "TRADE_REQUEST") then
		KarmaChatDefault(KARMA_MSG_AUTOIGNORE_TRADE .. Msg);
		CancelTrade();
		StaticPopup_Hide("TRADE");

		return;
	end

	if (event == "DUEL_REQUESTED") then
		KarmaChatDefault(KARMA_MSG_AUTOIGNORE_DUEL .. Msg);
		CancelDuel();
		StaticPopup_Hide("DUEL_REQUESTED");

		return;
	end
end

-----------------------------------------
-- CHAT FUNCTIONS -- NEW METHOD ---------
-----------------------------------------

function	KarmaModuleLocal.ChatRememberStore(sName, sGUID, sMsg)
	local	iNow = time();
	local	iOldestIndex, iOldestTime = 0, -1;
	local	key, value;
	for key, value in pairs(KarmaModuleLocal.ChatRememberList) do
		if (value.GUID == sGUID) then
			if ((value.Message ~= sMsg) or (iNow - value.Time > 5)) then
				KOH.TableInit(value, "Messages");
				local	iCnt, i = #value.Messages;
				if (iCnt < 3) then
					iCnt = iCnt + 1;
					value.Messages[iCnt] = { Message = sMsg, At = iNow };
				else
					for i = 1, 2 do
						value.Messages[i] = value.Messages[i + 1];
					end
					value.Messages[3] = { Message = sMsg, At = iNow };
				end
			end

			value.Message = sMsg;
			value.Time = iNow;
			return;
		end

		if ((iOldestTime == -1) or (value.Time < iOldestTime)) then
			iOldestIndex = key;
			iOldestTime = value.Time;
		end
	end

	-- not yet in storage. add
	if (KarmaModuleLocal.ChatRememberList[KarmaModuleLocal.ChatRememberCount] == nil) then
		KarmaModuleLocal.ChatRememberIndex = KarmaModuleLocal.ChatRememberIndex + 1;
		if (KarmaModuleLocal.ChatRememberIndex == KarmaModuleLocal.ChatRememberCount + 1) then
			KarmaModuleLocal.ChatRememberIndex = 1;
		end
	else
		-- drop oldest
		KarmaModuleLocal.ChatRememberIndex = iOldestIndex;
	end

	KarmaModuleLocal.ChatRememberList[KarmaModuleLocal.ChatRememberIndex] = {};
	local	Value = KarmaModuleLocal.ChatRememberList[KarmaModuleLocal.ChatRememberIndex];
	Value.GUID = sGUID;
	Value.Name = sName;
	Value.Time = iNow;

	local	localizedClass, englishClass, localizedRace, englishRace, sex = GetPlayerInfoByGUID(sGUID);
	Value.Class = localizedClass;
	Value.ClassEN = englishClass;
	Value.Race = localizedRace;
	Value.RaceEN = englishRace;

	local	sRace, k, v = strupper(englishRace);
	for k, v in pairs(KARMA_RACES_ALLIANCE_LOCALIZED) do
		if (sRace == strsub(k, 5)) then
			Value.Faction = "Alliance";
			break
		end
	end
	for k, v in pairs(KARMA_RACES_HORDE_LOCALIZED) do
		if (sRace == strsub(k, 5)) then
			Value.Faction = "Horde";
			break
		end
	end

	Value.Sex = sex;
end

KarmaModuleLocal.ChatFilters["CHAT_MSG_SYSTEM"] = {	bRedo = false	};

KarmaModuleLocal.ChatFilters["CHAT_MSG_SYSTEM"].fFilter = function(ChatFrameSelf, event, ...)
	local	arg1 = ...;

	KarmaChatDebug("System MSG: <" .. arg1 .. ">.");

	do
		-- what does INVITATION represent? old baggage?
		-- "|Hplayer:%%s|h%[%%s%]|h" => "|Hplayer:[^|]+|h%[(.+)%]|h"
		local	sPattern = string.gsub(ERR_INVITED_TO_GROUP_SS, "|Hplayer:%%s|h%[%%s%]|h", "|Hplayer:[^|]+|h%%[(.+)%%]|h");
		local	sName = string.match(arg1, sPattern);
		if (sName) then
			KarmaChatDebug("|cFF8080FFInvite to group by " .. sName .. ".|r");
			KarmaObj.DB.I24.Add(sName, nil, "INVITE", "INVITE_A", nil);
		end
	end

	do
		local	sPattern = string.gsub(ERR_INVITED_ALREADY_IN_GROUP_SS, "|Hplayer:%%s|h%[%%s%]|h", "|Hplayer:[^|]+|h%%[(.+)%%]|h");
		local	sName = string.match(arg1, sPattern);
		if (sName) then
			KarmaChatDebug("|cFF8080FFFailed invite to group by " .. sName .. ".|r");
			KarmaObj.DB.I24.Add(sName, nil, "INVITE", "INVITE_B", nil);
		end
	end

	return false;
end

KarmaModuleLocal.ChatFilters["CHAT_MSG_CHANNEL_LIST"] = {	bRedo = false	};

KarmaModuleLocal.ChatFilters["CHAT_MSG_CHANNEL_LIST"].fFilter = function(ChatFrameSelf, event, ...)
	local	arg1, arg2, arg3, arg4 = ...;
	if (KarmaModuleLocal.ChannelName) then
		-- larger channels can take more than 5s!
		if (GetTime() > KarmaModuleLocal.ChannelTime + KARMA_CHECKCHANNEL_TIMEMAX) then
			Karma_CheckOnlineInChannelDone();
		else
			local	isChannel = false;
			if (type(KarmaModuleLocal.ChannelName) == "number") then
				-- by number
				local	iChannel = tonumber(strsub(arg4, 1, 1));
				if (iChannel == KarmaModuleLocal.ChannelName) then
					isChannel = true;
				end
			else
				-- by name: compensate e.g. "General - Stormwind City" by cutting at first space
				local	sChannel = strsub(arg4, 4);
				local	iPosSpace = strfind(sChannel, " ", 1, true);
				if (iPosSpace) then
					sChannel = strsub(sChannel, 1, iPosSpace - 1);
				end
				if (sChannel == KarmaModuleLocal.ChannelName) then
					isChannel = true;
				end
			end

			if (isChannel) then
				KarmaChatDebug("ChannelList to <" .. strsub(arg4, 4) .. ">: {" .. arg1 .. "}");
				Karma_CheckOnlineInChannelResults(" " .. arg1 .. ",");
				KarmaModuleLocal.ChannelTime = GetTime() + 5 - KARMA_CHECKCHANNEL_TIMEMAX;
				return true;
			else
				KarmaChatDebug("ChannelList to <" .. strsub(arg4, 4) .. ">: {" .. arg1 .. "} (probably not by Karma)");
			end
		end
	end

	return false;
end

KarmaModuleLocal.ChatFilters.fChannelFilter = function(ChatFrameSelf, event, ...)
	local	arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12 = ...;

	Karma_WhoAmIInit();
	if (arg2 == WhoAmI) then
		return false;
	end

	if (arg12 and (arg12 ~= "")) then
		KarmaModuleLocal.ChatRememberStore(arg2, arg12, arg1);
		if (event == "CHAT_MSG_WHISPER") then
			KarmaObj.DB.I24.Add(arg2, arg12, event, arg1);
		end
	end

	if (not KCfg.Get("MARKUP_ENABLED")) then
		return false;
	end

	local	vConfig;
	local	oEvent = KarmaModuleLocal.ChatFilters[event];
	if (type(oEvent) ~= "table") then
		-- currently: CHAT_MSG_ACHIEVEMENT
		if (KarmaModuleLocal.ChatFilterMissingWarning[event] == nil) then
			KarmaModuleLocal.ChatFilterMissingWarning[event] = true;
			KarmaChatDebug("fChannelFilter(): event has no config entry? <" .. event .. ">");
		end
	else
		if (oEvent.sConfigName) then
			vConfig = KCfg.Get(oEvent.sConfigName);
		elseif (oEvent.sConfig) then
			KarmaChatDebug("fChannelFilter(): event has only historic sConfig? <" .. event .. ">");
			vConfig = Karma_GetConfig(oEvent.sConfig);		-- fallback
		end
	end

	if (vConfig or (KCfg.Get("AUTOIGNORE") == 1)) then
		local	oMember = Karma_MemberList_GetObject(arg2);
		if (oMember == nil) then
			return false;
		end

		local	karma = KarmaObj.DB.M.KarmaGet(oMember);
		local	threshold = tonumber(KCfg.Get("AUTOIGNORE_THRESHOLD"));
		if (karma <= threshold) then
			-- ignore by threshold
			return true;
		end

		-- Markup: by overwriting GetColoredName()
		if (KCfg.Get("MARKUP_VERSION") >= 3) then
			return false;
		end

		-- Markup: self-made
		if ((type(ChatFrameSelf) == "table") and (type(ChatFrameSelf.GetName) == "function")) then
			-- if it has a valid frame: WIM fails to provide AddMessage, so we can't return true, because we didn't output anything
			local	sFramename = ChatFrameSelf:GetName();
			if ((type(sFramename) == "string") and (strsub(sFramename, 1, 9) == "ChatFrame")) then
				KarmaModuleLocal.ChatFilters.DefaultOutput(oMember, ChatFrameSelf, event, ...);
				return true;
			end

			KarmaChatDebug("Invalid frame in fChannelFilter for event " .. event .. ": " .. Karma_NilToString(sFramename));
		end
	end

	return false;
end

do
	local	KMLCF = KarmaModuleLocal.ChatFilters;
	local	fChannelFilter = KMLCF.fChannelFilter;
	local	sConfig, sConfigName;

	sConfigName = "MARKUP_CHANNELS";
	if (KARMA_CONFIG) then
		sConfig = KARMA_CONFIG[sConfigName];
	end
	KMLCF["CHAT_MSG_CHANNEL"] = {		bRedo = true, sConfig = sConfig, sConfigName = sConfigName	};
	KMLCF["CHAT_MSG_CHANNEL"].fFilter	= fChannelFilter;

	sConfigName = "MARKUP_YELLSAYEMOTE";
	if (KARMA_CONFIG) then
		sConfig = KARMA_CONFIG[sConfigName];
	end
	KMLCF["CHAT_MSG_SAY"] = {		bRedo = true, sConfig = sConfig, sConfigName = sConfigName	};
	KMLCF["CHAT_MSG_SAY"].fFilter		= fChannelFilter;
	KMLCF["CHAT_MSG_YELL"] = {		bRedo = true, sConfig = sConfig, sConfigName = sConfigName	};
	KMLCF["CHAT_MSG_YELL"].fFilter		= fChannelFilter;
	KMLCF["CHAT_MSG_EMOTE"] = {		bRedo = true, sConfig = sConfig, sConfigName = sConfigName	};
	KMLCF["CHAT_MSG_EMOTE"].fFilter		= fChannelFilter;
	KMLCF["CHAT_MSG_TEXT_EMOTE"] = {	bRedo = true, sConfig = sConfig, sConfigName = sConfigName	};
	KMLCF["CHAT_MSG_TEXT_EMOTE"].fFilter	= fChannelFilter;

	sConfigName = "MARKUP_BG";
	if (KARMA_CONFIG) then
		sConfig = KARMA_CONFIG[sConfigName];
	end
	KMLCF["CHAT_MSG_BATTLEGROUND"] = {		bRedo = true, sConfig = sConfig, sConfigName = sConfigName	};
	KMLCF["CHAT_MSG_BATTLEGROUND"].fFilter		= fChannelFilter;
	KMLCF["CHAT_MSG_BATTLEGROUND_LEADER"] = {	bRedo = true, sConfig = sConfig, sConfigName = sConfigName	};
	KMLCF["CHAT_MSG_BATTLEGROUND_LEADER"].fFilter	= fChannelFilter;

	sConfigName = "MARKUP_GUILD";
	if (KARMA_CONFIG) then
		sConfig = KARMA_CONFIG[sConfigName];
	end
	KMLCF["CHAT_MSG_GUILD"] = {		bRedo = true, sConfig = sConfig, sConfigName = sConfigName	};
	KMLCF["CHAT_MSG_GUILD"].fFilter		= fChannelFilter;
	KMLCF["CHAT_MSG_OFFICER"] = {		bRedo = true, sConfig = sConfig, sConfigName = sConfigName	};
	KMLCF["CHAT_MSG_OFFICER"].fFilter	= fChannelFilter;

	sConfigName = "MARKUP_RAID";
	if (KARMA_CONFIG) then
		sConfig = KARMA_CONFIG[sConfigName];
	end
	KMLCF["CHAT_MSG_PARTY"] = {		bRedo = true, sConfig = sConfig, sConfigName = sConfigName	};
	KMLCF["CHAT_MSG_PARTY"].fFilter		= fChannelFilter;
	KMLCF["CHAT_MSG_PARTY_LEADER"] = {	bRedo = true, sConfig = sConfig, sConfigName = sConfigName	};
	KMLCF["CHAT_MSG_PARTY_LEADER"].fFilter	= fChannelFilter;

	KMLCF["CHAT_MSG_RAID"] = {		bRedo = true, sConfig = sConfig, sConfigName = sConfigName	};
	KMLCF["CHAT_MSG_RAID"].fFilter		= fChannelFilter;
	KMLCF["CHAT_MSG_RAID_LEADER"] = {	bRedo = true, sConfig = sConfig, sConfigName = sConfigName	};
	KMLCF["CHAT_MSG_RAID_LEADER"].fFilter	= fChannelFilter;

	sConfigName = "MARKUP_WHISPERS";
	if (KARMA_CONFIG) then
		sConfig = KARMA_CONFIG[sConfigName];
	end
	KMLCF["CHAT_MSG_WHISPER"] = {			bRedo = true, sConfig = sConfig, sConfigName = sConfigName	};
	KMLCF["CHAT_MSG_WHISPER"].fFilter		= fChannelFilter;
	KMLCF["CHAT_MSG_WHISPER_INFORM"] = {		bRedo = true, sConfig = sConfig, sConfigName = sConfigName	};
	KMLCF["CHAT_MSG_WHISPER_INFORM"].fFilter	= fChannelFilter;
	KMLCF["CHAT_MSG_DND"] = {			bRedo = true, sConfig = sConfig, sConfigName = sConfigName	};
	KMLCF["CHAT_MSG_DND"].fFilter			= fChannelFilter;
end

function	KarmaModuleLocal.ChatFilters.MarkupSender(sSender, oMember)
	local	sMarkup = sSender;

	if (KCfg.Get("MARKUP_COLOUR_NAME") and (sSender ~= "")) then
		local	sClassWOGender = Karma_MemberObject_GetClassWOGender(oMember);
		if (sClassWOGender and (sClassWOGender ~= "")) then
			local	iRed, iGreen, iBlue = Karma_ClassMToColor(sClassWOGender);
			sMarkup = format("|c%s%s|r", ColourToString(1, iRed, iGreen, iBlue), sMarkup);
		end
	end

	local	sKarma = "";
	if (KCfg.Get("MARKUP_SHOW_KARMA")) then
		local	iKarma, bModified = Karma_MemberObject_GetKarmaModified(oMember);
		if (iKarma ~= 50) then
			iKarma = math.min(iKarma, 100);
			if (bModified) then
				bModified = "*";
			else
				bModified = "";
			end

			if (KCfg.Get("MARKUP_COLOUR_KARMA")) then
				local	iRed, iGreen, iBlue = Karma_Karma2Color(iKarma);
				sKarma = format(" {|c%s%s%s|r}", ColourToString(1, iRed, iGreen, iBlue), bModified, iKarma);
			else
				sKarma = format(" {%s%s}", bModified, iKarma);
			end
		end
	end
	sMarkup = sMarkup .. sKarma

	local	sNotes = Karma_MemberObject_GetNotes(oMember);
	if (sNotes) and (sNotes ~= "") then
		sMarkup = sMarkup .. "+";
	end

	return sMarkup;
end

function	KarmaModuleLocal.ChatFilters.DefaultOutput(oMember, self, event, ...)
	local	arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11 = ...;

	local type = strsub(event, 10);
	local info = ChatTypeInfo[type];
	local channelLength = strlen(arg4);

	-- whee, the check if there is *actually* something to be displayed is made *AFTER* the filters...
	-- what a braindamaged nonsense. *sigh*
	if ( (strsub(type, 1, 7) == "CHANNEL") and (type ~= "CHANNEL_LIST") and ((arg1 ~= "INVITE") or (type ~= "CHANNEL_NOTICE_USER")) ) then
		if ( arg1 == "WRONG_PASSWORD" ) then
			local staticPopup = _G[StaticPopup_Visible("CHAT_CHANNEL_PASSWORD") or ""];
			if ( staticPopup and staticPopup.data == arg9 ) then
				-- Don't display invalid password messages if we're going to prompt for a password (bug 102312)
				return;
			end
		end

		local found = 0;
		for index, value in pairs(self.channelList) do
			if ( channelLength > strlen(value) ) then
				-- arg9 is the channel name without the number in front...
				if ( ((arg7 > 0) and (self.zoneChannelList[index] == arg7)) or (strupper(value) == strupper(arg9)) ) then
					found = 1;
					info = ChatTypeInfo["CHANNEL"..arg8];
					if ( (type == "CHANNEL_NOTICE") and (arg1 == "YOU_LEFT") ) then
						self.channelList[index] = nil;
						self.zoneChannelList[index] = nil;
					end
					break;
				end
			end
		end
		if ( (found == 0) or not info ) then
			return;
		end
	end

	if ( type == "TEXT_EMOTE" ) then
		self:AddMessage(arg1, info.r, info.g, info.b, info.id);
	else
		-- channel is active for current frame, do the output

		-- stripped fontHeight (unused), moved body, renamed coloredName as sSenderMarkedup and moved

		-- Add AFK/DND flags
		local pflag;
		if(strlen(arg6) > 0) then
			if ( arg6 == "GM" ) then
				--If it was a whisper, dispatch it to the GMChat addon.
				if ( type == "WHISPER" ) then
					return
				end

				--Add Blizzard Icon, this was sent by a GM
				pflag = "|TInterface\\ChatFrame\\UI-ChatIcon-Blizz.blp:0:2:0:-3|t ";
			else
				pflag = _G["CHAT_FLAG_"..arg6];
			end
		else
			pflag = "";
		end
		if ( type == "WHISPER_INFORM" and GMChatFrame_IsGM and GMChatFrame_IsGM(arg2) ) then
			return
		end

		local showLink = 1;
		if ( strsub(type, 1, 7) == "MONSTER" or strsub(type, 1, 9) == "RAID_BOSS") then
			showLink = nil;
		else
			arg1 = gsub(arg1, "%%", "%%%%");
		end

		-- Search for icon links and replace them with texture links.
		if ( arg7 < 1 or ( arg7 >= 1 and CHAT_SHOW_ICONS ~= "0" ) ) then
			local term;
			for tag in string.gmatch(arg1, "%b{}") do
				term = strlower(string.gsub(tag, "[{}]", ""));
				if ( ICON_TAG_LIST[term] and ICON_LIST[ICON_TAG_LIST[term]] ) then
					arg1 = string.gsub(arg1, tag, ICON_LIST[ICON_TAG_LIST[term]] .. "0|t");
				end
			end
		end

		local	sSenderMarkedup = KarmaModuleLocal.ChatFilters.MarkupSender(arg2, oMember);
		local body;

		if ( (strlen(arg3) > 0) and (arg3 ~= "Universal") and (arg3 ~= self.defaultLanguage) ) then
			local languageHeader = "["..arg3.."] ";
			if ( showLink and (strlen(arg2) > 0) ) then
				body = format(_G["CHAT_"..type.."_GET"]..languageHeader..arg1, pflag.."|Hplayer:"..arg2..":"..arg11.."|h".."["..sSenderMarkedup.."]".."|h");
			else
				KarmaChatDebug("Type " .. type .. ": arg2 <> MARKUP? (1)");
				body = format(_G["CHAT_"..type.."_GET"]..languageHeader..arg1, pflag..arg2);
			end
		else
			if ( showLink and (strlen(arg2) > 0) and (type ~= "EMOTE") ) then
				body = format(_G["CHAT_"..type.."_GET"]..arg1, pflag.."|Hplayer:"..arg2..":"..arg11.."|h".."["..sSenderMarkedup.."]".."|h");
			elseif ( showLink and (strlen(arg2) > 0) and (type == "EMOTE") ) then
				body = format(_G["CHAT_"..type.."_GET"]..arg1, pflag.."|Hplayer:"..arg2..":"..arg11.."|h"..sSenderMarkedup.."|h");
			else
				KarmaChatDebug("Type " .. type .. ": arg2 <> MARKUP? (2)");
				body = format(_G["CHAT_"..type.."_GET"]..arg1, pflag..arg2, arg2);
			end
		end

		-- Add Channel
		arg4 = gsub(arg4, "%s%-%s.*", "");
		if(channelLength > 0) then
			body = "|Hchannel:"..arg8.."|h["..arg4.."]|h "..body;
		end

		self:AddMessage(body, info.r, info.g, info.b, info.id);

		if ( type == "WHISPER" ) then
			ChatEdit_SetLastTellTarget(arg2);
			if ( self.tellTimer and (GetTime() > self.tellTimer) ) then
				PlaySound("TellMessage");
			end
			self.tellTimer = GetTime() + CHAT_TELL_ALERT_TIME;
			FCF_FlashTab(self);
		end
	end
end

-----------------------------------------
-- CHAT FUNCTIONS -- OLD METHOD ---------
-----------------------------------------

function	Karma_ChatFrame_OnEvent(self, event, ...)
	-- KarmaChatDebug("Karma_ChatFrame_OnEvent: event = [" .. event .. "]");

	local	_type = type;		-- really weird overwriting of elementary function in original Blizzard code...
	local	arg1, arg2, arg3, arg4 = ...;

	if (event == "CHAT_MSG_SYSTEM") and (arg1 ~= nil) and (GetNumWhoResults() == 1) then
		-- undocumented(?) who-reply: arg1 comes as: "|Hplayer:ABCDE[ABCDE]"
		if (strsub(arg1, 1, 9) == "|Hplayer:") then
			local sMemberName = strsub(arg1, 10);
			local openingbracket = strfind(sMemberName, "[", 1, true);
			if (openingbracket) then
				sMemberName = strsub(sMemberName, openingbracket + 1);
				local closingbracket = strfind(sMemberName, "]", 1, true);
				if (closingbracket) then
					sMemberName = strsub(sMemberName, 1, closingbracket - 1);
					KarmaChatDebug("Potential /who <" .. sMemberName .. "> spotted!");
					WhoUpdateShowKarmaAndNote();
				end
			end
		end

		return KARMA_OriginalChatFrame_OnEvent(self, event, ...);
	end

	if (strsub(event, 1, 8) == "CHAT_MSG") then
		local	type = strsub(event, 10);
		local	info = ChatTypeInfo[type];

		local	channelLength = strlen(arg4);
		if ((strsub(type, 1, 7) == "CHANNEL") and (type ~= "CHANNEL_LIST") and (type ~= "CHANNEL_NOTICE")) then
			if (KCfg.Get("AUTOIGNORE") == 1) then
				local	oMember = Karma_MemberList_GetObject(arg2);
				if (oMember == nil) then
					KARMA_OriginalChatFrame_OnEvent(self, event, ...);
				else
					local	karma = KarmaObj.DB.M.KarmaGet(oMember);
					local	threshold = tonumber(KCfg.Get("AUTOIGNORE_THRESHOLD"));
					if (karma <= threshold) then
						-- ignore else do the normal thing
					else
						Karma_HandleMarkup(self, event, ...);
					end
				end
			else
				Karma_HandleMarkup(self, event, ...);
			end

			return;
		end

		if     (type == "SYSTEM") then
			KARMA_OriginalChatFrame_OnEvent(self, event, ...);
		elseif (type == "TEXT_EMOTE") or (type == "SKILL") or (type == "LOOT") then
			KARMA_OriginalChatFrame_OnEvent(self, event, ...);
		elseif (strsub(type, 1, 7) == "COMBAT_") then
			KARMA_OriginalChatFrame_OnEvent(self, event, ...);
		elseif (strsub(type, 1, 6) == "SPELL_") then
			KARMA_OriginalChatFrame_OnEvent(self, event, ...);
		elseif (type == "IGNORED") then
			KARMA_OriginalChatFrame_OnEvent(self, event, ...);
		elseif (type == "CHANNEL_LIST") then
			if (KarmaModuleLocal.ChannelName) then
				if (GetTime() > KarmaModuleLocal.ChannelTime + KARMA_CHECKCHANNEL_TIMEMAX) then
					Karma_CheckOnlineInChannelDone();
				else
					local	isChannel = false;
					if (_type(KarmaModuleLocal.ChannelName) == "number") then
						-- by number
						local	iChannel = tonumber(strsub(arg4, 1, 1));
						if (iChannel == KarmaModuleLocal.ChannelName) then
							isChannel = true;
						end
					else
						-- by name: compensate e.g. "General - Stormwind City" by cutting at first space
						local	sChannel = strsub(arg4, 4);
						local	iPosSpace = strfind(sChannel, " ", 1, true);
						if (iPosSpace) then
							sChannel = strsub(sChannel, 1, iPosSpace - 1);
						end
						if (sChannel == KarmaModuleLocal.ChannelName) then
							isChannel = true;
						end
					end

					if (isChannel) then
						KarmaChatDebug("ChannelList to <" .. strsub(arg4, 4) .. ">: {" .. arg1 .. "}");
						Karma_CheckOnlineInChannelResults(" " .. arg1 .. ",");
						KarmaModuleLocal.ChannelTime = GetTime() + 5 - KARMA_CHECKCHANNEL_TIMEMAX;
						return;
					else
						KarmaChatDebug("ChannelList to <" .. strsub(arg4, 4) .. ">: {" .. arg1 .. "} (probably not by Karma)");
					end
				end
			end

			KARMA_OriginalChatFrame_OnEvent(self, event, ...);
-- handled above
--		elseif (type == "CHANNEL_NOTICE_USER") then
--			KARMA_OriginalChatFrame_OnEvent(self, event, ...);
		elseif (type == "CHANNEL_NOTICE") then
			KARMA_OriginalChatFrame_OnEvent(self, event, ...);
		elseif (type == "TRADESKILLS") then		-- perceived
			KARMA_OriginalChatFrame_OnEvent(self, event, ...);
--		elseif (type == "SPELL_TRADESKILLS") then
--			KARMA_OriginalChatFrame_OnEvent(self, event, ...);
		else
			if (KCfg.Get("AUTOIGNORE") == 1) then
				local	oMember = Karma_MemberList_GetObject(arg2);
				if (oMember == nil) then
					KARMA_OriginalChatFrame_OnEvent(self, event, ...);
				else
					local	karma = KarmaObj.DB.M.KarmaGet(oMember);
					local	threshold = tonumber(KCfg.Get("AUTOIGNORE_THRESHOLD"));
					if (karma <= threshold) then
						-- ignore else do the normal thing
					else
						Karma_HandleMarkup(self, event, ...);
					end
				end
			else
				Karma_HandleMarkup(self, event, ...);
			end
		end

		return;
	else
		KARMA_OriginalChatFrame_OnEvent(self, event, ...);
	end
end

function	Karma_HandleMarkup(self, event, ...)
	if (not KCfg.Get("MARKUP_ENABLED")) then
		return KARMA_OriginalChatFrame_OnEvent(self, event, ...);
	end

	local arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11 = ...;
	if ((arg2 == nil) or (arg2 == "")) then
		KarmaChatDebug("Unexpected event without sender: " .. event);
		KARMA_OriginalChatFrame_OnEvent(self, event, ...);
		return
	end

	local	sMsg, sSender, sChan, sStatus, sChatIndex, sChatNoNum = arg1, arg2, arg4, arg6, arg7, arg9;
	local	tMemberlist = KarmaObj.DB.SF.MemberListGet();
	local	sSenderStatus = "";

	local	i = strfind(sSender, "-");	-- Got to handle cross server BG
	if (i) then
		sSender = strsub(sSender, 1, i - 1);
	end

	--KarmaChatDebug("Event from "..sSender..","..arg2);
	local	sBucket = KarmaObj.NameToBucket(sSender);
	if (tMemberlist[sBucket][sSender] == nil) then
		return KARMA_OriginalChatFrame_OnEvent(self, event, ...);
	end

	if (strlen(sStatus) > 0) then
		sSenderStatus = TEXT(getglobal("CHAT_FLAG_" .. sStatus));
		if sSenderStatus == nil then
			KarmaChatDebug("sSenderStatus == nil (setting to \"\" from sStatus = " .. sStatus);
			sSenderStatus = "";
		end
	end

	if	(event == "CHAT_MSG_WHISPER") then
		if (KCfg.Get("MARKUP_WHISPERS")) then
			local	sBody = sSenderStatus .. Karma_MarkupSender(sSender) .. KARMA_MSG_MARKUP_WHISPER .. sMsg;
			local	oInfo = ChatTypeInfo["WHISPER"];

			self:AddMessage(sBody, oInfo.r, oInfo.g, oInfo.b, oInfo.id);

			ChatEdit_SetLastTellTarget(arg2);

			if (self.tellTimer and (GetTime() > self.tellTimer)) then
				PlaySound("TellMessage");
			end
			self.tellTimer = GetTime() + CHAT_TELL_ALERT_TIME;
			FCF_FlashTab(self);	-- flashes title of tab on window if hidden
		else
			return KARMA_OriginalChatFrame_OnEvent(self, event, ...);
		end
	elseif	((event == "CHAT_MSG_CHANNEL") and
			(sSender ~= UnitName("player"))) then
		-- skip if message starts with "<GEM" (GEM 2.x), "GEM3" (GEM 3.x) or "" (Karma's own stuff)
		if (strsub(sMsg, 1, 4) == "<GEM") or (strsub(sMsg, 1, 4) == "GEM3") or (strsub(sMsg, 1, 2) == "") then
			return KARMA_OriginalChatFrame_OnEvent(self, event, ...);
		end

		if (KCfg.Get("MARKUP_CHANNELS")) then
			local	sChanName = gsub(sChan, "%s%-%s.*", ""); -- cribbed from ChatFrame.lua
			local	iFound = 0;
			local	oInfo;
			for index, value in pairs(self.channelList) do
				if ( ((sChatIndex > 0) and (self.zoneChannelList[index] == sChatIndex)) or (strupper(value) == strupper(sChatNoNum)) ) then
					iFound = 1;
					oInfo = ChatTypeInfo["CHANNEL"..arg8];
					if ( (type == "CHANNEL_NOTICE") and (sMsg == "YOU_LEFT") ) then
						self.channelList[index] = nil;
						self.zoneChannelList[index] = nil;
					end
					break;
				end
			end

			if ((iFound == 0) or not oInfo) then
				return KARMA_OriginalChatFrame_OnEvent(self, event, ...);
			end

			local	sBody = sSenderStatus .."[" .. sChanName .. "] " .. Karma_MarkupSender(sSender) .. KARMA_MSG_MARKUP_CHANNEL .. sMsg;

			self:AddMessage(sBody, oInfo.r, oInfo.g, oInfo.b, oInfo.id);
		else
			return KARMA_OriginalChatFrame_OnEvent(self, event, ...);
		end
	else
		return KARMA_OriginalChatFrame_OnEvent(self, event, ...);
	end
end

function	Karma_MarkupSender(sName)
	local	oMember = Karma_MemberList_GetObject(sName);
	if (not oMember) then
		return sName;
	end

	local	sMarkup = "";
	local	iRed, iGreen, iBlue
	iRed, iGreen, iBlue = Karma_MemberList_GetColors(Karma_MemberObject_GetName(oMember));

	if (KCfg.Get("MARKUP_COLOUR_NAME")) then
		sMarkup = format(TEXT("[|c%s|Hplayer:%s|h%s|h|r]"), ColourToString(1, iRed, iGreen, iBlue), sName, sName);
	else
		sMarkup = KOH.Name2Clickable(sName);
	end

	local	sKarma = "";
	if (KCfg.Get("MARKUP_SHOW_KARMA")) then
		local	iKarma, bModified = Karma_MemberObject_GetKarmaModified(oMember);
		if (bModified) then
			bModified = "*";
		else
			bModified = "";
		end
		if (KCfg.Get("MARKUP_COLOUR_KARMA")) then
			sKarma = format(TEXT(" {|c%s%s%s|r}"), ColourToString(1, iRed, iGreen, iBlue), bModified, iKarma);
		else
			sKarma = format(TEXT(" {%s%s}"), bModified, iKarma);
		end
	end

	sMarkup = sMarkup .. sKarma
--	sMarkup = "[|c"..ColourToString(1, iRed, iGreen, iBlue).."|Hplayer:"..sName.."|r] <|c"..ColourToString(0, iRed, iGreen, iBlue) .. iKarma .. "|r>";

	local	sNotes = Karma_MemberObject_GetNotes(oMember);
	if (sNotes) and (sNotes ~= "") then
		sMarkup = sMarkup .. "+";
	end

	return sMarkup;
end

-----------------------------------------
-- CONFIG FUNCTIONS (phased out in favor of karmaConfig.lua)
-----------------------------------------

function	Karma_GetConfig(config)
	KarmaChatDebug("Karma_GetConfig() called via " .. debugstack(2, 3, 0));
	if (KarmaConfigLocal == nil) then
		return nil;
	end

	if (config == nil) then
		KarmaChatDebug("Oops? Requested <nil> config. Doh! >> " .. debugstack());
		return nil;
	end

	return KarmaConfigLocal[config];
end

function	Karma_SetConfig(config, value)
	KarmaChatDebug("Karma_SetConfig() called via " .. debugstack(2, 3, 0));
	if (KarmaConfigLocal == nil) then
		return;
	end

	local valstr = value;
	if value == true then
		valstr = "true";
	elseif value == false then
		valstr = "false";
	elseif value == nil then
		valstr = "nil";
	end
	KarmaChatDebug("Setting " .. config .. " to value " .. valstr);

	KarmaConfigLocal[config] = value;
end


-----------------------------------------
--	Karma Options Window
-----------------------------------------

local KARMA_OPTIONS_SORTTYPE_DROPDOWN = {
	{ sName = KARMA_WINEL_DROPDOWNBYKARMA,		sortName = "SORTFUNCTION_TYPE_KARMA" },
	{ sName = KARMA_WINEL_DROPDOWNBYXP,		sortName = "SORTFUNCTION_TYPE_XP" },
	{ sName = KARMA_WINEL_DROPDOWNBYTIME,		sortName = "SORTFUNCTION_TYPE_PLAYED" },
	{ sName = KARMA_WINEL_DROPDOWNBYXPALL,		sortName = "SORTFUNCTION_TYPE_XPALL" },
	{ sName = KARMA_WINEL_DROPDOWNBYTIMEALL,	sortName = "SORTFUNCTION_TYPE_PLAYEDALL" },
	{ sName = KARMA_WINEL_DROPDOWNBYNAME,		sortName = "SORTFUNCTION_TYPE_NAME" },
	{ sName = KARMA_WINEL_DROPDOWNBYCLASS,		sortName = "SORTFUNCTION_TYPE_CLASS" },
	{ sName = KARMA_WINEL_DROPDOWNBYJOINED,		sortName = "SORTFUNCTION_TYPE_JOINED" },
	{ sName = KARMA_WINEL_DROPDOWNBYJOINEDTHIS,	sortName = "SORTFUNCTION_TYPE_JOINEDTHIS" },
	{ sName = KARMA_WINEL_DROPDOWNBYSEEN,		sortName = "SORTFUNCTION_TYPE_SEEN" },
	{ sName = KARMA_WINEL_DROPDOWNBYTALENT,		sortName = "SORTFUNCTION_TYPE_TALENT" },
	{ sName = KARMA_WINEL_DROPDOWNBYGUILDTOP,	sortName = "SORTFUNCTION_TYPE_GUILD_TOP" },
	{ sName = KARMA_WINEL_DROPDOWNBYGUILDBOTTOM,	sortName = "SORTFUNCTION_TYPE_GUILD_BOTTOM" },
};

function	KarmaWindowOptions_SortByDropDown_Initialize()
	if (type(KARMA_CONFIG) == "table") then
		local	iCnt, i = #KARMA_OPTIONS_SORTTYPE_DROPDOWN;
		for i = 1, iCnt do
			local	oEntry = KARMA_OPTIONS_SORTTYPE_DROPDOWN[i];
			oEntry.sortType = KARMA_CONFIG[oEntry.sortName];
		end
	end

	local	info, i;
	for i = 1, getn(KARMA_OPTIONS_SORTTYPE_DROPDOWN) do
		info = {};
		info.text = KARMA_OPTIONS_SORTTYPE_DROPDOWN[i].sName;
		info.func = KarmaWindowOptions_SortByDropDown_OnClick;
		UIDropDownMenu_AddButton(info);
	end
end

function	KarmaWindowOptions_SortByDropDown_OnShow(self)
 	UIDropDownMenu_Initialize(self, KarmaWindowOptions_SortByDropDown_Initialize);
 	UIDropDownMenu_SetWidth(self, 220);
 	UIDropDownMenu_SetButtonWidth(self, 24);

	local	sValue, i = KCfg.Get("SORTFUNCTION");
 	for i = 1, getn(KARMA_OPTIONS_SORTTYPE_DROPDOWN) do
		local	sortName = KARMA_OPTIONS_SORTTYPE_DROPDOWN[i].sortName;
		if (sortName) then
			if (KCfg.EqualsIndirect(sValue, sortName)) then
				UIDropDownMenu_SetSelectedID(KarmaOptionsWindow_SortType_DropDown, i);
				return
			end
		elseif (sValue == KARMA_OPTIONS_SORTTYPE_DROPDOWN[i].sortType) then
			UIDropDownMenu_SetSelectedID(KarmaOptionsWindow_SortType_DropDown, i);
			return
		end
	end

	KarmaChatDebug("KWO_SBDD_OS: failed to set selection");
end

function	KarmaWindowOptions_SortByDropDown_OnClick(self)
	UIDropDownMenu_SetSelectedID(KarmaOptionsWindow_SortType_DropDown, self:GetID());
	local	iSelection = UIDropDownMenu_GetSelectedID(KarmaOptionsWindow_SortType_DropDown);
	local	sortName = KARMA_OPTIONS_SORTTYPE_DROPDOWN[iSelection].sortName;
	if (sortName) then
		KCfg.SetIndirect("SORTFUNCTION", sortName);
		Karma_MemberList_ResetMemberNamesCache();
		KarmaWindow_Update();
		return
	else
		local	sortType = KARMA_OPTIONS_SORTTYPE_DROPDOWN[iSelection].sortType;
		if (sortType) then
			KCfg.Set("SORTFUNCTION", sortType);
			Karma_MemberList_ResetMemberNamesCache();
			KarmaWindow_Update();
			return
		end
	end

	KarmaChatDebug("KWO_SBDD_OC: failed to get selection");
end

local KARMA_OPTIONS_COLORTYPE_DROPDOWN = {
	{ sName = KARMA_WINEL_DROPDOWNBYKARMA,		colorName = "COLORFUNCTION_TYPE_KARMA" },
	{ sName = KARMA_WINEL_DROPDOWNBYCLASS,		colorName = "COLORFUNCTION_TYPE_CLASS" },
	{ sName = KARMA_WINEL_DROPDOWNBYTIME,		colorName = "COLORFUNCTION_TYPE_PLAYED" },
	{ sName = KARMA_WINEL_DROPDOWNBYTIMEALL,	colorName = "COLORFUNCTION_TYPE_PLAYEDALL" },
	{ sName = KARMA_WINEL_DROPDOWNBYXPLVL,		colorName = "COLORFUNCTION_TYPE_XPLVL" },
	{ sName = KARMA_WINEL_DROPDOWNBYXPLVLALL,	colorName = "COLORFUNCTION_TYPE_XPLVLALL" },
	{ sName = KARMA_WINEL_DROPDOWNBYXP,		colorName = "COLORFUNCTION_TYPE_XP" },
	{ sName = KARMA_WINEL_DROPDOWNBYXPALL,		colorName = "COLORFUNCTION_TYPE_XPALL" },
};

function	KarmaWindowOptions_ColorByDropDown_Initialize()
	local	iCnt, i = #KARMA_OPTIONS_COLORTYPE_DROPDOWN;

	if (type(KARMA_CONFIG) == "table") then
		for i = 1, iCnt do
			local	oEntry = KARMA_OPTIONS_COLORTYPE_DROPDOWN[i];
			oEntry.colorType = KARMA_CONFIG[oEntry.colorName];
		end
	end

	local	info;
	for i = 1, iCnt do
		info = {};
		info.text = KARMA_OPTIONS_COLORTYPE_DROPDOWN[i].sName;
		info.func = KarmaWindowOptions_ColorByDropDown_OnClick;
		UIDropDownMenu_AddButton(info);
	end
end

function	KarmaWindowOptions_ColorByDropDown_OnShow(self)
	UIDropDownMenu_Initialize(self, KarmaWindowOptions_ColorByDropDown_Initialize);
 	UIDropDownMenu_SetWidth(self, 220);
	UIDropDownMenu_SetButtonWidth(self, 24);

	local	iCnt, i = #KARMA_OPTIONS_COLORTYPE_DROPDOWN;
	local	sValue = KCfg.Get("COLORFUNCTION");
	for i = 1, iCnt do
		local	colorName = KARMA_OPTIONS_COLORTYPE_DROPDOWN[i].colorName;
		if (colorName) then
			if (KCfg.EqualsIndirect(sValue, colorName)) then
				UIDropDownMenu_SetSelectedID(KarmaOptionsWindow_ColorType_DropDown, i);
				return
			end
		else
			if (sValue == KARMA_OPTIONS_COLORTYPE_DROPDOWN[i].colorType) then
				UIDropDownMenu_SetSelectedID(KarmaOptionsWindow_ColorType_DropDown, i);
				return
			end
		end
	end

	KarmaChatDebug("KWO_CBDD_OS: failed to set selection");
end

function	KarmaWindowOptions_ColorByDropDown_OnClick(self)
	UIDropDownMenu_SetSelectedID(KarmaOptionsWindow_ColorType_DropDown, self:GetID());
	local	iSelection = UIDropDownMenu_GetSelectedID(KarmaOptionsWindow_ColorType_DropDown);
	local	colorName = KARMA_OPTIONS_COLORTYPE_DROPDOWN[iSelection].colorName;
	if (colorName) then
		KCfg.SetIndirect("COLORFUNCTION", colorName);
		KarmaWindow_Update();
		return
	else
		local	colorType = KARMA_OPTIONS_COLORTYPE_DROPDOWN[iSelection].colorType;
		if (colorType) then
			KCfg.Set("COLORFUNCTION", colorType);
			KarmaWindow_Update();
			return
		end
	end

	KarmaChatDebug("KWO_CBDD_OC: failed to get selection");
end

KarmaObj.Colorspace = {};

function	KarmaObj.Colorspace.ValueInit(sName)
	local	oGroup = KarmaModuleLocal.ColorSpaces[sName];
	if (oGroup == nil) then
		local	Def = KarmaModuleLocal.ColorSpaces.Default2;
		if (sName == "Karma") then
			Def = KarmaModuleLocal.ColorSpaces.Default1;
		end

		KarmaModuleLocal.ColorSpaces[sName] = Karma_CopyTable(Def);
		KarmaChatDebug("Colorspace: Init(" .. sName .. ") - copied.");
	end
end

function	KarmaObj.Colorspace.ValueGet(sName, sSuffix)
	KarmaObj.Colorspace.ValueInit(sName);

	local	oGroup = KarmaModuleLocal.ColorSpaces[sName];
	if (oGroup) then
		local	oItem = oGroup[sSuffix];
		if (oItem) then
			return oItem;
		end
	end

	return { r = 1, g = 1, b = 1 };
end

function	KarmaObj.Colorspace.ValueSet(sName, sSuffix, oValues)
	KarmaObj.Colorspace.ValueInit(sName);

	local	oGroup = KarmaModuleLocal.ColorSpaces[sName];
	if (oGroup) then
		local	oItem = oGroup[sSuffix];
		if (oItem) then
			oItem.r = oValues.r;
			oItem.g = oValues.g;
			oItem.b = oValues.b;
		end
	end

	if (sName and sSuffix) then
		local	oConfigs = KCfg.Get("COLORSPACE_" .. strupper(sName));
		if (oConfigs) then
			local	oConfig = oConfigs[sSuffix];
			if (oConfig) then
				oConfig.r = oValues.r;
				oConfig.g = oValues.g;
				oConfig.b = oValues.b;
			end
		end
	end
end

function	KarmaObj.Colorspace.Init(oFrame)
	local	sNameFull, sName, sSuffix = oFrame:GetName();

	local	oTexture = _G[sNameFull .. "Texture"];
	oTexture:SetTexture("");
	oTexture:SetTexture(1, 1, 1);

	if (sNameFull) then
		sSuffix = strsub(sNameFull, -8);
		sName = strsub(sNameFull, 31, -10);

		local	oBtn1 = _G[sName .. "_" .. strsub(sSuffix, 1, 3)];
		local	oBtn2 = _G[sName .. "_" .. strsub(sSuffix, 6, 8)];
		if (oBtn1 and oBtn2) then
			local	sText = oBtn1:GetText() .. " => " .. oBtn2.GetText();
			local	oText = _G[sNameFull .. "Text"];
			oText:SetText(sText);
		end
	end
end

function	KarmaObj.Colorspace.Show(oFrame)
	local	sNameFull, sName, sSuffix = oFrame:GetName();
	if (sNameFull) then
		sSuffix = strsub(sNameFull, -8);
		sName = strsub(sNameFull, 31, -10);
	end

	local	oFrom, oTo;
	if (sSuffix == "MinToAvg") then
		oFrom = KarmaObj.Colorspace.ValueGet(sName, "Min");
		oTo   = KarmaObj.Colorspace.ValueGet(sName, "Avg");
	elseif (sSuffix == "AvgToMax") then
		oFrom = KarmaObj.Colorspace.ValueGet(sName, "Avg");
		oTo   = KarmaObj.Colorspace.ValueGet(sName, "Max");
	end

	if ((oFrom == nil) or (oTo == nil)) then
		KarmaChatDebug("Colorgradient: " .. (sName or "???") .. "/" .. (sSuffix or "???") .. " -- missing.");
		return
	end

	local	oTexture = _G[sNameFull .. "Texture"];
	oTexture:SetGradient("HORIZONTAL", oFrom.r, oFrom.g, oFrom.b, oTo.r, oTo.g, oTo.b);
	oTexture:Show();
end

function	KarmaAvEnK.Colorspace.ModifyDone()
	if (not ColorPickerFrame:IsShown()) then
		ColorPickerFrame.oData = nil;
		ColorPickerFrame.func = nil;
		ColorPickerFrame.cancelFunc = nil;
		if (InterfaceOptionsFrame:GetFrameStrata() ~= "HIGH") then
			ColorPickerFrame:SetFrameStrata("DIALOG");
		end
	end
end

function	KarmaAvEnK.Colorspace.ModifyDo()
	local	oData = ColorPickerFrame.oData;
	if (oData) then
		local	oSelect = oData.oSelect;
		local	r, g, b = ColorPickerFrame:GetColorRGB();
		if (oSelect and r and g and b) then
			oSelect.r = r;
			oSelect.g = g;
			oSelect.b = b;
		end

		KarmaObj.Colorspace.ValueSet(oData.sKeyMain, oData.sKeySub, oSelect);

		local	oFrame = oData.oFrame;
		if (oFrame) then
			local	sName = oFrame:GetName();
			local	sSuffix = strsub(sName, -3);
			if (sSuffix ~= "Max") then
				local	oGradient = _G[strsub(sName, 1, -4) .. "MinToAvg"];
				KarmaObj.Colorspace.Show(oGradient);
			end
			if (sSuffix ~= "Min") then
				local	oGradient = _G[strsub(sName, 1, -4) .. "AvgToMax"];
				KarmaObj.Colorspace.Show(oGradient);
			end
		end
	end

	KarmaAvEnK.Colorspace.ModifyDone();
end

function	KarmaAvEnK.Colorspace.Modify(oFrame)
	if (not KCfg.Get("COLORSPACE_ENABLE")) then
		return
	end

	local	sNameFull, sName, sSuffix = oFrame:GetName();
	if (sNameFull) then
		sSuffix = strsub(sNameFull, -3);
		sName = strsub(sNameFull, 31, -5);
	end

	local	oSelect;
	if ((sSuffix == "Min") or (sSuffix == "Avg") or (sSuffix == "Max")) then
		oSelect = KarmaObj.Colorspace.ValueGet(sName, sSuffix);
	end

	if (oSelect and not ColorPickerFrame:IsShown()) then
		ColorPickerFrame.func = nil;
		ColorPickerFrame:SetColorRGB(oSelect.r, oSelect.g, oSelect.b);
		if (InterfaceOptionsFrame:GetFrameStrata() ~= "HIGH") then
			ColorPickerFrame:SetFrameStrata("FULLSCREEN_DIALOG");
		end

		ColorPickerFrame.oData  = { sKeyMain = sName, sKeySub = sSuffix, oSelect = oSelect, oFrame = oFrame };
		ColorPickerFrame.func = KarmaAvEnK.Colorspace.ModifyDo;
		ColorPickerFrame.cancelFunc = KarmaAvEnK.Colorspace.ModifyDone;
		ColorPickerFrame:Show();
	end
end

--
--
--
function	KarmaWindowOptions_ChatDefaultDropDown_Initialize()
	local	info;
	local	i;
	for i = 1, NUM_CHAT_WINDOWS do
		local	chatFrame = getglobal("ChatFrame"..i);
		if (chatFrame) then
			local	temp, shown;
			temp, temp, temp, temp, temp, temp, shown, temp = GetChatWindowInfo(i);
			if (shown or chatFrame.isDocked) then
				local	tab = getglobal(chatFrame:GetName().."Tab");
				local	sName = tab:GetText();

				KarmaChatDebug("ChatDefault_Init: [" .. i .. "] => " .. sName);

				info = {};
				info.value = i;
				info.text = sName;
				info.arg1 = sName;
				info.arg2 = i;
				info.func = KarmaWindowOptions_ChatDefaultDropDown_OnClick;
				UIDropDownMenu_AddButton(info);
			end
		end
	end

	info = {};
	info.value = -1;
	info.text = KARMA_WINEL_CHATDROPDOWNRESET;
	info.arg1 = KARMA_WINEL_CHATDROPDOWNRESET;
	info.arg2 = -1;
	info.func = KarmaWindowOptions_ChatDefaultDropDown_OnClick;
	UIDropDownMenu_AddButton(info);
end

function	KarmaWindowOptions_ChatDefaultDropDown_OnShow(self)
	UIDropDownMenu_Initialize(self, KarmaWindowOptions_ChatDefaultDropDown_Initialize);
	UIDropDownMenu_SetWidth(self, 100);
	UIDropDownMenu_SetButtonWidth(self, 24);

	-- hopefully overriden...
	UIDropDownMenu_SetSelectedID(self, 0);

	local	found = false;
	local	ConfigChatDefault = KCfg.GetPerChar("CHAT_DEFAULT");
	if (ConfigChatDefault ~= nil) and (ConfigChatDefault ~= "") then
		local	i;
		for i = 1, NUM_CHAT_WINDOWS do
			local	chatFrame = getglobal("ChatFrame"..i);
			if (chatFrame) then
				local	temp, shown;
				temp, temp, temp, temp, temp, temp, shown, temp = GetChatWindowInfo(i);
				if (shown or chatFrame.isDocked) then
					local	tab = getglobal(chatFrame:GetName().."Tab");
					local	sName = tab:GetText();
					if (sName == ConfigChatDefault) then
						KarmaChatDebug("ChatDefault_Set: [" .. i .. "] <= " .. sName);
						UIDropDownMenu_SetSelectedValue(self, i);
						found = true;
						break;
					end
				end
			end
		end
	end

	if not found then
		KarmaChatDebug("ChatDefault_Set: [1] <= DEFAULT_CHAT_FRAME");
		UIDropDownMenu_SetSelectedID(self, 1);
	end
end

function	KarmaWindowOptions_ChatDefaultDropDown_OnClick(self, arg1, arg2)
	UIDropDownMenu_SetSelectedID(KarmaOptionsWindow_ChatDefault_DropDown, self:GetID());
	if (arg1 ~= nil) and (arg2 ~= nil) then
		if (arg2 > 0) then
			local chatFrame = getglobal("ChatFrame" .. arg2);
			if chatFrame then
				KarmaObj.UIChat.DefaultSet(chatFrame);
				KarmaChatDefault(KARMA_MSG_CHATWND_DEFAULT .. KARMA_MSG_CHATWND_ISNOW .. " <" .. arg1 .. ">");
				KCfg.SetPerChar("CHAT_DEFAULT", arg1);
				KarmaWindow_Update();
			end
		else
			KarmaObj.UIChat.DefaultSet(DEFAULT_CHAT_FRAME);
			KarmaChatDefault(KARMA_MSG_CHATWND_DEFAULT .. KARMA_MSG_CHATWND_ISNOW .. KARMA_MSG_CHATWND_DEFAULTAGAIN);
			KCfg.SetPerChar("CHAT_DEFAULT", "");
			KarmaWindow_Update();
		end
	end
end

function	KarmaWindowOptions_ChatSecondaryDropDown_Initialize()
	local	info;
	local	i;
	for i = 1, NUM_CHAT_WINDOWS do
		local	chatFrame = getglobal("ChatFrame" .. i);
		if (chatFrame) then
			local	temp, shown;
			temp, temp, temp, temp, temp, temp, shown, temp = GetChatWindowInfo(i);
			if (shown or chatFrame.isDocked) then
				local	tab = getglobal(chatFrame:GetName().."Tab");
				local	sName = tab:GetText();

				KarmaChatDebug("ChatSecondary_Init: [" .. i .. "] => " .. sName);

				info = {};
				info.value = i;
				info.text = sName;
				info.arg1 = sName;
				info.arg2 = i;
				info.func = KarmaWindowOptions_ChatSecondaryDropDown_OnClick;
				UIDropDownMenu_AddButton(info);
			end
		end
	end

	info = {};
	info.value = -1;
	info.text = KARMA_WINEL_CHATDROPDOWNRESET;
	info.arg1 = KARMA_WINEL_CHATDROPDOWNRESET;
	info.arg2 = -1;
	info.func = KarmaWindowOptions_ChatSecondaryDropDown_OnClick;
	UIDropDownMenu_AddButton(info);
end

function	KarmaWindowOptions_ChatSecondaryDropDown_OnShow(self)
	UIDropDownMenu_Initialize(self, KarmaWindowOptions_ChatSecondaryDropDown_Initialize);
	UIDropDownMenu_SetWidth(self, 100);
	UIDropDownMenu_SetButtonWidth(self, 24);

	local sNameCurrently = KarmaObj.UIChat.SecondaryNameGet();
	if sNameCurrently == nil then
		sNameCurrently = KCfg.GetPerChar("CHAT_SECONDARY");
		if (sNameCurrently == "") then
			sNameCurrently = nil;
		end
	end

	local	found = false;
	if sNameCurrently ~= nil then
		KarmaChatDebug("ChatSecondary_Set: [???] <= " .. sNameCurrently);

		local	i;
		for i = 1, NUM_CHAT_WINDOWS do
			local	chatFrame = getglobal("ChatFrame"..i);
			if (chatFrame) then
				local	temp, shown;
				temp, temp, temp, temp, temp, temp, shown, temp = GetChatWindowInfo(i);
				if (shown or chatFrame.isDocked) then
					local	tab = getglobal(chatFrame:GetName().."Tab");
					local	sName = tab:GetText();
	
					if (sName == sNameCurrently) then
						KarmaChatDebug("ChatSecondary_Set: [" .. i .. "] <= " .. sName);
						UIDropDownMenu_SetSelectedValue(self, i);
						found = true;
						break;
					end
				end
			end
		end
	end

	if not found and (sNameCurrently ~= nil) then
		KarmaChatDebug("ChatSecondary_Set: [???] <= " .. sNameCurrently);
		UIDropDownMenu_SetSelectedID(self, 2);
	end
end

function	KarmaWindowOptions_ChatSecondaryDropDown_OnClick(self, arg1, arg2)
	UIDropDownMenu_SetSelectedID(KarmaOptionsWindow_ChatSecondary_DropDown, self:GetID());
	if (arg1 ~= nil) and (arg2 ~= nil) then
		if (arg2 > 0) then
			local chatFrame = getglobal("ChatFrame" .. arg2);
			if chatFrame then
				KarmaObj.UIChat.SecondarySet(chatFrame);
				KarmaChatDefault(KARMA_MSG_CHATWND_SECONDARY .. KARMA_MSG_CHATWND_ISNOW .. " <" .. arg1 .. "> " .. KARMA_MSG_CHATWND_OVERTHERE);
				KarmaChatSecondary(KARMA_MSG_CHATWND_SECONDARY .. KARMA_MSG_CHATWND_ISNOW .. KARMA_MSG_CHATWND_THISONE);
				KCfg.SetPerChar("CHAT_SECONDARY", arg1);
				KarmaWindow_Update();
			end
		else
			KarmaObj.UIChat.SecondarySet(nil);
			KarmaChatDefault(KARMA_MSG_CHATWND_SECONDARY .. KARMA_MSG_CHATWND_ISNOW .. KARMA_MSG_CHATWND_UNSET);
			KCfg.SetPerChar("CHAT_SECONDARY", "");
			KarmaWindow_Update();
		end
	end
end

-- DEBUG window
function	KarmaWindowOptions_ChatDebugDropDown_Initialize()
	local	info;
	local	i;
	for i = 1, NUM_CHAT_WINDOWS do
		local	chatFrame = getglobal("ChatFrame" .. i);
		if (chatFrame) then
			local	temp, shown;
			temp, temp, temp, temp, temp, temp, shown, temp = GetChatWindowInfo(i);
			if (shown or chatFrame.isDocked) then
				local	tab = getglobal(chatFrame:GetName().."Tab");
				local	sName = tab:GetText();

				KarmaChatDebug("ChatDebug_Init: [" .. i .. "] => " .. sName);

				info = {};
				info.value = i;
				info.text = sName;
				info.arg1 = sName;
				info.arg2 = i;
				info.func = KarmaWindowOptions_ChatDebugDropDown_OnClick;
				UIDropDownMenu_AddButton(info);
			end
		end
	end

	info = {};
	info.value = -1;
	info.text = KARMA_WINEL_CHATDROPDOWNRESET;
	info.arg1 = KARMA_WINEL_CHATDROPDOWNRESET;
	info.arg2 = -1;
	info.func = KarmaWindowOptions_ChatDebugDropDown_OnClick;
	UIDropDownMenu_AddButton(info);
end

function	KarmaWindowOptions_ChatDebugDropDown_OnShow(self)
	UIDropDownMenu_Initialize(self, KarmaWindowOptions_ChatDebugDropDown_Initialize);
	UIDropDownMenu_SetWidth(self, 100);
	UIDropDownMenu_SetButtonWidth(self, 24);

	-- hopefully overriden...
	UIDropDownMenu_SetSelectedID(self, 0);

	local sNameCurrently = KarmaObj.UIChat.DebugNameGet();
	if sNameCurrently == nil then
		sNameCurrently = KCfg.GetPerChar("CHAT_DEBUG");
		if (sNameCurrently == "") then
			sNameCurrently = nil;
		end
	end

	local	found = false;
	if sNameCurrently ~= nil then
		KarmaChatDebug("ChatDebug_Set: [???] <= " .. sNameCurrently);

		local	i;
		for i = 1, NUM_CHAT_WINDOWS do
			local	chatFrame = getglobal("ChatFrame"..i);
			if (chatFrame) then
				local	temp, shown;
				temp, temp, temp, temp, temp, temp, shown, temp = GetChatWindowInfo(i);
				if (shown or chatFrame.isDocked) then
					local	tab = getglobal(chatFrame:GetName().."Tab");
					local	sName = tab:GetText();

					if (sName == sNameCurrently) then
						KarmaChatDebug("ChatDebug_Set: [" .. i .. "] <= " .. sName);
						UIDropDownMenu_SetSelectedValue(self, i);
						found = true;
						break;
					end
				end
			end
		end
	end

	if not found and (sNameCurrently ~= nil) then
		KarmaChatDebug("ChatDebug_Set: [???] <= " .. sNameCurrently);
	end
end

function	KarmaWindowOptions_ChatDebugDropDown_OnClick(self, arg1, arg2)
	UIDropDownMenu_SetSelectedID(KarmaOptionsWindow_ChatDebug_DropDown, self:GetID());
	if (arg1 ~= nil) and (arg2 ~= nil) then
		if (arg2 > 0) then
			local chatFrame = getglobal("ChatFrame" .. arg2);
			if chatFrame then
				KarmaObj.UIChat.DebugSet(chatFrame);
				KarmaChatDefault(KARMA_MSG_CHATWND_DEBUG .. KARMA_MSG_CHATWND_ISNOW .. " <" .. arg1 .. "> " .. KARMA_MSG_CHATWND_OVERTHERE);
				KarmaChatDebug(KARMA_MSG_CHATWND_DEBUG .. KARMA_MSG_CHATWND_ISNOW .. KARMA_MSG_CHATWND_THISONE);
				KCfg.SetPerChar("CHAT_DEBUG", arg1);
				KarmaWindow_Update();
			end
		else
			KarmaObj.UIChat.DebugSet(nil);
			KarmaChatDefault(KARMA_MSG_CHATWND_DEBUG .. KARMA_MSG_CHATWND_ISNOW .. KARMA_MSG_CHATWND_UNSET);
			KCfg.SetPerChar("CHAT_DEBUG", "");
			KarmaWindow_Update();
		end
	end
end

--
--
--
function	KarmaOptionWindow_AutoignoreEnabled_Checkbox_OnLoad(self)
	self:SetChecked(KCfg.Get("AUTOIGNORE"));
end

function	KarmaOptionWindow_AutoignoreEnabled_Checkbox_OnClick(self)
	KCfg.Set("AUTOIGNORE", KOH.Nil1To01(self:GetChecked()));
end

function	KarmaOptionWindow_IgnoreInvites_Checkbox_OnLoad(self)
	self:SetChecked(KCfg.Get("AUTOIGNORE_INVITES"));
end

function	KarmaOptionWindow_IgnoreInvites_Checkbox_OnClick(self)
	KCfg.Set("AUTOIGNORE_INVITES", KOH.Nil1To01(self:GetChecked()));
end

function	KarmaOptionWindow_AutoIgnoreThreshold_OnShow(self)
	self:SetText(KCfg.Get("AUTOIGNORE_THRESHOLD"));
end

function	KarmaOptionWindow_AutoIgnoreThreshold_OnChanged(self)
	KCfg.Set("AUTOIGNORE_THRESHOLD", self:GetText());
end

--
----
--   Sharing
----
--
-- SHARE_ONREQ_KARMA
--
function	KarmaOptionWindow_Sharing_KarmaLevel_Menu_Initialize()
	local	i = 0;
	while (KARMA_SHARELEVELS["L" .. i] ~= nil) do
		local	info = {};
		info.value = i;
		info.text = KARMA_SHARELEVELS["L" .. i];
		info.arg1 = info.text;
		info.arg2 = i;
		info.func = KarmaOptionWindow_Sharing_KarmaLevel_Menu_OnClick;
		UIDropDownMenu_AddButton(info);

		i = i + 1;
	end
end

function	KarmaOptionWindow_Sharing_KarmaLevel_Menu_OnShow(self)
	UIDropDownMenu_Initialize(self, KarmaOptionWindow_Sharing_KarmaLevel_Menu_Initialize);
	UIDropDownMenu_SetWidth(self, 100);
	UIDropDownMenu_SetButtonWidth(self, 24);
	UIDropDownMenu_JustifyText(self, "LEFT");

	local	bSet = false;
	local	iLevel = KCfg.Get("SHARE_ONREQ_KARMA");
	if (iLevel ~= nil) then
		local	sLevel = KARMA_SHARELEVELS["L" .. iLevel];
		if (sLevel ~= nil) then
			bSet = true;
			UIDropDownMenu_SetSelectedValue(self, iLevel);
		end
	end
	if (not bSet) then
		UIDropDownMenu_SetSelectedID(self, 1);
	end
end

function	KarmaOptionWindow_Sharing_KarmaLevel_Menu_OnClick(self, arg1, arg2)
	UIDropDownMenu_SetSelectedID(KarmaOptionWindow_Sharing_KarmaLevel_Menu, self:GetID());
	if (arg1 ~= nil) and (arg2 ~= nil) then
		KCfg.Set("SHARE_ONREQ_KARMA", arg2);
		KarmaChatSecondary("Share level for " .. KARMA_ITSELF .. " value is now: " .. arg1 .. " (" .. arg2 .. ")");
	end
end

--
-- SHARE_ONREQ_PUBLICNOTE
--
function	KarmaOptionWindow_Sharing_PublicnoteLevel_Menu_Initialize()
	local	i = 0;
	while (KARMA_SHARELEVELS["L" .. i] ~= nil) do
		local	info = {};
		info.value = i;
		info.text = KARMA_SHARELEVELS["L" .. i];
		info.arg1 = info.text;
		info.arg2 = i;
		info.func = KarmaOptionWindow_Sharing_PublicnoteLevel_Menu_OnClick;
		UIDropDownMenu_AddButton(info);

		i = i + 1;
	end
end

function	KarmaOptionWindow_Sharing_PublicnoteLevel_Menu_OnShow(self)
	UIDropDownMenu_Initialize(self, KarmaOptionWindow_Sharing_PublicnoteLevel_Menu_Initialize);
	UIDropDownMenu_SetWidth(self, 100);
	UIDropDownMenu_SetButtonWidth(self, 24);
	UIDropDownMenu_JustifyText(self, "LEFT");

	local	bSet = false;
	local	iLevel = KCfg.Get("SHARE_ONREQ_PUBLICNOTE");
	if (iLevel ~= nil) then
		local	sLevel = KARMA_SHARELEVELS["L" .. iLevel];
		if (sLevel ~= nil) then
			bSet = true;
			UIDropDownMenu_SetSelectedValue(self, iLevel);
		end
	end
	if (not bSet) then
		UIDropDownMenu_SetSelectedID(self, 1);
	end
end

function	KarmaOptionWindow_Sharing_PublicnoteLevel_Menu_OnClick(self, arg1, arg2)
	UIDropDownMenu_SetSelectedID(KarmaOptionWindow_Sharing_PublicnoteLevel_Menu, self:GetID());
	if (arg1 ~= nil) and (arg2 ~= nil) then
		KCfg.Set("SHARE_ONREQ_PUBLICNOTE", arg2);
		KarmaChatSecondary("Share level for public note is now: " .. arg1 .. " (" .. arg2 .. ")");
	end
end

function	KarmaOptionWindow_Sharing_ChannelName_OnShow(self)
	local	sText = KCfg.Get("SHARE_CHANNEL_NAME");
	if (sText) then
		self:SetText(sText);
	end
end

function	KarmaOptionWindow_Sharing_ChannelName_OnChanged(self)
	local	sText = self:GetText();
	if (sText == "") then
		sText = nil;
	end
	KCfg.Set("SHARE_CHANNEL_NAME", sText);
end

--
--
--
function	KarmaOptionWindow_WarnLowKarma_Checkbox_OnLoad(self)
	self:SetChecked(KCfg.Get("JOINWARN_ENABLED"));
end

function	KarmaOptionWindow_WarnLowKarma_Checkbox_OnClick(self)
	KCfg.Set("JOINWARN_ENABLED", KOH.Nil1To01(self:GetChecked()));
end

function	KarmaOptionWindow_WarnLowKarma_Threshold_OnShow(self)
	local Threshold = KCfg.Get("JOINWARN_THRESHOLD");
	if (Threshold) then
		self:SetText(Threshold);
	end
end

function	KarmaOptionWindow_WarnLowKarma_Threshold_OnChanged(self)
	KCfg.Set("JOINWARN_THRESHOLD", self:GetText());
end

--
--
--
function	KarmaOptionWindow_DBClean_KeepIfNote_Checkbox_OnLoad(self)
	local	KeepIfNote = KCfg.Get("CLEAN_KEEPIFNOTE");
	if (KeepIfNote ~= 0) then
		self:SetChecked(KeepIfNote);
	end
end

function	KarmaOptionWindow_DBClean_KeepIfNote_Checkbox_OnClick(self)
	KCfg.Set("CLEAN_KEEPIFNOTE", KOH.Nil1To01(self:GetChecked()));
end

--
function	KarmaOptionWindow_DBClean_RemovePvPJoins_Checkbox_OnLoad(self)
	local	RemovePvPJoins = KCfg.Get("CLEAN_REMOVEPVPJOINS");
	if (RemovePvPJoins ~= 0) then
		self:SetChecked(RemovePvPJoins);
	end
end

function	KarmaOptionWindow_DBClean_RemovePvPJoins_Checkbox_OnClick(self)
	KCfg.Set("CLEAN_REMOVEPVPJOINS", KOH.Nil1To01(self:GetChecked()));
end

--
function	KarmaOptionWindow_DBClean_RemoveXServer_Checkbox_OnLoad(self)
	local	RemoveXServer = KCfg.Get("CLEAN_REMOVEXSERVER");
	if (RemoveXServer ~= 0) then
		self:SetChecked(RemoveXServer);
	end
end

function	KarmaOptionWindow_DBClean_RemoveXServer_Checkbox_OnClick(self)
	KCfg.Set("CLEAN_REMOVEXSERVER", KOH.Nil1To01(self:GetChecked()));
end

--
function	KarmaOptionWindow_DBClean_KeepIfKarma_Checkbox_OnLoad(self)
	local	KeepIfKarma = KCfg.Get("CLEAN_KEEPIFKARMA");
	if (KeepIfKarma ~= 0) then
		self:SetChecked(KeepIfKarma);
	end
end

function	KarmaOptionWindow_DBClean_KeepIfKarma_Checkbox_OnClick(self)
	KCfg.Set("CLEAN_KEEPIFKARMA", KOH.Nil1To01(self:GetChecked()));
end

--
function	KarmaOptionWindow_DBClean_KeepIfQListThres_OnShow(self)
	if (KCfg.Get("CLEAN_KEEPIFQUESTCOUNT") == nil) then
		KCfg.Set("CLEAN_KEEPIFQUESTCOUNT", 1);
	end
	self:SetText(KCfg.Get("CLEAN_KEEPIFQUESTCOUNT"));
end

function	KarmaOptionWindow_DBClean_KeepIfQListThres_OnChanged(self)
	local	Value = tonumber(self:GetText());
	if (type(Value) == "number") and (Value >= 0) then
		KCfg.Set("CLEAN_KEEPIFQUESTCOUNT", Value);
	end
end

--
function	KarmaOptionWindow_DBClean_KeepIfZListThres_OnShow(self)
	if (KCfg.Get("CLEAN_KEEPIFZONECOUNT") == nil) then
		KCfg.Set("CLEAN_KEEPIFZONECOUNT", 1);
	end
	self:SetText(KCfg.Get("CLEAN_KEEPIFZONECOUNT"));
end

function	KarmaOptionWindow_DBClean_KeepIfZListThres_OnChanged(self)
	local	Value = tonumber(self:GetText());
	if (type(Value) == "number") and (Value >= 0) then
		KCfg.Set("CLEAN_KEEPIFZONECOUNT", Value);
	end
end

--
function	KarmaOptionWindow_DBClean_KeepIfRListThres_OnShow(self)
	if (KCfg.Get("CLEAN_KEEPIFREGIONCOUNT") == nil) then
		KCfg.Set("CLEAN_KEEPIFREGIONCOUNT", 1);
	end
	self:SetText(KCfg.Get("CLEAN_KEEPIFREGIONCOUNT"));
end

function	KarmaOptionWindow_DBClean_KeepIfRListThres_OnChanged(self)
	local	Value = tonumber(self:GetText());
	if (type(Value) == "number") then
		KCfg.Set("CLEAN_KEEPIFREGIONCOUNT", Value);
	end
end

--
function	KarmaOptionWindow_DBClean_IgnorePVPZones_Checkbox_OnLoad(self)
	local	IgnorePVPZones = KCfg.Get("CLEAN_IGNOREPVPZONES");
	if (IgnorePVPZones ~= 0) then
		self:SetChecked(IgnorePVPZones);
	end
end

function	KarmaOptionWindow_DBClean_IgnorePVPZones_Checkbox_OnClick(self)
	KCfg.Set("CLEAN_IGNOREPVPZONES", KOH.Nil1To01(self:GetChecked()));
end

function	KarmaOptionWindow_DBClean_Test_OnClick()
	Karma_ClearUnused("dryrun");
end

--
--
--

-- ************************************************************************ --
-- ************************************************************************ --
function	KarmaOptionWindow_Other_MainWndTab_Dropdown_Initialize()
	local	MainWndTabs = {
		[ 1 ] = KARMA_WINEL_TRACKINGDATA_BUTTON,
		[ 2 ] = KARMA_WINEL_OTHERDATA_BUTTON
		};

	local	info;
	local	i;
	for i = 1, #MainWndTabs do
		info = {};
		info.value = i;
		info.text = MainWndTabs[i];
		info.arg1 = MainWndTabs[i];
		info.arg2 = i;
		info.func = KarmaOptionWindow_Other_MainWndTab_Dropdown_OnClick;
		UIDropDownMenu_AddButton(info);
	end
end

function	KarmaOptionWindow_Other_MainWndTab_Dropdown_OnShow(self)
	UIDropDownMenu_Initialize(self, KarmaOptionWindow_Other_MainWndTab_Dropdown_Initialize);
	UIDropDownMenu_SetWidth(self, 150);
	UIDropDownMenu_SetButtonWidth(self, 24);

	-- hopefully overriden...
	local	id = KCfg.Get("MAINWND_INITIALTAB");
	if (id) then
		UIDropDownMenu_SetSelectedID(self, id);
	else
		UIDropDownMenu_SetSelectedID(self, 1);
	end
end

function	KarmaOptionWindow_Other_MainWndTab_Dropdown_OnClick(self, arg1, arg2)
	UIDropDownMenu_SetSelectedID(KarmaOptionWindow_Other_MainWndTab_Dropdown, self:GetID());
	if (arg2) and (arg2 > 0) then
		KCfg.Set("MAINWND_INITIALTAB", arg2);
	end
end
-- ************************************************************************ --
-- ************************************************************************ --

function	KarmaOptionWindow_Other_AutocheckTalents_Checkbox_OnLoad(self)
	self:SetChecked(KCfg.Get("TALENTS_AUTOFETCH") == 1);
end

function	KarmaOptionWindow_Other_AutocheckTalents_Checkbox_OnClick(self)
	KCfg.Set("TALENTS_AUTOFETCH", KOH.Nil1To01(self:GetChecked()));
	KARMA_TalentInspect.AutofetchConfigCache = nil;
end

function	KarmaOptionWindow_Other_MinimapIconHide_Checkbox_OnLoad(self)
	self:SetChecked(KCfg.Get("MINIMAP_HIDE") == 1);
end

function	KarmaOptionWindow_Other_MinimapIconHide_Checkbox_OnClick(self)
	KCfg.Set("MINIMAP_HIDE", KOH.Nil1To01(self:GetChecked()));
	Karma_MinimapIconFrame_ResetIcon();
	Karma_MinimapIconFrame_InitComplete();
end

--
--
--
function	KarmaOptionWindow_VirtualKarma_TimeKarma_Checkbox_OnLoad(self)
	self:SetChecked(KCfg.Get("TIME_KARMA_DEFAULT") == 1);
end

function	KarmaOptionWindow_VirtualKarma_TimeKarma_Checkbox_OnClick(self)
	KCfg.Set("TIME_KARMA_DEFAULT", KOH.Nil1To01(self:GetChecked()));
end

function	KarmaOptionWindow_VirtualKarma_TimeKarmaThreshold_Editbox_OnShow(self)
	local	value = KCfg.Get("TIME_KARMA_MINVAL");
	if (type(value) == "number") then
		if (value < 1) or (value > 99) then
			value = 50;
			KCfg.Set("TIME_KARMA_MINVAL", value);
		end
	else
		value = 50;
		KCfg.Set("TIME_KARMA_MINVAL", value);
	end

	self:SetText(value);
end

function	KarmaOptionWindow_VirtualKarma_TimeKarmaThreshold_Editbox_OnChanged(self)
	local	value = tonumber(self:GetText());
	if (type(value) == "number") then
		if (value >= 1) and (value <= 99) then
			KCfg.Set("TIME_KARMA_MINVAL", value);
		end
	end
end

function	KarmaOptionWindow_VirtualKarma_TimeKarmaFactor_Editbox_OnShow(self)
	local	value = KCfg.Get("TIME_KARMA_FACTOR");
	if (type(value) == "number") then
		if (value < 0.01) or (value > 10) then
			value = 0.4;
			KCfg.Set("TIME_KARMA_FACTOR", value);
		end
	else
		value = 50;
		KCfg.Set("TIME_KARMA_FACTOR", value);
	end

	self:SetText(value);
end

function	KarmaOptionWindow_VirtualKarma_TimeKarmaFactor_Editbox_OnChanged(self)
	local	value = tonumber(self:GetText());
	if (type(value) == "number") then
		if (value >= 0.01) and (value <= 10) then
			KCfg.Set("TIME_KARMA_FACTOR", value);
		end
	end
end

--
--
--
function	KarmaOptionWindow_Tooltip_ShiftReq_Checkbox_OnLoad(self)
	self:SetChecked(KCfg.Get("TOOLTIP_SHIFTREQ") ~= 0);
end

function	KarmaOptionWindow_Tooltip_ShiftReq_Checkbox_OnClick(self)
	KCfg.Set("TOOLTIP_SHIFTREQ", KOH.Nil1To01(self:GetChecked()));
end


function	KarmaOptionWindow_OtherKarmaTips_Checkbox_OnLoad(self)
	self:SetChecked(KOH.BooleanToInt(KCfg.Get("TOOLTIP_KARMA")));
end

function	KarmaOptionWindow_OtherKarmaTips_Checkbox_OnClick(self)
	KCfg.Set("TOOLTIP_KARMA", KOH.IntToBoolean(self:GetChecked()));
end

-- pair >>
function	KarmaOptionWindow_OtherPlayedThisTips_Checkbox_OnLoad(self)
	self:SetChecked(KCfg.Get("TOOLTIP_PLAYEDTHIS"));
end

function	KarmaOptionWindow_OtherPlayedThisTips_Checkbox_OnClick(self)
	local	iChecked = KOH.Nil1To01(self:GetChecked());
	KCfg.Set("TOOLTIP_PLAYEDTHIS", iChecked);
	KCfg.Set("TOOLTIP_PLAYEDTOTAL", 1 - iChecked);
	KarmaOptionWindow_OtherPlayedTotalTips_Checkbox:SetChecked(1 - iChecked);
end

function	KarmaOptionWindow_OtherPlayedTotalTips_Checkbox_OnLoad(self)
	self:SetChecked(KCfg.Get("TOOLTIP_PLAYEDTOTAL"));
end

function	KarmaOptionWindow_OtherPlayedTotalTips_Checkbox_OnClick(self)
	local	iChecked = KOH.Nil1To01(self:GetChecked());
	KCfg.Set("TOOLTIP_PLAYEDTOTAL", iChecked);
	KCfg.Set("TOOLTIP_PLAYEDTHIS", 1 - iChecked);
	KarmaOptionWindow_OtherPlayedThisTips_Checkbox:SetChecked(1 - iChecked);
end
-- pair <<

function	KarmaOptionWindow_OtherNoteTips_Checkbox_OnLoad(self)
	self:SetChecked(KOH.BooleanToInt(KCfg.Get("TOOLTIP_NOTES")));
end

function	KarmaOptionWindow_OtherNoteTips_Checkbox_OnClick(self)
	KCfg.Set("TOOLTIP_NOTES", KOH.IntToBoolean(self:GetChecked()));
end


function	KarmaOptionWindow_Tooltip_Skill_Checkbox_OnLoad(self)
	self:SetChecked(KCfg.Get("TOOLTIP_SKILL") ~= 0);
end

function	KarmaOptionWindow_Tooltip_Skill_Checkbox_OnClick(self)
	KCfg.Set("TOOLTIP_SKILL", KOH.Nil1To01(self:GetChecked()));
end

function	KarmaOptionWindow_Tooltip_Talents_Checkbox_OnLoad(self)
	self:SetChecked(KCfg.Get("TOOLTIP_TALENTS") ~= 0);
end

function	KarmaOptionWindow_Tooltip_Talents_Checkbox_OnClick(self)
	KCfg.Set("TOOLTIP_TALENTS", KOH.Nil1To01(self:GetChecked()));
end

function	KarmaOptionWindow_Tooltip_Alts_Checkbox_OnLoad(self)
	self:SetChecked(KCfg.Get("TOOLTIP_ALTS") ~= 0);
end

function	KarmaOptionWindow_Tooltip_Alts_Checkbox_OnClick(self)
	KCfg.Set("TOOLTIP_ALTS", KOH.Nil1To01(self:GetChecked()));
end


function	Karma_ShowTooltipHelp()
	return KCfg.Get("TOOLTIP_HELP") ~= 0;
end

function	KarmaOptionWindow_Tooltip_Help_Checkbox_OnLoad(self)
	self:SetChecked(KCfg.Get("TOOLTIP_HELP") ~= 0);
end

function	KarmaOptionWindow_Tooltip_Help_Checkbox_OnClick(self)
	KCfg.Set("TOOLTIP_HELP", KOH.Nil1To01(self:GetChecked()));
end

function	KarmaOptionWindow_Tooltip_LFMAddKarma_Checkbox_OnLoad(self)
	self:SetChecked(KCfg.Get("TOOLTIP_LFMADDKARMA") ~= 0);
end

function	KarmaOptionWindow_Tooltip_LFMAddKarma_Checkbox_OnClick(self)
	KCfg.Set("TOOLTIP_LFMADDKARMA", KOH.Nil1To01(self:GetChecked()));
end

function	KarmaObj.UI.Config.CheckBox_MarkupVersion_OnLoad(self)
	self:SetChecked(KCfg.Get("MARKUP_VERSION") >= 3);
end

function	KarmaObj.UI.Config.CheckBox_MarkupVersion_OnClick(self)
	KCfg.Set("MARKUP_VERSION", 2 + KOH.Nil1To01(self:GetChecked()));
	KarmaChatSecondaryFallbackDefault("Setting will be effective with next relogging.");
end

------------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------

--		["KarmaOptionWindow_MarkupWhispers_Checkbox"] =
--			{ CFG = KARMA_CONFIG.MARKUP_WHISPERS, TYPE = "bool", DEPENDS = KARMA_CONFIG.MARKUP_ENABLED },
--			{ CFGName = "MARKUP_WHISPERS", TYPE = "bool", DEPENDSName = "MARKUP_ENABLED" },

function	KarmaObj.UI.Config.CheckBox_OnLoad(self)
	local	sName = self:GetName();
	if (KarmaModuleLocal.UIConfig.Elements[sName]) then
		local	oElement = KarmaModuleLocal.UIConfig.Elements[sName];
		local	bOn = false;
		local	Value;
		if (oElement.CFGName) then
			Value = KCfg.Get(oElement.CFGName);
			if (Value == nil) then
				Value = oElement.DEFAULT;
				KCfg.Set(oElement.CFGName, Value);
			end
		elseif (oElement.CFG) then
			Value = Karma_GetConfig(oElement.CFG);			-- fallback
			if (Value == nil) then
				Value = oElement.DEFAULT;
				Karma_SetConfig(oElement.CFG, Value);		-- fallback
			end
		end

		if (oElement.TYPE == "bool") then
			bOn = true == Value;
		elseif (oElement.TYPE == "01") then
			bOn = 1 == Value;
		end

		if (bOn) then
			self:SetChecked(1);
		else
			self:SetChecked(0);
		end
	else
		self:EnableMouse(false);
		KarmaChatDebug("KOUIC.CB: missing element " .. sName);
	end
end

function	KarmaObj.UI.Config.CheckBox_OnClick(self)
	local	sName = self:GetName();
	if (KarmaModuleLocal.UIConfig.Elements[sName]) then
		local	oElement = KarmaModuleLocal.UIConfig.Elements[sName];
		if (oElement.DEPENDSName or oElement.DEPENDS) then
			if (oElement.DEPENDSName) then
				local	DepValue = KCfg.Get(oElement.DEPENDSName);
				local	bDepOn = false;
				if (oElement.TYPE == "bool") then
					bDepOn = true == DepValue;
				elseif (oElement.TYPE == "01") then
					bDepOn = 1 == DepValue;
				end
				if (not bDepOn) then
					-- restore state in UI to stored one
					KarmaObj.UI.Config.CheckBox_OnLoad(self);
					return
				end
			elseif (oElement.DEPENDS) then
				local	DepValue = Karma_GetConfig(oElement.DEPENDS);	-- fallback
				local	bDepOn = false;
				if (oElement.TYPE == "bool") then
					bDepOn = true == DepValue;
				elseif (oElement.TYPE == "01") then
					bDepOn = 1 == DepValue;
				end
				if (not bDepOn) then
					-- restore state in UI to stored one
					KarmaObj.UI.Config.CheckBox_OnLoad(self);
					return
				end
			end
		end

		local	Value;
		local	bOn = 1 == self:GetChecked();
		if (oElement.TYPE == "bool") then
			Value = bOn;
		elseif (oElement.TYPE == "01") then
			if (bOn) then
				Value = 1;
			else
				Value = 0;
			end
		else
			KarmaChatDebug("KOUIC.CB: missing TYPE for element " .. sName);
			Value = bOn;
		end

		if (oElement.CFGName) then
			KCfg.Set(oElement.CFGName, Value);
		elseif (oElement.CFG) then
			Karma_SetConfig(oElement.CFG, Value);			-- fallback
		end
	else
		KarmaChatDebug("KOUIC.CB: missing element " .. sName);
	end
end

------------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------

---
---- Minimap Icon: positioning and menu
---
local function MinimapSetPosFromAngle(angle)
	local	xcenter, ycenter = Minimap:GetCenter()
	local	xmin, ymin = Minimap:GetLeft(), Minimap:GetBottom();
	-- (xcenter, ycenter) + r * (cos angle, sin angle)
	local	r = xcenter - xmin + 10;
	local	cos_a = cos(angle);
	local	sin_a = sin(angle);

	if (GetMinimapShape) then
		if (GetMinimapShape() ~= "ROUND") then
			-- square minimap: r = f(angle)
			if (abs(cos_a) > abs(sin_a)) then
				r = r / abs(cos_a);
			else
				r = r / abs(sin_a);
			end;
		end;
	end;

	KarmaChatDebug("Setting minimap icon to pos { " .. ( - r * cos_a ) .. " / " .. ( r * sin_a ) .. " } (angle = " .. angle .. ")");
	Karma_MinimapIconFrame:ClearAllPoints();
	Karma_MinimapIconFrame:SetPoint("CENTER", "Minimap", "CENTER", - r * cos_a, r * sin_a);
end

function	Karma_MinimapIconFrame_OnLoad(self)
	self:RegisterForClicks("LeftButtonUp","MiddleButtonUp","RightButtonUp");
	self:RegisterForDrag("LeftButton");
	Karma_MinimapIconFrame_ResetIcon();
end

function	Karma_MinimapIconFrame_ResetIcon()
	-- forced initial position, just so SimpleMinimap doesn't f*** it up completely
	MinimapSetPosFromAngle(180);
	if (KCfg.Get("MINIMAP_HIDE") ~= 1) then
		Karma_MinimapIconFrame:Show();
	else
		Karma_MinimapIconFrame:Hide();
	end
end

function	Karma_MinimapIconFrame_InitComplete()
	-- faction object not ready in OnLoad
	local IconPos = KCfg.GetPerChar("MINIMAPPOS");
	if (IconPos == nil) then
		IconPos = 180;
	end

	MinimapSetPosFromAngle(IconPos);

	if (KCfg.Get("MINIMAP_HIDE") == 1) then
		Karma_MinimapIconFrame:Hide();
	end
end

function	Karma_MinimapIconFrame_IconDragStart(self)
	self:LockHighlight();
	self:StartMoving()
end

function	Karma_MinimapIconFrame_IconDragStop(self)
	self:StopMovingOrSizing();
	self:UnlockHighlight();
	Karma_MinimapIconFrame_IconDrag(true);
end

function	Karma_MinimapIconFrame_IconDragging()
	Karma_MinimapIconFrame_IconDrag(false);
end

function	Karma_MinimapIconFrame_IconDrag(store)
	local xcenter, ycenter = Minimap:GetCenter()
	local xmin, ymin = Minimap:GetLeft(), Minimap:GetBottom();
	local xpos, ypos = GetCursorPosition();

--KarmaChatDebug("Minimap: Center (x, y) = (" .. xcenter .. ", " .. ycenter .. ")");
--KarmaChatDebug("Minimap: LeftBottom (x, y) = (" .. xmin .. ", " .. ymin .. ")");
--KarmaChatDebug("Minimap: Center (x, y) = (" .. xpos .. ", " .. ypos .. ")");

	xpos = xmin - xpos / Minimap:GetEffectiveScale() + 70;
	ypos =        ypos / Minimap:GetEffectiveScale() - ymin - 70;

	local IconPos = math.deg(math.atan2(ypos,xpos));

--KarmaChatDebug("Minimap: IconPos = " .. IconPos .. " from (x, y) = (" .. xpos .. ", " .. ypos .. ")");

	MinimapSetPosFromAngle(IconPos);
	if (store) then
		KCfg.SetPerChar("MINIMAPPOS", IconPos);
	end
end

function	Karma_MinimapIconFrame_TooltipShow(self)
	if not KARMA_Minimap_Tooltip_Hide then
		GameTooltip:SetOwner(self, "ANCHOR_BOTTOMLEFT");

		GameTooltip:AddLine(KARMA_WINEL_TITLE);

		local	text, key, iPos;
		text = KARMA_WINEL_MINIMENU_TOOLTIP1;
		key  = GetBindingKey("KARMAWINDOW");
		if (key) and (key ~= "") then
			-- un-caps modifiers
			key = string.reverse(key);
			iPos = strfind(key, "-", 1, true);
			if (iPos) then
				key = strsub(key, 1, iPos) .. strlower(strsub(key, iPos + 1));
			end
			key = string.reverse(key);

			text = text .. " (" .. key .. ")";
		end
		GameTooltip:AddLine(text,.9,.9,.9);
		local	text, key;
		text = KARMA_WINEL_MINIMENU_TOOLTIP2;
		key  = GetBindingKey("KARMAWINDOW2");
		if (key) and (key ~= "") then
			-- un-caps modifiers
			key = string.reverse(key);
			iPos = strfind(key, "-", 1, true);
			if (iPos) then
				key = strsub(key, 1, iPos) .. strlower(strsub(key, iPos + 1));
			end
			key = string.reverse(key);

			text = text .. " (" .. key .. ")";
		end
		GameTooltip:AddLine(text,.9,.9,.9);
		GameTooltip:AddLine(KARMA_WINEL_MINIMENU_TOOLTIP3,.9,.9,.9);

		local targetname, targetserver = UnitName("target");
		if (targetserver and (targetserver ~= "")) then
			targetname = targetname .. "@" .. targetserver;
		end
		if (targetname ~= nil) then
			if (UnitFactionGroup("player") == UnitFactionGroup("target") and UnitIsPlayer("target")) then
				local oMember = Karma_MemberList_GetObject(targetname);
				if (oMember ~= nil) then
					local	red, green, blue = Karma_MemberList_GetColors(targetname);
					local	iKarma, bModified = Karma_MemberObject_GetKarmaModified(oMember);
					local	sKarma;
					if (bModified) then
						sKarma = "*" .. iKarma;
					else
						sKarma = iKarma;
					end
					local	sNote = Karma_MemberObject_GetNotes(oMember);
					if (sNote and (sNote ~= "")) then
						GameTooltip:AddLine(targetname .. KARMA_WINEL_FRAG_COLONSPACE .. sKarma .. KARMA_WINEL_FRAG_SPACE .. KARMA_WINEL_TITLE, red, green, blue);
						local	sExtract = KOH.ExtractHeader(sNote);
						GameTooltip:AddLine(sExtract,.8,.8,.8,1);
					elseif (iKarma ~= 50) then
						GameTooltip:AddLine(targetname .. KARMA_WINEL_FRAG_COLONSPACE .. sKarma .. KARMA_WINEL_FRAG_SPACE .. KARMA_WINEL_TITLE, red, green, blue);
					end
				end
			end
		end

		GameTooltip:Show();
	end
end

function	Karma_MinimapIconFrame_TooltipHide()
	KARMA_Minimap_Tooltip_Hide = false;
	GameTooltip:Hide();
end

function	Karma_MinimapIconFrame_Clicked(self, button, down)
	if (button == "LeftButton") then
		Karma_ToggleWindow();
	elseif (button == "MiddleButton") then
		Karma_ToggleWindow2();
	elseif (button == "RightButton") then
		-- what do we want here... definitely Karma++/--
		ToggleDropDownMenu(1, nil, Karma_Minimap_Menu, self, 30, 30);
		KARMA_Minimap_Tooltip_Hide = true;
		GameTooltip:Hide();
	else
		KarmaChatDebug("Minimap icon: clicked " .. button .. " (unhandled)");
	end
end

local KARMA_MINIMAP_MENU_DROPDOWN = {
	[1] = {sName = KARMA_WINEL_INCREASE, iCommand = 503, bMemberOnly = true },
	[2] = {sName = KARMA_WINEL_DECREASE, iCommand = 497, bMemberOnly = true },
	[3] = {sName = KARMA_WINEL_MINIMENU_KARMACHANGE, iCommand = -1, bMemberOnly = true },
	[4] = {sName = KARMA_WINEL_MINIMENU_KARMAADDCHAR, iCommand = 100, bMemberOnly = false },
	[5] = {sName = KARMA_WINEL_MINIMENU_KARMASELCHAR, iCommand = 102, bMemberOnly = true },
	[6] = {sName = KARMA_WINEL_MINIMENU_KARMADELCHAR, iCommand = 101, bMemberOnly = true },
};

local KARMA_MINIMAP_MENUSUBSUBGOOD_DROPDOWN = {
	[1] = {sName = KARMA_WINEL_REASON_SKILL},
	[2] = {sName = KARMA_WINEL_REASON_HELP_KILL},
	[3] = {sName = KARMA_WINEL_REASON_HELP_INFO},
	[4] = {sName = KARMA_WINEL_REASON_HELP_ORGANIZE},
	[5] = {sName = KARMA_WINEL_REASON_MANNERS_UNCATEGORIZED},
	[6] = {sName = KARMA_WINEL_REASON_MANNERS_MODEST},
	[7] = {sName = KARMA_WINEL_REASON_MANNERS_POLITE},
	[8] = {sName = KARMA_WINEL_REASON_MANNERS_GENEROUS},
	[9] = {sName = KARMA_WINEL_REASON_MANNERS_GRACIOUS},
};

local KARMA_MINIMAP_MENUSUBSUBEVIL_DROPDOWN = {
	[1] = {sName = KARMA_WINEL_REASON_NINJA},
	[2] = {sName = KARMA_WINEL_REASON_KSER},
	[3] = {sName = KARMA_WINEL_REASON_SKILL},
	[4] = {sName = KARMA_WINEL_REASON_BOT},
	[5] = {sName = KARMA_WINEL_REASON_MANNERS_UNCATEGORIZED},
	[6] = {sName = KARMA_WINEL_REASON_MANNERS_CONCEITED},
	[7] = {sName = KARMA_WINEL_REASON_MANNERS_RUDE},
	[8] = {sName = KARMA_WINEL_REASON_MANNERS_SCAM},
	[9] = {sName = KARMA_WINEL_REASON_MANNERS_DRAMAQUEEN},
	[10] = {sName = KARMA_WINEL_REASON_SPAM_UNCATEGORIZED},
	[11] = {sName = KARMA_WINEL_REASON_SPAM_ALLCAPS},
	[12] = {sName = KARMA_WINEL_REASON_SPAM_WRONG_CHANNEL},
	[13] = {sName = KARMA_WINEL_REASON_SPAM_SPEED},
};

local	MenuTargetNameIndirect = nil;
local	MenuTargetNameSource = nil;
local	MenuTargetName = nil;
local	MenuTargetValid = false;

function	Karma_MinimapMenu_OnShow(self)
	UIDropDownMenu_Initialize(self, Karma_MinimapMenu_Initialize, "MENU");
end

function	Karma_MinimapMenu_Initialize(self, level)
	Karma_WhoAmIInit();
	local	sPlayerFaction = UnitFactionGroup("player");
	local	sName, sServer = UnitName("target");
	if ((sName == WhoAmI) or sServer and (sServer ~= "")) then
		sName = nil;
	end

	local	targetname = sName;
	local	HaveValidTarget, bIsMember = false, false;
	if (targetname ~= nil) then
		if (sPlayerFaction == UnitFactionGroup("target") and UnitIsPlayer("target")) then
			HaveValidTarget = true;
			bIsMember = (Karma_MemberList_GetObject(targetname) ~= nil);
		end
	end

	MenuTargetValid = HaveValidTarget;
	if (targetname == nil) then
		targetname = MenuTargetNameIndirect;
		HaveValidTarget = targetname ~= nil;
		bIsMember = (Karma_MemberList_GetObject(targetname) ~= nil);
	end

	local	info;
	if (level == 1) then
		MenuTargetName = targetname;

		info = {};
		if (HaveValidTarget) then
			info.text = KARMA_WINEL_TITLE .. KARMA_WINEL_MINIMENU_TARGETIS .. targetname;
		else
			info.text = KARMA_WINEL_TITLE .. KARMA_WINEL_MINIMENU_TARGETNONE;
		end
		if (MenuTargetNameIndirect and (MenuTargetNameIndirect ~= targetname)) then
			info.text = info.text .. "\n|cFFFF6060(indirect target overwritten)|r";
		end

		info.isTitle = 1;
		info.notCheckable = 1;
		UIDropDownMenu_AddButton(info);

		for i = 1, getn(KARMA_MINIMAP_MENU_DROPDOWN) do
			info = {};
			info.text = KARMA_MINIMAP_MENU_DROPDOWN[i].sName;
			info.notCheckable = 1;

			info.func = Karma_MinimapMenu_OnSelect;
			info.arg1 = KARMA_MINIMAP_MENU_DROPDOWN[i].iCommand;
			info.arg2 = targetname;

			if (info.arg1 == -1) then
				info.hasArrow = 1;
			end

			if (KARMA_MINIMAP_MENU_DROPDOWN[i].bMemberOnly ~= nil) then
				if (KARMA_MINIMAP_MENU_DROPDOWN[i].bMemberOnly ~= bIsMember) then
					info.disabled = 1;
				end
			end

			UIDropDownMenu_AddButton(info);
		end

		info = {};
		info.text = "------------";
		info.notCheckable = 1;
		info.notClickable = 1;
		info.justifyH = "CENTER";
		UIDropDownMenu_AddButton(info);

		info = {};
		info.text = "Target from chat...";
		info.value = "chat";
		info.notCheckable = 1;
		info.hasArrow = 1;
		UIDropDownMenu_AddButton(info);

		info = {};
		info.text = "Target from mouseover...";
		info.value = "mouseover";
		info.notCheckable = 1;
		info.hasArrow = 1;
		UIDropDownMenu_AddButton(info);

		info = {};
		info.text = "Target from history...";
		info.value = "history";
		info.notCheckable = 1;
		info.hasArrow = 1;
		UIDropDownMenu_AddButton(info);

		info = {};
		info.text = "Reset target";
		info.notCheckable = 1;
		info.func = Karma_MinimapMenu_OnSelect;
		info.arg1 = 200;
		UIDropDownMenu_AddButton(info);

		info = {};
		info.text = "------------";
		info.notCheckable = 1;
		info.notClickable = 1;
		info.justifyH = "CENTER";
		UIDropDownMenu_AddButton(info);

		info = {};
		info.text = TEXT(CANCEL);
		info.notCheckable = 1;
		info.func = Karma_MinimapMenu_OnSelect;
		info.arg1 = 0;
		UIDropDownMenu_AddButton(info);

		UIDropDownMenu_SetAnchor(self);
	elseif (level == 2) and (MenuTargetName == targetname) then
		-- Submenu
		-- choices for setting indirect menu targets
		if (UIDROPDOWNMENU_MENU_VALUE == "chat") then
			if (KarmaModuleLocal.ChatRememberList[1] ~= nil) then
				local	oKey = {};
				for i = 1, KarmaModuleLocal.ChatRememberCount do
					local	Value = KarmaModuleLocal.ChatRememberList[i];
					if (Value) then
						oKey[i] = { Key = i, Value = Value.Time };
					end
				end

				KOH.GenericSort(oKey, function(a, b) return a.Value < b.Value end);

				local	k, v;
				for k, v in pairs(oKey) do
					local	Value = KarmaModuleLocal.ChatRememberList[v.Key];

					info = {};
					info.text = Value.Name;
					if (Value.ClassEN) then
						local oColor = RAID_CLASS_COLORS[Value.ClassEN];
						if (oColor) then
							info.text = string.format("\124cFF%.2X%.2X%.2X", oColor.r*255, oColor.g*255, oColor.b*255) .. info.text .. "\124r";
						end
					elseif (Value.Class) then
					end

					local	sFaction = strsub(Value.Faction or "?", 1, 1);
					if (Value.Level) then
						sFaction = Value.Level .. " " .. sFaction;
					end
					info.text = info.text .. " (" .. sFaction .. ")";
					info.notCheckable = 1;
					if (sPlayerFaction == Value.Faction) then
						info.value = { Source = "chat", Key = v.Key };
						info.func = Karma_MinimapMenu_OnSelect;
						info.arg1 = 201;
						info.arg2 = Value.Name;
						info.hasArrow = 1;
					else
						info.disabled = 1;
					end
					UIDropDownMenu_AddButton(info, level);
				end
			end
		elseif (UIDROPDOWNMENU_MENU_VALUE == "mouseover") then
			if (KarmaModuleLocal.MouseOverKeepList[1] ~= nil) then
				local	oKey = {};
				for i = 1, KarmaModuleLocal.MouseOverKeepCount do
					local	Value = KarmaModuleLocal.MouseOverKeepList[i];
					if (Value) then
						oKey[i] = { Key = i, Value = Value.Time };
					end
				end

				KOH.GenericSort(oKey, function(a, b) return a.Value < b.Value end);

				local	k, v;
				for k, v in pairs(oKey) do
					local	Value = KarmaModuleLocal.MouseOverKeepList[v.Key];

					info = {};
					info.text = Value.Name;
					if (Value.ClassEN) then
						local oColor = RAID_CLASS_COLORS[Value.ClassEN];
						if (oColor) then
							info.text = string.format("\124cFF%.2X%.2X%.2X", oColor.r*255, oColor.g*255, oColor.b*255) .. info.text .. "\124r";
						end
					elseif (Value.Class) then
						local ClassID = KOH.ClassToID(Value.Class);
						if  (ClassID < 0) then
							ClassID = - ClassID;
						end
						local	sClassWOGender = KOH.IDToClass(ClassID);
						local	r, g, b = Karma_ClassMToColor(sClassWOGender);
						info.text = string.format("\124cFF%.2X%.2X%.2X", r*255, g*255, b*255) .. info.text .. "\124r";
					end
					local	sFaction = strsub(Value.Faction or "?", 1, 1);
					if (Value.Level) then
						sFaction = Value.Level .. " " .. sFaction;
					end
					info.text = info.text .. " (" .. sFaction .. ")";
					info.notCheckable = 1;
					if (sPlayerFaction == Value.Faction) then
						info.value = { Source = "mouseover", Key = v.Key };
						info.func = Karma_MinimapMenu_OnSelect;
						info.arg1 = 202;
						info.arg2 = Value.Name;
						info.hasArrow = 1;
					else
						info.disabled = 1;
					end
					UIDropDownMenu_AddButton(info, level);
				end
			end
		elseif (UIDROPDOWNMENU_MENU_VALUE == "history") then
			local	iMax = KarmaModuleLocal.Raid.iIndexHistory;
			local	oHistories = KarmaModuleLocal.Raid.HistoryTables;
			local	oHistory = oHistories[1];
			if ((iMax > 1) or (oHistory ~= nil)) then
				local	i;
				for i = 1, iMax do
					oHistory = oHistories[i];
					if (oHistory ~= nil) then
						info = {};
						if (oHistory.__Instance) then
							info.text = oHistory.__Instance .. ": done at " .. date("%H:%M", oHistory.__End or time());
						else
							info.text = i .. ": " .. date("%H:%M", oHistory.__Start) .. " => " .. date("%H:%M", oHistory.__End or time());
						end
						info.value = { Source = "history", Set = i };
						info.notCheckable = 1;
						info.hasArrow = 1;
						UIDropDownMenu_AddButton(info, level);
					end
				end
			end
		elseif (HaveValidTarget and (MenuTargetName == targetname)) then
			local values;
			values = {};
			values = { 1, 2, 5, 10 };
			info = {};
			info.text = KARMA_WINEL_MINIMENUSUB_INCREASE;
			info.notCheckable = 1;
			info.notClickable = 1;
			UIDropDownMenu_AddButton(info, 2);

			for i = 1, getn(values) do
				local	value = values[i];

				info = {};
				info.text = KARMA_WINEL_MINIMENUSUB_PLUS .. value;
				info.func = Karma_MinimapMenu_OnSelect;
				info.notCheckable = 1;
				info.hasArrow = 1;
				info.value = 500 + value;
				info.arg1 = 500 + value;
				info.arg2 = targetname;
				UIDropDownMenu_AddButton(info, 2);
			end

			info = {};
			info.text = KARMA_WINEL_MINIMENUSUB_DECREASE;
			info.notCheckable = 1;
			info.notClickable = 1;
			UIDropDownMenu_AddButton(info, 2);

			for i = 1, getn(values) do
				local	value = values[i];

				info = {};
				info.text = KARMA_WINEL_MINIMENUSUB_MINUS .. value;
				info.func = Karma_MinimapMenu_OnSelect;
				info.notCheckable = 1;
				info.hasArrow = 1;
				info.value = 500 - value;
				info.arg1 = 500 - value;
				info.arg2 = targetname;
				UIDropDownMenu_AddButton(info, 2);
			end
		end
	elseif (level == 3) then
		if (type(UIDROPDOWNMENU_MENU_VALUE) == "table") then
			local	oData = UIDROPDOWNMENU_MENU_VALUE;
			if (oData.Source == "chat") then
				local	Value = KarmaModuleLocal.ChatRememberList[oData.Key];
				if (Value.Messages) then
					local	iCnt, i = #Value.Messages;
					for i = 1, iCnt do
						local	sMsg = Value.Messages[i].Message;
						local	sLen = KarmaObj.UTF8.LenInChars(sMsg);
						if (sLen > 40) then
							if (sLen > 80) then
								if (sLen > 120) then
									sMsg = KarmaObj.UTF8.SubInChars(sMsg, 1, 40)
										.. "\n_________" .. KarmaObj.UTF8.SubInChars(sMsg, 41, 80)
										.. "\n_________" .. KarmaObj.UTF8.SubInChars(sMsg, 81, 115) .. "(...)";
								else
									sMsg = KarmaObj.UTF8.SubInChars(sMsg, 1, 40)
										.. "\n_________" .. KarmaObj.UTF8.SubInChars(sMsg, 41, 80)
										.. "\n_________" .. KarmaObj.UTF8.SubInChars(sMsg, 81);
								end
							else
								sMsg = KarmaObj.UTF8.SubInChars(sMsg, 1, 40)
									.. "\n_________" .. KarmaObj.UTF8.SubInChars(sMsg, 41);
							end
						end

						info = {};
						info.text = date("%H:%M:%S ", Value.Messages[i].At) .. sMsg;
						info.func = Karma_MinimapMenu_OnSelect;
						info.arg1 = 205;
						info.arg2 = { Source = oData.Source, Key = oData.Key, Message = i };
						info.notCheckable = 1;
						UIDropDownMenu_AddButton(info, level);

						if (i < iCnt) then
							info = {};
							info.text = " ";
							info.notCheckable = 1;
							UIDropDownMenu_AddButton(info, level);
						end
					end
				end
			end
			if (oData.Source == "mouseover") then
				local	Value = KarmaModuleLocal.MouseOverKeepList[oData.Key];

				info = {};
				info.text = date("%H:%M:%S ", Value.Time) .. "Seen in " .. Value.Zone;
				info.notCheckable = 1;
				UIDropDownMenu_AddButton(info, level);
			end
			if (oData.Source == "history") then
				local	oHistories = KarmaModuleLocal.Raid.HistoryTables;
				local	oHistory = oHistories[oData.Set];
				if (oHistory ~= nil) then
					local	iTotal, k, v = (oHistory.__End or time()) - oHistory.__Start;
					for k, v in pairs(oHistory) do
						if ((k ~= "__Start") and (k ~= "__End") and (k ~= "__Instance") and (k ~= WhoAmI)) then
							local	iLeft = v.Left or time();
							local	iTimeInRaid = iLeft - v.JoinedFirst - v.Sideline;

							info = {};
							info.text = k;		-- TODO: class color, Karma rating
							info.text = info.text .. ": " .. date("%H:%M", v.JoinedFirst) .. " => " .. date("%H:%M", v.Left or time()) .. format(" (%.2f%%)", 100 * iTimeInRaid / iTotal);
							info.notCheckable = 1;
							UIDropDownMenu_AddButton(info, level);
						end
					end
				end
			end
		end

		if ((type(UIDROPDOWNMENU_MENU_VALUE) == "number") and HaveValidTarget and (MenuTargetName == targetname)) then
			-- Subsubmenu: parent selection required!
			info = {};
			info.text = KARMA_WINEL_REASON_NONE;
			info.notCheckable = 1;
			info.func = Karma_MinimapMenu_OnSelect;
			info.arg1 = 0;
			UIDropDownMenu_AddButton(info, 3);

			local	ParentID = UIDROPDOWNMENU_MENU_VALUE;
			local	Menu = nil;
			if (ParentID >= 500) then
				Menu = KARMA_MINIMAP_MENUSUBSUBGOOD_DROPDOWN;
			else
				Menu = KARMA_MINIMAP_MENUSUBSUBEVIL_DROPDOWN;
			end
			for i = 1, getn(Menu) do
				info = {};
				info.text = Menu[i].sName;
				info.notCheckable = 1;

				info.func = Karma_MinimapMenu_OnSelect;
				info.arg1 = i * 1000 + ParentID;
				info.arg2 = targetname;

				if ((info.arg1 > 0) or (info.arg1 == -1)) and (HaveValidTarget == false) then
					info.disabled = 1;
					info.arg1 = -2;
				else
					info.disabled = nil;
				end

				UIDropDownMenu_AddButton(info, 3);
			end

			info = {};
			info.text = "------------";
			info.notCheckable = 1;
			info.notClickable = 1;
			info.justifyH = "CENTER";
			UIDropDownMenu_AddButton(info, 3);

			info = {};
			info.text = TEXT(CANCEL);
			info.notCheckable = 1;
			info.func = Karma_MinimapMenu_OnSelect;
			info.arg1 = 0;
			if (self:GetParent() ~= nil) then
				ParentID =  UIDROPDOWNMENU_MENU_VALUE;
				-- KarmaChatDebug("Karma_MinimapMenu_Initialize(3): ParentID = " .. Karma_NilToString(ParentID));
			end
			UIDropDownMenu_AddButton(info, 3);
		end
	end
end

function Karma_MinimapMenu_OnSelect(self, arg1, arg2)
	CloseDropDownMenus();
	KarmaChatDebug("Karma_MinimapMenu_OnSelect: Action " .. (arg1 or "<nil>") .. "/" .. (noteSel or "<nil>") .. " on target " .. (arg2 and tostring(arg2) or "<nil>"));
	if (arg1 ~= nil) then
		if (type(arg2) == "table") then
			-- line from chat: option to add to private note?
			local	oData = KarmaModuleLocal.ChatRememberList[arg2.Key];
		else
			local noteSel = math.floor(arg1 / 1000);
			arg1 = arg1 % 1000;
			local note = nil;
			if (noteSel > 0) then
				if (arg1 > 500) then
					note = KARMA_WINEL_FRAG_PLUS .. (arg1 - 500) .. KARMA_WINEL_FRAG_COLONSPACE .. KARMA_MINIMAP_MENUSUBSUBGOOD_DROPDOWN[noteSel].sName;
				else
					note = (arg1 - 500) .. KARMA_WINEL_FRAG_COLONSPACE .. KARMA_MINIMAP_MENUSUBSUBEVIL_DROPDOWN[noteSel].sName;
				end
			end

			if (arg1 >= 400) then
				-- KarmaChatDebug("Karma_MinimapMenu_OnSelect: Action " .. arg1 .. " on target " .. arg2 .. " with note " .. Karma_NilToString(note));
				Karma_ChangeKarma(arg2, false, arg1 - 500, note);
			elseif (arg1 == 100) then
				-- if target, add directly, otherwise regular add
				local	sTargetName;
				if (MenuTargetValid) then
					local	sTargetServer;
					sTargetName, sTargetServer = UnitName("target");
					if (sTargetServer and (sTargetServer ~= "")) then
						sTargetName = sTargetName .. "@" .. sTargetServer;
					end
				end
				if (sTargetName and (sTargetName == arg2)) then
					KarmaChatSecondaryFallbackDefault("Requested to add currently targetted unit <" .. arg2 .. "> - executing quick add.");

					Karma_MemberList_Add(arg2);
					-- Karma_MemberList_Update(arg2, level, class, race, guild);
					Karma_MemberList_Update(arg2, UnitLevel("target"), UnitClass("target"), UnitRace("target"));
					Karma_UpdateMember(args2);
					Karma_SetCurrentMember(arg2);
				else
					local	args = { [2] = arg2 };
					Karma_Command_AddMember_Insert(args);
					KarmaChatSecondaryFallbackDefault("Queued /who to add " .. arg2 .. " to the list of known players.");
				end
			elseif (arg1 == 101) then
				if (arg2 == KARMA_CURRENTMEMBER) then
					Karma_SetCurrentMember(nil);
				end;
				Karma_MemberList_Remove(arg2);
				Karma_MemberList_ResetMemberNamesCache();
				KarmaWindow_Update();
			elseif (arg1 == 102) then
				Karma_SetCurrentMember(arg2);
			elseif (arg1 == 200) then
				if (MenuTargetNameIndirect) then
					KarmaChatSecondaryFallbackDefault("Indirect target " .. MenuTargetNameIndirect .. " has been reset.");
					MenuTargetNameIndirect = nil;
				end
			elseif (arg1 == 201) then
				MenuTargetNameSource = "chat";
				MenuTargetNameIndirect = arg2;
				if (MenuTargetNameIndirect) then
					KarmaChatSecondaryFallbackDefault("Indirect target is now " .. MenuTargetNameIndirect .. " (from chat).");
				end
			elseif (arg1 == 202) then
				MenuTargetNameSource = "mouseover";
				MenuTargetNameIndirect = arg2;
				if (MenuTargetNameIndirect) then
					KarmaChatSecondaryFallbackDefault("Indirect target is now " .. MenuTargetNameIndirect .. " (from mouseover).");
				end
			end
		end
	end
end

---
---- Tooltips 
---
local	Karma_ObjectIsTipData =
	{
		["KarmaOptionsWindow_ColorSpace_Enable_Checkbox"] = KARMA_TOOLTIPS["COLORSPACE_ENABLE_CHECKBOX"],

		["KarmaOptionWindow_DBClean_AutoClean_Checkbox"] = KARMA_WINEL_AUTOCLEANCHECKBOXTOOLTIP,
		["KarmaOptionWindow_DBClean_KeepIfNote_Checkbox"] = KARMA_WINEL_DBCLEANKEEPIFNOTETOOLTIP,
		["KarmaOptionWindow_DBClean_RemovePvPJoins_Checkbox"] = KARMA_WINEL_DBCLEANREMOVEPVPJOINSTOOLTIP,
		["KarmaOptionWindow_DBClean_RemoveXServer_Checkbox"] = KARMA_WINEL_DBCLEANREMOVEXSERVERTOOLTIP,
		["KarmaOptionWindow_DBClean_KeepIfKarma_Checkbox"] = KARMA_WINEL_DBCLEANKEEPIFKARMATOOLTIP,
		["KarmaOptionWindow_DBClean_KeepIfQListThres_Editbox"] = KARMA_WINEL_DBCLEANKEEPIFQUESTNUMTOOLTIP,
		["KarmaOptionWindow_DBClean_KeepIfRListThres_Editbox"] = KARMA_WINEL_DBCLEANKEEPIFREGIONNUMTOOLTIP,
		["KarmaOptionWindow_DBClean_KeepIfZListThres_Editbox"] = KARMA_WINEL_DBCLEANKEEPIFZONENUMTOOLTIP,
		["KarmaOptionWindow_DBClean_IgnorePVPZones_Checkbox"] = KARMA_WINEL_DBCLEANIGNOREPVPZONESTOOLTIP,

		["KarmaOptionWindow_Other_ContextMenuDeactivate_Checkbox"] = KARMA_WINEL_CONTEXTMENUDEACTIVATE_TOOLTIP,
		["KarmaOptionWindow_Other_DBSparseTables_Checkbox"] = KARMA_WINEL_DBSPARSETABLES_TOOLTIP,

		["KarmaOptionWindow_DBClean_Test_Button"] = KARMA_WINEL_DBCLEAN_TESTTOOLTIP,

		-- TODO: add Filter-Tooltip
	};

local	Karma_ObjectIsTipExtraData =
	{
		["KarmaOptionWindow_DBClean_AutoClean_Checkbox"] = KARMA_WINEL_AUTOCLEANCHECKBOXTOOLTIPEXTRA,
	};

local	function	FillTooltip(fieldoftext)
	if (type(fieldoftext) == "table") then
		local	first = true;
		for i, text in pairs(fieldoftext) do
			if first then
				GameTooltip:AddLine(KARMA_WINEL_TITLE .. KARMA_WINEL_FRAG_COLONSPACE .. text);
				first = false;
			else
				GameTooltip:AddLine(text,.9,.9,.9);
			end
		end
	elseif (type(fieldoftext) == "string") then
		GameTooltip:AddLine(fieldoftext, 1, 1, 0);
	else
		KarmaChatDebug("Help text in unrecognized format!");
	end
end

function Karma_FromTable_Tooltip(oFrame)
	local	Name = oFrame:GetName();
	if (Karma_ObjectIsTipData[Name]) then
		GameTooltip:SetOwner(oFrame, "ANCHOR_BOTTOMLEFT");

		FillTooltip(Karma_ObjectIsTipData[Name]);
		if (Karma_ObjectIsTipExtraData[Name]) then
			GameTooltip:AddLine(Karma_ObjectIsTipExtraData[Name],.9,.6,.4);
		end

		GameTooltip:Show();
	else
		KarmaChatDebug("Missing help text for object <" .. Name .. ">!");
	end
end

---
---- Option window: initialization
---
function	KarmaOptionsWindow_OnLoad(self)
	-- hook it to Addons - panel (okay/cancel do nothing for us)
	self.name   = KARMA_ITSELF;
	InterfaceOptions_AddCategory(self);
end

function	KarmaOptionsWindow_OnShow(self)
	self.ParentWidth = InterfaceOptionsFrame:GetWidth();
	if (self.PreviousWidth) then
		InterfaceOptionsFrame:SetWidth(self.PreviousWidth);
	end
end

function	KarmaOptionsWindow_OnHide(self)
	self.PreviousWidth = InterfaceOptionsFrame:GetWidth();
	if (self.ParentWidth) then
		InterfaceOptionsFrame:SetWidth(self.ParentWidth);
	end
end

function	KarmaOptionsWindow_Show()
	if (not KarmaOptionsWindow:IsVisible()) then
		InterfaceOptionsFrame_OpenToCategory(KarmaOptionsWindow);
	end
end

---
---- Option window: categories
---
local	KARMA_OPTIONWINDOW_CAT = {};

function	KarmaObj.UI.OptWnd.CatAdd(frame, id)
	KOH.TableInit(KARMA_OPTIONWINDOW_CAT, id);
	tinsert(KARMA_OPTIONWINDOW_CAT[id], frame);
end

function KarmaOptionWindowCategoriesHideAll()
	local	id, oCat, key, frame;
	for id, oCat in pairs(KARMA_OPTIONWINDOW_CAT) do
		for key, frame in pairs(oCat) do
			frame:Hide();
		end
	end
end

local	Karma_OptionWindowCatCount = 5;

function KarmaOptionWindowCategory_OnClick(btnobj)
	KarmaOptionWindowCategoriesHideAll();

	local	id, oCat;
	for id, oCat in pairs(KARMA_OPTIONWINDOW_CAT) do
		getglobal("KarmaOptionWindowCategory_Button" .. id):UnlockHighlight();
	end
	btnobj:LockHighlight();

	local	btnid = btnobj:GetID();
	if (KARMA_OPTIONWINDOW_CAT[btnid]) then
		local	iRightParent = InterfaceOptionsFramePanelContainer:GetRight();
		local	iRightNew = 0;

		local	key, value;
		for key, value in pairs(KARMA_OPTIONWINDOW_CAT[btnid]) do
			value:Show();

			local	iRight = value:GetRight() + 15;
			if (iRight > iRightNew) then
				iRightNew = iRight;
			end
		end

		if (iRightNew > 0) then
			if (iRightNew > iRightParent + 5) then 
				InterfaceOptionsFrame:SetWidth(InterfaceOptionsFrame:GetWidth() + iRightNew - iRightParent);
			elseif ((iRightNew < iRightParent - 5) and KarmaOptionsWindow.ParentWidth) then
				local	iWidth = InterfaceOptionsFrame:GetWidth() + iRightNew - iRightParent;
				if (iWidth > KarmaOptionsWindow.ParentWidth) then
					InterfaceOptionsFrame:SetWidth(iWidth);
				else
					InterfaceOptionsFrame:SetWidth(KarmaOptionsWindow.ParentWidth);
				end
			end
		end
	end
end

---
---- Main window: Filter stuff
---
function	Karma_ParseFilter(F)
	local Pattern, Name, C, LF, LT, KF, KT, JoinedAfter, JoinedBefore, Notes, Pub, Guild, Instance;
	if F ~= nil then
		-- force copy
		F = strsub(F, 1)
		while F ~= "" do
			local	SpacePos = strfind(F, " ", 1);
			local	FSub = nil;
			if SpacePos ~= nil then
				FSub = strsub(F, 1, SpacePos - 1);
				F = strsub(F, SpacePos + 1);
			else
				FSub = F;
				F = "";
			end

			local	Type, Value;
			if strsub(FSub, 2, 2) == "-" then
				Type = strsub(FSub, 1, 1);
				Value = strsub(FSub, 3);
				-- if Value starts with a "...
				if (Value and (strsub(Value, 1, 1) == "\"")) then
					-- ... find a matching " afterwards, followed by space or end of line
					local	iMatch = strfind(F, "\"");
					if (iMatch and ((iMatch == strlen(F)) or (strsub(F, iMatch + 1, iMatch + 1) == " "))) then
						Value = Value .. " " .. strsub(F, 1, iMatch);
						F = strsub(F, iMatch + 1);
					end

					-- if it's properly quoted, remove the quotes
					local	iValLen = strlen(Value);
					if (strsub(Value, iValLen, iValLen) == "\"") then
						Value = strsub(Value, 2, iValLen - 1);
					end
				end
			else
				Type = "n";
				Value = FSub;
			end

			if (Value ~= "") then
				if Type == "p" then
					Pattern = Value;
				elseif Type == "n" then
					Name = Value;
				elseif Type == "c" then
					C = Value;
				elseif Type == "i" then
					Notes = Value;
				elseif Type == "u" then
					Pub = Value;
				elseif Type == "a" then
					JoinedAfter = tonumber(Value);
				elseif Type == "b" then
					JoinedBefore = tonumber(Value);
				elseif Type == "g" then
					Guild = Value;
				elseif Type == "r" then
					Instance = Value;
				else
					local	ValueFrom = Value;
					local	ValueTo   = Value;
					local	MinusPos  = strfind(Value, "-", 1);
					if MinusPos ~= nil then
						ValueFrom = strsub(Value, 1, MinusPos - 1);
						ValueTo   = strsub(Value, MinusPos + 1);
					end
						
					if Type == "l" then
						LF = ValueFrom;
						LT = ValueTo;
					end
					if Type == "k" then
						KF = ValueFrom;
						KT = ValueTo;
					end
				end
			end
		end

		if (Name == "") then
			Name = nil;
		end
		if (Name) then
			Name = KarmaObj.StringInitialCapitalized(Name);
		end
		if (C == "") then
			C = nil;
		end
		if (LF == "") then
			LF = nil;
		end
		if (LT == "") then
			LT = nil;
		end
		if (KF == "") then
			KF = nil;
		end
		if (KT == "") then
			KT = nil;
		end
		if (Notes == "") then
			Notes = nil;
		end
		if (Pub == "") then
			Pub = nil;
		end
		if (Guild == "") then
			Guild = nil;
		end
		if (Instance == "") then
			Instance = nil;
		end
	end

	return Pattern, Name, C, LF, LT, KF, KT, JoinedAfter, JoinedBefore, Notes, Pub, Guild, Instance;
end

function Karma_ExecuteFilter(CurrentFilter)
	local	cfPattern, cfName, cfClass, cfLevelFrom, cfLevelTo, cfKarmaFrom, cfKarmaTo,
		cfJoinedAfter, cfJoinedBefore, cfNotes, cfPublic, cfGuild, cfInstance = Karma_ParseFilter(CurrentFilter);
	if CurrentFilter ~= KARMA_Filter.Total then
		KARMA_Filter.Total = CurrentFilter;

--		KarmaChatDefault("Karma: Filter(N, C, L, V) = (" .. Karma_NilToString(cfName)
--			.. ", " .. Karma_NilToString(cfClass) .. ", " .. Karma_NilToString(cfLevel)
--			.. ", " .. Karma_NilToString(cfKarma));

		KARMA_Filter.Pattern = cfPattern;
		KARMA_Filter.Name = cfName;
		KARMA_Filter.Class = cfClass;
		KARMA_Filter.LevelFrom = tonumber(cfLevelFrom);
		KARMA_Filter.LevelTo = tonumber(cfLevelTo);
		KARMA_Filter.KarmaFrom = tonumber(cfKarmaFrom);
		KARMA_Filter.KarmaTo = tonumber(cfKarmaTo);
		KARMA_Filter.JoinedAfter = cfJoinedAfter;
		KARMA_Filter.JoinedBefore = cfJoinedBefore;
		KARMA_Filter.Notes = cfNotes;
		KARMA_Filter.Public = cfPublic;
		KARMA_Filter.Guild = cfGuild;
		KARMA_Filter.Instance = cfInstance;

		local	sDbg, k, v = "";
		for k, v in pairs(KARMA_Filter) do
			if (v ~= nil) then
				sDbg = sDbg .. " / " .. k .. " = <" .. v .. ">";
			end
		end
		if (sDbg ~= "") then
			KarmaChatDebug("Parsed: >> " .. strsub(sDbg, 4) .. " <<");
		end

		Karma_MemberList_ResetMemberNamesCache();
		KarmaWindow_UpdateMemberList();
	end
end

function KarmaWindow_FilterUpdateText()
	local	CurrentFilter = KarmaWindow_Filter_EditBox:GetText();
	if strlen(CurrentFilter) == 0 then
		CurrentFilter = nil;
	end

	Karma_ExecuteFilter(CurrentFilter);
end

function	KarmaObj.UI.Filter_Editbox_Tooltip(self, title, key, anchor)
	-- ANCHOR_BOTTOMLEFT: links unten
	if Karma_ShowTooltipHelp() and (type(KARMA_TOOLTIPS[key]) == "table") then
		if (anchor) then
			GameTooltip:SetOwner(self, anchor);
		else
			GameTooltip:SetOwner(self, "ANCHOR_TOPRIGHT");
		end
	
		GameTooltip:AddLine(KARMA_WINEL_TITLE .. KARMA_WINEL_FRAG_COLONSPACE .. title);
		local	bNextIsBrighter = false;
		for key, value in pairs(KARMA_TOOLTIPS[key]) do
			if (value == "") then
				bNextIsBrighter = true;
			else
				if (bNextIsBrighter) then
					GameTooltip:AddLine(value, 0.9, 0.9, 0.9);
					bNextIsBrighter = false;
				else
					GameTooltip:AddLine(value, 0.8, 0.8, 0.8);
				end
			end
		end
	
		GameTooltip:Show();
	end
end

function	Karma_FilterInit()
	if (KARMA_Filter.Total ~= nil) then
		if (KARMA_Filter.Name ~= nil) then
			KarmaFilterWindow_NameStarts_Editbox:SetText(KARMA_Filter.Name);
		end
		if (KARMA_Filter.Class ~= nil) then
			KarmaFilterWindow_Class_Editbox:SetText(KARMA_Filter.Class);
		end
		if (KARMA_Filter.LevelFrom ~= nil) then
			KarmaFilterWindow_LevelFrom_Editbox:SetText(KARMA_Filter.LevelFrom);
		end
		if (KARMA_Filter.LevelTo ~= nil) then
			KarmaFilterWindow_LevelTo_Editbox:SetText(KARMA_Filter.LevelTo);
		end
		if (KARMA_Filter.KarmaFrom ~= nil) then
			KarmaFilterWindow_KarmaFrom_Editbox:SetText(KARMA_Filter.KarmaFrom);
		end
		if (KARMA_Filter.KarmaTo ~= nil) then
			KarmaFilterWindow_KarmaTo_Editbox:SetText(KARMA_Filter.KarmaTo);
		end
		if (KARMA_Filter.JoinedAfter ~= nil) then
			if (KARMA_Filter.JoinedAfter < 0) then
				local	sText = tostring(- KARMA_Filter.JoinedAfter) .. " days ago";
				KarmaFilterWindow_JoinedAfter_Editbox:SetText(sText);
			elseif (KARMA_Filter.JoinedAfter > 1000000) then
				KarmaFilterWindow_JoinedAfter_Editbox:SetText(date(KARMA_DATEFORMAT, KARMA_Filter.JoinedAfter));
			end
		end
		if (KARMA_Filter.JoinedBefore ~= nil) then
			if (KARMA_Filter.JoinedBefore < 0) then
				local	sText = tostring(- KARMA_Filter.JoinedBefore) .. " days ago";
				KarmaFilterWindow_JoinedBefore_Editbox:SetText(sText);
			elseif (KARMA_Filter.JoinedBefore > 1000000) then
				KarmaFilterWindow_JoinedBefore_Editbox:SetText(date(KARMA_DATEFORMAT, KARMA_Filter.JoinedBefore));
			end
		end
		if (KARMA_Filter.Notes ~= nil) then
			KarmaFilterWindow_NotePrivate_Editbox:SetText(KARMA_Filter.Notes);
		end
		if (KARMA_Filter.Public ~= nil) then
			KarmaFilterWindow_NotePublic_Editbox:SetText(KARMA_Filter.Public);
		end
		if (KARMA_Filter.Instance ~= nil) then
			KarmaFilterWindow_RegionVisitedWith_Editbox:SetText(KARMA_Filter.Instance);
		end
	end
end

function	Karma_FilterOk()
	local	StrToDate = function(Value)
			-- direct value: valid if negative, equals days ago
			local	Result = tonumber(Value);

			if (Result == nil) then
				-- "nnn days ago" -> -nnn
				Result = string.gsub(Value, "(%d+) days ago", "%1");
				if (Result) then
					Result = tonumber(Result);
					if (Result) then
						Result = - Result;
					end
				end
			end

			if ((Result == nil) or (type(Result) ~= "number") or (Result < - 3650) or ((Result >= 0) and (Result < 9000000))) then
				-- split at known delimiters (if any language uses other, need to adjust...)
				local	a1, a2, a3, x = strsplit(".", Value);
				if (a2 == nil) then
					a1, a2, a3, x = strsplit("-", Value);
					if (a2 == nil) then
						a1, a2, a3, x = strsplit("/", Value);
					end
				end

				-- yay, exactly 3 args
				if ((a3 ~= nil) and (x == nil)) then
					a1 = tonumber(a1);
					a2 = tonumber(a2);
					a3 = tonumber(a3);
				end

				if ((a1 ~= nil) and (a2 ~= nil) and (a3 ~= nil)) then
					local	a = { [1] = a1, [2] = a2, [3] = a3 };

					-- now we need to assign it to day, month, year in the same order as we would output it ourselves...
					local	d, m, y;

					local	PosArg, Max, Pos = {}, 0;
					Pos = strfind(KARMA_DATEFORMAT, "%d", 1, true);
					if (Pos) then
						PosArg[Pos] = "D";
						Max = math.max(Pos, Max);
					end
					Pos = strfind(KARMA_DATEFORMAT, "%m", 1, true);
					if (Pos) then
						PosArg[Pos] = "M";
						Max = math.max(Pos, Max);
					end
					Pos = strfind(KARMA_DATEFORMAT, "%Y", 1, true);
					if (Pos) then
						PosArg[Pos] = "Y";
						Max = math.max(Pos, Max);
					end
					Pos = 1;
					for x = 1, Max do
						if (PosArg[x]) then
							if (PosArg[x] == "D") then
								d = a[Pos];
								Pos = Pos + 1;
							elseif (PosArg[x] == "M") then
								m = a[Pos];
								Pos = Pos + 1;
							elseif (PosArg[x] == "Y") then
								y = a[Pos];
								Pos = Pos + 1;
							end
						end
					end

					KarmaChatDebug("StrToDate: d = " .. (d or "<nil>") .. ", m = " .. (m or "<nil>") .. ", y = " .. (y or "<nil>"));

					-- got all assigned, try to convert only if in sensible ranges
					if ((d ~= nil) and (m ~= nil) and (y ~= nil)) then
						if ((d >= 1) and (d <= 31) and (m >= 1) and (m <= 12) and (y >= 2000)) then
							local	tValue = { year = y, month = m, day = d };
							Result = time(tValue);
						end
					end
				end
			end

			return Result;
		end

	local	NewTotal = "";
	local	Delimiter = "";
	local	Space = " ";

	local	text = KarmaFilterWindow_NameStarts_Editbox:GetText();
	if (text ~= "") then
		NewTotal = NewTotal .. Delimiter .. "n-" .. text;
		Delimiter = Space;
	end

	text = KarmaFilterWindow_NameContains_Editbox:GetText();
	if (text ~= "") then
		NewTotal = NewTotal .. Delimiter .. "p-" .. text;
		Delimiter = Space;
	end

	text = KarmaFilterWindow_Class_Editbox:GetText();
	if (text ~= "") then
		NewTotal = NewTotal .. Delimiter .. "c-" .. text;
		Delimiter = Space;
	end

	local	textFrom = KarmaFilterWindow_LevelFrom_Editbox:GetText();
	local	textTo = KarmaFilterWindow_LevelTo_Editbox:GetText();
	if (textFrom ~= "") or (textTo ~= "") then
		NewTotal = NewTotal .. Delimiter .. "l-" .. textFrom .. "-" .. textTo;
		Delimiter = Space;
	end

	textFrom = KarmaFilterWindow_KarmaFrom_Editbox:GetText();
	textTo = KarmaFilterWindow_KarmaTo_Editbox:GetText();
	if (textFrom ~= "") or (textTo ~= "") then
		NewTotal = NewTotal .. Delimiter .. "k-" .. textFrom .. "-" .. textTo;
		Delimiter = Space;
	end

	text = KarmaFilterWindow_JoinedAfter_Editbox:GetText();
	if (text ~= "") then
		local	iValue = StrToDate(text);
		if (iValue) then
			NewTotal = NewTotal .. Delimiter .. "a-" .. iValue;
			Delimiter = Space;
		end
	end

	text = KarmaFilterWindow_JoinedBefore_Editbox:GetText();
	if (text ~= "") then
		local	iValue = StrToDate(text);
		if (iValue) then
			NewTotal = NewTotal .. Delimiter .. "b-" .. iValue;
			Delimiter = Space;
		end
	end

	text = KarmaFilterWindow_NotePrivate_Editbox:GetText();
	if (text ~= "") then
		if (strfind(text, " ")) then
			text = "\"" .. text .. "\"";
		end
		NewTotal = NewTotal .. Delimiter .. "i-" .. text;
		Delimiter = Space;
	end

	text = KarmaFilterWindow_NotePublic_Editbox:GetText();
	if (text ~= "") then
		if (strfind(text, " ")) then
			text = "\"" .. text .. "\"";
		end
		NewTotal = NewTotal .. Delimiter .. "u-" .. text;
		Delimiter = Space;
	end

	text = KarmaFilterWindow_RegionVisitedWith_Editbox:GetText();
	if (text ~= "") then
		if (strfind(text, " ")) then
			text = "\"" .. text .. "\"";
		end
		NewTotal = NewTotal .. Delimiter .. "r-" .. text;
		Delimiter = Space;
	end

	KarmaWindow_Filter_EditBox:SetText(NewTotal);
end

function	KarmaModuleLocal.Command.VersionQuery(args)
	local	VerReq = args.VerReq;
	local	VerAudience = args.VerAudience;
	local	Skipped = true;
	KarmaChatDebug("Version request pending for <" .. VerAudience .. "> - checking...");
	if (KarmaModuleLocal.Version.Seen[VerAudience]) then
		if (KarmaModuleLocal.Version.Seen[VerAudience].Newer == 0) then	-- if someone announced newer, don't shout about being a lazy non-updater...
			if (KarmaModuleLocal.Version.Seen[VerAudience].Same == 0) or	-- either noone said anything yet?
			   (KarmaModuleLocal.Version.Seen[VerAudience].Older > 0) then	-- or they were all older versions: tell them
				KarmaChatDebug("Version requested, as noone said anything about a newer version in <" .. VerAudience .. ">");
				KarmaModuleLocal.Version.Seen[VerAudience].Same  = 0;
				KarmaModuleLocal.Version.Seen[VerAudience].Older = 0;
				SendAddonMessage("KARMA", VerReq, VerAudience);
				Skipped = false;
			else
				SkipReason = "Seen same: " .. KarmaModuleLocal.Version.Seen[VerAudience].Same .. " or no older: " .. KarmaModuleLocal.Version.Seen[VerAudience].Older;
			end
		else
			SkipReason = "Seen newer: " .. KarmaModuleLocal.Version.Seen[VerAudience].Newer;
		end
	else
		KarmaChatDebug("Unexpected audience: " .. VerAudience);
	end
	if (Skipped) then
		KarmaChatDebug("Version request for <" .. VerAudience .. "> skipped.");
	end
end

function	KarmaModuleLocal.Command.VersionQueryQueue(_VerReq, _VerAudience)
	local	oEntry = {};
	oEntry.At = GetTime() + 20 + random(10);
	oEntry.CmdList = {};
	oEntry.CmdList[1] = { sName = "VersionQuery", func = KarmaModuleLocal.Command.VersionQuery, args = { VerReq = _VerReq, VerAudience = _VerAudience } };

	Karma_CronQueue[#Karma_CronQueue + 1] = oEntry;
end

--
--
--
function	KarmaModuleLocal.Command.ChannelTest(args)
	if (args.sChan) then
		local	iChan = GetChannelName(args.sChan);
		if (iChan ~= 0) then
			local	oChanKarma = KarmaModuleLocal.Channels[0];
			if ((type(oChanKarma) ~= "table") or
			    (type(oChanKarma) == "table") and (oChanKarma.Number == nil)) then
				KarmaChatSecondaryFallbackDefault("Sending test message to channel " .. iChan .. ": #" .. args.sChan);
				SendChatMessage("Test!", "CHANNEL", nil, iChan);
			else
				KarmaChatSecondaryFallbackDefault("Channel #" .. args.sChan .. " already validated or rejected, not testing.");
			end
		else
			KarmaChatSecondaryFallbackDefault("Channel #" .. args.sChan .. " not yet joined. Can't test.");
		end
	end
end

function	KarmaModuleLocal.Command.ChannelAuto(args)
	local	sChan = KCfg.Get("SHARE_CHANNEL_NAME");
	if ((sChan ~= nil) and (sChan ~= "")) then
		local	oChannels = { GetChannelList() };
		local	k, v, bFound;
		bFound = false;
		for k, v in pairs(oChannels) do
			if ((type(v) == "string") and (sChan == v)) then
				bFound = true;
			end
		end

		if (not bFound) then
			KarmaChatSecondary("Auto-joining " .. sChan .. "...");
			JoinChannelByName(sChan, nil, DEFAULT_CHAT_FRAME:GetID());
		end

		local	i;
		for i = 1, NUM_CHAT_WINDOWS do
			RemoveChatWindowChannel(i, sChan);
		end

		local	oEntry = {};
		oEntry.At = GetTime() + 240 + random(120);
		oEntry.CmdList = {};
		oEntry.CmdList[1] = { sName = "ChannelTest", func = KarmaModuleLocal.Command.ChannelTest, args = { sChan = sChan} };

		Karma_CronQueue[#Karma_CronQueue + 1] = oEntry;
	end
end

function	KarmaModuleLocal.Command.ChannelAutoQueue()
	local	oEntry = {};
	oEntry.At = GetTime() + 20 + random(10);
	oEntry.CmdList = {};
	oEntry.CmdList[1] = { sName = "ChannelAutoJoinHide", func = KarmaModuleLocal.Command.ChannelAuto, args = {} };

	Karma_CronQueue[#Karma_CronQueue + 1] = oEntry;
end

--
--
--
function	KarmaModuleLocal.Command.xFactionRemindUpdate(args)
	KarmaChatDefault("There is cross-faction information for " .. args.iCount .. " players stored into " .. KARMA_ITSELF .. "'s hold. Transfer it into the main database with '" .. KARMA_CMDSELF .. " xupdate'!");
end

function	KarmaModuleLocal.Command.xFactionRemindUpdateQueue(_iCount)
	local	oEntry = {};
	oEntry.At = GetTime() + 30 + random(30);
	oEntry.CmdList = {};
	oEntry.CmdList[1] = { sName = "xFactionRemindUpdate", func = KarmaModuleLocal.Command.xFactionRemindUpdate, args = { iCount = _iCount} };

	Karma_CronQueue[#Karma_CronQueue + 1] = oEntry;
end

---
---- ChatMsg_AddOn: invisible inter-AddOn-communication
---
function	Karma_ChatMsg_AddOn(self, event, ...)
	local	arg1, arg2, arg3, arg4 = ...;
	Karma_WhoAmIInit();

	local	Msg = "ChatMsg_AddOn(" .. arg1 .. "): <" .. arg2 .. "> via " .. arg3;
	if (arg4 ~= nil) then
		Msg = Msg .. " from " .. arg4;
	end
	if (arg1 == "KARMA") and (arg4 == WhoAmI) then
		if (KarmaObj.UI.MsgAddOnForceHandling) then
			KarmaChatDebug(Msg .. " (from self, forced handling)");
		else
			KarmaChatDebug(Msg .. " (from self, no handling)");
		end
	end

	if (arg1 == "KARMA") and ((arg4 ~= WhoAmI) or KarmaObj.UI.MsgAddOnForceHandling) and
		((arg3 == "PARTY") or (arg3 == "WHISPER") or (arg3 == "GUILD") or (arg3 == "CHANNEL")) then

		if (KarmaObj.UI.MsgAddOnForceHandling) then
			KarmaObj.UI.MsgAddOnForceHandling = KarmaObj.UI.MsgAddOnForceHandling - 1;
			if (KarmaObj.UI.MsgAddOnForceHandling == 0) then
				KarmaObj.UI.MsgAddOnForceHandling = nil;
			end
		end

		KarmaChatDebug(Msg);

		if (KARMA_OtherInfos[arg4] == nil) then
			KARMA_OtherInfos[arg4] = {};
		end

		if (arg2) and (arg2 ~= "") then
			-- request?
			if (strsub(arg2, 1, 1) == "?") then
				-- version request
				if (strsub(arg2, 2) == "v") then
					SendAddonMessage("KARMA", "!v" .. KARMA_VERSION_TEXT, arg3, arg4);
				elseif (strsub(arg2, 2) == "v1") then
					SendAddonMessage("KARMA", "!v1:" .. KARMA_VERSION_TEXT .. ":" .. KARMA_VERSION_DATE, arg3, arg4);
				end

				-- player info request
				if (strsub(arg2, 2, 4) == "p1:") then
					local	sName = strsub(arg2, 5);
					local	oMember = Karma_MemberList_GetObject(sName);
					if (oMember) then
						-- Sharing: 0: never, 1: always, 2: via GUILD, 3: with trusted people only
						local	iKarma = KCfg.Get("SHARE_ONREQ_KARMA");
						local	iPubNote = KCfg.Get("SHARE_ONREQ_PUBLICNOTE");
						local	bTrustKarma, bTrustNote = false, false
						if (iKarma == 3) or (iPubNote == 3) then
							oRequester = Karma_MemberList_GetObject(arg4);
							if (oRequester and (oRequester[KARMA_DB_L5_RRFFM_SHARE_TRUST] ~= nil)) then
								local	iTrust = oRequester[KARMA_DB_L5_RRFFM_SHARE_TRUST];
								if (1 == bit.band(iTrust, 1)) then
									bTrustKarma = true;
								end
								if (2 == bit.band(iTrust, 2)) then
									bTrustNote = true;
								end
							end
						end

						local	sReply = "";

						if ((iKarma == 1) or
						    ((iKarma == 2) and (arg3 == "GUILD")) or
						    ((iKarma == 3) and bTrustKarma)) then
							sReply = sReply .. ":k" .. KarmaObj.DB.M.KarmaGet(oMember);
						end

						if ((iPubNote == 1) or
						    ((iPubNote == 2) and (arg3 == "GUILD")) or
						    ((iPubNote == 3) and bTrustNote)) then
							local	sNote  = Karma_MemberObject_GetPublicNotes(oMember); 
							if (sNote and (sNote ~= "")) then
								if ((strsub(sNote, 1, 1) == "#") or strfind(sNote, ":")) then
									sNote = string.gsub(sNote, "#", "##");
									sNote = string.gsub(sNote, "!", "#!");
									sNote = string.gsub(sNote, ":", "#!#!");
									sNote = "#" .. sNote;
								end
								sReply = sReply .. ":np" .. sNote;
							end
						end

						-- *always* reply in WHISPER!
						if (sReply ~= "") then
							SendAddonMessage("KARMA", "!p1:" .. sName .. sReply, "WHISPER", arg4);
						end
					end
				end

				-- data exchange request
				if ((strsub(arg2, 2, 4) == "x1:") or (strsub(arg2, 2, 4) == "x2:")) then
					KarmaObj.Share.AddOnMessageXRequest(arg2, arg3, arg4);
				end
			end

			-- reply?
			if (strsub(arg2, 1, 1) == "!") then
				if (strsub(arg2, 2, 2) == "v") then
					local	iPos;
					local	vermajmin, vermaj, vermin, verdat;
	
					-- version reply: v1
					if (strsub(arg2, 2, 4) == "v1:") then
						-- compare...
						KarmaChatDebug("Version reply v1: <" .. strsub(arg2, 5) .. "> from " .. arg4);
						if (KARMA_OtherInfos[arg4].ver == nil) then
							KARMA_OtherInfos[arg4].ver = strsub(arg2, 5);
							iPos = strfind(KARMA_OtherInfos[arg4].ver, ":", 1, true);
							if (iPos) then
								vermajmin = strsub(KARMA_OtherInfos[arg4].ver, 1, iPos - 1);
								verdat = strsub(KARMA_OtherInfos[arg4].ver, iPos + 1);
							else
								vermajmin = KARMA_OtherInfos[arg4].ver;
							end
						end
					-- version reply (old)
					elseif (strsub(arg2, 4, 4) ~= ":") then
						-- compare...
						KarmaChatDebug("Version reply v0: <" .. strsub(arg2, 3) .. "> from " .. arg4);
						if (KARMA_OtherInfos[arg4].ver == nil) then
							KARMA_OtherInfos[arg4].ver = strsub(arg2, 3);
							vermajmin = KARMA_OtherInfos[arg4].ver;
						end
					end
	
					if (vermajmin) then
						iPos = strfind(vermajmin, ".", 1, true);
						if (iPos) then
							vermaj = tonumber(strsub(vermajmin, 1, iPos - 1), 16);
							vermin = tonumber(strsub(vermajmin, iPos + 1), 16);
						else
							vermaj = vermajmin;
						end
	
						local	mymajmin, mymaj, mymin, mydat;
						mymajmin = KARMA_VERSION_TEXT;
						iPos = strfind(mymajmin, ".", 1, true);
						if (iPos) then
							mymaj = tonumber(strsub(mymajmin, 1, iPos - 1), 16);
							mymin = tonumber(strsub(mymajmin, iPos + 1), 16);
						end

						local	Msg;
						if (vermajmin) and (mymajmin) and (vermajmin ~= mymajmin) then
							if (vermin) and (mymin) then
								if (vermaj > mymaj) or ((vermaj == mymaj) and (vermin > mymin)) then
									Msg = KARMA_MSG_VERSION_NEW1 .. vermajmin;
								end
							elseif (vermajmin > mymajmin) then
								Msg = KARMA_MSG_VERSION_NEW1 .. vermajmin;
							end
						end

						local	VersionSeen = KarmaModuleLocal.Version.Seen[arg3];
						if (type(VersionSeen) == "table") then
							if (vermajmin == mymajmin) then
								VersionSeen.Same = VersionSeen.Same + 1;
							else
								if (vermin) and (mymin) then
									if (vermaj > mymaj) or ((vermaj == mymaj) and (vermin > mymin)) then
										VersionSeen.Newer = VersionSeen.Newer + 1;
									else
										VersionSeen.Older = VersionSeen.Older + 1;
									end
								elseif (vermajmin > mymajmin) then
									VersionSeen.Newer = VersionSeen.Newer + 1;
								else
									VersionSeen.Older = VersionSeen.Older + 1;
								end
							end
						end

KarmaChatDebug("Version from " .. arg4 .. KARMA_WINEL_FRAG_COLONSPACE .. vermajmin .. "(" .. Karma_NilToString(verdat) .. ")");

						if (Msg) then
							if (KARMA_VERSION_TEXT_NEWEST ~= nil) then
								if (vermajmin == KARMA_VERSION_TEXT_NEWEST) then
									-- if same: skip
									Msg = nil;
								else
									local	newmajmin, newmaj, newmin;
									local	newmajmin = KARMA_VERSION_TEXT_NEWEST;
									iPos = strfind(newmajmin, ".", 1, true);
									if (iPos) then
										newmaj = tonumber(strsub(newmajmin, 1, iPos - 1), 16);
										newmin = tonumber(strsub(newmajmin, iPos + 1), 16);
									end

KarmaChatDebug("MostRecent-Seen: " .. Karma_NilToString(newmaj) .. "~" .. Karma_NilToString(newmin)
						.. " vs. " .. Karma_NilToString(vermaj) .. "~" .. Karma_NilToString(vermin));

									-- if newer: assign & display; if older: ignore
									if (vermin) and (newmin) then
										if (vermaj > newmaj) or ((vermaj == newmaj) and (vermin > newmin)) then
											KARMA_VERSION_TEXT_NEWEST = vermajmin;
											KARMA_VERSION_DATE_NEWEST = verdat;
										else
											Msg = nil;
										end
									else
										if (vermajmin > mymajmin) then
											KARMA_VERSION_TEXT_NEWEST = vermajmin;
											KARMA_VERSION_DATE_NEWEST = verdat;
										else
											Msg = nil;
										end
									end
								end
							else
								KARMA_VERSION_TEXT_NEWEST = vermajmin;
								KARMA_VERSION_DATE_NEWEST = verdat;
							end
						end

						if (Msg) then
							if (verdat) and (strfind(verdat, "?", 1, true) == nil) then
								Msg = Msg .. KARMA_MSG_VERSION_NEW2 .. verdat .. KARMA_MSG_VERSION_NEW3;
							end
							KarmaChatDefault(Msg);
						end
					end
				end

				-- player info reply
				if (strsub(arg2, 2, 4) == "p1:") then
					local	iPos = strfind(arg2, ":", 5, true);
					if (iPos) then
						local	sName = strsub(arg2, 5, iPos - 1);
						local	sInfo = strsub(arg2, iPos + 1);
						local	bSpam = true;
						do
							local	oMember = Karma_MemberList_GetObject(sName);
							if (oMember) then
								bSpam = false;
							end
						end
						if (bSpam) then
							KarmaChatDebug("Infos from " .. arg4 .. " about " .. sName .. " = <" .. sInfo .. ">: No object, will spam.");
						else
							KarmaChatDebug("Infos from " .. arg4 .. " about " .. sName .. " = <" .. sInfo .. ">: Have object, no spamming.");
						end
						if (KarmaModuleLocal.NotesPublic.Results[sName] == nil) then
							KarmaModuleLocal.NotesPublic.Results[sName] = {};
						end
						if (KarmaModuleLocal.NotesPublic.Results[sName][arg4] == nil) then
							KarmaModuleLocal.NotesPublic.Results[sName][arg4] = {};
						end

						local	oContainer = KarmaModuleLocal.NotesPublic.Results[sName][arg4];
						while (sInfo ~= "") do
							iPos = strfind(sInfo, ":", 1, true);
							if (strsub(sInfo, 1, 1) == "k") then
								local	sKarma, iKarma;
								if (iPos) then
									sKarma = strsub(sInfo, 2, iPos - 1);
								else
									sKarma = strsub(sInfo, 2);
								end
								iKarma = tonumber(sKarma);
								if (iKarma and (iKarma > 0)) then
									if (iKarma > 90) then
										sKarma = "a lot of positive Karma";
									elseif (iKarma > 70) then
										sKarma = "much positive Karma";
									elseif (iKarma > 60) then
										sKarma = "some positive Karma";
									elseif (iKarma > 50) then
										sKarma = "positive Karma";
									elseif (iKarma < 10) then
										sKarma = "a lot of negative Karma";
									elseif (iKarma < 30) then
										sKarma = "much negative Karma";
									elseif (iKarma < 40) then
										sKarma = "some negative Karma";
									elseif (iKarma < 50) then
										sKarma = "negative Karma";
									else	-- 50.
										sKarma = "unmodified Karma";
									end

									oContainer.sKarma = sKarma;
									if (bSpam) then
										KarmaChatSecondary(arg4 .. " has assigned " .. sKarma .. " to " .. sName .. ".");
									end
								else
									KarmaChatDebug("Invalid Karma value in reply from " .. arg4 .. ": <" .. sKarma .. ">");
								end
							elseif (strsub(sInfo, 1, 2) == "np") then
								local	sNote;
								if (iPos) then
									sNote = strsub(sInfo, 3, iPos - 1);
								else
									sNote = strsub(sInfo, 3);
								end

								if (strsub(sNote, 1, 1) == "#") then
									sNote = strsub(sNote, 2);
									sNote = string.gsub(sNote, "#!#!", ":");
									sNote = string.gsub(sNote, "#!", "!");
									sNote = string.gsub(sNote, "##", "#");
								end

								oContainer.sNotePub = sNote;
								if (bSpam) then
									KarmaChatSecondary(arg4 .. " has added a public note to " .. sName .. ": " .. sNote);
								end
							end

							if (iPos) then
								sInfo = strsub(sInfo, iPos + 1);
							else
								sInfo = "";
							end
						end
					end
				end

				-- data exchange reply
				if (strsub(arg2, 2, 2) == "x") then
					KarmaObj.Share.AddOnMessageXReply(arg2, arg3, arg4);
				end
			end
		end
	end
end


function	Karma_ChatMsg_System(self, event, ...)
	local	arg1 = ...;
	if (KCfg.Get("MARKUP_VERSION") >= 2) then
		-- undocumented(?) who-reply: arg1 comes as: "|Hplayer:ABCDE[ABCDE]"
		if (strsub(arg1, 1, 9) == "|Hplayer:") then
			local sMemberName = strsub(arg1, 10);
			local openingbracket = strfind(sMemberName, "[", 1, true);
			if (openingbracket) then
				sMemberName = strsub(sMemberName, openingbracket + 1);
				local closingbracket = strfind(sMemberName, "]", 1, true);
				if (closingbracket) then
					sMemberName = strsub(sMemberName, 1, closingbracket - 1);
					KarmaChatDebug("Potential /who <" .. sMemberName .. "> spotted!");
					WhoUpdateShowKarmaAndNote();
				end
			end
		end
	end
end

--
---
--
function	Karma_ChatMsg_Channel(self, event, ...)
	local	arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9 = ...;
	if (arg8 and arg9) then
		if (KarmaModuleLocal.Channels[arg8] == nil) then
			KarmaModuleLocal.Channels[arg8] = {};
			local	oChan = KarmaModuleLocal.Channels[arg8];
			oChan.NameUser  = arg4;
			oChan.NameShort = strlower(arg9);
			oChan.BlizzChan = arg7 or 0;
			oChan.Number    = arg8;
		end

		local	oChanKarma = KarmaModuleLocal.Channels[0];
		if (oChanKarma == nil) then
			KarmaModuleLocal.Channels[0] = {};
			oChanKarma = KarmaModuleLocal.Channels[0];
			oChanKarma.NameUser  = "<internal>";
			oChanKarma.NameShort = "<internal>";
			oChanKarma.BlizzChan = 0;
			oChanKarma.Number    = nil;
		end

		if (oChanKarma.Number == nil) then
			local	sChanKarma = KCfg.Get("SHARE_CHANNEL_NAME");
			if (sChanKarma) then
				local	sChanKarmaLower = strlower(sChanKarma);
				local	oChan = KarmaModuleLocal.Channels[arg8];
				if (sChanKarmaLower == oChan.NameShort) then
					if (oChan.BlizzChan ~= 0) then
						KarmaChatDefault("INVALID communication channel <#" .. arg4 .. "> (Blizzard channel)");
						oChanKarma.Number = -1;
					else
						KarmaChatDefault("Found communication channel <#" .. arg4 .. ">");
						oChanKarma.Number = arg8;
					end
				end
			else
				oChanKarma.Number = -1;
			end
		end

		if (oChanKarma.Number) then
			if (arg8 == oChanKarma.Number) then
				-- Karma channel.
				KarmaChatDebug("Comm{" .. arg8 .. ": " .. arg2 .. "} => " .. arg1);
				if (strsub(arg1, 1, 2) == "\194\167") then	--  = 194,167
					if (strsub(arg1, 3, 8) == "KARMA:") then
						if (strsub(arg1, 9, 12) == "?p1:") then
							local	sEncReq = strsub(arg1, 13);
							if (strlen(sEncReq) % 4 == 0) then
								local	sDecReq = "";
								local	cClass;
								while (sEncReq ~= "") do
									cClass = strsub(sEncReq, 1, 1);
									local	iMulti;
									if (cClass == "+") then
										iMulti = 17;
									elseif (cClass == "-") then
										iMulti = 19;
									elseif (cClass == "!") then
										iMulti = 23;
									elseif (cClass == "?") then
										iMulti = 29;
									elseif (cClass == "=") then
										iMulti = 31;
									end

									if (iMulti) then
										local	iVal = tonumber(strsub(sEncReq, 2, 4));
										if (iVal and iVal ~= 0) then
											sDecReq = sDecReq .. string.char((iVal * iMulti) % 257);
										else
											KarmaChatDebug("Ieks: " .. strsub(sEncReq, 2, 4) .. " - inconvertible?");
											sEncReq = "";
											sDecRec = "";
										end
									else
										KarmaChatDebug("Ieks: " .. cClass .. " - invalid class?");
										sEncReq = "";
										sDecRec = "";
									end
									if (sEncReq ~="") then
										sEncReq = strsub(sEncReq, 5);
									end
								end

								if (sDecReq ~= "") then
									KarmaChatDebug("Decoded: " .. sDecReq);

									-- reply: lazy reuse...
									Karma_ChatMsg_AddOn(self, event, "KARMA", "?p1:" .. sDecReq, "CHANNEL", arg2);
								else
									KarmaChatDebug("Failed to decode: " .. strsub(arg1, 13));
								end
							else
								KarmaChatDebug("Malformed request:" .. strsub(arg1, 9, 12) .. " - not a name following.");
							end
						else
							KarmaChatDebug("Unknown request:" .. strsub(arg1, 9, 12));
						end
					else
						-- KarmaChatDebug("Not a Karma message, missing KARMA: string.");
					end
				else
					-- KarmaChatDebug("Not an AddOn message, missing paragraph sign.");
				end
			end
		end
	else
		KarmaChatDebug("--== channels information ==-- ");
		for k, v in pairs(KarmaModuleLocal.Channels) do
			KarmaChatDebug("-- [" .. k .. "] " .. v.NameUser .. ": {" .. v.BlizzChan .. "} " .. v.NameShort);
		end
		KarmaChatDebug("--== -------------------- ==-- ");
	end
end

-----------------------------------------
-- TALENT WINDOW
-----------------------------------------

Karma_TalentWindow_Membername = nil;

Karma_TalentWindow_MemberResult = nil;

function	Karma_TalentInit(oWnd)
	local	oMember = Karma_MemberList_GetObject(KARMA_CURRENTMEMBER);
	if (oMember == nil) then
		self:Hide();
	end

	local	iSpec = oWnd.iSpec;

	Karma_TalentWindow_Membername = KARMA_CURRENTMEMBER;
	KarmaTalentWindow_Player_Name:SetText(Karma_TalentWindow_Membername);

	local	sTalentTitle = KARMA_WINEL_TALENTWND_TALENT_TITLE;
	if (iSpec) then
		sTalentTitle = sTalentTitle .. KARMA_WINEL_FRAG_SPACE .. iSpec;
	end
	sTalentTitle = sTalentTitle .. KARMA_WINEL_FRAG_COLON;
	KarmaTalentWindow_Talent_Title:SetText(sTalentTitle);
	local	oTree = oMember[KARMA_DB_L5_RRFFM_TALENTTREE];
	local	aTrees = KarmaObj.Talents.TreeObjToStringsObj(oTree, bShiftPressed);
	if (aTrees["S_" .. iSpec] ~= "") then
		KarmaTalentWindow_Talent_Value:SetText(aTrees["S_" .. iSpec]);
	else
		KarmaTalentWindow_Talent_Value:SetText("???");
	end

	local	classid = oMember[KARMA_DB_L5_RRFFM.CLASS_ID];
	if (classid == 0) then
		classid = KOH.ClassToID(Karma_MemberObject_GetClass(oMember));
	end
	if (classid < 0) then
		classid = - classid;
	end
	if (classid > 0) then
		local	talentmask = KarmaObj.Talents.ClassMask(classid);
		local	iBit, CheckBoxObj;
		for iBit = 1, KARMA_TALENTS_MAXBITPLUS1 do
			if (iBit == 1) then
				CheckBoxObj = KarmaTalentWindow_HPS_Checkbox;
			end
			if (iBit == 2) then
				CheckBoxObj = KarmaTalentWindow_Tank_Checkbox;
			end
			if (iBit == 3) then
				CheckBoxObj = KarmaTalentWindow_DPS_Checkbox;
			end
			if (iBit == 4) then
				CheckBoxObj = KarmaTalentWindow_Melee_Checkbox;
			end
			if (iBit == 5) then
				CheckBoxObj = KarmaTalentWindow_Ranged_Checkbox;
			end
			if ((talentmask % 2) == 1) then
				CheckBoxObj:Enable();
			else
				CheckBoxObj:Disable();
			end
			talentmask = math.floor(talentmask / 2);
		end

		Karma_TalentWindow_MemberResult = Karma_MemberObject_GetTalentIDRaw(oMember, iSpec);
		if (Karma_TalentWindow_MemberResult == 0) then
			Karma_TalentWindow_MemberResult = KarmaObj.Talents.ClassIDToTalentsDefault(classid);
		end
		local	TalentResult = Karma_TalentWindow_MemberResult;
		for iBit = 1, KARMA_TALENTS_MAXBITPLUS1 do
			if (iBit == 1) then
				CheckBoxObj = KarmaTalentWindow_HPS_Checkbox;
			end
			if (iBit == 2) then
				CheckBoxObj = KarmaTalentWindow_Tank_Checkbox;
			end
			if (iBit == 3) then
				CheckBoxObj = KarmaTalentWindow_DPS_Checkbox;
			end
			if (iBit == 4) then
				CheckBoxObj = KarmaTalentWindow_Melee_Checkbox;
			end
			if (iBit == 5) then
				CheckBoxObj = KarmaTalentWindow_Ranged_Checkbox;
			end
			CheckBoxObj:SetChecked(TalentResult % 2);

			TalentResult = math.floor(TalentResult / 2);
		end

		KarmaTalentWindow_Result_Editbox:SetText(KarmaObj.Talents.TalentIDToColorizedText(Karma_TalentWindow_MemberResult));
	end
end

function	Karma_TalentUpdate(clicked)
	-- HPS: => Ranged
	if (clicked == "H") then
		if (KarmaTalentWindow_HPS_Checkbox:GetChecked()) then
			KarmaTalentWindow_DPS_Checkbox:SetChecked(0);
			KarmaTalentWindow_Tank_Checkbox:SetChecked(0);
			KarmaTalentWindow_Melee_Checkbox:SetChecked(0);
			KarmaTalentWindow_Ranged_Checkbox:SetChecked(1);
		end
	end
	-- Tank: => Melee
	if (clicked == "T") then
		if (KarmaTalentWindow_Tank_Checkbox:GetChecked()) then
			KarmaTalentWindow_HPS_Checkbox:SetChecked(0);
			KarmaTalentWindow_Melee_Checkbox:SetChecked(1);
			KarmaTalentWindow_Ranged_Checkbox:SetChecked(0);
			if (KarmaObj.Const.iTOC >= 50000) then
				-- Pandaria brought the death of the Feral Tank/DPS duality
				KarmaTalentWindow_DPS_Checkbox:SetChecked(0);
			end
		end
	end
	-- DPS: => !HPS
	if (clicked == "D") then
		if (KarmaTalentWindow_DPS_Checkbox:GetChecked()) then
			if (KarmaObj.Const.iTOC >= 50000) then
				-- Pandaria brought the death of the Feral Tank/DPS duality
				KarmaTalentWindow_Tank_Checkbox:SetChecked(0);
			end
			KarmaTalentWindow_HPS_Checkbox:SetChecked(0);
			-- TODO: if class is not druid/shaman, M/R can also be set
		end
	end
	-- R: => !M
	if (clicked == "R") then
		if (KarmaTalentWindow_Ranged_Checkbox:GetChecked()) then
			KarmaTalentWindow_Tank_Checkbox:SetChecked(0);
			KarmaTalentWindow_Melee_Checkbox:SetChecked(0);
		end
	end
	-- M: => !R
	if (clicked == "M") then
		if (KarmaTalentWindow_Melee_Checkbox:GetChecked()) then
			KarmaTalentWindow_HPS_Checkbox:SetChecked(0);
			KarmaTalentWindow_Ranged_Checkbox:SetChecked(0);
		end
	end

	Karma_TalentWindow_MemberResult = 0;
	local	iBit;
	local	iBitValue = 1;
	for iBit = 1, KARMA_TALENTS_MAXBITPLUS1 do
		if (iBit == 1) then
			CheckBoxObj = KarmaTalentWindow_HPS_Checkbox;
		end
		if (iBit == 2) then
			CheckBoxObj = KarmaTalentWindow_Tank_Checkbox;
		end
		if (iBit == 3) then
			CheckBoxObj = KarmaTalentWindow_DPS_Checkbox;
		end
		if (iBit == 4) then
			CheckBoxObj = KarmaTalentWindow_Melee_Checkbox;
		end
		if (iBit == 5) then
			CheckBoxObj = KarmaTalentWindow_Ranged_Checkbox;
		end

		if (CheckBoxObj:GetChecked()) then
			Karma_TalentWindow_MemberResult = Karma_TalentWindow_MemberResult + iBitValue;
		end
		iBitValue = iBitValue * 2;
	end

	local	TitleObj = getglobal("KarmaTalentWindow_Result_Editbox");
	TitleObj:SetText(KarmaObj.Talents.TalentIDToColorizedText(Karma_TalentWindow_MemberResult));
end

function	Karma_TalentDone(ExitOk)
	KarmaTalentWindow:Hide();
	if (ExitOk) then
		local	oMember = Karma_MemberList_GetObject(Karma_TalentWindow_Membername);
		if (oMember) and (Karma_TalentWindow_MemberResult) then
			Karma_MemberObject_SetTalentID(oMember, KarmaTalentWindow.iSpec, Karma_TalentWindow_MemberResult); 
			KarmaWindow_Update();
		end
	end
end

function	KarmaWindow_OtherData_OnEnter(self, motion)
	local	oMember = Karma_MemberList_GetObject(KARMA_CURRENTMEMBER);
	if (oMember) then
		local	bHaveLines;
		GameTooltip:SetOwner(self, "ANCHOR_RIGHT");

		local	iSkill = Karma_MemberObject_GetSkill(oMember);
		if (iSkill >= 0) then
			local	sSkill = KARMA_SKILL_LEVELS[iSkill];
			if (sSkill) then
				local	sModel = KCfg.Get("SKILL_MODEL");
				if (sModel == "complex") then
					sSkill = KARMA_WINEL_CHOSENPLAYERSKILLTITLE .. KARMA_WINEL_FRAG_SPACE .. tostring(iSkill) .. KARMA_WINEL_FRAG_COLONSPACE .. sSkill;
				else
					sSkill = KARMA_WINEL_CHOSENPLAYERSKILLTITLE .. KARMA_WINEL_FRAG_SPACE .. sSkill;
				end

				bHaveLines = true;
				GameTooltip:AddLine(sSkill, 1, 1, 1);
			end
		end

		local	iGear, sGear;
		iGear = Karma_MemberObject_GetGearPVE(oMember);
		if (iGear >= 0) then
			sGear = KARMA_GEAR_PVE_LEVELS[iGear];
			if (sGear) then
				bHaveLines = true;
				sGear = KARMA_WINEL_CHOSENPLAYERGEARPVETITLE .. KARMA_WINEL_FRAG_COLONSPACE .. sGear;
				GameTooltip:AddLine(sGear, 1, 1, 1);
			end
		end
		iGear = Karma_MemberObject_GetGearPVP(oMember);
		if (iGear >= 0) then
			sGear = KARMA_GEAR_PVP_LEVELS[iGear];
			if (sGear) then
				bHaveLines = true;
				sGear = KARMA_WINEL_CHOSENPLAYERGEARPVPTITLE .. KARMA_WINEL_FRAG_COLONSPACE .. sGear;
				GameTooltip:AddLine(sGear, 1, 1, 1);
			end
		end

		if (bHaveLines) then
			GameTooltip:Show();
		end
	end
end

---
----
---

function	Karma_CommandShareQuery(args)
	local	sAudience = args[2];
	local	sName = args[3];
	if (KSlash.ShareQuery(args, 3, true)) then
		if (KARMA_OtherInfos[sName]) then
			if (sAudience == "$GUILD") then
				KARMA_OtherInfos[sName].Queried = bit.bor(KARMA_OtherInfos[sName].Queried, 1);
			end
			if (sAudience == "#") then
				KARMA_OtherInfos[sName].Queried = bit.bor(KARMA_OtherInfos[sName].Queried, 2);
			end
		end
	elseif (KARMA_PartyNames[sName]) then
		Karma_QueueCommandShareQuery(sName);
	end

	-- delay next command by 5 seconds (we don't want other people to kill themselves by sending us notes!!)
	KarmaModuleLocal.Timers.CmdQ = GetTime() + 5;
end

function	Karma_QueueCommandShareQuery(sPlayername)
	if (IsInGuild() and (GetNumGuildMembers() > 1)) then
		local	oCmd = { sName = "sharequery - $GUILD - " .. sPlayername, func = Karma_CommandShareQuery, args = { [ 2 ] = "$GUILD", [ 3 ] = sPlayername } };
		KarmaObj.Slash.CommandQAddPrio( { [1] = oCmd } );
	end

	local	sChannel = KCfg.Get("SHARE_CHANNEL_NAME");
	if ((type(sChannel) == "string") and (sChannel ~= "") and
	    ((GetChannelName(sChannel) ~= 0) or KCfg.Get("SHARE_CHANNEL_AUTO"))) then
		local	oCmd = { sName = "sharequery - # - " .. sPlayername, func = Karma_CommandShareQuery, args = { [ 2 ] = "#", [ 3 ] = sPlayername } };
		KarmaObj.Slash.CommandQAddPrio( { [1] = oCmd } );
	end
end

---
----
---

local	function	Karma_MemberConflict_Menu_OnSelect(self, arg1, arg2)
	KarmaObj.ProfileStart("Karma_MemberConflict_Menu_OnSelect")

	local	oMember = Karma_MemberList_GetObject(arg2);
	if (oMember ~= nil) and (arg1 ~= nil) then
		if (arg1 == 1) then
			local	args = {};
			args[2] = arg2;
			Karma_MemberForceUpdate(args);
		elseif (arg1 == 2) then
			local	args = {};
			args[2] = arg2;
			Karma_MemberForceNew(args);
		elseif (arg1 == 3) then
			Karma_SetCurrentMember(arg2);
			KarmaWindow_ScrollToCurrentMember();
			if (not KarmaWindow:IsVisible()) then
				KarmaWindow:Show();
			else
				KarmaWindow:Raise();
			end
		end
	end

	KarmaObj.ProfileStop("Karma_MemberConflict_Menu_OnSelect")
end

function	Karma_MemberConflict_Menu_Initialize()
	KarmaObj.ProfileStart("Karma_MemberConflict_Menu_Initialize")

	local	oMember;
	if (Karma_MemberConflict_Menu.Member ~= nil) then
		oMember = Karma_MemberList_GetObject(Karma_MemberConflict_Menu.Member);
	end

	if (oMember) then
		local	sConflict = nil;
		if	(oMember[KARMA_DB_L5_RRFFM_CONFLICT] ~= nil) and
			(oMember[KARMA_DB_L5_RRFFM_CONFLICT].Resolved == 0) then
			sConflict = oMember[KARMA_DB_L5_RRFFM_CONFLICT].Conflict;
		end

		KarmaChatDebug("MC_M_I: Caller = " .. tostring(Karma_MemberConflict_Menu.Caller));

		local	bLFMList = 	("KarmaWindow2_List1_Name" == strsub(Karma_MemberConflict_Menu.Caller, 1, 23)) or
					("KarmaWindow2_List2_Name" == strsub(Karma_MemberConflict_Menu.Caller, 1, 23));
		if (bLFMList or sConflict) then
			local	info;
			info = {};
			info.text = Karma_MemberConflict_Menu.Member .. ": " .. (sConflict or "");
			info.isTitle = 1;
			info.notCheckable = 1;
			UIDropDownMenu_AddButton(info);

			-- this gets secretly crapped by UIDropDownMenu.lua
			info.disabled = nil;

			-- remove title fields, prepare entry fields
			info.isTitle = nil;
			info.arg2 = Karma_MemberConflict_Menu.Member;
			info.func = Karma_MemberConflict_Menu_OnSelect;

			if (sConflict) then
				info.text = "FORCE update of stored data to logged on player";
				info.arg1 = 1;
				UIDropDownMenu_AddButton(info);

				info.text = "Backup currently stored data and create a new entry";
				info.arg1 = 2;
				UIDropDownMenu_AddButton(info);
			end

			if (bLFMList) then
				info.text = "Select player in " .. KARMA_ITSELF .. "'s main window";
				info.arg1 = 3;
				UIDropDownMenu_AddButton(info);
			end
		end
	end

	Karma_MemberConflict_Menu.Member = nil;

	KarmaObj.ProfileStop("Karma_MemberConflict_Menu_Initialize")
end

