
KarmaAvEnKHistory = { Alliance = {}, Horde = {} };

local	KarmaObj = KarmaAvEnK;
KarmaObj.History = {};
local	KOH = KarmaObj.Helpers;
local	HistoryObj = KarmaObj.History;

local	KARMA_DB_L4_RRFF = {
			MEMBERBUCKETS = "MEMBERBUCKETS",

			HISTORY_MOVED = "HIST_MOVED",
			HISTORY_SEEN = "HIST_SEEN",
		};

local	KARMA_DB_L5_RRFFM = {
			LASTSEEN = "LASTSEEN",
		};

local		KARMA_DB_L5_RRFFM_TIMESTAMP = "TIMESTAMP";
local		KARMA_DB_L5_RRFFM_TIMESTAMP_SUCCESS = "SUCCESS";

local		KARMA_DB_L5_RRFFM_JOINEDLAST_TIME = "JOINEDLAST";

function	HistoryObj.Update(sRealmOnly, bServerValid)
	local	oRealms, iIxR, sRealm = KarmaObj.DB.ServerListGet(true);
	if (type(sRealmOnly) == "string") then
		if (not bServerValid and not KarmaObj.DB.ServerExists(sRealmOnly)) then
			KarmaChatDefault("Server <" .. sRealmOnly .. "> does not have any data stored yet.");
			return
		end

		oRealms = { sRealmOnly };
	end

	for iIxR, sRealm in pairs(oRealms) do
		local	sFaction = UnitFactionGroup("player");
		KOH.TableInit(KarmaAvEnKHistory[sFaction], sRealm);
		local	oHistory = KarmaAvEnKHistory[sFaction][sRealm];

		local	oRealm = KarmaObj.DB.FactionServerGet(sRealm);
		local	oBuckets = oRealm[KARMA_DB_L4_RRFF.MEMBERBUCKETS];

		KarmaChatSecondaryFallbackDefault("Checking server " .. sRealm .. "...");


		-- check for stuff to move back
		KOH.TableInit(oRealm, KARMA_DB_L4_RRFF.HISTORY_SEEN);
		local	oSeen = oRealm[KARMA_DB_L4_RRFF.HISTORY_SEEN];

		local	iCntMerged = 0;
		local	iCntMoved = 0;

		local	sMember, iWhen;
		for sMember, iWhen in pairs(oSeen) do
			if (type(oHistory[sMember]) == "table") then
				local	sBucket = KarmaObj.NameToBucket(sMember);
				local	oMember = oBuckets[sBucket][sMember];
				if (oMember) then
					iCntMerged = iCntMerged + 1;
					KarmaObj.DB.MergeChar(oMember, oHistory[sMember])
				else
					iCntMoved = iCntMoved + 1;
					oBuckets[sBucket][sMember] = oHistory[sMember];
				end

				oBuckets[sBucket][sMember][KARMA_DB_L5_RRFFM.LASTSEEN] = iWhen;

				oHistory[sMember] = nil;
			end
		end

		table.wipe(oSeen);

		-- TEMP
		local	oMove, sMember, oMember = {};
		for sMember, oMember in pairs(oHistory) do
			local	iAltID = Karma_MemberObject_GetAltID(oMember) or -1;
			if (strfind(sMember, ":", 1, true) or (iAltID ~= -1)) then
				tinsert(oMove, sMember);
			end
		end
		local	iIx, sMember;
		for iIx, sMember in pairs(oMove) do
			local	sBucket = KarmaObj.NameToBucket(sMember);
			oBuckets[sBucket][sMember] = oHistory[sMember];
			oHistory[sMember] = nil;
			iCntMoved = iCntMoved + 1;
		end
		-- TEMP

		if (iCntMerged + iCntMoved > 0) then
			KarmaChatSecondaryFallbackDefault("Server " .. sRealm .. ": Restored " .. (iCntMerged + iCntMoved) .. " entries (merged " .. iCntMerged .. ", moved " .. iCntMoved .. ")");
		end


		-- move out old data
		local	iCntMoved = 0;

		local	iNow, sBucket, oBucket = time();
		for sBucket, oBucket in pairs(oBuckets) do
			local	oMove, sMember, oMember = {};
			for sMember, oMember in pairs(oBucket) do
				if (not strfind(sMember, ":", 1, true)) then
					local	sNotes = Karma_MemberObject_GetNotes(oMember) or "";
					local	iAltID = Karma_MemberObject_GetAltID(oMember) or -1;
					if ((sNotes == "") and (iAltID == -1)) then
						local	iTime = 0;
						local	oField = oMember[KARMA_DB_L5_RRFFM_TIMESTAMP];
						if (oField and oField[KARMA_DB_L5_RRFFM_TIMESTAMP_SUCCESS]) then
							iTime = math.max(iTime, oField[KARMA_DB_L5_RRFFM_TIMESTAMP_SUCCESS]);
						end
						local	oField = oMember[KARMA_DB_L5_RRFFM.LASTSEEN];
						if (oField) then
							iTime = math.max(iTime, oField);
						end
						local	oField = oMember[KARMA_DB_L5_RRFFM_JOINEDLAST_TIME];
						if (oField) then
							iTime = math.max(iTime, oField);
						end

						if (iNow - iTime > 86400 * 365.25) then
							tinsert(oMove, sMember);
						end
					end
				end
			end

			local	iIx;
			for iIx, sMember in pairs(oMove) do
				oHistory[sMember] = oBucket[sMember];
				oBucket[sMember] = nil;
			end

			iCntMoved = iCntMoved + #oMove;
		end

		if (iCntMoved > 0) then
			KarmaChatSecondaryFallbackDefault("Server " .. sRealm .. ": Moved " .. iCntMoved .. " entries out into historic database.");
		end


		-- update the moved list
		local	oMoved, sMember, oMember = {};
		for sMember, oMember in pairs(oHistory) do
			oMoved[sMember] = oRealm[KARMA_DB_L4_RRFF.HISTORY_MOVED][sMember] or iNow;
		end

		oRealm[KARMA_DB_L4_RRFF.HISTORY_MOVED] = oMoved;
	end
end

