
-- localization.final.lua: complete localization

if (KARMAAVENK_LANG_LOC.PREF == "EN") then
	KARMAAVENK_LANG = KARMAAVENK_LANG_LOC[KARMAAVENK_LANG_LOC.PREF];
else
	-- define language to use
	KARMAAVENK_LANG = KARMAAVENK_LANG_LOC[KARMAAVENK_LANG_LOC.PREF];

	-- add missing strings
	KARMAAVENK_LANG_DUPLICATES = {};
	local	oDupes = KARMAAVENK_LANG_DUPLICATES;
	KARMAAVENK_LANG_MISSING = {};
	local	oMissing = KARMAAVENK_LANG_MISSING; 

	local	function	CheckRecursive(oEng, oCurr, sPath)
			local	k, v;
			for k, v in pairs(oEng) do
				if (oCurr[k] == nil) then
					oCurr[k] = v;
					oMissing[sPath .. k] = v;
				elseif (type(v) == "table") then
					if (sPath == "") then
						CheckRecursive(oEng[k], oCurr[k], k);
					else
						CheckRecursive(oEng[k], oCurr[k], sPath .. "." .. k);
					end
				elseif (oCurr[k] == v) then
					oDupes[sPath .. k] = v;
				end
			end
		end

	CheckRecursive(KARMAAVENK_LANG_LOC.EN, KARMAAVENK_LANG, "");
end

