﻿local hcWorldMapFrame
local hcMiniMapFrame

hcDefaultObjects = {
	MiniMapWorldMapButton = true,
	MinimapZoomIn = true,
	MinimapZoomOut = true,
	MinimapBorderTop = true,
	MinimapToggleButton = true,
	MinimapZoneTextButton = true,
	GameTimeFrame = true,
}

function hcInit()
	if (hcSavedState == nil) then
		hcSavedState= {}
	end
	if (hcSavedState.Zoom == nil) then
		hcSavedState.Zoom = 0
	end
	if (hcSavedState.Objects == nil) then
		hcSavedState.Objects = {}
		hcSavedState.Objects = hcDefaultObjects
	end
end

function hcSetup()
	for i,j in pairs(hcSavedState.Objects) do
		local obj = getglobal(TEXT(i))
		if (hcSavedState.Objects[i]) then
			obj:Show()
		else
			obj:Hide()
		end
	end
	Minimap:SetZoom(hcSavedState.Zoom)
end

function hcZoom()
	if not arg1 then return end
	if arg1 > 0 and Minimap:GetZoom() < 5 then
		Minimap:SetZoom(Minimap:GetZoom() + 1)
	elseif arg1 < 0 and Minimap:GetZoom() > 0 then
		Minimap:SetZoom(Minimap:GetZoom() - 1)
	end
	hcSavedState.Zoom = Minimap:GetZoom()
end

function hcUpdateMiniMap()
	x,y=GetPlayerMapPosition("player")
	hcMiniMapFrame.loc:SetText(string.format("%.1f, %.1f", x * 100, y * 100))
end

function hcUpdateWorldMap()
	local output = ""
	local OFFSET_X = 0.0022
	local OFFSET_Y = -0.0262


	local x, y = GetCursorPosition()
	local scale = WorldMapFrame:GetScale()
	x = x / scale
	y = y / scale
	local width = WorldMapButton:GetWidth()
	local height = WorldMapButton:GetHeight()
	local centerX, centerY = WorldMapFrame:GetCenter()
	local adjustedX = (x - (centerX - (width / 2))) / width
	local adjustedY = (centerY + (height / 2) - y) / height
	x = (adjustedX + OFFSET_X) * 100
	y = (adjustedY + OFFSET_Y) * 100
	local px, py = GetPlayerMapPosition("player")
	hcWorldMapFrame.loc:SetText(string.format("havocCoords v1.1 ru - Курсор: %.1f, %.1f Игрок: %.1f, %.1f", x, y, px * 100, py * 100))
end

function hcEvent ()
	if (event == "ZONE_CHANGED_NEW_AREA") then
		SetMapToCurrentZone()
	end
	if (event == "VARIABLES_LOADED") then
		hcInit()
		hcSetup()
	end
end

function hcEnable()
	hcMiniMapFrame = CreateFrame("Frame", nil, Minimap)

	hcMiniMapFrame:EnableMouse(false)
	hcMiniMapFrame:SetPoint("TOPLEFT", Minimap, "TOPLEFT")
	hcMiniMapFrame:SetPoint("BOTTOMRIGHT", Minimap, "BOTTOMRIGHT")
	hcMiniMapFrame:EnableMouseWheel(true)

	hcMiniMapFrame.loc = hcMiniMapFrame:CreateFontString(nil, "OVERLAY")
	hcMiniMapFrame.loc:SetWidth(1000)
	hcMiniMapFrame.loc:SetHeight(16)
	hcMiniMapFrame.loc:SetPoint("BOTTOM", hcMiniMapFrame, "BOTTOM", 0, -20)
	hcMiniMapFrame.loc:SetJustifyH("CENTER")
	hcMiniMapFrame.loc:SetFontObject(GameFontNormal)
	hcMiniMapFrame:SetScript("OnMouseWheel", hcZoom)
	hcMiniMapFrame:SetScript("OnUpdate", hcUpdateMiniMap)
	hcMiniMapFrame:SetScript("OnEvent",hcEvent);

	hcWorldMapFrame = CreateFrame("Frame",nil, WorldMapFrame)
	hcWorldMapFrame.loc = hcWorldMapFrame:CreateFontString(nil, "OVERLAY")
	hcWorldMapFrame.loc:SetPoint("BOTTOM", WorldMapFrame, "BOTTOM", 0, 10)
	hcWorldMapFrame.loc:SetJustifyH("CENTER")
	hcWorldMapFrame.loc:SetFontObject(GameFontNormal)
	hcWorldMapFrame:SetScript("OnUpdate", hcUpdateWorldMap)

	SetMapToCurrentZone()
	hcMiniMapFrame:RegisterEvent("ZONE_CHANGED_NEW_AREA")
	hcMiniMapFrame:RegisterEvent("VARIABLES_LOADED")
end

hcEnable()
