---------------------------------------------------------
-- Localizable strings (defaults) for enUS and enGB

GEMHELPER_VERSION_TEXT		= "Gem Helper v1.8.3"
GEMHELPER_DONE_TEXT		= "Done"

GEMHELPER_ERRORTOOLTIP_L1	= "Unsafe Item"
GEMHELPER_ERRORTOOLTIP_L2	= "ItemID: "
GEMHELPER_ERRORTOOLTIP_L3	= "This item is unsafe. To view this item without the risk of disconnection, you need to have first seen it in the game world. This is a restriction enforced by Blizzard since Patch 1.10."
GEMHELPER_ERRORTOOLTIP_L4	= "You can right-click to attempt to query the server.  You may be disconnected."
GEMHELPER_QUERY_MESSAGE		= "Server queried for "

GEMHELPER_OPENJC_TEXT		= "Open/close the original JC tradeskill window."
GEMHELPER_CHANGEBGCOLOR_TEXT	= "Change the background color."
GEMHELPER_SHOW_OTHER_JC_TEXT	= "Showing %s's JC"
GEMHELPER_OF_TEXT	= " of "

-- GEMHELPER_JEWELCRAFTING_TEXT must match the text written on the top of default Jewelcrafting UI
-- window, which should also be the same as the text written in your Character --> Skills -->
-- Professions panel because this string is used to check whether a player has Jewelcrafting as
-- a profession as well as whether the Jewelcrafting default UI window is about to be open.
GEMHELPER_JEWELCRAFTING_TEXT	= "Jewelcrafting"

GEMHELPER_CHECKBUTTON_TEXT	= {
	[1]	= "Filter by Gem Color",
	[2]	= "Filter by Material",
	[3]	= "Filter by Statistic",
	[4] = "Use AND logic",
	[5] = "Use AND logic",

	[11]	= "Blue gems",
	[12]	= "Red gems",
	[13]	= "Yellow gems",
	[14]	= "Meta gems",

	[61]	= "Strength",
	[62]	= "Agility",
	[63]	= "Stamina",
	[64]	= "Intellect",
	[65]	= "Spirit",
	[66]	= "Resilience",

	[70]	= "Haste Rating",
	[71]	= "Hit Rating",
	[72]	= "Critical Strike Rating",
	[73]	= "Attack Power",
	[74]	= "Dodge Rating",
	[75]	= "Defense Rating",
	[76]	= "Parry Rating",

	[81]	= "Armor Penetration",
	[82]	= "Spell Penetration",
	[83]	= "Spell Power",
	[84]	= "Expertise Rating",
	[85]	= "Mana / 5 seconds",
	[86]	= "Resist All",

	[101]	= "Show Jewelcrafting Gems",
	[1011]	= "Have Materials",
	[1012]	= "That %s Can Cut",
	[1013]	= "Exclude JC-Only",
	[102]	= "Show Enchanting Gems",
	[103]	= "Show Vendor Gems",
	[104]	= "Show Instance Drop Gems",
	[105]	= "Exclude non-WotLK gems",

	[111]	= "Replace default JC UI",
}

-- Data for English localization
GemHelper_GemLocaleData = {
	-- Crafted Uncommon Quality Gems
	[23095] = {n = "Bold Blood Garnet",		d = "Crafted, 1 Blood Garnet"},
	[28595] = {n = "Bright Blood Garnet",		d = "Crafted, 1 Blood Garnet"},
	[23113] = {n = "Brilliant Golden Draenite",		d = "Crafted, 1 Golden Draenite"},
	[23106] = {n = "Dazzling Deep Peridot",		d = "Crafted, 1 Deep Peridot (Scryers only)"},
	[23097] = {n = "Delicate Blood Garnet",		d = "Crafted, 1 Blood Garnet"},
	[23105] = {n = "Enduring Deep Peridot",		d = "Crafted, 1 Deep Peridot"},
	[23114] = {n = "Gleaming Golden Draenite",		d = "Crafted, 1 Golden Draenite"},
	[23100] = {n = "Glinting Flame Spessarite",		d = "Crafted, 1 Flame Spessarite"},
	[23108] = {n = "Glowing Shadow Draenite",		d = "Crafted, 1 Shadow Draenite"},
	[23098] = {n = "Inscribed Flame Spessarite",		d = "Crafted, 1 Flame Spessarite"},
	[23104] = {n = "Jagged Deep Peridot",		d = "Crafted, 1 Deep Peridot"},
	[23099] = {n = "Luminous Flame Spessarite",		d = "Crafted, 1 Flame Spessarite"},
	[23121] = {n = "Lustrous Azure Moonstone",		d = "Crafted, 1 Azure Moonstone"},
	[23101] = {n = "Potent Flame Spessarite",		d = "Crafted, 1 Flame Spessarite"},
	[23103] = {n = "Radiant Deep Peridot",		d = "Crafted, 1 Deep Peridot"},
	[23116] = {n = "Rigid Golden Draenite",		d = "Crafted, 1 Golden Draenite"},
	[23109] = {n = "Royal Shadow Draenite",		d = "Crafted, 1 Shadow Draenite (Aldor only)"},
	[23096] = {n = "Runed Blood Garnet",		d = "Crafted, 1 Blood Garnet"},
	[23110] = {n = "Shifting Shadow Draenite",		d = "Crafted, 1 Shadow Draenite"},
	[28290] = {n = "Smooth Golden Draenite",		d = "Crafted, 1 Golden Draenite"},
	[23118] = {n = "Solid Azure Moonstone",		d = "Crafted, 1 Azure Moonstone"},
	[23111] = {n = "Sovereign Shadow Draenite",		d = "Crafted, 1 Shadow Draenite"},
	[23119] = {n = "Sparkling Azure Moonstone",		d = "Crafted, 1 Azure Moonstone"},
	[23120] = {n = "Stormy Azure Moonstone",		d = "Crafted, 1 Azure Moonstone"},
	[23094] = {n = "Teardrop Blood Garnet",		d = "Crafted, 1 Blood Garnet"},
	[23115] = {n = "Thick Golden Draenite",		d = "Crafted, 1 Golden Draenite"},

	-- Crafted Rare Quality Gems
	[24027] = {n = "Bold Living Ruby",			d = "Crafted, 1 Living Ruby"},
	[24031] = {n = "Bright Living Ruby",		d = "Crafted, 1 Living Ruby"},
	[24047] = {n = "Brilliant Dawnstone",		d = "Crafted, 1 Dawnstone"},
	[24065] = {n = "Dazzling Talasite",			d = "Crafted, 1 Talasite"},
	[24028] = {n = "Delicate Living Ruby",		d = "Crafted, 1 Living Ruby"},
	[24062] = {n = "Enduring Talasite",			d = "Crafted, 1 Talasite"},
	[24036] = {n = "Flashing Living Ruby",		d = "Crafted, 1 Living Ruby"},
	[24050] = {n = "Gleaming Dawnstone",		d = "Crafted, 1 Dawnstone"},
	[24061] = {n = "Glinting Noble Topaz",		d = "Crafted, 1 Noble Topaz"},
	[24056] = {n = "Glowing Nightseye",			d = "Crafted, 1 Nightseye"},
	[24058] = {n = "Inscribed Noble Topaz",		d = "Crafted, 1 Noble Topaz"},
	[24067] = {n = "Jagged Talasite",			d = "Crafted, 1 Talasite"},
	[24060] = {n = "Luminous Noble Topaz",		d = "Crafted, 1 Noble Topaz"},
	[24037] = {n = "Lustrous Star of Elune",		d = "Crafted, 1 Star of Elune"},
	[24059] = {n = "Potent Noble Topaz",		d = "Crafted, 1 Noble Topaz"},
	[24066] = {n = "Radiant Talasite",			d = "Crafted, 1 Talasite"},
	[24051] = {n = "Rigid Dawnstone",			d = "Crafted, 1 Dawnstone"},
	[24057] = {n = "Royal Nightseye",			d = "Crafted, 1 Nightseye"},
	[24030] = {n = "Runed Living Ruby",			d = "Crafted, 1 Living Ruby"},
	[24055] = {n = "Shifting Nightseye",		d = "Crafted, 1 Nightseye"},
	[24048] = {n = "Smooth Dawnstone",			d = "Crafted, 1 Dawnstone"},
	[24033] = {n = "Solid Star of Elune",		d = "Crafted, 1 Star of Elune"},
	[24054] = {n = "Sovereign Nightseye",		d = "Crafted, 1 Nightseye"},
	[24035] = {n = "Sparkling Star of Elune",		d = "Crafted, 1 Star of Elune"},
	[24039] = {n = "Stormy Star of Elune",		d = "Crafted, 1 Star of Elune"},
	[24032] = {n = "Subtle Living Ruby",		d = "Crafted, 1 Living Ruby"},
	[24029] = {n = "Teardrop Living Ruby",		d = "Crafted, 1 Living Ruby"},
	[24052] = {n = "Thick Dawnstone",			d = "Crafted, 1 Dawnstone"},

	-- Crafted Rare Meta Gems
	[25897] = {n = "Bracing Earthstorm Diamond",		d = "Crafted, 1 Earthstorm Diamond"},
	[25899]	= {n = "Brutal Earthstorm Diamond",	d = "Crafted, 1 Earthstorm Diamond"},
	[25890] = {n = "Destructive Skyfire Diamond",		d = "Crafted, 1 Skyfire Diamond"},
	[25895] = {n = "Enigmatic Skyfire Diamond",		d = "Crafted, 1 Skyfire Diamond"},
	[25901]	= {n = "Insightful Earthstorm Diamond",	d = "Crafted, 1 Earthstorm Diamond"},
	[25893] = {n = "Mystical Skyfire Diamond",		d = "Crafted, 1 Skyfire Diamond"},
	[25896] = {n = "Powerful Earthstorm Diamond",	d = "Crafted, 1 Earthstorm Diamond"},
	[25894] = {n = "Swift Skyfire Diamond",		d = "Crafted, 1 Skyfire Diamond"},
	[25898]	= {n = "Tenacious Earthstorm Diamond",	d = "Crafted, 1 Earthstorm Diamond"},

	-- Enchanter Created
	[22460] = {n = "Prismatic Sphere",		d = "Enchanter Crafted, 4 Large Prismatic Shard"},
	[22459] = {n = "Void Sphere",		d = "Enchanter Crafted, 2 Void Crystal"},

	-- PvP Purchased Rare Meta Gems (Terrokar Spirit Towers)
	[28557] = {n = "Swift Starfire Diamond",	d = "Vendor, 8 Spirit Shard (Allerian Stronghold/Stonebreaker Hold)"},
	[28556] = {n = "Swift Windfire Diamond",	d = "Vendor, 8 Spirit Shard (Allerian Stronghold/Stonebreaker Hold)"},

	-- PvP Purchased Gems (Nagrand, Halaa)
	[27679]	= {n = "Sublime Mystic Dawnstone",	d = "Vendor, 100 Halaa Battle Token (Halaa, Nagrand)"},
	[30598] = {n = "Don Amancio's Heart", 	d = "Vendor, 14g 9s 72c (Limited Supply (1)) (Halaa, Nagrand)"},

	-- PvP Purchased Epic Gems (Honor Points)
	[28362] = {n = "Bold Ornate Ruby",		d = "Vendor, 8100 Honor (Champion's Hall/Hall of Legends)"},
	[28120] = {n = "Gleaming Ornate Dawnstone",	d = "Vendor, 8100 Honor (Champion's Hall/Hall of Legends)"},
	[28363] = {n = "Inscribed Ornate Topaz",	d = "Vendor, 10000 Honor (Champion's Hall/Hall of Legends)"},
	[28123] = {n = "Potent Ornate Topaz",	d = "Vendor, 10000 Honor (Champion's Hall/Hall of Legends)"},
	[28118] = {n = "Runed Ornate Ruby",		d = "Vendor, 8100 Honor (Champion's Hall/Hall of Legends)"},
	[28119] = {n = "Smooth Ornate Dawnstone",	d = "Vendor, 8100 Honor (Champion's Hall/Hall of Legends)"},

	-- PvP Puchased Rare Gems (Honor Hold/Thrallmar)
	-- Honor Hold itemIDs
	[27809] = {n = "Barbed Deep Peridot", 	d = "Vendor, 10 Mark of Honor Hold/Thrallmar (Hellfire Peninsula)"},
	[28361] = {n = "Mighty Blood Garnet", 	d = "Vendor, 10 Mark of Honor Hold/Thrallmar (Hellfire Peninsula)"},
	[27820] = {n = "Notched Deep Peridot", 	d = "Vendor, 10 Mark of Honor Hold/Thrallmar (Hellfire Peninsula)"},
	[27812] = {n = "Stark Blood Garnet", 	d = "Vendor, 10 Mark of Honor Hold/Thrallmar (Hellfire Peninsula)"},

	--Thrallmar duplicates, different itemIDs
	--[27786] = {n = "Barbed Deep Peridot", 	d = "Vendor, 10 Mark of Honor Hold/Thrallmar (Hellfire Peninsula)"},
	--[28360] = {n = "Mighty Blood Garnet", 	d = "Vendor, 10 Mark of Honor Hold/Thrallmar (Hellfire Peninsula)"},
	--[27785] = {n = "Notched Deep Peridot", 	d = "Vendor, 10 Mark of Honor Hold/Thrallmar (Hellfire Peninsula)"},
	--[27777] = {n = "Stark Blood Garnet", 	d = "Vendor, 10 Mark of Honor Hold/Thrallmar (Hellfire Peninsula)"},

	-- Vendor Purchased (Common Gems)
	[28458] = {n = "Bold Tourmaline", 		d = "Gem Vendor, 2g (Shattrath, Stormspire, Honor Hold, Thrallmar)"},
	[28462] = {n = "Bright Tourmaline", 	d = "Gem Vendor, 2g (Shattrath, Stormspire, Honor Hold, Thrallmar)"},
	[28466] = {n = "Brilliant Amber", 		d = "Gem Vendor, 2g (Shattrath, Stormspire, Honor Hold, Thrallmar)"},
	[28459] = {n = "Delicate Tourmaline", 	d = "Gem Vendor, 2g (Shattrath, Stormspire, Honor Hold, Thrallmar)"},
	[28469] = {n = "Gleaming Amber", 		d = "Gem Vendor, 2g (Shattrath, Stormspire, Honor Hold, Thrallmar)"},
	[28465] = {n = "Lustrous Zircon", 		d = "Gem Vendor, 2g (Shattrath, Stormspire, Honor Hold, Thrallmar)"},
	[28468] = {n = "Rigid Amber", 		d = "Gem Vendor, 2g (Shattrath, Stormspire, Honor Hold, Thrallmar)"},
	[28461] = {n = "Runed Tourmaline", 		d = "Gem Vendor, 2g (Shattrath, Stormspire, Honor Hold, Thrallmar)"},
	[28467] = {n = "Smooth Amber", 		d = "Gem Vendor, 2g (Shattrath, Stormspire, Honor Hold, Thrallmar)"},
	[28463] = {n = "Solid Zircon", 		d = "Gem Vendor, 2g (Shattrath, Stormspire, Honor Hold, Thrallmar)"},
	[28464] = {n = "Sparkling Zircon", 		d = "Gem Vendor, 2g (Shattrath, Stormspire, Honor Hold, Thrallmar)"},
	[28460] = {n = "Teardrop Tourmaline", 	d = "Gem Vendor, 2g (Shattrath, Stormspire, Honor Hold, Thrallmar)"},
	[28470] = {n = "Thick Amber", 		d = "Gem Vendor, 2g (Shattrath, Stormspire, Honor Hold, Thrallmar)"},

	-- Instance Epic Gem Drops
	[30565] = {n = "Assassin's Fire Opal",	d = "The Mechanar - Heroic"},
	[30601] = {n = "Beaming Fire Opal",		d = "The Blood Furnace - Heroic"},
	[30574] = {n = "Brutal Tanzanite",		d = "The Botanica - Heroic"},
	[30587] = {n = "Champion's Fire Opal", 	d = "Auchenai Crypts - Heroic"},
	[30566] = {n = "Defender's Tanzanite",	d = "The Mechanar - Heroic"},
	[30594] = {n = "Effulgent Chrysoprase",	d = "Hellfire Ramparts - Heroic"},
	[30584] = {n = "Enscribed Fire Opal",	d = "Mana-Tombs - Heroic"},
	[30559] = {n = "Etched Fire Opal", 		d = "Shadow Labyrinth - Heroic"},
	[30600] = {n = "Fluorescent Tanzanite", 	d = "The Blood Furnace - Heroic"},
	[30558] = {n = "Glimmering Fire Opal",	d = "The Black Morass - Heroic"},
	[30556] = {n = "Glinting Fire Opal",	d = "The Black Morass - Heroic"},
	[30585] = {n = "Glistening Fire Opal",	d = "Mana-Tombs - Heroic"},
	[30555]	= {n = "Glowing Tanzanite",		d = "The Black Morass - Heroic"},
	[31116] = {n = "Infused Amethyst",		d = "Quest Reward - Nightbane, Karazhan"},
	[30551] = {n = "Infused Fire Opal",		d = "The Steamvault - Heroic"},
	[30593] = {n = "Iridescent Fire Opal",	d = "Hellfire Ramparts - Heroic"},
	[30602] = {n = "Jagged Chrysoprase",	d = "The Blood Furnace - Heroic"},
	[30606] = {n = "Lambent Chrysoprase",	d = "The Underbog - Heroic"},
	[30547] = {n = "Luminous Fire Opal",	d = "The Shattered Halls - Heroic"},
	[30548] = {n = "Polished Chrysoprase",	d = "The Shattered Halls - Heroic"},
	[30553] = {n = "Pristine Fire Opal",	d = "Sethekk Halls - Heroic"},
	[31118] = {n = "Pulsing Amethyst",		d = "Quest Reward - Nightbane, Karazhan"},
	[30608] = {n = "Radiant Chrysoprase",	d = "The Underbog - Heroic"},
	[30563]	= {n = "Regal Tanzanite",		d = "Shadow Labyrinth - Heroic"},
	[30604] = {n = "Resplendent Fire Opal",	d = "The Slave Pens - Heroic"},
	[30603]	= {n = "Royal Tanzanite",		d = "The Slave Pens - Heroic"},
	[30586] = {n = "Seer's Chrysoprase",	d = "Auchenai Crypts - Heroic"},
	[30549] = {n = "Shifting Tanzanite",	d = "The Steamvault - Heroic"},
	[30564] = {n = "Shining Fire Opal",		d = "The Mechanar - Heroic Mode"},
	[31117] = {n = "Soothing Amethyst",		d = "Quest Reward - Nightbane, Karazhan"},
	[30546] = {n = "Sovereign Tanzanite",	d = "The Shattered Halls - Heroic"},
	[30607] = {n = "Splendid Fire Opal",	d = "The Underbog - Heroic"},
	[30554] = {n = "Stalwart Fire Opal", 	d = "Sethekk Halls - Heroic"},
	[30592] = {n = "Steady Chrysoprase",	d = "Hellfire Ramparts - Heroic"},
	[30550] = {n = "Sundered Chrysoprase",	d = "The Steamvault - Heroic"},
	[30583] = {n = "Timeless Chrysoprase", 	d = "Mana-Tombs - Heroic"},
	[30605] = {n = "Vivid Chrysoprase", 	d = "The Slave Pens - Heroic"},

	-- Added in Gem Helper v1.1
	[30552] = {n = "Blessed Tanzanite",		d = "Sethekk Halls - Heroic"},
	[30589] = {n = "Dazzling Chrysoprase",	d = "Old Hillsbrad Foothills - Heroic"},
	[30582] = {n = "Deadly Fire Opal",		d = "The Arcatraz - Heroic"},
	[30581] = {n = "Durable Fire Opal",		d = "The Arcatraz - Heroic"},
	[30591] = {n = "Empowered Fire Opal",	d = "Old Hillsbrad Foothills - Heroic"},
	[30590] = {n = "Enduring Chrysoprase",	d = "Old Hillsbrad Foothills - Heroic"},
	[30572] = {n = "Imperial Tanzanite",	d = "The Botanica - Heroic"},
	[30573] = {n = "Mysterious Fire Opal",	d = "The Botanica - Heroic"},
	[30575] = {n = "Nimble Fire Opal",		d = "The Arcatraz - Heroic"},
	[30588] = {n = "Potent Fire Opal",		d = "Auchenai Crypts - Heroic"},
	[30560] = {n = "Rune Covered Chrysoprase",	d = "Shadow Labyrinth - Heroic"},

	-- Added in Gem Helper v1.2 (patch 2.1.1)
	[31863] = {n = "Balanced Nightseye",		d = "Crafted, 1 Nightseye"},
	[31861] = {n = "Great Dawnstone",			d = "Crafted, 1 Dawnstone"},
	[31865] = {n = "Infused Nightseye",			d = "Crafted, 1 Nightseye"},
	[31867] = {n = "Veiled Noble Topaz",		d = "Crafted, 1 Noble Topaz"},
	[31868] = {n = "Wicked Noble Topaz",		d = "Crafted, 1 Noble Topaz"},
	[32836] = {n = "Purified Shadow Pearl",		d = "Crafted, 1 Shadow Pearl, 1 Purified Draenic Water"},
	[32833] = {n = "Purified Jaggal Pearl",		d = "Crafted, 1 Jaggal Pearl, 1 Purified Draenic Water"},
	[32409]	= {n = "Relentless Earthstorm Diamond",	d = "Crafted, 1 Earthstorm Diamond"},
	[32410] = {n = "Thundering Skyfire Diamond",	d = "Crafted, 1 Skyfire Diamond"},

	-- Added in Gem Helper v1.3 (patch 2.1.3)
	[24053] = {n = "Mystic Dawnstone",		d = "Crafted, 1 Dawnstone"},
	[32634] = {n = "Unstable Amethyst",		d = "Vendor, 40 Apexis Shard (Blade's Edge Mountains)"},
	[32635] = {n = "Unstable Peridot",		d = "Vendor, 40 Apexis Shard (Blade's Edge Mountains)"},
	[32636] = {n = "Unstable Sapphire",		d = "Vendor, 40 Apexis Shard (Blade's Edge Mountains)"},
	[32637] = {n = "Unstable Citrine",		d = "Vendor, 40 Apexis Shard (Blade's Edge Mountains)"},
	[32638] = {n = "Unstable Topaz",		d = "Vendor, 40 Apexis Shard (Blade's Edge Mountains)"},
	[32639] = {n = "Unstable Talasite",		d = "Vendor, 40 Apexis Shard (Blade's Edge Mountains)"},
	[32640] = {n = "Potent Unstable Diamond",	d = "Vendor, 160 Apexis Shard (Blade's Edge Mountains)"},
	[32641] = {n = "Imbued Unstable Diamond",	d = "Vendor, 160 Apexis Shard (Blade's Edge Mountains)"},

	-- Added in Gem Helper v1.3 (patch 2.1.3)
	-- The following gems are crafted from epic gem drops in Black Temple/Hyjal
	[32193] = {n = "Bold Crimson Spinel",		d = "Crafted, 1 Crimson Spinel"},
	[32194] = {n = "Delicate Crimson Spinel",		d = "Crafted, 1 Crimson Spinel"},
	[32195] = {n = "Teardrop Crimson Spinel",		d = "Crafted, 1 Crimson Spinel"},
	[32196] = {n = "Runed Crimson Spinel",		d = "Crafted, 1 Crimson Spinel"},
	[32197] = {n = "Bright Crimson Spinel",		d = "Crafted, 1 Crimson Spinel"},
	[32198] = {n = "Subtle Crimson Spinel",		d = "Crafted, 1 Crimson Spinel"},
	[32199] = {n = "Flashing Crimson Spinel",		d = "Crafted, 1 Crimson Spinel"},
	[32200] = {n = "Solid Empyrean Sapphire",		d = "Crafted, 1 Empyrean Sapphire"},
	[32201] = {n = "Sparkling Empyrean Sapphire",	d = "Crafted, 1 Empyrean Sapphire"},
	[32202] = {n = "Lustrous Empyrean Sapphire",	d = "Crafted, 1 Empyrean Sapphire"},
	[32203] = {n = "Stormy Empyrean Sapphire",		d = "Crafted, 1 Empyrean Sapphire"},
	[32204] = {n = "Brilliant Lionseye",		d = "Crafted, 1 Lionseye"},
	[32205] = {n = "Smooth Lionseye",			d = "Crafted, 1 Lionseye"},
	[32206] = {n = "Rigid Lionseye",			d = "Crafted, 1 Lionseye"},
	[32207] = {n = "Gleaming Lionseye",			d = "Crafted, 1 Lionseye"},
	[32208] = {n = "Thick Lionseye",			d = "Crafted, 1 Lionseye"},
	[32209] = {n = "Mystic Lionseye",			d = "Crafted, 1 Lionseye"},
	[32210] = {n = "Great Lionseye",			d = "Crafted, 1 Lionseye"},
	[32211] = {n = "Sovereign Shadowsong Amethyst",	d = "Crafted, 1 Shadowsong Amethyst"},
	[32212] = {n = "Shifting Shadowsong Amethyst",	d = "Crafted, 1 Shadowsong Amethyst"},
	[32213] = {n = "Balanced Shadowsong Amethyst",	d = "Crafted, 1 Shadowsong Amethyst"},
	[32214] = {n = "Infused Shadowsong Amethyst",	d = "Crafted, 1 Shadowsong Amethyst"},
	[32215] = {n = "Glowing Shadowsong Amethyst",	d = "Crafted, 1 Shadowsong Amethyst"},
	[32216] = {n = "Royal Shadowsong Amethyst",		d = "Crafted, 1 Shadowsong Amethyst"},
	[32217] = {n = "Inscribed Pyrestone",		d = "Crafted, 1 Pyrestone"},
	[32218] = {n = "Potent Pyrestone",			d = "Crafted, 1 Pyrestone"},
	[32219] = {n = "Luminous Pyrestone",		d = "Crafted, 1 Pyrestone"},
	[32220] = {n = "Glinting Pyrestone",		d = "Crafted, 1 Pyrestone"},
	[32221] = {n = "Veiled Pyrestone",			d = "Crafted, 1 Pyrestone"},
	[32222] = {n = "Wicked Pyrestone",			d = "Crafted, 1 Pyrestone"},
	[32223] = {n = "Enduring Seaspray Emerald",		d = "Crafted, 1 Seaspray Emerald"},
	[32224] = {n = "Radiant Seaspray Emerald",		d = "Crafted, 1 Seaspray Emerald"},
	[32225] = {n = "Dazzling Seaspray Emerald",		d = "Crafted, 1 Seaspray Emerald"},
	[32226] = {n = "Jagged Seaspray Emerald",		d = "Crafted, 1 Seaspray Emerald"},

	-- Added in Gem Helper v1.4 (patch 2.2.0)
	[33131] = {n = "Crimson Sun",	d = "Crafted, 1 Living Ruby"},
	[33133] = {n = "Don Julio's Heart",	d = "Crafted, 1 Living Ruby"},
	[33134] = {n = "Kailee's Rose",	d = "Crafted, 1 Living Ruby"},
	[33135] = {n = "Falling Star",	d = "Crafted, 1 Star of Elune"},
	[33140] = {n = "Blood of Amber",	d = "Crafted, 1 Dawnstone"},
	[33143] = {n = "Stone of Blades",	d = "Crafted, 1 Dawnstone"},
	[33144] = {n = "Facet of Eternity",	d = "Crafted, 1 Dawnstone"},
	[33782] = {n = "Steady Talasite",	d = "Crafted, 1 Talasite"},

	-- Added in Gem Helper v1.41 (patch 2.2.2)
	[31862] = {n = "Balanced Shadow Draenite",		d = "Crafted, 1 Shadow Draenite"},
	[31860] = {n = "Great Golden Draenite",		d = "Crafted, 1 Golden Draenite"},
	[31864] = {n = "Infused Shadow Draenite",		d = "Crafted, 1 Shadow Draenite"},
	[31866] = {n = "Veiled Flame Spessarite",		d = "Crafted, 1 Flame Spessarite"},
	[31869] = {n = "Wicked Flame Spessarite",		d = "Crafted, 1 Flame Spessarite"},

	-- Added in Gem Helper v1.5 (patch 2.3.0)
	[34220] = {n = "Chaotic Skyfire Diamond",	d = "Crafted, 1 Skyfire Diamond"},
	[34256] = {n = "Charmed Amani Jewel",	d = "Quest Reward - Zul'Aman"},

	-- Added in Gem Helper v1.6 (patch 2.4.0)
	[35503] = {n = "Ember Skyfire Diamond",	d = "Crafted, 1 Skyfire Diamond"},
	[35501] = {n = "Eternal Earthstorm Diamond",	d = "Crafted, 1 Earthstorm Diamond"},
	[35707] = {n = "Regal Nightseye",			d = "Crafted, 1 Nightseye"},
	[34831] = {n = "Eye of the Sea",	d = "Quest Reward - Fishing Daily"},
	[35758] = {n = "Steady Seaspray Emerald",		d = "Crafted, 1 Seaspray Emerald"},
	[35759] = {n = "Forceful Seaspray Emerald",		d = "Crafted, 1 Seaspray Emerald"},
	[35760] = {n = "Reckless Pyrestone",			d = "Crafted, 1 Pyrestone"},
	[35761] = {n = "Quick Lionseye",		d = "Crafted, 1 Lionseye"},

	-- Added in Gem Helper v1.7 (patch 2.4.2)
	[37503] = {n = "Royal Shadowsong Amethyst",		d = "Crafted, 1 Shadowsong Amethyst"},
	[35315] = {n = "Quick Dawnstone",		d = "Crafted, 1 Dawnstone"},
	[35316] = {n = "Reckless Noble Topaz",			d = "Crafted, 1 Noble Topaz"},
	[35318] = {n = "Forceful Talasite",		d = "Crafted, 1 Talasite"},

	-- Sunwell BoP quest rewards from "Hard to Kill" - http://www.wowhead.com/?quest=11492
	--[35487] = {n = "Bright Crimson Spinel",		d = "Quest Reward - Magister's Terrace"},
	--[35488] = {n = "Runed Crimson Spinel",		d = "Quest Reward - Magister's Terrace"},
	--[35489] = {n = "Teardrop Crimson Spinel",	d = "Quest Reward - Magister's Terrace"},

	-- Added in Gem Helper v1.8.0 (patch 3.0.3)
	-- Crafted Uncommon Quality Gems
	[39927] = {n = "Lustrous Chalcedony",	d = "Crafted, 1 Chalcedony"},
	[39919] = {n = "Solid Chalcedony",	d = "Crafted, 1 Chalcedony"},
	[39920] = {n = "Sparkling Chalcedony",	d = "Crafted, 1 Chalcedony"},
	[39932] = {n = "Stormy Chalcedony",	d = "Crafted, 1 Chalcedony"},

	[39900] = {n = "Bold Bloodstone",	d = "Crafted, 1 Bloodstone"},
	[39906] = {n = "Bright Bloodstone",	d = "Crafted, 1 Bloodstone"},
	[39905] = {n = "Delicate Bloodstone",	d = "Crafted, 1 Bloodstone"},
	[39908] = {n = "Flashing Bloodstone",	d = "Crafted, 1 Bloodstone"},
	[39909] = {n = "Fractured Bloodstone",	d = "Crafted, 1 Bloodstone"},
	[39910] = {n = "Precise Bloodstone",	d = "Crafted, 1 Bloodstone"},
	[39911] = {n = "Runed Bloodstone",	d = "Crafted, 1 Bloodstone"},
	[39907] = {n = "Subtle Bloodstone",	d = "Crafted, 1 Bloodstone"},

	[39912] = {n = "Brilliant Sun Crystal",	d = "Crafted, 1 Sun Crystal"},
	[39917] = {n = "Mystic Sun Crystal",	d = "Crafted, 1 Sun Crystal"},
	[39918] = {n = "Quick Sun Crystal",	d = "Crafted, 1 Sun Crystal"},
	[39915] = {n = "Rigid Sun Crystal",	d = "Crafted, 1 Sun Crystal"},
	[39914] = {n = "Smooth Sun Crystal",	d = "Crafted, 1 Sun Crystal"},
	[39916] = {n = "Thick Sun Crystal",	d = "Crafted, 1 Sun Crystal"},

	[39984] = {n = "Dazzling Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[39976] = {n = "Enduring Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[39989] = {n = "Energized Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[39978] = {n = "Forceful Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[39983] = {n = "Intricate Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[39974] = {n = "Jagged Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[39986] = {n = "Lambent Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[39980] = {n = "Misty Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[39988] = {n = "Opaque Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[39990] = {n = "Radiant Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[39979] = {n = "Seer's Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[39992] = {n = "Shattered Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[39981] = {n = "Shining Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[39977] = {n = "Steady Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[39985] = {n = "Sundered Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[39991] = {n = "Tense Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[39968] = {n = "Timeless Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[39982] = {n = "Turbid Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[39975] = {n = "Vivid Dark Jade",	d = "Crafted, 1 Dark Jade"},

	[39966] = {n = "Accurate Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[39949] = {n = "Champion's Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[39952] = {n = "Deadly Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[39955] = {n = "Deft Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[39958] = {n = "Durable Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[39962] = {n = "Empowered Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[39948] = {n = "Etched Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[39951] = {n = "Fierce Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[39965] = {n = "Glimmering Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[39953] = {n = "Glinting Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[39947] = {n = "Inscribed Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[39954] = {n = "Lucent Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[39946] = {n = "Luminous Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[39956] = {n = "Potent Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[39961] = {n = "Pristine Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[39959] = {n = "Reckless Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[39967] = {n = "Resolute Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[39950] = {n = "Resplendent Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[39964] = {n = "Stalwart Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[39963] = {n = "Stark Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[39957] = {n = "Veiled Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[39960] = {n = "Wicked Huge Citrine",	d = "Crafted, 1 Huge Citrine"},

	[39937] = {n = "Balanced Shadow Crystal",	d = "Crafted, 1 Shadow Crystal"},
	[39939] = {n = "Defender's Shadow Crystal",	d = "Crafted, 1 Shadow Crystal"},
	[39936] = {n = "Glowing Shadow Crystal",	d = "Crafted, 1 Shadow Crystal"},
	[39940] = {n = "Guardian Shadow Crystal",	d = "Crafted, 1 Shadow Crystal"},
	[39944] = {n = "Infused Shadow Crystal",	d = "Crafted, 1 Shadow Crystal"},
	[39945] = {n = "Mysterious Shadow Crystal",	d = "Crafted, 1 Shadow Crystal"},
	[39933] = {n = "Puissant Shadow Crystal",	d = "Crafted, 1 Shadow Crystal"},
	[39941] = {n = "Purified Shadow Crystal",	d = "Crafted, 1 Shadow Crystal"},
	[39938] = {n = "Regal Shadow Crystal",	d = "Crafted, 1 Shadow Crystal"},
	[39943] = {n = "Royal Shadow Crystal",	d = "Crafted, 1 Shadow Crystal"},
	[39935] = {n = "Shifting Shadow Crystal",	d = "Crafted, 1 Shadow Crystal"},
	[39934] = {n = "Sovereign Shadow Crystal",	d = "Crafted, 1 Shadow Crystal"},
	[39942] = {n = "Tenuous Shadow Crystal",	d = "Crafted, 1 Shadow Crystal"},

	[42701] = {n = "Enchanted Pearl",	d = "Crafted, 1 Northsea Pearl, 1 Infinite Dust"},

	-- Crafted Uncommon Perfect Quality Gems
	[41440] = {n = "Perfect Lustrous Chalcedony",	d = "Crafted, 1 Chalcedony"},
	[41441] = {n = "Perfect Solid Chalcedony",	d = "Crafted, 1 Chalcedony"},
	[41442] = {n = "Perfect Sparkling Chalcedony",	d = "Crafted, 1 Chalcedony"},
	[41443] = {n = "Perfect Stormy Chalcedony",	d = "Crafted, 1 Chalcedony"},

	[41432] = {n = "Perfect Bold Bloodstone",	d = "Crafted, 1 Bloodstone"},
	[41433] = {n = "Perfect Bright Bloodstone",	d = "Crafted, 1 Bloodstone"},
	[41434] = {n = "Perfect Delicate Bloodstone",	d = "Crafted, 1 Bloodstone"},
	[41435] = {n = "Perfect Flashing Bloodstone",	d = "Crafted, 1 Bloodstone"},
	[41436] = {n = "Perfect Fractured Bloodstone",	d = "Crafted, 1 Bloodstone"},
	[41437] = {n = "Perfect Precise Bloodstone",	d = "Crafted, 1 Bloodstone"},
	[41438] = {n = "Perfect Runed Bloodstone",	d = "Crafted, 1 Bloodstone"},
	[41439] = {n = "Perfect Subtle Bloodstone",	d = "Crafted, 1 Bloodstone"},

	[41444] = {n = "Perfect Brilliant Sun Crystal",	d = "Crafted, 1 Sun Crystal"},
	[41445] = {n = "Perfect Mystic Sun Crystal",	d = "Crafted, 1 Sun Crystal"},
	[41446] = {n = "Perfect Quick Sun Crystal",	d = "Crafted, 1 Sun Crystal"},
	[41447] = {n = "Perfect Rigid Sun Crystal",	d = "Crafted, 1 Sun Crystal"},
	[41448] = {n = "Perfect Smooth Sun Crystal",	d = "Crafted, 1 Sun Crystal"},
	[41449] = {n = "Perfect Thick Sun Crystal",	d = "Crafted, 1 Sun Crystal"},

	[41463] = {n = "Perfect Dazzling Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[41464] = {n = "Perfect Enduring Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[41465] = {n = "Perfect Energized Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[41466] = {n = "Perfect Forceful Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[41467] = {n = "Perfect Intricate Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[41468] = {n = "Perfect Jagged Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[41469] = {n = "Perfect Lambert Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[41470] = {n = "Perfect Misty Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[41471] = {n = "Perfect Opaque Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[41472] = {n = "Perfect Radiant Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[41473] = {n = "Perfect Seer's Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[41474] = {n = "Perfect Shattered Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[41475] = {n = "Perfect Shining Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[41476] = {n = "Perfect Steady Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[41477] = {n = "Perfect Sundered Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[41478] = {n = "Perfect Tense Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[41479] = {n = "Perfect Timeless Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[41480] = {n = "Perfect Turbid Dark Jade",	d = "Crafted, 1 Dark Jade"},
	[41481] = {n = "Perfect Vivid Dark Jade",	d = "Crafted, 1 Dark Jade"},

	[41482] = {n = "Perfect Accurate Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[41483] = {n = "Perfect Champion's Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[41484] = {n = "Perfect Deadly Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[41485] = {n = "Perfect Deft Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[41486] = {n = "Perfect Durable Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[41487] = {n = "Perfect Empowered Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[41488] = {n = "Perfect Etched Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[41489] = {n = "Perfect Fierce Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[41490] = {n = "Perfect Glimmering Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[41491] = {n = "Perfect Glinting Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[41492] = {n = "Perfect Inscribed Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[41493] = {n = "Perfect Lucent Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[41494] = {n = "Perfect Luminous Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[41495] = {n = "Perfect Potent Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[41496] = {n = "Perfect Pristine Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[41497] = {n = "Perfect Reckless Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[41498] = {n = "Perfect Resolute Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[41499] = {n = "Perfect Resplendent Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[41500] = {n = "Perfect Stalwart Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[41501] = {n = "Perfect Stark Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[41502] = {n = "Perfect Veiled Huge Citrine",	d = "Crafted, 1 Huge Citrine"},
	[41429] = {n = "Perfect Wicked Huge Citrine",	d = "Crafted, 1 Huge Citrine"},

	[41450] = {n = "Perfect Balanced Shadow Crystal",	d = "Crafted, 1 Shadow Crystal"},
	[41451] = {n = "Perfect Defender's Shadow Crystal",	d = "Crafted, 1 Shadow Crystal"},
	[41452] = {n = "Perfect Glowing Shadow Crystal",	d = "Crafted, 1 Shadow Crystal"},
	[41453] = {n = "Perfect Guardian Shadow Crystal",	d = "Crafted, 1 Shadow Crystal"},
	[41454] = {n = "Perfect Infused Shadow Crystal",	d = "Crafted, 1 Shadow Crystal"},
	[41455] = {n = "Perfect Mysterious Shadow Crystal",	d = "Crafted, 1 Shadow Crystal"},
	[41456] = {n = "Perfect Puissant Shadow Crystal",	d = "Crafted, 1 Shadow Crystal"},
	[41457] = {n = "Perfect Purified Shadow Crystal",	d = "Crafted, 1 Shadow Crystal"},
	[41458] = {n = "Perfect Regal Shadow Crystal",	d = "Crafted, 1 Shadow Crystal"},
	[41459] = {n = "Perfect Royal Shadow Crystal",	d = "Crafted, 1 Shadow Crystal"},
	[41460] = {n = "Perfect Shifting Shadow Crystal",	d = "Crafted, 1 Shadow Crystal"},
	[41461] = {n = "Perfect Sovereign Shadow Crystal",	d = "Crafted, 1 Shadow Crystal"},
	[41462] = {n = "Perfect Tenuous Shadow Crystal",	d = "Crafted, 1 Shadow Crystal"},

	-- Crafted Rare Quality Gems
	[40010] = {n = "Lustrous Sky Sapphire",	d = "Crafted, 1 Sky Sapphire"},
	[40008] = {n = "Solid Sky Sapphire",	d = "Crafted, 1 Sky Sapphire"},
	[40009] = {n = "Sparkling Sky Sapphire",	d = "Crafted, 1 Sky Sapphire"},
	[40011] = {n = "Stormy Sky Sapphire",	d = "Crafted, 1 Sky Sapphire"},

	[39996] = {n = "Bold Scarlet Ruby",	d = "Crafted, 1 Scarlet Ruby"},
	[39999] = {n = "Bright Scarlet Ruby",	d = "Crafted, 1 Scarlet Ruby"},
	[39997] = {n = "Delicate Scarlet Ruby",	d = "Crafted, 1 Scarlet Ruby"},
	[40001] = {n = "Flashing Scarlet Ruby",	d = "Crafted, 1 Scarlet Ruby"},
	[40002] = {n = "Fractured Scarlet Ruby",	d = "Crafted, 1 Scarlet Ruby"},
	[40003] = {n = "Precise Scarlet Ruby",	d = "Crafted, 1 Scarlet Ruby"},
	[39998] = {n = "Runed Scarlet Ruby",	d = "Crafted, 1 Scarlet Ruby"},
	[40000] = {n = "Subtle Scarlet Ruby",	d = "Crafted, 1 Scarlet Ruby"},

	[40012] = {n = "Brilliant Autumn's Glow",	d = "Crafted, 1 Autumn's Glow"},
	[40016] = {n = "Mystic Autumn's Glow",	d = "Crafted, 1 Autumn's Glow"},
	[40017] = {n = "Quick Autumn's Glow",	d = "Crafted, 1 Autumn's Glow"},
	[40014] = {n = "Rigid Autumn's Glow",	d = "Crafted, 1 Autumn's Glow"},
	[40013] = {n = "Smooth Autumn's Glow",	d = "Crafted, 1 Autumn's Glow"},
	[40015] = {n = "Thick Autumn's Glow",	d = "Crafted, 1 Autumn's Glow"},

	[40094] = {n = "Dazzling Forest Emerald",	d = "Crafted, 1 Forest Emerald"},
	[40089] = {n = "Enduring Forest Emerald",	d = "Crafted, 1 Forest Emerald"},
	[40105] = {n = "Energized Forest Emerald",	d = "Crafted, 1 Forest Emerald"},
	[40091] = {n = "Forceful Forest Emerald",	d = "Crafted, 1 Forest Emerald"},
	[40104] = {n = "Intricate Forest Emerald",	d = "Crafted, 1 Forest Emerald"},
	[40086] = {n = "Jagged Forest Emerald",	d = "Crafted, 1 Forest Emerald"},
	[40100] = {n = "Lambert Forest Emerald",	d = "Crafted, 1 Forest Emerald"},
	[40095] = {n = "Misty Forest Emerald",	d = "Crafted, 1 Forest Emerald"},
	[40103] = {n = "Opaque Forest Emerald",	d = "Crafted, 1 Forest Emerald"},
	[40098] = {n = "Radiant Forest Emerald",	d = "Crafted, 1 Forest Emerald"},
	[40092] = {n = "Seer's Forest Emerald",	d = "Crafted, 1 Forest Emerald"},
	[40106] = {n = "Shattered Forest Emerald",	d = "Crafted, 1 Forest Emerald"},
	[40099] = {n = "Shining Forest Emerald",	d = "Crafted, 1 Forest Emerald"},
	[40090] = {n = "Steady Forest Emerald",	d = "Crafted, 1 Forest Emerald"},
	[40096] = {n = "Sundered Forest Emerald",	d = "Crafted, 1 Forest Emerald"},
	[40101] = {n = "Tense Forest Emerald",	d = "Crafted, 1 Forest Emerald"},
	[40085] = {n = "Timeless Forest Emerald",	d = "Crafted, 1 Forest Emerald"},
	[40102] = {n = "Turbid Forest Emerald",	d = "Crafted, 1 Forest Emerald"},
	[40088] = {n = "Vivid Forest Emerald",	d = "Crafted, 1 Forest Emerald"},

	[40058] = {n = "Accurate Monarch Topaz",	d = "Crafted, 1 Monarch Topaz"},
	[40039] = {n = "Champion's Monarch Topaz",	d = "Crafted, 1 Monarch Topaz"},
	[40043] = {n = "Deadly Monarch Topaz",	d = "Crafted, 1 Monarch Topaz"},
	[40046] = {n = "Deft Monarch Topaz",	d = "Crafted, 1 Monarch Topaz"},
	[40050] = {n = "Durable Monarch Topaz",	d = "Crafted, 1 Monarch Topaz"},
	[40054] = {n = "Empowered Monarch Topaz",	d = "Crafted, 1 Monarch Topaz"},
	[40038] = {n = "Etched Monarch Topaz",	d = "Crafted, 1 Monarch Topaz"},
	[40041] = {n = "Fierce Monarch Topaz",	d = "Crafted, 1 Monarch Topaz"},
	[40057] = {n = "Glimmering Monarch Topaz",	d = "Crafted, 1 Monarch Topaz"},
	[40044] = {n = "Glinting Monarch Topaz",	d = "Crafted, 1 Monarch Topaz"},
	[40037] = {n = "Inscribed Monarch Topaz",	d = "Crafted, 1 Monarch Topaz"},
	[40045] = {n = "Lucent Monarch Topaz",	d = "Crafted, 1 Monarch Topaz"},
	[40047] = {n = "Luminous Monarch Topaz",	d = "Crafted, 1 Monarch Topaz"},
	[40048] = {n = "Potent Monarch Topaz",	d = "Crafted, 1 Monarch Topaz"},
	[40053] = {n = "Pristine Monarch Topaz",	d = "Crafted, 1 Monarch Topaz"},
	[40051] = {n = "Reckless Monarch Topaz",	d = "Crafted, 1 Monarch Topaz"},
	[40059] = {n = "Resolute Monarch Topaz",	d = "Crafted, 1 Monarch Topaz"},
	[40040] = {n = "Resplendent Monarch Topaz",	d = "Crafted, 1 Monarch Topaz"},
	[40056] = {n = "Stalwart Monarch Topaz",	d = "Crafted, 1 Monarch Topaz"},
	[40055] = {n = "Stark Monarch Topaz",	d = "Crafted, 1 Monarch Topaz"},
	[40049] = {n = "Veiled Monarch Topaz",	d = "Crafted, 1 Monarch Topaz"},
	[40052] = {n = "Wicked Monarch Topaz",	d = "Crafted, 1 Monarch Topaz"},

	[40029] = {n = "Balanced Twilight Opal",	d = "Crafted, 1 Twilight Opal"},
	[40032] = {n = "Defender's Twilight Opal",	d = "Crafted, 1 Twilight Opal"},
	[40025] = {n = "Glowing Twilight Opal",	d = "Crafted, 1 Twilight Opal"},
	[40034] = {n = "Guardian Twilight Opal",	d = "Crafted, 1 Twilight Opal"},
	[40030] = {n = "Infused Twilight Opal",	d = "Crafted, 1 Twilight Opal"},
	[40028] = {n = "Mysterious Twilight Opal",	d = "Crafted, 1 Twilight Opal"},
	[40033] = {n = "Puissant Twilight Opal",	d = "Crafted, 1 Twilight Opal"},
	[40026] = {n = "Purified Twilight Opal",	d = "Crafted, 1 Twilight Opal"},
	[40031] = {n = "Regal Twilight Opal",	d = "Crafted, 1 Twilight Opal"},
	[40027] = {n = "Royal Twilight Opal",	d = "Crafted, 1 Twilight Opal"},
	[40023] = {n = "Shifting Twilight Opal",	d = "Crafted, 1 Twilight Opal"},
	[40022] = {n = "Sovereign Twilight Opal",	d = "Crafted, 1 Twilight Opal"},
	[40024] = {n = "Tenuous Twilight Opal",	d = "Crafted, 1 Twilight Opal"},

	[42702] = {n = "Enchanted Tear",	d = "Crafted, 1 Siren's Tear, 4 Infinite Dust"},

	-- Crafted Rare Quality Meta Gems
	[41380] = {n = "Austere Earthsiege Diamond",	d = "Crafted, 1 Earthsiege Diamond"},
	[41389] = {n = "Beaming Earthsiege Diamond",	d = "Crafted, 1 Earthsiege Diamond"},
	[41395] = {n = "Bracing Earthsiege Diamond",	d = "Crafted, 1 Earthsiege Diamond"},
	[41396] = {n = "Eternal Earthsiege Diamond",	d = "Crafted, 1 Earthsiege Diamond"},
	[41401]	= {n = "Insightful Earthsiege Diamond",	d = "Crafted, 1 Earthsiege Diamond"},
	[41385] = {n = "Invigorating Earthsiege Diamond",	d = "Crafted, 1 Earthsiege Diamond"},
	[41381] = {n = "Persistent Earthsiege Diamond",	d = "Crafted, 1 Earthsiege Diamond"},
	[41397] = {n = "Powerful Earthsiege Diamond",	d = "Crafted, 1 Earthsiege Diamond"},
	[41398] = {n = "Relentless Earthsiege Diamond",	d = "Crafted, 1 Earthsiege Diamond"},
	[41382] = {n = "Trenchant Earthsiege Diamond",	d = "Crafted, 1 Earthsiege Diamond"},

	[41285] = {n = "Chaotic Skyflare Diamond",	d = "Crafted, 1 Skyflare Diamond"},
	[41307] = {n = "Destructive Skyflare Diamond",	d = "Crafted, 1 Skyflare Diamond"},
	[41377] = {n = "Effulgent Skyflare Diamond",	d = "Crafted, 1 Skyflare Diamond"},
	[41333] = {n = "Ember Skyflare Diamond",	d = "Crafted, 1 Skyflare Diamond"},
	[41335] = {n = "Enigmatic Skyflare Diamond",	d = "Crafted, 1 Skyflare Diamond"},
	[41378] = {n = "Forlorn Skyflare Diamond",	d = "Crafted, 1 Skyflare Diamond"},
	[41379] = {n = "Impassive Skyflare Diamond",	d = "Crafted, 1 Skyflare Diamond"},
	[41376] = {n = "Revitalizing Skyflare Diamond",	d = "Crafted, 1 Skyflare Diamond"},
	[41339] = {n = "Swift Skyflare Diamond",	d = "Crafted, 1 Skyflare Diamond"},
	[41400] = {n = "Thundering Skyflare Diamond",	d = "Crafted, 1 Skyflare Diamond"},
	[41375] = {n = "Tireless Skyflare Diamond",	d = "Crafted, 1 Skyflare Diamond"},

	-- PvP Purchased Gems
	[44081] = {n = "Enigmatic Starflare Diamond", d = "Vendor, 15 Stone Keeper's Shard (Wintergrasp)"},
	[44084] = {n = "Forlorn Starflare Diamond", d = "Vendor, 15 Stone Keeper's Shard (Wintergrasp)"},
	[44082] = {n = "Impassive Starflare Diamond", d = "Vendor, 15 Stone Keeper's Shard (Wintergrasp)"},
	[44076] = {n = "Swift Starflare Diamond", d = "Vendor, 15 Stone Keeper's Shard (Wintergrasp)"},
	[44078] = {n = "Tireless Starflare Diamond", d = "Vendor, 15 Stone Keeper's Shard (Wintergrasp)"},

	[44087] = {n = "Persistent Earthshatter Diamond", d = "Vendor, 15 Stone Keeper's Shard (Wintergrasp)"},
	[44088] = {n = "Powerful Earthshatter Diamond", d = "Vendor, 15 Stone Keeper's Shard (Wintergrasp)"},
	[44089] = {n = "Trenchant Earthshatter Diamond", d = "Vendor, 15 Stone Keeper's Shard (Wintergrasp)"},

	[44066] = {n = "Kharmaa's Grace", d = "Vendor, 20 Stone Keeper's Shard (Wintergrasp)"},

	-- Crafted JC-only Epic Gems (Dragon's Eye)
	[42146] = {n = "Lustrous Dragon's Eye",	d = "Crafted, 1 Dragon's Eye"},
	[36767] = {n = "Solid Dragon's Eye",	d = "Crafted, 1 Dragon's Eye"},
	[42145] = {n = "Sparkling Dragon's Eye",	d = "Crafted, 1 Dragon's Eye"},
	[42155] = {n = "Stormy Dragon's Eye",	d = "Crafted, 1 Dragon's Eye"},

	[42142] = {n = "Bold Dragon's Eye",	d = "Crafted, 1 Dragon's Eye"},
	[36766] = {n = "Bright Dragon's Eye",	d = "Crafted, 1 Dragon's Eye"},
	[42143] = {n = "Delicate Dragon's Eye",	d = "Crafted, 1 Dragon's Eye"},
	[42152] = {n = "Flashing Dragon's Eye",	d = "Crafted, 1 Dragon's Eye"},
	[42153] = {n = "Fractured Dragon's Eye",	d = "Crafted, 1 Dragon's Eye"},
	[42154] = {n = "Precise Dragon's Eye",	d = "Crafted, 1 Dragon's Eye"},
	[42144] = {n = "Runed Dragon's Eye",	d = "Crafted, 1 Dragon's Eye"},
	[42151] = {n = "Subtle Dragon's Eye",	d = "Crafted, 1 Dragon's Eye"},

	[42148] = {n = "Brilliant Dragon's Eye",	d = "Crafted, 1 Dragon's Eye"},
	[42158] = {n = "Mystic Dragon's Eye",	d = "Crafted, 1 Dragon's Eye"},
	[42150] = {n = "Quick Dragon's Eye",	d = "Crafted, 1 Dragon's Eye"},
	[42156] = {n = "Rigid Dragon's Eye",	d = "Crafted, 1 Dragon's Eye"},
	[42149] = {n = "Smooth Dragon's Eye",	d = "Crafted, 1 Dragon's Eye"},
	[42157] = {n = "Thick Dragon's Eye",	d = "Crafted, 1 Dragon's Eye"},

	-- Gems from fishing daily in Dalaran
	[45862] = {n = "Bold Stormjewel",   d = "Quest Reward - Fishing Daily"},
	[45879] = {n = "Delicate Stormjewel",   d = "Quest Reward - Fishing Daily"},
	[45883] = {n = "Runed Stormjewel",   d = "Quest Reward - Fishing Daily"},
	[45882] = {n = "Brilliant Stormjewel",   d = "Quest Reward - Fishing Daily"},
	[45987] = {n = "Rigid Stormjewel",  d = "Quest Reward - Fishing Daily"},
	[45880] = {n = "Solid Stormjewel",  d = "Quest Reward - Fishing Daily"},
	[45881] = {n = "Sparkling Stormjewel",  d = "Quest Reward - Fishing Daily"},

	-- Added in 3.2
	[40121] = {n = "Lustrous Majestic Zircon",  d = "Crafted, 1 Majestic Zircon"},
	[40119] = {n = "Solid Majestic Zircon",  d = "Crafted, 1 Majestic Zircon"},
	[40120] = {n = "Sparkling Majestic Zircon",  d = "Crafted, 1 Majestic Zircon"},
	[40122] = {n = "Stormy Majestic Zircon",  d = "Crafted, 1 Majestic Zircon"},

	[40111] = {n = "Bold Cardinal Ruby",   d = "Crafted, 1 Cardinal Ruby"},
	[40114] = {n = "Bright Cardinal Ruby",   d = "Crafted, 1 Cardinal Ruby"},
	[40112] = {n = "Delicate Cardinal Ruby",   d = "Crafted, 1 Cardinal Ruby"},
	[40116] = {n = "Flashing Cardinal Ruby",   d = "Crafted, 1 Cardinal Ruby"},
	[40117] = {n = "Fractured Cardinal Ruby",   d = "Crafted, 1 Cardinal Ruby"},
	[40118] = {n = "Precise Cardinal Ruby",   d = "Crafted, 1 Cardinal Ruby"},
	[40113] = {n = "Runed Cardinal Ruby",   d = "Crafted, 1 Cardinal Ruby"},
	[40115] = {n = "Subtle Cardinal Ruby",   d = "Crafted, 1 Cardinal Ruby"},

	[40123] = {n = "Brilliant King's Amber",   d = "Crafted, 1 King's Amber"},
	[40127] = {n = "Mystic King's Amber",   d = "Crafted, 1 King's Amber"},
	[40128] = {n = "Quick King's Amber",   d = "Crafted, 1 King's Amber"},
	[40125] = {n = "Rigid King's Amber",  d = "Crafted, 1 King's Amber"},
	[40124] = {n = "Smooth King's Amber",   d = "Crafted, 1 King's Amber"},
	[40126] = {n = "Thick King's Amber",   d = "Crafted, 1 King's Amber"},

	[40175] = {n = "Dazzling Eye of Zul",  d = "Crafted, 1 Eye of Zul"},
	[40167] = {n = "Enduring Eye of Zul",  d = "Crafted, 1 Eye of Zul"},
	[40179] = {n = "Energized Eye of Zul",  d = "Crafted, 1 Eye of Zul"},
	[40169] = {n = "Forceful Eye of Zul",  d = "Crafted, 1 Eye of Zul"},
	[40174] = {n = "Intricate Eye of Zul",  d = "Crafted, 1 Eye of Zul"},
	[40165] = {n = "Jagged Eye of Zul",  d = "Crafted, 1 Eye of Zul"},
	[40177] = {n = "Lambent Eye of Zul", d = "Crafted, 1 Eye of Zul"},
	[40171] = {n = "Misty Eye of Zul",  d = "Crafted, 1 Eye of Zul"},
	[40178] = {n = "Opaque Eye of Zul",  d = "Crafted, 1 Eye of Zul"},
	[40180] = {n = "Radiant Eye of Zul",  d = "Crafted, 1 Eye of Zul"},
	[40170] = {n = "Seer's Eye of Zul",  d = "Crafted, 1 Eye of Zul"},
	[40182] = {n = "Shattered Eye of Zul",  d = "Crafted, 1 Eye of Zul"},
	[40172] = {n = "Shining Eye of Zul",  d = "Crafted, 1 Eye of Zul"},
	[40168] = {n = "Steady Eye of Zul",  d = "Crafted, 1 Eye of Zul"},
	[40176] = {n = "Sundered Eye of Zul",  d = "Crafted, 1 Eye of Zul"},
	[40181] = {n = "Tense Eye of Zul",  d = "Crafted, 1 Eye of Zul"},
	[40164] = {n = "Timeless Eye of Zul",  d = "Crafted, 1 Eye of Zul"},
	[40173] = {n = "Turbid Eye of Zul",  d = "Crafted, 1 Eye of Zul"},
	[40166] = {n = "Vivid Eye of Zul",  d = "Crafted, 1 Eye of Zul"},

	[40162] = {n = "Accurate Ametrine",  d = "Crafted, 1 Ametrine"},
	[40144] = {n = "Champion's Ametrine",  d = "Crafted, 1 Ametrine"},
	[40147] = {n = "Deadly Ametrine",  d = "Crafted, 1 Ametrine"},
	[40150] = {n = "Deft Ametrine",  d = "Crafted, 1 Ametrine"},
	[40154] = {n = "Durable Ametrine", d = "Crafted, 1 Ametrine"},
	[40158] = {n = "Empowered Ametrine",  d = "Crafted, 1 Ametrine"},
	[40143] = {n = "Etched Ametrine",  d = "Crafted, 1 Ametrine"},
	[40146] = {n = "Fierce Ametrine",  d = "Crafted, 1 Ametrine"},
	[40161] = {n = "Glimmering Ametrine", d = "Crafted, 1 Ametrine"},
	[40148] = {n = "Glinting Ametrine", d = "Crafted, 1 Ametrine"},
	[40142] = {n = "Inscribed Ametrine", d = "Crafted, 1 Ametrine"},
	[40149] = {n = "Lucent Ametrine",  d = "Crafted, 1 Ametrine"},
	[40151] = {n = "Luminous Ametrine",  d = "Crafted, 1 Ametrine"},
	[40152] = {n = "Potent Ametrine",  d = "Crafted, 1 Ametrine"},
	[40157] = {n = "Pristine Ametrine", d = "Crafted, 1 Ametrine"},
	[40155] = {n = "Reckless Ametrine",  d = "Crafted, 1 Ametrine"},
	[40163] = {n = "Resolute Ametrine",  d = "Crafted, 1 Ametrine"},
	[40145] = {n = "Resplendent Ametrine",  d = "Crafted, 1 Ametrine"},
	[40160] = {n = "Stalwart Ametrine",  d = "Crafted, 1 Ametrine"},
	[40159] = {n = "Stark Ametrine",  d = "Crafted, 1 Ametrine"},
	[40153] = {n = "Veiled Ametrine",  d = "Crafted, 1 Ametrine"},
	[40156] = {n = "Wicked Ametrine",  d = "Crafted, 1 Ametrine"},

	[40136] = {n = "Balanced Dreadstone",  d = "Crafted, 1 Dreadstone"},
	[40139] = {n = "Defender's Dreadstone",  d = "Crafted, 1 Dreadstone"},
	[40132] = {n = "Glowing Dreadstone",  d = "Crafted, 1 Dreadstone"},
	[40141] = {n = "Guardian's Dreadstone",  d = "Crafted, 1 Dreadstone"},
	[40137] = {n = "Infused Dreadstone",  d = "Crafted, 1 Dreadstone"},
	[40135] = {n = "Mysterious Dreadstone",  d = "Crafted, 1 Dreadstone"},
	[40140] = {n = "Puissant Dreadstone",  d = "Crafted, 1 Dreadstone"},
	[40133] = {n = "Purified Dreadstone",  d = "Crafted, 1 Dreadstone"},
	[40138] = {n = "Regal Dreadstone",  d = "Crafted, 1 Dreadstone"},
	[40134] = {n = "Royal Dreadstone",  d = "Crafted, 1 Dreadstone"},
	[40130] = {n = "Shifting Dreadstone",  d = "Crafted, 1 Dreadstone"},
	[40129] = {n = "Sovereign Dreadstone",  d = "Crafted, 1 Dreadstone"},
	[40131] = {n = "Tenuous Dreadstone",  d = "Crafted, 1 Dreadstone"},

	[49110] = {n = "Nightmare Tear",  d = "Crafted, 1 Dragon's Eye, 5 Infinite Dust"},
}