---------------------------------------------------------
-- Refer to GEMHELPER_CHECKBUTTON_TEXT in the localization files for checkbox IDs


-- Base Item IDs for gem materials
-- Format: [Checkbox ID] = Gem itemID
GemHelper_MaterialGemID = {
	[21] = 23117,	-- Azure Moonstone
	[22] = 23077,	-- Blood Garnet
	[23] = 23112,	-- Golden Draenite
	[24] = 23079,	-- Deep Peridot
	[25] = 21929,	-- Flame Spessarite
	[26] = 23107,	-- Shadow Draenite
	[27] = 24478,	-- Jaggal Pearl
	[31] = 23438,	-- Star of Elune
	[32] = 23436,	-- Living Ruby
	[33] = 23440,	-- Dawnstone
	[34] = 23437,	-- Talasite
	[35] = 23439,	-- Noble Topaz
	[36] = 23441,	-- Nightseye
	[37] = 24479,	-- Shadow Pearl
	[41] = 25868,	-- Skyfire Diamond
	[42] = 25867,	-- Earthstorm Diamond
	[51] = 32228,	-- Empyrean Sapphire
	[52] = 32227,	-- Crimson Spinel
	[53] = 32229,	-- Lionseye
	[54] = 32249,	-- Seaspray Emerald
	[55] = 32231,	-- Pyrestone
	[56] = 32230,	-- Shadowsong Amethyst
	[121] = 36923,	-- Chalcedony
	[122] = 36917,	-- Bloodstone
	[123] = 36920,	-- Sun Crystal
	[124] = 36932,	-- Dark Jade
	[125] = 36929,	-- Huge Citrine
	[126] = 36926,	-- Shadow Crystal
	[127] = 36783,	-- Northsea Pearl
	[131] = 36924,	-- Sky Sapphire
	[132] = 36918,	-- Scarlet Ruby
	[133] = 36921,	-- Autumn's Glow
	[134] = 36933,	-- Forest Emerald
	[135] = 36930,	-- Monarch Topaz
	[136] = 36927,	-- Twilight Opal
	[137] = 36784,	-- Siren's Tear
	[141] = 41266,	-- Skyflare Diamond
	[142] = 41334,	-- Earthsiege Diamond
	[143] = 42225,	-- Dragon's Eye
	[151] = 36925,	-- Majestic Zircon
	[152] = 36919,	-- Cardinal Ruby
	[153] = 36922,	-- King's Amber
	[154] = 36934,	-- Eye of Zul
	[155] = 36931,	-- Ametrine	
	[156] = 36928,	-- Dreadstone
}

-- Create reverse lookup table for speed
GemHelper_ReverseMaterialGemID = {}
for k, v in pairs(GemHelper_MaterialGemID) do
	GemHelper_ReverseMaterialGemID[v] = k
end

-- Icons for raw gems
GEMHELPER_CHECKBUTTON_TEXT[21]	= "|TInterface\\Icons\\INV_Misc_Gem_AzureDraenite_03:0|t"
GEMHELPER_CHECKBUTTON_TEXT[22]	= "|TInterface\\Icons\\INV_Misc_Gem_BloodGem_03:0|t"
GEMHELPER_CHECKBUTTON_TEXT[23]	= "|TInterface\\Icons\\INV_Misc_Gem_GoldenDraenite_03:0|t"
GEMHELPER_CHECKBUTTON_TEXT[24]	= "|TInterface\\Icons\\INV_Misc_Gem_DeepPeridot_03:0|t"
GEMHELPER_CHECKBUTTON_TEXT[25]	= "|TInterface\\Icons\\INV_Misc_Gem_FlameSpessarite_03:0|t"
GEMHELPER_CHECKBUTTON_TEXT[26]	= "|TInterface\\Icons\\INV_Misc_Gem_EbonDraenite_03:0|t"
GEMHELPER_CHECKBUTTON_TEXT[27]	= "|TInterface\\Icons\\INV_Misc_Gem_Pearl_02:0|t"

GEMHELPER_CHECKBUTTON_TEXT[31]	= "|TInterface\\Icons\\INV_Jewelcrafting_StarOfElune_02:0|t"
GEMHELPER_CHECKBUTTON_TEXT[32]	= "|TInterface\\Icons\\INV_Jewelcrafting_LivingRuby_02:0|t"
GEMHELPER_CHECKBUTTON_TEXT[33]	= "|TInterface\\Icons\\INV_Jewelcrafting_Dawnstone_02:0|t"
GEMHELPER_CHECKBUTTON_TEXT[34]	= "|TInterface\\Icons\\INV_Jewelcrafting_Talasite_02:0|t"
GEMHELPER_CHECKBUTTON_TEXT[35]	= "|TInterface\\Icons\\INV_Jewelcrafting_NobleTopaz_02:0|t"
GEMHELPER_CHECKBUTTON_TEXT[36]	= "|TInterface\\Icons\\INV_Jewelcrafting_Nightseye_02:0|t"
GEMHELPER_CHECKBUTTON_TEXT[37]	= "|TInterface\\Icons\\INV_Misc_Gem_Pearl_01:0|t"

GEMHELPER_CHECKBUTTON_TEXT[41]	= "|TInterface\\Icons\\INV_Misc_Gem_Diamond_05:0|t"
GEMHELPER_CHECKBUTTON_TEXT[42]	= "|TInterface\\Icons\\INV_Misc_Gem_Diamond_04:0|t"

GEMHELPER_CHECKBUTTON_TEXT[51]	= "|TInterface\\Icons\\INV_Jewelcrafting_EmpyreanSapphire_01:0|t"
GEMHELPER_CHECKBUTTON_TEXT[52]	= "|TInterface\\Icons\\INV_Jewelcrafting_CrimsonSpinel_01:0|t"
GEMHELPER_CHECKBUTTON_TEXT[53]	= "|TInterface\\Icons\\INV_Jewelcrafting_Lionseye_01:0|t"
GEMHELPER_CHECKBUTTON_TEXT[54]	= "|TInterface\\Icons\\INV_Jewelcrafting_SeasprayEmerald_01:0|t"
GEMHELPER_CHECKBUTTON_TEXT[55]	= "|TInterface\\Icons\\INV_Jewelcrafting_Pyrestone_01:0|t"
GEMHELPER_CHECKBUTTON_TEXT[56]	= "|TInterface\\Icons\\INV_Jewelcrafting_ShadowsongAmethyst_01:0|t"

GEMHELPER_CHECKBUTTON_TEXT[121]	= "|TInterface\\Icons\\INV_Jewelcrafting_Gem_10:0|t"
GEMHELPER_CHECKBUTTON_TEXT[122]	= "|TInterface\\Icons\\INV_Jewelcrafting_Gem_12:0|t"
GEMHELPER_CHECKBUTTON_TEXT[123]	= "|TInterface\\Icons\\INV_Jewelcrafting_Gem_08:0|t"
GEMHELPER_CHECKBUTTON_TEXT[124]	= "|TInterface\\Icons\\INV_Jewelcrafting_Gem_07:0|t"
GEMHELPER_CHECKBUTTON_TEXT[125]	= "|TInterface\\Icons\\INV_Jewelcrafting_Gem_09:0|t"
GEMHELPER_CHECKBUTTON_TEXT[126]	= "|TInterface\\Icons\\INV_Jewelcrafting_Gem_11:0|t"
GEMHELPER_CHECKBUTTON_TEXT[127]	= "|TInterface\\Icons\\INV_Misc_Gem_Pearl_09:0|t"

GEMHELPER_CHECKBUTTON_TEXT[131]	= "|TInterface\\Icons\\INV_Jewelcrafting_Gem_05:0|t"
GEMHELPER_CHECKBUTTON_TEXT[132]	= "|TInterface\\Icons\\INV_Jewelcrafting_Gem_04:0|t"
GEMHELPER_CHECKBUTTON_TEXT[133]	= "|TInterface\\Icons\\INV_Jewelcrafting_Gem_03:0|t"
GEMHELPER_CHECKBUTTON_TEXT[134]	= "|TInterface\\Icons\\INV_Jewelcrafting_Gem_01:0|t"
GEMHELPER_CHECKBUTTON_TEXT[135]	= "|TInterface\\Icons\\INV_Jewelcrafting_Gem_02:0|t"
GEMHELPER_CHECKBUTTON_TEXT[136]	= "|TInterface\\Icons\\INV_Jewelcrafting_Gem_06:0|t"
GEMHELPER_CHECKBUTTON_TEXT[137]	= "|TInterface\\Icons\\INV_Misc_Gem_Pearl_11:0|t"

GEMHELPER_CHECKBUTTON_TEXT[141]	= "|TInterface\\Icons\\INV_Jewelcrafting_IceDiamond_01:0|t"
GEMHELPER_CHECKBUTTON_TEXT[142]	= "|TInterface\\Icons\\INV_Jewelcrafting_ShadowSpirit_01:0|t"
GEMHELPER_CHECKBUTTON_TEXT[143]	= "|TInterface\\Icons\\INV_Jewelcrafting_DragonsEye01:0|t"

GEMHELPER_CHECKBUTTON_TEXT[151]	= "|TInterface\\Icons\\INV_Jewelcrafting_Gem_35:0|t"
GEMHELPER_CHECKBUTTON_TEXT[152]	= "|TInterface\\Icons\\INV_Jewelcrafting_Gem_32:0|t"
GEMHELPER_CHECKBUTTON_TEXT[153]	= "|TInterface\\Icons\\INV_Jewelcrafting_Gem_36:0|t"
GEMHELPER_CHECKBUTTON_TEXT[154]	= "|TInterface\\Icons\\INV_Jewelcrafting_Gem_34:0|t"
GEMHELPER_CHECKBUTTON_TEXT[155]	= "|TInterface\\Icons\\INV_Jewelcrafting_Gem_33:0|t"
GEMHELPER_CHECKBUTTON_TEXT[156]	= "|TInterface\\Icons\\INV_Jewelcrafting_Gem_31:0|t"

-- Data for rarity, gemtype, colour, stats
-- Format: [Gem itemID] = gemTable
--   r = rarity quality sort value
--   [checkbox ID] = true (if the statistic is applicable)
GemHelper_GemData = {
	-- Crafted Uncommon Quality Gems
	[23095] = {r = 2, [101] = true, [22] = true, [12] = true, [61] = true},	-- Bold Blood Garnet, red, 6 str
	[28595] = {r = 2, [101] = true, [22] = true, [12] = true, [73] = true},	-- Bright Blood Garnet, red, 12 atk pwr
	[23113] = {r = 2, [101] = true, [23] = true, [13] = true, [64] = true},	-- Brilliant Golden Draenite, yellow, 6 int
	[23106] = {r = 2, [101] = true, [24] = true, [13] = true, [11] = true, [85] = true, [64] = true},	-- Dazzling Deep Peridot, yellow, blue, 1 mp5, 3 int
	[23097] = {r = 2, [101] = true, [22] = true, [12] = true, [62] = true},	-- Delicate Blood Garnet, red, 6 agi
	[23105] = {r = 2, [101] = true, [24] = true, [13] = true, [11] = true, [75] = true, [63] = true},	-- Enduring Deep Peridot, yellow, blue, 3 def, 4 stam
	[23114] = {r = 2, [101] = true, [23] = true, [13] = true, [72] = true},	-- Gleaming Golden Draenite, yellow, 6 crit
	[23100] = {r = 2, [101] = true, [25] = true, [13] = true, [12] = true, [71] = true, [62] = true},	-- Glinting Flame Spessarite, yellow, red, 3 hit, 3 agi
	[23108] = {r = 2, [101] = true, [26] = true, [12] = true, [11] = true, [83] = true, [63] = true},	-- Glowing Shadow Draenite, red, blue, 4 spell, 4 stam
	[23098] = {r = 2, [101] = true, [25] = true, [13] = true, [12] = true, [72] = true, [61] = true},	-- Inscribed Flame Spessarite, yellow, red, 3 crit, 3 str
	[23104] = {r = 2, [101] = true, [24] = true, [13] = true, [11] = true, [72] = true, [63] = true},	-- Jagged Deep Peridot, yellow, blue, 3 crit, 4 stam
	[23099] = {r = 2, [101] = true, [25] = true, [13] = true, [12] = true, [83] = true, [64] = true},	-- Luminous Flame Spessarite, yellow, red, 7 spell, 3 int
	[23121] = {r = 2, [101] = true, [21] = true, [11] = true, [85] = true},	-- Lustrous Azure Moonstone, blue, 2 mp5
	[23101] = {r = 2, [101] = true, [25] = true, [13] = true, [12] = true, [72] = true, [83] = true},	-- Potent Flame Spessarite, yellow, red, 3 crit, 4 spell
	[23103] = {r = 2, [101] = true, [24] = true, [13] = true, [11] = true, [72] = true, [82] = true},	-- Radiant Deep Peridot, yellow, blue, 3 crit, 4 spellpenet
	[23116] = {r = 2, [101] = true, [23] = true, [13] = true, [71] = true},	-- Rigid Golden Draenite, yellow, 6 hit
	[23109] = {r = 2, [101] = true, [26] = true, [12] = true, [11] = true, [83] = true, [85] = true},	-- Royal Shadow Draenite, red, blue, 7 spell, 1 mp5
	[23096] = {r = 2, [101] = true, [22] = true, [12] = true, [83] = true},	-- Runed Blood Garnet, red, 7 spell
	[23110] = {r = 2, [101] = true, [26] = true, [12] = true, [11] = true, [62] = true, [63] = true},	-- Shifting Shadow Draenite, red, blue, 3 agi, 4 stam
	[28290] = {r = 2, [101] = true, [23] = true, [13] = true, [72] = true},	-- Smooth Golden Draenite, yellow, 6 crit
	[23118] = {r = 2, [101] = true, [21] = true, [11] = true, [63] = true},	-- Solid Azure Moonstone, blue, 9 stam
	[23111] = {r = 2, [101] = true, [26] = true, [12] = true, [11] = true, [61] = true, [63] = true},	-- Sovereign Shadow Draenite, red, blue, 3 str, 4 stam
	[23119] = {r = 2, [101] = true, [21] = true, [11] = true, [65] = true},	-- Sparkling Azure Moonstone, blue, 6 spi
	[23120] = {r = 2, [101] = true, [21] = true, [11] = true, [82] = true},	-- Stormy Azure Moonstone, blue, 8 spellpenet
	[23094] = {r = 2, [101] = true, [22] = true, [12] = true, [83] = true},	-- Teardrop Blood Garnet, red, 13 spell
	[23115] = {r = 2, [101] = true, [23] = true, [13] = true, [75] = true},	-- Thick Golden Draenite, yellow, 6 def

	-- Crafted Rare Quality Gems
	[24027] = {r = 3, [101] = true, [32] = true, [12] = true, [61] = true},	-- Bold Living Ruby, red, 8 str
	[24031] = {r = 3, [101] = true, [32] = true, [12] = true, [73] = true},	-- Bright Living Ruby, red, 16 ap
	[24047] = {r = 3, [101] = true, [33] = true, [13] = true, [64] = true},	-- Brilliant Dawnstone, yellow, 8 int
	[24065] = {r = 3, [101] = true, [34] = true, [13] = true, [11] = true, [85] = true, [64] = true},	-- Dazzling Talasite, yellow, blue, 4 int, 2 mp5
	[24028] = {r = 3, [101] = true, [32] = true, [12] = true, [62] = true},	-- Delicate Living Ruby, red, 8 agi
	[24062] = {r = 3, [101] = true, [34] = true, [13] = true, [11] = true, [75] = true, [63] = true},	-- Enduring Talasite, yellow, blue, 4 def, 6 stam
	[24036] = {r = 3, [101] = true, [32] = true, [12] = true, [76] = true},	-- Flashing Living Ruby, red, 8 parry
	[24050] = {r = 3, [101] = true, [33] = true, [13] = true, [72] = true},	-- Gleaming Dawnstone, yellow, 8 spell crit
	[24061] = {r = 3, [101] = true, [35] = true, [13] = true, [12] = true, [71] = true, [62] = true},	-- Glinting Noble Topaz, red, yellow, 4 hit, 4 agi
	[24056] = {r = 3, [101] = true, [36] = true, [12] = true, [11] = true, [83] = true, [63] = true},	-- Glowing Nightseye, red, blue, 5 spell, 6 stam
	[24058] = {r = 3, [101] = true, [35] = true, [13] = true, [12] = true, [72] = true, [61] = true},	-- Inscribed Noble Topaz, red, yellow, 4 crit, 4 str
	[24067] = {r = 3, [101] = true, [34] = true, [13] = true, [11] = true, [72] = true, [63] = true},	-- Jagged Talasite, yellow, blue, 4 crit, 6 stam
	[24060] = {r = 3, [101] = true, [35] = true, [13] = true, [12] = true, [83] = true, [64] = true},	-- Luminous Noble Topaz, red, yellow, 9 spell, 4 int
	[24037] = {r = 3, [101] = true, [31] = true, [11] = true, [85] = true},	-- Lustrous Star of Elune, blue, 3 mp5
	[24059] = {r = 3, [101] = true, [35] = true, [13] = true, [12] = true, [72] = true, [83] = true},	-- Potent Noble Topaz, red, yellow, 4 crit, 5 spell
	[24066] = {r = 3, [101] = true, [34] = true, [13] = true, [11] = true, [72] = true, [82] = true},	-- Radiant Talasite, blue, yellow, 4 crit, 5 spellpenet
	[24051] = {r = 3, [101] = true, [33] = true, [13] = true, [71] = true},	-- Rigid Dawnstone, yellow, 8 hit
	[24057] = {r = 3, [101] = true, [36] = true, [12] = true, [11] = true, [83] = true, [85] = true},	-- Royal Nightseye, red, blue, 9 spell, 2 mp5
	[24030] = {r = 3, [101] = true, [32] = true, [12] = true, [83] = true},	-- Runed Living Ruby, red, 9 spell
	[24055] = {r = 3, [101] = true, [36] = true, [12] = true, [11] = true, [62] = true, [63] = true},	-- Shifting Nightseye, red, blue, 4 agi, 6 stam
	[24048] = {r = 3, [101] = true, [33] = true, [13] = true, [72] = true},	-- Smooth Dawnstone, yellow, 8 crit
	[24033] = {r = 3, [101] = true, [31] = true, [11] = true, [63] = true},	-- Solid Star of Elune, blue, 12 stam
	[24054] = {r = 3, [101] = true, [36] = true, [12] = true, [11] = true, [61] = true, [63] = true},	-- Sovereign Nightseye, red, blue, 4 str, 6 stam
	[24035] = {r = 3, [101] = true, [31] = true, [11] = true, [65] = true},	-- Sparkling Star of Elune, blue, 8 spi
	[24039] = {r = 3, [101] = true, [31] = true, [11] = true, [82] = true},	-- Stormy Star of Elune, blue, 10 spellpenet
	[24032] = {r = 3, [101] = true, [32] = true, [12] = true, [74] = true},	-- Subtle Living Ruby, red, 8 dodge
	[24029] = {r = 3, [101] = true, [32] = true, [12] = true, [83] = true},	-- Teardrop Living Ruby, red, 18 spell
	[24052] = {r = 3, [101] = true, [33] = true, [13] = true, [75] = true},	-- Thick Dawnstone, yellow, 8 def

	-- Crafted Rare Meta Gems
	[25897] = {r = 3, [101] = true, [42] = true, [14] = true, [83] = true},	-- Bracing Earthstorm Diamond, meta, 14 spell, 2% reduced threat
	[25899]	= {r = 3, [101] = true, [42] = true, [14] = true, [0] = true},	-- Brutal Earthstorm Diamond, meta, +3 melee damage, chance to stun target
	[25890] = {r = 3, [101] = true, [41] = true, [14] = true, [72] = true}, -- Destructive Skyfire Diamond, meta, 14 crit, 1% spellreflect
	[25895] = {r = 3, [101] = true, [41] = true, [14] = true, [72] = true},	-- Enigmatic Skyfire Diamond, meta, 12 crit, 5% snare and root resist
	[25901]	= {r = 3, [101] = true, [42] = true, [14] = true, [64] = true},	-- Insightful Earthstorm Diamond, meta, 12 int, chance to restore mana on spellcast
	[25893] = {r = 3, [101] = true, [41] = true, [14] = true, [0] = true},	-- Mystical Skyfire Diamond, meta, 2% on spellcast - next spell instant cast
	[25896] = {r = 3, [101] = true, [42] = true, [14] = true, [63] = true},	-- Powerful Earthstorm Diamond, meta, 18 stam, stun duration reduced by 15%
	[25894] = {r = 3, [101] = true, [41] = true, [14] = true, [73] = true},	-- Swift Skyfire Diamond, meta, 24 atk power, minor run speed increase
	[25898]	= {r = 3, [101] = true, [42] = true, [14] = true, [75] = true},	-- Tenacious Earthstorm Diamond, meta, 12 def, chance to restore spellth on hit

	-- Enchanter Created
	[22460] = {r = 3, [102] = true, [11] = true, [12] = true, [13] = true, [86] = true},	-- Prismatic Sphere, red, yellow, blue, 3 resist all
	[22459] = {r = 4, [102] = true, [11] = true, [12] = true, [13] = true, [86] = true},	-- Void Sphere, red, yellow, blue, 4 resist all

	-- PvP Purchased Rare Meta Gems (Terrokar Spirit Towers)
	[28557] = {r = 3, [103] = true, [14] = true, [83] = true},	-- Swift Starfire Diamond, meta, 12 spell, minor run speed increase
	[28556] = {r = 3, [103] = true, [14] = true, [73] = true},	-- Swift Windfire Diamond, meta, 20 atk power, minor run speed increase

	-- PvP Purchased Gems (Nagrand, Halaa)
	[27679]	= {r = 4, [103] = true, [13] = true, [66] = true},	-- Sublime Mystic Dawnstone, yellow, 10 res
	[30598] = {r = 3, [103] = true, [12] = true, [61] = true},	-- Don Amancio's Heart, red, 8 str

	-- PvP Purchased Epic Gems (Honor Points)
	[28362] = {r = 4, [103] = true, [12] = true, [73] = true},	-- Bold Ornate Ruby, red, 20 atk power
	[28120] = {r = 4, [103] = true, [13] = true, [72] = true},	-- Gleaming Ornate Dawnstone, yellow, 10 crit
	[28363] = {r = 4, [103] = true, [12] = true, [13] = true, [73] = true, [72] = true},	-- Inscribed Ornate Topaz, red, yellow, 10 atk power, 5 crit
	[28123] = {r = 4, [103] = true, [12] = true, [13] = true, [83] = true, [72] = true},	-- Potent Ornate Topaz, red, yellow, 6 spell, 5 crit
	[28118] = {r = 4, [103] = true, [12] = true, [83] = true},	-- Runed Ornate Ruby, red, 12 spell
	[28119] = {r = 4, [103] = true, [13] = true, [72] = true},	-- Smooth Ornate Dawnstone, yellow, 10 crit

	-- PvP Puchased Rare Gems (Honor Hold/Thrallmar)
	-- Honor Hold itemIDs
	[27809] = {r = 3, [103] = true, [13] = true, [11] = true, [63] = true, [72] = true},	-- Barbed Deep Peridot, yellow, blue, 3 stam, 4 crit
	[28361] = {r = 3, [103] = true, [12] = true, [73] = true},	-- Mighty Blood Garnet, red, 14 atk power
	[27820] = {r = 3, [103] = true, [13] = true, [11] = true, [63] = true, [72] = true},	-- Notched Deep Peridot, yellow, blue, 3 stam, 4 crit
	[27812] = {r = 3, [103] = true, [12] = true, [83] = true},	-- Stark Blood Garnet, red, 8 spell

	--Thrallmar duplicates, different itemIDs
	--[27786] = {r = 3, [103] = true, [13] = true, [11] = true, [63] = true, [72] = true},	-- Barbed Deep Peridot, yellow, blue, 3 stam, 4 crit
	--[28360] = {r = 3, [103] = true, [12] = true, [73] = true},	-- Mighty Blood Garnet, red, 14 atk power
	--[27785] = {r = 3, [103] = true, [13] = true, [11] = true, [63] = true, [72] = true},	-- Notched Deep Peridot, yellow, blue, 3 stam, 4 crit
	--[27777] = {r = 3, [103] = true, [12] = true, [83] = true},	-- Stark Blood Garnet, red, 8 spell

	-- Vendor Purchased (Common Gems)
	[28458] = {r = 1, [103] = true, [12] = true, [61] = true},	-- Bold Tourmaline, red, 4 str
	[28462] = {r = 1, [103] = true, [12] = true, [73] = true},	-- Bright Tourmaline, red, 8 atk power
	[28466] = {r = 1, [103] = true, [13] = true, [64] = true},	-- Brilliant Amber, yellow, 4 int
	[28459] = {r = 1, [103] = true, [12] = true, [62] = true},	-- Delicate Tourmaline, red, 4 agi
	[28469] = {r = 1, [103] = true, [13] = true, [72] = true},	-- Gleaming Amber, yellow, 4 crit
	[28465] = {r = 1, [103] = true, [11] = true, [85] = true},	-- Lustrous Zircon, blue, 1 mp5
	[28468] = {r = 1, [103] = true, [13] = true, [71] = true},	-- Rigid Amber, yellow, 4 hit
	[28461] = {r = 1, [103] = true, [12] = true, [83] = true},	-- Runed Tourmaline, red, 5 spell
	[28467] = {r = 1, [103] = true, [13] = true, [72] = true},	-- Smooth Amber, yellow, 4 crit
	[28463] = {r = 1, [103] = true, [11] = true, [63] = true},	-- Solid Zircon, blue, 6 stam
	[28464] = {r = 1, [103] = true, [11] = true, [65] = true},	-- Sparkling Zircon, blue, 4 spi
	[28460] = {r = 1, [103] = true, [12] = true, [83] = true},	-- Teardrop Tourmaline, red, 9 spell
	[28470] = {r = 1, [103] = true, [13] = true, [75] = true},	-- Thick Amber, yellow, 4 def

	-- Instance Epic Gem Drops
	[30565] = {r = 4, [104] = true, [12] = true, [13] = true, [72] = true, [74] = true},	-- Assassin's Fire Opal, red, yellow, 6 crit, 5 dodge
	[30601] = {r = 4, [104] = true, [12] = true, [13] = true, [74] = true, [66] = true},	-- Beaming Fire Opal, red, yellow, 5 dodge, 4 res
	[30574] = {r = 4, [104] = true, [12] = true, [11] = true, [73] = true, [63] = true},	-- Brutal Tanzanite, red, blue, 10 atk power, 6 stam
	[30587] = {r = 4, [104] = true, [12] = true, [13] = true, [61] = true, [75] = true},	-- Champion's Fire Opal, red, yellow, 5 str, 4 def
	[30566] = {r = 4, [104] = true, [12] = true, [11] = true, [76] = true, [63] = true},	-- Defender's Tanzanite, red, blue, 5 parry, 6 stam
	[30594] = {r = 4, [104] = true, [13] = true, [11] = true, [75] = true, [85] = true},	-- Effulgent Chrysoprase, yellow, blue, 5 def, 2 mp5
	[30584] = {r = 4, [104] = true, [12] = true, [13] = true, [61] = true, [72] = true},	-- Enscribed Fire Opal, red, yellow, 5 str, 4 crit
	[30559] = {r = 4, [104] = true, [12] = true, [13] = true, [61] = true, [71] = true},	-- Etched Fire Opal, red, yellow, 5 str, 4 hit
	[30600] = {r = 4, [104] = true, [12] = true, [11] = true, [83] = true, [65] = true},	-- Fluorescent Tanzanite, red, blue, 6 spell, 4 spi
	[30558] = {r = 4, [104] = true, [12] = true, [13] = true, [76] = true, [75] = true},	-- Glimmering Fire Opal, red, yellow, 5 parry, 4 def
	[30556] = {r = 4, [104] = true, [12] = true, [13] = true, [62] = true, [71] = true},	-- Glinting Fire Opal, red, yellow, 5 agi, 4 hit
	[30585] = {r = 4, [104] = true, [12] = true, [13] = true, [62] = true, [75] = true},	-- Glistening Fire Opal, red, yellow, 4 agi, 5 def
	[30555]	= {r = 4, [104] = true, [12] = true, [11] = true, [83] = true, [63] = true},	-- Glowing Tanzanite, red, blue, 6 spell, 6 stam
	[31116] = {r = 4, [104] = true, [12] = true, [11] = true, [83] = true, [63] = true},	-- Infused Amethyst, red, blue, 6 spell, 6 stam
	[30551] = {r = 4, [104] = true, [12] = true, [13] = true, [83] = true, [64] = true},	-- Infused Fire Opal, red, yellow, 6 spell, 4 int
	[30593] = {r = 4, [104] = true, [12] = true, [13] = true, [83] = true, [72] = true},	-- Iridescent Fire Opal, red, yellow, 11 spell, 4 crit
	[30602] = {r = 4, [104] = true, [13] = true, [11] = true, [63] = true, [72] = true},	-- Jagged Chrysoprase, yellow, blue, 6 stam, 5 crit
	[30606] = {r = 4, [104] = true, [13] = true, [11] = true, [71] = true, [85] = true},	-- Lambent Chrysophrase, yellow, blue, 5 hit, 2 mp5
	[30547] = {r = 4, [104] = true, [12] = true, [13] = true, [83] = true, [64] = true},	-- Luminous Fire Opal, red, yellow, 11 spell, 4 int
	[30548] = {r = 4, [104] = true, [13] = true, [11] = true, [63] = true, [72] = true},	-- Polished Chrysoprase, yellow, blue, 6 stam, 5 crit
	[30553] = {r = 4, [104] = true, [12] = true, [13] = true, [73] = true, [71] = true},	-- Pristine Fire Opal, red, yellow, 10 atk power, 4 hit
	[31118] = {r = 4, [104] = true, [12] = true, [11] = true, [73] = true, [63] = true},	-- Pulsing Amethyst, red, blue, 10 atk power, 6 stam
	[30608] = {r = 4, [104] = true, [13] = true, [11] = true, [72] = true, [82] = true},	-- Radiant Chrysoprase, yellow, blue, 5 crit, 5 spellpenet
	[30563]	= {r = 4, [104] = true, [12] = true, [11] = true, [74] = true, [63] = true},	-- Regal Tanzanite, red, blue, 5 dodge, 6 stam
	[30604] = {r = 4, [104] = true, [12] = true, [13] = true, [61] = true, [66] = true},	-- Resplendent Fire Opal, red, yellow, 5 str, 4 res
	[30603]	= {r = 4, [104] = true, [12] = true, [11] = true, [83] = true, [85] = true},	-- Royal Tanzanite, red, blue, 11 spell, 2 mp5
	[30586] = {r = 4, [104] = true, [13] = true, [11] = true, [64] = true, [65] = true},	-- Seer's Chrysoprase, yellow, blue, 4 int, 5 spi
	[30549] = {r = 4, [104] = true, [12] = true, [11] = true, [61] = true, [62] = true},	-- Shifting Tanzanite, red, blue, 5 str, 4 agi
	[30564] = {r = 4, [104] = true, [12] = true, [13] = true, [83] = true, [71] = true},	-- Shining Fire Opal, red, yellow, 6 spell, 5 hit
	[31117] = {r = 4, [104] = true, [12] = true, [11] = true, [83] = true, [63] = true},	-- Soothing Amethyst, red, blue, 11 spell, 6 stam
	[30546]	= {r = 4, [104] = true, [12] = true, [11] = true, [61] = true, [63]	= true},	-- Sovereign Tanzanite, red, blue, 5 str, 6 stam
	[30607] = {r = 4, [104] = true, [12] = true, [13] = true, [76] = true, [66] = true},	-- Splendid Fire Opal, red, yellow, 5 parry, 4 res
	[30554] = {r = 4, [104] = true, [12] = true, [13] = true, [75] = true, [74] = true},	-- Stalwart Fire Opal, red, yellow, 5 def, 4 dodge
	[30592] = {r = 4, [104] = true, [13] = true, [11] = true, [63] = true, [66] = true},	-- Steady Chrysoprase, yellow, blue, 6 stam, 5 res
	[30550] = {r = 4, [104] = true, [13] = true, [11] = true, [72] = true, [85] = true},	-- Sundered Chrysoprase, yellow, blue, 5 crit, 2 mp5
	[30583] = {r = 4, [104] = true, [13] = true, [11] = true, [64] = true, [63] = true},	-- Timeless Chrysoprase, yellow, blue, 5 int, 6 stam
	[30605] = {r = 4, [104] = true, [13] = true, [11] = true, [71] = true, [63] = true},	-- Vivid Chrysoprase, yellow, blue, 5 hit, 6 stam

	-- Added in Gem Helper v1.1
	[30552] = {r = 4, [104] = true, [12] = true, [11] = true, [83] = true, [63] = true},	-- Blessed Tanzanite, red, blue, 11 spell, 6 stam
	[30589] = {r = 4, [104] = true, [13] = true, [11] = true, [64] = true, [85] = true},	-- Dazzling Chrysoprase, yellow, blue, 5 int, 2 mp5
	[30582] = {r = 4, [104] = true, [12] = true, [13] = true, [73] = true, [72] = true},	-- Deadly Fire Opal, red, yellow, 8 atk power, 5 crit
	[30581] = {r = 4, [104] = true, [12] = true, [13] = true, [83] = true, [66] = true},	-- Durable Fire Opal, red, yellow, 11 spell, 4 res
	[30591] = {r = 4, [104] = true, [12] = true, [13] = true, [73] = true, [66] = true},	-- Empowered Fire Opal, red, yellow, 8 atk power, 5 res
	[30590] = {r = 4, [104] = true, [13] = true, [11] = true, [63] = true, [75] = true},	-- Enduring Chrysoprase, yellow, blue, 6 stam, 5 def
	[30572] = {r = 4, [104] = true, [12] = true, [11] = true, [65] = true, [83] = true},	-- Imperial Tanzanite, red, blue, 5 spi, 9 spell
	[30573] = {r = 4, [104] = true, [12] = true, [13] = true, [83] = true, [82] = true},	-- Mysterious Fire Opal, red, yellow, 6 spell, 5 spellpenet
	[30575] = {r = 4, [104] = true, [12] = true, [13] = true, [74] = true, [71] = true},	-- Nimble Fire Opal, red, yellow, 5 dodge, 4 hit
	[30588] = {r = 4, [104] = true, [12] = true, [13] = true, [83] = true, [72] = true},	-- Potent Fire Opal, red, yellow, 6 spell, 4 crit
	[30560] = {r = 4, [104] = true, [13] = true, [11] = true, [72] = true, [85] = true},	-- Rune Covered Chrysoprase, yellow, blue, 5 crit, 2 mp5

	-- Added in Gem Helper v1.2 (patch 2.1.1)
	[31863] = {r = 3, [101] = true, [36] = true, [12] = true, [11] = true, [73] = true, [63] = true},	-- Balanced Nightseye, red, blue, 8 atk power, 6 stam
	[31861] = {r = 3, [101] = true, [33] = true, [13] = true, [71] = true},		-- Great Dawnstone, yellow, 8 hit
	[31865] = {r = 3, [101] = true, [36] = true, [12] = true, [11] = true, [73] = true, [85] = true},	-- Infused Nightseye, red, blue, 8 atk power, 2 mp5
	[31867] = {r = 3, [101] = true, [35] = true, [13] = true, [12] = true, [71] = true, [83] = true},	-- Veiled Noble Topaz, red, yellow, 4 hit, 6 spell
	[31868] = {r = 3, [101] = true, [35] = true, [13] = true, [12] = true, [72] = true, [73] = true},	-- Wicked Noble Topaz, red, yellow, 4 crit, 8 atk power
	[32836] = {r = 3, [101] = true, [37] = true, [12] = true, [11] = true, [83] = true, [65] = true},	-- Purified Shadow Pearl, red, blue, 9 spell, 4 spi
	[32833] = {r = 2, [101] = true, [27] = true, [12] = true, [11] = true, [83] = true, [65] = true},	-- Purified Jaggal Pearl, red, blue, 7 spell, 3 spi
	[32409] = {r = 3, [101] = true, [42] = true, [14] = true, [62] = true},		-- Relentless Earthstorm Diamond, meta, 12 agi, 3% increased critical damage
	[32410] = {r = 3, [101] = true, [41] = true, [14] = true, [0] = true},		-- Thundering Skyfire Diamond, meta, Chance to increase melee/ranged attack speed

	-- Added in Gem Helper v1.3 (patch 2.1.3)
	[24053] = {r = 3, [101] = true, [33] = true, [13] = true, [66] = true},		-- Mystic Dawnstone, yellow, 8 res
	[32634] = {r = 3, [103] = true, [12] = true, [11] = true, [73] = true, [63] = true},	-- Unstable Amethyst, red, blue, 8 atk power, 6 stam
	[32635] = {r = 3, [103] = true, [13] = true, [11] = true, [64] = true, [63] = true},	-- Unstable Peridot, yellow, blue, 4 int, 6 stam
	[32636] = {r = 3, [103] = true, [12] = true, [11] = true, [83] = true, [65] = true},	-- Unstable Sapphire, red, blue, 9 spell, 4 spi
	[32637] = {r = 3, [103] = true, [12] = true, [13] = true, [73] = true, [72] = true},	-- Unstable Citrine, red, yellow, 8 atk power, 4 crit
	[32638] = {r = 3, [103] = true, [12] = true, [13] = true, [83] = true, [64] = true},	-- Unstable Topaz, red, yellow, 5 spell, 4 int
	[32639] = {r = 3, [103] = true, [11] = true, [13] = true, [63] = true, [72] = true},	-- Unstable Talasite, blue, yellow, 4 stam, 4 crit
	[32640] = {r = 3, [103] = true, [14] = true, [73] = true},	-- Potent Unstable Diamond, meta, 24 atk power, 5% stun resist
	[32641] = {r = 3, [103] = true, [14] = true, [83] = true},	-- Imbued Unstable Diamond, meta, 14 spell, 5% stun resist

	-- Added in Gem Helper v1.3 (patch 2.1.3)
	-- The following gems are crafted from epic gem drops in Black Temple/Hyjal
	[32193] = {r = 4, [101] = true, [52] = true, [12] = true, [61] = true},	-- Bold Crimson Spinel, red, 10 str
	[32194] = {r = 4, [101] = true, [52] = true, [12] = true, [62] = true},	-- Delicate Crimson Spinel, red, 10 agi
	[32195] = {r = 4, [101] = true, [52] = true, [12] = true, [83] = true},	-- Teardrop Crimson Spinel, red, 22 spell
	[32196] = {r = 4, [101] = true, [52] = true, [12] = true, [83] = true},	-- Runed Crimson Spinel, red, 12 spell
	[32197] = {r = 4, [101] = true, [52] = true, [12] = true, [73] = true},	-- Bright Crimson Spinel, red, 20 atk power
	[32198] = {r = 4, [101] = true, [52] = true, [12] = true, [74] = true},	-- Subtle Crimson Spinel, red, 10 dodge
	[32199] = {r = 4, [101] = true, [52] = true, [12] = true, [76] = true},	-- Flashing Crimson Spinel, red, 10 parry
	[32200] = {r = 4, [101] = true, [51] = true, [11] = true, [63] = true},	-- Solid Empyrean Sapphire, blue, 15 stam
	[32201] = {r = 4, [101] = true, [51] = true, [11] = true, [65] = true},	-- Sparkling Empyrean Sapphire, blue, 10 spi
	[32202] = {r = 4, [101] = true, [51] = true, [11] = true, [85] = true},	-- Lustrous Empyrean Sapphire, blue, 4 mp5
	[32203] = {r = 4, [101] = true, [51] = true, [11] = true, [82] = true},	-- Stormy Empyrean Sapphire, blue, 13 spellpene
	[32204] = {r = 4, [101] = true, [53] = true, [13] = true, [64] = true},	-- Brilliant Lionseye, yellow, 10 int
	[32205] = {r = 4, [101] = true, [53] = true, [13] = true, [72] = true},	-- Smooth Lionseye, yellow, 10 crit
	[32206] = {r = 4, [101] = true, [53] = true, [13] = true, [71] = true},	-- Rigid Lionseye, yellow, 10 hit
	[32207] = {r = 4, [101] = true, [53] = true, [13] = true, [72] = true},	-- Gleaming Lionseye, yellow, 10 crit
	[32208] = {r = 4, [101] = true, [53] = true, [13] = true, [75] = true},	-- Thick Lionseye, yellow, 10 def
	[32209] = {r = 4, [101] = true, [53] = true, [13] = true, [66] = true},	-- Mystic Lionseye, yellow, 10 res
	[32210] = {r = 4, [101] = true, [53] = true, [13] = true, [71] = true},	-- Great Lionseye, yellow, 10 hit
	[32211] = {r = 4, [101] = true, [56] = true, [12] = true, [11] = true, [61] = true, [63] = true},	-- Sovereign Shadowsong Amethyst, red, blue, 5 str, 7 stam
	[32212] = {r = 4, [101] = true, [56] = true, [12] = true, [11] = true, [62] = true, [63] = true},	-- Shifting Shadowsong Amethyst, red, blue, 5 agi, 7 stam
	[32213] = {r = 4, [101] = true, [56] = true, [12] = true, [11] = true, [73] = true, [63] = true},	-- Balanced Shadowsong Amethyst, red, blue, 10 atk power, 7 stam
	[32214] = {r = 4, [101] = true, [56] = true, [12] = true, [11] = true, [73] = true, [85] = true},	-- Infused Shadowsong Amethyst, red, blue, 10 atk power, 2 mp5
	[32215] = {r = 4, [101] = true, [56] = true, [12] = true, [11] = true, [83] = true, [63] = true},	-- Glowing Shadowsong Amethyst, red, blue, 6 spell, 7 stam
	[32216] = {r = 4, [101] = true, [56] = true, [12] = true, [11] = true, [83] = true, [85] = true},	-- Royal Shadowsong Amethyst, red, blue, 11 spell, 2 mp5
	[32217] = {r = 4, [101] = true, [55] = true, [12] = true, [13] = true, [72] = true, [61] = true},	-- Inscribed Pyrestone, red, yellow, 5 crit, 5 str
	[32218] = {r = 4, [101] = true, [55] = true, [12] = true, [13] = true, [72] = true, [83] = true},	-- Potent Pyrestone, red, yellow, 5 crit, 6 spell
	[32219] = {r = 4, [101] = true, [55] = true, [12] = true, [13] = true, [83] = true, [64] = true},	-- Luminous Pyrestone, red, yellow, 11 spell, 5 int
	[32220] = {r = 4, [101] = true, [55] = true, [12] = true, [13] = true, [71] = true, [62] = true},	-- Glinting Pyrestone, red, yellow, 5 hit, 5 agi
	[32221] = {r = 4, [101] = true, [55] = true, [12] = true, [13] = true, [71] = true, [83] = true},	-- Veiled Pyrestone, red, yellow, 5 hit, 6 spell
	[32222] = {r = 4, [101] = true, [55] = true, [12] = true, [13] = true, [72] = true, [73] = true},	-- Wicked Pyrestone, red, yellow, 5 crit, 10 atk power
	[32223] = {r = 4, [101] = true, [54] = true, [11] = true, [13] = true, [75] = true, [63] = true},	-- Enduring Seaspray Emerald, blue, yellow, 5 def, 7 stam
	[32224] = {r = 4, [101] = true, [54] = true, [11] = true, [13] = true, [72] = true, [82] = true},	-- Radiant Seaspray Emerald, blue, yellow, 5 crit, 6 spellpene
	[32225] = {r = 4, [101] = true, [54] = true, [11] = true, [13] = true, [64] = true, [85] = true},	-- Dazzling Seaspray Emerald, blue, yellow, 5 int, 2 mp5
	[32226] = {r = 4, [101] = true, [54] = true, [11] = true, [13] = true, [72] = true, [63] = true},	-- Jagged Seaspray Emerald, blue, yellow, 5 crit, 7 stam

	-- Added in Gem Helper v1.4 (patch 2.2.0)
	[33131] = {r = 5, [101] = true, [32] = true, [12] = true, [73] = true, [1013] = true},	-- Crimson Sun, red, 24 ap
	[33133] = {r = 5, [101] = true, [32] = true, [12] = true, [83] = true, [1013] = true},	-- Don Julio's Heart, red, 14 spell
	[33134] = {r = 5, [101] = true, [32] = true, [12] = true, [83] = true, [1013] = true},	-- Kailee's Rose, red, 26 spell
	[33135] = {r = 5, [101] = true, [31] = true, [11] = true, [63] = true, [1013] = true},	-- Falling Star, blue, 18 stam
	[33140] = {r = 5, [101] = true, [33] = true, [13] = true, [72] = true, [1013] = true},	-- Blood of Ember, yellow, 12 crit
	[33143] = {r = 5, [101] = true, [33] = true, [13] = true, [72] = true, [1013] = true},	-- Stone of Blades, yellow, 12 crit
	[33144] = {r = 5, [101] = true, [33] = true, [13] = true, [75] = true, [1013] = true},	-- Facet of Eternity, yellow, 12 def
	[33782] = {r = 3, [101] = true, [34] = true, [13] = true, [11] = true, [66] = true, [63] = true},	-- Steady Talasite, yellow, blue, 4 res, 6 stam

	-- Added in Gem Helper v1.41 (patch 2.2.2)
	[31862] = {r = 2, [101] = true, [26] = true, [12] = true, [11] = true, [73] = true, [63] = true},	-- Balanced Shadow Draenite, red, blue, 6 atk power, 4 stam
	[31860] = {r = 2, [101] = true, [23] = true, [13] = true, [71] = true},				-- Great Golden Draenite, yellow, 6 hit
	[31864] = {r = 2, [101] = true, [26] = true, [12] = true, [11] = true, [73] = true, [85] = true},	-- Infused Shadow Draenite, red, blue, 6 atk power, 1 mp5
	[31866] = {r = 2, [101] = true, [25] = true, [13] = true, [12] = true, [71] = true, [83] = true},	-- Veiled Flame Spessarite, red, yellow, 3 hit, 4 spell
	[31869] = {r = 2, [101] = true, [25] = true, [13] = true, [12] = true, [72] = true, [73] = true},	-- Wicked Flame Spessarite, red, yellow, 3 crit, 6 atk power

	-- Added in Gem Helper v1.5 (patch 2.3.0)
	[34220] = {r = 3, [101] = true, [41] = true, [14] = true, [72] = true},	-- Chaotic Skyfire Diamond, meta, +12 crit, +3% spell crit damage
	[34256] = {r = 4, [104] = true, [11] = true, [63] = true},	-- Charmed Amani Jewel, blue, 15 stam

	-- Added in Gem Helper v1.6 (patch 2.4.0)
	[35503] = {r = 3, [101] = true, [41] = true, [14] = true, [83] = true, [64] = true},	-- Ember Skyfire Diamond, meta, +14 spell, +2% int
	[35501] = {r = 3, [101] = true, [42] = true, [14] = true, [75] = true},	-- Eternal Earthstorm Diamond, meta, +12 def, +10% shieldblock
	[35707] = {r = 3, [101] = true, [36] = true, [12] = true, [11] = true, [74] = true, [63] = true},	-- Regal Nightseye, red, blue, 4 dodge, 6 stam
	[34831] = {r = 3, [104] = true, [11] = true, [63] = true},	-- Eye of the Sea, blue, 15 stam
	[35758] = {r = 4, [101] = true, [54] = true, [11] = true, [13] = true, [66] = true, [63] = true},	-- Steady Seaspray Emerald, blue, yellow, 5 res, 7 stam
	[35759] = {r = 4, [101] = true, [54] = true, [11] = true, [13] = true, [70] = true, [63] = true},	-- Forceful Seaspray Emerald, blue, yellow, 5 spellhaste, 7 stam
	[35760] = {r = 4, [101] = true, [55] = true, [12] = true, [13] = true, [70] = true, [83] = true},	-- Reckless Pyrestone, red, yellow, 5 spellhaste, 6 spell
	[35761] = {r = 4, [101] = true, [53] = true, [13] = true, [70] = true},	-- Quick Lionseye, yellow, 10 spellhaste

	-- Added in Gem Helper v1.7 (patch 2.4.2)
	[37503] = {r = 4, [101] = true, [56] = true, [12] = true, [11] = true, [83] = true, [65] = true},	-- Purified Shadowsong Amethyst, red, blue, 11 spell, 5 spi
	[35315] = {r = 3, [101] = true, [33] = true, [13] = true, [70] = true},	-- Quick Dawnstone, yellow, 8 spellhaste
	[35316] = {r = 3, [101] = true, [35] = true, [13] = true, [12] = true, [70] = true, [83] = true},	-- Reckless Noble Topaz, red, yellow, 4 spellhaste, 5 spell
	[35318] = {r = 3, [101] = true, [34] = true, [13] = true, [11] = true, [70] = true, [63] = true},	-- Forceful Talasite, yellow, blue, 4 spellhaste, 6 stam

	-- Sunwell BoP quest rewards from "Hard to Kill" - http://www.wowhead.com/?quest=11492
	--[35487] = {r = 4, [104] = true, [52] = true, [12] = true, [73] = true},	-- Bright Crimson Spinel, red, 20 atk power
	--[35488] = {r = 4, [104] = true, [52] = true, [12] = true, [83] = true},	-- Runed Crimson Spinel, red, 12 spell
	--[35489] = {r = 4, [104] = true, [52] = true, [12] = true, [83] = true},	-- Teardrop Crimson Spinel, red, 22 spell

	--[[
	The following epic quality gems exist in game (you can sniff their itemIDs), but nobody knows how to obtain the recipes to craft them.
	[33132]-- Delicate Fire Ruby, red, 12 agi
	[33136]-- Nothing
	[33137]-- Sparkling Falling Star, blue, 12 spi
	[33138]-- Mystic Bladestone, yellow, 12 res
	[33139]-- Brilliant Bladestone, yellow, 12 int
	[33141]-- Great Bladestone, yellow, 12 hit
	[33142]-- Rigid Bladestone, yellow, 12 hit
	]]

	-- Added in Gem Helper v1.8.0 (patch 3.0.3)
	-- Crafted Uncommon Quality Gems
	[39927] = {r = 11, [101] = true, [121] = true, [11] = true, [85] = true},	-- Lustrous Chalcedony, blue, 5 mp5
	[39919] = {r = 11, [101] = true, [121] = true, [11] = true, [63] = true},	-- Solid Chalcedony, blue, 18 stam
	[39920] = {r = 11, [101] = true, [121] = true, [11] = true, [65] = true},	-- Sparkling Chalcedony, blue, 12 spi
	[39932] = {r = 11, [101] = true, [121] = true, [11] = true, [82] = true},	-- Stormy Chalcedony, blue, 15 spellpenet

	[39900] = {r = 11, [101] = true, [122] = true, [12] = true, [61] = true},	-- Bold Bloodstone, red, 12 str
	[39906] = {r = 11, [101] = true, [122] = true, [12] = true, [73] = true},	-- Bright Bloodstone, red, 24 atk pwr
	[39905] = {r = 11, [101] = true, [122] = true, [12] = true, [62] = true},	-- Delicate Bloodstone, red, 12 agi
	[39908] = {r = 11, [101] = true, [122] = true, [12] = true, [76] = true},	-- Flashing Bloodstone, red, 12 parry
	[39909] = {r = 11, [101] = true, [122] = true, [12] = true, [81] = true},	-- Fractured Bloodstone, red, 12 armorpenet
	[39910] = {r = 11, [101] = true, [122] = true, [12] = true, [84] = true},	-- Precise Bloodstone, red, 12 expert
	[39911] = {r = 11, [101] = true, [122] = true, [12] = true, [83] = true},	-- Runed Bloodstone, red, 14 spell
	[39907] = {r = 11, [101] = true, [122] = true, [12] = true, [74] = true},	-- Subtle Bloodstone, red, 12 dodge

	[39912] = {r = 11, [101] = true, [123] = true, [13] = true, [64] = true},	-- Brilliant Sun Crystal, yellow, 12 int
	[39917] = {r = 11, [101] = true, [123] = true, [13] = true, [66] = true},	-- Mystic Sun Crystal, yellow, 12 res
	[39918] = {r = 11, [101] = true, [123] = true, [13] = true, [70] = true},	-- Quick Sun Crystal, yellow, 12 haste
	[39915] = {r = 11, [101] = true, [123] = true, [13] = true, [71] = true},	-- Rigid Sun Crystal, yellow, 12 hit
	[39914] = {r = 11, [101] = true, [123] = true, [13] = true, [72] = true},	-- Smooth Sun Crystal, yellow, 12 crit
	[39916] = {r = 11, [101] = true, [123] = true, [13] = true, [75] = true},	-- Thick Sun Crystal, yellow, 12 def

	[39984] = {r = 11, [101] = true, [124] = true, [13] = true, [11] = true, [64] = true, [85] = true},	-- Dazzling Dark Jade, yellow, blue, 6 int, 2 mp5
	[39976] = {r = 11, [101] = true, [124] = true, [13] = true, [11] = true, [75] = true, [63] = true},	-- Enduring Dark Jade, yellow, blue, 6 def, 9 stam
	[39989] = {r = 11, [101] = true, [124] = true, [13] = true, [11] = true, [70] = true, [85] = true},	-- Energized Dark Jade, yellow, blue, 6 haste, 2 mp5
	[39978] = {r = 11, [101] = true, [124] = true, [13] = true, [11] = true, [70] = true, [63] = true},	-- Forceful Dark Jade, yellow, blue, 6 haste, 9 stam
	[39983] = {r = 11, [101] = true, [124] = true, [13] = true, [11] = true, [70] = true, [65] = true},	-- Intricate Dark Jade, yellow, blue, 6 haste, 6 spi
	[39974] = {r = 11, [101] = true, [124] = true, [13] = true, [11] = true, [72] = true, [63] = true},	-- Jagged Dark Jade, yellow, blue, 6 crit, 9 stam
	[39986] = {r = 11, [101] = true, [124] = true, [13] = true, [11] = true, [71] = true, [85] = true},	-- Lambert Dark Jade, yellow, blue, 6 hit, 2 mp5
	[39980] = {r = 11, [101] = true, [124] = true, [13] = true, [11] = true, [72] = true, [65] = true},	-- Misty Dark Jade, yellow, blue, 6 crit, 6 spi
	[39988] = {r = 11, [101] = true, [124] = true, [13] = true, [11] = true, [66] = true, [85] = true},	-- Opaque Dark Jade, yellow, blue, 6 res, 2 mp5
	[39990] = {r = 11, [101] = true, [124] = true, [13] = true, [11] = true, [72] = true, [82] = true},	-- Radiant Dark Jade, yellow, blue, 6 crit, 8 spellpenet
	[39979] = {r = 11, [101] = true, [124] = true, [13] = true, [11] = true, [64] = true, [65] = true},	-- Seer's Dark Jade, yellow, blue, 6 int, 6 spi
	[39992] = {r = 11, [101] = true, [124] = true, [13] = true, [11] = true, [70] = true, [82] = true},	-- Shattered Dark Jade, yellow, blue, 6 haste, 8 spellpenet
	[39981] = {r = 11, [101] = true, [124] = true, [13] = true, [11] = true, [71] = true, [65] = true},	-- Shining Dark Jade, yellow, blue, 6 hit, 6 spi
	[39977] = {r = 11, [101] = true, [124] = true, [13] = true, [11] = true, [66] = true, [63] = true},	-- Steady Dark Jade, yellow, blue, 6 res, 9 stam
	[39985] = {r = 11, [101] = true, [124] = true, [13] = true, [11] = true, [72] = true, [85] = true},	-- Sundered Dark Jade, yellow, blue, 6 crit, 2 mp5
	[39991] = {r = 11, [101] = true, [124] = true, [13] = true, [11] = true, [71] = true, [82] = true},	-- Tense Dark Jade, yellow, blue, 6 hit, 8 spellpenet
	[39968] = {r = 11, [101] = true, [124] = true, [13] = true, [11] = true, [64] = true, [63] = true},	-- Timeless Dark Jade, yellow, blue, 6 int, 9 stam
	[39982] = {r = 11, [101] = true, [124] = true, [13] = true, [11] = true, [66] = true, [65] = true},	-- Turbid Dark Jade, yellow, blue, 6 res, 6 spi
	[39975] = {r = 11, [101] = true, [124] = true, [13] = true, [11] = true, [71] = true, [63] = true},	-- Vivid Dark Jade, yellow, blue, 6 hit, 9 stam

	[39966] = {r = 11, [101] = true, [125] = true, [13] = true, [12] = true, [84] = true, [71] = true},	-- Accurate Huge Citrine, yellow, red, 6 expert, 6 hit
	[39949] = {r = 11, [101] = true, [125] = true, [13] = true, [12] = true, [61] = true, [75] = true},	-- Champion's Huge Citrine, yellow, red, 6 str, 6 def
	[39952] = {r = 11, [101] = true, [125] = true, [13] = true, [12] = true, [62] = true, [72] = true},	-- Deadly Huge Citrine, yellow, red, 6 agi, 6 crit
	[39955] = {r = 11, [101] = true, [125] = true, [13] = true, [12] = true, [62] = true, [70] = true},	-- Deft Huge Citrine, yellow, red, 6 agi, 6 haste
	[39958] = {r = 11, [101] = true, [125] = true, [13] = true, [12] = true, [83] = true, [66] = true},	-- Durable Huge Citrine, yellow, red, 7 spell, 6 res
	[39962] = {r = 11, [101] = true, [125] = true, [13] = true, [12] = true, [73] = true, [66] = true},	-- Empowered Huge Citrine, yellow, red, 12 atk pwr, 6 res
	[39948] = {r = 11, [101] = true, [125] = true, [13] = true, [12] = true, [61] = true, [71] = true},	-- Etched Huge Citrine, yellow, red, 6 str, 6 hit
	[39951] = {r = 11, [101] = true, [125] = true, [13] = true, [12] = true, [61] = true, [70] = true},	-- Fierce Huge Citrine, yellow, red, 6 str, 6 haste
	[39965] = {r = 11, [101] = true, [125] = true, [13] = true, [12] = true, [76] = true, [75] = true},	-- Glimmering Huge Citrine, yellow, red, 6 parry, 6 def
	[39953] = {r = 11, [101] = true, [125] = true, [13] = true, [12] = true, [62] = true, [71] = true},	-- Glinting Huge Citrine, yellow, red, 6 agi, 6 hit
	[39947] = {r = 11, [101] = true, [125] = true, [13] = true, [12] = true, [61] = true, [72] = true},	-- Inscribed Huge Citrine, yellow, red, 6 str, 6 crit
	[39954] = {r = 11, [101] = true, [125] = true, [13] = true, [12] = true, [62] = true, [66] = true},	-- Lucent Huge Citrine, yellow, red, 6 agi, 6 res
	[39946] = {r = 11, [101] = true, [125] = true, [13] = true, [12] = true, [83] = true, [64] = true},	-- Luminous Huge Citrine, yellow, red, 7 spell, 6 int
	[39956] = {r = 11, [101] = true, [125] = true, [13] = true, [12] = true, [83] = true, [72] = true},	-- Potent Huge Citrine, yellow, red, 7 spell, 6 crit
	[39961] = {r = 11, [101] = true, [125] = true, [13] = true, [12] = true, [73] = true, [71] = true},	-- Pristine Huge Citrine, yellow, red, 12 atk pwr, 6 hit
	[39959] = {r = 11, [101] = true, [125] = true, [13] = true, [12] = true, [83] = true, [70] = true},	-- Reckless Huge Citrine, yellow, red, 7 spell, 6 haste
	[39967] = {r = 11, [101] = true, [125] = true, [13] = true, [12] = true, [84] = true, [75] = true},	-- Resolute Huge Citrine, yellow, red, 6 expert, 6 def
	[39950] = {r = 11, [101] = true, [125] = true, [13] = true, [12] = true, [61] = true, [66] = true},	-- Resplendent Huge Citrine, yellow, red, 6 str, 6 res
	[39964] = {r = 11, [101] = true, [125] = true, [13] = true, [12] = true, [74] = true, [75] = true},	-- Stalwart Huge Citrine, yellow, red, 6 dodge, 6 def
	[39963] = {r = 11, [101] = true, [125] = true, [13] = true, [12] = true, [73] = true, [70] = true},	-- Stark Huge Citrine, yellow, red, 12 atk pwr, 6 haste
	[39957] = {r = 11, [101] = true, [125] = true, [13] = true, [12] = true, [83] = true, [71] = true},	-- Veiled Huge Citrine, yellow, red, 7 spell, 6 hit
	[39960] = {r = 11, [101] = true, [125] = true, [13] = true, [12] = true, [73] = true, [72] = true},	-- Wicked Huge Citrine, yellow, red, 12 atk pwr, 6 crit

	[39937] = {r = 11, [101] = true, [126] = true, [12] = true, [11] = true, [73] = true, [63] = true},	-- Balanced Shadow Crystal, red, blue, 12 atk pwr, 9 stam
	[39939] = {r = 11, [101] = true, [126] = true, [12] = true, [11] = true, [76] = true, [63] = true},	-- Defender's Shadow Crystal, red, blue, 6 parry, 9 stam
	[39936] = {r = 11, [101] = true, [126] = true, [12] = true, [11] = true, [83] = true, [63] = true},	-- Glowing Shadow Crystal, red, blue, 7 spell, 9 stam
	[39940] = {r = 11, [101] = true, [126] = true, [12] = true, [11] = true, [84] = true, [63] = true},	-- Guardian Shadow Crystal, red, blue, 6 expert, 9 stam
	[39944] = {r = 11, [101] = true, [126] = true, [12] = true, [11] = true, [73] = true, [85] = true},	-- Infused Shadow Crystal, red, blue, 12 atk pwr, 2 mp5
	[39945] = {r = 11, [101] = true, [126] = true, [12] = true, [11] = true, [83] = true, [82] = true},	-- Mysterious Shadow Crystal, red, blue, 7 spell, 8 spellpenet
	[39933] = {r = 11, [101] = true, [126] = true, [12] = true, [11] = true, [81] = true, [63] = true},	-- Puissant Shadow Crystal, red, blue, 6 armorpenet, 9 stam
	[39941] = {r = 11, [101] = true, [126] = true, [12] = true, [11] = true, [83] = true, [65] = true},	-- Purified Shadow Crystal, red, blue, 7 spell, 6 spi
	[39938] = {r = 11, [101] = true, [126] = true, [12] = true, [11] = true, [74] = true, [63] = true},	-- Regal Shadow Crystal, red, blue, 6 dodge, 9 stam
	[39943] = {r = 11, [101] = true, [126] = true, [12] = true, [11] = true, [83] = true, [85] = true},	-- Royal Shadow Crystal, red, blue, 7 spell, 2 mp5
	[39935] = {r = 11, [101] = true, [126] = true, [12] = true, [11] = true, [62] = true, [63] = true},	-- Shifting Shadow Crystal, red, blue, 6 agi, 9 stam
	[39934] = {r = 11, [101] = true, [126] = true, [12] = true, [11] = true, [61] = true, [63] = true},	-- Sovereign Shadow Crystal, red, blue, 6 str, 9 stam
	[39942] = {r = 11, [101] = true, [126] = true, [12] = true, [11] = true, [62] = true, [85] = true},	-- Tenuous Shadow Crystal, red, blue, 6 agi, 2 mp5

	[42701] = {r = 11, [101] = true, [127] = true, [11] = true, [12] = true, [13] = true, [61] = true, [62] = true, [63] = true, [64] = true, [65] = true},	-- Enchanted Pearl, red, yellow, blue, 4 stats

	-- Crafted Uncommon Perfect Quality Gems
	[41440] = {r = 12, [101] = true, [121] = true, [11] = true, [85] = true},	-- Perfect Lustrous Chalcedony, blue, 6 mp5
	[41441] = {r = 12, [101] = true, [121] = true, [11] = true, [63] = true},	-- Perfect Solid Chalcedony, blue, 21 stam
	[41442] = {r = 12, [101] = true, [121] = true, [11] = true, [65] = true},	-- Perfect Sparkling Chalcedony, blue, 14 spi
	[41443] = {r = 12, [101] = true, [121] = true, [11] = true, [82] = true},	-- Perfect Stormy Chalcedony, blue, 18 spellpenet

	[41432] = {r = 12, [101] = true, [122] = true, [12] = true, [61] = true},	-- Perfect Bold Bloodstone, red, 14 str
	[41433] = {r = 12, [101] = true, [122] = true, [12] = true, [73] = true},	-- Perfect Bright Bloodstone, red, 28 atk pwr
	[41434] = {r = 12, [101] = true, [122] = true, [12] = true, [62] = true},	-- Perfect Delicate Bloodstone, red, 14 agi
	[41435] = {r = 12, [101] = true, [122] = true, [12] = true, [76] = true},	-- Perfect Flashing Bloodstone, red, 14 parry
	[41436] = {r = 12, [101] = true, [122] = true, [12] = true, [81] = true},	-- Perfect Fractured Bloodstone, red, 14 armorpenet
	[41437] = {r = 12, [101] = true, [122] = true, [12] = true, [84] = true},	-- Perfect Precise Bloodstone, red, 14 expert
	[41438] = {r = 12, [101] = true, [122] = true, [12] = true, [83] = true},	-- Perfect Runed Bloodstone, red, 16 spell
	[41439] = {r = 12, [101] = true, [122] = true, [12] = true, [74] = true},	-- Perfect Subtle Bloodstone, red, 14 dodge

	[41444] = {r = 12, [101] = true, [123] = true, [13] = true, [64] = true},	-- Perfect Brilliant Sun Crystal, yellow, 14 int
	[41445] = {r = 12, [101] = true, [123] = true, [13] = true, [66] = true},	-- Perfect Mystic Sun Crystal, yellow, 14 res
	[41446] = {r = 12, [101] = true, [123] = true, [13] = true, [70] = true},	-- Perfect Quick Sun Crystal, yellow, 14 haste
	[41447] = {r = 12, [101] = true, [123] = true, [13] = true, [71] = true},	-- Perfect Rigid Sun Crystal, yellow, 14 hit
	[41448] = {r = 12, [101] = true, [123] = true, [13] = true, [72] = true},	-- Perfect Smooth Sun Crystal, yellow, 14 crit
	[41449] = {r = 12, [101] = true, [123] = true, [13] = true, [75] = true},	-- Perfect Thick Sun Crystal, yellow, 14 def

	[41463] = {r = 12, [101] = true, [124] = true, [13] = true, [11] = true, [64] = true, [85] = true},	-- Perfect Dazzling Dark Jade, yellow, blue, 7 int, 3 mp5
	[41464] = {r = 12, [101] = true, [124] = true, [13] = true, [11] = true, [75] = true, [63] = true},	-- Perfect Enduring Dark Jade, yellow, blue, 7 def, 11 stam
	[41465] = {r = 12, [101] = true, [124] = true, [13] = true, [11] = true, [70] = true, [85] = true},	-- Perfect Energized Dark Jade, yellow, blue, 7 haste, 3 mp5
	[41466] = {r = 12, [101] = true, [124] = true, [13] = true, [11] = true, [70] = true, [63] = true},	-- Perfect Forceful Dark Jade, yellow, blue, 7 haste, 11 stam
	[41467] = {r = 12, [101] = true, [124] = true, [13] = true, [11] = true, [70] = true, [65] = true},	-- Perfect Intricate Dark Jade, yellow, blue, 7 haste, 7 spi
	[41468] = {r = 12, [101] = true, [124] = true, [13] = true, [11] = true, [72] = true, [63] = true},	-- Perfect Jagged Dark Jade, yellow, blue, 7 crit, 11 stam
	[41469] = {r = 12, [101] = true, [124] = true, [13] = true, [11] = true, [71] = true, [85] = true},	-- Perfect Lambert Dark Jade, yellow, blue, 7 hit, 3 mp5
	[41470] = {r = 12, [101] = true, [124] = true, [13] = true, [11] = true, [72] = true, [65] = true},	-- Perfect Misty Dark Jade, yellow, blue, 7 crit, 7 spi
	[41471] = {r = 12, [101] = true, [124] = true, [13] = true, [11] = true, [66] = true, [85] = true},	-- Perfect Opaque Dark Jade, yellow, blue, 7 res, 3 mp5
	[41472] = {r = 12, [101] = true, [124] = true, [13] = true, [11] = true, [72] = true, [82] = true},	-- Perfect Radiant Dark Jade, yellow, blue, 7 crit, 9 spellpenet
	[41473] = {r = 12, [101] = true, [124] = true, [13] = true, [11] = true, [64] = true, [65] = true},	-- Perfect Seer's Dark Jade, yellow, blue, 7 int, 7 spi
	[41474] = {r = 12, [101] = true, [124] = true, [13] = true, [11] = true, [70] = true, [82] = true},	-- Perfect Shattered Dark Jade, yellow, blue, 7 haste, 9 spellpenet
	[41475] = {r = 12, [101] = true, [124] = true, [13] = true, [11] = true, [71] = true, [65] = true},	-- Perfect Shining Dark Jade, yellow, blue, 7 hit, 7 spi
	[41476] = {r = 12, [101] = true, [124] = true, [13] = true, [11] = true, [66] = true, [63] = true},	-- Perfect Steady Dark Jade, yellow, blue, 7 res, 11 stam
	[41477] = {r = 12, [101] = true, [124] = true, [13] = true, [11] = true, [72] = true, [85] = true},	-- Perfect Sundered Dark Jade, yellow, blue, 7 crit, 3 mp5
	[41478] = {r = 12, [101] = true, [124] = true, [13] = true, [11] = true, [71] = true, [82] = true},	-- Perfect Tense Dark Jade, yellow, blue, 7 hit, 9 spellpenet
	[41479] = {r = 12, [101] = true, [124] = true, [13] = true, [11] = true, [64] = true, [63] = true},	-- Perfect Timeless Dark Jade, yellow, blue, 7 int, 11 stam
	[41480] = {r = 12, [101] = true, [124] = true, [13] = true, [11] = true, [66] = true, [65] = true},	-- Perfect Turbid Dark Jade, yellow, blue, 7 res, 7 spi
	[41481] = {r = 12, [101] = true, [124] = true, [13] = true, [11] = true, [71] = true, [63] = true},	-- Perfect Vivid Dark Jade, yellow, blue, 7 hit, 11 stam

	[41482] = {r = 12, [101] = true, [125] = true, [13] = true, [12] = true, [84] = true, [71] = true},	-- Perfect Accurate Huge Citrine, yellow, red, 7 expert, 7 hit
	[41483] = {r = 12, [101] = true, [125] = true, [13] = true, [12] = true, [61] = true, [75] = true},	-- Perfect Champion's Huge Citrine, yellow, red, 7 str, 7 def
	[41484] = {r = 12, [101] = true, [125] = true, [13] = true, [12] = true, [62] = true, [72] = true},	-- Perfect Deadly Huge Citrine, yellow, red, 7 agi, 7 crit
	[41485] = {r = 12, [101] = true, [125] = true, [13] = true, [12] = true, [62] = true, [70] = true},	-- Perfect Deft Huge Citrine, yellow, red, 7 agi, 7 haste
	[41486] = {r = 12, [101] = true, [125] = true, [13] = true, [12] = true, [83] = true, [66] = true},	-- Perfect Durable Huge Citrine, yellow, red, 8 spell, 7 res
	[41487] = {r = 12, [101] = true, [125] = true, [13] = true, [12] = true, [73] = true, [66] = true},	-- Perfect Empowered Huge Citrine, yellow, red, 14 atk pwr, 7 res
	[41488] = {r = 12, [101] = true, [125] = true, [13] = true, [12] = true, [61] = true, [71] = true},	-- Perfect Etched Huge Citrine, yellow, red, 7 str, 7 hit
	[41489] = {r = 12, [101] = true, [125] = true, [13] = true, [12] = true, [61] = true, [70] = true},	-- Perfect Fierce Huge Citrine, yellow, red, 7 str, 7 haste
	[41490] = {r = 12, [101] = true, [125] = true, [13] = true, [12] = true, [76] = true, [75] = true},	-- Perfect Glimmering Huge Citrine, yellow, red, 7 parry, 7 def
	[41491] = {r = 12, [101] = true, [125] = true, [13] = true, [12] = true, [62] = true, [71] = true},	-- Perfect Glinting Huge Citrine, yellow, red, 7 agi, 7 hit
	[41492] = {r = 12, [101] = true, [125] = true, [13] = true, [12] = true, [61] = true, [72] = true},	-- Perfect Inscribed Huge Citrine, yellow, red, 7 str, 7 crit
	[41493] = {r = 12, [101] = true, [125] = true, [13] = true, [12] = true, [62] = true, [66] = true},	-- Perfect Lucent Huge Citrine, yellow, red, 7 agi, 7 res
	[41494] = {r = 12, [101] = true, [125] = true, [13] = true, [12] = true, [83] = true, [64] = true},	-- Perfect Luminous Huge Citrine, yellow, red, 8 spell, 7 int
	[41495] = {r = 12, [101] = true, [125] = true, [13] = true, [12] = true, [83] = true, [72] = true},	-- Perfect Potent Huge Citrine, yellow, red, 8 spell, 7 crit
	[41496] = {r = 12, [101] = true, [125] = true, [13] = true, [12] = true, [73] = true, [71] = true},	-- Perfect Pristine Huge Citrine, yellow, red, 14 atk pwr, 7 hit
	[41497] = {r = 12, [101] = true, [125] = true, [13] = true, [12] = true, [83] = true, [70] = true},	-- Perfect Reckless Huge Citrine, yellow, red, 8 spell, 7 haste
	[41498] = {r = 12, [101] = true, [125] = true, [13] = true, [12] = true, [84] = true, [75] = true},	-- Perfect Resolute Huge Citrine, yellow, red, 7 expert, 7 def
	[41499] = {r = 12, [101] = true, [125] = true, [13] = true, [12] = true, [61] = true, [66] = true},	-- Perfect Resplendent Huge Citrine, yellow, red, 7 str, 7 res
	[41500] = {r = 12, [101] = true, [125] = true, [13] = true, [12] = true, [74] = true, [75] = true},	-- Perfect Stalwart Huge Citrine, yellow, red, 7 dodge, 7 def
	[41501] = {r = 12, [101] = true, [125] = true, [13] = true, [12] = true, [73] = true, [70] = true},	-- Perfect Stark Huge Citrine, yellow, red, 14 atk pwr, 7 haste
	[41502] = {r = 12, [101] = true, [125] = true, [13] = true, [12] = true, [83] = true, [71] = true},	-- Perfect Veiled Huge Citrine, yellow, red, 8 spell, 7 hit
	[41429] = {r = 12, [101] = true, [125] = true, [13] = true, [12] = true, [73] = true, [72] = true},	-- Perfect Wicked Huge Citrine, yellow, red, 14 atk pwr, 7 crit

	[41450] = {r = 12, [101] = true, [126] = true, [12] = true, [11] = true, [73] = true, [63] = true},	-- Perfect Balanced Shadow Crystal, red, blue, 14 atk pwr, 11 stam
	[41451] = {r = 12, [101] = true, [126] = true, [12] = true, [11] = true, [76] = true, [63] = true},	-- Perfect Defender's Shadow Crystal, red, blue, 7 parry, 11 stam
	[41452] = {r = 12, [101] = true, [126] = true, [12] = true, [11] = true, [83] = true, [63] = true},	-- Perfect Glowing Shadow Crystal, red, blue, 8 spell, 11 stam
	[41453] = {r = 12, [101] = true, [126] = true, [12] = true, [11] = true, [84] = true, [63] = true},	-- Perfect Guardian Shadow Crystal, red, blue, 7 expert, 11 stam
	[41454] = {r = 12, [101] = true, [126] = true, [12] = true, [11] = true, [73] = true, [85] = true},	-- Perfect Infused Shadow Crystal, red, blue, 14 atk pwr, 3 mp5
	[41455] = {r = 12, [101] = true, [126] = true, [12] = true, [11] = true, [83] = true, [82] = true},	-- Perfect Mysterious Shadow Crystal, red, blue, 8 spell, 8 spellpenet
	[41456] = {r = 12, [101] = true, [126] = true, [12] = true, [11] = true, [81] = true, [63] = true},	-- Perfect Puissant Shadow Crystal, red, blue, 7 armorpenet, 11 stam
	[41457] = {r = 12, [101] = true, [126] = true, [12] = true, [11] = true, [83] = true, [65] = true},	-- Perfect Purified Shadow Crystal, red, blue, 8 spell, 7 spi
	[41458] = {r = 12, [101] = true, [126] = true, [12] = true, [11] = true, [74] = true, [63] = true},	-- Perfect Regal Shadow Crystal, red, blue, 7 dodge, 11 stam
	[41459] = {r = 12, [101] = true, [126] = true, [12] = true, [11] = true, [83] = true, [85] = true},	-- Perfect Royal Shadow Crystal, red, blue, 8 spell, 3 mp5
	[41460] = {r = 12, [101] = true, [126] = true, [12] = true, [11] = true, [62] = true, [63] = true},	-- Perfect Shifting Shadow Crystal, red, blue, 7 agi, 11 stam
	[41461] = {r = 12, [101] = true, [126] = true, [12] = true, [11] = true, [61] = true, [63] = true},	-- Perfect Sovereign Shadow Crystal, red, blue, 7 str, 11 stam
	[41462] = {r = 12, [101] = true, [126] = true, [12] = true, [11] = true, [62] = true, [85] = true},	-- Perfect Tenuous Shadow Crystal, red, blue, 7 agi, 3 mp5

	-- Crafted Rare Quality Gems
	[40010] = {r = 13, [101] = true, [131] = true, [11] = true, [85] = true},	-- Lustrous Sky Sapphire, blue, 6 mp5
	[40008] = {r = 13, [101] = true, [131] = true, [11] = true, [63] = true},	-- Solid Sky Sapphire, blue, 24 stam
	[40009] = {r = 13, [101] = true, [131] = true, [11] = true, [65] = true},	-- Sparkling Sky Sapphire, blue, 16 spi
	[40011] = {r = 13, [101] = true, [131] = true, [11] = true, [82] = true},	-- Stormy Sky Sapphire, blue, 20 spellpenet

	[39996] = {r = 13, [101] = true, [132] = true, [12] = true, [61] = true},	-- Bold Scarlet Ruby, red, 16 str
	[39999] = {r = 13, [101] = true, [132] = true, [12] = true, [73] = true},	-- Bright Scarlet Ruby, red, 32 atk pwr
	[39997] = {r = 13, [101] = true, [132] = true, [12] = true, [62] = true},	-- Delicate Scarlet Ruby, red, 16 agi
	[40001] = {r = 13, [101] = true, [132] = true, [12] = true, [76] = true},	-- Flashing Scarlet Ruby, red, 16 parry
	[40002] = {r = 13, [101] = true, [132] = true, [12] = true, [81] = true},	-- Fractured Scarlet Ruby, red, 16 armorpenet
	[40003] = {r = 13, [101] = true, [132] = true, [12] = true, [84] = true},	-- Precise Scarlet Ruby, red, 16 expert
	[39998] = {r = 13, [101] = true, [132] = true, [12] = true, [83] = true},	-- Runed Scarlet Ruby, red, 19 spell
	[40000] = {r = 13, [101] = true, [132] = true, [12] = true, [74] = true},	-- Subtle Scarlet Ruby, red, 16 dodge

	[40012] = {r = 13, [101] = true, [133] = true, [13] = true, [64] = true},	-- Brilliant Autumn's Glow, yellow, 16 int
	[40016] = {r = 13, [101] = true, [133] = true, [13] = true, [66] = true},	-- Mystic Autumn's Glow, yellow, 16 res
	[40017] = {r = 13, [101] = true, [133] = true, [13] = true, [70] = true},	-- Quick Autumn's Glow, yellow, 16 haste
	[40014] = {r = 13, [101] = true, [133] = true, [13] = true, [71] = true},	-- Rigid Autumn's Glow, yellow, 16 hit
	[40013] = {r = 13, [101] = true, [133] = true, [13] = true, [72] = true},	-- Smooth Autumn's Glow, yellow, 16 crit
	[40015] = {r = 13, [101] = true, [133] = true, [13] = true, [75] = true},	-- Thick Autumn's Glow, yellow, 16 def

	[40094] = {r = 13, [101] = true, [134] = true, [13] = true, [11] = true, [64] = true, [85] = true},	-- Dazzling Forest Emerald, yellow, blue, 8 int, 3 mp5
	[40089] = {r = 13, [101] = true, [134] = true, [13] = true, [11] = true, [75] = true, [63] = true},	-- Enduring Forest Emerald, yellow, blue, 8 def, 12 stam
	[40105] = {r = 13, [101] = true, [134] = true, [13] = true, [11] = true, [70] = true, [85] = true},	-- Energized Forest Emerald, yellow, blue, 8 haste, 3 mp5
	[40091] = {r = 13, [101] = true, [134] = true, [13] = true, [11] = true, [70] = true, [63] = true},	-- Forceful Forest Emerald, yellow, blue, 8 haste, 12 stam
	[40104] = {r = 13, [101] = true, [134] = true, [13] = true, [11] = true, [70] = true, [65] = true},	-- Intricate Forest Emerald, yellow, blue, 8 haste, 8 spi
	[40086] = {r = 13, [101] = true, [134] = true, [13] = true, [11] = true, [72] = true, [63] = true},	-- Jagged Forest Emerald, yellow, blue, 8 crit, 12 stam
	[40100] = {r = 13, [101] = true, [134] = true, [13] = true, [11] = true, [71] = true, [85] = true},	-- Lambert Forest Emerald, yellow, blue, 8 hit, 3 mp5
	[40095] = {r = 13, [101] = true, [134] = true, [13] = true, [11] = true, [72] = true, [65] = true},	-- Misty Forest Emerald, yellow, blue, 8 crit, 8 spi
	[40103] = {r = 13, [101] = true, [134] = true, [13] = true, [11] = true, [66] = true, [85] = true},	-- Opaque Forest Emerald, yellow, blue, 8 res, 3 mp5
	[40098] = {r = 13, [101] = true, [134] = true, [13] = true, [11] = true, [72] = true, [82] = true},	-- Radiant Forest Emerald, yellow, blue, 8 crit, 10 spellpenet
	[40092] = {r = 13, [101] = true, [134] = true, [13] = true, [11] = true, [64] = true, [65] = true},	-- Seer's Forest Emerald, yellow, blue, 8 int, 8 spi
	[40106] = {r = 13, [101] = true, [134] = true, [13] = true, [11] = true, [70] = true, [82] = true},	-- Shattered Forest Emerald, yellow, blue, 8 haste, 10 spellpenet
	[40099] = {r = 13, [101] = true, [134] = true, [13] = true, [11] = true, [71] = true, [65] = true},	-- Shining Forest Emerald, yellow, blue, 8 hit, 8 spi
	[40090] = {r = 13, [101] = true, [134] = true, [13] = true, [11] = true, [66] = true, [63] = true},	-- Steady Forest Emerald, yellow, blue, 8 res, 12 stam
	[40096] = {r = 13, [101] = true, [134] = true, [13] = true, [11] = true, [72] = true, [85] = true},	-- Sundered Forest Emerald, yellow, blue, 8 crit, 3 mp5
	[40101] = {r = 13, [101] = true, [134] = true, [13] = true, [11] = true, [71] = true, [82] = true},	-- Tense Forest Emerald, yellow, blue, 8 hit, 10 spellpenet
	[40085] = {r = 13, [101] = true, [134] = true, [13] = true, [11] = true, [64] = true, [63] = true},	-- Timeless Forest Emerald, yellow, blue, 8 int, 12 stam
	[40102] = {r = 13, [101] = true, [134] = true, [13] = true, [11] = true, [66] = true, [65] = true},	-- Turbid Forest Emerald, yellow, blue, 8 res, 8 spi
	[40088] = {r = 13, [101] = true, [134] = true, [13] = true, [11] = true, [71] = true, [63] = true},	-- Vivid Forest Emerald, yellow, blue, 8 hit, 12 stam

	[40058] = {r = 13, [101] = true, [135] = true, [13] = true, [12] = true, [84] = true, [71] = true},	-- Accurate Monarch Topaz, yellow, red, 8 expert, 8 hit
	[40039] = {r = 13, [101] = true, [135] = true, [13] = true, [12] = true, [61] = true, [75] = true},	-- Champion's Monarch Topaz, yellow, red, 8 str, 8 def
	[40043] = {r = 13, [101] = true, [135] = true, [13] = true, [12] = true, [62] = true, [72] = true},	-- Deadly Monarch Topaz, yellow, red, 8 agi, 8 crit
	[40046] = {r = 13, [101] = true, [135] = true, [13] = true, [12] = true, [62] = true, [70] = true},	-- Deft Monarch Topaz, yellow, red, 8 agi, 8 haste
	[40050] = {r = 13, [101] = true, [135] = true, [13] = true, [12] = true, [83] = true, [66] = true},	-- Durable Monarch Topaz, yellow, red, 9 spell, 8 res
	[40054] = {r = 13, [101] = true, [135] = true, [13] = true, [12] = true, [73] = true, [66] = true},	-- Empowered Monarch Topaz, yellow, red, 16 atk pwr, 8 res
	[40038] = {r = 13, [101] = true, [135] = true, [13] = true, [12] = true, [61] = true, [71] = true},	-- Etched Monarch Topaz, yellow, red, 8 str, 8 hit
	[40041] = {r = 13, [101] = true, [135] = true, [13] = true, [12] = true, [61] = true, [70] = true},	-- Fierce Monarch Topaz, yellow, red, 8 str, 8 haste
	[40057] = {r = 13, [101] = true, [135] = true, [13] = true, [12] = true, [76] = true, [75] = true},	-- Glimmering Monarch Topaz, yellow, red, 8 parry, 8 def
	[40044] = {r = 13, [101] = true, [135] = true, [13] = true, [12] = true, [62] = true, [71] = true},	-- Glinting Monarch Topaz, yellow, red, 8 agi, 8 hit
	[40037] = {r = 13, [101] = true, [135] = true, [13] = true, [12] = true, [61] = true, [72] = true},	-- Inscribed Monarch Topaz, yellow, red, 8 str, 8 crit
	[40045] = {r = 13, [101] = true, [135] = true, [13] = true, [12] = true, [62] = true, [66] = true},	-- Lucent Monarch Topaz, yellow, red, 8 agi, 8 res
	[40047] = {r = 13, [101] = true, [135] = true, [13] = true, [12] = true, [83] = true, [64] = true},	-- Luminous Monarch Topaz, yellow, red, 9 spell, 8 int
	[40048] = {r = 13, [101] = true, [135] = true, [13] = true, [12] = true, [83] = true, [72] = true},	-- Potent Monarch Topaz, yellow, red, 9 spell, 8 crit
	[40053] = {r = 13, [101] = true, [135] = true, [13] = true, [12] = true, [73] = true, [71] = true},	-- Pristine Monarch Topaz, yellow, red, 16 atk pwr, 8 hit
	[40051] = {r = 13, [101] = true, [135] = true, [13] = true, [12] = true, [83] = true, [70] = true},	-- Reckless Monarch Topaz, yellow, red, 9 spell, 8 haste
	[40059] = {r = 13, [101] = true, [135] = true, [13] = true, [12] = true, [84] = true, [75] = true},	-- Resolute Monarch Topaz, yellow, red, 8 expert, 8 def
	[40040] = {r = 13, [101] = true, [135] = true, [13] = true, [12] = true, [61] = true, [66] = true},	-- Resplendent Monarch Topaz, yellow, red, 8 str, 8 res
	[40056] = {r = 13, [101] = true, [135] = true, [13] = true, [12] = true, [74] = true, [75] = true},	-- Stalwart Monarch Topaz, yellow, red, 8 dodge, 8 def
	[40055] = {r = 13, [101] = true, [135] = true, [13] = true, [12] = true, [73] = true, [70] = true},	-- Stark Monarch Topaz, yellow, red, 16 atk pwr, 8 haste
	[40049] = {r = 13, [101] = true, [135] = true, [13] = true, [12] = true, [83] = true, [71] = true},	-- Veiled Monarch Topaz, yellow, red, 9 spell, 8 hit
	[40052] = {r = 13, [101] = true, [135] = true, [13] = true, [12] = true, [73] = true, [72] = true},	-- Wicked Monarch Topaz, yellow, red, 16 atk pwr, 8 crit

	[40029] = {r = 13, [101] = true, [136] = true, [12] = true, [11] = true, [73] = true, [63] = true},	-- Balanced Twilight Opal, red, blue, 16 atk pwr, 12 stam
	[40032] = {r = 13, [101] = true, [136] = true, [12] = true, [11] = true, [76] = true, [63] = true},	-- Defender's Twilight Opal, red, blue, 8 parry, 12 stam
	[40025] = {r = 13, [101] = true, [136] = true, [12] = true, [11] = true, [83] = true, [63] = true},	-- Glowing Twilight Opal, red, blue, 9 spell, 12 stam
	[40034] = {r = 13, [101] = true, [136] = true, [12] = true, [11] = true, [84] = true, [63] = true},	-- Guardian Twilight Opal, red, blue, 8 expert, 12 stam
	[40030] = {r = 13, [101] = true, [136] = true, [12] = true, [11] = true, [73] = true, [85] = true},	-- Infused Twilight Opal, red, blue, 16 atk pwr, 3 mp5
	[40028] = {r = 13, [101] = true, [136] = true, [12] = true, [11] = true, [83] = true, [82] = true},	-- Mysterious Twilight Opal, red, blue, 9 spell, 10 spellpenet
	[40033] = {r = 13, [101] = true, [136] = true, [12] = true, [11] = true, [81] = true, [63] = true},	-- Puissant Twilight Opal, red, blue, 8 armorpenet, 12 stam
	[40026] = {r = 13, [101] = true, [136] = true, [12] = true, [11] = true, [83] = true, [65] = true},	-- Purified Twilight Opal, red, blue, 9 spell, 8 spi
	[40031] = {r = 13, [101] = true, [136] = true, [12] = true, [11] = true, [74] = true, [63] = true},	-- Regal Twilight Opal, red, blue, 8 dodge, 12 stam
	[40027] = {r = 13, [101] = true, [136] = true, [12] = true, [11] = true, [83] = true, [85] = true},	-- Royal Twilight Opal, red, blue, 9 spell, 3 mp5
	[40023] = {r = 13, [101] = true, [136] = true, [12] = true, [11] = true, [62] = true, [63] = true},	-- Shifting Twilight Opal, red, blue, 8 agi, 12 stam
	[40022] = {r = 13, [101] = true, [136] = true, [12] = true, [11] = true, [61] = true, [63] = true},	-- Sovereign Twilight Opal, red, blue, 8 str, 12 stam
	[40024] = {r = 13, [101] = true, [136] = true, [12] = true, [11] = true, [62] = true, [85] = true},	-- Tenuous Twilight Opal, red, blue, 8 agi, 3 mp5

	[42702] = {r = 13, [101] = true, [137] = true, [11] = true, [12] = true, [13] = true, [61] = true, [62] = true, [63] = true, [64] = true, [65] = true},	-- Enchanted Tear, red, yellow, blue, 6 stats

	-- Crafted Rare Quality Meta Gems
	[41380] = {r = 14, [101] = true, [142] = true, [14] = true, [63] = true},	-- Austere Earthsiege Diamond, meta, 32 stam, +2% armor value from items
	[41389] = {r = 14, [101] = true, [142] = true, [14] = true, [72] = true},	-- Beaming Earthsiege Diamond, meta, 21 crit, +2% mana
	[41395] = {r = 14, [101] = true, [142] = true, [14] = true, [83] = true},	-- Bracing Earthsiege Diamond, meta, 25 spell, 2% reduced threat
	[41396] = {r = 14, [101] = true, [142] = true, [14] = true, [75] = true},	-- Eternal Earthsiege Diamond, meta, 21 def, +5% shield block value
	[41401]	= {r = 14, [101] = true, [142] = true, [14] = true, [64] = true},	-- Insightful Earthsiege Diamond, meta, 21 int, chance to restore mana on spellcast
	[41385] = {r = 14, [101] = true, [142] = true, [14] = true, [73] = true},	-- Invigorating Earthsiege Diamond, meta, 42 atk pwr, sometimes heal on your crits
	[41381] = {r = 14, [101] = true, [142] = true, [14] = true, [73] = true},	-- Persistent Earthsiege Diamond, meta, 42 atk pwr, stun duration reduced by 10%
	[41397] = {r = 14, [101] = true, [142] = true, [14] = true, [63] = true},	-- Powerful Earthsiege Diamond, meta, 32 stam, stun duration reduced by 10%
	[41398] = {r = 14, [101] = true, [142] = true, [14] = true, [62] = true},	-- Relentless Earthsiege Diamond, meta, 21 agi, +3% crit damage
	[41382] = {r = 14, [101] = true, [142] = true, [14] = true, [83] = true},	-- Trenchant Earthsiege Diamond, meta, 25 spell, stun duration reduced by 10%

	[41285] = {r = 14, [101] = true, [141] = true, [14] = true, [72] = true},	-- Chaotic Skyflare Diamond, meta, 21 crit, +3% crit damage
	[41307] = {r = 14, [101] = true, [141] = true, [14] = true, [72] = true},	-- Destructive Skyflare Diamond, meta, 25 crit, 1% spellreflect
	[41377] = {r = 14, [101] = true, [141] = true, [14] = true, [63] = true},	-- Effulgent Skyflare Diamond, meta, 32 stam, reduce spell damage taken by 2%
	[41333] = {r = 14, [101] = true, [141] = true, [14] = true, [83] = true},	-- Ember Skyflare Diamond, meta, 25 spell, +2% int
	[41335] = {r = 14, [101] = true, [141] = true, [14] = true, [72] = true},	-- Enigmatic Skyflare Diamond, meta, 21 crit, reduces snare/root duration by 10%
	[41378] = {r = 14, [101] = true, [141] = true, [14] = true, [83] = true},	-- Forlorn Skyflare Diamond, meta, 25 spell, silence duration reduced by 10%
	[41379] = {r = 14, [101] = true, [141] = true, [14] = true, [72] = true},	-- Impassive Skyflare Diamond, meta, 21 crit, fear duration reduced by 10%
	[41376] = {r = 14, [101] = true, [141] = true, [14] = true, [85] = true},	-- Revitalizing Skyflare Diamond, meta, 8 mp5, 3% increased crit healing effect
	[41339] = {r = 14, [101] = true, [141] = true, [14] = true, [73] = true},	-- Swift Skyflare Diamond, meta, 42 atk pwr, minor run speed increase
	[41400] = {r = 14, [101] = true, [141] = true, [14] = true, [0] = true},	-- Thundering Skyflare Diamond, meta, chance to increase melee/ranged attack speed
	[41375] = {r = 14, [101] = true, [141] = true, [14] = true, [83] = true},	-- Tireless Skyflare Diamond, meta, 25 spell, minor run speed increase

	-- PvP Purchased Gems (Wintergrasp)
	[44081] = {r = 14, [103] = true, [14] = true, [72] = true},	-- Enigmatic Starflare Diamond, meta, 17 crit, reduces snare/root duration by 10%
	[44084] = {r = 14, [103] = true, [14] = true, [83] = true},	-- Forlorn Starflare Diamond, meta, 20 spell, silence duration reduced by 10%
	[44082] = {r = 14, [103] = true, [14] = true, [72] = true},	-- Impassive Starflare Diamond, meta, 17 crit, fear duration reduced by 10%
	[44076] = {r = 14, [103] = true, [14] = true, [73] = true},	-- Swift Starflare Diamond, meta, 34 atk pwr, minor run speed increase
	[44078] = {r = 14, [103] = true, [14] = true, [83] = true},	-- Tireless Starflare Diamond, meta, 20 spell, minor run speed increase

	[44087] = {r = 14, [103] = true, [14] = true, [73] = true},	-- Persistent Earthshatter Diamond, meta, 34 atk pwr, stun duration reduced by 10%
	[44088] = {r = 14, [103] = true, [14] = true, [63] = true},	-- Powerful Earthshatter Diamond, meta, 26 stam, stun duration reduced by 10%
	[44089] = {r = 14, [103] = true, [14] = true, [83] = true},	-- Trenchant Earthshatter Diamond, meta, 20 spell, stun duration reduced by 10%

	[44066] = {r = 15, [103] = true, [13] = true, [66] = true},	-- Kharmaa's Grace, yellow, 20 res

	-- Crafted JC-only Epic Gems (Dragon's Eye)
	[42146] = {r = 16, [101] = true, [143] = true, [11] = true, [85] = true, [1013] = true},	-- Lustrous Dragon's Eye, blue, red, yellow, 11 mp5
	[36767] = {r = 16, [101] = true, [143] = true, [11] = true, [63] = true, [1013] = true},	-- Solid Dragon's Eye, blue, red, yellow, 41 stam
	[42145] = {r = 16, [101] = true, [143] = true, [11] = true, [65] = true, [1013] = true},	-- Sparkling Dragon's Eye, blue, red, yellow, 27 spi
	[42155] = {r = 16, [101] = true, [143] = true, [11] = true, [82] = true, [1013] = true},	-- Stormy Dragon's Eye, blue, red, yellow, 35 spellpenet

	[42142] = {r = 16, [101] = true, [143] = true, [12] = true, [61] = true, [1013] = true},	-- Bold Dragon's Eye, blue, red, yellow, 27 str
	[36766] = {r = 16, [101] = true, [143] = true, [12] = true, [73] = true, [1013] = true},	-- Bright Dragon's Eye, blue, red, yellow, 54 atk pwr
	[42143] = {r = 16, [101] = true, [143] = true, [12] = true, [62] = true, [1013] = true},	-- Delicate Dragon's Eye, blue, red, yellow, 27 agi
	[42152] = {r = 16, [101] = true, [143] = true, [12] = true, [76] = true, [1013] = true},	-- Flashing Dragon's Eye, blue, red, yellow, 27 parry
	[42153] = {r = 16, [101] = true, [143] = true, [12] = true, [81] = true, [1013] = true},	-- Fractured Dragon's Eye, blue, red, yellow, 27 armorpenet
	[42154] = {r = 16, [101] = true, [143] = true, [12] = true, [84] = true, [1013] = true},	-- Precise Dragon's Eye, blue, red, yellow, 27 expert
	[42144] = {r = 16, [101] = true, [143] = true, [12] = true, [83] = true, [1013] = true},	-- Runed Dragon's Eye, blue, red, yellow, 32 spell
	[42151] = {r = 16, [101] = true, [143] = true, [12] = true, [74] = true, [1013] = true},	-- Subtle Dragon's Eye, blue, red, yellow, 27 dodge

	[42148] = {r = 16, [101] = true, [143] = true, [13] = true, [64] = true, [1013] = true},	-- Brilliant Dragon's Eye, blue, red, yellow, 27 int
	[42158] = {r = 16, [101] = true, [143] = true, [13] = true, [66] = true, [1013] = true},	-- Mystic Dragon's Eye, blue, red, yellow, 27 res
	[42150] = {r = 16, [101] = true, [143] = true, [13] = true, [70] = true, [1013] = true},	-- Quick Dragon's Eye, blue, red, yellow, 27 haste
	[42156] = {r = 16, [101] = true, [143] = true, [13] = true, [71] = true, [1013] = true},	-- Rigid Dragon's Eye, blue, red, yellow, 27 hit
	[42149] = {r = 16, [101] = true, [143] = true, [13] = true, [72] = true, [1013] = true},	-- Smooth Dragon's Eye, blue, red, yellow, 27 crit
	[42157] = {r = 16, [101] = true, [143] = true, [13] = true, [75] = true, [1013] = true},	-- Thick Dragon's Eye, blue, red, yellow, 27 def

	-- Gems from fishing daily in Dalaran
	[45862] = {r = 15, [104] = true, [152] = true, [12] = true, [61] = true},	-- Bold Stormjewel, red, 20 str
	[45879] = {r = 15, [104] = true, [152] = true, [12] = true, [62] = true},	-- Delicate Stormjewel, red, 20 agi
	[45883] = {r = 15, [104] = true, [152] = true, [12] = true, [83] = true},	-- Runed Stormjewel, red, 23 spell
	[45882] = {r = 15, [104] = true, [153] = true, [13] = true, [64] = true},	-- Brilliant Stormjewel, yellow, 20 int
	[45987] = {r = 15, [104] = true, [153] = true, [13] = true, [71] = true},	-- Rigid Stormjewel, yellow, 20 hit
	[45880] = {r = 15, [104] = true, [151] = true, [11] = true, [63] = true},	-- Solid Stormjewel, blue, 30 stam
	[45881] = {r = 15, [104] = true, [151] = true, [11] = true, [65] = true},	-- Sparkling Stormjewel, blue, 20 spi

	-- Added in 3.2
	[40121] = {r = 15, [101] = true, [151] = true, [11] = true, [85] = true},	-- Lustrous Majestic Zircon, blue, 10 mp5
	[40119] = {r = 15, [101] = true, [151] = true, [11] = true, [63] = true},	-- Solid Majestic Zircon, blue, 30 stam
	[40120] = {r = 15, [101] = true, [151] = true, [11] = true, [65] = true},	-- Sparkling Majestic Zircon, blue, 20 spi
	[40122] = {r = 15, [101] = true, [151] = true, [11] = true, [82] = true},	-- Stormy Majestic Zircon, blue, 25 spellpenet

	[40111] = {r = 15, [101] = true, [152] = true, [12] = true, [61] = true},	-- Bold Cardinal Ruby, red, 20 str
	[40114] = {r = 15, [101] = true, [152] = true, [12] = true, [73] = true},	-- Bright Cardinal Ruby, red, 40 atk pwr
	[40112] = {r = 15, [101] = true, [152] = true, [12] = true, [62] = true},	-- Delicate Cardinal Ruby, red, 20 agi
	[40116] = {r = 15, [101] = true, [152] = true, [12] = true, [76] = true},	-- Flashing Cardinal Ruby, red, 20 parry
	[40117] = {r = 15, [101] = true, [152] = true, [12] = true, [81] = true},	-- Fractured Cardinal Ruby, red, 20 armorpenet
	[40118] = {r = 15, [101] = true, [152] = true, [12] = true, [84] = true},	-- Precise Cardinal Ruby, red, 20 expert
	[40113] = {r = 15, [101] = true, [152] = true, [12] = true, [83] = true},	-- Runed Cardinal Ruby, red, 23 spell
	[40115] = {r = 15, [101] = true, [152] = true, [12] = true, [74] = true},	-- Subtle Cardinal Ruby, red, 20 dodge

	[40123] = {r = 15, [101] = true, [153] = true, [13] = true, [64] = true},	-- Brilliant King's Amber, yellow, 20 int
	[40127] = {r = 15, [101] = true, [153] = true, [13] = true, [66] = true},	-- Mystic King's Amber, yellow, 20 res
	[40128] = {r = 15, [101] = true, [153] = true, [13] = true, [70] = true},	-- Quick King's Amber, yellow, 20 haste
	[40125] = {r = 15, [101] = true, [153] = true, [13] = true, [71] = true},	-- Rigid King's Amber, yellow, 20 hit
	[40124] = {r = 15, [101] = true, [153] = true, [13] = true, [72] = true},	-- Smooth King's Amber, yellow, 20 crit
	[40126] = {r = 15, [101] = true, [153] = true, [13] = true, [75] = true},	-- Thick King's Amber, yellow, 20 def

	[40175] = {r = 15, [101] = true, [154] = true, [13] = true, [11] = true, [64] = true, [85] = true},	-- Dazzling Eye of Zul, yellow, blue, 10 int, 5 mp5
	[40167] = {r = 15, [101] = true, [154] = true, [13] = true, [11] = true, [75] = true, [63] = true},	-- Enduring Eye of Zul, yellow, blue, 10 def, 15 stam
	[40179] = {r = 15, [101] = true, [154] = true, [13] = true, [11] = true, [70] = true, [85] = true},	-- Energized Eye of Zul, yellow, blue, 10 haste, 5 mp5
	[40169] = {r = 15, [101] = true, [154] = true, [13] = true, [11] = true, [70] = true, [63] = true},	-- Forceful Eye of Zul, yellow, blue, 10 haste, 15 stam
	[40174] = {r = 15, [101] = true, [154] = true, [13] = true, [11] = true, [70] = true, [65] = true},	-- Intricate Eye of Zul, yellow, blue, 10 haste, 10 spi
	[40165] = {r = 15, [101] = true, [154] = true, [13] = true, [11] = true, [72] = true, [63] = true},	-- Jagged Eye of Zul, yellow, blue, 10 crit, 15 stam
	[40177] = {r = 15, [101] = true, [154] = true, [13] = true, [11] = true, [71] = true, [85] = true},	-- Lambent Eye of Zul, yellow, blue, 10 hit, 5 mp5
	[40171] = {r = 15, [101] = true, [154] = true, [13] = true, [11] = true, [72] = true, [65] = true},	-- Misty Eye of Zul, yellow, blue, 10 crit, 10 spi
	[40178] = {r = 15, [101] = true, [154] = true, [13] = true, [11] = true, [66] = true, [85] = true},	-- Opaque Eye of Zul, yellow, blue, 10 res, 5 mp5
	[40180] = {r = 15, [101] = true, [154] = true, [13] = true, [11] = true, [72] = true, [82] = true},	-- Radiant Eye of Zul, yellow, blue, 10 crit, 13 spellpenet
	[40170] = {r = 15, [101] = true, [154] = true, [13] = true, [11] = true, [64] = true, [65] = true},	-- Seer's Eye of Zul, yellow, blue, 10 int, 10 spi
	[40182] = {r = 15, [101] = true, [154] = true, [13] = true, [11] = true, [70] = true, [82] = true},	-- Shattered Eye of Zul, yellow, blue, 10 haste, 13 spellpenet
	[40172] = {r = 15, [101] = true, [154] = true, [13] = true, [11] = true, [71] = true, [65] = true},	-- Shining Eye of Zul, yellow, blue, 10 hit, 10 spi
	[40168] = {r = 15, [101] = true, [154] = true, [13] = true, [11] = true, [66] = true, [63] = true},	-- Steady Eye of Zul, yellow, blue, 10 res, 15 stam
	[40176] = {r = 15, [101] = true, [154] = true, [13] = true, [11] = true, [72] = true, [85] = true},	-- Sundered Eye of Zul, yellow, blue, 10 crit, 5 mp5
	[40181] = {r = 15, [101] = true, [154] = true, [13] = true, [11] = true, [71] = true, [82] = true},	-- Tense Eye of Zul, yellow, blue, 10 hit, 13 spellpenet
	[40164] = {r = 15, [101] = true, [154] = true, [13] = true, [11] = true, [64] = true, [63] = true},	-- Timeless Eye of Zul, yellow, blue, 10 int, 15 stam
	[40173] = {r = 15, [101] = true, [154] = true, [13] = true, [11] = true, [66] = true, [65] = true},	-- Turbid Eye of Zul, yellow, blue, 10 res, 10 spi
	[40166] = {r = 15, [101] = true, [154] = true, [13] = true, [11] = true, [71] = true, [63] = true},	-- Vivid Eye of Zul, yellow, blue, 10 hit, 15 stam

	[40162] = {r = 15, [101] = true, [155] = true, [12] = true, [13] = true, [84] = true, [71] = true},	-- Accurate Ametrine, red, yellow, 10 expert, 10 hit
	[40144] = {r = 15, [101] = true, [155] = true, [12] = true, [13] = true, [61] = true, [75] = true},	-- Champion's Ametrine, red, yellow, 10 str, 10 def
	[40147] = {r = 15, [101] = true, [155] = true, [12] = true, [13] = true, [62] = true, [72] = true},	-- Deadly Ametrine, red, yellow, 10 agi, 10 crit
	[40150] = {r = 15, [101] = true, [155] = true, [12] = true, [13] = true, [62] = true, [70] = true},	-- Deft Ametrine, red, yellow, 10 agi, 10 haste
	[40154] = {r = 15, [101] = true, [155] = true, [12] = true, [13] = true, [83] = true, [66] = true},	-- Durable Ametrine, red, yellow, 12 spell, 10 res
	[40158] = {r = 15, [101] = true, [155] = true, [12] = true, [13] = true, [73] = true, [66] = true},	-- Empowered Ametrine, red, yellow, 20 atk pwr, 10 res
	[40143] = {r = 15, [101] = true, [155] = true, [12] = true, [13] = true, [61] = true, [71] = true},	-- Etched Ametrine, red, yellow, 10 str, 10 hit
	[40146] = {r = 15, [101] = true, [155] = true, [12] = true, [13] = true, [61] = true, [70] = true},	-- Fierce Ametrine, red, yellow, 10 str, 10 haste
	[40161] = {r = 15, [101] = true, [155] = true, [12] = true, [13] = true, [76] = true, [75] = true},	-- Glimmering Ametrine, red, yellow, 10 parry, 10 def
	[40148] = {r = 15, [101] = true, [155] = true, [12] = true, [13] = true, [62] = true, [71] = true},	-- Glinting Ametrine, red, yellow, 10 agi, 10 hit
	[40142] = {r = 15, [101] = true, [155] = true, [12] = true, [13] = true, [61] = true, [72] = true},	-- Inscribed Ametrine, red, yellow, 10 str, 10 crit
	[40149] = {r = 15, [101] = true, [155] = true, [12] = true, [13] = true, [62] = true, [66] = true},	-- Lucent Ametrine, red, yellow, 10 agi, 10 res
	[40151] = {r = 15, [101] = true, [155] = true, [12] = true, [13] = true, [83] = true, [64] = true},	-- Luminous Ametrine, red, yellow, 12 spell, 10 int
	[40152] = {r = 15, [101] = true, [155] = true, [12] = true, [13] = true, [83] = true, [72] = true},	-- Potent Ametrine, red, yellow, 12 spell, 10 crit
	[40157] = {r = 15, [101] = true, [155] = true, [12] = true, [13] = true, [73] = true, [71] = true},	-- Pristine Ametrine, red, yellow, 20 atk pwr, 10 hit
	[40155] = {r = 15, [101] = true, [155] = true, [12] = true, [13] = true, [83] = true, [70] = true},	-- Reckless Ametrine, red, yellow, 12 spell, 10 haste
	[40163] = {r = 15, [101] = true, [155] = true, [12] = true, [13] = true, [84] = true, [75] = true},	-- Resolute Ametrine, red, yellow, 10 expert, 10 def
	[40145] = {r = 15, [101] = true, [155] = true, [12] = true, [13] = true, [61] = true, [66] = true},	-- Resplendent Ametrine, red, yellow, 10 str, 10 res
	[40160] = {r = 15, [101] = true, [155] = true, [12] = true, [13] = true, [74] = true, [75] = true},	-- Stalwart Ametrine, red, yellow, 10 dodge, 10 def
	[40159] = {r = 15, [101] = true, [155] = true, [12] = true, [13] = true, [73] = true, [70] = true},	-- Stark Ametrine, red, yellow, 20 atk pwr, 10 haste
	[40153] = {r = 15, [101] = true, [155] = true, [12] = true, [13] = true, [83] = true, [71] = true},	-- Veiled Ametrine, red, yellow, 12 spell, 10 hit
	[40156] = {r = 15, [101] = true, [155] = true, [12] = true, [13] = true, [73] = true, [72] = true},	-- Wicked Ametrine, red, yellow, 20 atk pwr, 10 crit

	[40136] = {r = 15, [101] = true, [156] = true, [12] = true, [11] = true, [73] = true, [63] = true},	-- Balanced Dreadstone, red, blue, 20 atk pwr, 15 stam
	[40139] = {r = 15, [101] = true, [156] = true, [12] = true, [11] = true, [76] = true, [63] = true},	-- Defender's Dreadstone, red, blue, 10 parry, 15 stam
	[40132] = {r = 15, [101] = true, [156] = true, [12] = true, [11] = true, [83] = true, [63] = true},	-- Glowing Dreadstone, red, blue, 12 spell, 15 stam
	[40141] = {r = 15, [101] = true, [156] = true, [12] = true, [11] = true, [84] = true, [63] = true},	-- Guardian's Dreadstone, red, blue, 10 expert, 15 stam
	[40137] = {r = 15, [101] = true, [156] = true, [12] = true, [11] = true, [73] = true, [85] = true},	-- Infused Dreadstone, red, blue, 20 atk pwr, 5 mp5
	[40135] = {r = 15, [101] = true, [156] = true, [12] = true, [11] = true, [83] = true, [82] = true},	-- Mysterious Dreadstone, red, blue, 12 spell, 13 spellpenet
	[40140] = {r = 15, [101] = true, [156] = true, [12] = true, [11] = true, [81] = true, [63] = true},	-- Puissant Dreadstone, red, blue, 10 armor penet, 15 stam
	[40133] = {r = 15, [101] = true, [156] = true, [12] = true, [11] = true, [83] = true, [65] = true},	-- Purified Dreadstone, red, blue, 12 spell, 10 spi
	[40138] = {r = 15, [101] = true, [156] = true, [12] = true, [11] = true, [74] = true, [63] = true},	-- Regal Dreadstone, red, blue, 10 dodge, 15 stam
	[40134] = {r = 15, [101] = true, [156] = true, [12] = true, [11] = true, [83] = true, [85] = true},	-- Royal Dreadstone, red, blue, 12 spell, 5 mp5
	[40130] = {r = 15, [101] = true, [156] = true, [12] = true, [11] = true, [62] = true, [63] = true},	-- Shifting Dreadstone, red, blue, 10 agi, 15 stam
	[40129] = {r = 15, [101] = true, [156] = true, [12] = true, [11] = true, [61] = true, [63] = true},	-- Sovereign Dreadstone, red, blue, 10 str, 15 stam
	[40131] = {r = 15, [101] = true, [156] = true, [12] = true, [11] = true, [62] = true, [85] = true},	-- Tenuous Dreadstone, red, blue, 10 agi, 5 mp5

	[49110] = {r = 15, [101] = true, [143] = true, [11] = true, [12] = true, [13] = true, [61] = true, [62] = true, [63] = true, [64] = true, [65] = true},	-- Nightmare Tear, red, yellow, blue, 10 stats
}