Enraged = LibStub("AceAddon-3.0"):NewAddon("Enraged","AceConsole-3.0", "AceEvent-3.0");

-- Setting of Spell Data
function Enraged:setSpellData(id) 
  local name, _, tex = GetSpellInfo(id); 
  return { id, name, tex } 
 end 
 
-- Spell details shared between specs
Enraged.common = {
	hstrike = { spell = Enraged:setSpellData(47450), onGCD = false}, -- Heroic Strike 
	slam    = { spell = Enraged:setSpellData(47475), onGCD = true},  -- Slam
	exec 	  = { spell = Enraged:setSpellData(47471), onGCD = true},  -- Execute
  hthrow  = { spell = Enraged:setSpellData(57755), onGCD = true},  -- Heroic Throw
  -- csmash  = { spell = Enraged:setSpellData(86346), onGCD = true},  -- Colossus Smash
}
 
 -- Spell details for  Debuffs
Enraged.debuffs = {
  demo   = { spell = Enraged:setSpellData(47437), onGCD = true}, -- Demo Shout
  sunder = { spell = Enraged:setSpellData(7386),  onGCD = true}, -- Sunder Armor
  tclap  = { spell = Enraged:setSpellData(47502), onGCD = true}, -- Thunder Clap
}

 -- Spell details for Enraged Effects
Enraged.enraged_effects = {
  bloodr 	  = { spell = Enraged:setSpellData(2687),  onGCD = false}, -- Bloodrage
	berserk   = { spell = Enraged:setSpellData(18499), onGCD = true},  -- Berserker Rage
	deathwish = { spell = Enraged:setSpellData(12292), onGCD = true},  -- Death Wish    
}

-- Spell details for Fury 
Enraged.fury = {
	bthirst		= { spell = Enraged:setSpellData(23881), onGCD = true}, -- Bloodthirst
  whirlw    = { spell = Enraged:setSpellData(1680),  onGCD = true},  -- Whirlwind
--rageblow  = { Enraged:setSpellData(85288), onGCD = true }, -- Raging Blow  
}

-- Spell details for Arms
Enraged.arms = {
  op = Enraged:setSpellData(7384),  -- Overpower
  ms = Enraged:setSpellData(47486), -- Mortal Strike
  bs = Enraged:setSpellData(46924), -- Bladestorm
  ss = Enraged:setSpellData(12328)  -- Sweeping Strikes
}

-- Spell Details for Helpfull Shouts
Enraged.shouts = {
  battle  = { spell = Enraged:setSpellData(47436), onGCD = true},  -- Battle Shout
  command = { spell = Enraged:setSpellData(47440), onGCD = true},  -- Commanding Shout
}

-- Spell Details for Equivalent Debuffs
Enraged.external = {
  might    = { spell = Enraged:setSpellData(47437)}, -- Blessing of Might
  demoroar = { spell = Enraged:setSpellData(48560)}, -- Demoralizing Roar (tested)
  vindic   = { spell = Enraged:setSpellData(26016)}, -- Vindication (tested)
  acidspit = { spell = Enraged:setSpellData(55754)}, -- Acid Spit
  expose   = { spell = Enraged:setSpellData(8647)},  -- Expose Armor (tested)
  frostfever = { spell = Enraged:setSpellData(59921)}, -- Frost Fever (tested)
  judgjust = { spell = Enraged:setSpellData(53696)}, -- Judgment of the Just (tested)
  infect   = { spell = Enraged:setSpellData(48485)}, -- Infected Wounds (tested)
}

-- Local variables
local enabled
local timeSinceLastUpdate = 0
local updateFrequency = 0.1
local theGCD = 1.5
local frameItialized = false
local buffInitialized = false
local inCombat = false
local timeEnteringCombat = 0
local TGSpec = 0

----------------------------------
-- Override the OnUpdate function
----------------------------------
local function OnUpdate(this, elapsed)
	timeSinceLastUpdate = timeSinceLastUpdate + elapsed
  if timeSinceLastUpdate > updateFrequency then  
    if (Enraged.db.profile.frame_isShown == true) then    
      Enraged:UpdateQueue()
      Enraged:UpdateOOR()
      Enraged:refreshTextures()
      Enraged:UpdateCDs()
      timeSinceLastUpdate = 0
    end
    if (Enraged.db.profile.buff_isShown == true) then
      Enraged:UpdateBuffs()
      timeSinceLastUpdate = 0
    end
  end
end

------------------------
-- Defaults and Options
------------------------
local defaults = {
    profile = {
        frame_width = 190,
        frame_height = 80,
        frame_x = 400,
        frame_y = 400,
        frame_scale = 1.0,
        frame_isShown = true,
   
        buff_x = 400,
        buff_y = 300,
        buff_width = 190,
        buff_height = 50,
        buff_scale = 1.0,
        buff_isShown = true,

        suggest_execute = true,
        suggest_deathwish = false,
        suggest_thunderclap = false,
        suggest_demo = true,
        suggest_sunder = true,
        suggest_enrage = false,
        
        icon_size = 64,
        icon_size_small = 48,
        icon_size_tiny = 32,        
        isLocked = false,
        showOnlyIC = false,
        enabled = true,
    },
}

local options = {
    name = "Enraged",
    handler = Enraged,
    type = "group",
    args = {
        lock = {
            type = "toggle",
            name = "Lock Frames",
            order = 10,
            desc = "Locks the Enraged Frame",
            get = function() return Enraged.db.profile.isLocked end,
            set = "ToggleLocked",
        },
        showOnlyIC = {
            type = "toggle",
            name = "Show only in Combat",
            order = 20,
            desc = "Toggles showing the frames only while in combat",
            get = function() return Enraged.db.profile.showOnlyIC end,
            set = "ToggleShowOnlyIC",
        },
        frame = {
            type = "group",
            name = "Enraged Frame",
            guiInline = true,
            order = 100,
            args = {
                toggle = {
                    type = "toggle",
                    name = "Show Frame",
                    order = 110,
                    desc = "Toggles the display of the frame on the screen.",
                    get = function() return Enraged.db.profile.frame_isShown end,
                    set = "ToggleShowOnScreen",
                },     
                scale = {
                    type = "range",
                    name = "Scale",
                    order = 120,
                    min = 0.5,
                    max = 1.5,
                    step = 0.1,
                    desc = "Sets the scaling of the Enraged Frame",    
                    get = function() return Enraged.db.profile.frame_scale end,
                    set = "SetScale",
                },                  
                posx = {
                    type = "input",
                    name = "X-Coordinate",
                    order = 130,
                    desc = "Sets the X-Coordinate of the Enraged Frame",
                    get = function() return Enraged.db.profile.frame_x end,
                    set = "SetXCoord",
                },
                posy = {
                    type = "input",
                    name = "Y-Coordinate",
                    order = 140,
                    desc = "Sets the Y-Coordinate of the Enraged Frame",
                    get = function() return Enraged.db.profile.frame_y end,
                    set = "SetYCoord",
                },      
            },              
        },
        buffs = {
           type = "group",
           name = "Buffs / Debuffs Frame",
           guiInline = true,
           order = 200,
           args = {
              toggle = {
                  type = "toggle",
                  name = "Show Frame",
                  order = 10,
                  get = function() return Enraged.db.profile.buff_isShown end,
                  set = "ToggleBuffsShowOnScreen",
              },  
              scale = {
                  type = "range",
                  name = "Scale",
                  order = 210,
                  min = 0.5,
                  max = 1.5,
                  step = 0.1,
                  desc = "Sets the scaling of the Buffs / Debuffs Frame",    
                  get = function() return Enraged.db.profile.buff_scale end,
                  set = "SetBuffScale",
            },                  
              posx = {
                  type = "input",
                  name = "X-Coordinate",
                  order = 220,
                  desc = "Sets the X-Coordinate of the Buffs / Debuffs Frame",
                  get = function() return Enraged.db.profile.buff_x end,
                  set = "SetBuffXCoord",
              },
              posy = {
                  type = "input",
                  name = "Y-Coordinate",
                  order = 230,
                  desc = "Sets the Y-Coordinate of the Buffs / Debuffs Frame",
                  get = function() return Enraged.db.profile.buff_y end,
                  set = "SetBuffYCoord",
               },
           },
        },
        suggest = {
            type = "group",
            name = "Optional DPS Priority Suggestions",
            guiInline = true,
            order = 300,
            args = {
              useExecute = {
                type = "toggle",
                name = "Execute",
                desc = "Will suggest using Execute within rotational gaps",
                order = 310,
                get = function() return Enraged.db.profile.suggest_execute end,
                set = function() Enraged.db.profile.suggest_execute = not Enraged.db.profile.suggest_execute end,
              },
              useDeathWish = {
                type = "toggle",
                name = "Death Wish",
                desc = "Will suggest using Death Wish within rotational gaps.",
                order = 320,
                get = function() return Enraged.db.profile.suggest_deathwish end,
                set = function() Enraged.db.profile.suggest_deathwish = not Enraged.db.profile.suggest_deathwish end,
              },
              useSunder = {
                type = "toggle",
                name = "Sunder Armor",
                desc = "Will suggest using Sunder Armor within rotational gaps.",
                order = 330,
                get = function() return Enraged.db.profile.suggest_sunder end,
                set = function() Enraged.db.profile.suggest_sunder = not Enraged.db.profile.suggest_sunder end,
              },
              useThunderClap = {
                type = "toggle",
                name = "Thunder Clap",
                desc = "Will suggest using Thunder Clap within rotational gaps.",
                order = 340,
                get = function() return Enraged.db.profile.suggest_thunderclap end,
                set = function() Enraged.db.profile.suggest_thunderclap = not Enraged.db.profile.suggest_thunderclap end,
              },
              useDemo = {
                type = "toggle",
                name = "Demo Shout",
                desc = "Will suggest using Demo Shout within rotational gaps.",
                order = 350,
                get = function() return Enraged.db.profile.suggest_demo end,
                set = function() Enraged.db.profile.suggest_demo = not Enraged.db.profile.suggest_demo end,
              },
              useEnrage = {
                type = "toggle",
                name = "Enrages (Cata - NYI)",
                desc = "Will suggest using Bloodrage and Berserker Rage within rotational gaps.",
                order = 360,
                get = function() return Enraged.db.profile.suggest_enrage end,
                set = function() Enraged.db.profile.suggest_enrage = not Enraged.db.profile.suggest_enrage end,
              },              
            },
        },
    },
}

-----------------------------------------------
-- Frame initializing for Enraged, Buffs, Debug
------------------------------------------------
function Enraged:InitEnragedFrame()
  -- Enraged and Ability Frames
  local EnragedFrame = CreateFrame("Frame", "enragedFrame", UIParent)

  self.frame = EnragedFrame
  EnragedFrame.Ability1Frame = CreateFrame("Frame", "ability1Frame", EnragedFrame)
  EnragedFrame.Ability2Frame = CreateFrame("Frame", "ability2Frame", EnragedFrame)  
  EnragedFrame.Ability3Frame = CreateFrame("Frame", "ability3Frame", EnragedFrame)
  
  -- Set Frame Strata and load background
  EnragedFrame:SetFrameStrata("BACKGROUND")
  EnragedFrame:SetWidth(self.db.profile.frame_scale * self.db.profile.frame_width)
  EnragedFrame:SetHeight(self.db.profile.frame_scale * self.db.profile.frame_height)
  
  -- Set the Backdrop
	EnragedFrame:SetBackdrop({
		bgFile = "Interface\\Tooltips\\UI-Tooltip-Background",
		edgeFile = nil,
		tile = true, tileSize = 4, edgeSize = 0,
		insets = { left = 1, right = 1, top = 1, bottom = 1 }
	})
  if (self.db.profile.isLocked == true) then
      EnragedFrame:SetBackdropColor(0, 0, 0, 0)
  else
      EnragedFrame:SetBackdropColor(0, 0, 0, 0.7)
  end
  
  -- Create Frames for Abilities #1
  EnragedFrame.Ability1Frame.ability = Enraged.fury.bthirst -- Default
	EnragedFrame.Ability1Frame:SetWidth(self.db.profile.icon_size * self.db.profile.frame_scale)
	EnragedFrame.Ability1Frame:SetHeight(self.db.profile.icon_size * self.db.profile.frame_scale)
  EnragedFrame.Ability1Frame:ClearAllPoints()
  EnragedFrame.Ability1Frame:SetPoint("BOTTOMLEFT", EnragedFrame, "BOTTOMLEFT", 8 * self.db.profile.frame_scale, 8 * self.db.profile.frame_scale)
  EnragedFrame.Ability1Frame.texture = EnragedFrame.Ability1Frame:CreateTexture(nil, "OVERLAY")
  EnragedFrame.Ability1Frame.texture:SetTexture(EnragedFrame.Ability1Frame.ability.spell[3])
  EnragedFrame.Ability1Frame.texture:SetWidth(self.db.profile.icon_size * self.db.profile.frame_scale)
  EnragedFrame.Ability1Frame.texture:SetHeight(self.db.profile.icon_size * self.db.profile.frame_scale)
	EnragedFrame.Ability1Frame.texture:ClearAllPoints() 
	EnragedFrame.Ability1Frame.cooldown = CreateFrame("Cooldown","Ability1Cooldown",Ability1Frame)
	EnragedFrame.Ability1Frame.cooldown:SetAllPoints(EnragedFrame.Ability1Frame)
	EnragedFrame.Ability1Frame.cooldown:SetDrawEdge(enable)
  EnragedFrame.Ability1Frame.texture:SetPoint("BOTTOMLEFT", EnragedFrame.Ability1Frame, "BOTTOMLEFT")
  EnragedFrame.Ability1Frame.inRange = true
  
  -- Create Frames for Abilities #2
  EnragedFrame.Ability2Frame.ability = Enraged.fury.whirlw -- Default
	EnragedFrame.Ability2Frame:SetWidth(self.db.profile.icon_size_small * self.db.profile.frame_scale)
	EnragedFrame.Ability2Frame:SetHeight(self.db.profile.icon_size_small * self.db.profile.frame_scale)
  EnragedFrame.Ability2Frame:ClearAllPoints()
  EnragedFrame.Ability2Frame:SetPoint("BOTTOMLEFT", EnragedFrame, "BOTTOMLEFT", 80 * self.db.profile.frame_scale, 8 * self.db.profile.frame_scale)
  EnragedFrame.Ability2Frame.texture = EnragedFrame.Ability2Frame:CreateTexture(nil, "OVERLAY")
  EnragedFrame.Ability2Frame.texture:SetTexture(EnragedFrame.Ability2Frame.ability.spell[3])
  EnragedFrame.Ability2Frame.texture:SetWidth(self.db.profile.icon_size_small * self.db.profile.frame_scale)
  EnragedFrame.Ability2Frame.texture:SetHeight(self.db.profile.icon_size_small * self.db.profile.frame_scale)
	EnragedFrame.Ability2Frame.texture:ClearAllPoints() 
	EnragedFrame.Ability2Frame.cooldown = CreateFrame("Cooldown","Ability2Cooldown",Ability2Frame)	
	EnragedFrame.Ability2Frame.cooldown:SetDrawEdge(enable)	
  EnragedFrame.Ability2Frame.cooldown:SetAllPoints(EnragedFrame.Ability2Frame)
  EnragedFrame.Ability2Frame.texture:SetPoint("BOTTOMLEFT", EnragedFrame.Ability2Frame, "BOTTOMLEFT")
  EnragedFrame.Ability2Frame.inRange = true

  -- Create Frames for Abilities #3
  EnragedFrame.Ability3Frame.ability = Enraged.fury.bthirst -- Default  
	EnragedFrame.Ability3Frame:SetWidth(self.db.profile.icon_size_small * self.db.profile.frame_scale)
	EnragedFrame.Ability3Frame:SetHeight(self.db.profile.icon_size_small * self.db.profile.frame_scale)
  EnragedFrame.Ability3Frame:ClearAllPoints()
  EnragedFrame.Ability3Frame:SetPoint("BOTTOMLEFT", EnragedFrame, "BOTTOMLEFT", 136 * self.db.profile.frame_scale, 8 * self.db.profile.frame_scale)
  EnragedFrame.Ability3Frame.texture = EnragedFrame.Ability3Frame:CreateTexture(nil, "OVERLAY")
  EnragedFrame.Ability3Frame.texture:SetTexture(EnragedFrame.Ability3Frame.ability.spell[3])
  EnragedFrame.Ability3Frame.texture:SetWidth(self.db.profile.icon_size_small * self.db.profile.frame_scale)
  EnragedFrame.Ability3Frame.texture:SetHeight(self.db.profile.icon_size_small * self.db.profile.frame_scale)
	EnragedFrame.Ability3Frame.texture:ClearAllPoints() 
	EnragedFrame.Ability3Frame.cooldown = CreateFrame("Cooldown","Ability3Cooldown",Ability3Frame)	
  EnragedFrame.Ability3Frame.cooldown:SetAllPoints(EnragedFrame.Ability3Frame)
	EnragedFrame.Ability3Frame.cooldown:SetDrawEdge(enable)				
  EnragedFrame.Ability3Frame.texture:SetPoint("BOTTOMLEFT", EnragedFrame.Ability3Frame, "BOTTOMLEFT")
  EnragedFrame.Ability3Frame.inRange = true
  
  -- Set X/Y points, enable mouse 
  EnragedFrame:SetPoint("TOPLEFT", UIParent, "BOTTOMLEFT",self.db.profile.frame_x,self.db.profile.frame_y)
	EnragedFrame:EnableMouse(true)
	EnragedFrame:SetMovable(true)
	EnragedFrame:SetClampedToScreen(true)
	EnragedFrame:RegisterForDrag("LeftButton")
	EnragedFrame:SetScript("OnDragStart", function()
		this:StartMoving()
	end) 
  EnragedFrame:SetScript("OnDragStop", function()
    this:StopMovingOrSizing()
    self.db.profile.frame_x = this:GetLeft()
    self.db.profile.frame_y = this:GetTop()
  end)  
  
  -- Check DB profile for locked and shown status
  if (self.db.profile.isLocked == true) then
    EnragedFrame:EnableMouse(false)
  else
    EnragedFrame:EnableMouse(true)
  end
  if (self.db.profile.frame_isShown and self.db.profile.showOnlyIC == false) then
    EnragedFrame:Show()
  else
    EnragedFrame:Hide()    
  end
  
  -- Set up OnUpdate
  frameInitialized = true
  self.frame:SetScript("OnUpdate", OnUpdate)  
end

function Enraged:InitBuffsFrame()
  local BuffsFrame = CreateFrame("Frame", "buffsFrame", UIParent)

  self.buffframe = BuffsFrame
  BuffsFrame.enrage  = CreateFrame("Frame", "buffsEnrage", BuffsFrame)
  BuffsFrame.sunder  = CreateFrame("Frame", "buffsSunder", BuffsFrame)  
  BuffsFrame.thunder = CreateFrame("Frame", "buffsThunder", BuffsFrame)
  BuffsFrame.demo    = CreateFrame("Frame", "buffsDemo", BuffsFrame)  
  
  -- Set Frame Strata and load background
  BuffsFrame:SetFrameStrata("BACKGROUND")
  BuffsFrame.enrage:SetFrameStrata("BACKGROUND")
  BuffsFrame.sunder:SetFrameStrata("BACKGROUND")
  BuffsFrame.thunder:SetFrameStrata("BACKGROUND")
  BuffsFrame.demo:SetFrameStrata("BACKGROUND")  
  BuffsFrame:SetWidth(self.db.profile.buff_scale * self.db.profile.buff_width)
  BuffsFrame:SetHeight(self.db.profile.buff_scale * self.db.profile.buff_height)
  
  -- Set the Backdrop
	BuffsFrame:SetBackdrop({
		bgFile = "Interface\\Tooltips\\UI-Tooltip-Background",
		edgeFile = nil,
		tile = true, tileSize = 4, edgeSize = 0,
		insets = { left = 1, right = 1, top = 1, bottom = 1 }
	})
  if (self.db.profile.isLocked == true) then
    BuffsFrame:SetBackdropColor(0, 0, 0, 0)
  else
      BuffsFrame:SetBackdropColor(0, 0, 0, 0.7)
  end
  
  -- Buffs Enrage Frame (Set Ability, width, height, texture)
  BuffsFrame.enrage.ability = Enraged.enraged_effects.deathwish -- Default
	BuffsFrame.enrage:SetWidth(self.db.profile.icon_size_tiny * self.db.profile.buff_scale)
	BuffsFrame.enrage:SetHeight(self.db.profile.icon_size_tiny * self.db.profile.buff_scale)
  BuffsFrame.enrage:ClearAllPoints()
  BuffsFrame.enrage:SetPoint("BOTTOMLEFT", BuffsFrame, "BOTTOMLEFT", 13 * self.db.profile.buff_scale, 8 * self.db.profile.buff_scale)
  BuffsFrame.enrage.texture = BuffsFrame.enrage:CreateTexture(nil, "OVERLAY")
  BuffsFrame.enrage.texture:SetTexture(BuffsFrame.enrage.ability.spell[3])
  BuffsFrame.enrage.texture:SetWidth(self.db.profile.icon_size_tiny * self.db.profile.buff_scale)
  BuffsFrame.enrage.texture:SetHeight(self.db.profile.icon_size_tiny * self.db.profile.buff_scale)
	BuffsFrame.enrage.texture:ClearAllPoints() 
  BuffsFrame.enrage.texture:SetPoint("BOTTOMLEFT", BuffsFrame.enrage, "BOTTOMLEFT")
  
  -- Buffs Sunder Frame (Set Ability, width, height, texture)  
  BuffsFrame.sunder.ability = Enraged.debuffs.sunder -- Default
	BuffsFrame.sunder:SetWidth(self.db.profile.icon_size_tiny * self.db.profile.buff_scale)
	BuffsFrame.sunder:SetHeight(self.db.profile.icon_size_tiny * self.db.profile.buff_scale)
  BuffsFrame.sunder:ClearAllPoints()
  BuffsFrame.sunder:SetPoint("BOTTOMLEFT", BuffsFrame, "BOTTOMLEFT", 57 * self.db.profile.buff_scale, 8 * self.db.profile.buff_scale)
  BuffsFrame.sunder.texture = BuffsFrame.sunder:CreateTexture(nil, "OVERLAY")
  BuffsFrame.sunder.texture:SetTexture(BuffsFrame.sunder.ability.spell[3])
  BuffsFrame.sunder.texture:SetWidth(self.db.profile.icon_size_tiny * self.db.profile.buff_scale)
  BuffsFrame.sunder.texture:SetHeight(self.db.profile.icon_size_tiny * self.db.profile.buff_scale)
	BuffsFrame.sunder.texture:ClearAllPoints() 
  BuffsFrame.sunder.texture:SetPoint("BOTTOMLEFT", BuffsFrame.sunder, "BOTTOMLEFT")

  -- Buffs Thunder Frame (Set Ability, width, height, texture)  
  BuffsFrame.thunder.ability = Enraged.debuffs.tclap -- Default
	BuffsFrame.thunder:SetWidth(self.db.profile.icon_size_tiny * self.db.profile.buff_scale)
	BuffsFrame.thunder:SetHeight(self.db.profile.icon_size_tiny * self.db.profile.buff_scale)
  BuffsFrame.thunder:ClearAllPoints()
  BuffsFrame.thunder:SetPoint("BOTTOMLEFT", BuffsFrame, "BOTTOMLEFT", 101 * self.db.profile.buff_scale, 8 * self.db.profile.buff_scale)
  BuffsFrame.thunder.texture = BuffsFrame.thunder:CreateTexture(nil, "OVERLAY")
  BuffsFrame.thunder.texture:SetTexture(BuffsFrame.thunder.ability.spell[3])
  BuffsFrame.thunder.texture:SetWidth(self.db.profile.icon_size_tiny * self.db.profile.buff_scale)
  BuffsFrame.thunder.texture:SetHeight(self.db.profile.icon_size_tiny * self.db.profile.buff_scale)
	BuffsFrame.thunder.texture:ClearAllPoints() 
  BuffsFrame.thunder.texture:SetPoint("BOTTOMLEFT", BuffsFrame.thunder, "BOTTOMLEFT")

  -- Buffs Demo Frame (Set Ability, width, height, texture)  
  BuffsFrame.demo.ability = Enraged.debuffs.demo -- Default
	BuffsFrame.demo:SetWidth(self.db.profile.icon_size_tiny * self.db.profile.buff_scale)
	BuffsFrame.demo:SetHeight(self.db.profile.icon_size_tiny * self.db.profile.buff_scale)
  BuffsFrame.demo:ClearAllPoints()
  BuffsFrame.demo:SetPoint("BOTTOMLEFT", BuffsFrame, "BOTTOMLEFT", 145 * self.db.profile.buff_scale, 8 * self.db.profile.buff_scale)
  BuffsFrame.demo.texture = BuffsFrame.demo:CreateTexture(nil, "OVERLAY")
  BuffsFrame.demo.texture:SetTexture(BuffsFrame.demo.ability.spell[3])
  BuffsFrame.demo.texture:SetWidth(self.db.profile.icon_size_tiny * self.db.profile.buff_scale)
  BuffsFrame.demo.texture:SetHeight(self.db.profile.icon_size_tiny * self.db.profile.buff_scale)
	BuffsFrame.demo.texture:ClearAllPoints() 
  BuffsFrame.demo.texture:SetPoint("BOTTOMLEFT", BuffsFrame.demo, "BOTTOMLEFT")  

  -- Setup the Buffs Frame
  BuffsFrame:SetPoint("TOPLEFT", UIParent, "BOTTOMLEFT",self.db.profile.buff_x,self.db.profile.buff_y)
	BuffsFrame:EnableMouse(true)
	BuffsFrame:SetMovable(true)
	BuffsFrame:SetClampedToScreen(true)
	BuffsFrame:RegisterForDrag("LeftButton")
	BuffsFrame:SetScript("OnDragStart", function()
		this:StartMoving()
	end) 
  BuffsFrame:SetScript("OnDragStop", function()
    this:StopMovingOrSizing()
    self.db.profile.buff_x = this:GetLeft()
    self.db.profile.buff_y = this:GetTop()
  end)  
  
  -- Overlay text for the timers
	local text1 = buffsEnrage:CreateFontString(nil, "OVERLAY")
	text1:ClearAllPoints()
	text1:SetPoint("LEFT", buffsEnrage, "LEFT", 6 * self.db.profile.buff_scale, 0)
	text1:SetJustifyH("CENTER")
	text1:SetFont("Fonts\\FRIZQT__.TTF", 12  * self.db.profile.buff_scale, "OUTLINE")
  text1:SetText("")
	buffsEnrage.enragetime = text1

	local text2 = buffsSunder:CreateFontString(nil, "OVERLAY")
	text2:ClearAllPoints()
	text2:SetPoint("LEFT", buffsSunder, "LEFT", 6 * self.db.profile.buff_scale, 0)
	text2:SetJustifyH("CENTER")
	text2:SetFont("Fonts\\FRIZQT__.TTF", 12  * self.db.profile.buff_scale, "OUTLINE")
  text2:SetText("")
	buffsSunder.sundertime = text2
  
	local text3 = buffsThunder:CreateFontString(nil, "OVERLAY")
	text3:ClearAllPoints()
	text3:SetPoint("LEFT", buffsThunder, "LEFT", 6 * self.db.profile.buff_scale, 0)
	text3:SetJustifyH("CENTER")
	text3:SetFont("Fonts\\FRIZQT__.TTF", 12  * self.db.profile.buff_scale, "OUTLINE")
  text3:SetText("")
	buffsThunder.tclaptime = text3

	local text4 = buffsDemo:CreateFontString(nil, "OVERLAY")
	text4:ClearAllPoints()
	text4:SetPoint("LEFT", buffsDemo, "LEFT", 6 * self.db.profile.buff_scale, 0)
	text4:SetJustifyH("CENTER")
	text4:SetFont("Fonts\\FRIZQT__.TTF", 12  * self.db.profile.buff_scale, "OUTLINE")
  text3:SetText("")
	buffsDemo.demotime = text4
  
	local text5 = buffsSunder:CreateFontString(nil, "OVERLAY")
	text5:ClearAllPoints()
	text5:SetPoint("BOTTOMRIGHT", buffsSunder, "BOTTOMRIGHT", -1  * self.db.profile.buff_scale, 1  * self.db.profile.buff_scale)
	text5:SetJustifyH("CENTER")
	text5:SetFont("Fonts\\FRIZQT__.TTF", 10  * self.db.profile.buff_scale, "OUTLINE")
  text5:SetText("")
	buffsSunder.sunderstack = text5  
  
  -- Check DB profile for locked and shown status
  if (self.db.profile.isLocked == true) then
    BuffsFrame:EnableMouse(false)
  else
    BuffsFrame:EnableMouse(true)
  end
  if (self.db.profile.buff_isShown and self.db.profile.showOnlyIC == false) then
    BuffsFrame:Show()
  else
    BuffsFrame:Hide()
  end  
  
  buffInitialized = true
  self.buffframe:SetScript("OnUpdate", OnUpdate)  
end

---------------------------------------------
-- On Initialized, Enable and Disable Methods
---------------------------------------------
function Enraged:OnInitialize()
  self.db = LibStub("AceDB-3.0"):New("EnragedDB", defaults, "Default")
  
  local className, myClass = UnitClass("player")
  if myClass ~= "WARRIOR" then
    self:Print("You have loaded Enraged on a " .. className .. ". This addon is designed for the Warrior class.")
    enabled = false
		return
  else
    enabled = true
  end  
  
  LibStub("AceConfig-3.0"):RegisterOptionsTable("Enraged", options, {"enraged", "enr"})
  self.optionsFrame = LibStub("AceConfigDialog-3.0"):AddToBlizOptions("Enraged", "Enraged")  
  self:RegisterChatCommand("enr", "ChatCommand")
  self:RegisterChatCommand("enraged", "ChatCommand")
  
	self:RegisterEvent("PLAYER_TALENT_UPDATE")  
	self:RegisterEvent("UNIT_ENTERED_VEHICLE")
	self:RegisterEvent("UNIT_EXITED_VEHICLE")  
  self:RegisterEvent("PLAYER_REGEN_ENABLED")
  self:RegisterEvent("PLAYER_REGEN_DISABLED")  
  
  _, _, _, _, TitansGrip = GetTalentInfo(2,27)
  self:InitBuffsFrame()  
  self:InitEnragedFrame()
  self:EvaluateToggle()
end
 
function Enraged:OnEnable()
end

function Enraged:OnDisable()
end

function Enraged:PLAYER_TALENT_UPDATE()
  self:EvaluateToggle()
end

function Enraged:EvaluateToggle()
  _, _, _, _, TGSpec = GetTalentInfo(2,27)
  
  -- Show
  if (Enraged.db.profile.isLocked == false) or
     ((Enraged.db.profile.showOnlyIC == true and inCombat == true) or
      (Enraged.db.profile.showOnlyIC == false)) then
    if (Enraged.db.profile.frame_isShown == true and TGSpec == 1) then
      self.frame:Show()
    end
    if (Enraged.db.profile.buff_isShown == true) then
      self.buffframe:Show()
    end
  end
  
  -- Hide Based on Spec, regardless of locked or not
  if (TGSpec == 0) then
   self.frame:Hide()
  end
  
  -- Hide Based on in combat
  if (Enraged.db.profile.isLocked == true) then
    if (Enraged.db.profile.showOnlyIC == true and inCombat == false) then
      if (self.frame:IsShown() ~= nil) then
        self.frame:Hide()
      end
      if (self.buffframe:IsShown() ~= nil) then
        self.buffframe:Hide()
      end
    end
    
    -- Hide Based on not wanting to show
    if (Enraged.db.profile.frame_isShown == false and self.frame:IsShown() ~= nil) then
      self.frame:Hide()
    end
    if (Enraged.db.profile.buff_isShown == false and self.buffframe:IsShown() ~= nil) then
      self.buffframe:Hide()
    end
  end
end

function Enraged:UNIT_ENTERED_VEHICLE()
end
function Enraged:UNIT_EXITED_VEHICLE()
end

function Enraged:PLAYER_REGEN_ENABLED()
  inCombat = false
  Enraged:EvaluateToggle()
end

function Enraged:PLAYER_REGEN_DISABLED()
  inCombat = true
  timeEnteringCombat = GetTime()
  Enraged:EvaluateToggle()
end

-----------------------------------------------------
-- Get and Set of X, Y Coordinates and Width / Height
-----------------------------------------------------
function Enraged:SetXCoord(info, value)
  if (self.db.profile.isLocked == false) then
    self.db.profile.frame_x = value
    self.frame:SetPoint("TOPLEFT", UIParent, "BOTTOMLEFT",self.db.profile.frame_x,self.db.profile.frame_y)
  end
end

function Enraged:SetYCoord(info, value)
  if (self.db.profile.isLocked == false) then
    self.db.profile.frame_y = value
    self.frame:SetPoint("TOPLEFT", UIParent, "BOTTOMLEFT",self.db.profile.frame_x,self.db.profile.frame_y)
  end
end

function Enraged:SetBuffXCoord(info, value)
  if (self.db.profile.isLocked == false) then
    self.db.profile.buff_x = value
    buffsFrame:SetPoint("TOPLEFT", UIParent, "BOTTOMLEFT",self.db.profile.buff_x,self.db.profile.buff_y)
  end
end

function Enraged:SetBuffYCoord(info, value)
  if (self.db.profile.isLocked == false) then
    self.db.profile.buff_y = value
    buffsFrame:SetPoint("TOPLEFT", UIParent, "BOTTOMLEFT",self.db.profile.buff_x,self.db.profile.buff_y)
  end
end

----------------------------------------
-- Toggling of Enraged/Buffs Locking
---------------------------------------
function Enraged:ToggleLocked(info, value)
  self.db.profile.isLocked = value
  if (self.db.profile.isLocked == true) then
    if (frameInitialized == true) then
      self.frame:EnableMouse(false)
      self.frame:SetBackdropColor(0, 0, 0, 0)
    end
    if (buffInitialized == true) then
      buffsFrame:EnableMouse(false)
      buffsFrame:SetBackdropColor(0, 0, 0, 0)
    end
  else
    if (frameInitialized == true) then
      self.frame:EnableMouse(true)
      self.frame:SetBackdropColor(0, 0, 0, 0.7)
    end
    if (buffInitialized == true) then
      buffsFrame:EnableMouse(true)
      buffsFrame:SetBackdropColor(0, 0, 0, 0.7)
    end
  end
  
  self:EvaluateToggle()
end

------------------------------------
-- Toggling of Enraged/Buffs frames
------------------------------------
function Enraged:ToggleShowOnScreen(info, value)
  self.db.profile.frame_isShown = value
  self:EvaluateToggle()
  if (TGSpec == 0 and self.db.profile.frame_isShown == true) then
    self:Print("Ability Queue is will be enabled when a Fury Spec (x/51/x) is detected.")
  end
end

function Enraged:ToggleBuffsShowOnScreen(info,value)
  self.db.profile.buff_isShown = value;
  self:EvaluateToggle()    
end

------------------------------------
-- Toggling of showing out of combat
------------------------------------
function Enraged:ToggleShowOnlyIC(info, value)
    self.db.profile.showOnlyIC = not self.db.profile.showOnlyIC    
    self:EvaluateToggle()
end

---------------------------------
-- Scale of Enraged/Buffs frames
---------------------------------               
function Enraged:SetScale(info, value)
  self.db.profile.frame_scale = value
  if (tonumber(value) > 1.5 or tonumber(value) < 0.5) then
      self:Print("Scale value out of range (0.5-1.5)")
      return
  end
  enragedFrame:SetWidth(self.db.profile.frame_scale * self.db.profile.frame_width)
  enragedFrame:SetHeight(self.db.profile.frame_scale * self.db.profile.frame_height)
  
  ability1Frame:SetWidth(self.db.profile.frame_scale * self.db.profile.icon_size)
  ability1Frame:SetHeight(self.db.profile.frame_scale * self.db.profile.icon_size)
  ability1Frame:ClearAllPoints()
  ability1Frame:SetPoint("BOTTOMLEFT", enragedFrame, "BOTTOMLEFT", 8 * self.db.profile.frame_scale, 8 * self.db.profile.frame_scale)
  ability1Frame.texture:SetWidth(self.db.profile.icon_size * self.db.profile.frame_scale)
  ability1Frame.texture:SetHeight(self.db.profile.icon_size * self.db.profile.frame_scale)    
  
  ability2Frame:SetWidth(self.db.profile.frame_scale * self.db.profile.icon_size_small)
  ability2Frame:SetHeight(self.db.profile.frame_scale * self.db.profile.icon_size_small)
  ability2Frame:ClearAllPoints()
  ability2Frame:SetPoint("BOTTOMLEFT", enragedFrame, "BOTTOMLEFT", 80 * self.db.profile.frame_scale, 8 * self.db.profile.frame_scale)
  ability2Frame.texture:SetWidth(self.db.profile.icon_size_small * self.db.profile.frame_scale)
  ability2Frame.texture:SetHeight(self.db.profile.icon_size_small * self.db.profile.frame_scale)
  
  ability3Frame:SetWidth(self.db.profile.frame_scale * self.db.profile.icon_size_small)
  ability3Frame:SetHeight(self.db.profile.frame_scale * self.db.profile.icon_size_small)
  ability3Frame:ClearAllPoints()
  ability3Frame:SetPoint("BOTTOMLEFT", enragedFrame, "BOTTOMLEFT", 136 * self.db.profile.frame_scale, 8 * self.db.profile.frame_scale)  
  ability3Frame.texture:SetWidth(self.db.profile.icon_size_small * self.db.profile.frame_scale)
  ability3Frame.texture:SetHeight(self.db.profile.icon_size_small * self.db.profile.frame_scale)
end

function Enraged:SetBuffScale(info, value)
  self.db.profile.buff_scale = value
  if (tonumber(value) > 1.5 or tonumber(value) < 0.5) then
      self:Print("Scale value out of range (0.5-1.5)")
      return
  end
  
  buffsFrame:SetWidth(self.db.profile.buff_scale * self.db.profile.buff_width)
  buffsFrame:SetHeight(self.db.profile.buff_scale * self.db.profile.buff_height) 
  
  -- Enraged Buff
  buffsEnrage:SetWidth(self.db.profile.buff_scale * self.db.profile.icon_size_tiny)
  buffsEnrage:SetHeight(self.db.profile.buff_scale * self.db.profile.icon_size_tiny)
  buffsEnrage:ClearAllPoints()
  buffsEnrage:SetPoint("BOTTOMLEFT", buffsFrame, "BOTTOMLEFT", 13 * self.db.profile.buff_scale, 8 * self.db.profile.buff_scale)
  buffsEnrage.texture:SetWidth(self.db.profile.icon_size_tiny * self.db.profile.buff_scale)
  buffsEnrage.texture:SetHeight(self.db.profile.icon_size_tiny * self.db.profile.buff_scale)
  
  -- Sunder
  buffsSunder:SetWidth(self.db.profile.buff_scale * self.db.profile.icon_size_tiny)
  buffsSunder:SetHeight(self.db.profile.buff_scale * self.db.profile.icon_size_tiny)
  buffsSunder:ClearAllPoints()
  buffsSunder:SetPoint("BOTTOMLEFT", buffsFrame, "BOTTOMLEFT", 57 * self.db.profile.buff_scale, 8 * self.db.profile.buff_scale)
  buffsSunder.texture:SetWidth(self.db.profile.icon_size_tiny * self.db.profile.buff_scale)
  buffsSunder.texture:SetHeight(self.db.profile.icon_size_tiny * self.db.profile.buff_scale)    

  -- Thunder Clap
  buffsThunder:SetWidth(self.db.profile.buff_scale * self.db.profile.icon_size_tiny)
  buffsThunder:SetHeight(self.db.profile.buff_scale * self.db.profile.icon_size_tiny)
  buffsThunder:ClearAllPoints()
  buffsThunder:SetPoint("BOTTOMLEFT", buffsFrame, "BOTTOMLEFT", 101 * self.db.profile.buff_scale, 8 * self.db.profile.buff_scale)
  buffsThunder.texture:SetWidth(self.db.profile.icon_size_tiny * self.db.profile.buff_scale)
  buffsThunder.texture:SetHeight(self.db.profile.icon_size_tiny * self.db.profile.buff_scale)    
  
  -- Demo Shout
  buffsDemo:SetWidth(self.db.profile.buff_scale * self.db.profile.icon_size_tiny)
  buffsDemo:SetHeight(self.db.profile.buff_scale * self.db.profile.icon_size_tiny)
  buffsDemo:ClearAllPoints()
  buffsDemo:SetPoint("BOTTOMLEFT", buffsFrame, "BOTTOMLEFT", 145 * self.db.profile.buff_scale, 8 * self.db.profile.buff_scale)
  buffsDemo.texture:SetWidth(self.db.profile.icon_size_tiny * self.db.profile.buff_scale)
  buffsDemo.texture:SetHeight(self.db.profile.icon_size_tiny * self.db.profile.buff_scale)
  
  buffsEnrage.enragetime:SetFont("Fonts\\FRIZQT__.TTFa", 12 * self.db.profile.buff_scale, "OUTLINE")
  buffsSunder.sundertime:SetFont("Fonts\\FRIZQT__.TTF", 12 * self.db.profile.buff_scale, "OUTLINE")
  buffsSunder.sunderstack:SetFont("Fonts\\FRIZQT__.TTF", 10 * self.db.profile.buff_scale, "OUTLINE")
  buffsThunder.tclaptime:SetFont("Fonts\\FRIZQT__.TTF", 12 * self.db.profile.buff_scale, "OUTLINE")  
  buffsDemo.demotime:SetFont("Fonts\\FRIZQT__.TTF", 12 * self.db.profile.buff_scale, "OUTLINE")
end

-------------------------------
-- Interpret the Chat Commnads
-------------------------------
function Enraged:ChatCommand(input)
  if input:trim() == "options" or input:trim() == "config" then
    InterfaceOptionsFrame_OpenToCategory(self.optionsFrame)
  else
    if input:trim() == "enr" then

      self:Print("Enter \"/enr config\" for configuration GUI")
    end
    LibStub("AceConfigCmd-3.0").HandleCommand(Enraged, "enr", "Enraged", input)
  end
end

-------------------------------------
-- Toggles Enraged Ability's colours
-- based on their availablility
-------------------------------------
function Enraged:ShowAbilitiesUnavailable(override)
  if (override == false) then
    ability1Frame.texture:SetVertexColor(0.8, 0.1, 0.1)
  else
    ability1Frame.texture:SetVertexColor(1, 1, 1)
  end
  ability2Frame.texture:SetVertexColor(0.8, 0.1, 0.1)
  ability3Frame.texture:SetVertexColor(0.8, 0.1, 0.1)
  Enraged:refreshTextures()        
end

function Enraged:ShowAbilitiesAvailable()
  ability1Frame.texture:SetVertexColor(1, 1, 1)
  ability2Frame.texture:SetVertexColor(1, 1, 1)
  ability3Frame.texture:SetVertexColor(1, 1, 1)
  Enraged:refreshTextures()        
end

------------------------------------
-- Update the DPS Priority Queue
------------------------------------
function Enraged:UpdateQueue()
  local bthirstStart,bthirstBaseCD = GetSpellCooldown(Enraged.fury.bthirst.spell[1])
  local whirlwStart,whirlwBaseCD = GetSpellCooldown(Enraged.fury.whirlw.spell[1])
  local _,_,_,slamCount,_,_,slamTR,_,_,_,_ = UnitAura("player","Slam!")
  local _,_,latency = GetNetStats()
  local currentStart,currentBaseGCD = GetSpellCooldown(Enraged.debuffs.sunder.spell[1])
  local bthirstCD = 0
  local whirlwCD = 0
  local currentGCD = 0
  
  if (bthirstStart > 0) then
    bthirstCD = bthirstBaseCD - (GetTime() - bthirstStart)
  else
    bthirstCD = 0
  end
  
  if (whirlwStart > 0) then
    whirlwCD = whirlwBaseCD - (GetTime() - whirlwStart)
  else
    whirlwCD = 0
  end

  if (currentStart > 0) then
    currentGCD = currentBaseGCD - (GetTime() - currentStart)
  else
    currentGCD = 0
  end
  
  -- Update BT and WW
  if bthirstCD <= currentGCD then -- BT has top priority
    ability1Frame.ability = Enraged.fury.bthirst
  end
  
  if whirlwCD <= currentGCD then -- WW has secondary priority
    if bthirstCD <= currentGCD then
      ability2Frame.ability = Enraged.fury.whirlw
    else
      ability1Frame.ability = Enraged.fury.whirlw
    end
  end
  
  -- Calculate what could be coming up next
  -- BT is coming up first (or is up)
  if bthirstCD <= whirlwCD then
    ability1Frame.ability = Enraged.fury.bthirst
    -- Update slots 2 and 3 depending on WW's cooldown
    if ((currentGCD + bthirstCD + bthirstBaseCD) < whirlwCD) then -- 4 is CD of BT
      ability2Frame.ability = Enraged.fury.bthirst
      ability3Frame.ability = Enraged.fury.whirlw
    else
      ability2Frame.ability = Enraged.fury.whirlw
      ability3Frame.ability = Enraged.fury.bthirst
    end
  end
  
  
  -- Finally, WW is set to come up before BT and not before the end of the current GCD,
  -- then we have a simple WW->BT->BT rotation
  if whirlwCD < bthirstCD then
    ability1Frame.ability = Enraged.fury.whirlw
    ability2Frame.ability = Enraged.fury.bthirst
    ability3Frame.ability = Enraged.fury.bthirst
  end
  
  -- Update Slam
  if slamCount ~= nil then
    -- Try to update for #1 slot
    if bthirstCD > currentGCD and whirlwCD > currentGCD then
      Enraged:pushbackAbilities(1)
      ability1Frame.ability = Enraged.common.slam
    end
    
    if ((bthirstCD <= currentGCD and whirlwCD > (theGCD + currentGCD)) or (whirlwCD <= currentGCD and bthirstCD > (theGCD + currentGCD))) and slamTR >= theGCD then
      Enraged:pushbackAbilities(2)
      ability2Frame.ability = Enraged.common.slam
    end

    if bthirstCD <= currentGCD and whirlwCD < (currentGCD+theGCD) and slamTR >= ((2*theGCD) + currentGCD) then
      ability3Frame.ability = Enraged.common.slam
    end
    
    if whirlwCD <= currentGCD and bthirstCD < (currentGCD+theGCD) and slamTR >= ((2*theGCD) + currentGCD) then
      ability3Frame.ability = Enraged.common.slam
    end
    
  end

  Enraged:updateRotationGaps(currentGCD)
end

----------------------------------------------------
-- Checks ability slots 1-3 for rotational gaps, and
-- fills them in with a beneficial ability
----------------------------------------------------
function Enraged:updateRotationGaps(currentGCD)
  local ability1Start, ability1BaseCD = GetSpellCooldown(ability1Frame.ability.spell[1])
  local ability2Start, ability2BaseCD = GetSpellCooldown(ability2Frame.ability.spell[1])
  local ability3Start, ability3BaseCD = GetSpellCooldown(ability3Frame.ability.spell[1])
  local ability1CD = ability1BaseCD - (GetTime() - ability1Start)
  local ability2CD = ability2BaseCD - (GetTime() - ability2Start)
  local ability3CD = ability3BaseCD - (GetTime() - ability3Start)
  
  if (ability1CD > currentGCD) then
    Enraged:updateAbility1(currentGCD)
    return
  end
  if (ability2CD > theGCD + currentGCD) then
    Enraged:updateAbility2(currentGCD)
    return
  end
  if (ability3CD > (2*theGCD) + currentGCD) then
    Enraged:updateAbility3(currentGCD)
    return
  end
end

function Enraged:updateAbility1(currentGCD)
  -- Wait 8 seconds into combat before suggesting debuffs, to let the tanks put them up and to let you DPS.
  -- Check Sunder
  if ((GetTime() - timeEnteringCombat) > 8) then
    if (self.db.profile.suggest_sunder == true) then
      local _,_,_,sunderStack,_,_,sunderTR,_,_,_,_  = UnitDebuff("target", Enraged.debuffs.sunder.spell[2])
      if (sunderTR == nil) then
        _,_,_,sunderStack,_,_,sunderTR,_,_,_,_  = UnitDebuff("target", Enraged.external.acidspit.spell[2])
        if (sunderTR == nil) then
          _,_,_,sunderStack,_,_,sunderTR,_,_,_,_  = UnitDebuff("target", Enraged.external.expose.spell[2]) 
        end
      end
      if (sunderStack == nil or sunderStack < 5 or ((sunderTR - GetTime()) < 15)) then
        Enraged:pushbackAbilities(1)
        ability1Frame.ability = Enraged.debuffs.sunder
        return
      end
    end
  end
  
  -- Check Demo Shout
  if ((GetTime() - timeEnteringCombat) > 8) then
    if (self.db.profile.suggest_demo == true) then
      local _,_,_,_,_,_,demoTR,_,_,_,_ = UnitDebuff("target", Enraged.debuffs.demo.spell[2])
      if (demoTR == nil) then
        _,_,_,_,_,_,demoTR,_,_,_,_ = UnitDebuff("target", Enraged.external.demoroar.spell[2])
        if (demoTR == nil) then
          _,_,_,_,_,_,demoTR,_,_,_,_ = UnitDebuff("target", Enraged.external.vindic.spell[2])
        end
      end 
      if (demoTR == nil or (demoTR - GetTime()) < 5) then
        Enraged:pushbackAbilities(1)
        ability1Frame.ability = Enraged.debuffs.demo
        return
      end
    end
  end
  
  -- Check Thunderclap
  if ((GetTime() - timeEnteringCombat) > 8) then
    if (self.db.profile.suggest_thunderclap == true) then
      local _,_,_,_,_,_,tclapTR,_,_,_,_  = UnitDebuff("target", Enraged.debuffs.tclap.spell[2])
      if (tclapTR == nil) then
        _,_,_,_,_,_,tclapTR,_,_,_,_ = UnitDebuff("target", Enraged.external.frostfever.spell[2])
        if (tclapTR == nil) then
          _,_,_,_,_,_,tclapTR,_,_,_,_ = UnitDebuff("target", Enraged.external.judgjust.spell[2])
          if (tclapTR == nil) then
            _,_,_,_,_,_,tclapTR,_,_,_,_ = UnitDebuff("target", Enraged.external.infect.spell[2])
          end
        end
      end
      if (tclapTR == nil or (tclapTR - GetTime()) < 5) then
        Enraged:pushbackAbilities(1)
        ability1Frame.ability = Enraged.debuffs.tclap
        return
      end
    end
  end
    
  -- Check Death Wish
  if (self.db.profile.suggest_deathwish == true) then
    local dwStart, dwBase = GetSpellCooldown(Enraged.enraged_effects.deathwish.spell[1])
    local dwCD
    if (dwStart > 0) then
      dwCD = dwBase - (GetTime() - dwStart)
    else
      dwCD = 0
    end  
    if (dwCD <= currentGCD) then
      Enraged:pushbackAbilities(1)
      ability1Frame.ability = Enraged.enraged_effects.deathwish
      return
    end
  end
  
  -- Check Execute
  local health = UnitHealth("target") / UnitHealthMax("target")
  if (health < 0.2 and self.db.profile.suggest_execute == true) then
    Enraged:pushbackAbilities(1)
    ability1Frame.ability = Enraged.common.exec
    return
  end
end

function Enraged:updateAbility2(currentGCD)
  -- Check Death Wish
  if (self.db.profile.suggest_deathwish == true) then
    local dwStart, dwBase = GetSpellCooldown(Enraged.enraged_effects.deathwish.spell[1])
    local dwCD
    if (dwStart > 0) then
      dwCD = dwBase - (GetTime() - dwStart)
    else
      dwCD = 0
    end  
    if (dwCD <= currentGCD) then
      Enraged:pushbackAbilities(2)
      ability2Frame.ability = Enraged.enraged_effects.deathwish
      return
    end
  end
  
  -- Check Execute
  local health = UnitHealth("target") / UnitHealthMax("target")
  if (health < 0.2 and self.db.profile.suggest_execute == true) then
    Enraged:pushbackAbilities(2)
    ability2Frame.ability = Enraged.common.exec
    return
  end  
end

function Enraged:updateAbility3(currentGCD)
  -- Check Death Wish
  local dwStart, dwBase = GetSpellCooldown(Enraged.enraged_effects.deathwish.spell[1])
  local dwCD
  if (self.db.profile.suggest_deathwish == true) then
    if (dwStart > 0) then
      dwCD = dwBase - (GetTime() - dwStart)
    else
      dwCD = 0
    end  
    if (dwCD <= currentGCD) then
      ability3Frame.ability = Enraged.enraged_effects.deathwish
      return      
    end
  end
  
  -- Check Execute
  local health = UnitHealth("target") / UnitHealthMax("target")
  if (health < 0.2 and self.db.profile.suggest_execute == true) then
    ability3Frame.ability = Enraged.common.exec
  end  
end

------------------------------------
-- Refresh textures in the DPS queue
------------------------------------
function Enraged:refreshTextures()
  ability1Frame.texture:SetTexture(ability1Frame.ability.spell[3])
  ability2Frame.texture:SetTexture(ability2Frame.ability.spell[3])
  ability3Frame.texture:SetTexture(ability3Frame.ability.spell[3])
end

------------------------------------
-- Pushback abilities down the queue,
-- starting from the given index
------------------------------------
function Enraged:pushbackAbilities(index)
  local ability1 = ability1Frame.ability
  local ability2 = ability2Frame.ability
  
  if (index == 1) then
    ability2Frame.ability = ability1
    ability3Frame.ability = ability2
  end
   
  if (index == 2) then
    ability3Frame.ability = ability2
  end
end

------------------------------------
-- Update the Cooldowns on the DPS
-- abilitiy queue.
------------------------------------
function Enraged:UpdateCDs()
	local start, duration = GetSpellCooldown(ability1Frame.ability.spell[1])
	if duration and duration > 0 then
		ability1Frame.cooldown:SetCooldown(start, duration)
		ability1Frame.cooldown:Show()
  else
    ability1Frame.cooldown:Hide()
  end
  
  start, duration = GetSpellCooldown(ability2Frame.ability.spell[1])
  if duration and duration > 0 then
    ability2Frame.cooldown:SetCooldown(start, duration)
		ability2Frame.cooldown:Show()
	else
    ability2Frame.cooldown:Hide()
  end
   
  start, duration = GetSpellCooldown(ability3Frame.ability.spell[1])
  if duration and duration > 0 then
  	ability3Frame.cooldown:SetCooldown(start, duration)
		ability3Frame.cooldown:Show()
  else
    ability3Frame.cooldown:Hide() 
	end
end

-------------------------------------
-- Update Buff/Debuff durations and 
-- change opacities based on them
-------------------------------------
function Enraged:UpdateBuffs()
  local _,_,_,enrageCount,_,enrageDuration,enrageET,_,_ = UnitAura("player", Enraged.enraged_effects.deathwish.spell[2])
  local _,_,_,sunderStack,_,_,sunderTR,_,_,_,_  = UnitDebuff("target", Enraged.debuffs.sunder.spell[2])
  local _,_,_,_,_,_,tclapTR,_,_,_,_  = UnitDebuff("target", Enraged.debuffs.tclap.spell[2])
  local _,_,_,_,_,_,demoTR,_,_,_,_  = UnitDebuff("target", Enraged.debuffs.demo.spell[2])
  
  -- Basic Death Wish analyzing, TODO: more advanced Enrage logic for Cataclysm
  if (enrageET ~= nil) then
    if ((enrageET - GetTime()) <= 9.5) then
      buffsEnrage.enragetime:ClearAllPoints()
      buffsEnrage.enragetime:SetPoint("LEFT", buffsEnrage, "LEFT", 10 * self.db.profile.buff_scale, 0)
    else
      buffsEnrage.enragetime:ClearAllPoints()
      buffsEnrage.enragetime:SetPoint("LEFT", buffsEnrage, "LEFT", 6 * self.db.profile.buff_scale, 0)    
    end
    buffsEnrage.enragetime:SetText(format("%.0f",enrageET - GetTime()))    
    buffsEnrage.texture:SetAlpha(1)
  else
    buffsEnrage.enragetime:SetText()
    buffsEnrage.texture:SetAlpha(0.3)
  end
  
  -- Lets look at external debuffs if our own are not present  
  -- Sunder
  if (sunderTR == nil) then
    _,_,_,sunderStack,_,_,sunderTR,_,_,_,_  = UnitDebuff("target", Enraged.external.acidspit.spell[2])
    if (sunderTR == nil) then
      _,_,_,sunderStack,_,_,sunderTR,_,_,_,_  = UnitDebuff("target", Enraged.external.expose.spell[2])
      if (sunderTR == nil) then
        buffsSunder.ability = Enraged.debuffs.sunder
      else
        buffsSunder.ability = Enraged.external.expose
      end
    else
      buffsSunder.ability = Enraged.external.acidspit
    end
  else
    buffsSunder.ability = Enraged.debuffs.sunder
  end
  
  -- Thunder Clap
  if (tclapTR == nil) then
    _,_,_,_,_,_,tclapTR,_,_,_,_  = UnitDebuff("target", Enraged.external.frostfever.spell[2])
    if (tclapTR == nil) then
      _,_,_,_,_,_,tclapTR,_,_,_,_  = UnitDebuff("target", Enraged.external.judgjust.spell[2])
      if (tclapTR == nil) then
        _,_,_,_,_,_,tclapTR,_,_,_,_  = UnitDebuff("target", Enraged.external.infect.spell[2])
        if (tclapTR == nil) then
          buffsThunder.ability = Enraged.debuffs.tclap
        else
          buffsThunder.ability = Enraged.external.infect
        end
      else
        buffsThunder.ability = Enraged.external.judgjust
      end
    else
      buffsThunder.ability = Enraged.external.frostfever
    end
  else
    buffsThunder.ability = Enraged.debuffs.tclap
  end
  
  -- Demo Shout
  if (demoTR == nil) then
    _,_,_,_,_,_,demoTR,_,_,_,_  = UnitDebuff("target", Enraged.external.demoroar.spell[2])
    if (demoTR == nil) then
      _,_,_,_,_,_,demoTR,_,_,_,_  = UnitDebuff("target", Enraged.external.vindic.spell[2])
        if (demoTR == nil) then
          buffsDemo.ability = Enraged.debuffs.demo
        else
          buffsDemo.ability = Enraged.external.vindic
        end
    else
      buffsDemo.ability = Enraged.external.demoroar
    end
  else
    buffsDemo.ability = Enraged.debuffs.demo
  end
  
  -- Update buff timers etc
  Enraged:UpdateBuffTimers(sunderTR, sunderStack, demoTR, tclapTR)
end

-- Update buff textures, timers, stack counts, etc for Buff Frames
function Enraged:UpdateBuffTimers(sunderTR, sunderStack, demoTR, tclapTR)
  -- Sunder and equivalents
  if (sunderTR ~= nil) then
    buffsSunder:SetAlpha(1)
    buffsSunder.texture:SetTexture(buffsSunder.ability.spell[3])
    if (sunderStack > 0) then
      buffsSunder.sunderstack:SetText(sunderStack)
    else
      buffsSunder.sunderstack:SetText("")
    end 
    if ((sunderTR - GetTime()) <= 9.5) then
      buffsSunder.sundertime:ClearAllPoints()
      buffsSunder.sundertime:SetPoint("LEFT", buffsSunder, "LEFT", 10 * self.db.profile.buff_scale, 0)
      buffsSunder.sunderstack:SetPoint("BOTTOMRIGHT", buffsSunder, "BOTTOMRIGHT", -1 * self.db.profile.buff_scale, 1 * self.db.profile.buff_scale)
    else
      buffsSunder.sundertime:ClearAllPoints()
      buffsSunder.sundertime:SetPoint("LEFT", buffsSunder, "LEFT", 6 * self.db.profile.buff_scale, 0)    
    end
    buffsSunder.sundertime:SetText(format("%.0f",sunderTR - GetTime()))
  else
    buffsSunder.texture:SetTexture(buffsSunder.ability.spell[3])
    buffsSunder.sundertime:SetText("")
    buffsSunder.sunderstack:SetText("")
    buffsSunder:SetAlpha(0.3)
  end
    
  -- Thunder Clap and equivalents
  if (tclapTR ~= nil) then
    buffsThunder:SetAlpha(1)
    buffsThunder.texture:SetTexture(buffsThunder.ability.spell[3])
    if ((tclapTR - GetTime()) <= 9.5) then
      buffsThunder.tclaptime:ClearAllPoints()
      buffsThunder.tclaptime:SetPoint("LEFT", buffsThunder, "LEFT", 10 * self.db.profile.buff_scale, 0)
    else
      buffsThunder.tclaptime:ClearAllPoints()
      buffsThunder.tclaptime:SetPoint("LEFT", buffsThunder, "LEFT", 6 * self.db.profile.buff_scale, 0)    
    end
    buffsThunder.tclaptime:SetText(format("%.0f",tclapTR - GetTime()))
  else
    buffsThunder.texture:SetTexture(buffsThunder.ability.spell[3])
    buffsThunder.tclaptime:SetText("")
    buffsThunder:SetAlpha(0.3)
  end  
  
  -- Demo Shout and equivalents
  if (demoTR ~= nil) then
    buffsDemo:SetAlpha(1)
    buffsDemo.texture:SetTexture(buffsDemo.ability.spell[3])    
    if ((demoTR - GetTime()) <= 9.5) then
      buffsDemo.demotime:ClearAllPoints()
      buffsDemo.demotime:SetPoint("LEFT", buffsDemo, "LEFT", 10 * self.db.profile.buff_scale, 0)
    else
      buffsDemo.demotime:ClearAllPoints()
      buffsDemo.demotime:SetPoint("LEFT", buffsDemo, "LEFT", 6 * self.db.profile.buff_scale, 0)    
    end
    buffsDemo.demotime:SetText(format("%.0f",demoTR - GetTime()))
  else
    buffsDemo.texture:SetTexture(buffsDemo.ability.spell[3])  
    buffsDemo.demotime:SetText("")
    buffsDemo:SetAlpha(0.3)
  end  
end
-------------------------------------------------
-- Check if your current target is in melee range
--------------------------------------------------
function Enraged:UpdateOOR()
  local hthrowCD = GetSpellCooldown(Enraged.common.hthrow.spell[1])
  local meleeRange = IsSpellInRange(Enraged.debuffs.sunder.spell[2], "target") -- Spell available in all stances, all specs
  local throwRange = IsSpellInRange(Enraged.common.hthrow.spell[2], "target") -- Spell available in all stances, all specs
  if meleeRange ~= nil and meleeRange == 0 then
    if (hthrowCD == 0) then
      if (ability1Frame.ability == Enraged.common.hthrow) then
        Enraged:pushbackAbilities(1)
      end
      ability1Frame.ability = Enraged.common.hthrow
      if (throwRange ~= nil and throwRange == 1) then
        Enraged:ShowAbilitiesUnavailable(true)      
      else
        Enraged:ShowAbilitiesUnavailable(false)
      end  
    else
      Enraged:ShowAbilitiesUnavailable(false)
    end
  else
    Enraged:ShowAbilitiesAvailable(false)
  end
end