local ElvuiConfig = LibStub("AceAddon-3.0"):NewAddon("ElvuiConfig", "AceConsole-3.0", "AceEvent-3.0")
local L = LibStub("AceLocale-3.0"):GetLocale("ElvuiConfig", false)
local LSM = LibStub("LibSharedMedia-3.0")
local db
local defaults
local DEFAULT_WIDTH = 815
local DEFAULT_HEIGHT = 555
local AC = LibStub("AceConfig-3.0")
local ACD = LibStub("AceConfigDialog-3.0")
local ACR = LibStub("AceConfigRegistry-3.0")

if IsAddOnLoaded("ElvUI_ConfigUI") then
	error("The AddOn 'ElvUI_ConfigUI' is no longer in use, please remove it from you addons folders. The new config addon is called 'ElvUI_Config'")
end

function ElvuiConfig:LoadDefaults()
	local E, _, _, DB = unpack(ElvUI)
	--Defaults
	defaults = {
		profile = {
			general = DB["general"],
			media = DB["media"],
			nameplate = DB["nameplate"],
			skin = DB["skin"],
			unitframes = DB["unitframes"],
			raidframes = DB["raidframes"],
			classtimer = DB["classtimer"],
			actionbar = DB["actionbar"],
			datatext = DB["datatext"],
			chat = DB["chat"],
			tooltip = DB["tooltip"],
			others = DB["others"],
		},
	}
end	

function ElvuiConfig:OnInitialize()	
	ElvuiConfig:RegisterChatCommand("ec", "ShowConfig")
	ElvuiConfig:RegisterChatCommand("elvui", "ShowConfig")
	
	self.OnInitialize = nil
end

function ElvuiConfig:ShowConfig() 
	ACD[ACD.OpenFrames.ElvuiConfig and "Close" or "Open"](ACD,"ElvuiConfig") 
end

function ElvuiConfig:Load()
	self:LoadDefaults()

	-- Create savedvariables
	self.db = LibStub("AceDB-3.0"):New("ElvConfig", defaults)
	self.db.RegisterCallback(self, "OnProfileChanged", "OnProfileChanged")
	self.db.RegisterCallback(self, "OnProfileCopied", "OnProfileChanged")
	self.db.RegisterCallback(self, "OnProfileReset", "OnProfileChanged")
	db = self.db.profile
	
	self:SetupOptions()
end

function ElvuiConfig:OnProfileChanged(event, database, newProfileKey)
	StaticPopup_Show("CFG_RELOAD")
end


function ElvuiConfig:SetupOptions()
	AC:RegisterOptionsTable("ElvuiConfig", self.GenerateOptions)
	ACD:SetDefaultSize("ElvuiConfig", DEFAULT_WIDTH, DEFAULT_HEIGHT)

	--Create Profiles Table
	self.profile = LibStub("AceDBOptions-3.0"):GetOptionsTable(self.db);
	AC:RegisterOptionsTable("ElvProfiles", self.profile)
	self.profile.order = -10
	
	self.SetupOptions = nil
end

function ElvuiConfig.GenerateOptions()
	if ElvuiConfig.noconfig then assert(false, ElvuiConfig.noconfig) end
	if not ElvuiConfig.Options then
		ElvuiConfig.GenerateOptionsInternal()
		ElvuiConfig.GenerateOptionsInternal = nil
	end
	return ElvuiConfig.Options
end

function ElvuiConfig.GenerateOptionsInternal()
	local E, C, _, DB = unpack(ElvUI)

	StaticPopupDialogs["CFG_RELOAD"] = {
		text = L["CFG_RELOAD"],
		button1 = ACCEPT,
		button2 = CANCEL,
		OnAccept = function() ReloadUI() end,
		timeout = 0,
		whileDead = 1,
	}
	
	if C["general"].upperpanel == true and C["general"].lowerpanel == true then
		L["DATATEXT_POS"] = L["DATATEXT_POS3"]	
	elseif C["general"].upperpanel == true and C["general"].lowerpanel ~= true then
		L["DATATEXT_POS"] = L["DATATEXT_POS2"]
	elseif C["general"].lowerpanel == true and C["general"].upperpanel ~= true then
		L["DATATEXT_POS"] = L["DATATEXT_POS4"]		
	end
	
	ElvuiConfig.Options = {
		type = "group",
		name = "ElvUI",
		args = {
			ElvUI_Header = {
				order = 1,
				type = "header",
				name = L["Version"]..format(": |cffFFFFFF%s|r",E.version),
				width = "full",		
			},
			LoginMessage = {
				order = 2,
				type = "toggle",
				name = L["Login Message"],
				desc = L["Display login message"],
				get = function(info) return db.general.loginmessage end,
				set = function(info, value) db.general.loginmessage = value; end,
			},
			ToggleAnchors = {
				order = 3,
				type = "execute",
				name = L["Toggle Anchors"],
				desc = L["Unlock various elements of the UI to be repositioned."],
				func = function() 
					E.ToggleMovers()
					E.ToggleElements()
					
					if ElvUF or oUF then
						E.MoveUF()
					end				
				end,
			},
			InstallUI = {
				order = 4,
				type = "execute",
				name = L["Install"],
				desc = L["Re-run the installation process"],
				func = function() E.Install(); ElvuiConfig:ShowConfig(); GameTooltip:Hide() end,
			},
			general = {
				order = 5,
				type = "group",
				name = L["General"],
				desc = L["General"],
				get = function(info) return db.general[ info[#info] ] end,
				set = function(info, value) db.general[ info[#info] ] = value; StaticPopup_Show("CFG_RELOAD") end,
				args = {
					intro = {
						order = 1,
						type = "description",
						name = L["ELVUI_DESC"],
					},
					autoscale = {
						order = 2,
						name = L["Auto Scale"],
						desc = L["Automatically scale the User Interface based on your screen resolution"],
						type = "toggle",
					},					
					uiscale = {
						order = 3,
						name = L["Scale"],
						desc = L["Controls the scaling of the entire User Interface"],
						disabled = function(info) return db.general.autoscale end,
						type = "range",
						min = 0.64, max = 1, step = 0.01,
						isPercent = true,
					},
					multisampleprotect = {
						order = 4,
						name = L["Multisample Protection"],
						desc = L["Force the Blizzard Multisample Option to be set to 1x. WARNING: Turning this off will lead to blurry borders"],
						type = "toggle",
					},
					fontscale = {
						order = 5,
						name = L["Font Scale"],
						desc = L["Set the font scale for everything in UI. Note: This doesn't effect somethings that have their own seperate options (UnitFrame Font, Datatext Font, ect..)"],
						type = "range",
						min = 8, max = 22, step = 1,
					},
					resolutionoverride = {
						order = 6,
						name = L["Resolution Override"],
						desc = L["Set a resolution version to use. By default any screensize > 1440 is considered a High resolution. This effects actionbar/unitframe layouts. If set to None, then it will be automatically determined by your screen size"],
						type = "select",
						values = {
							["NONE"] = L["None"],
							["Low"] = L["Low"],
							["High"] = L["High"],
						},
					},
					pixelPerfect = {
						order = 7,
						type = "toggle",
						name = L['Pixel Perfect'],
						desc = L['The Pixel Perfect option will change the overall apperance of your UI. Using Pixel Perfect is a slight performance increase over the traditional layout.'],
					},
					upperpanel = {
						order = 8,
						type = "toggle",
						name = L["Upper Frame"],
						desc = L["Enable a bar accross the top of the screen, doing this will move the location and coords texts to that bar, and also allow for spaces nine and ten of the datatexts to be used."],
					},
					lowerpanel = {
						order = 9,
						type = "toggle",
						name = L["Lower Frame"],
						desc = L["Enable a bar accross the bottom of the screen, doing this will allow for four extra datatext positions."],					
					},
				},
			},
			media = {
				order = 7,
				type = "group",
				name = L["Media"],
				desc = L["MEDIA_DESC"],
				get = function(info) return db.media[ info[#info] ] end,
				set = function(info, value) db.media[ info[#info] ] = value; StaticPopup_Show("CFG_RELOAD") end,
				args = {
					intro = {
						order = 1,
						type = "description",
						name = L["MEDIA_DESC"],
					},
					Fonts = {
						type = "group",
						order = 2,
						name = L["Fonts"],
						guiInline = true,
						args = {
							font = {
								type = "select", dialogControl = 'LSM30_Font',
								order = 1,
								name = L["Font"],
								desc = L["The font that the core of the UI will use"],
								values = AceGUIWidgetLSMlists.font,
							},
							dmgfont = {
								type = "select", dialogControl = 'LSM30_Font',
								order = 3,
								name = L["Combat Text Font"],
								desc = L["The font that combat text will use. WARNING: This requires a game restart after changing this option."],
								values = AceGUIWidgetLSMlists.font,						
							},					
						},
					},
					Textures = {
						type = "group",
						order = 3,
						name = L["Textures"],
						guiInline = true,
						args = {
							normTex = {
								type = "select", dialogControl = 'LSM30_Statusbar',
								order = 1,
								name = L["StatusBar Texture"],
								desc = L["Texture that gets used on all StatusBars"],
								values = AceGUIWidgetLSMlists.statusbar,								
							},
							glossTex = {
								type = "select", dialogControl = 'LSM30_Statusbar',
								order = 2,
								name = L["Gloss Texture"],
								desc = L["This gets used by some objects, unless gloss mode is on."],
								values = AceGUIWidgetLSMlists.statusbar,								
							},
							blank = {
								type = "select", dialogControl = 'LSM30_Background',
								order = 4,
								name = L["Backdrop Texture"],
								desc = L["Used on almost all frames"],
								values = AceGUIWidgetLSMlists.background,							
							},
						},
					},
					GenColors = {
						type = "group",
						order = 5,
						name = L["Colors"],
						guiInline = true,
						args = {
							bordercolor = {
								type = "color",
								order = 1,
								name = L["Border Color"],
								desc = L["Main Frame's Border Color"],
								hasAlpha = false,
								get = function(info)
									local t = db.media[ info[#info] ]
									return t.r, t.g, t.b, t.a
								end,
								set = function(info, r, g, b)
									db.media[ info[#info] ] = {}
									local t = db.media[ info[#info] ]
									t.r, t.g, t.b = r, g, b
									StaticPopup_Show("CFG_RELOAD")
								end,					
							},
							backdropcolor = {
								type = "color",
								order = 2,
								name = L["Backdrop Color"],
								desc = L["Main Frame's Backdrop Color"],
								hasAlpha = false,
								get = function(info)
									local t = db.media[ info[#info] ]
									return t.r, t.g, t.b, t.a
								end,
								set = function(info, r, g, b)
									db.media[ info[#info] ] = {}
									local t = db.media[ info[#info] ]
									t.r, t.g, t.b = r, g, b
									StaticPopup_Show("CFG_RELOAD")
								end,						
							},
							backdropfadecolor = {
								type = "color",
								order = 3,
								name = L["Backdrop Fade Color"],
								desc = L["Faded backdrop color of some frames"],
								hasAlpha = true,
								get = function(info)
									local t = db.media[ info[#info] ]
									return t.r, t.g, t.b, t.a
								end,
								set = function(info, r, g, b, a)
									db.media[ info[#info] ] = {}
									local t = db.media[ info[#info] ]	
									t.r, t.g, t.b, t.a = r, g, b, a
									StaticPopup_Show("CFG_RELOAD")
								end,						
							},
							valuecolor = {
								type = "color",
								order = 4,
								name = L["Value Color"],
								desc = L["Value color of various text/frame objects"],
								hasAlpha = false,
								get = function(info)
									local t = db.media[ info[#info] ]
									return t.r, t.g, t.b, t.a
								end,
								set = function(info, r, g, b)
									db.media[ info[#info] ] = {}
									local t = db.media[ info[#info] ]
									t.r, t.g, t.b = r, g, b
									StaticPopup_Show("CFG_RELOAD")
								end,						
							},
						},
					},	
				},
			},
			nameplate = {
				order = 8,
				type = "group",
				name = L["Nameplates"],
				desc = L["NAMEPLATE_DESC"],
				get = function(info) return db.nameplate[ info[#info] ] end,
				set = function(info, value) db.nameplate[ info[#info] ] = value; StaticPopup_Show("CFG_RELOAD") end,
				args = {
					intro = {
						order = 1,
						type = "description",
						name = L["NAMEPLATE_DESC"],
					},				
					enable = {
						type = "toggle",
						order = 2,
						name = ENABLE,
						desc = L["Enable/Disable Nameplates"],
						set = function(info, value)
							db.nameplate[ info[#info] ] = value; 
							StaticPopup_Show("CFG_RELOAD")
						end,
					},
					Nameplates = {
						type = "group",
						order = 3,
						name = L["Nameplate Options"],
						guiInline = true,		
						disabled = function() return not db.nameplate.enable end,
						args = {
							font = {
								type = "select", dialogControl = 'LSM30_Font',
								order = 1,
								name = L["Font"],
								values = AceGUIWidgetLSMlists.font,
							},
							fontsize = {
								type = "range",
								order = 2,
								name = L["Font Scale"],
								desc = L["Controls the size of the unitframe font"],
								type = "range",
								min = 8, max = 22, step = 1,							
							},
							fontoutline = {
								order = 3,
								name = L["Font Outline"],
								desc = L["Set the font outline."],
								type = "select",
								values = {
									['NONE'] = 'None',
									['OUTLINE'] = 'OUTLINE',
									['MONOCHROME'] = 'MONOCHROME',
									['MONOCHROMEOUTLINE'] = 'MONOCROMEOUTLINE',
									['THICKOUTLINE'] = 'THICKOUTLINE',
								},
								set = function(info, value) db.nameplate[ info[#info] ] = value; StaticPopup_Show("CFG_RELOAD") end,
							},
							showhealth = {
								type = "toggle",
								order = 4,
								name = L["Show Health"],
								desc = L["Display health values on nameplates, this will also increase the size of the nameplate"],
							},
							enhancethreat = {
								type = "toggle",
								order = 5,
								name = L["Health Threat Coloring"],
								desc = L["Color the nameplate's healthbar by your current threat, Example: good threat color is used if your a tank when you have threat, opposite for DPS."],
							},
							combat = {
								type = "toggle",
								order = 6,
								name = L["Toggle Combat"],
								desc = L["Toggles the nameplates off when not in combat."],							
							},
							trackauras = {
								type = "toggle",
								order = 7,
								name = L["Track Auras"],
								desc = L["Tracks your debuffs on nameplates."],									
							},
							trackccauras = {
								type = "toggle",
								order = 8,
								name = L["Track CC Debuffs"],
								desc = L["Tracks CC debuffs on nameplates from you or a friendly player"],										
							},
							Colors = {
								type = "group",
								order = 9,
								name = L["Colors"],
								guiInline = true,	
								get = function(info)
									local t = db.nameplate[ info[#info] ]
									return t.r, t.g, t.b, t.a
								end,
								set = function(info, r, g, b)
									db.nameplate[ info[#info] ] = {}
									local t = db.nameplate[ info[#info] ]
									t.r, t.g, t.b = r, g, b
									StaticPopup_Show("CFG_RELOAD")
								end,	
								disabled = function() return (not db.nameplate.enhancethreat or not db.nameplate.enable) end,								
								args = {
									goodcolor = {
										type = "color",
										order = 1,
										name = L["Good Color"],
										desc = L["This is displayed when you have threat as a tank, if you don't have threat it is displayed as a DPS/Healer"],
										hasAlpha = false,
									},		
									badcolor = {
										type = "color",
										order = 2,
										name = L["Bad Color"],
										desc = L["This is displayed when you don't have threat as a tank, if you do have threat it is displayed as a DPS/Healer"],
										hasAlpha = false,
									},
									transitioncolor = {
										type = "color",
										order = 3,
										name = L["Transition Color"],
										desc = L["This color is displayed when gaining/losing threat"],
										hasAlpha = false,									
									},
								},
							},
						},
					},
				},
			},
			unitframes = {
				order = 9,
				type = "group",
				name = L["Unit Frames"],
				desc = L["UF_DESC"],
				childGroups = "tree",
				get = function(info) return db.unitframes[ info[#info] ] end,
				set = function(info, value) db.unitframes[ info[#info] ] = value; StaticPopup_Show("CFG_RELOAD") end,
				args = {
					intro = {
						order = 1,
						type = "description",
						name = L["UF_DESC"],
					},								
					enable = {
						order = 2,
						type = "toggle",
						name = ENABLE,
						desc = L["Enable Unitframes"],
					},
					UFGroup = {
						order = 3,
						type = "group",
						name = L["General Settings"],
						disabled = function() return not db.unitframes.enable end,	
						args = {
							font = {
								type = "select", dialogControl = 'LSM30_Font',
								order = 1,
								name = L["Font"],
								values = AceGUIWidgetLSMlists.font,
							},
							fontsize = {
								type = "range",
								order = 1,
								name = L["Font Scale"],
								desc = L["Controls the size of the unitframe font"],
								type = "range",
								min = 8, max = 22, step = 1,							
							},
							fontoutline = {
								order = 2,
								name = L["Font Outline"],
								desc = L["Set the font outline."],
								type = "select",
								values = {
									['NONE'] = 'None',
									['OUTLINE'] = 'OUTLINE',
									['MONOCHROME'] = 'MONOCHROME',
									['MONOCHROMEOUTLINE'] = 'MONOCROMEOUTLINE',
									['THICKOUTLINE'] = 'THICKOUTLINE',
								},
								set = function(info, value) db.unitframes[ info[#info] ] = value; StaticPopup_Show("CFG_RELOAD") end,
							},	
							lowThreshold = {
								type = "range",
								order = 3,
								name = L["Low Mana Threshold"],
								desc = L["Point to warn about low mana"],
								type = "range",
								min = 1, max = 99, step = 1,							
							},
							targetpowerplayeronly = {
								type = "toggle",
								order = 4,
								name = L["Target Power on Player Only"],
								desc = L["Only display power values on player units"] ,
							},
							showfocustarget = {
								type = "toggle",
								order = 5,
								name = L["Focus's Target"],
								desc = L["Display the focus unit's target"],							
							},
							pettarget = {
								type = "toggle",
								order = 6,
								name = L["Pet's Target"],
								desc = L["Display the pet unit's target"],
								disabled = function() return not db.unitframes.enable end,	
							},
							showtotalhpmp = {
								type = "toggle",
								order = 7,
								name = L["Total HP/MP"],
								desc = L["Display the total HP/MP on all available units"],								
							},
							showsmooth = {
								type = "toggle",
								order = 8,
								name = L["Smooth Bars"],
								desc = L["Smoothly transition statusbars when values change"],									
							},
							charportrait = {
								type = "toggle",
								order = 9,
								name = L["Character Portrait"],
								desc = L["Display character portrait on available frames"],								
							},
							charportraithealth = {
								type = "toggle",
								order = 10,
								name = L["Character Portrait on Health"],
								desc = L["Overlay character portrait on the healthbar available frames"],
								disabled = function() return (not db.unitframes.enable or not db.unitframes.charportrait) end,
							},
							classcolor = {
								type = "toggle",
								order = 11,
								name = L["Class Colored Healthbars"],
								desc = L["Color unitframes by class"],						
							},
							classcolorpower = {
								type = "toggle",
								order = 12,
								name = L["Class Colored Powerbars"],
								desc = L["Color powerbars by class"],						
							},
							classcolorbackdrop = {
								type = "toggle",
								order = 13,
								name = L["Class Colored Backdrop"],
								desc = L["Color backdrops by class"],
								disabled = function() return (not db.unitframes.enable or db.unitframes.healthbackdrop) end,
							},
							healthcolor = {
								type = "color",
								order = 14,
								name = L["Health Color"],
								desc = L["Color of the healthbar"],
								hasAlpha = false,
								disabled = function() return (not db.unitframes.enable or db.unitframes.classcolor) end,
								get = function(info)
									local t = db.unitframes[ info[#info] ]
									return t.r, t.g, t.b, t.a
								end,
								set = function(info, r, g, b)
									db.unitframes[ info[#info] ] = {}
									local t = db.unitframes[ info[#info] ]
									t.r, t.g, t.b = r, g, b
									StaticPopup_Show("CFG_RELOAD")
								end,								
							},
							healthcolorbyvalue = {
								type = "toggle",
								order = 15,
								name = L["Color Health by Value"],
								desc = L["Color the health frame by current ammount of hp remaining"],							
							},
							healthbackdrop = {
								type = "toggle",
								order = 16,
								name = L["Custom Backdrop Color"],
								desc = L["Enable using the custom backdrop color, otherwise 20% of the current health color gets used"],
							},
							healthbackdropcolor = {
								type = "color",
								order = 17,
								name = L["Health Backdrop Color"],
								desc = L["Color of the healthbar's backdrop"],
								hasAlpha = false,
								disabled = function() return (not db.unitframes.enable or not db.unitframes.healthbackdrop) end,
								get = function(info)
									local t = db.unitframes[ info[#info] ]
									return t.r, t.g, t.b, t.a
								end,
								set = function(info, r, g, b)
									db.unitframes[ info[#info] ] = {}
									local t = db.unitframes[ info[#info] ]
									t.r, t.g, t.b = r, g, b
									StaticPopup_Show("CFG_RELOAD")
								end,									
							},
							combatfeedback = {
								type = "toggle",
								order = 18,
								name = L["Combat Feedback"],
								desc = L["Enable displaying incoming damage/healing on player/target frame"],							
							},
							debuffhighlight = {
								type = "toggle",
								order = 19,
								name = L["Debuff Highlighting"],
								desc = L["Enable highlighting unitframes when there is a debuff you can dispel"],							
							},
							classbar = {
								type = "toggle",
								order = 20,
								name = L["ClassBar"],
								desc = L["Display class specific bar (runebar/totembar/holypowerbar/soulshardbar/eclipsebar)"],							
							},
							combat = {
								type = "toggle",
								order = 21,
								name = L["Combat Fade"],
								desc = L["Fade main unitframes out when not in combat, unless you cast or mouseover the frame"],								
							},
							mini_powerbar = {
								type = "toggle",
								order = 22,
								name = L["Mini-Powerbar Theme"],
								desc = L["Style the unitframes with a smaller powerbar"],		
								disabled = function() return not db.unitframes.enable or db.unitframes.powerbar_offset ~= 0 end,	
							},
							mini_classbar = {
								type = "toggle",
								order = 23,
								name = L["Mini-Classbar Theme"],
								desc = L["Make classbars smaller and restyle them"],
							},
							arena = {
								type = "toggle",
								order = 24,
								name = L["Arena Frames"],							
							},
							showboss = {
								type = "toggle",
								order = 25,
								name = L["Boss Frames"],							
							},
							displayaggro = {
								type = "toggle",
								order = 27,
								name = L["Display Aggro"],
								desc = L["Enable red glow around the player frame when you have aggro"],
							},
							powerbar_offset = {
								type = "range",
								order = 28,
								name = L["Powerbar Offset"],
								desc = L["Detach and offset the power bar on the main unitframes"],
								min = 0, max = 22, step = 1,	
							},
							powerbar_height = {
								type = "range",
								order = 29,
								name = L["Powerbar Height"],
								desc = L["Set the height of the powerbar, this is void if you don't have powerbar offset set to zero."],
								min = 5, max = 25, step = 1,								
							},
							classbar_height = {
								type = "range",
								order = 30,
								name = L["Classbar Height"],
								desc = L["Set the height of the classbar."],
								min = 5, max = 25, step = 1,								
							},
							unitname = {
								type = "toggle",
								order = 31,
								name = L["Player Name"],
								desc = L["Enable Player Name"],
							},
							namefontsize = {
								type = "range",
								order = 32,
								name = L["Player Name Size"],
								min = 8, max = 32, step = 1,
								disabled = function() return not db.unitframes.unitname end,									
							},
						},
					},
					UFSizeGroup = {
						order = 4,
						type = "group",
						name = L["Frame Sizes"],
						disabled = function() return not db.unitframes.enable end,	
						args = {
							playtarwidth = {
								type = "range",
								order = 1,
								name = L["Player/Target Width"],
								desc = L["Controls the size of the frame"],
								type = "range",
								min = 185, max = 320, step = 1,								
							},
							playtarheight = {
								type = "range",
								order = 2,
								name = L["Player/Target Height"],
								desc = L["Controls the size of the frame"],
								type = "range",
								min = 35, max = 150, step = 1,								
							},
							smallwidth = {
								type = "range",
								order = 3,
								name = L["TargetTarget, Focus, FocusTarget, Pet Width"],
								desc = L["Controls the size of the frame"],
								type = "range",
								min = 80, max = 175, step = 1,								
							},
							smallheight = {
								type = "range",
								order = 4,
								name = L["TargetTarget, Focus, FocusTarget, Pet Height"],
								desc = L["Controls the size of the frame"],
								type = "range",
								min = 18, max = 110, step = 1,								
							},
							arenabosswidth = {
								type = "range",
								order = 5,
								name = L["Arena/Boss Width"],
								desc = L["Controls the size of the frame"],
								type = "range",
								min = 175, max = 275, step = 1,								
							},
							arenabossheight = {
								type = "range",
								order = 6,
								name = L["Arena/Boss Height"],
								desc = L["Controls the size of the frame"],
								type = "range",
								min = 30, max = 110, step = 1,								
							},
							assisttankwidth = {
								type = "range",
								order = 7,
								name = L["Assist/Tank Width"],
								desc = L["Controls the size of the frame"],
								type = "range",
								min = 100, max = 140, step = 1,							
							},
							assisttankheight = {
								type = "range",
								order = 8,
								name = L["Assist/Tank Height"],
								desc = L["Controls the size of the frame"],
								type = "range",
								min = 15, max = 70, step = 1,							
							},
							portaitwidth = {
								type = "range",
								order = 9,
								name = L["Portait Width"],
								desc = L["Controls the size of the frame"],
								type = "range",
								min = 45, max = 280, step = 1,							
							},
							portaitheight = {
								type = "range",
								order = 10,
								name = L["Portait Height"],
								desc = L["Controls the size of the frame"],
								type = "range",
								min = 45, max = 280, step = 1,							
							},								
						},
					},
					UFAurasGroup = {
						order = 5,
						type = "group",
						name = L["Auras"],
						disabled = function() return not db.unitframes.enable end,	
						args = {
							playerbuffs = {
								type = "toggle",
								order = 1,
								name = L["Player Buffs"],
								desc = L["Display auras on frame"],				
							},
							playerdebuffs = {
								type = "toggle",
								order = 2,
								name = L["Player Debuffs"],
								desc = L["Display auras on frame"],				
							},
							targetbuffs = {
								type = "toggle",
								order = 3,
								name = L["Target Buffs"],
								desc = L["Display auras on frame"],								
							},
							targetdebuffs = {
								type = "toggle",
								order = 4,
								name = L["Target Debuffs"],
								desc = L["Display auras on frame"],								
							},
							arenabuffs = {
								type = "toggle",
								order = 5,
								name = L["Arena Buffs"],
								desc = L["Display important buffs on the arena unit, these may be changed in the filter section of the config"],								
							},
							arenadebuffs = {
								type = "toggle",
								order = 6,
								name = L["Arena Debuffs"],
								desc = L["Display important debuffs on the arena unit, these may be changed in the filter section of the config"],								
							},
							bossbuffs = {
								type = "toggle",
								order = 7,
								name = L["Boss Buffs"],
								desc = L["Display auras on frame"],								
							},
							bossdebuffs = {
								type = "toggle",
								order = 8,
								name = L["Boss Debuffs"],
								desc = L["Display auras on frame"],
							},
							totdebuffs = {
								type = "toggle",
								order = 9,
								name = L["TargetTarget Debuffs"],
								desc = L["Display auras on frame"],									
							},
							focusdebuffs = {
								type = "toggle",
								order = 10,
								name = L["Focus Debuffs"],
								desc = L["Display auras on frame"],									
							},
							playerdebuffsonly = {
								type = "toggle",
								order = 11,
								name = L["Player's Debuffs Only"],
								desc = L["Only display debuffs on the target, targettarget, boss, and arena frames that are from yourself"],						
							},
							auratimer = {
								type = "toggle",
								order = 12,
								name = L["Aura Timer"],
								desc = L["Display aura timer"],								
							},
							playeraurasperrow = {
								type = "range",
								order = 13,
								name = L["Player Auras in Row"],
								desc = L["The ammount of auras displayed in a single row"],
								type = "range",
								min = 5, max = 13, step = 1,								
							},
							targetaurasperrow = {
								type = "range",
								order = 13,
								name = L["Target Auras in Row"],
								desc = L["The ammount of auras displayed in a single row"],
								type = "range",
								min = 5, max = 13, step = 1,								
							},							
							smallaurasperrow = {
								type = "range",
								order = 14,
								name = L["Small Frames Auras in Row"],
								desc = L["The ammount of auras displayed in a single row"],
								type = "range",
								min = 3, max = 9, step = 1,								
							},			
							playernumbuffrows = {
								type = "range",
								order = 15,
								name = L["Player Buff Rows"],
								desc = L["Ammount of rows of auras"],
								type = "range",
								min = 1, max = 5, step = 1,									
							},
							playernumdebuffrows = {
								type = "range",
								order = 15,
								name = L["Player Debuff Rows"],
								desc = L["Ammount of rows of auras"],
								type = "range",
								min = 1, max = 5, step = 1,									
							},	
							targetnumbuffrows = {
								type = "range",
								order = 15,
								name = L["Target Buff Rows"],
								desc = L["Ammount of rows of auras"],
								type = "range",
								min = 1, max = 5, step = 1,									
							},
							targetnumdebuffrows = {
								type = "range",
								order = 15,
								name = L["Target Debuff Rows"],
								desc = L["Ammount of rows of auras"],
								type = "range",
								min = 1, max = 5, step = 1,									
							},								
							auratextscale = {
								type = "range",
								order = 19,
								name = L["Aura Text Scale"],
								desc = L["Controls the size of the aura font"],
								type = "range",
								min = 9, max = 15, step = 1,									
							},
						},
					},
					UFCBGroup = {
						order = 6,
						type = "group",
						name = L["Castbar"],
						disabled = function() return (not db.unitframes.enable or not db.unitframes.unitcastbar) end,	
						args = {
							unitcastbar = {
								type = "toggle",
								order = 1,
								name = ENABLE,
								desc = L["Enable/Disable Castbars"],
								disabled = false,
							},
							cblatency = {
								type = "toggle",
								order = 2,
								name = L["Castbar Latency"],
								desc = L["Show latency on player castbar"],							
							},
							cbicons = {
								type = "toggle",
								order = 3,
								name = L["Castbar Icons"],
								desc = L["Show icons on castbars"],								
							},
							cbticks = {
								type = "toggle",
								order = 4,
								name = L["Castbar Ticks"],
								desc = L["Display ticks on castbar when you cast a spell that is channeled, this list may be modified under filters"],
							},
							castplayerwidth = {
								type = "range",
								order = 5,
								name = L["Width Player Castbar"],
								desc = L["The size of the castbar"],
								type = "range",
								min = 160, max = math.ceil(800), step = .01,
							},
							castplayerheight = {
								type = "range",
								order = 6,
								name = L["Height Player Castbar"],
								desc = L["The size of the castbar"],
								type = "range",
								min = 10, max = 50, step = 1,
							},
							casttargetwidth = {
								type = "range",
								order = 7,
								name = L["Width Target Castbar"],
								desc = L["The size of the castbar"],
								type = "range",
								min = 160, max = math.ceil(800), step = .01,							
							},								
							casttargetheight = {
								type = "range",
								order = 8,
								name = L["Height Target Castbar"],
								desc = L["The size of the castbar"],
								type = "range",
								min = 10, max = 50, step = 1,								
							},	
							castfocuswidth = {
								type = "range",
								order = 9,
								name = L["Width Focus Castbar"],
								desc = L["The size of the castbar"],
								type = "range",
								min = 160, max = math.ceil(800), step = .01,						
							},							
							castfocusheight = {
								type = "range",
								order = 10,
								name = L["Height Focus Castbar"],
								desc = L["The size of the castbar"],
								type = "range",
								min = 10, max = 50, step = 1,								
							},								
							castbarcolor = {
								type = "color",
								order = 11,
								name = L["Castbar Color"],
								desc = L["Color of the castbar"],
								hasAlpha = false,
								disabled = function() return (not db.unitframes.enable or db.general.classcolortheme) end,
								get = function(info)
									local t = db.unitframes[ info[#info] ]
									return t.r, t.g, t.b, t.a
								end,
								set = function(info, r, g, b)
									db.unitframes[ info[#info] ] = {}
									local t = db.unitframes[ info[#info] ]
									t.r, t.g, t.b = r, g, b
									StaticPopup_Show("CFG_RELOAD")
								end,								
							},
							nointerruptcolor = {
								type = "color",
								order = 12,
								name = L["Interrupt Color"],
								desc = L["Color of the castbar when you can't interrupt the cast"],
								hasAlpha = false,
								get = function(info)
									local t = db.unitframes[ info[#info] ]
									return t.r, t.g, t.b
								end,
								set = function(info, r, g, b)
									db.unitframes[ info[#info] ] = {}
									local t = db.unitframes[ info[#info] ]
									t.r, t.g, t.b = r, g, b
									StaticPopup_Show("CFG_RELOAD")
								end,									
							},
						},
					},
					PowerColors = {
						type = "group",
						order = 7,
						name = L["Power Colors"],
						get = function(info)
							local t = db.unitframes[ info[#info] ]
							return t.r, t.g, t.b, t.a
						end,
						set = function(info, r, g, b)
							db.unitframes[ info[#info] ] = {}
							local t = db.unitframes[ info[#info] ]
							t.r, t.g, t.b = r, g, b
							StaticPopup_Show("CFG_RELOAD")
						end,								
						args = {
							POWER_MANA = {
								type = "color",
								order = 1,
								name = L["Mana"],
								hasAlpha = false,						
							},
							POWER_RAGE = {
								type = "color",
								order = 2,
								name = L["Rage"],
								hasAlpha = false,							
							},
							POWER_FOCUS = {
								type = "color",
								order = 3,
								name = L["Focus"],
								hasAlpha = false,							
							},
							POWER_ENERGY = {
								type = "color",
								order = 4,
								name = L["Energy"],
								hasAlpha = false,							
							},
							POWER_RUNICPOWER = {
								type = "color",
								order = 6,
								name = L["Runic Power"],
								hasAlpha = false,							
							},
						},
					},
				},
			},
			raidframes = {
				order = 10,
				type = "group",
				name = L["Raid Frames"],
				desc = L["RF_DESC"],
				get = function(info) return db.raidframes[ info[#info] ] end,
				set = function(info, value) db.raidframes[ info[#info] ] = value; StaticPopup_Show("CFG_RELOAD") end,				
				args = {
					intro = {
						order = 1,
						type = "description",
						name = L["RF_DESC"],					
					},
					enable = {
						order = 2,
						type = "toggle",
						name = ENABLE,
						desc = L["Enable Raidframes"],
					},
					RFGroup = {
						order = 3,
						type = "group",
						name = L["General Settings"],
						guiInline = true,
						disabled = function() return not db.raidframes.enable end,	
						args = {
							fontsize = {
								type = "range",
								order = 1,
								name = L["Font Scale"],
								desc = L["Controls the size of the unitframe font"],
								type = "range",
								min = 9, max = 15, step = 1,							
							},
							scale = {
								type = "range",
								order = 2,
								name = L["Scale"],
								type = "range",
								min = 0.64, max = 1.5, step = 0.01,
								isPercent = true,
							},
							showrange = {
								order = 3,
								type = "toggle",
								name = L["Fade with Range"],
								desc = L["Fade the unit out when they become out of range"],
							},
							raidalphaoor = {
								type = "range",
								order = 4,
								name = L["Out of Range Alpha"],
								type = "range",
								min = 0, max = 1, step = 0.01,
								isPercent = true,							
							},
							showsolo = {
								order = 5,
								type = "toggle",
								name = L["Show Solo"],
								desc = L["When true, the header is shown when the player is not in any group."],							
							},
							showplayerinparty = {
								order = 6,
								type = "toggle",
								name = L["Player In Party"],
								desc = L["Show the player frame in the party layout"],							
							},
							griddps = {
								order = 9,
								type = "toggle",
								name = L["DPS GridMode"],
								desc = L["Show the DPS layout in gridmode instead of vertical"],
								disabled = function() return not db.raidframes.enable end,
							},
							displayaggro = {
								type = "toggle",
								order = 10,
								name = L["Display Aggro"],
								desc = L["Change the frame's border to red when a unit has aggro"],
							},
							mini_powerbar = {
								type = "toggle",
								order = 11,
								name = L["Mini-Powerbar Theme"],
								desc = L["Style the unitframes with a smaller powerbar"],
							},						
							raidunitbuffwatch = {
								type = "toggle",
								order = 12,
								name = L["Raid Buff Display"],
								desc = L["Display special buffs on raidframes"],
								disabled = function() return not db.raidframes.enable and not db.unitframes.enable end,
							},
							debuffs = {
								type = "toggle",
								order = 13,
								name = L["Display Debuffs"],
							},
							healthdeficit = {
								order = 14,
								type = "toggle",
								name = L["Health Deficit"],
								desc = L["Display health deficit on the frame"],
							},
							buffindicatorsize = {
								type = "range",
								order = 15,
								name = L["Buff Icon Size"],
								desc = L["Size of the buff icon on raidframes"],
								disabled = function() return not db.raidframes.enable and not db.unitframes.enable end,
								type = "range",
								min = 3, max = 18, step = 1,									
							},
							buffindicatorcoloricons = {
								type = "toggle",
								order = 16,
								name = L["Color Buff Icons"],
								desc = L["If turned off the buff icon on raid/party frames will be displayed as the actual texture of the icon instead of a color icon"],
							},
							powerbar_offset = {
								type = "range",
								order = 17,
								name = L["Powerbar Offset"],
								desc = L["Detach and offset the power bar on the main unitframes"],
								min = 0, max = 12, step = 1,
							},
						},
					},
				},
			},
			classtimer = {
				order = 11,
				type = "group",
				name = L["Class Timers"],
				desc = L["CLASSTIMER_DESC"],
				get = function(info) return db.classtimer[ info[#info] ] end,
				set = function(info, value) db.classtimer[ info[#info] ] = value; StaticPopup_Show("CFG_RELOAD") end,
				args = {
					intro = {
						order = 1,
						type = "description",
						name = L["CLASSTIMER_DESC"],
					},
					enable = {
						order = 2,
						type = "toggle",
						name = ENABLE,
						desc = L["Enable Class Timers"],
					},
					CTGroup = {
						order = 3,
						type = "group",
						name = L["General Settings"],
						guiInline = true,
						disabled = function() return not db.classtimer.enable or (not oUF_ElvUI_player) or not db.unitframes.enable end,	
						args = {
							font = {
								type = "select", dialogControl = 'LSM30_Font',
								order = 1,
								name = L["Font"],
								values = AceGUIWidgetLSMlists.font,
							},
							fontsize = {
								type = "range",
								order = 1,
								name = L["Font Scale"],
								desc = L["Controls the size of the unitframe font"],
								type = "range",
								min = 8, max = 22, step = 1,							
							},
							fontoutline = {
								order = 2,
								name = L["Font Outline"],
								desc = L["Set the font outline."],
								type = "select",
								values = {
									['NONE'] = 'None',
									['OUTLINE'] = 'OUTLINE',
									['MONOCHROME'] = 'MONOCHROME',
									['MONOCHROMEOUTLINE'] = 'MONOCROMEOUTLINE',
									['THICKOUTLINE'] = 'THICKOUTLINE',
								},
								set = function(info, value) db.classtimer[ info[#info] ] = value; StaticPopup_Show("CFG_RELOAD") end,
							},	
							bar_height = {
								type = "range",
								order = 3,
								name = L["Bar Height"],
								desc = L["Controls the height of the bar"],
								type = "range",
								min = 9, max = 25, step = 1,								
							},
							bar_spacing = {
								type = "range",
								order = 4,
								name = L["Bar Spacing"],
								desc = L["Controls the spacing in between bars"],
								type = "range",
								min = 5, max = 10, step = 1,								
							},
							icon_position = {
								type = "range",
								order = 5,
								name = L["Icon Position"],
								desc = L["0 = Left\n1 = Right\n2 = Outside Left\n3 = Outside Right"],
								type = "range",
								min = 0, max = 3, step = 1,								
							},
							layout = {
								type = "range",
								order = 6,
								name = L["Layout"],
								desc = L["LAYOUT_DESC"],
								type = "range",
								min = 1, max = 5, step = 1,								
							},
							showspark = {
								type = "toggle",
								order = 7,
								name = L["Spark"],
								desc = L["Display spark"],
							},
							cast_suparator = {
								type = "toggle",
								order = 8,
								name = L["Cast Seperator"],							
							},
							classcolor = {
								type = "toggle",
								order = 9,
								name = L["Class Color"],								
							},
							ColorGroup = {
								order = 10,
								type = "group",
								name = L["Colors"],
								guiInline = true,
								disabled = function() return not db.classtimer.enable or (not oUF_ElvUI_player) or not db.unitframes.enable or db.classtimer.classcolor end,
								get = function(info)
									local t = db.classtimer[ info[#info] ]
									return t.r, t.g, t.b, t.a
								end,
								set = function(info, r, g, b)
									db.classtimer[ info[#info] ] = {}
									local t = db.classtimer[ info[#info] ]
									t.r, t.g, t.b = r, g, b
									StaticPopup_Show("CFG_RELOAD")
								end,									
								args = {
									buffcolor = {
										type = "color",
										order = 1,
										name = L["Buff"],
										hasAlpha = false,	
									},
									debuffcolor = {
										type = "color",
										order = 2,
										name = L["Debuff"],
										hasAlpha = false,	
									},	
									proccolor = {
										type = "color",
										order = 3,
										name = L["Proc"],
										hasAlpha = false,	
									},											
								},
							},				
						},
					},
				},
			},
			actionbar = {
				order = 12,
				type = "group",
				name = L["Action Bars"],
				desc = L["AB_DESC"],
				childGroups = "tree",
				get = function(info) return db.actionbar[ info[#info] ] end,
				set = function(info, value) db.actionbar[ info[#info] ] = value; StaticPopup_Show("CFG_RELOAD") end,
				args = {
					intro = {
						order = 1,
						type = "description",
						name = L["AB_DESC"],
					},
					enable = {
						order = 2,
						type = "toggle",
						name = ENABLE,
					},
					hotkey = {
						type = "toggle",
						order = 3,
						name = L["Hotkey Text"],
						desc = L["Display hotkey text on action buttons"],
					},
					showgrid = {
						type = "toggle",
						order = 4,
						name = L["Display Grid"],
						desc = L["Display grid backdrop behind empty buttons"],	
					},
					macrotext = {
						type = "toggle",
						order = 5,
						name = L["Macro Text"],						
					},
					fontGroup = {
						order = 6,
						type = 'group',
						guiInline = true,
						name = L['Fonts'],
						args = {
							font = {
								type = "select", dialogControl = 'LSM30_Font',
								order = 2,
								name = L["Font"],
								values = AceGUIWidgetLSMlists.font,
							},
							fontsize = {
								order = 3,
								name = L["Font Scale"],
								type = "range",
								min = 8, max = 22, step = 1,					
							},
							fontoutline = {
								order = 4,
								name = L["Font Outline"],
								desc = L["Set the font outline."],
								type = "select",
								values = {
									['NONE'] = 'None',
									['OUTLINE'] = 'OUTLINE',
									['MONOCHROME'] = 'MONOCHROME',
									['MONOCHROMEOUTLINE'] = 'MONOCROMEOUTLINE',
									['THICKOUTLINE'] = 'THICKOUTLINE',
								},
								set = function(info, value) db.actionbar[ info[#info] ] = value; StaticPopup_Show("CFG_RELOAD") end,
							},
						},
					},	
					MicromenuGroup = {
						order = 7,
						type = "group",
						name = L['Micromenu'],	
						args = {
							microbar = {
								type = "toggle",
								order = 1,
								name = L['Micromenu'],
								desc = L["Display blizzards default microbar, this will disable the right click menu on minimap"],
							},
							mousemicro = {
								type = "toggle",
								order = 2,
								name = L['Micro Bar on Mouseover'],
								desc = L['Display blizzards default microbar when mouseovered'],
							},
						},
					},	
					AB1Group = {
						order = 8,
						type = "group",
						name = L['Bar 1'],	
						args = {
							bar1enable = {
								type = "toggle",
								order = 1,
								name = ENABLE,						
							},
							bar1btnmax = {
								order = 2,
								name = L['Buttons'],
								desc = L['The amount of buttons to display.'],
								type = "range",
								min = 1, max = NUM_ACTIONBAR_BUTTONS, step = 1,
							},
							bar1btnsize = {
								order = 3,
								name = L['Button Size'],
								desc = L['The size of the action buttons.'],
								type = "range",
								min = 15, max = 60, step = 1,
							},
							bar1btnrows = {
								order = 4,
								name = L['Buttons Per Row'],
								desc = L['The amount of buttons to display per row.'],
								type = "range",
								min = 1, max = NUM_ACTIONBAR_BUTTONS, step = 1,
							},
							bar1xspacing = {
								order = 5,
								name = "Horizontal Spacing",
								desc = "The spacing inbetween button columns.",
								type = "range",
								min = 0, max = 100, step = 1,
							},
							bar1yspacing = {
								order = 6,
								name = "Vertical Spacing",
								desc = "The spacing inbetween button rows.",
								type = "range",
								min = 0, max = 100, step = 1,
							},
						},
					},
					AB2Group = {
						order = 9,
						type = "group",
						name = L['Bar 2'],	
						args = {
							bar2enable = {
								type = "toggle",
								order = 1,
								name = ENABLE,						
							},
							bar2btnmax = {
								order = 2,
								name = L['Buttons'],
								desc = L['The amount of buttons to display.'],
								type = "range",
								min = 1, max = NUM_ACTIONBAR_BUTTONS, step = 1,
							},
							bar2btnsize = {
								order = 3,
								name = L['Button Size'],
								desc = L['The size of the action buttons.'],
								type = "range",
								min = 15, max = 60, step = 1,
							},
							bar2btnrows = {
								order = 4,
								name = L['Buttons Per Row'],
								desc = L['The amount of buttons to display per row.'],
								type = "range",
								min = 1, max = NUM_ACTIONBAR_BUTTONS, step = 1,
							},
							bar2xspacing = {
								order = 5,
								name = "Horizontal Spacing",
								desc = "The spacing inbetween button columns.",
								type = "range",
								min = 0, max = 100, step = 1,
							},
							bar2yspacing = {
								order = 6,
								name = "Vertical Spacing",
								desc = "The spacing inbetween button rows.",
								type = "range",
								min = 0, max = 100, step = 1,
							},
						},
					},
					AB3Group = {
						order = 10,
						type = "group",
						name = L['Bar 3'],	
						args = {
							bar3enable = {
								type = "toggle",
								order = 1,
								name = ENABLE,						
							},
							bar3btnmax = {
								order = 2,
								name = L['Buttons'],
								desc = L['The amount of buttons to display.'],
								type = "range",
								min = 1, max = NUM_ACTIONBAR_BUTTONS, step = 1,
							},
							bar3btnsize = {
								order = 3,
								name = L['Button Size'],
								desc = L['The size of the action buttons.'],
								type = "range",
								min = 15, max = 60, step = 1,
							},
							bar3btnrows = {
								order = 4,
								name = L['Buttons Per Row'],
								desc = L['The amount of buttons to display per row.'],
								type = "range",
								min = 1, max = NUM_ACTIONBAR_BUTTONS, step = 1,
							},
							bar3xspacing = {
								order = 5,
								name = "Horizontal Spacing",
								desc = "The spacing inbetween button columns.",
								type = "range",
								min = 0, max = 100, step = 1,
							},
							bar3yspacing = {
								order = 6,
								name = "Vertical Spacing",
								desc = "The spacing inbetween button rows.",
								type = "range",
								min = 0, max = 100, step = 1,
							},
						},
					},
					AB4Group = {
						order = 11,
						type = "group",
						name = L['Bar 4'],	
						args = {
							bar4enable = {
								type = "toggle",
								order = 1,
								name = ENABLE,						
							},
							bar4btnmax = {
								order = 2,
								name = L['Buttons'],
								desc = L['The amount of buttons to display.'],
								type = "range",
								min = 1, max = NUM_ACTIONBAR_BUTTONS, step = 1,
							},
							bar4btnsize = {
								order = 3,
								name = L['Button Size'],
								desc = L['The size of the action buttons.'],
								type = "range",
								min = 15, max = 60, step = 1,
							},
							bar4btnrows = {
								order = 4,
								name = L['Buttons Per Row'],
								desc = L['The amount of buttons to display per row.'],
								type = "range",
								min = 1, max = NUM_ACTIONBAR_BUTTONS, step = 1,
							},
							bar4xspacing = {
								order = 5,
								name = "Horizontal Spacing",
								desc = "The spacing inbetween button columns.",
								type = "range",
								min = 0, max = 100, step = 1,
							},
							bar4yspacing = {
								order = 6,
								name = "Vertical Spacing",
								desc = "The spacing inbetween button rows.",
								type = "range",
								min = 0, max = 100, step = 1,
							},
						},
					},
					AB5Group = {
						order = 12,
						type = "group",
						name = L['Bar 5'],	
						args = {
							bar5enable = {
								type = "toggle",
								order = 1,
								name = ENABLE,						
							},
							bar5btnmax = {
								order = 2,
								name = L['Buttons'],
								desc = L['The amount of buttons to display.'],
								type = "range",
								min = 1, max = NUM_ACTIONBAR_BUTTONS, step = 1,
							},
							bar5btnsize = {
								order = 3,
								name = L['Button Size'],
								desc = L['The size of the action buttons.'],
								type = "range",
								min = 15, max = 60, step = 1,
							},
							bar5btnrows = {
								order = 4,
								name = L['Buttons Per Row'],
								desc = L['The amount of buttons to display per row.'],
								type = "range",
								min = 1, max = NUM_ACTIONBAR_BUTTONS, step = 1,
							},
							bar5xspacing = {
								order = 5,
								name = "Horizontal Spacing",
								desc = "The spacing inbetween button columns.",
								type = "range",
								min = 0, max = 100, step = 1,
							},
							bar5yspacing = {
								order = 6,
								name = "Vertical Spacing",
								desc = "The spacing inbetween button rows.",
								type = "range",
								min = 0, max = 100, step = 1,
							},
						},
					},
					PetGroup = {
						order = 13,
						type = "group",
						name = L['Pet Bar'],	
						args = {
							petbarenable = {
								type = "toggle",
								order = 1,
								name = ENABLE,						
							},
							petbarbtnsize = {
								order = 2,
								name = L['Button Size'],
								desc = L['The size of the action buttons.'],
								type = "range",
								min = 1, max = 200, step = 1,
							},
							petbarbtnrows = {
								order = 3,
								name = L['Buttons Per Row'],
								desc = L['The amount of buttons to display per row.'],
								type = "range",
								min = 1, max = 10, step = 1,
							},
							petbarspacing = {
								order = 4,
								name = L['Button Spacing'],
								desc = L['The spacing between buttons.'],
								type = "range",
								min = 0, max = 100, step = 1,
							},
						},
					},
					ShiftGroup = {
						order = 14,
						type = "group",
						name = L['Bar Shift'],	
						args = {
							hideshapeshift = {
								type = "toggle",
								order = 1,
								name = L['Bar Shift'],								
							},
							verticalstance = {
								type = "toggle",
								order = 2,
								name = L["Vertical Shape Shift"],
								desc = L["Make the shape shift bar grow vertically instead of horizontally"],	
								disabled = function() return not db.actionbar.enable or db.actionbar.hideshapeshift end,							
							},
							shiftbarbtnsize = {
								order = 3,
								name = L['Button Size'],
								desc = L['The size of the action buttons.'],
								type = "range",
								min = 1, max = 60, step = 1,
							},
							shiftbarspacing = {
								order = 4,
								name = L['Button Spacing'],
								desc = L['The spacing between buttons.'],
								type = "range",
								min = 0, max = 40, step = 1,
							},
						},
					},
					CooldownGroup = {
						order = 15,
						type = "group",
						name = L['Cooldown Text'],	
						disabled = function() return not db.actionbar.enablecd end,								
						args = {
							enablecd = {
								type = "toggle",
								order = 1,
								name = ENABLE,
								disabled = false,								
							},
							treshold = {
								type = "range",
								order = 2,
								name = L["Threshold"],
								desc = L["Threshold before turning text red and displaying decimal places"],
								type = "range",
								min = -1, max = 60, step = 1,		
							},
							ColorGroup = {
								order = 3,
								type = "group",
								name = L["Colors"],
								guiInline = true,
								get = function(info)
									local t = db.actionbar[ info[#info] ]
									return t.r, t.g, t.b, t.a
								end,
								set = function(info, r, g, b)
									db.actionbar[ info[#info] ] = {}
									local t = db.actionbar[ info[#info] ]
									t.r, t.g, t.b = r, g, b
									StaticPopup_Show("CFG_RELOAD")
								end,									
								args = {
									expiringcolor = {
										type = "color",
										order = 1,
										name = L["Expiring"],
										desc = L["This gets displayed when your below the threshold"],
										hasAlpha = false,		
									},
									secondscolor = {
										type = "color",
										order = 2,
										name = L["Seconds"],
										hasAlpha = false,												
									},
									minutescolor = {
										type = "color",
										order = 3,
										name = L["Minutes"],
										hasAlpha = false,													
									},
									hourscolor = {
										type = "color",
										order = 4,
										name = L["Hours"],
										hasAlpha = false,												
									},
									dayscolor = {
										type = "color",
										order = 5,
										name = L["Days"],
										hasAlpha = false,													
									},
								},
							},
						},
					},
				},
			},
			datatext = {
				order = 13,
				type = "group",
				name = L["Data Texts"],
				desc = L["DATATEXT_DESC"],
				get = function(info) return db.datatext[ info[#info] ] end,
				set = function(info, value) db.datatext[ info[#info] ] = value; StaticPopup_Show("CFG_RELOAD") end,		
				args = {
					intro = {
						order = 1,
						type = "description",
						name = L["DATATEXT_DESC"],
					},
					font = {
						type = "select", dialogControl = 'LSM30_Font',
						order = 2,
						name = L["Font"],
						values = AceGUIWidgetLSMlists.font,
					},
					fontsize = {
						order = 3,
						name = L["Font Scale"],
						desc = L["Font size for datatexts"],
						type = "range",
						min = 8, max = 22, step = 1,					
					},
					fontoutline = {
						order = 4,
						name = L["Font Outline"],
						desc = L["Set the font outline."],
						type = "select",
						values = {
							['NONE'] = 'None',
							['OUTLINE'] = 'OUTLINE',
							['MONOCHROME'] = 'MONOCHROME',
							['MONOCHROMEOUTLINE'] = 'MONOCROMEOUTLINE',
							['THICKOUTLINE'] = 'THICKOUTLINE',
						},
						set = function(info, value) db.datatext[ info[#info] ] = value; StaticPopup_Show("CFG_RELOAD") end,
					},
					BattleGround = {
						order = 5,
						type = "toggle",
						name = L["BG Text"],
						desc = L["Display special datatexts when inside a battleground"],
					},
					time24 = {
						order = 6,
						type = "toggle",
						name = L["24-Hour Time"],
						desc = L["Display time datatext on a 24 hour time scale"],	
						disabled = function() return db.datatext.wowtime == 0 end,
					},
					localtime = {
						order = 7,
						type = "toggle",
						name = L["Local Time"],
						desc = L["Display local time instead of server time"],	
						disabled = function() return db.datatext.wowtime == 0 end,					
					},					
					classcolor = {
						order = 8,
						type = "toggle",
						name = L["Class Color"],
						desc = L["Color the datatext values based on your class"],
					},
					DataGroup = {
						order = 9,
						type = "group",
						name = L["Text Positions"],
						guiInline = true,
						args = {
							stat1 = {
								order = 1,
								type = "range",
								name = L["Stat #1"],
								desc = L["Display stat based on your role (Avoidance-Tank, AP-Melee, SP/HP-Caster)"]..L["DATATEXT_POS"],
								min = 0, max = 8, step = 1,
							},
							Durability = {
								order = 2,
								type = "range",
								name = L["Durability"],
								desc = L["Display your current durability"]..L["DATATEXT_POS"],
								min = 0, max = 8, step = 1,							
							},
							stat2 = {
								order = 3,
								type = "range",
								name = L["Stat #2"],
								desc = L["Display stat based on your role (Armor-Tank, Crit-Melee, Crit-Caster)"]..L["DATATEXT_POS"],
								min = 0, max = 8, step = 1,							
							},
							System = {
								order = 4,
								type = "range",
								name = L["System"],
								desc = L["Display FPS and Latency"]..L["DATATEXT_POS"],
								min = 0, max = 8, step = 1,								
							},
							Time = {
								order = 5,
								type = "range",
								name = L["Time"],
								desc = L["Display current time"]..L["DATATEXT_POS"],
								min = 0, max = 8, step = 1,									
							},
							Gold = {
								order = 6,
								type = "range",
								name = L["Gold"],
								desc = L["Display current gold"]..L["DATATEXT_POS"],
								min = 0, max = 8, step = 1,								
							},
							guild = {
								order = 7,
								type = "range",
								name = L["Guild"],
								desc = L["Display current online people in guild"]..L["DATATEXT_POS"],
								min = 0, max = 8, step = 1,								
							},
							friends = {
								order = 8,
								type = "range",
								name = L["Friends"],
								desc = L["Display current online friends"]..L["DATATEXT_POS"],
								min = 0, max = 8, step = 1,								
							},
						},
					},
				},
			},
			chat = {
				order = 14,
				type = "group",
				name = L["Chat"],
				desc = L["CHAT_DESC"],
				get = function(info) return db.chat[ info[#info] ] end,
				set = function(info, value) db.chat[ info[#info] ] = value; StaticPopup_Show("CFG_RELOAD") end,		
				args = {
					intro = {
						order = 1,
						type = "description",
						name = L["CHAT_DESC"],
					},
					enable = {
						order = 2,
						type = "toggle",
						name = ENABLE,
					},
					ChatGroup = {
						order = 3,
						type = "group",
						name = L["General Settings"],
						guiInline = true,
						disabled = function() return not db.chat.enable end,	
						args = {
							font = {
								type = "select", dialogControl = 'LSM30_Font',
								order = 1,
								name = L["Font"],
								values = AceGUIWidgetLSMlists.font,
							},
							fontsize = {
								order = 2,
								name = L["Font Scale"],
								desc = L["Font size for datatexts"],
								type = "range",
								min = 8, max = 22, step = 1,					
							},
							fontoutline = {
								order = 3,
								name = L["Font Outline"],
								desc = L["Set the font outline."],
								type = "select",
								values = {
									['NONE'] = 'None',
									['OUTLINE'] = 'OUTLINE',
									['MONOCHROME'] = 'MONOCHROME',
									['MONOCHROMEOUTLINE'] = 'MONOCROMEOUTLINE',
									['THICKOUTLINE'] = 'THICKOUTLINE',
								},
								set = function(info, value) db.chat[ info[#info] ] = value; StaticPopup_Show("CFG_RELOAD") end,
							},
							whispersound = {
								type = "toggle",
								order = 4,
								name = L["Whisper Sound"],
								desc = L["Play a sound when receiving a whisper, this can be set in media section"],
							},
							whisper = {
								type = "select", dialogControl = 'LSM30_Sound',
								order = 1,
								name = L["Whisper Sound"],
								desc = L["Sound that is played when recieving a whisper"],
								values = AceGUIWidgetLSMlists.sound,								
							},
							chatwidth = {
								type = "range",
								order = 6,
								name = L["Chat Width"],
								desc = L["Width of chatframe"],
								min = 200, max = 600, step = 1,
							},
							chatheight = {
								type = "range",
								order = 7,
								name = L["Chat Height"],
								desc = L["Height of chatframe"],
								min = 75, max = 450, step = 1,
							},
							sticky = {
								type = "toggle",
								order = 9,
								name = L["Sticky Editbox"],
								desc = L["When pressing enter to open the chat editbox, display the last known channel"],								
							},
							bubbles = {
								type = "toggle",
								order = 10,
								name = L["Chat Bubbles"],
								desc = L["Skin Blizzard's Chat Bubbles"],							
							},
							chatbar = {
								type = "toggle",
								order = 11,
								name = L["Chat Bar"],
								desc = L["Enable Chat Bar"],							
							},
							panelBackdropNameLeft = {
								order = 100,
								type = 'input',
								width = 'full',
								name = L['Panel Texture (Left)'],
								desc = L['Specify a filename located inside the World of Warcraft directory. Textures folder that you wish to have set as a panel background.\n\nPlease Note:\n-The image size recommended is 256x128\n-You must do a complete game restart after adding a file to the folder.\n-The file type must be tga format.\n\nExample: Interface\\AddOns\\ElvUI\\media\\textures\\copy\n\nOr for most users it would be easier to simply put a tga file into your WoW folder, then type the name of the file here.'],
								set = function(info, value) 
									db.chat[ info[#info] ] = value;
									StaticPopup_Show("CFG_RELOAD")
								end,
							},
							panelBackdropNameRight = {
								order = 101,
								type = 'input',
								width = 'full',
								name = L['Panel Texture (Right)'],
								desc = L['Specify a filename located inside the World of Warcraft directory. Textures folder that you wish to have set as a panel background.\n\nPlease Note:\n-The image size recommended is 256x128\n-You must do a complete game restart after adding a file to the folder.\n-The file type must be tga format.\n\nExample: Interface\\AddOns\\ElvUI\\media\\textures\\copy\n\nOr for most users it would be easier to simply put a tga file into your WoW folder, then type the name of the file here.'],
								set = function(info, value) 
									db.chat[ info[#info] ] = value;
									StaticPopup_Show("CFG_RELOAD")
								end,
							},
						},
					},
				},
			},
			tooltip = {
				order = 15,
				type = "group",
				name = L["Tooltip"],
				desc = L["TT_DESC"],
				get = function(info) return db.tooltip[ info[#info] ] end,
				set = function(info, value) db.tooltip[ info[#info] ] = value; StaticPopup_Show("CFG_RELOAD") end,		
				args = {
					intro = {
						order = 1,
						type = "description",
						name = L["TT_DESC"],
					},
					enable = {
						order = 2,
						type = "toggle",
						name = ENABLE,
					},
					TTGroup = {
						order = 3,
						type = "group",
						name = L["General Settings"],
						guiInline = true,
						disabled = function() return not db.tooltip.enable end,	
						args = {
							hidecombat = {
								order = 1,
								type = "toggle",
								name = L["Hide Combat"],
								desc = L["Hide tooltip when entering combat"],
							},
							hidecombatraid = {
								order = 2,
								type = "toggle",
								name = L["Hide Combat in Raid"],
								desc = L["Hide tooltip when entering combat only inside a raid instance"],	
								disabled = function() return not db.tooltip.enable or not db.tooltip.hidecombat end,
							},
							hidebuttons = {
								order = 3,
								type = "toggle",
								name = L["Hide Buttons"],
								desc = L["Hide tooltip when mousing over action buttons"],								
							},
							hideuf = {
								order = 4,
								type = "toggle",
								name = L["Hide Unit Frames"],
								desc = L["Hide tooltip when mousing over unit frames"],								
							},
							cursor = {
								order = 5,
								type = "toggle",
								name = L["Cursor"],
								desc = L["Tooltip anchored to cursor"],								
							},
							colorreaction = {
								order = 6,
								type = "toggle",
								name = L["Color Reaction"],
								desc = L["Always color border of tooltip by unit reaction"],									
							},
							itemid = {
								order = 7,
								type = "toggle",
								name = L["ItemID"],
								desc = L["Display itemid on item tooltips"],							
							},
							whotargetting = {
								order = 8,
								type = "toggle",
								name = L["Who's Targetting?"],
								desc = L["Display if anyone in your party/raid is targetting the tooltip unit"],								
							},
						},
					},
				},
			},
			skin = {
				order = 16,
				type = "group",
				name = L["Skins"],
				desc = L["SKIN_DESC"],
				get = function(info) return db.skin[ info[#info] ] end,
				set = function(info, value) db.skin[ info[#info] ] = value; StaticPopup_Show("CFG_RELOAD") end,
				args = {
					intro = {
						order = 1,
						type = "description",
						name = L["SKIN_DESC"],
					},
					enable = {
						order = 2,
						type = "toggle",
						name = ENABLE,
						desc = L["Enable/disable skinning of the entire BlizzardUI."]
					},
					BlizzardSkinz = {
						order = 3,
						type = "group",
						name = L["Blizzard Skins"],
						guiInline = true,
						disabled = function() return not db.skin.enable end,	
						args = {
							Achievement_Popup = {
								type = "toggle",
								name = L["Achievement Popup Frames"],
								desc = L["TOGGLESKIN_DESC"],								
							},
							AchievementUI = {
								type = "toggle",
								name = L["Achievement Frame"],
								desc = L["TOGGLESKIN_DESC"],
							},
							Arena = {
								type = "toggle",
								name = L["Arena Frame"],
								desc = L["TOGGLESKIN_DESC"],
							},
							ArenaRegistrar = {
								type = "toggle",
								name = L["ArenaRegistrar Frame"],
								desc = L["TOGGLESKIN_DESC"],
							},
							AuctionhouseUI = {
								type = "toggle",
								name = L["Auction Frame"],
								desc = L["TOGGLESKIN_DESC"],								
							},
							Character = {
								type = "toggle",
								name = L["Character Frame"],
								desc = L["TOGGLESKIN_DESC"],								
							},
							Friends = {
								type = "toggle",
								name = L["Friends"],
								desc = L["TOGGLESKIN_DESC"],								
							},
							Gossip = {
								type = "toggle",
								name = L["Gossip Frame"],
								desc = L["TOGGLESKIN_DESC"],								
							},
							LFD = {
								type = "toggle",
								name = L["LFG Frame"],
								desc = L["TOGGLESKIN_DESC"],								
							},
							MacroUI = {
								type = "toggle",
								name = L["Macro Frame"],
								desc = L["TOGGLESKIN_DESC"],								
							},
							Mail = {
								type = "toggle",
								name = L["Mail Frame"],
								desc = L["TOGGLESKIN_DESC"],								
							},
							Merchant = {
								type = "toggle",
								name = L["Merchant Frame"],
								desc = L["TOGGLESKIN_DESC"],								
							},
							Misc = {
								type = "toggle",
								name = L["Misc Frames"],
								desc = L["TOGGLESKIN_DESC"],								
							},
							PvP = {
								type = "toggle",
								name = L["PvP Frames"],
								desc = L["TOGGLESKIN_DESC"],								
							},
							Quest = {
								type = "toggle",
								name = L["Quest Frames"],
								desc = L["TOGGLESKIN_DESC"],								
							},
							SpellBook = {
								type = "toggle",
								name = L["Spellbook"],
								desc = L["TOGGLESKIN_DESC"],								
							},
							TalentUI = {
								type = "toggle",
								name = L["Talent Frame"],
								desc = L["TOGGLESKIN_DESC"],							
							},
							Taxi = {
								type = "toggle",
								name = L["Taxi Frame"],
								desc = L["TOGGLESKIN_DESC"],								
							},
							TradeSkillUI = {
								type = "toggle",
								name = L["TradeSkill Frame"],
								desc = L["TOGGLESKIN_DESC"],								
							},
						},
					},					
					embedright = {
						order = 4,
						type = "select",
						name = L["Embed Right"],
						desc = L["EMBED_DESC"],
						values = {
							["NONE"] = L["None"],
							["Recount"] = "Recount",
							["Omen"] = "Omen",
						},						
					},
					AddOnSkins = {
						order = 6,
						type = "group",
						name = L["Addon Skins"],
						guiInline = true,
						args = {
							Skada = {
								order = 1,
								type = "toggle",
								name = "Skada",
								desc = L["Enable this skin"],
							},			
							Recount = {
								order = 2,
								type = "toggle",
								name = "Recount",
								desc = L["Enable this skin"],
							},		
							Omen = {
								order = 3,
								type = "toggle",
								name = "Omen",
								desc = L["Enable this skin"],
							},								
							DBM = {
								order = 6,
								type = "toggle",
								name = "DBM",
								desc = L["Enable this skin"],
							},
							Ace3 = {
								order = 11,
								type = "toggle",
								name = "Ace3",
							},
						},
					},
				},
			},
			others = {
				order = 18,
				type = "group",
				name = L["Misc"],
				desc = L["MISC_DESC"],
				childGroups = "tree",
				get = function(info) return db.others[ info[#info] ] end,
				set = function(info, value) db.others[ info[#info] ] = value; StaticPopup_Show("CFG_RELOAD") end,		
				args = {
					intro = {
						order = 1,
						type = "description",
						name = L["MISC_DESC"],
					},
					GenGroup = {
						order = 2,
						type = "group",
						name = L["General"],	
						args = {
							errorenable = {
								type = "toggle",
								order = 2,
								name = L["Hide Error Text"],
								desc = L["Hide annoying red error text on center of screen"],							
							},
							autoacceptinv = {
								type = "toggle",
								order = 3,
								name = L["Auto Accept Invite"],
								desc = L["Automatically accept invite when invited by a friend/guildie"],							
							},
							enablebag = {
								type = "toggle",
								order = 4,
								name = L["All-In-One Bag"],
								desc = L["Enable/Disable the All-In-One Bag, you must disable this if you wish to run another bag addon"],										
							},
							afkcamera = {
								type = "toggle",
								order = 5,
								name = L["AFK Camera"],
								desc = L["Splin Camera AFK"],							
							},
							alertcombat = {
								type = "toggle",
								order = 6,
								name = L["Alert Combat"],						
							},
						},
					},
					LootGroup = {
						order = 3,
						type = "group",
						name = L["Loot"],	
						args = {
							lootframe = {
								type = "toggle",
								order = 1,
								name = L["Loot Frame"],
								desc = L["Skin loot window"],							
							},
							rolllootframe = {
								type = "toggle",
								order = 2,
								name = L["Loot Roll Frame"],
								desc = L["Skin loot roll window"],								
							},
							sellgrays = {
								type = "toggle",
								order = 4,
								name = L["Sell Grays"],
								desc = L["Automatically sell gray items when visiting a vendor"],								
							},
							autorepair = {
								type = "toggle",
								order = 4,
								name = L["Auto Repair"],
								desc = L["Automatically repair when visiting a vendor"],							
							},
						},
					},
					AurasGroup = {
						order = 4,
						type = "group",
						name = L["Combat"],	
						args = {
							raidbuffreminder = {
								type = "toggle",
								order = 3,
								name = L["Raid Buffs Reminder"],
								desc = L["Icons below minimap, displayed inside instances"],								
							},
							announceinterrupt = {
								type = "select",
								order = 4,
								name = L["Interrupt Announce"],
								desc = L["Announce when you interrupt a spell"],
								values = {
									["NONE"] = L["None"],
									["SAY"] = CHAT_MSG_SAY,
									["PARTY"] = PARTY,
									["RAID"] = RAID,
								},
							},
							showthreat = {
								type = "toggle",
								order = 5,
								name = L["Threat Display"],
								desc = L["Display threat in the bottomright panel"],							
							},
							minimapauras = {
								type = "toggle",
								order = 6,
								name = L["Minimap Auras"],
								desc = L["Display blizzard skinned auras by the minimap"],							
							},
							rowbuffs = {
								order = 6,
								name = L["Row Buffs"],
								desc = L["Row Buffs"],
								type = "range",
								min = 9, max = 20, step = 1,					
							},
						},
					},
				},		
			},
		},
	}
	if C["general"].upperpanel == true and C["general"].lowerpanel == true then
		for _, option in pairs(ElvuiConfig.Options.args.datatext.args.DataGroup.args) do
			option.max = 14
		end
	elseif C["general"].upperpanel == true and C["general"].lowerpanel ~= true then
		for _, option in pairs(ElvuiConfig.Options.args.datatext.args.DataGroup.args) do
			option.max = 10
		end
	elseif C["general"].lowerpanel == true and C["general"].upperpanel ~= true then
		for _, option in pairs(ElvuiConfig.Options.args.datatext.args.DataGroup.args) do
			option.max = 12
		end	
	end
	
	ElvuiConfig.Options.args.profiles = ElvuiConfig.profile
end


