﻿---------------------------------------------------------------------------------------------
-- AddOn Name: ElvUI 3.x
-- Author: Bunny
-- Description: ElvUI
-- Credits:
---------------------------------------------------------------------------------------------
local E, C, L, DB = unpack(select(2, ...))

local ElvUI, ns = ...
local oUF = ns.oUF or oUF
assert(oUF, "ElvUI was unable to locate oUF.")

if not( C['raidframes']['enable'] == true ) then return end

local RAID_WIDTH
local RAID_HEIGHT

if( C['raidframes']['griddps'] ~= true ) then
	RAID_WIDTH = E.Scale( 130 )*C['raidframes']['scale']
	RAID_HEIGHT = E.Scale( 28 )*C['raidframes']['scale']
else
	RAID_WIDTH = ( ( ( LeftChatPanel:GetWidth() - ( 3 * 4 ) ) / 5 ) ) * C["raidframes"]['scale']
	RAID_HEIGHT = E.Scale( 40 )*C['raidframes']['scale']
end

local USE_POWERBAR_OFFSET_R = C['raidframes']['powerbar_offset'] ~= 0
local POWERBAR_OFFSET_R = C['raidframes']['powerbar_offset']
local POWERTHEME = C['raidframes']['mini_powerbar']
local SPACING = E.Spacing
local BORDER = E.Border

local function Shared( self, unit )
	local POWERBAR_WIDTH = RAID_WIDTH - ( BORDER * 2 )
	local POWERBAR_HEIGHT = 8
	
	if( C['raidframes']['griddps'] ~= true ) then
		POWERBAR_HEIGHT = 7
	end
	-- Set Colors
	self.colors = E.oUF_colors
	-- Register Frames for Click
	self:RegisterForClicks( 'AnyUp' )
	self:SetScript( 'OnEnter', UnitFrame_OnEnter )
	self:SetScript( 'OnLeave', UnitFrame_OnLeave )
	-- Setup Menu
	self.menu = E.SpawnMenu
	self:SetAttribute( 'type2', 'menu' )
	-- Reid Size
	self:SetAttribute( 'initial-height', RAID_HEIGHT )
	self:SetAttribute( 'initial-width', RAID_WIDTH )
	-- Frame Level
	self:SetFrameLevel( 5 )
	-- Health
	local health = E.ContructHealthBar( self, true, true )
	health:Point( 'TOPRIGHT', self, 'TOPRIGHT', -BORDER, -BORDER )
	if C['raidframes'].griddps ~= true then
		health.value:Point( 'RIGHT', health, 'RIGHT', -2, 0 )
		if USE_POWERBAR_OFFSET_R then
			health:Point( 'TOPRIGHT', self, 'TOPRIGHT', -( BORDER+POWERBAR_OFFSET_R ), -BORDER )
			health:Point( 'BOTTOMLEFT', self, 'BOTTOMLEFT', BORDER, BORDER + POWERBAR_OFFSET_R )
		elseif POWERTHEME == true then
			health:Point( 'BOTTOMLEFT', self, 'BOTTOMLEFT', BORDER, BORDER + ( POWERBAR_HEIGHT / 2 ) )
		else
			health:Point( 'BOTTOMLEFT', self, 'BOTTOMLEFT', BORDER, BORDER + POWERBAR_HEIGHT )
		end
	else
		if USE_POWERBAR_OFFSET_R then
			health:Point( 'TOPRIGHT', self, 'TOPRIGHT', -( BORDER+POWERBAR_OFFSET_R ), -BORDER )
			health:Point( 'BOTTOMLEFT', self, 'BOTTOMLEFT', BORDER, BORDER + POWERBAR_OFFSET_R )
		elseif POWERTHEME == true then
			health:Point( 'BOTTOMLEFT', self, "BOTTOMLEFT", BORDER, BORDER + ( POWERBAR_HEIGHT / 2 ) )
		else
			health:Point( 'BOTTOMLEFT', self, 'BOTTOMLEFT', BORDER, BORDER + POWERBAR_HEIGHT )
		end
		health.value:Point( 'BOTTOM', health, 'BOTTOM', 0, 4 )	
	end
	health.value:SetFont( C['unitframes']['font'], C['raidframes']['fontsize'], C['unitframes']['fontoutline'] )
	
	self.Health = health
	-- Power
	local power = E.ConstructPowerBar( self, true, nil )
	if C["raidframes"]['griddps'] ~= true then
		if USE_POWERBAR_OFFSET_R then
			power:Point( 'TOPRIGHT', health, 'TOPRIGHT', POWERBAR_OFFSET_R, -POWERBAR_OFFSET_R )
			power:Point( 'BOTTOMLEFT', health, 'BOTTOMLEFT', POWERBAR_OFFSET_R, -POWERBAR_OFFSET_R )
			power:SetFrameStrata( 'LOW' )
			power:SetFrameLevel( 2 )
		elseif POWERTHEME == true then
			power:Width( ( POWERBAR_WIDTH / 1.5 ) - BORDER * 2 )
			power:Height( POWERBAR_HEIGHT - BORDER * 2 )
			power:Point( 'RIGHT', self, 'BOTTOMRIGHT', -( BORDER * 2 + 4 ), ( BORDER + ( POWERBAR_HEIGHT / 2 ) ) - 1 )
			power:SetFrameStrata("MEDIUM")
			power:SetFrameLevel(self:GetFrameLevel() + 3)
		else
			power:Point( 'TOPLEFT', health.backdrop, "BOTTOMLEFT", BORDER, - ( E.PixelMode and 0 or ( BORDER + SPACING ) ) )
			power:Point( 'BOTTOMRIGHT', self, "BOTTOMRIGHT", -BORDER, BORDER )
		end
	else
		if USE_POWERBAR_OFFSET_R then
			power:Point( 'TOPRIGHT', health, "TOPRIGHT", POWERBAR_OFFSET_R, -POWERBAR_OFFSET_R )
			power:Point( 'BOTTOMLEFT', health, 'BOTTOMLEFT', POWERBAR_OFFSET_R, -POWERBAR_OFFSET_R )
			power:SetFrameStrata( 'LOW' )
			power:SetFrameLevel( 2 )
		elseif POWERTHEME == true then
			power:Width( ( POWERBAR_WIDTH / 1.3 ) - BORDER * 2 )
			power:Height( POWERBAR_HEIGHT - 1 - BORDER * 2 )
			power:Point( 'CENTER', self, 'BOTTOM', 0, ( BORDER + ( POWERBAR_HEIGHT / 2 ) ) - 1 )
			power:SetFrameStrata( 'MEDIUM' )
			power:SetFrameLevel( self:GetFrameLevel() + 3 )
		else
			power:Point( 'TOPLEFT', health.backdrop, 'BOTTOMLEFT', BORDER, - ( E.PixelMode and 0 or ( BORDER + SPACING ) ) )
			power:Point( 'BOTTOMRIGHT', self, 'BOTTOMRIGHT', -BORDER, BORDER )
		end	
	end
	
	self.Power = power
	-- Name
	self:FontString( 'Name', C['unitframes']['font'], C['unitframes']['fontsize'], C['unitframes']['fontoutline'] )
	if( C["raidframes"].griddps ~= true ) then
		self.Name:Point( 'LEFT', health, "LEFT", 2, 0 )
	else
		self.Name:Point( 'TOP', health, 'TOP', 0, -2 )
	end
	self.Name.frequentUpdates = 0.3
	self:Tag( self.Name, '[ElvUI:getnamecolor][ElvUI:nameshort]' )
	--Leader Icon
	local leader = self:CreateTexture( nil, 'OVERLAY' )
	leader:Size( 14 )
	leader:Point( 'TOPRIGHT', -4, 8 )
	
	self.Leader = leader
	-- LFDRole
    local LFDRole = health:CreateTexture( nil, 'OVERLAY' )
    LFDRole:Size( 17, 17 )
	LFDRole:Point( 'TOPRIGHT', health, 'TOPRIGHT', -2, -2 )
	
	self.LFDRole = LFDRole
	--Master Looter Icon
	local ml = self:CreateTexture( nil, 'OVERLAY' )
	ml:Size( 14 )
	
	self.MasterLooter = ml
	self:RegisterEvent( 'PARTY_LEADER_CHANGED', E.MLAnchorUpdate )
	self:RegisterEvent( 'PARTY_MEMBERS_CHANGED', E.MLAnchorUpdate )
	-- Ready Check
	local ReadyCheck = self.Health:CreateTexture( nil, 'OVERLAY' )
	ReadyCheck:SetHeight( C['raidframes']['fontsize'] )
	ReadyCheck:SetWidth( C['raidframes']['fontsize'] )
	if( C["raidframes"].griddps ~= true ) then
		ReadyCheck:Point( 'LEFT', self.Name, 'RIGHT', 4, 0 )
	else	
		ReadyCheck:Point( 'TOP', self.Name, 'BOTTOM', 0, -2 )
	end
	
	self.ReadyCheck = ReadyCheck
	-- Rais Icons
	local RaidIcon = self:CreateTexture( nil, 'OVERLAY' )
	RaidIcon:Size( 15 * C['raidframes']['scale'], 15 * C["raidframes"]['scale'] )
	if( C['raidframes']['griddps'] ~= true ) then
		RaidIcon:SetPoint( 'LEFT', self.Name, 'RIGHT' )
	else
		RaidIcon:SetPoint( 'CENTER', self, 'TOP' )
	end
	RaidIcon:SetTexture( 'Interface\\AddOns\\ElvUI\\media\\textures\\raidicons.blp' )
	
	self.RaidIcon = RaidIcon
	-- Show Range
	if( C['raidframes']['showrange'] == true ) then
		local range = { 
			insideAlpha = 1, 
			outsideAlpha = C['raidframes']['raidalphaoor']
		}
		
		self.Range = range
	end
	-- Aggro Glow
	if( C['raidframes']['displayaggro'] == true ) then
		table.insert( self.__elements, E.UpdateThreat )
		self:RegisterEvent( 'PLAYER_TARGET_CHANGED', E.UpdateThreat )
		self:RegisterEvent( 'UNIT_THREAT_LIST_UPDATE', E.UpdateThreat )
		self:RegisterEvent( 'UNIT_THREAT_SITUATION_UPDATE', E.UpdateThreat )
	end
	-- Debuff
	if( C['unitframes']['debuffhighlight'] == true ) then
		local dbh = self:CreateTexture( nil, 'OVERLAY' )
		if POWERTHEME == true then
			dbh:SetPoint( 'TOPLEFT' )
			dbh:SetPoint( 'BOTTOMRIGHT', health.backdrop, 'BOTTOMRIGHT' )
		else
			dbh:SetAllPoints()
		end
		dbh:SetTexture( C["media"]['blank'] )
		dbh:SetBlendMode( 'ADD' )
		dbh:SetVertexColor( 0,0,0,0 )
		self.DebuffHighlight = dbh
		self.DebuffHighlightFilter = true
		self.DebuffHighlightAlpha = 0.35
	end
	
	if C['raidframes']['griddps'] ~= true and C['raidframes']['debuffs'] == true then
		local debuffs = CreateFrame( 'Frame', nil, self )
		debuffs:SetPoint( 'LEFT', self, 'RIGHT', E.Scale( 6 ), 0 )
		debuffs:SetHeight( RAID_HEIGHT )
		debuffs:SetWidth( RAID_HEIGHT * 5 )
		debuffs.size = ( RAID_HEIGHT )
		debuffs.num = 5
		debuffs.spacing = 2
		
		debuffs.initialAnchor = 'LEFT'
		debuffs.PostCreateIcon = E.PostCreateAura
		debuffs.PostUpdateIcon = E.PostUpdateAura
		self.Debuffs = debuffs
		-- Debuff Aura Filter
		self.Debuffs.CustomFilter = E.AuraFilter		
	elseif C['raidframes']['debuffs'] == true then
		-- Raid Debuffs (big middle icon)
		local RaidDebuffs = CreateFrame( 'Frame', nil, self )
		RaidDebuffs:Height( RAID_HEIGHT * 0.6 )
		RaidDebuffs:Width( RAID_HEIGHT * 0.6 )
		RaidDebuffs:Point( 'BOTTOM', self, 'BOTTOM', 0, 1 )
		RaidDebuffs:SetFrameLevel( self:GetFrameLevel() + 2 )
		RaidDebuffs:SetFrameStrata( 'MEDIUM' )
		RaidDebuffs:SetFrameLevel( 50 )
		
		RaidDebuffs:SetTemplate( 'Default' )
		
		RaidDebuffs.icon = RaidDebuffs:CreateTexture( nil, 'OVERLAY' )
		RaidDebuffs.icon:SetTexCoord( .1,.9,.1,.9 )
		RaidDebuffs.icon:Point( 'TOPLEFT', 2, -2 )
		RaidDebuffs.icon:Point( 'BOTTOMRIGHT', -2, 2 )
		
		RaidDebuffs.count = RaidDebuffs:CreateFontString( nil, 'OVERLAY' )
		RaidDebuffs.count:SetFont( C['unitframes']['font'], C['unitframes']['fontsize'], C['unitframes']['fontoutline'] )
		RaidDebuffs.count:SetPoint( 'BOTTOMRIGHT', RaidDebuffs, 'BOTTOMRIGHT', 0, 2 )
		RaidDebuffs.count:SetTextColor(1, .9, 0)
		
		RaidDebuffs:FontString( 'time', C['unitframes']['font'], C['unitframes']['fontsize'], C['unitframes']['fontoutline'] )
		RaidDebuffs.time:SetPoint( 'CENTER' )
		RaidDebuffs.time:SetTextColor( 1, .9, 0 )
		
		self.RaidDebuffs = RaidDebuffs
		self.RaidDebuffs.CustomFilter = E.AuraFilter
	end
	-- Raid Unit Buff Watch
	if( C['raidframes']['raidunitbuffwatch'] == true ) then
		E.createAuraWatch( self, unit )
    end
	
	self:HookScript( 'OnEnter', function( self )
		if( not UnitIsConnected( self.unit ) or UnitIsDead( self.unit ) or UnitIsGhost( self.unit ) ) then return end
		local hover = RAID_CLASS_COLORS[select( 2, UnitClass( self.unit ) )]
		self.Health:SetStatusBarColor( hover.r, hover.g, hover.b )
		self.Health.classcolored = true
	end )

	self:HookScript( 'OnLeave', function( self )
		if( not UnitIsConnected( self.unit ) or UnitIsDead( self.unit ) or UnitIsGhost( self.unit ) ) then return end
		local color = E.oUF_colors.health
		self.Health:SetStatusBarColor( color[1], color[2], color[3] )
		self.Health.classcolored = false
	end )
	
	return self
end

oUF:RegisterStyle( 'Raid', Shared )
oUF:Factory( function( self )
	oUF:SetActiveStyle( 'Raid' )	
	local raid
	if C['raidframes'].griddps ~= true then
		raid = self:SpawnHeader( 'Raid', nil, 'solo,raid,party',
		'showSolo', C['raidframes']['showsolo'],
		'showRaid', true, 
		'showParty', true,
		'point', 'LEFT',
		'showPlayer', C['raidframes']['showplayerinparty'],
		'groupFilter', '1,2,3,4,5,6,7,8',
		'groupingOrder', '1,2,3,4,5,6,7,8',
		'groupBy', 'GROUP',
		'maxColumns', 25,
		'unitsPerColumn', 1,
		'columnSpacing', E.PixelMode and 1 or 3,
		'columnAnchorPoint', 'TOP'
		)	
		raid:SetPoint( 'BOTTOMLEFT', LeftChatPanel, 'TOPLEFT', 0, 4 )
	else
		raid = self:SpawnHeader( 'Raid', nil, 'solo,raid,party',
		'showSolo', C['raidframes']['showsolo'],
		'showRaid', true, 
		'showParty', true,
		'showPlayer', C['raidframes']['showplayerinparty'],
		'xoffset', E.PixelMode and 1 or 3,
		'yOffset', E.PixelMode and 1 or -3,
		'point', 'LEFT',
		'groupFilter', '1,2,3,4,5,6,7,8',
		'groupingOrder', '1,2,3,4,5,6,7,8',
		'groupBy', 'GROUP',
		'maxColumns', 8,
		'unitsPerColumn', 5,
		'columnSpacing', E.PixelMode and 1 or 3,
		'columnAnchorPoint', 'TOP'
		)
		raid:Point("BOTTOMLEFT", LeftChatPanel, "TOPLEFT", 0, 4)	
	end
end )

local Group = CreateFrame( 'Frame' )
Group:RegisterEvent( 'PLAYER_ENTERING_WORLD' )
Group:RegisterEvent( 'ZONE_CHANGED_NEW_AREA' )
Group:SetScript( 'OnEvent', function( self )
	local inInstance, instanceType = IsInInstance()
	local _, _, _, _, maxPlayers, _, _ = GetInstanceInfo()

	if( inInstance and instanceType == 'raid' and maxPlayers ~= 40 ) then
		Raid:SetAttribute( 'groupFilter', '1,2,3,4,5' )
	else
		Raid:SetAttribute( 'groupFilter', '1,2,3,4,5,6,7,8' )
	end
end )