local E, C, L, DB = unpack( select( 2, ... ) )

function E.ContructHealthBar( self, bg, text )
	local health = CreateFrame( 'StatusBar', nil, self )
	health:SetStatusBarTexture( C['media']['normTex'] )
	health:SetFrameStrata( 'LOW' )
	health.frequentUpdates = true
	health.PostUpdate = E.PostUpdateHealth
	
	if ( C['unitframes']['showsmooth'] == true ) then
		health.Smooth = true
	end	
	
	if ( bg ) then
		health.bg = health:CreateTexture( nil, 'BORDER' )
		health.bg:SetAllPoints()
		health.bg:SetTexture( C['media']['blank'] )
		
		if ( C['unitframes']['healthbackdrop'] ~= true ) then
			health.bg.multiplier = 0.25
		else
			health.bg:SetTexture( unpack( C['unitframes']['healthbackdropcolor'] ) )
			health.bg.SetVertexColor = E.dummy
		end
	end
	
	if ( text ) then
		health:FontString( 'value', C['unitframes']['font'], C['unitframes']['fontsize'], C['unitframes']['fontoutline'] )
		health.value:SetShadowColor( 0, 0, 0, 0 )
		health.value:SetParent( self )
	end
	
	if ( C['unitframes']['classcolor'] ~= true ) then
		health.colorTapping = true
		
		if ( C['unitframes']['healthcolorbyvalue'] == true ) then
			health.colorSmooth = true
		else
			health.colorHealth = true
		end
	else
		health.colorTapping = true	
		health.colorClass = true
		health.colorReaction = true
	end
	health.colorDisconnected = true
	
	health:CreateBackdrop( 'Default' )
	
	return health
end

E.PostUpdateHealth = function( health, unit, min, max )
	local r, g, b = health:GetStatusBarColor()
	health.defaultColor = {r, g, b}
	
	if ( C['general']['classcolortheme'] == true ) then
		health.backdrop:SetBackdropBorderColor( r, g, b )
		if health:GetParent().Portrait and health:GetParent().Portrait.backdrop then
			health:GetParent().Portrait.backdrop:SetBackdropBorderColor( r, g, b )
		end
	end

	if ( C['unitframes']['classcolor'] == true and C['unitframes']['healthcolorbyvalue'] == true and not ( UnitIsTapped( unit ) and not UnitIsTappedByPlayer( unit ) ) ) then
		local newr, newg, newb = oUF.ColorGradient( min / max, 1, 0, 0, 1, 1, 0, r, g, b )

		health:SetStatusBarColor( newr, newg, newb )
		if health.bg and health.bg.multiplier then
			local mu = health.bg.multiplier
			health.bg:SetVertexColor( newr * mu, newg * mu, newb * mu )
		end
	end

	if ( C['unitframes']['classcolorbackdrop'] == true ) then
		local t
			if UnitIsPlayer( unit ) then
				local _, class = UnitClass( unit )
				t = health:GetParent().colors.class[class]
			elseif UnitReaction( unit, 'player' ) then
				t = health:GetParent().colors.reaction[UnitReaction( unit, 'player' )]
			end
			
		if ( t ) then
			health.bg:SetVertexColor( t[1], t[2], t[3] )
		end
	end
	
	if not health.value then return end
	
	local header = health:GetParent():GetParent():GetName()
	
	if header == 'Raid' then
		if not UnitIsConnected( unit ) or UnitIsDead( unit ) or UnitIsGhost( unit ) then
			if not UnitIsConnected(unit) then
				health.value:SetText( '|cffD7BEA5'..L.unitframes_ouf_offline..'|r' )
			elseif UnitIsDead( unit ) then
				health.value:SetText( '|cffD7BEA5'..L.unitframes_ouf_dead..'|r' )
			elseif UnitIsGhost( unit ) then
				health.value:SetText( '|cffD7BEA5'..L.unitframes_ouf_ghost..'|r' )
			end
		else
			if min ~= max and C['raidframes']['healthdeficit'] == true then
				health.value:SetText( '|cff559655-'..E.ShortValueNegative( max-min )..'|r' )
			else
				health.value:SetText( '' )
			end
		end
	else
		if not UnitIsConnected( unit ) or UnitIsDead( unit ) or UnitIsGhost( unit ) then
			if not UnitIsConnected( unit ) then
				health.value:SetText('|cffD7BEA5'..L.unitframes_ouf_offline..'|r' )
			elseif UnitIsDead( unit ) then
				health.value:SetText( '|cffD7BEA5'..L.unitframes_ouf_dead..'|r' )
			elseif UnitIsGhost( unit ) then
				health.value:SetText( '|cffD7BEA5'..L.unitframes_ouf_ghost..'|r' )
			end
		else
			if min ~= max then
				local r, g, b
				r, g, b = oUF.ColorGradient( min/max, 0.69, 0.31, 0.31, 0.65, 0.63, 0.35, 0.33, 0.59, 0.33 )
				if unit == 'player' and health:GetAttribute( 'normalUnit' ) ~= 'pet' then
					if C['unitframes']['showtotalhpmp'] == true then
						health.value:SetFormattedText( '|cff559655%s|r |cffD7BEA5|||r |cff559655%s|r', E.ShortValue( min ), E.ShortValue( max ) )
					else
						health.value:SetFormattedText( '|cffAF5050%s|r |cffD7BEA5-|r |cff%02x%02x%02x%d%%|r', E.ShortValue( min ), r * 255, g * 255, b * 255, floor( min / max * 100 ) )
					end
				elseif unit == 'target' or unit == 'focus' or (unit and unit:find('boss%d')) then
					if C['unitframes']['showtotalhpmp'] == true then
						health.value:SetFormattedText('|cff559655%s|r |cffD7BEA5|||r |cff559655%s|r', E.ShortValue(min), E.ShortValue( max ) )
					else
						health.value:SetFormattedText( '|cffAF5050%s|r |cffD7BEA5-|r |cff%02x%02x%02x%d%%|r', E.ShortValue( min ), r * 255, g * 255, b * 255, floor( min / max * 100 ) )
					end
				elseif ( unit and unit:find( 'arena%d' ) ) then
					health.value:SetText( '|cff559655'..E.ShortValue( min )..'|r' )
				else
					health.value:SetFormattedText( '|cffAF5050%s|r |cffD7BEA5-|r |cff%02x%02x%02x%d%%|r', E.ShortValue( min ), r * 255, g * 255, b * 255, floor( min / max * 100 ) )
				end
			else
				if unit == 'player' and health:GetAttribute( 'normalUnit' ) ~= 'pet' then
					health.value:SetText( '|cff559655'..E.ShortValue( max )..'|r' )
				elseif unit == 'target' or unit == 'focus' or ( unit and unit:find( 'arena%d' ) ) then
					health.value:SetText( '|cff559655'..E.ShortValue( max )..'|r' )
				else
					health.value:SetText( '|cff559655'..E.ShortValue( max )..'|r' )
				end
			end
		end
	end
end