local E, C, L, DB = unpack(select(2, ...))

if not C["datatext"].stat2 or C["datatext"].stat2 == 0 then return end

local Stat = CreateFrame("Frame")
Stat:EnableMouse(true)
Stat:SetFrameStrata("MEDIUM")
Stat:SetFrameLevel(3)

local Text  = LeftChatDataPanel:CreateFontString(nil, "LOW")
Text:SetFont(C["datatext"].font, C["datatext"].fontsize, C["datatext"].fontoutline)
E.PP(C["datatext"].stat2, Text)

local _G = getfenv(0)
local format = string.format
local chanceString = "%.2f%%"
local armorString = ARMOR..": "
local modifierString = string.join("", "%d (+", chanceString, ")")
local baseArmor, effectiveArmor, armor, posBuff, negBuff
local displayNumberString = string.join("", "%s", E.ValColor, "%d|r")
local displayFloatString = string.join("", "%s", E.ValColor, "%.2f%%|r")

local function CalculateMitigation(level, effective)
	local mitigation
	
	if not effective then
		_, effective, _, _, _ = UnitArmor("player")
	end
	
	if level < 60 then
		mitigation = (effective/(effective + 400 + (85 * level)));
	else
		mitigation = (effective/(effective + (467.5 * level - 22167.5)));
	end
	if mitigation > .75 then
		mitigation = .75
	end
	return mitigation
end

local function AddTooltipHeader(description)
	GameTooltip:AddLine(description)
	GameTooltip:AddLine(' ')
end

local function UpdateTank(self)
	baseArmor, effectiveArmor, armor, posBuff, negBuff = UnitArmor("player");
	
	Text:SetFormattedText(displayNumberString, armorString, effectiveArmor)

	self:SetAllPoints(Text)
end

local function UpdateCaster(self)
	local spellcrit = GetSpellCritChance(2)

	Text:SetFormattedText(displayFloatString, L.datatext_playercrit, spellcrit)

	self:SetAllPoints(Text)
end

local function UpdateMelee(self)
	local meleecrit = GetCritChance()
	local rangedcrit = GetRangedCritChance()
	local critChance
		
	if E.myclass == "HUNTER" then    
		critChance = rangedcrit
	else
		critChance = meleecrit
	end
	
	Text:SetFormattedText(displayFloatString, L.datatext_playercrit, critChance)

	self:SetAllPoints(Text)
end

local int = 5	
local function Update(self, t)
	int = int - t
	if int > 0 then return end
	
	if E.Role == "Tank" then
		UpdateTank(self)
	elseif E.Role == "Caster" then
		UpdateCaster(self)
	elseif E.Role == "Melee" then
		UpdateMelee(self)		
	end
	int = 2
end

Stat:SetScript("OnUpdate", Update)
Update(Stat, 6)