local E, C, L, DB = unpack(select(2, ...))

function E.PP(p, obj)
	local LEFT = LeftChatDataPanel
	local RIGHT = RightChatDataPanel
	local MAPLEFT = LeftMiniPanel
	local MAPRIGHT = RightMiniPanel
	
	if p == 1 then
		obj:SetParent(LEFT)
		obj:SetHeight(LEFT:GetHeight())
		obj:SetPoint("LEFT", LEFT, 5, 0)
		obj:SetPoint('TOP', LEFT)
		obj:SetPoint('BOTTOM', LEFT)
	elseif p == 2 then
		obj:SetParent(LEFT)
		obj:SetHeight(LEFT:GetHeight())
		obj:SetPoint('TOP', LEFT)
		obj:SetPoint('BOTTOM', LEFT)
	elseif p == 3 then
		obj:SetParent(LEFT)
		obj:SetHeight(LEFT:GetHeight())
		obj:SetPoint("RIGHT", LEFT, -5, 0)
		obj:SetPoint('TOP', LEFT)
		obj:SetPoint('BOTTOM', LEFT)
	elseif p == 4 then
		obj:SetParent(RIGHT)
		obj:SetHeight(RIGHT:GetHeight())
		obj:SetPoint("LEFT", RIGHT, 5, 0)
		obj:SetPoint('TOP', RIGHT)
		obj:SetPoint('BOTTOM', RIGHT)
	elseif p == 5 then
		obj:SetParent(RIGHT)
		obj:SetHeight(RIGHT:GetHeight())
		obj:SetPoint('TOP', RIGHT)
		obj:SetPoint('BOTTOM', RIGHT)
	elseif p == 6 then
		obj:SetParent(RIGHT)
		obj:SetHeight(RIGHT:GetHeight())
		obj:SetPoint("RIGHT", RIGHT, -5, 0)
		obj:SetPoint('TOP', RIGHT)
		obj:SetPoint('BOTTOM', RIGHT)
	end
	
	if Minimap then
		if p == 7 then
			obj:SetParent(MAPLEFT)
			obj:SetHeight(MAPLEFT:GetHeight())
			obj:SetPoint('TOP', MAPLEFT)
			obj:SetPoint('BOTTOM', MAPLEFT)
		elseif p == 8 then
			obj:SetParent(MAPRIGHT)
			obj:SetHeight(MAPRIGHT:GetHeight())
			obj:SetPoint('TOP', MAPRIGHT)
			obj:SetPoint('BOTTOM', MAPRIGHT)
		end
	end
end

E.DataTextTooltipAnchor = function(self)
	local panel = self:GetParent()
	local anchor = "ANCHOR_TOP"
	local xoff = 0
	local yoff = ( E.PixelMode and 1 or 3 )
	
	if panel == LeftChatDataPanel then
		anchor = "ANCHOR_TOPLEFT"
		xoff = E.Scale(-16)
	elseif panel == RightChatDataPanel then
		anchor = "ANCHOR_TOPRIGHT"
		xoff = E.Scale(16)
	elseif panel == LeftMiniPanel or panel == RightMiniPanel then
		local position = select(3, MinimapMover:GetPoint())
		if position:match("LEFT") then
			anchor = "ANCHOR_BOTTOMRIGHT"
			yoff = E.Scale(-4)
			xoff = -RightMiniPanel:GetWidth()
			panel = LeftMiniPanel
		elseif position:match("RIGHT") then
			anchor = "ANCHOR_BOTTOMLEFT"
			yoff = E.Scale(-4)
			xoff = RightMiniPanel:GetWidth()
			panel = RightMiniPanel
		else
			anchor = "ANCHOR_BOTTOM"
			yoff = E.Scale(-4)
		end
	elseif ElvuiStat9Block and ElvuiStat10Block and (panel == ElvuiStat9Block or panel == ElvuiStat10Block) then
		anchor = "ANCHOR_BOTTOM"
		yoff = E.Scale(-4)
	end
	
	return anchor, panel, xoff, yoff
end