﻿local E, C, L, DB = unpack(select(2, ...))

if not C['datatext']['BattleGround'] or C['datatext']['BattleGround'] ~= true then return end

local join = string.join
local classColor = RAID_CLASS_COLORS[E.myclass]
local damageDoneString = join('', L.datatext_damage, E.ValColor, '%s')
local honorGainedString = join('', L.datatext_honor, E.ValColor, '%s')
local killingBlowsString = join('', L.datatext_killingblows, E.ValColor, '%d')
local deathsString = join('', L.datatext_ttdeaths, E.ValColor, '%d')
local honorableKillsString = join('', L.datatext_tthonorkills, E.ValColor, '%d')
local healingDoneString = join('', L.datatext_healing, E.ValColor, '%s')

local function ShowBattleGroundStatTooltip(self)
	local numScores = GetNumBattlefieldScores()
	for i=1, numScores do
		name, killingBlows, honorKills, deaths, honorGained, faction, rank, race, class, classToken, damageDone, healingDone  = GetBattlefieldScore(i);
		if name then
			if name == E.myname then
				GameTooltip:SetOwner(self, 'ANCHOR_CURSOR')
				GameTooltip:ClearLines()
				GameTooltip:AddDoubleLine(L.datatext_ttstatsfor, name, 1, 1, 1, classColor.r, classColor.g, classColor.b)
				GameTooltip:AddLine(' ')
				
				if GetRealZoneText() == L.bg_zone_arathibasin then
					GameTooltip:AddDoubleLine(L.datatext_basesassaulted, GetBattlefieldStatData(i, 1), 1, 1, 1)
					GameTooltip:AddDoubleLine(L.datatext_basesdefended, GetBattlefieldStatData(i, 2), 1, 1, 1)
				elseif GetRealZoneText() == L.bg_zone_wg then
					GameTooltip:AddDoubleLine(L.datatext_flagscaptured, GetBattlefieldStatData(i, 1), 1, 1, 1)
					GameTooltip:AddDoubleLine(L.datatext_flagsreturned, GetBattlefieldStatData(i, 2), 1, 1, 1)
				elseif GetRealZoneText() == L.bg_zone_es then
					GameTooltip:AddDoubleLine(L.datatext_flagscaptured, GetBattlefieldStatData(i, 1), 1, 1, 1)
				elseif GetRealZoneText() == L.bg_zone_av then
					GameTooltip:AddDoubleLine(L.datatext_graveyardsassaulted, GetBattlefieldStatData(i, 1), 1, 1, 1)
					GameTooltip:AddDoubleLine(L.datatext_graveyardsdefended, GetBattlefieldStatData(i, 2), 1, 1, 1)
					GameTooltip:AddDoubleLine(L.datatext_towersassaulted, GetBattlefieldStatData(i, 3), 1, 1, 1)
					GameTooltip:AddDoubleLine(L.datatext_towersdefended, GetBattlefieldStatData(i, 4), 1, 1, 1)
				elseif GetRealZoneText() == L.bg_zone_sa then
					GameTooltip:AddDoubleLine(L.datatext_demolishersdestroyed, GetBattlefieldStatData(i, 1), 1, 1, 1)
					GameTooltip:AddDoubleLine(L.datatext_gatesdestroyed, GetBattlefieldStatData(i, 2), 1, 1, 1)
				elseif GetRealZoneText() == L.bg_zone_ic then
					GameTooltip:AddDoubleLine(L.datatext_basesassaulted, GetBattlefieldStatData(i, 1), 1, 1, 1)
					GameTooltip:AddDoubleLine(L.datatext_basesdefended, GetBattlefieldStatData(i, 2), 1, 1, 1)
				end					
				GameTooltip:Show()
			end
		end
	end
end

local BattleFrameLeft = CreateFrame('Frame', 'ElvUIInfoLeftBattleGround', UIParent)
BattleFrameLeft:SetTemplate('Default', true)
BattleFrameLeft:SetAllPoints(LeftChatDataPanel)
BattleFrameLeft:SetFrameStrata('LOW')
BattleFrameLeft:SetFrameLevel(3)
BattleFrameLeft:EnableMouse(true)
local function OnEvent(self, event)
	if event == 'PLAYER_ENTERING_WORLD' then
		inInstance, instanceType = IsInInstance()
		if inInstance and (instanceType == 'pvp') then
			BattleFrameLeft:Show()
			LeftChatDataPanel:EnableMouse(true)
			LeftChatDataPanel:SetScript('OnMouseDown', function(self) ToggleFrame(ElvUIInfoRightBattleGround) ToggleFrame(ElvUIInfoLeftBattleGround) end)
		else
			BattleFrameLeft:Hide()
			LeftChatDataPanel:EnableMouse(false)
			LeftChatDataPanel:SetScript('OnMouseDown', function(self) ToggleFrame(ElvUIInfoRightBattleGround) ToggleFrame(ElvUIInfoLeftBattleGround) end)
		end
	end
end
BattleFrameLeft:SetScript('OnEnter', ShowBattleGroundStatTooltip) 
BattleFrameLeft:SetScript('OnMouseDown', function(self) ToggleFrame(ElvUIInfoRightBattleGround) ToggleFrame(ElvUIInfoLeftBattleGround) end)
BattleFrameLeft:SetScript('OnLeave', function(self) GameTooltip:Hide() end)
BattleFrameLeft:RegisterEvent('PLAYER_ENTERING_WORLD')
BattleFrameLeft:RegisterEvent('ZONE_CHANGED_NEW_AREA')
BattleFrameLeft:SetScript('OnEvent', OnEvent)

local BattleFrameRight = CreateFrame('Frame', 'ElvUIInfoRightBattleGround', UIParent)
BattleFrameRight:SetTemplate('Default', true)
BattleFrameRight:SetAllPoints(RightChatDataPanel)
BattleFrameRight:SetFrameStrata('LOW')
BattleFrameRight:SetFrameLevel(3)
BattleFrameRight:EnableMouse(true)
local function OnEvent(self, event)
	if event == 'PLAYER_ENTERING_WORLD' then
		inInstance, instanceType = IsInInstance()
		if inInstance and (instanceType == 'pvp') then
			BattleFrameRight:Show()
			RightChatDataPanel:EnableMouse(true)
			RightChatDataPanel:SetScript('OnMouseDown', function(self) ToggleFrame(ElvUIInfoRightBattleGround) ToggleFrame(ElvUIInfoLeftBattleGround) end)
		else
			BattleFrameRight:Hide()
			RightChatDataPanel:EnableMouse(false)
			RightChatDataPanel:SetScript('OnMouseDown', function(self) ToggleFrame(ElvUIInfoRightBattleGround) ToggleFrame(ElvUIInfoLeftBattleGround) end)
		end
	end
end
BattleFrameRight:SetScript('OnEnter', ShowBattleGroundStatTooltip) 
BattleFrameRight:SetScript('OnMouseDown', function(self) ToggleFrame(ElvUIInfoRightBattleGround) ToggleFrame(ElvUIInfoLeftBattleGround) end)
BattleFrameRight:SetScript('OnLeave', function(self) GameTooltip:Hide() end)
BattleFrameRight:RegisterEvent('PLAYER_ENTERING_WORLD')
BattleFrameRight:RegisterEvent('ZONE_CHANGED_NEW_AREA')
BattleFrameRight:SetScript('OnEvent', OnEvent)

local Stat = CreateFrame('Frame')
Stat:EnableMouse(true)

local Text1 = ElvUIInfoLeftBattleGround:CreateFontString(nil, 'OVERLAY')
Text1:SetFont(C['datatext']['font'], C['datatext']['fontsize'], C['datatext']['fontoutline'])
Text1:Point('LEFT', ElvUIInfoLeftBattleGround, 5, 0)
Text1:SetHeight(LeftChatDataPanel:GetHeight())

local Text2 = ElvUIInfoLeftBattleGround:CreateFontString(nil, 'OVERLAY')
Text2:SetFont(C['datatext']['font'], C['datatext']['fontsize'], C['datatext']['fontoutline'])
Text2:Point('CENTER', ElvUIInfoLeftBattleGround, 0, 0)
Text2:SetHeight(LeftChatDataPanel:GetHeight())

local Text3 = ElvUIInfoLeftBattleGround:CreateFontString(nil, 'OVERLAY')
Text3:SetFont(C['datatext']['font'], C['datatext']['fontsize'], C['datatext']['fontoutline'])
Text3:Point('RIGHT', ElvUIInfoLeftBattleGround, -5, 0)
Text3:SetHeight(LeftChatDataPanel:GetHeight())

local Text4 = ElvUIInfoLeftBattleGround:CreateFontString(nil, 'OVERLAY')
Text4:SetFont(C['datatext']['font'], C['datatext']['fontsize'], C['datatext']['fontoutline'])
Text4:Point('LEFT', ElvUIInfoRightBattleGround, 5, 0)
Text4:SetHeight(LeftChatDataPanel:GetHeight())

local Text5 = ElvUIInfoLeftBattleGround:CreateFontString(nil, 'OVERLAY')
Text5:SetFont(C['datatext']['font'], C['datatext']['fontsize'], C['datatext']['fontoutline'])
Text5:Point('CENTER', ElvUIInfoRightBattleGround, 0, 0)
Text5:SetHeight(LeftChatDataPanel:GetHeight())

local Text6 = ElvUIInfoLeftBattleGround:CreateFontString(nil, 'OVERLAY')
Text6:SetFont(C['datatext']['font'], C['datatext']['fontsize'], C['datatext']['fontoutline'])
Text6:Point('RIGHT', ElvUIInfoRightBattleGround, -5, 0.5)
Text6:SetHeight(LeftChatDataPanel:GetHeight())

local int = 1
local function Update(self, t)
	int = int - t
	if int < 0 then
		RequestBattlefieldScoreData()
		local numScores = GetNumBattlefieldScores()
		for i=1, numScores do
			name, killingBlows, honorKills, deaths, honorGained, faction, rank, race, class, classToken, damageDone, healingDone  = GetBattlefieldScore(i);
			if name then
				if name == E.myname then
					Text1:SetFormattedText(damageDoneString, damageDone)
					Text2:SetFormattedText(honorGainedString, honorGained)
					Text3:SetFormattedText(killingBlowsString, killingBlows)
					Text4:SetFormattedText(deathsString, deaths)
					Text5:SetFormattedText(honorableKillsString, honorKills)
					Text6:SetFormattedText(healingDoneString, healingDone)
				end   
			end
		end 
		int  = 1
	end
end

local function OnEvent(self, event)
	if event == 'PLAYER_ENTERING_WORLD' then
		inInstance, instanceType = IsInInstance()
		if not inInstance or instanceType == 'none' then
			Text1:SetText('')
			Text2:SetText('')
			Text3:SetText('')
		end
	end
end

Stat:RegisterEvent('PLAYER_ENTERING_WORLD')
Stat:SetScript('OnEvent', OnEvent)
Stat:SetScript('OnUpdate', Update)
Update(Stat, 10)